/*  
	Copyright (C) 2006 Salvatore Scarciglia <laas.mono@gmail.com>
	http://laas.altervista.org

    This code is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This code is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

/*
	This class identify the service Provider; so far, the 
	available providers are:
	--------------------------
	ID | Name
	--------------------------
	 1 | Google
	 2 | BabelFish (Altavista)
	 3 | Systran
	 4 | WorldLingo
	 5 | Babel Fish (Yahoo)
	--------------------------
*/

public class yTProvider {
	private int			_ID;
	private string 		_Name;
	private string		_MainUrl;
	private string		_LangSep;
	private string 		_OpenTag1;
	private string 		_OpenTag2;
	private string 		_CloseTag;
	private string		_AvailableServices;
	
	// Constructor (the only one)
	public yTProvider(int idProvider){
		_ID = idProvider;
		Init();
	}
	
	// Used to change the actual provider
	public void changeProvider(int newProviderID){
		_ID = newProviderID;
		Init();
	}
	
	// Provider Initialization
	private void Init(){
		switch(_ID) {
			case 1: 		// Google
				_Name 		= "Google";
				_MainUrl 	= "http://www.google.com";
				_LangSep 	= "|";
				_OpenTag1 	= "<textarea";
				_OpenTag2 	= "ltr>";
				_CloseTag 	= "</div></td>";
				_AvailableServices =  	"fr|en#fr|de#de|en#de|fr#it|en#pt|en#"+
										"es|en#en|fr#en|de#en|it#en|pt#en|es";
				break;
			case 2:		// BabelFish (Altavista)
				_Name 		= "BabelFish";
				_MainUrl 	= "http://babelfish.altavista.com";
				_LangSep 	= "_";
				_OpenTag1 	= "http://www.altavista.com/web/results";
				_OpenTag2 	= "px;>";
				_CloseTag 	= "</div>";
				_AvailableServices = 	"zh_en#nl_en#nl_fr#fr_en#fr_de#fr_el#"+
										"fr_it#fr_pt#fr_nl#fr_es#de_en#de_fr#"+
										"el_en#el_fr#it_en#it_fr#ja_en#ko_en#"+
										"pt_en#pt_fr#ru_en#es_en#es_fr#en_zh#"+
										"en_nl#en_fr#en_de#en_el#en_it#en_ja#"+
										"en_ko#en_pt#en_ru#en_es";
				break;
			case 3:		// Systran
				_Name 		= "Systran";
				_MainUrl 	= "http://www.systranbox.com";
				_LangSep 	= "_";
				_OpenTag1 	= "translation";
				_OpenTag2 	= "ual\">";
				_CloseTag 	= "</textarea>";
				_AvailableServices = 	"zh_en#nl_en#nl_fr#fr_en#fr_de#fr_el#"+
										"fr_it#fr_pt#fr_nl#fr_es#de_en#de_fr#"+
										"el_en#el_fr#it_en#it_fr#ja_en#ko_en#"+
										"pt_en#pt_fr#ru_en#es_en#es_fr#en_zh#"+
										"en_nl#en_fr#en_de#en_el#en_it#en_ja#"+
										"en_ko#en_pt#en_ru#en_es#sv_en#ar_en#"+
										"en_sv#en_ar";
				break;
			case 4:		// WorldLingo
				_Name 		= "WorldLingo";
				_MainUrl 	= "http://www.WorldLingo.com";
				_LangSep 	= "_";
				_OpenTag1 	= "wl_result";
				_OpenTag2 	= ">";
				_CloseTag 	= "</textarea>";
				_AvailableServices = 	"en_zh#en_nl#en_fr#en_de#en_el#en_it#"+
										"en_ja#en_ko#en_pt#en_ru#en_es#"+
										"zh_en#zh_nl#zh_fr#zh_de#zh_el#zh_it#"+
										"zh_ja#zh_ko#zh_pt#zh_ru#zh_es#"+
										"nl_en#nl_zh#nl_fr#nl_de#nl_el#nl_it#"+
										"nl_ja#nl_ko#nl_pt#nl_ru#nl_es#"+		
										"fr_en#fr_zh#fr_nl#fr_de#fr_el#fr_it#"+
										"fr_ja#fr_ko#fr_pt#fr_ru#fr_es#"+		
										"de_en#de_zh#de_nl#de_fr#de_el#de_it#"+
										"de_ja#de_ko#de_pt#de_ru#de_es#"+	
										"el_en#el_zh#el_nl#el_fr#el_de#el_it#"+
										"el_ja#el_ko#el_pt#el_ru#el_es#"+	
										"it_en#it_zh#it_nl#it_fr#it_de#it_el#"+
										"it_ja#it_ko#it_pt#it_ru#it_es#"+		
										"ja_en#ja_zh#ja_nl#ja_fr#ja_de#ja_el#"+
										"ja_it#ja_ko#ja_pt#ja_ru#ja_es#"+		
										"ko_en#ko_zh#ko_nl#ko_fr#ko_de#ko_el#"+
										"ko_it#ko_ja#ko_pt#ko_ru#ko_es#"+		
										"pt_en#pt_zh#pt_nl#pt_fr#pt_de#pt_el#"+
										"pt_it#pt_ja#pt_ko#pt_ru#pt_es#"+		
										"ru_en#ru_zh#ru_nl#ru_fr#ru_de#ru_el#"+
										"ru_it#ru_ja#ru_ko#ru_pt#ru_es#"+		
										"es_en#es_zh#es_nl#es_fr#es_de#es_el#"+
										"es_it#es_ja#es_ko#es_pt#es_ru";										
				break;		
			case 5:		// BabelFish (Yahoo)
				_Name 		= "BabelFish Yahoo";
				_MainUrl 	= "http://it.search.yahoo.com";
				_LangSep 	= "_";
				_OpenTag1 	= "<textarea name=\"p";
				_OpenTag2 	= "#FFFFCC\">";
				_CloseTag 	= "</textarea>";
				_AvailableServices = 	"zh_en#en_zh#en_nl#en_fr#en_de#en_el#"+
										"en_it#en_ja#en_ko#en_pt#en_ru#en_es#"+
										"nl_en#nl_fr#fr_nl#fr_en#fr_de#fr_el#"+
										"fr_it#fr_pt#fr_es#de_en#de_fr#el_en#"+
										"el_fr#it_en#it_fr#ja_en#ko_en#pt_en#"+
										"pt_fr#ru_en#es_en#es_fr";

				break;						
		}
	}
	
	// Determine if the requested translation is possible
	public bool serviceIsAvailable(string langFrom,string langTo) {
		string srv = langFrom+_LangSep+langTo;
		if(_AvailableServices.IndexOf(srv)==-1)
			return false;
		else
			return true;
	}
	
	
	
	// return the URL of the provider
	public string getUrlTranslator(string langFrom, string langTo, string textToTransalte){
		string resUrl=_MainUrl;
		switch(_ID) {
			case 1:		// Google
				resUrl+="/translate_t?text="+textToTransalte+
						"&langpair="+langFrom+_LangSep+langTo+"&ie=utf8&oe=utf8";	
				break;
			case 2:		// BabelFish (Altavista)
				resUrl+="/babelfish/tr?urltext="+textToTransalte+
						"&lp="+langFrom+_LangSep+langTo+"&enc=utf8";
				break;
			case 3: 		// Systran
				resUrl+="/systran/box?systran_charset=utf-8&ttype=text&systran_text="+textToTransalte+
						"&systran_lp="+langFrom+_LangSep+langTo+"";
				break;
			case 4: 		// WorldLingo
				resUrl+="/wl/translate?wl_text="+textToTransalte+
						"&wl_srclang="+langFrom+"&wl_trglang="+langTo+"&wl_ucp=1";
				break;		
			case 5:		// BabelFish (Yahoo)
				resUrl+="/language/translate?doit=done&tt=text&intl=1&text="+textToTransalte+
						"&lp="+langFrom+_LangSep+langTo+"";
				break;			
		}
		return resUrl;
	}
	
	// Public Properties :: start
	public int ID {
		get {return _ID;}
	}		
	public string Name {
		get {return _Name;}
	}	
	public string LangSep {
		get {return _LangSep;}
	}	
	public string OpenTag1 {
		get {return _OpenTag1;}
	}	
	public string OpenTag2 {
		get {return _OpenTag2;}
	}	
	public string CloseTag {
		get {return _CloseTag;}
	}		
	public string MainUrl {
		get {return _MainUrl;}
	}		
	// Public Properties :: end

}