/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.geospatial;

import org.j3d.geom.GeometryData;
import org.j3d.geom.InvalidArraySizeException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.web3d.vrml.renderer.common.nodes.geospatial.GeoPosition;

public class ElevationGridGenerator {
    private static final float DEFAULT_SIZE = 100.0f;
    private static final int DEFAULT_POINT_COUNT = 2;
    private static final float DEFAULT_HEIGHT = 2.0f;
    private double terrainWidth;
    private double terrainDepth;
    private int widthPoints;
    private int depthPoints;
    private float yScale;
    private double[] flatHeights;
    private int numTerrainValues;
    private int numTexcoordValues;
    private float[] terrainCoordinates;
    private float[] terrainNormals;
    private float[] terrainTexcoords;
    private int facetCount;
    private GeoPosition inPosition;
    private GeoPosition outPosition;
    private float[] normal;
    private boolean perVertexNormals = true;

    public ElevationGridGenerator(double d, double d2, int n, int n2, float f, double[] dArray) {
        if (n < 2 || n2 < 2) {
            throw new IllegalArgumentException("Point count <= 1");
        }
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("Dimension <= 0");
        }
        this.terrainWidth = d;
        this.terrainDepth = d2;
        this.widthPoints = n;
        this.depthPoints = n2;
        this.yScale = f;
        this.facetCount = (this.depthPoints - 1) * (this.widthPoints - 1);
        this.flatHeights = dArray;
        this.inPosition = new GeoPosition();
        this.outPosition = new GeoPosition();
        this.normal = new float[3];
    }

    public void setDimensions(double d, double d2, int n, int n2) {
        if (this.terrainWidth != d || this.terrainDepth != d2) {
            this.terrainDepth = d2;
            this.terrainWidth = d;
        }
        if (n != this.widthPoints || n2 != this.depthPoints) {
            this.widthPoints = n;
            this.depthPoints = n2;
            this.facetCount = (this.depthPoints - 1) * (this.widthPoints - 1);
        }
    }

    public void setTerrainDetail(double[] dArray) {
        this.flatHeights = dArray;
    }

    public int getVertexCount(boolean bl) {
        int n = bl ? this.facetCount * 2 : this.widthPoints * 2 * (this.depthPoints - 1);
        return n;
    }

    public void generate(GeometryData geometryData, MathTransform mathTransform, double[] dArray, double[] dArray2, boolean bl, double d) throws InvalidArraySizeException, TransformException {
        if (bl) {
            this.indexedTriangleStrips(geometryData, mathTransform, dArray, dArray2, d);
        } else {
            this.triangleStrips(geometryData, mathTransform, dArray, dArray2, d);
        }
    }

    public void generateIndexedQuads(GeometryData geometryData, MathTransform mathTransform, double[] dArray, double[] dArray2, boolean bl, double d) throws InvalidArraySizeException, TransformException {
        double[] dArray3;
        double d2;
        int n;
        int n2;
        int n3;
        int n4 = this.widthPoints * this.depthPoints;
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n4 * 3];
        } else if (geometryData.coordinates.length < n4 * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n4 * 3);
        }
        if (geometryData.normals == null) {
            geometryData.normals = new float[n4 * 3];
        } else if (geometryData.normals.length < n4 * 3) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n4 * 3);
        }
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n4 * 2];
        } else if (geometryData.textureCoordinates.length < n4 * 2) {
            throw new InvalidArraySizeException("TextureCoordinates", geometryData.textureCoordinates.length, n4 * 2);
        }
        int n5 = (this.widthPoints - 1) * (this.depthPoints - 1) * 4;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n5];
        } else if (geometryData.indexes.length < n5) {
            throw new InvalidArraySizeException("Indexes", geometryData.indexes.length, n5);
        }
        float[] fArray = geometryData.coordinates;
        float[] fArray2 = geometryData.textureCoordinates;
        float[] fArray3 = geometryData.normals;
        geometryData.vertexCount = n4;
        double d3 = dArray[1];
        double d4 = dArray[0];
        double d5 = this.terrainWidth / (double)(this.widthPoints - 1);
        double d6 = this.terrainDepth / (double)(this.depthPoints - 1);
        float f = 1.0f / ((float)this.widthPoints - 1.0f);
        float f2 = 1.0f / ((float)this.depthPoints - 1.0f);
        int n6 = 0;
        int n7 = this.widthPoints * this.depthPoints;
        int n8 = 0;
        if (dArray2 != null) {
            n3 = 0;
            for (n2 = 0; n2 < this.depthPoints; ++n2) {
                for (n = 0; n < this.widthPoints; ++n) {
                    d2 = ++n3 > this.flatHeights.length ? 0.0 : this.flatHeights[n3 - 1];
                    this.inPosition.setPosition(d4, d3, d2 * (double)this.yScale);
                    mathTransform.transform((DirectPosition)this.inPosition, (DirectPosition)this.outPosition);
                    dArray3 = this.outPosition.getCoordinates();
                    fArray[n6] = (float)(dArray3[0] - dArray2[0]);
                    fArray[n6 + 1] = (float)(dArray3[1] - dArray2[1]);
                    fArray[n6 + 2] = (float)(dArray3[2] - dArray2[2]);
                    fArray2[n8++] = (float)n * f;
                    fArray2[n8++] = (float)n2 * f2;
                    n6 += 3;
                    d3 += d5;
                    if (n3 % this.widthPoints != 0) continue;
                    d4 += d6;
                    d3 = dArray[1];
                }
            }
        } else {
            n3 = 0;
            for (n2 = 0; n2 < this.depthPoints; ++n2) {
                for (n = 0; n < this.widthPoints; ++n) {
                    d2 = ++n3 > this.flatHeights.length ? 0.0 : this.flatHeights[n3 - 1];
                    this.inPosition.setPosition(d4, d3, d2 * (double)this.yScale);
                    mathTransform.transform((DirectPosition)this.inPosition, (DirectPosition)this.outPosition);
                    dArray3 = this.outPosition.getCoordinates();
                    fArray[n6] = (float)dArray3[0];
                    fArray[n6 + 1] = (float)dArray3[1];
                    fArray[n6 + 2] = (float)dArray3[2];
                    fArray2[n8++] = (float)n * f;
                    fArray2[n8++] = (float)n2 * f2;
                    n6 += 3;
                    d3 += d5;
                    if (n3 % this.widthPoints != 0) continue;
                    d4 += d6;
                    d3 = dArray[1];
                }
            }
        }
        n3 = 0;
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = geometryData.indexes.length;
        for (n = 0; n < this.depthPoints - 1; ++n) {
            for (int i = 0; i < this.widthPoints - 1; ++i) {
                nArray[n3] = i + n * this.widthPoints;
                nArray[n3 + 1] = nArray[n3] + 1;
                nArray[n3 + 2] = nArray[n3 + 1] + this.widthPoints;
                nArray[n3 + 3] = nArray[n3 + 2] - 1;
                n3 += 4;
            }
        }
        this.regenerateNormals(geometryData.coordinates, geometryData.normals);
    }

    private void triangleStrips(GeometryData geometryData, MathTransform mathTransform, double[] dArray, double[] dArray2, double d) throws InvalidArraySizeException, TransformException {
        int n;
        this.generateUnindexedTriStripCoordinates(geometryData, mathTransform, dArray, dArray2);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriStripNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateUnindexedTriStripTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        geometryData.numStrips = n = this.depthPoints - 1;
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n];
        } else if (geometryData.stripCounts.length < n) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n);
        }
        int n2 = n;
        while (--n2 >= 0) {
            geometryData.stripCounts[n2] = this.widthPoints * 2;
        }
    }

    private void generateUnindexedTriStripCoordinates(GeometryData geometryData, MathTransform mathTransform, double[] dArray, double[] dArray2) throws InvalidArraySizeException, TransformException {
        int n = this.widthPoints * (this.depthPoints - 1) * 2;
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.numTerrainValues = this.widthPoints * this.depthPoints * 3;
        this.terrainCoordinates = new float[this.numTerrainValues];
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = this.terrainWidth / (double)(this.widthPoints - 1);
        double d4 = this.terrainDepth / (double)(this.depthPoints - 1);
        if (this.perVertexNormals) {
            this.terrainNormals = new float[fArray.length];
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = this.widthPoints * (this.depthPoints - 1);
        if (dArray2 != null) {
            for (int i = 1; i <= n4; ++i) {
                double d5;
                double d6;
                double d7;
                double d8;
                this.inPosition.setPosition(d + d4, d2, this.flatHeights[i + this.widthPoints - 1] * (double)this.yScale);
                mathTransform.transform((DirectPosition)this.inPosition, (DirectPosition)this.outPosition);
                double[] dArray3 = this.outPosition.getCoordinates();
                fArray[n2] = -((float)(dArray3[0] - dArray2[0]));
                fArray[n2 + 1] = (float)(dArray3[1] - dArray2[1]);
                fArray[n2 + 2] = -((float)(dArray3[2] - dArray2[2]));
                if (this.perVertexNormals) {
                    d8 = dArray3[0];
                    d7 = dArray3[1];
                    d6 = dArray3[2];
                    d5 = d8 * d8 + d7 * d7 + d6 * d6;
                    if (d5 != 0.0) {
                        d5 = 1.0 / Math.sqrt(d5);
                        this.terrainNormals[n2] = (float)(d8 * d5);
                        this.terrainNormals[n2 + 1] = (float)(d7 * d5);
                        this.terrainNormals[n2 + 2] = (float)(d6 * d5);
                    } else {
                        this.terrainNormals[n2] = 0.0f;
                        this.terrainNormals[n2 + 1] = 1.0f;
                        this.terrainNormals[n2 + 2] = 0.0f;
                    }
                }
                if (d == 0.0) {
                    this.terrainCoordinates[n3] = fArray[n2];
                    this.terrainCoordinates[n3 + 1] = fArray[n2 + 1];
                    this.terrainCoordinates[n3 + 2] = fArray[n2 + 2];
                    n3 += 3;
                }
                this.inPosition.setPosition(d, d2, this.flatHeights[i - 1] * (double)this.yScale);
                mathTransform.transform((DirectPosition)this.inPosition, (DirectPosition)this.outPosition);
                dArray3 = this.outPosition.getCoordinates();
                if (this.perVertexNormals) {
                    d8 = dArray3[0];
                    d7 = dArray3[1];
                    d6 = dArray3[2];
                    d5 = d8 * d8 + d7 * d7 + d6 * d6;
                    if (d5 != 0.0) {
                        d5 = 1.0 / Math.sqrt(d5);
                        this.terrainNormals[n2 + 3] = (float)(d8 * d5);
                        this.terrainNormals[n2 + 4] = (float)(d7 * d5);
                        this.terrainNormals[n2 + 5] = (float)(d6 * d5);
                    } else {
                        this.terrainNormals[n2 + 3] = 0.0f;
                        this.terrainNormals[n2 + 4] = 1.0f;
                        this.terrainNormals[n2 + 5] = 0.0f;
                    }
                }
                fArray[n2 + 3] = -((float)(dArray3[0] - dArray2[0]));
                fArray[n2 + 4] = (float)(dArray3[1] - dArray2[1]);
                fArray[n2 + 5] = -((float)(dArray3[2] - dArray2[2]));
                this.terrainCoordinates[n3] = fArray[n2 + 3];
                this.terrainCoordinates[n3 + 1] = fArray[n2 + 4];
                this.terrainCoordinates[n3 + 2] = fArray[n2 + 5];
                n2 += 6;
                n3 += 3;
                d2 += d3;
                if (i % this.widthPoints != 0) continue;
                d += d4;
                d2 = 0.0;
            }
        } else {
            System.out.println("*** EG no origin: " + n4);
            for (int i = 1; i <= n4; ++i) {
                double d9;
                double d10;
                double d11;
                double d12;
                this.inPosition.setPosition(d + d4, d2, this.flatHeights[i + this.widthPoints - 1] * (double)this.yScale);
                mathTransform.transform((DirectPosition)this.inPosition, (DirectPosition)this.outPosition);
                double[] dArray4 = this.outPosition.getCoordinates();
                fArray[n2] = -((float)dArray4[0]);
                fArray[n2 + 1] = (float)dArray4[1];
                fArray[n2 + 2] = -((float)dArray4[2]);
                System.out.println("out1: " + dArray4[0] + " " + dArray4[1] + " " + dArray4[2]);
                if (this.perVertexNormals) {
                    d12 = dArray4[0];
                    d11 = dArray4[1];
                    d10 = dArray4[2];
                    d9 = d12 * d12 + d11 * d11 + d10 * d10;
                    if (d9 != 0.0) {
                        d9 = 1.0 / Math.sqrt(d9);
                        this.terrainNormals[n2] = (float)(d12 * d9);
                        this.terrainNormals[n2 + 1] = (float)(d11 * d9);
                        this.terrainNormals[n2 + 2] = (float)(d10 * d9);
                    } else {
                        this.terrainNormals[n2] = 0.0f;
                        this.terrainNormals[n2 + 1] = 1.0f;
                        this.terrainNormals[n2 + 2] = 0.0f;
                    }
                }
                if (d == 0.0) {
                    this.terrainCoordinates[n3] = fArray[n2];
                    this.terrainCoordinates[n3 + 1] = fArray[n2 + 1];
                    this.terrainCoordinates[n3 + 2] = fArray[n2 + 2];
                    n3 += 3;
                }
                this.inPosition.setPosition(d, d2, this.flatHeights[i - 1] * (double)this.yScale);
                mathTransform.transform((DirectPosition)this.inPosition, (DirectPosition)this.outPosition);
                dArray4 = this.outPosition.getCoordinates();
                System.out.println("out2: " + dArray4[0] + " " + dArray4[1] + " " + dArray4[2]);
                fArray[n2 + 3] = -((float)dArray4[0]);
                fArray[n2 + 4] = (float)dArray4[1];
                fArray[n2 + 5] = -((float)dArray4[2]);
                if (this.perVertexNormals) {
                    d12 = dArray4[0];
                    d11 = dArray4[1];
                    d10 = dArray4[2];
                    d9 = d12 * d12 + d11 * d11 + d10 * d10;
                    if (d9 != 0.0) {
                        d9 = 1.0 / Math.sqrt(d9);
                        this.terrainNormals[n2 + 3] = (float)(d12 * d9);
                        this.terrainNormals[n2 + 4] = (float)(d11 * d9);
                        this.terrainNormals[n2 + 5] = (float)(d10 * d9);
                    } else {
                        this.terrainNormals[n2 + 3] = 0.0f;
                        this.terrainNormals[n2 + 4] = 1.0f;
                        this.terrainNormals[n2 + 5] = 0.0f;
                    }
                }
                this.terrainCoordinates[n3] = fArray[n2 + 3];
                this.terrainCoordinates[n3 + 1] = fArray[n2 + 4];
                this.terrainCoordinates[n3 + 2] = fArray[n2 + 5];
                n2 += 6;
                n3 += 3;
                d2 += d3;
                if (i % this.widthPoints != 0) continue;
                d += d4;
                d2 = 0.0;
            }
        }
    }

    private void generateUnindexedTriStripNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
        this.regenerateNormals();
        float[] fArray = geometryData.normals;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.widthPoints * 3;
        int n5 = this.widthPoints * (this.depthPoints - 1);
        if (!this.perVertexNormals) {
            int n6 = n5;
            while (--n6 >= 0) {
                fArray[n2++] = this.terrainNormals[n3];
                fArray[n2++] = this.terrainNormals[n3 + 1];
                fArray[n2++] = this.terrainNormals[n3 + 2];
                fArray[n2++] = this.terrainNormals[n3 + n4];
                fArray[n2++] = this.terrainNormals[n3 + n4 + 1];
                fArray[n2++] = this.terrainNormals[n3 + n4 + 2];
                n3 += 3;
            }
        } else {
            for (float fArray[var3_9] : this.terrainNormals) {
            }
        }
    }

    private void generateUnindexedTriStripTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2 = this.widthPoints * (this.depthPoints - 1) * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n2 * 2];
        } else if (geometryData.textureCoordinates.length < n2 * 2) {
            throw new InvalidArraySizeException("Coordinates", geometryData.textureCoordinates.length, n2 * 2);
        }
        float[] fArray = geometryData.textureCoordinates;
        this.regenerateTexcoords();
        int n3 = 0;
        int n4 = 0;
        int n5 = this.widthPoints * 2;
        int n6 = n = this.widthPoints * (this.depthPoints - 1);
        while (--n6 >= 0) {
            fArray[n3++] = this.terrainTexcoords[n4 + n5];
            fArray[n3++] = this.terrainTexcoords[n4 + n5 + 1];
            fArray[n3++] = this.terrainTexcoords[n4];
            fArray[n3++] = this.terrainTexcoords[n4 + 1];
            n4 += 2;
        }
    }

    private void indexedTriangleStrips(GeometryData geometryData, MathTransform mathTransform, double[] dArray, double[] dArray2, double d) throws InvalidArraySizeException, TransformException {
        int n;
        this.generateIndexedCoordinates(geometryData, mathTransform, dArray, dArray2);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n2 = this.widthPoints * (this.depthPoints - 1) * 2;
        int n3 = this.depthPoints - 1;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n2];
        } else if (geometryData.indexes.length < n2) {
            throw new InvalidArraySizeException("Indexes", geometryData.indexes.length, n2);
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n3];
        } else if (geometryData.stripCounts.length < n3) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n3);
        }
        int[] nArray = geometryData.indexes;
        int[] nArray2 = geometryData.stripCounts;
        geometryData.indexesCount = n2;
        geometryData.numStrips = n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = n = this.widthPoints * (this.depthPoints - 1);
        while (--n6 >= 0) {
            nArray[n4++] = n5;
            nArray[n4++] = n5 + this.widthPoints;
            ++n5;
        }
        n6 = n3;
        while (--n6 >= 0) {
            nArray2[n6] = this.widthPoints * 2;
        }
    }

    private void generateIndexedCoordinates(GeometryData geometryData, MathTransform mathTransform, double[] dArray, double[] dArray2) throws InvalidArraySizeException, TransformException {
        int n = this.widthPoints * this.depthPoints;
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = this.terrainWidth / (double)(this.widthPoints - 1);
        double d4 = this.terrainDepth / (double)(this.depthPoints - 1);
        int n2 = 0;
        int n3 = this.widthPoints * this.depthPoints;
        if (dArray2 != null) {
            for (int i = 1; i <= n3; ++i) {
                this.inPosition.setPosition(d2, this.flatHeights[i - 1], d);
                mathTransform.transform((DirectPosition)this.inPosition, (DirectPosition)this.outPosition);
                double[] dArray3 = this.outPosition.getCoordinates();
                fArray[n2] = (float)(dArray3[0] - dArray2[0]);
                fArray[n2 + 1] = (float)(dArray3[1] - dArray2[1]);
                fArray[n2 + 2] = (float)(dArray3[2] - dArray2[2]);
                n2 += 3;
                d2 += d3;
                if (i % this.widthPoints != 0) continue;
                d += d4;
                d2 = 0.0;
            }
        } else {
            for (int i = 1; i <= n3; ++i) {
                this.inPosition.setPosition(d2, this.flatHeights[i - 1], d);
                mathTransform.transform((DirectPosition)this.inPosition, (DirectPosition)this.outPosition);
                double[] dArray4 = this.outPosition.getCoordinates();
                fArray[n2] = (float)dArray4[0];
                fArray[n2 + 1] = (float)dArray4[1];
                fArray[n2 + 2] = (float)dArray4[2];
                n2 += 3;
                d2 += d3;
                if (i % this.widthPoints != 0) continue;
                d += d4;
                d2 = 0.0;
            }
        }
    }

    private void generateIndexedNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
        this.regenerateNormals();
        System.arraycopy(this.terrainNormals, 0, geometryData.normals, 0, this.numTerrainValues);
    }

    private void generateTriTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        this.regenerateTexcoords();
        System.out.println("Unhandled textured generation case in ElevationGridGenerator");
    }

    private void generateTriTexture3D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("3D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
        System.out.println("Unhandled textured generation case in ElevationGridGenerator");
    }

    private final void regenerateNormals() {
        int n;
        if (this.perVertexNormals) {
            return;
        }
        this.terrainNormals = new float[this.numTerrainValues];
        int n2 = 0;
        int n3 = 0;
        int n4 = this.depthPoints * 3;
        this.createFaceNormal(this.terrainCoordinates, n4, 0, 3);
        this.terrainNormals[n2] = this.normal[0];
        this.terrainNormals[n2 + 1] = this.normal[1];
        this.terrainNormals[n2 + 2] = this.normal[2];
        n2 = 3;
        n3 = 3;
        for (n = 1; n < this.depthPoints - 1; ++n) {
            this.calcSideAverageNormal(this.terrainCoordinates, n3, n3 + 3, n3 + n4, n3 - 3);
            this.terrainNormals[n2] = this.normal[0];
            this.terrainNormals[n2 + 1] = this.normal[1];
            this.terrainNormals[n2 + 2] = this.normal[2];
            n2 += 3;
            n3 += 3;
        }
        this.createFaceNormal(this.terrainCoordinates, n3, n3 + n4, n3 - 3);
        this.terrainNormals[n2] = this.normal[0];
        this.terrainNormals[n2 + 1] = this.normal[1];
        this.terrainNormals[n2 + 2] = this.normal[2];
        n2 += 3;
        n3 += 3;
        for (n = 1; n < this.widthPoints - 1; ++n) {
            this.calcSideAverageNormal(this.terrainCoordinates, n3, n3 - n4, n3 + 3, n3 + n4);
            this.terrainNormals[n2] = this.normal[0];
            this.terrainNormals[n2 + 1] = this.normal[1];
            this.terrainNormals[n2 + 2] = this.normal[2];
            n3 += 3;
            n2 += 3;
            for (int i = 1; i < this.depthPoints - 1; ++i) {
                this.calcQuadAverageNormal(this.terrainCoordinates, n3, n3 + 3, n3 + n4, n3 - 3, n3 - n4);
                this.terrainNormals[n2] = this.normal[0];
                this.terrainNormals[n2 + 1] = this.normal[1];
                this.terrainNormals[n2 + 2] = this.normal[2];
                n3 += 3;
                n2 += 3;
            }
            this.calcSideAverageNormal(this.terrainCoordinates, n3, n3 + n4, n3 - 3, n3 - n4);
            this.terrainNormals[n2] = this.normal[0];
            this.terrainNormals[n2 + 1] = this.normal[1];
            this.terrainNormals[n2 + 2] = this.normal[2];
            n3 += 3;
            n2 += 3;
        }
        this.createFaceNormal(this.terrainCoordinates, n3, n3 - n4, n3 + 3);
        this.terrainNormals[n2] = this.normal[0];
        this.terrainNormals[n2 + 1] = this.normal[1];
        this.terrainNormals[n2 + 2] = this.normal[2];
        n3 += 3;
        n2 += 3;
        for (n = 1; n < this.depthPoints - 1; ++n) {
            this.calcSideAverageNormal(this.terrainCoordinates, n3, n3 - 3, n3 - n4, n3 + 3);
            this.terrainNormals[n2] = this.normal[0];
            this.terrainNormals[n2 + 1] = this.normal[1];
            this.terrainNormals[n2 + 2] = this.normal[2];
            n3 += 3;
            n2 += 3;
        }
        this.createFaceNormal(this.terrainCoordinates, n3, n3 - 3, n3 - n4);
        this.terrainNormals[n2] = this.normal[0];
        this.terrainNormals[n2 + 1] = this.normal[1];
        this.terrainNormals[n2 + 2] = this.normal[2];
    }

    private void calcSideAverageNormal(float[] fArray, int n, int n2, int n3, int n4) {
        this.createFaceNormal(fArray, n, n2, n3);
        float f = this.normal[0];
        float f2 = this.normal[1];
        float f3 = this.normal[2];
        this.createFaceNormal(fArray, n, n3, n4);
        this.normal[0] = (this.normal[0] + f) * 0.5f;
        this.normal[1] = (this.normal[1] + f2) * 0.5f;
        this.normal[2] = (this.normal[2] + f3) * 0.5f;
        float f4 = this.normal[0] * this.normal[0] + this.normal[1] * this.normal[1] + this.normal[2] * this.normal[2];
        if (f4 != 0.0f) {
            f4 = 1.0f / (float)Math.sqrt(f4);
            this.normal[0] = this.normal[0] * f4;
            this.normal[1] = this.normal[1] * f4;
            this.normal[2] = this.normal[2] * f4;
        } else {
            this.normal[0] = 0.0f;
            this.normal[1] = 0.0f;
            this.normal[2] = 0.0f;
        }
    }

    private void calcQuadAverageNormal(float[] fArray, int n, int n2, int n3, int n4, int n5) {
        this.createFaceNormal(fArray, n, n3, n2);
        float f = this.normal[0];
        float f2 = this.normal[1];
        float f3 = this.normal[2];
        this.createFaceNormal(fArray, n, n3, n4);
        f += this.normal[0];
        f2 += this.normal[1];
        f3 += this.normal[2];
        this.createFaceNormal(fArray, n, n4, n5);
        this.createFaceNormal(fArray, n, n5, n2);
        this.normal[0] = (this.normal[0] + (f += this.normal[0])) * 0.25f;
        this.normal[1] = (this.normal[1] + (f2 += this.normal[1])) * 0.25f;
        this.normal[2] = (this.normal[2] + (f3 += this.normal[2])) * 0.25f;
        float f4 = this.normal[0] * this.normal[0] + this.normal[1] * this.normal[1] + this.normal[2] * this.normal[2];
        if (f4 != 0.0f) {
            f4 = 1.0f / (float)Math.sqrt(f4);
            this.normal[0] = this.normal[0] * f4;
            this.normal[1] = this.normal[1] * f4;
            this.normal[2] = this.normal[2] * f4;
        } else {
            this.normal[0] = 0.0f;
            this.normal[1] = 0.0f;
            this.normal[2] = 0.0f;
        }
    }

    private final void regenerateTexcoords() {
        this.numTexcoordValues = this.widthPoints * this.depthPoints * 2;
        this.terrainTexcoords = new float[this.numTexcoordValues];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 1.0f / (float)(this.widthPoints - 1);
        float f4 = 1.0f / (float)(this.depthPoints - 1);
        int n = 0;
        if (this.flatHeights != null) {
            int n2 = this.numTerrainValues / 3;
            for (int i = 1; i <= n2; ++i) {
                this.terrainTexcoords[n++] = f2;
                this.terrainTexcoords[n++] = f;
                f2 += f3;
                if (i % this.widthPoints != 0) continue;
                f += f4;
                f2 = 0.0f;
            }
        } else {
            for (int i = 0; i < this.depthPoints; ++i) {
                for (int j = 0; j < this.widthPoints; ++j) {
                    this.terrainTexcoords[n++] = f2;
                    this.terrainTexcoords[n++] = f;
                    f2 += f3;
                }
                f += f4;
                f2 = 0.0f;
            }
        }
    }

    private void createFaceNormal(float[] fArray, int n, int n2, int n3) {
        float f = fArray[n2 + 1] - fArray[n + 1];
        float f2 = fArray[n + 2] - fArray[n3 + 2];
        float f3 = fArray[n2 + 2] - fArray[n + 2];
        float f4 = fArray[n + 1] - fArray[n3 + 1];
        float f5 = f * f2 - f3 * f4;
        float f6 = fArray[n] - fArray[n3];
        float f7 = fArray[n2] - fArray[n];
        float f8 = f3 * f6 - f7 * f2;
        float f9 = f7 * f4 - f * f6;
        float f10 = f5 * f5 + f8 * f8 + f9 * f9;
        if (f10 != 0.0f) {
            f10 = 1.0f / (float)Math.sqrt(f10);
            this.normal[0] = -f5 * f10;
            this.normal[1] = -f8 * f10;
            this.normal[2] = -f9 * f10;
        } else {
            this.normal[0] = 0.0f;
            this.normal[1] = 0.0f;
            this.normal[2] = 0.0f;
        }
    }

    private final void regenerateNormals(float[] fArray, float[] fArray2) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.widthPoints * 3;
        this.createFaceNormal(fArray, n4, 0, 3);
        fArray2[n2++] = this.normal[0];
        fArray2[n2++] = this.normal[1];
        fArray2[n2++] = this.normal[2];
        n3 = 3;
        for (n = 1; n < this.widthPoints - 1; ++n) {
            this.calcSideAverageNormal(fArray, n3, n3 + 3, n3 + n4, n3 - 3);
            fArray2[n2++] = this.normal[0];
            fArray2[n2++] = this.normal[1];
            fArray2[n2++] = this.normal[2];
            n3 += 3;
        }
        this.createFaceNormal(fArray, n3, n3 + n4, n3 - 3);
        fArray2[n2++] = this.normal[0];
        fArray2[n2++] = this.normal[1];
        fArray2[n2++] = this.normal[2];
        n3 += 3;
        for (n = 1; n < this.depthPoints - 1; ++n) {
            this.calcSideAverageNormal(fArray, n3, n3 - n4, n3 + 3, n3 + n4);
            fArray2[n2++] = this.normal[0];
            fArray2[n2++] = this.normal[1];
            fArray2[n2++] = this.normal[2];
            n3 += 3;
            for (int i = 1; i < this.widthPoints - 1; ++i) {
                this.calcQuadAverageNormal(fArray, n3, n3 + 3, n3 + n4, n3 - 3, n3 - n4);
                fArray2[n2++] = this.normal[0];
                fArray2[n2++] = this.normal[1];
                fArray2[n2++] = this.normal[2];
                n3 += 3;
            }
            this.calcSideAverageNormal(fArray, n3, n3 + n4, n3 - 3, n3 - n4);
            fArray2[n2++] = this.normal[0];
            fArray2[n2++] = this.normal[1];
            fArray2[n2++] = this.normal[2];
            n3 += 3;
        }
        this.createFaceNormal(fArray, n3, n3 - n4, n3 + 3);
        fArray2[n2++] = this.normal[0];
        fArray2[n2++] = this.normal[1];
        fArray2[n2++] = this.normal[2];
        n3 += 3;
        for (n = 1; n < this.widthPoints - 1; ++n) {
            this.calcSideAverageNormal(fArray, n3, n3 - 3, n3 - n4, n3 + 3);
            fArray2[n2++] = this.normal[0];
            fArray2[n2++] = this.normal[1];
            fArray2[n2++] = this.normal[2];
            n3 += 3;
        }
        this.createFaceNormal(fArray, n3, n3 - 3, n3 - n4);
        fArray2[n2++] = this.normal[0];
        fArray2[n2++] = this.normal[1];
        fArray2[n2++] = this.normal[2];
    }

    private String pp(float[] fArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fArray.length; ++i) {
            String string = Float.toString(fArray[i]);
            int n2 = n - string.length();
            if (n2 == 0) {
                stringBuffer.append(string);
                stringBuffer.append(" ");
                continue;
            }
            if (n2 < 0) {
                stringBuffer.append(string.substring(0, n));
                stringBuffer.append(" ");
                continue;
            }
            for (int j = 0; j < n2; ++j) {
                string = string + " ";
            }
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

