/*
   unibetaprep - Prepare a Beta Code file contianing traditional
                 Beta Code special numeric values for conversion
                 with beta2uni.

   Author: Paul Hardy

   Date: 2018
*/

%{
#include <config.h>   /* Generated by GNU Autotools */

#include <locale.h>
#include <stdio.h>
#include <unistd.h>

#define YY_NO_INPUT
#define YY_NO_UNPUT

#define PROG_NAME	"unibetaprep"

#define MAXSTRING 4096


int  escaped_last=0;       /* =1 if last string printed started with '{' */
void escape_out (char *);  /* output a hexadecimal Unicode code point    */

%}

%option noyywrap

%%
$[1-9]	escape_out ("$");
$[1-4][0-9]	escape_out ("$");
$50	escape_out ("$50");
$51	escape_out ("$50");
$52	escape_out ("$52");
$53	escape_out ("$53");
$70	escape_out ("$");
$80	escape_out ("&");
&[1-9]	escape_out ("&");
&[1-4][0-9]	escape_out ("&");
\{10	escape_out ("\\u0332");
\{100	escape_out ("{100");
\{101	escape_out ("{101");
\<	escape_out ("\\u0305");
\<1	escape_out ("\\u0332");
\<2	escape_out ("\\u2035");
\>2	escape_out ("\\u2032");
\<3	escape_out ("\\u0361");
\<4	escape_out ("\\u035C");
\<5	escape_out ("\\u035D");
\<8	escape_out ("\\u0333");
\<16	escape_out ("\\u2035");
\>16	escape_out ("\\u2032");
\<17	escape_out ("\\u0333");
\<18	escape_out ("\\u0336");
\<19	escape_out ("\\u2032");
\<31	escape_out ("\\u0336");
\<32	escape_out ("\\u0305\\u0332");
\<33	escape_out ("\\u221A");
\<100	escape_out ("\\u0338");
\"1	escape_out ("\\u201E");
\"2	escape_out ("\\u201C");
\"4	escape_out ("\\u201A");
\"5	escape_out ("\\u201B");
\[	escape_out ("[");
\]	escape_out ("]");
\[1	escape_out ("\\u0028");
\]1	escape_out ("\\u0029");
\[2	escape_out ("\\u2329");
\]2	escape_out ("\\u232A");
\[3	escape_out ("\\u007B");
\]3	escape_out ("\\u007D");
\[4	escape_out ("\\u27E6");
\]4	escape_out ("\\u27E7");
\[5	escape_out ("\\u2E24");
\]5	escape_out ("\\u2E25");
\[6	escape_out ("\\u2E22");
\]6	escape_out ("\\u2E23");
\[7	escape_out ("\\u2E22");
\]7	escape_out ("\\u2E25");
\[8	escape_out ("\\u2E24");
\]8	escape_out ("\\u2E23");
\[9	escape_out ("\\u2027");
\]9	escape_out ("\\u2027");
\[10	escape_out ("[");
\]10	escape_out ("]");
\[11	escape_out ("\\u208D");
\]11	escape_out ("\\u208E");
\[12	escape_out ("\\u2192");
\]12	escape_out ("\\u2190");
\[13	escape_out ("/");
\]13	escape_out ("/");
\[14	escape_out ("|:");
\]14	escape_out (":|");
\[16	escape_out ("\\u27E6");
\]16	escape_out ("\\u27E7");
\[17	escape_out ("\\u230A\\u230A");
\]17	escape_out ("\\u230B\\u230B");
\[18	escape_out ("\\u27EA");
\]18	escape_out ("\\u27EB");
\[20	escape_out ("\\u23A7");
\]20	escape_out ("\\u23AB");
\[21	escape_out ("\\u23AA");
\]21	escape_out ("\\u23AA");
\[22	escape_out ("\\u23AB");
\]22	escape_out ("\\u23AC");
\[23	escape_out ("\\u23A9");
\]23	escape_out ("\\u23AD");
\[30	escape_out ("\\u239B");
\]30	escape_out ("\\u239E");
\[31	escape_out ("\\u239C");
\]31	escape_out ("\\u239F");
\[32	escape_out ("\\u239D");
\]32	escape_out ("\\u23A0");
\[70	escape_out ("\\u2E02");
\]70	escape_out ("\\u2E03");
\[71	escape_out ("\\u2E04");
\]71	escape_out ("\\u2E05");
\[72	escape_out ("\\u2E09");
\]72	escape_out ("\\u2E0A");
\[73	escape_out ("\\u2E0B");
\]73	escape_out ("\\u2E0C");
\[80	escape_out ("/");
\]80	escape_out ("/");
\[81	escape_out ("//");
\]81	escape_out ("//");
\[82	escape_out ("\\u2E20");
\]82	escape_out ("\\u2E21");
\[83	escape_out ("\\u2E21");
\]83	escape_out ("\\u2E20");
\[84	escape_out ("\\u2E26");
\]84	escape_out ("\\u2E27");
\[85	escape_out ("\\u2E28");
\]85	escape_out ("\\u2E29");
%	escape_out ("\\u2020");
%1	escape_out ("?");
%2	escape_out ("*");
%3	escape_out ("/");
%4	escape_out ("!");
%5	escape_out ("|");
%6	escape_out ("=");
%7	escape_out ("+");
%8	escape_out ("%%");
%9	escape_out ("&");
%10	escape_out (":");
%11	escape_out ("\\u2022");
%12	escape_out ("*");
%13	escape_out ("\\u2021");
%14	escape_out ("\\u00A7");
%15	escape_out ("\\u02C8");
%16	escape_out ("\\u00A6");
%17	escape_out ("\\u2016");
%18	escape_out ("'");
%19	escape_out ("\\u2013");
%20	escape_out ("\\u0301");
%21	escape_out ("\\u0300");
%22	escape_out ("\\u0302");
%23	escape_out ("\\u0308");
%24	escape_out ("\\u0342");
%25	escape_out ("\\u0327");
%26	escape_out ("\\u0304");
%27	escape_out ("\\u0306");
%28	escape_out ("\\u0308");
%29	escape_out ("\\u0323\\u0323");
%30	escape_out ("\\u02BC");
%31	escape_out ("\\u02BD");
%32	escape_out ("\\u00B4");
%33	escape_out ("`");
%34	escape_out ("\\u1FC0");
%35	escape_out ("\\u1FCE");
%36	escape_out ("\\u1FDE");
%37	escape_out ("\\u1FDD");
%38	escape_out ("\\u1FDF");
%39	escape_out ("\\u00A8");
%40	escape_out ("\\u23D1");
%41	escape_out ("\\u2013");
%42	escape_out ("\\u23D5");
%43	escape_out ("\\u00D7");
%44	escape_out ("\\u23D2");
%45	escape_out ("\\u23D3");
%46	escape_out ("\\u23D4");
%47	escape_out ("\\u10111");
%48	escape_out ("\\u23D1\\u23D1");
%49	escape_out ("\\u23D1\\u23D1\\u23D1");
%80	escape_out ("v.");
%81	escape_out ("vac.");
%91	escape_out ("\\u0485");
%92	escape_out ("\\u0486");
%93	escape_out ("\\u1DC0");
%94	escape_out ("\\u0307");
%95	escape_out ("\\u1DC1");
%96	escape_out ("\\u035C");
%97	escape_out ("\\u0307");
%98	escape_out ("?");
%99	escape_out ("\\u2248");
%100	escape_out (";");
%101	escape_out ("#");
%102	escape_out ("\\u2018");
%103	escape_out ("\\");
%104	escape_out ("^");
%105	escape_out ("|||");
%106	escape_out ("\\u224C");
%107	escape_out ("~");
%108	escape_out ("\\u00B1");
%109	escape_out ("\\u00B7");
%110	escape_out ("\\u25CB");
%127	escape_out ("\\u032F");
%128	escape_out ("\\u030C");
%129	escape_out ("\\u2020");
%130	escape_out ("\\u0307");
%132	escape_out ("\\u0385");
%133	escape_out ("\\u1FCD");
%134	escape_out ("\\u1FCF");
%138	escape_out ("\\u23D1\\u0301");
%139	escape_out ("%%139");
%140	escape_out ("\\u10112");
%141	escape_out ("\\u23D6");
%142	escape_out ("\\u2510");
%144	escape_out ("\\u23D1\\u0336");
%145	escape_out ("\\u2013\\u0301");
%146	escape_out ("\\u00B7");
%147	escape_out ("\\u030A");
%148	escape_out ("\\u030C");
%149	escape_out ("\\u0328");
%150	escape_out ("|");
%154	escape_out ("\\u2234");
%155	escape_out ("\\u2235");
%157	escape_out ("%%157");
%158	escape_out ("\\u2042");
%159	escape_out ("\\u00D7");
%160	escape_out ("-");
%161	escape_out ("\\u00F7");
%162	escape_out ("\\u0338");
%163	escape_out ("\\u00B6");
%170	escape_out ("\\u0359");
%171	escape_out ("//");
%172	escape_out ("\\u02BC");
%173	escape_out ("\\u02BD");
%174	escape_out ("\\u00B4");
%175	escape_out ("`");
%176	escape_out ("\\u1FC0");
%177	escape_out ("\\u0313");
%178	escape_out ("\\u0314");
%179	escape_out ("\\u0323");
%180	escape_out ("\\u033D");
%181	escape_out ("\\u032D");
%182	escape_out ("\\u0361");
%183	escape_out ("\\u035D");
%184	escape_out ("\\u035E");
%185	escape_out ("\\u2319");
%186	escape_out ("\\u1D242");
%187	escape_out ("\\u00AC");
%188	escape_out ("\\u031A");
#	escape_out ("\\u0374");
\*#1	escape_out ("\\u03DE");
#1	escape_out ("\\u03DF");
\*#2	escape_out ("\\u03DA");
#2	escape_out ("\\u03DB");
\*#3	escape_out ("\\u03D8");
#3	escape_out ("\\u03D9");
#4	escape_out ("\\u03DE");
\*#5	escape_out ("\\u03E0");
#5	escape_out ("\\u03E1");
#6	escape_out ("\\u2E0F");
#8	escape_out ("\\u2E10");
#9	escape_out ("\\u0301");
#10	escape_out ("\\u03FD");
#11	escape_out ("\\u03FF");
#12	escape_out ("\\u2014");
#13	escape_out ("\\u203B");
#14	escape_out ("\\u2E16");
#15	escape_out (">");
#16	escape_out ("\\u03FE");
#17	escape_out ("/");
#18	escape_out ("<");
#19	escape_out ("\\u0300");
#20	escape_out ("\\u10175");
#21	escape_out ("\\u10176");
#22	escape_out ("\\u0375");
#23	escape_out ("\\u03D8");
#24	escape_out ("\\u10176");
#25	escape_out ("\\u10176");
#26	escape_out ("\\u2E0F");
#29	escape_out ("\\u00B7");
#30	escape_out ("#30");
#31	escape_out ("#31");
#51	escape_out ("\\u00B7");
#52	escape_out ("\\u205A");
#53	escape_out ("\\u205D");
#55	escape_out ("\\u2059");
#59	escape_out ("\\u03FD");
#60	escape_out ("\\u0399");
#61	escape_out ("\\u10142");
#62	escape_out ("\\u10143");
#63	escape_out ("\\u0394");
#64	escape_out ("\\u10144");
#65	escape_out ("\\u0397");
#66	escape_out ("\\u10145");
#67	escape_out ("\\u03A7");
#68	escape_out ("\\u10146");
#69	escape_out ("\\u039C");
#70	escape_out (".");
#71	escape_out ("\\u00B7");
#72	escape_out ("\\u02D9");
#73	escape_out ("\\u205A");
#74	escape_out ("\\u205D");
#75	escape_out (".");
#80	escape_out ("\\u0308");
#81	escape_out ("'");
#82	escape_out ("\\u02CA");
#83	escape_out ("\\u02CB");
#84	escape_out ("\\u1FC0");
#85	escape_out ("\\u02BD");
#86	escape_out ("\\u02BC");
#87	escape_out ("\\u0394\\u0345");
#90	escape_out ("\\u2014");
#100	escape_out ("\\u10186");
#101	escape_out ("\\u1017B");
#102	escape_out ("\\u10182\\u03C5");
#103	escape_out ("\\u039B\\u0338");
#104	escape_out ("\\u10182\\u03BF");
#105	escape_out ("#105");
#106	escape_out ("\\u10184");
#107	escape_out ("#107");
#108	escape_out ("#108");
#109	escape_out ("\\u10182\\u03BF");
#110	escape_out ("\\u03B1\\u0317");
#111	escape_out ("\\u10182\\u03B5");
#112	escape_out ("\\u10188");
#113	escape_out ("\\u1017C");
#114	escape_out ("\\u10140");
#115	escape_out ("\\u10189");
#116	escape_out ("\\u1017C");
#117	escape_out ("\\u10183");
#118	escape_out ("\\u03BB\\u0338");
#119	escape_out ("\\u1017D");
#120	escape_out ("\\u10184");
#121	escape_out ("\\u03BE\\u0338");
#122	escape_out ("\\u1017D");
#123	escape_out ("\\u1017C");
#124	escape_out ("#124");
#125	escape_out ("\\u10182\\u03C5");
#126	escape_out ("#126");
#127	escape_out ("\\u03BB\\u0345");
#128	escape_out ("\\u03FC");
#129	escape_out ("\\u039B\\u0325");
#130	escape_out ("\\u1018A");
#131	escape_out ("\\u10177");
#132	escape_out ("\\u03B2\\u0338");
#133	escape_out ("\\u03C7\\u03BF");
#134	escape_out ("\\u0393\\u03B2");
#135	escape_out ("\\u02D9");
#136	escape_out ("\\u03A3");
#137	escape_out ("\\u0393\\u03B2");
#150	escape_out ("\\u221E");
#151	escape_out ("\\u2014");
#152	escape_out ("\\u205A\\u2014");
#153	escape_out ("\\u2026\\u0305");
#154	escape_out ("\\u2C80");
#155	escape_out ("\\u2014\\u0323");
#156	escape_out ("\\u2310");
#157	escape_out ("#157");
#158	escape_out ("\\u2237\\u0336");
#159	escape_out ("\\u2237\\u0334");
#160	escape_out ("~\\u0323");
#161	escape_out ("\\u10175");
#162	escape_out ("\\u25A1");
#163	escape_out ("\\u0375");
#165	escape_out ("\\u00D7");
#166	escape_out ("\\u2A5A");
#167	escape_out ("\\u039C\\u039C");
#168	escape_out ("\\u039C\\u039C\\u039C");
#169	escape_out ("\\u10175");
#170	escape_out ("II");
#171	escape_out ("\\u10175");
#172	escape_out ("\\u10176");
#173	escape_out ("\\u10175");
#200	escape_out ("\\u2643");
#201	escape_out ("\\u25A1");
#202	escape_out ("\\u264F");
#203	escape_out ("\\u264D");
#204	escape_out ("\\u2640");
#205	escape_out ("\\u2650");
#206	escape_out ("\\u2644");
#207	escape_out ("\\u2609");
#208	escape_out ("\\u263F");
#209	escape_out ("\\u263E");
#210	escape_out ("\\u2642");
#211	escape_out ("\\u2651");
#212	escape_out ("\\u264C");
#213	escape_out ("\\u2648");
#214	escape_out ("\\u264E");
#215	escape_out ("\\u264A");
#216	escape_out ("\\u264B");
#217	escape_out ("\\u2653");
#218	escape_out ("\\u2652");
#219	escape_out ("\\u2649");
#220	escape_out ("\\u260D");
#221	escape_out ("\\u263D");
#222	escape_out ("\\u260C");
#223	escape_out ("\\u2605");
#240	escape_out ("\\u10177");
#241	escape_out ("\\u260B");
#242	escape_out ("\\u2651");
#243	escape_out ("#243");
#244	escape_out ("\\u264C");
#245	escape_out ("\\u264E\\u033D");
#246	escape_out ("#246");
#247	escape_out ("#247");
#248	escape_out ("#248");
#249	escape_out ("\\u03C0\\u263E");
#250	escape_out ("#250");
#300	escape_out ("#300");
#301	escape_out ("\\u039B\\u039F");
#302	escape_out ("#302");
#303	escape_out (">");
#304	escape_out ("#304");
#305	escape_out ("\\u2EDE");
#306	escape_out ("#306");
#307	escape_out ("#307");
#308	escape_out ("#308");
#310	escape_out ("\\u2EDE");
#311	escape_out ("#311");
#312	escape_out ("#312");
#313	escape_out ("\\u2E0E");
#314	escape_out ("#314");
#315	escape_out ("\\u2E0E");
#319	escape_out ("\\u25CF");
#320	escape_out ("\\u2629");
#321	escape_out ("\\u2629");
#322	escape_out ("\\u2627");
#323	escape_out (">");
\*#400	escape_out ("\\u0370");
#400	escape_out ("\\u0371");
\*#401	escape_out ("\\u037F");
#401	escape_out ("\\u03F3");
#451	escape_out ("\\u0283");
#452	escape_out ("\\u2E10");
#453	escape_out ("\\u2E11");
#454	escape_out ("\\u2E10");
#455	escape_out ("\\u2E11");
#456	escape_out ("\\u2EDE");
#457	escape_out ("#457");
#458	escape_out ("\\u03A7");
#459	escape_out ("\\u00B7");
#460	escape_out ("\\u2014");
#461	escape_out ("|");
#465	escape_out ("\\u2627");
#466	escape_out ("#466");
#467	escape_out ("\\u2192");
#468	escape_out ("\\u2E0E");
#476	escape_out ("\\u0283");
#501	escape_out ("#501");
#502	escape_out ("#502");
#503	escape_out ("#503");
#504	escape_out ("\\u2E0E");
#505	escape_out ("\\u205C");
#506	escape_out ("\\u2E15");
#507	escape_out ("\\u2E14");
#508	escape_out ("\\u203B");
#509	escape_out ("\\u0305\\u0311");
#510	escape_out ("\\u03C0\\u2014\\u03B5");
#511	escape_out ("\\u03BA\\u2014\\u03B9");
#512	escape_out ("\\u03FD");
#513	escape_out ("#513");
#514	escape_out ("#514");
#515	escape_out ("\\u10185");
#516	escape_out ("\\u0394\\u0345");
#517	escape_out ("\\u10185");
#518	escape_out ("\\u10179");
#519	escape_out ("\\u2191");
#520	escape_out ("\\u2629");
#521	escape_out ("#521");
#522	escape_out ("\\u0397");
#523	escape_out ("\\u2E13");
#524	escape_out ("\\u2297");
#525	escape_out ("\\u271B");
#526	escape_out ("\\u2190");
#527	escape_out ("\\u02C6");
#528	escape_out ("\\u03BB\\u032D");
#529	escape_out ("\\u204B");
#530	escape_out ("#530");
#531	escape_out ("\\u035C");
#532	escape_out ("\\u2E12");
#533	escape_out ("\\u03DA");
#534	escape_out ("\\u0302\\u02C6");
#535	escape_out ("#535");
#536	escape_out ("#536");
#537	escape_out ("#537");
#538	escape_out ("#538");
#539	escape_out ("#539");
#540	escape_out ("#540");
#542	escape_out ("\\u03A1\\u0336");
#543	escape_out ("#543");
#544	escape_out ("\\u2058");
#545	escape_out ("#545");
#546	escape_out ("#546");
#547	escape_out ("#547");
#548	escape_out ("\\u2016\\u0334");
#549	escape_out ("#549");
#550	escape_out ("\\u2E2E");
#551	escape_out ("#551");
#552	escape_out ("#552");
#553	escape_out ("#553");
#554	escape_out ("#554");
#555	escape_out ("#555");
#556	escape_out ("\\u2629");
#557	escape_out ("#557");
#558	escape_out ("#558");
#559	escape_out ("#559");
#561	escape_out ("\\u2191");
#562	escape_out ("\\u0305");
#563	escape_out ("\\u1D242");
#564	escape_out ("\\u1D243");
#565	escape_out ("\\u1D244");
#566	escape_out ("\\u1D231");
#567	escape_out ("\\u1D213");
#568	escape_out ("\\u1D233");
#569	escape_out ("\\u1D236");
#570	escape_out ("\\u03F9");
#571	escape_out ("\\u10143");
#572	escape_out ("\\u1D229");
#573	escape_out ("\\u1D212");
#574	escape_out ("\\u0393");
#575	escape_out ("\\u1D215");
#576	escape_out ("\\u1D216");
#577	escape_out ("\\u03A6");
#578	escape_out ("\\u03A1");
#579	escape_out ("\\u039C");
#580	escape_out ("\\u0399");
#581	escape_out ("\\u0398");
#582	escape_out ("\\u1D20D");
#583	escape_out ("\\u039D");
#584	escape_out ("\\u2127");
#585	escape_out ("\\u0396");
#586	escape_out ("\\u1D238");
#587	escape_out ("\\u0395");
#588	escape_out ("\\u1D208");
#589	escape_out ("\\u1D21A");
#590	escape_out ("\\u1D23F");
#591	escape_out ("\\u1D21B");
#592	escape_out ("\\u1D240");
#593	escape_out ("\\u039B");
#594	escape_out ("#594");
#595	escape_out ("#595");
#596	escape_out ("#596");
#597	escape_out ("#597");
#598	escape_out ("\\u0394");
#599	escape_out ("\\u1D214");
#600	escape_out ("\\u1D228");
#601	escape_out ("#601");
#602	escape_out ("\\u1D237");
#603	escape_out ("\\u03A0");
#604	escape_out ("\\u1D226");
#605	escape_out ("#605");
#606	escape_out ("#606");
#607	escape_out ("#607");
#608	escape_out ("#608");
#609	escape_out ("#609");
#610	escape_out ("#610");
#611	escape_out ("#611");
#612	escape_out ("#612");
#613	escape_out ("#613");
#614	escape_out ("#614");
#615	escape_out ("\\u1D230");
#616	escape_out ("\\u1D21E");
#617	escape_out ("\\u03A9");
#618	escape_out ("#618");
#619	escape_out ("\\u03BB");
#620	escape_out ("#620");
#621	escape_out ("\\u1D205");
#622	escape_out ("\\u1D201");
#623	escape_out ("\\u2127");
#624	escape_out ("\\u03FD");
#625	escape_out ("#625");
#626	escape_out ("#626");
#627	escape_out ("\\u1D217");
#628	escape_out ("\\u039F");
#629	escape_out ("\\u039E");
#630	escape_out ("\\u0394");
#631	escape_out ("\\u039A");
#632	escape_out ("\\u1D20E");
#633	escape_out ("\\u1D232");
#634	escape_out ("\\u1D239");
#635	escape_out ("\\u1D200");
#636	escape_out ("\\u1D203");
#637	escape_out ("\\u1D206");
#638	escape_out ("\\u1D209");
#639	escape_out ("\\u1D20C");
#640	escape_out ("\\u1D211");
#641	escape_out ("\\u03A9");
#642	escape_out ("\\u0397");
#643	escape_out ("\\u1D21D");
#644	escape_out ("\\u1D21F");
#645	escape_out ("\\u1D221");
#646	escape_out ("\\u1D225");
#647	escape_out ("\\u1D22C");
#648	escape_out ("\\u1D235");
#649	escape_out ("\\u1D20B");
#650	escape_out ("\\u1D20F");
#651	escape_out ("\\u03A7");
#652	escape_out ("\\u03A4");
#653	escape_out ("\\u1D219");
#654	escape_out ("\\u1D21C");
#655	escape_out ("\\u1D202");
#656	escape_out ("\\u1D224");
#657	escape_out ("\\u1D22E");
#658	escape_out ("\\u1D23E");
#659	escape_out ("\\u1D241");
#660	escape_out ("\\u0391");
#661	escape_out ("\\u0392");
#662	escape_out ("\\u03A5");
#663	escape_out ("\\u03A8");
#664	escape_out ("\\u1D23A");
#665	escape_out ("\\u1D234");
#666	escape_out ("\\u1D22F");
#667	escape_out ("\\u1D22D");
#668	escape_out ("\\u1D210");
#669	escape_out ("\\u1D20A");
#670	escape_out ("\\u1D207");
#671	escape_out ("\\u1D21B");
#672	escape_out ("\\u1D218");
#673	escape_out ("\\u1D223");
#674	escape_out ("\\u1D222");
#675	escape_out ("\\u1D240");
#676	escape_out ("\\u1D23D");
#677	escape_out ("\\u03BC");
#678	escape_out ("\\u1D220");
#679	escape_out ("\\u1D204");
#680	escape_out ("#680");
#681	escape_out ("#681");
#682	escape_out ("#682");
#683	escape_out ("\\u2733");
#684	escape_out ("\\u1D22A");
#685	escape_out ("#685");
#686	escape_out ("#686");
#687	escape_out ("#687");
#688	escape_out ("\\u03BC\\u030A");
#689	escape_out ("\\u10175");
#690	escape_out ("\\u27D8");
#691	escape_out ("\\u27C0");
#692	escape_out ("\\u27C1");
#693	escape_out ("#693");
#694	escape_out ("\\u0396");
#695	escape_out ("\\u2014");
#696	escape_out ("\\u1D227");
#697	escape_out ("\\u1D245");
#700	escape_out ("\\u205E");
#701	escape_out ("#701");
#702	escape_out ("#702");
#703	escape_out ("\\u25CB\\u25CB\\u25CB");
#704	escape_out ("\\u2014\\u0307");
#705	escape_out ("#705");
#706	escape_out ("#706");
#707	escape_out ("#707");
#708	escape_out ("#708");
#709	escape_out ("\\u223B");
#710	escape_out ("\\u039A\\u0336");
\*#711	escape_out ("\\u03FA");
#711	escape_out ("\\u03FB");
#712	escape_out ("#712");
#713	escape_out ("#713");
#714	escape_out ("#714");
#715	escape_out ("#715");
#716	escape_out ("#716");
#717	escape_out ("\\u2E00");
#718	escape_out ("\\u2E01");
#719	escape_out ("\\u2E06");
#720	escape_out ("\\u2E07");
#721	escape_out ("\\u003A");
#722	escape_out ("\\u2135");
#723	escape_out ("\\u1D516");
#724	escape_out ("\\u210C");
#725	escape_out ("\\u1D510");
#730	escape_out ("\\u2014");
#731	escape_out ("\\u23D7");
#732	escape_out ("\\u23D8");
#733	escape_out ("\\u23D9");
#751	escape_out ("\\u0661");
#752	escape_out ("\\u0662");
#753	escape_out ("\\u0663");
#754	escape_out ("\\u0664");
#755	escape_out ("\\u0665");
#756	escape_out ("\\u0666");
#757	escape_out ("\\u0667");
#758	escape_out ("\\u0668");
#759	escape_out ("\\u0669");
#760	escape_out ("\\u0660");
#761	escape_out ("#761");
#762	escape_out ("\\u02D9");
#800	escape_out ("\\u2733");
#801	escape_out ("\\u10141");
#802	escape_out ("\\u10140");
#803	escape_out ("\\u03A7");
#804	escape_out ("/");
#805	escape_out ("\\u03A4");
#806	escape_out ("\\u039A");
#807	escape_out ("\\u10166");
#808	escape_out ("\\u10148");
#811	escape_out ("\\u03A4");
#812	escape_out ("\\u10148");
#813	escape_out ("\\u10149");
#814	escape_out ("\\u1014A");
#815	escape_out ("\\u1014B");
#816	escape_out ("\\u1014C");
#817	escape_out ("\\u1014D");
#818	escape_out ("\\u1014E");
#819	escape_out ("#819");
#821	escape_out ("\\u03A3");
#822	escape_out ("\\u1014F");
#823	escape_out ("\\u10150");
#824	escape_out ("\\u10151");
#825	escape_out ("\\u10152");
#826	escape_out ("\\u10153");
#827	escape_out ("\\u10154");
#828	escape_out ("#828");
#829	escape_out ("\\u10155");
#830	escape_out ("\\u10147");
#831	escape_out ("\\u10147");
#832	escape_out ("\\u10156");
#833	escape_out ("\\u039C");
#834	escape_out ("\\u10157");
#835	escape_out ("\\u03A7");
#836	escape_out ("\\u03A3");
#837	escape_out ("\\u03A4");
#838	escape_out ("\\u10143");
#839	escape_out ("\\u10141");
#840	escape_out ("||");
#841	escape_out ("|||");
#842	escape_out ("\\u00B7");
#843	escape_out ("\\u1015B");
#844	escape_out ("\\u205D");
#845	escape_out ("\\u10158");
#846	escape_out ("\\u10110");
#847	escape_out ("\\u1015E");
#848	escape_out ("\\u10112");
#850	escape_out ("#850");
#853	escape_out ("\\u0399");
#862	escape_out ("\\u0394");
#863	escape_out ("\\u10144");
#865	escape_out ("\\u10145");
#866	escape_out ("\\u03A7");
#867	escape_out ("\\u10146");
#899	escape_out ("#899");
#922	escape_out ("\\u1D228");
#923	escape_out ("#923");
#924	escape_out ("#924");
#925	escape_out ("\\u1D217");
#926	escape_out ("\\u1D232");
#927	escape_out ("W");
#928	escape_out ("\\u1D20B");
#929	escape_out ("\\u1D214");
#930	escape_out ("#930");
#932	escape_out ("\\u2733");
#933	escape_out ("#933");
#934	escape_out ("#934");
#936	escape_out ("#936");
#938	escape_out ("\\u01A7");
#939	escape_out ("~");
#940	escape_out ("#940");
#941	escape_out ("\\u1D205");
#980	escape_out ("#980");
#1000	escape_out ("\\u1017C");
#1001	escape_out ("\\u1017D");
#1002	escape_out ("\\u1017E");
#1003	escape_out ("\\u1017F");
#1004	escape_out ("\\u10180");
#1005	escape_out ("\\u03A7");
#1006	escape_out ("\\u03A7\\u0391");
#1007	escape_out ("\\u03A7\\u0392");
#1008	escape_out ("\\u03A7\\u0393");
#1009	escape_out ("\\u03A7\\u0394");
#1010	escape_out ("\\u03A7\\u0395");
#1011	escape_out ("\\u03A7\\u0396");
#1012	escape_out ("\\u03A7\\u0397");
#1013	escape_out ("\\u03A7>");
#1020	escape_out ("<");
#1021	escape_out ("\\u0394\\u0374");
#1022	escape_out ("\\u0397\\u0374");
#1023	escape_out ("\\u0399\\u0374");
#1024	escape_out ("\\u039B\\u0392");
#1100	escape_out ("\\u2183");
#1101	escape_out ("#1101");
#1102	escape_out ("#1102");
#1103	escape_out ("\\u0323\\u0313");
#1104	escape_out ("#1104");
#1105	escape_out ("M\\u030A");
#1106	escape_out ("#1106");
#1107	escape_out ("S\\u0336S\\u0336S");
#1108	escape_out ("X\\u0336");
#1109	escape_out ("=");
#1110	escape_out ("-");
#1111	escape_out ("\\u00B0");
#1112	escape_out ("#1112");
#1113	escape_out ("#1113");
#1114	escape_out ("\\u1D201");
#1115	escape_out ("|");
#1116	escape_out ("\\u01A7");
#1117	escape_out ("Z");
#1118	escape_out ("#1118");
#1119	escape_out ("\\u0110");
#1120	escape_out ("#1120");
#1121	escape_out ("Z");
#1122	escape_out ("#1122");
#1123	escape_out ("#1123");
#1124	escape_out ("\\u211E");
#1125	escape_out ("#1125");
#1126	escape_out ("O");
#1127	escape_out ("V\\u0338");
#1128	escape_out ("I\\u0336I\\u0336S\\u0336");
#1129	escape_out ("Z\\u0336");
#1130	escape_out ("\\");
#1131	escape_out ("\\\\");
#1132	escape_out ("\\\\u0336");
#1133	escape_out ("\\\\u0336\\\\u0336");
#1134	escape_out ("#1134");
#1135	escape_out ("9");
#1136	escape_out ("\\u2112");
#1200	escape_out ("\\u00A2");
#1201	escape_out ("\\u2021");
#1202	escape_out ("\\u20A4");
#1203	escape_out ("\\u00DF");
#1204	escape_out ("\\u00B0");
#1209	escape_out ("\\u0127");
#1212	escape_out ("D\\u0336");
#1213	escape_out ("\\u0152");
#1214	escape_out ("\\u0153");
#1215	escape_out ("\\u00C6");
#1216	escape_out ("\\u00E6");
#1219	escape_out ("$");
#1220	escape_out ("@");
#1221	escape_out ("\\u0131");
#1222	escape_out ("\\u0130");
#1223	escape_out ("i\\u0336");
#1224	escape_out ("\\u2295");
#1225	escape_out ("\\u00A9");
#1226	escape_out ("\\u2731");
#1227	escape_out ("\\u2021");
#1228	escape_out ("#1228");
#1229	escape_out ("#1229");
#1230	escape_out ("\\u25AD");
#1231	escape_out ("#1231");
#1232	escape_out ("#1232");
#1233	escape_out ("#1233");
#1312	escape_out ("M\\u2019");
#1313	escape_out ("\\u223D");
#1314	escape_out ("n\\u030A");
#1315	escape_out ("#1315");
#1316	escape_out ("\\u0292");
#1317	escape_out ("\\u02D9//.");
#1318	escape_out ("\\u223B");
#1319	escape_out ("#1319");
#1320	escape_out ("\\u0375\\u0311");
#1321	escape_out ("#1321");
#1322	escape_out ("\\u2644");
#1323	escape_out ("\\u03B6\\u0337\\u03C2\\u0300");
#1324	escape_out ("\\u03B8\\u03C2\\u0302");
#1326	escape_out ("#1326");
#1327	escape_out ("#1327");
#1328	escape_out ("#1328");
#1334	escape_out ("#1334");
#1335	escape_out ("//");
#1336	escape_out ("#1336");
#1337	escape_out (">");
#1338	escape_out ("\\u1017E");
#1340	escape_out ("\\u039D\\u03BF");
#1341	escape_out ("#1341");
#1500	escape_out ("\\u03B3\\u0374");
#1501	escape_out ("#1501");
#1502	escape_out ("\\u03A7\\u0374");
#1503	escape_out ("#1503");
#1504	escape_out ("#1504");
#1505	escape_out ("#1505");
#1506	escape_out ("\\u0300\\u030C");
#1509	escape_out ("#1509");
#1510	escape_out ("#1510");
#1511	escape_out ("#1511");
#1512	escape_out ("<");
#1513	escape_out ("\\u10175");
#1514	escape_out ("\\u00F7");
#1515	escape_out ("\\u1D20F");
#1516	escape_out ("#1516");
#1517	escape_out ("#1517");
#1518	escape_out ("\\u1D229");
#1519	escape_out ("#1519");
#1520	escape_out ("#1520");
#1521	escape_out ("\\u0222");
#1522	escape_out ("#1522");
#1523	escape_out ("\\u205B");
#1524	escape_out ("#1524");
#1525	escape_out ("#1525");
#1526	escape_out ("#1526");
#1527	escape_out ("#1527");
#1528	escape_out ("#1528");
#1529	escape_out ("\\u2227");
#1530	escape_out ("\\u2228");
#1531	escape_out ("\\u03CF");
#1532	escape_out ("\\u03D7");
#2000	escape_out ("\\u1D000");
#2001	escape_out ("\\u1D001");
#2002	escape_out ("\\u1D002");
#2003	escape_out ("\\u1D003");
#2004	escape_out ("\\u1D004");
#2005	escape_out ("\\u1D005");
#2006	escape_out ("\\u1D006");
#2007	escape_out ("\\u1D007");
#2008	escape_out ("\\u1D008");
#2009	escape_out ("\\u1D009");
#2010	escape_out ("\\u1D00A");
#2011	escape_out ("\\u1D00B");
#2012	escape_out ("\\u1D00C");
#2013	escape_out ("\\u1D00D");
#2014	escape_out ("\\u1D00E");
#2015	escape_out ("\\u1D00F");
#2016	escape_out ("\\u1D010");
#2017	escape_out ("\\u1D011");
#2018	escape_out ("\\u1D012");
#2019	escape_out ("\\u1D013");
#2020	escape_out ("\\u1D014");
#2021	escape_out ("\\u1D015");
#2022	escape_out ("\\u1D016");
#2023	escape_out ("\\u1D017");
#2024	escape_out ("\\u1D018");
#2025	escape_out ("\\u1D019");
#2026	escape_out ("\\u1D01A");
#2027	escape_out ("\\u1D01B");
#2028	escape_out ("\\u1D01C");
#2029	escape_out ("\\u1D01D");
#2030	escape_out ("\\u1D01E");
#2031	escape_out ("\\u1D01F");
#2032	escape_out ("\\u1D020");
#2033	escape_out ("\\u1D021");
#2034	escape_out ("\\u1D022");
#2035	escape_out ("\\u1D023");
#2036	escape_out ("\\u1D024");
#2037	escape_out ("\\u1D025");
#2038	escape_out ("\\u1D026");
#2039	escape_out ("\\u1D027");
#2040	escape_out ("\\u1D028");
#2041	escape_out ("\\u1D029");
#2042	escape_out ("\\u1D02A");
#2043	escape_out ("\\u1D02B");
#2044	escape_out ("\\u1D02C");
#2045	escape_out ("\\u1D02D");
#2046	escape_out ("\\u1D02E");
#2047	escape_out ("\\u1D02F");
#2048	escape_out ("\\u1D030");
#2049	escape_out ("\\u1D031");
#2050	escape_out ("\\u1D032");
#2051	escape_out ("\\u1D033");
#2052	escape_out ("\\u1D034");
#2053	escape_out ("\\u1D035");
#2054	escape_out ("\\u1D036");
#2055	escape_out ("\\u1D037");
#2056	escape_out ("\\u1D038");
#2057	escape_out ("\\u1D039");
#2058	escape_out ("\\u1D03A");
#2059	escape_out ("\\u1D03B");
#2060	escape_out ("\\u1D03C");
#2061	escape_out ("\\u1D03D");
#2062	escape_out ("\\u1D03E");
#2063	escape_out ("\\u1D03F");
#2064	escape_out ("\\u1D040");
#2065	escape_out ("\\u1D041");
#2066	escape_out ("\\u1D042");
#2067	escape_out ("\\u1D043");
#2068	escape_out ("\\u1D044");
#2069	escape_out ("\\u1D045");
#2070	escape_out ("\\u1D046");
#2071	escape_out ("\\u1D047");
#2072	escape_out ("\\u1D048");
#2073	escape_out ("\\u1D049");
#2074	escape_out ("\\u1D04A");
#2075	escape_out ("\\u1D04B");
#2076	escape_out ("\\u1D04C");
#2077	escape_out ("\\u1D04D");
#2078	escape_out ("\\u1D04E");
#2079	escape_out ("\\u1D04F");
#2080	escape_out ("\\u1D050");
#2081	escape_out ("\\u1D051");
#2082	escape_out ("\\u1D052");
#2083	escape_out ("\\u1D053");
#2084	escape_out ("\\u1D054");
#2085	escape_out ("\\u1D055");
#2086	escape_out ("\\u1D056");
#2087	escape_out ("\\u1D057");
#2088	escape_out ("\\u1D058");
#2089	escape_out ("\\u1D059");
#2090	escape_out ("\\u1D05A");
#2091	escape_out ("\\u1D05B");
#2092	escape_out ("\\u1D05C");
#2093	escape_out ("\\u1D05D");
#2094	escape_out ("\\u1D05E");
#2095	escape_out ("\\u1D05F");
#2096	escape_out ("\\u1D060");
#2097	escape_out ("\\u1D061");
#2098	escape_out ("\\u1D062");
#2099	escape_out ("\\u1D063");
#2100	escape_out ("\\u1D064");
#2101	escape_out ("\\u1D065");
#2102	escape_out ("\\u1D066");
#2103	escape_out ("\\u1D067");
#2104	escape_out ("\\u1D068");
#2105	escape_out ("\\u1D069");
#2106	escape_out ("\\u1D06A");
#2107	escape_out ("\\u1D06B");
#2108	escape_out ("\\u1D06C");
#2109	escape_out ("\\u1D06D");
#2110	escape_out ("\\u1D06E");
#2111	escape_out ("\\u1D06F");
#2112	escape_out ("\\u1D070");
#2113	escape_out ("\\u1D071");
#2114	escape_out ("\\u1D072");
#2115	escape_out ("\\u1D073");
#2116	escape_out ("\\u1D074");
#2117	escape_out ("\\u1D075");
#2118	escape_out ("\\u1D076");
#2119	escape_out ("\\u1D077");
#2120	escape_out ("\\u1D078");
#2121	escape_out ("\\u1D079");
#2122	escape_out ("\\u1D07A");
#2123	escape_out ("\\u1D07B");
#2124	escape_out ("\\u1D07C");
#2125	escape_out ("\\u1D07D");
#2126	escape_out ("\\u1D07E");
#2127	escape_out ("\\u1D07F");
#2128	escape_out ("\\u1D080");
#2129	escape_out ("\\u1D081");
#2130	escape_out ("\\u1D082");
#2131	escape_out ("\\u1D083");
#2132	escape_out ("\\u1D084");
#2133	escape_out ("\\u1D085");
#2134	escape_out ("\\u1D086");
#2135	escape_out ("\\u1D087");
#2136	escape_out ("\\u1D088");
#2137	escape_out ("\\u1D089");
#2138	escape_out ("\\u1D08A");
#2139	escape_out ("\\u1D08B");
#2140	escape_out ("\\u1D08C");
#2141	escape_out ("\\u1D08D");
#2142	escape_out ("\\u1D08E");
#2143	escape_out ("\\u1D08F");
#2144	escape_out ("\\u1D090");
#2145	escape_out ("\\u1D091");
#2146	escape_out ("\\u1D092");
#2147	escape_out ("\\u1D093");
#2148	escape_out ("\\u1D094");
#2149	escape_out ("\\u1D095");
#2150	escape_out ("\\u1D096");
#2151	escape_out ("\\u1D097");
#2152	escape_out ("\\u1D098");
#2153	escape_out ("\\u1D099");
#2154	escape_out ("\\u1D09A");
#2155	escape_out ("\\u1D09B");
#2156	escape_out ("\\u1D09C");
#2157	escape_out ("\\u1D09D");
#2158	escape_out ("\\u1D09E");
#2159	escape_out ("\\u1D09F");
#2160	escape_out ("\\u1D0A0");
#2161	escape_out ("\\u1D0A1");
#2162	escape_out ("\\u1D0A2");
#2163	escape_out ("\\u1D0A3");
#2164	escape_out ("\\u1D0A4");
#2165	escape_out ("\\u1D0A5");
#2166	escape_out ("\\u1D0A6");
#2167	escape_out ("\\u1D0A7");
#2168	escape_out ("\\u1D0A8");
#2169	escape_out ("\\u1D0A9");
#2170	escape_out ("\\u1D0AA");
#2171	escape_out ("\\u1D0AB");
#2172	escape_out ("\\u1D0AC");
#2173	escape_out ("\\u1D0AD");
#2174	escape_out ("\\u1D0AE");
#2175	escape_out ("\\u1D0AF");
#2176	escape_out ("\\u1D0B0");
#2177	escape_out ("\\u1D0B1");
#2178	escape_out ("\\u1D0B2");
#2179	escape_out ("\\u1D0B3");
#2180	escape_out ("\\u1D0B4");
#2181	escape_out ("\\u1D0B5");
#2182	escape_out ("\\u1D0B6");
#2183	escape_out ("\\u1D0B7");
#2184	escape_out ("\\u1D0B8");
#2185	escape_out ("\\u1D0B9");
#2186	escape_out ("\\u1D0BA");
#2187	escape_out ("\\u1D0BB");
#2188	escape_out ("\\u1D0BC");
#2189	escape_out ("\\u1D0BD");
#2190	escape_out ("\\u1D0BE");
#2191	escape_out ("\\u1D0BF");
#2192	escape_out ("\\u1D0C0");
#2193	escape_out ("\\u1D0C1");
#2194	escape_out ("\\u1D0C2");
#2195	escape_out ("\\u1D0C3");
#2196	escape_out ("\\u1D0C4");
#2197	escape_out ("\\u1D0C5");
#2198	escape_out ("\\u1D0C6");
#2199	escape_out ("\\u1D0C7");
#2200	escape_out ("\\u1D0C8");
#2201	escape_out ("\\u1D0C9");
#2202	escape_out ("\\u1D0CA");
#2203	escape_out ("\\u1D0CB");
#2204	escape_out ("\\u1D0CC");
#2205	escape_out ("\\u1D0CD");
#2206	escape_out ("\\u1D0CE");
#2207	escape_out ("\\u1D0CF");
#2208	escape_out ("\\u1D0D0");
#2209	escape_out ("\\u1D0D1");
#2210	escape_out ("\\u1D0D2");
#2211	escape_out ("\\u1D0D3");
#2212	escape_out ("\\u1D0D4");
#2213	escape_out ("\\u1D0D5");
#2214	escape_out ("\\u1D0D6");
#2215	escape_out ("\\u1D0D7");
#2216	escape_out ("\\u1D0D8");
#2217	escape_out ("\\u1D0D9");
#2218	escape_out ("\\u1D0DA");
#2219	escape_out ("\\u1D0DB");
#2220	escape_out ("\\u1D0DC");
#2221	escape_out ("\\u1D0DD");
#2222	escape_out ("\\u1D0DE");
#2223	escape_out ("\\u1D0DF");
#2224	escape_out ("\\u1D0E0");
#2225	escape_out ("\\u1D0E1");
#2226	escape_out ("\\u1D0E2");
#2227	escape_out ("\\u1D0E3");
#2228	escape_out ("\\u1D0E4");
#2229	escape_out ("\\u1D0E5");
#2230	escape_out ("\\u1D0E6");
#2231	escape_out ("\\u1D0E7");
#2232	escape_out ("\\u1D0E8");
#2233	escape_out ("\\u1D0E9");
#2234	escape_out ("\\u1D0EA");
#2235	escape_out ("\\u1D0EB");
#2236	escape_out ("\\u1D0EC");
#2237	escape_out ("\\u1D0ED");
#2238	escape_out ("\\u1D0EE");
#2239	escape_out ("\\u1D0EF");
#2240	escape_out ("\\u1D0F0");
#2241	escape_out ("\\u1D0F1");
#2242	escape_out ("\\u1D0F2");
#2243	escape_out ("\\u1D0F3");
#2244	escape_out ("\\u1D0F4");
#2245	escape_out ("\\u1D0F5");
#2300	escape_out ("#2300");
.	{
	   if (escaped_last == 1) {
              fputc ('}', yyout);
              escaped_last = 0;
           }
	   fprintf (yyout, "%s", yytext);
	}
%%

int
main (int argc, char *argv[])
{
   int i;            /* loop variable       */
   int exit_status;  /* program exit status */

   void print_help ();

   exit_status = EXIT_SUCCESS;
   yyin  = stdin;
   yyout = stdout;

   for (i = 1; i < argc; i++) {
      /*
         Parse options.  If an invalid command line argument
         was given, print a help menu and exit with error status.
      */
      if (argv[i][0] == '-') {
         switch (argv[i][1]) {
            case 'i': yyin  = fopen (argv[++i], "r");
                      break;
                      /*
                         output file format; file name follows
                         in next parameter, so increment i
                      */
            case 'o': yyout = fopen (argv[++i], "w");
                      break;
            default:  print_help ();
                      exit_status = EXIT_FAILURE;
                      break;
         }
      }
      else {
         print_help ();
         exit_status = EXIT_FAILURE;
      }
   }

   if (exit_status == EXIT_SUCCESS) {
      yylex ();

      /*
         Done reading output.  End an escape sequence
         if that was the last thing output.
      */
      if (escaped_last == 1) {
         fputc ('}', yyout);
         escaped_last = 0;
      }
   }

   exit (exit_status);
}


/*
   Print a help message.  The parameter is the program name,
   taken from argv[0].
*/
void
print_help ()
{

   fprintf (stderr, "\nUnknown command line parameter.\n\n");
   fprintf (stderr, "Syntax: %s [-i input_file] [-o output_file]\n\n",
            PROG_NAME);
   fprintf (stderr, "    -i: specify input file name\n\n");
   fprintf (stderr, "    -o: specify output file name\n\n");

   return;
}


/*
   Print an escaped sequence.  Such sequences are enclosed in
   ASCII braces ("{...}").  Multiple such escape sequences
   back to back can be joined into one, so keep track of
   whether or not the last thing we printed was also an
   escape sequence.  If it was, combine the last escape
   sequence with the current one; generate consolidated
   sequence output of the form

        "{\u....\u....\u....}"

   rather than

       "{\u....}{\u....}{\u....}"
*/
void
escape_out (char *escaped_text)
{

   if (escaped_last == 0) {
      fputc ('{', yyout);  /* start a new escape string */
   }
   fprintf (yyout, "%s", escaped_text);
   escaped_last = 1;

   return;
}

