/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2022-2023 KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * This File Copy From Kylin-nm Modify by zhaikangning <zhaikangning@kylinos.cn> 2023.8.1
 */
#include "divider.h"
#include <QPainter>
#include <QApplication>
#include <QGSettings>
#define THEME_SCHAME "org.ukui.style"
#define COLOR_THEME "styleName"

Divider::Divider(bool useLightPal, QWidget * parent)
    :m_useLightPal(useLightPal),
     QFrame(parent)
{
    /**修改主题时paletteChanged 信号并未触发，这里注释掉并监听主题GSettings进行palette的更新**/
    //connect(qApp, &QApplication::paletteChanged, this ,&Divider::onPaletteChanged);

    onPaletteChanged();
    const QByteArray id("org.ukui.style");
    if (QGSettings::isSchemaInstalled(id)) {
        QGSettings *styleGsettings = new QGSettings(id, QByteArray(), this);
        connect(styleGsettings, &QGSettings::changed, [=](const QString key){
            if ((key.compare("style-name") == 0) || (key.compare("styleName") == 0)) {
                onPaletteChanged();
            }
        });
    }
}

void Divider::onPaletteChanged()
{
    QPalette pal = qApp->palette();
    m_color = pal.color(QPalette::BrightText);
    m_color.setAlphaF(0.08);
    update();
}

void Divider::paintEvent(QPaintEvent * e)
{
    QPainter p(this);
    p.save();
    p.setBrush(m_color);
    p.setPen(Qt::transparent);
    p.drawRoundedRect(this->rect(), 0, 0);
    p.restore();
    return QFrame::paintEvent(e);
}
