/* Copyright (c) 2003-2004 Ecole centrale de Lyon
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "fdtd3d.h"
#include <stdio.h>
#include <stdlib.h>
#include "init.h"
#include "simul.h"
#include "utils.h"
#ifdef HAVE_MPI
#include <mpi.h>
#endif

#ifdef HAVE_MPI
#define SEXY "orgy"
#else // HAVE_MPI
#ifdef HAVE_FFTW3
#define SEXY "yes"
#else
#define SEXY "no"
#endif // HAVE_FFTW3
#endif // HAVE_MPI

void usage(char *foobar)
{
  printf("Usage : %s file.fdtd\n",foobar);
#ifdef HAVE_MPI
  MPI_Abort(MPI_COMM_WORLD,1);
#endif
  exit(1);
}

int main(int argc, char **argv)
{
  SimulDesc *simul;

#ifdef HAVE_MPI
  int mpi_node;

  MPI_Init(&argc, &argv);
  MPI_Comm_rank(MPI_COMM_WORLD, &mpi_node);
#endif // HAVE_MPI

#ifdef HAVE_MPI
  if(mpi_node==0)
#endif
    {
      if(argc<2)
	usage(argv[0]);
      printf("<Tessa> ASV: %s / %s / %s\n",__DATE__,SEXY,VERSION);
    }

#ifdef HAVE_MPI
  if(mpi_node)
    simul = alloc_simuldesc();
  else
#endif // HAVE_MPI
    simul = read_simul(argv[1]);

#ifdef HAVE_MPI
  simul=broadcast_simuldesc(simul);
#endif

  if(simul==NULL)
    {
#ifdef HAVE_MPI
      if(mpi_node==0)
#endif
	printf("%s: error while reading simulation file\n",argv[1]);
      return -1;
    }

  RunSimul(simul);

#ifdef HAVE_MPI
  MPI_Finalize();
#endif

  return 0;
}
