/* Copyright 2023 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

#ifndef TENSORFLOW_COMPILER_XLA_MLIR_BACKENDS_OPENXLA_CONVERSION_CONVERT_WHILE_OP_H_
#define TENSORFLOW_COMPILER_XLA_MLIR_BACKENDS_OPENXLA_CONVERSION_CONVERT_WHILE_OP_H_

#include "mlir/IR/PatternMatch.h"  // from @llvm-project
#include "mlir/Transforms/DialectConversion.h"  // from @llvm-project
#include "tensorflow/compiler/xla/mlir/backends/openxla/conversion/de_bufferization.h"
#include "tensorflow/compiler/xla/mlir/backends/openxla/conversion/xla_gpu_api.h"

namespace xla {
namespace gpu {

// Appends patterns to convert while loops to scf.while operations and IREE HAL
// to load predicate from device buffer (HAL backend).
void populateWhileOpConversionPatterns(mlir::RewritePatternSet &patterns,
                                       mlir::TypeConverter &converter,
                                       DeBufferization &state);

// Appends patterns to convert while loops to scf.while operations and XLA:GPU
// API to load predicate from device buffer (StreamExecutor backend).
void populateWhileOpConversionPatterns(mlir::RewritePatternSet &patterns,
                                       mlir::TypeConverter &converter,
                                       DeBufferization &state, XlaGpuApi &api);

}  // namespace gpu
}  // namespace xla

#endif  // TENSORFLOW_COMPILER_XLA_MLIR_BACKENDS_OPENXLA_CONVERSION_CONVERT_WHILE_OP_H_
