; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -mtriple=aarch64-- -mcpu=falkor -O0 -aarch64-enable-atomic-cfg-tidy=0 -stop-after=irtranslator -global-isel -verify-machineinstrs %s -o - | FileCheck %s

define void @store_nontemporal(i32* dereferenceable(4) %ptr) {
  ; CHECK-LABEL: name: store_nontemporal
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x0
  ; CHECK:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; CHECK:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; CHECK:   G_STORE [[C]](s32), [[COPY]](p0) :: (non-temporal store (s32) into %ir.ptr)
  ; CHECK:   RET_ReallyLR
  store i32 0, i32* %ptr, align 4, !nontemporal !0
  ret void
}

define void @store_dereferenceable(i32* dereferenceable(4) %ptr) {
  ; CHECK-LABEL: name: store_dereferenceable
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x0
  ; CHECK:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; CHECK:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; CHECK:   G_STORE [[C]](s32), [[COPY]](p0) :: (store (s32) into %ir.ptr)
  ; CHECK:   RET_ReallyLR
  store i32 0, i32* %ptr, align 4
  ret void
}

define void @store_volatile_dereferenceable(i32* dereferenceable(4) %ptr) {
  ; CHECK-LABEL: name: store_volatile_dereferenceable
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x0
  ; CHECK:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; CHECK:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; CHECK:   G_STORE [[C]](s32), [[COPY]](p0) :: (volatile store (s32) into %ir.ptr)
  ; CHECK:   RET_ReallyLR
  store volatile i32 0, i32* %ptr, align 4
  ret void
}

define void @store_falkor_strided_access(i32* %ptr) {
  ; CHECK-LABEL: name: store_falkor_strided_access
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x0
  ; CHECK:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; CHECK:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; CHECK:   G_STORE [[C]](s32), [[COPY]](p0) :: ("aarch64-strided-access" store (s32) into %ir.ptr)
  ; CHECK:   RET_ReallyLR
  store i32 0, i32* %ptr, align 4, !falkor.strided.access !0
  ret void
}

!0 = !{}
