/* ====================================================================
 * Copyright (c) 2007,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_REVISION_FACTORY_H
#define _SVN_REVISION_FACTORY_H

// sc
#include "Revision.h"

// svn
struct svn_opt_revision_t;


namespace svn
{

class RevisionFactory
{
public:
  /** Create a Revision object from the given subversiob revision @a svnrev. */
  static Revision* toRevision( const svn_opt_revision_t* svnrev );

  /** Fills a subversionb revision @svnrev from the Revision object @a rev. */
  static void toSvnRevision( const Revision* rev, svn_opt_revision_t* svnrev );

private:
  RevisionFactory();
};


} // namespace


#endif //  _SVN_REVISION_FACTORY_H

