/* ====================================================================
 * Copyright (c) 2003-2006, 2008  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "Line.h"

Line::Line() : _blockNumber(0), _type(ctNop)
{
}

Line::Line( const Line& src )
: _line(src._line), _blockNumber(src._blockNumber), _type(src._type)
{
}

Line::Line( const sc::String &line, int blockNumber, ConflictType type )
: _line(line), _blockNumber(blockNumber), _type(type)
{
}

const sc::String& Line::getLine() const
{
  return _line;
}

const char* Line::getStr() const
{
  return _line.getStr();
}

size_t Line::getChars() const
{
  return _line.getCharCnt();
}

size_t Line::getBytes() const
{
  return _line.getByteCnt();
}

int Line::getBlockNr() const
{
  return _blockNumber;
}

ConflictType Line::getType() const
{
  return _type;
}

bool Line::isEmpty() const
{
  return (_type == ctNop) || (((ctFlagEmpty) & _type) == ctFlagEmpty);
}

bool Line::isCommon() const
{
  return _type == ctCommon;
}

bool Line::isDifference() const
{
  return (_type != ctNop) && (_type != ctCommon);
    
    //|| (_type != ctCommon) || (((ctFlagEmpty) & _type) == ctFlagEmpty);
}


Line Line::_empty;
const Line& Line::getEmpty()
{
  return _empty;
}

Line Line::_empty2(_empty.getLine(),0,ctCommon);
const Line& Line::getEmpty2()
{
  return _empty2;
}
