/* ------------------------------------------------------------------------ */
/*                                                                          */
/* [binimg.h]    Portable machine-independant binary format                 */
/*                                                                          */
/* Copyright (c) 1993 by Lars D\olle, Heike Manns                           */
/* ------------------------------------------------------------------------ */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef binimg_INCL
#define binimg_INCL


#include "standard.h"
#include "symbols.h"


#ifdef __cplusplus
extern "C" {
#endif


/*  
  Summary

  [binimg] offers a set of functions to read and write binary files in a portable
  machine-independant format. Within the STYX-system they are used to make data structures
  persistent.

  non-reentrant API:

  For each supported data type exist a read and write function with the following signature.

  |   void put<TYPE>(<CTYPE>  x);
  |   void get<TYPE>(<CTYPE> &x);

  Source and target are implicit in these operations. The functions 'getBgn' and 'getEnd'
  open and close a source. To open and close a target one has to use the functions 'putBgn'
  and 'putEnd'. So it is not possible to read or write more than one file at a time.

  reentrant API:

  For each supported data type exist a read and write function with the following signature.

  |   void fput<TYPE>(BinImg_T img, <CTYPE>  x);
  |   void fget<TYPE>(BinImg_T img, <CTYPE> &x);

  The functions 'fgetBgn' and 'fgetEnd' open and close a source. To open and close a target
  one has to use the functions 'fputBgn' and 'fputEnd'. So it is possible to read or write
  more than one file at a time.

  Each binary file within the STYX-system starts with a header block. Creation and reading
  e.g. checking is done by the functions 'putHeader' and 'getHeader' respectively
  'fputHeader' and 'fgetHeader'.

  The binary files are protected against unauthorized reading and writing by an integrated
  combined encryption and checking method. Further more they will be compressed.
*/

/*  
  Files and EOF

  With the non-reentrant API it is not possible to read or write more than one file at a time.

  This module doesn't support an explicit EOF-predicate. It is the responsibility of the user
  to check for EOF. Reading behind EOF causes the program to abort with an error message.
*/

AbstractType( BinImg_T ) /* Abstract binary image type */
;

BinImg_T BIN_getCurImage(void);                   /* get current image      */
void     BIN_setIncEvent(void (*evt)(float lvl)); /* set the get-inc event  */

void fBIN_setIncEvent(BinImg_T img,void (*evt)(float lvl))
/* set the get-inc event for binary image 'img' */
;


/* ----------------------------- Open & Close --------------------------------- */

void putBgn(c_string EnvVar, c_string FileName, c_string Ext)
/* open [$'EnvVar'/'FileName''Ext'] to put binary image */
;

BinImg_T fputBgn(c_string EnvVar, c_string FileName, c_string Ext)
/* open [$'EnvVar'/'FileName''Ext'] to put binary image (reentrant) */
;

BinImg_T TryfputBgn(c_string EnvVar, c_string FileName, c_string Ext)
/* tries to open [$'EnvVar'/'FileName''Ext'] to put binary image (reentrant);
   returns NULL in the case of an invalid path
*/
;

void getBgn(c_string EnvVar, c_string FileName, c_string Ext)
/* open [$'EnvVar'/'FileName''Ext'] to get binary image */
;

BinImg_T fgetBgn(c_string EnvVar, c_string FileName, c_string Ext)
/* open [$'EnvVar'/'FileName''Ext'] to get binary image (reentrant) */
;

BinImg_T TryfgetBgn(c_string EnvVar, c_string FileName, c_string Ext)
/* tries to open [$'EnvVar'/'FileName''Ext'] to get binary image (reentrant);
   returns NULL in the case of an invalid path
*/
;

void putEnd(void);                     /* completes binary puting           */

void fputEnd(BinImg_T img)
/* completes puting to binary image 'img';
   frees 'img' (reentrant) */
;

void getEnd(void);                     /* completes binary geting           */

void fgetEnd(BinImg_T img)
/* completes geting from binary image 'img';
   frees 'img' (reentrant) */
;


/* -------------------------------- Header ------------------------------------------ */

/*  
  There are a lot of reasons to save some informations at the beginning of such a file.

  Beside a short text describing the content of the file, the user want to be sure that
  the file has the expected format. Following an old tradition this will be done by a
  'Magic'.

  To handle format changes of binary files we introduce a version. The version consists
  of two numbers ('Major', 'Minor'). Binary formats with different major-numbers are
  treated as incompatible. Binary formats with different minor-numbers are treated as
  upward compatible.

  Furthermore this module has an internal version number to track changes of the internal
  format.

  Contrary to the external representation the title will be be saved as null-terminated
  string.

  'getHeader' respectively 'fgetHeader' checks these informations and aborts the operation
  in the case of an error. During the read or write process the current minor-version is
  accessable via the function 'MinorVersion' respectively 'fMinorVersion'.
*/

void putHeader(c_string Title, c_string Magic, c_byte Major, c_byte Minor)
/* put header */
;

void fputHeader
     (
       BinImg_T img, c_string Title, c_string Magic, c_byte Major, c_byte Minor
     )
/* put header to binary image 'img' (reentrant) */
;

void getHeaderInfo(c_string *Com, c_string *Mag, c_byte *Ma, c_byte *Mi, c_byte *Bv)
/* get header information ( title,magic,major,minor,version ) */
;

void fgetHeaderInfo
     (
       BinImg_T img, c_string *Com, c_string *Mag,
       c_byte *Ma, c_byte *Mi, c_byte *Bv
     )
/* get header information ( title,magic,major,minor,version )
   from binary image 'img' (reentrant) */
;

void getHeader(c_string Magic, c_byte Major, c_byte Minor)
/* validates header */
;

void fgetHeader(BinImg_T img, c_string Magic, c_byte Major, c_byte Minor)
/* validates header of binary image 'img' (reentrant) */
;

void getHeaderTitle(c_string Magic, c_byte Major, c_byte Minor, c_string* Title)
/* validates header, returns title */
;

void fgetHeaderTitle
     (
       BinImg_T img, c_string Magic, c_byte Major, c_byte Minor, c_string* Title
     )
/* validates header, returns title of binary image 'img' (reentrant) */
;

short MinorVersion(void);          /* 'Minor' of the file                   */
short fMinorVersion(BinImg_T img); /* 'Minor' of the file 'img' (reentrant) */

/* ============================= Data types =============================== */

/*  
  Actually the following data types are supported.

  | TYPE      | CTYPE                  |
  +-----------+------------------------+----------------------------
  | Byte      | unsigned char          |
  | Word      | unsigned short int     |   Intrinsic C-data types
  | Long      | signed long int        |
  | ULong     | unsigned long int      |
  | Int64     | signed long long int   | if supported type
  | UInt64    | unsigned long long int | if supported type
  +-----------+------------------------+----------------------------
  | String    | (char *)               |   Strings
  | WC-String | (wchar_t *)            |   Unicode Strings
  | Binary    | c_bstring              |   binary Strings
  | Symbol    | symbol                 |   Symbols
  | Function  | (? (*)())              |   Functions
  | Abstract  | (?)                    |   "Objects"
  | StdCPtr   | (?*)                   |   References
*/

/* ----------------------------- Plain values ----------------------------- */

void putByte(c_byte v);                /* put 'v' to file                   */
void fputByte(BinImg_T img, c_byte v); /* put 'v' to file 'img' (reentrant) */
void getByte(c_byte *v);               /* get 'v' from file                 */

void fgetByte(BinImg_T img, c_byte *v)
/* get 'v' from file 'img' (reentrant) */
;

int  getByte_or_EOF(void);             /* get byte or EOF from file         */

int fgetByte_or_EOF(BinImg_T img)
/* get byte or EOF from file 'img' (reentrant) */
;

void putWord(short v);                 /* put 'v' to file; msb first        */

void fputWord(BinImg_T img, short v)
/* put 'v' to file 'img'; msb first (reentrant) */
;

void getWord(short *v);                /* get 'v' from file; msb first      */

void fgetWord(BinImg_T img, short *v)
/* get 'v' from file 'img'; msb first (reentrant) */
;

void putLong(long v);           /* put 'v' ( <= 32 Bit ) to file; msw first */

void fputLong(BinImg_T img, long v)
/* put 'v' ( <= 32 Bit ) to file 'img'; msw first (reentrant) */
;

void getLong(long *v);          /* get 'v' from file; msw first             */

void fgetLong(BinImg_T img, long *v)
/* get 'v' from file 'img'; msw first (reentrant) */
;

void putULong(unsigned long v); /* put 'v' ( <= 32 Bit ) to file; msw first */

void fputULong(BinImg_T img, unsigned long v)
/* put 'v' ( <= 32 Bit ) to file 'img'; msw first (reentrant) */
;

void getULong(unsigned long *v);     /* get 'v' from file; msw first        */

void fgetULong(BinImg_T img, unsigned long *v)
/* get 'v' from file 'img'; msw first (reentrant) */
;

void putInt(int v);                  /* put 'v' ( <= 16 Bit ) to file       */

void fputInt(BinImg_T img, int v)
/* put 'v' ( <= 16 Bit ) to file 'img' (reentrant) */
;

void getInt(int* v);                 /* get 'v' from file                   */
void fgetInt(BinImg_T img, int* v);  /* get 'v' from file 'img' (reentrant) */

#ifdef STYX_CONFIG_TINT64

void putInt64(c_int64 v);       /* put 'v' ( <= 64 Bit ) to file; msl first */

void fputInt64(BinImg_T img, c_int64 v)
/* put 'v' ( <= 64 Bit ) to file 'img'; msl first (reentrant) */
;

void getInt64(c_int64 *v);      /* get 'v' from file; msl first             */

void fgetInt64(BinImg_T img, c_int64 *v)
/* get 'v' from file 'img'; msl first (reentrant) */
;

void putUInt64(c_uint64 v);     /* put 'v' ( <= 64 Bit ) to file; msl first */

void fputUInt64(BinImg_T img, c_uint64 v)
/* put 'v' ( <= 64 Bit ) to file 'img'; msl first (reentrant) */
;

void getUInt64(c_uint64 *v);    /* get 'v' from file; msl first             */

void fgetUInt64(BinImg_T img, c_uint64 *v)
/* get 'v' from file 'img'; msl first (reentrant) */
;


#endif

void putString(c_string v);           /* put 'v' to file; length byte first */

void fputString(BinImg_T img, c_string v)
/* put 'v' to file 'img'; length byte first (reentrant) */
;

void getString(c_string *v)
/* get 'v' from file; length first; allocs memory */
;

void fgetString(BinImg_T img, c_string *v)
/* get 'v' from file 'img'; length first; allocs memory (reentrant) */
;

void putWCString(wc_string v);        /* put 'v' to file; length byte first */

void fputWCString(BinImg_T img, wc_string v)
/* put 'v' to file 'img'; length byte first (reentrant) */
;

void getWCString(wc_string *v)
/* get 'v' from file; length first; allocs memory */
;

void fgetWCString(BinImg_T img, wc_string *v)
/* get 'v' from file 'img'; length first; allocs memory (reentrant) */
;

void putBString(c_bstring v);         /* put 'v' to file                    */

void fputBString(BinImg_T img, c_bstring v)
/* put 'v' to file 'img' (reentrant) */
;

void getBString(c_bstring *v);        /* get 'v' from file; allocs memory   */

void fgetBString(BinImg_T img, c_bstring *v)
/* get 'v' from file 'img'; allocs memory (reentrant) */
;


/* ----------------------------- Huge binaries ------------------------------- */

/* 
  To save and load large binary data blocks the following functions can be used.
*/

void putHuge(HugeCPtr v, long len);    /* put 'len' bytes to file           */

void fputHuge(BinImg_T img, HugeCPtr v, long len)
/* put 'len' bytes to file 'img' (reentrant) */
;

void getHuge(HugeCPtr *v, long *len);  /* get 'len' bytes from file         */

void fgetHuge(BinImg_T img, HugeCPtr *v, long *len)
/* get 'len' bytes from file 'img' (reentrant) */
;


/* -------------------------------- Symbols ------------------------------- */

/* 
  Symbols are externally represented as ( binary ) strings.
  <br>The leading byte specifies the symbol type.
*/

void putSymbol(symbol v);                /* put a symbol to file            */
void fputSymbol(BinImg_T img, symbol v); /* put a symbol to file            */
void getSymbol(symbol *v);               /* get a symbol from file          */

void fgetSymbol(BinImg_T img, symbol *v)
/* get a symbol from file 'img' (reentrant) */
;


/* ------------------------------- Functions ------------------------------ */

/* 
   For technical reasons the functions must be defined in a global table.<br>
   They are externally represented by a symbolic name representing the key
   to the function table entry. ( see also <a href="glo_tab.htm">[glo_tab]</a> )
*/

void putFunction(StdCPtr v)
/* put a function to file
   raises error if 'v' not 'Glo'bally defined
*/
;

void fputFunction(BinImg_T img, StdCPtr v)
/* put a function to file 'img' (reentrant)
   raises error if 'v' not 'Glo'bally defined
*/
;

void getFunction(StdCPtr *v)
/* get a function from file
   raises error if 's' not 'Glo'bally defined
*/
;

void fgetFunction(BinImg_T img, StdCPtr *v)
/* get a function from file 'img' (reentrant)
   raises error if 's' not 'Glo'bally defined
*/
;


/* ---------------------------- Abstract types ---------------------------- */

/*  
   In the case of a generic data type ( e.g. 'List(Alpha)') a 'put'-function
   typically looks like:

   non-reentrant API:
   |  void putList(List(Alpha) v, void putAlpha(Alpha v))
   |  {
   |    putInt(List_length(v));
   |    for (; !List_null(v); v = List_rest(v))
   |      putAlpha(List_first(Alpha,v));
   |  }

   reentrant API:
   |  void putList(BinImg_T img, List(Alpha) v, void putAlpha(BinImg_T img,Alpha v))
   |  {
   |    fputInt(img,List_length(v));
   |    for (; !List_null(v); v = List_rest(v))
   |      putAlpha(img,List_first(Alpha,v));
   |  }

   In the case of a heterogen parameter type ("Object") the user has to save
   the corresponding 'get'-function together with the value.
*/

void putAbstract(Abs_T v, void putData(Abs_T v), void getData(Abs_T *v))
/* put abstract data to file */
;

void fputAbstract
     (
       BinImg_T img, Abs_T v,
       void putData(BinImg_T img,Abs_T v),
       void getData(BinImg_T img,Abs_T *v)
     )
/* put abstract data to file 'img' (reentrant) */
;

void getAbstract(Abs_T *v);            /* get abstract data from file       */

void fgetAbstract(BinImg_T img, Abs_T *v)
/* get abstract data from file 'img' (reentrant) */
;


/* -------------------------------- Pointer ------------------------------------------- */

/*  
   References to multiple or cyclic referenced structures ( except symbols and functions )
   can't be simply expanded if the representation should be unique.
   For cases like this we support the following function.

   non-reentrant API:
   |  void putReference(Abs_T  v, void putData(Abs_T v));

   reentrant API:
   |  void fputReference(BinImg_T img, Abs_T  v, void putData(BinImg_T img,Abs_T v));

   This function outputs a reference number for this structure and only in the case of the
   first reference the structure values.
*/

void putReference(Abs_T v, void putData(Abs_T v)); /* put a pointer to file */

void fputReference
     (
       BinImg_T img, Abs_T v, void putData(BinImg_T img,Abs_T v)
     )
/* put a pointer to file 'img' (reentrant) */
;

void getReference(Abs_T *v, void getData(Abs_T *v))
/* get a pointer from file */
;

void fgetReference
     (
       BinImg_T img, Abs_T *v, void getData(BinImg_T img,Abs_T *v)
     )
/* get a pointer from file 'img' */
;



#ifdef __cplusplus
}
#endif

#endif
