# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
# Copyright 2012 Canonical
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.

"""Share-app autopilot tests."""

import os

from autopilot.input import Mouse, Touch, Pointer
from autopilot.platform import model
from autopilot.testcase import AutopilotTestCase

from share_app.emulators.main_window import MainWindow

class ShareAppTestCase(AutopilotTestCase):

    """A common test case class that provides several useful methods for tests."""

    if model() == 'Desktop':
        scenarios = [
        ('with mouse', dict(input_device_class=Mouse)),
        ]
    else:
        scenarios = [
        ('with touch', dict(input_device_class=Touch)),
        ]

    local_location = "../../share-app"

    def setUp(self):
        self.pointing_device = Pointer(self.input_device_class.create())
        super(ShareAppTestCase, self).setUp()
        
        if os.path.exists(self.local_location):
            self.launch_test_local()
        else:
            self.launch_test_installed()

    def launch_test_local(self):
        self.app = self.launch_test_application(
            "../../share-app")

    def launch_test_installed(self):
        if model() == 'Desktop':
            self.app = self.launch_test_application(
                "share-app"
                )
        else:
            self.app = self.launch_test_application(
                "share-app",
                "--desktop_file_hint=/usr/share/applications/share-app.desktop",
                app_type='qt')

    @property
    def main_window(self):
        return MainWindow(self.app)
