// Copyright (C) 1999-2015
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __polygon_h__
#define __polygon_h__

#include "marker.h"
#include "list.h"

class Polygon : public Marker {
 protected:
  List<Vertex> vertex;

  void renderX(Drawable, Coord::InternalSystem, RenderMode);
  void renderPS(int);
#ifdef MAC_OSX_TK
  void renderMACOSX();
#endif
#ifdef __WIN32
  void renderWIN32();
#endif

  void updateHandles();

  void moveVertex(const Vector&, int);
  void recalcCenter();

  int isInRef(const Vector& v);

public:
  Polygon(Base* p, const Vector& ctr,
	  const Vector& b);
  Polygon(Base* p, const Vector& ctr,
	  const Vector& b,
	  const char* clr, int* dsh,
	  int wth, const char* fnt, const char* txt,
	  unsigned short prop, const char* cmt,
	  const List<Tag>& tg, const List<CallBack>& cb);
  Polygon(Base* p, const List<Vertex>& v, 
	  const char* clr, int* dsh,
	  int wth, const char* fnt, const char* txt,
	  unsigned short prop, const char* cmt,
	  const List<Tag>& tg, const List<CallBack>& cb);
  Polygon(const Polygon&);

  virtual Marker* dup() {return new Polygon(*this);}
  void updateCoords(const Matrix&);

  void edit(const Vector&, int);
  void rotate(const Vector&, int);

  void analysis(AnalysisTask, int);
  void analysisHistogram(char*, char*, int);
  void analysisPlot3d(char*, char*, Coord::CoordSystem, Marker::AnalysisMethod);
  void analysisStats(Coord::CoordSystem, Coord::SkyFrame sky);

  void createVertex(int, const Vector&);
  void deleteVertex(int);
  int getSegment(const Vector&);
  void reset(const Vector&);

  int isIn(const Vector& vv) {return isIn(vv, Coord::CANVAS);}
  int isIn(const Vector& vv, Coord::InternalSystem sys)
  {return isInRef(bckMap(vv,sys));}

  int isIn(const Vector& vv, const Matrix& bck)
  {return isInRef(vv*bck);}

  void list(ostream&, Coord::CoordSystem, Coord::SkyFrame, Coord::SkyFormat, int, int);
  void listXML(ostream&, Coord::CoordSystem, Coord::SkyFrame, Coord::SkyFormat);
  virtual void listCiao(ostream&, Coord::CoordSystem, int);
  virtual void listSAOtng(ostream&, Coord::CoordSystem, Coord::SkyFrame, Coord::SkyFormat, int);
  virtual void listSAOimage(ostream&, int);
  virtual void listPros(ostream&, Coord::CoordSystem, Coord::SkyFrame, Coord::SkyFormat, int);
};

#endif
