#!/bin/sh
[ "$1" = "-h" ] && cat <<tac

This example tests the following features of the sanitizer:

  - top-level Base64 handling
  - forcing inline logs (or not)

tac

rm -f test.log test.out
touch test.log test.out

export BASE64_DATA="\
DQoNCg0KAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAJAAAAPgAAACAAAAADAAAAXgAA//BASE64
AA8AAAACAAAAbQAAH35KUEVHUGhGbAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADIw//BASE64
6gVnJK8bZBOD1Fak9o9rKxGSuaqTWxYb41+Xvz0rupyja3Q9KlKHLZbD7e5dJVJO//BASE64
Rmumt1V48H5t44Fc1YWMt3KkMalnJ4A/XPpgc57VV17xxJp8b2Xh2aGeVMK2ohC6//BASE64
qwPIiUjB6ffIOedoGAx9XLeHsZndb2eFVkvik9l/m/JHz+e5nhcugpVZavZLdm/P//BASE64
awabBJJqNxDZQN8yNO2C49VQAsw5/hBrBufE/h6CZmikvrxgcgR26pHJ7h2bcB6E//BASE64
p+FcXNcz3aNPetLJPKctM7bizY6knBJ9c/ypTGiErKoIxjep7/UDmv17A8AZZh4///BASE64
7S5VZetl8kv1bPzPFcaZhOT9ilBfe/x0/A65PGen+VJcHQL5ooSolcXqsqZPBP7k//BASE64
Y/E1s2vjHw9clEM91auy53XFv+7U+mUZmP8A3z+VecpbqxBQfLkEHbnac9+P881I//BASE64
dzbk4E0Lh0HTAOPunkcNg89KoSu2RnOK4zT7m5splurKaSGdcBXQkZ56HjkHHIPB//BASE64
"

BINFALSE=/bin/false
[ -x /usr/bin/false ] && BINFALSE=/usr/bin/false
export BINFALSE

for FLI in 0 1 2; do
    echo "Setting feat_log_inline = $FLI" >>test.out
    $ANOMY/bin/sanitizer.pl -nofprot $SAN_CONF \
                            "header_rev = 0" \
			    "feat_testing = 1" \
			    "feat_log_trace = 1" \
	   	            "feat_log_inline = $FLI" \
			    'file_list_rules = 1' \
			    'file_name_tpl = /tmp/att-$F' \
			    "file_list_1_scanner = 0:1::$BINFALSE" \
			    'file_list_1_policy = unknown:unknown:unknown:unknown' \
			    'file_list_1 = .exe$' \
	 		    <<EOF 2>>test.log |sed -e "s,$BINFALSE,/bin/false,g" >>test.out
From xxx@example.com  Thu Aug  3 07:32:10 2000
Return-Path: <xxx@example.com>
Received: from example.com (root@example.com [149.144.245.5])
	by example.com (8.9.3/8.9.3) with ESMTP id HAA01305
	for <bre@example.com>; Thu, 3 Aug 2000 07:32:03 GMT
From: xxx@example.com
Date: Thu, 3 Aug 2000 06:39:59 GMT
Message-Id: <200008030639.GAA23780@example.com>
MIME-Version: 1.0
Sender: xxx@example.com
To: fake@example.com
Subject: Clean multipart/mixed test case
Content-Type: application/applefile; x-mac-creator="5068466C"; x-mac-type="4A504547"
Content-Disposition: attachment; filenamE="evil.exe"
Content-Transfer-Encoding: base64

$BASE64_DATA
$BASE64_DATA
$BASE64_DATA
$BASE64_DATA
$BASE64_DATA
$BASE64_DATA
$BASE64_DATA
$BASE64_DATA
$BASE64_DATA
$BASE64_DATA
$BASE64_DATA
$BASE64_DATA
$BASE64_DATA
$BASE64_DATA
///BASE64///

EOF
    echo -n "Total base64 encoded data: " >>test.out
    grep '//BASE64' <test.out  | wc       >>test.out
    echo "*** Exit code was $? ***"       >>test.out
done
