#%/////////////////////////////////////////////////////////////////////////////
#
# Simple_Identity_Management RPM spec file
#
#%/////////////////////////////////////////////////////////////////////////////


%define packageVersion 1
Version: %{version}
Release: %{packageVersion}%{?dist}

Vendor:    OpenDRIM
Summary:   OpenDRIM Simple_Identity_Management Provider
Name:      opendrim-lmp-simpleidentitymanagement
Group:     Systems Management/Base
License:   GPL
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
URL:       http://opendrim.sourceforge.net

Source:    %{name}-%{version}.tar.gz

BuildRequires: autoconf, tog-pegasus-devel, libopendrim >= 1.1.1
Requires: tog-pegasus, libopendrim >= 1.1.1



%description



%global PEGASUS_ARCH_LIB %{_lib}
%global COMMONLIBDIR /usr/%PEGASUS_ARCH_LIB
%global PROVIDERDIR %COMMONLIBDIR/Pegasus/providers
%global OPENDRIM_REG_DIR /usr/share/OpenDRIM
%global OPENDRIM_MOF_DIR /usr/share/OpenDRIM/%{name}/mof
%global PROVIDER_SCRIPT_POST Simple_Identity_Management
%global CIMNAMESPACE %{?CIM_NAMESPACE:%{CIM_NAMESPACE}}%{!?CIM_NAMESPACE:root/cimv2}
%global CIMSERVER pegasus
%global INTEROPNAMESPACE root/interop

%prep
%setup -q -n %{name}-%{version}

%build
autoreconf --install --force
./configure CIMSERVER=%CIMSERVER CIMNAMESPACE=%CIMNAMESPACE INTEROPNAMESPACE=%INTEROPNAMESPACE --prefix=/usr
make 

%pre
SERVICE='cimserver'

if !(ps ax | grep -v grep | grep $SERVICE > /dev/null)
then
    echo "$SERVICE is not running"
    exit 1
fi

%install
make install COMMONLIBDIR=$RPM_BUILD_ROOT%COMMONLIBDIR PROVIDERDIR=$RPM_BUILD_ROOT%PROVIDERDIR
%{__install} -d -m 744 $RPM_BUILD_ROOT%OPENDRIM_REG_DIR/%{name}/registration
%{__install} -p -m 644 registration/*.sh $RPM_BUILD_ROOT%OPENDRIM_REG_DIR/%{name}/registration
%{__install} -d -m 744 $RPM_BUILD_ROOT%OPENDRIM_MOF_DIR/
%{__install} -p -m 644 mof/*.mof $RPM_BUILD_ROOT%OPENDRIM_MOF_DIR/

%post
%OPENDRIM_REG_DIR/%{name}-%{version}-script/%PROVIDER_SCRIPT_POST.sh %CIMNAMESPACE %{vendor} %CIMSERVER %INTEROPNAMESPACE %{version}

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && %{__rm} -rf $RPM_BUILD_ROOT;
[ "${RPM_BUILD_DIR}" != "/" ] && %{__rm} -rf ${RPM_BUILD_DIR}/%{name}-%{version};

%preun
SERVICE='cimserver'

if !(ps ax | grep -v grep | grep $SERVICE > /dev/null)
then
    echo "$SERVICE is not running"
    exit 1
fi
%OPENDRIM_REG_DIR/%{name}-%{version}-script/%PROVIDER_SCRIPT_POST-remove.sh %CIMNAMESPACE %CIMSERVER %INTEROPNAMESPACE

%files
%defattr(755, root, root, 755)
%dir %COMMONLIBDIR
%dir %PROVIDERDIR
%COMMONLIBDIR/*.so
%PROVIDERDIR/*.so
%defattr(744, root, root, 755)
%dir %OPENDRIM_REG_DIR
%dir %OPENDRIM_MOF_DIR
%dir %OPENDRIM_REG_DIR/%{name}-%{version}-script
%OPENDRIM_REG_DIR/%{name}-%{version}-script/*.sh
%OPENDRIM_MOF_DIR/*.mof

