// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Message_ProgressIndicator_HeaderFile
#define _Message_ProgressIndicator_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Message_ProgressIndicator_HeaderFile
#include <Handle_Message_ProgressIndicator.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Message_SequenceOfProgressScale_HeaderFile
#include <Message_SequenceOfProgressScale.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class TCollection_HAsciiString;
class Message_ProgressScale;


//! Defines abstract interface from program to the "user". <br>
//!          That includes progress indication and user break mechanisms <br>
//! <br>
//!          The interface to progress indicator represents it as a scale <br>
//!          for each range and step can be defined by the program that uses it. <br>
//!          The scale can be made "infinite", which means it will grow <br>
//!          non-linearly, end of scale will be approached asymptotically at <br>
//!          infinite number of steps. In that case value of scale range <br>
//!          gives a number of steps corresponding to position at 1/2 of scale. <br>
//!          The current position can be either set directly (in a range from <br>
//!          current position to maximum scale value), or incremented step <br>
//!          by step. <br>
//! <br>
//!          Progress indication mechanism is adapted for convenient <br>
//!          usage in hiererchical processes that require indication of <br>
//!          progress at several (sub)levels of the process. <br>
//!          For that purpose, it is possible to create restricted sub-scope of <br>
//!          indication by specifying part of a current scale that is to be <br>
//!          used by the subprocess. <br>
//!          When subprocess works with progress indicator in the restricted <br>
//!          scope, it has the same interface to a scale, while actually it <br>
//!          deals only with part of the whole scale. <br>
//! <br>
//!          NOTE: <br>
//!             Currently there is no support for concurrent progress <br>
//!             indicator that could be useful in multithreaded applications. <br>
//!             The main reason for this is that such implementation would be <br>
//!             too complex regarding forecasted lack of real need for such <br>
//!             support. <br>
//!             To support this it would require that ProgressScale keep its <br>
//!             own position and take care of incrementing main ProgressIndicator <br>
//!             in destructor. This would also require having cross-references <br>
//!             between nested instances of ProgressScale, ie. potential <br>
//!             problems with memory management. <br>
//!             In case of need of concurrent progress indicator two things can <br>
//!             be suggested: either creation of single spane with summary number <br>
//!             of steps, or usage of infinite scale. <br>
//! <br>
//!          The user break is implemented as virtual function that might <br>
//!          return True in case if break signal from the user is obtained. <br>
//! <br>
//!          The derived classes should take care of visualisation of the <br>
//!          progress indicator (e.g. show total position at the graphical bar, <br>
//!          and/or print all scopes in text mode), and for implementation <br>
//!          of user break mechanism (if defined). <br>
class Message_ProgressIndicator : public MMgt_TShared {

public:

  //! Drops all scopes and sets scale from 0 to 100, step 1 <br>
//!          This scale has name "Step" <br>
  Standard_EXPORT   virtual  void Reset() ;
  
        void SetName(const Standard_CString name) ;
  //! Set (optional) name for scale <br>
        void SetName(const Handle(TCollection_HAsciiString)& name) ;
  //! Set range for current scale <br>
        void SetRange(const Standard_Real min,const Standard_Real max) ;
  //! Set step for current scale <br>
        void SetStep(const Standard_Real step) ;
  //! Set or drop infinite mode for the current scale <br>
        void SetInfinite(const Standard_Boolean isInf = Standard_True) ;
  
        void SetScale(const Standard_CString name,const Standard_Real min,const Standard_Real max,const Standard_Real step,const Standard_Boolean isInf = Standard_False) ;
  //! Set all parameters for current scale <br>
  Standard_EXPORT     void SetScale(const Standard_Real min,const Standard_Real max,const Standard_Real step,const Standard_Boolean isInf = Standard_False) ;
  //! Returns all parameters for current scale <br>
  Standard_EXPORT     void GetScale(Standard_Real& min,Standard_Real& max,Standard_Real& step,Standard_Boolean& isInf) const;
  
  Standard_EXPORT     void SetValue(const Standard_Real val) ;
  //! Set and get progress value at current scale <br>
//!          If the value to be set is more than currently set one, or out <br>
//!          of range for the current scale, it is limited by that range <br>
  Standard_EXPORT     Standard_Real GetValue() const;
  
        void Increment() ;
  //! Increment the progress value by the default of specified step <br>
        void Increment(const Standard_Real step) ;
  
        Standard_Boolean NewScope(const Standard_CString name = 0) ;
  
        Standard_Boolean NewScope(const Handle(TCollection_HAsciiString)& name) ;
  
        Standard_Boolean NewScope(const Standard_Real span,const Standard_CString name = 0) ;
  //! Creates new scope on a part of a current scale from current <br>
//!          position with span either equal to default step, or specified <br>
//!          The scale for the new scope will have specified name and <br>
//!          ranged from 0 to 100 with step 1 <br>
//!          Returns False if something is wrong in arguments or in current <br>
//!          position of progress indicator; scope is opened anyway <br>
  Standard_EXPORT     Standard_Boolean NewScope(const Standard_Real span,const Handle(TCollection_HAsciiString)& name) ;
  //! Close the current scope and thus return to previous scale <br>
//!          Updates position to be at the end of the closing scope <br>
//!          Returns False if no scope is opened <br>
  Standard_EXPORT     Standard_Boolean EndScope() ;
  
        Standard_Boolean NextScope(const Standard_CString name = 0) ;
  //! Optimized version of { return EndScope() && NewScope(); } <br>
  Standard_EXPORT     Standard_Boolean NextScope(const Standard_Real span,const Standard_CString name = 0) ;
  //! Should return True if user has send a break signal. <br>
//!          Default implementation returns False. <br>
  Standard_EXPORT   virtual  Standard_Boolean UserBreak() ;
  //! Update presentation of the progress indicator <br>
//!          Called when progress position is changed <br>
//!          Flag force is intended for forcing update in case if it is <br>
//!          optimized; all internal calls from ProgressIndicator are <br>
//!          done with this flag equal to False <br>
  Standard_EXPORT   virtual  Standard_Boolean Show(const Standard_Boolean force = Standard_True)  = 0;
  //! Returns total progress position on the basic scale <br>
//!          ranged from 0. to 1. <br>
        Standard_Real GetPosition() const;
  //! Returns current number of opened scopes <br>
//!          This number is always >=1 as top-level scale is always present <br>
  Standard_EXPORT     Standard_Integer GetNbScopes() const;
  //! Returns data for scale of index-th scope <br>
//!          The first scope is current one, the last is the top-level one <br>
  Standard_EXPORT    const Message_ProgressScale& GetScope(const Standard_Integer index) const;




  DEFINE_STANDARD_RTTI(Message_ProgressIndicator)

protected:

  //! Constructor, just calls own Reset() (not yet redefined) <br>
  Standard_EXPORT   Message_ProgressIndicator();



private: 


Standard_Real myPosition;
Message_SequenceOfProgressScale myScopes;


};


#include <Message_ProgressIndicator.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
