# Community Guidelines

Nibabel is a [NIPY](https://nipy.org) project, and we strive to adhere to the
[NIPY Community Code](https://nipy.org/conduct.html), reproduced below.

The NIPY community is a community of practice devoted to the use of the Python programming language
in the analysis of neuroimaging data. The following code of conduct is a guideline for our behavior
as we participate in this community.

It is based on, and heavily inspired by a reading of the Python community code of conduct, the
Apache foundation code of conduct, the Debian code of conduct, and the Ten Principles of Burning
Man.

## The code of conduct for the NIPY community

The Neuroimaging in Python (NIPY) community is made up of members with a diverse set of skills,
personalities, background, and experiences. We welcome these differences because they are the
source of diverse ideas, solutions and decisions about our work. Decisions we make affect users,
colleagues, and through scientific results, the general public. We take these consequences
seriously when making decisions. When you are working with members of the community, we encourage
you to follow these guidelines, which help steer our interactions and help keep NIPY a positive,
successful, and growing community.

### A member of the NIPY community is:

#### Open

Members of the community are open to collaboration. Be it on the reuse of data, on the
implementation of methods, on finding technical solutions, establishing best practices, and
otherwise. We are accepting of all who wish to take part in our activities, fostering an
environment where anyone can participate and everyone can make a difference.

#### Collaborative

Our work will be used by other people, and in turn we will depend on the work of others. When we
make something for the benefit of others, we are willing to explain to others how it works, so that
they can build on the work to make it even better. We are willing to provide constructive criticism
on the work of others and accept criticism of our own work, as the experiences and skill sets of
other members contribute to the whole of our efforts.

#### Inquisitive

Nobody knows everything! Asking questions early avoids many problems later, so questions are
encouraged, though they may be directed to the appropriate forum. Those who are asked should be
responsive and helpful, within the context of our shared goal of improving neuroimaging practice.

#### Considerate

Members of the community are considerate of their peers. We are thoughtful when addressing the
efforts of others, keeping in mind that often-times the labor was completed simply for the good of
the community. We are attentive in our communications, whether in person or online, and we are
tactful when approaching differing views.

#### Careful in the words we choose

We value courtesy, kindness and inclusiveness in all our interactions. Therefore, we take
responsibility for our own speech. In particular, we avoid:

 * Personal insults.
 * Violent threats or language directed against another person.
 * Sexist, racist, or otherwise discriminatory jokes and language.
 * Any form of sexual or violent material.
 * Sharing private content, such as emails sent privately or non-publicly, or unlogged forums such
   as IRC channel history.
 * Excessive or unnecessary profanity.
 * Repeated harassment of others. In general, if someone asks you to stop, then stop.
 * Advocating for, or encouraging, any of the above behaviour.

#### Concise

Keep in mind that what you write once will be read by many others. Writing a short email means
people can understand the conversation as efficiently as possible. Even short emails should always
strive to be empathetic, welcoming, friendly and patient. When a long explanation is necessary,
consider adding a summary.

Try to bring new ideas to a conversation, so that each message adds something unique to the
conversation. Keep in mind that, when using email, the rest of the thread still contains the other
messages with arguments that have already been made.

Try to stay on topic, especially in discussions that are already fairly long and complex.

#### Respectful

Members of the community are respectful. We are respectful of others, their positions, their
skills, their commitments, and their efforts. We are respectful of the volunteer and professional
efforts that permeate the NIPY community. We are respectful of the processes set forth in the
community, and we work within them. When we disagree, we are courteous and kind in raising our
issues.

## Incident Reporting

We put great value on respectful, friendly and helpful communication.

If you feel that any of our Nibabel communications lack respect, or are unfriendly or unhelpful,
please try the following steps:

* If you feel able, please let the person who has sent the email or comment that you found it
  disrespectful / unhelpful / unfriendly, and why;

* If you don't feel able to do that, or that didn't work, please contact Chris Markiewicz directly
  by email (<markiewicz@stanford.edu>), and he will do his best to resolve it.
  If you don't feel comfortable contacting Chris, please email Matthew Brett
  (<matthew.brett@gmail.com>) instead.

## Attribution

The vast majority of the above was taken from the NIPY Code of Conduct.
