/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Date;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.trans.XPathException;

public abstract class Builder
implements Receiver {
    public static final int UNSPECIFIED_TREE_MODEL = -1;
    public static final int LINKED_TREE = 0;
    public static final int STANDARD_TREE = 0;
    public static final int TINY_TREE = 1;
    public static final int TINY_TREE_CONDENSED = 2;
    protected PipelineConfiguration pipe;
    protected Configuration config;
    protected NamePool namePool;
    protected String systemId;
    protected String baseURI;
    protected NodeInfo currentRoot;
    protected boolean lineNumbering = false;
    protected boolean started = false;
    protected boolean timing = false;
    private boolean open = false;
    private long startTime;

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
        this.config = pipe.getConfiguration();
        this.namePool = this.config.getNamePool();
        this.lineNumbering = this.lineNumbering || this.config.isLineNumbering();
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setLineNumbering(boolean lineNumbering) {
        this.lineNumbering = lineNumbering;
    }

    public void setTiming(boolean on) {
        this.timing = on;
    }

    public boolean isTiming() {
        return this.timing;
    }

    public void open() throws XPathException {
        if (this.timing && !this.open) {
            System.err.println("Building tree for " + this.getSystemId() + " using " + this.getClass());
            this.startTime = new Date().getTime();
        }
        this.open = true;
    }

    public void close() throws XPathException {
        if (this.timing && this.open) {
            long endTime = new Date().getTime();
            System.err.println("Tree built in " + (endTime - this.startTime) + " milliseconds");
            if (this.currentRoot instanceof TinyDocumentImpl) {
                ((TinyDocumentImpl)this.currentRoot).showSize();
            }
            this.startTime = endTime;
        }
        this.open = false;
    }

    public boolean usesTypeAnnotations() {
        return true;
    }

    public NodeInfo getCurrentRoot() {
        return this.currentRoot;
    }

    public void reset() {
        this.pipe = null;
        this.config = null;
        this.namePool = null;
        this.systemId = null;
        this.baseURI = null;
        this.currentRoot = null;
        this.lineNumbering = false;
        this.started = false;
        this.timing = false;
        this.open = false;
    }

    public static NodeInfo build(Source source, Stripper stripper, Configuration config) throws XPathException {
        return config.buildDocument(source);
    }

    public static NodeInfo build(Source source, Stripper stripper, PipelineConfiguration pipe) throws XPathException {
        Configuration config = pipe.getConfiguration();
        return config.buildDocument(source);
    }
}

