/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File Folder.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef Folder_H
#define Folder_H

#ifndef IconObject_H
#include "IconObject.h"
#endif

#include <string>
using std::string;


class FolderObserver;

class FolderVisitor {
public:
	virtual void visit(IconObject*) = 0;
};


class Folder : public IconObject {
public:

// -- Exceptions
	// None

// -- Contructors

	Folder(Folder* parent,
		const IconClass& kind, const string& name,
		IconInfo* info);

// -- Destructor

	virtual ~Folder(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	virtual IconObject* find(const vector<string>&);
	virtual IconObject* find(const string&);
	virtual IconObject* create(const string&);

	virtual bool adopt(IconObject*);
	virtual bool release(IconObject*);

	virtual void visit(FolderVisitor&);


	void addObserver(FolderObserver*);
	void removeObserver(FolderObserver*);

	string uniqueName(const string&);
	string duplicateName(const string&);
	void   position(IconObject*,int x,int y);
	void   renamed(IconObject*,const string&,const string&); 

	virtual void empty();
	virtual void destroy();

	void scan();
	void ensureChildrenWritable() ;

	void copyContent(Folder*);
	virtual void drop(IconObject*);

	typedef void (FolderObserver::*TellObserverProc)(IconObject*);
	void tellObservers(TellObserverProc,IconObject*);

	void open();
	void close();

	virtual bool ancestor(IconObject*);
	virtual bool sameAs(IconObject*);
	virtual void notifyChanged();

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods

	static Folder* top();
	static Folder* folder(const string&,bool create = true);
	static Folder* folder(const string&,const string&,bool create = true);
	static Folder* folder(const string&,const string&,const string&,bool create = true);

protected:

// -- Members

	typedef map<string,IconObjectH> KidMap;
	KidMap kids_;
	bool  ready_;

	set<FolderObserver*> observers_;

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods

	virtual set<string> can();
	virtual void createFiles();

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	Folder(const Folder&);
	Folder& operator=(const Folder&);

// -- Members


// -- Methods
	// None

// -- Overridden methods

	// From IconObject

	virtual void edit();


// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const Folder& p)
	//	{ p.print(s); return s; }

};

class FolderH : public Handle<Folder>{
public:
	FolderH(Folder* f) : Handle<Folder>(f) {}
};

#endif
