/* ----- encode/1013xfreeze3, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_1013xfreeze3_checksums[] = {
  "5837a623cf7f3d3c0f749b1f17bd4e6bcdee5dc21260123f6addfeb8e2116a2a",
  "a876703bcdb2d60e3da575c761a4f020680168798a3d68303972da1450397dbd",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_1013xfreeze3_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_1013xfreeze3_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_1013xfreeze3_ITEMBYTES

static void *storage_encode_1013xfreeze3_s;
static unsigned char *test_encode_1013xfreeze3_s;
static void *storage_encode_1013xfreeze3_x;
static unsigned char *test_encode_1013xfreeze3_x;
static void *storage_encode_1013xfreeze3_s2;
static unsigned char *test_encode_1013xfreeze3_s2;
static void *storage_encode_1013xfreeze3_x2;
static unsigned char *test_encode_1013xfreeze3_x2;

#define precomputed_encode_1013xfreeze3_NUM 4

static const unsigned char precomputed_encode_1013xfreeze3_s[precomputed_encode_1013xfreeze3_NUM][crypto_encode_STRBYTES] = {
  {255,255,0,0,255,0,1,1,0,255,254,0,1,1,0,255,2,0,1,0,0,1,1,1,254,0,1,0,1,2,0,2,1,0,255,0,1,255,1,2,255,0,1,254,1,1,2,2,1,255,255,1,255,255,1,1,255,0,0,0,254,2,2,1,1,255,0,0,0,0,1,1,1,1,0,255,255,255,1,255,1,0,254,2,255,0,0,1,255,0,254,0,1,0,2,0,255,1,1,1,254,0,254,1,0,254,255,1,255,0,0,255,1,1,1,254,2,1,255,1,255,0,255,255,255,0,2,0,0,254,0,255,0,2,0,1,0,254,255,0,255,0,0,1,255,2,255,1,255,2,255,254,0,2,255,255,255,1,1,0,255,0,0,0,1,255,1,0,0,0,255,1,255,254,1,254,1,255,1,255,1,0,0,254,1,0,255,1,255,2,0,2,0,0,255,255,2,255,255,1,1,0,1,255,0,0,0,1,1,0,2,2,1,255,255,1,0,255,255,254,255,2,254,1,0,255,0,1,254,0,0,255,1,0,1,254,255,0,1,254,1,0,254,255,1,1,0,255,255,255,0,2,255,0,255,0,1,0,0,0,254,0,0,2,0,0,1,0,2,2,0,0,255,1,255,0,254,255,2,0,255,0,255,1,0,0,255,1,0,0,254,2,1,254,1,254,255,1,2,1,255,0,255,255,255,0,1,254,1,255,254,1,0,255,255,1,255,0,0,0,1,0,2,255,0,254,255,1,254,254,2,1,2,1,255,0,0,254,255,0,255,0,0,0,1,1,1,0,1,1,255,0,255,0,0,0,1,1,1,2,255,255,2,255,255,1,254,0,0,255,1,0,255,0,255,1,0,0,255,1,2,1,1,0,0,2,255,0,255,1,1,1,254,255,0,255,1,255,255,1,254,0,1,255,0,255,1,2,1,255,1,2,255,0,1,255,1,255,0,254,254,0,1,2,0,255,255,0,0,0,1,1,255,255,255,0,0,255,0,2,1,1,2,254,0,0,0,0,255,2,0,0,0,0,1,1,1,0,2,1,255,2,255,0,255,1,1,1,1,2,1,1,1,255,1,255,1,255,0,0,1,0,0,0,1,255,0,255,1,255,2,1,0,0,1,255,0,0,1,0,1,1,0,255,254,0,0,0,0,254,0,2,1,1,255,2,255,0,255,0,0,255,1,1,255,2,0,1,254,255,255,0,0,254,1,2,2,0,0,1,1,254,0,0,254,254,255,0,1,0,0,255,255,1,0,255,255,255,0,255,255,0,255,0,1,1,255,1,1,255,2,0,0,255,0,1,0,255,0,255,255,0,255,0,2,255,1,1,1,2,1,255,0,0,0,2,254,255,1,1,0,1,255,1,1,0,254,0,254,2,1,0,255,2,0,2,255,255,0,0,0,1,0,255,254,1,0,2,254,255,255,1,0,0,0,2,1,255,0,0,0,2,255,255,254,1,255,1,255,255,1,0,0,1,1,0,255,1,1,255,0,0,255,0,0,1,1,1,0,0,255,1,255,1,1,1,0,1,1,0,0,2,1,254,1,255,1,255,2,255,255,2,1,254,255,1,254,1,1,255,254,1,255,0,0,0,0,255,0,255,0,254,255,255,255,255,0,255,0,1,255,255,1,0,1,2,1,255,0,1,254,0,0,0,1,255,2,255,255,1,1,0,0,1,0,1,1,255,254,0,254,1,1,0,255,0,1,0,0,2,0,0,2,255,1,255,1,0,0,254,0,0,255,0,1,255,0,0,1,1,1,2,255,1,1,1,255,1,0,1,0,0,1,2,0,1,0,0,0,255,0,1,0,255,1,255,0,2,2,0,255,255,1,0,0,1,0,254,2,255,255,0,0,255,0,0,1,1,0,0,255,255,255,0,255,0,255,0,1,255,255,0,0,0,1,2,0,255,0,0,0,255,2,1,255,255,0,0,1,1,0,255,254,2,2,0,0,255,0,0,2,0,0,0,2,0,0,2,1,2,255,255,1,0,0,1,1,0,255,2,1,255,2,1,0,1,0,255,1,0,0,0,1,254,1,254,0,1,2,0,254,1,254,0,1,1,1,1,1,255,1,0,0,1,1,1,0,255,0,1,1,0,255,254,0,1,254,0,255,0,1,1,1,1,254,0,255,1,0,1,255,254,0,1,0,0,254,254,255,1,254,2,255,0,0,0,0,1,254,1,1,254,0,255,0,255,0,0,0,1,2,0,2,1,255,255,1,2,255,0,0,0,255,254,1,0,0,1,0,0,0,254,255,0,255,0,1,1,254,1,2,255,1},
  {1,0,1,0,1,2,255,0,255,2,0,0,255,1,0,255,255,1,0,1,255,0,1,0,0,0,2,1,255,1,0,0,1,255,254,1,255,0,0,255,1,0,1,0,1,0,0,1,255,0,1,255,0,2,255,1,0,255,1,1,0,255,0,0,255,1,0,0,1,1,255,255,255,0,0,254,1,1,0,1,0,1,255,2,1,1,1,0,0,0,254,255,0,255,254,0,1,1,2,1,1,0,2,0,255,0,1,0,0,1,255,0,255,1,2,2,255,0,0,1,0,254,255,1,1,0,255,255,255,1,255,0,254,2,255,0,2,2,1,2,0,0,0,0,255,0,255,0,1,0,254,0,0,2,2,0,1,2,0,1,2,0,0,1,255,1,0,255,0,1,255,1,255,255,1,0,0,1,0,255,1,1,0,255,2,255,0,0,255,254,1,0,255,0,1,1,255,2,255,255,1,255,255,0,1,0,0,2,1,1,254,255,1,254,1,1,254,0,255,0,254,255,1,2,255,1,1,255,0,1,1,0,0,254,255,255,254,0,255,0,1,255,1,2,1,0,0,1,254,0,0,0,2,255,1,1,255,1,2,255,254,1,254,1,0,2,0,1,255,1,0,1,0,0,1,255,1,255,255,254,255,255,255,255,0,0,1,0,254,2,1,2,0,254,0,255,254,1,254,0,0,254,255,255,0,255,0,255,1,1,1,1,0,2,1,0,1,1,0,255,255,0,255,1,0,0,1,255,0,0,0,255,255,254,0,0,1,0,255,0,255,0,1,1,1,2,255,254,2,0,0,1,255,0,0,254,255,1,1,0,0,0,1,255,0,255,255,1,2,255,255,2,1,0,0,0,255,255,254,1,0,255,255,255,0,1,255,0,1,0,255,2,0,254,0,254,255,0,1,0,1,255,1,1,254,2,0,255,1,255,2,2,255,255,2,2,0,255,0,1,0,1,255,254,2,255,0,1,1,0,255,1,0,255,1,2,255,0,255,254,1,1,0,255,1,0,1,0,254,255,0,2,1,0,1,0,1,255,0,255,2,0,0,0,0,0,255,254,0,254,0,0,2,0,1,1,255,0,1,254,255,254,254,2,255,1,254,255,0,255,0,255,0,1,0,0,2,1,0,254,1,2,2,2,255,2,255,1,255,0,0,255,255,254,0,2,2,0,0,1,0,255,2,1,2,0,0,1,1,255,1,255,1,255,2,0,0,254,0,0,255,0,0,255,0,0,0,0,0,0,254,255,255,1,2,0,1,1,0,0,1,0,255,0,1,0,0,255,255,1,0,0,1,1,1,255,0,0,2,1,255,0,0,2,255,255,1,0,255,1,1,255,0,1,255,255,0,0,1,255,1,0,254,255,254,1,0,0,0,1,255,1,1,255,255,255,1,255,255,1,255,254,0,0,0,0,1,1,2,255,2,255,254,254,0,1,1,255,1,0,255,255,0,1,255,254,0,254,255,254,2,255,1,1,2,2,255,2,1,2,2,0,255,1,254,0,2,255,1,1,1,255,255,1,2,255,1,255,0,2,2,254,255,255,254,0,1,254,0,0,1,1,1,0,0,255,1,1,0,1,0,2,1,2,254,1,255,1,1,0,2,0,254,255,1,1,2,1,2,255,0,0,255,255,1,254,0,1,2,0,0,2,1,0,1,0,255,1,0,0,255,2,2,1,1,0,1,254,0,255,1,2,0,0,255,1,1,1,1,0,2,0,0,1,0,255,1,255,1,0,0,254,2,1,0,1,1,255,1,254,2,255,0,2,0,1,0,1,1,1,255,0,255,255,255,0,2,2,255,0,0,1,254,0,0,0,255,254,1,2,2,1,0,0,255,255,254,255,255,0,255,2,254,1,1,255,1,1,255,254,255,0,1,255,0,0,2,0,255,255,255,1,1,254,0,255,1,0,0,254,2,0,0,254,0,2,1,0,2,1,254,0,1,255,0,0,0,255,0,0,1,255,1,0,255,254,1,1,0,1,255,1,255,1,255,255,255,0,1,2,1,255,1,1,1,0,0,255,1,0,0,1,1,1,255,0,1,255,1,2,255,1,255,1,2,255,0,0,255,1,0,0,1,1,0,1,255,0,255,0,2,0,255,254,0,0,1,0,0,254,1,255,254,0,1,1,0,255,1,0,255,254,1,0,0,0,0,255,255,255,255,0,255,255,255,1,0,254,1,254,255,254,0,1,0,0,0,1,0,1,254,254,0,255,0,1,255,1,255,0,1,0,2,0,0,0,255,254,255,1,0,255,1,1,255,255,0,255,1,255,1,1,0},
  {254,1,254,1,2,2,0,1,254,0,0,1,255,1,255,0,0,0,255,2,255,0,255,255,1,254,255,0,0,255,1,255,255,0,0,0,1,0,2,0,0,1,0,0,1,1,255,254,0,2,255,255,0,0,255,1,1,1,1,0,0,255,255,2,2,0,255,0,255,0,1,254,254,0,0,255,254,0,0,255,254,254,255,1,255,255,0,1,255,1,255,1,254,0,0,255,0,254,2,2,255,0,1,255,255,0,0,254,1,0,1,2,2,255,254,0,0,255,0,255,255,0,255,2,0,255,0,1,255,0,0,255,0,1,1,1,254,254,255,255,1,0,255,0,255,0,0,0,1,0,1,255,255,255,2,0,255,0,255,1,0,255,1,254,0,254,1,0,0,255,254,0,255,1,1,1,0,255,0,0,0,1,0,1,255,255,0,255,255,1,255,255,255,0,2,0,1,2,0,1,1,254,1,0,255,255,0,0,255,255,0,1,0,255,0,254,1,255,255,0,0,2,2,2,2,0,0,0,0,254,0,1,0,1,0,1,255,0,1,1,1,1,255,0,255,0,1,0,0,0,1,1,255,1,254,1,1,0,254,1,255,254,1,2,255,255,2,2,2,254,255,0,255,1,0,255,2,1,255,255,0,255,2,255,0,1,1,2,255,1,1,1,1,1,254,254,1,2,1,255,1,255,0,2,1,0,0,255,0,2,0,255,255,254,0,255,1,255,255,1,255,255,2,255,254,2,0,1,255,254,254,1,1,255,255,0,0,1,255,255,0,0,1,1,1,1,255,255,255,255,2,1,1,2,1,255,0,1,255,2,255,0,2,255,255,2,0,1,0,1,1,1,1,0,255,254,0,0,255,1,0,1,255,0,0,0,0,0,1,254,0,255,255,2,1,255,0,2,2,0,0,0,0,0,1,255,1,2,255,1,0,255,2,1,255,255,0,255,255,1,0,255,0,1,2,255,0,0,255,1,255,254,0,0,1,1,255,0,255,0,1,255,1,1,255,1,0,0,0,0,254,0,0,255,2,0,255,0,254,0,1,0,255,0,0,0,255,0,1,255,0,255,255,1,255,1,255,1,0,254,255,0,1,255,255,0,254,2,255,0,254,1,255,2,2,1,0,255,1,0,254,254,255,1,254,255,0,0,255,254,0,1,0,1,1,1,1,254,2,255,1,1,255,0,1,255,0,255,1,255,0,1,255,255,1,255,0,1,255,1,0,2,0,2,0,255,255,1,255,255,1,255,2,255,254,0,255,0,0,0,255,0,1,0,0,2,0,1,0,2,255,0,0,2,255,0,254,2,0,1,0,254,0,0,0,0,1,2,0,1,1,255,255,0,0,255,2,0,255,1,255,0,0,255,2,0,0,254,0,0,1,0,1,255,2,1,0,1,1,0,0,254,0,255,1,0,255,255,0,0,1,2,0,0,2,0,255,0,1,0,1,1,255,254,0,1,254,0,255,254,1,1,0,254,0,1,0,0,254,1,1,1,255,255,0,255,255,0,2,255,1,0,1,1,0,255,1,1,0,1,2,255,1,1,1,254,255,255,1,2,1,255,1,255,1,1,254,0,1,254,255,255,0,1,0,2,255,0,1,2,1,255,1,255,1,0,2,2,255,255,0,0,0,255,255,255,255,0,1,255,255,255,255,1,1,0,254,1,2,1,1,2,0,255,0,1,255,255,254,255,255,1,2,255,255,254,1,255,0,0,2,1,1,1,0,0,255,0,2,255,0,255,255,1,0,255,0,1,255,2,255,2,255,1,255,1,0,1,0,0,0,2,2,255,0,255,0,0,255,1,254,2,254,0,255,0,0,0,0,0,0,255,0,1,1,255,254,1,0,1,0,0,254,254,2,0,0,254,1,0,1,0,255,0,0,255,1,254,0,0,1,0,0,1,255,1,255,0,0,255,0,0,255,255,255,1,1,1,255,0,1,254,255,0,255,1,1,1,255,1,255,1,2,254,254,0,1,0,254,0,255,255,255,0,0,2,0,2,255,0,0,1,0,254,0,1,0,0,255,2,1,255,1,0,254,1,255,1,255,0,0,255,254,1,0,255,255,1,0,0,2,1,1,255,0,1,255,0,1,255,0,255,255,0,1,0,1,255,255,255,254,1,0,254,0,1,1,1,255,2,1,0,254,255,0,0,1,255,255,0,255,255,0,0,0,255,255,0,0,0,0,255,1,2,1,1,0,0,0,0,255,2,255,254,254,255,0,1,255,1,255,255,2,0,0,1,254,255,2,0,2,1,254,0,2,0,0,1,255,0,255,0,254},
  {1,255,0,0,1,255,255,2,255,0,255,254,0,254,255,1,255,0,0,0,1,255,1,1,0,1,1,255,255,0,0,255,254,2,254,0,255,255,255,0,1,2,255,0,0,1,0,1,255,1,255,0,255,255,1,0,2,0,255,2,1,1,1,254,0,0,255,0,1,2,2,0,255,0,1,1,1,255,1,255,0,0,255,0,0,255,0,1,0,255,0,1,255,255,2,2,0,0,255,1,254,1,255,0,255,0,1,255,254,254,254,255,1,0,255,255,0,0,2,0,1,0,1,1,2,0,0,255,1,0,255,255,0,0,1,254,2,255,1,255,254,0,254,255,254,1,1,2,1,255,0,1,255,1,255,255,1,255,0,1,0,0,0,0,255,0,0,0,0,1,0,255,1,1,1,255,254,255,2,1,254,255,255,2,255,1,254,0,1,0,255,255,0,255,0,255,0,1,0,1,255,1,255,254,255,255,0,0,255,255,1,255,0,0,254,1,2,0,1,0,0,0,1,0,2,0,0,2,0,1,254,255,0,0,255,1,1,255,0,255,0,2,1,1,255,0,254,1,1,2,0,0,255,255,0,0,2,1,254,255,1,1,254,0,0,0,1,1,255,0,255,1,1,1,1,254,254,1,2,1,1,255,255,255,0,0,0,1,255,255,2,2,1,1,255,0,0,255,0,254,2,0,255,255,254,2,255,255,0,1,254,2,0,0,0,1,1,0,1,254,255,0,255,0,0,1,0,0,1,255,255,0,1,254,2,1,2,0,1,1,1,0,0,1,255,0,255,0,255,0,1,0,2,0,0,254,254,255,255,2,0,255,2,1,254,255,255,2,0,0,255,1,255,0,1,255,255,0,1,1,255,0,254,0,0,1,0,0,2,1,0,2,0,2,0,1,0,254,1,0,255,1,1,0,0,1,1,1,1,1,255,0,0,255,0,1,1,255,0,255,1,255,254,255,255,1,1,255,1,255,0,255,1,254,1,2,1,1,0,0,2,1,255,254,1,1,1,254,255,1,255,254,1,255,0,255,0,0,0,1,1,0,1,0,255,254,255,254,255,255,255,255,2,0,2,1,2,255,0,1,0,255,254,0,255,0,255,255,0,255,1,255,2,254,2,1,255,255,0,1,0,1,0,2,1,0,255,255,1,0,1,255,254,1,0,1,255,0,2,1,1,1,255,2,0,2,255,0,0,254,2,0,1,1,0,0,1,255,255,255,0,0,254,1,0,0,0,1,1,255,1,255,2,255,255,0,255,0,255,1,0,0,255,255,0,0,255,0,1,1,0,0,255,0,255,255,255,1,0,255,255,2,0,254,1,0,0,0,0,0,0,0,1,0,0,0,0,0,255,255,255,2,255,2,255,255,0,0,2,0,2,0,255,1,254,255,255,0,255,0,0,255,0,255,1,255,0,1,0,0,0,0,255,0,0,1,0,0,255,1,255,1,254,255,1,2,0,254,2,255,255,1,0,2,1,1,1,2,1,255,1,255,0,0,0,2,0,0,0,0,0,0,254,1,0,255,2,255,0,1,0,255,2,255,0,0,255,0,1,2,254,0,1,255,254,0,0,1,255,255,0,255,0,255,254,0,0,255,254,1,255,2,255,0,2,255,254,254,1,1,0,0,254,255,255,0,1,254,0,1,255,255,1,0,254,0,0,1,0,2,254,0,1,255,0,255,2,0,254,255,255,1,1,1,255,0,1,255,255,0,0,255,1,255,254,0,1,1,255,255,255,0,0,254,1,1,0,255,1,1,1,1,255,1,255,1,255,0,1,1,2,0,255,0,2,0,1,255,1,1,0,0,255,254,255,0,254,255,1,1,1,0,255,255,1,0,255,255,0,0,255,1,255,255,1,255,1,0,255,1,1,1,1,255,0,0,2,0,1,255,0,255,254,0,0,0,255,0,0,2,2,1,1,0,255,0,255,255,255,255,0,0,1,255,0,255,255,0,255,0,0,254,0,255,255,1,255,0,1,0,254,1,255,255,0,0,0,1,1,255,1,255,0,1,255,255,0,0,0,255,0,1,1,0,0,1,1,1,0,255,0,1,1,2,0,0,1,0,254,0,0,0,0,2,2,1,2,0,0,0,0,255,254,0,0,0,254,254,0,1,0,254,1,255,2,255,1,0,1,254,0,2,1,0,1,1,1,0,255,0,1,2,1,255,0,0,255,1,1,0,2,255,1,0,0,0,0,0,2,255,1,255,255,255,2,1,255,255,255,255,0,255,2,1,0,255,254,254,0,255,0,0,254,255,1,255,0,254,2,255,0,255,255},
} ;

static const int16_t precomputed_encode_1013xfreeze3_x[precomputed_encode_1013xfreeze3_NUM][crypto_encode_ITEMS] = {
  {5846,15476,-4986,-13461,21989,24036,-13862,4984,-21405,21212,19405,-15651,-3491,-21164,9132,-1873,-32233,25686,-14975,2952,21285,10309,6568,1969,31450,-9531,-8354,14166,-10307,-27211,28347,-22381,-18485,14514,4718,-14958,-2729,16472,-9911,-20575,31199,3711,15994,25507,-28784,-30224,-25567,-31546,-28172,18299,10604,10741,23957,17609,15583,-21818,-3061,21012,24228,28005,29668,-19807,-31327,-12638,-22835,10712,27714,15201,-7530,-16773,-31961,-14570,-20801,12949,-24855,27131,13310,-15214,-18752,14381,-9560,-27537,32032,-19357,29189,32037,15630,1699,29633,-10815,22741,-32289,-26234,-11349,-21610,16950,14903,12919,-9155,5398,27982,-17934,19984,55,14130,28096,5909,6343,-11206,-17169,32181,-13810,-21059,11470,-22142,32752,-18991,-12263,-11248,-29324,4331,-7662,7937,12806,-11761,-5784,-31822,27933,30243,19570,-5262,-7300,-30564,-28414,24192,3688,6927,29347,30857,12936,3296,2571,-10278,-23273,28418,-23752,16868,-1586,13178,-30988,22883,27961,-19155,-29854,12107,18698,-9049,-14930,-12767,-3810,25337,31461,29259,18765,-3440,-4087,4606,6480,-24477,-4050,-712,-23177,30893,30379,-11444,16657,-4148,6791,-5948,6416,-2615,7104,-31596,28096,-5918,3465,21737,-17246,28754,-31519,14967,-18769,-11547,12528,13880,30113,-18892,-6211,29042,-17807,-1898,10785,-11639,25631,26664,-14328,30144,13672,-23936,25908,-17233,-25096,-24059,7613,23966,11272,12054,24506,212,28057,-13957,-26812,22210,-22844,-18738,28394,16710,-31892,19420,-29163,25191,-10933,-6782,12033,-11672,19042,17816,1041,2377,27430,-27113,20721,26569,18110,-2324,-24848,-14685,-11788,-8902,5171,32121,-32491,13433,9120,-9307,32571,-7409,-14715,-32304,17520,20953,-29574,-20823,-26335,-6576,1938,-16802,-31632,-18370,-31006,16587,-29796,-12028,6925,473,-11007,27664,29033,-27712,11205,26009,-24303,24842,-12296,-6645,-27441,26927,5722,24021,7248,29257,-31852,-16907,30730,-27002,27847,8513,-30452,-19114,-30962,-3022,-18567,22952,-4681,-7006,30741,-14942,25306,-5645,28415,27085,1936,-2325,16622,758,-32405,9071,30225,1146,-11439,-28055,32316,-21319,13601,5088,31207,30230,13090,32311,22891,-24637,15262,-27892,-20981,-4606,339,-25596,27016,12575,-6303,15908,8151,-1122,-3822,-11261,7306,4759,-5277,-10379,15772,3197,26382,20843,-16983,8064,-1353,15670,-12629,-16547,-17914,2939,22238,-22177,24083,5120,-16508,29989,16515,-2208,19304,8407,28257,14021,23889,24773,-11042,14457,-6090,-328,-4253,-22387,11704,8878,-14508,-4185,-17965,-3187,15576,24599,1408,-12128,-15620,29026,11669,-21369,7007,673,-13573,-6307,-7856,21106,29412,16045,10229,3198,-6631,-8690,-23611,6835,19007,-21242,-22669,-7996,16998,-27725,-55,-2225,1016,26628,18418,19060,-18915,-15518,-23860,2091,9923,15863,-17931,23937,32451,10564,-31301,-16363,-3094,-12124,-15663,25533,20528,22779,-21274,-32642,-476,-29476,20671,-31113,-14409,14196,-20937,16625,-27985,25959,-11523,-1716,30375,3502,-30596,-14807,28017,-22519,-14153,30938,-27028,-793,-32490,20165,-17420,-28142,8827,6958,-20551,115,-25418,12103,12632,8227,21656,-17063,-15829,-2523,30561,2620,11280,25908,13272,3808,14930,-4140,27122,-9776,-4270,-24070,-18824,-16308,19557,15070,21533,-5946,2226,-24371,8016,-29765,14068,21627,-15232,17989,9504,15726,7938,-6228,23764,8364,-24931,5596,15925,26078,-29500,1175,20871,-2605,12954,-1971,13586,-30728,-3410,-6922,-31729,-13119,-3107,27418,18893,17165,-19830,-16578,28705,-27281,-16636,-30394,10758,10188,12562,-30413,21580,-11541,30111,29827,27013,-10900,-6186,-28286,-2388,798,-8038,29081,-3767,4302,-12805,28901,21155,-23712,31112,-4834,25110,5324,-2802,10687,9253,8093,8269,12205,16514,-22630,22386,30075,-11188,29436,-2666,-22032,-1201,-18222,27896,-14506,-15378,26921,28866,-30691,23819,10090,-7073,12286,-29020,8296,31568,26316,-15099,-2325,-29185,18835,-13855,3226,-11918,20910,-7466,-8650,-16286,-22091,-32001,22522,17259,31603,-29842,-1745,1347,2033,-26713,5847,-19933,-109,2180,10107,-6693,15375,-13190,-7431,-7177,27661,-30560,4056,-27811,28606,-12670,24737,5080,8619,-2469,20892,-27649,-32408,17342,11991,14061,-2823,-22606,30068,9824,22630,-22382,3422,-27086,-13621,2531,-26000,-27711,-1806,-4625,-32474,-21942,11828,4129,3388,-6283,87,-5763,-14374,-26727,-8229,-26585,2068,9328,4860,-8301,7145,-24422,1487,-24461,-19844,-6329,11010,-18755,-20891,-16494,-12342,-30226,-10268,30787,-5474,-4636,-6647,2228,-29650,-3328,20327,-29944,-25250,17500,23123,15955,29692,5602,-7502,-15334,32128,-11984,25868,12027,18135,5334,25032,-14935,16794,31184,-24690,30277,21551,22439,13064,-16279,21945,9140,-2040,-1640,29615,19403,4339,-15423,-29507,-32194,-27320,-15469,5430,8839,17944,-1464,-17880,-23061,-959,-562,-32245,-2689,32570,9631,-839,21168,-6687,-2330,213,-24164,-25496,14642,18337,11352,24265,-290,-27605,1611,24584,19629,-23660,-4956,22857,-27943,-27261,-10335,-31978,317,-16970,17801,-32588,17946,-21675,21865,-23241,21351,-472,17469,16357,-4687,3459,-10161,2788,-1085,-17270,-20860,21047,-17828,-6164,3073,5138,-3614,-23670,12670,-29094,20100,1165,-17479,-15651,11029,3330,-4860,-9405,2888,-14481,13555,-28818,-15421,-4115,-5158,30396,-23203,-19867,-15903,13553,10967,-5801,-26514,-3099,1840,-19566,22945,-27313,-13330,-1822,-16554,-6813,7070,-21120,-15933,-31859,-27047,-10323,5949,24158,10307,-3694,-32535,16592,22359,-13552,-11619,-2894,12059,-13993,-20142,-23850,-32571,-21182,-26452,-22158,-15589,32217,-23301,-26442,30020,-29626,-5438,24353,3152,7848,-20295,-29120,12301,-21438,-14761,16744,-24961,-31195,-18486,2124,-7471,17577,-11508,-22225,22989,9273,-15915,-21421,-14445,-1116,-31039,-5786,-16591,-15682,27881,-14615,2160,-23304,3424,-24302,-15699,5390,-19969,-18671,21848,-29731,-68,-4413,-16712,7815,-4858,-11627,4725,1347,31566,-1640,18802,1582,28018,-19350,-7316,-29908,816,28672,-6020,31915,-15426,-10052,-32288,-2840,-16658,-14390,-6310,-28283,21588,18849,12670,-31982,-18728,-19572,22181,4047,-21857,-5894,28272,20771,16900,20412,-6566,19771,16095,-6880,5061,-9452,6448,-1760,-19415,30289,-22233,-8989,-6674,7296,-26189,22388,25900,10326,-29201,26970,-30102,32692,23473,-15151,-3200,28897,-23902,12779,-16734,28539,-21387,-14907,-9848,22771,-18269,-9173,20179,8895,-4786,31395,410,4905,10869,21996,-24767,-23629,-19299,-21871,-19391,14039,-4357,-15629,-30958,6185,-849,3531,29385,4103,27349,-7805,22623,-2013,3391,-11451,8529,14856,23038,-2737,-25449,-14392,-12351,-17420,-28937,29770,-26666,-18076,23948,-31049},
  {3055,19608,-8627,-23373,10603,-19897,30299,15477,17588,-26116,-16104,-23916,26399,-15785,-11715,23024,3149,5098,-30075,-22904,22310,-18837,-24440,-28233,19902,-28734,-32749,5953,3395,11944,-22275,3771,-14618,-13522,25042,2788,8156,-29028,25977,23450,-9920,27981,-17435,18018,-6470,30906,3558,-19871,9890,-1407,11230,-11572,8346,-23431,14816,-6908,12675,14123,4702,-19265,21894,4133,-10659,-27930,16196,-28472,29637,20541,12880,-5321,2780,-10369,22880,-3234,24576,21787,15208,-10457,-11727,-17489,-19236,6730,-12523,-28504,-31481,11104,-9473,17952,17370,-3672,31231,9575,13626,11732,20302,-28872,7084,-20465,-19612,-6740,-11717,-21774,-22873,-9627,-15166,17748,-7019,-17100,-25794,-15152,-5518,31581,31910,-6185,-26596,-32644,28646,24378,-26319,2410,-2736,28165,-8443,-25616,1075,3729,5714,-5122,5654,-18692,30140,-6231,21940,-25750,31682,-27576,-31945,-25426,-28403,-21820,-14925,-28599,-12258,12156,-9166,-30066,30713,20091,-9959,-1887,23587,-5445,-17847,-26722,-19765,25071,-2825,-23917,24897,-26909,-32476,23061,11166,-13118,27413,-25409,-31242,14804,-22731,-31994,-10798,-30380,-3775,25199,-26738,762,-18663,9058,9429,-7048,-20819,-22526,-3405,-3340,-32470,-15850,7668,11079,32234,28702,895,-9621,19904,-16326,12010,-20408,-9880,-19519,-3529,18896,-28871,-6679,32660,30999,-11381,-29463,726,-25546,-18350,-845,21319,6266,5194,20890,-22775,4504,26167,9903,14381,25473,22513,26828,11083,-28153,21392,-32255,-14792,-3670,-1389,-14666,-18194,19596,-15282,30916,19514,-14545,17485,28146,-4756,-1188,-827,326,-8288,-22552,2941,21585,11640,-3125,20575,-14664,-7194,-10692,-30832,22589,10822,-7490,28634,-11120,-24928,-3076,31546,10951,30463,-22766,-30606,-18010,5886,4756,4184,-8039,7710,1081,-32727,-11094,-14486,-3754,-17450,28820,31259,21052,16631,16724,-2995,15191,-4548,-21486,10696,18630,29521,-30046,-410,-25195,32004,24706,-2589,8186,22564,-19862,25840,-24495,-14598,32761,-5440,27890,11262,-11551,5538,-4855,-17726,7189,-22055,13507,30651,-21361,-19856,-19119,2860,-27935,-14973,-2032,-8884,-20058,3647,-32567,-27549,4845,-29543,-9955,-25203,-25845,21300,3758,-7138,22579,-32394,22215,2716,-10335,-14881,-2535,16454,24243,-5456,-5603,10354,-22921,27923,29302,-28753,15504,-26814,12637,-5824,-11958,23211,30823,20876,-12377,4300,23307,16902,-24963,-10109,11621,1527,17504,18770,4579,-24076,-11779,24065,-31741,-7928,-7656,-26394,-7665,2591,32669,22906,-22862,-32340,27305,31385,14228,-24711,-6179,14564,-9522,-5867,15411,371,-18850,-17844,31285,23997,30421,-1744,22017,-1709,-10527,-9896,10415,13048,-21452,22807,-22192,-17289,-9112,-15953,31907,-22741,-22402,28118,25454,-24712,-31765,-12891,12005,11346,-30770,10734,14254,21320,21457,-18196,16871,19857,-29306,-12173,8130,-13258,-28646,-8079,-673,-3293,-26122,-4855,-6945,-14764,20779,-4013,11800,-23511,-9205,-13163,-30357,-13490,-8934,18031,-4753,-9864,-16738,-24062,31530,-31331,-17757,-18239,-8365,23910,-1435,-23275,-23067,-25080,26202,28830,15771,6203,23998,24078,24847,-31077,23439,-22504,20382,12889,58,-3133,22665,1819,31840,-10396,21922,29932,-21073,4835,7795,25996,24029,-10929,29663,-19059,31088,-15945,-4400,-20403,-1959,-32476,-13238,6615,24811,-18206,-22846,-30721,-30952,20579,-31228,29738,12898,5747,-10512,-26502,8864,23591,19405,-9441,-22906,-26269,14055,-27588,3253,-16728,-6619,-20875,16090,-30175,7356,-16494,10312,-27314,-2500,-17765,2219,11281,23375,-17995,-29391,19548,21367,8955,14631,-2242,-30216,-10713,1202,-7935,-22470,18405,-3072,-28167,32421,20953,24251,-7981,-25715,-20746,15915,-12905,-13799,13461,-32481,14590,-32322,15296,-1158,-18476,-4605,28704,13466,21341,-11084,-5208,32625,12847,1306,-32729,-1363,957,72,-21346,12685,-10198,29319,28746,-19258,-15403,19088,-14099,3174,-556,12766,4831,-8182,32514,-19673,28418,31394,24825,-3972,12985,14522,-4601,29733,17668,-5899,17302,-12809,-13734,-20295,-18897,-22460,4739,-28664,-31805,15530,28031,8069,-7772,7907,8588,4231,-5317,17470,24768,-9600,-21126,-5286,-25760,6730,-16675,-8287,-18946,-15319,26521,30622,-25998,4321,8152,1256,-30140,-24492,3893,26492,-24138,-1073,-8680,25087,-5739,19648,-4645,31135,-16390,15212,-8162,-1493,-26668,-18970,32342,-28423,-18908,-26530,-18061,-24492,1118,13360,23218,20256,-20296,-8446,-3422,-863,-15434,14486,32438,-9836,-28711,6314,11701,25694,9063,-17875,-20764,32311,32234,5357,17410,16548,5824,26392,-21531,27138,5530,-2291,13471,-16572,-28641,14801,-26291,10165,-20463,-13463,25617,-17233,-15485,-23830,26473,-21446,24896,-24068,10912,31194,-19672,-14055,18388,12656,-11504,14710,-26965,11185,-28498,6248,-15156,-2778,1676,30209,9652,22105,20937,-8036,-21628,3135,-1755,-32338,-3371,18414,-18026,4638,21188,-32723,-13845,30282,-5617,-28792,-18022,-13679,-13664,4656,-21893,21463,31698,-4558,-27692,-19381,30798,24576,18203,3742,-6566,-2882,7093,-29184,-25753,29289,-29274,4765,21639,1142,1105,-13624,-18053,-4785,-3705,19195,-28717,-27236,17127,-602,-25412,16133,-13943,19756,-29485,2582,-14004,-30385,-3345,-11975,-21144,-25958,-26153,-9632,-2602,31671,-6289,-3949,24062,-22905,-22186,-22957,25421,15048,-14973,-32720,24373,28305,-26181,-3264,24071,29992,8239,-24601,-17263,-23507,-28701,15639,-7555,6836,24406,31673,4583,20490,29219,-28450,25951,-12557,-23915,5531,-893,-23744,8279,29359,-10003,-23058,-8489,10688,-6132,23124,-24820,-30927,15113,29642,13991,-15236,-22835,32026,12237,27944,15430,-5238,14022,18568,-20650,-8307,14139,18940,8823,-31510,-4295,10752,-19570,-22328,32536,-15114,-23324,10103,-11313,4053,-28371,-14320,-29016,27552,-24854,12518,-8750,25278,20804,21364,2284,-65,-11952,-21215,6089,-9785,3515,-16031,-12841,31631,11957,25761,868,-25711,1831,5933,10639,6271,16165,8889,-105,-11200,-1106,972,-26922,5923,4630,-24698,16709,4404,-20999,-4138,-6218,-16852,9206,10417,2273,-9047,-23089,24836,22380,16446,-7645,10591,-10446,12846,-12398,-17054,5883,3088,-12580,-1059,21170,-369,-22864,8061,27146,23770,12018,3729,-14756,-20508,-6549,24628,-13745,-8731,27871,-18432,-737,589,8208,11639,-17627,243,19235,22093,-5249,29130,18177,-22053,8871,3473,-8440,-8443,-11110,9990,-11737,25127,18575,-22862,-21123,26488,-32087,28417,-5917,29362,-32277,-30923,15366,14595,-26448,-31772,768,-5903,19576,17614,10449,6776,-28908,8527,-5362,2248,1973,26958,-8984,2187,-27211,-20538,29577,29310,-391,25972,28463,-6653,7959,-7723,-26135,-4985,27377,4148,-6300,-15052,-5966,32294,-14603,-25778,5064},
  {25873,-3593,22747,6055,-29779,-29248,24765,1213,20479,-327,-22830,8314,-13834,7759,16205,-20136,-24279,-12141,12872,-18832,9125,7005,-6133,30113,-12824,31543,5369,8229,-4785,-8227,-7616,-13525,17471,-8766,24228,-17679,-21752,-4047,-30061,18150,-28047,-28220,3492,18723,-20597,-32258,23309,30865,-15627,-19117,-13633,-12265,-6786,-15921,6098,-12506,-31142,-5321,-19391,-20466,32697,-14959,19226,-32452,-16753,-19659,-2191,31752,8165,-24690,754,27340,31840,1740,2358,23216,28561,10299,-23526,31145,26959,25318,1634,-12767,28316,21326,19371,-19289,-10678,-23219,11003,3184,21487,12312,19893,-10687,30738,30757,-26830,-28300,4274,6240,-32444,24056,-11836,21126,-29409,29926,-17387,19368,1027,-27421,-32104,14204,28135,-4545,30057,21260,29958,3065,11552,9411,18830,-19690,-7365,26282,-5601,-19985,-8515,-16410,-609,7877,17403,-8810,12301,-27251,18019,16777,23705,-8605,7744,8991,26807,16815,-14854,-114,14142,-5049,2404,-32124,-4073,21761,24116,9608,-20476,24996,-7669,5265,5072,-28412,-5709,-3235,-20903,28318,1164,26845,-20726,16437,4443,23864,17638,20985,-11113,-10400,-4139,10057,13317,17858,-28386,-18387,-19983,-7094,-2571,-15989,-4303,8363,-28704,-12268,7475,-25391,6698,-13852,32729,22338,-27055,-18498,5653,-18505,25365,-13883,11632,20734,-31583,11511,-3583,4313,12369,-29640,-14230,-3787,57,-21935,31422,4943,-4347,24682,-32279,23228,7298,24435,27960,-28198,-29896,-24775,-16999,32238,4989,25278,-26646,28885,22197,-20537,-19998,-3194,-2073,3796,23375,25098,-8381,-15725,-14519,9160,10937,8886,-12253,-23550,8755,-30567,28806,18726,-29822,12310,29825,-29357,30046,-30983,-26966,-8298,28819,-29729,-11287,26380,3715,-16987,11261,254,-18445,-31297,-25183,29272,-1219,-16434,-5242,-4265,-9471,18407,-25399,6973,8627,25739,-16326,-8770,-24037,16964,-11292,9304,-20129,-19684,28277,-4703,964,-8984,13621,-23009,26368,20752,-16952,-27322,-10223,-7681,-17780,23333,17118,-22645,16360,23202,-25740,6452,11235,-31576,-23754,-10876,-13138,25378,10548,-5107,-18407,383,-15943,-22238,-11365,-2923,-30706,-4063,29500,-30787,8166,-17588,-8293,19942,18016,2143,6847,7556,16349,-26886,29091,-998,15431,-15766,-11130,22080,-19613,-11840,4711,-30443,-9970,-10612,-13438,32339,-23329,-16775,-8789,-22501,-3620,21488,11385,-24533,28766,-22132,23486,-9036,-18067,1214,1583,-25645,-32436,-21764,31617,-5075,-32477,-13145,-30854,6435,-7096,32320,-1860,-20226,8864,-12461,-9486,-11018,-4189,1815,-1872,21603,-18447,7320,-1718,23314,-597,21479,15917,-24859,7411,31100,7059,-18580,-20392,-2742,-25467,-23880,1182,-18621,3877,-16054,-3809,-26410,14153,6853,-25509,6173,-25132,-32240,2960,-3709,480,-14746,-4075,4624,28755,21989,24261,-2030,-22393,25301,18090,7092,29429,13951,-13849,17134,-5772,-13053,-24935,-7121,-658,14901,9548,19554,-4394,26339,5983,-12416,-6853,-13277,11934,7350,-3177,-30726,21202,-6726,16308,21230,-19585,-7026,-11827,24366,31213,-22509,7345,5313,-11701,-24831,6039,-13965,7670,-2043,-3071,21251,4800,14948,-6715,-6383,14768,-1748,-14839,-3992,3555,20977,-12532,15531,-28358,20105,-11947,-5307,30508,-19417,24785,-2010,21451,3547,-12037,-31618,-30592,1660,-16206,-14074,15295,2850,17614,20107,-49,6943,28678,-15634,-16143,-24645,32444,26338,8406,7114,-17256,-6680,-28598,-8327,2164,29566,-31069,20126,-7625,-16763,22484,-12468,-18986,-8461,-24003,-11044,16378,32042,30129,-15596,21512,5711,-3956,-5755,-6477,8521,28064,9373,-21135,-32275,-8583,-22876,7050,20990,26615,-860,14264,-10507,-16499,14948,-26566,4856,21622,28017,25106,12021,-15504,30327,-14593,28968,-9662,16947,28698,-28267,-31050,-29351,23562,-24772,31817,-13347,19071,-16486,-7429,-20076,32326,-24883,28851,-14306,11934,26293,8865,18078,19971,6717,-5264,-20518,-29568,-10127,-1565,6410,30950,24669,22350,20318,-17833,-8037,10922,12055,31973,30819,18369,5012,-25360,-8694,-28899,16705,-29790,5688,-22736,-10533,-8873,2708,-32320,-23066,-14811,7846,-3158,-9729,-4893,23470,-22629,12512,-16706,27717,5333,-15520,-384,-3240,-8615,-20698,-13860,23946,-32137,-28578,-3184,-26247,3058,10728,11044,-20228,-14254,32719,-19155,-5264,28966,-11892,-14956,31954,8917,11554,-1332,18166,3129,-9728,14250,-24279,31096,11392,-29051,-6602,3569,16688,-32121,18680,23828,-31269,-24043,18728,7546,9225,-3062,-31763,-19272,2654,-25232,-10685,-10887,13330,-25924,27668,-13304,9385,-8651,21940,13685,12938,-25040,-31960,-14264,5885,15256,-11191,-28784,-2540,25810,-22275,-4283,28669,-7234,-12484,3948,8527,7143,-20392,-5755,-7083,-32369,-31705,-30344,-1726,5800,-13006,-21215,-3963,-23689,-31438,-4960,29534,-3330,30897,-28335,22508,28910,-9820,8399,27291,15862,32,-5881,-8905,-9952,-18998,-21980,14265,31372,-7223,-19330,-9494,-16028,-29182,18525,-9007,10563,12364,6998,-2314,29413,10208,20114,-32210,-23140,21041,18785,31000,16153,17507,-28260,8106,-30904,4213,-31466,11719,1197,24384,15248,1470,-25141,25364,-10023,-8746,18980,-230,-31323,-10582,-13542,12253,10136,-30628,3476,-18442,19154,5884,-13459,-9521,5166,13381,-9930,22866,24555,-29308,-32269,22772,-32082,-5230,-32190,-6756,-1351,-24740,28786,-27139,28567,-25170,29642,10692,-24222,23877,-10290,12483,12042,9140,-23559,-14957,-818,19961,25780,-16916,-25455,-20885,-22671,-18882,26527,19171,-30202,9762,-11910,20962,-27431,-14085,15151,-29721,1637,15786,-357,-3946,6607,27712,-19596,3822,2197,19074,8250,14887,23420,-19544,27425,-10683,-14799,-11449,-23598,-5499,29498,31007,-5869,10276,-6071,-22796,10250,-8919,9238,16999,8687,-27117,30692,-7520,9556,-26027,2999,11722,4097,-15485,-16657,19060,18814,-5682,8056,29820,20593,-31251,26972,27653,2516,-27852,19968,-18493,-9171,-17347,-6268,20037,1665,4405,1056,21220,-1905,-19763,28350,-1776,31367,-25696,-23930,1433,15457,-29013,32086,10549,10622,-2663,-11491,-10953,-16536,25934,32194,-14468,-13779,-9112,-15886,-28850,-21870,-1695,-26131,-1976,4624,17132,-25611,-2882,30158,-8727,-17402,-5614,27243,-136,1664,31917,-14699,-21990,-13874,19652,1562,7040,29701,6181,27828,17986,-7566,-13160,-19133,-25196,25883,-31084,4138,13158,26182,11786,9423,19791,4465,9806,-13717,-24408,-16135,-2449,9003,18729,-786,-11062,2696,-28977,-1824,23964,21015,101,-26135,-26176,6952,1267,-18663,1221,10722,23169,3758,-31444,1235,21874,21214,27989,-12003,-17414,16778,-29195,1067,12626,-23944,2310,20526,-21272,28003,19223,-23503,-1383,-29944,-8021,30817,-14499,-31096,-28260,14175,-13097,7238,-1482,27977,-30759,20206},
  {-11207,2042,6942,-22365,8752,-15169,18950,-31501,-9901,-30234,-9676,19672,20460,32155,31061,-3110,31289,30822,-15183,-4254,-28106,14747,6724,-11420,-26268,-5420,-5402,21503,-7285,-29901,-4107,-1207,19642,-19885,18808,-8022,8288,14816,12881,22119,-10568,-30901,29369,-5358,-19665,9169,-24450,-14792,-15541,-5195,26726,17322,8408,-8197,-25874,-16812,-32212,23469,-14281,-16669,1024,12949,9637,25219,-20943,-2943,4367,-1227,-25022,-18610,-24583,2034,-10117,-21183,15184,-29102,-25712,-4222,-16316,-11539,-24174,26118,8471,11412,12252,29489,28416,-1052,-2718,-1678,27987,-9920,-733,-9094,-29332,-28117,3504,12546,-8284,2968,29131,-29363,5402,-26433,16904,-3333,8722,-11299,32482,27652,24508,5123,-6905,18183,10031,-3694,-5760,8262,-31501,-13191,-6062,636,-12221,-7745,-24967,19380,6744,32315,9793,7362,-6502,8144,-17646,-6936,-20108,32353,-21463,4424,-3158,17507,20464,12237,32647,5273,30022,3586,-9074,-26806,9487,30128,-11343,7621,-4270,-1049,22826,28307,-19274,15248,22011,-3308,21201,-28911,-1308,-25305,-15262,7353,20130,19584,5166,-5531,13947,2198,-27311,-26183,748,-15979,23089,-9694,-23833,14566,20212,1517,-13843,-16990,827,15961,24142,-19848,-5612,-16821,32018,9344,10053,-15208,16725,1898,198,-6908,-28989,-7568,-13483,10645,-8128,29752,6350,25994,31767,660,4025,28427,-7178,-1729,-17040,-4386,18238,-7403,-20134,32586,-3251,31149,26673,-30996,12970,17226,-29077,-15687,2274,-24892,-18984,-27479,26284,24233,30762,-14910,3056,-22496,-23867,845,-22974,15305,-21489,-28357,3874,571,-1909,4548,27529,-5222,4651,-20884,-10230,8334,-7747,6695,11766,-13419,-18349,-1061,22504,-9025,-17720,-11759,29875,16425,-20487,18048,-31649,10045,-13039,-25005,21350,-31322,-3356,-32126,-22241,22471,29890,-2903,-24250,-17630,-31718,3584,9386,6860,21045,26343,19965,15328,-15136,-5551,-31747,-31444,-31040,2770,-9637,-5604,10275,7469,-28017,30178,-26320,14607,24596,5747,21163,-24157,6614,17591,-25683,541,20590,-22555,-13896,13143,-28197,15070,-30707,19209,-18698,21034,-15331,-12906,21788,-13776,-31935,2272,12582,-28107,-374,-6244,10472,27615,-7451,16909,-24355,-19490,-21337,-7125,-15533,5467,-6635,20580,-15945,6718,5627,-15279,-4300,-24756,8333,7236,-1475,29787,-32524,7338,20295,22585,31501,-15925,26069,-17992,31791,18383,-20833,-5078,26497,13292,1148,-25210,16545,-24135,28391,-3368,-6022,-29868,14752,23570,-12502,22749,-27596,1654,21299,-5922,30565,-6588,25392,-6464,-3759,-24294,-32113,15226,-5028,-30406,-4170,-29449,20109,-20015,-3108,21943,-12962,-20736,-1627,-2525,-20504,23151,23499,-7598,10771,3583,-4418,-6071,10964,-840,-22452,23915,18150,-24854,14629,18833,12849,-8005,-1841,18068,19921,-7924,23915,9997,1198,5837,-25688,-3220,12621,3566,-21239,21865,-13715,-23674,-27506,15826,-1695,18147,-21013,11380,24443,19591,-10346,-50,-25064,31948,27524,-30836,4085,22576,-3926,13604,29625,-4507,14304,20574,-10239,-21737,-3044,-90,-4412,-27210,-8506,17605,-7240,32122,1694,-4297,18542,21641,-31306,-7428,-29989,-7457,-31123,26669,-17727,-29693,-1857,3527,20071,-27288,10265,-9705,21269,17819,-1314,19922,-7742,11804,-27901,25849,-29911,4597,8879,17834,-20952,12745,21132,-1598,-13641,-28987,14764,32280,13124,-10885,-19067,-2805,1102,25967,31447,-32483,27240,-21827,22169,15681,-25156,-1871,1204,-24356,20351,-27880,-25665,-31531,28040,6462,18249,19213,-16495,-19389,-31109,-17423,-3570,-31377,-32753,13004,-8293,-3790,-16443,-17790,19873,-12437,23352,15714,-9411,-9461,6709,3911,7906,-5353,-26017,22391,-12190,1752,16136,-13428,6620,-21179,29898,6006,-6109,10538,14154,-9714,-5776,-31827,12439,-3239,-1083,23211,28418,13245,5348,19886,-12163,9052,-31149,-1966,-232,-21199,-45,27460,14353,9306,15315,29109,12561,-32490,-22218,3795,-12866,-1734,-8607,19692,29097,23928,18425,12686,-11287,-32563,4805,-25600,-14164,-14356,15507,-28596,-24415,-7233,-28153,-23319,3824,-18254,28867,5129,18863,16026,22682,20553,16794,11168,-651,23414,-24950,28061,-7515,-16532,-25836,5163,7977,22305,1244,4809,28902,3367,-27837,23685,10100,4372,-12787,1900,17014,11753,6073,-22969,-18051,20050,-23149,19667,6068,6847,-15696,-29440,12976,12190,-23630,-18094,-15119,8309,-21704,-14086,1470,-22056,-20616,-21244,702,-16731,-5229,6573,5256,-16971,25783,12892,-31533,3287,-20443,15527,-4548,-13244,-5295,20435,-24481,28379,-30315,6972,-6439,-25647,-22292,-27214,28054,-5367,-27092,4745,27487,-13470,29241,14893,353,21305,5961,32429,-3885,21083,18631,9342,12063,-4768,29239,-14648,21887,-26830,10622,21849,-29791,10409,29677,19345,-25895,-10799,-9222,16947,27661,12107,-13420,1638,646,20425,-23151,6046,14939,2012,12661,-25218,19567,-16041,28089,-8276,606,-18943,24898,-30414,-17849,24494,-26409,12884,-30181,-22536,26158,18947,23087,12022,-16286,-16841,-12925,-6522,4831,28766,-16153,819,-10905,12797,-26714,31838,26821,-11049,8062,-30437,6554,17120,515,1899,20265,20086,-7868,-2780,26391,25619,7669,6136,-899,7699,8393,-2720,-7363,-8645,26450,15822,4402,166,-19162,-4986,18011,-26649,-20407,-2496,-29948,14168,-260,-20957,17808,-1980,-5869,32281,21410,27987,25060,4073,1069,-1556,12814,2475,10400,8855,-10922,-13104,21245,-3316,-30702,12069,18890,-25958,-13399,19343,2218,26261,5215,-5517,19379,-3836,-21668,15862,7330,-169,10569,-9468,-21595,6030,-27074,-7276,24552,13121,24421,-10131,7419,1500,32360,-31467,-15888,-24340,-27757,-24929,-29510,-7050,24305,-4449,8771,24122,-12526,-3079,-30114,8034,-23360,2516,-28983,2075,8300,963,20126,8559,23259,23929,14553,16826,5033,-12632,27581,7524,-26864,28842,29830,-22304,5336,-2749,23652,-7044,27261,15046,-3920,4931,13339,30278,12189,5956,25922,15962,-21597,-28317,27048,6380,-4497,12616,13642,19185,21282,4741,-9908,-16787,-28860,734,13098,-20045,-30818,-19960,19152,-30678,-10442,-17064,21760,-7947,20427,-14925,26013,-30871,-25999,-12635,-18883,14934,21726,-23829,-25806,-9553,32404,-24558,4323,-6870,27793,30901,-1917,466,-4008,18562,-6344,20747,-20983,-346,-21476,14097,-24596,21064,-2418,-28717,1594,-19440,-16976,-15836,-6959,-18888,12005,25281,-4682,-17839,-2531,32693,23871,-14121,31487,-30893,-17603,12333,-27031,-37,-476,-1503,20016,-22170,-24930,31722,-26971,-5656,6718,13334,-7666,-8170,-29215,-24668,-778,-11836,32147,31943,1938,31115,-20749,-3578,-5133,3713,26926,28750,20817,31067,29319,2493,20986,21800,-22271,27887,-7281,27433,-23185,8369,-12012,-8254,31565},
} ;

static void test_encode_1013xfreeze3_impl(long long impl)
{
  unsigned char *s = test_encode_1013xfreeze3_s;
  unsigned char *x = test_encode_1013xfreeze3_x;
  unsigned char *s2 = test_encode_1013xfreeze3_s2;
  unsigned char *x2 = test_encode_1013xfreeze3_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_1013xfreeze3_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_1013xfreeze3(impl);
    printf("encode_1013xfreeze3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1013xfreeze3_implementation(impl),ntruprime_dispatch_encode_1013xfreeze3_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_1013xfreeze3;
    printf("encode_1013xfreeze3 selected implementation %s compiler %s\n",ntruprime_encode_1013xfreeze3_implementation(),ntruprime_encode_1013xfreeze3_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_1013xfreeze3_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_1013xfreeze3_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_1013xfreeze3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_1013xfreeze3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_1013xfreeze3_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_1013xfreeze3_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_1013xfreeze3(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1013xfreeze3")) return;
  storage_encode_1013xfreeze3_s = callocplus(crypto_encode_STRBYTES);
  test_encode_1013xfreeze3_s = aligned(storage_encode_1013xfreeze3_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_1013xfreeze3_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_1013xfreeze3_x = aligned(storage_encode_1013xfreeze3_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_1013xfreeze3_s2 = callocplus(maxalloc);
  test_encode_1013xfreeze3_s2 = aligned(storage_encode_1013xfreeze3_s2,crypto_encode_STRBYTES);
  storage_encode_1013xfreeze3_x2 = callocplus(maxalloc);
  test_encode_1013xfreeze3_x2 = aligned(storage_encode_1013xfreeze3_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_1013xfreeze3 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_1013xfreeze3();++impl)
      forked(test_encode_1013xfreeze3_impl,impl);
    ++test_encode_1013xfreeze3_s;
    ++test_encode_1013xfreeze3_x;
    ++test_encode_1013xfreeze3_s2;
    ++test_encode_1013xfreeze3_x2;
  }
  free(storage_encode_1013xfreeze3_x2);
  free(storage_encode_1013xfreeze3_s2);
  free(storage_encode_1013xfreeze3_x);
  free(storage_encode_1013xfreeze3_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

