// generated by Fast Light User Interface Designer (fluid) version 1.0300

#include "PADnoteUI.h"
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

PADnoteHarmonicProfile::PADnoteHarmonicProfile(int x,int y, int w, int h, const char *label):Fl_Box(x,y,w,h,label) {
  pars=NULL;
}

void PADnoteHarmonicProfile::init(PADnoteParameters *pars,Master *master_) {
  master=master_;
  this->pars=pars;
}

void PADnoteHarmonicProfile::draw() {
  int ox=x(),oy=y(),lx=w(),ly=h();
  if (!visible()) return;
  REALTYPE smps[lx];
  
  REALTYPE realbw=pars->getprofile(smps,lx);
  bool active=active_r();
  
  //draw the equivalent bandwidth
  if (active) fl_color(220,220,220);
   else fl_color(160,165,165);
  fl_line_style(0);
  int rbw=(int)(realbw*(lx-1.0)/2.0);
  for (int i=lx/2-rbw;i<(lx/2+rbw);i++) fl_line(ox+i,oy,ox+i,oy+ly-1);
  
  fl_line_style(0);
  if (active) fl_color(200,200,200);
   else  fl_color(160,160,160);
  for (int i=1;i<10;i++){
  	int kx=(int)(lx/10.0*i);
  	fl_line(ox+kx,oy,ox+kx,oy+ly-1);
  };
  for (int i=1;i<5;i++){
  	int ky=(int)(ly/5.0*i);
  	fl_line(ox,oy+ly-ky,ox+lx,oy+ly-ky-1);
  };
  
  
  fl_color(120,120,120);
  fl_line_style(FL_DOT);
  fl_line(ox+lx/2,oy,ox+lx/2,oy+ly);
  
  //draw the graph
  fl_line_style(0);
  int old=0;
  for (int i=0;i<lx;i++){
     int val=(int) ((ly-2)*smps[i]);
     if (active) fl_color(180,210,240);
        else fl_color(150,150,155);
     fl_line(ox+i,oy+ly-1,ox+i,oy+ly-1-val);
     if (active) fl_color(0,0,100);
         else fl_color(150,150,150);
     if (i>0) fl_line(ox+i-1,oy+ly-2-old,ox+i,oy+ly-2-val);
     old=val;   
  };
  
  
  fl_line_style(FL_DASH);
  if (active) fl_color(0,100,220);
      else fl_color(150,160,170);
  fl_line(ox+lx/2-rbw,oy,ox+lx/2-rbw,oy+ly-1);
  fl_line(ox+lx/2+rbw,oy,ox+lx/2+rbw,oy+ly-1);
  
  fl_line_style(0);
}

PADnoteOvertonePosition::PADnoteOvertonePosition(int x,int y, int w, int h, const char *label):Fl_Box(x,y,w,h,label) {
  pars=NULL;
}

void PADnoteOvertonePosition::init(PADnoteParameters *pars,Master *master_) {
  master=master_;
  this->pars=pars;
}

void PADnoteOvertonePosition::draw() {
  if (!visible()) return;
  const int maxdb=60;
  
  int ox=x(),oy=y(),lx=w(),ly=h();
  const int maxharmonic=64;
  
  
  for (int i=1;i<maxharmonic;i++){
  	fl_color(200,200,200);
  	fl_line_style(FL_DOT);
  	if (i%5==0) fl_line_style(0);
  	if (i%10==0) fl_color(160,160,160);
  	int kx=(int)(lx/(REALTYPE)maxharmonic*i);
  	fl_line(ox+kx,oy,ox+kx,oy+ly);
  };
  
  
  
  int n=OSCIL_SIZE/2;
  REALTYPE spc[n];
  for (int i=0;i<n;i++) spc[i]=0.0;
  
  pthread_mutex_lock(&master->mutex);
  pars->oscilgen->getspectrum(n,spc,0);
  pthread_mutex_unlock(&master->mutex);
  
  
  //normalize
  REALTYPE max=0;
  for (int i=0;i<n;i++){
     REALTYPE x=fabs(spc[i]);
     if (max<x) max=x;
  }
  if (max<0.000001) max=1.0;
  max=max*1.05;
  
  REALTYPE spectrum[lx];
  for (int i=0;i<lx;i++) spectrum[i]=0;
  
  
  for (int i=1;i<n;i++){
  	REALTYPE nhr=pars->getNhr(i);
  	int kx=(int)(lx/(REALTYPE)maxharmonic*nhr);
  	if ((kx<0)||(kx>lx)) continue;
  
          spectrum[kx]=spc[i-1]/max+1e-9;
  
  };
  
  fl_color(180,0,0);
  fl_line_style(0);
  
  if (pars->Pmode==2){
     int old=0;
     for (int i=1;i<lx;i++){
  	if ((spectrum[i]>1e-10)||(i==(lx-1))){
  		int delta=i-old;
  		REALTYPE val1=spectrum[old];
  		REALTYPE val2=spectrum[i];
  
  		REALTYPE idelta=1.0/delta;
  		for (int j=0;j<delta;j++){
  			REALTYPE x=idelta*j;
  			spectrum[old+j]=val1*(1.0-x)+val2*x;
  		};
  		old=i;
  	};
        
     };
  };
  
  for (int i=0;i<lx;i++){
  	REALTYPE x=spectrum[i];
          if (x>dB2rap(-maxdb)) x=rap2dB(x)/maxdb+1;
               else continue;
         	int yy=(int)(x*ly);
  	fl_line(ox+i,oy+ly-1-yy,ox+i,oy+ly-1);
        
  };
}

void PADnoteUI::cb__i(Fl_Tabs* o, void*) {
  if (o->value()!=harmonicstructuregroup) applybutton->hide();
	else applybutton->show();
}
void PADnoteUI::cb_(Fl_Tabs* o, void* v) {
  ((PADnoteUI*)(o->parent()->user_data()))->cb__i(o,v);
}

void PADnoteUI::cb_hpbasepar1_i(WidgetPDial* o, void*) {
  pars->Php.base.par1=(int) o->value();
hprofile->redraw();
cbwidget->do_callback();
}
void PADnoteUI::cb_hpbasepar1(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hpbasepar1_i(o,v);
}

void PADnoteUI::cb_hpbasetype_i(Fl_Choice* o, void*) {
  pars->Php.base.type=o->value();
hprofile->redraw();
cbwidget->do_callback();
}
void PADnoteUI::cb_hpbasetype(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hpbasetype_i(o,v);
}

Fl_Menu_Item PADnoteUI::menu_hpbasetype[] = {
 {"Gauss", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Square", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"DoubleExp", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void PADnoteUI::cb_hpfreqmult_i(WidgetPDial* o, void*) {
  pars->Php.freqmult=(int) o->value();
hprofile->redraw();
cbwidget->do_callback();
}
void PADnoteUI::cb_hpfreqmult(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hpfreqmult_i(o,v);
}

void PADnoteUI::cb_hpmpar1_i(WidgetPDial* o, void*) {
  pars->Php.modulator.par1=(int) o->value();
hprofile->redraw();
cbwidget->do_callback();
}
void PADnoteUI::cb_hpmpar1(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hpmpar1_i(o,v);
}

void PADnoteUI::cb_hpmfreq_i(WidgetPDial* o, void*) {
  pars->Php.modulator.freq=(int) o->value();
hprofile->redraw();
cbwidget->do_callback();
}
void PADnoteUI::cb_hpmfreq(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hpmfreq_i(o,v);
}

void PADnoteUI::cb_hpamptype_i(Fl_Choice* o, void*) {
  pars->Php.amp.type=o->value();
hprofile->redraw();
cbwidget->do_callback();
}
void PADnoteUI::cb_hpamptype(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_hpamptype_i(o,v);
}

Fl_Menu_Item PADnoteUI::menu_hpamptype[] = {
 {"OFF", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Gauss", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Sine", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Flat", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void PADnoteUI::cb_hpampmode_i(Fl_Choice* o, void*) {
  pars->Php.amp.mode=o->value();
hprofile->redraw();
cbwidget->do_callback();
}
void PADnoteUI::cb_hpampmode(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_hpampmode_i(o,v);
}

Fl_Menu_Item PADnoteUI::menu_hpampmode[] = {
 {"Sum", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Mult", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Div1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Div2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void PADnoteUI::cb_hpamppar1_i(WidgetPDial* o, void*) {
  pars->Php.amp.par1=(int) o->value();
hprofile->redraw();
cbwidget->do_callback();
}
void PADnoteUI::cb_hpamppar1(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_hpamppar1_i(o,v);
}

void PADnoteUI::cb_hpamppar2_i(WidgetPDial* o, void*) {
  pars->Php.amp.par2=(int) o->value();
hprofile->redraw();
cbwidget->do_callback();
}
void PADnoteUI::cb_hpamppar2(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_hpamppar2_i(o,v);
}

void PADnoteUI::cb_hpautoscale_i(Fl_Check_Button* o, void*) {
  pars->Php.autoscale=(int) o->value();
hprofile->redraw();
cbwidget->do_callback();
}
void PADnoteUI::cb_hpautoscale(Fl_Check_Button* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hpautoscale_i(o,v);
}

void PADnoteUI::cb_hponehalf_i(Fl_Choice* o, void*) {
  pars->Php.onehalf=o->value();
hprofile->redraw();
cbwidget->do_callback();
}
void PADnoteUI::cb_hponehalf(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hponehalf_i(o,v);
}

Fl_Menu_Item PADnoteUI::menu_hponehalf[] = {
 {"Full", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Upper Half", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Lower Half", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void PADnoteUI::cb_hpwidth_i(WidgetPDial* o, void*) {
  pars->Php.width=(int) o->value();
hprofile->redraw();
cbwidget->do_callback();
}
void PADnoteUI::cb_hpwidth(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hpwidth_i(o,v);
}

void PADnoteUI::cb_Change_i(Fl_Button*, void*) {
  if (oscui!=NULL) delete (oscui);
oscui=new OscilEditor(pars->oscilgen,osc,cbwidget,applybutton,master);
}
void PADnoteUI::cb_Change(Fl_Button* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_Change_i(o,v);
}

void PADnoteUI::cb_cbwidget_i(Fl_Box*, void*) {
  overtonepos->redraw();
applybutton->color(FL_RED);
applybutton->redraw();
}
void PADnoteUI::cb_cbwidget(Fl_Box* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_cbwidget_i(o,v);
}

void PADnoteUI::cb_Resonance_i(Fl_Button*, void*) {
  resui->resonancewindow->redraw();
resui->resonancewindow->show();
resui->setcbwidget(cbwidget,applybutton);
}
void PADnoteUI::cb_Resonance(Fl_Button* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_Resonance_i(o,v);
}

void PADnoteUI::cb_bwdial_i(WidgetPDial* o, void*) {
  bwcents->value(pars->setPbandwidth((int) o->value()));
cbwidget->do_callback();
}
void PADnoteUI::cb_bwdial(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_bwdial_i(o,v);
}

void PADnoteUI::cb_hrpostype_i(Fl_Choice* o, void*) {
  pars->Phrpos.type=o->value();
overtonepos->redraw();
cbwidget->do_callback();
}
void PADnoteUI::cb_hrpostype(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hrpostype_i(o,v);
}

Fl_Menu_Item PADnoteUI::menu_hrpostype[] = {
 {"Harmonic", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"ShiftU", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"ShiftL", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"PowerU", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"PowerL", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Sine", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Power", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

void PADnoteUI::cb_hrpospar1_i(WidgetPDial* o, void*) {
  pars->Phrpos.par1=(int) o->value();
overtonepos->redraw();
cbwidget->do_callback();
}
void PADnoteUI::cb_hrpospar1(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hrpospar1_i(o,v);
}

void PADnoteUI::cb_hrpospar2_i(WidgetPDial* o, void*) {
  pars->Phrpos.par2=(int) o->value();
overtonepos->redraw();
cbwidget->do_callback();
}
void PADnoteUI::cb_hrpospar2(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hrpospar2_i(o,v);
}

void PADnoteUI::cb_hrpospar3_i(WidgetPDial* o, void*) {
  pars->Phrpos.par3=(int) o->value();
overtonepos->redraw();
cbwidget->do_callback();
}
void PADnoteUI::cb_hrpospar3(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hrpospar3_i(o,v);
}

void PADnoteUI::cb_bwscale_i(Fl_Choice* o, void*) {
  pars->Pbwscale=(int) o->value();
cbwidget->do_callback();
}
void PADnoteUI::cb_bwscale(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_bwscale_i(o,v);
}

Fl_Menu_Item PADnoteUI::menu_bwscale[] = {
 {"Normal", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"EqualHz", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Quater", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Half", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"75%", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"150%", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Double", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Inv.Half", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

void PADnoteUI::cb_qsamplesize_i(Fl_Choice* o, void*) {
  pars->Pquality.samplesize=(int) o->value();
cbwidget->do_callback();
}
void PADnoteUI::cb_qsamplesize(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_qsamplesize_i(o,v);
}

Fl_Menu_Item PADnoteUI::menu_qsamplesize[] = {
 {"16k (Tiny)", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"32k", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"64k (Small)", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"128k", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"256k (Normal)", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"512k", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"1M (Big)", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

void PADnoteUI::cb_qsmpoct_i(Fl_Choice* o, void*) {
  pars->Pquality.smpoct=(int) o->value();
cbwidget->do_callback();
}
void PADnoteUI::cb_qsmpoct(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_qsmpoct_i(o,v);
}

Fl_Menu_Item PADnoteUI::menu_qsmpoct[] = {
 {"0.5", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"3", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"4", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"6", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"12", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

void PADnoteUI::cb_qoct_i(Fl_Choice* o, void*) {
  pars->Pquality.oct=(int) o->value();
cbwidget->do_callback();
}
void PADnoteUI::cb_qoct(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_qoct_i(o,v);
}

Fl_Menu_Item PADnoteUI::menu_qoct[] = {
 {"1", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"3", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"4", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"5", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"6", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"7", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"8", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

void PADnoteUI::cb_qbasenote_i(Fl_Choice* o, void*) {
  pars->Pquality.basenote=(int) o->value();
cbwidget->do_callback();
}
void PADnoteUI::cb_qbasenote(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_qbasenote_i(o,v);
}

Fl_Menu_Item PADnoteUI::menu_qbasenote[] = {
 {"C-2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"G-2", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"C-3", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"G-3", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"C-4", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"G-4", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"C-5", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"G-5", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {"G-6", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

void PADnoteUI::cb_spectrummode_i(Fl_Choice* o, void*) {
  pars->Pmode=(int) o->value();

if (pars->Pmode==0){
   bwprofilegroup->activate();
   bwdial->activate();
   bwcents->activate();
   hprofile->activate();
   hprofile->color(54);
   bwscale->activate();
} else {
   bwprofilegroup->deactivate();
   bwdial->deactivate();
   bwcents->deactivate();
   hprofile->deactivate();
   hprofile->color(48);
   bwscale->deactivate();
};

cbwidget->do_callback();
}
void PADnoteUI::cb_spectrummode(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_spectrummode_i(o,v);
}

Fl_Menu_Item PADnoteUI::menu_spectrummode[] = {
 {"Bandwidth", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Discrete", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Continous", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

void PADnoteUI::cb_octave_i(Fl_Counter* o, void*) {
  int k=(int) o->value();
if (k<0) k+=16;
pars->PCoarseDetune = k*1024+
   pars->PCoarseDetune%1024;
}
void PADnoteUI::cb_octave(Fl_Counter* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_octave_i(o,v);
}

void PADnoteUI::cb_coarsedet_i(Fl_Counter* o, void*) {
  int k=(int) o->value();
if (k<0) k+=1024;
pars->PCoarseDetune = k+
   (pars->PCoarseDetune/1024)*1024;
}
void PADnoteUI::cb_coarsedet(Fl_Counter* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_coarsedet_i(o,v);
}

void PADnoteUI::cb_detune_i(Fl_Slider* o, void*) {
  pars->PDetune=(int)o->value()+8192;
detunevalueoutput->do_callback();
}
void PADnoteUI::cb_detune(Fl_Slider* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_detune_i(o,v);
}

void PADnoteUI::cb_detunevalueoutput_i(Fl_Value_Output* o, void*) {
  o->value(getdetune(pars->PDetuneType,0,pars->PDetune));
}
void PADnoteUI::cb_detunevalueoutput(Fl_Value_Output* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_detunevalueoutput_i(o,v);
}

void PADnoteUI::cb_detunetype_i(Fl_Choice* o, void*) {
  pars->PDetuneType=(int) o->value()+1;
detunevalueoutput->do_callback();
}
void PADnoteUI::cb_detunetype(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_detunetype_i(o,v);
}

void PADnoteUI::cb_hz440_i(Fl_Check_Button* o, void*) {
  int x=(int) o->value();
pars->Pfixedfreq=x;
if (x==0) fixedfreqetdial->deactivate();
   else fixedfreqetdial->activate();
}
void PADnoteUI::cb_hz440(Fl_Check_Button* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hz440_i(o,v);
}

void PADnoteUI::cb_fixedfreqetdial_i(WidgetPDial* o, void*) {
  pars->PfixedfreqET=(int) o->value();
}
void PADnoteUI::cb_fixedfreqetdial(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_fixedfreqetdial_i(o,v);
}

void PADnoteUI::cb_volume_i(Fl_Value_Slider* o, void*) {
  pars->PVolume=(int)o->value();
}
void PADnoteUI::cb_volume(Fl_Value_Slider* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_volume_i(o,v);
}

void PADnoteUI::cb_vsns_i(Fl_Value_Slider* o, void*) {
  pars->PAmpVelocityScaleFunction=(int) o->value();
}
void PADnoteUI::cb_vsns(Fl_Value_Slider* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_vsns_i(o,v);
}

void PADnoteUI::cb_pan_i(WidgetPDial* o, void*) {
  pars->PPanning=(int) o->value();
}
void PADnoteUI::cb_pan(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_pan_i(o,v);
}

void PADnoteUI::cb_pstr_i(WidgetPDial* o, void*) {
  pars->PPunchStrength=(int) o->value();
}
void PADnoteUI::cb_pstr(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_pstr_i(o,v);
}

void PADnoteUI::cb_pt_i(WidgetPDial* o, void*) {
  pars->PPunchTime=(int) o->value();
}
void PADnoteUI::cb_pt(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_pt_i(o,v);
}

void PADnoteUI::cb_pstc_i(WidgetPDial* o, void*) {
  pars->PPunchStretch=(int) o->value();
}
void PADnoteUI::cb_pstc(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_pstc_i(o,v);
}

void PADnoteUI::cb_pvel_i(WidgetPDial* o, void*) {
  pars->PPunchVelocitySensing=(int) o->value();
}
void PADnoteUI::cb_pvel(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_pvel_i(o,v);
}

void PADnoteUI::cb_stereo_i(Fl_Check_Button* o, void*) {
  pars->PStereo=(int) o->value();
hprofile->redraw();
}
void PADnoteUI::cb_stereo(Fl_Check_Button* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_stereo_i(o,v);
}

void PADnoteUI::cb_applybutton_i(Fl_Button* o, void*) {
  pars->applyparameters(true);
o->color(FL_GRAY);
if (oscui!=NULL) {
	oscui->applybutton->color(FL_GRAY);
	oscui->applybutton->redraw();
};
if (resui!=NULL) {
	resui->applybutton->color(FL_GRAY);
	resui->applybutton->redraw();
};
}
void PADnoteUI::cb_applybutton(Fl_Button* o, void* v) {
  ((PADnoteUI*)(o->parent()->user_data()))->cb_applybutton_i(o,v);
}

void PADnoteUI::cb_Close_i(Fl_Button*, void*) {
  padnotewindow->hide();
}
void PADnoteUI::cb_Close(Fl_Button* o, void* v) {
  ((PADnoteUI*)(o->parent()->user_data()))->cb_Close_i(o,v);
}

void PADnoteUI::cb_C_i(Fl_Button*, void*) {
  presetsui->copy(pars);
}
void PADnoteUI::cb_C(Fl_Button* o, void* v) {
  ((PADnoteUI*)(o->parent()->user_data()))->cb_C_i(o,v);
}

void PADnoteUI::cb_P_i(Fl_Button*, void*) {
  presetsui->paste(pars,this);
}
void PADnoteUI::cb_P(Fl_Button* o, void* v) {
  ((PADnoteUI*)(o->parent()->user_data()))->cb_P_i(o,v);
}

void PADnoteUI::cb_export_i(Fl_Button*, void*) {
  char *filename;
filename=fl_file_chooser("Export samples:","(*.wav)",NULL,0);
if (filename==NULL) return;
fl_filename_setext(filename,"");



pars->export2wav(filename);
}
void PADnoteUI::cb_export(Fl_Button* o, void* v) {
  ((PADnoteUI*)(o->parent()->user_data()))->cb_export_i(o,v);
}

PADnoteUI::PADnoteUI(PADnoteParameters *parameters,Master *master_) {
  pars=parameters;
  master=master_;
  oscui=NULL;
  resui=new ResonanceUI(pars->resonance);
  make_window();
}

Fl_Double_Window* PADnoteUI::make_window() {
  { padnotewindow = new Fl_Double_Window(535, 450, "PAD synth Parameters");
    padnotewindow->user_data((void*)(this));
    { Fl_Tabs* o = new Fl_Tabs(0, 0, 535, 395);
      o->callback((Fl_Callback*)cb_);
      { harmonicstructuregroup = new Fl_Group(0, 20, 535, 375, "Harmonic Structure");
        harmonicstructuregroup->box(FL_ENGRAVED_BOX);
        { Fl_Group* o = bwprofilegroup = new Fl_Group(5, 30, 90, 260);
          bwprofilegroup->box(FL_ENGRAVED_BOX);
          { WidgetPDial* o = hpbasepar1 = new WidgetPDial(20, 75, 25, 25, "Width");
            hpbasepar1->box(FL_ROUND_UP_BOX);
            hpbasepar1->color(FL_BACKGROUND_COLOR);
            hpbasepar1->selection_color(FL_INACTIVE_COLOR);
            hpbasepar1->labeltype(FL_NORMAL_LABEL);
            hpbasepar1->labelfont(0);
            hpbasepar1->labelsize(10);
            hpbasepar1->labelcolor(FL_FOREGROUND_COLOR);
            hpbasepar1->maximum(127);
            hpbasepar1->step(1);
            hpbasepar1->callback((Fl_Callback*)cb_hpbasepar1);
            hpbasepar1->align(Fl_Align(FL_ALIGN_TOP));
            hpbasepar1->when(FL_WHEN_CHANGED);
            o->value(pars->Php.base.par1);
          } // WidgetPDial* hpbasepar1
          { Fl_Choice* o = hpbasetype = new Fl_Choice(15, 45, 75, 15, "Base Type");
            hpbasetype->down_box(FL_BORDER_BOX);
            hpbasetype->labelsize(10);
            hpbasetype->textsize(10);
            hpbasetype->callback((Fl_Callback*)cb_hpbasetype);
            hpbasetype->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            hpbasetype->menu(menu_hpbasetype);
            o->value(pars->Php.base.type);
          } // Fl_Choice* hpbasetype
          { WidgetPDial* o = hpfreqmult = new WidgetPDial(55, 75, 25, 25, "FreqMlt");
            hpfreqmult->box(FL_ROUND_UP_BOX);
            hpfreqmult->color(FL_BACKGROUND_COLOR);
            hpfreqmult->selection_color(FL_INACTIVE_COLOR);
            hpfreqmult->labeltype(FL_NORMAL_LABEL);
            hpfreqmult->labelfont(0);
            hpfreqmult->labelsize(10);
            hpfreqmult->labelcolor(FL_FOREGROUND_COLOR);
            hpfreqmult->maximum(127);
            hpfreqmult->step(1);
            hpfreqmult->callback((Fl_Callback*)cb_hpfreqmult);
            hpfreqmult->align(Fl_Align(FL_ALIGN_TOP));
            hpfreqmult->when(FL_WHEN_CHANGED);
            o->value(pars->Php.freqmult);
          } // WidgetPDial* hpfreqmult
          { WidgetPDial* o = hpmpar1 = new WidgetPDial(15, 115, 20, 20, "Str");
            hpmpar1->box(FL_ROUND_UP_BOX);
            hpmpar1->color(FL_BACKGROUND_COLOR);
            hpmpar1->selection_color(FL_INACTIVE_COLOR);
            hpmpar1->labeltype(FL_NORMAL_LABEL);
            hpmpar1->labelfont(0);
            hpmpar1->labelsize(10);
            hpmpar1->labelcolor(FL_FOREGROUND_COLOR);
            hpmpar1->maximum(127);
            hpmpar1->step(1);
            hpmpar1->callback((Fl_Callback*)cb_hpmpar1);
            hpmpar1->align(Fl_Align(FL_ALIGN_TOP));
            hpmpar1->when(FL_WHEN_CHANGED);
            o->value(pars->Php.modulator.par1);
          } // WidgetPDial* hpmpar1
          { WidgetPDial* o = hpmfreq = new WidgetPDial(40, 115, 20, 20, "SFreq");
            hpmfreq->box(FL_ROUND_UP_BOX);
            hpmfreq->color(FL_BACKGROUND_COLOR);
            hpmfreq->selection_color(FL_INACTIVE_COLOR);
            hpmfreq->labeltype(FL_NORMAL_LABEL);
            hpmfreq->labelfont(0);
            hpmfreq->labelsize(10);
            hpmfreq->labelcolor(FL_FOREGROUND_COLOR);
            hpmfreq->maximum(127);
            hpmfreq->step(1);
            hpmfreq->callback((Fl_Callback*)cb_hpmfreq);
            hpmfreq->align(Fl_Align(FL_ALIGN_TOP));
            hpmfreq->when(FL_WHEN_CHANGED);
            o->value(pars->Php.modulator.freq);
          } // WidgetPDial* hpmfreq
          { Fl_Group* o = new Fl_Group(10, 160, 80, 105);
            o->box(FL_BORDER_BOX);
            { Fl_Choice* o = hpamptype = new Fl_Choice(15, 175, 70, 15, "AmpMultiplier");
              hpamptype->down_box(FL_BORDER_BOX);
              hpamptype->labelsize(10);
              hpamptype->textsize(10);
              hpamptype->callback((Fl_Callback*)cb_hpamptype);
              hpamptype->align(Fl_Align(FL_ALIGN_TOP_LEFT));
              hpamptype->menu(menu_hpamptype);
              o->value(pars->Php.amp.type);
            } // Fl_Choice* hpamptype
            { Fl_Choice* o = hpampmode = new Fl_Choice(15, 205, 70, 15, "AmpMode");
              hpampmode->down_box(FL_BORDER_BOX);
              hpampmode->labelsize(10);
              hpampmode->textsize(10);
              hpampmode->callback((Fl_Callback*)cb_hpampmode);
              hpampmode->align(Fl_Align(FL_ALIGN_TOP_LEFT));
              hpampmode->menu(menu_hpampmode);
              o->value(pars->Php.amp.mode);
            } // Fl_Choice* hpampmode
            { WidgetPDial* o = hpamppar1 = new WidgetPDial(15, 235, 25, 25, "Par1");
              hpamppar1->box(FL_ROUND_UP_BOX);
              hpamppar1->color(FL_BACKGROUND_COLOR);
              hpamppar1->selection_color(FL_INACTIVE_COLOR);
              hpamppar1->labeltype(FL_NORMAL_LABEL);
              hpamppar1->labelfont(0);
              hpamppar1->labelsize(10);
              hpamppar1->labelcolor(FL_FOREGROUND_COLOR);
              hpamppar1->maximum(127);
              hpamppar1->step(1);
              hpamppar1->callback((Fl_Callback*)cb_hpamppar1);
              hpamppar1->align(Fl_Align(FL_ALIGN_TOP));
              hpamppar1->when(FL_WHEN_CHANGED);
              o->value(pars->Php.amp.par1);
            } // WidgetPDial* hpamppar1
            { WidgetPDial* o = hpamppar2 = new WidgetPDial(55, 235, 25, 25, "Par2");
              hpamppar2->box(FL_ROUND_UP_BOX);
              hpamppar2->color(FL_BACKGROUND_COLOR);
              hpamppar2->selection_color(FL_INACTIVE_COLOR);
              hpamppar2->labeltype(FL_NORMAL_LABEL);
              hpamppar2->labelfont(0);
              hpamppar2->labelsize(10);
              hpamppar2->labelcolor(FL_FOREGROUND_COLOR);
              hpamppar2->maximum(127);
              hpamppar2->step(1);
              hpamppar2->callback((Fl_Callback*)cb_hpamppar2);
              hpamppar2->align(Fl_Align(FL_ALIGN_TOP));
              hpamppar2->when(FL_WHEN_CHANGED);
              o->value(pars->Php.amp.par2);
            } // WidgetPDial* hpamppar2
            o->end();
          } // Fl_Group* o
          { Fl_Check_Button* o = hpautoscale = new Fl_Check_Button(10, 270, 60, 15, "autoscale");
            hpautoscale->down_box(FL_DOWN_BOX);
            hpautoscale->labelsize(10);
            hpautoscale->callback((Fl_Callback*)cb_hpautoscale);
            o->value(pars->Php.autoscale);
          } // Fl_Check_Button* hpautoscale
          { Fl_Choice* o = hponehalf = new Fl_Choice(10, 143, 80, 15);
            hponehalf->down_box(FL_BORDER_BOX);
            hponehalf->labelsize(10);
            hponehalf->textsize(10);
            hponehalf->callback((Fl_Callback*)cb_hponehalf);
            hponehalf->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            hponehalf->menu(menu_hponehalf);
            o->value(pars->Php.onehalf);
          } // Fl_Choice* hponehalf
          { WidgetPDial* o = hpwidth = new WidgetPDial(65, 115, 20, 20, "Size");
            hpwidth->box(FL_ROUND_UP_BOX);
            hpwidth->color(FL_BACKGROUND_COLOR);
            hpwidth->selection_color(FL_INACTIVE_COLOR);
            hpwidth->labeltype(FL_NORMAL_LABEL);
            hpwidth->labelfont(0);
            hpwidth->labelsize(10);
            hpwidth->labelcolor(FL_FOREGROUND_COLOR);
            hpwidth->maximum(127);
            hpwidth->step(1);
            hpwidth->callback((Fl_Callback*)cb_hpwidth);
            hpwidth->align(Fl_Align(FL_ALIGN_TOP));
            hpwidth->when(FL_WHEN_CHANGED);
            o->value(pars->Php.width);
          } // WidgetPDial* hpwidth
          if (pars->Pmode!=0) o->deactivate();
          bwprofilegroup->end();
        } // Fl_Group* bwprofilegroup
        { Fl_Group* o = new Fl_Group(100, 155, 270, 135);
          o->box(FL_THIN_DOWN_BOX);
          o->color(FL_GRAY0);
          o->selection_color((Fl_Color)71);
          o->labelcolor((Fl_Color)179);
          o->align(Fl_Align(FL_ALIGN_BOTTOM_LEFT));
          osc=new Oscilloscope(o->x(),o->y(),o->w(),o->h(),"");
          osc->init(pars->oscilgen,master);
          o->end();
        } // Fl_Group* o
        { Fl_Button* o = new Fl_Button(375, 270, 60, 20, "Change");
          o->box(FL_THIN_UP_BOX);
          o->labelfont(1);
          o->labelsize(11);
          o->callback((Fl_Callback*)cb_Change);
        } // Fl_Button* o
        { cbwidget = new Fl_Box(125, 135, 205, 20, "Harmonic Content");
          cbwidget->callback((Fl_Callback*)cb_cbwidget);
          cbwidget->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
        } // Fl_Box* cbwidget
        { Fl_Button* o = new Fl_Button(375, 225, 80, 20, "Resonance");
          o->box(FL_THIN_UP_BOX);
          o->callback((Fl_Callback*)cb_Resonance);
        } // Fl_Button* o
        { WidgetPDial* o = bwdial = new WidgetPDial(15, 295, 35, 35, "BandWidth");
          bwdial->box(FL_ROUND_UP_BOX);
          bwdial->color(FL_BACKGROUND_COLOR);
          bwdial->selection_color(FL_INACTIVE_COLOR);
          bwdial->labeltype(FL_NORMAL_LABEL);
          bwdial->labelfont(0);
          bwdial->labelsize(10);
          bwdial->labelcolor(FL_FOREGROUND_COLOR);
          bwdial->maximum(1000);
          bwdial->step(1);
          bwdial->callback((Fl_Callback*)cb_bwdial);
          bwdial->align(Fl_Align(FL_ALIGN_BOTTOM));
          bwdial->when(FL_WHEN_CHANGED);
          o->value(pars->Pbandwidth);
          if (pars->Pmode!=0) o->deactivate();
        } // WidgetPDial* bwdial
        { Fl_Value_Output* o = bwcents = new Fl_Value_Output(55, 305, 55, 15, "cents");
          bwcents->labelsize(10);
          bwcents->maximum(10000);
          bwcents->step(0.1);
          bwcents->align(Fl_Align(FL_ALIGN_BOTTOM_LEFT));
          o->value(pars->setPbandwidth(pars->Pbandwidth));
          if (pars->Pmode!=0) o->deactivate();
        } // Fl_Value_Output* bwcents
        { Fl_Group* o = new Fl_Group(315, 295, 215, 45);
          o->box(FL_ENGRAVED_BOX);
          { Fl_Choice* o = hrpostype = new Fl_Choice(325, 310, 80, 20, "OvertonesPosition");
            hrpostype->down_box(FL_BORDER_BOX);
            hrpostype->labelsize(10);
            hrpostype->textsize(11);
            hrpostype->callback((Fl_Callback*)cb_hrpostype);
            hrpostype->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            hrpostype->menu(menu_hrpostype);
            o->value(pars->Phrpos.type);
          } // Fl_Choice* hrpostype
          { WidgetPDial* o = hrpospar1 = new WidgetPDial(425, 310, 25, 25, "Par1");
            hrpospar1->box(FL_ROUND_UP_BOX);
            hrpospar1->color(FL_BACKGROUND_COLOR);
            hrpospar1->selection_color(FL_INACTIVE_COLOR);
            hrpospar1->labeltype(FL_NORMAL_LABEL);
            hrpospar1->labelfont(0);
            hrpospar1->labelsize(10);
            hrpospar1->labelcolor(FL_FOREGROUND_COLOR);
            hrpospar1->maximum(255);
            hrpospar1->step(1);
            hrpospar1->callback((Fl_Callback*)cb_hrpospar1);
            hrpospar1->align(Fl_Align(FL_ALIGN_TOP));
            hrpospar1->when(FL_WHEN_CHANGED);
            o->value(pars->Phrpos.par1);
          } // WidgetPDial* hrpospar1
          { WidgetPDial* o = hrpospar2 = new WidgetPDial(460, 310, 25, 25, "Par2");
            hrpospar2->box(FL_ROUND_UP_BOX);
            hrpospar2->color(FL_BACKGROUND_COLOR);
            hrpospar2->selection_color(FL_INACTIVE_COLOR);
            hrpospar2->labeltype(FL_NORMAL_LABEL);
            hrpospar2->labelfont(0);
            hrpospar2->labelsize(10);
            hrpospar2->labelcolor(FL_FOREGROUND_COLOR);
            hrpospar2->maximum(255);
            hrpospar2->step(1);
            hrpospar2->callback((Fl_Callback*)cb_hrpospar2);
            hrpospar2->align(Fl_Align(FL_ALIGN_TOP));
            hrpospar2->when(FL_WHEN_CHANGED);
            o->value(pars->Phrpos.par2);
          } // WidgetPDial* hrpospar2
          { WidgetPDial* o = hrpospar3 = new WidgetPDial(495, 310, 25, 25, "ForceH");
            hrpospar3->box(FL_ROUND_UP_BOX);
            hrpospar3->color(FL_BACKGROUND_COLOR);
            hrpospar3->selection_color(FL_INACTIVE_COLOR);
            hrpospar3->labeltype(FL_NORMAL_LABEL);
            hrpospar3->labelfont(0);
            hrpospar3->labelsize(10);
            hrpospar3->labelcolor(FL_FOREGROUND_COLOR);
            hrpospar3->maximum(255);
            hrpospar3->step(1);
            hrpospar3->callback((Fl_Callback*)cb_hrpospar3);
            hrpospar3->align(Fl_Align(FL_ALIGN_TOP));
            hrpospar3->when(FL_WHEN_CHANGED);
            o->value(pars->Phrpos.par3);
          } // WidgetPDial* hrpospar3
          o->end();
        } // Fl_Group* o
        { Fl_Choice* o = bwscale = new Fl_Choice(120, 305, 80, 20, "Bandwidth Scale");
          bwscale->down_box(FL_BORDER_BOX);
          bwscale->labelsize(10);
          bwscale->textsize(11);
          bwscale->callback((Fl_Callback*)cb_bwscale);
          bwscale->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          bwscale->menu(menu_bwscale);
          o->value(pars->Pbwscale);
          if (pars->Pmode!=0) o->deactivate();
        } // Fl_Choice* bwscale
        { Fl_Group* o = overtonepos = new Fl_Group(5, 345, 525, 45);
          overtonepos->box(FL_FLAT_BOX);
          overtonepos->color(FL_LIGHT3);
          overtonepos->selection_color((Fl_Color)218);
          overtonepos->labelcolor(FL_GREEN);
          PADnoteOvertonePosition *opui=new PADnoteOvertonePosition(o->x(),o->y(),o->w(),o->h(),"");
          opui->init(pars,master);
          overtonepos->end();
        } // Fl_Group* overtonepos
        { Fl_Choice* o = qsamplesize = new Fl_Choice(375, 190, 115, 20, "Sample Size");
          qsamplesize->down_box(FL_BORDER_BOX);
          qsamplesize->labelsize(10);
          qsamplesize->textsize(11);
          qsamplesize->callback((Fl_Callback*)cb_qsamplesize);
          qsamplesize->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          qsamplesize->menu(menu_qsamplesize);
          o->value(pars->Pquality.samplesize);
        } // Fl_Choice* qsamplesize
        { Fl_Choice* o = qsmpoct = new Fl_Choice(430, 155, 45, 20, "smp/oct");
          qsmpoct->down_box(FL_BORDER_BOX);
          qsmpoct->labelsize(11);
          qsmpoct->textsize(11);
          qsmpoct->callback((Fl_Callback*)cb_qsmpoct);
          qsmpoct->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          qsmpoct->menu(menu_qsmpoct);
          o->value(pars->Pquality.smpoct);
        } // Fl_Choice* qsmpoct
        { Fl_Choice* o = qoct = new Fl_Choice(480, 155, 45, 20, "no.oct");
          qoct->down_box(FL_BORDER_BOX);
          qoct->labelsize(11);
          qoct->textsize(11);
          qoct->callback((Fl_Callback*)cb_qoct);
          qoct->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          qoct->menu(menu_qoct);
          o->value(pars->Pquality.oct);
        } // Fl_Choice* qoct
        { Fl_Choice* o = qbasenote = new Fl_Choice(375, 155, 50, 20, "base");
          qbasenote->down_box(FL_BORDER_BOX);
          qbasenote->labelsize(11);
          qbasenote->textsize(11);
          qbasenote->callback((Fl_Callback*)cb_qbasenote);
          qbasenote->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          qbasenote->menu(menu_qbasenote);
          o->value(pars->Pquality.basenote);
        } // Fl_Choice* qbasenote
        { Fl_Group* o = hprofile = new Fl_Group(100, 45, 430, 90);
          hprofile->box(FL_FLAT_BOX);
          hprofile->color(FL_LIGHT3);
          hprofile->selection_color((Fl_Color)218);
          hprofile->labelcolor(FL_GREEN);
          PADnoteHarmonicProfile *hpui=new PADnoteHarmonicProfile(o->x(),o->y(),o->w(),o->h(),"");
          hpui->init(pars,master);
          if (pars->Pmode!=0) { o->deactivate(); o->color(48);};
          hprofile->end();
        } // Fl_Group* hprofile
        { new Fl_Box(160, 25, 315, 20, "Profile of One Harmonic (Frequency Distribution)");
        } // Fl_Box* o
        { Fl_Choice* o = spectrummode = new Fl_Choice(220, 305, 90, 20, "Spectrum Mode");
          spectrummode->down_box(FL_BORDER_BOX);
          spectrummode->labelfont(1);
          spectrummode->labelsize(10);
          spectrummode->textsize(11);
          spectrummode->callback((Fl_Callback*)cb_spectrummode);
          spectrummode->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          spectrummode->menu(menu_spectrummode);
          o->value(pars->Pmode);
        } // Fl_Choice* spectrummode
        harmonicstructuregroup->end();
      } // Fl_Group* harmonicstructuregroup
      { Fl_Group* o = new Fl_Group(0, 20, 535, 375, "Envelopes&LFOs");
        o->box(FL_ENGRAVED_BOX);
        o->hide();
        { Fl_Group* o = new Fl_Group(5, 275, 525, 115, "FREQUENCY");
          o->box(FL_THIN_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->labelfont(1);
          o->labelsize(13);
          o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
          { EnvelopeUI* o = freqenv = new EnvelopeUI(10, 315, 205, 70, "PADSynth - Frequency Envelope");
            freqenv->box(FL_FLAT_BOX);
            freqenv->color((Fl_Color)51);
            freqenv->selection_color(FL_BACKGROUND_COLOR);
            freqenv->labeltype(FL_NORMAL_LABEL);
            freqenv->labelfont(0);
            freqenv->labelsize(14);
            freqenv->labelcolor(FL_FOREGROUND_COLOR);
            freqenv->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
            freqenv->when(FL_WHEN_RELEASE);
            o->init(pars->FreqEnvelope);
            freqenv->end();
          } // EnvelopeUI* freqenv
          { Fl_Counter* o = octave = new Fl_Counter(470, 295, 45, 15, "Octave");
            octave->tooltip("Octave");
            octave->type(1);
            octave->labelsize(10);
            octave->minimum(-8);
            octave->maximum(7);
            octave->step(1);
            octave->textfont(1);
            octave->textsize(11);
            octave->callback((Fl_Callback*)cb_octave);
            octave->align(Fl_Align(FL_ALIGN_TOP));
            int k=pars->PCoarseDetune/1024;
            if (k>=8) k-=16;
            o->value(k);
          } // Fl_Counter* octave
          { Fl_Counter* o = coarsedet = new Fl_Counter(455, 365, 60, 20, "Coarse det.");
            coarsedet->tooltip("Coarse Detune");
            coarsedet->labelsize(10);
            coarsedet->minimum(-64);
            coarsedet->maximum(63);
            coarsedet->step(1);
            coarsedet->textfont(1);
            coarsedet->textsize(11);
            coarsedet->callback((Fl_Callback*)cb_coarsedet);
            coarsedet->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            int k=pars->PCoarseDetune%1024;
            if (k>=512) k-=1024;
            o->value(k);
            o->lstep(10);
          } // Fl_Counter* coarsedet
          { LFOUI* o = freqlfo = new LFOUI(215, 315, 230, 70, "Frequency LFO     ");
            freqlfo->box(FL_FLAT_BOX);
            freqlfo->color(FL_DARK1);
            freqlfo->selection_color(FL_BACKGROUND_COLOR);
            freqlfo->labeltype(FL_NORMAL_LABEL);
            freqlfo->labelfont(0);
            freqlfo->labelsize(14);
            freqlfo->labelcolor(FL_FOREGROUND_COLOR);
            freqlfo->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
            freqlfo->when(FL_WHEN_RELEASE);
            o->init(pars->FreqLfo);
            freqlfo->end();
          } // LFOUI* freqlfo
          { Fl_Slider* o = detune = new Fl_Slider(60, 295, 295, 15);
            detune->tooltip("Fine Detune (cents)");
            detune->type(5);
            detune->box(FL_FLAT_BOX);
            detune->minimum(-8192);
            detune->maximum(8191);
            detune->step(1);
            detune->callback((Fl_Callback*)cb_detune);
            o->value(pars->PDetune-8192);
          } // Fl_Slider* detune
          { Fl_Value_Output* o = detunevalueoutput = new Fl_Value_Output(12, 295, 45, 15, "Detune");
            detunevalueoutput->labelsize(10);
            detunevalueoutput->minimum(-5000);
            detunevalueoutput->maximum(5000);
            detunevalueoutput->step(0.01);
            detunevalueoutput->textfont(1);
            detunevalueoutput->textsize(10);
            detunevalueoutput->callback((Fl_Callback*)cb_detunevalueoutput);
            detunevalueoutput->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->value(getdetune(pars->PDetuneType,0,pars->PDetune));
          } // Fl_Value_Output* detunevalueoutput
          { Fl_Choice* o = detunetype = new Fl_Choice(450, 335, 75, 15, "Detune Type");
            detunetype->down_box(FL_BORDER_BOX);
            detunetype->labelsize(10);
            detunetype->textfont(1);
            detunetype->textsize(10);
            detunetype->callback((Fl_Callback*)cb_detunetype);
            detunetype->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->add("L35cents");o->add("L10cents");o->add("E100cents");o->add("E1200cents");
            o->value(pars->PDetuneType-1);
          } // Fl_Choice* detunetype
          { Fl_Check_Button* o = hz440 = new Fl_Check_Button(365, 295, 50, 15, "440Hz");
            hz440->tooltip("set the base frequency to 440Hz");
            hz440->down_box(FL_DOWN_BOX);
            hz440->labelfont(1);
            hz440->labelsize(10);
            hz440->callback((Fl_Callback*)cb_hz440);
            o->value(pars->Pfixedfreq);
          } // Fl_Check_Button* hz440
          { WidgetPDial* o = fixedfreqetdial = new WidgetPDial(420, 295, 15, 15, "Eq.T.");
            fixedfreqetdial->tooltip("How the frequency varies acording to the keyboard (leftmost for fixed frequen\
cy)");
            fixedfreqetdial->box(FL_ROUND_UP_BOX);
            fixedfreqetdial->color(FL_BACKGROUND_COLOR);
            fixedfreqetdial->selection_color(FL_INACTIVE_COLOR);
            fixedfreqetdial->labeltype(FL_NORMAL_LABEL);
            fixedfreqetdial->labelfont(0);
            fixedfreqetdial->labelsize(10);
            fixedfreqetdial->labelcolor(FL_FOREGROUND_COLOR);
            fixedfreqetdial->maximum(127);
            fixedfreqetdial->step(1);
            fixedfreqetdial->callback((Fl_Callback*)cb_fixedfreqetdial);
            fixedfreqetdial->align(Fl_Align(FL_ALIGN_RIGHT));
            fixedfreqetdial->when(FL_WHEN_CHANGED);
            o->value(pars->PfixedfreqET);
            if (pars->Pfixedfreq==0) o->deactivate();
          } // WidgetPDial* fixedfreqetdial
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(5, 25, 240, 250, "AMPLITUDE");
          o->box(FL_THIN_UP_FRAME);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->labelfont(1);
          o->labelsize(13);
          o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
          { Fl_Value_Slider* o = volume = new Fl_Value_Slider(10, 50, 160, 15, "Vol");
            volume->tooltip("Volume");
            volume->type(5);
            volume->box(FL_FLAT_BOX);
            volume->labelsize(11);
            volume->maximum(127);
            volume->step(1);
            volume->callback((Fl_Callback*)cb_volume);
            volume->align(Fl_Align(FL_ALIGN_RIGHT));
            o->value(pars->PVolume);
          } // Fl_Value_Slider* volume
          { Fl_Value_Slider* o = vsns = new Fl_Value_Slider(10, 70, 160, 15, "V.Sns");
            vsns->tooltip("Velocity Sensing Function (rightmost to disable)");
            vsns->type(5);
            vsns->box(FL_FLAT_BOX);
            vsns->labelsize(11);
            vsns->maximum(127);
            vsns->step(1);
            vsns->callback((Fl_Callback*)cb_vsns);
            vsns->align(Fl_Align(FL_ALIGN_RIGHT));
            o->value(pars->PAmpVelocityScaleFunction);
          } // Fl_Value_Slider* vsns
          { WidgetPDial* o = pan = new WidgetPDial(210, 45, 30, 30, "Pan");
            pan->tooltip("Panning (leftmost is Random)");
            pan->box(FL_ROUND_UP_BOX);
            pan->color(FL_BACKGROUND_COLOR);
            pan->selection_color(FL_INACTIVE_COLOR);
            pan->labeltype(FL_NORMAL_LABEL);
            pan->labelfont(0);
            pan->labelsize(10);
            pan->labelcolor(FL_FOREGROUND_COLOR);
            pan->maximum(127);
            pan->step(1);
            pan->callback((Fl_Callback*)cb_pan);
            pan->align(Fl_Align(FL_ALIGN_BOTTOM));
            pan->when(FL_WHEN_CHANGED);
            o->value(pars->PPanning);
          } // WidgetPDial* pan
          { WidgetPDial* o = pstr = new WidgetPDial(125, 247, 25, 25, "P.Str.");
            pstr->tooltip("Punch Strength");
            pstr->box(FL_ROUND_UP_BOX);
            pstr->color(FL_BACKGROUND_COLOR);
            pstr->selection_color(FL_INACTIVE_COLOR);
            pstr->labeltype(FL_NORMAL_LABEL);
            pstr->labelfont(0);
            pstr->labelsize(10);
            pstr->labelcolor(FL_FOREGROUND_COLOR);
            pstr->maximum(127);
            pstr->step(1);
            pstr->callback((Fl_Callback*)cb_pstr);
            pstr->align(Fl_Align(FL_ALIGN_TOP));
            pstr->when(FL_WHEN_CHANGED);
            o->value(pars->PPunchStrength);
          } // WidgetPDial* pstr
          { WidgetPDial* o = pt = new WidgetPDial(155, 247, 25, 25, "P.t.");
            pt->tooltip("Punch Time (duration)");
            pt->box(FL_ROUND_UP_BOX);
            pt->color(FL_BACKGROUND_COLOR);
            pt->selection_color(FL_INACTIVE_COLOR);
            pt->labeltype(FL_NORMAL_LABEL);
            pt->labelfont(0);
            pt->labelsize(10);
            pt->labelcolor(FL_FOREGROUND_COLOR);
            pt->maximum(127);
            pt->step(1);
            pt->callback((Fl_Callback*)cb_pt);
            pt->align(Fl_Align(FL_ALIGN_TOP));
            pt->when(FL_WHEN_CHANGED);
            o->value(pars->PPunchTime);
          } // WidgetPDial* pt
          { WidgetPDial* o = pstc = new WidgetPDial(185, 247, 25, 25, "P.Stc.");
            pstc->tooltip("Punch Stretch");
            pstc->box(FL_ROUND_UP_BOX);
            pstc->color(FL_BACKGROUND_COLOR);
            pstc->selection_color(FL_INACTIVE_COLOR);
            pstc->labeltype(FL_NORMAL_LABEL);
            pstc->labelfont(0);
            pstc->labelsize(10);
            pstc->labelcolor(FL_FOREGROUND_COLOR);
            pstc->maximum(127);
            pstc->step(1);
            pstc->callback((Fl_Callback*)cb_pstc);
            pstc->align(Fl_Align(FL_ALIGN_TOP));
            pstc->when(FL_WHEN_CHANGED);
            o->value(pars->PPunchStretch);
          } // WidgetPDial* pstc
          { WidgetPDial* o = pvel = new WidgetPDial(215, 247, 25, 25, "P.Vel.");
            pvel->tooltip("Punch Velocity Sensing");
            pvel->box(FL_ROUND_UP_BOX);
            pvel->color(FL_BACKGROUND_COLOR);
            pvel->selection_color(FL_INACTIVE_COLOR);
            pvel->labeltype(FL_NORMAL_LABEL);
            pvel->labelfont(0);
            pvel->labelsize(10);
            pvel->labelcolor(FL_FOREGROUND_COLOR);
            pvel->maximum(127);
            pvel->step(1);
            pvel->callback((Fl_Callback*)cb_pvel);
            pvel->align(Fl_Align(FL_ALIGN_TOP));
            pvel->when(FL_WHEN_CHANGED);
            o->value(pars->PPunchVelocitySensing);
          } // WidgetPDial* pvel
          { EnvelopeUI* o = ampenv = new EnvelopeUI(10, 95, 205, 70, "PADSynth - Amplitude Envelope");
            ampenv->box(FL_FLAT_BOX);
            ampenv->color((Fl_Color)51);
            ampenv->selection_color(FL_BACKGROUND_COLOR);
            ampenv->labeltype(FL_NORMAL_LABEL);
            ampenv->labelfont(0);
            ampenv->labelsize(14);
            ampenv->labelcolor(FL_FOREGROUND_COLOR);
            ampenv->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
            ampenv->when(FL_WHEN_RELEASE);
            o->init(pars->AmpEnvelope);
            ampenv->end();
          } // EnvelopeUI* ampenv
          { LFOUI* o = amplfo = new LFOUI(10, 165, 230, 70, "Amplitude LFO     ");
            amplfo->box(FL_FLAT_BOX);
            amplfo->color(FL_DARK1);
            amplfo->selection_color(FL_BACKGROUND_COLOR);
            amplfo->labeltype(FL_NORMAL_LABEL);
            amplfo->labelfont(0);
            amplfo->labelsize(14);
            amplfo->labelcolor(FL_FOREGROUND_COLOR);
            amplfo->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
            amplfo->when(FL_WHEN_RELEASE);
            o->init(pars->AmpLfo);
            amplfo->end();
          } // LFOUI* amplfo
          { Fl_Check_Button* o = stereo = new Fl_Check_Button(15, 245, 70, 25, "Stereo");
            stereo->down_box(FL_DOWN_BOX);
            stereo->callback((Fl_Callback*)cb_stereo);
            o->value(pars->PStereo);
          } // Fl_Check_Button* stereo
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(245, 25, 285, 250, "FILTER");
          o->box(FL_THIN_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->labelfont(1);
          o->labelsize(13);
          o->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
          { EnvelopeUI* o = filterenv = new EnvelopeUI(250, 130, 275, 70, "PADSynth - Filter Envelope");
            filterenv->box(FL_FLAT_BOX);
            filterenv->color((Fl_Color)51);
            filterenv->selection_color(FL_BACKGROUND_COLOR);
            filterenv->labeltype(FL_NORMAL_LABEL);
            filterenv->labelfont(0);
            filterenv->labelsize(14);
            filterenv->labelcolor(FL_FOREGROUND_COLOR);
            filterenv->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
            filterenv->when(FL_WHEN_RELEASE);
            o->init(pars->FilterEnvelope);
            filterenv->end();
          } // EnvelopeUI* filterenv
          { LFOUI* o = filterlfo = new LFOUI(250, 200, 230, 70, "Filter LFO     ");
            filterlfo->box(FL_FLAT_BOX);
            filterlfo->color(FL_DARK1);
            filterlfo->selection_color(FL_BACKGROUND_COLOR);
            filterlfo->labeltype(FL_NORMAL_LABEL);
            filterlfo->labelfont(0);
            filterlfo->labelsize(14);
            filterlfo->labelcolor(FL_FOREGROUND_COLOR);
            filterlfo->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
            filterlfo->when(FL_WHEN_RELEASE);
            o->init(pars->FilterLfo);
            filterlfo->end();
          } // LFOUI* filterlfo
          { FilterUI* o = filterui = new FilterUI(250, 55, 275, 75, "PADsynth - Filter");
            filterui->box(FL_FLAT_BOX);
            filterui->color(FL_LIGHT1);
            filterui->selection_color(FL_BACKGROUND_COLOR);
            filterui->labeltype(FL_NORMAL_LABEL);
            filterui->labelfont(0);
            filterui->labelsize(14);
            filterui->labelcolor(FL_FOREGROUND_COLOR);
            filterui->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
            filterui->when(FL_WHEN_RELEASE);
            o->init(pars->GlobalFilter,&pars->PFilterVelocityScale,&pars->PFilterVelocityScaleFunction);
            filterui->end();
          } // FilterUI* filterui
          o->end();
        } // Fl_Group* o
        o->end();
      } // Fl_Group* o
      o->end();
    } // Fl_Tabs* o
    { Fl_Button* o = applybutton = new Fl_Button(45, 405, 185, 40, "Apply Changes");
      applybutton->box(FL_THIN_UP_BOX);
      applybutton->labelfont(1);
      applybutton->labelsize(16);
      applybutton->callback((Fl_Callback*)cb_applybutton);
      o->color(FL_RED);
    } // Fl_Button* applybutton
    { Fl_Button* o = new Fl_Button(320, 405, 175, 40, "Close");
      o->box(FL_THIN_UP_BOX);
      o->labelsize(17);
      o->callback((Fl_Callback*)cb_Close);
    } // Fl_Button* o
    { Fl_Button* o = new Fl_Button(240, 430, 25, 15, "C");
      o->box(FL_THIN_UP_BOX);
      o->color((Fl_Color)179);
      o->labelfont(1);
      o->labelsize(11);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->callback((Fl_Callback*)cb_C);
    } // Fl_Button* o
    { Fl_Button* o = new Fl_Button(270, 430, 25, 15, "P");
      o->box(FL_THIN_UP_BOX);
      o->color((Fl_Color)179);
      o->labelfont(1);
      o->labelsize(11);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->callback((Fl_Callback*)cb_P);
    } // Fl_Button* o
    { Fl_Button* o = new Fl_Button(240, 405, 55, 15, "export");
      o->tooltip("export samples as wav file");
      o->box(FL_THIN_UP_BOX);
      o->color(FL_WHITE);
      o->labelsize(11);
      o->callback((Fl_Callback*)cb_export);
      o->align(Fl_Align(FL_ALIGN_WRAP));
    } // Fl_Button* o
    padnotewindow->end();
  } // Fl_Double_Window* padnotewindow
  return padnotewindow;
}

void PADnoteUI::refresh() {
  volume->value(pars->PVolume);
  vsns->value(pars->PAmpVelocityScaleFunction);
  pan->value(pars->PPanning);
  
  stereo->value(pars->PStereo);
  
  
  pstr->value(pars->PPunchStrength);
  pt->value(pars->PPunchTime);
  pstc->value(pars->PPunchStretch);
  pvel->value(pars->PPunchVelocitySensing);
  
  detunevalueoutput->value(getdetune(pars->PDetuneType,0,pars->PDetune));
  detune->value(pars->PDetune-8192);
  
  int k=pars->PCoarseDetune/1024;if (k>=8) k-=16;
  octave->value(k);
  
  detunetype->value(pars->PDetuneType-1);
  k=pars->PCoarseDetune%1024;if (k>=512) k-=1024;
  coarsedet->value(k);
  
  hz440->value(pars->Pfixedfreq);
  fixedfreqetdial->value(pars->PfixedfreqET);
  
  amplfo->refresh();
  freqlfo->refresh();
  filterlfo->refresh();
  
  ampenv->refresh();
  freqenv->refresh();
  filterenv->refresh();
  filterui->refresh();
  
  
  /* harmonic structure parametrs */
  
  resui->refresh();
  if (oscui!=NULL) oscui->refresh();
  
  hpbasetype->value(pars->Php.base.type);
  hpbasepar1->value(pars->Php.base.par1);
  hpfreqmult->value(pars->Php.freqmult);
  
  hpmpar1->value(pars->Php.modulator.par1);
  hpmfreq->value(pars->Php.modulator.freq);
  hpwidth->value(pars->Php.width);
  
  hponehalf->value(pars->Php.onehalf);
  hpamptype->value(pars->Php.amp.type);
  hpampmode->value(pars->Php.amp.mode);
  hpamppar1->value(pars->Php.amp.par1);
  hpamppar2->value(pars->Php.amp.par2);
  hpautoscale->value(pars->Php.autoscale);
  
  bwdial->value(pars->Pbandwidth);
  if (pars->Pmode==0){
     bwprofilegroup->activate();
     bwdial->activate();
     bwcents->activate();
     hprofile->activate();
     hprofile->color(54);
     bwscale->activate();
  } else {
     bwprofilegroup->deactivate();
     bwdial->deactivate();
     bwcents->deactivate();
     hprofile->deactivate();
     hprofile->color(48);
     bwscale->activate();
  };
  
  spectrummode->value(pars->Pmode);
  
  qbasenote->value(pars->Pquality.basenote);
  qsmpoct->value(pars->Pquality.smpoct);
  qoct->value(pars->Pquality.oct);
  qsamplesize->value(pars->Pquality.samplesize);
  
  hrpostype->value(pars->Phrpos.type);
  hrpospar1->value(pars->Phrpos.par1);
  hrpospar2->value(pars->Phrpos.par2);
  hrpospar3->value(pars->Phrpos.par3);
  
  hprofile->redraw();
  overtonepos->redraw();
  
  osc->redraw();
  pars->applyparameters(true);
  applybutton->color(FL_GRAY);
  applybutton->parent()->redraw();
}

PADnoteUI::~PADnoteUI() {
  delete(oscui);
  delete(resui);
  
  padnotewindow->hide();
  delete(padnotewindow);
}
