
 /**************************************************************************
 *                       THIS FILE WAS GENERATED                           *
 * Script: utility/generate_specenum.py                                    *
 *                       DO NOT CHANGE THIS FILE                           *
 **************************************************************************/

/********************************************************************** 
 Freeciv - Copyright (C) 2009
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
***********************************************************************/

/*
 * Include this file to define tools to manage enumerators.  First of all,
 * before including this file, you *MUST* define the following macros:
 * - SPECENUM_NAME: is the name of the enumeration (e.g. 'foo' for defining
 * 'enum foo').
 * - SPECENUM_VALUE%d: define like this all values of your enumeration type
 * (e.g. '#define SPECENUM_VALUE0 FOO_FIRST').
 *
 * The following macros *CAN* be defined:
 * - SPECENUM_INVALID: specifies a value that your 'foo_invalid()' function
 * will return.  Note it cannot be a declared value with SPECENUM_VALUE%d.
 * - SPECENUM_BITWISE: defines if the enumeration should be like
 * [1, 2, 4, 8, etc...] instead of the default of [0, 1, 2, 3, etc...].
 * - SPECENUM_ZERO: can be defined only if SPECENUM_BITWISE was also defined.
 * It defines a 0 value.  Note that if you don't declare this value, 0 passed
 * to the 'foo_is_valid()' function will return 0.
 * - SPECENUM_COUNT: The number of elements in the enum for use in static
 * structs. It can not be used in combination with SPECENUM_BITWISE.
 * SPECENUM_is_valid() will return the invalid element for it.
 *
 * SPECENUM_VALUE%dNAME, SPECENUM_ZERONAME, SPECENUM_COUNTNAME: Can be used
 * to bind the name of the particular enumerator.  If not defined, the
 * default name for 'FOO_FIRST' is '"FOO_FIRST"'.
 *
 * Assuming SPECENUM_NAME were 'foo', including this file would provide
 * the definition for the enumeration type 'enum foo', and prototypes for
 * the following functions:
 *   bool foo_is_bitwise(void);
 *   enum foo foo_min(void);
 *   enum foo foo_max(void);
 *   enum foo foo_invalid(void);
 *   bool foo_is_valid(enum foo);
 *
 *   enum foo foo_begin(void);
 *   enum foo foo_end(void);
 *   enum foo foo_next(enum foo);
 *
 *   const char *foo_name(enum foo);
 *   enum foo foo_by_name(const char *name,
 *                        int (*strcmp_func)(const char *, const char *));
 *
 * Example:
 *   #define SPECENUM_NAME test
 *   #define SPECENUM_BITWISE
 *   #define SPECENUM_VALUE0 TEST0
 *   #define SPECENUM_VALUE1 TEST1
 *   #define SPECENUM_VALUE3 TEST3
 *   #include "specenum_gen.h"
 *
 *  {
 *    static const char *strings[] = {
 *      "TEST1", "test3", "fghdf", NULL
 *    };
 *    enum test e;
 *    int i;
 *
 *    log_verbose("enum test [%d; %d]%s",
 *                test_min(), test_max(), test_bitwise ? " bitwise" : "");
 *
 *    for (e = test_begin(); e != test_end(); e = test_next(e)) {
 *      log_verbose("Value %d is %s", e, test_name(e));
 *    }
 *
 *    for (i = 0; strings[i]; i++) {
 *      e = test_by_name(strings[i], mystrcasecmp);
 *      if (test_is_valid(e)) {
 *        log_verbose("Value is %d for %s", e, strings[i]);
 *      } else {
 *        log_verbose("%s is not a valid name", strings[i]);
 *      }
 *    }
 *  }
 *
 * Will output:
 *   enum test [1, 8] bitwise
 *   Value 1 is TEST0
 *   Value 2 is TEST1
 *   Value 8 is TEST3
 *   Value is 2 for TEST1
 *   Value is 8 for test3
 *   fghdf is not a valid name
 */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "log.h"        /* fc_assert. */
#include "support.h"    /* bool type. */

#ifndef SPECENUM_NAME
#error Must define a SPECENUM_NAME to use this header
#endif

#define SPECENUM_PASTE_(x, y) x ## y
#define SPECENUM_PASTE(x, y) SPECENUM_PASTE_(x, y)

#define SPECENUM_STRING_(x) #x
#define SPECENUM_STRING(x) SPECENUM_STRING_(x)

#define SPECENUM_FOO(suffix) SPECENUM_PASTE(SPECENUM_NAME, suffix)

#ifndef SPECENUM_INVALID
#define SPECENUM_INVALID ((enum SPECENUM_NAME) -1)
#endif

#ifdef SPECENUM_BITWISE
#ifdef SPECENUM_COUNT
#error Cannot define SPECENUM_COUNT when SPECENUM_BITWISE is defined.
#endif
#define SPECENUM_VALUE(value) (1 << value)
#else /* SPECENUM_BITWISE */
#ifdef SPECENUM_ZERO
#error Cannot define SPECENUM_ZERO when SPECENUM_BITWISE is not defined.
#endif
#define SPECENUM_VALUE(value) (value)
#endif /* SPECENUM_BITWISE */

#undef SPECENUM_MIN_VALUE
#undef SPECENUM_MAX_VALUE

/* Enumeration definition. */
enum SPECENUM_NAME {
#ifdef SPECENUM_ZERO
  SPECENUM_ZERO = 0,
#endif

#ifdef SPECENUM_VALUE0
  SPECENUM_VALUE0 = SPECENUM_VALUE(0),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE0
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE0
#endif /* SPECENUM_VALUE0 */

#ifdef SPECENUM_VALUE1
  SPECENUM_VALUE1 = SPECENUM_VALUE(1),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE1
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE1
#endif /* SPECENUM_VALUE1 */

#ifdef SPECENUM_VALUE2
  SPECENUM_VALUE2 = SPECENUM_VALUE(2),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE2
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE2
#endif /* SPECENUM_VALUE2 */

#ifdef SPECENUM_VALUE3
  SPECENUM_VALUE3 = SPECENUM_VALUE(3),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE3
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE3
#endif /* SPECENUM_VALUE3 */

#ifdef SPECENUM_VALUE4
  SPECENUM_VALUE4 = SPECENUM_VALUE(4),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE4
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE4
#endif /* SPECENUM_VALUE4 */

#ifdef SPECENUM_VALUE5
  SPECENUM_VALUE5 = SPECENUM_VALUE(5),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE5
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE5
#endif /* SPECENUM_VALUE5 */

#ifdef SPECENUM_VALUE6
  SPECENUM_VALUE6 = SPECENUM_VALUE(6),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE6
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE6
#endif /* SPECENUM_VALUE6 */

#ifdef SPECENUM_VALUE7
  SPECENUM_VALUE7 = SPECENUM_VALUE(7),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE7
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE7
#endif /* SPECENUM_VALUE7 */

#ifdef SPECENUM_VALUE8
  SPECENUM_VALUE8 = SPECENUM_VALUE(8),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE8
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE8
#endif /* SPECENUM_VALUE8 */

#ifdef SPECENUM_VALUE9
  SPECENUM_VALUE9 = SPECENUM_VALUE(9),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE9
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE9
#endif /* SPECENUM_VALUE9 */

#ifdef SPECENUM_VALUE10
  SPECENUM_VALUE10 = SPECENUM_VALUE(10),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE10
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE10
#endif /* SPECENUM_VALUE10 */

#ifdef SPECENUM_VALUE11
  SPECENUM_VALUE11 = SPECENUM_VALUE(11),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE11
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE11
#endif /* SPECENUM_VALUE11 */

#ifdef SPECENUM_VALUE12
  SPECENUM_VALUE12 = SPECENUM_VALUE(12),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE12
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE12
#endif /* SPECENUM_VALUE12 */

#ifdef SPECENUM_VALUE13
  SPECENUM_VALUE13 = SPECENUM_VALUE(13),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE13
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE13
#endif /* SPECENUM_VALUE13 */

#ifdef SPECENUM_VALUE14
  SPECENUM_VALUE14 = SPECENUM_VALUE(14),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE14
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE14
#endif /* SPECENUM_VALUE14 */

#ifdef SPECENUM_VALUE15
  SPECENUM_VALUE15 = SPECENUM_VALUE(15),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE15
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE15
#endif /* SPECENUM_VALUE15 */

#ifdef SPECENUM_VALUE16
  SPECENUM_VALUE16 = SPECENUM_VALUE(16),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE16
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE16
#endif /* SPECENUM_VALUE16 */

#ifdef SPECENUM_VALUE17
  SPECENUM_VALUE17 = SPECENUM_VALUE(17),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE17
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE17
#endif /* SPECENUM_VALUE17 */

#ifdef SPECENUM_VALUE18
  SPECENUM_VALUE18 = SPECENUM_VALUE(18),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE18
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE18
#endif /* SPECENUM_VALUE18 */

#ifdef SPECENUM_VALUE19
  SPECENUM_VALUE19 = SPECENUM_VALUE(19),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE19
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE19
#endif /* SPECENUM_VALUE19 */

#ifdef SPECENUM_VALUE20
  SPECENUM_VALUE20 = SPECENUM_VALUE(20),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE20
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE20
#endif /* SPECENUM_VALUE20 */

#ifdef SPECENUM_VALUE21
  SPECENUM_VALUE21 = SPECENUM_VALUE(21),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE21
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE21
#endif /* SPECENUM_VALUE21 */

#ifdef SPECENUM_VALUE22
  SPECENUM_VALUE22 = SPECENUM_VALUE(22),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE22
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE22
#endif /* SPECENUM_VALUE22 */

#ifdef SPECENUM_VALUE23
  SPECENUM_VALUE23 = SPECENUM_VALUE(23),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE23
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE23
#endif /* SPECENUM_VALUE23 */

#ifdef SPECENUM_VALUE24
  SPECENUM_VALUE24 = SPECENUM_VALUE(24),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE24
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE24
#endif /* SPECENUM_VALUE24 */

#ifdef SPECENUM_VALUE25
  SPECENUM_VALUE25 = SPECENUM_VALUE(25),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE25
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE25
#endif /* SPECENUM_VALUE25 */

#ifdef SPECENUM_VALUE26
  SPECENUM_VALUE26 = SPECENUM_VALUE(26),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE26
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE26
#endif /* SPECENUM_VALUE26 */

#ifdef SPECENUM_VALUE27
  SPECENUM_VALUE27 = SPECENUM_VALUE(27),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE27
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE27
#endif /* SPECENUM_VALUE27 */

#ifdef SPECENUM_VALUE28
  SPECENUM_VALUE28 = SPECENUM_VALUE(28),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE28
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE28
#endif /* SPECENUM_VALUE28 */

#ifdef SPECENUM_VALUE29
  SPECENUM_VALUE29 = SPECENUM_VALUE(29),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE29
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE29
#endif /* SPECENUM_VALUE29 */

#ifdef SPECENUM_VALUE30
  SPECENUM_VALUE30 = SPECENUM_VALUE(30),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE30
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE30
#endif /* SPECENUM_VALUE30 */

#ifdef SPECENUM_VALUE31
  SPECENUM_VALUE31 = SPECENUM_VALUE(31),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE31
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE31
#endif /* SPECENUM_VALUE31 */

#ifdef SPECENUM_VALUE32
  SPECENUM_VALUE32 = SPECENUM_VALUE(32),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE32
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE32
#endif /* SPECENUM_VALUE32 */

#ifdef SPECENUM_VALUE33
  SPECENUM_VALUE33 = SPECENUM_VALUE(33),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE33
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE33
#endif /* SPECENUM_VALUE33 */

#ifdef SPECENUM_VALUE34
  SPECENUM_VALUE34 = SPECENUM_VALUE(34),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE34
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE34
#endif /* SPECENUM_VALUE34 */

#ifdef SPECENUM_VALUE35
  SPECENUM_VALUE35 = SPECENUM_VALUE(35),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE35
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE35
#endif /* SPECENUM_VALUE35 */

#ifdef SPECENUM_VALUE36
  SPECENUM_VALUE36 = SPECENUM_VALUE(36),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE36
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE36
#endif /* SPECENUM_VALUE36 */

#ifdef SPECENUM_VALUE37
  SPECENUM_VALUE37 = SPECENUM_VALUE(37),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE37
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE37
#endif /* SPECENUM_VALUE37 */

#ifdef SPECENUM_VALUE38
  SPECENUM_VALUE38 = SPECENUM_VALUE(38),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE38
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE38
#endif /* SPECENUM_VALUE38 */

#ifdef SPECENUM_VALUE39
  SPECENUM_VALUE39 = SPECENUM_VALUE(39),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE39
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE39
#endif /* SPECENUM_VALUE39 */

#ifdef SPECENUM_VALUE40
  SPECENUM_VALUE40 = SPECENUM_VALUE(40),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE40
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE40
#endif /* SPECENUM_VALUE40 */

#ifdef SPECENUM_VALUE41
  SPECENUM_VALUE41 = SPECENUM_VALUE(41),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE41
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE41
#endif /* SPECENUM_VALUE41 */

#ifdef SPECENUM_VALUE42
  SPECENUM_VALUE42 = SPECENUM_VALUE(42),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE42
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE42
#endif /* SPECENUM_VALUE42 */

#ifdef SPECENUM_VALUE43
  SPECENUM_VALUE43 = SPECENUM_VALUE(43),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE43
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE43
#endif /* SPECENUM_VALUE43 */

#ifdef SPECENUM_VALUE44
  SPECENUM_VALUE44 = SPECENUM_VALUE(44),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE44
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE44
#endif /* SPECENUM_VALUE44 */

#ifdef SPECENUM_VALUE45
  SPECENUM_VALUE45 = SPECENUM_VALUE(45),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE45
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE45
#endif /* SPECENUM_VALUE45 */

#ifdef SPECENUM_VALUE46
  SPECENUM_VALUE46 = SPECENUM_VALUE(46),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE46
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE46
#endif /* SPECENUM_VALUE46 */

#ifdef SPECENUM_VALUE47
  SPECENUM_VALUE47 = SPECENUM_VALUE(47),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE47
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE47
#endif /* SPECENUM_VALUE47 */

#ifdef SPECENUM_VALUE48
  SPECENUM_VALUE48 = SPECENUM_VALUE(48),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE48
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE48
#endif /* SPECENUM_VALUE48 */

#ifdef SPECENUM_VALUE49
  SPECENUM_VALUE49 = SPECENUM_VALUE(49),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE49
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE49
#endif /* SPECENUM_VALUE49 */

#ifdef SPECENUM_VALUE50
  SPECENUM_VALUE50 = SPECENUM_VALUE(50),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE50
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE50
#endif /* SPECENUM_VALUE50 */

#ifdef SPECENUM_VALUE51
  SPECENUM_VALUE51 = SPECENUM_VALUE(51),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE51
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE51
#endif /* SPECENUM_VALUE51 */

#ifdef SPECENUM_VALUE52
  SPECENUM_VALUE52 = SPECENUM_VALUE(52),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE52
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE52
#endif /* SPECENUM_VALUE52 */

#ifdef SPECENUM_VALUE53
  SPECENUM_VALUE53 = SPECENUM_VALUE(53),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE53
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE53
#endif /* SPECENUM_VALUE53 */

#ifdef SPECENUM_VALUE54
  SPECENUM_VALUE54 = SPECENUM_VALUE(54),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE54
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE54
#endif /* SPECENUM_VALUE54 */

#ifdef SPECENUM_VALUE55
  SPECENUM_VALUE55 = SPECENUM_VALUE(55),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE55
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE55
#endif /* SPECENUM_VALUE55 */

#ifdef SPECENUM_VALUE56
  SPECENUM_VALUE56 = SPECENUM_VALUE(56),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE56
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE56
#endif /* SPECENUM_VALUE56 */

#ifdef SPECENUM_VALUE57
  SPECENUM_VALUE57 = SPECENUM_VALUE(57),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE57
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE57
#endif /* SPECENUM_VALUE57 */

#ifdef SPECENUM_VALUE58
  SPECENUM_VALUE58 = SPECENUM_VALUE(58),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE58
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE58
#endif /* SPECENUM_VALUE58 */

#ifdef SPECENUM_VALUE59
  SPECENUM_VALUE59 = SPECENUM_VALUE(59),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE59
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE59
#endif /* SPECENUM_VALUE59 */

#ifdef SPECENUM_VALUE60
  SPECENUM_VALUE60 = SPECENUM_VALUE(60),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE60
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE60
#endif /* SPECENUM_VALUE60 */

#ifdef SPECENUM_VALUE61
  SPECENUM_VALUE61 = SPECENUM_VALUE(61),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE61
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE61
#endif /* SPECENUM_VALUE61 */

#ifdef SPECENUM_VALUE62
  SPECENUM_VALUE62 = SPECENUM_VALUE(62),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE62
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE62
#endif /* SPECENUM_VALUE62 */

#ifdef SPECENUM_VALUE63
  SPECENUM_VALUE63 = SPECENUM_VALUE(63),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE63
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE63
#endif /* SPECENUM_VALUE63 */

#ifdef SPECENUM_VALUE64
  SPECENUM_VALUE64 = SPECENUM_VALUE(64),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE64
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE64
#endif /* SPECENUM_VALUE64 */

#ifdef SPECENUM_VALUE65
  SPECENUM_VALUE65 = SPECENUM_VALUE(65),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE65
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE65
#endif /* SPECENUM_VALUE65 */

#ifdef SPECENUM_VALUE66
  SPECENUM_VALUE66 = SPECENUM_VALUE(66),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE66
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE66
#endif /* SPECENUM_VALUE66 */

#ifdef SPECENUM_VALUE67
  SPECENUM_VALUE67 = SPECENUM_VALUE(67),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE67
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE67
#endif /* SPECENUM_VALUE67 */

#ifdef SPECENUM_VALUE68
  SPECENUM_VALUE68 = SPECENUM_VALUE(68),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE68
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE68
#endif /* SPECENUM_VALUE68 */

#ifdef SPECENUM_VALUE69
  SPECENUM_VALUE69 = SPECENUM_VALUE(69),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE69
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE69
#endif /* SPECENUM_VALUE69 */

#ifdef SPECENUM_VALUE70
  SPECENUM_VALUE70 = SPECENUM_VALUE(70),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE70
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE70
#endif /* SPECENUM_VALUE70 */

#ifdef SPECENUM_VALUE71
  SPECENUM_VALUE71 = SPECENUM_VALUE(71),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE71
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE71
#endif /* SPECENUM_VALUE71 */

#ifdef SPECENUM_VALUE72
  SPECENUM_VALUE72 = SPECENUM_VALUE(72),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE72
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE72
#endif /* SPECENUM_VALUE72 */

#ifdef SPECENUM_VALUE73
  SPECENUM_VALUE73 = SPECENUM_VALUE(73),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE73
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE73
#endif /* SPECENUM_VALUE73 */

#ifdef SPECENUM_VALUE74
  SPECENUM_VALUE74 = SPECENUM_VALUE(74),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE74
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE74
#endif /* SPECENUM_VALUE74 */

#ifdef SPECENUM_VALUE75
  SPECENUM_VALUE75 = SPECENUM_VALUE(75),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE75
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE75
#endif /* SPECENUM_VALUE75 */

#ifdef SPECENUM_VALUE76
  SPECENUM_VALUE76 = SPECENUM_VALUE(76),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE76
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE76
#endif /* SPECENUM_VALUE76 */

#ifdef SPECENUM_VALUE77
  SPECENUM_VALUE77 = SPECENUM_VALUE(77),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE77
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE77
#endif /* SPECENUM_VALUE77 */

#ifdef SPECENUM_VALUE78
  SPECENUM_VALUE78 = SPECENUM_VALUE(78),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE78
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE78
#endif /* SPECENUM_VALUE78 */

#ifdef SPECENUM_VALUE79
  SPECENUM_VALUE79 = SPECENUM_VALUE(79),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE79
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE79
#endif /* SPECENUM_VALUE79 */

#ifdef SPECENUM_VALUE80
  SPECENUM_VALUE80 = SPECENUM_VALUE(80),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE80
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE80
#endif /* SPECENUM_VALUE80 */

#ifdef SPECENUM_VALUE81
  SPECENUM_VALUE81 = SPECENUM_VALUE(81),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE81
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE81
#endif /* SPECENUM_VALUE81 */

#ifdef SPECENUM_VALUE82
  SPECENUM_VALUE82 = SPECENUM_VALUE(82),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE82
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE82
#endif /* SPECENUM_VALUE82 */

#ifdef SPECENUM_VALUE83
  SPECENUM_VALUE83 = SPECENUM_VALUE(83),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE83
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE83
#endif /* SPECENUM_VALUE83 */

#ifdef SPECENUM_VALUE84
  SPECENUM_VALUE84 = SPECENUM_VALUE(84),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE84
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE84
#endif /* SPECENUM_VALUE84 */

#ifdef SPECENUM_VALUE85
  SPECENUM_VALUE85 = SPECENUM_VALUE(85),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE85
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE85
#endif /* SPECENUM_VALUE85 */

#ifdef SPECENUM_VALUE86
  SPECENUM_VALUE86 = SPECENUM_VALUE(86),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE86
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE86
#endif /* SPECENUM_VALUE86 */

#ifdef SPECENUM_VALUE87
  SPECENUM_VALUE87 = SPECENUM_VALUE(87),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE87
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE87
#endif /* SPECENUM_VALUE87 */

#ifdef SPECENUM_VALUE88
  SPECENUM_VALUE88 = SPECENUM_VALUE(88),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE88
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE88
#endif /* SPECENUM_VALUE88 */

#ifdef SPECENUM_VALUE89
  SPECENUM_VALUE89 = SPECENUM_VALUE(89),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE89
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE89
#endif /* SPECENUM_VALUE89 */

#ifdef SPECENUM_VALUE90
  SPECENUM_VALUE90 = SPECENUM_VALUE(90),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE90
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE90
#endif /* SPECENUM_VALUE90 */

#ifdef SPECENUM_VALUE91
  SPECENUM_VALUE91 = SPECENUM_VALUE(91),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE91
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE91
#endif /* SPECENUM_VALUE91 */

#ifdef SPECENUM_VALUE92
  SPECENUM_VALUE92 = SPECENUM_VALUE(92),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE92
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE92
#endif /* SPECENUM_VALUE92 */

#ifdef SPECENUM_VALUE93
  SPECENUM_VALUE93 = SPECENUM_VALUE(93),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE93
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE93
#endif /* SPECENUM_VALUE93 */

#ifdef SPECENUM_VALUE94
  SPECENUM_VALUE94 = SPECENUM_VALUE(94),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE94
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE94
#endif /* SPECENUM_VALUE94 */

#ifdef SPECENUM_VALUE95
  SPECENUM_VALUE95 = SPECENUM_VALUE(95),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE95
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE95
#endif /* SPECENUM_VALUE95 */

#ifdef SPECENUM_VALUE96
  SPECENUM_VALUE96 = SPECENUM_VALUE(96),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE96
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE96
#endif /* SPECENUM_VALUE96 */

#ifdef SPECENUM_VALUE97
  SPECENUM_VALUE97 = SPECENUM_VALUE(97),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE97
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE97
#endif /* SPECENUM_VALUE97 */

#ifdef SPECENUM_VALUE98
  SPECENUM_VALUE98 = SPECENUM_VALUE(98),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE98
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE98
#endif /* SPECENUM_VALUE98 */

#ifdef SPECENUM_VALUE99
  SPECENUM_VALUE99 = SPECENUM_VALUE(99),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE99
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE99
#endif /* SPECENUM_VALUE99 */

#ifdef SPECENUM_VALUE100
  SPECENUM_VALUE100 = SPECENUM_VALUE(100),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE100
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE100
#endif /* SPECENUM_VALUE100 */

#ifdef SPECENUM_VALUE101
  SPECENUM_VALUE101 = SPECENUM_VALUE(101),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE101
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE101
#endif /* SPECENUM_VALUE101 */

#ifdef SPECENUM_VALUE102
  SPECENUM_VALUE102 = SPECENUM_VALUE(102),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE102
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE102
#endif /* SPECENUM_VALUE102 */

#ifdef SPECENUM_VALUE103
  SPECENUM_VALUE103 = SPECENUM_VALUE(103),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE103
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE103
#endif /* SPECENUM_VALUE103 */

#ifdef SPECENUM_VALUE104
  SPECENUM_VALUE104 = SPECENUM_VALUE(104),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE104
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE104
#endif /* SPECENUM_VALUE104 */

#ifdef SPECENUM_VALUE105
  SPECENUM_VALUE105 = SPECENUM_VALUE(105),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE105
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE105
#endif /* SPECENUM_VALUE105 */

#ifdef SPECENUM_VALUE106
  SPECENUM_VALUE106 = SPECENUM_VALUE(106),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE106
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE106
#endif /* SPECENUM_VALUE106 */

#ifdef SPECENUM_VALUE107
  SPECENUM_VALUE107 = SPECENUM_VALUE(107),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE107
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE107
#endif /* SPECENUM_VALUE107 */

#ifdef SPECENUM_VALUE108
  SPECENUM_VALUE108 = SPECENUM_VALUE(108),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE108
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE108
#endif /* SPECENUM_VALUE108 */

#ifdef SPECENUM_VALUE109
  SPECENUM_VALUE109 = SPECENUM_VALUE(109),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE109
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE109
#endif /* SPECENUM_VALUE109 */

#ifdef SPECENUM_VALUE110
  SPECENUM_VALUE110 = SPECENUM_VALUE(110),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE110
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE110
#endif /* SPECENUM_VALUE110 */

#ifdef SPECENUM_VALUE111
  SPECENUM_VALUE111 = SPECENUM_VALUE(111),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE111
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE111
#endif /* SPECENUM_VALUE111 */

#ifdef SPECENUM_VALUE112
  SPECENUM_VALUE112 = SPECENUM_VALUE(112),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE112
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE112
#endif /* SPECENUM_VALUE112 */

#ifdef SPECENUM_VALUE113
  SPECENUM_VALUE113 = SPECENUM_VALUE(113),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE113
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE113
#endif /* SPECENUM_VALUE113 */

#ifdef SPECENUM_VALUE114
  SPECENUM_VALUE114 = SPECENUM_VALUE(114),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE114
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE114
#endif /* SPECENUM_VALUE114 */

#ifdef SPECENUM_VALUE115
  SPECENUM_VALUE115 = SPECENUM_VALUE(115),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE115
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE115
#endif /* SPECENUM_VALUE115 */

#ifdef SPECENUM_VALUE116
  SPECENUM_VALUE116 = SPECENUM_VALUE(116),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE116
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE116
#endif /* SPECENUM_VALUE116 */

#ifdef SPECENUM_VALUE117
  SPECENUM_VALUE117 = SPECENUM_VALUE(117),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE117
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE117
#endif /* SPECENUM_VALUE117 */

#ifdef SPECENUM_VALUE118
  SPECENUM_VALUE118 = SPECENUM_VALUE(118),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE118
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE118
#endif /* SPECENUM_VALUE118 */

#ifdef SPECENUM_VALUE119
  SPECENUM_VALUE119 = SPECENUM_VALUE(119),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE119
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE119
#endif /* SPECENUM_VALUE119 */

#ifdef SPECENUM_VALUE120
  SPECENUM_VALUE120 = SPECENUM_VALUE(120),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE120
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE120
#endif /* SPECENUM_VALUE120 */

#ifdef SPECENUM_VALUE121
  SPECENUM_VALUE121 = SPECENUM_VALUE(121),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE121
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE121
#endif /* SPECENUM_VALUE121 */

#ifdef SPECENUM_VALUE122
  SPECENUM_VALUE122 = SPECENUM_VALUE(122),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE122
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE122
#endif /* SPECENUM_VALUE122 */

#ifdef SPECENUM_VALUE123
  SPECENUM_VALUE123 = SPECENUM_VALUE(123),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE123
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE123
#endif /* SPECENUM_VALUE123 */

#ifdef SPECENUM_VALUE124
  SPECENUM_VALUE124 = SPECENUM_VALUE(124),
#ifndef SPECENUM_MIN_VALUE
#define SPECENUM_MIN_VALUE SPECENUM_VALUE124
#endif
#ifdef SPECENUM_MAX_VALUE
#undef SPECENUM_MAX_VALUE
#endif
#define SPECENUM_MAX_VALUE SPECENUM_VALUE124
#endif /* SPECENUM_VALUE124 */

#ifdef SPECENUM_COUNT
  SPECENUM_COUNT = (SPECENUM_MAX_VALUE + 1),
#endif /* SPECENUM_COUNT */
};

/**************************************************************************
  Returns TRUE if this enumeration is in bitwise mode.
**************************************************************************/
static inline bool SPECENUM_FOO(_is_bitwise)(void)
{
#ifdef SPECENUM_BITWISE
  return TRUE;
#else
  return FALSE;
#endif
}

/**************************************************************************
  Returns the value of the minimal enumerator.
**************************************************************************/
static inline enum SPECENUM_NAME SPECENUM_FOO(_min)(void)
{
  return SPECENUM_MIN_VALUE;
}

/**************************************************************************
  Returns the value of the maximal enumerator.
**************************************************************************/
static inline enum SPECENUM_NAME SPECENUM_FOO(_max)(void)
{
  return SPECENUM_MAX_VALUE;
}

/**************************************************************************
  Returns TRUE if this enumerator was defined.
**************************************************************************/
static inline bool SPECENUM_FOO(_is_valid)(enum SPECENUM_NAME enumerator)
{
  switch (enumerator) {
#ifdef SPECENUM_ZERO
  case SPECENUM_ZERO:
#endif

#ifdef SPECENUM_VALUE0
  case SPECENUM_VALUE0:
#endif

#ifdef SPECENUM_VALUE1
  case SPECENUM_VALUE1:
#endif

#ifdef SPECENUM_VALUE2
  case SPECENUM_VALUE2:
#endif

#ifdef SPECENUM_VALUE3
  case SPECENUM_VALUE3:
#endif

#ifdef SPECENUM_VALUE4
  case SPECENUM_VALUE4:
#endif

#ifdef SPECENUM_VALUE5
  case SPECENUM_VALUE5:
#endif

#ifdef SPECENUM_VALUE6
  case SPECENUM_VALUE6:
#endif

#ifdef SPECENUM_VALUE7
  case SPECENUM_VALUE7:
#endif

#ifdef SPECENUM_VALUE8
  case SPECENUM_VALUE8:
#endif

#ifdef SPECENUM_VALUE9
  case SPECENUM_VALUE9:
#endif

#ifdef SPECENUM_VALUE10
  case SPECENUM_VALUE10:
#endif

#ifdef SPECENUM_VALUE11
  case SPECENUM_VALUE11:
#endif

#ifdef SPECENUM_VALUE12
  case SPECENUM_VALUE12:
#endif

#ifdef SPECENUM_VALUE13
  case SPECENUM_VALUE13:
#endif

#ifdef SPECENUM_VALUE14
  case SPECENUM_VALUE14:
#endif

#ifdef SPECENUM_VALUE15
  case SPECENUM_VALUE15:
#endif

#ifdef SPECENUM_VALUE16
  case SPECENUM_VALUE16:
#endif

#ifdef SPECENUM_VALUE17
  case SPECENUM_VALUE17:
#endif

#ifdef SPECENUM_VALUE18
  case SPECENUM_VALUE18:
#endif

#ifdef SPECENUM_VALUE19
  case SPECENUM_VALUE19:
#endif

#ifdef SPECENUM_VALUE20
  case SPECENUM_VALUE20:
#endif

#ifdef SPECENUM_VALUE21
  case SPECENUM_VALUE21:
#endif

#ifdef SPECENUM_VALUE22
  case SPECENUM_VALUE22:
#endif

#ifdef SPECENUM_VALUE23
  case SPECENUM_VALUE23:
#endif

#ifdef SPECENUM_VALUE24
  case SPECENUM_VALUE24:
#endif

#ifdef SPECENUM_VALUE25
  case SPECENUM_VALUE25:
#endif

#ifdef SPECENUM_VALUE26
  case SPECENUM_VALUE26:
#endif

#ifdef SPECENUM_VALUE27
  case SPECENUM_VALUE27:
#endif

#ifdef SPECENUM_VALUE28
  case SPECENUM_VALUE28:
#endif

#ifdef SPECENUM_VALUE29
  case SPECENUM_VALUE29:
#endif

#ifdef SPECENUM_VALUE30
  case SPECENUM_VALUE30:
#endif

#ifdef SPECENUM_VALUE31
  case SPECENUM_VALUE31:
#endif

#ifdef SPECENUM_VALUE32
  case SPECENUM_VALUE32:
#endif

#ifdef SPECENUM_VALUE33
  case SPECENUM_VALUE33:
#endif

#ifdef SPECENUM_VALUE34
  case SPECENUM_VALUE34:
#endif

#ifdef SPECENUM_VALUE35
  case SPECENUM_VALUE35:
#endif

#ifdef SPECENUM_VALUE36
  case SPECENUM_VALUE36:
#endif

#ifdef SPECENUM_VALUE37
  case SPECENUM_VALUE37:
#endif

#ifdef SPECENUM_VALUE38
  case SPECENUM_VALUE38:
#endif

#ifdef SPECENUM_VALUE39
  case SPECENUM_VALUE39:
#endif

#ifdef SPECENUM_VALUE40
  case SPECENUM_VALUE40:
#endif

#ifdef SPECENUM_VALUE41
  case SPECENUM_VALUE41:
#endif

#ifdef SPECENUM_VALUE42
  case SPECENUM_VALUE42:
#endif

#ifdef SPECENUM_VALUE43
  case SPECENUM_VALUE43:
#endif

#ifdef SPECENUM_VALUE44
  case SPECENUM_VALUE44:
#endif

#ifdef SPECENUM_VALUE45
  case SPECENUM_VALUE45:
#endif

#ifdef SPECENUM_VALUE46
  case SPECENUM_VALUE46:
#endif

#ifdef SPECENUM_VALUE47
  case SPECENUM_VALUE47:
#endif

#ifdef SPECENUM_VALUE48
  case SPECENUM_VALUE48:
#endif

#ifdef SPECENUM_VALUE49
  case SPECENUM_VALUE49:
#endif

#ifdef SPECENUM_VALUE50
  case SPECENUM_VALUE50:
#endif

#ifdef SPECENUM_VALUE51
  case SPECENUM_VALUE51:
#endif

#ifdef SPECENUM_VALUE52
  case SPECENUM_VALUE52:
#endif

#ifdef SPECENUM_VALUE53
  case SPECENUM_VALUE53:
#endif

#ifdef SPECENUM_VALUE54
  case SPECENUM_VALUE54:
#endif

#ifdef SPECENUM_VALUE55
  case SPECENUM_VALUE55:
#endif

#ifdef SPECENUM_VALUE56
  case SPECENUM_VALUE56:
#endif

#ifdef SPECENUM_VALUE57
  case SPECENUM_VALUE57:
#endif

#ifdef SPECENUM_VALUE58
  case SPECENUM_VALUE58:
#endif

#ifdef SPECENUM_VALUE59
  case SPECENUM_VALUE59:
#endif

#ifdef SPECENUM_VALUE60
  case SPECENUM_VALUE60:
#endif

#ifdef SPECENUM_VALUE61
  case SPECENUM_VALUE61:
#endif

#ifdef SPECENUM_VALUE62
  case SPECENUM_VALUE62:
#endif

#ifdef SPECENUM_VALUE63
  case SPECENUM_VALUE63:
#endif

#ifdef SPECENUM_VALUE64
  case SPECENUM_VALUE64:
#endif

#ifdef SPECENUM_VALUE65
  case SPECENUM_VALUE65:
#endif

#ifdef SPECENUM_VALUE66
  case SPECENUM_VALUE66:
#endif

#ifdef SPECENUM_VALUE67
  case SPECENUM_VALUE67:
#endif

#ifdef SPECENUM_VALUE68
  case SPECENUM_VALUE68:
#endif

#ifdef SPECENUM_VALUE69
  case SPECENUM_VALUE69:
#endif

#ifdef SPECENUM_VALUE70
  case SPECENUM_VALUE70:
#endif

#ifdef SPECENUM_VALUE71
  case SPECENUM_VALUE71:
#endif

#ifdef SPECENUM_VALUE72
  case SPECENUM_VALUE72:
#endif

#ifdef SPECENUM_VALUE73
  case SPECENUM_VALUE73:
#endif

#ifdef SPECENUM_VALUE74
  case SPECENUM_VALUE74:
#endif

#ifdef SPECENUM_VALUE75
  case SPECENUM_VALUE75:
#endif

#ifdef SPECENUM_VALUE76
  case SPECENUM_VALUE76:
#endif

#ifdef SPECENUM_VALUE77
  case SPECENUM_VALUE77:
#endif

#ifdef SPECENUM_VALUE78
  case SPECENUM_VALUE78:
#endif

#ifdef SPECENUM_VALUE79
  case SPECENUM_VALUE79:
#endif

#ifdef SPECENUM_VALUE80
  case SPECENUM_VALUE80:
#endif

#ifdef SPECENUM_VALUE81
  case SPECENUM_VALUE81:
#endif

#ifdef SPECENUM_VALUE82
  case SPECENUM_VALUE82:
#endif

#ifdef SPECENUM_VALUE83
  case SPECENUM_VALUE83:
#endif

#ifdef SPECENUM_VALUE84
  case SPECENUM_VALUE84:
#endif

#ifdef SPECENUM_VALUE85
  case SPECENUM_VALUE85:
#endif

#ifdef SPECENUM_VALUE86
  case SPECENUM_VALUE86:
#endif

#ifdef SPECENUM_VALUE87
  case SPECENUM_VALUE87:
#endif

#ifdef SPECENUM_VALUE88
  case SPECENUM_VALUE88:
#endif

#ifdef SPECENUM_VALUE89
  case SPECENUM_VALUE89:
#endif

#ifdef SPECENUM_VALUE90
  case SPECENUM_VALUE90:
#endif

#ifdef SPECENUM_VALUE91
  case SPECENUM_VALUE91:
#endif

#ifdef SPECENUM_VALUE92
  case SPECENUM_VALUE92:
#endif

#ifdef SPECENUM_VALUE93
  case SPECENUM_VALUE93:
#endif

#ifdef SPECENUM_VALUE94
  case SPECENUM_VALUE94:
#endif

#ifdef SPECENUM_VALUE95
  case SPECENUM_VALUE95:
#endif

#ifdef SPECENUM_VALUE96
  case SPECENUM_VALUE96:
#endif

#ifdef SPECENUM_VALUE97
  case SPECENUM_VALUE97:
#endif

#ifdef SPECENUM_VALUE98
  case SPECENUM_VALUE98:
#endif

#ifdef SPECENUM_VALUE99
  case SPECENUM_VALUE99:
#endif

#ifdef SPECENUM_VALUE100
  case SPECENUM_VALUE100:
#endif

#ifdef SPECENUM_VALUE101
  case SPECENUM_VALUE101:
#endif

#ifdef SPECENUM_VALUE102
  case SPECENUM_VALUE102:
#endif

#ifdef SPECENUM_VALUE103
  case SPECENUM_VALUE103:
#endif

#ifdef SPECENUM_VALUE104
  case SPECENUM_VALUE104:
#endif

#ifdef SPECENUM_VALUE105
  case SPECENUM_VALUE105:
#endif

#ifdef SPECENUM_VALUE106
  case SPECENUM_VALUE106:
#endif

#ifdef SPECENUM_VALUE107
  case SPECENUM_VALUE107:
#endif

#ifdef SPECENUM_VALUE108
  case SPECENUM_VALUE108:
#endif

#ifdef SPECENUM_VALUE109
  case SPECENUM_VALUE109:
#endif

#ifdef SPECENUM_VALUE110
  case SPECENUM_VALUE110:
#endif

#ifdef SPECENUM_VALUE111
  case SPECENUM_VALUE111:
#endif

#ifdef SPECENUM_VALUE112
  case SPECENUM_VALUE112:
#endif

#ifdef SPECENUM_VALUE113
  case SPECENUM_VALUE113:
#endif

#ifdef SPECENUM_VALUE114
  case SPECENUM_VALUE114:
#endif

#ifdef SPECENUM_VALUE115
  case SPECENUM_VALUE115:
#endif

#ifdef SPECENUM_VALUE116
  case SPECENUM_VALUE116:
#endif

#ifdef SPECENUM_VALUE117
  case SPECENUM_VALUE117:
#endif

#ifdef SPECENUM_VALUE118
  case SPECENUM_VALUE118:
#endif

#ifdef SPECENUM_VALUE119
  case SPECENUM_VALUE119:
#endif

#ifdef SPECENUM_VALUE120
  case SPECENUM_VALUE120:
#endif

#ifdef SPECENUM_VALUE121
  case SPECENUM_VALUE121:
#endif

#ifdef SPECENUM_VALUE122
  case SPECENUM_VALUE122:
#endif

#ifdef SPECENUM_VALUE123
  case SPECENUM_VALUE123:
#endif

#ifdef SPECENUM_VALUE124
  case SPECENUM_VALUE124:
#endif

    return TRUE;
#ifdef SPECENUM_COUNT
  case SPECENUM_COUNT:
    return FALSE;
#endif /* SPECENUM_COUNT */
  }

  return FALSE;
}

/**************************************************************************
  Returns an invalid enumerator value.
**************************************************************************/
static inline enum SPECENUM_NAME SPECENUM_FOO(_invalid)(void)
{
  fc_assert(!SPECENUM_FOO(_is_valid(SPECENUM_INVALID)));
  return SPECENUM_INVALID;
}

/**************************************************************************
  Beginning of the iteration of the enumerators.
**************************************************************************/
static inline enum SPECENUM_NAME SPECENUM_FOO(_begin)(void)
{
  return SPECENUM_FOO(_min)();
}

/**************************************************************************
  End of the iteration of the enumerators.
**************************************************************************/
static inline enum SPECENUM_NAME SPECENUM_FOO(_end)(void)
{
  return SPECENUM_FOO(_invalid)();
}

/**************************************************************************
  Find the next valid enumerator value.
**************************************************************************/
static inline enum SPECENUM_NAME SPECENUM_FOO(_next)(enum SPECENUM_NAME e)
{
  do {
#ifdef SPECENUM_BITWISE
    e = (enum SPECENUM_NAME)(e << 1);
#else
    e = (enum SPECENUM_NAME)(e + 1);
#endif

    if (e > SPECENUM_FOO(_max)()) {
      /* End of the iteration. */
      return SPECENUM_FOO(_invalid)();
    }
  } while (!SPECENUM_FOO(_is_valid)(e));

  return e;
}

/**************************************************************************
  Returns the name of the enumerator.
**************************************************************************/
static inline const char *SPECENUM_FOO(_name)(enum SPECENUM_NAME enumerator)
{
  switch (enumerator) {
#ifdef SPECENUM_ZERO
  case SPECENUM_ZERO:
#ifdef SPECENUM_ZERONAME
    return SPECENUM_ZERONAME;
#else
    return SPECENUM_STRING(SPECENUM_ZERO);
#endif
#endif /* SPECENUM_ZERO */

#ifdef SPECENUM_VALUE0
  case SPECENUM_VALUE0:
#ifdef SPECENUM_VALUE0NAME
    return SPECENUM_VALUE0NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE0);
#endif
#endif /* SPECENUM_VALUE0 */

#ifdef SPECENUM_VALUE1
  case SPECENUM_VALUE1:
#ifdef SPECENUM_VALUE1NAME
    return SPECENUM_VALUE1NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE1);
#endif
#endif /* SPECENUM_VALUE1 */

#ifdef SPECENUM_VALUE2
  case SPECENUM_VALUE2:
#ifdef SPECENUM_VALUE2NAME
    return SPECENUM_VALUE2NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE2);
#endif
#endif /* SPECENUM_VALUE2 */

#ifdef SPECENUM_VALUE3
  case SPECENUM_VALUE3:
#ifdef SPECENUM_VALUE3NAME
    return SPECENUM_VALUE3NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE3);
#endif
#endif /* SPECENUM_VALUE3 */

#ifdef SPECENUM_VALUE4
  case SPECENUM_VALUE4:
#ifdef SPECENUM_VALUE4NAME
    return SPECENUM_VALUE4NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE4);
#endif
#endif /* SPECENUM_VALUE4 */

#ifdef SPECENUM_VALUE5
  case SPECENUM_VALUE5:
#ifdef SPECENUM_VALUE5NAME
    return SPECENUM_VALUE5NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE5);
#endif
#endif /* SPECENUM_VALUE5 */

#ifdef SPECENUM_VALUE6
  case SPECENUM_VALUE6:
#ifdef SPECENUM_VALUE6NAME
    return SPECENUM_VALUE6NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE6);
#endif
#endif /* SPECENUM_VALUE6 */

#ifdef SPECENUM_VALUE7
  case SPECENUM_VALUE7:
#ifdef SPECENUM_VALUE7NAME
    return SPECENUM_VALUE7NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE7);
#endif
#endif /* SPECENUM_VALUE7 */

#ifdef SPECENUM_VALUE8
  case SPECENUM_VALUE8:
#ifdef SPECENUM_VALUE8NAME
    return SPECENUM_VALUE8NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE8);
#endif
#endif /* SPECENUM_VALUE8 */

#ifdef SPECENUM_VALUE9
  case SPECENUM_VALUE9:
#ifdef SPECENUM_VALUE9NAME
    return SPECENUM_VALUE9NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE9);
#endif
#endif /* SPECENUM_VALUE9 */

#ifdef SPECENUM_VALUE10
  case SPECENUM_VALUE10:
#ifdef SPECENUM_VALUE10NAME
    return SPECENUM_VALUE10NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE10);
#endif
#endif /* SPECENUM_VALUE10 */

#ifdef SPECENUM_VALUE11
  case SPECENUM_VALUE11:
#ifdef SPECENUM_VALUE11NAME
    return SPECENUM_VALUE11NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE11);
#endif
#endif /* SPECENUM_VALUE11 */

#ifdef SPECENUM_VALUE12
  case SPECENUM_VALUE12:
#ifdef SPECENUM_VALUE12NAME
    return SPECENUM_VALUE12NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE12);
#endif
#endif /* SPECENUM_VALUE12 */

#ifdef SPECENUM_VALUE13
  case SPECENUM_VALUE13:
#ifdef SPECENUM_VALUE13NAME
    return SPECENUM_VALUE13NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE13);
#endif
#endif /* SPECENUM_VALUE13 */

#ifdef SPECENUM_VALUE14
  case SPECENUM_VALUE14:
#ifdef SPECENUM_VALUE14NAME
    return SPECENUM_VALUE14NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE14);
#endif
#endif /* SPECENUM_VALUE14 */

#ifdef SPECENUM_VALUE15
  case SPECENUM_VALUE15:
#ifdef SPECENUM_VALUE15NAME
    return SPECENUM_VALUE15NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE15);
#endif
#endif /* SPECENUM_VALUE15 */

#ifdef SPECENUM_VALUE16
  case SPECENUM_VALUE16:
#ifdef SPECENUM_VALUE16NAME
    return SPECENUM_VALUE16NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE16);
#endif
#endif /* SPECENUM_VALUE16 */

#ifdef SPECENUM_VALUE17
  case SPECENUM_VALUE17:
#ifdef SPECENUM_VALUE17NAME
    return SPECENUM_VALUE17NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE17);
#endif
#endif /* SPECENUM_VALUE17 */

#ifdef SPECENUM_VALUE18
  case SPECENUM_VALUE18:
#ifdef SPECENUM_VALUE18NAME
    return SPECENUM_VALUE18NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE18);
#endif
#endif /* SPECENUM_VALUE18 */

#ifdef SPECENUM_VALUE19
  case SPECENUM_VALUE19:
#ifdef SPECENUM_VALUE19NAME
    return SPECENUM_VALUE19NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE19);
#endif
#endif /* SPECENUM_VALUE19 */

#ifdef SPECENUM_VALUE20
  case SPECENUM_VALUE20:
#ifdef SPECENUM_VALUE20NAME
    return SPECENUM_VALUE20NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE20);
#endif
#endif /* SPECENUM_VALUE20 */

#ifdef SPECENUM_VALUE21
  case SPECENUM_VALUE21:
#ifdef SPECENUM_VALUE21NAME
    return SPECENUM_VALUE21NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE21);
#endif
#endif /* SPECENUM_VALUE21 */

#ifdef SPECENUM_VALUE22
  case SPECENUM_VALUE22:
#ifdef SPECENUM_VALUE22NAME
    return SPECENUM_VALUE22NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE22);
#endif
#endif /* SPECENUM_VALUE22 */

#ifdef SPECENUM_VALUE23
  case SPECENUM_VALUE23:
#ifdef SPECENUM_VALUE23NAME
    return SPECENUM_VALUE23NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE23);
#endif
#endif /* SPECENUM_VALUE23 */

#ifdef SPECENUM_VALUE24
  case SPECENUM_VALUE24:
#ifdef SPECENUM_VALUE24NAME
    return SPECENUM_VALUE24NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE24);
#endif
#endif /* SPECENUM_VALUE24 */

#ifdef SPECENUM_VALUE25
  case SPECENUM_VALUE25:
#ifdef SPECENUM_VALUE25NAME
    return SPECENUM_VALUE25NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE25);
#endif
#endif /* SPECENUM_VALUE25 */

#ifdef SPECENUM_VALUE26
  case SPECENUM_VALUE26:
#ifdef SPECENUM_VALUE26NAME
    return SPECENUM_VALUE26NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE26);
#endif
#endif /* SPECENUM_VALUE26 */

#ifdef SPECENUM_VALUE27
  case SPECENUM_VALUE27:
#ifdef SPECENUM_VALUE27NAME
    return SPECENUM_VALUE27NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE27);
#endif
#endif /* SPECENUM_VALUE27 */

#ifdef SPECENUM_VALUE28
  case SPECENUM_VALUE28:
#ifdef SPECENUM_VALUE28NAME
    return SPECENUM_VALUE28NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE28);
#endif
#endif /* SPECENUM_VALUE28 */

#ifdef SPECENUM_VALUE29
  case SPECENUM_VALUE29:
#ifdef SPECENUM_VALUE29NAME
    return SPECENUM_VALUE29NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE29);
#endif
#endif /* SPECENUM_VALUE29 */

#ifdef SPECENUM_VALUE30
  case SPECENUM_VALUE30:
#ifdef SPECENUM_VALUE30NAME
    return SPECENUM_VALUE30NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE30);
#endif
#endif /* SPECENUM_VALUE30 */

#ifdef SPECENUM_VALUE31
  case SPECENUM_VALUE31:
#ifdef SPECENUM_VALUE31NAME
    return SPECENUM_VALUE31NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE31);
#endif
#endif /* SPECENUM_VALUE31 */

#ifdef SPECENUM_VALUE32
  case SPECENUM_VALUE32:
#ifdef SPECENUM_VALUE32NAME
    return SPECENUM_VALUE32NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE32);
#endif
#endif /* SPECENUM_VALUE32 */

#ifdef SPECENUM_VALUE33
  case SPECENUM_VALUE33:
#ifdef SPECENUM_VALUE33NAME
    return SPECENUM_VALUE33NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE33);
#endif
#endif /* SPECENUM_VALUE33 */

#ifdef SPECENUM_VALUE34
  case SPECENUM_VALUE34:
#ifdef SPECENUM_VALUE34NAME
    return SPECENUM_VALUE34NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE34);
#endif
#endif /* SPECENUM_VALUE34 */

#ifdef SPECENUM_VALUE35
  case SPECENUM_VALUE35:
#ifdef SPECENUM_VALUE35NAME
    return SPECENUM_VALUE35NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE35);
#endif
#endif /* SPECENUM_VALUE35 */

#ifdef SPECENUM_VALUE36
  case SPECENUM_VALUE36:
#ifdef SPECENUM_VALUE36NAME
    return SPECENUM_VALUE36NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE36);
#endif
#endif /* SPECENUM_VALUE36 */

#ifdef SPECENUM_VALUE37
  case SPECENUM_VALUE37:
#ifdef SPECENUM_VALUE37NAME
    return SPECENUM_VALUE37NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE37);
#endif
#endif /* SPECENUM_VALUE37 */

#ifdef SPECENUM_VALUE38
  case SPECENUM_VALUE38:
#ifdef SPECENUM_VALUE38NAME
    return SPECENUM_VALUE38NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE38);
#endif
#endif /* SPECENUM_VALUE38 */

#ifdef SPECENUM_VALUE39
  case SPECENUM_VALUE39:
#ifdef SPECENUM_VALUE39NAME
    return SPECENUM_VALUE39NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE39);
#endif
#endif /* SPECENUM_VALUE39 */

#ifdef SPECENUM_VALUE40
  case SPECENUM_VALUE40:
#ifdef SPECENUM_VALUE40NAME
    return SPECENUM_VALUE40NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE40);
#endif
#endif /* SPECENUM_VALUE40 */

#ifdef SPECENUM_VALUE41
  case SPECENUM_VALUE41:
#ifdef SPECENUM_VALUE41NAME
    return SPECENUM_VALUE41NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE41);
#endif
#endif /* SPECENUM_VALUE41 */

#ifdef SPECENUM_VALUE42
  case SPECENUM_VALUE42:
#ifdef SPECENUM_VALUE42NAME
    return SPECENUM_VALUE42NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE42);
#endif
#endif /* SPECENUM_VALUE42 */

#ifdef SPECENUM_VALUE43
  case SPECENUM_VALUE43:
#ifdef SPECENUM_VALUE43NAME
    return SPECENUM_VALUE43NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE43);
#endif
#endif /* SPECENUM_VALUE43 */

#ifdef SPECENUM_VALUE44
  case SPECENUM_VALUE44:
#ifdef SPECENUM_VALUE44NAME
    return SPECENUM_VALUE44NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE44);
#endif
#endif /* SPECENUM_VALUE44 */

#ifdef SPECENUM_VALUE45
  case SPECENUM_VALUE45:
#ifdef SPECENUM_VALUE45NAME
    return SPECENUM_VALUE45NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE45);
#endif
#endif /* SPECENUM_VALUE45 */

#ifdef SPECENUM_VALUE46
  case SPECENUM_VALUE46:
#ifdef SPECENUM_VALUE46NAME
    return SPECENUM_VALUE46NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE46);
#endif
#endif /* SPECENUM_VALUE46 */

#ifdef SPECENUM_VALUE47
  case SPECENUM_VALUE47:
#ifdef SPECENUM_VALUE47NAME
    return SPECENUM_VALUE47NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE47);
#endif
#endif /* SPECENUM_VALUE47 */

#ifdef SPECENUM_VALUE48
  case SPECENUM_VALUE48:
#ifdef SPECENUM_VALUE48NAME
    return SPECENUM_VALUE48NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE48);
#endif
#endif /* SPECENUM_VALUE48 */

#ifdef SPECENUM_VALUE49
  case SPECENUM_VALUE49:
#ifdef SPECENUM_VALUE49NAME
    return SPECENUM_VALUE49NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE49);
#endif
#endif /* SPECENUM_VALUE49 */

#ifdef SPECENUM_VALUE50
  case SPECENUM_VALUE50:
#ifdef SPECENUM_VALUE50NAME
    return SPECENUM_VALUE50NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE50);
#endif
#endif /* SPECENUM_VALUE50 */

#ifdef SPECENUM_VALUE51
  case SPECENUM_VALUE51:
#ifdef SPECENUM_VALUE51NAME
    return SPECENUM_VALUE51NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE51);
#endif
#endif /* SPECENUM_VALUE51 */

#ifdef SPECENUM_VALUE52
  case SPECENUM_VALUE52:
#ifdef SPECENUM_VALUE52NAME
    return SPECENUM_VALUE52NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE52);
#endif
#endif /* SPECENUM_VALUE52 */

#ifdef SPECENUM_VALUE53
  case SPECENUM_VALUE53:
#ifdef SPECENUM_VALUE53NAME
    return SPECENUM_VALUE53NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE53);
#endif
#endif /* SPECENUM_VALUE53 */

#ifdef SPECENUM_VALUE54
  case SPECENUM_VALUE54:
#ifdef SPECENUM_VALUE54NAME
    return SPECENUM_VALUE54NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE54);
#endif
#endif /* SPECENUM_VALUE54 */

#ifdef SPECENUM_VALUE55
  case SPECENUM_VALUE55:
#ifdef SPECENUM_VALUE55NAME
    return SPECENUM_VALUE55NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE55);
#endif
#endif /* SPECENUM_VALUE55 */

#ifdef SPECENUM_VALUE56
  case SPECENUM_VALUE56:
#ifdef SPECENUM_VALUE56NAME
    return SPECENUM_VALUE56NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE56);
#endif
#endif /* SPECENUM_VALUE56 */

#ifdef SPECENUM_VALUE57
  case SPECENUM_VALUE57:
#ifdef SPECENUM_VALUE57NAME
    return SPECENUM_VALUE57NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE57);
#endif
#endif /* SPECENUM_VALUE57 */

#ifdef SPECENUM_VALUE58
  case SPECENUM_VALUE58:
#ifdef SPECENUM_VALUE58NAME
    return SPECENUM_VALUE58NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE58);
#endif
#endif /* SPECENUM_VALUE58 */

#ifdef SPECENUM_VALUE59
  case SPECENUM_VALUE59:
#ifdef SPECENUM_VALUE59NAME
    return SPECENUM_VALUE59NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE59);
#endif
#endif /* SPECENUM_VALUE59 */

#ifdef SPECENUM_VALUE60
  case SPECENUM_VALUE60:
#ifdef SPECENUM_VALUE60NAME
    return SPECENUM_VALUE60NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE60);
#endif
#endif /* SPECENUM_VALUE60 */

#ifdef SPECENUM_VALUE61
  case SPECENUM_VALUE61:
#ifdef SPECENUM_VALUE61NAME
    return SPECENUM_VALUE61NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE61);
#endif
#endif /* SPECENUM_VALUE61 */

#ifdef SPECENUM_VALUE62
  case SPECENUM_VALUE62:
#ifdef SPECENUM_VALUE62NAME
    return SPECENUM_VALUE62NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE62);
#endif
#endif /* SPECENUM_VALUE62 */

#ifdef SPECENUM_VALUE63
  case SPECENUM_VALUE63:
#ifdef SPECENUM_VALUE63NAME
    return SPECENUM_VALUE63NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE63);
#endif
#endif /* SPECENUM_VALUE63 */

#ifdef SPECENUM_VALUE64
  case SPECENUM_VALUE64:
#ifdef SPECENUM_VALUE64NAME
    return SPECENUM_VALUE64NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE64);
#endif
#endif /* SPECENUM_VALUE64 */

#ifdef SPECENUM_VALUE65
  case SPECENUM_VALUE65:
#ifdef SPECENUM_VALUE65NAME
    return SPECENUM_VALUE65NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE65);
#endif
#endif /* SPECENUM_VALUE65 */

#ifdef SPECENUM_VALUE66
  case SPECENUM_VALUE66:
#ifdef SPECENUM_VALUE66NAME
    return SPECENUM_VALUE66NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE66);
#endif
#endif /* SPECENUM_VALUE66 */

#ifdef SPECENUM_VALUE67
  case SPECENUM_VALUE67:
#ifdef SPECENUM_VALUE67NAME
    return SPECENUM_VALUE67NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE67);
#endif
#endif /* SPECENUM_VALUE67 */

#ifdef SPECENUM_VALUE68
  case SPECENUM_VALUE68:
#ifdef SPECENUM_VALUE68NAME
    return SPECENUM_VALUE68NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE68);
#endif
#endif /* SPECENUM_VALUE68 */

#ifdef SPECENUM_VALUE69
  case SPECENUM_VALUE69:
#ifdef SPECENUM_VALUE69NAME
    return SPECENUM_VALUE69NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE69);
#endif
#endif /* SPECENUM_VALUE69 */

#ifdef SPECENUM_VALUE70
  case SPECENUM_VALUE70:
#ifdef SPECENUM_VALUE70NAME
    return SPECENUM_VALUE70NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE70);
#endif
#endif /* SPECENUM_VALUE70 */

#ifdef SPECENUM_VALUE71
  case SPECENUM_VALUE71:
#ifdef SPECENUM_VALUE71NAME
    return SPECENUM_VALUE71NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE71);
#endif
#endif /* SPECENUM_VALUE71 */

#ifdef SPECENUM_VALUE72
  case SPECENUM_VALUE72:
#ifdef SPECENUM_VALUE72NAME
    return SPECENUM_VALUE72NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE72);
#endif
#endif /* SPECENUM_VALUE72 */

#ifdef SPECENUM_VALUE73
  case SPECENUM_VALUE73:
#ifdef SPECENUM_VALUE73NAME
    return SPECENUM_VALUE73NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE73);
#endif
#endif /* SPECENUM_VALUE73 */

#ifdef SPECENUM_VALUE74
  case SPECENUM_VALUE74:
#ifdef SPECENUM_VALUE74NAME
    return SPECENUM_VALUE74NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE74);
#endif
#endif /* SPECENUM_VALUE74 */

#ifdef SPECENUM_VALUE75
  case SPECENUM_VALUE75:
#ifdef SPECENUM_VALUE75NAME
    return SPECENUM_VALUE75NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE75);
#endif
#endif /* SPECENUM_VALUE75 */

#ifdef SPECENUM_VALUE76
  case SPECENUM_VALUE76:
#ifdef SPECENUM_VALUE76NAME
    return SPECENUM_VALUE76NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE76);
#endif
#endif /* SPECENUM_VALUE76 */

#ifdef SPECENUM_VALUE77
  case SPECENUM_VALUE77:
#ifdef SPECENUM_VALUE77NAME
    return SPECENUM_VALUE77NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE77);
#endif
#endif /* SPECENUM_VALUE77 */

#ifdef SPECENUM_VALUE78
  case SPECENUM_VALUE78:
#ifdef SPECENUM_VALUE78NAME
    return SPECENUM_VALUE78NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE78);
#endif
#endif /* SPECENUM_VALUE78 */

#ifdef SPECENUM_VALUE79
  case SPECENUM_VALUE79:
#ifdef SPECENUM_VALUE79NAME
    return SPECENUM_VALUE79NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE79);
#endif
#endif /* SPECENUM_VALUE79 */

#ifdef SPECENUM_VALUE80
  case SPECENUM_VALUE80:
#ifdef SPECENUM_VALUE80NAME
    return SPECENUM_VALUE80NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE80);
#endif
#endif /* SPECENUM_VALUE80 */

#ifdef SPECENUM_VALUE81
  case SPECENUM_VALUE81:
#ifdef SPECENUM_VALUE81NAME
    return SPECENUM_VALUE81NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE81);
#endif
#endif /* SPECENUM_VALUE81 */

#ifdef SPECENUM_VALUE82
  case SPECENUM_VALUE82:
#ifdef SPECENUM_VALUE82NAME
    return SPECENUM_VALUE82NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE82);
#endif
#endif /* SPECENUM_VALUE82 */

#ifdef SPECENUM_VALUE83
  case SPECENUM_VALUE83:
#ifdef SPECENUM_VALUE83NAME
    return SPECENUM_VALUE83NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE83);
#endif
#endif /* SPECENUM_VALUE83 */

#ifdef SPECENUM_VALUE84
  case SPECENUM_VALUE84:
#ifdef SPECENUM_VALUE84NAME
    return SPECENUM_VALUE84NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE84);
#endif
#endif /* SPECENUM_VALUE84 */

#ifdef SPECENUM_VALUE85
  case SPECENUM_VALUE85:
#ifdef SPECENUM_VALUE85NAME
    return SPECENUM_VALUE85NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE85);
#endif
#endif /* SPECENUM_VALUE85 */

#ifdef SPECENUM_VALUE86
  case SPECENUM_VALUE86:
#ifdef SPECENUM_VALUE86NAME
    return SPECENUM_VALUE86NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE86);
#endif
#endif /* SPECENUM_VALUE86 */

#ifdef SPECENUM_VALUE87
  case SPECENUM_VALUE87:
#ifdef SPECENUM_VALUE87NAME
    return SPECENUM_VALUE87NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE87);
#endif
#endif /* SPECENUM_VALUE87 */

#ifdef SPECENUM_VALUE88
  case SPECENUM_VALUE88:
#ifdef SPECENUM_VALUE88NAME
    return SPECENUM_VALUE88NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE88);
#endif
#endif /* SPECENUM_VALUE88 */

#ifdef SPECENUM_VALUE89
  case SPECENUM_VALUE89:
#ifdef SPECENUM_VALUE89NAME
    return SPECENUM_VALUE89NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE89);
#endif
#endif /* SPECENUM_VALUE89 */

#ifdef SPECENUM_VALUE90
  case SPECENUM_VALUE90:
#ifdef SPECENUM_VALUE90NAME
    return SPECENUM_VALUE90NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE90);
#endif
#endif /* SPECENUM_VALUE90 */

#ifdef SPECENUM_VALUE91
  case SPECENUM_VALUE91:
#ifdef SPECENUM_VALUE91NAME
    return SPECENUM_VALUE91NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE91);
#endif
#endif /* SPECENUM_VALUE91 */

#ifdef SPECENUM_VALUE92
  case SPECENUM_VALUE92:
#ifdef SPECENUM_VALUE92NAME
    return SPECENUM_VALUE92NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE92);
#endif
#endif /* SPECENUM_VALUE92 */

#ifdef SPECENUM_VALUE93
  case SPECENUM_VALUE93:
#ifdef SPECENUM_VALUE93NAME
    return SPECENUM_VALUE93NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE93);
#endif
#endif /* SPECENUM_VALUE93 */

#ifdef SPECENUM_VALUE94
  case SPECENUM_VALUE94:
#ifdef SPECENUM_VALUE94NAME
    return SPECENUM_VALUE94NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE94);
#endif
#endif /* SPECENUM_VALUE94 */

#ifdef SPECENUM_VALUE95
  case SPECENUM_VALUE95:
#ifdef SPECENUM_VALUE95NAME
    return SPECENUM_VALUE95NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE95);
#endif
#endif /* SPECENUM_VALUE95 */

#ifdef SPECENUM_VALUE96
  case SPECENUM_VALUE96:
#ifdef SPECENUM_VALUE96NAME
    return SPECENUM_VALUE96NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE96);
#endif
#endif /* SPECENUM_VALUE96 */

#ifdef SPECENUM_VALUE97
  case SPECENUM_VALUE97:
#ifdef SPECENUM_VALUE97NAME
    return SPECENUM_VALUE97NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE97);
#endif
#endif /* SPECENUM_VALUE97 */

#ifdef SPECENUM_VALUE98
  case SPECENUM_VALUE98:
#ifdef SPECENUM_VALUE98NAME
    return SPECENUM_VALUE98NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE98);
#endif
#endif /* SPECENUM_VALUE98 */

#ifdef SPECENUM_VALUE99
  case SPECENUM_VALUE99:
#ifdef SPECENUM_VALUE99NAME
    return SPECENUM_VALUE99NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE99);
#endif
#endif /* SPECENUM_VALUE99 */

#ifdef SPECENUM_VALUE100
  case SPECENUM_VALUE100:
#ifdef SPECENUM_VALUE100NAME
    return SPECENUM_VALUE100NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE100);
#endif
#endif /* SPECENUM_VALUE100 */

#ifdef SPECENUM_VALUE101
  case SPECENUM_VALUE101:
#ifdef SPECENUM_VALUE101NAME
    return SPECENUM_VALUE101NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE101);
#endif
#endif /* SPECENUM_VALUE101 */

#ifdef SPECENUM_VALUE102
  case SPECENUM_VALUE102:
#ifdef SPECENUM_VALUE102NAME
    return SPECENUM_VALUE102NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE102);
#endif
#endif /* SPECENUM_VALUE102 */

#ifdef SPECENUM_VALUE103
  case SPECENUM_VALUE103:
#ifdef SPECENUM_VALUE103NAME
    return SPECENUM_VALUE103NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE103);
#endif
#endif /* SPECENUM_VALUE103 */

#ifdef SPECENUM_VALUE104
  case SPECENUM_VALUE104:
#ifdef SPECENUM_VALUE104NAME
    return SPECENUM_VALUE104NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE104);
#endif
#endif /* SPECENUM_VALUE104 */

#ifdef SPECENUM_VALUE105
  case SPECENUM_VALUE105:
#ifdef SPECENUM_VALUE105NAME
    return SPECENUM_VALUE105NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE105);
#endif
#endif /* SPECENUM_VALUE105 */

#ifdef SPECENUM_VALUE106
  case SPECENUM_VALUE106:
#ifdef SPECENUM_VALUE106NAME
    return SPECENUM_VALUE106NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE106);
#endif
#endif /* SPECENUM_VALUE106 */

#ifdef SPECENUM_VALUE107
  case SPECENUM_VALUE107:
#ifdef SPECENUM_VALUE107NAME
    return SPECENUM_VALUE107NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE107);
#endif
#endif /* SPECENUM_VALUE107 */

#ifdef SPECENUM_VALUE108
  case SPECENUM_VALUE108:
#ifdef SPECENUM_VALUE108NAME
    return SPECENUM_VALUE108NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE108);
#endif
#endif /* SPECENUM_VALUE108 */

#ifdef SPECENUM_VALUE109
  case SPECENUM_VALUE109:
#ifdef SPECENUM_VALUE109NAME
    return SPECENUM_VALUE109NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE109);
#endif
#endif /* SPECENUM_VALUE109 */

#ifdef SPECENUM_VALUE110
  case SPECENUM_VALUE110:
#ifdef SPECENUM_VALUE110NAME
    return SPECENUM_VALUE110NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE110);
#endif
#endif /* SPECENUM_VALUE110 */

#ifdef SPECENUM_VALUE111
  case SPECENUM_VALUE111:
#ifdef SPECENUM_VALUE111NAME
    return SPECENUM_VALUE111NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE111);
#endif
#endif /* SPECENUM_VALUE111 */

#ifdef SPECENUM_VALUE112
  case SPECENUM_VALUE112:
#ifdef SPECENUM_VALUE112NAME
    return SPECENUM_VALUE112NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE112);
#endif
#endif /* SPECENUM_VALUE112 */

#ifdef SPECENUM_VALUE113
  case SPECENUM_VALUE113:
#ifdef SPECENUM_VALUE113NAME
    return SPECENUM_VALUE113NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE113);
#endif
#endif /* SPECENUM_VALUE113 */

#ifdef SPECENUM_VALUE114
  case SPECENUM_VALUE114:
#ifdef SPECENUM_VALUE114NAME
    return SPECENUM_VALUE114NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE114);
#endif
#endif /* SPECENUM_VALUE114 */

#ifdef SPECENUM_VALUE115
  case SPECENUM_VALUE115:
#ifdef SPECENUM_VALUE115NAME
    return SPECENUM_VALUE115NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE115);
#endif
#endif /* SPECENUM_VALUE115 */

#ifdef SPECENUM_VALUE116
  case SPECENUM_VALUE116:
#ifdef SPECENUM_VALUE116NAME
    return SPECENUM_VALUE116NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE116);
#endif
#endif /* SPECENUM_VALUE116 */

#ifdef SPECENUM_VALUE117
  case SPECENUM_VALUE117:
#ifdef SPECENUM_VALUE117NAME
    return SPECENUM_VALUE117NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE117);
#endif
#endif /* SPECENUM_VALUE117 */

#ifdef SPECENUM_VALUE118
  case SPECENUM_VALUE118:
#ifdef SPECENUM_VALUE118NAME
    return SPECENUM_VALUE118NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE118);
#endif
#endif /* SPECENUM_VALUE118 */

#ifdef SPECENUM_VALUE119
  case SPECENUM_VALUE119:
#ifdef SPECENUM_VALUE119NAME
    return SPECENUM_VALUE119NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE119);
#endif
#endif /* SPECENUM_VALUE119 */

#ifdef SPECENUM_VALUE120
  case SPECENUM_VALUE120:
#ifdef SPECENUM_VALUE120NAME
    return SPECENUM_VALUE120NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE120);
#endif
#endif /* SPECENUM_VALUE120 */

#ifdef SPECENUM_VALUE121
  case SPECENUM_VALUE121:
#ifdef SPECENUM_VALUE121NAME
    return SPECENUM_VALUE121NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE121);
#endif
#endif /* SPECENUM_VALUE121 */

#ifdef SPECENUM_VALUE122
  case SPECENUM_VALUE122:
#ifdef SPECENUM_VALUE122NAME
    return SPECENUM_VALUE122NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE122);
#endif
#endif /* SPECENUM_VALUE122 */

#ifdef SPECENUM_VALUE123
  case SPECENUM_VALUE123:
#ifdef SPECENUM_VALUE123NAME
    return SPECENUM_VALUE123NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE123);
#endif
#endif /* SPECENUM_VALUE123 */

#ifdef SPECENUM_VALUE124
  case SPECENUM_VALUE124:
#ifdef SPECENUM_VALUE124NAME
    return SPECENUM_VALUE124NAME;
#else
    return SPECENUM_STRING(SPECENUM_VALUE124);
#endif
#endif /* SPECENUM_VALUE124 */

#ifdef SPECENUM_COUNT
  case SPECENUM_COUNT:
#ifdef SPECENUM_COUNTNAME
    return SPECENUM_COUNTNAME;
#else
    return SPECENUM_STRING(SPECENUM_COUNT);
#endif
#endif /* SPECENUM_COUNT */
  }

  return NULL;
}

/**************************************************************************
  Returns the enumerator for the name or *_invalid() if not found.
**************************************************************************/
static inline enum SPECENUM_NAME SPECENUM_FOO(_by_name)
    (const char *name, int (*strcmp_func)(const char *, const char *))
{
  enum SPECENUM_NAME e;
  const char *enum_name;

  for (e = SPECENUM_FOO(_begin)(); e != SPECENUM_FOO(_end)();
       e = SPECENUM_FOO(_next)(e)) {
    if ((enum_name = SPECENUM_FOO(_name)(e))
        && 0 == strcmp_func(name, enum_name)) {
      return e;
    }
  }

  return SPECENUM_FOO(_invalid)();
}

#undef SPECENUM_NAME
#undef SPECENUM_PASTE_
#undef SPECENUM_PASTE
#undef SPECENUM_STRING_
#undef SPECENUM_STRING
#undef SPECENUM_FOO
#undef SPECENUM_INVALID
#undef SPECENUM_BITWISE
#undef SPECENUM_VALUE
#undef SPECENUM_ZERO
#undef SPECENUM_MIN_VALUE
#undef SPECENUM_MAX_VALUE
#undef SPECENUM_COUNT
#undef SPECENUM_VALUE0
#undef SPECENUM_VALUE1
#undef SPECENUM_VALUE2
#undef SPECENUM_VALUE3
#undef SPECENUM_VALUE4
#undef SPECENUM_VALUE5
#undef SPECENUM_VALUE6
#undef SPECENUM_VALUE7
#undef SPECENUM_VALUE8
#undef SPECENUM_VALUE9
#undef SPECENUM_VALUE10
#undef SPECENUM_VALUE11
#undef SPECENUM_VALUE12
#undef SPECENUM_VALUE13
#undef SPECENUM_VALUE14
#undef SPECENUM_VALUE15
#undef SPECENUM_VALUE16
#undef SPECENUM_VALUE17
#undef SPECENUM_VALUE18
#undef SPECENUM_VALUE19
#undef SPECENUM_VALUE20
#undef SPECENUM_VALUE21
#undef SPECENUM_VALUE22
#undef SPECENUM_VALUE23
#undef SPECENUM_VALUE24
#undef SPECENUM_VALUE25
#undef SPECENUM_VALUE26
#undef SPECENUM_VALUE27
#undef SPECENUM_VALUE28
#undef SPECENUM_VALUE29
#undef SPECENUM_VALUE30
#undef SPECENUM_VALUE31
#undef SPECENUM_VALUE32
#undef SPECENUM_VALUE33
#undef SPECENUM_VALUE34
#undef SPECENUM_VALUE35
#undef SPECENUM_VALUE36
#undef SPECENUM_VALUE37
#undef SPECENUM_VALUE38
#undef SPECENUM_VALUE39
#undef SPECENUM_VALUE40
#undef SPECENUM_VALUE41
#undef SPECENUM_VALUE42
#undef SPECENUM_VALUE43
#undef SPECENUM_VALUE44
#undef SPECENUM_VALUE45
#undef SPECENUM_VALUE46
#undef SPECENUM_VALUE47
#undef SPECENUM_VALUE48
#undef SPECENUM_VALUE49
#undef SPECENUM_VALUE50
#undef SPECENUM_VALUE51
#undef SPECENUM_VALUE52
#undef SPECENUM_VALUE53
#undef SPECENUM_VALUE54
#undef SPECENUM_VALUE55
#undef SPECENUM_VALUE56
#undef SPECENUM_VALUE57
#undef SPECENUM_VALUE58
#undef SPECENUM_VALUE59
#undef SPECENUM_VALUE60
#undef SPECENUM_VALUE61
#undef SPECENUM_VALUE62
#undef SPECENUM_VALUE63
#undef SPECENUM_VALUE64
#undef SPECENUM_VALUE65
#undef SPECENUM_VALUE66
#undef SPECENUM_VALUE67
#undef SPECENUM_VALUE68
#undef SPECENUM_VALUE69
#undef SPECENUM_VALUE70
#undef SPECENUM_VALUE71
#undef SPECENUM_VALUE72
#undef SPECENUM_VALUE73
#undef SPECENUM_VALUE74
#undef SPECENUM_VALUE75
#undef SPECENUM_VALUE76
#undef SPECENUM_VALUE77
#undef SPECENUM_VALUE78
#undef SPECENUM_VALUE79
#undef SPECENUM_VALUE80
#undef SPECENUM_VALUE81
#undef SPECENUM_VALUE82
#undef SPECENUM_VALUE83
#undef SPECENUM_VALUE84
#undef SPECENUM_VALUE85
#undef SPECENUM_VALUE86
#undef SPECENUM_VALUE87
#undef SPECENUM_VALUE88
#undef SPECENUM_VALUE89
#undef SPECENUM_VALUE90
#undef SPECENUM_VALUE91
#undef SPECENUM_VALUE92
#undef SPECENUM_VALUE93
#undef SPECENUM_VALUE94
#undef SPECENUM_VALUE95
#undef SPECENUM_VALUE96
#undef SPECENUM_VALUE97
#undef SPECENUM_VALUE98
#undef SPECENUM_VALUE99
#undef SPECENUM_VALUE100
#undef SPECENUM_VALUE101
#undef SPECENUM_VALUE102
#undef SPECENUM_VALUE103
#undef SPECENUM_VALUE104
#undef SPECENUM_VALUE105
#undef SPECENUM_VALUE106
#undef SPECENUM_VALUE107
#undef SPECENUM_VALUE108
#undef SPECENUM_VALUE109
#undef SPECENUM_VALUE110
#undef SPECENUM_VALUE111
#undef SPECENUM_VALUE112
#undef SPECENUM_VALUE113
#undef SPECENUM_VALUE114
#undef SPECENUM_VALUE115
#undef SPECENUM_VALUE116
#undef SPECENUM_VALUE117
#undef SPECENUM_VALUE118
#undef SPECENUM_VALUE119
#undef SPECENUM_VALUE120
#undef SPECENUM_VALUE121
#undef SPECENUM_VALUE122
#undef SPECENUM_VALUE123
#undef SPECENUM_VALUE124
#undef SPECENUM_ZERONAME
#undef SPECENUM_VALUE0NAME
#undef SPECENUM_VALUE1NAME
#undef SPECENUM_VALUE2NAME
#undef SPECENUM_VALUE3NAME
#undef SPECENUM_VALUE4NAME
#undef SPECENUM_VALUE5NAME
#undef SPECENUM_VALUE6NAME
#undef SPECENUM_VALUE7NAME
#undef SPECENUM_VALUE8NAME
#undef SPECENUM_VALUE9NAME
#undef SPECENUM_VALUE10NAME
#undef SPECENUM_VALUE11NAME
#undef SPECENUM_VALUE12NAME
#undef SPECENUM_VALUE13NAME
#undef SPECENUM_VALUE14NAME
#undef SPECENUM_VALUE15NAME
#undef SPECENUM_VALUE16NAME
#undef SPECENUM_VALUE17NAME
#undef SPECENUM_VALUE18NAME
#undef SPECENUM_VALUE19NAME
#undef SPECENUM_VALUE20NAME
#undef SPECENUM_VALUE21NAME
#undef SPECENUM_VALUE22NAME
#undef SPECENUM_VALUE23NAME
#undef SPECENUM_VALUE24NAME
#undef SPECENUM_VALUE25NAME
#undef SPECENUM_VALUE26NAME
#undef SPECENUM_VALUE27NAME
#undef SPECENUM_VALUE28NAME
#undef SPECENUM_VALUE29NAME
#undef SPECENUM_VALUE30NAME
#undef SPECENUM_VALUE31NAME
#undef SPECENUM_VALUE32NAME
#undef SPECENUM_VALUE33NAME
#undef SPECENUM_VALUE34NAME
#undef SPECENUM_VALUE35NAME
#undef SPECENUM_VALUE36NAME
#undef SPECENUM_VALUE37NAME
#undef SPECENUM_VALUE38NAME
#undef SPECENUM_VALUE39NAME
#undef SPECENUM_VALUE40NAME
#undef SPECENUM_VALUE41NAME
#undef SPECENUM_VALUE42NAME
#undef SPECENUM_VALUE43NAME
#undef SPECENUM_VALUE44NAME
#undef SPECENUM_VALUE45NAME
#undef SPECENUM_VALUE46NAME
#undef SPECENUM_VALUE47NAME
#undef SPECENUM_VALUE48NAME
#undef SPECENUM_VALUE49NAME
#undef SPECENUM_VALUE50NAME
#undef SPECENUM_VALUE51NAME
#undef SPECENUM_VALUE52NAME
#undef SPECENUM_VALUE53NAME
#undef SPECENUM_VALUE54NAME
#undef SPECENUM_VALUE55NAME
#undef SPECENUM_VALUE56NAME
#undef SPECENUM_VALUE57NAME
#undef SPECENUM_VALUE58NAME
#undef SPECENUM_VALUE59NAME
#undef SPECENUM_VALUE60NAME
#undef SPECENUM_VALUE61NAME
#undef SPECENUM_VALUE62NAME
#undef SPECENUM_VALUE63NAME
#undef SPECENUM_VALUE64NAME
#undef SPECENUM_VALUE65NAME
#undef SPECENUM_VALUE66NAME
#undef SPECENUM_VALUE67NAME
#undef SPECENUM_VALUE68NAME
#undef SPECENUM_VALUE69NAME
#undef SPECENUM_VALUE70NAME
#undef SPECENUM_VALUE71NAME
#undef SPECENUM_VALUE72NAME
#undef SPECENUM_VALUE73NAME
#undef SPECENUM_VALUE74NAME
#undef SPECENUM_VALUE75NAME
#undef SPECENUM_VALUE76NAME
#undef SPECENUM_VALUE77NAME
#undef SPECENUM_VALUE78NAME
#undef SPECENUM_VALUE79NAME
#undef SPECENUM_VALUE80NAME
#undef SPECENUM_VALUE81NAME
#undef SPECENUM_VALUE82NAME
#undef SPECENUM_VALUE83NAME
#undef SPECENUM_VALUE84NAME
#undef SPECENUM_VALUE85NAME
#undef SPECENUM_VALUE86NAME
#undef SPECENUM_VALUE87NAME
#undef SPECENUM_VALUE88NAME
#undef SPECENUM_VALUE89NAME
#undef SPECENUM_VALUE90NAME
#undef SPECENUM_VALUE91NAME
#undef SPECENUM_VALUE92NAME
#undef SPECENUM_VALUE93NAME
#undef SPECENUM_VALUE94NAME
#undef SPECENUM_VALUE95NAME
#undef SPECENUM_VALUE96NAME
#undef SPECENUM_VALUE97NAME
#undef SPECENUM_VALUE98NAME
#undef SPECENUM_VALUE99NAME
#undef SPECENUM_VALUE100NAME
#undef SPECENUM_VALUE101NAME
#undef SPECENUM_VALUE102NAME
#undef SPECENUM_VALUE103NAME
#undef SPECENUM_VALUE104NAME
#undef SPECENUM_VALUE105NAME
#undef SPECENUM_VALUE106NAME
#undef SPECENUM_VALUE107NAME
#undef SPECENUM_VALUE108NAME
#undef SPECENUM_VALUE109NAME
#undef SPECENUM_VALUE110NAME
#undef SPECENUM_VALUE111NAME
#undef SPECENUM_VALUE112NAME
#undef SPECENUM_VALUE113NAME
#undef SPECENUM_VALUE114NAME
#undef SPECENUM_VALUE115NAME
#undef SPECENUM_VALUE116NAME
#undef SPECENUM_VALUE117NAME
#undef SPECENUM_VALUE118NAME
#undef SPECENUM_VALUE119NAME
#undef SPECENUM_VALUE120NAME
#undef SPECENUM_VALUE121NAME
#undef SPECENUM_VALUE122NAME
#undef SPECENUM_VALUE123NAME
#undef SPECENUM_VALUE124NAME

#ifdef __cplusplus
}
#endif /* __cplusplus */
