/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef MMLMonitorDisplayFactory_H
#define MMLMonitorDisplayFactory_H

#include "MonitorIn.hxx"

#include "monitor/monitors/MonitorGeometricDeviation.h"
#include "monitor/monitors/MonitorPosition.h"
#include "monitor/monitors/MonitorRen.h"
#include "monitor/monitors/MonitorForce.h"
#include "monitor/monitors/MonitorPointSetDistance.h"
#include "monitor/monitors/MonitorPointFinalSetDistance.h"
#include "monitor/monitors/MonitorVolume.h"
#include "monitor/monitors/MonitorSurface.h"
#include "monitor/monitors/MonitorDisplacement.h"
#include "monitor/monitors/MonitorNormDisplacement.h"
#include "monitor/monitors/MonitorPointToTriangleMeshDistanceFinal.h"
#include "monitor/monitors/MonitorComputingTime.h"
#include "monitor/monitors/MonitorDistanceX.h"
#include "monitor/monitors/MonitorDistanceY.h"
#include "monitor/monitors/MonitorDistanceZ.h"

/**
 * A factory to create monitors
 */
class MonitorFactory
{
  public:
    /// destructor
    ~MonitorFactory();
    
    /// create a monitor according to the xsdcxx object monitor
    static Monitor* createMonitor(mml::Monitor* m,MonitoringManager* monitoringManager);
    
  private:
    /// constructor  
    MonitorFactory();
    
};

#endif // MMLMonitorDisplayFactory_H