/* calendar-unit.c generated by valac 0.28.0, the Vala compiler
 * generated from calendar-unit.vala, do not modify */

/* Copyright 2014-2015 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_CALENDAR_TYPE_SPAN (california_calendar_span_get_type ())
#define CALIFORNIA_CALENDAR_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan))
#define CALIFORNIA_CALENDAR_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))
#define CALIFORNIA_CALENDAR_IS_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_IS_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))

typedef struct _CaliforniaCalendarSpan CaliforniaCalendarSpan;
typedef struct _CaliforniaCalendarSpanClass CaliforniaCalendarSpanClass;
typedef struct _CaliforniaCalendarSpanPrivate CaliforniaCalendarSpanPrivate;

#define CALIFORNIA_CALENDAR_TYPE_UNIT (california_calendar_unit_get_type ())
#define CALIFORNIA_CALENDAR_UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit))
#define CALIFORNIA_CALENDAR_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))
#define CALIFORNIA_CALENDAR_IS_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_IS_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_UNIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))

typedef struct _CaliforniaCalendarUnit CaliforniaCalendarUnit;
typedef struct _CaliforniaCalendarUnitClass CaliforniaCalendarUnitClass;

#define CALIFORNIA_CALENDAR_TYPE_DATE (california_calendar_date_get_type ())
#define CALIFORNIA_CALENDAR_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate))
#define CALIFORNIA_CALENDAR_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))
#define CALIFORNIA_CALENDAR_IS_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_IS_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))

typedef struct _CaliforniaCalendarDate CaliforniaCalendarDate;
typedef struct _CaliforniaCalendarDateClass CaliforniaCalendarDateClass;

#define CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE (california_collection_simple_iterable_get_type ())
#define CALIFORNIA_COLLECTION_SIMPLE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, CaliforniaCollectionSimpleIterable))
#define CALIFORNIA_COLLECTION_IS_SIMPLE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE))
#define CALIFORNIA_COLLECTION_SIMPLE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, CaliforniaCollectionSimpleIterableIface))

typedef struct _CaliforniaCollectionSimpleIterable CaliforniaCollectionSimpleIterable;
typedef struct _CaliforniaCollectionSimpleIterableIface CaliforniaCollectionSimpleIterableIface;

#define CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR (california_collection_simple_iterator_get_type ())
#define CALIFORNIA_COLLECTION_SIMPLE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIterator))
#define CALIFORNIA_COLLECTION_IS_SIMPLE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR))
#define CALIFORNIA_COLLECTION_SIMPLE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIteratorIface))

typedef struct _CaliforniaCollectionSimpleIterator CaliforniaCollectionSimpleIterator;
typedef struct _CaliforniaCollectionSimpleIteratorIface CaliforniaCollectionSimpleIteratorIface;
typedef struct _CaliforniaCalendarUnitPrivate CaliforniaCalendarUnitPrivate;

#define CALIFORNIA_CALENDAR_TYPE_DATE_UNIT (california_calendar_date_unit_get_type ())

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaCalendarSpan {
	CaliforniaBaseObject parent_instance;
	CaliforniaCalendarSpanPrivate * priv;
};

struct _CaliforniaCalendarSpanClass {
	CaliforniaBaseObjectClass parent_class;
	CaliforniaCalendarDate* (*get_start_date) (CaliforniaCalendarSpan* self);
	CaliforniaCalendarDate* (*get_end_date) (CaliforniaCalendarSpan* self);
};

struct _CaliforniaCollectionSimpleIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (CaliforniaCollectionSimpleIterator* self);
	gpointer (*get) (CaliforniaCollectionSimpleIterator* self);
};

struct _CaliforniaCollectionSimpleIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (CaliforniaCollectionSimpleIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (CaliforniaCollectionSimpleIterable* self);
	GDestroyNotify (*get_g_destroy_func) (CaliforniaCollectionSimpleIterable* self);
	CaliforniaCollectionSimpleIterator* (*iterator) (CaliforniaCollectionSimpleIterable* self);
};

struct _CaliforniaCalendarUnit {
	CaliforniaCalendarSpan parent_instance;
	CaliforniaCalendarUnitPrivate * priv;
};

struct _CaliforniaCalendarUnitClass {
	CaliforniaCalendarSpanClass parent_class;
	gpointer (*adjust) (CaliforniaCalendarUnit* self, gint quantity);
	gint (*difference) (CaliforniaCalendarUnit* self, gconstpointer other);
};

typedef enum  {
	CALIFORNIA_CALENDAR_DATE_UNIT_DAY,
	CALIFORNIA_CALENDAR_DATE_UNIT_WEEK,
	CALIFORNIA_CALENDAR_DATE_UNIT_MONTH,
	CALIFORNIA_CALENDAR_DATE_UNIT_YEAR
} CaliforniaCalendarDateUnit;

struct _CaliforniaCalendarUnitPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	CaliforniaCalendarDateUnit _date_unit;
};


static gpointer california_calendar_unit_parent_class = NULL;
static CaliforniaCollectionSimpleIterableIface* california_calendar_unit_california_collection_simple_iterable_parent_iface = NULL;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_calendar_span_get_type (void) G_GNUC_CONST;
GType california_calendar_unit_get_type (void) G_GNUC_CONST;
GType california_calendar_date_get_type (void) G_GNUC_CONST;
GType california_collection_simple_iterator_get_type (void) G_GNUC_CONST;
GType california_collection_simple_iterable_get_type (void) G_GNUC_CONST;
GType california_calendar_date_unit_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_UNIT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitPrivate))
enum  {
	CALIFORNIA_CALENDAR_UNIT_DUMMY_PROPERTY,
	CALIFORNIA_CALENDAR_UNIT_G_TYPE,
	CALIFORNIA_CALENDAR_UNIT_G_DUP_FUNC,
	CALIFORNIA_CALENDAR_UNIT_G_DESTROY_FUNC,
	CALIFORNIA_CALENDAR_UNIT_DATE_UNIT
};
#define CALIFORNIA_CALENDAR_UNIT_PROP_DATE_UNIT "date-unit"
CaliforniaCalendarUnit* california_calendar_unit_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, CaliforniaCalendarDateUnit date_unit, CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date);
CaliforniaCalendarSpan* california_calendar_span_construct (GType object_type, CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date);
static void california_calendar_unit_set_date_unit (CaliforniaCalendarUnit* self, CaliforniaCalendarDateUnit value);
CaliforniaCalendarUnit* california_calendar_unit_construct_uninitialized (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, CaliforniaCalendarDateUnit date_unit);
CaliforniaCalendarSpan* california_calendar_span_construct_uninitialized (GType object_type);
gpointer california_calendar_unit_next (CaliforniaCalendarUnit* self);
gpointer california_calendar_unit_adjust (CaliforniaCalendarUnit* self, gint quantity);
gpointer california_calendar_unit_previous (CaliforniaCalendarUnit* self);
static gpointer california_calendar_unit_real_adjust (CaliforniaCalendarUnit* self, gint quantity);
gint california_calendar_unit_difference (CaliforniaCalendarUnit* self, gconstpointer other);
static gint california_calendar_unit_real_difference (CaliforniaCalendarUnit* self, gconstpointer other);
gboolean california_calendar_unit_contains (CaliforniaCalendarUnit* self, CaliforniaCalendarDate* date);
gboolean california_calendar_span_has_date (CaliforniaCalendarSpan* self, CaliforniaCalendarDate* date);
static CaliforniaCollectionSimpleIterator* california_calendar_unit_real_iterator (CaliforniaCollectionSimpleIterable* base);
CaliforniaCollectionSimpleIterator* california_calendar_span_date_iterator (CaliforniaCalendarSpan* self);
CaliforniaCalendarDateUnit california_calendar_unit_get_date_unit (CaliforniaCalendarUnit* self);
static void california_calendar_unit_finalize (GObject* obj);
static void _vala_california_calendar_unit_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_calendar_unit_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


CaliforniaCalendarUnit* california_calendar_unit_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, CaliforniaCalendarDateUnit date_unit, CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date) {
	CaliforniaCalendarUnit * self = NULL;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	CaliforniaCalendarDate* _tmp1_ = NULL;
	CaliforniaCalendarDateUnit _tmp2_ = 0;
#line 40 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (start_date), NULL);
#line 40 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (end_date), NULL);
#line 41 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	_tmp0_ = start_date;
#line 41 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	_tmp1_ = end_date;
#line 41 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	self = (CaliforniaCalendarUnit*) california_calendar_span_construct (object_type, _tmp0_, _tmp1_);
#line 41 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	self->priv->g_type = g_type;
#line 41 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	self->priv->g_dup_func = g_dup_func;
#line 41 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 43 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	_tmp2_ = date_unit;
#line 43 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	california_calendar_unit_set_date_unit (self, _tmp2_);
#line 40 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	return self;
#line 206 "calendar-unit.c"
}


/**
     * This is specifically for {@link Date}, which can't pass itself down to {@link Span} as that
     * will create a reference cycle, or for child classes which need to do more work before
     * providing a date span.
     *
     * If the latter, the child class should call {@link init_span} to complete initialization.
     */
CaliforniaCalendarUnit* california_calendar_unit_construct_uninitialized (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, CaliforniaCalendarDateUnit date_unit) {
	CaliforniaCalendarUnit * self = NULL;
	CaliforniaCalendarDateUnit _tmp0_ = 0;
#line 54 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	self = (CaliforniaCalendarUnit*) california_calendar_span_construct_uninitialized (object_type);
#line 54 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	self->priv->g_type = g_type;
#line 54 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	self->priv->g_dup_func = g_dup_func;
#line 54 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 56 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	_tmp0_ = date_unit;
#line 56 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	california_calendar_unit_set_date_unit (self, _tmp0_);
#line 53 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	return self;
#line 234 "calendar-unit.c"
}


/**
     * The next chronological discrete unit of time.
     */
gpointer california_calendar_unit_next (CaliforniaCalendarUnit* self) {
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
#line 62 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_UNIT (self), NULL);
#line 63 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	_tmp0_ = california_calendar_unit_adjust (self, 1);
#line 63 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	result = _tmp0_;
#line 63 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	return result;
#line 252 "calendar-unit.c"
}


/**
     * The previous chronological discrete unit of time.
     */
gpointer california_calendar_unit_previous (CaliforniaCalendarUnit* self) {
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
#line 69 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_UNIT (self), NULL);
#line 70 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	_tmp0_ = california_calendar_unit_adjust (self, -1);
#line 70 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	result = _tmp0_;
#line 70 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	return result;
#line 270 "calendar-unit.c"
}


/**
     * Returns the same type of {@link Unit} adjusted a quantity of units from this one.
     *
     * Subtraction (adjusting to a past date) is acheived by using a negative quantity.
     */
static gpointer california_calendar_unit_real_adjust (CaliforniaCalendarUnit* self, gint quantity) {
#line 78 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	g_critical ("Type `%s' does not implement abstract method `california_calendar_unit_adjust'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 78 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	return NULL;
#line 284 "calendar-unit.c"
}


gpointer california_calendar_unit_adjust (CaliforniaCalendarUnit* self, gint quantity) {
#line 78 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_UNIT (self), NULL);
#line 78 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	return CALIFORNIA_CALENDAR_UNIT_GET_CLASS (self)->adjust (self, quantity);
#line 293 "calendar-unit.c"
}


/**
     * Returns the number of {@link Unit}s between the two.
     *
     * If the supplied Unit is earlier than this one, a negative value is returned.  (In other
     * words, future days are positive, past days are negative.)
     */
static gint california_calendar_unit_real_difference (CaliforniaCalendarUnit* self, gconstpointer other) {
#line 86 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	g_critical ("Type `%s' does not implement abstract method `california_calendar_unit_difference'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 86 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	return 0;
#line 308 "calendar-unit.c"
}


gint california_calendar_unit_difference (CaliforniaCalendarUnit* self, gconstpointer other) {
#line 86 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_UNIT (self), 0);
#line 86 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	return CALIFORNIA_CALENDAR_UNIT_GET_CLASS (self)->difference (self, other);
#line 317 "calendar-unit.c"
}


/**
     * True if the {@link Unit} contains the specified {@link Date}.
     *
     * This is named to conform to Vala's rule for automatic syntax support.  This allows for the
     * ''in'' operator to function on Units, but only for Dates (which is a common operation).
     */
gboolean california_calendar_unit_contains (CaliforniaCalendarUnit* self, CaliforniaCalendarDate* date) {
	gboolean result = FALSE;
	CaliforniaCalendarDate* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 94 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_UNIT (self), FALSE);
#line 94 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_DATE (date), FALSE);
#line 95 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	_tmp0_ = date;
#line 95 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	_tmp1_ = california_calendar_span_has_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan), _tmp0_);
#line 95 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	result = _tmp1_;
#line 95 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	return result;
#line 343 "calendar-unit.c"
}


/**
     * Returns a {@link Collection.SimpleIterator} of all the {@link Date}s in the
     * {@link Unit}'s span of time.
     *
     * This is named to conform to Vala's rule for automatic iterator support.  This allows for
     * the ''foreach'' operator to function on Units, but only for Dates (which is a common
     * operation).
     */
static CaliforniaCollectionSimpleIterator* california_calendar_unit_real_iterator (CaliforniaCollectionSimpleIterable* base) {
	CaliforniaCalendarUnit * self;
	CaliforniaCollectionSimpleIterator* result = NULL;
	CaliforniaCollectionSimpleIterator* _tmp0_ = NULL;
#line 106 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit);
#line 107 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	_tmp0_ = california_calendar_span_date_iterator (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 107 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	result = _tmp0_;
#line 107 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	return result;
#line 367 "calendar-unit.c"
}


CaliforniaCalendarDateUnit california_calendar_unit_get_date_unit (CaliforniaCalendarUnit* self) {
	CaliforniaCalendarDateUnit result;
	CaliforniaCalendarDateUnit _tmp0_ = 0;
#line 38 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_UNIT (self), 0);
#line 38 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	_tmp0_ = self->priv->_date_unit;
#line 38 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	result = _tmp0_;
#line 38 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	return result;
#line 382 "calendar-unit.c"
}


static void california_calendar_unit_set_date_unit (CaliforniaCalendarUnit* self, CaliforniaCalendarDateUnit value) {
	CaliforniaCalendarDateUnit _tmp0_ = 0;
#line 38 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_UNIT (self));
#line 38 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	_tmp0_ = value;
#line 38 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	self->priv->_date_unit = _tmp0_;
#line 38 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	g_object_notify ((GObject *) self, "date-unit");
#line 396 "calendar-unit.c"
}


static void california_calendar_unit_class_init (CaliforniaCalendarUnitClass * klass) {
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	california_calendar_unit_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaCalendarUnitPrivate));
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	((CaliforniaCalendarUnitClass *) klass)->adjust = california_calendar_unit_real_adjust;
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	((CaliforniaCalendarUnitClass *) klass)->difference = california_calendar_unit_real_difference;
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_calendar_unit_get_property;
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_calendar_unit_set_property;
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	G_OBJECT_CLASS (klass)->finalize = california_calendar_unit_finalize;
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_UNIT_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_UNIT_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_UNIT_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 421 "calendar-unit.c"
	/**
	     * Returns the {@link DateUnit} this {@link Unit} represents.
	     */
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_UNIT_DATE_UNIT, g_param_spec_enum ("date-unit", "date-unit", "date-unit", CALIFORNIA_CALENDAR_TYPE_DATE_UNIT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 427 "calendar-unit.c"
}


static GType california_calendar_unit_california_collection_simple_iterable_get_g_type (CaliforniaCalendarUnit* self) {
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	return CALIFORNIA_CALENDAR_TYPE_DATE;
#line 434 "calendar-unit.c"
}


static GBoxedCopyFunc california_calendar_unit_california_collection_simple_iterable_get_g_dup_func (CaliforniaCalendarUnit* self) {
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	return g_object_ref;
#line 441 "calendar-unit.c"
}


static GDestroyNotify california_calendar_unit_california_collection_simple_iterable_get_g_destroy_func (CaliforniaCalendarUnit* self) {
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	return g_object_unref;
#line 448 "calendar-unit.c"
}


static void california_calendar_unit_california_collection_simple_iterable_interface_init (CaliforniaCollectionSimpleIterableIface * iface) {
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	california_calendar_unit_california_collection_simple_iterable_parent_iface = g_type_interface_peek_parent (iface);
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	iface->iterator = (CaliforniaCollectionSimpleIterator* (*)(CaliforniaCollectionSimpleIterable*)) california_calendar_unit_real_iterator;
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	iface->get_g_type = (GType(*)(CaliforniaCollectionSimpleIterable*)) california_calendar_unit_california_collection_simple_iterable_get_g_type;
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(CaliforniaCollectionSimpleIterable*)) california_calendar_unit_california_collection_simple_iterable_get_g_dup_func;
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	iface->get_g_destroy_func = (GDestroyNotify(*)(CaliforniaCollectionSimpleIterable*)) california_calendar_unit_california_collection_simple_iterable_get_g_destroy_func;
#line 463 "calendar-unit.c"
}


static void california_calendar_unit_instance_init (CaliforniaCalendarUnit * self) {
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	self->priv = CALIFORNIA_CALENDAR_UNIT_GET_PRIVATE (self);
#line 470 "calendar-unit.c"
}


static void california_calendar_unit_finalize (GObject* obj) {
	CaliforniaCalendarUnit * self;
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit);
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	G_OBJECT_CLASS (california_calendar_unit_parent_class)->finalize (obj);
#line 480 "calendar-unit.c"
}


/**
 * An immutable, discrete, well-recognized unit of calendar dates.
 *
 * This interface indicates the {@link Calendar.Span} represents a discrete unit of time (each of
 * which may not contain the same number of days, such as {@link Year}s, while some might, such as
 * {@link Week}s), in contrast to a {@link DateSpan}, which represents an ''arbitrary''
 * span of dates that may or may not correspond to a well-recognized unit of dates.
 *
 * Note that this different than a {@link UnitSpan} such as {@link MonthSpan} which is designed to
 * hold an arbitrary consecutive number of their date units (i.e. a span of months).  Unit
 * represents a single unit of time (a week or a month).
 *
 * If Vala supported constrained generics, a UnitSpan would be defined as requiring a generic type
 * of Unit.
 *
 * Unit is not designed to work with discrete {@link ExactTime} or {@link WallTime} units.
 *
 * @see Date
 * @see Week
 * @see MonthOfYear
 * @see Year
 */
GType california_calendar_unit_get_type (void) {
	static volatile gsize california_calendar_unit_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_unit_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaCalendarUnitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_calendar_unit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaCalendarUnit), 0, (GInstanceInitFunc) california_calendar_unit_instance_init, NULL };
		static const GInterfaceInfo california_collection_simple_iterable_info = { (GInterfaceInitFunc) california_calendar_unit_california_collection_simple_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType california_calendar_unit_type_id;
		california_calendar_unit_type_id = g_type_register_static (CALIFORNIA_CALENDAR_TYPE_SPAN, "CaliforniaCalendarUnit", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (california_calendar_unit_type_id, CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, &california_collection_simple_iterable_info);
		g_once_init_leave (&california_calendar_unit_type_id__volatile, california_calendar_unit_type_id);
	}
	return california_calendar_unit_type_id__volatile;
}


static void _vala_california_calendar_unit_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarUnit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit);
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	switch (property_id) {
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
		case CALIFORNIA_CALENDAR_UNIT_DATE_UNIT:
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
		g_value_set_enum (value, california_calendar_unit_get_date_unit (self));
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
		break;
#line 531 "calendar-unit.c"
		default:
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
		break;
#line 537 "calendar-unit.c"
	}
}


static void _vala_california_calendar_unit_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarUnit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit);
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
	switch (property_id) {
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
		case CALIFORNIA_CALENDAR_UNIT_DATE_UNIT:
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
		california_calendar_unit_set_date_unit (self, g_value_get_enum (value));
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
		break;
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
		case CALIFORNIA_CALENDAR_UNIT_G_TYPE:
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
		self->priv->g_type = g_value_get_gtype (value);
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
		break;
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
		case CALIFORNIA_CALENDAR_UNIT_G_DUP_FUNC:
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
		self->priv->g_dup_func = g_value_get_pointer (value);
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
		break;
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
		case CALIFORNIA_CALENDAR_UNIT_G_DESTROY_FUNC:
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
		self->priv->g_destroy_func = g_value_get_pointer (value);
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
		break;
#line 571 "calendar-unit.c"
		default:
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jim/git/california/src/calendar/calendar-unit.vala"
		break;
#line 577 "calendar-unit.c"
	}
}



