//#########################################################################
//generated by MysqlMetal on 2007-Sep-28 - extracted from file northwind.dbml.
//#########################################################################

using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.Text;
using System.Linq;
//using System.Data.Linq;
using System.Data.Linq.Mapping;
using DbLinq.Linq;
using DbLinq.SqlServer;

namespace nwind
{

    /// <summary>
    /// This class represents Microsoft database Northwind.
    /// </summary>
    public partial class Northwind : DataContext
    {
        public Northwind(string connStr)
            : base(new System.Data.SqlClient.SqlConnection(connStr), new SqlServerVendor())
        {
        }

        //these fields represent tables in database and are
        //ordered - parent tables first, child tables next. Do not change the order.
        public Table<Categories> Categories { get { return GetTable<Categories>(); } }
        public Table<CustomerCustomerDemo> CustomerCustomerDemos { get { return GetTable<CustomerCustomerDemo>(); } }
        public Table<CustomerDemographics> CustomerDemographics { get { return GetTable<CustomerDemographics>(); } }
        public Table<Customers> Customers { get { return GetTable<Customers>(); } }
        public Table<Employees> Employees { get { return GetTable<Employees>(); } }
        public Table<EmployeeTerritories> EmployeeTerritories { get { return GetTable<EmployeeTerritories>(); } }
        public Table<OrderDetails> OrderDetails { get { return GetTable<OrderDetails>(); } }
        public Table<Orders> Orders { get { return GetTable<Orders>(); } }
        public Table<Products> Products { get { return GetTable<Products>(); } }
        public Table<Region> Regions { get { return GetTable<Region>(); } }
        public Table<Shippers> Shippers { get { return GetTable<Shippers>(); } }
        public Table<Suppliers> Suppliers { get { return GetTable<Suppliers>(); } }
        public Table<Territories> Territories { get { return GetTable<Territories>(); } }
    }



    [Table(Name = "dbo.Categories")]
    public partial class Categories : IModified
    {
        bool _isModified_;
        public bool IsModified
        {
            get { return _isModified_; }
            set { _isModified_ = value; }
        }

        [DbLinq.Linq.Mapping.AutoGenId]
        protected int _CategoryID;

        protected string _CategoryName;

        protected string _Description;

        protected System.Data.Linq.Binary _Picture;


        #region costructors
        public Categories()
        {
        }
        public Categories(int CategoryID, string CategoryName, string Description, System.Data.Linq.Binary Picture)
        {
            this._CategoryID = CategoryID;
            this._CategoryName = CategoryName;
            this._Description = Description;
            this._Picture = Picture;
        }
        #endregion


        #region properties - accessors

        [Column(Name = "CategoryID", DbType = "Int NOT NULL IDENTITY", IsPrimaryKey = true, IsDbGenerated = true)]
        [DebuggerNonUserCode]
        public int CategoryID
        {
            get { return _CategoryID; }
            set { _CategoryID = value; _isModified_ = true; }
        }


        [Column(Name = "CategoryName", DbType = "NVarChar(15) NOT NULL", CanBeNull = false)]
        [DebuggerNonUserCode]
        public string CategoryName
        {
            get { return _CategoryName; }
            set { _CategoryName = value; _isModified_ = true; }
        }


        [Column(Name = "Description", DbType = "NText", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string Description
        {
            get { return _Description; }
            set { _Description = value; _isModified_ = true; }
        }


        [Column(Name = "Picture", DbType = "Image", CanBeNull = true)]
        [DebuggerNonUserCode]
        public System.Data.Linq.Binary Picture
        {
            get { return _Picture; }
            set { _Picture = value; _isModified_ = true; }
        }

        #endregion

        #region GetHashCode(),Equals() - uses column _CategoryID to look up objects in liveObjectMap
        //TODO: move this logic our of user code, into a generated class
        public override int GetHashCode()
        {
            return _CategoryID.GetHashCode();
        }
        public override bool Equals(object obj)
        {
            Categories o2 = obj as Categories;
            if (o2 == null)
                return false;
            return _CategoryID.Equals(o2._CategoryID);
        }
        #endregion


        [Association(Storage = "null", OtherKey = "CategoryID", Name = "FK_Products_Categories")]
        public EntityMSet<Products> Products
        {
            get { return null; } //TODO L212
        }

    }



    [Table(Name = "dbo.CustomerCustomerDemo")]
    public partial class CustomerCustomerDemo : IModified
    {
        bool _isModified_;
        public bool IsModified
        {
            get { return _isModified_; }
            set { _isModified_ = value; }
        }


        protected string _CustomerID;

        protected string _CustomerTypeID;


        #region costructors
        public CustomerCustomerDemo()
        {
        }
        public CustomerCustomerDemo(string CustomerID, string CustomerTypeID)
        {
            this._CustomerID = CustomerID;
            this._CustomerTypeID = CustomerTypeID;
        }
        #endregion


        #region properties - accessors

        [Column(Name = "CustomerID", DbType = "NChar(5) NOT NULL", IsPrimaryKey = true)]
        [DebuggerNonUserCode]
        public string CustomerID
        {
            get { return _CustomerID; }
            set { _CustomerID = value; _isModified_ = true; }
        }


        [Column(Name = "CustomerTypeID", DbType = "NChar(10) NOT NULL", IsPrimaryKey = true)]
        [DebuggerNonUserCode]
        public string CustomerTypeID
        {
            get { return _CustomerTypeID; }
            set { _CustomerTypeID = value; _isModified_ = true; }
        }

        #endregion

        #region GetHashCode(),Equals() - uses column _CustomerID to look up objects in liveObjectMap
        //TODO: move this logic our of user code, into a generated class
        public override int GetHashCode()
        {
            return _CustomerID.GetHashCode();
        }
        public override bool Equals(object obj)
        {
            CustomerCustomerDemo o2 = obj as CustomerCustomerDemo;
            if (o2 == null)
                return false;
            return _CustomerID.Equals(o2._CustomerID);
        }
        #endregion



        private System.Data.Linq.EntityRef<CustomerDemographics> _CustomerDemographics;

        [Association(Storage = "_CustomerDemographics", ThisKey = "CustomerTypeID", Name = "FK_CustomerCustomerDemo")]
        [DebuggerNonUserCode]
        public CustomerDemographics CustomerDemographics
        {
            get { return this._CustomerDemographics.Entity; }
            set { this._CustomerDemographics.Entity = value; }
        }


        private System.Data.Linq.EntityRef<Customers> _Customers;

        [Association(Storage = "_Customers", ThisKey = "CustomerID", Name = "FK_CustomerCustomerDemo_Customers")]
        [DebuggerNonUserCode]
        public Customers Customers
        {
            get { return this._Customers.Entity; }
            set { this._Customers.Entity = value; }
        }

    }



    [Table(Name = "dbo.CustomerDemographics")]
    public partial class CustomerDemographics : IModified
    {
        bool _isModified_;
        public bool IsModified
        {
            get { return _isModified_; }
            set { _isModified_ = value; }
        }


        protected string _CustomerTypeID;

        protected string _CustomerDesc;


        #region costructors
        public CustomerDemographics()
        {
        }
        public CustomerDemographics(string CustomerTypeID, string CustomerDesc)
        {
            this._CustomerTypeID = CustomerTypeID;
            this._CustomerDesc = CustomerDesc;
        }
        #endregion


        #region properties - accessors

        [Column(Name = "CustomerTypeID", DbType = "NChar(10) NOT NULL", IsPrimaryKey = true)]
        [DebuggerNonUserCode]
        public string CustomerTypeID
        {
            get { return _CustomerTypeID; }
            set { _CustomerTypeID = value; _isModified_ = true; }
        }


        [Column(Name = "CustomerDesc", DbType = "NText", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string CustomerDesc
        {
            get { return _CustomerDesc; }
            set { _CustomerDesc = value; _isModified_ = true; }
        }

        #endregion

        #region GetHashCode(),Equals() - uses column _CustomerTypeID to look up objects in liveObjectMap
        //TODO: move this logic our of user code, into a generated class
        public override int GetHashCode()
        {
            return _CustomerTypeID.GetHashCode();
        }
        public override bool Equals(object obj)
        {
            CustomerDemographics o2 = obj as CustomerDemographics;
            if (o2 == null)
                return false;
            return _CustomerTypeID.Equals(o2._CustomerTypeID);
        }
        #endregion


        [Association(Storage = "null", OtherKey = "CustomerTypeID", Name = "FK_CustomerCustomerDemo")]
        public EntityMSet<CustomerCustomerDemo> CustomerCustomerDemo
        {
            get { return null; } //TODO L212
        }

    }



    [Table(Name = "dbo.Customers")]
    public partial class Customers : IModified
    {
        bool _isModified_;
        public bool IsModified
        {
            get { return _isModified_; }
            set { _isModified_ = value; }
        }


        protected string _CustomerID;

        protected string _CompanyName;

        protected string _ContactName;

        protected string _ContactTitle;

        protected string _Address;

        protected string _City;

        protected string _Region;

        protected string _PostalCode;

        protected string _Country;

        protected string _Phone;

        protected string _Fax;


        #region costructors
        public Customers()
        {
        }
        public Customers(string CustomerID, string CompanyName, string ContactName, string ContactTitle, string Address, string City, string Region, string PostalCode, string Country, string Phone, string Fax)
        {
            this._CustomerID = CustomerID;
            this._CompanyName = CompanyName;
            this._ContactName = ContactName;
            this._ContactTitle = ContactTitle;
            this._Address = Address;
            this._City = City;
            this._Region = Region;
            this._PostalCode = PostalCode;
            this._Country = Country;
            this._Phone = Phone;
            this._Fax = Fax;
        }
        #endregion


        #region properties - accessors

        [Column(Name = "CustomerID", DbType = "NChar(5) NOT NULL", IsPrimaryKey = true)]
        [DebuggerNonUserCode]
        public string CustomerID
        {
            get { return _CustomerID; }
            set { _CustomerID = value; _isModified_ = true; }
        }


        [Column(Name = "CompanyName", DbType = "NVarChar(40) NOT NULL", CanBeNull = false)]
        [DebuggerNonUserCode]
        public string CompanyName
        {
            get { return _CompanyName; }
            set { _CompanyName = value; _isModified_ = true; }
        }


        [Column(Name = "ContactName", DbType = "NVarChar(30)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string ContactName
        {
            get { return _ContactName; }
            set { _ContactName = value; _isModified_ = true; }
        }


        [Column(Name = "ContactTitle", DbType = "NVarChar(30)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string ContactTitle
        {
            get { return _ContactTitle; }
            set { _ContactTitle = value; _isModified_ = true; }
        }


        [Column(Name = "Address", DbType = "NVarChar(60)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string Address
        {
            get { return _Address; }
            set { _Address = value; _isModified_ = true; }
        }


        [Column(Name = "City", DbType = "NVarChar(15)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string City
        {
            get { return _City; }
            set { _City = value; _isModified_ = true; }
        }


        [Column(Name = "Region", DbType = "NVarChar(15)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string Region
        {
            get { return _Region; }
            set { _Region = value; _isModified_ = true; }
        }


        [Column(Name = "PostalCode", DbType = "NVarChar(10)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string PostalCode
        {
            get { return _PostalCode; }
            set { _PostalCode = value; _isModified_ = true; }
        }


        [Column(Name = "Country", DbType = "NVarChar(15)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string Country
        {
            get { return _Country; }
            set { _Country = value; _isModified_ = true; }
        }


        [Column(Name = "Phone", DbType = "NVarChar(24)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string Phone
        {
            get { return _Phone; }
            set { _Phone = value; _isModified_ = true; }
        }


        [Column(Name = "Fax", DbType = "NVarChar(24)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string Fax
        {
            get { return _Fax; }
            set { _Fax = value; _isModified_ = true; }
        }

        #endregion

        #region GetHashCode(),Equals() - uses column _CustomerID to look up objects in liveObjectMap
        //TODO: move this logic our of user code, into a generated class
        public override int GetHashCode()
        {
            return _CustomerID.GetHashCode();
        }
        public override bool Equals(object obj)
        {
            Customers o2 = obj as Customers;
            if (o2 == null)
                return false;
            return _CustomerID.Equals(o2._CustomerID);
        }
        #endregion


        [Association(Storage = "null", OtherKey = "CustomerID", Name = "FK_CustomerCustomerDemo_Customers")]
        public EntityMSet<CustomerCustomerDemo> CustomerCustomerDemo
        {
            get { return null; } //TODO L212
        }

        [Association(Storage = "null", OtherKey = "CustomerID", Name = "FK_Orders_Customers")]
        public EntityMSet<Orders> Orders
        {
            get { return null; } //TODO L212
        }

    }



    [Table(Name = "dbo.Employees")]
    public partial class Employees : IModified
    {
        bool _isModified_;
        public bool IsModified
        {
            get { return _isModified_; }
            set { _isModified_ = value; }
        }

        [DbLinq.Linq.Mapping.AutoGenId]
        protected int _EmployeeID;

        protected string _LastName;

        protected string _FirstName;

        protected string _Title;

        protected string _TitleOfCourtesy;

        protected System.DateTime? _BirthDate;

        protected System.DateTime? _HireDate;

        protected string _Address;

        protected string _City;

        protected string _Region;

        protected string _PostalCode;

        protected string _Country;

        protected string _HomePhone;

        protected string _Extension;

        protected System.Data.Linq.Binary _Photo;

        protected string _Notes;

        protected int? _ReportsTo;

        protected string _PhotoPath;


        #region costructors
        public Employees()
        {
        }
        public Employees(int EmployeeID, string LastName, string FirstName, string Title, string TitleOfCourtesy, System.DateTime? BirthDate, System.DateTime? HireDate, string Address, string City, string Region, string PostalCode, string Country, string HomePhone, string Extension, System.Data.Linq.Binary Photo, string Notes, int? ReportsTo, string PhotoPath)
        {
            this._EmployeeID = EmployeeID;
            this._LastName = LastName;
            this._FirstName = FirstName;
            this._Title = Title;
            this._TitleOfCourtesy = TitleOfCourtesy;
            this._BirthDate = BirthDate;
            this._HireDate = HireDate;
            this._Address = Address;
            this._City = City;
            this._Region = Region;
            this._PostalCode = PostalCode;
            this._Country = Country;
            this._HomePhone = HomePhone;
            this._Extension = Extension;
            this._Photo = Photo;
            this._Notes = Notes;
            this._ReportsTo = ReportsTo;
            this._PhotoPath = PhotoPath;
        }
        #endregion


        #region properties - accessors

        [Column(Name = "EmployeeID", DbType = "Int NOT NULL IDENTITY", IsPrimaryKey = true, IsDbGenerated = true)]
        [DebuggerNonUserCode]
        public int EmployeeID
        {
            get { return _EmployeeID; }
            set { _EmployeeID = value; _isModified_ = true; }
        }


        [Column(Name = "LastName", DbType = "NVarChar(20) NOT NULL", CanBeNull = false)]
        [DebuggerNonUserCode]
        public string LastName
        {
            get { return _LastName; }
            set { _LastName = value; _isModified_ = true; }
        }


        [Column(Name = "FirstName", DbType = "NVarChar(10) NOT NULL", CanBeNull = false)]
        [DebuggerNonUserCode]
        public string FirstName
        {
            get { return _FirstName; }
            set { _FirstName = value; _isModified_ = true; }
        }


        [Column(Name = "Title", DbType = "NVarChar(30)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string Title
        {
            get { return _Title; }
            set { _Title = value; _isModified_ = true; }
        }


        [Column(Name = "TitleOfCourtesy", DbType = "NVarChar(25)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string TitleOfCourtesy
        {
            get { return _TitleOfCourtesy; }
            set { _TitleOfCourtesy = value; _isModified_ = true; }
        }


        [Column(Name = "BirthDate", DbType = "DateTime", CanBeNull = true)]
        [DebuggerNonUserCode]
        public System.DateTime? BirthDate
        {
            get { return _BirthDate; }
            set { _BirthDate = value; _isModified_ = true; }
        }


        [Column(Name = "HireDate", DbType = "DateTime", CanBeNull = true)]
        [DebuggerNonUserCode]
        public System.DateTime? HireDate
        {
            get { return _HireDate; }
            set { _HireDate = value; _isModified_ = true; }
        }


        [Column(Name = "Address", DbType = "NVarChar(60)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string Address
        {
            get { return _Address; }
            set { _Address = value; _isModified_ = true; }
        }


        [Column(Name = "City", DbType = "NVarChar(15)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string City
        {
            get { return _City; }
            set { _City = value; _isModified_ = true; }
        }


        [Column(Name = "Region", DbType = "NVarChar(15)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string Region
        {
            get { return _Region; }
            set { _Region = value; _isModified_ = true; }
        }


        [Column(Name = "PostalCode", DbType = "NVarChar(10)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string PostalCode
        {
            get { return _PostalCode; }
            set { _PostalCode = value; _isModified_ = true; }
        }


        [Column(Name = "Country", DbType = "NVarChar(15)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string Country
        {
            get { return _Country; }
            set { _Country = value; _isModified_ = true; }
        }


        [Column(Name = "HomePhone", DbType = "NVarChar(24)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string HomePhone
        {
            get { return _HomePhone; }
            set { _HomePhone = value; _isModified_ = true; }
        }


        [Column(Name = "Extension", DbType = "NVarChar(4)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string Extension
        {
            get { return _Extension; }
            set { _Extension = value; _isModified_ = true; }
        }


        [Column(Name = "Photo", DbType = "Image", CanBeNull = true)]
        [DebuggerNonUserCode]
        public System.Data.Linq.Binary Photo
        {
            get { return _Photo; }
            set { _Photo = value; _isModified_ = true; }
        }


        [Column(Name = "Notes", DbType = "NText", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string Notes
        {
            get { return _Notes; }
            set { _Notes = value; _isModified_ = true; }
        }


        [Column(Name = "ReportsTo", DbType = "Int", CanBeNull = true)]
        [DebuggerNonUserCode]
        public int? ReportsTo
        {
            get { return _ReportsTo; }
            set { _ReportsTo = value; _isModified_ = true; }
        }


        [Column(Name = "PhotoPath", DbType = "NVarChar(255)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string PhotoPath
        {
            get { return _PhotoPath; }
            set { _PhotoPath = value; _isModified_ = true; }
        }

        #endregion

        #region GetHashCode(),Equals() - uses column _EmployeeID to look up objects in liveObjectMap
        //TODO: move this logic our of user code, into a generated class
        public override int GetHashCode()
        {
            return _EmployeeID.GetHashCode();
        }
        public override bool Equals(object obj)
        {
            Employees o2 = obj as Employees;
            if (o2 == null)
                return false;
            return _EmployeeID.Equals(o2._EmployeeID);
        }
        #endregion


        [Association(Storage = "null", OtherKey = "ReportsTo", Name = "FK_Employees_Employees")]
        public EntityMSet<Employees> Employee
        {
            get { return null; } //TODO L212
        }

        [Association(Storage = "null", OtherKey = "EmployeeID", Name = "FK_EmployeeTerritories_Employees")]
        public EntityMSet<EmployeeTerritories> EmployeeTerritories
        {
            get { return null; } //TODO L212
        }

        [Association(Storage = "null", OtherKey = "EmployeeID", Name = "FK_Orders_Employees")]
        public EntityMSet<Orders> Orders
        {
            get { return null; } //TODO L212
        }

        private System.Data.Linq.EntityRef<Employees> _Employees;

        [Association(Storage = "_Employees", ThisKey = "ReportsTo", Name = "FK_Employees_Employees")]
        [DebuggerNonUserCode]
        public Employees ReportsToEmployees
        {
            get { return this._Employees.Entity; }
            set { this._Employees.Entity = value; }
        }

    }



    [Table(Name = "dbo.EmployeeTerritories")]
    public partial class EmployeeTerritories : IModified
    {
        bool _isModified_;
        public bool IsModified
        {
            get { return _isModified_; }
            set { _isModified_ = value; }
        }


        protected int _EmployeeID;

        protected string _TerritoryID;


        #region costructors
        public EmployeeTerritories()
        {
        }
        public EmployeeTerritories(int EmployeeID, string TerritoryID)
        {
            this._EmployeeID = EmployeeID;
            this._TerritoryID = TerritoryID;
        }
        #endregion


        #region properties - accessors

        [Column(Name = "EmployeeID", DbType = "Int NOT NULL", IsPrimaryKey = true)]
        [DebuggerNonUserCode]
        public int EmployeeID
        {
            get { return _EmployeeID; }
            set { _EmployeeID = value; _isModified_ = true; }
        }


        [Column(Name = "TerritoryID", DbType = "NVarChar(20) NOT NULL", IsPrimaryKey = true)]
        [DebuggerNonUserCode]
        public string TerritoryID
        {
            get { return _TerritoryID; }
            set { _TerritoryID = value; _isModified_ = true; }
        }

        #endregion

        #region GetHashCode(),Equals() - uses column _EmployeeID to look up objects in liveObjectMap
        //TODO: move this logic our of user code, into a generated class
        public override int GetHashCode()
        {
            return _EmployeeID.GetHashCode();
        }
        public override bool Equals(object obj)
        {
            EmployeeTerritories o2 = obj as EmployeeTerritories;
            if (o2 == null)
                return false;
            return _EmployeeID.Equals(o2._EmployeeID);
        }
        #endregion



        private System.Data.Linq.EntityRef<Employees> _Employees;

        [Association(Storage = "_Employees", ThisKey = "EmployeeID", Name = "FK_EmployeeTerritories_Employees")]
        [DebuggerNonUserCode]
        public Employees Employees
        {
            get { return this._Employees.Entity; }
            set { this._Employees.Entity = value; }
        }


        private System.Data.Linq.EntityRef<Territories> _Territories;

        [Association(Storage = "_Territories", ThisKey = "TerritoryID", Name = "FK_EmployeeTerritories_Territories")]
        [DebuggerNonUserCode]
        public Territories Territories
        {
            get { return this._Territories.Entity; }
            set { this._Territories.Entity = value; }
        }

    }



    [Table(Name = "dbo.Order Details")]
    public partial class OrderDetails : IModified
    {
        bool _isModified_;
        public bool IsModified
        {
            get { return _isModified_; }
            set { _isModified_ = value; }
        }


        protected int _OrderID;

        protected int _ProductID;

        protected decimal _UnitPrice;

        protected short _Quantity;

        protected System.Single _Discount;


        #region costructors
        public OrderDetails()
        {
        }
        public OrderDetails(int OrderID, int ProductID, decimal UnitPrice, short Quantity, System.Single Discount)
        {
            this._OrderID = OrderID;
            this._ProductID = ProductID;
            this._UnitPrice = UnitPrice;
            this._Quantity = Quantity;
            this._Discount = Discount;
        }
        #endregion


        #region properties - accessors

        [Column(Name = "OrderID", DbType = "Int NOT NULL", IsPrimaryKey = true)]
        [DebuggerNonUserCode]
        public int OrderID
        {
            get { return _OrderID; }
            set { _OrderID = value; _isModified_ = true; }
        }


        [Column(Name = "ProductID", DbType = "Int NOT NULL", IsPrimaryKey = true)]
        [DebuggerNonUserCode]
        public int ProductID
        {
            get { return _ProductID; }
            set { _ProductID = value; _isModified_ = true; }
        }


        [Column(Name = "UnitPrice", DbType = "Money NOT NULL", CanBeNull = false)]
        [DebuggerNonUserCode]
        public decimal UnitPrice
        {
            get { return _UnitPrice; }
            set { _UnitPrice = value; _isModified_ = true; }
        }


        [Column(Name = "Quantity", DbType = "SmallInt NOT NULL", CanBeNull = false)]
        [DebuggerNonUserCode]
        public short Quantity
        {
            get { return _Quantity; }
            set { _Quantity = value; _isModified_ = true; }
        }


        [Column(Name = "Discount", DbType = "Real NOT NULL", CanBeNull = false)]
        [DebuggerNonUserCode]
        public System.Single Discount
        {
            get { return _Discount; }
            set { _Discount = value; _isModified_ = true; }
        }

        #endregion

        #region GetHashCode(),Equals() - uses column _OrderID to look up objects in liveObjectMap
        //TODO: move this logic our of user code, into a generated class
        public override int GetHashCode()
        {
            return _OrderID.GetHashCode();
        }
        public override bool Equals(object obj)
        {
            OrderDetails o2 = obj as OrderDetails;
            if (o2 == null)
                return false;
            return _OrderID.Equals(o2._OrderID);
        }
        #endregion



        private System.Data.Linq.EntityRef<Orders> _Orders;

        [Association(Storage = "_Orders", ThisKey = "OrderID", Name = "FK_Order_Details_Orders")]
        [DebuggerNonUserCode]
        public Orders Orders
        {
            get { return this._Orders.Entity; }
            set { this._Orders.Entity = value; }
        }


        private System.Data.Linq.EntityRef<Products> _Products;

        [Association(Storage = "_Products", ThisKey = "ProductID", Name = "FK_Order_Details_Products")]
        [DebuggerNonUserCode]
        public Products Products
        {
            get { return this._Products.Entity; }
            set { this._Products.Entity = value; }
        }

    }



    [Table(Name = "dbo.Orders")]
    public partial class Orders : IModified
    {
        bool _isModified_;
        public bool IsModified
        {
            get { return _isModified_; }
            set { _isModified_ = value; }
        }

        [DbLinq.Linq.Mapping.AutoGenId]
        protected int _OrderID;

        protected string _CustomerID;

        protected int? _EmployeeID;

        protected System.DateTime? _OrderDate;

        protected System.DateTime? _RequiredDate;

        protected System.DateTime? _ShippedDate;

        protected int? _ShipVia;

        protected decimal? _Freight;

        protected string _ShipName;

        protected string _ShipAddress;

        protected string _ShipCity;

        protected string _ShipRegion;

        protected string _ShipPostalCode;

        protected string _ShipCountry;


        #region costructors
        public Orders()
        {
        }
        public Orders(int OrderID, string CustomerID, int? EmployeeID, System.DateTime? OrderDate, System.DateTime? RequiredDate, System.DateTime? ShippedDate, int? ShipVia, decimal? Freight, string ShipName, string ShipAddress, string ShipCity, string ShipRegion, string ShipPostalCode, string ShipCountry)
        {
            this._OrderID = OrderID;
            this._CustomerID = CustomerID;
            this._EmployeeID = EmployeeID;
            this._OrderDate = OrderDate;
            this._RequiredDate = RequiredDate;
            this._ShippedDate = ShippedDate;
            this._ShipVia = ShipVia;
            this._Freight = Freight;
            this._ShipName = ShipName;
            this._ShipAddress = ShipAddress;
            this._ShipCity = ShipCity;
            this._ShipRegion = ShipRegion;
            this._ShipPostalCode = ShipPostalCode;
            this._ShipCountry = ShipCountry;
        }
        #endregion


        #region properties - accessors

        [Column(Name = "OrderID", DbType = "Int NOT NULL IDENTITY", IsPrimaryKey = true, IsDbGenerated = true)]
        [DebuggerNonUserCode]
        public int OrderID
        {
            get { return _OrderID; }
            set { _OrderID = value; _isModified_ = true; }
        }


        [Column(Name = "CustomerID", DbType = "NChar(5)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string CustomerID
        {
            get { return _CustomerID; }
            set { _CustomerID = value; _isModified_ = true; }
        }


        [Column(Name = "EmployeeID", DbType = "Int", CanBeNull = true)]
        [DebuggerNonUserCode]
        public int? EmployeeID
        {
            get { return _EmployeeID; }
            set { _EmployeeID = value; _isModified_ = true; }
        }


        [Column(Name = "OrderDate", DbType = "DateTime", CanBeNull = true)]
        [DebuggerNonUserCode]
        public System.DateTime? OrderDate
        {
            get { return _OrderDate; }
            set { _OrderDate = value; _isModified_ = true; }
        }


        [Column(Name = "RequiredDate", DbType = "DateTime", CanBeNull = true)]
        [DebuggerNonUserCode]
        public System.DateTime? RequiredDate
        {
            get { return _RequiredDate; }
            set { _RequiredDate = value; _isModified_ = true; }
        }


        [Column(Name = "ShippedDate", DbType = "DateTime", CanBeNull = true)]
        [DebuggerNonUserCode]
        public System.DateTime? ShippedDate
        {
            get { return _ShippedDate; }
            set { _ShippedDate = value; _isModified_ = true; }
        }


        [Column(Name = "ShipVia", DbType = "Int", CanBeNull = true)]
        [DebuggerNonUserCode]
        public int? ShipVia
        {
            get { return _ShipVia; }
            set { _ShipVia = value; _isModified_ = true; }
        }


        [Column(Name = "Freight", DbType = "Money", CanBeNull = true)]
        [DebuggerNonUserCode]
        public decimal? Freight
        {
            get { return _Freight; }
            set { _Freight = value; _isModified_ = true; }
        }


        [Column(Name = "ShipName", DbType = "NVarChar(40)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string ShipName
        {
            get { return _ShipName; }
            set { _ShipName = value; _isModified_ = true; }
        }


        [Column(Name = "ShipAddress", DbType = "NVarChar(60)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string ShipAddress
        {
            get { return _ShipAddress; }
            set { _ShipAddress = value; _isModified_ = true; }
        }


        [Column(Name = "ShipCity", DbType = "NVarChar(15)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string ShipCity
        {
            get { return _ShipCity; }
            set { _ShipCity = value; _isModified_ = true; }
        }


        [Column(Name = "ShipRegion", DbType = "NVarChar(15)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string ShipRegion
        {
            get { return _ShipRegion; }
            set { _ShipRegion = value; _isModified_ = true; }
        }


        [Column(Name = "ShipPostalCode", DbType = "NVarChar(10)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string ShipPostalCode
        {
            get { return _ShipPostalCode; }
            set { _ShipPostalCode = value; _isModified_ = true; }
        }


        [Column(Name = "ShipCountry", DbType = "NVarChar(15)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string ShipCountry
        {
            get { return _ShipCountry; }
            set { _ShipCountry = value; _isModified_ = true; }
        }

        #endregion

        #region GetHashCode(),Equals() - uses column _OrderID to look up objects in liveObjectMap
        //TODO: move this logic our of user code, into a generated class
        public override int GetHashCode()
        {
            return _OrderID.GetHashCode();
        }
        public override bool Equals(object obj)
        {
            Orders o2 = obj as Orders;
            if (o2 == null)
                return false;
            return _OrderID.Equals(o2._OrderID);
        }
        #endregion


        [Association(Storage = "null", OtherKey = "OrderID", Name = "FK_Order_Details_Orders")]
        public EntityMSet<OrderDetails> OrderDetails
        {
            get { return null; } //TODO L212
        }

        private System.Data.Linq.EntityRef<Customers> _Customers;

        [Association(Storage = "_Customers", ThisKey = "CustomerID", Name = "FK_Orders_Customers")]
        [DebuggerNonUserCode]
        public Customers Customers
        {
            get { return this._Customers.Entity; }
            set { this._Customers.Entity = value; }
        }


        private System.Data.Linq.EntityRef<Employees> _Employees;

        [Association(Storage = "_Employees", ThisKey = "EmployeeID", Name = "FK_Orders_Employees")]
        [DebuggerNonUserCode]
        public Employees Employees
        {
            get { return this._Employees.Entity; }
            set { this._Employees.Entity = value; }
        }


        private System.Data.Linq.EntityRef<Shippers> _Shippers;

        [Association(Storage = "_Shippers", ThisKey = "ShipVia", Name = "FK_Orders_Shippers")]
        [DebuggerNonUserCode]
        public Shippers Shippers
        {
            get { return this._Shippers.Entity; }
            set { this._Shippers.Entity = value; }
        }

    }



    [Table(Name = "dbo.Products")]
    public partial class Products : IModified
    {
        bool _isModified_;
        public bool IsModified
        {
            get { return _isModified_; }
            set { _isModified_ = value; }
        }

        [DbLinq.Linq.Mapping.AutoGenId]
        protected int _ProductID;

        protected string _ProductName;

        protected int? _SupplierID;

        protected int? _CategoryID;

        protected string _QuantityPerUnit;

        protected decimal? _UnitPrice;

        protected short? _UnitsInStock;

        protected short? _UnitsOnOrder;

        protected short? _ReorderLevel;

        protected System.Boolean _Discontinued;


        #region costructors
        public Products()
        {
        }
        public Products(int ProductID, string ProductName, int? SupplierID, int? CategoryID, string QuantityPerUnit, decimal? UnitPrice, short? UnitsInStock, short? UnitsOnOrder, short? ReorderLevel, System.Boolean Discontinued)
        {
            this._ProductID = ProductID;
            this._ProductName = ProductName;
            this._SupplierID = SupplierID;
            this._CategoryID = CategoryID;
            this._QuantityPerUnit = QuantityPerUnit;
            this._UnitPrice = UnitPrice;
            this._UnitsInStock = UnitsInStock;
            this._UnitsOnOrder = UnitsOnOrder;
            this._ReorderLevel = ReorderLevel;
            this._Discontinued = Discontinued;
        }
        #endregion


        #region properties - accessors

        [Column(Name = "ProductID", DbType = "Int NOT NULL IDENTITY", IsPrimaryKey = true, IsDbGenerated = true)]
        [DebuggerNonUserCode]
        public int ProductID
        {
            get { return _ProductID; }
            set { _ProductID = value; _isModified_ = true; }
        }


        [Column(Name = "ProductName", DbType = "NVarChar(40) NOT NULL", CanBeNull = false)]
        [DebuggerNonUserCode]
        public string ProductName
        {
            get { return _ProductName; }
            set { _ProductName = value; _isModified_ = true; }
        }


        [Column(Name = "SupplierID", DbType = "Int", CanBeNull = true)]
        [DebuggerNonUserCode]
        public int? SupplierID
        {
            get { return _SupplierID; }
            set { _SupplierID = value; _isModified_ = true; }
        }


        [Column(Name = "CategoryID", DbType = "Int", CanBeNull = true)]
        [DebuggerNonUserCode]
        public int? CategoryID
        {
            get { return _CategoryID; }
            set { _CategoryID = value; _isModified_ = true; }
        }


        [Column(Name = "QuantityPerUnit", DbType = "NVarChar(20)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string QuantityPerUnit
        {
            get { return _QuantityPerUnit; }
            set { _QuantityPerUnit = value; _isModified_ = true; }
        }


        [Column(Name = "UnitPrice", DbType = "Money", CanBeNull = true)]
        [DebuggerNonUserCode]
        public decimal? UnitPrice
        {
            get { return _UnitPrice; }
            set { _UnitPrice = value; _isModified_ = true; }
        }


        [Column(Name = "UnitsInStock", DbType = "SmallInt", CanBeNull = true)]
        [DebuggerNonUserCode]
        public short? UnitsInStock
        {
            get { return _UnitsInStock; }
            set { _UnitsInStock = value; _isModified_ = true; }
        }


        [Column(Name = "UnitsOnOrder", DbType = "SmallInt", CanBeNull = true)]
        [DebuggerNonUserCode]
        public short? UnitsOnOrder
        {
            get { return _UnitsOnOrder; }
            set { _UnitsOnOrder = value; _isModified_ = true; }
        }


        [Column(Name = "ReorderLevel", DbType = "SmallInt", CanBeNull = true)]
        [DebuggerNonUserCode]
        public short? ReorderLevel
        {
            get { return _ReorderLevel; }
            set { _ReorderLevel = value; _isModified_ = true; }
        }


        [Column(Name = "Discontinued", DbType = "Bit NOT NULL", CanBeNull = false)]
        [DebuggerNonUserCode]
        public System.Boolean Discontinued
        {
            get { return _Discontinued; }
            set { _Discontinued = value; _isModified_ = true; }
        }

        #endregion

        #region GetHashCode(),Equals() - uses column _ProductID to look up objects in liveObjectMap
        //TODO: move this logic our of user code, into a generated class
        public override int GetHashCode()
        {
            return _ProductID.GetHashCode();
        }
        public override bool Equals(object obj)
        {
            Products o2 = obj as Products;
            if (o2 == null)
                return false;
            return _ProductID.Equals(o2._ProductID);
        }
        #endregion


        [Association(Storage = "null", OtherKey = "ProductID", Name = "FK_Order_Details_Products")]
        public EntityMSet<OrderDetails> OrderDetails
        {
            get { return null; } //TODO L212
        }

        private System.Data.Linq.EntityRef<Categories> _Categories;

        [Association(Storage = "_Categories", ThisKey = "CategoryID", Name = "FK_Products_Categories")]
        [DebuggerNonUserCode]
        public Categories Categories
        {
            get { return this._Categories.Entity; }
            set { this._Categories.Entity = value; }
        }


        private System.Data.Linq.EntityRef<Suppliers> _Suppliers;

        [Association(Storage = "_Suppliers", ThisKey = "SupplierID", Name = "FK_Products_Suppliers")]
        [DebuggerNonUserCode]
        public Suppliers Suppliers
        {
            get { return this._Suppliers.Entity; }
            set { this._Suppliers.Entity = value; }
        }

    }



    [Table(Name = "dbo.Region")]
    public partial class Region : IModified
    {
        bool _isModified_;
        public bool IsModified
        {
            get { return _isModified_; }
            set { _isModified_ = value; }
        }


        protected int _RegionID;

        protected string _RegionDescription;


        #region costructors
        public Region()
        {
        }
        public Region(int RegionID, string RegionDescription)
        {
            this._RegionID = RegionID;
            this._RegionDescription = RegionDescription;
        }
        #endregion


        #region properties - accessors

        [Column(Name = "RegionID", DbType = "Int NOT NULL", IsPrimaryKey = true)]
        [DebuggerNonUserCode]
        public int RegionID
        {
            get { return _RegionID; }
            set { _RegionID = value; _isModified_ = true; }
        }


        [Column(Name = "RegionDescription", DbType = "NChar(50) NOT NULL", CanBeNull = false)]
        [DebuggerNonUserCode]
        public string RegionDescription
        {
            get { return _RegionDescription; }
            set { _RegionDescription = value; _isModified_ = true; }
        }

        #endregion

        #region GetHashCode(),Equals() - uses column _RegionID to look up objects in liveObjectMap
        //TODO: move this logic our of user code, into a generated class
        public override int GetHashCode()
        {
            return _RegionID.GetHashCode();
        }
        public override bool Equals(object obj)
        {
            Region o2 = obj as Region;
            if (o2 == null)
                return false;
            return _RegionID.Equals(o2._RegionID);
        }
        #endregion


        [Association(Storage = "null", OtherKey = "RegionID", Name = "FK_Territories_Region")]
        public EntityMSet<Territories> Territories
        {
            get { return null; } //TODO L212
        }

    }



    [Table(Name = "dbo.Shippers")]
    public partial class Shippers : IModified
    {
        bool _isModified_;
        public bool IsModified
        {
            get { return _isModified_; }
            set { _isModified_ = value; }
        }

        [DbLinq.Linq.Mapping.AutoGenId]
        protected int _ShipperID;

        protected string _CompanyName;

        protected string _Phone;


        #region costructors
        public Shippers()
        {
        }
        public Shippers(int ShipperID, string CompanyName, string Phone)
        {
            this._ShipperID = ShipperID;
            this._CompanyName = CompanyName;
            this._Phone = Phone;
        }
        #endregion


        #region properties - accessors

        [Column(Name = "ShipperID", DbType = "Int NOT NULL IDENTITY", IsPrimaryKey = true, IsDbGenerated = true)]
        [DebuggerNonUserCode]
        public int ShipperID
        {
            get { return _ShipperID; }
            set { _ShipperID = value; _isModified_ = true; }
        }


        [Column(Name = "CompanyName", DbType = "NVarChar(40) NOT NULL", CanBeNull = false)]
        [DebuggerNonUserCode]
        public string CompanyName
        {
            get { return _CompanyName; }
            set { _CompanyName = value; _isModified_ = true; }
        }


        [Column(Name = "Phone", DbType = "NVarChar(24)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string Phone
        {
            get { return _Phone; }
            set { _Phone = value; _isModified_ = true; }
        }

        #endregion

        #region GetHashCode(),Equals() - uses column _ShipperID to look up objects in liveObjectMap
        //TODO: move this logic our of user code, into a generated class
        public override int GetHashCode()
        {
            return _ShipperID.GetHashCode();
        }
        public override bool Equals(object obj)
        {
            Shippers o2 = obj as Shippers;
            if (o2 == null)
                return false;
            return _ShipperID.Equals(o2._ShipperID);
        }
        #endregion


        [Association(Storage = "null", OtherKey = "ShipVia", Name = "FK_Orders_Shippers")]
        public EntityMSet<Orders> Orders
        {
            get { return null; } //TODO L212
        }

    }



    [Table(Name = "dbo.Suppliers")]
    public partial class Suppliers : IModified
    {
        bool _isModified_;
        public bool IsModified
        {
            get { return _isModified_; }
            set { _isModified_ = value; }
        }

        [DbLinq.Linq.Mapping.AutoGenId]
        protected int _SupplierID;

        protected string _CompanyName;

        protected string _ContactName;

        protected string _ContactTitle;

        protected string _Address;

        protected string _City;

        protected string _Region;

        protected string _PostalCode;

        protected string _Country;

        protected string _Phone;

        protected string _Fax;

        protected string _HomePage;


        #region costructors
        public Suppliers()
        {
        }
        public Suppliers(int SupplierID, string CompanyName, string ContactName, string ContactTitle, string Address, string City, string Region, string PostalCode, string Country, string Phone, string Fax, string HomePage)
        {
            this._SupplierID = SupplierID;
            this._CompanyName = CompanyName;
            this._ContactName = ContactName;
            this._ContactTitle = ContactTitle;
            this._Address = Address;
            this._City = City;
            this._Region = Region;
            this._PostalCode = PostalCode;
            this._Country = Country;
            this._Phone = Phone;
            this._Fax = Fax;
            this._HomePage = HomePage;
        }
        #endregion


        #region properties - accessors

        [Column(Name = "SupplierID", DbType = "Int NOT NULL IDENTITY", IsPrimaryKey = true, IsDbGenerated = true)]
        [DebuggerNonUserCode]
        public int SupplierID
        {
            get { return _SupplierID; }
            set { _SupplierID = value; _isModified_ = true; }
        }


        [Column(Name = "CompanyName", DbType = "NVarChar(40) NOT NULL", CanBeNull = false)]
        [DebuggerNonUserCode]
        public string CompanyName
        {
            get { return _CompanyName; }
            set { _CompanyName = value; _isModified_ = true; }
        }


        [Column(Name = "ContactName", DbType = "NVarChar(30)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string ContactName
        {
            get { return _ContactName; }
            set { _ContactName = value; _isModified_ = true; }
        }


        [Column(Name = "ContactTitle", DbType = "NVarChar(30)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string ContactTitle
        {
            get { return _ContactTitle; }
            set { _ContactTitle = value; _isModified_ = true; }
        }


        [Column(Name = "Address", DbType = "NVarChar(60)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string Address
        {
            get { return _Address; }
            set { _Address = value; _isModified_ = true; }
        }


        [Column(Name = "City", DbType = "NVarChar(15)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string City
        {
            get { return _City; }
            set { _City = value; _isModified_ = true; }
        }


        [Column(Name = "Region", DbType = "NVarChar(15)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string Region
        {
            get { return _Region; }
            set { _Region = value; _isModified_ = true; }
        }


        [Column(Name = "PostalCode", DbType = "NVarChar(10)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string PostalCode
        {
            get { return _PostalCode; }
            set { _PostalCode = value; _isModified_ = true; }
        }


        [Column(Name = "Country", DbType = "NVarChar(15)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string Country
        {
            get { return _Country; }
            set { _Country = value; _isModified_ = true; }
        }


        [Column(Name = "Phone", DbType = "NVarChar(24)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string Phone
        {
            get { return _Phone; }
            set { _Phone = value; _isModified_ = true; }
        }


        [Column(Name = "Fax", DbType = "NVarChar(24)", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string Fax
        {
            get { return _Fax; }
            set { _Fax = value; _isModified_ = true; }
        }


        [Column(Name = "HomePage", DbType = "NText", CanBeNull = true)]
        [DebuggerNonUserCode]
        public string HomePage
        {
            get { return _HomePage; }
            set { _HomePage = value; _isModified_ = true; }
        }

        #endregion

        #region GetHashCode(),Equals() - uses column _SupplierID to look up objects in liveObjectMap
        //TODO: move this logic our of user code, into a generated class
        public override int GetHashCode()
        {
            return _SupplierID.GetHashCode();
        }
        public override bool Equals(object obj)
        {
            Suppliers o2 = obj as Suppliers;
            if (o2 == null)
                return false;
            return _SupplierID.Equals(o2._SupplierID);
        }
        #endregion


        [Association(Storage = "null", OtherKey = "SupplierID", Name = "FK_Products_Suppliers")]
        public EntityMSet<Products> Products
        {
            get { return null; } //TODO L212
        }

    }



    [Table(Name = "dbo.Territories")]
    public partial class Territories : IModified
    {
        bool _isModified_;
        public bool IsModified
        {
            get { return _isModified_; }
            set { _isModified_ = value; }
        }


        protected string _TerritoryID;

        protected string _TerritoryDescription;

        protected int _RegionID;


        #region costructors
        public Territories()
        {
        }
        public Territories(string TerritoryID, string TerritoryDescription, int RegionID)
        {
            this._TerritoryID = TerritoryID;
            this._TerritoryDescription = TerritoryDescription;
            this._RegionID = RegionID;
        }
        #endregion


        #region properties - accessors

        [Column(Name = "TerritoryID", DbType = "NVarChar(20) NOT NULL", IsPrimaryKey = true)]
        [DebuggerNonUserCode]
        public string TerritoryID
        {
            get { return _TerritoryID; }
            set { _TerritoryID = value; _isModified_ = true; }
        }


        [Column(Name = "TerritoryDescription", DbType = "NChar(50) NOT NULL", CanBeNull = false)]
        [DebuggerNonUserCode]
        public string TerritoryDescription
        {
            get { return _TerritoryDescription; }
            set { _TerritoryDescription = value; _isModified_ = true; }
        }


        [Column(Name = "RegionID", DbType = "Int NOT NULL", CanBeNull = false)]
        [DebuggerNonUserCode]
        public int RegionID
        {
            get { return _RegionID; }
            set { _RegionID = value; _isModified_ = true; }
        }

        #endregion

        #region GetHashCode(),Equals() - uses column _TerritoryID to look up objects in liveObjectMap
        //TODO: move this logic our of user code, into a generated class
        public override int GetHashCode()
        {
            return _TerritoryID.GetHashCode();
        }
        public override bool Equals(object obj)
        {
            Territories o2 = obj as Territories;
            if (o2 == null)
                return false;
            return _TerritoryID.Equals(o2._TerritoryID);
        }
        #endregion


        [Association(Storage = "null", OtherKey = "TerritoryID", Name = "FK_EmployeeTerritories_Territories")]
        public EntityMSet<EmployeeTerritories> EmployeeTerritories
        {
            get { return null; } //TODO L212
        }

        private System.Data.Linq.EntityRef<Region> _Region;

        [Association(Storage = "_Region", ThisKey = "RegionID", Name = "FK_Territories_Region")]
        [DebuggerNonUserCode]
        public Region Region
        {
            get { return this._Region.Entity; }
            set { this._Region.Entity = value; }
        }

    }

}