# файл конфигурации

Данный файл позволяет настроить некоторые аспекты поведения RHVoice. В
текущей версии файл считывается только один раз, при инициализации
синтезатора. Это означает, что для того, чтобы изменения настроек
вступили в силу, необходимо перезапустить программу, использующую
RHVoice.

В Windows имя файла конфигурации - `RHVoice.ini`, на других
платформах - `RHVoice.conf`.

## Расположение

### GNU/Linux

Путь к директории с пользовательскими настройками определяется при
компиляции. Его можно переопределить, задав значение переменной
`sysconfdir` при вызове `scons`. По умолчанию используется значение
`$prefix/etc`, что, при использовании значения переменной `prefix` по
умолчанию, означает `/usr/local/etc`.

Полный путь к конфигурационному файлу - `$sysconfdir/RHVoice/RHVoice.conf`.

### Windows

#### Версия для SAPI5

Путь к файлу - `%APPDATA%\RHVoice\RHVoice.ini`.

#### Версия для NVDA

Перейдите в папку, где NVDA хранит все пользовательские настройки.
Файл `RHVoice.ini` должен находиться в подпапке `RHVoice-config`.

### Android

В зависимости от устройства, конфигурационный файл может располагаться
либо во внутренней памяти, либо на карте памяти. Путь к файлу - `Android/data/com.github.olga_yakovleva.rhvoice.android/files/RHVoice.conf`.

## Формат

В целом RHVoice придерживается классического ini-формата. Поскольку
этот формат не задаётся никаким официальным стандартом, и существуют
различия в реализации между разными приложениями, далее перечислены
некоторые особенности, на которые следует обратить внимание.

* Файл должен сохраняться в кодировке UTF-8.
* В качестве символа комментария используется точка с запятой.
  Закомментировать можно только целую строку.
* В качестве десятичного разделителя используется точка.
* В значениях допускается представление любого символа его кодом. Формат
  представления соответствует формату числовых ссылок на символы,
  используемых в XML, только опускается начальный символ `&`.
  Например, русскую букву А можно записать следующим образом: `#1040;`.
* Если для опции допустимы только два логических значения, включена
  или отключена, то для включения можно использовать одно из ключевых
  слов: `true`, `yes`, `on` или `1`, а для отключения - `false`, `no`,
  `off` или `0`.

## Общие настройки и исключения

Для некоторых опций возможно указать, что они должны применяться
только к конкретному языку или голосу. Некоторые настройки доступны
только для какого-то одного языка.

### Настройки языков

Используется следующий формат:

```
languages.<язык>.<параметр>=<значение>
```

Язык можно задать одним из следующих способов:

* Английское название языка.
* Двухбуквенный код языка, согласно ISO 639-1.
* Трёхбуквенный код языка, согласно ISO 639-3.

Примеры:

```
languages.russian.default_rate=2
languages.eng.default_rate=0.8
```

### Настройки голосов

Используется следующий формат:

```
voices.<имя>.<параметр>=<значение>
```

Пример:

```
voices.elena.enabled=no
```

## Доступные опции

### Скорость, высота и громкость

Настройки из данной группы определяют, как RHVoice должен
интерпретировать значения скорости, высоты и громкости, которые он
получает от программ-клиентов.

Значение `1` соответствует стандартному поведению голосов.

Например, NVDA передаёт синтезатору значения скорости, выраженные в процентах.
RHVoice интерпретирует 50% как скорость по умолчанию (`default_rate`),
а 100% - как максимальную скорость (`max_rate`).

В следующей таблице показаны все опции этой группы.

Параметр|Описание|Значение по умолчанию|Минимальное значение|Максимальное значение
---|---|---|---|---
`default_rate`|скорость по умолчанию|1|`min_rate`|`max_rate`
`min_rate`|минимальная скорость|0.5|0.2|1
`max_rate`|максимальная скорость|2|1|5
`default_pitch`|высота по умолчанию|1|`min_pitch`|`max_pitch`
`min_pitch`|минимальная высота|0.5|0.5|1
`max_pitch`|максимальная высота|2|1|2
`default_volume`|громкость по умолчанию|1|`min_volume`|`max_volume`
`min_volume`|минимальная громкость|0.25|0.25|1
`max_volume`|максимальная громкость|2|1|4

Эти настройки можно задать как для синтезатора в целом, так и для
отдельных языков и голосов.

Примеры:

```
default_volume=0.8
languages.russian.default_rate=1.5
voices.aleksandr.default_pitch=0.9
```

#### Использование библиотеки Sonic

RHVoice может использовать [библиотеку Sonic](https://github.com/waywardgeek/sonic) для изменения скорости речи. Настройка `min_sonic_rate` задаёт минимальное значение скорости, начиная с которого вместо встроенного алгоритма изменения скорости будет использоваться Sonic. По умолчанию в Android всегда используется встроенный алгоритм, а на других платформах Sonic используется для ускорения речи, то есть синтезатор ведёт себя так, как будто в конфигурационном файле прописано:

```
min_sonic_rate=1
```

### Переключение языка и голосовые профили

RHVoice может анализировать входной текст и автоматически переключать
язык синтеза. Эта функциональность доступна только для языков, чьи
алфавиты не включают общих букв.

#### Голосовые профили

Голосовой профиль - это просто выбранное пользователем сочетание
голосов. Языки этих голосов должны отличаться. Первый голос в группе
считается основным голосом и задаёт так называемый основной язык.

Чтецы экрана и другие программы-клиенты будут включать голосовые
профили в список доступных голосов. Исключение составляет Android,
где, из-за особенностей этой платформы, пользовательские голосовые
профили не учитываются.

В конфигурационном файле голосовой профиль представляет собой
последовательность имён голосов, разделённых знаком `+`. Набор
голосовых профилей задаётся параметром `voice_profiles`. Его значение -
список профилей, разделённых запятой. 

Пример:

```
voice_profiles=anna+slt,aleksandr+alan
```

#### Переключение языков

Когда активен один из голосовых профилей, RHVoice постарается
использовать тот голос, который соответствует языку текста. Язык может
быть задан программой-клиентом или определён автоматически. Если не
удаётся определить язык, как при чтении отдельных чисел или названий
знаков пунктуации, будет использован основной голос - первый голос
профиля.

Если же такие элементы, как числа или неалфавитные символы,
встречаются внутри предложения, и RHVoice определил, что язык этого
предложения отличается от основного, возможны два варианта поведения
синтезатора: переключаться на основной голос при чтении этих элементов
или читать всё предложение одним голосом, соответствующим языку. По
умолчанию используется первый вариант, но пользователь может
переопределить поведение синтезатора, отключив опцию
`prefer_primary_language`:

```
prefer_primary_language=false
```

### Качество речи

Настройка `quality` позволяет выбрать один из трёх доступных вариантов качества речи.  Чем ниже качество, тем выше производительность: прежде всего, тем быстрее синтезатор начнёт говорить. Доступные режимы описаны в следующей таблице.

Значение|Частота дискретизации (кГц)|Оптимизация времени отклика
---|---|---
`max`|24|нет
`standard`|24|да
`min`|16|да

По умолчанию используется стандартное качество, то есть синтезатор ведёт себя так, как будто в конфигурационном файле прописано:

```
quality=standard
```

### Чтение пунктуации

Несмотря на название, настройки этой группы относятся и к другим
неалфавитным символам, даже если их нельзя, строго говоря,
классифицировать как знаки препинания.

#### Режим чтения пунктуации

Этот режим задаётся параметром `punctuation_mode`. Доступны следующие
варианты:

Значение|Описание
---|---
`none`|не читать (значение по умолчанию)
`some`|выборочное чтение
`all`|читать все знаки

Например, включить чтение всех знаков препинания можно следующим
образом:

```
punctuation_mode=all
```

#### Выборочное чтение пунктуации

Параметр `punctuation_list` задаёт, какие именно знаки произносить при
выборочном чтении. Например:

```
punctuation_list=@$/\
```

#### Названия знаков

Встроенный словарь знаков препинания и других символов нельзя назвать полным. Но пользователь может задать названия дополнительных символов в пользовательском словаре. 

### Заглавные буквы

Следующие настройки определяют, будет ли синтезатор при чтении
отдельных символов уведомлять пользователя, что буква является
заглавной.

#### Режим индикации заглавных букв

Этот режим задаётся параметром `indicate_capitals`. Поддерживаются
следующие значения:

Значение|Описание
---|---
`no`|отключить (значение по умолчанию)
`word`|произносить слово "заглавная" перед буквой
`pitch`|изменять высоту голоса
`sound`|подавать короткий звуковой сигнал

Пример:

```
indicate_capitals=pitch
```

#### Изменение высоты при произнесении заглавной буквы

Если включено изменение высоты голоса при чтении заглавных букв, то
параметр `cap_pitch_factor` задаёт значение этого изменение. Эта
настройка доступна как для синтезатора в целом, так и для отдельных
голосов.

Следующий пример устанавливает увеличение высоты на 30%:

```
cap_pitch_factor=1.3
```

### Указание ударения в тексте

Указание положения ударения в тексте поддерживается только для
русского и украинского языков. Например, чтобы указать синтезатору, что следующая за знаком `+` гласная должна получить ударение, нужно прописать в конфигурационном файле:

```
stress_marker=+
```

### Отключение отдельных языков и голосов

Вы можете сделать некоторые языки и голоса недоступными
программам-клиентам. Такая возможность может оказаться полезной, если
вы не используете эти языки или голоса и не хотите, чтобы ваш чтец
экрана их отображал. Следующий пример блокирует все английские голоса
и Александра:

```
languages.english.enabled=false
voices.aleksandr.enabled=false
```

### Поддержка псевдо-английского

Данный режим доступен только для языков, не использующих латинский алфавит.

При чтении английских слов голоса могут стараться по мере возможности следовать правильному английскому произношению. При этом они не могут использовать правильные английские звуки, а только наиболее близкие звуки родного языка.

Чтобы можно было использовать этот режим, необходимо, чтобы был установлен английский языковой пакет. При этом не обязательно устанавливать английские голоса.

Поддержка псевдо-английского включена по умолчанию, если английский языковой пакет установлен. Отключить её, например, для русских голосов можно так:

```
languages.russian.use_pseudo_english=no
```
