#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Cultist Simulator expansions:
# - Perpetual Edition
# - The Dancer
# - The Ghoul
# - The Priest
# - The Exile
###

script_version=20240531.1

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID='cultist-simulator'
GAME_NAME='Cultist Simulator'

EXPANSION_ID_PERPETUAL='perpetual-edition'
EXPANSION_NAME_PERPETUAL='Perpetual Edition'

EXPANSION_ID_DANCER='the-dancer'
EXPANSION_NAME_DANCER='The Dancer'

EXPANSION_ID_GHOUL='the-ghoul'
EXPANSION_NAME_GHOUL='The Ghoul'

EXPANSION_ID_PRIEST='the-priest'
EXPANSION_NAME_PRIEST='The Priest'

EXPANSION_ID_EXILE='the-exile'
EXPANSION_NAME_EXILE='The Exile'

# Archives

## Perpetual Edition

ARCHIVE_BASE_PERPETUAL_7_NAME='cultist_simulator_perpetual_edition_content_2023_12_s_5_71509.sh'
ARCHIVE_BASE_PERPETUAL_7_MD5='ba64a839ed79df208e346e45705028c7'
ARCHIVE_BASE_PERPETUAL_7_SIZE='897'
ARCHIVE_BASE_PERPETUAL_7_VERSION='2023.12.s.5-gog71509'

ARCHIVE_BASE_PERPETUAL_6_NAME='cultist_simulator_perpetual_edition_content_2023_12_s_4_71175.sh'
ARCHIVE_BASE_PERPETUAL_6_MD5='b06fb18d1183088111c459e4369823b0'
ARCHIVE_BASE_PERPETUAL_6_SIZE='897'
ARCHIVE_BASE_PERPETUAL_6_VERSION='2023.12.s.4-gog71175'

ARCHIVE_BASE_PERPETUAL_5_NAME='cultist_simulator_perpetual_edition_content_2023_10_r_10_68985.sh'
ARCHIVE_BASE_PERPETUAL_5_MD5='d4b6b6332df5a68e0e819ecfde900ca8'
ARCHIVE_BASE_PERPETUAL_5_SIZE='1212'
ARCHIVE_BASE_PERPETUAL_5_VERSION='2023.10.r.10-gog68985'

ARCHIVE_BASE_PERPETUAL_4_NAME='cultist_simulator_perpetual_edition_content_2023_5_p_12_67501.sh'
ARCHIVE_BASE_PERPETUAL_4_MD5='2a725b7b09eb2990bf5452b904575e0f'
ARCHIVE_BASE_PERPETUAL_4_SIZE='1212'
ARCHIVE_BASE_PERPETUAL_4_VERSION='2023.05.p.12-gog67501'

ARCHIVE_BASE_PERPETUAL_3_NAME='cultist_simulator_perpetual_edition_content_2023_4_o_4_64959.sh'
ARCHIVE_BASE_PERPETUAL_3_MD5='4e753614162be0092276c2f79c6fa536'
ARCHIVE_BASE_PERPETUAL_3_SIZE='1300'
ARCHIVE_BASE_PERPETUAL_3_VERSION='2023.04.o.4-gog64959'

ARCHIVE_BASE_PERPETUAL_2_NAME='cultist_simulator_perpetual_edition_content_2022_12_n_2_61763.sh'
ARCHIVE_BASE_PERPETUAL_2_MD5='d075fca6120b358a13349e0df210c80c'
ARCHIVE_BASE_PERPETUAL_2_SIZE='1300'
ARCHIVE_BASE_PERPETUAL_2_VERSION='2022.12.n.2-gog61763'

ARCHIVE_BASE_PERPETUAL_1_NAME='cultist_simulator_perpetual_edition_content_2022_3_p_1_54545.sh'
ARCHIVE_BASE_PERPETUAL_1_MD5='b6523031eb075dab51ab73aaeefd8b8a'
ARCHIVE_BASE_PERPETUAL_1_SIZE='1300'
ARCHIVE_BASE_PERPETUAL_1_VERSION='2022.03.p.1-gog54545'

ARCHIVE_BASE_PERPETUAL_0_NAME='cultist_simulator_perpetual_edition_content_2022_3_n_1_54418.sh'
ARCHIVE_BASE_PERPETUAL_0_MD5='76dd2895edb86c9e5086ff073b86bd41'
ARCHIVE_BASE_PERPETUAL_0_SIZE='1300'
ARCHIVE_BASE_PERPETUAL_0_VERSION='2022.03.n.1-gog54418'

## The Dancer

ARCHIVE_BASE_DANCER_7_NAME='cultist_simulator_the_dancer_2023_12_s_5_71509.sh'
ARCHIVE_BASE_DANCER_7_MD5='7411914a034e8f059f2f78b1476101d2'
ARCHIVE_BASE_DANCER_7_SIZE='1178'
ARCHIVE_BASE_DANCER_7_VERSION='2023.12.s.5-gog71509'
ARCHIVE_BASE_DANCER_7_URL='https://www.gog.com/game/cultist_simulator_the_dancer'

ARCHIVE_BASE_DANCER_6_NAME='cultist_simulator_the_dancer_2023_12_s_4_71175.sh'
ARCHIVE_BASE_DANCER_6_MD5='5a33ee82ccc822bc5a249288093e315a'
ARCHIVE_BASE_DANCER_6_SIZE='1178'
ARCHIVE_BASE_DANCER_6_VERSION='2023.12.s.4-gog71175'

ARCHIVE_BASE_DANCER_5_NAME='cultist_simulator_the_dancer_2023_10_r_10_68985.sh'
ARCHIVE_BASE_DANCER_5_MD5='3202862234290566863abf42afe2e0eb'
ARCHIVE_BASE_DANCER_5_SIZE='1580'
ARCHIVE_BASE_DANCER_5_VERSION='2023.10.r.10-gog68985'

ARCHIVE_BASE_DANCER_4_NAME='cultist_simulator_the_dancer_2023_5_p_12_67501.sh'
ARCHIVE_BASE_DANCER_4_MD5='1735b3ba59f8d72f04fac14fc0c7c58b'
ARCHIVE_BASE_DANCER_4_SIZE='1580'
ARCHIVE_BASE_DANCER_4_VERSION='2023.05.p.12-gog67501'

ARCHIVE_BASE_DANCER_3_NAME='cultist_simulator_the_dancer_2023_4_o_4_64959.sh'
ARCHIVE_BASE_DANCER_3_MD5='3174e4feddd8c11acc39aa0cac8696de'
ARCHIVE_BASE_DANCER_3_SIZE='1600'
ARCHIVE_BASE_DANCER_3_VERSION='2023.04.o.4-gog64959'

ARCHIVE_BASE_DANCER_2_NAME='cultist_simulator_the_dancer_2022_12_n_2_61763.sh'
ARCHIVE_BASE_DANCER_2_MD5='36fbfe3d25d28f0a465a72dc394eb6b7'
ARCHIVE_BASE_DANCER_2_SIZE='1600'
ARCHIVE_BASE_DANCER_2_VERSION='2022.12.n.2-gog61763'

ARCHIVE_BASE_DANCER_1_NAME='cultist_simulator_the_dancer_2022_3_p_1_54545.sh'
ARCHIVE_BASE_DANCER_1_MD5='e8b5d104fd30e6e7566bc24fbca5d718'
ARCHIVE_BASE_DANCER_1_SIZE='1600'
ARCHIVE_BASE_DANCER_1_VERSION='2022.03.p.1-gog54545'

ARCHIVE_BASE_DANCER_0_NAME='cultist_simulator_the_dancer_2022_3_n_1_54418.sh'
ARCHIVE_BASE_DANCER_0_MD5='8dbbb7e6121b9d62661837191f053405'
ARCHIVE_BASE_DANCER_0_SIZE='1600'
ARCHIVE_BASE_DANCER_0_VERSION='2022.03.n.1-gog54418'

## The Ghoul

ARCHIVE_BASE_GHOUL_7_NAME='cultist_simulator_the_ghoul_2023_12_s_5_71509.sh'
ARCHIVE_BASE_GHOUL_7_MD5='8185ddbb6681d90a233078d959188c2e'
ARCHIVE_BASE_GHOUL_7_SIZE='1163'
ARCHIVE_BASE_GHOUL_7_VERSION='2023.12.s.5-gog71509'
ARCHIVE_BASE_GHOUL_7_URL='https://www.gog.com/game/cultist_simulator_the_ghoul'

ARCHIVE_BASE_GHOUL_6_NAME='cultist_simulator_the_ghoul_2023_12_s_4_71175.sh'
ARCHIVE_BASE_GHOUL_6_MD5='ff6fdc10d98aea9e260522521112d176'
ARCHIVE_BASE_GHOUL_6_SIZE='1163'
ARCHIVE_BASE_GHOUL_6_VERSION='2023.12.s.4-gog71175'

ARCHIVE_BASE_GHOUL_5_NAME='cultist_simulator_the_ghoul_2023_10_r_10_68985.sh'
ARCHIVE_BASE_GHOUL_5_MD5='7ee4993ad1e507cd48c705a6cbc0fe90'
ARCHIVE_BASE_GHOUL_5_SIZE='1592'
ARCHIVE_BASE_GHOUL_5_VERSION='2023.10.r.10-gog68985'

ARCHIVE_BASE_GHOUL_4_NAME='cultist_simulator_the_ghoul_2023_5_p_12_67501.sh'
ARCHIVE_BASE_GHOUL_4_MD5='06c81c342ee8bcc81e298d5dd519d2e7'
ARCHIVE_BASE_GHOUL_4_SIZE='1592'
ARCHIVE_BASE_GHOUL_4_VERSION='2023.05.p.12-gog67501'

ARCHIVE_BASE_GHOUL_3_NAME='cultist_simulator_the_ghoul_2023_4_o_4_64959.sh'
ARCHIVE_BASE_GHOUL_3_MD5='246f3518914281bca5d0647170e1c12f'
ARCHIVE_BASE_GHOUL_3_SIZE='1600'
ARCHIVE_BASE_GHOUL_3_VERSION='2023.04.o.4-gog64959'

ARCHIVE_BASE_GHOUL_2_NAME='cultist_simulator_the_ghoul_2022_12_n_2_61763.sh'
ARCHIVE_BASE_GHOUL_2_MD5='53674742e8cb5a7570a6f5318a998261'
ARCHIVE_BASE_GHOUL_2_SIZE='1600'
ARCHIVE_BASE_GHOUL_2_VERSION='2022.12.n.2-gog61763'

ARCHIVE_BASE_GHOUL_1_NAME='cultist_simulator_the_ghoul_2022_3_p_1_54545.sh'
ARCHIVE_BASE_GHOUL_1_MD5='c04cd53c229a5cb2d243a6c00e4e6847'
ARCHIVE_BASE_GHOUL_1_SIZE='1600'
ARCHIVE_BASE_GHOUL_1_VERSION='2022.03.p.1-gog54545'

ARCHIVE_BASE_GHOUL_0_NAME='cultist_simulator_the_ghoul_2022_3_n_1_54418.sh'
ARCHIVE_BASE_GHOUL_0_MD5='d1b72e87563e87df340570dd91ec44a2'
ARCHIVE_BASE_GHOUL_0_SIZE='1600'
ARCHIVE_BASE_GHOUL_0_VERSION='2022.03.n.1-gog54418'

## The Priest

ARCHIVE_BASE_PRIEST_7_NAME='cultist_simulator_the_priest_2023_12_s_5_71509.sh'
ARCHIVE_BASE_PRIEST_7_MD5='0b5d5436b8853cfc3a100404070779c8'
ARCHIVE_BASE_PRIEST_7_SIZE='1238'
ARCHIVE_BASE_PRIEST_7_VERSION='2023.12.s.5-gog71509'
ARCHIVE_BASE_PRIEST_7_URL='https://www.gog.com/game/cultist_simulator_the_priest'

ARCHIVE_BASE_PRIEST_6_NAME='cultist_simulator_the_priest_2023_12_s_4_71175.sh'
ARCHIVE_BASE_PRIEST_6_MD5='84f26baca8a0219e3b11f6f91fca3bb9'
ARCHIVE_BASE_PRIEST_6_SIZE='1238'
ARCHIVE_BASE_PRIEST_6_VERSION='2023.12.s.4-gog71175'

ARCHIVE_BASE_PRIEST_5_NAME='cultist_simulator_the_priest_2023_10_r_10_68985.sh'
ARCHIVE_BASE_PRIEST_5_MD5='98051cfd374e9165e59377fbac3a3c35'
ARCHIVE_BASE_PRIEST_5_SIZE='1668'
ARCHIVE_BASE_PRIEST_5_VERSION='2023.10.r.10-gog68985'

ARCHIVE_BASE_PRIEST_4_NAME='cultist_simulator_the_priest_2023_5_p_12_67501.sh'
ARCHIVE_BASE_PRIEST_4_MD5='c6e17f6d95cf866bcd91fff881216ca8'
ARCHIVE_BASE_PRIEST_4_SIZE='1668'
ARCHIVE_BASE_PRIEST_4_VERSION='2023.05.p.12-gog67501'

ARCHIVE_BASE_PRIEST_3_NAME='cultist_simulator_the_priest_2023_4_o_4_64959.sh'
ARCHIVE_BASE_PRIEST_3_MD5='fd1b784c35b7d1acadeebb5f6da8ea68'
ARCHIVE_BASE_PRIEST_3_SIZE='1700'
ARCHIVE_BASE_PRIEST_3_VERSION='2023.04.o.4-gog64959'

ARCHIVE_BASE_PRIEST_2_NAME='cultist_simulator_the_priest_2022_12_n_2_61763.sh'
ARCHIVE_BASE_PRIEST_2_MD5='1f12513a9b61863ced08ebe7ff3f2001'
ARCHIVE_BASE_PRIEST_2_SIZE='1700'
ARCHIVE_BASE_PRIEST_2_VERSION='2022.12.n.2-gog61763'

ARCHIVE_BASE_PRIEST_1_NAME='cultist_simulator_the_priest_2022_3_p_1_54545.sh'
ARCHIVE_BASE_PRIEST_1_MD5='e56271d1fd1e2eca197d4bef956965c9'
ARCHIVE_BASE_PRIEST_1_SIZE='1700'
ARCHIVE_BASE_PRIEST_1_VERSION='2022.03.p.1-gog54545'

ARCHIVE_BASE_PRIEST_0_NAME='cultist_simulator_the_priest_2022_3_n_1_54418.sh'
ARCHIVE_BASE_PRIEST_0_MD5='26516af73ab47d8aa161a6e2ad99eb5f'
ARCHIVE_BASE_PRIEST_0_SIZE='1700'
ARCHIVE_BASE_PRIEST_0_VERSION='2022.03.n.1-gog54418'

## The Exile

ARCHIVE_BASE_EXILE_7_NAME='cultist_simulator_the_exile_2023_12_s_5_71509.sh'
ARCHIVE_BASE_EXILE_7_MD5='b8ec4b2021be5b82b4d1bea8f85e2275'
ARCHIVE_BASE_EXILE_7_SIZE='5482'
ARCHIVE_BASE_EXILE_7_VERSION='2023.12.s.5-gog71509'
ARCHIVE_BASE_EXILE_7_URL='https://www.gog.com/game/cultist_simulator_the_exile'

ARCHIVE_BASE_EXILE_6_NAME='cultist_simulator_the_exile_2023_12_s_4_71175.sh'
ARCHIVE_BASE_EXILE_6_MD5='4848d25ba494b3ce05199c14b3fb7cdb'
ARCHIVE_BASE_EXILE_6_SIZE='5482'
ARCHIVE_BASE_EXILE_6_VERSION='2023.12.s.4-gog71175'

ARCHIVE_BASE_EXILE_5_NAME='cultist_simulator_the_exile_2023_10_r_10_68985.sh'
ARCHIVE_BASE_EXILE_5_MD5='127f09acc54cce367ce7e167468ed229'
ARCHIVE_BASE_EXILE_5_SIZE='6088'
ARCHIVE_BASE_EXILE_5_VERSION='2023.10.r.10-gog68985'

ARCHIVE_BASE_EXILE_4_NAME='cultist_simulator_the_exile_2023_5_p_12_67501.sh'
ARCHIVE_BASE_EXILE_4_MD5='0ed4869ccb55e3e7b5afa9ade6a654a9'
ARCHIVE_BASE_EXILE_4_SIZE='6088'
ARCHIVE_BASE_EXILE_4_VERSION='2023.05.p.12-gog67501'

ARCHIVE_BASE_EXILE_3_NAME='cultist_simulator_the_exile_2023_4_o_4_64959.sh'
ARCHIVE_BASE_EXILE_3_MD5='c25a0b322398181606826e8e91946ed8'
ARCHIVE_BASE_EXILE_3_SIZE='6100'
ARCHIVE_BASE_EXILE_3_VERSION='2023.04.o.4-gog64959'

ARCHIVE_BASE_EXILE_2_NAME='cultist_simulator_the_exile_2022_12_n_2_61763.sh'
ARCHIVE_BASE_EXILE_2_MD5='97f7192f414ebc9c456f14485bcfdc9c'
ARCHIVE_BASE_EXILE_2_SIZE='6100'
ARCHIVE_BASE_EXILE_2_VERSION='2022.12.n.2-gog61763'

ARCHIVE_BASE_EXILE_1_NAME='cultist_simulator_the_exile_2022_3_p_1_54545.sh'
ARCHIVE_BASE_EXILE_1_MD5='ad7232336e7aefd959a57fd2c3c7243b'
ARCHIVE_BASE_EXILE_1_SIZE='6100'
ARCHIVE_BASE_EXILE_1_VERSION='2022.03.p.1-gog54545'

ARCHIVE_BASE_EXILE_0_NAME='cultist_simulator_the_exile_2022_3_n_1_54418.sh'
ARCHIVE_BASE_EXILE_0_MD5='3bf084c13791a61820aaf49650dd2a32'
ARCHIVE_BASE_EXILE_0_SIZE='6100'
ARCHIVE_BASE_EXILE_0_VERSION='2022.03.n.1-gog54418'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
CS_Data'

PKG_MAIN_DEPS="$GAME_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
