#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2015 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Startopia
###

script_version=20230925.1

PLAYIT_COMPATIBILITY_LEVEL='2.26'

GAME_ID='startopia'
GAME_NAME='Startopia'

ARCHIVE_BASE_0_NAME='setup_startopia_2.0.0.17.exe'
ARCHIVE_BASE_0_MD5='4fe8d194afc1012e136ed3e82f1de171'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='600000'
ARCHIVE_BASE_0_VERSION='1.01b-gog2.0.0.17'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/startopia'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
binkw32.dll
startopia.exe
startopia.ini'
CONTENT_GAME_DATA_FILES='
cardid.tom
data
intro
languageinis
missions
startopia.jpg
text'
CONTENT_DOC_DATA_FILES='
eula
weblinks
*.html
*.pdf
*.rtf
*.txt'

USER_PERSISTENT_DIRECTORIES='
profiles'
USER_PERSISTENT_FILES='
startopia.ini'

APP_MAIN_EXE='startopia.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

## FIXME: This game can get display issues on some resolutions, when run on Wayland without using a virtual desktop.

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Generate minimal configuration file
	config_file='startopia.ini'
	game_path="C:\\$(game_id)"
	intro_path="${game_path}\\intro\\"
	drive_path_music="${game_path}\\data\\"
	drive_path_sound="${game_path}\\data\\"
	drive_path_voice="${game_path}\\data\\"
	cat > "$config_file" <<- EOF
	[Intro]
	IntroPath=$intro_path
	[Sound]
	DrivePathMusic=$drive_path_music
	DrivePathSound=$drive_path_sound
	SoundPathVoice=$drive_path_voice
	EOF
)

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
