#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Empire Earth 1
# send your bug reports to contact@dotslashplay.it
###

script_version=20240506.1

PLAYIT_COMPATIBILITY_LEVEL='2.28'

GAME_ID='empire-earth-1'
GAME_NAME='Empire Earth'

EXPANSION_ID='the-art-of-conquest'
EXPANSION_NAME='The Art of Conquest'

ARCHIVE_BASE_0_NAME='setup_empire_earth_gold_2.0.0.2974_(25522).exe'
ARCHIVE_BASE_0_MD5='e8b22cdc9520aefab49e21349b20b731'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='710000'
ARCHIVE_BASE_0_VERSION='2.0.0-gog25522'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/empire_earth_gold_edition'

# Archive content

CONTENT_PATH_DEFAULT='.'

## Empire Earth - base game

CONTENT_GAME_BIN_PATH="${CONTENT_PATH_DEFAULT}/empire earth"
CONTENT_GAME_BIN_FILES='
redist
*.cfg
*.dll
*.exe
*.inf'
CONTENT_GAME_DATA_PATH="${CONTENT_PATH_DEFAULT}/empire earth"
CONTENT_GAME_DATA_FILES='
data'
CONTENT_DOC_DATA_FILES='
manual.pdf
scenario_editor_manual.pdf
technology_tree.pdf'

## The Art of Conquest expansion

CONTENT_GAME_BIN_EXPANSION_PATH="${CONTENT_PATH_DEFAULT}/empire earth - the art of conquest"
CONTENT_GAME_BIN_EXPANSION_FILES='
redist
*.cfg
*.dll
*.exe
*.inf'
CONTENT_GAME_DATA_EXPANSION_PATH="${CONTENT_PATH_DEFAULT}/empire earth - the art of conquest"
CONTENT_GAME_DATA_EXPANSION_FILES='
data'
CONTENT_DOC_DATA_EXPANSION_FILES='
technology_tree_aoc.pdf
manual_aoc.pdf'

# Applications

## Empire Earth - base game

APP_MAIN_EXE='empire earth.exe'
APP_MAIN_ICON='empire earth/empire earth.exe'
### Run the game binary from its parent directory
APP_MAIN_PRERUN='# Run the game binary from its parent directory
cd "$(dirname "$APP_EXE")"
APP_EXE=$(basename "$APP_EXE")'

USER_PERSISTENT_DIRECTORIES="
${GAME_ID}/data/Scenarios
${GAME_ID}/data/Saved Games
${GAME_ID}/Users"

## The Art of Conquest expansion

APP_EXPANSION_ID="${GAME_ID}-${EXPANSION_ID}"
APP_EXPANSION_NAME="$GAME_NAME - $EXPANSION_NAME"
APP_EXPANSION_EXE='ee-aoc.exe'
APP_EXPANSION_ICON='empire earth - the art of conquest/ee-aoc.exe'
### Run the game binary from its parent directory
APP_EXPANSION_PRERUN='# Run the game binary from its parent directory
cd "$(dirname "$APP_EXE")"
APP_EXE=$(basename "$APP_EXE")'

USER_PERSISTENT_DIRECTORIES="$USER_PERSISTENT_DIRECTORIES
${EXPANSION_ID}/data/Scenarios
${EXPANSION_ID}/data/Saved Games
${EXPANSION_ID}/Users"

# Packages

PACKAGES_LIST='
PKG_BIN
PKG_DATA
PKG_BIN_EXPANSION
PKG_DATA_EXPANSION'

## Empire Earth - base game

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ID="$GAME_ID"
PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

## The Art of Conquest expansion

PKG_DATA_EXPANSION_ID="${GAME_ID}-${EXPANSION_ID}-data"
PKG_DATA_EXPANSION_DESCRIPTION="$EXPANSION_NAME - data"

PKG_BIN_EXPANSION_ID="${GAME_ID}-${EXPANSION_ID}"
PKG_BIN_EXPANSION_ARCH='32'
PKG_BIN_EXPANSION_DESCRIPTION="$EXPANSION_NAME"
PKG_BIN_EXPANSION_DEPS="$PKG_DATA_EXPANSION_ID $PKG_BIN_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA' 'APP_MAIN'
content_inclusion_icons 'PKG_DATA_EXPANSION' 'APP_EXPANSION'
content_inclusion 'GAME_BIN'  'PKG_BIN'  "$(path_game_data)/$(game_id)"
content_inclusion 'GAME_DATA' 'PKG_DATA' "$(path_game_data)/$(game_id)"
content_inclusion 'DOC_DATA'  'PKG_DATA' "$(path_documentation)/$(game_id)"
content_inclusion 'GAME_BIN_EXPANSION'  'PKG_BIN_EXPANSION'  "$(path_game_data)/$(expansion_id)"
content_inclusion 'GAME_DATA_EXPANSION' 'PKG_DATA_EXPANSION' "$(path_game_data)/$(expansion_id)"
content_inclusion 'DOC_DATA_EXPANSION'  'PKG_DATA_EXPANSION' "$(path_documentation)/$(expansion_id)"
rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

APP_MAIN_EXE="$(game_id)/$(application_exe 'APP_MAIN')"
launchers_generation 'PKG_BIN' 'APP_MAIN'
APP_EXPANSION_EXE="$(expansion_id)/$(application_exe 'APP_EXPANSION')"
launchers_generation 'PKG_BIN_EXPANSION' 'APP_EXPANSION'

# Build package

packages_generation
(
	## Ignore the expansion name for the base game.
	unset EXPANSION_NAME
	print_instructions 'PKG_BIN' 'PKG_DATA'
)
print_instructions 'PKG_BIN_EXPANSION' 'PKG_DATA_EXPANSION'

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
