#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Emmanuel Gil Peyrot <linkmauve@linkmauve.fr>
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# TrackMania Nations Forever
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20230618.2

GAME_ID='trackmania-nations-forever'
GAME_NAME='TrackMania Nations Forever'

ARCHIVE_BASE_0='tmnationsforever_setup.exe'
ARCHIVE_BASE_0_MD5='2a36d70989f94ba9369993749ff20640'
ARCHIVE_BASE_0_EXTRACTOR='bsdtar'
ARCHIVE_BASE_0_SIZE='520000'
ARCHIVE_BASE_0_VERSION='2.11.26-1'
ARCHIVE_BASE_0_URL='https://trackmaniaforever.com/nations/'

CONTENT_PATH_DEFAULT='app'
ARCHIVE_GAME_BIN_FILES='
binkw32.dll
openal32.dll
thumbgbx.dll
thumbgbx.tlb
tmforever.exe
tmforeverlauncher.exe
wrap_oal.dll'
ARCHIVE_GAME_DATA_FILES='
gamedata
packs
tmforever.map
gbx.ico
launchicon.png
nadeo.ini'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='tmforeverlauncher.exe'
APP_MAIN_ICON='launchicon.png'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine libGL.so.1"

# Store game progress and configuration in persistent paths

APP_WINE_LINK_DIRS="$APP_WINE_LINK_DIRS"'
userdata:users/${USER}/My Documents/TmForever'
DATA_DIRS="$DATA_DIRS ./userdata"

# innoextract is required to extract the content of an inner archive

SCRIPT_DEPS="$SCRIPT_DEPS innoextract"

# Load common functions

target_version='2.17'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Use DXVK for Direct3D 9/10/11 rendering

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# Use DXVK for Direct3D 9/10/11 rendering
if [ ! -e dxvk_installed ]; then
	# Wait until the WINE prefix creation is complete
	printf "Waiting for the WINE prefix initialization to complete, it might take a couple seconds…\\n"
	while [ ! -f "${WINEPREFIX}/system.reg" ]; do
		sleep 1s
	done

	if \
		command -v dxvk-setup >/dev/null 2>&1 && \
		command -v wine-development >/dev/null 2>&1
	then
		dxvk-setup install --development
		touch dxvk_installed
	elif command -v winetricks >/dev/null 2>&1; then
		winetricks dxvk
		touch dxvk_installed
	else
		message="\\033[1;33mWarning:\\033[0m\\n"
		message="${message}DXVK patches could not be installed in the WINE prefix.\\n"
		message="${message}The game might run with display or performance issues.\\n"
		printf "\\n${message}\\n"
	fi

	# Wait a bit to ensure there is no lingering wine process
	sleep 1s
fi'
case "$OPTION_PACKAGE" in
	('deb')
		# Debian-based distributions should use repositories-provided dxvk
		# winetricks is used as a fallback for branches not having access to dxvk-setup
		extra_dependencies='mesa-vulkan-drivers | vulkan-icd, dxvk-wine32-development | winetricks, dxvk | winetricks'
		if [ -n "$PKG_BIN_DEPS_DEB" ]; then
			PKG_BIN_DEPS_DEB="${PKG_BIN_DEPS_DEB}, ${extra_dependencies}"
		else
			PKG_BIN_DEPS_DEB="$extra_dependencies"
		fi
	;;
	(*)
		# Default is to use winetricks
		PKG_BIN_DEPS="$PKG_BIN_DEPS winetricks"
	;;
esac

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
ARCHIVE_INNER="${PLAYIT_WORKDIR}/gamedata/TmNationsForever_Setup_Tmp.exe"
ARCHIVE_INNER_TYPE='innosetup'
archive_extraction 'ARCHIVE_INNER'
rm "$ARCHIVE_INNER"

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
