#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Sagebrush
# send your bug reports to contact@dotslashplay.it
###

script_version=20230415.1

GAME_ID='sagebrush'
GAME_NAME='Sagebrush'

ARCHIVE_BASE_0='sagebrush-windows-universal.zip'
ARCHIVE_BASE_0_MD5='0af5ff01fdb4216f81b443a11c997ee1'
ARCHIVE_BASE_0_SIZE='380000'
ARCHIVE_BASE_0_VERSION='1.41b-itch1'
ARCHIVE_BASE_0_URL='https://redactgames.itch.io/sagebrush'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
Sagebrush.exe
Sagebrush_Data/Plugins
Sagebrush_Data/Managed
Sagebrush_Data/Mono
UnityPlayer.dll'
CONTENT_GAME_DATA_FILES='
Sagebrush_Data'

APP_WINE_LINK_DIRS='
userdata:users/${USER}/AppData/LocalLow/Redact Games/Sagebrush'
USER_PERSISTENT_FILES='
userdata'

APP_MAIN_EXE='Sagebrush.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Set up a WINE virtual desktop on first launch, using the current desktop resolution

PKG_BIN_DEPS="$PKG_BIN_DEPS xrandr sed"
sed_expression='s/.*primary.* ([0-9]+x[0-9]+).*/\1/p'
sed_options="--regexp-extended --silent --expression='$sed_expression'"
APP_WINETRICKS="$APP_WINETRICKS vd=\$(LANG=C xrandr | sed $sed_options)"

# Load common functions

target_version='2.22'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"
	set_standard_permissions .
)

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
