#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Catie in MeowmeowLand
# send your bug reports to contact@dotslashplay.it
###

script_version=20221231.1

GAME_ID='catie-in-meowmeowland'
GAME_NAME='Catie in MeowMeowLand'

UNITY3D_NAME='CatieinMeowmeowLand'

ARCHIVE_BASE_0='catie_in_meowmeowland_0_1_0_3_1e54c009_55446.sh'
ARCHIVE_BASE_0_MD5='d897acf6e88697b317c561c41582f41d'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='1800000'
ARCHIVE_BASE_0_VERSION='0.1.0.3-gog55446'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/catie_in_meowmeowland'

CONTENT_PATH_DEFAULT='data/noarch/game/CatieinMeowmeowLand_v0.1.0.3_1e54c009'
CONTENT_GAME_BIN_FILES="
${UNITY3D_NAME}_Data/Plugins
${UNITY3D_NAME}.x86_64
GameAssembly.so
UnityPlayer.so"
CONTENT_GAME_DATA_FILES="
${UNITY3D_NAME}_Data
CatieinMeowmeowLand/bfsBuildData.json"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
ld-linux-x86-64.so.2
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1'

# Load common functions

target_version='2.20'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
