#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Liar Liar 2
# send your bug reports to contact@dotslashplay.it
###

script_version=20230425.1

GAME_ID='liar-liar-2'
GAME_NAME='Liar Liar 2: Pants on Fire'

ARCHIVE_BASE_0='liarliar2-all.zip'
ARCHIVE_BASE_0_MD5='6450f265d59ece46331070a2e0a14121'
ARCHIVE_BASE_0_SIZE='110000'
ARCHIVE_BASE_0_VERSION='1.0-itch'
ARCHIVE_BASE_0_URL='https://tokimekiwaku.itch.io/liar-liar-2'

RENPY_NAME='liar liar 2'

CONTENT_PATH_DEFAULT='liarliar2-all'
CONTENT_LIBS_BIN_PATH="${CONTENT_PATH_DEFAULT}/lib/linux-x86_64"
CONTENT_LIBS_BIN_FILES='
libavcodec.so.54
libavformat.so.54
libavresample.so.1
libavutil.so.52
libGLEW.so.1.7
libpng12.so.0
libpython2.7.so.1.0
libswscale.so.2'
CONTENT_GAME_BIN_FILES="
lib/linux-x86_64/lib/python2.7
lib/linux-x86_64/python
lib/linux-x86_64/pythonw
lib/linux-x86_64/zsync
lib/linux-x86_64/zsyncmake
lib/linux-x86_64/${RENPY_NAME}"
CONTENT_GAME_DATA_FILES="
game
renpy
lib/pythonlib2.7
${RENPY_NAME}.py"
CONTENT_DOC_DATA_FILES='
README.html'

APP_MAIN_EXE="lib/linux-x86_64/${RENPY_NAME}"
APP_MAIN_OPTIONS='-EO *.py'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libfreetype.so.6
libGL.so.1
libGLU.so.1
libjpeg.so.62
libm.so.6
libpthread.so.0
librt.so.1
libSDL-1.2.so.0
libSDL_image-1.2.so.0
libSDL_ttf-2.0.so.0
libutil.so.1
libX11.so.6
libXext.so.6
libXi.so.6
libXmu.so.6
libz.so.1'

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Use default Ren'Py icon if it is available

launcher_desktop() {
	local application
	application="$1"

	local application_name application_icon application_category launcher_desktop_exec
	application_name=$(application_name "$application")
	application_category=$(application_category "$application")
	launcher_desktop_exec=$(launcher_desktop_exec "$application")

	cat <<- EOF
	[Desktop Entry]
	Version=1.0
	Type=Application
	Name=$application_name
	Icon=renpy
	$launcher_desktop_exec
	Categories=$application_category
	EOF
}

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
