/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_BOOTLOGICALIDENTITY_H_
#define OPENDRIM_BOOTLOGICALIDENTITY_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_ManagedElement.h"
#include "CIM_ManagedElementAccess.h"
#include "cmpiCIM_ManagedElement.h"
#include "CIM_ManagedElementAccess.h"
*/

const static char* OpenDRIM_BootLogicalIdentity_classnames[] = {"OpenDRIM_BootLogicalIdentity"};
static string OpenDRIM_BootLogicalIdentity_NAMESPACE = _NAMESPACE;
const static string SystemElement_role = "SystemElement";
const static char* SystemElement_classnames[] = {"OpenDRIM_BootSourceSetting"};
const static string SystemElement_NAMESPACE = _NAMESPACE;

const static string SameElement_role = "SameElement";
const static char* SameElement_classnames[] = {"OpenDRIM_BootConfigSetting"};
const static string SameElement_NAMESPACE = _NAMESPACE;

class OpenDRIM_BootLogicalIdentity {

public:
	
	Objectpath SystemElement;
	bool SystemElement_isNULL;
	
	Objectpath SameElement;
	bool SameElement_isNULL;
	
	OpenDRIM_BootLogicalIdentity() {
		SystemElement_isNULL = true;
		SameElement_isNULL = true;
	}
	
	~OpenDRIM_BootLogicalIdentity() {}
	
	string getKeys() const {
		return CF_toLowCase(".SystemElement=\"" + CF_quoteString(SystemElement.toString()) + "\""".SameElement=\"" + CF_quoteString(SameElement.toString()) + "\"");
	}

	int getSystemElement(Objectpath& value) const {
		if (SystemElement_isNULL==true)
			return NOT_FOUND;
		value = SystemElement;
		return OK;
	}
	
	int setSystemElement(const Objectpath& newValue) {
		SystemElement = newValue;
		SystemElement.setNamespace(SystemElement_NAMESPACE);
		SystemElement_isNULL = false;
		return OK;
	}

	int getSameElement(Objectpath& value) const {
		if (SameElement_isNULL==true)
			return NOT_FOUND;
		value = SameElement;
		return OK;
	}
	
	int setSameElement(const Objectpath& newValue) {
		SameElement = newValue;
		SameElement.setNamespace(SameElement_NAMESPACE);
		SameElement_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_BOOTLOGICALIDENTITY_H_*/
