/*###############################################################################
# Linux Management Providers (LMP), Battery provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef CMPIOPENDRIM_BATTERY_H_
#define CMPIOPENDRIM_BATTERY_H_

#include "OpenDRIM_Battery.h"

CMPIObjectPath* Battery_OpenDRIM_Battery_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_Battery& instance);

CMPIInstance* Battery_OpenDRIM_Battery_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_Battery& instance);

void Battery_OpenDRIM_Battery_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_Battery& instance);

void Battery_OpenDRIM_Battery_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_Battery& instance);

void Battery_OpenDRIM_Battery_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Battery_RequestStateChange_In& args);

void Battery_OpenDRIM_Battery_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_Battery_RequestStateChange_Out& args);

void Battery_OpenDRIM_Battery_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Battery_SetPowerState_In& args);

void Battery_OpenDRIM_Battery_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Battery_EnableDevice_In& args);

void Battery_OpenDRIM_Battery_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Battery_OnlineDevice_In& args);

void Battery_OpenDRIM_Battery_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Battery_QuiesceDevice_In& args);


#endif /*CMPIOPENDRIM_BATTERY_H_*/
