/*
 * Copyright 2003-2007 Keith Seymour.
 * Copyright 1992-2007 The University of Tennessee. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * 
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer listed
 *   in this license in the documentation and/or other materials
 *   provided with the distribution.
 * 
 * - Neither the name of the copyright holders nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * This file was auto-generated by the org.netlib.generate.JavaGenerator
 * program, a part of netlib-java.
 * 
 * @see http://code.google.com/p/netlib-java/
 */

#include "f2j_jni.h"
#include "org_netlib_lapack_NativeLAPACK.h"

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dbdsdc (JNIEnv * env, jobject calling_obj, jstring uplo, jstring compq, jint n, jdoubleArray d, jdoubleArray e, jdoubleArray u, jint ldu, jdoubleArray vt, jint ldvt, jdoubleArray q, jintArray iq, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jdouble * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jint * jni_iq = (*env)->GetPrimitiveArrayCritical(env, iq, JNI_FALSE);
	check_memory(env, jni_iq);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dbdsdc_(jni_uplo, jni_compq, &n, jni_d, jni_e, jni_u, &ldu, jni_vt, &ldvt, jni_q, jni_iq, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, compq, jni_compq);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iq, jni_iq, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dbdsqr (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint ncvt, jint nru, jint ncc, jdoubleArray d, jdoubleArray e, jdoubleArray vt, jint ldvt, jdoubleArray u, jint ldu, jdoubleArray c, jint Ldc, jdoubleArray work, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jdouble * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dbdsqr_(jni_uplo, &n, &ncvt, &nru, &ncc, jni_d, jni_e, jni_vt, &ldvt, jni_u, &ldu, jni_c, &Ldc, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ddisna (JNIEnv * env, jobject calling_obj, jstring job, jint m, jint n, jdoubleArray d, jdoubleArray sep, jobject info){
	char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_sep = (*env)->GetPrimitiveArrayCritical(env, sep, JNI_FALSE);
	check_memory(env, jni_sep);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ddisna_(jni_job, &m, &n, jni_d, jni_sep, &jni_info);

	(*env)->ReleaseStringUTFChars(env, job, jni_job);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, sep, jni_sep, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgbbrd (JNIEnv * env, jobject calling_obj, jstring vect, jint m, jint n, jint ncc, jint kl, jint ku, jdoubleArray ab, jint ldab, jdoubleArray d, jdoubleArray e, jdoubleArray q, jint ldq, jdoubleArray pt, jint ldpt, jdoubleArray c, jint Ldc, jdoubleArray work, jobject info){
	char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jdouble * jni_pt = (*env)->GetPrimitiveArrayCritical(env, pt, JNI_FALSE);
	check_memory(env, jni_pt);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgbbrd_(jni_vect, &m, &n, &ncc, &kl, &ku, jni_ab, &ldab, jni_d, jni_e, jni_q, &ldq, jni_pt, &ldpt, jni_c, &Ldc, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, vect, jni_vect);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, pt, jni_pt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgbcon (JNIEnv * env, jobject calling_obj, jstring norm, jint n, jint kl, jint ku, jdoubleArray ab, jint ldab, jintArray ipiv, jdouble anorm, jobject rcond, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgbcon_(jni_norm, &n, &kl, &ku, jni_ab, &ldab, jni_ipiv, &anorm, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, norm, jni_norm);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgbequ (JNIEnv * env, jobject calling_obj, jint m, jint n, jint kl, jint ku, jdoubleArray ab, jint ldab, jdoubleArray r, jdoubleArray c, jobject rowcnd, jobject colcnd, jobject amax, jobject info){
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
	check_memory(env, jni_r);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jclass jni_rowcndClass = (*env)->GetObjectClass(env, rowcnd);
	jfieldID jni_rowcndId = (*env)->GetFieldID(env, jni_rowcndClass, "val", "D");
	jdouble jni_rowcnd = (*env)->GetDoubleField(env, rowcnd, jni_rowcndId);
	jclass jni_colcndClass = (*env)->GetObjectClass(env, colcnd);
	jfieldID jni_colcndId = (*env)->GetFieldID(env, jni_colcndClass, "val", "D");
	jdouble jni_colcnd = (*env)->GetDoubleField(env, colcnd, jni_colcndId);
	jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
	jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "D");
	jdouble jni_amax = (*env)->GetDoubleField(env, amax, jni_amaxId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgbequ_(&m, &n, &kl, &ku, jni_ab, &ldab, jni_r, jni_c, &jni_rowcnd, &jni_colcnd, &jni_amax, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->SetDoubleField(env, rowcnd, jni_rowcndId, jni_rowcnd);
	(*env)->SetDoubleField(env, colcnd, jni_colcndId, jni_colcnd);
	(*env)->SetDoubleField(env, amax, jni_amaxId, jni_amax);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgbrfs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint kl, jint ku, jint nrhs, jdoubleArray ab, jint ldab, jdoubleArray afb, jint ldafb, jintArray ipiv, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_afb = (*env)->GetPrimitiveArrayCritical(env, afb, JNI_FALSE);
	check_memory(env, jni_afb);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgbrfs_(jni_trans, &n, &kl, &ku, &nrhs, jni_ab, &ldab, jni_afb, &ldafb, jni_ipiv, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, afb, jni_afb, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgbsv (JNIEnv * env, jobject calling_obj, jint n, jint kl, jint ku, jint nrhs, jdoubleArray ab, jint ldab, jintArray ipiv, jdoubleArray b, jint ldb, jobject info){
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgbsv_(&n, &kl, &ku, &nrhs, jni_ab, &ldab, jni_ipiv, jni_b, &ldb, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgbsvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring trans, jint n, jint kl, jint ku, jint nrhs, jdoubleArray ab, jint ldab, jdoubleArray afb, jint ldafb, jintArray ipiv, jobject equed, jdoubleArray r, jdoubleArray c, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jobject rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_afb = (*env)->GetPrimitiveArrayCritical(env, afb, JNI_FALSE);
	check_memory(env, jni_afb);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
	jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
	jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
	char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
	jdouble * jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
	check_memory(env, jni_r);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgbsvx_(jni_fact, jni_trans, &n, &kl, &ku, &nrhs, jni_ab, &ldab, jni_afb, &ldafb, jni_ipiv, jni_equed, jni_r, jni_c, jni_b, &ldb, jni_x, &ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, fact, jni_fact);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, afb, jni_afb, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	jstring jni_equedStringNew = (*env)->NewStringUTF(env, jni_equed);
	(*env)->SetObjectField(env, equed, jni_equedId, jni_equedStringNew);
	(*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgbtf2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jint kl, jint ku, jdoubleArray ab, jint ldab, jintArray ipiv, jobject info){
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgbtf2_(&m, &n, &kl, &ku, jni_ab, &ldab, jni_ipiv, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgbtrf (JNIEnv * env, jobject calling_obj, jint m, jint n, jint kl, jint ku, jdoubleArray ab, jint ldab, jintArray ipiv, jobject info){
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgbtrf_(&m, &n, &kl, &ku, jni_ab, &ldab, jni_ipiv, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgbtrs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint kl, jint ku, jint nrhs, jdoubleArray ab, jint ldab, jintArray ipiv, jdoubleArray b, jint ldb, jobject info){
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgbtrs_(jni_trans, &n, &kl, &ku, &nrhs, jni_ab, &ldab, jni_ipiv, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgebak (JNIEnv * env, jobject calling_obj, jstring job, jstring side, jint n, jint ilo, jint ihi, jdoubleArray scale, jint m, jdoubleArray v, jint ldv, jobject info){
	char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	jdouble * jni_scale = (*env)->GetPrimitiveArrayCritical(env, scale, JNI_FALSE);
	check_memory(env, jni_scale);
	jdouble * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgebak_(jni_job, jni_side, &n, &ilo, &ihi, jni_scale, &m, jni_v, &ldv, &jni_info);

	(*env)->ReleaseStringUTFChars(env, job, jni_job);
	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleasePrimitiveArrayCritical(env, scale, jni_scale, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgebal (JNIEnv * env, jobject calling_obj, jstring job, jint n, jdoubleArray a, jint lda, jobject ilo, jobject ihi, jdoubleArray scale, jobject info){
	char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
	jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
	jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
	jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
	jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
	jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
	jdouble * jni_scale = (*env)->GetPrimitiveArrayCritical(env, scale, JNI_FALSE);
	check_memory(env, jni_scale);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgebal_(jni_job, &n, jni_a, &lda, &jni_ilo, &jni_ihi, jni_scale, &jni_info);

	(*env)->ReleaseStringUTFChars(env, job, jni_job);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
	(*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
	(*env)->ReleasePrimitiveArrayCritical(env, scale, jni_scale, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgebd2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray d, jdoubleArray e, jdoubleArray tauq, jdoubleArray taup, jdoubleArray work, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_tauq = (*env)->GetPrimitiveArrayCritical(env, tauq, JNI_FALSE);
	check_memory(env, jni_tauq);
	jdouble * jni_taup = (*env)->GetPrimitiveArrayCritical(env, taup, JNI_FALSE);
	check_memory(env, jni_taup);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgebd2_(&m, &n, jni_a, &lda, jni_d, jni_e, jni_tauq, jni_taup, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tauq, jni_tauq, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, taup, jni_taup, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgebrd (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray d, jdoubleArray e, jdoubleArray tauq, jdoubleArray taup, jdoubleArray work, jint lwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_tauq = (*env)->GetPrimitiveArrayCritical(env, tauq, JNI_FALSE);
	check_memory(env, jni_tauq);
	jdouble * jni_taup = (*env)->GetPrimitiveArrayCritical(env, taup, JNI_FALSE);
	check_memory(env, jni_taup);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgebrd_(&m, &n, jni_a, &lda, jni_d, jni_e, jni_tauq, jni_taup, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tauq, jni_tauq, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, taup, jni_taup, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgecon (JNIEnv * env, jobject calling_obj, jstring norm, jint n, jdoubleArray a, jint lda, jdouble anorm, jobject rcond, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgecon_(jni_norm, &n, jni_a, &lda, &anorm, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, norm, jni_norm);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgeequ (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray r, jdoubleArray c, jobject rowcnd, jobject colcnd, jobject amax, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
	check_memory(env, jni_r);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jclass jni_rowcndClass = (*env)->GetObjectClass(env, rowcnd);
	jfieldID jni_rowcndId = (*env)->GetFieldID(env, jni_rowcndClass, "val", "D");
	jdouble jni_rowcnd = (*env)->GetDoubleField(env, rowcnd, jni_rowcndId);
	jclass jni_colcndClass = (*env)->GetObjectClass(env, colcnd);
	jfieldID jni_colcndId = (*env)->GetFieldID(env, jni_colcndClass, "val", "D");
	jdouble jni_colcnd = (*env)->GetDoubleField(env, colcnd, jni_colcndId);
	jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
	jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "D");
	jdouble jni_amax = (*env)->GetDoubleField(env, amax, jni_amaxId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgeequ_(&m, &n, jni_a, &lda, jni_r, jni_c, &jni_rowcnd, &jni_colcnd, &jni_amax, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->SetDoubleField(env, rowcnd, jni_rowcndId, jni_rowcnd);
	(*env)->SetDoubleField(env, colcnd, jni_colcndId, jni_colcnd);
	(*env)->SetDoubleField(env, amax, jni_amaxId, jni_amax);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgeev (JNIEnv * env, jobject calling_obj, jstring jobvl, jstring jobvr, jint n, jdoubleArray a, jint lda, jdoubleArray wr, jdoubleArray wi, jdoubleArray vl, jint ldvl, jdoubleArray vr, jint ldvr, jdoubleArray work, jint lwork, jobject info){
	char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
	char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
	check_memory(env, jni_wr);
	jdouble * jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
	check_memory(env, jni_wi);
	jdouble * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jdouble * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgeev_(jni_jobvl, jni_jobvr, &n, jni_a, &lda, jni_wr, jni_wi, jni_vl, &ldvl, jni_vr, &ldvr, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
	(*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgeevx (JNIEnv * env, jobject calling_obj, jstring balanc, jstring jobvl, jstring jobvr, jstring sense, jint n, jdoubleArray a, jint lda, jdoubleArray wr, jdoubleArray wi, jdoubleArray vl, jint ldvl, jdoubleArray vr, jint ldvr, jobject ilo, jobject ihi, jdoubleArray scale, jobject abnrm, jdoubleArray rconde, jdoubleArray rcondv, jdoubleArray work, jint lwork, jintArray iwork, jobject info){
	char * jni_balanc = (char *)(*env)->GetStringUTFChars(env, balanc, JNI_FALSE);
	char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
	char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
	char * jni_sense = (char *)(*env)->GetStringUTFChars(env, sense, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
	check_memory(env, jni_wr);
	jdouble * jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
	check_memory(env, jni_wi);
	jdouble * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jdouble * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
	jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
	jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
	jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
	jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
	jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
	jdouble * jni_scale = (*env)->GetPrimitiveArrayCritical(env, scale, JNI_FALSE);
	check_memory(env, jni_scale);
	jclass jni_abnrmClass = (*env)->GetObjectClass(env, abnrm);
	jfieldID jni_abnrmId = (*env)->GetFieldID(env, jni_abnrmClass, "val", "D");
	jdouble jni_abnrm = (*env)->GetDoubleField(env, abnrm, jni_abnrmId);
	jdouble * jni_rconde = (*env)->GetPrimitiveArrayCritical(env, rconde, JNI_FALSE);
	check_memory(env, jni_rconde);
	jdouble * jni_rcondv = (*env)->GetPrimitiveArrayCritical(env, rcondv, JNI_FALSE);
	check_memory(env, jni_rcondv);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgeevx_(jni_balanc, jni_jobvl, jni_jobvr, jni_sense, &n, jni_a, &lda, jni_wr, jni_wi, jni_vl, &ldvl, jni_vr, &ldvr, &jni_ilo, &jni_ihi, jni_scale, &jni_abnrm, jni_rconde, jni_rcondv, jni_work, &lwork, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, balanc, jni_balanc);
	(*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
	(*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
	(*env)->ReleaseStringUTFChars(env, sense, jni_sense);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
	(*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
	(*env)->ReleasePrimitiveArrayCritical(env, scale, jni_scale, 0);
	(*env)->SetDoubleField(env, abnrm, jni_abnrmId, jni_abnrm);
	(*env)->ReleasePrimitiveArrayCritical(env, rconde, jni_rconde, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, rcondv, jni_rcondv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgegs (JNIEnv * env, jobject calling_obj, jstring jobvsl, jstring jobvsr, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray alphar, jdoubleArray alphai, jdoubleArray beta, jdoubleArray vsl, jint ldvsl, jdoubleArray vsr, jint ldvsr, jdoubleArray work, jint lwork, jobject info){
	char * jni_jobvsl = (char *)(*env)->GetStringUTFChars(env, jobvsl, JNI_FALSE);
	char * jni_jobvsr = (char *)(*env)->GetStringUTFChars(env, jobvsr, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
	check_memory(env, jni_alphar);
	jdouble * jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
	check_memory(env, jni_alphai);
	jdouble * jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
	check_memory(env, jni_beta);
	jdouble * jni_vsl = (*env)->GetPrimitiveArrayCritical(env, vsl, JNI_FALSE);
	check_memory(env, jni_vsl);
	jdouble * jni_vsr = (*env)->GetPrimitiveArrayCritical(env, vsr, JNI_FALSE);
	check_memory(env, jni_vsr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgegs_(jni_jobvsl, jni_jobvsr, &n, jni_a, &lda, jni_b, &ldb, jni_alphar, jni_alphai, jni_beta, jni_vsl, &ldvsl, jni_vsr, &ldvsr, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobvsl, jni_jobvsl);
	(*env)->ReleaseStringUTFChars(env, jobvsr, jni_jobvsr);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vsl, jni_vsl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vsr, jni_vsr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgegv (JNIEnv * env, jobject calling_obj, jstring jobvl, jstring jobvr, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray alphar, jdoubleArray alphai, jdoubleArray beta, jdoubleArray vl, jint ldvl, jdoubleArray vr, jint ldvr, jdoubleArray work, jint lwork, jobject info){
	char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
	char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
	check_memory(env, jni_alphar);
	jdouble * jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
	check_memory(env, jni_alphai);
	jdouble * jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
	check_memory(env, jni_beta);
	jdouble * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jdouble * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgegv_(jni_jobvl, jni_jobvr, &n, jni_a, &lda, jni_b, &ldb, jni_alphar, jni_alphai, jni_beta, jni_vl, &ldvl, jni_vr, &ldvr, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
	(*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgehd2 (JNIEnv * env, jobject calling_obj, jint n, jint ilo, jint ihi, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgehd2_(&n, &ilo, &ihi, jni_a, &lda, jni_tau, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgehrd (JNIEnv * env, jobject calling_obj, jint n, jint ilo, jint ihi, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgehrd_(&n, &ilo, &ihi, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgelq2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgelq2_(&m, &n, jni_a, &lda, jni_tau, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgelqf (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgelqf_(&m, &n, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgels (JNIEnv * env, jobject calling_obj, jstring trans, jint m, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray work, jint lwork, jobject info){
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgels_(jni_trans, &m, &n, &nrhs, jni_a, &lda, jni_b, &ldb, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgelsd (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray s, jdouble rcond, jobject rank, jdoubleArray work, jint lwork, jintArray iwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
	jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
	jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgelsd_(&m, &n, &nrhs, jni_a, &lda, jni_b, &ldb, jni_s, &rcond, &jni_rank, jni_work, &lwork, jni_iwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->SetIntField(env, rank, jni_rankId, jni_rank);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgelss (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray s, jdouble rcond, jobject rank, jdoubleArray work, jint lwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
	jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
	jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgelss_(&m, &n, &nrhs, jni_a, &lda, jni_b, &ldb, jni_s, &rcond, &jni_rank, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->SetIntField(env, rank, jni_rankId, jni_rank);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgelsx (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jintArray jpvt, jdouble rcond, jobject rank, jdoubleArray work, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jint * jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
	check_memory(env, jni_jpvt);
	jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
	jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
	jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgelsx_(&m, &n, &nrhs, jni_a, &lda, jni_b, &ldb, jni_jpvt, &rcond, &jni_rank, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
	(*env)->SetIntField(env, rank, jni_rankId, jni_rank);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgelsy (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jintArray jpvt, jdouble rcond, jobject rank, jdoubleArray work, jint lwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jint * jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
	check_memory(env, jni_jpvt);
	jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
	jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
	jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgelsy_(&m, &n, &nrhs, jni_a, &lda, jni_b, &ldb, jni_jpvt, &rcond, &jni_rank, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
	(*env)->SetIntField(env, rank, jni_rankId, jni_rank);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgeql2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgeql2_(&m, &n, jni_a, &lda, jni_tau, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgeqlf (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgeqlf_(&m, &n, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgeqp3 (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jintArray jpvt, jdoubleArray tau, jdoubleArray work, jint lwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
	check_memory(env, jni_jpvt);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgeqp3_(&m, &n, jni_a, &lda, jni_jpvt, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgeqpf (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jintArray jpvt, jdoubleArray tau, jdoubleArray work, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
	check_memory(env, jni_jpvt);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgeqpf_(&m, &n, jni_a, &lda, jni_jpvt, jni_tau, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgeqr2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgeqr2_(&m, &n, jni_a, &lda, jni_tau, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgeqrf (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgeqrf_(&m, &n, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgerfs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray af, jint ldaf, jintArray ipiv, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
	check_memory(env, jni_af);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgerfs_(jni_trans, &n, &nrhs, jni_a, &lda, jni_af, &ldaf, jni_ipiv, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgerq2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgerq2_(&m, &n, jni_a, &lda, jni_tau, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgerqf (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgerqf_(&m, &n, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgesc2 (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray a, jint lda, jdoubleArray rhs, jintArray ipiv, jintArray jpiv, jobject scale){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_rhs = (*env)->GetPrimitiveArrayCritical(env, rhs, JNI_FALSE);
	check_memory(env, jni_rhs);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jint * jni_jpiv = (*env)->GetPrimitiveArrayCritical(env, jpiv, JNI_FALSE);
	check_memory(env, jni_jpiv);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jdouble jni_scale = (*env)->GetDoubleField(env, scale, jni_scaleId);

	dgesc2_(&n, jni_a, &lda, jni_rhs, jni_ipiv, jni_jpiv, &jni_scale);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, rhs, jni_rhs, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, jpiv, jni_jpiv, 0);
	(*env)->SetDoubleField(env, scale, jni_scaleId, jni_scale);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgesdd (JNIEnv * env, jobject calling_obj, jstring jobz, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray s, jdoubleArray u, jint ldu, jdoubleArray vt, jint ldvt, jdoubleArray work, jint lwork, jintArray iwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jdouble * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jdouble * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgesdd_(jni_jobz, &m, &n, jni_a, &lda, jni_s, jni_u, &ldu, jni_vt, &ldvt, jni_work, &lwork, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgesv (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jdoubleArray a, jint lda, jintArray ipiv, jdoubleArray b, jint ldb, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgesv_(&n, &nrhs, jni_a, &lda, jni_ipiv, jni_b, &ldb, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgesvd (JNIEnv * env, jobject calling_obj, jstring jobu, jstring jobvt, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray s, jdoubleArray u, jint ldu, jdoubleArray vt, jint ldvt, jdoubleArray work, jint lwork, jobject info){
	char * jni_jobu = (char *)(*env)->GetStringUTFChars(env, jobu, JNI_FALSE);
	char * jni_jobvt = (char *)(*env)->GetStringUTFChars(env, jobvt, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jdouble * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jdouble * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgesvd_(jni_jobu, jni_jobvt, &m, &n, jni_a, &lda, jni_s, jni_u, &ldu, jni_vt, &ldvt, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobu, jni_jobu);
	(*env)->ReleaseStringUTFChars(env, jobvt, jni_jobvt);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgesvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring trans, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray af, jint ldaf, jintArray ipiv, jobject equed, jdoubleArray r, jdoubleArray c, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jobject rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
	check_memory(env, jni_af);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
	jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
	jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
	char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
	jdouble * jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
	check_memory(env, jni_r);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgesvx_(jni_fact, jni_trans, &n, &nrhs, jni_a, &lda, jni_af, &ldaf, jni_ipiv, jni_equed, jni_r, jni_c, jni_b, &ldb, jni_x, &ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, fact, jni_fact);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	jstring jni_equedStringNew = (*env)->NewStringUTF(env, jni_equed);
	(*env)->SetObjectField(env, equed, jni_equedId, jni_equedStringNew);
	(*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgetc2 (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray a, jint lda, jintArray ipiv, jintArray jpiv, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jint * jni_jpiv = (*env)->GetPrimitiveArrayCritical(env, jpiv, JNI_FALSE);
	check_memory(env, jni_jpiv);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgetc2_(&n, jni_a, &lda, jni_ipiv, jni_jpiv, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, jpiv, jni_jpiv, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgetf2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jintArray ipiv, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgetf2_(&m, &n, jni_a, &lda, jni_ipiv, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgetrf (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jintArray ipiv, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgetrf_(&m, &n, jni_a, &lda, jni_ipiv, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgetri (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray a, jint lda, jintArray ipiv, jdoubleArray work, jint lwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgetri_(&n, jni_a, &lda, jni_ipiv, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgetrs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jdoubleArray a, jint lda, jintArray ipiv, jdoubleArray b, jint ldb, jobject info){
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgetrs_(jni_trans, &n, &nrhs, jni_a, &lda, jni_ipiv, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dggbak (JNIEnv * env, jobject calling_obj, jstring job, jstring side, jint n, jint ilo, jint ihi, jdoubleArray lscale, jdoubleArray rscale, jint m, jdoubleArray v, jint ldv, jobject info){
	char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	jdouble * jni_lscale = (*env)->GetPrimitiveArrayCritical(env, lscale, JNI_FALSE);
	check_memory(env, jni_lscale);
	jdouble * jni_rscale = (*env)->GetPrimitiveArrayCritical(env, rscale, JNI_FALSE);
	check_memory(env, jni_rscale);
	jdouble * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dggbak_(jni_job, jni_side, &n, &ilo, &ihi, jni_lscale, jni_rscale, &m, jni_v, &ldv, &jni_info);

	(*env)->ReleaseStringUTFChars(env, job, jni_job);
	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleasePrimitiveArrayCritical(env, lscale, jni_lscale, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, rscale, jni_rscale, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dggbal (JNIEnv * env, jobject calling_obj, jstring job, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jobject ilo, jobject ihi, jdoubleArray lscale, jdoubleArray rscale, jdoubleArray work, jobject info){
	char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
	jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
	jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
	jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
	jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
	jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
	jdouble * jni_lscale = (*env)->GetPrimitiveArrayCritical(env, lscale, JNI_FALSE);
	check_memory(env, jni_lscale);
	jdouble * jni_rscale = (*env)->GetPrimitiveArrayCritical(env, rscale, JNI_FALSE);
	check_memory(env, jni_rscale);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dggbal_(jni_job, &n, jni_a, &lda, jni_b, &ldb, &jni_ilo, &jni_ihi, jni_lscale, jni_rscale, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, job, jni_job);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
	(*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
	(*env)->ReleasePrimitiveArrayCritical(env, lscale, jni_lscale, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, rscale, jni_rscale, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dggev (JNIEnv * env, jobject calling_obj, jstring jobvl, jstring jobvr, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray alphar, jdoubleArray alphai, jdoubleArray beta, jdoubleArray vl, jint ldvl, jdoubleArray vr, jint ldvr, jdoubleArray work, jint lwork, jobject info){
	char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
	char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
	check_memory(env, jni_alphar);
	jdouble * jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
	check_memory(env, jni_alphai);
	jdouble * jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
	check_memory(env, jni_beta);
	jdouble * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jdouble * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dggev_(jni_jobvl, jni_jobvr, &n, jni_a, &lda, jni_b, &ldb, jni_alphar, jni_alphai, jni_beta, jni_vl, &ldvl, jni_vr, &ldvr, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
	(*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dggevx (JNIEnv * env, jobject calling_obj, jstring balanc, jstring jobvl, jstring jobvr, jstring sense, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray alphar, jdoubleArray alphai, jdoubleArray beta, jdoubleArray vl, jint ldvl, jdoubleArray vr, jint ldvr, jobject ilo, jobject ihi, jdoubleArray lscale, jdoubleArray rscale, jobject abnrm, jobject bbnrm, jdoubleArray rconde, jdoubleArray rcondv, jdoubleArray work, jint lwork, jintArray iwork, jbooleanArray bwork, jobject info){
	char * jni_balanc = (char *)(*env)->GetStringUTFChars(env, balanc, JNI_FALSE);
	char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
	char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
	char * jni_sense = (char *)(*env)->GetStringUTFChars(env, sense, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
	check_memory(env, jni_alphar);
	jdouble * jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
	check_memory(env, jni_alphai);
	jdouble * jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
	check_memory(env, jni_beta);
	jdouble * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jdouble * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
	jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
	jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
	jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
	jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
	jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
	jdouble * jni_lscale = (*env)->GetPrimitiveArrayCritical(env, lscale, JNI_FALSE);
	check_memory(env, jni_lscale);
	jdouble * jni_rscale = (*env)->GetPrimitiveArrayCritical(env, rscale, JNI_FALSE);
	check_memory(env, jni_rscale);
	jclass jni_abnrmClass = (*env)->GetObjectClass(env, abnrm);
	jfieldID jni_abnrmId = (*env)->GetFieldID(env, jni_abnrmClass, "val", "D");
	jdouble jni_abnrm = (*env)->GetDoubleField(env, abnrm, jni_abnrmId);
	jclass jni_bbnrmClass = (*env)->GetObjectClass(env, bbnrm);
	jfieldID jni_bbnrmId = (*env)->GetFieldID(env, jni_bbnrmClass, "val", "D");
	jdouble jni_bbnrm = (*env)->GetDoubleField(env, bbnrm, jni_bbnrmId);
	jdouble * jni_rconde = (*env)->GetPrimitiveArrayCritical(env, rconde, JNI_FALSE);
	check_memory(env, jni_rconde);
	jdouble * jni_rcondv = (*env)->GetPrimitiveArrayCritical(env, rcondv, JNI_FALSE);
	check_memory(env, jni_rcondv);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jboolean * jni_bworkTmp = (*env)->GetPrimitiveArrayCritical(env, bwork, JNI_FALSE);
	jint jni_bworkSize = (*env)->GetArrayLength(env, bwork);
	logical jni_bwork[jni_bworkSize];
	int jni_bworki;
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
	for (jni_bworki = 0 ; jni_bworki < jni_bworkSize ; jni_bworki++){
		if (jni_bworkTmp[jni_bworki] == JNI_FALSE){
			jni_bwork[jni_bworki] = 0;
		} else {
			jni_bwork[jni_bworki] = 1;
		}
	}

	dggevx_(jni_balanc, jni_jobvl, jni_jobvr, jni_sense, &n, jni_a, &lda, jni_b, &ldb, jni_alphar, jni_alphai, jni_beta, jni_vl, &ldvl, jni_vr, &ldvr, &jni_ilo, &jni_ihi, jni_lscale, jni_rscale, &jni_abnrm, &jni_bbnrm, jni_rconde, jni_rcondv, jni_work, &lwork, jni_iwork, jni_bwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, balanc, jni_balanc);
	(*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
	(*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
	(*env)->ReleaseStringUTFChars(env, sense, jni_sense);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
	(*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
	(*env)->ReleasePrimitiveArrayCritical(env, lscale, jni_lscale, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, rscale, jni_rscale, 0);
	(*env)->SetDoubleField(env, abnrm, jni_abnrmId, jni_abnrm);
	(*env)->SetDoubleField(env, bbnrm, jni_bbnrmId, jni_bbnrm);
	(*env)->ReleasePrimitiveArrayCritical(env, rconde, jni_rconde, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, rcondv, jni_rcondv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	for (jni_bworki = 0 ; jni_bworki < jni_bworkSize ; jni_bworki++){
		if (jni_bwork[jni_bworki] == 0){
			jni_bworkTmp[jni_bworki] = JNI_FALSE;
		} else {
			jni_bworkTmp[jni_bworki] = JNI_TRUE;
		}
	}
	(*env)->ReleasePrimitiveArrayCritical(env, bwork, jni_bworkTmp, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dggglm (JNIEnv * env, jobject calling_obj, jint n, jint m, jint p, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray d, jdoubleArray x, jdoubleArray y, jdoubleArray work, jint lwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
	check_memory(env, jni_y);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dggglm_(&n, &m, &p, jni_a, &lda, jni_b, &ldb, jni_d, jni_x, jni_y, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgghrd (JNIEnv * env, jobject calling_obj, jstring compq, jstring compz, jint n, jint ilo, jint ihi, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray q, jint ldq, jdoubleArray z, jint ldz, jobject info){
	char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
	char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgghrd_(jni_compq, jni_compz, &n, &ilo, &ihi, jni_a, &lda, jni_b, &ldb, jni_q, &ldq, jni_z, &ldz, &jni_info);

	(*env)->ReleaseStringUTFChars(env, compq, jni_compq);
	(*env)->ReleaseStringUTFChars(env, compz, jni_compz);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgglse (JNIEnv * env, jobject calling_obj, jint m, jint n, jint p, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray c, jdoubleArray d, jdoubleArray x, jdoubleArray work, jint lwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgglse_(&m, &n, &p, jni_a, &lda, jni_b, &ldb, jni_c, jni_d, jni_x, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dggqrf (JNIEnv * env, jobject calling_obj, jint n, jint m, jint p, jdoubleArray a, jint lda, jdoubleArray taua, jdoubleArray b, jint ldb, jdoubleArray taub, jdoubleArray work, jint lwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_taua = (*env)->GetPrimitiveArrayCritical(env, taua, JNI_FALSE);
	check_memory(env, jni_taua);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_taub = (*env)->GetPrimitiveArrayCritical(env, taub, JNI_FALSE);
	check_memory(env, jni_taub);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dggqrf_(&n, &m, &p, jni_a, &lda, jni_taua, jni_b, &ldb, jni_taub, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, taua, jni_taua, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, taub, jni_taub, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dggrqf (JNIEnv * env, jobject calling_obj, jint m, jint p, jint n, jdoubleArray a, jint lda, jdoubleArray taua, jdoubleArray b, jint ldb, jdoubleArray taub, jdoubleArray work, jint lwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_taua = (*env)->GetPrimitiveArrayCritical(env, taua, JNI_FALSE);
	check_memory(env, jni_taua);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_taub = (*env)->GetPrimitiveArrayCritical(env, taub, JNI_FALSE);
	check_memory(env, jni_taub);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dggrqf_(&m, &p, &n, jni_a, &lda, jni_taua, jni_b, &ldb, jni_taub, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, taua, jni_taua, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, taub, jni_taub, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dggsvd (JNIEnv * env, jobject calling_obj, jstring jobu, jstring jobv, jstring jobq, jint m, jint n, jint p, jobject k, jobject l, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray alpha, jdoubleArray beta, jdoubleArray u, jint ldu, jdoubleArray v, jint ldv, jdoubleArray q, jint ldq, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_jobu = (char *)(*env)->GetStringUTFChars(env, jobu, JNI_FALSE);
	char * jni_jobv = (char *)(*env)->GetStringUTFChars(env, jobv, JNI_FALSE);
	char * jni_jobq = (char *)(*env)->GetStringUTFChars(env, jobq, JNI_FALSE);
	jclass jni_kClass = (*env)->GetObjectClass(env, k);
	jfieldID jni_kId = (*env)->GetFieldID(env, jni_kClass, "val", "I");
	jint jni_k = (*env)->GetIntField(env, k, jni_kId);
	jclass jni_lClass = (*env)->GetObjectClass(env, l);
	jfieldID jni_lId = (*env)->GetFieldID(env, jni_lClass, "val", "I");
	jint jni_l = (*env)->GetIntField(env, l, jni_lId);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_alpha = (*env)->GetPrimitiveArrayCritical(env, alpha, JNI_FALSE);
	check_memory(env, jni_alpha);
	jdouble * jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
	check_memory(env, jni_beta);
	jdouble * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jdouble * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dggsvd_(jni_jobu, jni_jobv, jni_jobq, &m, &n, &p, &jni_k, &jni_l, jni_a, &lda, jni_b, &ldb, jni_alpha, jni_beta, jni_u, &ldu, jni_v, &ldv, jni_q, &ldq, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobu, jni_jobu);
	(*env)->ReleaseStringUTFChars(env, jobv, jni_jobv);
	(*env)->ReleaseStringUTFChars(env, jobq, jni_jobq);
	(*env)->SetIntField(env, k, jni_kId, jni_k);
	(*env)->SetIntField(env, l, jni_lId, jni_l);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alpha, jni_alpha, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dggsvp (JNIEnv * env, jobject calling_obj, jstring jobu, jstring jobv, jstring jobq, jint m, jint p, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdouble tola, jdouble tolb, jobject k, jobject l, jdoubleArray u, jint ldu, jdoubleArray v, jint ldv, jdoubleArray q, jint ldq, jintArray iwork, jdoubleArray tau, jdoubleArray work, jobject info){
	char * jni_jobu = (char *)(*env)->GetStringUTFChars(env, jobu, JNI_FALSE);
	char * jni_jobv = (char *)(*env)->GetStringUTFChars(env, jobv, JNI_FALSE);
	char * jni_jobq = (char *)(*env)->GetStringUTFChars(env, jobq, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_kClass = (*env)->GetObjectClass(env, k);
	jfieldID jni_kId = (*env)->GetFieldID(env, jni_kClass, "val", "I");
	jint jni_k = (*env)->GetIntField(env, k, jni_kId);
	jclass jni_lClass = (*env)->GetObjectClass(env, l);
	jfieldID jni_lId = (*env)->GetFieldID(env, jni_lClass, "val", "I");
	jint jni_l = (*env)->GetIntField(env, l, jni_lId);
	jdouble * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jdouble * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dggsvp_(jni_jobu, jni_jobv, jni_jobq, &m, &p, &n, jni_a, &lda, jni_b, &ldb, &tola, &tolb, &jni_k, &jni_l, jni_u, &ldu, jni_v, &ldv, jni_q, &ldq, jni_iwork, jni_tau, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobu, jni_jobu);
	(*env)->ReleaseStringUTFChars(env, jobv, jni_jobv);
	(*env)->ReleaseStringUTFChars(env, jobq, jni_jobq);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, k, jni_kId, jni_k);
	(*env)->SetIntField(env, l, jni_lId, jni_l);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgtcon (JNIEnv * env, jobject calling_obj, jstring norm, jint n, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray du2, jintArray ipiv, jdouble anorm, jobject rcond, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
	jdouble * jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
	check_memory(env, jni_dl);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
	check_memory(env, jni_du);
	jdouble * jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
	check_memory(env, jni_du2);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgtcon_(jni_norm, &n, jni_dl, jni_d, jni_du, jni_du2, jni_ipiv, &anorm, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, norm, jni_norm);
	(*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgtrfs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray dlf, jdoubleArray df, jdoubleArray duf, jdoubleArray du2, jintArray ipiv, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
	check_memory(env, jni_dl);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
	check_memory(env, jni_du);
	jdouble * jni_dlf = (*env)->GetPrimitiveArrayCritical(env, dlf, JNI_FALSE);
	check_memory(env, jni_dlf);
	jdouble * jni_df = (*env)->GetPrimitiveArrayCritical(env, df, JNI_FALSE);
	check_memory(env, jni_df);
	jdouble * jni_duf = (*env)->GetPrimitiveArrayCritical(env, duf, JNI_FALSE);
	check_memory(env, jni_duf);
	jdouble * jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
	check_memory(env, jni_du2);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgtrfs_(jni_trans, &n, &nrhs, jni_dl, jni_d, jni_du, jni_dlf, jni_df, jni_duf, jni_du2, jni_ipiv, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dlf, jni_dlf, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, df, jni_df, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, duf, jni_duf, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgtsv (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray b, jint ldb, jobject info){
	jdouble * jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
	check_memory(env, jni_dl);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
	check_memory(env, jni_du);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgtsv_(&n, &nrhs, jni_dl, jni_d, jni_du, jni_b, &ldb, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgtsvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring trans, jint n, jint nrhs, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray dlf, jdoubleArray df, jdoubleArray duf, jdoubleArray du2, jintArray ipiv, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jobject rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
	check_memory(env, jni_dl);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
	check_memory(env, jni_du);
	jdouble * jni_dlf = (*env)->GetPrimitiveArrayCritical(env, dlf, JNI_FALSE);
	check_memory(env, jni_dlf);
	jdouble * jni_df = (*env)->GetPrimitiveArrayCritical(env, df, JNI_FALSE);
	check_memory(env, jni_df);
	jdouble * jni_duf = (*env)->GetPrimitiveArrayCritical(env, duf, JNI_FALSE);
	check_memory(env, jni_duf);
	jdouble * jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
	check_memory(env, jni_du2);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgtsvx_(jni_fact, jni_trans, &n, &nrhs, jni_dl, jni_d, jni_du, jni_dlf, jni_df, jni_duf, jni_du2, jni_ipiv, jni_b, &ldb, jni_x, &ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, fact, jni_fact);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dlf, jni_dlf, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, df, jni_df, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, duf, jni_duf, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgttrf (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray du2, jintArray ipiv, jobject info){
	jdouble * jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
	check_memory(env, jni_dl);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
	check_memory(env, jni_du);
	jdouble * jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
	check_memory(env, jni_du2);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgttrf_(&n, jni_dl, jni_d, jni_du, jni_du2, jni_ipiv, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgttrs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray du2, jintArray ipiv, jdoubleArray b, jint ldb, jobject info){
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
	check_memory(env, jni_dl);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
	check_memory(env, jni_du);
	jdouble * jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
	check_memory(env, jni_du2);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dgttrs_(jni_trans, &n, &nrhs, jni_dl, jni_d, jni_du, jni_du2, jni_ipiv, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dgtts2 (JNIEnv * env, jobject calling_obj, jint itrans, jint n, jint nrhs, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray du2, jintArray ipiv, jdoubleArray b, jint ldb){
	jdouble * jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
	check_memory(env, jni_dl);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
	check_memory(env, jni_du);
	jdouble * jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
	check_memory(env, jni_du2);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);

	dgtts2_(&itrans, &n, &nrhs, jni_dl, jni_d, jni_du, jni_du2, jni_ipiv, jni_b, &ldb);

	(*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dhgeqz (JNIEnv * env, jobject calling_obj, jstring job, jstring compq, jstring compz, jint n, jint ilo, jint ihi, jdoubleArray h, jint ldh, jdoubleArray t, jint ldt, jdoubleArray alphar, jdoubleArray alphai, jdoubleArray beta, jdoubleArray q, jint ldq, jdoubleArray z, jint ldz, jdoubleArray work, jint lwork, jobject info){
	char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
	char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
	char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
	jdouble * jni_h = (*env)->GetPrimitiveArrayCritical(env, h, JNI_FALSE);
	check_memory(env, jni_h);
	jdouble * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);
	jdouble * jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
	check_memory(env, jni_alphar);
	jdouble * jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
	check_memory(env, jni_alphai);
	jdouble * jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
	check_memory(env, jni_beta);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dhgeqz_(jni_job, jni_compq, jni_compz, &n, &ilo, &ihi, jni_h, &ldh, jni_t, &ldt, jni_alphar, jni_alphai, jni_beta, jni_q, &ldq, jni_z, &ldz, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, job, jni_job);
	(*env)->ReleaseStringUTFChars(env, compq, jni_compq);
	(*env)->ReleaseStringUTFChars(env, compz, jni_compz);
	(*env)->ReleasePrimitiveArrayCritical(env, h, jni_h, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dhsein (JNIEnv * env, jobject calling_obj, jstring side, jstring eigsrc, jstring initv, jbooleanArray select, jint n, jdoubleArray h, jint ldh, jdoubleArray wr, jdoubleArray wi, jdoubleArray vl, jint ldvl, jdoubleArray vr, jint ldvr, jint mm, jobject m, jdoubleArray work, jintArray ifaill, jintArray ifailr, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_eigsrc = (char *)(*env)->GetStringUTFChars(env, eigsrc, JNI_FALSE);
	char * jni_initv = (char *)(*env)->GetStringUTFChars(env, initv, JNI_FALSE);
	jboolean * jni_selectTmp = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
	jint jni_selectSize = (*env)->GetArrayLength(env, select);
	logical jni_select[jni_selectSize];
	int jni_selecti;
	jdouble * jni_h = (*env)->GetPrimitiveArrayCritical(env, h, JNI_FALSE);
	check_memory(env, jni_h);
	jdouble * jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
	check_memory(env, jni_wr);
	jdouble * jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
	check_memory(env, jni_wi);
	jdouble * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jdouble * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_ifaill = (*env)->GetPrimitiveArrayCritical(env, ifaill, JNI_FALSE);
	check_memory(env, jni_ifaill);
	jint * jni_ifailr = (*env)->GetPrimitiveArrayCritical(env, ifailr, JNI_FALSE);
	check_memory(env, jni_ifailr);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_selectTmp[jni_selecti] == JNI_FALSE){
			jni_select[jni_selecti] = 0;
		} else {
			jni_select[jni_selecti] = 1;
		}
	}

	dhsein_(jni_side, jni_eigsrc, jni_initv, jni_select, &n, jni_h, &ldh, jni_wr, jni_wi, jni_vl, &ldvl, jni_vr, &ldvr, &mm, &jni_m, jni_work, jni_ifaill, jni_ifailr, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, eigsrc, jni_eigsrc);
	(*env)->ReleaseStringUTFChars(env, initv, jni_initv);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_select[jni_selecti] == 0){
			jni_selectTmp[jni_selecti] = JNI_FALSE;
		} else {
			jni_selectTmp[jni_selecti] = JNI_TRUE;
		}
	}
	(*env)->ReleasePrimitiveArrayCritical(env, select, jni_selectTmp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, h, jni_h, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ifaill, jni_ifaill, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ifailr, jni_ifailr, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dhseqr (JNIEnv * env, jobject calling_obj, jstring job, jstring compz, jint n, jint ilo, jint ihi, jdoubleArray h, jint ldh, jdoubleArray wr, jdoubleArray wi, jdoubleArray z, jint ldz, jdoubleArray work, jint lwork, jobject info){
	char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
	char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
	jdouble * jni_h = (*env)->GetPrimitiveArrayCritical(env, h, JNI_FALSE);
	check_memory(env, jni_h);
	jdouble * jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
	check_memory(env, jni_wr);
	jdouble * jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
	check_memory(env, jni_wi);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dhseqr_(jni_job, jni_compz, &n, &ilo, &ihi, jni_h, &ldh, jni_wr, jni_wi, jni_z, &ldz, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, job, jni_job);
	(*env)->ReleaseStringUTFChars(env, compz, jni_compz);
	(*env)->ReleasePrimitiveArrayCritical(env, h, jni_h, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlabad (JNIEnv * env, jobject calling_obj, jobject small, jobject large){
	jclass jni_smallClass = (*env)->GetObjectClass(env, small);
	jfieldID jni_smallId = (*env)->GetFieldID(env, jni_smallClass, "val", "D");
	jdouble jni_small = (*env)->GetDoubleField(env, small, jni_smallId);
	jclass jni_largeClass = (*env)->GetObjectClass(env, large);
	jfieldID jni_largeId = (*env)->GetFieldID(env, jni_largeClass, "val", "D");
	jdouble jni_large = (*env)->GetDoubleField(env, large, jni_largeId);

	dlabad_(&jni_small, &jni_large);

	(*env)->SetDoubleField(env, small, jni_smallId, jni_small);
	(*env)->SetDoubleField(env, large, jni_largeId, jni_large);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlabrd (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nb, jdoubleArray a, jint lda, jdoubleArray d, jdoubleArray e, jdoubleArray tauq, jdoubleArray taup, jdoubleArray x, jint ldx, jdoubleArray y, jint ldy){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_tauq = (*env)->GetPrimitiveArrayCritical(env, tauq, JNI_FALSE);
	check_memory(env, jni_tauq);
	jdouble * jni_taup = (*env)->GetPrimitiveArrayCritical(env, taup, JNI_FALSE);
	check_memory(env, jni_taup);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
	check_memory(env, jni_y);

	dlabrd_(&m, &n, &nb, jni_a, &lda, jni_d, jni_e, jni_tauq, jni_taup, jni_x, &ldx, jni_y, &ldy);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tauq, jni_tauq, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, taup, jni_taup, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlacon (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray v, jdoubleArray x, jintArray isgn, jobject est, jobject kase){
	jdouble * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jint * jni_isgn = (*env)->GetPrimitiveArrayCritical(env, isgn, JNI_FALSE);
	check_memory(env, jni_isgn);
	jclass jni_estClass = (*env)->GetObjectClass(env, est);
	jfieldID jni_estId = (*env)->GetFieldID(env, jni_estClass, "val", "D");
	jdouble jni_est = (*env)->GetDoubleField(env, est, jni_estId);
	jclass jni_kaseClass = (*env)->GetObjectClass(env, kase);
	jfieldID jni_kaseId = (*env)->GetFieldID(env, jni_kaseClass, "val", "I");
	jint jni_kase = (*env)->GetIntField(env, kase, jni_kaseId);

	dlacon_(&n, jni_v, jni_x, jni_isgn, &jni_est, &jni_kase);

	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, isgn, jni_isgn, 0);
	(*env)->SetDoubleField(env, est, jni_estId, jni_est);
	(*env)->SetIntField(env, kase, jni_kaseId, jni_kase);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlacpy (JNIEnv * env, jobject calling_obj, jstring uplo, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);

	dlacpy_(jni_uplo, &m, &n, jni_a, &lda, jni_b, &ldb);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dladiv (JNIEnv * env, jobject calling_obj, jdouble a, jdouble b, jdouble c, jdouble d, jobject p, jobject q){
	jclass jni_pClass = (*env)->GetObjectClass(env, p);
	jfieldID jni_pId = (*env)->GetFieldID(env, jni_pClass, "val", "D");
	jdouble jni_p = (*env)->GetDoubleField(env, p, jni_pId);
	jclass jni_qClass = (*env)->GetObjectClass(env, q);
	jfieldID jni_qId = (*env)->GetFieldID(env, jni_qClass, "val", "D");
	jdouble jni_q = (*env)->GetDoubleField(env, q, jni_qId);

	dladiv_(&a, &b, &c, &d, &jni_p, &jni_q);

	(*env)->SetDoubleField(env, p, jni_pId, jni_p);
	(*env)->SetDoubleField(env, q, jni_qId, jni_q);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlae2 (JNIEnv * env, jobject calling_obj, jdouble a, jdouble b, jdouble c, jobject rt1, jobject rt2){
	jclass jni_rt1Class = (*env)->GetObjectClass(env, rt1);
	jfieldID jni_rt1Id = (*env)->GetFieldID(env, jni_rt1Class, "val", "D");
	jdouble jni_rt1 = (*env)->GetDoubleField(env, rt1, jni_rt1Id);
	jclass jni_rt2Class = (*env)->GetObjectClass(env, rt2);
	jfieldID jni_rt2Id = (*env)->GetFieldID(env, jni_rt2Class, "val", "D");
	jdouble jni_rt2 = (*env)->GetDoubleField(env, rt2, jni_rt2Id);

	dlae2_(&a, &b, &c, &jni_rt1, &jni_rt2);

	(*env)->SetDoubleField(env, rt1, jni_rt1Id, jni_rt1);
	(*env)->SetDoubleField(env, rt2, jni_rt2Id, jni_rt2);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaebz (JNIEnv * env, jobject calling_obj, jint ijob, jint nitmax, jint n, jint mmax, jint minp, jint nbmin, jdouble abstol, jdouble reltol, jdouble pivmin, jdoubleArray d, jdoubleArray e, jdoubleArray e2, jintArray nval, jdoubleArray ab, jdoubleArray c, jobject mout, jintArray nab, jdoubleArray work, jintArray iwork, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_e2 = (*env)->GetPrimitiveArrayCritical(env, e2, JNI_FALSE);
	check_memory(env, jni_e2);
	jint * jni_nval = (*env)->GetPrimitiveArrayCritical(env, nval, JNI_FALSE);
	check_memory(env, jni_nval);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jclass jni_moutClass = (*env)->GetObjectClass(env, mout);
	jfieldID jni_moutId = (*env)->GetFieldID(env, jni_moutClass, "val", "I");
	jint jni_mout = (*env)->GetIntField(env, mout, jni_moutId);
	jint * jni_nab = (*env)->GetPrimitiveArrayCritical(env, nab, JNI_FALSE);
	check_memory(env, jni_nab);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlaebz_(&ijob, &nitmax, &n, &mmax, &minp, &nbmin, &abstol, &reltol, &pivmin, jni_d, jni_e, jni_e2, jni_nval, jni_ab, jni_c, &jni_mout, jni_nab, jni_work, jni_iwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e2, jni_e2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, nval, jni_nval, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->SetIntField(env, mout, jni_moutId, jni_mout);
	(*env)->ReleasePrimitiveArrayCritical(env, nab, jni_nab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaed0 (JNIEnv * env, jobject calling_obj, jint icompq, jint qsiz, jint n, jdoubleArray d, jdoubleArray e, jdoubleArray q, jint ldq, jdoubleArray qstore, jint ldqs, jdoubleArray work, jintArray iwork, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jdouble * jni_qstore = (*env)->GetPrimitiveArrayCritical(env, qstore, JNI_FALSE);
	check_memory(env, jni_qstore);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlaed0_(&icompq, &qsiz, &n, jni_d, jni_e, jni_q, &ldq, jni_qstore, &ldqs, jni_work, jni_iwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, qstore, jni_qstore, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaed1 (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray d, jdoubleArray q, jint ldq, jintArray indxq, jobject rho, jint cutpnt, jdoubleArray work, jintArray iwork, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jint * jni_indxq = (*env)->GetPrimitiveArrayCritical(env, indxq, JNI_FALSE);
	check_memory(env, jni_indxq);
	jclass jni_rhoClass = (*env)->GetObjectClass(env, rho);
	jfieldID jni_rhoId = (*env)->GetFieldID(env, jni_rhoClass, "val", "D");
	jdouble jni_rho = (*env)->GetDoubleField(env, rho, jni_rhoId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlaed1_(&n, jni_d, jni_q, &ldq, jni_indxq, &jni_rho, &cutpnt, jni_work, jni_iwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, indxq, jni_indxq, 0);
	(*env)->SetDoubleField(env, rho, jni_rhoId, jni_rho);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaed2 (JNIEnv * env, jobject calling_obj, jobject k, jint n, jint n1, jdoubleArray d, jdoubleArray q, jint ldq, jintArray indxq, jobject rho, jdoubleArray z, jdoubleArray dlamda, jdoubleArray w, jdoubleArray q2, jintArray indx, jintArray indxc, jintArray indxp, jintArray coltyp, jobject info){
	jclass jni_kClass = (*env)->GetObjectClass(env, k);
	jfieldID jni_kId = (*env)->GetFieldID(env, jni_kClass, "val", "I");
	jint jni_k = (*env)->GetIntField(env, k, jni_kId);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jint * jni_indxq = (*env)->GetPrimitiveArrayCritical(env, indxq, JNI_FALSE);
	check_memory(env, jni_indxq);
	jclass jni_rhoClass = (*env)->GetObjectClass(env, rho);
	jfieldID jni_rhoId = (*env)->GetFieldID(env, jni_rhoClass, "val", "D");
	jdouble jni_rho = (*env)->GetDoubleField(env, rho, jni_rhoId);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_dlamda = (*env)->GetPrimitiveArrayCritical(env, dlamda, JNI_FALSE);
	check_memory(env, jni_dlamda);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_q2 = (*env)->GetPrimitiveArrayCritical(env, q2, JNI_FALSE);
	check_memory(env, jni_q2);
	jint * jni_indx = (*env)->GetPrimitiveArrayCritical(env, indx, JNI_FALSE);
	check_memory(env, jni_indx);
	jint * jni_indxc = (*env)->GetPrimitiveArrayCritical(env, indxc, JNI_FALSE);
	check_memory(env, jni_indxc);
	jint * jni_indxp = (*env)->GetPrimitiveArrayCritical(env, indxp, JNI_FALSE);
	check_memory(env, jni_indxp);
	jint * jni_coltyp = (*env)->GetPrimitiveArrayCritical(env, coltyp, JNI_FALSE);
	check_memory(env, jni_coltyp);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlaed2_(&jni_k, &n, &n1, jni_d, jni_q, &ldq, jni_indxq, &jni_rho, jni_z, jni_dlamda, jni_w, jni_q2, jni_indx, jni_indxc, jni_indxp, jni_coltyp, &jni_info);

	(*env)->SetIntField(env, k, jni_kId, jni_k);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, indxq, jni_indxq, 0);
	(*env)->SetDoubleField(env, rho, jni_rhoId, jni_rho);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dlamda, jni_dlamda, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q2, jni_q2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, indx, jni_indx, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, indxc, jni_indxc, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, indxp, jni_indxp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, coltyp, jni_coltyp, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaed3 (JNIEnv * env, jobject calling_obj, jint k, jint n, jint n1, jdoubleArray d, jdoubleArray q, jint ldq, jdouble rho, jdoubleArray dlamda, jdoubleArray q2, jintArray indx, jintArray ctot, jdoubleArray w, jdoubleArray s, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jdouble * jni_dlamda = (*env)->GetPrimitiveArrayCritical(env, dlamda, JNI_FALSE);
	check_memory(env, jni_dlamda);
	jdouble * jni_q2 = (*env)->GetPrimitiveArrayCritical(env, q2, JNI_FALSE);
	check_memory(env, jni_q2);
	jint * jni_indx = (*env)->GetPrimitiveArrayCritical(env, indx, JNI_FALSE);
	check_memory(env, jni_indx);
	jint * jni_ctot = (*env)->GetPrimitiveArrayCritical(env, ctot, JNI_FALSE);
	check_memory(env, jni_ctot);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlaed3_(&k, &n, &n1, jni_d, jni_q, &ldq, &rho, jni_dlamda, jni_q2, jni_indx, jni_ctot, jni_w, jni_s, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dlamda, jni_dlamda, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q2, jni_q2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, indx, jni_indx, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ctot, jni_ctot, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaed4 (JNIEnv * env, jobject calling_obj, jint n, jint i, jdoubleArray d, jdoubleArray z, jdoubleArray delta, jdouble rho, jobject dlam, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_delta = (*env)->GetPrimitiveArrayCritical(env, delta, JNI_FALSE);
	check_memory(env, jni_delta);
	jclass jni_dlamClass = (*env)->GetObjectClass(env, dlam);
	jfieldID jni_dlamId = (*env)->GetFieldID(env, jni_dlamClass, "val", "D");
	jdouble jni_dlam = (*env)->GetDoubleField(env, dlam, jni_dlamId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlaed4_(&n, &i, jni_d, jni_z, jni_delta, &rho, &jni_dlam, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, delta, jni_delta, 0);
	(*env)->SetDoubleField(env, dlam, jni_dlamId, jni_dlam);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaed5 (JNIEnv * env, jobject calling_obj, jint i, jdoubleArray d, jdoubleArray z, jdoubleArray delta, jdouble rho, jobject dlam){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_delta = (*env)->GetPrimitiveArrayCritical(env, delta, JNI_FALSE);
	check_memory(env, jni_delta);
	jclass jni_dlamClass = (*env)->GetObjectClass(env, dlam);
	jfieldID jni_dlamId = (*env)->GetFieldID(env, jni_dlamClass, "val", "D");
	jdouble jni_dlam = (*env)->GetDoubleField(env, dlam, jni_dlamId);

	dlaed5_(&i, jni_d, jni_z, jni_delta, &rho, &jni_dlam);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, delta, jni_delta, 0);
	(*env)->SetDoubleField(env, dlam, jni_dlamId, jni_dlam);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaed6 (JNIEnv * env, jobject calling_obj, jint kniter, jboolean orgati, jdouble rho, jdoubleArray d, jdoubleArray z, jdouble finit, jobject tau, jobject info){
	logical jni_orgati = (logical)orgati;
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_tauClass = (*env)->GetObjectClass(env, tau);
	jfieldID jni_tauId = (*env)->GetFieldID(env, jni_tauClass, "val", "D");
	jdouble jni_tau = (*env)->GetDoubleField(env, tau, jni_tauId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlaed6_(&kniter, &jni_orgati, &rho, jni_d, jni_z, &finit, &jni_tau, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetDoubleField(env, tau, jni_tauId, jni_tau);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaed7 (JNIEnv * env, jobject calling_obj, jint icompq, jint n, jint qsiz, jint tlvls, jint curlvl, jint curpbm, jdoubleArray d, jdoubleArray q, jint ldq, jintArray indxq, jobject rho, jint cutpnt, jdoubleArray qstore, jintArray qptr, jintArray prmptr, jintArray perm, jintArray givptr, jintArray givcol, jdoubleArray givnum, jdoubleArray work, jintArray iwork, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jint * jni_indxq = (*env)->GetPrimitiveArrayCritical(env, indxq, JNI_FALSE);
	check_memory(env, jni_indxq);
	jclass jni_rhoClass = (*env)->GetObjectClass(env, rho);
	jfieldID jni_rhoId = (*env)->GetFieldID(env, jni_rhoClass, "val", "D");
	jdouble jni_rho = (*env)->GetDoubleField(env, rho, jni_rhoId);
	jdouble * jni_qstore = (*env)->GetPrimitiveArrayCritical(env, qstore, JNI_FALSE);
	check_memory(env, jni_qstore);
	jint * jni_qptr = (*env)->GetPrimitiveArrayCritical(env, qptr, JNI_FALSE);
	check_memory(env, jni_qptr);
	jint * jni_prmptr = (*env)->GetPrimitiveArrayCritical(env, prmptr, JNI_FALSE);
	check_memory(env, jni_prmptr);
	jint * jni_perm = (*env)->GetPrimitiveArrayCritical(env, perm, JNI_FALSE);
	check_memory(env, jni_perm);
	jint * jni_givptr = (*env)->GetPrimitiveArrayCritical(env, givptr, JNI_FALSE);
	check_memory(env, jni_givptr);
	jint * jni_givcol = (*env)->GetPrimitiveArrayCritical(env, givcol, JNI_FALSE);
	check_memory(env, jni_givcol);
	jdouble * jni_givnum = (*env)->GetPrimitiveArrayCritical(env, givnum, JNI_FALSE);
	check_memory(env, jni_givnum);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlaed7_(&icompq, &n, &qsiz, &tlvls, &curlvl, &curpbm, jni_d, jni_q, &ldq, jni_indxq, &jni_rho, &cutpnt, jni_qstore, jni_qptr, jni_prmptr, jni_perm, jni_givptr, jni_givcol, jni_givnum, jni_work, jni_iwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, indxq, jni_indxq, 0);
	(*env)->SetDoubleField(env, rho, jni_rhoId, jni_rho);
	(*env)->ReleasePrimitiveArrayCritical(env, qstore, jni_qstore, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, qptr, jni_qptr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, prmptr, jni_prmptr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, perm, jni_perm, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givptr, jni_givptr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givcol, jni_givcol, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givnum, jni_givnum, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaed8 (JNIEnv * env, jobject calling_obj, jint icompq, jobject k, jint n, jint qsiz, jdoubleArray d, jdoubleArray q, jint ldq, jintArray indxq, jobject rho, jint cutpnt, jdoubleArray z, jdoubleArray dlamda, jdoubleArray q2, jint ldq2, jdoubleArray w, jintArray perm, jobject givptr, jintArray givcol, jdoubleArray givnum, jintArray indxp, jintArray indx, jobject info){
	jclass jni_kClass = (*env)->GetObjectClass(env, k);
	jfieldID jni_kId = (*env)->GetFieldID(env, jni_kClass, "val", "I");
	jint jni_k = (*env)->GetIntField(env, k, jni_kId);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jint * jni_indxq = (*env)->GetPrimitiveArrayCritical(env, indxq, JNI_FALSE);
	check_memory(env, jni_indxq);
	jclass jni_rhoClass = (*env)->GetObjectClass(env, rho);
	jfieldID jni_rhoId = (*env)->GetFieldID(env, jni_rhoClass, "val", "D");
	jdouble jni_rho = (*env)->GetDoubleField(env, rho, jni_rhoId);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_dlamda = (*env)->GetPrimitiveArrayCritical(env, dlamda, JNI_FALSE);
	check_memory(env, jni_dlamda);
	jdouble * jni_q2 = (*env)->GetPrimitiveArrayCritical(env, q2, JNI_FALSE);
	check_memory(env, jni_q2);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jint * jni_perm = (*env)->GetPrimitiveArrayCritical(env, perm, JNI_FALSE);
	check_memory(env, jni_perm);
	jclass jni_givptrClass = (*env)->GetObjectClass(env, givptr);
	jfieldID jni_givptrId = (*env)->GetFieldID(env, jni_givptrClass, "val", "I");
	jint jni_givptr = (*env)->GetIntField(env, givptr, jni_givptrId);
	jint * jni_givcol = (*env)->GetPrimitiveArrayCritical(env, givcol, JNI_FALSE);
	check_memory(env, jni_givcol);
	jdouble * jni_givnum = (*env)->GetPrimitiveArrayCritical(env, givnum, JNI_FALSE);
	check_memory(env, jni_givnum);
	jint * jni_indxp = (*env)->GetPrimitiveArrayCritical(env, indxp, JNI_FALSE);
	check_memory(env, jni_indxp);
	jint * jni_indx = (*env)->GetPrimitiveArrayCritical(env, indx, JNI_FALSE);
	check_memory(env, jni_indx);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlaed8_(&icompq, &jni_k, &n, &qsiz, jni_d, jni_q, &ldq, jni_indxq, &jni_rho, &cutpnt, jni_z, jni_dlamda, jni_q2, &ldq2, jni_w, jni_perm, &jni_givptr, jni_givcol, jni_givnum, jni_indxp, jni_indx, &jni_info);

	(*env)->SetIntField(env, k, jni_kId, jni_k);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, indxq, jni_indxq, 0);
	(*env)->SetDoubleField(env, rho, jni_rhoId, jni_rho);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dlamda, jni_dlamda, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q2, jni_q2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, perm, jni_perm, 0);
	(*env)->SetIntField(env, givptr, jni_givptrId, jni_givptr);
	(*env)->ReleasePrimitiveArrayCritical(env, givcol, jni_givcol, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givnum, jni_givnum, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, indxp, jni_indxp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, indx, jni_indx, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaed9 (JNIEnv * env, jobject calling_obj, jint k, jint kstart, jint kstop, jint n, jdoubleArray d, jdoubleArray q, jint ldq, jdouble rho, jdoubleArray dlamda, jdoubleArray w, jdoubleArray s, jint lds, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jdouble * jni_dlamda = (*env)->GetPrimitiveArrayCritical(env, dlamda, JNI_FALSE);
	check_memory(env, jni_dlamda);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlaed9_(&k, &kstart, &kstop, &n, jni_d, jni_q, &ldq, &rho, jni_dlamda, jni_w, jni_s, &lds, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dlamda, jni_dlamda, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaeda (JNIEnv * env, jobject calling_obj, jint n, jint tlvls, jint curlvl, jint curpbm, jintArray prmptr, jintArray perm, jintArray givptr, jintArray givcol, jdoubleArray givnum, jdoubleArray q, jintArray qptr, jdoubleArray z, jdoubleArray ztemp, jobject info){
	jint * jni_prmptr = (*env)->GetPrimitiveArrayCritical(env, prmptr, JNI_FALSE);
	check_memory(env, jni_prmptr);
	jint * jni_perm = (*env)->GetPrimitiveArrayCritical(env, perm, JNI_FALSE);
	check_memory(env, jni_perm);
	jint * jni_givptr = (*env)->GetPrimitiveArrayCritical(env, givptr, JNI_FALSE);
	check_memory(env, jni_givptr);
	jint * jni_givcol = (*env)->GetPrimitiveArrayCritical(env, givcol, JNI_FALSE);
	check_memory(env, jni_givcol);
	jdouble * jni_givnum = (*env)->GetPrimitiveArrayCritical(env, givnum, JNI_FALSE);
	check_memory(env, jni_givnum);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jint * jni_qptr = (*env)->GetPrimitiveArrayCritical(env, qptr, JNI_FALSE);
	check_memory(env, jni_qptr);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_ztemp = (*env)->GetPrimitiveArrayCritical(env, ztemp, JNI_FALSE);
	check_memory(env, jni_ztemp);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlaeda_(&n, &tlvls, &curlvl, &curpbm, jni_prmptr, jni_perm, jni_givptr, jni_givcol, jni_givnum, jni_q, jni_qptr, jni_z, jni_ztemp, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, prmptr, jni_prmptr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, perm, jni_perm, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givptr, jni_givptr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givcol, jni_givcol, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givnum, jni_givnum, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, qptr, jni_qptr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ztemp, jni_ztemp, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaein (JNIEnv * env, jobject calling_obj, jboolean rightv, jboolean noinit, jint n, jdoubleArray h, jint ldh, jdouble wr, jdouble wi, jdoubleArray vr, jdoubleArray vi, jdoubleArray b, jint ldb, jdoubleArray work, jdouble eps3, jdouble smlnum, jdouble bignum, jobject info){
	logical jni_rightv = (logical)rightv;
	logical jni_noinit = (logical)noinit;
	jdouble * jni_h = (*env)->GetPrimitiveArrayCritical(env, h, JNI_FALSE);
	check_memory(env, jni_h);
	jdouble * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jdouble * jni_vi = (*env)->GetPrimitiveArrayCritical(env, vi, JNI_FALSE);
	check_memory(env, jni_vi);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlaein_(&jni_rightv, &jni_noinit, &n, jni_h, &ldh, &wr, &wi, jni_vr, jni_vi, jni_b, &ldb, jni_work, &eps3, &smlnum, &bignum, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, h, jni_h, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vi, jni_vi, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaev2 (JNIEnv * env, jobject calling_obj, jdouble a, jdouble b, jdouble c, jobject rt1, jobject rt2, jobject cs1, jobject sn1){
	jclass jni_rt1Class = (*env)->GetObjectClass(env, rt1);
	jfieldID jni_rt1Id = (*env)->GetFieldID(env, jni_rt1Class, "val", "D");
	jdouble jni_rt1 = (*env)->GetDoubleField(env, rt1, jni_rt1Id);
	jclass jni_rt2Class = (*env)->GetObjectClass(env, rt2);
	jfieldID jni_rt2Id = (*env)->GetFieldID(env, jni_rt2Class, "val", "D");
	jdouble jni_rt2 = (*env)->GetDoubleField(env, rt2, jni_rt2Id);
	jclass jni_cs1Class = (*env)->GetObjectClass(env, cs1);
	jfieldID jni_cs1Id = (*env)->GetFieldID(env, jni_cs1Class, "val", "D");
	jdouble jni_cs1 = (*env)->GetDoubleField(env, cs1, jni_cs1Id);
	jclass jni_sn1Class = (*env)->GetObjectClass(env, sn1);
	jfieldID jni_sn1Id = (*env)->GetFieldID(env, jni_sn1Class, "val", "D");
	jdouble jni_sn1 = (*env)->GetDoubleField(env, sn1, jni_sn1Id);

	dlaev2_(&a, &b, &c, &jni_rt1, &jni_rt2, &jni_cs1, &jni_sn1);

	(*env)->SetDoubleField(env, rt1, jni_rt1Id, jni_rt1);
	(*env)->SetDoubleField(env, rt2, jni_rt2Id, jni_rt2);
	(*env)->SetDoubleField(env, cs1, jni_cs1Id, jni_cs1);
	(*env)->SetDoubleField(env, sn1, jni_sn1Id, jni_sn1);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaexc (JNIEnv * env, jobject calling_obj, jboolean wantq, jint n, jdoubleArray t, jint ldt, jdoubleArray q, jint ldq, jint j1, jint n1, jint n2, jdoubleArray work, jobject info){
	logical jni_wantq = (logical)wantq;
	jdouble * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlaexc_(&jni_wantq, &n, jni_t, &ldt, jni_q, &ldq, &j1, &n1, &n2, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlag2 (JNIEnv * env, jobject calling_obj, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdouble safmin, jobject scale1, jobject scale2, jobject wr1, jobject wr2, jobject wi){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_scale1Class = (*env)->GetObjectClass(env, scale1);
	jfieldID jni_scale1Id = (*env)->GetFieldID(env, jni_scale1Class, "val", "D");
	jdouble jni_scale1 = (*env)->GetDoubleField(env, scale1, jni_scale1Id);
	jclass jni_scale2Class = (*env)->GetObjectClass(env, scale2);
	jfieldID jni_scale2Id = (*env)->GetFieldID(env, jni_scale2Class, "val", "D");
	jdouble jni_scale2 = (*env)->GetDoubleField(env, scale2, jni_scale2Id);
	jclass jni_wr1Class = (*env)->GetObjectClass(env, wr1);
	jfieldID jni_wr1Id = (*env)->GetFieldID(env, jni_wr1Class, "val", "D");
	jdouble jni_wr1 = (*env)->GetDoubleField(env, wr1, jni_wr1Id);
	jclass jni_wr2Class = (*env)->GetObjectClass(env, wr2);
	jfieldID jni_wr2Id = (*env)->GetFieldID(env, jni_wr2Class, "val", "D");
	jdouble jni_wr2 = (*env)->GetDoubleField(env, wr2, jni_wr2Id);
	jclass jni_wiClass = (*env)->GetObjectClass(env, wi);
	jfieldID jni_wiId = (*env)->GetFieldID(env, jni_wiClass, "val", "D");
	jdouble jni_wi = (*env)->GetDoubleField(env, wi, jni_wiId);

	dlag2_(jni_a, &lda, jni_b, &ldb, &safmin, &jni_scale1, &jni_scale2, &jni_wr1, &jni_wr2, &jni_wi);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetDoubleField(env, scale1, jni_scale1Id, jni_scale1);
	(*env)->SetDoubleField(env, scale2, jni_scale2Id, jni_scale2);
	(*env)->SetDoubleField(env, wr1, jni_wr1Id, jni_wr1);
	(*env)->SetDoubleField(env, wr2, jni_wr2Id, jni_wr2);
	(*env)->SetDoubleField(env, wi, jni_wiId, jni_wi);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlags2 (JNIEnv * env, jobject calling_obj, jboolean upper, jdouble a1, jdouble a2, jdouble a3, jdouble b1, jdouble b2, jdouble b3, jobject csu, jobject snu, jobject csv, jobject snv, jobject csq, jobject snq){
	logical jni_upper = (logical)upper;
	jclass jni_csuClass = (*env)->GetObjectClass(env, csu);
	jfieldID jni_csuId = (*env)->GetFieldID(env, jni_csuClass, "val", "D");
	jdouble jni_csu = (*env)->GetDoubleField(env, csu, jni_csuId);
	jclass jni_snuClass = (*env)->GetObjectClass(env, snu);
	jfieldID jni_snuId = (*env)->GetFieldID(env, jni_snuClass, "val", "D");
	jdouble jni_snu = (*env)->GetDoubleField(env, snu, jni_snuId);
	jclass jni_csvClass = (*env)->GetObjectClass(env, csv);
	jfieldID jni_csvId = (*env)->GetFieldID(env, jni_csvClass, "val", "D");
	jdouble jni_csv = (*env)->GetDoubleField(env, csv, jni_csvId);
	jclass jni_snvClass = (*env)->GetObjectClass(env, snv);
	jfieldID jni_snvId = (*env)->GetFieldID(env, jni_snvClass, "val", "D");
	jdouble jni_snv = (*env)->GetDoubleField(env, snv, jni_snvId);
	jclass jni_csqClass = (*env)->GetObjectClass(env, csq);
	jfieldID jni_csqId = (*env)->GetFieldID(env, jni_csqClass, "val", "D");
	jdouble jni_csq = (*env)->GetDoubleField(env, csq, jni_csqId);
	jclass jni_snqClass = (*env)->GetObjectClass(env, snq);
	jfieldID jni_snqId = (*env)->GetFieldID(env, jni_snqClass, "val", "D");
	jdouble jni_snq = (*env)->GetDoubleField(env, snq, jni_snqId);

	dlags2_(&jni_upper, &a1, &a2, &a3, &b1, &b2, &b3, &jni_csu, &jni_snu, &jni_csv, &jni_snv, &jni_csq, &jni_snq);

	(*env)->SetDoubleField(env, csu, jni_csuId, jni_csu);
	(*env)->SetDoubleField(env, snu, jni_snuId, jni_snu);
	(*env)->SetDoubleField(env, csv, jni_csvId, jni_csv);
	(*env)->SetDoubleField(env, snv, jni_snvId, jni_snv);
	(*env)->SetDoubleField(env, csq, jni_csqId, jni_csq);
	(*env)->SetDoubleField(env, snq, jni_snqId, jni_snq);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlagtf (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray a, jdouble lambda, jdoubleArray b, jdoubleArray c, jdouble tol, jdoubleArray d, jintArray in, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jint * jni_in = (*env)->GetPrimitiveArrayCritical(env, in, JNI_FALSE);
	check_memory(env, jni_in);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlagtf_(&n, jni_a, &lambda, jni_b, jni_c, &tol, jni_d, jni_in, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, in, jni_in, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlagtm (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jdouble alpha, jdoubleArray dl, jdoubleArray d, jdoubleArray du, jdoubleArray x, jint ldx, jdouble beta, jdoubleArray b, jint ldb){
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
	check_memory(env, jni_dl);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
	check_memory(env, jni_du);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);

	dlagtm_(jni_trans, &n, &nrhs, &alpha, jni_dl, jni_d, jni_du, jni_x, &ldx, &beta, jni_b, &ldb);

	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlagts (JNIEnv * env, jobject calling_obj, jint job, jint n, jdoubleArray a, jdoubleArray b, jdoubleArray c, jdoubleArray d, jintArray in, jdoubleArray y, jobject tol, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jint * jni_in = (*env)->GetPrimitiveArrayCritical(env, in, JNI_FALSE);
	check_memory(env, jni_in);
	jdouble * jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
	check_memory(env, jni_y);
	jclass jni_tolClass = (*env)->GetObjectClass(env, tol);
	jfieldID jni_tolId = (*env)->GetFieldID(env, jni_tolClass, "val", "D");
	jdouble jni_tol = (*env)->GetDoubleField(env, tol, jni_tolId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlagts_(&job, &n, jni_a, jni_b, jni_c, jni_d, jni_in, jni_y, &jni_tol, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, in, jni_in, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
	(*env)->SetDoubleField(env, tol, jni_tolId, jni_tol);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlagv2 (JNIEnv * env, jobject calling_obj, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray alphar, jdoubleArray alphai, jdoubleArray beta, jobject csl, jobject snl, jobject csr, jobject snr){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
	check_memory(env, jni_alphar);
	jdouble * jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
	check_memory(env, jni_alphai);
	jdouble * jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
	check_memory(env, jni_beta);
	jclass jni_cslClass = (*env)->GetObjectClass(env, csl);
	jfieldID jni_cslId = (*env)->GetFieldID(env, jni_cslClass, "val", "D");
	jdouble jni_csl = (*env)->GetDoubleField(env, csl, jni_cslId);
	jclass jni_snlClass = (*env)->GetObjectClass(env, snl);
	jfieldID jni_snlId = (*env)->GetFieldID(env, jni_snlClass, "val", "D");
	jdouble jni_snl = (*env)->GetDoubleField(env, snl, jni_snlId);
	jclass jni_csrClass = (*env)->GetObjectClass(env, csr);
	jfieldID jni_csrId = (*env)->GetFieldID(env, jni_csrClass, "val", "D");
	jdouble jni_csr = (*env)->GetDoubleField(env, csr, jni_csrId);
	jclass jni_snrClass = (*env)->GetObjectClass(env, snr);
	jfieldID jni_snrId = (*env)->GetFieldID(env, jni_snrClass, "val", "D");
	jdouble jni_snr = (*env)->GetDoubleField(env, snr, jni_snrId);

	dlagv2_(jni_a, &lda, jni_b, &ldb, jni_alphar, jni_alphai, jni_beta, &jni_csl, &jni_snl, &jni_csr, &jni_snr);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
	(*env)->SetDoubleField(env, csl, jni_cslId, jni_csl);
	(*env)->SetDoubleField(env, snl, jni_snlId, jni_snl);
	(*env)->SetDoubleField(env, csr, jni_csrId, jni_csr);
	(*env)->SetDoubleField(env, snr, jni_snrId, jni_snr);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlahqr (JNIEnv * env, jobject calling_obj, jboolean wantt, jboolean wantz, jint n, jint ilo, jint ihi, jdoubleArray h, jint ldh, jdoubleArray wr, jdoubleArray wi, jint iloz, jint ihiz, jdoubleArray z, jint ldz, jobject info){
	logical jni_wantt = (logical)wantt;
	logical jni_wantz = (logical)wantz;
	jdouble * jni_h = (*env)->GetPrimitiveArrayCritical(env, h, JNI_FALSE);
	check_memory(env, jni_h);
	jdouble * jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
	check_memory(env, jni_wr);
	jdouble * jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
	check_memory(env, jni_wi);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlahqr_(&jni_wantt, &jni_wantz, &n, &ilo, &ihi, jni_h, &ldh, jni_wr, jni_wi, &iloz, &ihiz, jni_z, &ldz, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, h, jni_h, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlahrd (JNIEnv * env, jobject calling_obj, jint n, jint k, jint nb, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray t, jint ldt, jdoubleArray y, jint ldy){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);
	jdouble * jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
	check_memory(env, jni_y);

	dlahrd_(&n, &k, &nb, jni_a, &lda, jni_tau, jni_t, &ldt, jni_y, &ldy);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaic1 (JNIEnv * env, jobject calling_obj, jint job, jint j, jdoubleArray x, jdouble sest, jdoubleArray w, jdouble gamma, jobject sestpr, jobject s, jobject c){
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jclass jni_sestprClass = (*env)->GetObjectClass(env, sestpr);
	jfieldID jni_sestprId = (*env)->GetFieldID(env, jni_sestprClass, "val", "D");
	jdouble jni_sestpr = (*env)->GetDoubleField(env, sestpr, jni_sestprId);
	jclass jni_sClass = (*env)->GetObjectClass(env, s);
	jfieldID jni_sId = (*env)->GetFieldID(env, jni_sClass, "val", "D");
	jdouble jni_s = (*env)->GetDoubleField(env, s, jni_sId);
	jclass jni_cClass = (*env)->GetObjectClass(env, c);
	jfieldID jni_cId = (*env)->GetFieldID(env, jni_cClass, "val", "D");
	jdouble jni_c = (*env)->GetDoubleField(env, c, jni_cId);

	dlaic1_(&job, &j, jni_x, &sest, jni_w, &gamma, &jni_sestpr, &jni_s, &jni_c);

	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->SetDoubleField(env, sestpr, jni_sestprId, jni_sestpr);
	(*env)->SetDoubleField(env, s, jni_sId, jni_s);
	(*env)->SetDoubleField(env, c, jni_cId, jni_c);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaln2 (JNIEnv * env, jobject calling_obj, jboolean ltrans, jint na, jint nw, jdouble smin, jdouble ca, jdoubleArray a, jint lda, jdouble d1, jdouble d2, jdoubleArray b, jint ldb, jdouble wr, jdouble wi, jdoubleArray x, jint ldx, jobject scale, jobject xnorm, jobject info){
	logical jni_ltrans = (logical)ltrans;
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jdouble jni_scale = (*env)->GetDoubleField(env, scale, jni_scaleId);
	jclass jni_xnormClass = (*env)->GetObjectClass(env, xnorm);
	jfieldID jni_xnormId = (*env)->GetFieldID(env, jni_xnormClass, "val", "D");
	jdouble jni_xnorm = (*env)->GetDoubleField(env, xnorm, jni_xnormId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlaln2_(&jni_ltrans, &na, &nw, &smin, &ca, jni_a, &lda, &d1, &d2, jni_b, &ldb, &wr, &wi, jni_x, &ldx, &jni_scale, &jni_xnorm, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetDoubleField(env, scale, jni_scaleId, jni_scale);
	(*env)->SetDoubleField(env, xnorm, jni_xnormId, jni_xnorm);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlals0 (JNIEnv * env, jobject calling_obj, jint icompq, jint nl, jint nr, jint sqre, jint nrhs, jdoubleArray b, jint ldb, jdoubleArray bx, jint ldbx, jintArray perm, jint givptr, jintArray givcol, jint ldgcol, jdoubleArray givnum, jint ldgnum, jdoubleArray poles, jdoubleArray difl, jdoubleArray difr, jdoubleArray z, jint k, jdouble c, jdouble s, jdoubleArray work, jobject info){
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_bx = (*env)->GetPrimitiveArrayCritical(env, bx, JNI_FALSE);
	check_memory(env, jni_bx);
	jint * jni_perm = (*env)->GetPrimitiveArrayCritical(env, perm, JNI_FALSE);
	check_memory(env, jni_perm);
	jint * jni_givcol = (*env)->GetPrimitiveArrayCritical(env, givcol, JNI_FALSE);
	check_memory(env, jni_givcol);
	jdouble * jni_givnum = (*env)->GetPrimitiveArrayCritical(env, givnum, JNI_FALSE);
	check_memory(env, jni_givnum);
	jdouble * jni_poles = (*env)->GetPrimitiveArrayCritical(env, poles, JNI_FALSE);
	check_memory(env, jni_poles);
	jdouble * jni_difl = (*env)->GetPrimitiveArrayCritical(env, difl, JNI_FALSE);
	check_memory(env, jni_difl);
	jdouble * jni_difr = (*env)->GetPrimitiveArrayCritical(env, difr, JNI_FALSE);
	check_memory(env, jni_difr);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlals0_(&icompq, &nl, &nr, &sqre, &nrhs, jni_b, &ldb, jni_bx, &ldbx, jni_perm, &givptr, jni_givcol, &ldgcol, jni_givnum, &ldgnum, jni_poles, jni_difl, jni_difr, jni_z, &k, &c, &s, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, bx, jni_bx, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, perm, jni_perm, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givcol, jni_givcol, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givnum, jni_givnum, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, poles, jni_poles, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, difl, jni_difl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, difr, jni_difr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlalsa (JNIEnv * env, jobject calling_obj, jint icompq, jint smlsiz, jint n, jint nrhs, jdoubleArray b, jint ldb, jdoubleArray bx, jint ldbx, jdoubleArray u, jint ldu, jdoubleArray vt, jintArray k, jdoubleArray difl, jdoubleArray difr, jdoubleArray z, jdoubleArray poles, jintArray givptr, jintArray givcol, jint ldgcol, jintArray perm, jdoubleArray givnum, jdoubleArray c, jdoubleArray s, jdoubleArray work, jintArray iwork, jobject info){
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_bx = (*env)->GetPrimitiveArrayCritical(env, bx, JNI_FALSE);
	check_memory(env, jni_bx);
	jdouble * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jdouble * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jint * jni_k = (*env)->GetPrimitiveArrayCritical(env, k, JNI_FALSE);
	check_memory(env, jni_k);
	jdouble * jni_difl = (*env)->GetPrimitiveArrayCritical(env, difl, JNI_FALSE);
	check_memory(env, jni_difl);
	jdouble * jni_difr = (*env)->GetPrimitiveArrayCritical(env, difr, JNI_FALSE);
	check_memory(env, jni_difr);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_poles = (*env)->GetPrimitiveArrayCritical(env, poles, JNI_FALSE);
	check_memory(env, jni_poles);
	jint * jni_givptr = (*env)->GetPrimitiveArrayCritical(env, givptr, JNI_FALSE);
	check_memory(env, jni_givptr);
	jint * jni_givcol = (*env)->GetPrimitiveArrayCritical(env, givcol, JNI_FALSE);
	check_memory(env, jni_givcol);
	jint * jni_perm = (*env)->GetPrimitiveArrayCritical(env, perm, JNI_FALSE);
	check_memory(env, jni_perm);
	jdouble * jni_givnum = (*env)->GetPrimitiveArrayCritical(env, givnum, JNI_FALSE);
	check_memory(env, jni_givnum);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlalsa_(&icompq, &smlsiz, &n, &nrhs, jni_b, &ldb, jni_bx, &ldbx, jni_u, &ldu, jni_vt, jni_k, jni_difl, jni_difr, jni_z, jni_poles, jni_givptr, jni_givcol, &ldgcol, jni_perm, jni_givnum, jni_c, jni_s, jni_work, jni_iwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, bx, jni_bx, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, k, jni_k, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, difl, jni_difl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, difr, jni_difr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, poles, jni_poles, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givptr, jni_givptr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givcol, jni_givcol, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, perm, jni_perm, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givnum, jni_givnum, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlalsd (JNIEnv * env, jobject calling_obj, jstring uplo, jint smlsiz, jint n, jint nrhs, jdoubleArray d, jdoubleArray e, jdoubleArray b, jint ldb, jdouble rcond, jobject rank, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
	jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
	jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlalsd_(jni_uplo, &smlsiz, &n, &nrhs, jni_d, jni_e, jni_b, &ldb, &rcond, &jni_rank, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, rank, jni_rankId, jni_rank);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlamrg (JNIEnv * env, jobject calling_obj, jint n1, jint n2, jdoubleArray a, jint dtrd1, jint dtrd2, jintArray index){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_index = (*env)->GetPrimitiveArrayCritical(env, index, JNI_FALSE);
	check_memory(env, jni_index);

	dlamrg_(&n1, &n2, jni_a, &dtrd1, &dtrd2, jni_index);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, index, jni_index, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlanv2 (JNIEnv * env, jobject calling_obj, jobject a, jobject b, jobject c, jobject d, jobject rt1r, jobject rt1i, jobject rt2r, jobject rt2i, jobject cs, jobject sn){
	jclass jni_aClass = (*env)->GetObjectClass(env, a);
	jfieldID jni_aId = (*env)->GetFieldID(env, jni_aClass, "val", "D");
	jdouble jni_a = (*env)->GetDoubleField(env, a, jni_aId);
	jclass jni_bClass = (*env)->GetObjectClass(env, b);
	jfieldID jni_bId = (*env)->GetFieldID(env, jni_bClass, "val", "D");
	jdouble jni_b = (*env)->GetDoubleField(env, b, jni_bId);
	jclass jni_cClass = (*env)->GetObjectClass(env, c);
	jfieldID jni_cId = (*env)->GetFieldID(env, jni_cClass, "val", "D");
	jdouble jni_c = (*env)->GetDoubleField(env, c, jni_cId);
	jclass jni_dClass = (*env)->GetObjectClass(env, d);
	jfieldID jni_dId = (*env)->GetFieldID(env, jni_dClass, "val", "D");
	jdouble jni_d = (*env)->GetDoubleField(env, d, jni_dId);
	jclass jni_rt1rClass = (*env)->GetObjectClass(env, rt1r);
	jfieldID jni_rt1rId = (*env)->GetFieldID(env, jni_rt1rClass, "val", "D");
	jdouble jni_rt1r = (*env)->GetDoubleField(env, rt1r, jni_rt1rId);
	jclass jni_rt1iClass = (*env)->GetObjectClass(env, rt1i);
	jfieldID jni_rt1iId = (*env)->GetFieldID(env, jni_rt1iClass, "val", "D");
	jdouble jni_rt1i = (*env)->GetDoubleField(env, rt1i, jni_rt1iId);
	jclass jni_rt2rClass = (*env)->GetObjectClass(env, rt2r);
	jfieldID jni_rt2rId = (*env)->GetFieldID(env, jni_rt2rClass, "val", "D");
	jdouble jni_rt2r = (*env)->GetDoubleField(env, rt2r, jni_rt2rId);
	jclass jni_rt2iClass = (*env)->GetObjectClass(env, rt2i);
	jfieldID jni_rt2iId = (*env)->GetFieldID(env, jni_rt2iClass, "val", "D");
	jdouble jni_rt2i = (*env)->GetDoubleField(env, rt2i, jni_rt2iId);
	jclass jni_csClass = (*env)->GetObjectClass(env, cs);
	jfieldID jni_csId = (*env)->GetFieldID(env, jni_csClass, "val", "D");
	jdouble jni_cs = (*env)->GetDoubleField(env, cs, jni_csId);
	jclass jni_snClass = (*env)->GetObjectClass(env, sn);
	jfieldID jni_snId = (*env)->GetFieldID(env, jni_snClass, "val", "D");
	jdouble jni_sn = (*env)->GetDoubleField(env, sn, jni_snId);

	dlanv2_(&jni_a, &jni_b, &jni_c, &jni_d, &jni_rt1r, &jni_rt1i, &jni_rt2r, &jni_rt2i, &jni_cs, &jni_sn);

	(*env)->SetDoubleField(env, a, jni_aId, jni_a);
	(*env)->SetDoubleField(env, b, jni_bId, jni_b);
	(*env)->SetDoubleField(env, c, jni_cId, jni_c);
	(*env)->SetDoubleField(env, d, jni_dId, jni_d);
	(*env)->SetDoubleField(env, rt1r, jni_rt1rId, jni_rt1r);
	(*env)->SetDoubleField(env, rt1i, jni_rt1iId, jni_rt1i);
	(*env)->SetDoubleField(env, rt2r, jni_rt2rId, jni_rt2r);
	(*env)->SetDoubleField(env, rt2i, jni_rt2iId, jni_rt2i);
	(*env)->SetDoubleField(env, cs, jni_csId, jni_cs);
	(*env)->SetDoubleField(env, sn, jni_snId, jni_sn);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlapll (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray x, jint incx, jdoubleArray y, jint incy, jobject ssmin){
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
	check_memory(env, jni_y);
	jclass jni_ssminClass = (*env)->GetObjectClass(env, ssmin);
	jfieldID jni_ssminId = (*env)->GetFieldID(env, jni_ssminClass, "val", "D");
	jdouble jni_ssmin = (*env)->GetDoubleField(env, ssmin, jni_ssminId);

	dlapll_(&n, jni_x, &incx, jni_y, &incy, &jni_ssmin);

	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
	(*env)->SetDoubleField(env, ssmin, jni_ssminId, jni_ssmin);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlapmt (JNIEnv * env, jobject calling_obj, jboolean forwrd, jint m, jint n, jdoubleArray x, jint ldx, jintArray k){
	logical jni_forwrd = (logical)forwrd;
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jint * jni_k = (*env)->GetPrimitiveArrayCritical(env, k, JNI_FALSE);
	check_memory(env, jni_k);

	dlapmt_(&jni_forwrd, &m, &n, jni_x, &ldx, jni_k);

	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, k, jni_k, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaqgb (JNIEnv * env, jobject calling_obj, jint m, jint n, jint kl, jint ku, jdoubleArray ab, jint ldab, jdoubleArray r, jdoubleArray c, jdouble rowcnd, jdouble colcnd, jdouble amax, jobject equed){
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
	check_memory(env, jni_r);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
	jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
	jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
	char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);

	dlaqgb_(&m, &n, &kl, &ku, jni_ab, &ldab, jni_r, jni_c, &rowcnd, &colcnd, &amax, jni_equed);

	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	jstring jni_equedStringNew = (*env)->NewStringUTF(env, jni_equed);
	(*env)->SetObjectField(env, equed, jni_equedId, jni_equedStringNew);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaqge (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray r, jdoubleArray c, jdouble rowcnd, jdouble colcnd, jdouble amax, jobject equed){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
	check_memory(env, jni_r);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
	jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
	jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
	char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);

	dlaqge_(&m, &n, jni_a, &lda, jni_r, jni_c, &rowcnd, &colcnd, &amax, jni_equed);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	jstring jni_equedStringNew = (*env)->NewStringUTF(env, jni_equed);
	(*env)->SetObjectField(env, equed, jni_equedId, jni_equedStringNew);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaqp2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jint offset, jdoubleArray a, jint lda, jintArray jpvt, jdoubleArray tau, jdoubleArray vn1, jdoubleArray vn2, jdoubleArray work){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
	check_memory(env, jni_jpvt);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_vn1 = (*env)->GetPrimitiveArrayCritical(env, vn1, JNI_FALSE);
	check_memory(env, jni_vn1);
	jdouble * jni_vn2 = (*env)->GetPrimitiveArrayCritical(env, vn2, JNI_FALSE);
	check_memory(env, jni_vn2);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);

	dlaqp2_(&m, &n, &offset, jni_a, &lda, jni_jpvt, jni_tau, jni_vn1, jni_vn2, jni_work);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vn1, jni_vn1, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vn2, jni_vn2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaqps (JNIEnv * env, jobject calling_obj, jint m, jint n, jint offset, jint nb, jobject kb, jdoubleArray a, jint lda, jintArray jpvt, jdoubleArray tau, jdoubleArray vn1, jdoubleArray vn2, jdoubleArray auxv, jdoubleArray f, jint ldf){
	jclass jni_kbClass = (*env)->GetObjectClass(env, kb);
	jfieldID jni_kbId = (*env)->GetFieldID(env, jni_kbClass, "val", "I");
	jint jni_kb = (*env)->GetIntField(env, kb, jni_kbId);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
	check_memory(env, jni_jpvt);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_vn1 = (*env)->GetPrimitiveArrayCritical(env, vn1, JNI_FALSE);
	check_memory(env, jni_vn1);
	jdouble * jni_vn2 = (*env)->GetPrimitiveArrayCritical(env, vn2, JNI_FALSE);
	check_memory(env, jni_vn2);
	jdouble * jni_auxv = (*env)->GetPrimitiveArrayCritical(env, auxv, JNI_FALSE);
	check_memory(env, jni_auxv);
	jdouble * jni_f = (*env)->GetPrimitiveArrayCritical(env, f, JNI_FALSE);
	check_memory(env, jni_f);

	dlaqps_(&m, &n, &offset, &nb, &jni_kb, jni_a, &lda, jni_jpvt, jni_tau, jni_vn1, jni_vn2, jni_auxv, jni_f, &ldf);

	(*env)->SetIntField(env, kb, jni_kbId, jni_kb);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vn1, jni_vn1, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vn2, jni_vn2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, auxv, jni_auxv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, f, jni_f, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaqsb (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jdoubleArray ab, jint ldab, jdoubleArray s, jdouble scond, jdouble amax, jobject equed){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
	jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
	jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
	char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);

	dlaqsb_(jni_uplo, &n, &kd, jni_ab, &ldab, jni_s, &scond, &amax, jni_equed);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	jstring jni_equedStringNew = (*env)->NewStringUTF(env, jni_equed);
	(*env)->SetObjectField(env, equed, jni_equedId, jni_equedStringNew);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaqsp (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jdoubleArray s, jdouble scond, jdouble amax, jobject equed){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
	jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
	jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
	char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);

	dlaqsp_(jni_uplo, &n, jni_ap, jni_s, &scond, &amax, jni_equed);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	jstring jni_equedStringNew = (*env)->NewStringUTF(env, jni_equed);
	(*env)->SetObjectField(env, equed, jni_equedId, jni_equedStringNew);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaqsy (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jdoubleArray s, jdouble scond, jdouble amax, jobject equed){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
	jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
	jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
	char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);

	dlaqsy_(jni_uplo, &n, jni_a, &lda, jni_s, &scond, &amax, jni_equed);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	jstring jni_equedStringNew = (*env)->NewStringUTF(env, jni_equed);
	(*env)->SetObjectField(env, equed, jni_equedId, jni_equedStringNew);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaqtr (JNIEnv * env, jobject calling_obj, jboolean ltran, jboolean lreal, jint n, jdoubleArray t, jint ldt, jdoubleArray b, jdouble w, jobject scale, jdoubleArray x, jdoubleArray work, jobject info){
	logical jni_ltran = (logical)ltran;
	logical jni_lreal = (logical)lreal;
	jdouble * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jdouble jni_scale = (*env)->GetDoubleField(env, scale, jni_scaleId);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlaqtr_(&jni_ltran, &jni_lreal, &n, jni_t, &ldt, jni_b, &w, &jni_scale, jni_x, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetDoubleField(env, scale, jni_scaleId, jni_scale);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlar2v (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray x, jdoubleArray y, jdoubleArray z, jint incx, jdoubleArray c, jdoubleArray s, jint incc){
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
	check_memory(env, jni_y);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);

	dlar2v_(&n, jni_x, jni_y, jni_z, &incx, jni_c, jni_s, &incc);

	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlarf (JNIEnv * env, jobject calling_obj, jstring side, jint m, jint n, jdoubleArray v, jint incv, jdouble tau, jdoubleArray c, jint Ldc, jdoubleArray work){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	jdouble * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);

	dlarf_(jni_side, &m, &n, jni_v, &incv, &tau, jni_c, &Ldc, jni_work);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlarfb (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jstring direct, jstring storev, jint m, jint n, jint k, jdoubleArray v, jint ldv, jdoubleArray t, jint ldt, jdoubleArray c, jint Ldc, jdoubleArray work, jint ldwork){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_direct = (char *)(*env)->GetStringUTFChars(env, direct, JNI_FALSE);
	char * jni_storev = (char *)(*env)->GetStringUTFChars(env, storev, JNI_FALSE);
	jdouble * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jdouble * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);

	dlarfb_(jni_side, jni_trans, jni_direct, jni_storev, &m, &n, &k, jni_v, &ldv, jni_t, &ldt, jni_c, &Ldc, jni_work, &ldwork);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, direct, jni_direct);
	(*env)->ReleaseStringUTFChars(env, storev, jni_storev);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlarfg (JNIEnv * env, jobject calling_obj, jint n, jobject alpha, jdoubleArray x, jint incx, jobject tau){
	jclass jni_alphaClass = (*env)->GetObjectClass(env, alpha);
	jfieldID jni_alphaId = (*env)->GetFieldID(env, jni_alphaClass, "val", "D");
	jdouble jni_alpha = (*env)->GetDoubleField(env, alpha, jni_alphaId);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_tauClass = (*env)->GetObjectClass(env, tau);
	jfieldID jni_tauId = (*env)->GetFieldID(env, jni_tauClass, "val", "D");
	jdouble jni_tau = (*env)->GetDoubleField(env, tau, jni_tauId);

	dlarfg_(&n, &jni_alpha, jni_x, &incx, &jni_tau);

	(*env)->SetDoubleField(env, alpha, jni_alphaId, jni_alpha);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetDoubleField(env, tau, jni_tauId, jni_tau);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlarft (JNIEnv * env, jobject calling_obj, jstring direct, jstring storev, jint n, jint k, jdoubleArray v, jint ldv, jdoubleArray tau, jdoubleArray t, jint ldt){
	char * jni_direct = (char *)(*env)->GetStringUTFChars(env, direct, JNI_FALSE);
	char * jni_storev = (char *)(*env)->GetStringUTFChars(env, storev, JNI_FALSE);
	jdouble * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);

	dlarft_(jni_direct, jni_storev, &n, &k, jni_v, &ldv, jni_tau, jni_t, &ldt);

	(*env)->ReleaseStringUTFChars(env, direct, jni_direct);
	(*env)->ReleaseStringUTFChars(env, storev, jni_storev);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlarfx (JNIEnv * env, jobject calling_obj, jstring side, jint m, jint n, jdoubleArray v, jdouble tau, jdoubleArray c, jint Ldc, jdoubleArray work){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	jdouble * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);

	dlarfx_(jni_side, &m, &n, jni_v, &tau, jni_c, &Ldc, jni_work);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlargv (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray x, jint incx, jdoubleArray y, jint incy, jdoubleArray c, jint incc){
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
	check_memory(env, jni_y);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);

	dlargv_(&n, jni_x, &incx, jni_y, &incy, jni_c, &incc);

	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlarnv (JNIEnv * env, jobject calling_obj, jint idist, jintArray iseed, jint n, jdoubleArray x){
	jint * jni_iseed = (*env)->GetPrimitiveArrayCritical(env, iseed, JNI_FALSE);
	check_memory(env, jni_iseed);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);

	dlarnv_(&idist, jni_iseed, &n, jni_x);

	(*env)->ReleasePrimitiveArrayCritical(env, iseed, jni_iseed, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlartg (JNIEnv * env, jobject calling_obj, jdouble f, jdouble g, jobject cs, jobject sn, jobject r){
	jclass jni_csClass = (*env)->GetObjectClass(env, cs);
	jfieldID jni_csId = (*env)->GetFieldID(env, jni_csClass, "val", "D");
	jdouble jni_cs = (*env)->GetDoubleField(env, cs, jni_csId);
	jclass jni_snClass = (*env)->GetObjectClass(env, sn);
	jfieldID jni_snId = (*env)->GetFieldID(env, jni_snClass, "val", "D");
	jdouble jni_sn = (*env)->GetDoubleField(env, sn, jni_snId);
	jclass jni_rClass = (*env)->GetObjectClass(env, r);
	jfieldID jni_rId = (*env)->GetFieldID(env, jni_rClass, "val", "D");
	jdouble jni_r = (*env)->GetDoubleField(env, r, jni_rId);

	dlartg_(&f, &g, &jni_cs, &jni_sn, &jni_r);

	(*env)->SetDoubleField(env, cs, jni_csId, jni_cs);
	(*env)->SetDoubleField(env, sn, jni_snId, jni_sn);
	(*env)->SetDoubleField(env, r, jni_rId, jni_r);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlartv (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray x, jint incx, jdoubleArray y, jint incy, jdoubleArray c, jdoubleArray s, jint incc){
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
	check_memory(env, jni_y);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);

	dlartv_(&n, jni_x, &incx, jni_y, &incy, jni_c, jni_s, &incc);

	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaruv (JNIEnv * env, jobject calling_obj, jintArray iseed, jint n, jdoubleArray x){
	jint * jni_iseed = (*env)->GetPrimitiveArrayCritical(env, iseed, JNI_FALSE);
	check_memory(env, jni_iseed);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);

	dlaruv_(jni_iseed, &n, jni_x);

	(*env)->ReleasePrimitiveArrayCritical(env, iseed, jni_iseed, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlarz (JNIEnv * env, jobject calling_obj, jstring side, jint m, jint n, jint l, jdoubleArray v, jint incv, jdouble tau, jdoubleArray c, jint Ldc, jdoubleArray work){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	jdouble * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);

	dlarz_(jni_side, &m, &n, &l, jni_v, &incv, &tau, jni_c, &Ldc, jni_work);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlarzb (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jstring direct, jstring storev, jint m, jint n, jint k, jint l, jdoubleArray v, jint ldv, jdoubleArray t, jint ldt, jdoubleArray c, jint Ldc, jdoubleArray work, jint ldwork){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_direct = (char *)(*env)->GetStringUTFChars(env, direct, JNI_FALSE);
	char * jni_storev = (char *)(*env)->GetStringUTFChars(env, storev, JNI_FALSE);
	jdouble * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jdouble * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);

	dlarzb_(jni_side, jni_trans, jni_direct, jni_storev, &m, &n, &k, &l, jni_v, &ldv, jni_t, &ldt, jni_c, &Ldc, jni_work, &ldwork);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, direct, jni_direct);
	(*env)->ReleaseStringUTFChars(env, storev, jni_storev);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlarzt (JNIEnv * env, jobject calling_obj, jstring direct, jstring storev, jint n, jint k, jdoubleArray v, jint ldv, jdoubleArray tau, jdoubleArray t, jint ldt){
	char * jni_direct = (char *)(*env)->GetStringUTFChars(env, direct, JNI_FALSE);
	char * jni_storev = (char *)(*env)->GetStringUTFChars(env, storev, JNI_FALSE);
	jdouble * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);

	dlarzt_(jni_direct, jni_storev, &n, &k, jni_v, &ldv, jni_tau, jni_t, &ldt);

	(*env)->ReleaseStringUTFChars(env, direct, jni_direct);
	(*env)->ReleaseStringUTFChars(env, storev, jni_storev);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlas2 (JNIEnv * env, jobject calling_obj, jdouble f, jdouble g, jdouble h, jobject ssmin, jobject ssmax){
	jclass jni_ssminClass = (*env)->GetObjectClass(env, ssmin);
	jfieldID jni_ssminId = (*env)->GetFieldID(env, jni_ssminClass, "val", "D");
	jdouble jni_ssmin = (*env)->GetDoubleField(env, ssmin, jni_ssminId);
	jclass jni_ssmaxClass = (*env)->GetObjectClass(env, ssmax);
	jfieldID jni_ssmaxId = (*env)->GetFieldID(env, jni_ssmaxClass, "val", "D");
	jdouble jni_ssmax = (*env)->GetDoubleField(env, ssmax, jni_ssmaxId);

	dlas2_(&f, &g, &h, &jni_ssmin, &jni_ssmax);

	(*env)->SetDoubleField(env, ssmin, jni_ssminId, jni_ssmin);
	(*env)->SetDoubleField(env, ssmax, jni_ssmaxId, jni_ssmax);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlascl (JNIEnv * env, jobject calling_obj, jstring type, jint kl, jint ku, jdouble cfrom, jdouble cto, jint m, jint n, jdoubleArray a, jint lda, jobject info){
	char * jni_type = (char *)(*env)->GetStringUTFChars(env, type, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlascl_(jni_type, &kl, &ku, &cfrom, &cto, &m, &n, jni_a, &lda, &jni_info);

	(*env)->ReleaseStringUTFChars(env, type, jni_type);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasd0 (JNIEnv * env, jobject calling_obj, jint n, jint sqre, jdoubleArray d, jdoubleArray e, jdoubleArray u, jint ldu, jdoubleArray vt, jint ldvt, jint smlsiz, jintArray iwork, jdoubleArray work, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jdouble * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlasd0_(&n, &sqre, jni_d, jni_e, jni_u, &ldu, jni_vt, &ldvt, &smlsiz, jni_iwork, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasd1 (JNIEnv * env, jobject calling_obj, jint nl, jint nr, jint sqre, jdoubleArray d, jobject alpha, jobject beta, jdoubleArray u, jint ldu, jdoubleArray vt, jint ldvt, jintArray idxq, jintArray iwork, jdoubleArray work, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jclass jni_alphaClass = (*env)->GetObjectClass(env, alpha);
	jfieldID jni_alphaId = (*env)->GetFieldID(env, jni_alphaClass, "val", "D");
	jdouble jni_alpha = (*env)->GetDoubleField(env, alpha, jni_alphaId);
	jclass jni_betaClass = (*env)->GetObjectClass(env, beta);
	jfieldID jni_betaId = (*env)->GetFieldID(env, jni_betaClass, "val", "D");
	jdouble jni_beta = (*env)->GetDoubleField(env, beta, jni_betaId);
	jdouble * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jdouble * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jint * jni_idxq = (*env)->GetPrimitiveArrayCritical(env, idxq, JNI_FALSE);
	check_memory(env, jni_idxq);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlasd1_(&nl, &nr, &sqre, jni_d, &jni_alpha, &jni_beta, jni_u, &ldu, jni_vt, &ldvt, jni_idxq, jni_iwork, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->SetDoubleField(env, alpha, jni_alphaId, jni_alpha);
	(*env)->SetDoubleField(env, beta, jni_betaId, jni_beta);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, idxq, jni_idxq, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasd2 (JNIEnv * env, jobject calling_obj, jint nl, jint nr, jint sqre, jobject k, jdoubleArray d, jdoubleArray z, jdouble alpha, jdouble beta, jdoubleArray u, jint ldu, jdoubleArray vt, jint ldvt, jdoubleArray dsigma, jdoubleArray u2, jint ldu2, jdoubleArray vt2, jint ldvt2, jintArray idxp, jintArray idx, jintArray idxc, jintArray idxq, jintArray coltyp, jobject info){
	jclass jni_kClass = (*env)->GetObjectClass(env, k);
	jfieldID jni_kId = (*env)->GetFieldID(env, jni_kClass, "val", "I");
	jint jni_k = (*env)->GetIntField(env, k, jni_kId);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jdouble * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jdouble * jni_dsigma = (*env)->GetPrimitiveArrayCritical(env, dsigma, JNI_FALSE);
	check_memory(env, jni_dsigma);
	jdouble * jni_u2 = (*env)->GetPrimitiveArrayCritical(env, u2, JNI_FALSE);
	check_memory(env, jni_u2);
	jdouble * jni_vt2 = (*env)->GetPrimitiveArrayCritical(env, vt2, JNI_FALSE);
	check_memory(env, jni_vt2);
	jint * jni_idxp = (*env)->GetPrimitiveArrayCritical(env, idxp, JNI_FALSE);
	check_memory(env, jni_idxp);
	jint * jni_idx = (*env)->GetPrimitiveArrayCritical(env, idx, JNI_FALSE);
	check_memory(env, jni_idx);
	jint * jni_idxc = (*env)->GetPrimitiveArrayCritical(env, idxc, JNI_FALSE);
	check_memory(env, jni_idxc);
	jint * jni_idxq = (*env)->GetPrimitiveArrayCritical(env, idxq, JNI_FALSE);
	check_memory(env, jni_idxq);
	jint * jni_coltyp = (*env)->GetPrimitiveArrayCritical(env, coltyp, JNI_FALSE);
	check_memory(env, jni_coltyp);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlasd2_(&nl, &nr, &sqre, &jni_k, jni_d, jni_z, &alpha, &beta, jni_u, &ldu, jni_vt, &ldvt, jni_dsigma, jni_u2, &ldu2, jni_vt2, &ldvt2, jni_idxp, jni_idx, jni_idxc, jni_idxq, jni_coltyp, &jni_info);

	(*env)->SetIntField(env, k, jni_kId, jni_k);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dsigma, jni_dsigma, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u2, jni_u2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt2, jni_vt2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, idxp, jni_idxp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, idx, jni_idx, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, idxc, jni_idxc, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, idxq, jni_idxq, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, coltyp, jni_coltyp, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasd3 (JNIEnv * env, jobject calling_obj, jint nl, jint nr, jint sqre, jint k, jdoubleArray d, jdoubleArray q, jint ldq, jdoubleArray dsigma, jdoubleArray u, jint ldu, jdoubleArray u2, jint ldu2, jdoubleArray vt, jint ldvt, jdoubleArray vt2, jint ldvt2, jintArray idxc, jintArray ctot, jdoubleArray z, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jdouble * jni_dsigma = (*env)->GetPrimitiveArrayCritical(env, dsigma, JNI_FALSE);
	check_memory(env, jni_dsigma);
	jdouble * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jdouble * jni_u2 = (*env)->GetPrimitiveArrayCritical(env, u2, JNI_FALSE);
	check_memory(env, jni_u2);
	jdouble * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jdouble * jni_vt2 = (*env)->GetPrimitiveArrayCritical(env, vt2, JNI_FALSE);
	check_memory(env, jni_vt2);
	jint * jni_idxc = (*env)->GetPrimitiveArrayCritical(env, idxc, JNI_FALSE);
	check_memory(env, jni_idxc);
	jint * jni_ctot = (*env)->GetPrimitiveArrayCritical(env, ctot, JNI_FALSE);
	check_memory(env, jni_ctot);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlasd3_(&nl, &nr, &sqre, &k, jni_d, jni_q, &ldq, jni_dsigma, jni_u, &ldu, jni_u2, &ldu2, jni_vt, &ldvt, jni_vt2, &ldvt2, jni_idxc, jni_ctot, jni_z, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dsigma, jni_dsigma, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u2, jni_u2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt2, jni_vt2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, idxc, jni_idxc, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ctot, jni_ctot, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasd4 (JNIEnv * env, jobject calling_obj, jint n, jint i, jdoubleArray d, jdoubleArray z, jdoubleArray delta, jdouble rho, jobject sigma, jdoubleArray work, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_delta = (*env)->GetPrimitiveArrayCritical(env, delta, JNI_FALSE);
	check_memory(env, jni_delta);
	jclass jni_sigmaClass = (*env)->GetObjectClass(env, sigma);
	jfieldID jni_sigmaId = (*env)->GetFieldID(env, jni_sigmaClass, "val", "D");
	jdouble jni_sigma = (*env)->GetDoubleField(env, sigma, jni_sigmaId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlasd4_(&n, &i, jni_d, jni_z, jni_delta, &rho, &jni_sigma, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, delta, jni_delta, 0);
	(*env)->SetDoubleField(env, sigma, jni_sigmaId, jni_sigma);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasd5 (JNIEnv * env, jobject calling_obj, jint i, jdoubleArray d, jdoubleArray z, jdoubleArray delta, jdouble rho, jobject dsigma, jdoubleArray work){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_delta = (*env)->GetPrimitiveArrayCritical(env, delta, JNI_FALSE);
	check_memory(env, jni_delta);
	jclass jni_dsigmaClass = (*env)->GetObjectClass(env, dsigma);
	jfieldID jni_dsigmaId = (*env)->GetFieldID(env, jni_dsigmaClass, "val", "D");
	jdouble jni_dsigma = (*env)->GetDoubleField(env, dsigma, jni_dsigmaId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);

	dlasd5_(&i, jni_d, jni_z, jni_delta, &rho, &jni_dsigma, jni_work);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, delta, jni_delta, 0);
	(*env)->SetDoubleField(env, dsigma, jni_dsigmaId, jni_dsigma);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasd6 (JNIEnv * env, jobject calling_obj, jint icompq, jint nl, jint nr, jint sqre, jdoubleArray d, jdoubleArray vf, jdoubleArray vl, jobject alpha, jobject beta, jintArray idxq, jintArray perm, jobject givptr, jintArray givcol, jint ldgcol, jdoubleArray givnum, jint ldgnum, jdoubleArray poles, jdoubleArray difl, jdoubleArray difr, jdoubleArray z, jobject k, jobject c, jobject s, jdoubleArray work, jintArray iwork, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_vf = (*env)->GetPrimitiveArrayCritical(env, vf, JNI_FALSE);
	check_memory(env, jni_vf);
	jdouble * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jclass jni_alphaClass = (*env)->GetObjectClass(env, alpha);
	jfieldID jni_alphaId = (*env)->GetFieldID(env, jni_alphaClass, "val", "D");
	jdouble jni_alpha = (*env)->GetDoubleField(env, alpha, jni_alphaId);
	jclass jni_betaClass = (*env)->GetObjectClass(env, beta);
	jfieldID jni_betaId = (*env)->GetFieldID(env, jni_betaClass, "val", "D");
	jdouble jni_beta = (*env)->GetDoubleField(env, beta, jni_betaId);
	jint * jni_idxq = (*env)->GetPrimitiveArrayCritical(env, idxq, JNI_FALSE);
	check_memory(env, jni_idxq);
	jint * jni_perm = (*env)->GetPrimitiveArrayCritical(env, perm, JNI_FALSE);
	check_memory(env, jni_perm);
	jclass jni_givptrClass = (*env)->GetObjectClass(env, givptr);
	jfieldID jni_givptrId = (*env)->GetFieldID(env, jni_givptrClass, "val", "I");
	jint jni_givptr = (*env)->GetIntField(env, givptr, jni_givptrId);
	jint * jni_givcol = (*env)->GetPrimitiveArrayCritical(env, givcol, JNI_FALSE);
	check_memory(env, jni_givcol);
	jdouble * jni_givnum = (*env)->GetPrimitiveArrayCritical(env, givnum, JNI_FALSE);
	check_memory(env, jni_givnum);
	jdouble * jni_poles = (*env)->GetPrimitiveArrayCritical(env, poles, JNI_FALSE);
	check_memory(env, jni_poles);
	jdouble * jni_difl = (*env)->GetPrimitiveArrayCritical(env, difl, JNI_FALSE);
	check_memory(env, jni_difl);
	jdouble * jni_difr = (*env)->GetPrimitiveArrayCritical(env, difr, JNI_FALSE);
	check_memory(env, jni_difr);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_kClass = (*env)->GetObjectClass(env, k);
	jfieldID jni_kId = (*env)->GetFieldID(env, jni_kClass, "val", "I");
	jint jni_k = (*env)->GetIntField(env, k, jni_kId);
	jclass jni_cClass = (*env)->GetObjectClass(env, c);
	jfieldID jni_cId = (*env)->GetFieldID(env, jni_cClass, "val", "D");
	jdouble jni_c = (*env)->GetDoubleField(env, c, jni_cId);
	jclass jni_sClass = (*env)->GetObjectClass(env, s);
	jfieldID jni_sId = (*env)->GetFieldID(env, jni_sClass, "val", "D");
	jdouble jni_s = (*env)->GetDoubleField(env, s, jni_sId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlasd6_(&icompq, &nl, &nr, &sqre, jni_d, jni_vf, jni_vl, &jni_alpha, &jni_beta, jni_idxq, jni_perm, &jni_givptr, jni_givcol, &ldgcol, jni_givnum, &ldgnum, jni_poles, jni_difl, jni_difr, jni_z, &jni_k, &jni_c, &jni_s, jni_work, jni_iwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vf, jni_vf, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->SetDoubleField(env, alpha, jni_alphaId, jni_alpha);
	(*env)->SetDoubleField(env, beta, jni_betaId, jni_beta);
	(*env)->ReleasePrimitiveArrayCritical(env, idxq, jni_idxq, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, perm, jni_perm, 0);
	(*env)->SetIntField(env, givptr, jni_givptrId, jni_givptr);
	(*env)->ReleasePrimitiveArrayCritical(env, givcol, jni_givcol, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givnum, jni_givnum, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, poles, jni_poles, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, difl, jni_difl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, difr, jni_difr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetIntField(env, k, jni_kId, jni_k);
	(*env)->SetDoubleField(env, c, jni_cId, jni_c);
	(*env)->SetDoubleField(env, s, jni_sId, jni_s);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasd7 (JNIEnv * env, jobject calling_obj, jint icompq, jint nl, jint nr, jint sqre, jobject k, jdoubleArray d, jdoubleArray z, jdoubleArray zw, jdoubleArray vf, jdoubleArray vfw, jdoubleArray vl, jdoubleArray vlw, jdouble alpha, jdouble beta, jdoubleArray dsigma, jintArray idx, jintArray idxp, jintArray idxq, jintArray perm, jobject givptr, jintArray givcol, jint ldgcol, jdoubleArray givnum, jint ldgnum, jobject c, jobject s, jobject info){
	jclass jni_kClass = (*env)->GetObjectClass(env, k);
	jfieldID jni_kId = (*env)->GetFieldID(env, jni_kClass, "val", "I");
	jint jni_k = (*env)->GetIntField(env, k, jni_kId);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_zw = (*env)->GetPrimitiveArrayCritical(env, zw, JNI_FALSE);
	check_memory(env, jni_zw);
	jdouble * jni_vf = (*env)->GetPrimitiveArrayCritical(env, vf, JNI_FALSE);
	check_memory(env, jni_vf);
	jdouble * jni_vfw = (*env)->GetPrimitiveArrayCritical(env, vfw, JNI_FALSE);
	check_memory(env, jni_vfw);
	jdouble * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jdouble * jni_vlw = (*env)->GetPrimitiveArrayCritical(env, vlw, JNI_FALSE);
	check_memory(env, jni_vlw);
	jdouble * jni_dsigma = (*env)->GetPrimitiveArrayCritical(env, dsigma, JNI_FALSE);
	check_memory(env, jni_dsigma);
	jint * jni_idx = (*env)->GetPrimitiveArrayCritical(env, idx, JNI_FALSE);
	check_memory(env, jni_idx);
	jint * jni_idxp = (*env)->GetPrimitiveArrayCritical(env, idxp, JNI_FALSE);
	check_memory(env, jni_idxp);
	jint * jni_idxq = (*env)->GetPrimitiveArrayCritical(env, idxq, JNI_FALSE);
	check_memory(env, jni_idxq);
	jint * jni_perm = (*env)->GetPrimitiveArrayCritical(env, perm, JNI_FALSE);
	check_memory(env, jni_perm);
	jclass jni_givptrClass = (*env)->GetObjectClass(env, givptr);
	jfieldID jni_givptrId = (*env)->GetFieldID(env, jni_givptrClass, "val", "I");
	jint jni_givptr = (*env)->GetIntField(env, givptr, jni_givptrId);
	jint * jni_givcol = (*env)->GetPrimitiveArrayCritical(env, givcol, JNI_FALSE);
	check_memory(env, jni_givcol);
	jdouble * jni_givnum = (*env)->GetPrimitiveArrayCritical(env, givnum, JNI_FALSE);
	check_memory(env, jni_givnum);
	jclass jni_cClass = (*env)->GetObjectClass(env, c);
	jfieldID jni_cId = (*env)->GetFieldID(env, jni_cClass, "val", "D");
	jdouble jni_c = (*env)->GetDoubleField(env, c, jni_cId);
	jclass jni_sClass = (*env)->GetObjectClass(env, s);
	jfieldID jni_sId = (*env)->GetFieldID(env, jni_sClass, "val", "D");
	jdouble jni_s = (*env)->GetDoubleField(env, s, jni_sId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlasd7_(&icompq, &nl, &nr, &sqre, &jni_k, jni_d, jni_z, jni_zw, jni_vf, jni_vfw, jni_vl, jni_vlw, &alpha, &beta, jni_dsigma, jni_idx, jni_idxp, jni_idxq, jni_perm, &jni_givptr, jni_givcol, &ldgcol, jni_givnum, &ldgnum, &jni_c, &jni_s, &jni_info);

	(*env)->SetIntField(env, k, jni_kId, jni_k);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, zw, jni_zw, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vf, jni_vf, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vfw, jni_vfw, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vlw, jni_vlw, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dsigma, jni_dsigma, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, idx, jni_idx, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, idxp, jni_idxp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, idxq, jni_idxq, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, perm, jni_perm, 0);
	(*env)->SetIntField(env, givptr, jni_givptrId, jni_givptr);
	(*env)->ReleasePrimitiveArrayCritical(env, givcol, jni_givcol, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givnum, jni_givnum, 0);
	(*env)->SetDoubleField(env, c, jni_cId, jni_c);
	(*env)->SetDoubleField(env, s, jni_sId, jni_s);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasd8 (JNIEnv * env, jobject calling_obj, jint icompq, jint k, jdoubleArray d, jdoubleArray z, jdoubleArray vf, jdoubleArray vl, jdoubleArray difl, jdoubleArray difr, jint lddifr, jdoubleArray dsigma, jdoubleArray work, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_vf = (*env)->GetPrimitiveArrayCritical(env, vf, JNI_FALSE);
	check_memory(env, jni_vf);
	jdouble * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jdouble * jni_difl = (*env)->GetPrimitiveArrayCritical(env, difl, JNI_FALSE);
	check_memory(env, jni_difl);
	jdouble * jni_difr = (*env)->GetPrimitiveArrayCritical(env, difr, JNI_FALSE);
	check_memory(env, jni_difr);
	jdouble * jni_dsigma = (*env)->GetPrimitiveArrayCritical(env, dsigma, JNI_FALSE);
	check_memory(env, jni_dsigma);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlasd8_(&icompq, &k, jni_d, jni_z, jni_vf, jni_vl, jni_difl, jni_difr, &lddifr, jni_dsigma, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vf, jni_vf, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, difl, jni_difl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, difr, jni_difr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dsigma, jni_dsigma, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasda (JNIEnv * env, jobject calling_obj, jint icompq, jint smlsiz, jint n, jint sqre, jdoubleArray d, jdoubleArray e, jdoubleArray u, jint ldu, jdoubleArray vt, jintArray k, jdoubleArray difl, jdoubleArray difr, jdoubleArray z, jdoubleArray poles, jintArray givptr, jintArray givcol, jint ldgcol, jintArray perm, jdoubleArray givnum, jdoubleArray c, jdoubleArray s, jdoubleArray work, jintArray iwork, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jdouble * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jint * jni_k = (*env)->GetPrimitiveArrayCritical(env, k, JNI_FALSE);
	check_memory(env, jni_k);
	jdouble * jni_difl = (*env)->GetPrimitiveArrayCritical(env, difl, JNI_FALSE);
	check_memory(env, jni_difl);
	jdouble * jni_difr = (*env)->GetPrimitiveArrayCritical(env, difr, JNI_FALSE);
	check_memory(env, jni_difr);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_poles = (*env)->GetPrimitiveArrayCritical(env, poles, JNI_FALSE);
	check_memory(env, jni_poles);
	jint * jni_givptr = (*env)->GetPrimitiveArrayCritical(env, givptr, JNI_FALSE);
	check_memory(env, jni_givptr);
	jint * jni_givcol = (*env)->GetPrimitiveArrayCritical(env, givcol, JNI_FALSE);
	check_memory(env, jni_givcol);
	jint * jni_perm = (*env)->GetPrimitiveArrayCritical(env, perm, JNI_FALSE);
	check_memory(env, jni_perm);
	jdouble * jni_givnum = (*env)->GetPrimitiveArrayCritical(env, givnum, JNI_FALSE);
	check_memory(env, jni_givnum);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlasda_(&icompq, &smlsiz, &n, &sqre, jni_d, jni_e, jni_u, &ldu, jni_vt, jni_k, jni_difl, jni_difr, jni_z, jni_poles, jni_givptr, jni_givcol, &ldgcol, jni_perm, jni_givnum, jni_c, jni_s, jni_work, jni_iwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, k, jni_k, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, difl, jni_difl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, difr, jni_difr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, poles, jni_poles, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givptr, jni_givptr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givcol, jni_givcol, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, perm, jni_perm, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givnum, jni_givnum, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasdq (JNIEnv * env, jobject calling_obj, jstring uplo, jint sqre, jint n, jint ncvt, jint nru, jint ncc, jdoubleArray d, jdoubleArray e, jdoubleArray vt, jint ldvt, jdoubleArray u, jint ldu, jdoubleArray c, jint Ldc, jdoubleArray work, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jdouble * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlasdq_(jni_uplo, &sqre, &n, &ncvt, &nru, &ncc, jni_d, jni_e, jni_vt, &ldvt, jni_u, &ldu, jni_c, &Ldc, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasdt (JNIEnv * env, jobject calling_obj, jint n, jobject lvl, jobject nd, jintArray inode, jintArray ndiml, jintArray ndimr, jint msub){
	jclass jni_lvlClass = (*env)->GetObjectClass(env, lvl);
	jfieldID jni_lvlId = (*env)->GetFieldID(env, jni_lvlClass, "val", "I");
	jint jni_lvl = (*env)->GetIntField(env, lvl, jni_lvlId);
	jclass jni_ndClass = (*env)->GetObjectClass(env, nd);
	jfieldID jni_ndId = (*env)->GetFieldID(env, jni_ndClass, "val", "I");
	jint jni_nd = (*env)->GetIntField(env, nd, jni_ndId);
	jint * jni_inode = (*env)->GetPrimitiveArrayCritical(env, inode, JNI_FALSE);
	check_memory(env, jni_inode);
	jint * jni_ndiml = (*env)->GetPrimitiveArrayCritical(env, ndiml, JNI_FALSE);
	check_memory(env, jni_ndiml);
	jint * jni_ndimr = (*env)->GetPrimitiveArrayCritical(env, ndimr, JNI_FALSE);
	check_memory(env, jni_ndimr);

	dlasdt_(&n, &jni_lvl, &jni_nd, jni_inode, jni_ndiml, jni_ndimr, &msub);

	(*env)->SetIntField(env, lvl, jni_lvlId, jni_lvl);
	(*env)->SetIntField(env, nd, jni_ndId, jni_nd);
	(*env)->ReleasePrimitiveArrayCritical(env, inode, jni_inode, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ndiml, jni_ndiml, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ndimr, jni_ndimr, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaset (JNIEnv * env, jobject calling_obj, jstring uplo, jint m, jint n, jdouble alpha, jdouble beta, jdoubleArray a, jint lda){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);

	dlaset_(jni_uplo, &m, &n, &alpha, &beta, jni_a, &lda);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasq1 (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray d, jdoubleArray e, jdoubleArray work, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlasq1_(&n, jni_d, jni_e, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasq2 (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray z, jobject info){
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlasq2_(&n, jni_z, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasq3 (JNIEnv * env, jobject calling_obj, jint i0, jobject n0, jdoubleArray z, jint pp, jobject dmin, jobject sigma, jobject desig, jobject qmax, jobject nfail, jobject iter, jobject ndiv, jboolean ieee){
	jclass jni_n0Class = (*env)->GetObjectClass(env, n0);
	jfieldID jni_n0Id = (*env)->GetFieldID(env, jni_n0Class, "val", "I");
	jint jni_n0 = (*env)->GetIntField(env, n0, jni_n0Id);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_dminClass = (*env)->GetObjectClass(env, dmin);
	jfieldID jni_dminId = (*env)->GetFieldID(env, jni_dminClass, "val", "D");
	jdouble jni_dmin = (*env)->GetDoubleField(env, dmin, jni_dminId);
	jclass jni_sigmaClass = (*env)->GetObjectClass(env, sigma);
	jfieldID jni_sigmaId = (*env)->GetFieldID(env, jni_sigmaClass, "val", "D");
	jdouble jni_sigma = (*env)->GetDoubleField(env, sigma, jni_sigmaId);
	jclass jni_desigClass = (*env)->GetObjectClass(env, desig);
	jfieldID jni_desigId = (*env)->GetFieldID(env, jni_desigClass, "val", "D");
	jdouble jni_desig = (*env)->GetDoubleField(env, desig, jni_desigId);
	jclass jni_qmaxClass = (*env)->GetObjectClass(env, qmax);
	jfieldID jni_qmaxId = (*env)->GetFieldID(env, jni_qmaxClass, "val", "D");
	jdouble jni_qmax = (*env)->GetDoubleField(env, qmax, jni_qmaxId);
	jclass jni_nfailClass = (*env)->GetObjectClass(env, nfail);
	jfieldID jni_nfailId = (*env)->GetFieldID(env, jni_nfailClass, "val", "I");
	jint jni_nfail = (*env)->GetIntField(env, nfail, jni_nfailId);
	jclass jni_iterClass = (*env)->GetObjectClass(env, iter);
	jfieldID jni_iterId = (*env)->GetFieldID(env, jni_iterClass, "val", "I");
	jint jni_iter = (*env)->GetIntField(env, iter, jni_iterId);
	jclass jni_ndivClass = (*env)->GetObjectClass(env, ndiv);
	jfieldID jni_ndivId = (*env)->GetFieldID(env, jni_ndivClass, "val", "I");
	jint jni_ndiv = (*env)->GetIntField(env, ndiv, jni_ndivId);
	logical jni_ieee = (logical)ieee;

	dlasq3_(&i0, &jni_n0, jni_z, &pp, &jni_dmin, &jni_sigma, &jni_desig, &jni_qmax, &jni_nfail, &jni_iter, &jni_ndiv, &jni_ieee);

	(*env)->SetIntField(env, n0, jni_n0Id, jni_n0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetDoubleField(env, dmin, jni_dminId, jni_dmin);
	(*env)->SetDoubleField(env, sigma, jni_sigmaId, jni_sigma);
	(*env)->SetDoubleField(env, desig, jni_desigId, jni_desig);
	(*env)->SetDoubleField(env, qmax, jni_qmaxId, jni_qmax);
	(*env)->SetIntField(env, nfail, jni_nfailId, jni_nfail);
	(*env)->SetIntField(env, iter, jni_iterId, jni_iter);
	(*env)->SetIntField(env, ndiv, jni_ndivId, jni_ndiv);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasq4 (JNIEnv * env, jobject calling_obj, jint i0, jint n0, jdoubleArray z, jint pp, jint n0in, jdouble dmin, jdouble dmin1, jdouble dmin2, jdouble dn, jdouble dn1, jdouble dn2, jobject tau, jobject ttype){
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_tauClass = (*env)->GetObjectClass(env, tau);
	jfieldID jni_tauId = (*env)->GetFieldID(env, jni_tauClass, "val", "D");
	jdouble jni_tau = (*env)->GetDoubleField(env, tau, jni_tauId);
	jclass jni_ttypeClass = (*env)->GetObjectClass(env, ttype);
	jfieldID jni_ttypeId = (*env)->GetFieldID(env, jni_ttypeClass, "val", "I");
	jint jni_ttype = (*env)->GetIntField(env, ttype, jni_ttypeId);

	dlasq4_(&i0, &n0, jni_z, &pp, &n0in, &dmin, &dmin1, &dmin2, &dn, &dn1, &dn2, &jni_tau, &jni_ttype);

	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetDoubleField(env, tau, jni_tauId, jni_tau);
	(*env)->SetIntField(env, ttype, jni_ttypeId, jni_ttype);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasq5 (JNIEnv * env, jobject calling_obj, jint i0, jint n0, jdoubleArray z, jint pp, jdouble tau, jobject dmin, jobject dmin1, jobject dmin2, jobject dn, jobject dnm1, jobject dnm2, jboolean ieee){
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_dminClass = (*env)->GetObjectClass(env, dmin);
	jfieldID jni_dminId = (*env)->GetFieldID(env, jni_dminClass, "val", "D");
	jdouble jni_dmin = (*env)->GetDoubleField(env, dmin, jni_dminId);
	jclass jni_dmin1Class = (*env)->GetObjectClass(env, dmin1);
	jfieldID jni_dmin1Id = (*env)->GetFieldID(env, jni_dmin1Class, "val", "D");
	jdouble jni_dmin1 = (*env)->GetDoubleField(env, dmin1, jni_dmin1Id);
	jclass jni_dmin2Class = (*env)->GetObjectClass(env, dmin2);
	jfieldID jni_dmin2Id = (*env)->GetFieldID(env, jni_dmin2Class, "val", "D");
	jdouble jni_dmin2 = (*env)->GetDoubleField(env, dmin2, jni_dmin2Id);
	jclass jni_dnClass = (*env)->GetObjectClass(env, dn);
	jfieldID jni_dnId = (*env)->GetFieldID(env, jni_dnClass, "val", "D");
	jdouble jni_dn = (*env)->GetDoubleField(env, dn, jni_dnId);
	jclass jni_dnm1Class = (*env)->GetObjectClass(env, dnm1);
	jfieldID jni_dnm1Id = (*env)->GetFieldID(env, jni_dnm1Class, "val", "D");
	jdouble jni_dnm1 = (*env)->GetDoubleField(env, dnm1, jni_dnm1Id);
	jclass jni_dnm2Class = (*env)->GetObjectClass(env, dnm2);
	jfieldID jni_dnm2Id = (*env)->GetFieldID(env, jni_dnm2Class, "val", "D");
	jdouble jni_dnm2 = (*env)->GetDoubleField(env, dnm2, jni_dnm2Id);
	logical jni_ieee = (logical)ieee;

	dlasq5_(&i0, &n0, jni_z, &pp, &tau, &jni_dmin, &jni_dmin1, &jni_dmin2, &jni_dn, &jni_dnm1, &jni_dnm2, &jni_ieee);

	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetDoubleField(env, dmin, jni_dminId, jni_dmin);
	(*env)->SetDoubleField(env, dmin1, jni_dmin1Id, jni_dmin1);
	(*env)->SetDoubleField(env, dmin2, jni_dmin2Id, jni_dmin2);
	(*env)->SetDoubleField(env, dn, jni_dnId, jni_dn);
	(*env)->SetDoubleField(env, dnm1, jni_dnm1Id, jni_dnm1);
	(*env)->SetDoubleField(env, dnm2, jni_dnm2Id, jni_dnm2);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasq6 (JNIEnv * env, jobject calling_obj, jint i0, jint n0, jdoubleArray z, jint pp, jobject dmin, jobject dmin1, jobject dmin2, jobject dn, jobject dnm1, jobject dnm2){
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_dminClass = (*env)->GetObjectClass(env, dmin);
	jfieldID jni_dminId = (*env)->GetFieldID(env, jni_dminClass, "val", "D");
	jdouble jni_dmin = (*env)->GetDoubleField(env, dmin, jni_dminId);
	jclass jni_dmin1Class = (*env)->GetObjectClass(env, dmin1);
	jfieldID jni_dmin1Id = (*env)->GetFieldID(env, jni_dmin1Class, "val", "D");
	jdouble jni_dmin1 = (*env)->GetDoubleField(env, dmin1, jni_dmin1Id);
	jclass jni_dmin2Class = (*env)->GetObjectClass(env, dmin2);
	jfieldID jni_dmin2Id = (*env)->GetFieldID(env, jni_dmin2Class, "val", "D");
	jdouble jni_dmin2 = (*env)->GetDoubleField(env, dmin2, jni_dmin2Id);
	jclass jni_dnClass = (*env)->GetObjectClass(env, dn);
	jfieldID jni_dnId = (*env)->GetFieldID(env, jni_dnClass, "val", "D");
	jdouble jni_dn = (*env)->GetDoubleField(env, dn, jni_dnId);
	jclass jni_dnm1Class = (*env)->GetObjectClass(env, dnm1);
	jfieldID jni_dnm1Id = (*env)->GetFieldID(env, jni_dnm1Class, "val", "D");
	jdouble jni_dnm1 = (*env)->GetDoubleField(env, dnm1, jni_dnm1Id);
	jclass jni_dnm2Class = (*env)->GetObjectClass(env, dnm2);
	jfieldID jni_dnm2Id = (*env)->GetFieldID(env, jni_dnm2Class, "val", "D");
	jdouble jni_dnm2 = (*env)->GetDoubleField(env, dnm2, jni_dnm2Id);

	dlasq6_(&i0, &n0, jni_z, &pp, &jni_dmin, &jni_dmin1, &jni_dmin2, &jni_dn, &jni_dnm1, &jni_dnm2);

	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetDoubleField(env, dmin, jni_dminId, jni_dmin);
	(*env)->SetDoubleField(env, dmin1, jni_dmin1Id, jni_dmin1);
	(*env)->SetDoubleField(env, dmin2, jni_dmin2Id, jni_dmin2);
	(*env)->SetDoubleField(env, dn, jni_dnId, jni_dn);
	(*env)->SetDoubleField(env, dnm1, jni_dnm1Id, jni_dnm1);
	(*env)->SetDoubleField(env, dnm2, jni_dnm2Id, jni_dnm2);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasr (JNIEnv * env, jobject calling_obj, jstring side, jstring pivot, jstring direct, jint m, jint n, jdoubleArray c, jdoubleArray s, jdoubleArray a, jint lda){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_pivot = (char *)(*env)->GetStringUTFChars(env, pivot, JNI_FALSE);
	char * jni_direct = (char *)(*env)->GetStringUTFChars(env, direct, JNI_FALSE);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);

	dlasr_(jni_side, jni_pivot, jni_direct, &m, &n, jni_c, jni_s, jni_a, &lda);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, pivot, jni_pivot);
	(*env)->ReleaseStringUTFChars(env, direct, jni_direct);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasrt (JNIEnv * env, jobject calling_obj, jstring id, jint n, jdoubleArray d, jobject info){
	char * jni_id = (char *)(*env)->GetStringUTFChars(env, id, JNI_FALSE);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlasrt_(jni_id, &n, jni_d, &jni_info);

	(*env)->ReleaseStringUTFChars(env, id, jni_id);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlassq (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray x, jint incx, jobject scale, jobject sumsq){
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jdouble jni_scale = (*env)->GetDoubleField(env, scale, jni_scaleId);
	jclass jni_sumsqClass = (*env)->GetObjectClass(env, sumsq);
	jfieldID jni_sumsqId = (*env)->GetFieldID(env, jni_sumsqClass, "val", "D");
	jdouble jni_sumsq = (*env)->GetDoubleField(env, sumsq, jni_sumsqId);

	dlassq_(&n, jni_x, &incx, &jni_scale, &jni_sumsq);

	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetDoubleField(env, scale, jni_scaleId, jni_scale);
	(*env)->SetDoubleField(env, sumsq, jni_sumsqId, jni_sumsq);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasv2 (JNIEnv * env, jobject calling_obj, jdouble f, jdouble g, jdouble h, jobject ssmin, jobject ssmax, jobject snr, jobject csr, jobject snl, jobject csl){
	jclass jni_ssminClass = (*env)->GetObjectClass(env, ssmin);
	jfieldID jni_ssminId = (*env)->GetFieldID(env, jni_ssminClass, "val", "D");
	jdouble jni_ssmin = (*env)->GetDoubleField(env, ssmin, jni_ssminId);
	jclass jni_ssmaxClass = (*env)->GetObjectClass(env, ssmax);
	jfieldID jni_ssmaxId = (*env)->GetFieldID(env, jni_ssmaxClass, "val", "D");
	jdouble jni_ssmax = (*env)->GetDoubleField(env, ssmax, jni_ssmaxId);
	jclass jni_snrClass = (*env)->GetObjectClass(env, snr);
	jfieldID jni_snrId = (*env)->GetFieldID(env, jni_snrClass, "val", "D");
	jdouble jni_snr = (*env)->GetDoubleField(env, snr, jni_snrId);
	jclass jni_csrClass = (*env)->GetObjectClass(env, csr);
	jfieldID jni_csrId = (*env)->GetFieldID(env, jni_csrClass, "val", "D");
	jdouble jni_csr = (*env)->GetDoubleField(env, csr, jni_csrId);
	jclass jni_snlClass = (*env)->GetObjectClass(env, snl);
	jfieldID jni_snlId = (*env)->GetFieldID(env, jni_snlClass, "val", "D");
	jdouble jni_snl = (*env)->GetDoubleField(env, snl, jni_snlId);
	jclass jni_cslClass = (*env)->GetObjectClass(env, csl);
	jfieldID jni_cslId = (*env)->GetFieldID(env, jni_cslClass, "val", "D");
	jdouble jni_csl = (*env)->GetDoubleField(env, csl, jni_cslId);

	dlasv2_(&f, &g, &h, &jni_ssmin, &jni_ssmax, &jni_snr, &jni_csr, &jni_snl, &jni_csl);

	(*env)->SetDoubleField(env, ssmin, jni_ssminId, jni_ssmin);
	(*env)->SetDoubleField(env, ssmax, jni_ssmaxId, jni_ssmax);
	(*env)->SetDoubleField(env, snr, jni_snrId, jni_snr);
	(*env)->SetDoubleField(env, csr, jni_csrId, jni_csr);
	(*env)->SetDoubleField(env, snl, jni_snlId, jni_snl);
	(*env)->SetDoubleField(env, csl, jni_cslId, jni_csl);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlaswp (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray a, jint lda, jint k1, jint k2, jintArray ipiv, jint incx){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);

	dlaswp_(&n, jni_a, &lda, &k1, &k2, jni_ipiv, &incx);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasy2 (JNIEnv * env, jobject calling_obj, jboolean ltranl, jboolean ltranr, jint isgn, jint n1, jint n2, jdoubleArray tl, jint ldtl, jdoubleArray tr, jint ldtr, jdoubleArray b, jint ldb, jobject scale, jdoubleArray x, jint ldx, jobject xnorm, jobject info){
	logical jni_ltranl = (logical)ltranl;
	logical jni_ltranr = (logical)ltranr;
	jdouble * jni_tl = (*env)->GetPrimitiveArrayCritical(env, tl, JNI_FALSE);
	check_memory(env, jni_tl);
	jdouble * jni_tr = (*env)->GetPrimitiveArrayCritical(env, tr, JNI_FALSE);
	check_memory(env, jni_tr);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jdouble jni_scale = (*env)->GetDoubleField(env, scale, jni_scaleId);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_xnormClass = (*env)->GetObjectClass(env, xnorm);
	jfieldID jni_xnormId = (*env)->GetFieldID(env, jni_xnormClass, "val", "D");
	jdouble jni_xnorm = (*env)->GetDoubleField(env, xnorm, jni_xnormId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlasy2_(&jni_ltranl, &jni_ltranr, &isgn, &n1, &n2, jni_tl, &ldtl, jni_tr, &ldtr, jni_b, &ldb, &jni_scale, jni_x, &ldx, &jni_xnorm, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, tl, jni_tl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tr, jni_tr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetDoubleField(env, scale, jni_scaleId, jni_scale);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetDoubleField(env, xnorm, jni_xnormId, jni_xnorm);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlasyf (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nb, jobject kb, jdoubleArray a, jint lda, jintArray ipiv, jdoubleArray w, jint ldw, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jclass jni_kbClass = (*env)->GetObjectClass(env, kb);
	jfieldID jni_kbId = (*env)->GetFieldID(env, jni_kbClass, "val", "I");
	jint jni_kb = (*env)->GetIntField(env, kb, jni_kbId);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlasyf_(jni_uplo, &n, &nb, &jni_kb, jni_a, &lda, jni_ipiv, jni_w, &ldw, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->SetIntField(env, kb, jni_kbId, jni_kb);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlatbs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jstring normin, jint n, jint kd, jdoubleArray ab, jint ldab, jdoubleArray x, jobject scale, jdoubleArray cnorm, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	char * jni_normin = (char *)(*env)->GetStringUTFChars(env, normin, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jdouble jni_scale = (*env)->GetDoubleField(env, scale, jni_scaleId);
	jdouble * jni_cnorm = (*env)->GetPrimitiveArrayCritical(env, cnorm, JNI_FALSE);
	check_memory(env, jni_cnorm);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlatbs_(jni_uplo, jni_trans, jni_diag, jni_normin, &n, &kd, jni_ab, &ldab, jni_x, &jni_scale, jni_cnorm, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleaseStringUTFChars(env, normin, jni_normin);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetDoubleField(env, scale, jni_scaleId, jni_scale);
	(*env)->ReleasePrimitiveArrayCritical(env, cnorm, jni_cnorm, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlatdf (JNIEnv * env, jobject calling_obj, jint ijob, jint n, jdoubleArray z, jint ldz, jdoubleArray rhs, jobject rdsum, jobject rdscal, jintArray ipiv, jintArray jpiv){
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_rhs = (*env)->GetPrimitiveArrayCritical(env, rhs, JNI_FALSE);
	check_memory(env, jni_rhs);
	jclass jni_rdsumClass = (*env)->GetObjectClass(env, rdsum);
	jfieldID jni_rdsumId = (*env)->GetFieldID(env, jni_rdsumClass, "val", "D");
	jdouble jni_rdsum = (*env)->GetDoubleField(env, rdsum, jni_rdsumId);
	jclass jni_rdscalClass = (*env)->GetObjectClass(env, rdscal);
	jfieldID jni_rdscalId = (*env)->GetFieldID(env, jni_rdscalClass, "val", "D");
	jdouble jni_rdscal = (*env)->GetDoubleField(env, rdscal, jni_rdscalId);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jint * jni_jpiv = (*env)->GetPrimitiveArrayCritical(env, jpiv, JNI_FALSE);
	check_memory(env, jni_jpiv);

	dlatdf_(&ijob, &n, jni_z, &ldz, jni_rhs, &jni_rdsum, &jni_rdscal, jni_ipiv, jni_jpiv);

	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, rhs, jni_rhs, 0);
	(*env)->SetDoubleField(env, rdsum, jni_rdsumId, jni_rdsum);
	(*env)->SetDoubleField(env, rdscal, jni_rdscalId, jni_rdscal);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, jpiv, jni_jpiv, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlatps (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jstring normin, jint n, jdoubleArray ap, jdoubleArray x, jobject scale, jdoubleArray cnorm, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	char * jni_normin = (char *)(*env)->GetStringUTFChars(env, normin, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jdouble jni_scale = (*env)->GetDoubleField(env, scale, jni_scaleId);
	jdouble * jni_cnorm = (*env)->GetPrimitiveArrayCritical(env, cnorm, JNI_FALSE);
	check_memory(env, jni_cnorm);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlatps_(jni_uplo, jni_trans, jni_diag, jni_normin, &n, jni_ap, jni_x, &jni_scale, jni_cnorm, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleaseStringUTFChars(env, normin, jni_normin);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetDoubleField(env, scale, jni_scaleId, jni_scale);
	(*env)->ReleasePrimitiveArrayCritical(env, cnorm, jni_cnorm, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlatrd (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nb, jdoubleArray a, jint lda, jdoubleArray e, jdoubleArray tau, jdoubleArray w, jint ldw){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);

	dlatrd_(jni_uplo, &n, &nb, jni_a, &lda, jni_e, jni_tau, jni_w, &ldw);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlatrs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jstring normin, jint n, jdoubleArray a, jint lda, jdoubleArray x, jobject scale, jdoubleArray cnorm, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	char * jni_normin = (char *)(*env)->GetStringUTFChars(env, normin, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jdouble jni_scale = (*env)->GetDoubleField(env, scale, jni_scaleId);
	jdouble * jni_cnorm = (*env)->GetPrimitiveArrayCritical(env, cnorm, JNI_FALSE);
	check_memory(env, jni_cnorm);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlatrs_(jni_uplo, jni_trans, jni_diag, jni_normin, &n, jni_a, &lda, jni_x, &jni_scale, jni_cnorm, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleaseStringUTFChars(env, normin, jni_normin);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetDoubleField(env, scale, jni_scaleId, jni_scale);
	(*env)->ReleasePrimitiveArrayCritical(env, cnorm, jni_cnorm, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlatrz (JNIEnv * env, jobject calling_obj, jint m, jint n, jint l, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);

	dlatrz_(&m, &n, &l, jni_a, &lda, jni_tau, jni_work);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlatzm (JNIEnv * env, jobject calling_obj, jstring side, jint m, jint n, jdoubleArray v, jint incv, jdouble tau, jdoubleArray c1, jdoubleArray c2, jint Ldc, jdoubleArray work){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	jdouble * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jdouble * jni_c1 = (*env)->GetPrimitiveArrayCritical(env, c1, JNI_FALSE);
	check_memory(env, jni_c1);
	jdouble * jni_c2 = (*env)->GetPrimitiveArrayCritical(env, c2, JNI_FALSE);
	check_memory(env, jni_c2);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);

	dlatzm_(jni_side, &m, &n, jni_v, &incv, &tau, jni_c1, jni_c2, &Ldc, jni_work);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c1, jni_c1, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c2, jni_c2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlauu2 (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlauu2_(jni_uplo, &n, jni_a, &lda, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dlauum (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dlauum_(jni_uplo, &n, jni_a, &lda, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dopgtr (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jdoubleArray tau, jdoubleArray q, jint ldq, jdoubleArray work, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dopgtr_(jni_uplo, &n, jni_ap, jni_tau, jni_q, &ldq, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dopmtr (JNIEnv * env, jobject calling_obj, jstring side, jstring uplo, jstring trans, jint m, jint n, jdoubleArray ap, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dopmtr_(jni_side, jni_uplo, jni_trans, &m, &n, jni_ap, jni_tau, jni_c, &Ldc, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dorg2l (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dorg2l_(&m, &n, &k, jni_a, &lda, jni_tau, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dorg2r (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dorg2r_(&m, &n, &k, jni_a, &lda, jni_tau, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dorgbr (JNIEnv * env, jobject calling_obj, jstring vect, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jobject info){
	char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dorgbr_(jni_vect, &m, &n, &k, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, vect, jni_vect);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dorghr (JNIEnv * env, jobject calling_obj, jint n, jint ilo, jint ihi, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dorghr_(&n, &ilo, &ihi, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dorgl2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dorgl2_(&m, &n, &k, jni_a, &lda, jni_tau, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dorglq (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dorglq_(&m, &n, &k, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dorgql (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dorgql_(&m, &n, &k, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dorgqr (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dorgqr_(&m, &n, &k, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dorgr2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dorgr2_(&m, &n, &k, jni_a, &lda, jni_tau, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dorgrq (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dorgrq_(&m, &n, &k, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dorgtr (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dorgtr_(jni_uplo, &n, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dorm2l (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dorm2l_(jni_side, jni_trans, &m, &n, &k, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dorm2r (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dorm2r_(jni_side, jni_trans, &m, &n, &k, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dormbr (JNIEnv * env, jobject calling_obj, jstring vect, jstring side, jstring trans, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jint lwork, jobject info){
	char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dormbr_(jni_vect, jni_side, jni_trans, &m, &n, &k, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, vect, jni_vect);
	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dormhr (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint ilo, jint ihi, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jint lwork, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dormhr_(jni_side, jni_trans, &m, &n, &ilo, &ihi, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dorml2 (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dorml2_(jni_side, jni_trans, &m, &n, &k, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dormlq (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jint lwork, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dormlq_(jni_side, jni_trans, &m, &n, &k, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dormql (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jint lwork, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dormql_(jni_side, jni_trans, &m, &n, &k, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dormqr (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jint lwork, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dormqr_(jni_side, jni_trans, &m, &n, &k, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dormr2 (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dormr2_(jni_side, jni_trans, &m, &n, &k, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dormr3 (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jint l, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dormr3_(jni_side, jni_trans, &m, &n, &k, &l, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dormrq (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jint lwork, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dormrq_(jni_side, jni_trans, &m, &n, &k, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dormrz (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jint l, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jint lwork, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dormrz_(jni_side, jni_trans, &m, &n, &k, &l, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dormtr (JNIEnv * env, jobject calling_obj, jstring side, jstring uplo, jstring trans, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray c, jint Ldc, jdoubleArray work, jint lwork, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dormtr_(jni_side, jni_uplo, jni_trans, &m, &n, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpbcon (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jdoubleArray ab, jint ldab, jdouble anorm, jobject rcond, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpbcon_(jni_uplo, &n, &kd, jni_ab, &ldab, &anorm, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpbequ (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jdoubleArray ab, jint ldab, jdoubleArray s, jobject scond, jobject amax, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jclass jni_scondClass = (*env)->GetObjectClass(env, scond);
	jfieldID jni_scondId = (*env)->GetFieldID(env, jni_scondClass, "val", "D");
	jdouble jni_scond = (*env)->GetDoubleField(env, scond, jni_scondId);
	jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
	jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "D");
	jdouble jni_amax = (*env)->GetDoubleField(env, amax, jni_amaxId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpbequ_(jni_uplo, &n, &kd, jni_ab, &ldab, jni_s, &jni_scond, &jni_amax, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->SetDoubleField(env, scond, jni_scondId, jni_scond);
	(*env)->SetDoubleField(env, amax, jni_amaxId, jni_amax);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpbrfs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jint nrhs, jdoubleArray ab, jint ldab, jdoubleArray afb, jint ldafb, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_afb = (*env)->GetPrimitiveArrayCritical(env, afb, JNI_FALSE);
	check_memory(env, jni_afb);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpbrfs_(jni_uplo, &n, &kd, &nrhs, jni_ab, &ldab, jni_afb, &ldafb, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, afb, jni_afb, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpbstf (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jdoubleArray ab, jint ldab, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpbstf_(jni_uplo, &n, &kd, jni_ab, &ldab, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpbsv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jint nrhs, jdoubleArray ab, jint ldab, jdoubleArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpbsv_(jni_uplo, &n, &kd, &nrhs, jni_ab, &ldab, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpbsvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring uplo, jint n, jint kd, jint nrhs, jdoubleArray ab, jint ldab, jdoubleArray afb, jint ldafb, jobject equed, jdoubleArray s, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jobject rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_afb = (*env)->GetPrimitiveArrayCritical(env, afb, JNI_FALSE);
	check_memory(env, jni_afb);
	jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
	jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
	jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
	char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpbsvx_(jni_fact, jni_uplo, &n, &kd, &nrhs, jni_ab, &ldab, jni_afb, &ldafb, jni_equed, jni_s, jni_b, &ldb, jni_x, &ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, fact, jni_fact);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, afb, jni_afb, 0);
	jstring jni_equedStringNew = (*env)->NewStringUTF(env, jni_equed);
	(*env)->SetObjectField(env, equed, jni_equedId, jni_equedStringNew);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpbtf2 (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jdoubleArray ab, jint ldab, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpbtf2_(jni_uplo, &n, &kd, jni_ab, &ldab, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpbtrf (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jdoubleArray ab, jint ldab, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpbtrf_(jni_uplo, &n, &kd, jni_ab, &ldab, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpbtrs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jint nrhs, jdoubleArray ab, jint ldab, jdoubleArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpbtrs_(jni_uplo, &n, &kd, &nrhs, jni_ab, &ldab, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpocon (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jdouble anorm, jobject rcond, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpocon_(jni_uplo, &n, jni_a, &lda, &anorm, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpoequ (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray a, jint lda, jdoubleArray s, jobject scond, jobject amax, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jclass jni_scondClass = (*env)->GetObjectClass(env, scond);
	jfieldID jni_scondId = (*env)->GetFieldID(env, jni_scondClass, "val", "D");
	jdouble jni_scond = (*env)->GetDoubleField(env, scond, jni_scondId);
	jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
	jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "D");
	jdouble jni_amax = (*env)->GetDoubleField(env, amax, jni_amaxId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpoequ_(&n, jni_a, &lda, jni_s, &jni_scond, &jni_amax, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->SetDoubleField(env, scond, jni_scondId, jni_scond);
	(*env)->SetDoubleField(env, amax, jni_amaxId, jni_amax);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dporfs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray af, jint ldaf, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
	check_memory(env, jni_af);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dporfs_(jni_uplo, &n, &nrhs, jni_a, &lda, jni_af, &ldaf, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dposv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dposv_(jni_uplo, &n, &nrhs, jni_a, &lda, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dposvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray af, jint ldaf, jobject equed, jdoubleArray s, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jobject rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
	check_memory(env, jni_af);
	jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
	jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
	jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
	char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dposvx_(jni_fact, jni_uplo, &n, &nrhs, jni_a, &lda, jni_af, &ldaf, jni_equed, jni_s, jni_b, &ldb, jni_x, &ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, fact, jni_fact);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
	jstring jni_equedStringNew = (*env)->NewStringUTF(env, jni_equed);
	(*env)->SetObjectField(env, equed, jni_equedId, jni_equedStringNew);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpotf2 (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpotf2_(jni_uplo, &n, jni_a, &lda, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpotrf (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpotrf_(jni_uplo, &n, jni_a, &lda, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpotri (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpotri_(jni_uplo, &n, jni_a, &lda, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpotrs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpotrs_(jni_uplo, &n, &nrhs, jni_a, &lda, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dppcon (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jdouble anorm, jobject rcond, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dppcon_(jni_uplo, &n, jni_ap, &anorm, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dppequ (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jdoubleArray s, jobject scond, jobject amax, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jclass jni_scondClass = (*env)->GetObjectClass(env, scond);
	jfieldID jni_scondId = (*env)->GetFieldID(env, jni_scondClass, "val", "D");
	jdouble jni_scond = (*env)->GetDoubleField(env, scond, jni_scondId);
	jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
	jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "D");
	jdouble jni_amax = (*env)->GetDoubleField(env, amax, jni_amaxId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dppequ_(jni_uplo, &n, jni_ap, jni_s, &jni_scond, &jni_amax, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->SetDoubleField(env, scond, jni_scondId, jni_scond);
	(*env)->SetDoubleField(env, amax, jni_amaxId, jni_amax);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpprfs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jdoubleArray afp, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jdouble * jni_afp = (*env)->GetPrimitiveArrayCritical(env, afp, JNI_FALSE);
	check_memory(env, jni_afp);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpprfs_(jni_uplo, &n, &nrhs, jni_ap, jni_afp, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, afp, jni_afp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dppsv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jdoubleArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dppsv_(jni_uplo, &n, &nrhs, jni_ap, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dppsvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jdoubleArray afp, jobject equed, jdoubleArray s, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jobject rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jdouble * jni_afp = (*env)->GetPrimitiveArrayCritical(env, afp, JNI_FALSE);
	check_memory(env, jni_afp);
	jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
	jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
	jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
	char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dppsvx_(jni_fact, jni_uplo, &n, &nrhs, jni_ap, jni_afp, jni_equed, jni_s, jni_b, &ldb, jni_x, &ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, fact, jni_fact);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, afp, jni_afp, 0);
	jstring jni_equedStringNew = (*env)->NewStringUTF(env, jni_equed);
	(*env)->SetObjectField(env, equed, jni_equedId, jni_equedStringNew);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpptrf (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpptrf_(jni_uplo, &n, jni_ap, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpptri (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpptri_(jni_uplo, &n, jni_ap, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpptrs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jdoubleArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpptrs_(jni_uplo, &n, &nrhs, jni_ap, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dptcon (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray d, jdoubleArray e, jdouble anorm, jobject rcond, jdoubleArray work, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dptcon_(&n, jni_d, jni_e, &anorm, &jni_rcond, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpteqr (JNIEnv * env, jobject calling_obj, jstring compz, jint n, jdoubleArray d, jdoubleArray e, jdoubleArray z, jint ldz, jdoubleArray work, jobject info){
	char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpteqr_(jni_compz, &n, jni_d, jni_e, jni_z, &ldz, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, compz, jni_compz);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dptrfs (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jdoubleArray d, jdoubleArray e, jdoubleArray df, jdoubleArray ef, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_df = (*env)->GetPrimitiveArrayCritical(env, df, JNI_FALSE);
	check_memory(env, jni_df);
	jdouble * jni_ef = (*env)->GetPrimitiveArrayCritical(env, ef, JNI_FALSE);
	check_memory(env, jni_ef);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dptrfs_(&n, &nrhs, jni_d, jni_e, jni_df, jni_ef, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, df, jni_df, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ef, jni_ef, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dptsv (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jdoubleArray d, jdoubleArray e, jdoubleArray b, jint ldb, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dptsv_(&n, &nrhs, jni_d, jni_e, jni_b, &ldb, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dptsvx (JNIEnv * env, jobject calling_obj, jstring fact, jint n, jint nrhs, jdoubleArray d, jdoubleArray e, jdoubleArray df, jdoubleArray ef, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jobject rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jobject info){
	char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_df = (*env)->GetPrimitiveArrayCritical(env, df, JNI_FALSE);
	check_memory(env, jni_df);
	jdouble * jni_ef = (*env)->GetPrimitiveArrayCritical(env, ef, JNI_FALSE);
	check_memory(env, jni_ef);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dptsvx_(jni_fact, &n, &nrhs, jni_d, jni_e, jni_df, jni_ef, jni_b, &ldb, jni_x, &ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, fact, jni_fact);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, df, jni_df, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ef, jni_ef, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpttrf (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray d, jdoubleArray e, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpttrf_(&n, jni_d, jni_e, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dpttrs (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jdoubleArray d, jdoubleArray e, jdoubleArray b, jint ldb, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dpttrs_(&n, &nrhs, jni_d, jni_e, jni_b, &ldb, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dptts2 (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jdoubleArray d, jdoubleArray e, jdoubleArray b, jint ldb){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);

	dptts2_(&n, &nrhs, jni_d, jni_e, jni_b, &ldb);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_drscl (JNIEnv * env, jobject calling_obj, jint n, jdouble sa, jdoubleArray sx, jint incx){
	jdouble * jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
	check_memory(env, jni_sx);

	drscl_(&n, &sa, jni_sx, &incx);

	(*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsbev (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jint kd, jdoubleArray ab, jint ldab, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsbev_(jni_jobz, jni_uplo, &n, &kd, jni_ab, &ldab, jni_w, jni_z, &ldz, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsbevd (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jint kd, jdoubleArray ab, jint ldab, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsbevd_(jni_jobz, jni_uplo, &n, &kd, jni_ab, &ldab, jni_w, jni_z, &ldz, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsbevx (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jstring uplo, jint n, jint kd, jdoubleArray ab, jint ldab, jdoubleArray q, jint ldq, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jobject m, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jintArray iwork, jintArray ifail, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jint * jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
	check_memory(env, jni_ifail);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsbevx_(jni_jobz, jni_range, jni_uplo, &n, &kd, jni_ab, &ldab, jni_q, &ldq, &vl, &vu, &il, &iu, &abstol, &jni_m, jni_w, jni_z, &ldz, jni_work, jni_iwork, jni_ifail, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsbgst (JNIEnv * env, jobject calling_obj, jstring vect, jstring uplo, jint n, jint ka, jint kb, jdoubleArray ab, jint ldab, jdoubleArray bb, jint ldbb, jdoubleArray x, jint ldx, jdoubleArray work, jobject info){
	char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_bb = (*env)->GetPrimitiveArrayCritical(env, bb, JNI_FALSE);
	check_memory(env, jni_bb);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsbgst_(jni_vect, jni_uplo, &n, &ka, &kb, jni_ab, &ldab, jni_bb, &ldbb, jni_x, &ldx, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, vect, jni_vect);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, bb, jni_bb, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsbgv (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jint ka, jint kb, jdoubleArray ab, jint ldab, jdoubleArray bb, jint ldbb, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_bb = (*env)->GetPrimitiveArrayCritical(env, bb, JNI_FALSE);
	check_memory(env, jni_bb);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsbgv_(jni_jobz, jni_uplo, &n, &ka, &kb, jni_ab, &ldab, jni_bb, &ldbb, jni_w, jni_z, &ldz, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, bb, jni_bb, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsbgvd (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jint ka, jint kb, jdoubleArray ab, jint ldab, jdoubleArray bb, jint ldbb, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_bb = (*env)->GetPrimitiveArrayCritical(env, bb, JNI_FALSE);
	check_memory(env, jni_bb);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsbgvd_(jni_jobz, jni_uplo, &n, &ka, &kb, jni_ab, &ldab, jni_bb, &ldbb, jni_w, jni_z, &ldz, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, bb, jni_bb, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsbgvx (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jstring uplo, jint n, jint ka, jint kb, jdoubleArray ab, jint ldab, jdoubleArray bb, jint ldbb, jdoubleArray q, jint ldq, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jobject m, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jintArray iwork, jintArray ifail, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_bb = (*env)->GetPrimitiveArrayCritical(env, bb, JNI_FALSE);
	check_memory(env, jni_bb);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jint * jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
	check_memory(env, jni_ifail);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsbgvx_(jni_jobz, jni_range, jni_uplo, &n, &ka, &kb, jni_ab, &ldab, jni_bb, &ldbb, jni_q, &ldq, &vl, &vu, &il, &iu, &abstol, &jni_m, jni_w, jni_z, &ldz, jni_work, jni_iwork, jni_ifail, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, bb, jni_bb, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsbtrd (JNIEnv * env, jobject calling_obj, jstring vect, jstring uplo, jint n, jint kd, jdoubleArray ab, jint ldab, jdoubleArray d, jdoubleArray e, jdoubleArray q, jint ldq, jdoubleArray work, jobject info){
	char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsbtrd_(jni_vect, jni_uplo, &n, &kd, jni_ab, &ldab, jni_d, jni_e, jni_q, &ldq, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, vect, jni_vect);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dspcon (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jintArray ipiv, jdouble anorm, jobject rcond, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dspcon_(jni_uplo, &n, jni_ap, jni_ipiv, &anorm, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dspev (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jdoubleArray ap, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dspev_(jni_jobz, jni_uplo, &n, jni_ap, jni_w, jni_z, &ldz, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dspevd (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jdoubleArray ap, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dspevd_(jni_jobz, jni_uplo, &n, jni_ap, jni_w, jni_z, &ldz, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dspevx (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jstring uplo, jint n, jdoubleArray ap, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jobject m, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jintArray iwork, jintArray ifail, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jint * jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
	check_memory(env, jni_ifail);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dspevx_(jni_jobz, jni_range, jni_uplo, &n, jni_ap, &vl, &vu, &il, &iu, &abstol, &jni_m, jni_w, jni_z, &ldz, jni_work, jni_iwork, jni_ifail, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dspgst (JNIEnv * env, jobject calling_obj, jint itype, jstring uplo, jint n, jdoubleArray ap, jdoubleArray bp, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jdouble * jni_bp = (*env)->GetPrimitiveArrayCritical(env, bp, JNI_FALSE);
	check_memory(env, jni_bp);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dspgst_(&itype, jni_uplo, &n, jni_ap, jni_bp, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, bp, jni_bp, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dspgv (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring uplo, jint n, jdoubleArray ap, jdoubleArray bp, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jdouble * jni_bp = (*env)->GetPrimitiveArrayCritical(env, bp, JNI_FALSE);
	check_memory(env, jni_bp);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dspgv_(&itype, jni_jobz, jni_uplo, &n, jni_ap, jni_bp, jni_w, jni_z, &ldz, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, bp, jni_bp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dspgvd (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring uplo, jint n, jdoubleArray ap, jdoubleArray bp, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jdouble * jni_bp = (*env)->GetPrimitiveArrayCritical(env, bp, JNI_FALSE);
	check_memory(env, jni_bp);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dspgvd_(&itype, jni_jobz, jni_uplo, &n, jni_ap, jni_bp, jni_w, jni_z, &ldz, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, bp, jni_bp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dspgvx (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring range, jstring uplo, jint n, jdoubleArray ap, jdoubleArray bp, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jobject m, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jintArray iwork, jintArray ifail, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jdouble * jni_bp = (*env)->GetPrimitiveArrayCritical(env, bp, JNI_FALSE);
	check_memory(env, jni_bp);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jint * jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
	check_memory(env, jni_ifail);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dspgvx_(&itype, jni_jobz, jni_range, jni_uplo, &n, jni_ap, jni_bp, &vl, &vu, &il, &iu, &abstol, &jni_m, jni_w, jni_z, &ldz, jni_work, jni_iwork, jni_ifail, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, bp, jni_bp, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsprfs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jdoubleArray afp, jintArray ipiv, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jdouble * jni_afp = (*env)->GetPrimitiveArrayCritical(env, afp, JNI_FALSE);
	check_memory(env, jni_afp);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsprfs_(jni_uplo, &n, &nrhs, jni_ap, jni_afp, jni_ipiv, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, afp, jni_afp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dspsv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jintArray ipiv, jdoubleArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dspsv_(jni_uplo, &n, &nrhs, jni_ap, jni_ipiv, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dspsvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jdoubleArray afp, jintArray ipiv, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jobject rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jdouble * jni_afp = (*env)->GetPrimitiveArrayCritical(env, afp, JNI_FALSE);
	check_memory(env, jni_afp);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dspsvx_(jni_fact, jni_uplo, &n, &nrhs, jni_ap, jni_afp, jni_ipiv, jni_b, &ldb, jni_x, &ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, fact, jni_fact);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, afp, jni_afp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsptrd (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jdoubleArray d, jdoubleArray e, jdoubleArray tau, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsptrd_(jni_uplo, &n, jni_ap, jni_d, jni_e, jni_tau, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsptrf (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jintArray ipiv, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsptrf_(jni_uplo, &n, jni_ap, jni_ipiv, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsptri (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray ap, jintArray ipiv, jdoubleArray work, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsptri_(jni_uplo, &n, jni_ap, jni_ipiv, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsptrs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray ap, jintArray ipiv, jdoubleArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsptrs_(jni_uplo, &n, &nrhs, jni_ap, jni_ipiv, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dstebz (JNIEnv * env, jobject calling_obj, jstring range, jstring order, jint n, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jdoubleArray d, jdoubleArray e, jobject m, jobject nsplit, jdoubleArray w, jintArray iblock, jintArray isplit, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	char * jni_order = (char *)(*env)->GetStringUTFChars(env, order, JNI_FALSE);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jclass jni_nsplitClass = (*env)->GetObjectClass(env, nsplit);
	jfieldID jni_nsplitId = (*env)->GetFieldID(env, jni_nsplitClass, "val", "I");
	jint jni_nsplit = (*env)->GetIntField(env, nsplit, jni_nsplitId);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jint * jni_iblock = (*env)->GetPrimitiveArrayCritical(env, iblock, JNI_FALSE);
	check_memory(env, jni_iblock);
	jint * jni_isplit = (*env)->GetPrimitiveArrayCritical(env, isplit, JNI_FALSE);
	check_memory(env, jni_isplit);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dstebz_(jni_range, jni_order, &n, &vl, &vu, &il, &iu, &abstol, jni_d, jni_e, &jni_m, &jni_nsplit, jni_w, jni_iblock, jni_isplit, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleaseStringUTFChars(env, order, jni_order);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->SetIntField(env, nsplit, jni_nsplitId, jni_nsplit);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iblock, jni_iblock, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, isplit, jni_isplit, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dstedc (JNIEnv * env, jobject calling_obj, jstring compz, jint n, jdoubleArray d, jdoubleArray e, jdoubleArray z, jint ldz, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dstedc_(jni_compz, &n, jni_d, jni_e, jni_z, &ldz, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, compz, jni_compz);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dstegr (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jint n, jdoubleArray d, jdoubleArray e, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jobject m, jdoubleArray w, jdoubleArray z, jint ldz, jintArray isuppz, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jint * jni_isuppz = (*env)->GetPrimitiveArrayCritical(env, isuppz, JNI_FALSE);
	check_memory(env, jni_isuppz);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dstegr_(jni_jobz, jni_range, &n, jni_d, jni_e, &vl, &vu, &il, &iu, &abstol, &jni_m, jni_w, jni_z, &ldz, jni_isuppz, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, isuppz, jni_isuppz, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dstein (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray d, jdoubleArray e, jint m, jdoubleArray w, jintArray iblock, jintArray isplit, jdoubleArray z, jint ldz, jdoubleArray work, jintArray iwork, jintArray ifail, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jint * jni_iblock = (*env)->GetPrimitiveArrayCritical(env, iblock, JNI_FALSE);
	check_memory(env, jni_iblock);
	jint * jni_isplit = (*env)->GetPrimitiveArrayCritical(env, isplit, JNI_FALSE);
	check_memory(env, jni_isplit);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jint * jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
	check_memory(env, jni_ifail);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dstein_(&n, jni_d, jni_e, &m, jni_w, jni_iblock, jni_isplit, jni_z, &ldz, jni_work, jni_iwork, jni_ifail, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iblock, jni_iblock, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, isplit, jni_isplit, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsteqr (JNIEnv * env, jobject calling_obj, jstring compz, jint n, jdoubleArray d, jdoubleArray e, jdoubleArray z, jint ldz, jdoubleArray work, jobject info){
	char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsteqr_(jni_compz, &n, jni_d, jni_e, jni_z, &ldz, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, compz, jni_compz);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsterf (JNIEnv * env, jobject calling_obj, jint n, jdoubleArray d, jdoubleArray e, jobject info){
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsterf_(&n, jni_d, jni_e, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dstev (JNIEnv * env, jobject calling_obj, jstring jobz, jint n, jdoubleArray d, jdoubleArray e, jdoubleArray z, jint ldz, jdoubleArray work, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dstev_(jni_jobz, &n, jni_d, jni_e, jni_z, &ldz, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dstevd (JNIEnv * env, jobject calling_obj, jstring jobz, jint n, jdoubleArray d, jdoubleArray e, jdoubleArray z, jint ldz, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dstevd_(jni_jobz, &n, jni_d, jni_e, jni_z, &ldz, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dstevr (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jint n, jdoubleArray d, jdoubleArray e, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jobject m, jdoubleArray w, jdoubleArray z, jint ldz, jintArray isuppz, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jint * jni_isuppz = (*env)->GetPrimitiveArrayCritical(env, isuppz, JNI_FALSE);
	check_memory(env, jni_isuppz);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dstevr_(jni_jobz, jni_range, &n, jni_d, jni_e, &vl, &vu, &il, &iu, &abstol, &jni_m, jni_w, jni_z, &ldz, jni_isuppz, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, isuppz, jni_isuppz, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dstevx (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jint n, jdoubleArray d, jdoubleArray e, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jobject m, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jintArray iwork, jintArray ifail, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jint * jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
	check_memory(env, jni_ifail);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dstevx_(jni_jobz, jni_range, &n, jni_d, jni_e, &vl, &vu, &il, &iu, &abstol, &jni_m, jni_w, jni_z, &ldz, jni_work, jni_iwork, jni_ifail, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsycon (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jintArray ipiv, jdouble anorm, jobject rcond, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsycon_(jni_uplo, &n, jni_a, &lda, jni_ipiv, &anorm, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsyev (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jdoubleArray a, jint lda, jdoubleArray w, jdoubleArray work, jint lwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsyev_(jni_jobz, jni_uplo, &n, jni_a, &lda, jni_w, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsyevd (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jdoubleArray a, jint lda, jdoubleArray w, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsyevd_(jni_jobz, jni_uplo, &n, jni_a, &lda, jni_w, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsyevr (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jstring uplo, jint n, jdoubleArray a, jint lda, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jobject m, jdoubleArray w, jdoubleArray z, jint ldz, jintArray isuppz, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jint * jni_isuppz = (*env)->GetPrimitiveArrayCritical(env, isuppz, JNI_FALSE);
	check_memory(env, jni_isuppz);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsyevr_(jni_jobz, jni_range, jni_uplo, &n, jni_a, &lda, &vl, &vu, &il, &iu, &abstol, &jni_m, jni_w, jni_z, &ldz, jni_isuppz, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, isuppz, jni_isuppz, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsyevx (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jstring uplo, jint n, jdoubleArray a, jint lda, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jobject m, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jint lwork, jintArray iwork, jintArray ifail, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jint * jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
	check_memory(env, jni_ifail);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsyevx_(jni_jobz, jni_range, jni_uplo, &n, jni_a, &lda, &vl, &vu, &il, &iu, &abstol, &jni_m, jni_w, jni_z, &ldz, jni_work, &lwork, jni_iwork, jni_ifail, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsygs2 (JNIEnv * env, jobject calling_obj, jint itype, jstring uplo, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsygs2_(&itype, jni_uplo, &n, jni_a, &lda, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsygst (JNIEnv * env, jobject calling_obj, jint itype, jstring uplo, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsygst_(&itype, jni_uplo, &n, jni_a, &lda, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsygv (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring uplo, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray w, jdoubleArray work, jint lwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsygv_(&itype, jni_jobz, jni_uplo, &n, jni_a, &lda, jni_b, &ldb, jni_w, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsygvd (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring uplo, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray w, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsygvd_(&itype, jni_jobz, jni_uplo, &n, jni_a, &lda, jni_b, &ldb, jni_w, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsygvx (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring range, jstring uplo, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdouble vl, jdouble vu, jint il, jint iu, jdouble abstol, jobject m, jdoubleArray w, jdoubleArray z, jint ldz, jdoubleArray work, jint lwork, jintArray iwork, jintArray ifail, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jdouble * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jint * jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
	check_memory(env, jni_ifail);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsygvx_(&itype, jni_jobz, jni_range, jni_uplo, &n, jni_a, &lda, jni_b, &ldb, &vl, &vu, &il, &iu, &abstol, &jni_m, jni_w, jni_z, &ldz, jni_work, &lwork, jni_iwork, jni_ifail, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsyrfs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray af, jint ldaf, jintArray ipiv, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
	check_memory(env, jni_af);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsyrfs_(jni_uplo, &n, &nrhs, jni_a, &lda, jni_af, &ldaf, jni_ipiv, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsysv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint lda, jintArray ipiv, jdoubleArray b, jint ldb, jdoubleArray work, jint lwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsysv_(jni_uplo, &n, &nrhs, jni_a, &lda, jni_ipiv, jni_b, &ldb, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsysvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray af, jint ldaf, jintArray ipiv, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jobject rcond, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jint lwork, jintArray iwork, jobject info){
	char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
	check_memory(env, jni_af);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsysvx_(jni_fact, jni_uplo, &n, &nrhs, jni_a, &lda, jni_af, &ldaf, jni_ipiv, jni_b, &ldb, jni_x, &ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, &lwork, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, fact, jni_fact);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsytd2 (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jdoubleArray d, jdoubleArray e, jdoubleArray tau, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsytd2_(jni_uplo, &n, jni_a, &lda, jni_d, jni_e, jni_tau, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsytf2 (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jintArray ipiv, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsytf2_(jni_uplo, &n, jni_a, &lda, jni_ipiv, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsytrd (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jdoubleArray d, jdoubleArray e, jdoubleArray tau, jdoubleArray work, jint lwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsytrd_(jni_uplo, &n, jni_a, &lda, jni_d, jni_e, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsytrf (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jintArray ipiv, jdoubleArray work, jint lwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsytrf_(jni_uplo, &n, jni_a, &lda, jni_ipiv, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsytri (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jdoubleArray a, jint lda, jintArray ipiv, jdoubleArray work, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsytri_(jni_uplo, &n, jni_a, &lda, jni_ipiv, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dsytrs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jdoubleArray a, jint lda, jintArray ipiv, jdoubleArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dsytrs_(jni_uplo, &n, &nrhs, jni_a, &lda, jni_ipiv, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtbcon (JNIEnv * env, jobject calling_obj, jstring norm, jstring uplo, jstring diag, jint n, jint kd, jdoubleArray ab, jint ldab, jobject rcond, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtbcon_(jni_norm, jni_uplo, jni_diag, &n, &kd, jni_ab, &ldab, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, norm, jni_norm);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtbrfs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint kd, jint nrhs, jdoubleArray ab, jint ldab, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtbrfs_(jni_uplo, jni_trans, jni_diag, &n, &kd, &nrhs, jni_ab, &ldab, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtbtrs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint kd, jint nrhs, jdoubleArray ab, jint ldab, jdoubleArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jdouble * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtbtrs_(jni_uplo, jni_trans, jni_diag, &n, &kd, &nrhs, jni_ab, &ldab, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtgevc (JNIEnv * env, jobject calling_obj, jstring side, jstring howmny, jbooleanArray select, jint n, jdoubleArray s, jint lds, jdoubleArray p, jint ldp, jdoubleArray vl, jint ldvl, jdoubleArray vr, jint ldvr, jint mm, jobject m, jdoubleArray work, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
	jboolean * jni_selectTmp = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
	jint jni_selectSize = (*env)->GetArrayLength(env, select);
	logical jni_select[jni_selectSize];
	int jni_selecti;
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jdouble * jni_p = (*env)->GetPrimitiveArrayCritical(env, p, JNI_FALSE);
	check_memory(env, jni_p);
	jdouble * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jdouble * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_selectTmp[jni_selecti] == JNI_FALSE){
			jni_select[jni_selecti] = 0;
		} else {
			jni_select[jni_selecti] = 1;
		}
	}

	dtgevc_(jni_side, jni_howmny, jni_select, &n, jni_s, &lds, jni_p, &ldp, jni_vl, &ldvl, jni_vr, &ldvr, &mm, &jni_m, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_select[jni_selecti] == 0){
			jni_selectTmp[jni_selecti] = JNI_FALSE;
		} else {
			jni_selectTmp[jni_selecti] = JNI_TRUE;
		}
	}
	(*env)->ReleasePrimitiveArrayCritical(env, select, jni_selectTmp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, p, jni_p, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtgex2 (JNIEnv * env, jobject calling_obj, jboolean wantq, jboolean wantz, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray q, jint ldq, jdoubleArray z, jint ldz, jint j1, jint n1, jint n2, jdoubleArray work, jint lwork, jobject info){
	logical jni_wantq = (logical)wantq;
	logical jni_wantz = (logical)wantz;
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtgex2_(&jni_wantq, &jni_wantz, &n, jni_a, &lda, jni_b, &ldb, jni_q, &ldq, jni_z, &ldz, &j1, &n1, &n2, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtgexc (JNIEnv * env, jobject calling_obj, jboolean wantq, jboolean wantz, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray q, jint ldq, jdoubleArray z, jint ldz, jobject ifst, jobject ilst, jdoubleArray work, jint lwork, jobject info){
	logical jni_wantq = (logical)wantq;
	logical jni_wantz = (logical)wantz;
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_ifstClass = (*env)->GetObjectClass(env, ifst);
	jfieldID jni_ifstId = (*env)->GetFieldID(env, jni_ifstClass, "val", "I");
	jint jni_ifst = (*env)->GetIntField(env, ifst, jni_ifstId);
	jclass jni_ilstClass = (*env)->GetObjectClass(env, ilst);
	jfieldID jni_ilstId = (*env)->GetFieldID(env, jni_ilstClass, "val", "I");
	jint jni_ilst = (*env)->GetIntField(env, ilst, jni_ilstId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtgexc_(&jni_wantq, &jni_wantz, &n, jni_a, &lda, jni_b, &ldb, jni_q, &ldq, jni_z, &ldz, &jni_ifst, &jni_ilst, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetIntField(env, ifst, jni_ifstId, jni_ifst);
	(*env)->SetIntField(env, ilst, jni_ilstId, jni_ilst);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtgsen (JNIEnv * env, jobject calling_obj, jint ijob, jboolean wantq, jboolean wantz, jbooleanArray select, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray alphar, jdoubleArray alphai, jdoubleArray beta, jdoubleArray q, jint ldq, jdoubleArray z, jint ldz, jobject m, jobject pl, jobject pr, jdoubleArray dif, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	logical jni_wantq = (logical)wantq;
	logical jni_wantz = (logical)wantz;
	jboolean * jni_selectTmp = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
	jint jni_selectSize = (*env)->GetArrayLength(env, select);
	logical jni_select[jni_selectSize];
	int jni_selecti;
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
	check_memory(env, jni_alphar);
	jdouble * jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
	check_memory(env, jni_alphai);
	jdouble * jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
	check_memory(env, jni_beta);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jdouble * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jclass jni_plClass = (*env)->GetObjectClass(env, pl);
	jfieldID jni_plId = (*env)->GetFieldID(env, jni_plClass, "val", "D");
	jdouble jni_pl = (*env)->GetDoubleField(env, pl, jni_plId);
	jclass jni_prClass = (*env)->GetObjectClass(env, pr);
	jfieldID jni_prId = (*env)->GetFieldID(env, jni_prClass, "val", "D");
	jdouble jni_pr = (*env)->GetDoubleField(env, pr, jni_prId);
	jdouble * jni_dif = (*env)->GetPrimitiveArrayCritical(env, dif, JNI_FALSE);
	check_memory(env, jni_dif);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_selectTmp[jni_selecti] == JNI_FALSE){
			jni_select[jni_selecti] = 0;
		} else {
			jni_select[jni_selecti] = 1;
		}
	}

	dtgsen_(&ijob, &jni_wantq, &jni_wantz, jni_select, &n, jni_a, &lda, jni_b, &ldb, jni_alphar, jni_alphai, jni_beta, jni_q, &ldq, jni_z, &ldz, &jni_m, &jni_pl, &jni_pr, jni_dif, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_select[jni_selecti] == 0){
			jni_selectTmp[jni_selecti] = JNI_FALSE;
		} else {
			jni_selectTmp[jni_selecti] = JNI_TRUE;
		}
	}
	(*env)->ReleasePrimitiveArrayCritical(env, select, jni_selectTmp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->SetDoubleField(env, pl, jni_plId, jni_pl);
	(*env)->SetDoubleField(env, pr, jni_prId, jni_pr);
	(*env)->ReleasePrimitiveArrayCritical(env, dif, jni_dif, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtgsja (JNIEnv * env, jobject calling_obj, jstring jobu, jstring jobv, jstring jobq, jint m, jint p, jint n, jint k, jint l, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdouble tola, jdouble tolb, jdoubleArray alpha, jdoubleArray beta, jdoubleArray u, jint ldu, jdoubleArray v, jint ldv, jdoubleArray q, jint ldq, jdoubleArray work, jobject ncycle, jobject info){
	char * jni_jobu = (char *)(*env)->GetStringUTFChars(env, jobu, JNI_FALSE);
	char * jni_jobv = (char *)(*env)->GetStringUTFChars(env, jobv, JNI_FALSE);
	char * jni_jobq = (char *)(*env)->GetStringUTFChars(env, jobq, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_alpha = (*env)->GetPrimitiveArrayCritical(env, alpha, JNI_FALSE);
	check_memory(env, jni_alpha);
	jdouble * jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
	check_memory(env, jni_beta);
	jdouble * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jdouble * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_ncycleClass = (*env)->GetObjectClass(env, ncycle);
	jfieldID jni_ncycleId = (*env)->GetFieldID(env, jni_ncycleClass, "val", "I");
	jint jni_ncycle = (*env)->GetIntField(env, ncycle, jni_ncycleId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtgsja_(jni_jobu, jni_jobv, jni_jobq, &m, &p, &n, &k, &l, jni_a, &lda, jni_b, &ldb, &tola, &tolb, jni_alpha, jni_beta, jni_u, &ldu, jni_v, &ldv, jni_q, &ldq, jni_work, &jni_ncycle, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobu, jni_jobu);
	(*env)->ReleaseStringUTFChars(env, jobv, jni_jobv);
	(*env)->ReleaseStringUTFChars(env, jobq, jni_jobq);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alpha, jni_alpha, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, ncycle, jni_ncycleId, jni_ncycle);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtgsna (JNIEnv * env, jobject calling_obj, jstring job, jstring howmny, jbooleanArray select, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray vl, jint ldvl, jdoubleArray vr, jint ldvr, jdoubleArray s, jdoubleArray dif, jint mm, jobject m, jdoubleArray work, jint lwork, jintArray iwork, jobject info){
	char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
	char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
	jboolean * jni_selectTmp = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
	jint jni_selectSize = (*env)->GetArrayLength(env, select);
	logical jni_select[jni_selectSize];
	int jni_selecti;
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jdouble * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jdouble * jni_dif = (*env)->GetPrimitiveArrayCritical(env, dif, JNI_FALSE);
	check_memory(env, jni_dif);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_selectTmp[jni_selecti] == JNI_FALSE){
			jni_select[jni_selecti] = 0;
		} else {
			jni_select[jni_selecti] = 1;
		}
	}

	dtgsna_(jni_job, jni_howmny, jni_select, &n, jni_a, &lda, jni_b, &ldb, jni_vl, &ldvl, jni_vr, &ldvr, jni_s, jni_dif, &mm, &jni_m, jni_work, &lwork, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, job, jni_job);
	(*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_select[jni_selecti] == 0){
			jni_selectTmp[jni_selecti] = JNI_FALSE;
		} else {
			jni_selectTmp[jni_selecti] = JNI_TRUE;
		}
	}
	(*env)->ReleasePrimitiveArrayCritical(env, select, jni_selectTmp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dif, jni_dif, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtgsy2 (JNIEnv * env, jobject calling_obj, jstring trans, jint ijob, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray c, jint Ldc, jdoubleArray d, jint ldd, jdoubleArray e, jint lde, jdoubleArray f, jint ldf, jobject scale, jobject rdsum, jobject rdscal, jintArray iwork, jobject pq, jobject info){
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_f = (*env)->GetPrimitiveArrayCritical(env, f, JNI_FALSE);
	check_memory(env, jni_f);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jdouble jni_scale = (*env)->GetDoubleField(env, scale, jni_scaleId);
	jclass jni_rdsumClass = (*env)->GetObjectClass(env, rdsum);
	jfieldID jni_rdsumId = (*env)->GetFieldID(env, jni_rdsumClass, "val", "D");
	jdouble jni_rdsum = (*env)->GetDoubleField(env, rdsum, jni_rdsumId);
	jclass jni_rdscalClass = (*env)->GetObjectClass(env, rdscal);
	jfieldID jni_rdscalId = (*env)->GetFieldID(env, jni_rdscalClass, "val", "D");
	jdouble jni_rdscal = (*env)->GetDoubleField(env, rdscal, jni_rdscalId);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_pqClass = (*env)->GetObjectClass(env, pq);
	jfieldID jni_pqId = (*env)->GetFieldID(env, jni_pqClass, "val", "I");
	jint jni_pq = (*env)->GetIntField(env, pq, jni_pqId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtgsy2_(jni_trans, &ijob, &m, &n, jni_a, &lda, jni_b, &ldb, jni_c, &Ldc, jni_d, &ldd, jni_e, &lde, jni_f, &ldf, &jni_scale, &jni_rdsum, &jni_rdscal, jni_iwork, &jni_pq, &jni_info);

	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, f, jni_f, 0);
	(*env)->SetDoubleField(env, scale, jni_scaleId, jni_scale);
	(*env)->SetDoubleField(env, rdsum, jni_rdsumId, jni_rdsum);
	(*env)->SetDoubleField(env, rdscal, jni_rdscalId, jni_rdscal);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, pq, jni_pqId, jni_pq);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtgsyl (JNIEnv * env, jobject calling_obj, jstring trans, jint ijob, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray c, jint Ldc, jdoubleArray d, jint ldd, jdoubleArray e, jint lde, jdoubleArray f, jint ldf, jobject scale, jobject dif, jdoubleArray work, jint lwork, jintArray iwork, jobject info){
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jdouble * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jdouble * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jdouble * jni_f = (*env)->GetPrimitiveArrayCritical(env, f, JNI_FALSE);
	check_memory(env, jni_f);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jdouble jni_scale = (*env)->GetDoubleField(env, scale, jni_scaleId);
	jclass jni_difClass = (*env)->GetObjectClass(env, dif);
	jfieldID jni_difId = (*env)->GetFieldID(env, jni_difClass, "val", "D");
	jdouble jni_dif = (*env)->GetDoubleField(env, dif, jni_difId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtgsyl_(jni_trans, &ijob, &m, &n, jni_a, &lda, jni_b, &ldb, jni_c, &Ldc, jni_d, &ldd, jni_e, &lde, jni_f, &ldf, &jni_scale, &jni_dif, jni_work, &lwork, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, f, jni_f, 0);
	(*env)->SetDoubleField(env, scale, jni_scaleId, jni_scale);
	(*env)->SetDoubleField(env, dif, jni_difId, jni_dif);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtpcon (JNIEnv * env, jobject calling_obj, jstring norm, jstring uplo, jstring diag, jint n, jdoubleArray ap, jobject rcond, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtpcon_(jni_norm, jni_uplo, jni_diag, &n, jni_ap, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, norm, jni_norm);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtprfs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint nrhs, jdoubleArray ap, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtprfs_(jni_uplo, jni_trans, jni_diag, &n, &nrhs, jni_ap, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtptri (JNIEnv * env, jobject calling_obj, jstring uplo, jstring diag, jint n, jdoubleArray ap, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtptri_(jni_uplo, jni_diag, &n, jni_ap, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtptrs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint nrhs, jdoubleArray ap, jdoubleArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jdouble * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtptrs_(jni_uplo, jni_trans, jni_diag, &n, &nrhs, jni_ap, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtrcon (JNIEnv * env, jobject calling_obj, jstring norm, jstring uplo, jstring diag, jint n, jdoubleArray a, jint lda, jobject rcond, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jdouble jni_rcond = (*env)->GetDoubleField(env, rcond, jni_rcondId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtrcon_(jni_norm, jni_uplo, jni_diag, &n, jni_a, &lda, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, norm, jni_norm);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetDoubleField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtrevc (JNIEnv * env, jobject calling_obj, jstring side, jstring howmny, jbooleanArray select, jint n, jdoubleArray t, jint ldt, jdoubleArray vl, jint ldvl, jdoubleArray vr, jint ldvr, jint mm, jobject m, jdoubleArray work, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
	jboolean * jni_selectTmp = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
	jint jni_selectSize = (*env)->GetArrayLength(env, select);
	logical jni_select[jni_selectSize];
	int jni_selecti;
	jdouble * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);
	jdouble * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jdouble * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_selectTmp[jni_selecti] == JNI_FALSE){
			jni_select[jni_selecti] = 0;
		} else {
			jni_select[jni_selecti] = 1;
		}
	}

	dtrevc_(jni_side, jni_howmny, jni_select, &n, jni_t, &ldt, jni_vl, &ldvl, jni_vr, &ldvr, &mm, &jni_m, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_select[jni_selecti] == 0){
			jni_selectTmp[jni_selecti] = JNI_FALSE;
		} else {
			jni_selectTmp[jni_selecti] = JNI_TRUE;
		}
	}
	(*env)->ReleasePrimitiveArrayCritical(env, select, jni_selectTmp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtrexc (JNIEnv * env, jobject calling_obj, jstring compq, jint n, jdoubleArray t, jint ldt, jdoubleArray q, jint ldq, jobject ifst, jobject ilst, jdoubleArray work, jobject info){
	char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
	jdouble * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jclass jni_ifstClass = (*env)->GetObjectClass(env, ifst);
	jfieldID jni_ifstId = (*env)->GetFieldID(env, jni_ifstClass, "val", "I");
	jint jni_ifst = (*env)->GetIntField(env, ifst, jni_ifstId);
	jclass jni_ilstClass = (*env)->GetObjectClass(env, ilst);
	jfieldID jni_ilstId = (*env)->GetFieldID(env, jni_ilstClass, "val", "I");
	jint jni_ilst = (*env)->GetIntField(env, ilst, jni_ilstId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtrexc_(jni_compq, &n, jni_t, &ldt, jni_q, &ldq, &jni_ifst, &jni_ilst, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, compq, jni_compq);
	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->SetIntField(env, ifst, jni_ifstId, jni_ifst);
	(*env)->SetIntField(env, ilst, jni_ilstId, jni_ilst);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtrrfs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray x, jint ldx, jdoubleArray ferr, jdoubleArray berr, jdoubleArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jdouble * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jdouble * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtrrfs_(jni_uplo, jni_trans, jni_diag, &n, &nrhs, jni_a, &lda, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtrsen (JNIEnv * env, jobject calling_obj, jstring job, jstring compq, jbooleanArray select, jint n, jdoubleArray t, jint ldt, jdoubleArray q, jint ldq, jdoubleArray wr, jdoubleArray wi, jobject m, jobject s, jobject sep, jdoubleArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
	char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
	jboolean * jni_selectTmp = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
	jint jni_selectSize = (*env)->GetArrayLength(env, select);
	logical jni_select[jni_selectSize];
	int jni_selecti;
	jdouble * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);
	jdouble * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jdouble * jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
	check_memory(env, jni_wr);
	jdouble * jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
	check_memory(env, jni_wi);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jclass jni_sClass = (*env)->GetObjectClass(env, s);
	jfieldID jni_sId = (*env)->GetFieldID(env, jni_sClass, "val", "D");
	jdouble jni_s = (*env)->GetDoubleField(env, s, jni_sId);
	jclass jni_sepClass = (*env)->GetObjectClass(env, sep);
	jfieldID jni_sepId = (*env)->GetFieldID(env, jni_sepClass, "val", "D");
	jdouble jni_sep = (*env)->GetDoubleField(env, sep, jni_sepId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_selectTmp[jni_selecti] == JNI_FALSE){
			jni_select[jni_selecti] = 0;
		} else {
			jni_select[jni_selecti] = 1;
		}
	}

	dtrsen_(jni_job, jni_compq, jni_select, &n, jni_t, &ldt, jni_q, &ldq, jni_wr, jni_wi, &jni_m, &jni_s, &jni_sep, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, job, jni_job);
	(*env)->ReleaseStringUTFChars(env, compq, jni_compq);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_select[jni_selecti] == 0){
			jni_selectTmp[jni_selecti] = JNI_FALSE;
		} else {
			jni_selectTmp[jni_selecti] = JNI_TRUE;
		}
	}
	(*env)->ReleasePrimitiveArrayCritical(env, select, jni_selectTmp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->SetDoubleField(env, s, jni_sId, jni_s);
	(*env)->SetDoubleField(env, sep, jni_sepId, jni_sep);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtrsna (JNIEnv * env, jobject calling_obj, jstring job, jstring howmny, jbooleanArray select, jint n, jdoubleArray t, jint ldt, jdoubleArray vl, jint ldvl, jdoubleArray vr, jint ldvr, jdoubleArray s, jdoubleArray sep, jint mm, jobject m, jdoubleArray work, jint ldwork, jintArray iwork, jobject info){
	char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
	char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
	jboolean * jni_selectTmp = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
	jint jni_selectSize = (*env)->GetArrayLength(env, select);
	logical jni_select[jni_selectSize];
	int jni_selecti;
	jdouble * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);
	jdouble * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jdouble * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jdouble * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jdouble * jni_sep = (*env)->GetPrimitiveArrayCritical(env, sep, JNI_FALSE);
	check_memory(env, jni_sep);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_selectTmp[jni_selecti] == JNI_FALSE){
			jni_select[jni_selecti] = 0;
		} else {
			jni_select[jni_selecti] = 1;
		}
	}

	dtrsna_(jni_job, jni_howmny, jni_select, &n, jni_t, &ldt, jni_vl, &ldvl, jni_vr, &ldvr, jni_s, jni_sep, &mm, &jni_m, jni_work, &ldwork, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, job, jni_job);
	(*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_select[jni_selecti] == 0){
			jni_selectTmp[jni_selecti] = JNI_FALSE;
		} else {
			jni_selectTmp[jni_selecti] = JNI_TRUE;
		}
	}
	(*env)->ReleasePrimitiveArrayCritical(env, select, jni_selectTmp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, sep, jni_sep, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtrsyl (JNIEnv * env, jobject calling_obj, jstring trana, jstring tranb, jint isgn, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jdoubleArray c, jint Ldc, jobject scale, jobject info){
	char * jni_trana = (char *)(*env)->GetStringUTFChars(env, trana, JNI_FALSE);
	char * jni_tranb = (char *)(*env)->GetStringUTFChars(env, tranb, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jdouble * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jdouble jni_scale = (*env)->GetDoubleField(env, scale, jni_scaleId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtrsyl_(jni_trana, jni_tranb, &isgn, &m, &n, jni_a, &lda, jni_b, &ldb, jni_c, &Ldc, &jni_scale, &jni_info);

	(*env)->ReleaseStringUTFChars(env, trana, jni_trana);
	(*env)->ReleaseStringUTFChars(env, tranb, jni_tranb);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->SetDoubleField(env, scale, jni_scaleId, jni_scale);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtrti2 (JNIEnv * env, jobject calling_obj, jstring uplo, jstring diag, jint n, jdoubleArray a, jint lda, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtrti2_(jni_uplo, jni_diag, &n, jni_a, &lda, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtrtri (JNIEnv * env, jobject calling_obj, jstring uplo, jstring diag, jint n, jdoubleArray a, jint lda, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtrtri_(jni_uplo, jni_diag, &n, jni_a, &lda, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtrtrs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint nrhs, jdoubleArray a, jint lda, jdoubleArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtrtrs_(jni_uplo, jni_trans, jni_diag, &n, &nrhs, jni_a, &lda, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtzrqf (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtzrqf_(&m, &n, jni_a, &lda, jni_tau, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_dtzrzf (JNIEnv * env, jobject calling_obj, jint m, jint n, jdoubleArray a, jint lda, jdoubleArray tau, jdoubleArray work, jint lwork, jobject info){
	jdouble * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jdouble * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jdouble * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	dtzrzf_(&m, &n, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT jint JNICALL Java_org_netlib_lapack_NativeLAPACK_ieeeck (JNIEnv * env, jobject calling_obj, jint ispec, jfloat zero, jfloat one){
	jint returnValue;

	returnValue = ieeeck_(&ispec, &zero, &one);


	return returnValue;
}

JNIEXPORT jint JNICALL Java_org_netlib_lapack_NativeLAPACK_ilaenv (JNIEnv * env, jobject calling_obj, jint ispec, jstring name, jstring opts, jint n1, jint n2, jint n3, jint n4){
	char * jni_name = (char *)(*env)->GetStringUTFChars(env, name, JNI_FALSE);
	char * jni_opts = (char *)(*env)->GetStringUTFChars(env, opts, JNI_FALSE);
	jint returnValue;

	returnValue = ilaenv_(&ispec, jni_name, jni_opts, &n1, &n2, &n3, &n4, (*env)->GetStringLength(env, name), (*env)->GetStringLength(env, opts));

	(*env)->ReleaseStringUTFChars(env, name, jni_name);
	(*env)->ReleaseStringUTFChars(env, opts, jni_opts);

	return returnValue;
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sbdsdc (JNIEnv * env, jobject calling_obj, jstring uplo, jstring compq, jint n, jfloatArray d, jfloatArray e, jfloatArray u, jint ldu, jfloatArray vt, jint ldvt, jfloatArray q, jintArray iq, jfloatArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jfloat * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jint * jni_iq = (*env)->GetPrimitiveArrayCritical(env, iq, JNI_FALSE);
	check_memory(env, jni_iq);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sbdsdc_(jni_uplo, jni_compq, &n, jni_d, jni_e, jni_u, &ldu, jni_vt, &ldvt, jni_q, jni_iq, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, compq, jni_compq);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iq, jni_iq, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sbdsqr (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint ncvt, jint nru, jint ncc, jfloatArray d, jfloatArray e, jfloatArray vt, jint ldvt, jfloatArray u, jint ldu, jfloatArray c, jint Ldc, jfloatArray work, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jfloat * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sbdsqr_(jni_uplo, &n, &ncvt, &nru, &ncc, jni_d, jni_e, jni_vt, &ldvt, jni_u, &ldu, jni_c, &Ldc, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sdisna (JNIEnv * env, jobject calling_obj, jstring job, jint m, jint n, jfloatArray d, jfloatArray sep, jobject info){
	char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_sep = (*env)->GetPrimitiveArrayCritical(env, sep, JNI_FALSE);
	check_memory(env, jni_sep);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sdisna_(jni_job, &m, &n, jni_d, jni_sep, &jni_info);

	(*env)->ReleaseStringUTFChars(env, job, jni_job);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, sep, jni_sep, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgbbrd (JNIEnv * env, jobject calling_obj, jstring vect, jint m, jint n, jint ncc, jint kl, jint ku, jfloatArray ab, jint ldab, jfloatArray d, jfloatArray e, jfloatArray q, jint ldq, jfloatArray pt, jint ldpt, jfloatArray c, jint Ldc, jfloatArray work, jobject info){
	char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jfloat * jni_pt = (*env)->GetPrimitiveArrayCritical(env, pt, JNI_FALSE);
	check_memory(env, jni_pt);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgbbrd_(jni_vect, &m, &n, &ncc, &kl, &ku, jni_ab, &ldab, jni_d, jni_e, jni_q, &ldq, jni_pt, &ldpt, jni_c, &Ldc, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, vect, jni_vect);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, pt, jni_pt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgbcon (JNIEnv * env, jobject calling_obj, jstring norm, jint n, jint kl, jint ku, jfloatArray ab, jint ldab, jintArray ipiv, jfloat anorm, jobject rcond, jfloatArray work, jintArray iwork, jobject info){
	char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgbcon_(jni_norm, &n, &kl, &ku, jni_ab, &ldab, jni_ipiv, &anorm, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, norm, jni_norm);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgbequ (JNIEnv * env, jobject calling_obj, jint m, jint n, jint kl, jint ku, jfloatArray ab, jint ldab, jfloatArray r, jfloatArray c, jobject rowcnd, jobject colcnd, jobject amax, jobject info){
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
	check_memory(env, jni_r);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jclass jni_rowcndClass = (*env)->GetObjectClass(env, rowcnd);
	jfieldID jni_rowcndId = (*env)->GetFieldID(env, jni_rowcndClass, "val", "D");
	jfloat jni_rowcnd = (*env)->GetFloatField(env, rowcnd, jni_rowcndId);
	jclass jni_colcndClass = (*env)->GetObjectClass(env, colcnd);
	jfieldID jni_colcndId = (*env)->GetFieldID(env, jni_colcndClass, "val", "D");
	jfloat jni_colcnd = (*env)->GetFloatField(env, colcnd, jni_colcndId);
	jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
	jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "D");
	jfloat jni_amax = (*env)->GetFloatField(env, amax, jni_amaxId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgbequ_(&m, &n, &kl, &ku, jni_ab, &ldab, jni_r, jni_c, &jni_rowcnd, &jni_colcnd, &jni_amax, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->SetFloatField(env, rowcnd, jni_rowcndId, jni_rowcnd);
	(*env)->SetFloatField(env, colcnd, jni_colcndId, jni_colcnd);
	(*env)->SetFloatField(env, amax, jni_amaxId, jni_amax);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgbrfs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint kl, jint ku, jint nrhs, jfloatArray ab, jint ldab, jfloatArray afb, jint ldafb, jintArray ipiv, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jobject info){
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_afb = (*env)->GetPrimitiveArrayCritical(env, afb, JNI_FALSE);
	check_memory(env, jni_afb);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgbrfs_(jni_trans, &n, &kl, &ku, &nrhs, jni_ab, &ldab, jni_afb, &ldafb, jni_ipiv, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, afb, jni_afb, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgbsv (JNIEnv * env, jobject calling_obj, jint n, jint kl, jint ku, jint nrhs, jfloatArray ab, jint ldab, jintArray ipiv, jfloatArray b, jint ldb, jobject info){
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgbsv_(&n, &kl, &ku, &nrhs, jni_ab, &ldab, jni_ipiv, jni_b, &ldb, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgbsvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring trans, jint n, jint kl, jint ku, jint nrhs, jfloatArray ab, jint ldab, jfloatArray afb, jint ldafb, jintArray ipiv, jobject equed, jfloatArray r, jfloatArray c, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jobject rcond, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jobject info){
	char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_afb = (*env)->GetPrimitiveArrayCritical(env, afb, JNI_FALSE);
	check_memory(env, jni_afb);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
	jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
	jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
	char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
	jfloat * jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
	check_memory(env, jni_r);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgbsvx_(jni_fact, jni_trans, &n, &kl, &ku, &nrhs, jni_ab, &ldab, jni_afb, &ldafb, jni_ipiv, jni_equed, jni_r, jni_c, jni_b, &ldb, jni_x, &ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, fact, jni_fact);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, afb, jni_afb, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	jstring jni_equedStringNew = (*env)->NewStringUTF(env, jni_equed);
	(*env)->SetObjectField(env, equed, jni_equedId, jni_equedStringNew);
	(*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgbtf2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jint kl, jint ku, jfloatArray ab, jint ldab, jintArray ipiv, jobject info){
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgbtf2_(&m, &n, &kl, &ku, jni_ab, &ldab, jni_ipiv, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgbtrf (JNIEnv * env, jobject calling_obj, jint m, jint n, jint kl, jint ku, jfloatArray ab, jint ldab, jintArray ipiv, jobject info){
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgbtrf_(&m, &n, &kl, &ku, jni_ab, &ldab, jni_ipiv, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgbtrs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint kl, jint ku, jint nrhs, jfloatArray ab, jint ldab, jintArray ipiv, jfloatArray b, jint ldb, jobject info){
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgbtrs_(jni_trans, &n, &kl, &ku, &nrhs, jni_ab, &ldab, jni_ipiv, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgebak (JNIEnv * env, jobject calling_obj, jstring job, jstring side, jint n, jint ilo, jint ihi, jfloatArray scale, jint m, jfloatArray v, jint ldv, jobject info){
	char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	jfloat * jni_scale = (*env)->GetPrimitiveArrayCritical(env, scale, JNI_FALSE);
	check_memory(env, jni_scale);
	jfloat * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgebak_(jni_job, jni_side, &n, &ilo, &ihi, jni_scale, &m, jni_v, &ldv, &jni_info);

	(*env)->ReleaseStringUTFChars(env, job, jni_job);
	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleasePrimitiveArrayCritical(env, scale, jni_scale, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgebal (JNIEnv * env, jobject calling_obj, jstring job, jint n, jfloatArray a, jint lda, jobject ilo, jobject ihi, jfloatArray scale, jobject info){
	char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
	jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
	jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
	jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
	jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
	jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
	jfloat * jni_scale = (*env)->GetPrimitiveArrayCritical(env, scale, JNI_FALSE);
	check_memory(env, jni_scale);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgebal_(jni_job, &n, jni_a, &lda, &jni_ilo, &jni_ihi, jni_scale, &jni_info);

	(*env)->ReleaseStringUTFChars(env, job, jni_job);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
	(*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
	(*env)->ReleasePrimitiveArrayCritical(env, scale, jni_scale, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgebd2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jfloatArray d, jfloatArray e, jfloatArray tauq, jfloatArray taup, jfloatArray work, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_tauq = (*env)->GetPrimitiveArrayCritical(env, tauq, JNI_FALSE);
	check_memory(env, jni_tauq);
	jfloat * jni_taup = (*env)->GetPrimitiveArrayCritical(env, taup, JNI_FALSE);
	check_memory(env, jni_taup);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgebd2_(&m, &n, jni_a, &lda, jni_d, jni_e, jni_tauq, jni_taup, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tauq, jni_tauq, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, taup, jni_taup, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgebrd (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jfloatArray d, jfloatArray e, jfloatArray tauq, jfloatArray taup, jfloatArray work, jint lwork, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_tauq = (*env)->GetPrimitiveArrayCritical(env, tauq, JNI_FALSE);
	check_memory(env, jni_tauq);
	jfloat * jni_taup = (*env)->GetPrimitiveArrayCritical(env, taup, JNI_FALSE);
	check_memory(env, jni_taup);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgebrd_(&m, &n, jni_a, &lda, jni_d, jni_e, jni_tauq, jni_taup, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tauq, jni_tauq, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, taup, jni_taup, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgecon (JNIEnv * env, jobject calling_obj, jstring norm, jint n, jfloatArray a, jint lda, jfloat anorm, jobject rcond, jfloatArray work, jintArray iwork, jobject info){
	char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgecon_(jni_norm, &n, jni_a, &lda, &anorm, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, norm, jni_norm);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgeequ (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jfloatArray r, jfloatArray c, jobject rowcnd, jobject colcnd, jobject amax, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
	check_memory(env, jni_r);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jclass jni_rowcndClass = (*env)->GetObjectClass(env, rowcnd);
	jfieldID jni_rowcndId = (*env)->GetFieldID(env, jni_rowcndClass, "val", "D");
	jfloat jni_rowcnd = (*env)->GetFloatField(env, rowcnd, jni_rowcndId);
	jclass jni_colcndClass = (*env)->GetObjectClass(env, colcnd);
	jfieldID jni_colcndId = (*env)->GetFieldID(env, jni_colcndClass, "val", "D");
	jfloat jni_colcnd = (*env)->GetFloatField(env, colcnd, jni_colcndId);
	jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
	jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "D");
	jfloat jni_amax = (*env)->GetFloatField(env, amax, jni_amaxId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgeequ_(&m, &n, jni_a, &lda, jni_r, jni_c, &jni_rowcnd, &jni_colcnd, &jni_amax, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->SetFloatField(env, rowcnd, jni_rowcndId, jni_rowcnd);
	(*env)->SetFloatField(env, colcnd, jni_colcndId, jni_colcnd);
	(*env)->SetFloatField(env, amax, jni_amaxId, jni_amax);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgeev (JNIEnv * env, jobject calling_obj, jstring jobvl, jstring jobvr, jint n, jfloatArray a, jint lda, jfloatArray wr, jfloatArray wi, jfloatArray vl, jint ldvl, jfloatArray vr, jint ldvr, jfloatArray work, jint lwork, jobject info){
	char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
	char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
	check_memory(env, jni_wr);
	jfloat * jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
	check_memory(env, jni_wi);
	jfloat * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jfloat * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgeev_(jni_jobvl, jni_jobvr, &n, jni_a, &lda, jni_wr, jni_wi, jni_vl, &ldvl, jni_vr, &ldvr, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
	(*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgeevx (JNIEnv * env, jobject calling_obj, jstring balanc, jstring jobvl, jstring jobvr, jstring sense, jint n, jfloatArray a, jint lda, jfloatArray wr, jfloatArray wi, jfloatArray vl, jint ldvl, jfloatArray vr, jint ldvr, jobject ilo, jobject ihi, jfloatArray scale, jobject abnrm, jfloatArray rconde, jfloatArray rcondv, jfloatArray work, jint lwork, jintArray iwork, jobject info){
	char * jni_balanc = (char *)(*env)->GetStringUTFChars(env, balanc, JNI_FALSE);
	char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
	char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
	char * jni_sense = (char *)(*env)->GetStringUTFChars(env, sense, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
	check_memory(env, jni_wr);
	jfloat * jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
	check_memory(env, jni_wi);
	jfloat * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jfloat * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
	jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
	jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
	jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
	jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
	jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
	jfloat * jni_scale = (*env)->GetPrimitiveArrayCritical(env, scale, JNI_FALSE);
	check_memory(env, jni_scale);
	jclass jni_abnrmClass = (*env)->GetObjectClass(env, abnrm);
	jfieldID jni_abnrmId = (*env)->GetFieldID(env, jni_abnrmClass, "val", "D");
	jfloat jni_abnrm = (*env)->GetFloatField(env, abnrm, jni_abnrmId);
	jfloat * jni_rconde = (*env)->GetPrimitiveArrayCritical(env, rconde, JNI_FALSE);
	check_memory(env, jni_rconde);
	jfloat * jni_rcondv = (*env)->GetPrimitiveArrayCritical(env, rcondv, JNI_FALSE);
	check_memory(env, jni_rcondv);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgeevx_(jni_balanc, jni_jobvl, jni_jobvr, jni_sense, &n, jni_a, &lda, jni_wr, jni_wi, jni_vl, &ldvl, jni_vr, &ldvr, &jni_ilo, &jni_ihi, jni_scale, &jni_abnrm, jni_rconde, jni_rcondv, jni_work, &lwork, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, balanc, jni_balanc);
	(*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
	(*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
	(*env)->ReleaseStringUTFChars(env, sense, jni_sense);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
	(*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
	(*env)->ReleasePrimitiveArrayCritical(env, scale, jni_scale, 0);
	(*env)->SetFloatField(env, abnrm, jni_abnrmId, jni_abnrm);
	(*env)->ReleasePrimitiveArrayCritical(env, rconde, jni_rconde, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, rcondv, jni_rcondv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgegs (JNIEnv * env, jobject calling_obj, jstring jobvsl, jstring jobvsr, jint n, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray alphar, jfloatArray alphai, jfloatArray beta, jfloatArray vsl, jint ldvsl, jfloatArray vsr, jint ldvsr, jfloatArray work, jint lwork, jobject info){
	char * jni_jobvsl = (char *)(*env)->GetStringUTFChars(env, jobvsl, JNI_FALSE);
	char * jni_jobvsr = (char *)(*env)->GetStringUTFChars(env, jobvsr, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
	check_memory(env, jni_alphar);
	jfloat * jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
	check_memory(env, jni_alphai);
	jfloat * jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
	check_memory(env, jni_beta);
	jfloat * jni_vsl = (*env)->GetPrimitiveArrayCritical(env, vsl, JNI_FALSE);
	check_memory(env, jni_vsl);
	jfloat * jni_vsr = (*env)->GetPrimitiveArrayCritical(env, vsr, JNI_FALSE);
	check_memory(env, jni_vsr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgegs_(jni_jobvsl, jni_jobvsr, &n, jni_a, &lda, jni_b, &ldb, jni_alphar, jni_alphai, jni_beta, jni_vsl, &ldvsl, jni_vsr, &ldvsr, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobvsl, jni_jobvsl);
	(*env)->ReleaseStringUTFChars(env, jobvsr, jni_jobvsr);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vsl, jni_vsl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vsr, jni_vsr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgegv (JNIEnv * env, jobject calling_obj, jstring jobvl, jstring jobvr, jint n, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray alphar, jfloatArray alphai, jfloatArray beta, jfloatArray vl, jint ldvl, jfloatArray vr, jint ldvr, jfloatArray work, jint lwork, jobject info){
	char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
	char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
	check_memory(env, jni_alphar);
	jfloat * jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
	check_memory(env, jni_alphai);
	jfloat * jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
	check_memory(env, jni_beta);
	jfloat * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jfloat * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgegv_(jni_jobvl, jni_jobvr, &n, jni_a, &lda, jni_b, &ldb, jni_alphar, jni_alphai, jni_beta, jni_vl, &ldvl, jni_vr, &ldvr, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
	(*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgehd2 (JNIEnv * env, jobject calling_obj, jint n, jint ilo, jint ihi, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgehd2_(&n, &ilo, &ihi, jni_a, &lda, jni_tau, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgehrd (JNIEnv * env, jobject calling_obj, jint n, jint ilo, jint ihi, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jint lwork, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgehrd_(&n, &ilo, &ihi, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgelq2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgelq2_(&m, &n, jni_a, &lda, jni_tau, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgelqf (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jint lwork, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgelqf_(&m, &n, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgels (JNIEnv * env, jobject calling_obj, jstring trans, jint m, jint n, jint nrhs, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray work, jint lwork, jobject info){
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgels_(jni_trans, &m, &n, &nrhs, jni_a, &lda, jni_b, &ldb, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgelsd (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nrhs, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray s, jfloat rcond, jobject rank, jfloatArray work, jint lwork, jintArray iwork, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
	jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
	jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgelsd_(&m, &n, &nrhs, jni_a, &lda, jni_b, &ldb, jni_s, &rcond, &jni_rank, jni_work, &lwork, jni_iwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->SetIntField(env, rank, jni_rankId, jni_rank);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgelss (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nrhs, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray s, jfloat rcond, jobject rank, jfloatArray work, jint lwork, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
	jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
	jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgelss_(&m, &n, &nrhs, jni_a, &lda, jni_b, &ldb, jni_s, &rcond, &jni_rank, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->SetIntField(env, rank, jni_rankId, jni_rank);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgelsx (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nrhs, jfloatArray a, jint lda, jfloatArray b, jint ldb, jintArray jpvt, jfloat rcond, jobject rank, jfloatArray work, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jint * jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
	check_memory(env, jni_jpvt);
	jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
	jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
	jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgelsx_(&m, &n, &nrhs, jni_a, &lda, jni_b, &ldb, jni_jpvt, &rcond, &jni_rank, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
	(*env)->SetIntField(env, rank, jni_rankId, jni_rank);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgelsy (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nrhs, jfloatArray a, jint lda, jfloatArray b, jint ldb, jintArray jpvt, jfloat rcond, jobject rank, jfloatArray work, jint lwork, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jint * jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
	check_memory(env, jni_jpvt);
	jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
	jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
	jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgelsy_(&m, &n, &nrhs, jni_a, &lda, jni_b, &ldb, jni_jpvt, &rcond, &jni_rank, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
	(*env)->SetIntField(env, rank, jni_rankId, jni_rank);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgeql2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgeql2_(&m, &n, jni_a, &lda, jni_tau, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgeqlf (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jint lwork, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgeqlf_(&m, &n, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgeqp3 (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jintArray jpvt, jfloatArray tau, jfloatArray work, jint lwork, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
	check_memory(env, jni_jpvt);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgeqp3_(&m, &n, jni_a, &lda, jni_jpvt, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgeqpf (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jintArray jpvt, jfloatArray tau, jfloatArray work, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
	check_memory(env, jni_jpvt);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgeqpf_(&m, &n, jni_a, &lda, jni_jpvt, jni_tau, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgeqr2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgeqr2_(&m, &n, jni_a, &lda, jni_tau, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgeqrf (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jint lwork, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgeqrf_(&m, &n, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgerfs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jfloatArray a, jint lda, jfloatArray af, jint ldaf, jintArray ipiv, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jobject info){
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
	check_memory(env, jni_af);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgerfs_(jni_trans, &n, &nrhs, jni_a, &lda, jni_af, &ldaf, jni_ipiv, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgerq2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgerq2_(&m, &n, jni_a, &lda, jni_tau, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgerqf (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jint lwork, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgerqf_(&m, &n, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgesc2 (JNIEnv * env, jobject calling_obj, jint n, jfloatArray a, jint lda, jfloatArray rhs, jintArray ipiv, jintArray jpiv, jobject scale){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_rhs = (*env)->GetPrimitiveArrayCritical(env, rhs, JNI_FALSE);
	check_memory(env, jni_rhs);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jint * jni_jpiv = (*env)->GetPrimitiveArrayCritical(env, jpiv, JNI_FALSE);
	check_memory(env, jni_jpiv);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jfloat jni_scale = (*env)->GetFloatField(env, scale, jni_scaleId);

	sgesc2_(&n, jni_a, &lda, jni_rhs, jni_ipiv, jni_jpiv, &jni_scale);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, rhs, jni_rhs, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, jpiv, jni_jpiv, 0);
	(*env)->SetFloatField(env, scale, jni_scaleId, jni_scale);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgesdd (JNIEnv * env, jobject calling_obj, jstring jobz, jint m, jint n, jfloatArray a, jint lda, jfloatArray s, jfloatArray u, jint ldu, jfloatArray vt, jint ldvt, jfloatArray work, jint lwork, jintArray iwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jfloat * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jfloat * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgesdd_(jni_jobz, &m, &n, jni_a, &lda, jni_s, jni_u, &ldu, jni_vt, &ldvt, jni_work, &lwork, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgesv (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jfloatArray a, jint lda, jintArray ipiv, jfloatArray b, jint ldb, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgesv_(&n, &nrhs, jni_a, &lda, jni_ipiv, jni_b, &ldb, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgesvd (JNIEnv * env, jobject calling_obj, jstring jobu, jstring jobvt, jint m, jint n, jfloatArray a, jint lda, jfloatArray s, jfloatArray u, jint ldu, jfloatArray vt, jint ldvt, jfloatArray work, jint lwork, jobject info){
	char * jni_jobu = (char *)(*env)->GetStringUTFChars(env, jobu, JNI_FALSE);
	char * jni_jobvt = (char *)(*env)->GetStringUTFChars(env, jobvt, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jfloat * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jfloat * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgesvd_(jni_jobu, jni_jobvt, &m, &n, jni_a, &lda, jni_s, jni_u, &ldu, jni_vt, &ldvt, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobu, jni_jobu);
	(*env)->ReleaseStringUTFChars(env, jobvt, jni_jobvt);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgesvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring trans, jint n, jint nrhs, jfloatArray a, jint lda, jfloatArray af, jint ldaf, jintArray ipiv, jobject equed, jfloatArray r, jfloatArray c, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jobject rcond, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jobject info){
	char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
	check_memory(env, jni_af);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
	jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
	jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
	char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
	jfloat * jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
	check_memory(env, jni_r);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgesvx_(jni_fact, jni_trans, &n, &nrhs, jni_a, &lda, jni_af, &ldaf, jni_ipiv, jni_equed, jni_r, jni_c, jni_b, &ldb, jni_x, &ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, fact, jni_fact);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	jstring jni_equedStringNew = (*env)->NewStringUTF(env, jni_equed);
	(*env)->SetObjectField(env, equed, jni_equedId, jni_equedStringNew);
	(*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgetc2 (JNIEnv * env, jobject calling_obj, jint n, jfloatArray a, jint lda, jintArray ipiv, jintArray jpiv, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jint * jni_jpiv = (*env)->GetPrimitiveArrayCritical(env, jpiv, JNI_FALSE);
	check_memory(env, jni_jpiv);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgetc2_(&n, jni_a, &lda, jni_ipiv, jni_jpiv, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, jpiv, jni_jpiv, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgetf2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jintArray ipiv, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgetf2_(&m, &n, jni_a, &lda, jni_ipiv, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgetrf (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jintArray ipiv, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgetrf_(&m, &n, jni_a, &lda, jni_ipiv, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgetri (JNIEnv * env, jobject calling_obj, jint n, jfloatArray a, jint lda, jintArray ipiv, jfloatArray work, jint lwork, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgetri_(&n, jni_a, &lda, jni_ipiv, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgetrs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jfloatArray a, jint lda, jintArray ipiv, jfloatArray b, jint ldb, jobject info){
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgetrs_(jni_trans, &n, &nrhs, jni_a, &lda, jni_ipiv, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sggbak (JNIEnv * env, jobject calling_obj, jstring job, jstring side, jint n, jint ilo, jint ihi, jfloatArray lscale, jfloatArray rscale, jint m, jfloatArray v, jint ldv, jobject info){
	char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	jfloat * jni_lscale = (*env)->GetPrimitiveArrayCritical(env, lscale, JNI_FALSE);
	check_memory(env, jni_lscale);
	jfloat * jni_rscale = (*env)->GetPrimitiveArrayCritical(env, rscale, JNI_FALSE);
	check_memory(env, jni_rscale);
	jfloat * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sggbak_(jni_job, jni_side, &n, &ilo, &ihi, jni_lscale, jni_rscale, &m, jni_v, &ldv, &jni_info);

	(*env)->ReleaseStringUTFChars(env, job, jni_job);
	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleasePrimitiveArrayCritical(env, lscale, jni_lscale, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, rscale, jni_rscale, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sggbal (JNIEnv * env, jobject calling_obj, jstring job, jint n, jfloatArray a, jint lda, jfloatArray b, jint ldb, jobject ilo, jobject ihi, jfloatArray lscale, jfloatArray rscale, jfloatArray work, jobject info){
	char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
	jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
	jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
	jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
	jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
	jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
	jfloat * jni_lscale = (*env)->GetPrimitiveArrayCritical(env, lscale, JNI_FALSE);
	check_memory(env, jni_lscale);
	jfloat * jni_rscale = (*env)->GetPrimitiveArrayCritical(env, rscale, JNI_FALSE);
	check_memory(env, jni_rscale);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sggbal_(jni_job, &n, jni_a, &lda, jni_b, &ldb, &jni_ilo, &jni_ihi, jni_lscale, jni_rscale, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, job, jni_job);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
	(*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
	(*env)->ReleasePrimitiveArrayCritical(env, lscale, jni_lscale, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, rscale, jni_rscale, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sggev (JNIEnv * env, jobject calling_obj, jstring jobvl, jstring jobvr, jint n, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray alphar, jfloatArray alphai, jfloatArray beta, jfloatArray vl, jint ldvl, jfloatArray vr, jint ldvr, jfloatArray work, jint lwork, jobject info){
	char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
	char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
	check_memory(env, jni_alphar);
	jfloat * jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
	check_memory(env, jni_alphai);
	jfloat * jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
	check_memory(env, jni_beta);
	jfloat * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jfloat * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sggev_(jni_jobvl, jni_jobvr, &n, jni_a, &lda, jni_b, &ldb, jni_alphar, jni_alphai, jni_beta, jni_vl, &ldvl, jni_vr, &ldvr, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
	(*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sggevx (JNIEnv * env, jobject calling_obj, jstring balanc, jstring jobvl, jstring jobvr, jstring sense, jint n, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray alphar, jfloatArray alphai, jfloatArray beta, jfloatArray vl, jint ldvl, jfloatArray vr, jint ldvr, jobject ilo, jobject ihi, jfloatArray lscale, jfloatArray rscale, jobject abnrm, jobject bbnrm, jfloatArray rconde, jfloatArray rcondv, jfloatArray work, jint lwork, jintArray iwork, jbooleanArray bwork, jobject info){
	char * jni_balanc = (char *)(*env)->GetStringUTFChars(env, balanc, JNI_FALSE);
	char * jni_jobvl = (char *)(*env)->GetStringUTFChars(env, jobvl, JNI_FALSE);
	char * jni_jobvr = (char *)(*env)->GetStringUTFChars(env, jobvr, JNI_FALSE);
	char * jni_sense = (char *)(*env)->GetStringUTFChars(env, sense, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
	check_memory(env, jni_alphar);
	jfloat * jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
	check_memory(env, jni_alphai);
	jfloat * jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
	check_memory(env, jni_beta);
	jfloat * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jfloat * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jclass jni_iloClass = (*env)->GetObjectClass(env, ilo);
	jfieldID jni_iloId = (*env)->GetFieldID(env, jni_iloClass, "val", "I");
	jint jni_ilo = (*env)->GetIntField(env, ilo, jni_iloId);
	jclass jni_ihiClass = (*env)->GetObjectClass(env, ihi);
	jfieldID jni_ihiId = (*env)->GetFieldID(env, jni_ihiClass, "val", "I");
	jint jni_ihi = (*env)->GetIntField(env, ihi, jni_ihiId);
	jfloat * jni_lscale = (*env)->GetPrimitiveArrayCritical(env, lscale, JNI_FALSE);
	check_memory(env, jni_lscale);
	jfloat * jni_rscale = (*env)->GetPrimitiveArrayCritical(env, rscale, JNI_FALSE);
	check_memory(env, jni_rscale);
	jclass jni_abnrmClass = (*env)->GetObjectClass(env, abnrm);
	jfieldID jni_abnrmId = (*env)->GetFieldID(env, jni_abnrmClass, "val", "D");
	jfloat jni_abnrm = (*env)->GetFloatField(env, abnrm, jni_abnrmId);
	jclass jni_bbnrmClass = (*env)->GetObjectClass(env, bbnrm);
	jfieldID jni_bbnrmId = (*env)->GetFieldID(env, jni_bbnrmClass, "val", "D");
	jfloat jni_bbnrm = (*env)->GetFloatField(env, bbnrm, jni_bbnrmId);
	jfloat * jni_rconde = (*env)->GetPrimitiveArrayCritical(env, rconde, JNI_FALSE);
	check_memory(env, jni_rconde);
	jfloat * jni_rcondv = (*env)->GetPrimitiveArrayCritical(env, rcondv, JNI_FALSE);
	check_memory(env, jni_rcondv);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jboolean * jni_bworkTmp = (*env)->GetPrimitiveArrayCritical(env, bwork, JNI_FALSE);
	jint jni_bworkSize = (*env)->GetArrayLength(env, bwork);
	logical jni_bwork[jni_bworkSize];
	int jni_bworki;
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
	for (jni_bworki = 0 ; jni_bworki < jni_bworkSize ; jni_bworki++){
		if (jni_bworkTmp[jni_bworki] == JNI_FALSE){
			jni_bwork[jni_bworki] = 0;
		} else {
			jni_bwork[jni_bworki] = 1;
		}
	}

	sggevx_(jni_balanc, jni_jobvl, jni_jobvr, jni_sense, &n, jni_a, &lda, jni_b, &ldb, jni_alphar, jni_alphai, jni_beta, jni_vl, &ldvl, jni_vr, &ldvr, &jni_ilo, &jni_ihi, jni_lscale, jni_rscale, &jni_abnrm, &jni_bbnrm, jni_rconde, jni_rcondv, jni_work, &lwork, jni_iwork, jni_bwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, balanc, jni_balanc);
	(*env)->ReleaseStringUTFChars(env, jobvl, jni_jobvl);
	(*env)->ReleaseStringUTFChars(env, jobvr, jni_jobvr);
	(*env)->ReleaseStringUTFChars(env, sense, jni_sense);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->SetIntField(env, ilo, jni_iloId, jni_ilo);
	(*env)->SetIntField(env, ihi, jni_ihiId, jni_ihi);
	(*env)->ReleasePrimitiveArrayCritical(env, lscale, jni_lscale, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, rscale, jni_rscale, 0);
	(*env)->SetFloatField(env, abnrm, jni_abnrmId, jni_abnrm);
	(*env)->SetFloatField(env, bbnrm, jni_bbnrmId, jni_bbnrm);
	(*env)->ReleasePrimitiveArrayCritical(env, rconde, jni_rconde, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, rcondv, jni_rcondv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	for (jni_bworki = 0 ; jni_bworki < jni_bworkSize ; jni_bworki++){
		if (jni_bwork[jni_bworki] == 0){
			jni_bworkTmp[jni_bworki] = JNI_FALSE;
		} else {
			jni_bworkTmp[jni_bworki] = JNI_TRUE;
		}
	}
	(*env)->ReleasePrimitiveArrayCritical(env, bwork, jni_bworkTmp, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sggglm (JNIEnv * env, jobject calling_obj, jint n, jint m, jint p, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray d, jfloatArray x, jfloatArray y, jfloatArray work, jint lwork, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
	check_memory(env, jni_y);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sggglm_(&n, &m, &p, jni_a, &lda, jni_b, &ldb, jni_d, jni_x, jni_y, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgghrd (JNIEnv * env, jobject calling_obj, jstring compq, jstring compz, jint n, jint ilo, jint ihi, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray q, jint ldq, jfloatArray z, jint ldz, jobject info){
	char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
	char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgghrd_(jni_compq, jni_compz, &n, &ilo, &ihi, jni_a, &lda, jni_b, &ldb, jni_q, &ldq, jni_z, &ldz, &jni_info);

	(*env)->ReleaseStringUTFChars(env, compq, jni_compq);
	(*env)->ReleaseStringUTFChars(env, compz, jni_compz);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgglse (JNIEnv * env, jobject calling_obj, jint m, jint n, jint p, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray c, jfloatArray d, jfloatArray x, jfloatArray work, jint lwork, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgglse_(&m, &n, &p, jni_a, &lda, jni_b, &ldb, jni_c, jni_d, jni_x, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sggqrf (JNIEnv * env, jobject calling_obj, jint n, jint m, jint p, jfloatArray a, jint lda, jfloatArray taua, jfloatArray b, jint ldb, jfloatArray taub, jfloatArray work, jint lwork, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_taua = (*env)->GetPrimitiveArrayCritical(env, taua, JNI_FALSE);
	check_memory(env, jni_taua);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_taub = (*env)->GetPrimitiveArrayCritical(env, taub, JNI_FALSE);
	check_memory(env, jni_taub);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sggqrf_(&n, &m, &p, jni_a, &lda, jni_taua, jni_b, &ldb, jni_taub, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, taua, jni_taua, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, taub, jni_taub, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sggrqf (JNIEnv * env, jobject calling_obj, jint m, jint p, jint n, jfloatArray a, jint lda, jfloatArray taua, jfloatArray b, jint ldb, jfloatArray taub, jfloatArray work, jint lwork, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_taua = (*env)->GetPrimitiveArrayCritical(env, taua, JNI_FALSE);
	check_memory(env, jni_taua);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_taub = (*env)->GetPrimitiveArrayCritical(env, taub, JNI_FALSE);
	check_memory(env, jni_taub);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sggrqf_(&m, &p, &n, jni_a, &lda, jni_taua, jni_b, &ldb, jni_taub, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, taua, jni_taua, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, taub, jni_taub, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sggsvd (JNIEnv * env, jobject calling_obj, jstring jobu, jstring jobv, jstring jobq, jint m, jint n, jint p, jobject k, jobject l, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray alpha, jfloatArray beta, jfloatArray u, jint ldu, jfloatArray v, jint ldv, jfloatArray q, jint ldq, jfloatArray work, jintArray iwork, jobject info){
	char * jni_jobu = (char *)(*env)->GetStringUTFChars(env, jobu, JNI_FALSE);
	char * jni_jobv = (char *)(*env)->GetStringUTFChars(env, jobv, JNI_FALSE);
	char * jni_jobq = (char *)(*env)->GetStringUTFChars(env, jobq, JNI_FALSE);
	jclass jni_kClass = (*env)->GetObjectClass(env, k);
	jfieldID jni_kId = (*env)->GetFieldID(env, jni_kClass, "val", "I");
	jint jni_k = (*env)->GetIntField(env, k, jni_kId);
	jclass jni_lClass = (*env)->GetObjectClass(env, l);
	jfieldID jni_lId = (*env)->GetFieldID(env, jni_lClass, "val", "I");
	jint jni_l = (*env)->GetIntField(env, l, jni_lId);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_alpha = (*env)->GetPrimitiveArrayCritical(env, alpha, JNI_FALSE);
	check_memory(env, jni_alpha);
	jfloat * jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
	check_memory(env, jni_beta);
	jfloat * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jfloat * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sggsvd_(jni_jobu, jni_jobv, jni_jobq, &m, &n, &p, &jni_k, &jni_l, jni_a, &lda, jni_b, &ldb, jni_alpha, jni_beta, jni_u, &ldu, jni_v, &ldv, jni_q, &ldq, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobu, jni_jobu);
	(*env)->ReleaseStringUTFChars(env, jobv, jni_jobv);
	(*env)->ReleaseStringUTFChars(env, jobq, jni_jobq);
	(*env)->SetIntField(env, k, jni_kId, jni_k);
	(*env)->SetIntField(env, l, jni_lId, jni_l);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alpha, jni_alpha, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sggsvp (JNIEnv * env, jobject calling_obj, jstring jobu, jstring jobv, jstring jobq, jint m, jint p, jint n, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloat tola, jfloat tolb, jobject k, jobject l, jfloatArray u, jint ldu, jfloatArray v, jint ldv, jfloatArray q, jint ldq, jintArray iwork, jfloatArray tau, jfloatArray work, jobject info){
	char * jni_jobu = (char *)(*env)->GetStringUTFChars(env, jobu, JNI_FALSE);
	char * jni_jobv = (char *)(*env)->GetStringUTFChars(env, jobv, JNI_FALSE);
	char * jni_jobq = (char *)(*env)->GetStringUTFChars(env, jobq, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_kClass = (*env)->GetObjectClass(env, k);
	jfieldID jni_kId = (*env)->GetFieldID(env, jni_kClass, "val", "I");
	jint jni_k = (*env)->GetIntField(env, k, jni_kId);
	jclass jni_lClass = (*env)->GetObjectClass(env, l);
	jfieldID jni_lId = (*env)->GetFieldID(env, jni_lClass, "val", "I");
	jint jni_l = (*env)->GetIntField(env, l, jni_lId);
	jfloat * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jfloat * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sggsvp_(jni_jobu, jni_jobv, jni_jobq, &m, &p, &n, jni_a, &lda, jni_b, &ldb, &tola, &tolb, &jni_k, &jni_l, jni_u, &ldu, jni_v, &ldv, jni_q, &ldq, jni_iwork, jni_tau, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobu, jni_jobu);
	(*env)->ReleaseStringUTFChars(env, jobv, jni_jobv);
	(*env)->ReleaseStringUTFChars(env, jobq, jni_jobq);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, k, jni_kId, jni_k);
	(*env)->SetIntField(env, l, jni_lId, jni_l);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgtcon (JNIEnv * env, jobject calling_obj, jstring norm, jint n, jfloatArray dl, jfloatArray d, jfloatArray du, jfloatArray du2, jintArray ipiv, jfloat anorm, jobject rcond, jfloatArray work, jintArray iwork, jobject info){
	char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
	jfloat * jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
	check_memory(env, jni_dl);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
	check_memory(env, jni_du);
	jfloat * jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
	check_memory(env, jni_du2);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgtcon_(jni_norm, &n, jni_dl, jni_d, jni_du, jni_du2, jni_ipiv, &anorm, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, norm, jni_norm);
	(*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgtrfs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jfloatArray dl, jfloatArray d, jfloatArray du, jfloatArray dlf, jfloatArray df, jfloatArray duf, jfloatArray du2, jintArray ipiv, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jobject info){
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
	check_memory(env, jni_dl);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
	check_memory(env, jni_du);
	jfloat * jni_dlf = (*env)->GetPrimitiveArrayCritical(env, dlf, JNI_FALSE);
	check_memory(env, jni_dlf);
	jfloat * jni_df = (*env)->GetPrimitiveArrayCritical(env, df, JNI_FALSE);
	check_memory(env, jni_df);
	jfloat * jni_duf = (*env)->GetPrimitiveArrayCritical(env, duf, JNI_FALSE);
	check_memory(env, jni_duf);
	jfloat * jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
	check_memory(env, jni_du2);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgtrfs_(jni_trans, &n, &nrhs, jni_dl, jni_d, jni_du, jni_dlf, jni_df, jni_duf, jni_du2, jni_ipiv, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dlf, jni_dlf, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, df, jni_df, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, duf, jni_duf, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgtsv (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jfloatArray dl, jfloatArray d, jfloatArray du, jfloatArray b, jint ldb, jobject info){
	jfloat * jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
	check_memory(env, jni_dl);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
	check_memory(env, jni_du);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgtsv_(&n, &nrhs, jni_dl, jni_d, jni_du, jni_b, &ldb, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgtsvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring trans, jint n, jint nrhs, jfloatArray dl, jfloatArray d, jfloatArray du, jfloatArray dlf, jfloatArray df, jfloatArray duf, jfloatArray du2, jintArray ipiv, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jobject rcond, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jobject info){
	char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
	check_memory(env, jni_dl);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
	check_memory(env, jni_du);
	jfloat * jni_dlf = (*env)->GetPrimitiveArrayCritical(env, dlf, JNI_FALSE);
	check_memory(env, jni_dlf);
	jfloat * jni_df = (*env)->GetPrimitiveArrayCritical(env, df, JNI_FALSE);
	check_memory(env, jni_df);
	jfloat * jni_duf = (*env)->GetPrimitiveArrayCritical(env, duf, JNI_FALSE);
	check_memory(env, jni_duf);
	jfloat * jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
	check_memory(env, jni_du2);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgtsvx_(jni_fact, jni_trans, &n, &nrhs, jni_dl, jni_d, jni_du, jni_dlf, jni_df, jni_duf, jni_du2, jni_ipiv, jni_b, &ldb, jni_x, &ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, fact, jni_fact);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dlf, jni_dlf, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, df, jni_df, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, duf, jni_duf, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgttrf (JNIEnv * env, jobject calling_obj, jint n, jfloatArray dl, jfloatArray d, jfloatArray du, jfloatArray du2, jintArray ipiv, jobject info){
	jfloat * jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
	check_memory(env, jni_dl);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
	check_memory(env, jni_du);
	jfloat * jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
	check_memory(env, jni_du2);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgttrf_(&n, jni_dl, jni_d, jni_du, jni_du2, jni_ipiv, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgttrs (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jfloatArray dl, jfloatArray d, jfloatArray du, jfloatArray du2, jintArray ipiv, jfloatArray b, jint ldb, jobject info){
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
	check_memory(env, jni_dl);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
	check_memory(env, jni_du);
	jfloat * jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
	check_memory(env, jni_du2);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sgttrs_(jni_trans, &n, &nrhs, jni_dl, jni_d, jni_du, jni_du2, jni_ipiv, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sgtts2 (JNIEnv * env, jobject calling_obj, jint itrans, jint n, jint nrhs, jfloatArray dl, jfloatArray d, jfloatArray du, jfloatArray du2, jintArray ipiv, jfloatArray b, jint ldb){
	jfloat * jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
	check_memory(env, jni_dl);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
	check_memory(env, jni_du);
	jfloat * jni_du2 = (*env)->GetPrimitiveArrayCritical(env, du2, JNI_FALSE);
	check_memory(env, jni_du2);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);

	sgtts2_(&itrans, &n, &nrhs, jni_dl, jni_d, jni_du, jni_du2, jni_ipiv, jni_b, &ldb);

	(*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du2, jni_du2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_shgeqz (JNIEnv * env, jobject calling_obj, jstring job, jstring compq, jstring compz, jint n, jint ilo, jint ihi, jfloatArray h, jint ldh, jfloatArray t, jint ldt, jfloatArray alphar, jfloatArray alphai, jfloatArray beta, jfloatArray q, jint ldq, jfloatArray z, jint ldz, jfloatArray work, jint lwork, jobject info){
	char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
	char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
	char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
	jfloat * jni_h = (*env)->GetPrimitiveArrayCritical(env, h, JNI_FALSE);
	check_memory(env, jni_h);
	jfloat * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);
	jfloat * jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
	check_memory(env, jni_alphar);
	jfloat * jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
	check_memory(env, jni_alphai);
	jfloat * jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
	check_memory(env, jni_beta);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	shgeqz_(jni_job, jni_compq, jni_compz, &n, &ilo, &ihi, jni_h, &ldh, jni_t, &ldt, jni_alphar, jni_alphai, jni_beta, jni_q, &ldq, jni_z, &ldz, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, job, jni_job);
	(*env)->ReleaseStringUTFChars(env, compq, jni_compq);
	(*env)->ReleaseStringUTFChars(env, compz, jni_compz);
	(*env)->ReleasePrimitiveArrayCritical(env, h, jni_h, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_shsein (JNIEnv * env, jobject calling_obj, jstring side, jstring eigsrc, jstring initv, jbooleanArray select, jint n, jfloatArray h, jint ldh, jfloatArray wr, jfloatArray wi, jfloatArray vl, jint ldvl, jfloatArray vr, jint ldvr, jint mm, jobject m, jfloatArray work, jintArray ifaill, jintArray ifailr, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_eigsrc = (char *)(*env)->GetStringUTFChars(env, eigsrc, JNI_FALSE);
	char * jni_initv = (char *)(*env)->GetStringUTFChars(env, initv, JNI_FALSE);
	jboolean * jni_selectTmp = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
	jint jni_selectSize = (*env)->GetArrayLength(env, select);
	logical jni_select[jni_selectSize];
	int jni_selecti;
	jfloat * jni_h = (*env)->GetPrimitiveArrayCritical(env, h, JNI_FALSE);
	check_memory(env, jni_h);
	jfloat * jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
	check_memory(env, jni_wr);
	jfloat * jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
	check_memory(env, jni_wi);
	jfloat * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jfloat * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_ifaill = (*env)->GetPrimitiveArrayCritical(env, ifaill, JNI_FALSE);
	check_memory(env, jni_ifaill);
	jint * jni_ifailr = (*env)->GetPrimitiveArrayCritical(env, ifailr, JNI_FALSE);
	check_memory(env, jni_ifailr);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_selectTmp[jni_selecti] == JNI_FALSE){
			jni_select[jni_selecti] = 0;
		} else {
			jni_select[jni_selecti] = 1;
		}
	}

	shsein_(jni_side, jni_eigsrc, jni_initv, jni_select, &n, jni_h, &ldh, jni_wr, jni_wi, jni_vl, &ldvl, jni_vr, &ldvr, &mm, &jni_m, jni_work, jni_ifaill, jni_ifailr, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, eigsrc, jni_eigsrc);
	(*env)->ReleaseStringUTFChars(env, initv, jni_initv);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_select[jni_selecti] == 0){
			jni_selectTmp[jni_selecti] = JNI_FALSE;
		} else {
			jni_selectTmp[jni_selecti] = JNI_TRUE;
		}
	}
	(*env)->ReleasePrimitiveArrayCritical(env, select, jni_selectTmp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, h, jni_h, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ifaill, jni_ifaill, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ifailr, jni_ifailr, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_shseqr (JNIEnv * env, jobject calling_obj, jstring job, jstring compz, jint n, jint ilo, jint ihi, jfloatArray h, jint ldh, jfloatArray wr, jfloatArray wi, jfloatArray z, jint ldz, jfloatArray work, jint lwork, jobject info){
	char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
	char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
	jfloat * jni_h = (*env)->GetPrimitiveArrayCritical(env, h, JNI_FALSE);
	check_memory(env, jni_h);
	jfloat * jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
	check_memory(env, jni_wr);
	jfloat * jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
	check_memory(env, jni_wi);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	shseqr_(jni_job, jni_compz, &n, &ilo, &ihi, jni_h, &ldh, jni_wr, jni_wi, jni_z, &ldz, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, job, jni_job);
	(*env)->ReleaseStringUTFChars(env, compz, jni_compz);
	(*env)->ReleasePrimitiveArrayCritical(env, h, jni_h, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slabad (JNIEnv * env, jobject calling_obj, jobject small, jobject large){
	jclass jni_smallClass = (*env)->GetObjectClass(env, small);
	jfieldID jni_smallId = (*env)->GetFieldID(env, jni_smallClass, "val", "D");
	jfloat jni_small = (*env)->GetFloatField(env, small, jni_smallId);
	jclass jni_largeClass = (*env)->GetObjectClass(env, large);
	jfieldID jni_largeId = (*env)->GetFieldID(env, jni_largeClass, "val", "D");
	jfloat jni_large = (*env)->GetFloatField(env, large, jni_largeId);

	slabad_(&jni_small, &jni_large);

	(*env)->SetFloatField(env, small, jni_smallId, jni_small);
	(*env)->SetFloatField(env, large, jni_largeId, jni_large);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slabrd (JNIEnv * env, jobject calling_obj, jint m, jint n, jint nb, jfloatArray a, jint lda, jfloatArray d, jfloatArray e, jfloatArray tauq, jfloatArray taup, jfloatArray x, jint ldx, jfloatArray y, jint ldy){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_tauq = (*env)->GetPrimitiveArrayCritical(env, tauq, JNI_FALSE);
	check_memory(env, jni_tauq);
	jfloat * jni_taup = (*env)->GetPrimitiveArrayCritical(env, taup, JNI_FALSE);
	check_memory(env, jni_taup);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
	check_memory(env, jni_y);

	slabrd_(&m, &n, &nb, jni_a, &lda, jni_d, jni_e, jni_tauq, jni_taup, jni_x, &ldx, jni_y, &ldy);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tauq, jni_tauq, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, taup, jni_taup, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slacon (JNIEnv * env, jobject calling_obj, jint n, jfloatArray v, jfloatArray x, jintArray isgn, jobject est, jobject kase){
	jfloat * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jint * jni_isgn = (*env)->GetPrimitiveArrayCritical(env, isgn, JNI_FALSE);
	check_memory(env, jni_isgn);
	jclass jni_estClass = (*env)->GetObjectClass(env, est);
	jfieldID jni_estId = (*env)->GetFieldID(env, jni_estClass, "val", "D");
	jfloat jni_est = (*env)->GetFloatField(env, est, jni_estId);
	jclass jni_kaseClass = (*env)->GetObjectClass(env, kase);
	jfieldID jni_kaseId = (*env)->GetFieldID(env, jni_kaseClass, "val", "I");
	jint jni_kase = (*env)->GetIntField(env, kase, jni_kaseId);

	slacon_(&n, jni_v, jni_x, jni_isgn, &jni_est, &jni_kase);

	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, isgn, jni_isgn, 0);
	(*env)->SetFloatField(env, est, jni_estId, jni_est);
	(*env)->SetIntField(env, kase, jni_kaseId, jni_kase);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slacpy (JNIEnv * env, jobject calling_obj, jstring uplo, jint m, jint n, jfloatArray a, jint lda, jfloatArray b, jint ldb){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);

	slacpy_(jni_uplo, &m, &n, jni_a, &lda, jni_b, &ldb);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sladiv (JNIEnv * env, jobject calling_obj, jfloat a, jfloat b, jfloat c, jfloat d, jobject p, jobject q){
	jclass jni_pClass = (*env)->GetObjectClass(env, p);
	jfieldID jni_pId = (*env)->GetFieldID(env, jni_pClass, "val", "D");
	jfloat jni_p = (*env)->GetFloatField(env, p, jni_pId);
	jclass jni_qClass = (*env)->GetObjectClass(env, q);
	jfieldID jni_qId = (*env)->GetFieldID(env, jni_qClass, "val", "D");
	jfloat jni_q = (*env)->GetFloatField(env, q, jni_qId);

	sladiv_(&a, &b, &c, &d, &jni_p, &jni_q);

	(*env)->SetFloatField(env, p, jni_pId, jni_p);
	(*env)->SetFloatField(env, q, jni_qId, jni_q);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slae2 (JNIEnv * env, jobject calling_obj, jfloat a, jfloat b, jfloat c, jobject rt1, jobject rt2){
	jclass jni_rt1Class = (*env)->GetObjectClass(env, rt1);
	jfieldID jni_rt1Id = (*env)->GetFieldID(env, jni_rt1Class, "val", "D");
	jfloat jni_rt1 = (*env)->GetFloatField(env, rt1, jni_rt1Id);
	jclass jni_rt2Class = (*env)->GetObjectClass(env, rt2);
	jfieldID jni_rt2Id = (*env)->GetFieldID(env, jni_rt2Class, "val", "D");
	jfloat jni_rt2 = (*env)->GetFloatField(env, rt2, jni_rt2Id);

	slae2_(&a, &b, &c, &jni_rt1, &jni_rt2);

	(*env)->SetFloatField(env, rt1, jni_rt1Id, jni_rt1);
	(*env)->SetFloatField(env, rt2, jni_rt2Id, jni_rt2);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaebz (JNIEnv * env, jobject calling_obj, jint ijob, jint nitmax, jint n, jint mmax, jint minp, jint nbmin, jfloat abstol, jfloat reltol, jfloat pivmin, jfloatArray d, jfloatArray e, jfloatArray e2, jintArray nval, jfloatArray ab, jfloatArray c, jobject mout, jintArray nab, jfloatArray work, jintArray iwork, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_e2 = (*env)->GetPrimitiveArrayCritical(env, e2, JNI_FALSE);
	check_memory(env, jni_e2);
	jint * jni_nval = (*env)->GetPrimitiveArrayCritical(env, nval, JNI_FALSE);
	check_memory(env, jni_nval);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jclass jni_moutClass = (*env)->GetObjectClass(env, mout);
	jfieldID jni_moutId = (*env)->GetFieldID(env, jni_moutClass, "val", "I");
	jint jni_mout = (*env)->GetIntField(env, mout, jni_moutId);
	jint * jni_nab = (*env)->GetPrimitiveArrayCritical(env, nab, JNI_FALSE);
	check_memory(env, jni_nab);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slaebz_(&ijob, &nitmax, &n, &mmax, &minp, &nbmin, &abstol, &reltol, &pivmin, jni_d, jni_e, jni_e2, jni_nval, jni_ab, jni_c, &jni_mout, jni_nab, jni_work, jni_iwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e2, jni_e2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, nval, jni_nval, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->SetIntField(env, mout, jni_moutId, jni_mout);
	(*env)->ReleasePrimitiveArrayCritical(env, nab, jni_nab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaed0 (JNIEnv * env, jobject calling_obj, jint icompq, jint qsiz, jint n, jfloatArray d, jfloatArray e, jfloatArray q, jint ldq, jfloatArray qstore, jint ldqs, jfloatArray work, jintArray iwork, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jfloat * jni_qstore = (*env)->GetPrimitiveArrayCritical(env, qstore, JNI_FALSE);
	check_memory(env, jni_qstore);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slaed0_(&icompq, &qsiz, &n, jni_d, jni_e, jni_q, &ldq, jni_qstore, &ldqs, jni_work, jni_iwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, qstore, jni_qstore, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaed1 (JNIEnv * env, jobject calling_obj, jint n, jfloatArray d, jfloatArray q, jint ldq, jintArray indxq, jobject rho, jint cutpnt, jfloatArray work, jintArray iwork, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jint * jni_indxq = (*env)->GetPrimitiveArrayCritical(env, indxq, JNI_FALSE);
	check_memory(env, jni_indxq);
	jclass jni_rhoClass = (*env)->GetObjectClass(env, rho);
	jfieldID jni_rhoId = (*env)->GetFieldID(env, jni_rhoClass, "val", "D");
	jfloat jni_rho = (*env)->GetFloatField(env, rho, jni_rhoId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slaed1_(&n, jni_d, jni_q, &ldq, jni_indxq, &jni_rho, &cutpnt, jni_work, jni_iwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, indxq, jni_indxq, 0);
	(*env)->SetFloatField(env, rho, jni_rhoId, jni_rho);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaed2 (JNIEnv * env, jobject calling_obj, jobject k, jint n, jint n1, jfloatArray d, jfloatArray q, jint ldq, jintArray indxq, jobject rho, jfloatArray z, jfloatArray dlamda, jfloatArray w, jfloatArray q2, jintArray indx, jintArray indxc, jintArray indxp, jintArray coltyp, jobject info){
	jclass jni_kClass = (*env)->GetObjectClass(env, k);
	jfieldID jni_kId = (*env)->GetFieldID(env, jni_kClass, "val", "I");
	jint jni_k = (*env)->GetIntField(env, k, jni_kId);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jint * jni_indxq = (*env)->GetPrimitiveArrayCritical(env, indxq, JNI_FALSE);
	check_memory(env, jni_indxq);
	jclass jni_rhoClass = (*env)->GetObjectClass(env, rho);
	jfieldID jni_rhoId = (*env)->GetFieldID(env, jni_rhoClass, "val", "D");
	jfloat jni_rho = (*env)->GetFloatField(env, rho, jni_rhoId);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_dlamda = (*env)->GetPrimitiveArrayCritical(env, dlamda, JNI_FALSE);
	check_memory(env, jni_dlamda);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_q2 = (*env)->GetPrimitiveArrayCritical(env, q2, JNI_FALSE);
	check_memory(env, jni_q2);
	jint * jni_indx = (*env)->GetPrimitiveArrayCritical(env, indx, JNI_FALSE);
	check_memory(env, jni_indx);
	jint * jni_indxc = (*env)->GetPrimitiveArrayCritical(env, indxc, JNI_FALSE);
	check_memory(env, jni_indxc);
	jint * jni_indxp = (*env)->GetPrimitiveArrayCritical(env, indxp, JNI_FALSE);
	check_memory(env, jni_indxp);
	jint * jni_coltyp = (*env)->GetPrimitiveArrayCritical(env, coltyp, JNI_FALSE);
	check_memory(env, jni_coltyp);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slaed2_(&jni_k, &n, &n1, jni_d, jni_q, &ldq, jni_indxq, &jni_rho, jni_z, jni_dlamda, jni_w, jni_q2, jni_indx, jni_indxc, jni_indxp, jni_coltyp, &jni_info);

	(*env)->SetIntField(env, k, jni_kId, jni_k);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, indxq, jni_indxq, 0);
	(*env)->SetFloatField(env, rho, jni_rhoId, jni_rho);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dlamda, jni_dlamda, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q2, jni_q2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, indx, jni_indx, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, indxc, jni_indxc, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, indxp, jni_indxp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, coltyp, jni_coltyp, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaed3 (JNIEnv * env, jobject calling_obj, jint k, jint n, jint n1, jfloatArray d, jfloatArray q, jint ldq, jfloat rho, jfloatArray dlamda, jfloatArray q2, jintArray indx, jintArray ctot, jfloatArray w, jfloatArray s, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jfloat * jni_dlamda = (*env)->GetPrimitiveArrayCritical(env, dlamda, JNI_FALSE);
	check_memory(env, jni_dlamda);
	jfloat * jni_q2 = (*env)->GetPrimitiveArrayCritical(env, q2, JNI_FALSE);
	check_memory(env, jni_q2);
	jint * jni_indx = (*env)->GetPrimitiveArrayCritical(env, indx, JNI_FALSE);
	check_memory(env, jni_indx);
	jint * jni_ctot = (*env)->GetPrimitiveArrayCritical(env, ctot, JNI_FALSE);
	check_memory(env, jni_ctot);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slaed3_(&k, &n, &n1, jni_d, jni_q, &ldq, &rho, jni_dlamda, jni_q2, jni_indx, jni_ctot, jni_w, jni_s, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dlamda, jni_dlamda, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q2, jni_q2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, indx, jni_indx, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ctot, jni_ctot, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaed4 (JNIEnv * env, jobject calling_obj, jint n, jint i, jfloatArray d, jfloatArray z, jfloatArray delta, jfloat rho, jobject dlam, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_delta = (*env)->GetPrimitiveArrayCritical(env, delta, JNI_FALSE);
	check_memory(env, jni_delta);
	jclass jni_dlamClass = (*env)->GetObjectClass(env, dlam);
	jfieldID jni_dlamId = (*env)->GetFieldID(env, jni_dlamClass, "val", "D");
	jfloat jni_dlam = (*env)->GetFloatField(env, dlam, jni_dlamId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slaed4_(&n, &i, jni_d, jni_z, jni_delta, &rho, &jni_dlam, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, delta, jni_delta, 0);
	(*env)->SetFloatField(env, dlam, jni_dlamId, jni_dlam);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaed5 (JNIEnv * env, jobject calling_obj, jint i, jfloatArray d, jfloatArray z, jfloatArray delta, jfloat rho, jobject dlam){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_delta = (*env)->GetPrimitiveArrayCritical(env, delta, JNI_FALSE);
	check_memory(env, jni_delta);
	jclass jni_dlamClass = (*env)->GetObjectClass(env, dlam);
	jfieldID jni_dlamId = (*env)->GetFieldID(env, jni_dlamClass, "val", "D");
	jfloat jni_dlam = (*env)->GetFloatField(env, dlam, jni_dlamId);

	slaed5_(&i, jni_d, jni_z, jni_delta, &rho, &jni_dlam);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, delta, jni_delta, 0);
	(*env)->SetFloatField(env, dlam, jni_dlamId, jni_dlam);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaed6 (JNIEnv * env, jobject calling_obj, jint kniter, jboolean orgati, jfloat rho, jfloatArray d, jfloatArray z, jfloat finit, jobject tau, jobject info){
	logical jni_orgati = (logical)orgati;
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_tauClass = (*env)->GetObjectClass(env, tau);
	jfieldID jni_tauId = (*env)->GetFieldID(env, jni_tauClass, "val", "D");
	jfloat jni_tau = (*env)->GetFloatField(env, tau, jni_tauId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slaed6_(&kniter, &jni_orgati, &rho, jni_d, jni_z, &finit, &jni_tau, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetFloatField(env, tau, jni_tauId, jni_tau);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaed7 (JNIEnv * env, jobject calling_obj, jint icompq, jint n, jint qsiz, jint tlvls, jint curlvl, jint curpbm, jfloatArray d, jfloatArray q, jint ldq, jintArray indxq, jobject rho, jint cutpnt, jfloatArray qstore, jintArray qptr, jintArray prmptr, jintArray perm, jintArray givptr, jintArray givcol, jfloatArray givnum, jfloatArray work, jintArray iwork, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jint * jni_indxq = (*env)->GetPrimitiveArrayCritical(env, indxq, JNI_FALSE);
	check_memory(env, jni_indxq);
	jclass jni_rhoClass = (*env)->GetObjectClass(env, rho);
	jfieldID jni_rhoId = (*env)->GetFieldID(env, jni_rhoClass, "val", "D");
	jfloat jni_rho = (*env)->GetFloatField(env, rho, jni_rhoId);
	jfloat * jni_qstore = (*env)->GetPrimitiveArrayCritical(env, qstore, JNI_FALSE);
	check_memory(env, jni_qstore);
	jint * jni_qptr = (*env)->GetPrimitiveArrayCritical(env, qptr, JNI_FALSE);
	check_memory(env, jni_qptr);
	jint * jni_prmptr = (*env)->GetPrimitiveArrayCritical(env, prmptr, JNI_FALSE);
	check_memory(env, jni_prmptr);
	jint * jni_perm = (*env)->GetPrimitiveArrayCritical(env, perm, JNI_FALSE);
	check_memory(env, jni_perm);
	jint * jni_givptr = (*env)->GetPrimitiveArrayCritical(env, givptr, JNI_FALSE);
	check_memory(env, jni_givptr);
	jint * jni_givcol = (*env)->GetPrimitiveArrayCritical(env, givcol, JNI_FALSE);
	check_memory(env, jni_givcol);
	jfloat * jni_givnum = (*env)->GetPrimitiveArrayCritical(env, givnum, JNI_FALSE);
	check_memory(env, jni_givnum);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slaed7_(&icompq, &n, &qsiz, &tlvls, &curlvl, &curpbm, jni_d, jni_q, &ldq, jni_indxq, &jni_rho, &cutpnt, jni_qstore, jni_qptr, jni_prmptr, jni_perm, jni_givptr, jni_givcol, jni_givnum, jni_work, jni_iwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, indxq, jni_indxq, 0);
	(*env)->SetFloatField(env, rho, jni_rhoId, jni_rho);
	(*env)->ReleasePrimitiveArrayCritical(env, qstore, jni_qstore, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, qptr, jni_qptr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, prmptr, jni_prmptr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, perm, jni_perm, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givptr, jni_givptr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givcol, jni_givcol, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givnum, jni_givnum, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaed8 (JNIEnv * env, jobject calling_obj, jint icompq, jobject k, jint n, jint qsiz, jfloatArray d, jfloatArray q, jint ldq, jintArray indxq, jobject rho, jint cutpnt, jfloatArray z, jfloatArray dlamda, jfloatArray q2, jint ldq2, jfloatArray w, jintArray perm, jobject givptr, jintArray givcol, jfloatArray givnum, jintArray indxp, jintArray indx, jobject info){
	jclass jni_kClass = (*env)->GetObjectClass(env, k);
	jfieldID jni_kId = (*env)->GetFieldID(env, jni_kClass, "val", "I");
	jint jni_k = (*env)->GetIntField(env, k, jni_kId);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jint * jni_indxq = (*env)->GetPrimitiveArrayCritical(env, indxq, JNI_FALSE);
	check_memory(env, jni_indxq);
	jclass jni_rhoClass = (*env)->GetObjectClass(env, rho);
	jfieldID jni_rhoId = (*env)->GetFieldID(env, jni_rhoClass, "val", "D");
	jfloat jni_rho = (*env)->GetFloatField(env, rho, jni_rhoId);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_dlamda = (*env)->GetPrimitiveArrayCritical(env, dlamda, JNI_FALSE);
	check_memory(env, jni_dlamda);
	jfloat * jni_q2 = (*env)->GetPrimitiveArrayCritical(env, q2, JNI_FALSE);
	check_memory(env, jni_q2);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jint * jni_perm = (*env)->GetPrimitiveArrayCritical(env, perm, JNI_FALSE);
	check_memory(env, jni_perm);
	jclass jni_givptrClass = (*env)->GetObjectClass(env, givptr);
	jfieldID jni_givptrId = (*env)->GetFieldID(env, jni_givptrClass, "val", "I");
	jint jni_givptr = (*env)->GetIntField(env, givptr, jni_givptrId);
	jint * jni_givcol = (*env)->GetPrimitiveArrayCritical(env, givcol, JNI_FALSE);
	check_memory(env, jni_givcol);
	jfloat * jni_givnum = (*env)->GetPrimitiveArrayCritical(env, givnum, JNI_FALSE);
	check_memory(env, jni_givnum);
	jint * jni_indxp = (*env)->GetPrimitiveArrayCritical(env, indxp, JNI_FALSE);
	check_memory(env, jni_indxp);
	jint * jni_indx = (*env)->GetPrimitiveArrayCritical(env, indx, JNI_FALSE);
	check_memory(env, jni_indx);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slaed8_(&icompq, &jni_k, &n, &qsiz, jni_d, jni_q, &ldq, jni_indxq, &jni_rho, &cutpnt, jni_z, jni_dlamda, jni_q2, &ldq2, jni_w, jni_perm, &jni_givptr, jni_givcol, jni_givnum, jni_indxp, jni_indx, &jni_info);

	(*env)->SetIntField(env, k, jni_kId, jni_k);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, indxq, jni_indxq, 0);
	(*env)->SetFloatField(env, rho, jni_rhoId, jni_rho);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dlamda, jni_dlamda, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q2, jni_q2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, perm, jni_perm, 0);
	(*env)->SetIntField(env, givptr, jni_givptrId, jni_givptr);
	(*env)->ReleasePrimitiveArrayCritical(env, givcol, jni_givcol, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givnum, jni_givnum, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, indxp, jni_indxp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, indx, jni_indx, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaed9 (JNIEnv * env, jobject calling_obj, jint k, jint kstart, jint kstop, jint n, jfloatArray d, jfloatArray q, jint ldq, jfloat rho, jfloatArray dlamda, jfloatArray w, jfloatArray s, jint lds, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jfloat * jni_dlamda = (*env)->GetPrimitiveArrayCritical(env, dlamda, JNI_FALSE);
	check_memory(env, jni_dlamda);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slaed9_(&k, &kstart, &kstop, &n, jni_d, jni_q, &ldq, &rho, jni_dlamda, jni_w, jni_s, &lds, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dlamda, jni_dlamda, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaeda (JNIEnv * env, jobject calling_obj, jint n, jint tlvls, jint curlvl, jint curpbm, jintArray prmptr, jintArray perm, jintArray givptr, jintArray givcol, jfloatArray givnum, jfloatArray q, jintArray qptr, jfloatArray z, jfloatArray ztemp, jobject info){
	jint * jni_prmptr = (*env)->GetPrimitiveArrayCritical(env, prmptr, JNI_FALSE);
	check_memory(env, jni_prmptr);
	jint * jni_perm = (*env)->GetPrimitiveArrayCritical(env, perm, JNI_FALSE);
	check_memory(env, jni_perm);
	jint * jni_givptr = (*env)->GetPrimitiveArrayCritical(env, givptr, JNI_FALSE);
	check_memory(env, jni_givptr);
	jint * jni_givcol = (*env)->GetPrimitiveArrayCritical(env, givcol, JNI_FALSE);
	check_memory(env, jni_givcol);
	jfloat * jni_givnum = (*env)->GetPrimitiveArrayCritical(env, givnum, JNI_FALSE);
	check_memory(env, jni_givnum);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jint * jni_qptr = (*env)->GetPrimitiveArrayCritical(env, qptr, JNI_FALSE);
	check_memory(env, jni_qptr);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_ztemp = (*env)->GetPrimitiveArrayCritical(env, ztemp, JNI_FALSE);
	check_memory(env, jni_ztemp);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slaeda_(&n, &tlvls, &curlvl, &curpbm, jni_prmptr, jni_perm, jni_givptr, jni_givcol, jni_givnum, jni_q, jni_qptr, jni_z, jni_ztemp, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, prmptr, jni_prmptr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, perm, jni_perm, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givptr, jni_givptr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givcol, jni_givcol, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givnum, jni_givnum, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, qptr, jni_qptr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ztemp, jni_ztemp, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaein (JNIEnv * env, jobject calling_obj, jboolean rightv, jboolean noinit, jint n, jfloatArray h, jint ldh, jfloat wr, jfloat wi, jfloatArray vr, jfloatArray vi, jfloatArray b, jint ldb, jfloatArray work, jfloat eps3, jfloat smlnum, jfloat bignum, jobject info){
	logical jni_rightv = (logical)rightv;
	logical jni_noinit = (logical)noinit;
	jfloat * jni_h = (*env)->GetPrimitiveArrayCritical(env, h, JNI_FALSE);
	check_memory(env, jni_h);
	jfloat * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jfloat * jni_vi = (*env)->GetPrimitiveArrayCritical(env, vi, JNI_FALSE);
	check_memory(env, jni_vi);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slaein_(&jni_rightv, &jni_noinit, &n, jni_h, &ldh, &wr, &wi, jni_vr, jni_vi, jni_b, &ldb, jni_work, &eps3, &smlnum, &bignum, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, h, jni_h, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vi, jni_vi, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaev2 (JNIEnv * env, jobject calling_obj, jfloat a, jfloat b, jfloat c, jobject rt1, jobject rt2, jobject cs1, jobject sn1){
	jclass jni_rt1Class = (*env)->GetObjectClass(env, rt1);
	jfieldID jni_rt1Id = (*env)->GetFieldID(env, jni_rt1Class, "val", "D");
	jfloat jni_rt1 = (*env)->GetFloatField(env, rt1, jni_rt1Id);
	jclass jni_rt2Class = (*env)->GetObjectClass(env, rt2);
	jfieldID jni_rt2Id = (*env)->GetFieldID(env, jni_rt2Class, "val", "D");
	jfloat jni_rt2 = (*env)->GetFloatField(env, rt2, jni_rt2Id);
	jclass jni_cs1Class = (*env)->GetObjectClass(env, cs1);
	jfieldID jni_cs1Id = (*env)->GetFieldID(env, jni_cs1Class, "val", "D");
	jfloat jni_cs1 = (*env)->GetFloatField(env, cs1, jni_cs1Id);
	jclass jni_sn1Class = (*env)->GetObjectClass(env, sn1);
	jfieldID jni_sn1Id = (*env)->GetFieldID(env, jni_sn1Class, "val", "D");
	jfloat jni_sn1 = (*env)->GetFloatField(env, sn1, jni_sn1Id);

	slaev2_(&a, &b, &c, &jni_rt1, &jni_rt2, &jni_cs1, &jni_sn1);

	(*env)->SetFloatField(env, rt1, jni_rt1Id, jni_rt1);
	(*env)->SetFloatField(env, rt2, jni_rt2Id, jni_rt2);
	(*env)->SetFloatField(env, cs1, jni_cs1Id, jni_cs1);
	(*env)->SetFloatField(env, sn1, jni_sn1Id, jni_sn1);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaexc (JNIEnv * env, jobject calling_obj, jboolean wantq, jint n, jfloatArray t, jint ldt, jfloatArray q, jint ldq, jint j1, jint n1, jint n2, jfloatArray work, jobject info){
	logical jni_wantq = (logical)wantq;
	jfloat * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slaexc_(&jni_wantq, &n, jni_t, &ldt, jni_q, &ldq, &j1, &n1, &n2, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slag2 (JNIEnv * env, jobject calling_obj, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloat safmin, jobject scale1, jobject scale2, jobject wr1, jobject wr2, jobject wi){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_scale1Class = (*env)->GetObjectClass(env, scale1);
	jfieldID jni_scale1Id = (*env)->GetFieldID(env, jni_scale1Class, "val", "D");
	jfloat jni_scale1 = (*env)->GetFloatField(env, scale1, jni_scale1Id);
	jclass jni_scale2Class = (*env)->GetObjectClass(env, scale2);
	jfieldID jni_scale2Id = (*env)->GetFieldID(env, jni_scale2Class, "val", "D");
	jfloat jni_scale2 = (*env)->GetFloatField(env, scale2, jni_scale2Id);
	jclass jni_wr1Class = (*env)->GetObjectClass(env, wr1);
	jfieldID jni_wr1Id = (*env)->GetFieldID(env, jni_wr1Class, "val", "D");
	jfloat jni_wr1 = (*env)->GetFloatField(env, wr1, jni_wr1Id);
	jclass jni_wr2Class = (*env)->GetObjectClass(env, wr2);
	jfieldID jni_wr2Id = (*env)->GetFieldID(env, jni_wr2Class, "val", "D");
	jfloat jni_wr2 = (*env)->GetFloatField(env, wr2, jni_wr2Id);
	jclass jni_wiClass = (*env)->GetObjectClass(env, wi);
	jfieldID jni_wiId = (*env)->GetFieldID(env, jni_wiClass, "val", "D");
	jfloat jni_wi = (*env)->GetFloatField(env, wi, jni_wiId);

	slag2_(jni_a, &lda, jni_b, &ldb, &safmin, &jni_scale1, &jni_scale2, &jni_wr1, &jni_wr2, &jni_wi);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetFloatField(env, scale1, jni_scale1Id, jni_scale1);
	(*env)->SetFloatField(env, scale2, jni_scale2Id, jni_scale2);
	(*env)->SetFloatField(env, wr1, jni_wr1Id, jni_wr1);
	(*env)->SetFloatField(env, wr2, jni_wr2Id, jni_wr2);
	(*env)->SetFloatField(env, wi, jni_wiId, jni_wi);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slags2 (JNIEnv * env, jobject calling_obj, jboolean upper, jfloat a1, jfloat a2, jfloat a3, jfloat b1, jfloat b2, jfloat b3, jobject csu, jobject snu, jobject csv, jobject snv, jobject csq, jobject snq){
	logical jni_upper = (logical)upper;
	jclass jni_csuClass = (*env)->GetObjectClass(env, csu);
	jfieldID jni_csuId = (*env)->GetFieldID(env, jni_csuClass, "val", "D");
	jfloat jni_csu = (*env)->GetFloatField(env, csu, jni_csuId);
	jclass jni_snuClass = (*env)->GetObjectClass(env, snu);
	jfieldID jni_snuId = (*env)->GetFieldID(env, jni_snuClass, "val", "D");
	jfloat jni_snu = (*env)->GetFloatField(env, snu, jni_snuId);
	jclass jni_csvClass = (*env)->GetObjectClass(env, csv);
	jfieldID jni_csvId = (*env)->GetFieldID(env, jni_csvClass, "val", "D");
	jfloat jni_csv = (*env)->GetFloatField(env, csv, jni_csvId);
	jclass jni_snvClass = (*env)->GetObjectClass(env, snv);
	jfieldID jni_snvId = (*env)->GetFieldID(env, jni_snvClass, "val", "D");
	jfloat jni_snv = (*env)->GetFloatField(env, snv, jni_snvId);
	jclass jni_csqClass = (*env)->GetObjectClass(env, csq);
	jfieldID jni_csqId = (*env)->GetFieldID(env, jni_csqClass, "val", "D");
	jfloat jni_csq = (*env)->GetFloatField(env, csq, jni_csqId);
	jclass jni_snqClass = (*env)->GetObjectClass(env, snq);
	jfieldID jni_snqId = (*env)->GetFieldID(env, jni_snqClass, "val", "D");
	jfloat jni_snq = (*env)->GetFloatField(env, snq, jni_snqId);

	slags2_(&jni_upper, &a1, &a2, &a3, &b1, &b2, &b3, &jni_csu, &jni_snu, &jni_csv, &jni_snv, &jni_csq, &jni_snq);

	(*env)->SetFloatField(env, csu, jni_csuId, jni_csu);
	(*env)->SetFloatField(env, snu, jni_snuId, jni_snu);
	(*env)->SetFloatField(env, csv, jni_csvId, jni_csv);
	(*env)->SetFloatField(env, snv, jni_snvId, jni_snv);
	(*env)->SetFloatField(env, csq, jni_csqId, jni_csq);
	(*env)->SetFloatField(env, snq, jni_snqId, jni_snq);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slagtf (JNIEnv * env, jobject calling_obj, jint n, jfloatArray a, jfloat lambda, jfloatArray b, jfloatArray c, jfloat tol, jfloatArray d, jintArray in, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jint * jni_in = (*env)->GetPrimitiveArrayCritical(env, in, JNI_FALSE);
	check_memory(env, jni_in);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slagtf_(&n, jni_a, &lambda, jni_b, jni_c, &tol, jni_d, jni_in, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, in, jni_in, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slagtm (JNIEnv * env, jobject calling_obj, jstring trans, jint n, jint nrhs, jfloat alpha, jfloatArray dl, jfloatArray d, jfloatArray du, jfloatArray x, jint ldx, jfloat beta, jfloatArray b, jint ldb){
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_dl = (*env)->GetPrimitiveArrayCritical(env, dl, JNI_FALSE);
	check_memory(env, jni_dl);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_du = (*env)->GetPrimitiveArrayCritical(env, du, JNI_FALSE);
	check_memory(env, jni_du);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);

	slagtm_(jni_trans, &n, &nrhs, &alpha, jni_dl, jni_d, jni_du, jni_x, &ldx, &beta, jni_b, &ldb);

	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, dl, jni_dl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, du, jni_du, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slagts (JNIEnv * env, jobject calling_obj, jint job, jint n, jfloatArray a, jfloatArray b, jfloatArray c, jfloatArray d, jintArray in, jfloatArray y, jobject tol, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jint * jni_in = (*env)->GetPrimitiveArrayCritical(env, in, JNI_FALSE);
	check_memory(env, jni_in);
	jfloat * jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
	check_memory(env, jni_y);
	jclass jni_tolClass = (*env)->GetObjectClass(env, tol);
	jfieldID jni_tolId = (*env)->GetFieldID(env, jni_tolClass, "val", "D");
	jfloat jni_tol = (*env)->GetFloatField(env, tol, jni_tolId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slagts_(&job, &n, jni_a, jni_b, jni_c, jni_d, jni_in, jni_y, &jni_tol, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, in, jni_in, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
	(*env)->SetFloatField(env, tol, jni_tolId, jni_tol);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slagv2 (JNIEnv * env, jobject calling_obj, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray alphar, jfloatArray alphai, jfloatArray beta, jobject csl, jobject snl, jobject csr, jobject snr){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
	check_memory(env, jni_alphar);
	jfloat * jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
	check_memory(env, jni_alphai);
	jfloat * jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
	check_memory(env, jni_beta);
	jclass jni_cslClass = (*env)->GetObjectClass(env, csl);
	jfieldID jni_cslId = (*env)->GetFieldID(env, jni_cslClass, "val", "D");
	jfloat jni_csl = (*env)->GetFloatField(env, csl, jni_cslId);
	jclass jni_snlClass = (*env)->GetObjectClass(env, snl);
	jfieldID jni_snlId = (*env)->GetFieldID(env, jni_snlClass, "val", "D");
	jfloat jni_snl = (*env)->GetFloatField(env, snl, jni_snlId);
	jclass jni_csrClass = (*env)->GetObjectClass(env, csr);
	jfieldID jni_csrId = (*env)->GetFieldID(env, jni_csrClass, "val", "D");
	jfloat jni_csr = (*env)->GetFloatField(env, csr, jni_csrId);
	jclass jni_snrClass = (*env)->GetObjectClass(env, snr);
	jfieldID jni_snrId = (*env)->GetFieldID(env, jni_snrClass, "val", "D");
	jfloat jni_snr = (*env)->GetFloatField(env, snr, jni_snrId);

	slagv2_(jni_a, &lda, jni_b, &ldb, jni_alphar, jni_alphai, jni_beta, &jni_csl, &jni_snl, &jni_csr, &jni_snr);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
	(*env)->SetFloatField(env, csl, jni_cslId, jni_csl);
	(*env)->SetFloatField(env, snl, jni_snlId, jni_snl);
	(*env)->SetFloatField(env, csr, jni_csrId, jni_csr);
	(*env)->SetFloatField(env, snr, jni_snrId, jni_snr);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slahqr (JNIEnv * env, jobject calling_obj, jboolean wantt, jboolean wantz, jint n, jint ilo, jint ihi, jfloatArray h, jint ldh, jfloatArray wr, jfloatArray wi, jint iloz, jint ihiz, jfloatArray z, jint ldz, jobject info){
	logical jni_wantt = (logical)wantt;
	logical jni_wantz = (logical)wantz;
	jfloat * jni_h = (*env)->GetPrimitiveArrayCritical(env, h, JNI_FALSE);
	check_memory(env, jni_h);
	jfloat * jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
	check_memory(env, jni_wr);
	jfloat * jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
	check_memory(env, jni_wi);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slahqr_(&jni_wantt, &jni_wantz, &n, &ilo, &ihi, jni_h, &ldh, jni_wr, jni_wi, &iloz, &ihiz, jni_z, &ldz, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, h, jni_h, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slahrd (JNIEnv * env, jobject calling_obj, jint n, jint k, jint nb, jfloatArray a, jint lda, jfloatArray tau, jfloatArray t, jint ldt, jfloatArray y, jint ldy){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);
	jfloat * jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
	check_memory(env, jni_y);

	slahrd_(&n, &k, &nb, jni_a, &lda, jni_tau, jni_t, &ldt, jni_y, &ldy);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaic1 (JNIEnv * env, jobject calling_obj, jint job, jint j, jfloatArray x, jfloat sest, jfloatArray w, jfloat gamma, jobject sestpr, jobject s, jobject c){
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jclass jni_sestprClass = (*env)->GetObjectClass(env, sestpr);
	jfieldID jni_sestprId = (*env)->GetFieldID(env, jni_sestprClass, "val", "D");
	jfloat jni_sestpr = (*env)->GetFloatField(env, sestpr, jni_sestprId);
	jclass jni_sClass = (*env)->GetObjectClass(env, s);
	jfieldID jni_sId = (*env)->GetFieldID(env, jni_sClass, "val", "D");
	jfloat jni_s = (*env)->GetFloatField(env, s, jni_sId);
	jclass jni_cClass = (*env)->GetObjectClass(env, c);
	jfieldID jni_cId = (*env)->GetFieldID(env, jni_cClass, "val", "D");
	jfloat jni_c = (*env)->GetFloatField(env, c, jni_cId);

	slaic1_(&job, &j, jni_x, &sest, jni_w, &gamma, &jni_sestpr, &jni_s, &jni_c);

	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->SetFloatField(env, sestpr, jni_sestprId, jni_sestpr);
	(*env)->SetFloatField(env, s, jni_sId, jni_s);
	(*env)->SetFloatField(env, c, jni_cId, jni_c);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaln2 (JNIEnv * env, jobject calling_obj, jboolean ltrans, jint na, jint nw, jfloat smin, jfloat ca, jfloatArray a, jint lda, jfloat d1, jfloat d2, jfloatArray b, jint ldb, jfloat wr, jfloat wi, jfloatArray x, jint ldx, jobject scale, jobject xnorm, jobject info){
	logical jni_ltrans = (logical)ltrans;
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jfloat jni_scale = (*env)->GetFloatField(env, scale, jni_scaleId);
	jclass jni_xnormClass = (*env)->GetObjectClass(env, xnorm);
	jfieldID jni_xnormId = (*env)->GetFieldID(env, jni_xnormClass, "val", "D");
	jfloat jni_xnorm = (*env)->GetFloatField(env, xnorm, jni_xnormId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slaln2_(&jni_ltrans, &na, &nw, &smin, &ca, jni_a, &lda, &d1, &d2, jni_b, &ldb, &wr, &wi, jni_x, &ldx, &jni_scale, &jni_xnorm, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetFloatField(env, scale, jni_scaleId, jni_scale);
	(*env)->SetFloatField(env, xnorm, jni_xnormId, jni_xnorm);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slals0 (JNIEnv * env, jobject calling_obj, jint icompq, jint nl, jint nr, jint sqre, jint nrhs, jfloatArray b, jint ldb, jfloatArray bx, jint ldbx, jintArray perm, jint givptr, jintArray givcol, jint ldgcol, jfloatArray givnum, jint ldgnum, jfloatArray poles, jfloatArray difl, jfloatArray difr, jfloatArray z, jint k, jfloat c, jfloat s, jfloatArray work, jobject info){
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_bx = (*env)->GetPrimitiveArrayCritical(env, bx, JNI_FALSE);
	check_memory(env, jni_bx);
	jint * jni_perm = (*env)->GetPrimitiveArrayCritical(env, perm, JNI_FALSE);
	check_memory(env, jni_perm);
	jint * jni_givcol = (*env)->GetPrimitiveArrayCritical(env, givcol, JNI_FALSE);
	check_memory(env, jni_givcol);
	jfloat * jni_givnum = (*env)->GetPrimitiveArrayCritical(env, givnum, JNI_FALSE);
	check_memory(env, jni_givnum);
	jfloat * jni_poles = (*env)->GetPrimitiveArrayCritical(env, poles, JNI_FALSE);
	check_memory(env, jni_poles);
	jfloat * jni_difl = (*env)->GetPrimitiveArrayCritical(env, difl, JNI_FALSE);
	check_memory(env, jni_difl);
	jfloat * jni_difr = (*env)->GetPrimitiveArrayCritical(env, difr, JNI_FALSE);
	check_memory(env, jni_difr);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slals0_(&icompq, &nl, &nr, &sqre, &nrhs, jni_b, &ldb, jni_bx, &ldbx, jni_perm, &givptr, jni_givcol, &ldgcol, jni_givnum, &ldgnum, jni_poles, jni_difl, jni_difr, jni_z, &k, &c, &s, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, bx, jni_bx, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, perm, jni_perm, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givcol, jni_givcol, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givnum, jni_givnum, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, poles, jni_poles, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, difl, jni_difl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, difr, jni_difr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slalsa (JNIEnv * env, jobject calling_obj, jint icompq, jint smlsiz, jint n, jint nrhs, jfloatArray b, jint ldb, jfloatArray bx, jint ldbx, jfloatArray u, jint ldu, jfloatArray vt, jintArray k, jfloatArray difl, jfloatArray difr, jfloatArray z, jfloatArray poles, jintArray givptr, jintArray givcol, jint ldgcol, jintArray perm, jfloatArray givnum, jfloatArray c, jfloatArray s, jfloatArray work, jintArray iwork, jobject info){
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_bx = (*env)->GetPrimitiveArrayCritical(env, bx, JNI_FALSE);
	check_memory(env, jni_bx);
	jfloat * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jfloat * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jint * jni_k = (*env)->GetPrimitiveArrayCritical(env, k, JNI_FALSE);
	check_memory(env, jni_k);
	jfloat * jni_difl = (*env)->GetPrimitiveArrayCritical(env, difl, JNI_FALSE);
	check_memory(env, jni_difl);
	jfloat * jni_difr = (*env)->GetPrimitiveArrayCritical(env, difr, JNI_FALSE);
	check_memory(env, jni_difr);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_poles = (*env)->GetPrimitiveArrayCritical(env, poles, JNI_FALSE);
	check_memory(env, jni_poles);
	jint * jni_givptr = (*env)->GetPrimitiveArrayCritical(env, givptr, JNI_FALSE);
	check_memory(env, jni_givptr);
	jint * jni_givcol = (*env)->GetPrimitiveArrayCritical(env, givcol, JNI_FALSE);
	check_memory(env, jni_givcol);
	jint * jni_perm = (*env)->GetPrimitiveArrayCritical(env, perm, JNI_FALSE);
	check_memory(env, jni_perm);
	jfloat * jni_givnum = (*env)->GetPrimitiveArrayCritical(env, givnum, JNI_FALSE);
	check_memory(env, jni_givnum);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slalsa_(&icompq, &smlsiz, &n, &nrhs, jni_b, &ldb, jni_bx, &ldbx, jni_u, &ldu, jni_vt, jni_k, jni_difl, jni_difr, jni_z, jni_poles, jni_givptr, jni_givcol, &ldgcol, jni_perm, jni_givnum, jni_c, jni_s, jni_work, jni_iwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, bx, jni_bx, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, k, jni_k, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, difl, jni_difl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, difr, jni_difr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, poles, jni_poles, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givptr, jni_givptr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givcol, jni_givcol, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, perm, jni_perm, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givnum, jni_givnum, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slalsd (JNIEnv * env, jobject calling_obj, jstring uplo, jint smlsiz, jint n, jint nrhs, jfloatArray d, jfloatArray e, jfloatArray b, jint ldb, jfloat rcond, jobject rank, jfloatArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_rankClass = (*env)->GetObjectClass(env, rank);
	jfieldID jni_rankId = (*env)->GetFieldID(env, jni_rankClass, "val", "I");
	jint jni_rank = (*env)->GetIntField(env, rank, jni_rankId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slalsd_(jni_uplo, &smlsiz, &n, &nrhs, jni_d, jni_e, jni_b, &ldb, &rcond, &jni_rank, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, rank, jni_rankId, jni_rank);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slamrg (JNIEnv * env, jobject calling_obj, jint n1, jint n2, jfloatArray a, jint strd1, jint strd2, jintArray index){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_index = (*env)->GetPrimitiveArrayCritical(env, index, JNI_FALSE);
	check_memory(env, jni_index);

	slamrg_(&n1, &n2, jni_a, &strd1, &strd2, jni_index);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, index, jni_index, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slanv2 (JNIEnv * env, jobject calling_obj, jobject a, jobject b, jobject c, jobject d, jobject rt1r, jobject rt1i, jobject rt2r, jobject rt2i, jobject cs, jobject sn){
	jclass jni_aClass = (*env)->GetObjectClass(env, a);
	jfieldID jni_aId = (*env)->GetFieldID(env, jni_aClass, "val", "D");
	jfloat jni_a = (*env)->GetFloatField(env, a, jni_aId);
	jclass jni_bClass = (*env)->GetObjectClass(env, b);
	jfieldID jni_bId = (*env)->GetFieldID(env, jni_bClass, "val", "D");
	jfloat jni_b = (*env)->GetFloatField(env, b, jni_bId);
	jclass jni_cClass = (*env)->GetObjectClass(env, c);
	jfieldID jni_cId = (*env)->GetFieldID(env, jni_cClass, "val", "D");
	jfloat jni_c = (*env)->GetFloatField(env, c, jni_cId);
	jclass jni_dClass = (*env)->GetObjectClass(env, d);
	jfieldID jni_dId = (*env)->GetFieldID(env, jni_dClass, "val", "D");
	jfloat jni_d = (*env)->GetFloatField(env, d, jni_dId);
	jclass jni_rt1rClass = (*env)->GetObjectClass(env, rt1r);
	jfieldID jni_rt1rId = (*env)->GetFieldID(env, jni_rt1rClass, "val", "D");
	jfloat jni_rt1r = (*env)->GetFloatField(env, rt1r, jni_rt1rId);
	jclass jni_rt1iClass = (*env)->GetObjectClass(env, rt1i);
	jfieldID jni_rt1iId = (*env)->GetFieldID(env, jni_rt1iClass, "val", "D");
	jfloat jni_rt1i = (*env)->GetFloatField(env, rt1i, jni_rt1iId);
	jclass jni_rt2rClass = (*env)->GetObjectClass(env, rt2r);
	jfieldID jni_rt2rId = (*env)->GetFieldID(env, jni_rt2rClass, "val", "D");
	jfloat jni_rt2r = (*env)->GetFloatField(env, rt2r, jni_rt2rId);
	jclass jni_rt2iClass = (*env)->GetObjectClass(env, rt2i);
	jfieldID jni_rt2iId = (*env)->GetFieldID(env, jni_rt2iClass, "val", "D");
	jfloat jni_rt2i = (*env)->GetFloatField(env, rt2i, jni_rt2iId);
	jclass jni_csClass = (*env)->GetObjectClass(env, cs);
	jfieldID jni_csId = (*env)->GetFieldID(env, jni_csClass, "val", "D");
	jfloat jni_cs = (*env)->GetFloatField(env, cs, jni_csId);
	jclass jni_snClass = (*env)->GetObjectClass(env, sn);
	jfieldID jni_snId = (*env)->GetFieldID(env, jni_snClass, "val", "D");
	jfloat jni_sn = (*env)->GetFloatField(env, sn, jni_snId);

	slanv2_(&jni_a, &jni_b, &jni_c, &jni_d, &jni_rt1r, &jni_rt1i, &jni_rt2r, &jni_rt2i, &jni_cs, &jni_sn);

	(*env)->SetFloatField(env, a, jni_aId, jni_a);
	(*env)->SetFloatField(env, b, jni_bId, jni_b);
	(*env)->SetFloatField(env, c, jni_cId, jni_c);
	(*env)->SetFloatField(env, d, jni_dId, jni_d);
	(*env)->SetFloatField(env, rt1r, jni_rt1rId, jni_rt1r);
	(*env)->SetFloatField(env, rt1i, jni_rt1iId, jni_rt1i);
	(*env)->SetFloatField(env, rt2r, jni_rt2rId, jni_rt2r);
	(*env)->SetFloatField(env, rt2i, jni_rt2iId, jni_rt2i);
	(*env)->SetFloatField(env, cs, jni_csId, jni_cs);
	(*env)->SetFloatField(env, sn, jni_snId, jni_sn);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slapll (JNIEnv * env, jobject calling_obj, jint n, jfloatArray x, jint incx, jfloatArray y, jint incy, jobject ssmin){
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
	check_memory(env, jni_y);
	jclass jni_ssminClass = (*env)->GetObjectClass(env, ssmin);
	jfieldID jni_ssminId = (*env)->GetFieldID(env, jni_ssminClass, "val", "D");
	jfloat jni_ssmin = (*env)->GetFloatField(env, ssmin, jni_ssminId);

	slapll_(&n, jni_x, &incx, jni_y, &incy, &jni_ssmin);

	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
	(*env)->SetFloatField(env, ssmin, jni_ssminId, jni_ssmin);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slapmt (JNIEnv * env, jobject calling_obj, jboolean forwrd, jint m, jint n, jfloatArray x, jint ldx, jintArray k){
	logical jni_forwrd = (logical)forwrd;
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jint * jni_k = (*env)->GetPrimitiveArrayCritical(env, k, JNI_FALSE);
	check_memory(env, jni_k);

	slapmt_(&jni_forwrd, &m, &n, jni_x, &ldx, jni_k);

	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, k, jni_k, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaqgb (JNIEnv * env, jobject calling_obj, jint m, jint n, jint kl, jint ku, jfloatArray ab, jint ldab, jfloatArray r, jfloatArray c, jfloat rowcnd, jfloat colcnd, jfloat amax, jobject equed){
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
	check_memory(env, jni_r);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
	jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
	jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
	char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);

	slaqgb_(&m, &n, &kl, &ku, jni_ab, &ldab, jni_r, jni_c, &rowcnd, &colcnd, &amax, jni_equed);

	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	jstring jni_equedStringNew = (*env)->NewStringUTF(env, jni_equed);
	(*env)->SetObjectField(env, equed, jni_equedId, jni_equedStringNew);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaqge (JNIEnv * env, jobject calling_obj, jint m, jint n, jfloatArray a, jint lda, jfloatArray r, jfloatArray c, jfloat rowcnd, jfloat colcnd, jfloat amax, jobject equed){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_r = (*env)->GetPrimitiveArrayCritical(env, r, JNI_FALSE);
	check_memory(env, jni_r);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
	jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
	jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
	char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);

	slaqge_(&m, &n, jni_a, &lda, jni_r, jni_c, &rowcnd, &colcnd, &amax, jni_equed);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, r, jni_r, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	jstring jni_equedStringNew = (*env)->NewStringUTF(env, jni_equed);
	(*env)->SetObjectField(env, equed, jni_equedId, jni_equedStringNew);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaqp2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jint offset, jfloatArray a, jint lda, jintArray jpvt, jfloatArray tau, jfloatArray vn1, jfloatArray vn2, jfloatArray work){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
	check_memory(env, jni_jpvt);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_vn1 = (*env)->GetPrimitiveArrayCritical(env, vn1, JNI_FALSE);
	check_memory(env, jni_vn1);
	jfloat * jni_vn2 = (*env)->GetPrimitiveArrayCritical(env, vn2, JNI_FALSE);
	check_memory(env, jni_vn2);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);

	slaqp2_(&m, &n, &offset, jni_a, &lda, jni_jpvt, jni_tau, jni_vn1, jni_vn2, jni_work);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vn1, jni_vn1, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vn2, jni_vn2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaqps (JNIEnv * env, jobject calling_obj, jint m, jint n, jint offset, jint nb, jobject kb, jfloatArray a, jint lda, jintArray jpvt, jfloatArray tau, jfloatArray vn1, jfloatArray vn2, jfloatArray auxv, jfloatArray f, jint ldf){
	jclass jni_kbClass = (*env)->GetObjectClass(env, kb);
	jfieldID jni_kbId = (*env)->GetFieldID(env, jni_kbClass, "val", "I");
	jint jni_kb = (*env)->GetIntField(env, kb, jni_kbId);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_jpvt = (*env)->GetPrimitiveArrayCritical(env, jpvt, JNI_FALSE);
	check_memory(env, jni_jpvt);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_vn1 = (*env)->GetPrimitiveArrayCritical(env, vn1, JNI_FALSE);
	check_memory(env, jni_vn1);
	jfloat * jni_vn2 = (*env)->GetPrimitiveArrayCritical(env, vn2, JNI_FALSE);
	check_memory(env, jni_vn2);
	jfloat * jni_auxv = (*env)->GetPrimitiveArrayCritical(env, auxv, JNI_FALSE);
	check_memory(env, jni_auxv);
	jfloat * jni_f = (*env)->GetPrimitiveArrayCritical(env, f, JNI_FALSE);
	check_memory(env, jni_f);

	slaqps_(&m, &n, &offset, &nb, &jni_kb, jni_a, &lda, jni_jpvt, jni_tau, jni_vn1, jni_vn2, jni_auxv, jni_f, &ldf);

	(*env)->SetIntField(env, kb, jni_kbId, jni_kb);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, jpvt, jni_jpvt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vn1, jni_vn1, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vn2, jni_vn2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, auxv, jni_auxv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, f, jni_f, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaqsb (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jfloatArray ab, jint ldab, jfloatArray s, jfloat scond, jfloat amax, jobject equed){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
	jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
	jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
	char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);

	slaqsb_(jni_uplo, &n, &kd, jni_ab, &ldab, jni_s, &scond, &amax, jni_equed);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	jstring jni_equedStringNew = (*env)->NewStringUTF(env, jni_equed);
	(*env)->SetObjectField(env, equed, jni_equedId, jni_equedStringNew);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaqsp (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray ap, jfloatArray s, jfloat scond, jfloat amax, jobject equed){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
	jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
	jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
	char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);

	slaqsp_(jni_uplo, &n, jni_ap, jni_s, &scond, &amax, jni_equed);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	jstring jni_equedStringNew = (*env)->NewStringUTF(env, jni_equed);
	(*env)->SetObjectField(env, equed, jni_equedId, jni_equedStringNew);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaqsy (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray a, jint lda, jfloatArray s, jfloat scond, jfloat amax, jobject equed){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
	jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
	jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
	char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);

	slaqsy_(jni_uplo, &n, jni_a, &lda, jni_s, &scond, &amax, jni_equed);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	jstring jni_equedStringNew = (*env)->NewStringUTF(env, jni_equed);
	(*env)->SetObjectField(env, equed, jni_equedId, jni_equedStringNew);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaqtr (JNIEnv * env, jobject calling_obj, jboolean ltran, jboolean lreal, jint n, jfloatArray t, jint ldt, jfloatArray b, jfloat w, jobject scale, jfloatArray x, jfloatArray work, jobject info){
	logical jni_ltran = (logical)ltran;
	logical jni_lreal = (logical)lreal;
	jfloat * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jfloat jni_scale = (*env)->GetFloatField(env, scale, jni_scaleId);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slaqtr_(&jni_ltran, &jni_lreal, &n, jni_t, &ldt, jni_b, &w, &jni_scale, jni_x, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetFloatField(env, scale, jni_scaleId, jni_scale);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slar2v (JNIEnv * env, jobject calling_obj, jint n, jfloatArray x, jfloatArray y, jfloatArray z, jint incx, jfloatArray c, jfloatArray s, jint incc){
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
	check_memory(env, jni_y);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);

	slar2v_(&n, jni_x, jni_y, jni_z, &incx, jni_c, jni_s, &incc);

	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slarf (JNIEnv * env, jobject calling_obj, jstring side, jint m, jint n, jfloatArray v, jint incv, jfloat tau, jfloatArray c, jint Ldc, jfloatArray work){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	jfloat * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);

	slarf_(jni_side, &m, &n, jni_v, &incv, &tau, jni_c, &Ldc, jni_work);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slarfb (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jstring direct, jstring storev, jint m, jint n, jint k, jfloatArray v, jint ldv, jfloatArray t, jint ldt, jfloatArray c, jint Ldc, jfloatArray work, jint ldwork){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_direct = (char *)(*env)->GetStringUTFChars(env, direct, JNI_FALSE);
	char * jni_storev = (char *)(*env)->GetStringUTFChars(env, storev, JNI_FALSE);
	jfloat * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jfloat * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);

	slarfb_(jni_side, jni_trans, jni_direct, jni_storev, &m, &n, &k, jni_v, &ldv, jni_t, &ldt, jni_c, &Ldc, jni_work, &ldwork);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, direct, jni_direct);
	(*env)->ReleaseStringUTFChars(env, storev, jni_storev);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slarfg (JNIEnv * env, jobject calling_obj, jint n, jobject alpha, jfloatArray x, jint incx, jobject tau){
	jclass jni_alphaClass = (*env)->GetObjectClass(env, alpha);
	jfieldID jni_alphaId = (*env)->GetFieldID(env, jni_alphaClass, "val", "D");
	jfloat jni_alpha = (*env)->GetFloatField(env, alpha, jni_alphaId);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_tauClass = (*env)->GetObjectClass(env, tau);
	jfieldID jni_tauId = (*env)->GetFieldID(env, jni_tauClass, "val", "D");
	jfloat jni_tau = (*env)->GetFloatField(env, tau, jni_tauId);

	slarfg_(&n, &jni_alpha, jni_x, &incx, &jni_tau);

	(*env)->SetFloatField(env, alpha, jni_alphaId, jni_alpha);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetFloatField(env, tau, jni_tauId, jni_tau);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slarft (JNIEnv * env, jobject calling_obj, jstring direct, jstring storev, jint n, jint k, jfloatArray v, jint ldv, jfloatArray tau, jfloatArray t, jint ldt){
	char * jni_direct = (char *)(*env)->GetStringUTFChars(env, direct, JNI_FALSE);
	char * jni_storev = (char *)(*env)->GetStringUTFChars(env, storev, JNI_FALSE);
	jfloat * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);

	slarft_(jni_direct, jni_storev, &n, &k, jni_v, &ldv, jni_tau, jni_t, &ldt);

	(*env)->ReleaseStringUTFChars(env, direct, jni_direct);
	(*env)->ReleaseStringUTFChars(env, storev, jni_storev);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slarfx (JNIEnv * env, jobject calling_obj, jstring side, jint m, jint n, jfloatArray v, jfloat tau, jfloatArray c, jint Ldc, jfloatArray work){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	jfloat * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);

	slarfx_(jni_side, &m, &n, jni_v, &tau, jni_c, &Ldc, jni_work);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slargv (JNIEnv * env, jobject calling_obj, jint n, jfloatArray x, jint incx, jfloatArray y, jint incy, jfloatArray c, jint incc){
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
	check_memory(env, jni_y);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);

	slargv_(&n, jni_x, &incx, jni_y, &incy, jni_c, &incc);

	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slarnv (JNIEnv * env, jobject calling_obj, jint idist, jintArray iseed, jint n, jfloatArray x){
	jint * jni_iseed = (*env)->GetPrimitiveArrayCritical(env, iseed, JNI_FALSE);
	check_memory(env, jni_iseed);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);

	slarnv_(&idist, jni_iseed, &n, jni_x);

	(*env)->ReleasePrimitiveArrayCritical(env, iseed, jni_iseed, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slartg (JNIEnv * env, jobject calling_obj, jfloat f, jfloat g, jobject cs, jobject sn, jobject r){
	jclass jni_csClass = (*env)->GetObjectClass(env, cs);
	jfieldID jni_csId = (*env)->GetFieldID(env, jni_csClass, "val", "D");
	jfloat jni_cs = (*env)->GetFloatField(env, cs, jni_csId);
	jclass jni_snClass = (*env)->GetObjectClass(env, sn);
	jfieldID jni_snId = (*env)->GetFieldID(env, jni_snClass, "val", "D");
	jfloat jni_sn = (*env)->GetFloatField(env, sn, jni_snId);
	jclass jni_rClass = (*env)->GetObjectClass(env, r);
	jfieldID jni_rId = (*env)->GetFieldID(env, jni_rClass, "val", "D");
	jfloat jni_r = (*env)->GetFloatField(env, r, jni_rId);

	slartg_(&f, &g, &jni_cs, &jni_sn, &jni_r);

	(*env)->SetFloatField(env, cs, jni_csId, jni_cs);
	(*env)->SetFloatField(env, sn, jni_snId, jni_sn);
	(*env)->SetFloatField(env, r, jni_rId, jni_r);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slartv (JNIEnv * env, jobject calling_obj, jint n, jfloatArray x, jint incx, jfloatArray y, jint incy, jfloatArray c, jfloatArray s, jint incc){
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_y = (*env)->GetPrimitiveArrayCritical(env, y, JNI_FALSE);
	check_memory(env, jni_y);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);

	slartv_(&n, jni_x, &incx, jni_y, &incy, jni_c, jni_s, &incc);

	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, y, jni_y, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaruv (JNIEnv * env, jobject calling_obj, jintArray iseed, jint n, jfloatArray x){
	jint * jni_iseed = (*env)->GetPrimitiveArrayCritical(env, iseed, JNI_FALSE);
	check_memory(env, jni_iseed);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);

	slaruv_(jni_iseed, &n, jni_x);

	(*env)->ReleasePrimitiveArrayCritical(env, iseed, jni_iseed, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slarz (JNIEnv * env, jobject calling_obj, jstring side, jint m, jint n, jint l, jfloatArray v, jint incv, jfloat tau, jfloatArray c, jint Ldc, jfloatArray work){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	jfloat * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);

	slarz_(jni_side, &m, &n, &l, jni_v, &incv, &tau, jni_c, &Ldc, jni_work);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slarzb (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jstring direct, jstring storev, jint m, jint n, jint k, jint l, jfloatArray v, jint ldv, jfloatArray t, jint ldt, jfloatArray c, jint Ldc, jfloatArray work, jint ldwork){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_direct = (char *)(*env)->GetStringUTFChars(env, direct, JNI_FALSE);
	char * jni_storev = (char *)(*env)->GetStringUTFChars(env, storev, JNI_FALSE);
	jfloat * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jfloat * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);

	slarzb_(jni_side, jni_trans, jni_direct, jni_storev, &m, &n, &k, &l, jni_v, &ldv, jni_t, &ldt, jni_c, &Ldc, jni_work, &ldwork);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, direct, jni_direct);
	(*env)->ReleaseStringUTFChars(env, storev, jni_storev);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slarzt (JNIEnv * env, jobject calling_obj, jstring direct, jstring storev, jint n, jint k, jfloatArray v, jint ldv, jfloatArray tau, jfloatArray t, jint ldt){
	char * jni_direct = (char *)(*env)->GetStringUTFChars(env, direct, JNI_FALSE);
	char * jni_storev = (char *)(*env)->GetStringUTFChars(env, storev, JNI_FALSE);
	jfloat * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);

	slarzt_(jni_direct, jni_storev, &n, &k, jni_v, &ldv, jni_tau, jni_t, &ldt);

	(*env)->ReleaseStringUTFChars(env, direct, jni_direct);
	(*env)->ReleaseStringUTFChars(env, storev, jni_storev);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slas2 (JNIEnv * env, jobject calling_obj, jfloat f, jfloat g, jfloat h, jobject ssmin, jobject ssmax){
	jclass jni_ssminClass = (*env)->GetObjectClass(env, ssmin);
	jfieldID jni_ssminId = (*env)->GetFieldID(env, jni_ssminClass, "val", "D");
	jfloat jni_ssmin = (*env)->GetFloatField(env, ssmin, jni_ssminId);
	jclass jni_ssmaxClass = (*env)->GetObjectClass(env, ssmax);
	jfieldID jni_ssmaxId = (*env)->GetFieldID(env, jni_ssmaxClass, "val", "D");
	jfloat jni_ssmax = (*env)->GetFloatField(env, ssmax, jni_ssmaxId);

	slas2_(&f, &g, &h, &jni_ssmin, &jni_ssmax);

	(*env)->SetFloatField(env, ssmin, jni_ssminId, jni_ssmin);
	(*env)->SetFloatField(env, ssmax, jni_ssmaxId, jni_ssmax);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slascl (JNIEnv * env, jobject calling_obj, jstring type, jint kl, jint ku, jfloat cfrom, jfloat cto, jint m, jint n, jfloatArray a, jint lda, jobject info){
	char * jni_type = (char *)(*env)->GetStringUTFChars(env, type, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slascl_(jni_type, &kl, &ku, &cfrom, &cto, &m, &n, jni_a, &lda, &jni_info);

	(*env)->ReleaseStringUTFChars(env, type, jni_type);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasd0 (JNIEnv * env, jobject calling_obj, jint n, jint sqre, jfloatArray d, jfloatArray e, jfloatArray u, jint ldu, jfloatArray vt, jint ldvt, jint smlsiz, jintArray iwork, jfloatArray work, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jfloat * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slasd0_(&n, &sqre, jni_d, jni_e, jni_u, &ldu, jni_vt, &ldvt, &smlsiz, jni_iwork, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasd1 (JNIEnv * env, jobject calling_obj, jint nl, jint nr, jint sqre, jfloatArray d, jobject alpha, jobject beta, jfloatArray u, jint ldu, jfloatArray vt, jint ldvt, jintArray idxq, jintArray iwork, jfloatArray work, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jclass jni_alphaClass = (*env)->GetObjectClass(env, alpha);
	jfieldID jni_alphaId = (*env)->GetFieldID(env, jni_alphaClass, "val", "D");
	jfloat jni_alpha = (*env)->GetFloatField(env, alpha, jni_alphaId);
	jclass jni_betaClass = (*env)->GetObjectClass(env, beta);
	jfieldID jni_betaId = (*env)->GetFieldID(env, jni_betaClass, "val", "D");
	jfloat jni_beta = (*env)->GetFloatField(env, beta, jni_betaId);
	jfloat * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jfloat * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jint * jni_idxq = (*env)->GetPrimitiveArrayCritical(env, idxq, JNI_FALSE);
	check_memory(env, jni_idxq);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slasd1_(&nl, &nr, &sqre, jni_d, &jni_alpha, &jni_beta, jni_u, &ldu, jni_vt, &ldvt, jni_idxq, jni_iwork, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->SetFloatField(env, alpha, jni_alphaId, jni_alpha);
	(*env)->SetFloatField(env, beta, jni_betaId, jni_beta);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, idxq, jni_idxq, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasd2 (JNIEnv * env, jobject calling_obj, jint nl, jint nr, jint sqre, jobject k, jfloatArray d, jfloatArray z, jfloat alpha, jfloat beta, jfloatArray u, jint ldu, jfloatArray vt, jint ldvt, jfloatArray dsigma, jfloatArray u2, jint ldu2, jfloatArray vt2, jint ldvt2, jintArray idxp, jintArray idx, jintArray idxc, jintArray idxq, jintArray coltyp, jobject info){
	jclass jni_kClass = (*env)->GetObjectClass(env, k);
	jfieldID jni_kId = (*env)->GetFieldID(env, jni_kClass, "val", "I");
	jint jni_k = (*env)->GetIntField(env, k, jni_kId);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jfloat * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jfloat * jni_dsigma = (*env)->GetPrimitiveArrayCritical(env, dsigma, JNI_FALSE);
	check_memory(env, jni_dsigma);
	jfloat * jni_u2 = (*env)->GetPrimitiveArrayCritical(env, u2, JNI_FALSE);
	check_memory(env, jni_u2);
	jfloat * jni_vt2 = (*env)->GetPrimitiveArrayCritical(env, vt2, JNI_FALSE);
	check_memory(env, jni_vt2);
	jint * jni_idxp = (*env)->GetPrimitiveArrayCritical(env, idxp, JNI_FALSE);
	check_memory(env, jni_idxp);
	jint * jni_idx = (*env)->GetPrimitiveArrayCritical(env, idx, JNI_FALSE);
	check_memory(env, jni_idx);
	jint * jni_idxc = (*env)->GetPrimitiveArrayCritical(env, idxc, JNI_FALSE);
	check_memory(env, jni_idxc);
	jint * jni_idxq = (*env)->GetPrimitiveArrayCritical(env, idxq, JNI_FALSE);
	check_memory(env, jni_idxq);
	jint * jni_coltyp = (*env)->GetPrimitiveArrayCritical(env, coltyp, JNI_FALSE);
	check_memory(env, jni_coltyp);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slasd2_(&nl, &nr, &sqre, &jni_k, jni_d, jni_z, &alpha, &beta, jni_u, &ldu, jni_vt, &ldvt, jni_dsigma, jni_u2, &ldu2, jni_vt2, &ldvt2, jni_idxp, jni_idx, jni_idxc, jni_idxq, jni_coltyp, &jni_info);

	(*env)->SetIntField(env, k, jni_kId, jni_k);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dsigma, jni_dsigma, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u2, jni_u2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt2, jni_vt2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, idxp, jni_idxp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, idx, jni_idx, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, idxc, jni_idxc, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, idxq, jni_idxq, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, coltyp, jni_coltyp, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasd3 (JNIEnv * env, jobject calling_obj, jint nl, jint nr, jint sqre, jint k, jfloatArray d, jfloatArray q, jint ldq, jfloatArray dsigma, jfloatArray u, jint ldu, jfloatArray u2, jint ldu2, jfloatArray vt, jint ldvt, jfloatArray vt2, jint ldvt2, jintArray idxc, jintArray ctot, jfloatArray z, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jfloat * jni_dsigma = (*env)->GetPrimitiveArrayCritical(env, dsigma, JNI_FALSE);
	check_memory(env, jni_dsigma);
	jfloat * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jfloat * jni_u2 = (*env)->GetPrimitiveArrayCritical(env, u2, JNI_FALSE);
	check_memory(env, jni_u2);
	jfloat * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jfloat * jni_vt2 = (*env)->GetPrimitiveArrayCritical(env, vt2, JNI_FALSE);
	check_memory(env, jni_vt2);
	jint * jni_idxc = (*env)->GetPrimitiveArrayCritical(env, idxc, JNI_FALSE);
	check_memory(env, jni_idxc);
	jint * jni_ctot = (*env)->GetPrimitiveArrayCritical(env, ctot, JNI_FALSE);
	check_memory(env, jni_ctot);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slasd3_(&nl, &nr, &sqre, &k, jni_d, jni_q, &ldq, jni_dsigma, jni_u, &ldu, jni_u2, &ldu2, jni_vt, &ldvt, jni_vt2, &ldvt2, jni_idxc, jni_ctot, jni_z, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dsigma, jni_dsigma, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u2, jni_u2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt2, jni_vt2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, idxc, jni_idxc, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ctot, jni_ctot, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasd4 (JNIEnv * env, jobject calling_obj, jint n, jint i, jfloatArray d, jfloatArray z, jfloatArray delta, jfloat rho, jobject sigma, jfloatArray work, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_delta = (*env)->GetPrimitiveArrayCritical(env, delta, JNI_FALSE);
	check_memory(env, jni_delta);
	jclass jni_sigmaClass = (*env)->GetObjectClass(env, sigma);
	jfieldID jni_sigmaId = (*env)->GetFieldID(env, jni_sigmaClass, "val", "D");
	jfloat jni_sigma = (*env)->GetFloatField(env, sigma, jni_sigmaId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slasd4_(&n, &i, jni_d, jni_z, jni_delta, &rho, &jni_sigma, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, delta, jni_delta, 0);
	(*env)->SetFloatField(env, sigma, jni_sigmaId, jni_sigma);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasd5 (JNIEnv * env, jobject calling_obj, jint i, jfloatArray d, jfloatArray z, jfloatArray delta, jfloat rho, jobject dsigma, jfloatArray work){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_delta = (*env)->GetPrimitiveArrayCritical(env, delta, JNI_FALSE);
	check_memory(env, jni_delta);
	jclass jni_dsigmaClass = (*env)->GetObjectClass(env, dsigma);
	jfieldID jni_dsigmaId = (*env)->GetFieldID(env, jni_dsigmaClass, "val", "D");
	jfloat jni_dsigma = (*env)->GetFloatField(env, dsigma, jni_dsigmaId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);

	slasd5_(&i, jni_d, jni_z, jni_delta, &rho, &jni_dsigma, jni_work);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, delta, jni_delta, 0);
	(*env)->SetFloatField(env, dsigma, jni_dsigmaId, jni_dsigma);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasd6 (JNIEnv * env, jobject calling_obj, jint icompq, jint nl, jint nr, jint sqre, jfloatArray d, jfloatArray vf, jfloatArray vl, jobject alpha, jobject beta, jintArray idxq, jintArray perm, jobject givptr, jintArray givcol, jint ldgcol, jfloatArray givnum, jint ldgnum, jfloatArray poles, jfloatArray difl, jfloatArray difr, jfloatArray z, jobject k, jobject c, jobject s, jfloatArray work, jintArray iwork, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_vf = (*env)->GetPrimitiveArrayCritical(env, vf, JNI_FALSE);
	check_memory(env, jni_vf);
	jfloat * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jclass jni_alphaClass = (*env)->GetObjectClass(env, alpha);
	jfieldID jni_alphaId = (*env)->GetFieldID(env, jni_alphaClass, "val", "D");
	jfloat jni_alpha = (*env)->GetFloatField(env, alpha, jni_alphaId);
	jclass jni_betaClass = (*env)->GetObjectClass(env, beta);
	jfieldID jni_betaId = (*env)->GetFieldID(env, jni_betaClass, "val", "D");
	jfloat jni_beta = (*env)->GetFloatField(env, beta, jni_betaId);
	jint * jni_idxq = (*env)->GetPrimitiveArrayCritical(env, idxq, JNI_FALSE);
	check_memory(env, jni_idxq);
	jint * jni_perm = (*env)->GetPrimitiveArrayCritical(env, perm, JNI_FALSE);
	check_memory(env, jni_perm);
	jclass jni_givptrClass = (*env)->GetObjectClass(env, givptr);
	jfieldID jni_givptrId = (*env)->GetFieldID(env, jni_givptrClass, "val", "I");
	jint jni_givptr = (*env)->GetIntField(env, givptr, jni_givptrId);
	jint * jni_givcol = (*env)->GetPrimitiveArrayCritical(env, givcol, JNI_FALSE);
	check_memory(env, jni_givcol);
	jfloat * jni_givnum = (*env)->GetPrimitiveArrayCritical(env, givnum, JNI_FALSE);
	check_memory(env, jni_givnum);
	jfloat * jni_poles = (*env)->GetPrimitiveArrayCritical(env, poles, JNI_FALSE);
	check_memory(env, jni_poles);
	jfloat * jni_difl = (*env)->GetPrimitiveArrayCritical(env, difl, JNI_FALSE);
	check_memory(env, jni_difl);
	jfloat * jni_difr = (*env)->GetPrimitiveArrayCritical(env, difr, JNI_FALSE);
	check_memory(env, jni_difr);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_kClass = (*env)->GetObjectClass(env, k);
	jfieldID jni_kId = (*env)->GetFieldID(env, jni_kClass, "val", "I");
	jint jni_k = (*env)->GetIntField(env, k, jni_kId);
	jclass jni_cClass = (*env)->GetObjectClass(env, c);
	jfieldID jni_cId = (*env)->GetFieldID(env, jni_cClass, "val", "D");
	jfloat jni_c = (*env)->GetFloatField(env, c, jni_cId);
	jclass jni_sClass = (*env)->GetObjectClass(env, s);
	jfieldID jni_sId = (*env)->GetFieldID(env, jni_sClass, "val", "D");
	jfloat jni_s = (*env)->GetFloatField(env, s, jni_sId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slasd6_(&icompq, &nl, &nr, &sqre, jni_d, jni_vf, jni_vl, &jni_alpha, &jni_beta, jni_idxq, jni_perm, &jni_givptr, jni_givcol, &ldgcol, jni_givnum, &ldgnum, jni_poles, jni_difl, jni_difr, jni_z, &jni_k, &jni_c, &jni_s, jni_work, jni_iwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vf, jni_vf, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->SetFloatField(env, alpha, jni_alphaId, jni_alpha);
	(*env)->SetFloatField(env, beta, jni_betaId, jni_beta);
	(*env)->ReleasePrimitiveArrayCritical(env, idxq, jni_idxq, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, perm, jni_perm, 0);
	(*env)->SetIntField(env, givptr, jni_givptrId, jni_givptr);
	(*env)->ReleasePrimitiveArrayCritical(env, givcol, jni_givcol, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givnum, jni_givnum, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, poles, jni_poles, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, difl, jni_difl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, difr, jni_difr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetIntField(env, k, jni_kId, jni_k);
	(*env)->SetFloatField(env, c, jni_cId, jni_c);
	(*env)->SetFloatField(env, s, jni_sId, jni_s);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasd7 (JNIEnv * env, jobject calling_obj, jint icompq, jint nl, jint nr, jint sqre, jobject k, jfloatArray d, jfloatArray z, jfloatArray zw, jfloatArray vf, jfloatArray vfw, jfloatArray vl, jfloatArray vlw, jfloat alpha, jfloat beta, jfloatArray dsigma, jintArray idx, jintArray idxp, jintArray idxq, jintArray perm, jobject givptr, jintArray givcol, jint ldgcol, jfloatArray givnum, jint ldgnum, jobject c, jobject s, jobject info){
	jclass jni_kClass = (*env)->GetObjectClass(env, k);
	jfieldID jni_kId = (*env)->GetFieldID(env, jni_kClass, "val", "I");
	jint jni_k = (*env)->GetIntField(env, k, jni_kId);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_zw = (*env)->GetPrimitiveArrayCritical(env, zw, JNI_FALSE);
	check_memory(env, jni_zw);
	jfloat * jni_vf = (*env)->GetPrimitiveArrayCritical(env, vf, JNI_FALSE);
	check_memory(env, jni_vf);
	jfloat * jni_vfw = (*env)->GetPrimitiveArrayCritical(env, vfw, JNI_FALSE);
	check_memory(env, jni_vfw);
	jfloat * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jfloat * jni_vlw = (*env)->GetPrimitiveArrayCritical(env, vlw, JNI_FALSE);
	check_memory(env, jni_vlw);
	jfloat * jni_dsigma = (*env)->GetPrimitiveArrayCritical(env, dsigma, JNI_FALSE);
	check_memory(env, jni_dsigma);
	jint * jni_idx = (*env)->GetPrimitiveArrayCritical(env, idx, JNI_FALSE);
	check_memory(env, jni_idx);
	jint * jni_idxp = (*env)->GetPrimitiveArrayCritical(env, idxp, JNI_FALSE);
	check_memory(env, jni_idxp);
	jint * jni_idxq = (*env)->GetPrimitiveArrayCritical(env, idxq, JNI_FALSE);
	check_memory(env, jni_idxq);
	jint * jni_perm = (*env)->GetPrimitiveArrayCritical(env, perm, JNI_FALSE);
	check_memory(env, jni_perm);
	jclass jni_givptrClass = (*env)->GetObjectClass(env, givptr);
	jfieldID jni_givptrId = (*env)->GetFieldID(env, jni_givptrClass, "val", "I");
	jint jni_givptr = (*env)->GetIntField(env, givptr, jni_givptrId);
	jint * jni_givcol = (*env)->GetPrimitiveArrayCritical(env, givcol, JNI_FALSE);
	check_memory(env, jni_givcol);
	jfloat * jni_givnum = (*env)->GetPrimitiveArrayCritical(env, givnum, JNI_FALSE);
	check_memory(env, jni_givnum);
	jclass jni_cClass = (*env)->GetObjectClass(env, c);
	jfieldID jni_cId = (*env)->GetFieldID(env, jni_cClass, "val", "D");
	jfloat jni_c = (*env)->GetFloatField(env, c, jni_cId);
	jclass jni_sClass = (*env)->GetObjectClass(env, s);
	jfieldID jni_sId = (*env)->GetFieldID(env, jni_sClass, "val", "D");
	jfloat jni_s = (*env)->GetFloatField(env, s, jni_sId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slasd7_(&icompq, &nl, &nr, &sqre, &jni_k, jni_d, jni_z, jni_zw, jni_vf, jni_vfw, jni_vl, jni_vlw, &alpha, &beta, jni_dsigma, jni_idx, jni_idxp, jni_idxq, jni_perm, &jni_givptr, jni_givcol, &ldgcol, jni_givnum, &ldgnum, &jni_c, &jni_s, &jni_info);

	(*env)->SetIntField(env, k, jni_kId, jni_k);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, zw, jni_zw, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vf, jni_vf, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vfw, jni_vfw, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vlw, jni_vlw, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dsigma, jni_dsigma, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, idx, jni_idx, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, idxp, jni_idxp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, idxq, jni_idxq, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, perm, jni_perm, 0);
	(*env)->SetIntField(env, givptr, jni_givptrId, jni_givptr);
	(*env)->ReleasePrimitiveArrayCritical(env, givcol, jni_givcol, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givnum, jni_givnum, 0);
	(*env)->SetFloatField(env, c, jni_cId, jni_c);
	(*env)->SetFloatField(env, s, jni_sId, jni_s);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasd8 (JNIEnv * env, jobject calling_obj, jint icompq, jint k, jfloatArray d, jfloatArray z, jfloatArray vf, jfloatArray vl, jfloatArray difl, jfloatArray difr, jint lddifr, jfloatArray dsigma, jfloatArray work, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_vf = (*env)->GetPrimitiveArrayCritical(env, vf, JNI_FALSE);
	check_memory(env, jni_vf);
	jfloat * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jfloat * jni_difl = (*env)->GetPrimitiveArrayCritical(env, difl, JNI_FALSE);
	check_memory(env, jni_difl);
	jfloat * jni_difr = (*env)->GetPrimitiveArrayCritical(env, difr, JNI_FALSE);
	check_memory(env, jni_difr);
	jfloat * jni_dsigma = (*env)->GetPrimitiveArrayCritical(env, dsigma, JNI_FALSE);
	check_memory(env, jni_dsigma);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slasd8_(&icompq, &k, jni_d, jni_z, jni_vf, jni_vl, jni_difl, jni_difr, &lddifr, jni_dsigma, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vf, jni_vf, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, difl, jni_difl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, difr, jni_difr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dsigma, jni_dsigma, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasda (JNIEnv * env, jobject calling_obj, jint icompq, jint smlsiz, jint n, jint sqre, jfloatArray d, jfloatArray e, jfloatArray u, jint ldu, jfloatArray vt, jintArray k, jfloatArray difl, jfloatArray difr, jfloatArray z, jfloatArray poles, jintArray givptr, jintArray givcol, jint ldgcol, jintArray perm, jfloatArray givnum, jfloatArray c, jfloatArray s, jfloatArray work, jintArray iwork, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jfloat * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jint * jni_k = (*env)->GetPrimitiveArrayCritical(env, k, JNI_FALSE);
	check_memory(env, jni_k);
	jfloat * jni_difl = (*env)->GetPrimitiveArrayCritical(env, difl, JNI_FALSE);
	check_memory(env, jni_difl);
	jfloat * jni_difr = (*env)->GetPrimitiveArrayCritical(env, difr, JNI_FALSE);
	check_memory(env, jni_difr);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_poles = (*env)->GetPrimitiveArrayCritical(env, poles, JNI_FALSE);
	check_memory(env, jni_poles);
	jint * jni_givptr = (*env)->GetPrimitiveArrayCritical(env, givptr, JNI_FALSE);
	check_memory(env, jni_givptr);
	jint * jni_givcol = (*env)->GetPrimitiveArrayCritical(env, givcol, JNI_FALSE);
	check_memory(env, jni_givcol);
	jint * jni_perm = (*env)->GetPrimitiveArrayCritical(env, perm, JNI_FALSE);
	check_memory(env, jni_perm);
	jfloat * jni_givnum = (*env)->GetPrimitiveArrayCritical(env, givnum, JNI_FALSE);
	check_memory(env, jni_givnum);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slasda_(&icompq, &smlsiz, &n, &sqre, jni_d, jni_e, jni_u, &ldu, jni_vt, jni_k, jni_difl, jni_difr, jni_z, jni_poles, jni_givptr, jni_givcol, &ldgcol, jni_perm, jni_givnum, jni_c, jni_s, jni_work, jni_iwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, k, jni_k, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, difl, jni_difl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, difr, jni_difr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, poles, jni_poles, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givptr, jni_givptr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givcol, jni_givcol, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, perm, jni_perm, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, givnum, jni_givnum, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasdq (JNIEnv * env, jobject calling_obj, jstring uplo, jint sqre, jint n, jint ncvt, jint nru, jint ncc, jfloatArray d, jfloatArray e, jfloatArray vt, jint ldvt, jfloatArray u, jint ldu, jfloatArray c, jint Ldc, jfloatArray work, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_vt = (*env)->GetPrimitiveArrayCritical(env, vt, JNI_FALSE);
	check_memory(env, jni_vt);
	jfloat * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slasdq_(jni_uplo, &sqre, &n, &ncvt, &nru, &ncc, jni_d, jni_e, jni_vt, &ldvt, jni_u, &ldu, jni_c, &Ldc, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vt, jni_vt, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasdt (JNIEnv * env, jobject calling_obj, jint n, jobject lvl, jobject nd, jintArray inode, jintArray ndiml, jintArray ndimr, jint msub){
	jclass jni_lvlClass = (*env)->GetObjectClass(env, lvl);
	jfieldID jni_lvlId = (*env)->GetFieldID(env, jni_lvlClass, "val", "I");
	jint jni_lvl = (*env)->GetIntField(env, lvl, jni_lvlId);
	jclass jni_ndClass = (*env)->GetObjectClass(env, nd);
	jfieldID jni_ndId = (*env)->GetFieldID(env, jni_ndClass, "val", "I");
	jint jni_nd = (*env)->GetIntField(env, nd, jni_ndId);
	jint * jni_inode = (*env)->GetPrimitiveArrayCritical(env, inode, JNI_FALSE);
	check_memory(env, jni_inode);
	jint * jni_ndiml = (*env)->GetPrimitiveArrayCritical(env, ndiml, JNI_FALSE);
	check_memory(env, jni_ndiml);
	jint * jni_ndimr = (*env)->GetPrimitiveArrayCritical(env, ndimr, JNI_FALSE);
	check_memory(env, jni_ndimr);

	slasdt_(&n, &jni_lvl, &jni_nd, jni_inode, jni_ndiml, jni_ndimr, &msub);

	(*env)->SetIntField(env, lvl, jni_lvlId, jni_lvl);
	(*env)->SetIntField(env, nd, jni_ndId, jni_nd);
	(*env)->ReleasePrimitiveArrayCritical(env, inode, jni_inode, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ndiml, jni_ndiml, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ndimr, jni_ndimr, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaset (JNIEnv * env, jobject calling_obj, jstring uplo, jint m, jint n, jfloat alpha, jfloat beta, jfloatArray a, jint lda){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);

	slaset_(jni_uplo, &m, &n, &alpha, &beta, jni_a, &lda);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasq1 (JNIEnv * env, jobject calling_obj, jint n, jfloatArray d, jfloatArray e, jfloatArray work, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slasq1_(&n, jni_d, jni_e, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasq2 (JNIEnv * env, jobject calling_obj, jint n, jfloatArray z, jobject info){
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slasq2_(&n, jni_z, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasq3 (JNIEnv * env, jobject calling_obj, jint i0, jobject n0, jfloatArray z, jint pp, jobject dmin, jobject sigma, jobject desig, jobject qmax, jobject nfail, jobject iter, jobject ndiv, jboolean ieee){
	jclass jni_n0Class = (*env)->GetObjectClass(env, n0);
	jfieldID jni_n0Id = (*env)->GetFieldID(env, jni_n0Class, "val", "I");
	jint jni_n0 = (*env)->GetIntField(env, n0, jni_n0Id);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_dminClass = (*env)->GetObjectClass(env, dmin);
	jfieldID jni_dminId = (*env)->GetFieldID(env, jni_dminClass, "val", "D");
	jfloat jni_dmin = (*env)->GetFloatField(env, dmin, jni_dminId);
	jclass jni_sigmaClass = (*env)->GetObjectClass(env, sigma);
	jfieldID jni_sigmaId = (*env)->GetFieldID(env, jni_sigmaClass, "val", "D");
	jfloat jni_sigma = (*env)->GetFloatField(env, sigma, jni_sigmaId);
	jclass jni_desigClass = (*env)->GetObjectClass(env, desig);
	jfieldID jni_desigId = (*env)->GetFieldID(env, jni_desigClass, "val", "D");
	jfloat jni_desig = (*env)->GetFloatField(env, desig, jni_desigId);
	jclass jni_qmaxClass = (*env)->GetObjectClass(env, qmax);
	jfieldID jni_qmaxId = (*env)->GetFieldID(env, jni_qmaxClass, "val", "D");
	jfloat jni_qmax = (*env)->GetFloatField(env, qmax, jni_qmaxId);
	jclass jni_nfailClass = (*env)->GetObjectClass(env, nfail);
	jfieldID jni_nfailId = (*env)->GetFieldID(env, jni_nfailClass, "val", "I");
	jint jni_nfail = (*env)->GetIntField(env, nfail, jni_nfailId);
	jclass jni_iterClass = (*env)->GetObjectClass(env, iter);
	jfieldID jni_iterId = (*env)->GetFieldID(env, jni_iterClass, "val", "I");
	jint jni_iter = (*env)->GetIntField(env, iter, jni_iterId);
	jclass jni_ndivClass = (*env)->GetObjectClass(env, ndiv);
	jfieldID jni_ndivId = (*env)->GetFieldID(env, jni_ndivClass, "val", "I");
	jint jni_ndiv = (*env)->GetIntField(env, ndiv, jni_ndivId);
	logical jni_ieee = (logical)ieee;

	slasq3_(&i0, &jni_n0, jni_z, &pp, &jni_dmin, &jni_sigma, &jni_desig, &jni_qmax, &jni_nfail, &jni_iter, &jni_ndiv, &jni_ieee);

	(*env)->SetIntField(env, n0, jni_n0Id, jni_n0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetFloatField(env, dmin, jni_dminId, jni_dmin);
	(*env)->SetFloatField(env, sigma, jni_sigmaId, jni_sigma);
	(*env)->SetFloatField(env, desig, jni_desigId, jni_desig);
	(*env)->SetFloatField(env, qmax, jni_qmaxId, jni_qmax);
	(*env)->SetIntField(env, nfail, jni_nfailId, jni_nfail);
	(*env)->SetIntField(env, iter, jni_iterId, jni_iter);
	(*env)->SetIntField(env, ndiv, jni_ndivId, jni_ndiv);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasq4 (JNIEnv * env, jobject calling_obj, jint i0, jint n0, jfloatArray z, jint pp, jint n0in, jfloat dmin, jfloat dmin1, jfloat dmin2, jfloat dn, jfloat dn1, jfloat dn2, jobject tau, jobject ttype){
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_tauClass = (*env)->GetObjectClass(env, tau);
	jfieldID jni_tauId = (*env)->GetFieldID(env, jni_tauClass, "val", "D");
	jfloat jni_tau = (*env)->GetFloatField(env, tau, jni_tauId);
	jclass jni_ttypeClass = (*env)->GetObjectClass(env, ttype);
	jfieldID jni_ttypeId = (*env)->GetFieldID(env, jni_ttypeClass, "val", "I");
	jint jni_ttype = (*env)->GetIntField(env, ttype, jni_ttypeId);

	slasq4_(&i0, &n0, jni_z, &pp, &n0in, &dmin, &dmin1, &dmin2, &dn, &dn1, &dn2, &jni_tau, &jni_ttype);

	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetFloatField(env, tau, jni_tauId, jni_tau);
	(*env)->SetIntField(env, ttype, jni_ttypeId, jni_ttype);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasq5 (JNIEnv * env, jobject calling_obj, jint i0, jint n0, jfloatArray z, jint pp, jfloat tau, jobject dmin, jobject dmin1, jobject dmin2, jobject dn, jobject dnm1, jobject dnm2, jboolean ieee){
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_dminClass = (*env)->GetObjectClass(env, dmin);
	jfieldID jni_dminId = (*env)->GetFieldID(env, jni_dminClass, "val", "D");
	jfloat jni_dmin = (*env)->GetFloatField(env, dmin, jni_dminId);
	jclass jni_dmin1Class = (*env)->GetObjectClass(env, dmin1);
	jfieldID jni_dmin1Id = (*env)->GetFieldID(env, jni_dmin1Class, "val", "D");
	jfloat jni_dmin1 = (*env)->GetFloatField(env, dmin1, jni_dmin1Id);
	jclass jni_dmin2Class = (*env)->GetObjectClass(env, dmin2);
	jfieldID jni_dmin2Id = (*env)->GetFieldID(env, jni_dmin2Class, "val", "D");
	jfloat jni_dmin2 = (*env)->GetFloatField(env, dmin2, jni_dmin2Id);
	jclass jni_dnClass = (*env)->GetObjectClass(env, dn);
	jfieldID jni_dnId = (*env)->GetFieldID(env, jni_dnClass, "val", "D");
	jfloat jni_dn = (*env)->GetFloatField(env, dn, jni_dnId);
	jclass jni_dnm1Class = (*env)->GetObjectClass(env, dnm1);
	jfieldID jni_dnm1Id = (*env)->GetFieldID(env, jni_dnm1Class, "val", "D");
	jfloat jni_dnm1 = (*env)->GetFloatField(env, dnm1, jni_dnm1Id);
	jclass jni_dnm2Class = (*env)->GetObjectClass(env, dnm2);
	jfieldID jni_dnm2Id = (*env)->GetFieldID(env, jni_dnm2Class, "val", "D");
	jfloat jni_dnm2 = (*env)->GetFloatField(env, dnm2, jni_dnm2Id);
	logical jni_ieee = (logical)ieee;

	slasq5_(&i0, &n0, jni_z, &pp, &tau, &jni_dmin, &jni_dmin1, &jni_dmin2, &jni_dn, &jni_dnm1, &jni_dnm2, &jni_ieee);

	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetFloatField(env, dmin, jni_dminId, jni_dmin);
	(*env)->SetFloatField(env, dmin1, jni_dmin1Id, jni_dmin1);
	(*env)->SetFloatField(env, dmin2, jni_dmin2Id, jni_dmin2);
	(*env)->SetFloatField(env, dn, jni_dnId, jni_dn);
	(*env)->SetFloatField(env, dnm1, jni_dnm1Id, jni_dnm1);
	(*env)->SetFloatField(env, dnm2, jni_dnm2Id, jni_dnm2);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasq6 (JNIEnv * env, jobject calling_obj, jint i0, jint n0, jfloatArray z, jint pp, jobject dmin, jobject dmin1, jobject dmin2, jobject dn, jobject dnm1, jobject dnm2){
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_dminClass = (*env)->GetObjectClass(env, dmin);
	jfieldID jni_dminId = (*env)->GetFieldID(env, jni_dminClass, "val", "D");
	jfloat jni_dmin = (*env)->GetFloatField(env, dmin, jni_dminId);
	jclass jni_dmin1Class = (*env)->GetObjectClass(env, dmin1);
	jfieldID jni_dmin1Id = (*env)->GetFieldID(env, jni_dmin1Class, "val", "D");
	jfloat jni_dmin1 = (*env)->GetFloatField(env, dmin1, jni_dmin1Id);
	jclass jni_dmin2Class = (*env)->GetObjectClass(env, dmin2);
	jfieldID jni_dmin2Id = (*env)->GetFieldID(env, jni_dmin2Class, "val", "D");
	jfloat jni_dmin2 = (*env)->GetFloatField(env, dmin2, jni_dmin2Id);
	jclass jni_dnClass = (*env)->GetObjectClass(env, dn);
	jfieldID jni_dnId = (*env)->GetFieldID(env, jni_dnClass, "val", "D");
	jfloat jni_dn = (*env)->GetFloatField(env, dn, jni_dnId);
	jclass jni_dnm1Class = (*env)->GetObjectClass(env, dnm1);
	jfieldID jni_dnm1Id = (*env)->GetFieldID(env, jni_dnm1Class, "val", "D");
	jfloat jni_dnm1 = (*env)->GetFloatField(env, dnm1, jni_dnm1Id);
	jclass jni_dnm2Class = (*env)->GetObjectClass(env, dnm2);
	jfieldID jni_dnm2Id = (*env)->GetFieldID(env, jni_dnm2Class, "val", "D");
	jfloat jni_dnm2 = (*env)->GetFloatField(env, dnm2, jni_dnm2Id);

	slasq6_(&i0, &n0, jni_z, &pp, &jni_dmin, &jni_dmin1, &jni_dmin2, &jni_dn, &jni_dnm1, &jni_dnm2);

	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetFloatField(env, dmin, jni_dminId, jni_dmin);
	(*env)->SetFloatField(env, dmin1, jni_dmin1Id, jni_dmin1);
	(*env)->SetFloatField(env, dmin2, jni_dmin2Id, jni_dmin2);
	(*env)->SetFloatField(env, dn, jni_dnId, jni_dn);
	(*env)->SetFloatField(env, dnm1, jni_dnm1Id, jni_dnm1);
	(*env)->SetFloatField(env, dnm2, jni_dnm2Id, jni_dnm2);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasr (JNIEnv * env, jobject calling_obj, jstring side, jstring pivot, jstring direct, jint m, jint n, jfloatArray c, jfloatArray s, jfloatArray a, jint lda){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_pivot = (char *)(*env)->GetStringUTFChars(env, pivot, JNI_FALSE);
	char * jni_direct = (char *)(*env)->GetStringUTFChars(env, direct, JNI_FALSE);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);

	slasr_(jni_side, jni_pivot, jni_direct, &m, &n, jni_c, jni_s, jni_a, &lda);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, pivot, jni_pivot);
	(*env)->ReleaseStringUTFChars(env, direct, jni_direct);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasrt (JNIEnv * env, jobject calling_obj, jstring id, jint n, jfloatArray d, jobject info){
	char * jni_id = (char *)(*env)->GetStringUTFChars(env, id, JNI_FALSE);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slasrt_(jni_id, &n, jni_d, &jni_info);

	(*env)->ReleaseStringUTFChars(env, id, jni_id);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slassq (JNIEnv * env, jobject calling_obj, jint n, jfloatArray x, jint incx, jobject scale, jobject sumsq){
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jfloat jni_scale = (*env)->GetFloatField(env, scale, jni_scaleId);
	jclass jni_sumsqClass = (*env)->GetObjectClass(env, sumsq);
	jfieldID jni_sumsqId = (*env)->GetFieldID(env, jni_sumsqClass, "val", "D");
	jfloat jni_sumsq = (*env)->GetFloatField(env, sumsq, jni_sumsqId);

	slassq_(&n, jni_x, &incx, &jni_scale, &jni_sumsq);

	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetFloatField(env, scale, jni_scaleId, jni_scale);
	(*env)->SetFloatField(env, sumsq, jni_sumsqId, jni_sumsq);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasv2 (JNIEnv * env, jobject calling_obj, jfloat f, jfloat g, jfloat h, jobject ssmin, jobject ssmax, jobject snr, jobject csr, jobject snl, jobject csl){
	jclass jni_ssminClass = (*env)->GetObjectClass(env, ssmin);
	jfieldID jni_ssminId = (*env)->GetFieldID(env, jni_ssminClass, "val", "D");
	jfloat jni_ssmin = (*env)->GetFloatField(env, ssmin, jni_ssminId);
	jclass jni_ssmaxClass = (*env)->GetObjectClass(env, ssmax);
	jfieldID jni_ssmaxId = (*env)->GetFieldID(env, jni_ssmaxClass, "val", "D");
	jfloat jni_ssmax = (*env)->GetFloatField(env, ssmax, jni_ssmaxId);
	jclass jni_snrClass = (*env)->GetObjectClass(env, snr);
	jfieldID jni_snrId = (*env)->GetFieldID(env, jni_snrClass, "val", "D");
	jfloat jni_snr = (*env)->GetFloatField(env, snr, jni_snrId);
	jclass jni_csrClass = (*env)->GetObjectClass(env, csr);
	jfieldID jni_csrId = (*env)->GetFieldID(env, jni_csrClass, "val", "D");
	jfloat jni_csr = (*env)->GetFloatField(env, csr, jni_csrId);
	jclass jni_snlClass = (*env)->GetObjectClass(env, snl);
	jfieldID jni_snlId = (*env)->GetFieldID(env, jni_snlClass, "val", "D");
	jfloat jni_snl = (*env)->GetFloatField(env, snl, jni_snlId);
	jclass jni_cslClass = (*env)->GetObjectClass(env, csl);
	jfieldID jni_cslId = (*env)->GetFieldID(env, jni_cslClass, "val", "D");
	jfloat jni_csl = (*env)->GetFloatField(env, csl, jni_cslId);

	slasv2_(&f, &g, &h, &jni_ssmin, &jni_ssmax, &jni_snr, &jni_csr, &jni_snl, &jni_csl);

	(*env)->SetFloatField(env, ssmin, jni_ssminId, jni_ssmin);
	(*env)->SetFloatField(env, ssmax, jni_ssmaxId, jni_ssmax);
	(*env)->SetFloatField(env, snr, jni_snrId, jni_snr);
	(*env)->SetFloatField(env, csr, jni_csrId, jni_csr);
	(*env)->SetFloatField(env, snl, jni_snlId, jni_snl);
	(*env)->SetFloatField(env, csl, jni_cslId, jni_csl);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slaswp (JNIEnv * env, jobject calling_obj, jint n, jfloatArray a, jint lda, jint k1, jint k2, jintArray ipiv, jint incx){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);

	slaswp_(&n, jni_a, &lda, &k1, &k2, jni_ipiv, &incx);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasy2 (JNIEnv * env, jobject calling_obj, jboolean ltranl, jboolean ltranr, jint isgn, jint n1, jint n2, jfloatArray tl, jint ldtl, jfloatArray tr, jint ldtr, jfloatArray b, jint ldb, jobject scale, jfloatArray x, jint ldx, jobject xnorm, jobject info){
	logical jni_ltranl = (logical)ltranl;
	logical jni_ltranr = (logical)ltranr;
	jfloat * jni_tl = (*env)->GetPrimitiveArrayCritical(env, tl, JNI_FALSE);
	check_memory(env, jni_tl);
	jfloat * jni_tr = (*env)->GetPrimitiveArrayCritical(env, tr, JNI_FALSE);
	check_memory(env, jni_tr);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jfloat jni_scale = (*env)->GetFloatField(env, scale, jni_scaleId);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_xnormClass = (*env)->GetObjectClass(env, xnorm);
	jfieldID jni_xnormId = (*env)->GetFieldID(env, jni_xnormClass, "val", "D");
	jfloat jni_xnorm = (*env)->GetFloatField(env, xnorm, jni_xnormId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slasy2_(&jni_ltranl, &jni_ltranr, &isgn, &n1, &n2, jni_tl, &ldtl, jni_tr, &ldtr, jni_b, &ldb, &jni_scale, jni_x, &ldx, &jni_xnorm, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, tl, jni_tl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tr, jni_tr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetFloatField(env, scale, jni_scaleId, jni_scale);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetFloatField(env, xnorm, jni_xnormId, jni_xnorm);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slasyf (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nb, jobject kb, jfloatArray a, jint lda, jintArray ipiv, jfloatArray w, jint ldw, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jclass jni_kbClass = (*env)->GetObjectClass(env, kb);
	jfieldID jni_kbId = (*env)->GetFieldID(env, jni_kbClass, "val", "I");
	jint jni_kb = (*env)->GetIntField(env, kb, jni_kbId);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slasyf_(jni_uplo, &n, &nb, &jni_kb, jni_a, &lda, jni_ipiv, jni_w, &ldw, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->SetIntField(env, kb, jni_kbId, jni_kb);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slatbs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jstring normin, jint n, jint kd, jfloatArray ab, jint ldab, jfloatArray x, jobject scale, jfloatArray cnorm, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	char * jni_normin = (char *)(*env)->GetStringUTFChars(env, normin, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jfloat jni_scale = (*env)->GetFloatField(env, scale, jni_scaleId);
	jfloat * jni_cnorm = (*env)->GetPrimitiveArrayCritical(env, cnorm, JNI_FALSE);
	check_memory(env, jni_cnorm);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slatbs_(jni_uplo, jni_trans, jni_diag, jni_normin, &n, &kd, jni_ab, &ldab, jni_x, &jni_scale, jni_cnorm, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleaseStringUTFChars(env, normin, jni_normin);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetFloatField(env, scale, jni_scaleId, jni_scale);
	(*env)->ReleasePrimitiveArrayCritical(env, cnorm, jni_cnorm, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slatdf (JNIEnv * env, jobject calling_obj, jint ijob, jint n, jfloatArray z, jint ldz, jfloatArray rhs, jobject rdsum, jobject rdscal, jintArray ipiv, jintArray jpiv){
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_rhs = (*env)->GetPrimitiveArrayCritical(env, rhs, JNI_FALSE);
	check_memory(env, jni_rhs);
	jclass jni_rdsumClass = (*env)->GetObjectClass(env, rdsum);
	jfieldID jni_rdsumId = (*env)->GetFieldID(env, jni_rdsumClass, "val", "D");
	jfloat jni_rdsum = (*env)->GetFloatField(env, rdsum, jni_rdsumId);
	jclass jni_rdscalClass = (*env)->GetObjectClass(env, rdscal);
	jfieldID jni_rdscalId = (*env)->GetFieldID(env, jni_rdscalClass, "val", "D");
	jfloat jni_rdscal = (*env)->GetFloatField(env, rdscal, jni_rdscalId);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jint * jni_jpiv = (*env)->GetPrimitiveArrayCritical(env, jpiv, JNI_FALSE);
	check_memory(env, jni_jpiv);

	slatdf_(&ijob, &n, jni_z, &ldz, jni_rhs, &jni_rdsum, &jni_rdscal, jni_ipiv, jni_jpiv);

	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, rhs, jni_rhs, 0);
	(*env)->SetFloatField(env, rdsum, jni_rdsumId, jni_rdsum);
	(*env)->SetFloatField(env, rdscal, jni_rdscalId, jni_rdscal);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, jpiv, jni_jpiv, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slatps (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jstring normin, jint n, jfloatArray ap, jfloatArray x, jobject scale, jfloatArray cnorm, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	char * jni_normin = (char *)(*env)->GetStringUTFChars(env, normin, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jfloat jni_scale = (*env)->GetFloatField(env, scale, jni_scaleId);
	jfloat * jni_cnorm = (*env)->GetPrimitiveArrayCritical(env, cnorm, JNI_FALSE);
	check_memory(env, jni_cnorm);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slatps_(jni_uplo, jni_trans, jni_diag, jni_normin, &n, jni_ap, jni_x, &jni_scale, jni_cnorm, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleaseStringUTFChars(env, normin, jni_normin);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetFloatField(env, scale, jni_scaleId, jni_scale);
	(*env)->ReleasePrimitiveArrayCritical(env, cnorm, jni_cnorm, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slatrd (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nb, jfloatArray a, jint lda, jfloatArray e, jfloatArray tau, jfloatArray w, jint ldw){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);

	slatrd_(jni_uplo, &n, &nb, jni_a, &lda, jni_e, jni_tau, jni_w, &ldw);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slatrs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jstring normin, jint n, jfloatArray a, jint lda, jfloatArray x, jobject scale, jfloatArray cnorm, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	char * jni_normin = (char *)(*env)->GetStringUTFChars(env, normin, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jfloat jni_scale = (*env)->GetFloatField(env, scale, jni_scaleId);
	jfloat * jni_cnorm = (*env)->GetPrimitiveArrayCritical(env, cnorm, JNI_FALSE);
	check_memory(env, jni_cnorm);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slatrs_(jni_uplo, jni_trans, jni_diag, jni_normin, &n, jni_a, &lda, jni_x, &jni_scale, jni_cnorm, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleaseStringUTFChars(env, normin, jni_normin);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetFloatField(env, scale, jni_scaleId, jni_scale);
	(*env)->ReleasePrimitiveArrayCritical(env, cnorm, jni_cnorm, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slatrz (JNIEnv * env, jobject calling_obj, jint m, jint n, jint l, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);

	slatrz_(&m, &n, &l, jni_a, &lda, jni_tau, jni_work);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slatzm (JNIEnv * env, jobject calling_obj, jstring side, jint m, jint n, jfloatArray v, jint incv, jfloat tau, jfloatArray c1, jfloatArray c2, jint Ldc, jfloatArray work){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	jfloat * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jfloat * jni_c1 = (*env)->GetPrimitiveArrayCritical(env, c1, JNI_FALSE);
	check_memory(env, jni_c1);
	jfloat * jni_c2 = (*env)->GetPrimitiveArrayCritical(env, c2, JNI_FALSE);
	check_memory(env, jni_c2);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);

	slatzm_(jni_side, &m, &n, jni_v, &incv, &tau, jni_c1, jni_c2, &Ldc, jni_work);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c1, jni_c1, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c2, jni_c2, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slauu2 (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray a, jint lda, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slauu2_(jni_uplo, &n, jni_a, &lda, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_slauum (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray a, jint lda, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	slauum_(jni_uplo, &n, jni_a, &lda, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sopgtr (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray ap, jfloatArray tau, jfloatArray q, jint ldq, jfloatArray work, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sopgtr_(jni_uplo, &n, jni_ap, jni_tau, jni_q, &ldq, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sopmtr (JNIEnv * env, jobject calling_obj, jstring side, jstring uplo, jstring trans, jint m, jint n, jfloatArray ap, jfloatArray tau, jfloatArray c, jint Ldc, jfloatArray work, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sopmtr_(jni_side, jni_uplo, jni_trans, &m, &n, jni_ap, jni_tau, jni_c, &Ldc, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sorg2l (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sorg2l_(&m, &n, &k, jni_a, &lda, jni_tau, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sorg2r (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sorg2r_(&m, &n, &k, jni_a, &lda, jni_tau, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sorgbr (JNIEnv * env, jobject calling_obj, jstring vect, jint m, jint n, jint k, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jint lwork, jobject info){
	char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sorgbr_(jni_vect, &m, &n, &k, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, vect, jni_vect);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sorghr (JNIEnv * env, jobject calling_obj, jint n, jint ilo, jint ihi, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jint lwork, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sorghr_(&n, &ilo, &ihi, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sorgl2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sorgl2_(&m, &n, &k, jni_a, &lda, jni_tau, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sorglq (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jint lwork, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sorglq_(&m, &n, &k, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sorgql (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jint lwork, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sorgql_(&m, &n, &k, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sorgqr (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jint lwork, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sorgqr_(&m, &n, &k, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sorgr2 (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sorgr2_(&m, &n, &k, jni_a, &lda, jni_tau, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sorgrq (JNIEnv * env, jobject calling_obj, jint m, jint n, jint k, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jint lwork, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sorgrq_(&m, &n, &k, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sorgtr (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray a, jint lda, jfloatArray tau, jfloatArray work, jint lwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sorgtr_(jni_uplo, &n, jni_a, &lda, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sorm2l (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jfloatArray a, jint lda, jfloatArray tau, jfloatArray c, jint Ldc, jfloatArray work, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sorm2l_(jni_side, jni_trans, &m, &n, &k, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sorm2r (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jfloatArray a, jint lda, jfloatArray tau, jfloatArray c, jint Ldc, jfloatArray work, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sorm2r_(jni_side, jni_trans, &m, &n, &k, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sormbr (JNIEnv * env, jobject calling_obj, jstring vect, jstring side, jstring trans, jint m, jint n, jint k, jfloatArray a, jint lda, jfloatArray tau, jfloatArray c, jint Ldc, jfloatArray work, jint lwork, jobject info){
	char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sormbr_(jni_vect, jni_side, jni_trans, &m, &n, &k, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, vect, jni_vect);
	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sormhr (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint ilo, jint ihi, jfloatArray a, jint lda, jfloatArray tau, jfloatArray c, jint Ldc, jfloatArray work, jint lwork, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sormhr_(jni_side, jni_trans, &m, &n, &ilo, &ihi, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sorml2 (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jfloatArray a, jint lda, jfloatArray tau, jfloatArray c, jint Ldc, jfloatArray work, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sorml2_(jni_side, jni_trans, &m, &n, &k, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sormlq (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jfloatArray a, jint lda, jfloatArray tau, jfloatArray c, jint Ldc, jfloatArray work, jint lwork, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sormlq_(jni_side, jni_trans, &m, &n, &k, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sormql (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jfloatArray a, jint lda, jfloatArray tau, jfloatArray c, jint Ldc, jfloatArray work, jint lwork, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sormql_(jni_side, jni_trans, &m, &n, &k, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sormqr (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jfloatArray a, jint lda, jfloatArray tau, jfloatArray c, jint Ldc, jfloatArray work, jint lwork, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sormqr_(jni_side, jni_trans, &m, &n, &k, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sormr2 (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jfloatArray a, jint lda, jfloatArray tau, jfloatArray c, jint Ldc, jfloatArray work, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sormr2_(jni_side, jni_trans, &m, &n, &k, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sormr3 (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jint l, jfloatArray a, jint lda, jfloatArray tau, jfloatArray c, jint Ldc, jfloatArray work, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sormr3_(jni_side, jni_trans, &m, &n, &k, &l, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sormrq (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jfloatArray a, jint lda, jfloatArray tau, jfloatArray c, jint Ldc, jfloatArray work, jint lwork, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sormrq_(jni_side, jni_trans, &m, &n, &k, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sormrz (JNIEnv * env, jobject calling_obj, jstring side, jstring trans, jint m, jint n, jint k, jint l, jfloatArray a, jint lda, jfloatArray tau, jfloatArray c, jint Ldc, jfloatArray work, jint lwork, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sormrz_(jni_side, jni_trans, &m, &n, &k, &l, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sormtr (JNIEnv * env, jobject calling_obj, jstring side, jstring uplo, jstring trans, jint m, jint n, jfloatArray a, jint lda, jfloatArray tau, jfloatArray c, jint Ldc, jfloatArray work, jint lwork, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sormtr_(jni_side, jni_uplo, jni_trans, &m, &n, jni_a, &lda, jni_tau, jni_c, &Ldc, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spbcon (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jfloatArray ab, jint ldab, jfloat anorm, jobject rcond, jfloatArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spbcon_(jni_uplo, &n, &kd, jni_ab, &ldab, &anorm, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spbequ (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jfloatArray ab, jint ldab, jfloatArray s, jobject scond, jobject amax, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jclass jni_scondClass = (*env)->GetObjectClass(env, scond);
	jfieldID jni_scondId = (*env)->GetFieldID(env, jni_scondClass, "val", "D");
	jfloat jni_scond = (*env)->GetFloatField(env, scond, jni_scondId);
	jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
	jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "D");
	jfloat jni_amax = (*env)->GetFloatField(env, amax, jni_amaxId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spbequ_(jni_uplo, &n, &kd, jni_ab, &ldab, jni_s, &jni_scond, &jni_amax, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->SetFloatField(env, scond, jni_scondId, jni_scond);
	(*env)->SetFloatField(env, amax, jni_amaxId, jni_amax);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spbrfs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jint nrhs, jfloatArray ab, jint ldab, jfloatArray afb, jint ldafb, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_afb = (*env)->GetPrimitiveArrayCritical(env, afb, JNI_FALSE);
	check_memory(env, jni_afb);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spbrfs_(jni_uplo, &n, &kd, &nrhs, jni_ab, &ldab, jni_afb, &ldafb, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, afb, jni_afb, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spbstf (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jfloatArray ab, jint ldab, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spbstf_(jni_uplo, &n, &kd, jni_ab, &ldab, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spbsv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jint nrhs, jfloatArray ab, jint ldab, jfloatArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spbsv_(jni_uplo, &n, &kd, &nrhs, jni_ab, &ldab, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spbsvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring uplo, jint n, jint kd, jint nrhs, jfloatArray ab, jint ldab, jfloatArray afb, jint ldafb, jobject equed, jfloatArray s, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jobject rcond, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jobject info){
	char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_afb = (*env)->GetPrimitiveArrayCritical(env, afb, JNI_FALSE);
	check_memory(env, jni_afb);
	jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
	jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
	jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
	char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spbsvx_(jni_fact, jni_uplo, &n, &kd, &nrhs, jni_ab, &ldab, jni_afb, &ldafb, jni_equed, jni_s, jni_b, &ldb, jni_x, &ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, fact, jni_fact);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, afb, jni_afb, 0);
	jstring jni_equedStringNew = (*env)->NewStringUTF(env, jni_equed);
	(*env)->SetObjectField(env, equed, jni_equedId, jni_equedStringNew);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spbtf2 (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jfloatArray ab, jint ldab, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spbtf2_(jni_uplo, &n, &kd, jni_ab, &ldab, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spbtrf (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jfloatArray ab, jint ldab, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spbtrf_(jni_uplo, &n, &kd, jni_ab, &ldab, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spbtrs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint kd, jint nrhs, jfloatArray ab, jint ldab, jfloatArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spbtrs_(jni_uplo, &n, &kd, &nrhs, jni_ab, &ldab, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spocon (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray a, jint lda, jfloat anorm, jobject rcond, jfloatArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spocon_(jni_uplo, &n, jni_a, &lda, &anorm, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spoequ (JNIEnv * env, jobject calling_obj, jint n, jfloatArray a, jint lda, jfloatArray s, jobject scond, jobject amax, jobject info){
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jclass jni_scondClass = (*env)->GetObjectClass(env, scond);
	jfieldID jni_scondId = (*env)->GetFieldID(env, jni_scondClass, "val", "D");
	jfloat jni_scond = (*env)->GetFloatField(env, scond, jni_scondId);
	jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
	jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "D");
	jfloat jni_amax = (*env)->GetFloatField(env, amax, jni_amaxId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spoequ_(&n, jni_a, &lda, jni_s, &jni_scond, &jni_amax, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->SetFloatField(env, scond, jni_scondId, jni_scond);
	(*env)->SetFloatField(env, amax, jni_amaxId, jni_amax);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sporfs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jfloatArray a, jint lda, jfloatArray af, jint ldaf, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
	check_memory(env, jni_af);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sporfs_(jni_uplo, &n, &nrhs, jni_a, &lda, jni_af, &ldaf, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sposv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jfloatArray a, jint lda, jfloatArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sposv_(jni_uplo, &n, &nrhs, jni_a, &lda, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sposvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring uplo, jint n, jint nrhs, jfloatArray a, jint lda, jfloatArray af, jint ldaf, jobject equed, jfloatArray s, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jobject rcond, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jobject info){
	char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
	check_memory(env, jni_af);
	jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
	jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
	jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
	char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sposvx_(jni_fact, jni_uplo, &n, &nrhs, jni_a, &lda, jni_af, &ldaf, jni_equed, jni_s, jni_b, &ldb, jni_x, &ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, fact, jni_fact);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
	jstring jni_equedStringNew = (*env)->NewStringUTF(env, jni_equed);
	(*env)->SetObjectField(env, equed, jni_equedId, jni_equedStringNew);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spotf2 (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray a, jint lda, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spotf2_(jni_uplo, &n, jni_a, &lda, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spotrf (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray a, jint lda, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spotrf_(jni_uplo, &n, jni_a, &lda, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spotri (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray a, jint lda, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spotri_(jni_uplo, &n, jni_a, &lda, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spotrs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jfloatArray a, jint lda, jfloatArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spotrs_(jni_uplo, &n, &nrhs, jni_a, &lda, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sppcon (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray ap, jfloat anorm, jobject rcond, jfloatArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sppcon_(jni_uplo, &n, jni_ap, &anorm, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sppequ (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray ap, jfloatArray s, jobject scond, jobject amax, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jclass jni_scondClass = (*env)->GetObjectClass(env, scond);
	jfieldID jni_scondId = (*env)->GetFieldID(env, jni_scondClass, "val", "D");
	jfloat jni_scond = (*env)->GetFloatField(env, scond, jni_scondId);
	jclass jni_amaxClass = (*env)->GetObjectClass(env, amax);
	jfieldID jni_amaxId = (*env)->GetFieldID(env, jni_amaxClass, "val", "D");
	jfloat jni_amax = (*env)->GetFloatField(env, amax, jni_amaxId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sppequ_(jni_uplo, &n, jni_ap, jni_s, &jni_scond, &jni_amax, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->SetFloatField(env, scond, jni_scondId, jni_scond);
	(*env)->SetFloatField(env, amax, jni_amaxId, jni_amax);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spprfs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jfloatArray ap, jfloatArray afp, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jfloat * jni_afp = (*env)->GetPrimitiveArrayCritical(env, afp, JNI_FALSE);
	check_memory(env, jni_afp);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spprfs_(jni_uplo, &n, &nrhs, jni_ap, jni_afp, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, afp, jni_afp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sppsv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jfloatArray ap, jfloatArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sppsv_(jni_uplo, &n, &nrhs, jni_ap, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sppsvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring uplo, jint n, jint nrhs, jfloatArray ap, jfloatArray afp, jobject equed, jfloatArray s, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jobject rcond, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jobject info){
	char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jfloat * jni_afp = (*env)->GetPrimitiveArrayCritical(env, afp, JNI_FALSE);
	check_memory(env, jni_afp);
	jclass jni_equedClass = (*env)->GetObjectClass(env, equed);
	jfieldID jni_equedId = (*env)->GetFieldID(env, jni_equedClass, "val", "Ljava/lang/String;");
	jstring jni_equedString = (jstring)((*env)->GetObjectField(env, equed, jni_equedId));
	char * jni_equed = (char *)(*env)->GetStringUTFChars(env, jni_equedString, JNI_FALSE);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sppsvx_(jni_fact, jni_uplo, &n, &nrhs, jni_ap, jni_afp, jni_equed, jni_s, jni_b, &ldb, jni_x, &ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, fact, jni_fact);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, afp, jni_afp, 0);
	jstring jni_equedStringNew = (*env)->NewStringUTF(env, jni_equed);
	(*env)->SetObjectField(env, equed, jni_equedId, jni_equedStringNew);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spptrf (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray ap, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spptrf_(jni_uplo, &n, jni_ap, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spptri (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray ap, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spptri_(jni_uplo, &n, jni_ap, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spptrs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jfloatArray ap, jfloatArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spptrs_(jni_uplo, &n, &nrhs, jni_ap, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sptcon (JNIEnv * env, jobject calling_obj, jint n, jfloatArray d, jfloatArray e, jfloat anorm, jobject rcond, jfloatArray work, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sptcon_(&n, jni_d, jni_e, &anorm, &jni_rcond, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spteqr (JNIEnv * env, jobject calling_obj, jstring compz, jint n, jfloatArray d, jfloatArray e, jfloatArray z, jint ldz, jfloatArray work, jobject info){
	char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spteqr_(jni_compz, &n, jni_d, jni_e, jni_z, &ldz, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, compz, jni_compz);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sptrfs (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jfloatArray d, jfloatArray e, jfloatArray df, jfloatArray ef, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jfloatArray ferr, jfloatArray berr, jfloatArray work, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_df = (*env)->GetPrimitiveArrayCritical(env, df, JNI_FALSE);
	check_memory(env, jni_df);
	jfloat * jni_ef = (*env)->GetPrimitiveArrayCritical(env, ef, JNI_FALSE);
	check_memory(env, jni_ef);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sptrfs_(&n, &nrhs, jni_d, jni_e, jni_df, jni_ef, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, df, jni_df, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ef, jni_ef, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sptsv (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jfloatArray d, jfloatArray e, jfloatArray b, jint ldb, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sptsv_(&n, &nrhs, jni_d, jni_e, jni_b, &ldb, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sptsvx (JNIEnv * env, jobject calling_obj, jstring fact, jint n, jint nrhs, jfloatArray d, jfloatArray e, jfloatArray df, jfloatArray ef, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jobject rcond, jfloatArray ferr, jfloatArray berr, jfloatArray work, jobject info){
	char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_df = (*env)->GetPrimitiveArrayCritical(env, df, JNI_FALSE);
	check_memory(env, jni_df);
	jfloat * jni_ef = (*env)->GetPrimitiveArrayCritical(env, ef, JNI_FALSE);
	check_memory(env, jni_ef);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sptsvx_(jni_fact, &n, &nrhs, jni_d, jni_e, jni_df, jni_ef, jni_b, &ldb, jni_x, &ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, fact, jni_fact);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, df, jni_df, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ef, jni_ef, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spttrf (JNIEnv * env, jobject calling_obj, jint n, jfloatArray d, jfloatArray e, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spttrf_(&n, jni_d, jni_e, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_spttrs (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jfloatArray d, jfloatArray e, jfloatArray b, jint ldb, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	spttrs_(&n, &nrhs, jni_d, jni_e, jni_b, &ldb, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sptts2 (JNIEnv * env, jobject calling_obj, jint n, jint nrhs, jfloatArray d, jfloatArray e, jfloatArray b, jint ldb){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);

	sptts2_(&n, &nrhs, jni_d, jni_e, jni_b, &ldb);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_srscl (JNIEnv * env, jobject calling_obj, jint n, jfloat sa, jfloatArray sx, jint incx){
	jfloat * jni_sx = (*env)->GetPrimitiveArrayCritical(env, sx, JNI_FALSE);
	check_memory(env, jni_sx);

	srscl_(&n, &sa, jni_sx, &incx);

	(*env)->ReleasePrimitiveArrayCritical(env, sx, jni_sx, 0);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssbev (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jint kd, jfloatArray ab, jint ldab, jfloatArray w, jfloatArray z, jint ldz, jfloatArray work, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssbev_(jni_jobz, jni_uplo, &n, &kd, jni_ab, &ldab, jni_w, jni_z, &ldz, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssbevd (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jint kd, jfloatArray ab, jint ldab, jfloatArray w, jfloatArray z, jint ldz, jfloatArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssbevd_(jni_jobz, jni_uplo, &n, &kd, jni_ab, &ldab, jni_w, jni_z, &ldz, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssbevx (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jstring uplo, jint n, jint kd, jfloatArray ab, jint ldab, jfloatArray q, jint ldq, jfloat vl, jfloat vu, jint il, jint iu, jfloat abstol, jobject m, jfloatArray w, jfloatArray z, jint ldz, jfloatArray work, jintArray iwork, jintArray ifail, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jint * jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
	check_memory(env, jni_ifail);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssbevx_(jni_jobz, jni_range, jni_uplo, &n, &kd, jni_ab, &ldab, jni_q, &ldq, &vl, &vu, &il, &iu, &abstol, &jni_m, jni_w, jni_z, &ldz, jni_work, jni_iwork, jni_ifail, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssbgst (JNIEnv * env, jobject calling_obj, jstring vect, jstring uplo, jint n, jint ka, jint kb, jfloatArray ab, jint ldab, jfloatArray bb, jint ldbb, jfloatArray x, jint ldx, jfloatArray work, jobject info){
	char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_bb = (*env)->GetPrimitiveArrayCritical(env, bb, JNI_FALSE);
	check_memory(env, jni_bb);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssbgst_(jni_vect, jni_uplo, &n, &ka, &kb, jni_ab, &ldab, jni_bb, &ldbb, jni_x, &ldx, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, vect, jni_vect);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, bb, jni_bb, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssbgv (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jint ka, jint kb, jfloatArray ab, jint ldab, jfloatArray bb, jint ldbb, jfloatArray w, jfloatArray z, jint ldz, jfloatArray work, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_bb = (*env)->GetPrimitiveArrayCritical(env, bb, JNI_FALSE);
	check_memory(env, jni_bb);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssbgv_(jni_jobz, jni_uplo, &n, &ka, &kb, jni_ab, &ldab, jni_bb, &ldbb, jni_w, jni_z, &ldz, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, bb, jni_bb, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssbgvd (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jint ka, jint kb, jfloatArray ab, jint ldab, jfloatArray bb, jint ldbb, jfloatArray w, jfloatArray z, jint ldz, jfloatArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_bb = (*env)->GetPrimitiveArrayCritical(env, bb, JNI_FALSE);
	check_memory(env, jni_bb);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssbgvd_(jni_jobz, jni_uplo, &n, &ka, &kb, jni_ab, &ldab, jni_bb, &ldbb, jni_w, jni_z, &ldz, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, bb, jni_bb, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssbgvx (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jstring uplo, jint n, jint ka, jint kb, jfloatArray ab, jint ldab, jfloatArray bb, jint ldbb, jfloatArray q, jint ldq, jfloat vl, jfloat vu, jint il, jint iu, jfloat abstol, jobject m, jfloatArray w, jfloatArray z, jint ldz, jfloatArray work, jintArray iwork, jintArray ifail, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_bb = (*env)->GetPrimitiveArrayCritical(env, bb, JNI_FALSE);
	check_memory(env, jni_bb);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jint * jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
	check_memory(env, jni_ifail);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssbgvx_(jni_jobz, jni_range, jni_uplo, &n, &ka, &kb, jni_ab, &ldab, jni_bb, &ldbb, jni_q, &ldq, &vl, &vu, &il, &iu, &abstol, &jni_m, jni_w, jni_z, &ldz, jni_work, jni_iwork, jni_ifail, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, bb, jni_bb, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssbtrd (JNIEnv * env, jobject calling_obj, jstring vect, jstring uplo, jint n, jint kd, jfloatArray ab, jint ldab, jfloatArray d, jfloatArray e, jfloatArray q, jint ldq, jfloatArray work, jobject info){
	char * jni_vect = (char *)(*env)->GetStringUTFChars(env, vect, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssbtrd_(jni_vect, jni_uplo, &n, &kd, jni_ab, &ldab, jni_d, jni_e, jni_q, &ldq, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, vect, jni_vect);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sspcon (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray ap, jintArray ipiv, jfloat anorm, jobject rcond, jfloatArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sspcon_(jni_uplo, &n, jni_ap, jni_ipiv, &anorm, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sspev (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jfloatArray ap, jfloatArray w, jfloatArray z, jint ldz, jfloatArray work, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sspev_(jni_jobz, jni_uplo, &n, jni_ap, jni_w, jni_z, &ldz, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sspevd (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jfloatArray ap, jfloatArray w, jfloatArray z, jint ldz, jfloatArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sspevd_(jni_jobz, jni_uplo, &n, jni_ap, jni_w, jni_z, &ldz, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sspevx (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jstring uplo, jint n, jfloatArray ap, jfloat vl, jfloat vu, jint il, jint iu, jfloat abstol, jobject m, jfloatArray w, jfloatArray z, jint ldz, jfloatArray work, jintArray iwork, jintArray ifail, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jint * jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
	check_memory(env, jni_ifail);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sspevx_(jni_jobz, jni_range, jni_uplo, &n, jni_ap, &vl, &vu, &il, &iu, &abstol, &jni_m, jni_w, jni_z, &ldz, jni_work, jni_iwork, jni_ifail, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sspgst (JNIEnv * env, jobject calling_obj, jint itype, jstring uplo, jint n, jfloatArray ap, jfloatArray bp, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jfloat * jni_bp = (*env)->GetPrimitiveArrayCritical(env, bp, JNI_FALSE);
	check_memory(env, jni_bp);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sspgst_(&itype, jni_uplo, &n, jni_ap, jni_bp, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, bp, jni_bp, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sspgv (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring uplo, jint n, jfloatArray ap, jfloatArray bp, jfloatArray w, jfloatArray z, jint ldz, jfloatArray work, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jfloat * jni_bp = (*env)->GetPrimitiveArrayCritical(env, bp, JNI_FALSE);
	check_memory(env, jni_bp);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sspgv_(&itype, jni_jobz, jni_uplo, &n, jni_ap, jni_bp, jni_w, jni_z, &ldz, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, bp, jni_bp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sspgvd (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring uplo, jint n, jfloatArray ap, jfloatArray bp, jfloatArray w, jfloatArray z, jint ldz, jfloatArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jfloat * jni_bp = (*env)->GetPrimitiveArrayCritical(env, bp, JNI_FALSE);
	check_memory(env, jni_bp);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sspgvd_(&itype, jni_jobz, jni_uplo, &n, jni_ap, jni_bp, jni_w, jni_z, &ldz, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, bp, jni_bp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sspgvx (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring range, jstring uplo, jint n, jfloatArray ap, jfloatArray bp, jfloat vl, jfloat vu, jint il, jint iu, jfloat abstol, jobject m, jfloatArray w, jfloatArray z, jint ldz, jfloatArray work, jintArray iwork, jintArray ifail, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jfloat * jni_bp = (*env)->GetPrimitiveArrayCritical(env, bp, JNI_FALSE);
	check_memory(env, jni_bp);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jint * jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
	check_memory(env, jni_ifail);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sspgvx_(&itype, jni_jobz, jni_range, jni_uplo, &n, jni_ap, jni_bp, &vl, &vu, &il, &iu, &abstol, &jni_m, jni_w, jni_z, &ldz, jni_work, jni_iwork, jni_ifail, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, bp, jni_bp, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssprfs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jfloatArray ap, jfloatArray afp, jintArray ipiv, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jfloat * jni_afp = (*env)->GetPrimitiveArrayCritical(env, afp, JNI_FALSE);
	check_memory(env, jni_afp);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssprfs_(jni_uplo, &n, &nrhs, jni_ap, jni_afp, jni_ipiv, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, afp, jni_afp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sspsv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jfloatArray ap, jintArray ipiv, jfloatArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sspsv_(jni_uplo, &n, &nrhs, jni_ap, jni_ipiv, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sspsvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring uplo, jint n, jint nrhs, jfloatArray ap, jfloatArray afp, jintArray ipiv, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jobject rcond, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jobject info){
	char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jfloat * jni_afp = (*env)->GetPrimitiveArrayCritical(env, afp, JNI_FALSE);
	check_memory(env, jni_afp);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sspsvx_(jni_fact, jni_uplo, &n, &nrhs, jni_ap, jni_afp, jni_ipiv, jni_b, &ldb, jni_x, &ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, fact, jni_fact);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, afp, jni_afp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssptrd (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray ap, jfloatArray d, jfloatArray e, jfloatArray tau, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssptrd_(jni_uplo, &n, jni_ap, jni_d, jni_e, jni_tau, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssptrf (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray ap, jintArray ipiv, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssptrf_(jni_uplo, &n, jni_ap, jni_ipiv, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssptri (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray ap, jintArray ipiv, jfloatArray work, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssptri_(jni_uplo, &n, jni_ap, jni_ipiv, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssptrs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jfloatArray ap, jintArray ipiv, jfloatArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssptrs_(jni_uplo, &n, &nrhs, jni_ap, jni_ipiv, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sstebz (JNIEnv * env, jobject calling_obj, jstring range, jstring order, jint n, jfloat vl, jfloat vu, jint il, jint iu, jfloat abstol, jfloatArray d, jfloatArray e, jobject m, jobject nsplit, jfloatArray w, jintArray iblock, jintArray isplit, jfloatArray work, jintArray iwork, jobject info){
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	char * jni_order = (char *)(*env)->GetStringUTFChars(env, order, JNI_FALSE);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jclass jni_nsplitClass = (*env)->GetObjectClass(env, nsplit);
	jfieldID jni_nsplitId = (*env)->GetFieldID(env, jni_nsplitClass, "val", "I");
	jint jni_nsplit = (*env)->GetIntField(env, nsplit, jni_nsplitId);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jint * jni_iblock = (*env)->GetPrimitiveArrayCritical(env, iblock, JNI_FALSE);
	check_memory(env, jni_iblock);
	jint * jni_isplit = (*env)->GetPrimitiveArrayCritical(env, isplit, JNI_FALSE);
	check_memory(env, jni_isplit);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sstebz_(jni_range, jni_order, &n, &vl, &vu, &il, &iu, &abstol, jni_d, jni_e, &jni_m, &jni_nsplit, jni_w, jni_iblock, jni_isplit, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleaseStringUTFChars(env, order, jni_order);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->SetIntField(env, nsplit, jni_nsplitId, jni_nsplit);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iblock, jni_iblock, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, isplit, jni_isplit, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sstedc (JNIEnv * env, jobject calling_obj, jstring compz, jint n, jfloatArray d, jfloatArray e, jfloatArray z, jint ldz, jfloatArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sstedc_(jni_compz, &n, jni_d, jni_e, jni_z, &ldz, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, compz, jni_compz);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sstegr (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jint n, jfloatArray d, jfloatArray e, jfloat vl, jfloat vu, jint il, jint iu, jfloat abstol, jobject m, jfloatArray w, jfloatArray z, jint ldz, jintArray isuppz, jfloatArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jint * jni_isuppz = (*env)->GetPrimitiveArrayCritical(env, isuppz, JNI_FALSE);
	check_memory(env, jni_isuppz);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sstegr_(jni_jobz, jni_range, &n, jni_d, jni_e, &vl, &vu, &il, &iu, &abstol, &jni_m, jni_w, jni_z, &ldz, jni_isuppz, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, isuppz, jni_isuppz, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sstein (JNIEnv * env, jobject calling_obj, jint n, jfloatArray d, jfloatArray e, jint m, jfloatArray w, jintArray iblock, jintArray isplit, jfloatArray z, jint ldz, jfloatArray work, jintArray iwork, jintArray ifail, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jint * jni_iblock = (*env)->GetPrimitiveArrayCritical(env, iblock, JNI_FALSE);
	check_memory(env, jni_iblock);
	jint * jni_isplit = (*env)->GetPrimitiveArrayCritical(env, isplit, JNI_FALSE);
	check_memory(env, jni_isplit);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jint * jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
	check_memory(env, jni_ifail);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sstein_(&n, jni_d, jni_e, &m, jni_w, jni_iblock, jni_isplit, jni_z, &ldz, jni_work, jni_iwork, jni_ifail, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iblock, jni_iblock, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, isplit, jni_isplit, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssteqr (JNIEnv * env, jobject calling_obj, jstring compz, jint n, jfloatArray d, jfloatArray e, jfloatArray z, jint ldz, jfloatArray work, jobject info){
	char * jni_compz = (char *)(*env)->GetStringUTFChars(env, compz, JNI_FALSE);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssteqr_(jni_compz, &n, jni_d, jni_e, jni_z, &ldz, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, compz, jni_compz);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssterf (JNIEnv * env, jobject calling_obj, jint n, jfloatArray d, jfloatArray e, jobject info){
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssterf_(&n, jni_d, jni_e, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sstev (JNIEnv * env, jobject calling_obj, jstring jobz, jint n, jfloatArray d, jfloatArray e, jfloatArray z, jint ldz, jfloatArray work, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sstev_(jni_jobz, &n, jni_d, jni_e, jni_z, &ldz, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sstevd (JNIEnv * env, jobject calling_obj, jstring jobz, jint n, jfloatArray d, jfloatArray e, jfloatArray z, jint ldz, jfloatArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sstevd_(jni_jobz, &n, jni_d, jni_e, jni_z, &ldz, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sstevr (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jint n, jfloatArray d, jfloatArray e, jfloat vl, jfloat vu, jint il, jint iu, jfloat abstol, jobject m, jfloatArray w, jfloatArray z, jint ldz, jintArray isuppz, jfloatArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jint * jni_isuppz = (*env)->GetPrimitiveArrayCritical(env, isuppz, JNI_FALSE);
	check_memory(env, jni_isuppz);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sstevr_(jni_jobz, jni_range, &n, jni_d, jni_e, &vl, &vu, &il, &iu, &abstol, &jni_m, jni_w, jni_z, &ldz, jni_isuppz, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, isuppz, jni_isuppz, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_sstevx (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jint n, jfloatArray d, jfloatArray e, jfloat vl, jfloat vu, jint il, jint iu, jfloat abstol, jobject m, jfloatArray w, jfloatArray z, jint ldz, jfloatArray work, jintArray iwork, jintArray ifail, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jint * jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
	check_memory(env, jni_ifail);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	sstevx_(jni_jobz, jni_range, &n, jni_d, jni_e, &vl, &vu, &il, &iu, &abstol, &jni_m, jni_w, jni_z, &ldz, jni_work, jni_iwork, jni_ifail, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssycon (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray a, jint lda, jintArray ipiv, jfloat anorm, jobject rcond, jfloatArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssycon_(jni_uplo, &n, jni_a, &lda, jni_ipiv, &anorm, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssyev (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jfloatArray a, jint lda, jfloatArray w, jfloatArray work, jint lwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssyev_(jni_jobz, jni_uplo, &n, jni_a, &lda, jni_w, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssyevd (JNIEnv * env, jobject calling_obj, jstring jobz, jstring uplo, jint n, jfloatArray a, jint lda, jfloatArray w, jfloatArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssyevd_(jni_jobz, jni_uplo, &n, jni_a, &lda, jni_w, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssyevr (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jstring uplo, jint n, jfloatArray a, jint lda, jfloat vl, jfloat vu, jint il, jint iu, jfloat abstol, jobject m, jfloatArray w, jfloatArray z, jint ldz, jintArray isuppz, jfloatArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jint * jni_isuppz = (*env)->GetPrimitiveArrayCritical(env, isuppz, JNI_FALSE);
	check_memory(env, jni_isuppz);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssyevr_(jni_jobz, jni_range, jni_uplo, &n, jni_a, &lda, &vl, &vu, &il, &iu, &abstol, &jni_m, jni_w, jni_z, &ldz, jni_isuppz, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, isuppz, jni_isuppz, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssyevx (JNIEnv * env, jobject calling_obj, jstring jobz, jstring range, jstring uplo, jint n, jfloatArray a, jint lda, jfloat vl, jfloat vu, jint il, jint iu, jfloat abstol, jobject m, jfloatArray w, jfloatArray z, jint ldz, jfloatArray work, jint lwork, jintArray iwork, jintArray ifail, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jint * jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
	check_memory(env, jni_ifail);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssyevx_(jni_jobz, jni_range, jni_uplo, &n, jni_a, &lda, &vl, &vu, &il, &iu, &abstol, &jni_m, jni_w, jni_z, &ldz, jni_work, &lwork, jni_iwork, jni_ifail, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssygs2 (JNIEnv * env, jobject calling_obj, jint itype, jstring uplo, jint n, jfloatArray a, jint lda, jfloatArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssygs2_(&itype, jni_uplo, &n, jni_a, &lda, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssygst (JNIEnv * env, jobject calling_obj, jint itype, jstring uplo, jint n, jfloatArray a, jint lda, jfloatArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssygst_(&itype, jni_uplo, &n, jni_a, &lda, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssygv (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring uplo, jint n, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray w, jfloatArray work, jint lwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssygv_(&itype, jni_jobz, jni_uplo, &n, jni_a, &lda, jni_b, &ldb, jni_w, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssygvd (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring uplo, jint n, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray w, jfloatArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssygvd_(&itype, jni_jobz, jni_uplo, &n, jni_a, &lda, jni_b, &ldb, jni_w, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssygvx (JNIEnv * env, jobject calling_obj, jint itype, jstring jobz, jstring range, jstring uplo, jint n, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloat vl, jfloat vu, jint il, jint iu, jfloat abstol, jobject m, jfloatArray w, jfloatArray z, jint ldz, jfloatArray work, jint lwork, jintArray iwork, jintArray ifail, jobject info){
	char * jni_jobz = (char *)(*env)->GetStringUTFChars(env, jobz, JNI_FALSE);
	char * jni_range = (char *)(*env)->GetStringUTFChars(env, range, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jfloat * jni_w = (*env)->GetPrimitiveArrayCritical(env, w, JNI_FALSE);
	check_memory(env, jni_w);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jint * jni_ifail = (*env)->GetPrimitiveArrayCritical(env, ifail, JNI_FALSE);
	check_memory(env, jni_ifail);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssygvx_(&itype, jni_jobz, jni_range, jni_uplo, &n, jni_a, &lda, jni_b, &ldb, &vl, &vu, &il, &iu, &abstol, &jni_m, jni_w, jni_z, &ldz, jni_work, &lwork, jni_iwork, jni_ifail, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobz, jni_jobz);
	(*env)->ReleaseStringUTFChars(env, range, jni_range);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, w, jni_w, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ifail, jni_ifail, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssyrfs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jfloatArray a, jint lda, jfloatArray af, jint ldaf, jintArray ipiv, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
	check_memory(env, jni_af);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssyrfs_(jni_uplo, &n, &nrhs, jni_a, &lda, jni_af, &ldaf, jni_ipiv, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssysv (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jfloatArray a, jint lda, jintArray ipiv, jfloatArray b, jint ldb, jfloatArray work, jint lwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssysv_(jni_uplo, &n, &nrhs, jni_a, &lda, jni_ipiv, jni_b, &ldb, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssysvx (JNIEnv * env, jobject calling_obj, jstring fact, jstring uplo, jint n, jint nrhs, jfloatArray a, jint lda, jfloatArray af, jint ldaf, jintArray ipiv, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jobject rcond, jfloatArray ferr, jfloatArray berr, jfloatArray work, jint lwork, jintArray iwork, jobject info){
	char * jni_fact = (char *)(*env)->GetStringUTFChars(env, fact, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_af = (*env)->GetPrimitiveArrayCritical(env, af, JNI_FALSE);
	check_memory(env, jni_af);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssysvx_(jni_fact, jni_uplo, &n, &nrhs, jni_a, &lda, jni_af, &ldaf, jni_ipiv, jni_b, &ldb, jni_x, &ldx, &jni_rcond, jni_ferr, jni_berr, jni_work, &lwork, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, fact, jni_fact);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, af, jni_af, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssytd2 (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray a, jint lda, jfloatArray d, jfloatArray e, jfloatArray tau, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssytd2_(jni_uplo, &n, jni_a, &lda, jni_d, jni_e, jni_tau, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssytf2 (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray a, jint lda, jintArray ipiv, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssytf2_(jni_uplo, &n, jni_a, &lda, jni_ipiv, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssytrd (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray a, jint lda, jfloatArray d, jfloatArray e, jfloatArray tau, jfloatArray work, jint lwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_tau = (*env)->GetPrimitiveArrayCritical(env, tau, JNI_FALSE);
	check_memory(env, jni_tau);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssytrd_(jni_uplo, &n, jni_a, &lda, jni_d, jni_e, jni_tau, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, tau, jni_tau, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssytrf (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray a, jint lda, jintArray ipiv, jfloatArray work, jint lwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssytrf_(jni_uplo, &n, jni_a, &lda, jni_ipiv, jni_work, &lwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssytri (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jfloatArray a, jint lda, jintArray ipiv, jfloatArray work, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssytri_(jni_uplo, &n, jni_a, &lda, jni_ipiv, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_ssytrs (JNIEnv * env, jobject calling_obj, jstring uplo, jint n, jint nrhs, jfloatArray a, jint lda, jintArray ipiv, jfloatArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jint * jni_ipiv = (*env)->GetPrimitiveArrayCritical(env, ipiv, JNI_FALSE);
	check_memory(env, jni_ipiv);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	ssytrs_(jni_uplo, &n, &nrhs, jni_a, &lda, jni_ipiv, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ipiv, jni_ipiv, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_stbcon (JNIEnv * env, jobject calling_obj, jstring norm, jstring uplo, jstring diag, jint n, jint kd, jfloatArray ab, jint ldab, jobject rcond, jfloatArray work, jintArray iwork, jobject info){
	char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	stbcon_(jni_norm, jni_uplo, jni_diag, &n, &kd, jni_ab, &ldab, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, norm, jni_norm);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_stbrfs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint kd, jint nrhs, jfloatArray ab, jint ldab, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	stbrfs_(jni_uplo, jni_trans, jni_diag, &n, &kd, &nrhs, jni_ab, &ldab, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_stbtrs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint kd, jint nrhs, jfloatArray ab, jint ldab, jfloatArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jfloat * jni_ab = (*env)->GetPrimitiveArrayCritical(env, ab, JNI_FALSE);
	check_memory(env, jni_ab);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	stbtrs_(jni_uplo, jni_trans, jni_diag, &n, &kd, &nrhs, jni_ab, &ldab, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, ab, jni_ab, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_stgevc (JNIEnv * env, jobject calling_obj, jstring side, jstring howmny, jbooleanArray select, jint n, jfloatArray s, jint lds, jfloatArray p, jint ldp, jfloatArray vl, jint ldvl, jfloatArray vr, jint ldvr, jint mm, jobject m, jfloatArray work, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
	jboolean * jni_selectTmp = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
	jint jni_selectSize = (*env)->GetArrayLength(env, select);
	logical jni_select[jni_selectSize];
	int jni_selecti;
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jfloat * jni_p = (*env)->GetPrimitiveArrayCritical(env, p, JNI_FALSE);
	check_memory(env, jni_p);
	jfloat * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jfloat * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_selectTmp[jni_selecti] == JNI_FALSE){
			jni_select[jni_selecti] = 0;
		} else {
			jni_select[jni_selecti] = 1;
		}
	}

	stgevc_(jni_side, jni_howmny, jni_select, &n, jni_s, &lds, jni_p, &ldp, jni_vl, &ldvl, jni_vr, &ldvr, &mm, &jni_m, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_select[jni_selecti] == 0){
			jni_selectTmp[jni_selecti] = JNI_FALSE;
		} else {
			jni_selectTmp[jni_selecti] = JNI_TRUE;
		}
	}
	(*env)->ReleasePrimitiveArrayCritical(env, select, jni_selectTmp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, p, jni_p, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_stgex2 (JNIEnv * env, jobject calling_obj, jboolean wantq, jboolean wantz, jint n, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray q, jint ldq, jfloatArray z, jint ldz, jint j1, jint n1, jint n2, jfloatArray work, jint lwork, jobject info){
	logical jni_wantq = (logical)wantq;
	logical jni_wantz = (logical)wantz;
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	stgex2_(&jni_wantq, &jni_wantz, &n, jni_a, &lda, jni_b, &ldb, jni_q, &ldq, jni_z, &ldz, &j1, &n1, &n2, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_stgexc (JNIEnv * env, jobject calling_obj, jboolean wantq, jboolean wantz, jint n, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray q, jint ldq, jfloatArray z, jint ldz, jobject ifst, jobject ilst, jfloatArray work, jint lwork, jobject info){
	logical jni_wantq = (logical)wantq;
	logical jni_wantz = (logical)wantz;
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_ifstClass = (*env)->GetObjectClass(env, ifst);
	jfieldID jni_ifstId = (*env)->GetFieldID(env, jni_ifstClass, "val", "I");
	jint jni_ifst = (*env)->GetIntField(env, ifst, jni_ifstId);
	jclass jni_ilstClass = (*env)->GetObjectClass(env, ilst);
	jfieldID jni_ilstId = (*env)->GetFieldID(env, jni_ilstClass, "val", "I");
	jint jni_ilst = (*env)->GetIntField(env, ilst, jni_ilstId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	stgexc_(&jni_wantq, &jni_wantz, &n, jni_a, &lda, jni_b, &ldb, jni_q, &ldq, jni_z, &ldz, &jni_ifst, &jni_ilst, jni_work, &lwork, &jni_info);

	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetIntField(env, ifst, jni_ifstId, jni_ifst);
	(*env)->SetIntField(env, ilst, jni_ilstId, jni_ilst);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_stgsen (JNIEnv * env, jobject calling_obj, jint ijob, jboolean wantq, jboolean wantz, jbooleanArray select, jint n, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray alphar, jfloatArray alphai, jfloatArray beta, jfloatArray q, jint ldq, jfloatArray z, jint ldz, jobject m, jobject pl, jobject pr, jfloatArray dif, jfloatArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	logical jni_wantq = (logical)wantq;
	logical jni_wantz = (logical)wantz;
	jboolean * jni_selectTmp = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
	jint jni_selectSize = (*env)->GetArrayLength(env, select);
	logical jni_select[jni_selectSize];
	int jni_selecti;
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_alphar = (*env)->GetPrimitiveArrayCritical(env, alphar, JNI_FALSE);
	check_memory(env, jni_alphar);
	jfloat * jni_alphai = (*env)->GetPrimitiveArrayCritical(env, alphai, JNI_FALSE);
	check_memory(env, jni_alphai);
	jfloat * jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
	check_memory(env, jni_beta);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jfloat * jni_z = (*env)->GetPrimitiveArrayCritical(env, z, JNI_FALSE);
	check_memory(env, jni_z);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jclass jni_plClass = (*env)->GetObjectClass(env, pl);
	jfieldID jni_plId = (*env)->GetFieldID(env, jni_plClass, "val", "D");
	jfloat jni_pl = (*env)->GetFloatField(env, pl, jni_plId);
	jclass jni_prClass = (*env)->GetObjectClass(env, pr);
	jfieldID jni_prId = (*env)->GetFieldID(env, jni_prClass, "val", "D");
	jfloat jni_pr = (*env)->GetFloatField(env, pr, jni_prId);
	jfloat * jni_dif = (*env)->GetPrimitiveArrayCritical(env, dif, JNI_FALSE);
	check_memory(env, jni_dif);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_selectTmp[jni_selecti] == JNI_FALSE){
			jni_select[jni_selecti] = 0;
		} else {
			jni_select[jni_selecti] = 1;
		}
	}

	stgsen_(&ijob, &jni_wantq, &jni_wantz, jni_select, &n, jni_a, &lda, jni_b, &ldb, jni_alphar, jni_alphai, jni_beta, jni_q, &ldq, jni_z, &ldz, &jni_m, &jni_pl, &jni_pr, jni_dif, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_select[jni_selecti] == 0){
			jni_selectTmp[jni_selecti] = JNI_FALSE;
		} else {
			jni_selectTmp[jni_selecti] = JNI_TRUE;
		}
	}
	(*env)->ReleasePrimitiveArrayCritical(env, select, jni_selectTmp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphar, jni_alphar, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alphai, jni_alphai, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, z, jni_z, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->SetFloatField(env, pl, jni_plId, jni_pl);
	(*env)->SetFloatField(env, pr, jni_prId, jni_pr);
	(*env)->ReleasePrimitiveArrayCritical(env, dif, jni_dif, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_stgsja (JNIEnv * env, jobject calling_obj, jstring jobu, jstring jobv, jstring jobq, jint m, jint p, jint n, jint k, jint l, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloat tola, jfloat tolb, jfloatArray alpha, jfloatArray beta, jfloatArray u, jint ldu, jfloatArray v, jint ldv, jfloatArray q, jint ldq, jfloatArray work, jobject ncycle, jobject info){
	char * jni_jobu = (char *)(*env)->GetStringUTFChars(env, jobu, JNI_FALSE);
	char * jni_jobv = (char *)(*env)->GetStringUTFChars(env, jobv, JNI_FALSE);
	char * jni_jobq = (char *)(*env)->GetStringUTFChars(env, jobq, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_alpha = (*env)->GetPrimitiveArrayCritical(env, alpha, JNI_FALSE);
	check_memory(env, jni_alpha);
	jfloat * jni_beta = (*env)->GetPrimitiveArrayCritical(env, beta, JNI_FALSE);
	check_memory(env, jni_beta);
	jfloat * jni_u = (*env)->GetPrimitiveArrayCritical(env, u, JNI_FALSE);
	check_memory(env, jni_u);
	jfloat * jni_v = (*env)->GetPrimitiveArrayCritical(env, v, JNI_FALSE);
	check_memory(env, jni_v);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_ncycleClass = (*env)->GetObjectClass(env, ncycle);
	jfieldID jni_ncycleId = (*env)->GetFieldID(env, jni_ncycleClass, "val", "I");
	jint jni_ncycle = (*env)->GetIntField(env, ncycle, jni_ncycleId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	stgsja_(jni_jobu, jni_jobv, jni_jobq, &m, &p, &n, &k, &l, jni_a, &lda, jni_b, &ldb, &tola, &tolb, jni_alpha, jni_beta, jni_u, &ldu, jni_v, &ldv, jni_q, &ldq, jni_work, &jni_ncycle, &jni_info);

	(*env)->ReleaseStringUTFChars(env, jobu, jni_jobu);
	(*env)->ReleaseStringUTFChars(env, jobv, jni_jobv);
	(*env)->ReleaseStringUTFChars(env, jobq, jni_jobq);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, alpha, jni_alpha, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, beta, jni_beta, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, u, jni_u, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, v, jni_v, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, ncycle, jni_ncycleId, jni_ncycle);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_stgsna (JNIEnv * env, jobject calling_obj, jstring job, jstring howmny, jbooleanArray select, jint n, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray vl, jint ldvl, jfloatArray vr, jint ldvr, jfloatArray s, jfloatArray dif, jint mm, jobject m, jfloatArray work, jint lwork, jintArray iwork, jobject info){
	char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
	char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
	jboolean * jni_selectTmp = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
	jint jni_selectSize = (*env)->GetArrayLength(env, select);
	logical jni_select[jni_selectSize];
	int jni_selecti;
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jfloat * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jfloat * jni_s = (*env)->GetPrimitiveArrayCritical(env, s, JNI_FALSE);
	check_memory(env, jni_s);
	jfloat * jni_dif = (*env)->GetPrimitiveArrayCritical(env, dif, JNI_FALSE);
	check_memory(env, jni_dif);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_selectTmp[jni_selecti] == JNI_FALSE){
			jni_select[jni_selecti] = 0;
		} else {
			jni_select[jni_selecti] = 1;
		}
	}

	stgsna_(jni_job, jni_howmny, jni_select, &n, jni_a, &lda, jni_b, &ldb, jni_vl, &ldvl, jni_vr, &ldvr, jni_s, jni_dif, &mm, &jni_m, jni_work, &lwork, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, job, jni_job);
	(*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_select[jni_selecti] == 0){
			jni_selectTmp[jni_selecti] = JNI_FALSE;
		} else {
			jni_selectTmp[jni_selecti] = JNI_TRUE;
		}
	}
	(*env)->ReleasePrimitiveArrayCritical(env, select, jni_selectTmp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, s, jni_s, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, dif, jni_dif, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_stgsy2 (JNIEnv * env, jobject calling_obj, jstring trans, jint ijob, jint m, jint n, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray c, jint Ldc, jfloatArray d, jint ldd, jfloatArray e, jint lde, jfloatArray f, jint ldf, jobject scale, jobject rdsum, jobject rdscal, jintArray iwork, jobject pq, jobject info){
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_f = (*env)->GetPrimitiveArrayCritical(env, f, JNI_FALSE);
	check_memory(env, jni_f);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jfloat jni_scale = (*env)->GetFloatField(env, scale, jni_scaleId);
	jclass jni_rdsumClass = (*env)->GetObjectClass(env, rdsum);
	jfieldID jni_rdsumId = (*env)->GetFieldID(env, jni_rdsumClass, "val", "D");
	jfloat jni_rdsum = (*env)->GetFloatField(env, rdsum, jni_rdsumId);
	jclass jni_rdscalClass = (*env)->GetObjectClass(env, rdscal);
	jfieldID jni_rdscalId = (*env)->GetFieldID(env, jni_rdscalClass, "val", "D");
	jfloat jni_rdscal = (*env)->GetFloatField(env, rdscal, jni_rdscalId);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_pqClass = (*env)->GetObjectClass(env, pq);
	jfieldID jni_pqId = (*env)->GetFieldID(env, jni_pqClass, "val", "I");
	jint jni_pq = (*env)->GetIntField(env, pq, jni_pqId);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	stgsy2_(jni_trans, &ijob, &m, &n, jni_a, &lda, jni_b, &ldb, jni_c, &Ldc, jni_d, &ldd, jni_e, &lde, jni_f, &ldf, &jni_scale, &jni_rdsum, &jni_rdscal, jni_iwork, &jni_pq, &jni_info);

	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, f, jni_f, 0);
	(*env)->SetFloatField(env, scale, jni_scaleId, jni_scale);
	(*env)->SetFloatField(env, rdsum, jni_rdsumId, jni_rdsum);
	(*env)->SetFloatField(env, rdscal, jni_rdscalId, jni_rdscal);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, pq, jni_pqId, jni_pq);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_stgsyl (JNIEnv * env, jobject calling_obj, jstring trans, jint ijob, jint m, jint n, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray c, jint Ldc, jfloatArray d, jint ldd, jfloatArray e, jint lde, jfloatArray f, jint ldf, jobject scale, jobject dif, jfloatArray work, jint lwork, jintArray iwork, jobject info){
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_c = (*env)->GetPrimitiveArrayCritical(env, c, JNI_FALSE);
	check_memory(env, jni_c);
	jfloat * jni_d = (*env)->GetPrimitiveArrayCritical(env, d, JNI_FALSE);
	check_memory(env, jni_d);
	jfloat * jni_e = (*env)->GetPrimitiveArrayCritical(env, e, JNI_FALSE);
	check_memory(env, jni_e);
	jfloat * jni_f = (*env)->GetPrimitiveArrayCritical(env, f, JNI_FALSE);
	check_memory(env, jni_f);
	jclass jni_scaleClass = (*env)->GetObjectClass(env, scale);
	jfieldID jni_scaleId = (*env)->GetFieldID(env, jni_scaleClass, "val", "D");
	jfloat jni_scale = (*env)->GetFloatField(env, scale, jni_scaleId);
	jclass jni_difClass = (*env)->GetObjectClass(env, dif);
	jfieldID jni_difId = (*env)->GetFieldID(env, jni_difClass, "val", "D");
	jfloat jni_dif = (*env)->GetFloatField(env, dif, jni_difId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	stgsyl_(jni_trans, &ijob, &m, &n, jni_a, &lda, jni_b, &ldb, jni_c, &Ldc, jni_d, &ldd, jni_e, &lde, jni_f, &ldf, &jni_scale, &jni_dif, jni_work, &lwork, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, c, jni_c, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, d, jni_d, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, e, jni_e, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, f, jni_f, 0);
	(*env)->SetFloatField(env, scale, jni_scaleId, jni_scale);
	(*env)->SetFloatField(env, dif, jni_difId, jni_dif);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_stpcon (JNIEnv * env, jobject calling_obj, jstring norm, jstring uplo, jstring diag, jint n, jfloatArray ap, jobject rcond, jfloatArray work, jintArray iwork, jobject info){
	char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	stpcon_(jni_norm, jni_uplo, jni_diag, &n, jni_ap, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, norm, jni_norm);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_stprfs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint nrhs, jfloatArray ap, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	stprfs_(jni_uplo, jni_trans, jni_diag, &n, &nrhs, jni_ap, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_stptri (JNIEnv * env, jobject calling_obj, jstring uplo, jstring diag, jint n, jfloatArray ap, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	stptri_(jni_uplo, jni_diag, &n, jni_ap, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_stptrs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint nrhs, jfloatArray ap, jfloatArray b, jint ldb, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jfloat * jni_ap = (*env)->GetPrimitiveArrayCritical(env, ap, JNI_FALSE);
	check_memory(env, jni_ap);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	stptrs_(jni_uplo, jni_trans, jni_diag, &n, &nrhs, jni_ap, jni_b, &ldb, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, ap, jni_ap, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_strcon (JNIEnv * env, jobject calling_obj, jstring norm, jstring uplo, jstring diag, jint n, jfloatArray a, jint lda, jobject rcond, jfloatArray work, jintArray iwork, jobject info){
	char * jni_norm = (char *)(*env)->GetStringUTFChars(env, norm, JNI_FALSE);
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jclass jni_rcondClass = (*env)->GetObjectClass(env, rcond);
	jfieldID jni_rcondId = (*env)->GetFieldID(env, jni_rcondClass, "val", "D");
	jfloat jni_rcond = (*env)->GetFloatField(env, rcond, jni_rcondId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	strcon_(jni_norm, jni_uplo, jni_diag, &n, jni_a, &lda, &jni_rcond, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, norm, jni_norm);
	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->SetFloatField(env, rcond, jni_rcondId, jni_rcond);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_strevc (JNIEnv * env, jobject calling_obj, jstring side, jstring howmny, jbooleanArray select, jint n, jfloatArray t, jint ldt, jfloatArray vl, jint ldvl, jfloatArray vr, jint ldvr, jint mm, jobject m, jfloatArray work, jobject info){
	char * jni_side = (char *)(*env)->GetStringUTFChars(env, side, JNI_FALSE);
	char * jni_howmny = (char *)(*env)->GetStringUTFChars(env, howmny, JNI_FALSE);
	jboolean * jni_selectTmp = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
	jint jni_selectSize = (*env)->GetArrayLength(env, select);
	logical jni_select[jni_selectSize];
	int jni_selecti;
	jfloat * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);
	jfloat * jni_vl = (*env)->GetPrimitiveArrayCritical(env, vl, JNI_FALSE);
	check_memory(env, jni_vl);
	jfloat * jni_vr = (*env)->GetPrimitiveArrayCritical(env, vr, JNI_FALSE);
	check_memory(env, jni_vr);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_selectTmp[jni_selecti] == JNI_FALSE){
			jni_select[jni_selecti] = 0;
		} else {
			jni_select[jni_selecti] = 1;
		}
	}

	strevc_(jni_side, jni_howmny, jni_select, &n, jni_t, &ldt, jni_vl, &ldvl, jni_vr, &ldvr, &mm, &jni_m, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, side, jni_side);
	(*env)->ReleaseStringUTFChars(env, howmny, jni_howmny);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_select[jni_selecti] == 0){
			jni_selectTmp[jni_selecti] = JNI_FALSE;
		} else {
			jni_selectTmp[jni_selecti] = JNI_TRUE;
		}
	}
	(*env)->ReleasePrimitiveArrayCritical(env, select, jni_selectTmp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vl, jni_vl, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, vr, jni_vr, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_strexc (JNIEnv * env, jobject calling_obj, jstring compq, jint n, jfloatArray t, jint ldt, jfloatArray q, jint ldq, jobject ifst, jobject ilst, jfloatArray work, jobject info){
	char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
	jfloat * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jclass jni_ifstClass = (*env)->GetObjectClass(env, ifst);
	jfieldID jni_ifstId = (*env)->GetFieldID(env, jni_ifstClass, "val", "I");
	jint jni_ifst = (*env)->GetIntField(env, ifst, jni_ifstId);
	jclass jni_ilstClass = (*env)->GetObjectClass(env, ilst);
	jfieldID jni_ilstId = (*env)->GetFieldID(env, jni_ilstClass, "val", "I");
	jint jni_ilst = (*env)->GetIntField(env, ilst, jni_ilstId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	strexc_(jni_compq, &n, jni_t, &ldt, jni_q, &ldq, &jni_ifst, &jni_ilst, jni_work, &jni_info);

	(*env)->ReleaseStringUTFChars(env, compq, jni_compq);
	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->SetIntField(env, ifst, jni_ifstId, jni_ifst);
	(*env)->SetIntField(env, ilst, jni_ilstId, jni_ilst);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_strrfs (JNIEnv * env, jobject calling_obj, jstring uplo, jstring trans, jstring diag, jint n, jint nrhs, jfloatArray a, jint lda, jfloatArray b, jint ldb, jfloatArray x, jint ldx, jfloatArray ferr, jfloatArray berr, jfloatArray work, jintArray iwork, jobject info){
	char * jni_uplo = (char *)(*env)->GetStringUTFChars(env, uplo, JNI_FALSE);
	char * jni_trans = (char *)(*env)->GetStringUTFChars(env, trans, JNI_FALSE);
	char * jni_diag = (char *)(*env)->GetStringUTFChars(env, diag, JNI_FALSE);
	jfloat * jni_a = (*env)->GetPrimitiveArrayCritical(env, a, JNI_FALSE);
	check_memory(env, jni_a);
	jfloat * jni_b = (*env)->GetPrimitiveArrayCritical(env, b, JNI_FALSE);
	check_memory(env, jni_b);
	jfloat * jni_x = (*env)->GetPrimitiveArrayCritical(env, x, JNI_FALSE);
	check_memory(env, jni_x);
	jfloat * jni_ferr = (*env)->GetPrimitiveArrayCritical(env, ferr, JNI_FALSE);
	check_memory(env, jni_ferr);
	jfloat * jni_berr = (*env)->GetPrimitiveArrayCritical(env, berr, JNI_FALSE);
	check_memory(env, jni_berr);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);

	strrfs_(jni_uplo, jni_trans, jni_diag, &n, &nrhs, jni_a, &lda, jni_b, &ldb, jni_x, &ldx, jni_ferr, jni_berr, jni_work, jni_iwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, uplo, jni_uplo);
	(*env)->ReleaseStringUTFChars(env, trans, jni_trans);
	(*env)->ReleaseStringUTFChars(env, diag, jni_diag);
	(*env)->ReleasePrimitiveArrayCritical(env, a, jni_a, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, b, jni_b, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, x, jni_x, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, ferr, jni_ferr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, berr, jni_berr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_work, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, iwork, jni_iwork, 0);
	(*env)->SetIntField(env, info, jni_infoId, jni_info);
}

JNIEXPORT void JNICALL Java_org_netlib_lapack_NativeLAPACK_strsen (JNIEnv * env, jobject calling_obj, jstring job, jstring compq, jbooleanArray select, jint n, jfloatArray t, jint ldt, jfloatArray q, jint ldq, jfloatArray wr, jfloatArray wi, jobject m, jobject s, jobject sep, jfloatArray work, jint lwork, jintArray iwork, jint liwork, jobject info){
	char * jni_job = (char *)(*env)->GetStringUTFChars(env, job, JNI_FALSE);
	char * jni_compq = (char *)(*env)->GetStringUTFChars(env, compq, JNI_FALSE);
	jboolean * jni_selectTmp = (*env)->GetPrimitiveArrayCritical(env, select, JNI_FALSE);
	jint jni_selectSize = (*env)->GetArrayLength(env, select);
	logical jni_select[jni_selectSize];
	int jni_selecti;
	jfloat * jni_t = (*env)->GetPrimitiveArrayCritical(env, t, JNI_FALSE);
	check_memory(env, jni_t);
	jfloat * jni_q = (*env)->GetPrimitiveArrayCritical(env, q, JNI_FALSE);
	check_memory(env, jni_q);
	jfloat * jni_wr = (*env)->GetPrimitiveArrayCritical(env, wr, JNI_FALSE);
	check_memory(env, jni_wr);
	jfloat * jni_wi = (*env)->GetPrimitiveArrayCritical(env, wi, JNI_FALSE);
	check_memory(env, jni_wi);
	jclass jni_mClass = (*env)->GetObjectClass(env, m);
	jfieldID jni_mId = (*env)->GetFieldID(env, jni_mClass, "val", "I");
	jint jni_m = (*env)->GetIntField(env, m, jni_mId);
	jclass jni_sClass = (*env)->GetObjectClass(env, s);
	jfieldID jni_sId = (*env)->GetFieldID(env, jni_sClass, "val", "D");
	jfloat jni_s = (*env)->GetFloatField(env, s, jni_sId);
	jclass jni_sepClass = (*env)->GetObjectClass(env, sep);
	jfieldID jni_sepId = (*env)->GetFieldID(env, jni_sepClass, "val", "D");
	jfloat jni_sep = (*env)->GetFloatField(env, sep, jni_sepId);
	jfloat * jni_work = (*env)->GetPrimitiveArrayCritical(env, work, JNI_FALSE);
	check_memory(env, jni_work);
	jint * jni_iwork = (*env)->GetPrimitiveArrayCritical(env, iwork, JNI_FALSE);
	check_memory(env, jni_iwork);
	jclass jni_infoClass = (*env)->GetObjectClass(env, info);
	jfieldID jni_infoId = (*env)->GetFieldID(env, jni_infoClass, "val", "I");
	jint jni_info = (*env)->GetIntField(env, info, jni_infoId);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_selectTmp[jni_selecti] == JNI_FALSE){
			jni_select[jni_selecti] = 0;
		} else {
			jni_select[jni_selecti] = 1;
		}
	}

	strsen_(jni_job, jni_compq, jni_select, &n, jni_t, &ldt, jni_q, &ldq, jni_wr, jni_wi, &jni_m, &jni_s, &jni_sep, jni_work, &lwork, jni_iwork, &liwork, &jni_info);

	(*env)->ReleaseStringUTFChars(env, job, jni_job);
	(*env)->ReleaseStringUTFChars(env, compq, jni_compq);
	for (jni_selecti = 0 ; jni_selecti < jni_selectSize ; jni_selecti++){
		if (jni_select[jni_selecti] == 0){
			jni_selectTmp[jni_selecti] = JNI_FALSE;
		} else {
			jni_selectTmp[jni_selecti] = JNI_TRUE;
		}
	}
	(*env)->ReleasePrimitiveArrayCritical(env, select, jni_selectTmp, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, t, jni_t, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, q, jni_q, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wr, jni_wr, 0);
	(*env)->ReleasePrimitiveArrayCritical(env, wi, jni_wi, 0);
	(*env)->SetIntField(env, m, jni_mId, jni_m);
	(*env)->SetFloatField(env, s, jni_sId, jni_s);
	(*env)->SetFloatField(env, sep, jni_sepId, jni_sep);
	(*env)->ReleasePrimitiveArrayCritical(env, work, jni_