/*
** Copyright (C) 2007-2008 Erik de Castro Lopo <erikd@mega-nerd.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

/*
** This code is part of Secret Rabibt Code aka libsamplerate. A commercial
** use license for this code is available, please see:
**		http://www.mega-nerd.com/SRC/procedure.html
*/

/*
** f = make_src_filter (cycles = 69, incr = 2381, atten = 160.000000)
**
**   Stop band atten. : 154.67 dB
**   -3dB band width  : 1.922
**   half length      : 340238
**   increment        : 2381
*/

static const struct slow_high_qual_coeffs_s
{	int increment ;
	coeff_t coeffs [340239] ;
} slow_high_qual_coeffs =
{	2381,
{
 9.657284235393746030e-01,
 9.657281621412726613e-01,
 9.657273779472256292e-01,
 9.657260709579943425e-01,
 9.657242411748556687e-01,
 9.657218885995935143e-01,
 9.657190132344973810e-01,
 9.657156150823710261e-01,
 9.657116941465326843e-01,
 9.657072504307945282e-01,
 9.657022839394945324e-01,
 9.656967946774737133e-01,
 9.656907826500827907e-01,
 9.656842478631756377e-01,
 9.656771903231314846e-01,
 9.656696100368233893e-01,
 9.656615070116398858e-01,
 9.656528812554828756e-01,
 9.656437327767599665e-01,
 9.656340615843858055e-01,
 9.656238676877905158e-01,
 9.656131510969064857e-01,
 9.656019118221832453e-01,
 9.655901498745762535e-01,
 9.655778652655470085e-01,
 9.655650580070698208e-01,
 9.655517281116315909e-01,
 9.655378755922249256e-01,
 9.655235004623492490e-01,
 9.655086027360166856e-01,
 9.654931824277518393e-01,
 9.654772395525847983e-01,
 9.654607741260518017e-01,
 9.654437861642095609e-01,
 9.654262756836061721e-01,
 9.654082427013159773e-01,
 9.653896872349128078e-01,
 9.653706093024861934e-01,
 9.653510089226313706e-01,
 9.653308861144500597e-01,
 9.653102408975589022e-01,
 9.652890732920780259e-01,
 9.652673833186427022e-01,
 9.652451709983904671e-01,
 9.652224363529754436e-01,
 9.651991794045572393e-01,
 9.651754001757993917e-01,
 9.651510986898800271e-01,
 9.651262749704926369e-01,
 9.651009290418218756e-01,
 9.650750609285785320e-01,
 9.650486706559762151e-01,
 9.650217582497327973e-01,
 9.649943237360825155e-01,
 9.649663671417652022e-01,
 9.649378884940221779e-01,
 9.649088878206207864e-01,
 9.648793651498198676e-01,
 9.648493205103967352e-01,
 9.648187539316318562e-01,
 9.647876654433195087e-01,
 9.647560550757575681e-01,
 9.647239228597564997e-01,
 9.646912688266315872e-01,
 9.646580930082109262e-01,
 9.646243954368293183e-01,
 9.645901761453221646e-01,
 9.645554351670501125e-01,
 9.645201725358665268e-01,
 9.644843882861413586e-01,
 9.644480824527474905e-01,
 9.644112550710675080e-01,
 9.643739061770016940e-01,
 9.643360358069392735e-01,
 9.642976439977980485e-01,
 9.642587307869880942e-01,
 9.642192962124369604e-01,
 9.641793403125725748e-01,
 9.641388631263365649e-01,
 9.640978646931779306e-01,
 9.640563450530537093e-01,
 9.640143042464200951e-01,
 9.639717423142621922e-01,
 9.639286592980441659e-01,
 9.638850552397599802e-01,
 9.638409301818994246e-01,
 9.637962841674682091e-01,
 9.637511172399710890e-01,
 9.637054294434274082e-01,
 9.636592208223616618e-01,
 9.636124914218008319e-01,
 9.635652412872870443e-01,
 9.635174704648616917e-01,
 9.634691790010806445e-01,
 9.634203669430008166e-01,
 9.633710343381919339e-01,
 9.633211812347238778e-01,
 9.632708076811813402e-01,
 9.632199137266507227e-01,
 9.631684994207244666e-01,
 9.631165648135027180e-01,
 9.630641099555957707e-01,
 9.630111348981192920e-01,
 9.629576396926903259e-01,
 9.629036243914399495e-01,
 9.628490890469985075e-01,
 9.627940337125093784e-01,
 9.627384584416203150e-01,
 9.626823632884765614e-01,
 9.626257483077473864e-01,
 9.625686135545918898e-01,
 9.625109590846846475e-01,
 9.624527849542000579e-01,
 9.623940912198210018e-01,
 9.623348779387403962e-01,
 9.622751451686527568e-01,
 9.622148929677565299e-01,
 9.621541213947606419e-01,
 9.620928305088780608e-01,
 9.620310203698192453e-01,
 9.619686910378176803e-01,
 9.619058425735953488e-01,
 9.618424750383863797e-01,
 9.617785884939332730e-01,
 9.617141830024799054e-01,
 9.616492586267730847e-01,
 9.615838154300708762e-01,
 9.615178534761319451e-01,
 9.614513728292150008e-01,
 9.613843735540962276e-01,
 9.613168557160521877e-01,
 9.612488193808526038e-01,
 9.611802646147833418e-01,
 9.611111914846396376e-01,
 9.610416000577068907e-01,
 9.609714904017852000e-01,
 9.609008625851720442e-01,
 9.608297166766762709e-01,
 9.607580527456042185e-01,
 9.606858708617690423e-01,
 9.606131710954939340e-01,
 9.605399535175953574e-01,
 9.604662181993973702e-01,
 9.603919652127322903e-01,
 9.603171946299289274e-01,
 9.602419065238272378e-01,
 9.601661009677665559e-01,
 9.600897780355864830e-01,
 9.600129378016331039e-01,
 9.599355803407596532e-01,
 9.598577057283178560e-01,
 9.597793140401642553e-01,
 9.597004053526501099e-01,
 9.596209797426437094e-01,
 9.595410372875099458e-01,
 9.594605780651147553e-01,
 9.593796021538247842e-01,
 9.592981096325121637e-01,
 9.592161005805541762e-01,
 9.591335750778278157e-01,
 9.590505332047059017e-01,
 9.589669750420790617e-01,
 9.588829006713240899e-01,
 9.587983101743289271e-01,
 9.587132036334775620e-01,
 9.586275811316626871e-01,
 9.585414427522702674e-01,
 9.584547885791959709e-01,
 9.583676186968306254e-01,
 9.582799331900714312e-01,
 9.581917321443151891e-01,
 9.581030156454554136e-01,
 9.580137837798901046e-01,
 9.579240366345228574e-01,
 9.578337742967500956e-01,
 9.577429968544788341e-01,
 9.576517043961021436e-01,
 9.575598970105301255e-01,
 9.574675747871574938e-01,
 9.573747378158925514e-01,
 9.572813861871392049e-01,
 9.571875199917972976e-01,
 9.570931393212775973e-01,
 9.569982442674722645e-01,
 9.569028349227920449e-01,
 9.568069113801369596e-01,
 9.567104737329119590e-01,
 9.566135220750197066e-01,
 9.565160565008583582e-01,
 9.564180771053286678e-01,
 9.563195839838368739e-01,
 9.562205772322724950e-01,
 9.561210569470401932e-01,
 9.560210232250334617e-01,
 9.559204761636538317e-01,
 9.558194158607901114e-01,
 9.557178424148340401e-01,
 9.556157559246800659e-01,
 9.555131564897146879e-01,
 9.554100442098283352e-01,
 9.553064191854077070e-01,
 9.552022815173281112e-01,
 9.550976313069821089e-01,
 9.549924686562412113e-01,
 9.548867936674824142e-01,
 9.547806064435864215e-01,
 9.546739070879148858e-01,
 9.545666957043427159e-01,
 9.544589723972358719e-01,
 9.543507372714538084e-01,
 9.542419904323594659e-01,
 9.541327319858051714e-01,
 9.540229620381482922e-01,
 9.539126806962340277e-01,
 9.538018880674121736e-01,
 9.536905842595208016e-01,
 9.535787693809015808e-01,
 9.534664435403855665e-01,
 9.533536068473057457e-01,
 9.532402594114883776e-01,
 9.531264013432507731e-01,
 9.530120327534097324e-01,
 9.528971537532816560e-01,
 9.527817644546733300e-01,
 9.526658649698831471e-01,
 9.525494554117108770e-01,
 9.524325358934497832e-01,
 9.523151065288876227e-01,
 9.521971674323029822e-01,
 9.520787187184749367e-01,
 9.519597605026706155e-01,
 9.518402929006573032e-01,
 9.517203160286913377e-01,
 9.515998300035271029e-01,
 9.514788349424085911e-01,
 9.513573309630783958e-01,
 9.512353181837659433e-01,
 9.511127967232019254e-01,
 9.509897667006035338e-01,
 9.508662282356856732e-01,
 9.507421814486547440e-01,
 9.506176264602070880e-01,
 9.504925633915326522e-01,
 9.503669923643195405e-01,
 9.502409135007438001e-01,
 9.501143269234706423e-01,
 9.499872327556601048e-01,
 9.498596311209690501e-01,
 9.497315221435412846e-01,
 9.496029059480096679e-01,
 9.494737826595053276e-01,
 9.493441524036435597e-01,
 9.492140153065377062e-01,
 9.490833714947857214e-01,
 9.489522210954840498e-01,
 9.488205642362114167e-01,
 9.486884010450450377e-01,
 9.485557316505456305e-01,
 9.484225561817705152e-01,
 9.482888747682625130e-01,
 9.481546875400582719e-01,
 9.480199946276800516e-01,
 9.478847961621443829e-01,
 9.477490922749530755e-01,
 9.476128830981019879e-01,
 9.474761687640710361e-01,
 9.473389494058349625e-01,
 9.472012251568542318e-01,
 9.470629961510762529e-01,
 9.469242625229385979e-01,
 9.467850244073708899e-01,
 9.466452819397860319e-01,
 9.465050352560934188e-01,
 9.463642844926742903e-01,
 9.462230297864152595e-01,
 9.460812712746790032e-01,
 9.459390090953243568e-01,
 9.457962433866925478e-01,
 9.456529742876100819e-01,
 9.455092019373962930e-01,
 9.453649264758512416e-01,
 9.452201480432647074e-01,
 9.450748667804192982e-01,
 9.449290828285694666e-01,
 9.447827963294702647e-01,
 9.446360074253569161e-01,
 9.444887162589485907e-01,
 9.443409229734541777e-01,
 9.441926277125608502e-01,
 9.440438306204562702e-01,
 9.438945318418000552e-01,
 9.437447315217356580e-01,
 9.435944298059016910e-01,
 9.434436268404174930e-01,
 9.432923227718813530e-01,
 9.431405177473851653e-01,
 9.429882119144973318e-01,
 9.428354054212751967e-01,
 9.426820984162567196e-01,
 9.425282910484674703e-01,
 9.423739834674114135e-01,
 9.422191758230826775e-01,
 9.420638682659502328e-01,
 9.419080609469753229e-01,
 9.417517540175931456e-01,
 9.415949476297296172e-01,
 9.414376419357861625e-01,
 9.412798370886529264e-01,
 9.411215332416955626e-01,
 9.409627305487694438e-01,
 9.408034291642040081e-01,
 9.406436292428169699e-01,
 9.404833309399003305e-01,
 9.403225344112365880e-01,
 9.401612398130799741e-01,
 9.399994473021728858e-01,
 9.398371570357327842e-01,
 9.396743691714632973e-01,
 9.395110838675428955e-01,
 9.393473012826352164e-01,
 9.391830215758785183e-01,
 9.390182449068976700e-01,
 9.388529714357893852e-01,
 9.386872013231379874e-01,
 9.385209347299989791e-01,
 9.383541718179143620e-01,
 9.381869127488983162e-01,
 9.380191576854500779e-01,
 9.378509067905411722e-01,
 9.376821602276276257e-01,
 9.375129181606374207e-01,
 9.373431807539793770e-01,
 9.371729481725471489e-01,
 9.370022205816952443e-01,
 9.368309981472741077e-01,
 9.366592810355977017e-01,
 9.364870694134611595e-01,
 9.363143634481371214e-01,
 9.361411633073783989e-01,
 9.359674691594098705e-01,
 9.357932811729314793e-01,
 9.356185995171232284e-01,
 9.354434243616362998e-01,
 9.352677558766031574e-01,
 9.350915942326247787e-01,
 9.349149396007848667e-01,
 9.347377921526353051e-01,
 9.345601520602059287e-01,
 9.343820194960039682e-01,
 9.342033946330091654e-01,
 9.340242776446711082e-01,
 9.338446687049196671e-01,
 9.336645679881537818e-01,
 9.334839756692465684e-01,
 9.333028919235504262e-01,
 9.331213169268864904e-01,
 9.329392508555458541e-01,
 9.327566938862953405e-01,
 9.325736461963779478e-01,
 9.323901079635061873e-01,
 9.322060793658610844e-01,
 9.320215605820983962e-01,
 9.318365517913500540e-01,
 9.316510531732123956e-01,
 9.314650649077598210e-01,
 9.312785871755304701e-01,
 9.310916201575419882e-01,
 9.309041640352744285e-01,
 9.307162189906851291e-01,
 9.305277852061962784e-01,
 9.303388628647056846e-01,
 9.301494521495776713e-01,
 9.299595532446444102e-01,
 9.297691663342060320e-01,
 9.295782916030458365e-01,
 9.293869292364017598e-01,
 9.291950794199792529e-01,
 9.290027423399646045e-01,
 9.288099181830054007e-01,
 9.286166071362148555e-01,
 9.284228093871772503e-01,
 9.282285251239477120e-01,
 9.280337545350427764e-01,
 9.278384978094554869e-01,
 9.276427551366295265e-01,
 9.274465267064935237e-01,
 9.272498127094340736e-01,
 9.270526133362979593e-01,
 9.268549287784162427e-01,
 9.266567592275679610e-01,
 9.264581048760049953e-01,
 9.262589659164447431e-01,
 9.260593425420762248e-01,
 9.258592349465415428e-01,
 9.256586433239528677e-01,
 9.254575678688906626e-01,
 9.252560087763935792e-01,
 9.250539662419682285e-01,
 9.248514404615867379e-01,
 9.246484316316836427e-01,
 9.244449399491529995e-01,
 9.242409656113582672e-01,
 9.240365088161166529e-01,
 9.238315697617236477e-01,
 9.236261486469230508e-01,
 9.234202456709258433e-01,
 9.232138610334088558e-01,
 9.230069949345034441e-01,
 9.227996475748112548e-01,
 9.225918191553871273e-01,
 9.223835098777541930e-01,
 9.221747199438902198e-01,
 9.219654495562363827e-01,
 9.217556989177015936e-01,
 9.215454682316379653e-01,
 9.213347577018751178e-01,
 9.211235675326947536e-01,
 9.209118979288358764e-01,
 9.206997490954993424e-01,
 9.204871212383488599e-01,
 9.202740145634997759e-01,
 9.200604292775332871e-01,
 9.198463655874830058e-01,
 9.196318237008452856e-01,
 9.194168038255701170e-01,
 9.192013061700690102e-01,
 9.189853309432080009e-01,
 9.187688783543098703e-01,
 9.185519486131602518e-01,
 9.183345419299963064e-01,
 9.181166585155100535e-01,
 9.178982985808520345e-01,
 9.176794623376320903e-01,
 9.174601499979091468e-01,
 9.172403617742048709e-01,
 9.170200978794887936e-01,
 9.167993585271924095e-01,
 9.165781439311949663e-01,
 9.163564543058342338e-01,
 9.161342898659046163e-01,
 9.159116508266519352e-01,
 9.156885374037720959e-01,
 9.154649498134176389e-01,
 9.152408882721990713e-01,
 9.150163529971705456e-01,
 9.147913442058479561e-01,
 9.145658621161919521e-01,
 9.143399069466223716e-01,
 9.141134789160049179e-01,
 9.138865782436590424e-01,
 9.136592051493600541e-01,
 9.134313598533305711e-01,
 9.132030425762386328e-01,
 9.129742535392181280e-01,
 9.127449929638370429e-01,
 9.125152610721219970e-01,
 9.122850580865475845e-01,
 9.120543842300408155e-01,
 9.118232397259778965e-01,
 9.115916247981777909e-01,
 9.113595396709129881e-01,
 9.111269845689080604e-01,
 9.108939597173292269e-01,
 9.106604653417968986e-01,
 9.104265016683774636e-01,
 9.101920689235767359e-01,
 9.099571673343617162e-01,
 9.097217971281399418e-01,
 9.094859585327591533e-01,
 9.092496517765301656e-01,
 9.090128770881930054e-01,
 9.087756346969423360e-01,
 9.085379248324191304e-01,
 9.082997477247046758e-01,
 9.080611036043290119e-01,
 9.078219927022737057e-01,
 9.075824152499472053e-01,
 9.073423714792206995e-01,
 9.071018616223990305e-01,
 9.068608859122373467e-01,
 9.066194445819268921e-01,
 9.063775378651106607e-01,
 9.061351659958672977e-01,
 9.058923292087209811e-01,
 9.056490277386430865e-01,
 9.054052618210394199e-01,
 9.051610316917652055e-01,
 9.049163375871129844e-01,
 9.046711797438118374e-01,
 9.044255583990439273e-01,
 9.041794737904262913e-01,
 9.039329261560131723e-01,
 9.036859157343016813e-01,
 9.034384427642340176e-01,
 9.031905074851839244e-01,
 9.029421101369723424e-01,
 9.026932509598525334e-01,
 9.024439301945198499e-01,
 9.021941480821120685e-01,
 9.019439048642012846e-01,
 9.016932007827919149e-01,
 9.014420360803397925e-01,
 9.011904109997301848e-01,
 9.009383257842841219e-01,
 9.006857806777610609e-01,
 9.004327759243624385e-01,
 9.001793117687216794e-01,
 8.999253884559021976e-01,
 8.996710062314197121e-01,
 8.994161653412048318e-01,
 8.991608660316424695e-01,
 8.989051085495424198e-01,
 8.986488931421465765e-01,
 8.983922200571440309e-01,
 8.981350895426412073e-01,
 8.978775018471930602e-01,
 8.976194572197828681e-01,
 8.973609559098225663e-01,
 8.971019981671612964e-01,
 8.968425842420845173e-01,
 8.965827143853020154e-01,
 8.963223888479613377e-01,
 8.960616078816437957e-01,
 8.958003717383580256e-01,
 8.955386806705427638e-01,
 8.952765349310700671e-01,
 8.950139347732458672e-01,
 8.947508804507969815e-01,
 8.944873722178955378e-01,
 8.942234103291289982e-01,
 8.939589950395203655e-01,
 8.936941266045239640e-01,
 8.934288052800176683e-01,
 8.931630313223110074e-01,
 8.928968049881452762e-01,
 8.926301265346824332e-01,
 8.923629962195200882e-01,
 8.920954143006757375e-01,
 8.918273810366013077e-01,
 8.915588966861675013e-01,
 8.912899615086777860e-01,
 8.910205757638590685e-01,
 8.907507397118716863e-01,
 8.904804536132854276e-01,
 8.902097177291126151e-01,
 8.899385323207823495e-01,
 8.896668976501437287e-01,
 8.893948139794813912e-01,
 8.891222815714994177e-01,
 8.888493006893219972e-01,
 8.885758715964997556e-01,
 8.883019945570098663e-01,
 8.880276698352457254e-01,
 8.877528976960272766e-01,
 8.874776784046002343e-01,
 8.872020122266245368e-01,
 8.869258994281892239e-01,
 8.866493402757986697e-01,
 8.863723350363836850e-01,
 8.860948839772899710e-01,
 8.858169873662875560e-01,
 8.855386454715687972e-01,
 8.852598585617404980e-01,
 8.849806269058309027e-01,
 8.847009507732929157e-01,
 8.844208304339890026e-01,
 8.841402661582089539e-01,
 8.838592582166507894e-01,
 8.835778068804451824e-01,
 8.832959124211269275e-01,
 8.830135751106529263e-01,
 8.827307952213970799e-01,
 8.824475730261533979e-01,
 8.821639087981261174e-01,
 8.818798028109459120e-01,
 8.815952553386395829e-01,
 8.813102666556734688e-01,
 8.810248370369120341e-01,
 8.807389667576401848e-01,
 8.804526560935568291e-01,
 8.801659053207787631e-01,
 8.798787147158337874e-01,
 8.795910845556564883e-01,
 8.793030151176082221e-01,
 8.790145066794545770e-01,
 8.787255595193735891e-01,
 8.784361739159571858e-01,
 8.781463501482125178e-01,
 8.778560884955517452e-01,
 8.775653892378053600e-01,
 8.772742526552061992e-01,
 8.769826790284079854e-01,
 8.766906686384705605e-01,
 8.763982217668595531e-01,
 8.761053386954542610e-01,
 8.758120197065423218e-01,
 8.755182650828247093e-01,
 8.752240751074076286e-01,
 8.749294500637992966e-01,
 8.746343902359308142e-01,
 8.743388959081236367e-01,
 8.740429673651215481e-01,
 8.737466048920664585e-01,
 8.734498087745100614e-01,
 8.731525792984167200e-01,
 8.728549167501397088e-01,
 8.725568214164574066e-01,
 8.722582935845369922e-01,
 8.719593335419696389e-01,
 8.716599415767301018e-01,
 8.713601179772180183e-01,
 8.710598630322177183e-01,
 8.707591770309334178e-01,
 8.704580602629656827e-01,
 8.701565130183119834e-01,
 8.698545355873861240e-01,
 8.695521282609943725e-01,
 8.692492913303510038e-01,
 8.689460250870661984e-01,
 8.686423298231549239e-01,
 8.683382058310360474e-01,
 8.680336534035225649e-01,
 8.677286728338321486e-01,
 8.674232644155843719e-01,
 8.671174284427934920e-01,
 8.668111652098784425e-01,
 8.665044750116488448e-01,
 8.661973581433277669e-01,
 8.658898149005185285e-01,
 8.655818455792373411e-01,
 8.652734504758898826e-01,
 8.649646298872843975e-01,
 8.646553841106181526e-01,
 8.643457134434988642e-01,
 8.640356181839160543e-01,
 8.637250986302622557e-01,
 8.634141550813234645e-01,
 8.631027878362863559e-01,
 8.627909971947252954e-01,
 8.624787834566125522e-01,
 8.621661469223169671e-01,
 8.618530878925968475e-01,
 8.615396066686054066e-01,
 8.612257035518935400e-01,
 8.609113788443981674e-01,
 8.605966328484544459e-01,
 8.602814658667822245e-01,
 8.599658782025032533e-01,
 8.596498701591263059e-01,
 8.593334420405440710e-01,
 8.590165941510568004e-01,
 8.586993267953352271e-01,
 8.583816402784558708e-01,
 8.580635349058768346e-01,
 8.577450109834475755e-01,
 8.574260688174091261e-01,
 8.571067087143875440e-01,
 8.567869309814007961e-01,
 8.564667359258499868e-01,
 8.561461238555265751e-01,
 8.558250950786087108e-01,
 8.555036499036660080e-01,
 8.551817886396468893e-01,
 8.548595115958893542e-01,
 8.545368190821223120e-01,
 8.542137114084509264e-01,
 8.538901888853738242e-01,
 8.535662518237645546e-01,
 8.532419005348930163e-01,
 8.529171353304072500e-01,
 8.525919565223335495e-01,
 8.522663644230926705e-01,
 8.519403593454824009e-01,
 8.516139416026788922e-01,
 8.512871115082524254e-01,
 8.509598693761402100e-01,
 8.506322155206740288e-01,
 8.503041502565562570e-01,
 8.499756738988831772e-01,
 8.496467867631161131e-01,
 8.493174891651115166e-01,
 8.489877814210874396e-01,
 8.486576638476630574e-01,
 8.483271367618200332e-01,
 8.479962004809237230e-01,
 8.476648553227186245e-01,
 8.473331016053288200e-01,
 8.470009396472513163e-01,
 8.466683697673652587e-01,
 8.463353922849213840e-01,
 8.460020075195461287e-01,
 8.456682157912548403e-01,
 8.453340174204225788e-01,
 8.449994127278037670e-01,
 8.446644020345386306e-01,
 8.443289856621251088e-01,
 8.439931639324498303e-01,
 8.436569371677669071e-01,
 8.433203056906991568e-01,
 8.429832698242523126e-01,
 8.426458298917984813e-01,
 8.423079862170832488e-01,
 8.419697391242283446e-01,
 8.416310889377198734e-01,
 8.412920359824190841e-01,
 8.409525805835608159e-01,
 8.406127230667449490e-01,
 8.402724637579435107e-01,
 8.399318029834993427e-01,
 8.395907410701265450e-01,
 8.392492783449025939e-01,
 8.389074151352804432e-01,
 8.385651517690709822e-01,
 8.382224885744690157e-01,
 8.378794258800188466e-01,
 8.375359640146422535e-01,
 8.371921033076298313e-01,
 8.368478440886314429e-01,
 8.365031866876659894e-01,
 8.361581314351211880e-01,
 8.358126786617436910e-01,
 8.354668286986512982e-01,
 8.351205818773175249e-01,
 8.347739385295911418e-01,
 8.344268989876764131e-01,
 8.340794635841457527e-01,
 8.337316326519270682e-01,
 8.333834065243221900e-01,
 8.330347855349881092e-01,
 8.326857700179388644e-01,
 8.323363603075620842e-01,
 8.319865567385956728e-01,
 8.316363596461461283e-01,
 8.312857693656723335e-01,
 8.309347862329983236e-01,
 8.305834105843052928e-01,
 8.302316427561358125e-01,
 8.298794830853905014e-01,
 8.295269319093273586e-01,
 8.291739895655607651e-01,
 8.288206563920677006e-01,
 8.284669327271769745e-01,
 8.281128189095748882e-01,
 8.277583152783064557e-01,
 8.274034221727772920e-01,
 8.270481399327308525e-01,
 8.266924688982874025e-01,
 8.263364094099113766e-01,
 8.259799618084208150e-01,
 8.256231264349892518e-01,
 8.252659036311442708e-01,
 8.249082937387697267e-01,
 8.245502971000965298e-01,
 8.241919140577108616e-01,
 8.238331449545502894e-01,
 8.234739901339087620e-01,
 8.231144499394230651e-01,
 8.227545247150859220e-01,
 8.223942148052403311e-01,
 8.220335205545806767e-01,
 8.216724423081471773e-01,
 8.213109804113306600e-01,
 8.209491352098753358e-01,
 8.205869070498634787e-01,
 8.202242962777384072e-01,
 8.198613032402845002e-01,
 8.194979282846284185e-01,
 8.191341717582547588e-01,
 8.187700340089861806e-01,
 8.184055153849936204e-01,
 8.180406162347976240e-01,
 8.176753369072549127e-01,
 8.173096777515793665e-01,
 8.169436391173192646e-01,
 8.165772213543734948e-01,
 8.162104248129797845e-01,
 8.158432498437200309e-01,
 8.154756967975215209e-01,
 8.151077660256542678e-01,
 8.147394578797241271e-01,
 8.143707727116885620e-01,
 8.140017108738386575e-01,
 8.136322727188112225e-01,
 8.132624585995779087e-01,
 8.128922688694548704e-01,
 8.125217038820957693e-01,
 8.121507639914943288e-01,
 8.117794495519873310e-01,
 8.114077609182387407e-01,
 8.110356984452670170e-01,
 8.106632624884106963e-01,
 8.102904534033591455e-01,
 8.099172715461303573e-01,
 8.095437172730816089e-01,
 8.091697909409064637e-01,
 8.087954929066337728e-01,
 8.084208235276294507e-01,
 8.080457831615909248e-01,
 8.076703721665503544e-01,
 8.072945909008776288e-01,
 8.069184397232682660e-01,
 8.065419189927612864e-01,
 8.061650290687204512e-01,
 8.057877703108475842e-01,
 8.054101430791672511e-01,
 8.050321477340474097e-01,
 8.046537846361788704e-01,
 8.042750541465848446e-01,
 8.038959566266224988e-01,
 8.035164924379726292e-01,
 8.031366619426458797e-01,
 8.027564655029929552e-01,
 8.023759034816764224e-01,
 8.019949762416977990e-01,
 8.016136841463871177e-01,
 8.012320275593950436e-01,
 8.008500068447029774e-01,
 8.004676223666181700e-01,
 8.000848744897772757e-01,
 7.997017635791360268e-01,
 7.993182899999791147e-01,
 7.989344541179164150e-01,
 7.985502562988837649e-01,
 7.981656969091357468e-01,
 7.977807763152516829e-01,
 7.973954948841431856e-01,
 7.970098529830269563e-01,
 7.966238509794624223e-01,
 7.962374892413135452e-01,
 7.958507681367810171e-01,
 7.954636880343699534e-01,
 7.950762493029170930e-01,
 7.946884523115805843e-01,
 7.943002974298282171e-01,
 7.939117850274597377e-01,
 7.935229154745846447e-01,
 7.931336891416338464e-01,
 7.927441063993589943e-01,
 7.923541676188250449e-01,
 7.919638731714147006e-01,
 7.915732234288291869e-01,
 7.911822187630850323e-01,
 7.907908595465190649e-01,
 7.903991461517734241e-01,
 7.900070789518172099e-01,
 7.896146583199268321e-01,
 7.892218846296936707e-01,
 7.888287582550269628e-01,
 7.884352795701414784e-01,
 7.880414489495753960e-01,
 7.876472667681703177e-01,
 7.872527334010841482e-01,
 7.868578492237854327e-01,
 7.864626146120571315e-01,
 7.860670299419870721e-01,
 7.856710955899771642e-01,
 7.852748119327382925e-01,
 7.848781793472909829e-01,
 7.844811982109681781e-01,
 7.840838689014026919e-01,
 7.836861917965459723e-01,
 7.832881672746510038e-01,
 7.828897957142783026e-01,
 7.824910774942971381e-01,
 7.820920129938853105e-01,
 7.816926025925187149e-01,
 7.812928466699895491e-01,
 7.808927456063863293e-01,
 7.804922997821064357e-01,
 7.800915095778512276e-01,
 7.796903753746272647e-01,
 7.792888975537409779e-01,
 7.788870764968034432e-01,
 7.784849125857283836e-01,
 7.780824062027317245e-01,
 7.776795577303313722e-01,
 7.772763675513484349e-01,
 7.768728360488974527e-01,
 7.764689636064041611e-01,
 7.760647506075856183e-01,
 7.756601974364616403e-01,
 7.752553044773501378e-01,
 7.748500721148714465e-01,
 7.744445007339378906e-01,
 7.740385907197626647e-01,
 7.736323424578533947e-01,
 7.732257563340231288e-01,
 7.728188327343717967e-01,
 7.724115720453023082e-01,
 7.720039746535038994e-01,
 7.715960409459730052e-01,
 7.711877713099910547e-01,
 7.707791661331372390e-01,
 7.703702258032839589e-01,
 7.699609507086000448e-01,
 7.695513412375400986e-01,
 7.691413977788568168e-01,
 7.687311207215965503e-01,
 7.683205104550920872e-01,
 7.679095673689687596e-01,
 7.674982918531434439e-01,
 7.670866842978226741e-01,
 7.666747450935030850e-01,
 7.662624746309760759e-01,
 7.658498733013054949e-01,
 7.654369414958626106e-01,
 7.650236796062952482e-01,
 7.646100880245425557e-01,
 7.641961671428302294e-01,
 7.637819173536724016e-01,
 7.633673390498633138e-01,
 7.629524326244916388e-01,
 7.625371984709220508e-01,
 7.621216369828134329e-01,
 7.617057485541021133e-01,
 7.612895335790108575e-01,
 7.608729924520449828e-01,
 7.604561255679964660e-01,
 7.600389333219322863e-01,
 7.596214161092103012e-01,
 7.592035743254642588e-01,
 7.587854083666101257e-01,
 7.583669186288453101e-01,
 7.579481055086479957e-01,
 7.575289694027775855e-01,
 7.571095107082660425e-01,
 7.566897298224322110e-01,
 7.562696271428728245e-01,
 7.558492030674571760e-01,
 7.554284579943361111e-01,
 7.550073923219337013e-01,
 7.545860064489589014e-01,
 7.541643007743888960e-01,
 7.537422756974833105e-01,
 7.533199316177662253e-01,
 7.528972689350501568e-01,
 7.524742880494099673e-01,
 7.520509893612046248e-01,
 7.516273732710596622e-01,
 7.512034401798760586e-01,
 7.507791904888270196e-01,
 7.503546245993580888e-01,
 7.499297429131859261e-01,
 7.495045458322995291e-01,
 7.490790337589600112e-01,
 7.486532070956947171e-01,
 7.482270662452995547e-01,
 7.478006116108487644e-01,
 7.473738435956769344e-01,
 7.469467626033897689e-01,
 7.465193690378613134e-01,
 7.460916633032325107e-01,
 7.456636458039124227e-01,
 7.452353169445781189e-01,
 7.448066771301655731e-01,
 7.443777267658839847e-01,
 7.439484662572082296e-01,
 7.435188960098728650e-01,
 7.430890164298754597e-01,
 7.426588279234860313e-01,
 7.422283308972306148e-01,
 7.417975257579005888e-01,
 7.413664129125487889e-01,
 7.409349927684907300e-01,
 7.405032657333058266e-01,
 7.400712322148274014e-01,
 7.396388926211565629e-01,
 7.392062473606543227e-01,
 7.387732968419337132e-01,
 7.383400414738774398e-01,
 7.379064816656191184e-01,
 7.374726178265530452e-01,
 7.370384503663292008e-01,
 7.366039796948615770e-01,
 7.361692062223144095e-01,
 7.357341303591102832e-01,
 7.352987525159280224e-01,
 7.348630731037032460e-01,
 7.344270925336208178e-01,
 7.339908112171259491e-01,
 7.335542295659195355e-01,
 7.331173479919474989e-01,
 7.326801669074179957e-01,
 7.322426867247865401e-01,
 7.318049078567584464e-01,
 7.313668307163003757e-01,
 7.309284557166209062e-01,
 7.304897832711800820e-01,
 7.300508137936961850e-01,
 7.296115476981284154e-01,
 7.291719853986894373e-01,
 7.287321273098399388e-01,
 7.282919738462891868e-01,
 7.278515254229934728e-01,
 7.274107824551605539e-01,
 7.269697453582366631e-01,
 7.265284145479246058e-01,
 7.260867904401628881e-01,
 7.256448734511442566e-01,
 7.252026639973031541e-01,
 7.247601624953210475e-01,
 7.243173693621187681e-01,
 7.238742850148627284e-01,
 7.234309098709608143e-01,
 7.229872443480709343e-01,
 7.225432888640829221e-01,
 7.220990438371381881e-01,
 7.216545096856130659e-01,
 7.212096868281256956e-01,
 7.207645756835345807e-01,
 7.203191766709373667e-01,
 7.198734902096787236e-01,
 7.194275167193265874e-01,
 7.189812566197059107e-01,
 7.185347103308632466e-01,
 7.180878782730912846e-01,
 7.176407608669185256e-01,
 7.171933585331089489e-01,
 7.167456716926631222e-01,
 7.162977007668172025e-01,
 7.158494461770438244e-01,
 7.154009083450445505e-01,
 7.149520876927608626e-01,
 7.145029846423662789e-01,
 7.140535996162669097e-01,
 7.136039330371045653e-01,
 7.131539853277455432e-01,
 7.127037569112947279e-01,
 7.122532482110888186e-01,
 7.118024596506882240e-01,
 7.113513916538927173e-01,
 7.109000446447217847e-01,
 7.104484190474348315e-01,
 7.099965152865098661e-01,
 7.095443337866602640e-01,
 7.090918749728278847e-01,
 7.086391392701744119e-01,
 7.081861271040974515e-01,
 7.077328389002121023e-01,
 7.072792750843687193e-01,
 7.068254360826339289e-01,
 7.063713223213073933e-01,
 7.059169342269079328e-01,
 7.054622722261776335e-01,
 7.050073367460858442e-01,
 7.045521282138265118e-01,
 7.040966470568076341e-01,
 7.036408937026693566e-01,
 7.031848685792639886e-01,
 7.027285721146737663e-01,
 7.022720047371955321e-01,
 7.018151668753448424e-01,
 7.013580589578620739e-01,
 7.009006814137073160e-01,
 7.004430346720513789e-01,
 6.999851191622925572e-01,
 6.995269353140387558e-01,
 6.990684835571197020e-01,
 6.986097643215841702e-01,
 6.981507780376889905e-01,
 6.976915251359133707e-01,
 6.972320060469523462e-01,
 6.967722212017078975e-01,
 6.963121710313046053e-01,
 6.958518559670791026e-01,
 6.953912764405754121e-01,
 6.949304328835567146e-01,
 6.944693257279996867e-01,
 6.940079554060830658e-01,
 6.935463223502045249e-01,
 6.930844269929780088e-01,
 6.926222697672134165e-01,
 6.921598511059408043e-01,
 6.916971714423971740e-01,
 6.912342312100271391e-01,
 6.907710308424845902e-01,
 6.903075707736313626e-01,
 6.898438514375360153e-01,
 6.893798732684743857e-01,
 6.889156367009288129e-01,
 6.884511421695846956e-01,
 6.879863901093404843e-01,
 6.875213809552916944e-01,
 6.870561151427378999e-01,
 6.865905931071916157e-01,
 6.861248152843598680e-01,
 6.856587821101524094e-01,
 6.851924940206900461e-01,
 6.847259514522844315e-01,
 6.842591548414570513e-01,
 6.837921046249268997e-01,
 6.833248012396169191e-01,
 6.828572451226416762e-01,
 6.823894367113225723e-01,
 6.819213764431778513e-01,
 6.814530647559268184e-01,
 6.809845020874794042e-01,
 6.805156888759494871e-01,
 6.800466255596439025e-01,
 6.795773125770752099e-01,
 6.791077503669354920e-01,
 6.786379393681286620e-01,
 6.781678800197414869e-01,
 6.776975727610652367e-01,
 6.772270180315751453e-01,
 6.767562162709500617e-01,
 6.762851679190542420e-01,
 6.758138734159443439e-01,
 6.753423332018738678e-01,
 6.748705477172854961e-01,
 6.743985174028153118e-01,
 6.739262426992825850e-01,
 6.734537240477015407e-01,
 6.729809618892799161e-01,
 6.725079566654084129e-01,
 6.720347088176676920e-01,
 6.715612187878251538e-01,
 6.710874870178407114e-01,
 6.706135139498565767e-01,
 6.701393000261995914e-01,
 6.696648456893884438e-01,
 6.691901513821237879e-01,
 6.687152175472953486e-01,
 6.682400446279683770e-01,
 6.677646330674005259e-01,
 6.672889833090299705e-01,
 6.668130957964778505e-01,
 6.663369709735474933e-01,
 6.658606092842228596e-01,
 6.653840111726732065e-01,
 6.649071770832485351e-01,
 6.644301074604733737e-01,
 6.639528027490601003e-01,
 6.634752633938924005e-01,
 6.629974898400395888e-01,
 6.625194825327446191e-01,
 6.620412419174355190e-01,
 6.615627684397097363e-01,
 6.610840625453457964e-01,
 6.606051246802973065e-01,
 6.601259552906922901e-01,
 6.596465548228381826e-01,
 6.591669237232151701e-01,
 6.586870624384775219e-01,
 6.582069714154574758e-01,
 6.577266511011511385e-01,
 6.572461019427333628e-01,
 6.567653243875570812e-01,
 6.562843188831356533e-01,
 6.558030858771650706e-01,
 6.553216258175011966e-01,
 6.548399391521787516e-01,
 6.543580263293989896e-01,
 6.538758877975332506e-01,
 6.533935240051201854e-01,
 6.529109354008693078e-01,
 6.524281224336532237e-01,
 6.519450855525202870e-01,
 6.514618252066755044e-01,
 6.509783418455000747e-01,
 6.504946359185291849e-01,
 6.500107078754771006e-01,
 6.495265581662136301e-01,
 6.490421872407757808e-01,
 6.485575955493602107e-01,
 6.480727835423367722e-01,
 6.475877516702256420e-01,
 6.471025003837178602e-01,
 6.466170301336638948e-01,
 6.461313413710745301e-01,
 6.456454345471229761e-01,
 6.451593101131407604e-01,
 6.446729685206175064e-01,
 6.441864102212069287e-01,
 6.436996356667185060e-01,
 6.432126453091228102e-01,
 6.427254396005387393e-01,
 6.422380189932558325e-01,
 6.417503839397081800e-01,
 6.412625348924964053e-01,
 6.407744723043671264e-01,
 6.402861966282288320e-01,
 6.397977083171421109e-01,
 6.393090078243222063e-01,
 6.388200956031365729e-01,
 6.383309721071052101e-01,
 6.378416377899042145e-01,
 6.373520931053594518e-01,
 6.368623385074484444e-01,
 6.363723744502997048e-01,
 6.358822013881922919e-01,
 6.353918197755527020e-01,
 6.349012300669618636e-01,
 6.344104327171491420e-01,
 6.339194281809861220e-01,
 6.334282169134964890e-01,
 6.329367993698555850e-01,
 6.324451760053793059e-01,
 6.319533472755303194e-01,
 6.314613136359205070e-01,
 6.309690755423056352e-01,
 6.304766334505859104e-01,
 6.299839878168047580e-01,
 6.294911390971544840e-01,
 6.289980877479625088e-01,
 6.285048342257062437e-01,
 6.280113789870024332e-01,
 6.275177224886073768e-01,
 6.270238651874258107e-01,
 6.265298075404936995e-01,
 6.260355500049940014e-01,
 6.255410930382475643e-01,
 6.250464370977140138e-01,
 6.245515826409897553e-01,
 6.240565301258153008e-01,
 6.235612800100607256e-01,
 6.230658327517396566e-01,
 6.225701888089995029e-01,
 6.220743486401225653e-01,
 6.215783127035306999e-01,
 6.210820814577799887e-01,
 6.205856553615536342e-01,
 6.200890348736813884e-01,
 6.195922204531171262e-01,
 6.190952125589485044e-01,
 6.185980116504006254e-01,
 6.181006181868261562e-01,
 6.176030326277115456e-01,
 6.171052554326705852e-01,
 6.166072870614549561e-01,
 6.161091279739357995e-01,
 6.156107786301230345e-01,
 6.151122394901481494e-01,
 6.146135110142789681e-01,
 6.141145936628998880e-01,
 6.136154878965383030e-01,
 6.131161941758300760e-01,
 6.126167129615534002e-01,
 6.121170447146012661e-01,
 6.116171898959974484e-01,
 6.111171489668896228e-01,
 6.106169223885483666e-01,
 6.101165106223666035e-01,
 6.096159141298641559e-01,
 6.091151333726821937e-01,
 6.086141688125827898e-01,
 6.081130209114491425e-01,
 6.076116901312873519e-01,
 6.071101769342260868e-01,
 6.066084817825050379e-01,
 6.061066051384956799e-01,
 6.056045474646782889e-01,
 6.051023092236578194e-01,
 6.045998908781552439e-01,
 6.040972928910062212e-01,
 6.035945157251709769e-01,
 6.030915598437158742e-01,
 6.025884257098310659e-01,
 6.020851137868167280e-01,
 6.015816245380946059e-01,
 6.010779584271910281e-01,
 6.005741159177589994e-01,
 6.000700974735495574e-01,
 5.995659035584385288e-01,
 5.990615346364118743e-01,
 5.985569911715586944e-01,
 5.980522736280925455e-01,
 5.975473824703255721e-01,
 5.970423181626884901e-01,
 5.965370811697175979e-01,
 5.960316719560574406e-01,
 5.955260909864649177e-01,
 5.950203387258027332e-01,
 5.945144156390415047e-01,
 5.940083221912578759e-01,
 5.935020588476346282e-01,
 5.929956260734627893e-01,
 5.924890243341357499e-01,
 5.919822540951560352e-01,
 5.914753158221299767e-01,
 5.909682099807598288e-01,
 5.904609370368615329e-01,
 5.899534974563518386e-01,
 5.894458917052427527e-01,
 5.889381202496539736e-01,
 5.884301835558088944e-01,
 5.879220820900240563e-01,
 5.874138163187205830e-01,
 5.869053867084228493e-01,
 5.863967937257487106e-01,
 5.858880378374121678e-01,
 5.853791195102359124e-01,
 5.848700392111300106e-01,
 5.843607974071072242e-01,
 5.838513945652759052e-01,
 5.833418311528369982e-01,
 5.828321076370938103e-01,
 5.823222244854364682e-01,
 5.818121821653537973e-01,
 5.813019811444302132e-01,
 5.807916218903418359e-01,
 5.802811048708567121e-01,
 5.797704305538345926e-01,
 5.792595994072304855e-01,
 5.787486118990884387e-01,
 5.782374684975413182e-01,
 5.777261696708184679e-01,
 5.772147158872293904e-01,
 5.767031076151840630e-01,
 5.761913453231710669e-01,
 5.756794294797739076e-01,
 5.751673605536589129e-01,
 5.746551390135864468e-01,
 5.741427653283942556e-01,
 5.736302399670113461e-01,
 5.731175633984529894e-01,
 5.726047360918185003e-01,
 5.720917585162919039e-01,
 5.715786311411381604e-01,
 5.710653544357096045e-01,
 5.705519288694386182e-01,
 5.700383549118455129e-01,
 5.695246330325236528e-01,
 5.690107637011523334e-01,
 5.684967473874966704e-01,
 5.679825845613897251e-01,
 5.674682756927582616e-01,
 5.669538212515978781e-01,
 5.664392217079883274e-01,
 5.659244775320859677e-01,
 5.654095891941223195e-01,
 5.648945571644111707e-01,
 5.643793819133394729e-01,
 5.638640639113691178e-01,
 5.633486036290410448e-01,
 5.628330015369680250e-01,
 5.623172581058403230e-01,
 5.618013738064209228e-01,
 5.612853491095437519e-01,
 5.607691844861215635e-01,
 5.602528804071325030e-01,
 5.597364373436293228e-01,
 5.592198557667390491e-01,
 5.587031361476547664e-01,
 5.581862789576458317e-01,
 5.576692846680445514e-01,
 5.571521537502549526e-01,
 5.566348866757530045e-01,
 5.561174839160796246e-01,
 5.555999459428446752e-01,
 5.550822732277216343e-01,
 5.545644662424559224e-01,
 5.540465254588547994e-01,
 5.535284513487942482e-01,
 5.530102443842138671e-01,
 5.524919050371158713e-01,
 5.519734337795687562e-01,
 5.514548310837065204e-01,
 5.509360974217205609e-01,
 5.504172332658694433e-01,
 5.498982390884692428e-01,
 5.493791153619020928e-01,
 5.488598625586088575e-01,
 5.483404811510881327e-01,
 5.478209716119027961e-01,
 5.473013344136703484e-01,
 5.467815700290721281e-01,
 5.462616789308437637e-01,
 5.457416615917765057e-01,
 5.452215184847272189e-01,
 5.447012500826017289e-01,
 5.441808568583633710e-01,
 5.436603392850321015e-01,
 5.431396978356815008e-01,
 5.426189329834423258e-01,
 5.420980452014958484e-01,
 5.415770349630799618e-01,
 5.410559027414825195e-01,
 5.405346490100465529e-01,
 5.400132742421676069e-01,
 5.394917789112851914e-01,
 5.389701634908977690e-01,
 5.384484284545498767e-01,
 5.379265742758390090e-01,
 5.374046014284091788e-01,
 5.368825103859525827e-01,
 5.363603016222118214e-01,
 5.358379756109747927e-01,
 5.353155328260807977e-01,
 5.347929737414076623e-01,
 5.342702988308872802e-01,
 5.337475085684937337e-01,
 5.332246034282451808e-01,
 5.327015838842059647e-01,
 5.321784504104847269e-01,
 5.316552034812298544e-01,
 5.311318435706351426e-01,
 5.306083711529392399e-01,
 5.300847867024194304e-01,
 5.295610906933927442e-01,
 5.290372836002218415e-01,
 5.285133658973041326e-01,
 5.279893380590835461e-01,
 5.274652005600338756e-01,
 5.269409538746757660e-01,
 5.264165984775635021e-01,
 5.258921348432940013e-01,
 5.253675634464938238e-01,
 5.248428847618294979e-01,
 5.243180992640065208e-01,
 5.237932074277605876e-01,
 5.232682097278673616e-01,
 5.227431066391323711e-01,
 5.222178986363988917e-01,
 5.216925861945405085e-01,
 5.211671697884678878e-01,
 5.206416498931161208e-01,
 5.201160269834601557e-01,
 5.195903015345032516e-01,
 5.190644740212776442e-01,
 5.185385449188483209e-01,
 5.180125147023079135e-01,
 5.174863838467800292e-01,
 5.169601528274148095e-01,
 5.164338221193932599e-01,
 5.159073921979221433e-01,
 5.153808635382338688e-01,
 5.148542366155887118e-01,
 5.143275119052749256e-01,
 5.138006898826020796e-01,
 5.132737710229097194e-01,
 5.127467558015578186e-01,
 5.122196446939302206e-01,
 5.116924381754347495e-01,
 5.111651367215066522e-01,
 5.106377408075933877e-01,
 5.101102509091741677e-01,
 5.095826675017426366e-01,
 5.090549910608180850e-01,
 5.085272220619375672e-01,
 5.079993609806577881e-01,
 5.074714082925514402e-01,
 5.069433644732158628e-01,
 5.064152299982620509e-01,
 5.058870053433222047e-01,
 5.053586909840427355e-01,
 5.048302873960849313e-01,
 5.043017950551309525e-01,
 5.037732144368733955e-01,
 5.032445460170216212e-01,
 5.027157902713018656e-01,
 5.021869476754519113e-01,
 5.016580187052207540e-01,
 5.011290038363730437e-01,
 5.005999035446859757e-01,
 5.000707183059458494e-01,
 4.995414485959539519e-01,
 4.990120948905191756e-01,
 4.984826576654605157e-01,
 4.979531373966072372e-01,
 4.974235345597988744e-01,
 4.968938496308819563e-01,
 4.963640830857122266e-01,
 4.958342354001539221e-01,
 4.953043070500712242e-01,
 4.947742985113449121e-01,
 4.942442102598565978e-01,
 4.937140427714919455e-01,
 4.931837965221432807e-01,
 4.926534719877085911e-01,
 4.921230696440889729e-01,
 4.915925899671852450e-01,
 4.910620334329049430e-01,
 4.905314005171579339e-01,
 4.900006916958530301e-01,
 4.894699074449028187e-01,
 4.889390482402186655e-01,
 4.884081145577142680e-01,
 4.878771068732999372e-01,
 4.873460256628882603e-01,
 4.868148714023848855e-01,
 4.862836445677034547e-01,
 4.857523456347450086e-01,
 4.852209750794116427e-01,
 4.846895333776035097e-01,
 4.841580210052134903e-01,
 4.836264384381329662e-01,
 4.830947861522446596e-01,
 4.825630646234275734e-01,
 4.820312743275562695e-01,
 4.814994157404955955e-01,
 4.809674893381051808e-01,
 4.804354955962349960e-01,
 4.799034349907290720e-01,
 4.793713079974200597e-01,
 4.788391150921342820e-01,
 4.783068567506829627e-01,
 4.777745334488754381e-01,
 4.772421456625014491e-01,
 4.767096938673439643e-01,
 4.761771785391719081e-01,
 4.756446001537455448e-01,
 4.751119591868066538e-01,
 4.745792561140885768e-01,
 4.740464914113063921e-01,
 4.735136655541636319e-01,
 4.729807790183464533e-01,
 4.724478322795259699e-01,
 4.719148258133591955e-01,
 4.713817600954833820e-01,
 4.708486356015215701e-01,
 4.703154528070754847e-01,
 4.697822121877311963e-01,
 4.692489142190564566e-01,
 4.687155593765969797e-01,
 4.681821481358821591e-01,
 4.676486809724174631e-01,
 4.671151583616889313e-01,
 4.665815807791628966e-01,
 4.660479487002811561e-01,
 4.655142626004636908e-01,
 4.649805229551096653e-01,
 4.644467302395929309e-01,
 4.639128849292601942e-01,
 4.633789874994402314e-01,
 4.628450384254330086e-01,
 4.623110381825115689e-01,
 4.617769872459244196e-01,
 4.612428860908939776e-01,
 4.607087351926157925e-01,
 4.601745350262576029e-01,
 4.596402860669541734e-01,
 4.591059887898192859e-01,
 4.585716436699321941e-01,
 4.580372511823451731e-01,
 4.575028118020775802e-01,
 4.569683260041187967e-01,
 4.564337942634295597e-01,
 4.558992170549344691e-01,
 4.553645948535292032e-01,
 4.548299281340735245e-01,
 4.542952173713954989e-01,
 4.537604630402888861e-01,
 4.532256656155146390e-01,
 4.526908255717954632e-01,
 4.521559433838217568e-01,
 4.516210195262446159e-01,
 4.510860544736805533e-01,
 4.505510487007098885e-01,
 4.500160026818726400e-01,
 4.494809168916722997e-01,
 4.489457918045746676e-01,
 4.484106278950037439e-01,
 4.478754256373457809e-01,
 4.473401855059472854e-01,
 4.468049079751105213e-01,
 4.462695935191028918e-01,
 4.457342426121419510e-01,
 4.451988557284100589e-01,
 4.446634333420424467e-01,
 4.441279759271334893e-01,
 4.435924839577312651e-01,
 4.430569579078406650e-01,
 4.425213982514216715e-01,
 4.419858054623921340e-01,
 4.414501800146158339e-01,
 4.409145223819163628e-01,
 4.403788330380706828e-01,
 4.398431124568051298e-01,
 4.393073611117987443e-01,
 4.387715794766846589e-01,
 4.382357680250427157e-01,
 4.376999272304058497e-01,
 4.371640575662580352e-01,
 4.366281595060286236e-01,
 4.360922335230988933e-01,
 4.355562800907985532e-01,
 4.350202996824016899e-01,
 4.344842927711350944e-01,
 4.339482598301678262e-01,
 4.334122013326184852e-01,
 4.328761177515485503e-01,
 4.323400095599669313e-01,
 4.318038772308233630e-01,
 4.312677212370180091e-01,
 4.307315420513894155e-01,
 4.301953401467215055e-01,
 4.296591159957419137e-01,
 4.291228700711172128e-01,
 4.285866028454578536e-01,
 4.280503147913146123e-01,
 4.275140063811805335e-01,
 4.269776780874856570e-01,
 4.264413303826014578e-01,
 4.259049637388392928e-01,
 4.253685786284464032e-01,
 4.248321755236080244e-01,
 4.242957548964525483e-01,
 4.237593172190380342e-01,
 4.232228629633605355e-01,
 4.226863926013566530e-01,
 4.221499066048945425e-01,
 4.216134054457751912e-01,
 4.210768895957396896e-01,
 4.205403595264580741e-01,
 4.200038157095373204e-01,
 4.194672586165123507e-01,
 4.189306887188560813e-01,
 4.183941064879693750e-01,
 4.178575123951872583e-01,
 4.173209069117704839e-01,
 4.167842905089165217e-01,
 4.162476636577477906e-01,
 4.157110268293194855e-01,
 4.151743804946100291e-01,
 4.146377251245329520e-01,
 4.141010611899240135e-01,
 4.135643891615488066e-01,
 4.130277095100990392e-01,
 4.124910227061930335e-01,
 4.119543292203733942e-01,
 4.114176295231083413e-01,
 4.108809240847906552e-01,
 4.103442133757393417e-01,
 4.098074978661933043e-01,
 4.092707780263164508e-01,
 4.087340543261945847e-01,
 4.081973272358365712e-01,
 4.076605972251730048e-01,
 4.071238647640538222e-01,
 4.065871303222495237e-01,
 4.060503943694522277e-01,
 4.055136573752731732e-01,
 4.049769198092395550e-01,
 4.044401821408020736e-01,
 4.039034448393269972e-01,
 4.033667083740931081e-01,
 4.028299732143066914e-01,
 4.022932398290813283e-01,
 4.017565086874497204e-01,
 4.012197802583601924e-01,
 4.006830550106744160e-01,
 4.001463334131707961e-01,
 3.996096159345408627e-01,
 3.990729030433877722e-01,
 3.985361952082288051e-01,
 3.979994928974931456e-01,
 3.974627965795236029e-01,
 3.969261067225682837e-01,
 3.963894237947964694e-01,
 3.958527482642781870e-01,
 3.953160805989973658e-01,
 3.947794212668478409e-01,
 3.942427707356283006e-01,
 3.937061294730506145e-01,
 3.931694979467296180e-01,
 3.926328766241925505e-01,
 3.920962659728692290e-01,
 3.915596664600967669e-01,
 3.910230785531200737e-01,
 3.904865027190844717e-01,
 3.899499394250454110e-01,
 3.894133891379588652e-01,
 3.888768523246857178e-01,
 3.883403294519896520e-01,
 3.878038209865375952e-01,
 3.872673273948993855e-01,
 3.867308491435427764e-01,
 3.861943866988418184e-01,
 3.856579405270673111e-01,
 3.851215110943916886e-01,
 3.845850988668865766e-01,
 3.840487043105229592e-01,
 3.835123278911720113e-01,
 3.829759700745983819e-01,
 3.824396313264697977e-01,
 3.819033121123478480e-01,
 3.813670128976908713e-01,
 3.808307341478538999e-01,
 3.802944763280877716e-01,
 3.797582399035392964e-01,
 3.792220253392458162e-01,
 3.786858331001428102e-01,
 3.781496636510597309e-01,
 3.776135174567155639e-01,
 3.770773949817246562e-01,
 3.765412966905910541e-01,
 3.760052230477127777e-01,
 3.754691745173772133e-01,
 3.749331515637645551e-01,
 3.743971546509403114e-01,
 3.738611842428659071e-01,
 3.733252408033846947e-01,
 3.727893247962358880e-01,
 3.722534366850416832e-01,
 3.717175769333139757e-01,
 3.711817460044489203e-01,
 3.706459443617323157e-01,
 3.701101724683348304e-01,
 3.695744307873126688e-01,
 3.690387197816083487e-01,
 3.685030399140452606e-01,
 3.679673916473356066e-01,
 3.674317754440712402e-01,
 3.668961917667274975e-01,
 3.663606410776655831e-01,
 3.658251238391246329e-01,
 3.652896405132290414e-01,
 3.647541915619789687e-01,
 3.642187774472597783e-01,
 3.636833986308353750e-01,
 3.631480555743502592e-01,
 3.626127487393244753e-01,
 3.620774785871601065e-01,
 3.615422455791376111e-01,
 3.610070501764117146e-01,
 3.604718928400153510e-01,
 3.599367740308603292e-01,
 3.594016942097316702e-01,
 3.588666538372912718e-01,
 3.583316533740742993e-01,
 3.577966932804954592e-01,
 3.572617740168368416e-01,
 3.567268960432575242e-01,
 3.561920598197902410e-01,
 3.556572658063389958e-01,
 3.551225144626808938e-01,
 3.545878062484613125e-01,
 3.540531416232031714e-01,
 3.535185210462928884e-01,
 3.529839449769929804e-01,
 3.524494138744295180e-01,
 3.519149281976037824e-01,
 3.513804884053802757e-01,
 3.508460949564961573e-01,
 3.503117483095520290e-01,
 3.497774489230203177e-01,
 3.492431972552341723e-01,
 3.487089937643993998e-01,
 3.481748389085810302e-01,
 3.476407331457149752e-01,
 3.471066769335984237e-01,
 3.465726707298916742e-01,
 3.460387149921229644e-01,
 3.455048101776804215e-01,
 3.449709567438140612e-01,
 3.444371551476409499e-01,
 3.439034058461326038e-01,
 3.433697092961285335e-01,
 3.428360659543250311e-01,
 3.423024762772802765e-01,
 3.417689407214110076e-01,
 3.412354597429925751e-01,
 3.407020337981628844e-01,
 3.401686633429142903e-01,
 3.396353488330981496e-01,
 3.391020907244230442e-01,
 3.385688894724530051e-01,
 3.380357455326123972e-01,
 3.375026593601762048e-01,
 3.369696314102795243e-01,
 3.364366621379092370e-01,
 3.359037519979057307e-01,
 3.353709014449674508e-01,
 3.348381109336424077e-01,
 3.343053809183317848e-01,
 3.337727118532918258e-01,
 3.332401041926285612e-01,
 3.327075583902980860e-01,
 3.321750749001118330e-01,
 3.316426541757267477e-01,
 3.311102966706526152e-01,
 3.305780028382500624e-01,
 3.300457731317238408e-01,
 3.295136080041327076e-01,
 3.289815079083783789e-01,
 3.284494732972138564e-01,
 3.279175046232376545e-01,
 3.273856023388952430e-01,
 3.268537668964784371e-01,
 3.263219987481243978e-01,
 3.257902983458128565e-01,
 3.252586661413742752e-01,
 3.247271025864765237e-01,
 3.241956081326342609e-01,
 3.236641832312071032e-01,
 3.231328283333945728e-01,
 3.226015438902380961e-01,
 3.220703303526242789e-01,
 3.215391881712775790e-01,
 3.210081177967635813e-01,
 3.204771196794891641e-01,
 3.199461942697028882e-01,
 3.194153420174876135e-01,
 3.188845633727693807e-01,
 3.183538587853112500e-01,
 3.178232287047138560e-01,
 3.172926735804155185e-01,
 3.167621938616914656e-01,
 3.162317899976532787e-01,
 3.157014624372475597e-01,
 3.151712116292592070e-01,
 3.146410380223042536e-01,
 3.141109420648376949e-01,
 3.135809242051437185e-01,
 3.130509848913435866e-01,
 3.125211245713909736e-01,
 3.119913436930710771e-01,
 3.114616427040025615e-01,
 3.109320220516348376e-01,
 3.104024821832487291e-01,
 3.098730235459548621e-01,
 3.093436465866972740e-01,
 3.088143517522449755e-01,
 3.082851394891999441e-01,
 3.077560102439931833e-01,
 3.072269644628803920e-01,
 3.066980025919481267e-01,
 3.061691250771086392e-01,
 3.056403323641044278e-01,
 3.051116248985002444e-01,
 3.045830031256883119e-01,
 3.040544674908866596e-01,
 3.035260184391398997e-01,
 3.029976564153132879e-01,
 3.024693818640988296e-01,
 3.019411952300113389e-01,
 3.014130969573904917e-01,
 3.008850874903952755e-01,
 3.003571672730094844e-01,
 2.998293367490389993e-01,
 2.993015963621076803e-01,
 2.987739465556633056e-01,
 2.982463877729722435e-01,
 2.977189204571205616e-01,
 2.971915450510158596e-01,
 2.966642619973831607e-01,
 2.961370717387643570e-01,
 2.956099747175214287e-01,
 2.950829713758331696e-01,
 2.945560621556953529e-01,
 2.940292474989190108e-01,
 2.935025278471347643e-01,
 2.929759036417839968e-01,
 2.924493753241269589e-01,
 2.919229433352371617e-01,
 2.913966081160025978e-01,
 2.908703701071232439e-01,
 2.903442297491157231e-01,
 2.898181874823065329e-01,
 2.892922437468372077e-01,
 2.887663989826561028e-01,
 2.882406536295294974e-01,
 2.877150081270289927e-01,
 2.871894629145411160e-01,
 2.866640184312587714e-01,
 2.861386751161859032e-01,
 2.856134334081353865e-01,
 2.850882937457301924e-01,
 2.845632565673981151e-01,
 2.840383223113774891e-01,
 2.835134914157129704e-01,
 2.829887643182557033e-01,
 2.824641414566620434e-01,
 2.819396232683974990e-01,
 2.814152101907286263e-01,
 2.808909026607305237e-01,
 2.803667011152801147e-01,
 2.798426059910592012e-01,
 2.793186177245538526e-01,
 2.787947367520524633e-01,
 2.782709635096463074e-01,
 2.777472984332284289e-01,
 2.772237419584926976e-01,
 2.767002945209358633e-01,
 2.761769565558550021e-01,
 2.756537284983467950e-01,
 2.751306107833075831e-01,
 2.746076038454338120e-01,
 2.740847081192213652e-01,
 2.735619240389630669e-01,
 2.730392520387505129e-01,
 2.725166925524725170e-01,
 2.719942460138152218e-01,
 2.714719128562617656e-01,
 2.709496935130899509e-01,
 2.704275884173765743e-01,
 2.699055980019888779e-01,
 2.693837226995922651e-01,
 2.688619629426468038e-01,
 2.683403191634037288e-01,
 2.678187917939104379e-01,
 2.672973812660057180e-01,
 2.667760880113205779e-01,
 2.662549124612804685e-01,
 2.657338550470990102e-01,
 2.652129161997826001e-01,
 2.646920963501305235e-01,
 2.641713959287278479e-01,
 2.636508153659532505e-01,
 2.631303550919731893e-01,
 2.626100155367418476e-01,
 2.620897971300046869e-01,
 2.615697003012930066e-01,
 2.610497254799264422e-01,
 2.605298730950105779e-01,
 2.600101435754393897e-01,
 2.594905373498911927e-01,
 2.589710548468329154e-01,
 2.584516964945130502e-01,
 2.579324627209677590e-01,
 2.574133539540155446e-01,
 2.568943706212604705e-01,
 2.563755131500901063e-01,
 2.558567819676739741e-01,
 2.553381775009638255e-01,
 2.548197001766962511e-01,
 2.543013504213848530e-01,
 2.537831286613301263e-01,
 2.532650353226076345e-01,
 2.527470708310791125e-01,
 2.522292356123820301e-01,
 2.517115300919340326e-01,
 2.511939546949329416e-01,
 2.506765098463538122e-01,
 2.501591959709523194e-01,
 2.496420134932572643e-01,
 2.491249628375801495e-01,
 2.486080444280047985e-01,
 2.480912586883942950e-01,
 2.475746060423862360e-01,
 2.470580869133934265e-01,
 2.465417017246044895e-01,
 2.460254508989822841e-01,
 2.455093348592644054e-01,
 2.449933540279614630e-01,
 2.444775088273575536e-01,
 2.439617996795089838e-01,
 2.434462270062457134e-01,
 2.429307912291679139e-01,
 2.424154927696492989e-01,
 2.419003320488334607e-01,
 2.413853094876349525e-01,
 2.408704255067360411e-01,
 2.403556805265944230e-01,
 2.398410749674320386e-01,
 2.393266092492397079e-01,
 2.388122837917814323e-01,
 2.382980990145836808e-01,
 2.377840553369440224e-01,
 2.372701531779257134e-01,
 2.367563929563585023e-01,
 2.362427750908389634e-01,
 2.357292999997293304e-01,
 2.352159681011573300e-01,
 2.347027798130147669e-01,
 2.341897355529608538e-01,
 2.336768357384144679e-01,
 2.331640807865604792e-01,
 2.326514711143476966e-01,
 2.321390071384867304e-01,
 2.316266892754497708e-01,
 2.311145179414728634e-01,
 2.306024935525509689e-01,
 2.300906165244434864e-01,
 2.295788872726662322e-01,
 2.290673062124990444e-01,
 2.285558737589792055e-01,
 2.280445903269033570e-01,
 2.275334563308283320e-01,
 2.270224721850689353e-01,
 2.265116383036968606e-01,
 2.260009551005430772e-01,
 2.254904229891949996e-01,
 2.249800423829948492e-01,
 2.244698136950455669e-01,
 2.239597373382018752e-01,
 2.234498137250757743e-01,
 2.229400432680336275e-01,
 2.224304263791973824e-01,
 2.219209634704416012e-01,
 2.214116549533969858e-01,
 2.209025012394440768e-01,
 2.203935027397191937e-01,
 2.198846598651105211e-01,
 2.193759730262575536e-01,
 2.188674426335515677e-01,
 2.183590690971355108e-01,
 2.178508528269037237e-01,
 2.173427942324978046e-01,
 2.168348937233131324e-01,
 2.163271517084926765e-01,
 2.158195685969281075e-01,
 2.153121447972600466e-01,
 2.148048807178795372e-01,
 2.142977767669209666e-01,
 2.137908333522705318e-01,
 2.132840508815594949e-01,
 2.127774297621642663e-01,
 2.122709704012097631e-01,
 2.117646732055650238e-01,
 2.112585385818456785e-01,
 2.107525669364108400e-01,
 2.102467586753660467e-01,
 2.097411142045576271e-01,
 2.092356339295786127e-01,
 2.087303182557636028e-01,
 2.082251675881917896e-01,
 2.077201823316808527e-01,
 2.072153628907955347e-01,
 2.067107096698370394e-01,
 2.062062230728514134e-01,
 2.057019035036246057e-01,
 2.051977513656811636e-01,
 2.046937670622873962e-01,
 2.041899509964470172e-01,
 2.036863035709064185e-01,
 2.031828251881461767e-01,
 2.026795162503886027e-01,
 2.021763771595912473e-01,
 2.016734083174498704e-01,
 2.011706101253996071e-01,
 2.006679829846080565e-01,
 2.001655272959803888e-01,
 1.996632434601600392e-01,
 1.991611318775224626e-01,
 1.986591929481792140e-01,
 1.981574270719774489e-01,
 1.976558346484960649e-01,
 1.971544160770502818e-01,
 1.966531717566870063e-01,
 1.961521020861854703e-01,
 1.956512074640586463e-01,
 1.951504882885513326e-01,
 1.946499449576390983e-01,
 1.941495778690302265e-01,
 1.936493874201621057e-01,
 1.931493740082034505e-01,
 1.926495380300536908e-01,
 1.921498798823406684e-01,
 1.916503999614216636e-01,
 1.911510986633828957e-01,
 1.906519763840392734e-01,
 1.901530335189333121e-01,
 1.896542704633354115e-01,
 1.891556876122424957e-01,
 1.886572853603788458e-01,
 1.881590641021954335e-01,
 1.876610242318688393e-01,
 1.871631661433004745e-01,
 1.866654902301175534e-01,
 1.861679968856727596e-01,
 1.856706865030418874e-01,
 1.851735594750256453e-01,
 1.846766161941475193e-01,
 1.841798570526543555e-01,
 1.836832824425166932e-01,
 1.831868927554259063e-01,
 1.826906883827970063e-01,
 1.821946697157648676e-01,
 1.816988371451864204e-01,
 1.812031910616399843e-01,
 1.807077318554232148e-01,
 1.802124599165532415e-01,
 1.797173756347686946e-01,
 1.792224793995263188e-01,
 1.787277716000003069e-01,
 1.782332526250865190e-01,
 1.777389228633949603e-01,
 1.772447827032564149e-01,
 1.767508325327170060e-01,
 1.762570727395408599e-01,
 1.757635037112074416e-01,
 1.752701258349128322e-01,
 1.747769394975687840e-01,
 1.742839450858015282e-01,
 1.737911429859537726e-01,
 1.732985335840807883e-01,
 1.728061172659530187e-01,
 1.723138944170548581e-01,
 1.718218654225830699e-01,
 1.713300306674480911e-01,
 1.708383905362721167e-01,
 1.703469454133899330e-01,
 1.698556956828475573e-01,
 1.693646417284040973e-01,
 1.688737839335270607e-01,
 1.683831226813964355e-01,
 1.678926583549016083e-01,
 1.674023913366412541e-01,
 1.669123220089250015e-01,
 1.664224507537698516e-01,
 1.659327779529022884e-01,
 1.654433039877569456e-01,
 1.649540292394765795e-01,
 1.644649540889102923e-01,
 1.639760789166158916e-01,
 1.634874041028570035e-01,
 1.629989300276036834e-01,
 1.625106570705309172e-01,
 1.620225856110216189e-01,
 1.615347160281617733e-01,
 1.610470487007434892e-01,
 1.605595840072624458e-01,
 1.600723223259181427e-01,
 1.595852640346149820e-01,
 1.590984095109590768e-01,
 1.586117591322614429e-01,
 1.581253132755331969e-01,
 1.576390723174895259e-01,
 1.571530366345463281e-01,
 1.566672066028216015e-01,
 1.561815825981330286e-01,
 1.556961649960009186e-01,
 1.552109541716446550e-01,
 1.547259504999826396e-01,
 1.542411543556346243e-01,
 1.537565661129184080e-01,
 1.532721861458500867e-01,
 1.527880148281459682e-01,
 1.523040525332181594e-01,
 1.518202996341775357e-01,
 1.513367565038319928e-01,
 1.508534235146870017e-01,
 1.503703010389435824e-01,
 1.498873894484984703e-01,
 1.494046891149455047e-01,
 1.489222004095731855e-01,
 1.484399237033654784e-01,
 1.479578593670004272e-01,
 1.474760077708503481e-01,
 1.469943692849811079e-01,
 1.465129442791537062e-01,
 1.460317331228213888e-01,
 1.455507361851288983e-01,
 1.450699538349157214e-01,
 1.445893864407121754e-01,
 1.441090343707396304e-01,
 1.436288979929118692e-01,
 1.431489776748336162e-01,
 1.426692737837992053e-01,
 1.421897866867940785e-01,
 1.417105167504938701e-01,
 1.412314643412624360e-01,
 1.407526298251536856e-01,
 1.402740135679098887e-01,
 1.397956159349619809e-01,
 1.393174372914293413e-01,
 1.388394780021182939e-01,
 1.383617384315220245e-01,
 1.378842189438222732e-01,
 1.374069199028862820e-01,
 1.369298416722667944e-01,
 1.364529846152052195e-01,
 1.359763490946247211e-01,
 1.354999354731360739e-01,
 1.350237441130346938e-01,
 1.345477753762997497e-01,
 1.340720296245940246e-01,
 1.335965072192654979e-01,
 1.331212085213442087e-01,
 1.326461338915438937e-01,
 1.321712836902605992e-01,
 1.316966582775729866e-01,
 1.312222580132411109e-01,
 1.307480832567074203e-01,
 1.302741343670941743e-01,
 1.298004117032061366e-01,
 1.293269156235277439e-01,
 1.288536464862228836e-01,
 1.283806046491368646e-01,
 1.279077904697929757e-01,
 1.274352043053946504e-01,
 1.269628465128233019e-01,
 1.264907174486397945e-01,
 1.260188174690811125e-01,
 1.255471469300635246e-01,
 1.250757061871801967e-01,
 1.246044955957016642e-01,
 1.241335155105739996e-01,
 1.236627662864206723e-01,
 1.231922482775405780e-01,
 1.227219618379084831e-01,
 1.222519073211735668e-01,
 1.217820850806616562e-01,
 1.213124954693706598e-01,
 1.208431388399749395e-01,
 1.203740155448210225e-01,
 1.199051259359306260e-01,
 1.194364703649967996e-01,
 1.189680491833867704e-01,
 1.184998627421402079e-01,
 1.180319113919670732e-01,
 1.175641954832519903e-01,
 1.170967153660482790e-01,
 1.166294713900823815e-01,
 1.161624639047505320e-01,
 1.156956932591189369e-01,
 1.152291598019257318e-01,
 1.147628638815763463e-01,
 1.142968058461471120e-01,
 1.138309860433834586e-01,
 1.133654048206985399e-01,
 1.129000625251746631e-01,
 1.124349595035619154e-01,
 1.119700961022783159e-01,
 1.115054726674087754e-01,
 1.110410895447055402e-01,
 1.105769470795874843e-01,
 1.101130456171396654e-01,
 1.096493855021133251e-01,
 1.091859670789256387e-01,
 1.087227906916581610e-01,
 1.082598566840588805e-01,
 1.077971653995383472e-01,
 1.073347171811741552e-01,
 1.068725123717056691e-01,
 1.064105513135363973e-01,
 1.059488343487342138e-01,
 1.054873618190288742e-01,
 1.050261340658132092e-01,
 1.045651514301419727e-01,
 1.041044142527334654e-01,
 1.036439228739649415e-01,
 1.031836776338775630e-01,
 1.027236788721719446e-01,
 1.022639269282100694e-01,
 1.018044221410140671e-01,
 1.013451648492665058e-01,
 1.008861553913085601e-01,
 1.004273941051421620e-01,
 9.996888132842693397e-02,
 9.951061739848247878e-02,
 9.905260265228574279e-02,
 9.859483742647233429e-02,
 9.813732205733544101e-02,
 9.768005688082581628e-02,
 9.722304223255044675e-02,
 9.676627844777495324e-02,
 9.630976586141902496e-02,
 9.585350480806059670e-02,
 9.539749562193200472e-02,
 9.494173863692130511e-02,
 9.448623418657249584e-02,
 9.403098260408364328e-02,
 9.357598422230702095e-02,
 9.312123937374985894e-02,
 9.266674839057344182e-02,
 9.221251160459144336e-02,
 9.175852934727170285e-02,
 9.130480194973489283e-02,
 9.085132974275406115e-02,
 9.039811305675417297e-02,
 8.994515222181316549e-02,
 8.949244756765972753e-02,
 8.903999942367391007e-02,
 8.858780811888759821e-02,
 8.813587398198215184e-02,
 8.768419734129083432e-02,
 8.723277852479512096e-02,
 8.678161786012766887e-02,
 8.633071567457042961e-02,
 8.588007229505362217e-02,
 8.542968804815739836e-02,
 8.497956326010948358e-02,
 8.452969825678587068e-02,
 8.408009336371127795e-02,
 8.363074890605774747e-02,
 8.318166520864318791e-02,
 8.273284259593445544e-02,
 8.228428139204366221e-02,
 8.183598192072991107e-02,
 8.138794450539806047e-02,
 8.094016946909882160e-02,
 8.049265713452824489e-02,
 8.004540782402745636e-02,
 7.959842185958218574e-02,
 7.915169956282340491e-02,
 7.870524125502531554e-02,
 7.825904725710657039e-02,
 7.781311788962919085e-02,
 7.736745347279845586e-02,
 7.692205432646274932e-02,
 7.647692077011336576e-02,
 7.603205312288303930e-02,
 7.558745170354741472e-02,
 7.514311683052375679e-02,
 7.469904882187029804e-02,
 7.425524799528727959e-02,
 7.381171466811527193e-02,
 7.336844915733464756e-02,
 7.292545177956775981e-02,
 7.248272285107569546e-02,
 7.204026268775914899e-02,
 7.159807160515868629e-02,
 7.115614991845385651e-02,
 7.071449794246276177e-02,
 7.027311599164189071e-02,
 6.983200438008665967e-02,
 6.939116342152910899e-02,
 6.895059342933984592e-02,
 6.851029471652633762e-02,
 6.807026759573306385e-02,
 6.763051237924175285e-02,
 6.719102937896961891e-02,
 6.675181890647055583e-02,
 6.631288127293424872e-02,
 6.587421678918548018e-02,
 6.543582576568492126e-02,
 6.499770851252795190e-02,
 6.455986533944410577e-02,
 6.412229655579829157e-02,
 6.368500247058850317e-02,
 6.324798339244656897e-02,
 6.281123962963916507e-02,
 6.237477149006421390e-02,
 6.193857928125392348e-02,
 6.150266331037274048e-02,
 6.106702388421741262e-02,
 6.063166130921656544e-02,
 6.019657589143137533e-02,
 5.976176793655313402e-02,
 5.932723774990575349e-02,
 5.889298563644351781e-02,
 5.845901190075079856e-02,
 5.802531684704344273e-02,
 5.759190077916610806e-02,
 5.715876400059419216e-02,
 5.672590681443231281e-02,
 5.629332952341442597e-02,
 5.586103242990267392e-02,
 5.542901583588928649e-02,
 5.499728004299368062e-02,
 5.456582535246352894e-02,
 5.413465206517500267e-02,
 5.370376048163129357e-02,
 5.327315090196273195e-02,
 5.284282362592723770e-02,
 5.241277895290873817e-02,
 5.198301718191788295e-02,
 5.155353861159192586e-02,
 5.112434354019328858e-02,
 5.069543226561047666e-02,
 5.026680508535735781e-02,
 4.983846229657223903e-02,
 4.941040419601910177e-02,
 4.898263108008589495e-02,
 4.855514324478461818e-02,
 4.812794098575203655e-02,
 4.770102459824776542e-02,
 4.727439437715560966e-02,
 4.684805061698179424e-02,
 4.642199361185592871e-02,
 4.599622365552994557e-02,
 4.557074104137854437e-02,
 4.514554606239786633e-02,
 4.472063901120675034e-02,
 4.429602018004465125e-02,
 4.387168986077268074e-02,
 4.344764834487315625e-02,
 4.302389592344883773e-02,
 4.260043288722335786e-02,
 4.217725952654005628e-02,
 4.175437613136272902e-02,
 4.133178299127397703e-02,
 4.090948039547739196e-02,
 4.048746863279396174e-02,
 4.006574799166472134e-02,
 3.964431876014880979e-02,
 3.922318122592408085e-02,
 3.880233567628631891e-02,
 3.838178239814914183e-02,
 3.796152167804382055e-02,
 3.754155380211863374e-02,
 3.712187905613972827e-02,
 3.670249772548899586e-02,
 3.628341009516585641e-02,
 3.586461644978514163e-02,
 3.544611707357846891e-02,
 3.502791225039303402e-02,
 3.461000226369116695e-02,
 3.419238739655091480e-02,
 3.377506793166498711e-02,
 3.335804415134120682e-02,
 3.294131633750169846e-02,
 3.252488477168283959e-02,
 3.210874973503474034e-02,
 3.169291150832194426e-02,
 3.127737037192195729e-02,
 3.086212660582527897e-02,
 3.044718048963635654e-02,
 3.003253230257120140e-02,
 2.961818232345909616e-02,
 2.920413083074133859e-02,
 2.879037810247124171e-02,
 2.837692441631348150e-02,
 2.796377004954487405e-02,
 2.755091527905333820e-02,
 2.713836038133698308e-02,
 2.672610563250583243e-02,
 2.631415130827954169e-02,
 2.590249768398842148e-02,
 2.549114503457272987e-02,
 2.508009363458233235e-02,
 2.466934375817677119e-02,
 2.425889567912500877e-02,
 2.384874967080444913e-02,
 2.343890600620208639e-02,
 2.302936495791306146e-02,
 2.262012679814022487e-02,
 2.221119179869588539e-02,
 2.180256023099870835e-02,
 2.139423236607594647e-02,
 2.098620847456178842e-02,
 2.057848882669746984e-02,
 2.017107369233122824e-02,
 1.976396334091792481e-02,
 1.935715804151872180e-02,
 1.895065806280111717e-02,
 1.854446367303836871e-02,
 1.813857514010908459e-02,
 1.773299273149807342e-02,
 1.732771671429468585e-02,
 1.692274735519351189e-02,
 1.651808492049389177e-02,
 1.611372967609956894e-02,
 1.570968188751870401e-02,
 1.530594181986322591e-02,
 1.490250973784930724e-02,
 1.449938590579590708e-02,
 1.409657058762651613e-02,
 1.369406404686653034e-02,
 1.329186654664487634e-02,
 1.288997834969305388e-02,
 1.248839971834486522e-02,
 1.208713091453641857e-02,
 1.168617219980573260e-02,
 1.128552383529251267e-02,
 1.088518608173805018e-02,
 1.048515919948498840e-02,
 1.008544344847654185e-02,
 9.686039088257649907e-03,
 9.286946377972959271e-03,
 8.888165576367847501e-03,
 8.489696941788315437e-03,
 8.091540732179441572e-03,
 7.693697205086506147e-03,
 7.296166617654279915e-03,
 6.898949226626655516e-03,
 6.502045288346657882e-03,
 6.105455058756187499e-03,
 5.709178793395310036e-03,
 5.313216747403330144e-03,
 4.917569175516806924e-03,
 4.522236332070624261e-03,
 4.127218470997816475e-03,
 3.732515845828120703e-03,
 3.338128709689056322e-03,
 2.944057315305130887e-03,
 2.550301914997683134e-03,
 2.156862760684686523e-03,
 1.763740103880680286e-03,
 1.370934195696011781e-03,
 9.784452868372836218e-04,
 5.862736276072896000e-04,
 1.944194679035751347e-04,
-1.971169427804136346e-04,
-5.883353553562285440e-04,
-9.792355211404874926e-04,
-1.369817191854952668e-03,
-1.760080119627292902e-03,
-2.150024056990598384e-03,
-2.539648756883606823e-03,
-2.928953972651572330e-03,
-3.317939458045829348e-03,
-3.706604967224626408e-03,
-4.094950254752581856e-03,
-4.482975075601509582e-03,
-4.870679185149713424e-03,
-5.258062339184239702e-03,
-5.645124293898334117e-03,
-6.031864805893672604e-03,
-6.418283632179797547e-03,
-6.804380530174296456e-03,
-7.190155257703596467e-03,
-7.575607573002333776e-03,
-7.960737234713780378e-03,
-8.345544001890426930e-03,
-8.730027633994177916e-03,
-9.114187890896068012e-03,
-9.498024532876686229e-03,
-9.881537320626746640e-03,
-1.026472601524607703e-02,
-1.064759037824623486e-02,
-1.103013017154769529e-02,
-1.141234515748230753e-02,
-1.179423509879230954e-02,
-1.217579975863146424e-02,
-1.255703890056420607e-02,
-1.293795228856651353e-02,
-1.331853968702611558e-02,
-1.369880086074176835e-02,
-1.407873557492555355e-02,
-1.445834359520042391e-02,
-1.483762468760225876e-02,
-1.521657861857929166e-02,
-1.559520515499280592e-02,
-1.597350406411664550e-02,
-1.635147511363808578e-02,
-1.672911807165721951e-02,
-1.710643270668798371e-02,
-1.748341878765811638e-02,
-1.786007608390911133e-02,
-1.823640436519629107e-02,
-1.861240340168940355e-02,
-1.898807296397293787e-02,
-1.936341282304553449e-02,
-1.973842275032071034e-02,
-2.011310251762716064e-02,
-2.048745189720860282e-02,
-2.086147066172440792e-02,
-2.123515858424914263e-02,
-2.160851543827346788e-02,
-2.198154099770313272e-02,
-2.235423503686144800e-02,
-2.272659733048646921e-02,
-2.309862765373370611e-02,
-2.347032578217475227e-02,
-2.384169149179860350e-02,
-2.421272455901072457e-02,
-2.458342476063416285e-02,
-2.495379187390869141e-02,
-2.532382567649206148e-02,
-2.569352594646031815e-02,
-2.606289246230636750e-02,
-2.643192500294165928e-02,
-2.680062334769573243e-02,
-2.716898727631690547e-02,
-2.753701656897185324e-02,
-2.790471100624603018e-02,
-2.827207036914356625e-02,
-2.863909443908811345e-02,
-2.900578299792248849e-02,
-2.937213582790913768e-02,
-2.973815271172968594e-02,
-3.010383343248590124e-02,
-3.046917777369960792e-02,
-3.083418551931266932e-02,
-3.119885645368706759e-02,
-3.156319036160548652e-02,
-3.192718702827094385e-02,
-3.229084623930817549e-02,
-3.265416778076182802e-02,
-3.301715143909852296e-02,
-3.337979700120522614e-02,
-3.374210425439191918e-02,
-3.410407298638856721e-02,
-3.446570298534811644e-02,
-3.482699403984515496e-02,
-3.518794593887596134e-02,
-3.554855847185995482e-02,
-3.590883142863873778e-02,
-3.626876459947608183e-02,
-3.662835777505876050e-02,
-3.698761074649742353e-02,
-3.734652330532437642e-02,
-3.770509524349636293e-02,
-3.806332635339289283e-02,
-3.842121642781692881e-02,
-3.877876525999632978e-02,
-3.913597264358170680e-02,
-3.949283837264818547e-02,
-3.984936224169508684e-02,
-4.020554404564612161e-02,
-4.056138357984966081e-02,
-4.091688064007854148e-02,
-4.127203502253070505e-02,
-4.162684652382848266e-02,
-4.198131494102055189e-02,
-4.233544007157991756e-02,
-4.268922171340530647e-02,
-4.304265966482099387e-02,
-4.339575372457738639e-02,
-4.374850369185043913e-02,
-4.410090936624255775e-02,
-4.445297054778162699e-02,
-4.480468703692265520e-02,
-4.515605863454706659e-02,
-4.550708514196264570e-02,
-4.585776636090433539e-02,
-4.620810209353341802e-02,
-4.655809214243929878e-02,
-4.690773631063795135e-02,
-4.725703440157261181e-02,
-4.760598621911445866e-02,
-4.795459156756211316e-02,
-4.830285025164244433e-02,
-4.865076207651006235e-02,
-4.899832684774757530e-02,
-4.934554437136532551e-02,
-4.969241445380379041e-02,
-5.003893690193025184e-02,
-5.038511152304129409e-02,
-5.073093812486244303e-02,
-5.107641651554797879e-02,
-5.142154650368187946e-02,
-5.176632789827662756e-02,
-5.211076050877446603e-02,
-5.245484414504665571e-02,
-5.279857861739524483e-02,
-5.314196373655088318e-02,
-5.348499931367477894e-02,
-5.382768516035809497e-02,
-5.417002108862224719e-02,
-5.451200691091899475e-02,
-5.485364244013032214e-02,
-5.519492748956912609e-02,
-5.553586187297872290e-02,
-5.587644540453378522e-02,
-5.621667789883950245e-02,
-5.655655917093251744e-02,
-5.689608903628036451e-02,
-5.723526731078270452e-02,
-5.757409381076988159e-02,
-5.791256835300422068e-02,
-5.825069075468011781e-02,
-5.858846083342311717e-02,
-5.892587840729177767e-02,
-5.926294329477641704e-02,
-5.959965531479947259e-02,
-5.993601428671542497e-02,
-6.027202003031231770e-02,
-6.060767236581009187e-02,
-6.094297111386177968e-02,
-6.127791609555315044e-02,
-6.161250713240304377e-02,
-6.194674404636366788e-02,
-6.228062665982029428e-02,
-6.261415479559194475e-02,
-6.294732827692978150e-02,
-6.328014692752126358e-02,
-6.361261057148495657e-02,
-6.394471903337467511e-02,
-6.427647213817822003e-02,
-6.460786971131667056e-02,
-6.493891157864635499e-02,
-6.526959756645757393e-02,
-6.559992750147498886e-02,
-6.592990121085745558e-02,
-6.625951852219941207e-02,
-6.658877926352958776e-02,
-6.691768326331191952e-02,
-6.724623035044482999e-02,
-6.757442035426211580e-02,
-6.790225310453378016e-02,
-6.822972843146361821e-02,
-6.855684616569196477e-02,
-6.888360613829438983e-02,
-6.921000818078261452e-02,
-6.953605212510385880e-02,
-6.986173780364100805e-02,
-7.018706504921322364e-02,
-7.051203369507585972e-02,
-7.083664357492075458e-02,
-7.116089452287575889e-02,
-7.148478637350534626e-02,
-7.180831896181037732e-02,
-7.213149212322884918e-02,
-7.245430569363500717e-02,
-7.277675950934049676e-02,
-7.309885340709335044e-02,
-7.342058722407916738e-02,
-7.374196079792053049e-02,
-7.406297396667757549e-02,
-7.438362656884796309e-02,
-7.470391844336624065e-02,
-7.502384942960484138e-02,
-7.534341936737433409e-02,
-7.566262809692249347e-02,
-7.598147545893531307e-02,
-7.629996129453699150e-02,
-7.661808544528919684e-02,
-7.693584775319238511e-02,
-7.725324806068488426e-02,
-7.757028621064379625e-02,
-7.788696204638494158e-02,
-7.820327541166154084e-02,
-7.851922615066710132e-02,
-7.883481410803239164e-02,
-7.915003912882805082e-02,
-7.946490105856379715e-02,
-7.977939974318747074e-02,
-8.009353502908661548e-02,
-8.040730676308768810e-02,
-8.072071479245757075e-02,
-8.103375896490126740e-02,
-8.134643912856359682e-02,
-8.165875513202947023e-02,
-8.197070682432304467e-02,
-8.228229405490837534e-02,
-8.259351667368929062e-02,
-8.290437453100973908e-02,
-8.321486747765316494e-02,
-8.352499536484442322e-02,
-8.383475804424704581e-02,
-8.414415536796582273e-02,
-8.445318718854567808e-02,
-8.476185335897160056e-02,
-8.507015373267003133e-02,
-8.537808816350707375e-02,
-8.568565650578979787e-02,
-8.599285861426629596e-02,
-8.629969434412597395e-02,
-8.660616355099770569e-02,
-8.691226609095327460e-02,
-8.721800182050391814e-02,
-8.752337059660303398e-02,
-8.782837227664502810e-02,
-8.813300671846596712e-02,
-8.843727378034245412e-02,
-8.874117332099297484e-02,
-8.904470519957831398e-02,
-8.934786927570072257e-02,
-8.965066540940284934e-02,
-8.995309346117050242e-02,
-9.025515329193077585e-02,
-9.055684476305347896e-02,
-9.085816773634915189e-02,
-9.115912207407156354e-02,
-9.145970763891578259e-02,
-9.175992429402012041e-02,
-9.205977190296385504e-02,
-9.235925032976988192e-02,
-9.265835943890310400e-02,
-9.295709909527025139e-02,
-9.325546916422197685e-02,
-9.355346951155041335e-02,
-9.385110000349089487e-02,
-9.414836050672140133e-02,
-9.444525088836307203e-02,
-9.474177101597987261e-02,
-9.503792075757810931e-02,
-9.533369998160791392e-02,
-9.562910855696195311e-02,
-9.592414635297674685e-02,
-9.621881323943165532e-02,
-9.651310908654908705e-02,
-9.680703376499510959e-02,
-9.710058714587904705e-02,
-9.739376910075392413e-02,
-9.768657950161620251e-02,
-9.797901822090560042e-02,
-9.827108513150623059e-02,
-9.856278010674551782e-02,
-9.885410302039449038e-02,
-9.914505374666786330e-02,
-9.943563216022514861e-02,
-9.972583813616839321e-02,
-1.000156715500453292e-01,
-1.003051322778463345e-01,
-1.005942201960063065e-01,
-1.008829351814049813e-01,
-1.011712771113651155e-01,
-1.014592458636543598e-01,
-1.017468413164855506e-01,
-1.020340633485144338e-01,
-1.023209118388417188e-01,
-1.026073866670126622e-01,
-1.028934877130175812e-01,
-1.031792148572899664e-01,
-1.034645679807094237e-01,
-1.037495469645998286e-01,
-1.040341516907290209e-01,
-1.043183820413106089e-01,
-1.046022378990017487e-01,
-1.048857191469062394e-01,
-1.051688256685716916e-01,
-1.054515573479902074e-01,
-1.057339140695998936e-01,
-1.060158957182836953e-01,
-1.062975021793690078e-01,
-1.065787333386291336e-01,
-1.068595890822819638e-01,
-1.071400692969910889e-01,
-1.074201738698647712e-01,
-1.076999026884575689e-01,
-1.079792556407679766e-01,
-1.082582326152410762e-01,
-1.085368335007665802e-01,
-1.088150581866803301e-01,
-1.090929065627633671e-01,
-1.093703785192417788e-01,
-1.096474739467878101e-01,
-1.099241927365191551e-01,
-1.102005347799993318e-01,
-1.104764999692373767e-01,
-1.107520881966875953e-01,
-1.110272993552508941e-01,
-1.113021333382732125e-01,
-1.115765900395468968e-01,
-1.118506693533097840e-01,
-1.121243711742452437e-01,
-1.123976953974832049e-01,
-1.126706419185998648e-01,
-1.129432106336162450e-01,
-1.132154014389995245e-01,
-1.134872142316642324e-01,
-1.137586489089699449e-01,
-1.140297053687218259e-01,
-1.143003835091722237e-01,
-1.145706832290189492e-01,
-1.148406044274064564e-01,
-1.151101470039248009e-01,
-1.153793108586114446e-01,
-1.156480958919477442e-01,
-1.159165020048641553e-01,
-1.161845290987357504e-01,
-1.164521770753838698e-01,
-1.167194458370770516e-01,
-1.169863352865294914e-01,
-1.172528453269022775e-01,
-1.175189758618023494e-01,
-1.177847267952835397e-01,
-1.180500980318457127e-01,
-1.183150894764358751e-01,
-1.185797010344470936e-01,
-1.188439326117179812e-01,
-1.191077841145358196e-01,
-1.193712554496327016e-01,
-1.196343465241876541e-01,
-1.198970572458267353e-01,
-1.201593875226218411e-01,
-1.204213372630923290e-01,
-1.206829063762035886e-01,
-1.209440947713683462e-01,
-1.212049023584443885e-01,
-1.214653290477376718e-01,
-1.217253747500003230e-01,
-1.219850393764315699e-01,
-1.222443228386763114e-01,
-1.225032250488272967e-01,
-1.227617459194228766e-01,
-1.230198853634494466e-01,
-1.232776432943387679e-01,
-1.235350196259705491e-01,
-1.237920142726699896e-01,
-1.240486271492105691e-01,
-1.243048581708105366e-01,
-1.245607072531374204e-01,
-1.248161743123033657e-01,
-1.250712592648679788e-01,
-1.253259620278383280e-01,
-1.255802825186674854e-01,
-1.258342206552555964e-01,
-1.260877763559492548e-01,
-1.263409495395427795e-01,
-1.265937401252757166e-01,
-1.268461480328365865e-01,
-1.270981731823588035e-01,
-1.273498154944230076e-01,
-1.276010748900576475e-01,
-1.278519512907362321e-01,
-1.281024446183814391e-01,
-1.283525547953603685e-01,
-1.286022817444882338e-01,
-1.288516253890270025e-01,
-1.291005856526848961e-01,
-1.293491624596174172e-01,
-1.295973557344263505e-01,
-1.298451654021606227e-01,
-1.300925913883157758e-01,
-1.303396336188346327e-01,
-1.305862920201063815e-01,
-1.308325665189666587e-01,
-1.310784570426979101e-01,
-1.313239635190297794e-01,
-1.315690858761385806e-01,
-1.318138240426470487e-01,
-1.320581779476243112e-01,
-1.323021475205875541e-01,
-1.325457326914981360e-01,
-1.327889333907674163e-01,
-1.330317495492507329e-01,
-1.332741810982515374e-01,
-1.335162279695188692e-01,
-1.337578900952489380e-01,
-1.339991674080844297e-01,
-1.342400598411155055e-01,
-1.344805673278773872e-01,
-1.347206898023532440e-01,
-1.349604271989709448e-01,
-1.351997794526080265e-01,
-1.354387464985846723e-01,
-1.356773282726707608e-01,
-1.359155247110808151e-01,
-1.361533357504766950e-01,
-1.363907613279657649e-01,
-1.366278013811032532e-01,
-1.368644558478893380e-01,
-1.371007246667717283e-01,
-1.373366077766436100e-01,
-1.375721051168446729e-01,
-1.378072166271615828e-01,
-1.380419422478258162e-01,
-1.382762819195176573e-01,
-1.385102355833605359e-01,
-1.387438031809264394e-01,
-1.389769846542322218e-01,
-1.392097799457414908e-01,
-1.394421889983643303e-01,
-1.396742117554554130e-01,
-1.399058481608175530e-01,
-1.401370981586984310e-01,
-1.403679616937912045e-01,
-1.405984387112367007e-01,
-1.408285291566199471e-01,
-1.410582329759728637e-01,
-1.412875501157734026e-01,
-1.415164805229448541e-01,
-1.417450241448563741e-01,
-1.419731809293232061e-01,
-1.422009508246062648e-01,
-1.424283337794119142e-01,
-1.426553297428930223e-01,
-1.428819386646471290e-01,
-1.431081604947184449e-01,
-1.433339951835954917e-01,
-1.435594426822133507e-01,
-1.437845029419521081e-01,
-1.440091759146374661e-01,
-1.442334615525411590e-01,
-1.444573598083789268e-01,
-1.446808706353142349e-01,
-1.449039939869527505e-01,
-1.451267298173477549e-01,
-1.453490780809972016e-01,
-1.455710387328440769e-01,
-1.457926117282758449e-01,
-1.460137970231268623e-01,
-1.462345945736753527e-01,
-1.464550043366439902e-01,
-1.466750262692021189e-01,
-1.468946603289626451e-01,
-1.471139064739836744e-01,
-1.473327646627681786e-01,
-1.475512348542649121e-01,
-1.477693170078654417e-01,
-1.479870110834079489e-01,
-1.482043170411741495e-01,
-1.484212348418902649e-01,
-1.486377644467289372e-01,
-1.488539058173044827e-01,
-1.490696589156778329e-01,
-1.492850237043528427e-01,
-1.495000001462796213e-01,
-1.497145882048507848e-01,
-1.499287878439040655e-01,
-1.501425990277208689e-01,
-1.503560217210276884e-01,
-1.505690558889949404e-01,
-1.507817014972353542e-01,
-1.509939585118082739e-01,
-1.512058268992151899e-01,
-1.514173066264015155e-01,
-1.516283976607580297e-01,
-1.518390999701181576e-01,
-1.520494135227574706e-01,
-1.522593382873992929e-01,
-1.524688742332061253e-01,
-1.526780213297871946e-01,
-1.528867795471929858e-01,
-1.530951488559192386e-01,
-1.533031292269038393e-01,
-1.535107206315284023e-01,
-1.537179230416174658e-01,
-1.539247364294390463e-01,
-1.541311607677044171e-01,
-1.543371960295674417e-01,
-1.545428421886252957e-01,
-1.547480992189178561e-01,
-1.549529670949281734e-01,
-1.551574457915822769e-01,
-1.553615352842475927e-01,
-1.555652355487359972e-01,
-1.557685465613000420e-01,
-1.559714682986370615e-01,
-1.561740007378849826e-01,
-1.563761438566241557e-01,
-1.565778976328791317e-01,
-1.567792620451144148e-01,
-1.569802370722382934e-01,
-1.571808226936001196e-01,
-1.573810188889912254e-01,
-1.575808256386464767e-01,
-1.577802429232409986e-01,
-1.579792707238923122e-01,
-1.581779090221595296e-01,
-1.583761578000434656e-01,
-1.585740170399867477e-01,
-1.587714867248732897e-01,
-1.589685668380278194e-01,
-1.591652573632189316e-01,
-1.593615582846529266e-01,
-1.595574695869792226e-01,
-1.597529912552892728e-01,
-1.599481232751139570e-01,
-1.601428656324255240e-01,
-1.603372183136378137e-01,
-1.605311813056046200e-01,
-1.607247545956203838e-01,
-1.609179381714217483e-01,
-1.611107320211840888e-01,
-1.613031361335243719e-01,
-1.614951504974994900e-01,
-1.616867751026068445e-01,
-1.618780099387832072e-01,
-1.620688549964072744e-01,
-1.622593102662971964e-01,
-1.624493757397096894e-01,
-1.626390514083432826e-01,
-1.628283372643357096e-01,
-1.630172333002634366e-01,
-1.632057395091444374e-01,
-1.633938558844334477e-01,
-1.635815824200285984e-01,
-1.637689191102637276e-01,
-1.639558659499139037e-01,
-1.641424229341925112e-01,
-1.643285900587533321e-01,
-1.645143673196880207e-01,
-1.646997547135273798e-01,
-1.648847522372405006e-01,
-1.650693598882370661e-01,
-1.652535776643624110e-01,
-1.654374055639045715e-01,
-1.656208435855860139e-01,
-1.658038917285696578e-01,
-1.659865499924557675e-01,
-1.661688183772844218e-01,
-1.663506968835321287e-01,
-1.665321855121134342e-01,
-1.667132842643822555e-01,
-1.668939931421281053e-01,
-1.670743121475806725e-01,
-1.672542412834042702e-01,
-1.674337805527040812e-01,
-1.676129299590202182e-01,
-1.677916895063303881e-01,
-1.679700591990512248e-01,
-1.681480390420339865e-01,
-1.683256290405687194e-01,
-1.685028292003815931e-01,
-1.686796395276361216e-01,
-1.688560600289317204e-01,
-1.690320907113044557e-01,
-1.692077315822282657e-01,
-1.693829826496111302e-01,
-1.695578439217992894e-01,
-1.697323154075744411e-01,
-1.699063971161536291e-01,
-1.700800890571914914e-01,
-1.702533912407766248e-01,
-1.704263036774348039e-01,
-1.705988263781267888e-01,
-1.707709593542490190e-01,
-1.709427026176324194e-01,
-1.711140561805449267e-01,
-1.712850200556885749e-01,
-1.714555942562007995e-01,
-1.716257787956535774e-01,
-1.717955736880537876e-01,
-1.719649789478442381e-01,
-1.721339945898997525e-01,
-1.723026206295328600e-01,
-1.724708570824884379e-01,
-1.726387039649460442e-01,
-1.728061612935189728e-01,
-1.729732290852550036e-01,
-1.731399073576370407e-01,
-1.733061961285795594e-01,
-1.734720954164325757e-01,
-1.736376052399785930e-01,
-1.738027256184341562e-01,
-1.739674565714487697e-01,
-1.741317981191042585e-01,
-1.742957502819189874e-01,
-1.744593130808394232e-01,
-1.746224865372484891e-01,
-1.747852706729615402e-01,
-1.749476655102245315e-01,
-1.751096710717169602e-01,
-1.752712873805515048e-01,
-1.754325144602726372e-01,
-1.755933523348565395e-01,
-1.757538010287111041e-01,
-1.759138605666772104e-01,
-1.760735309740268373e-01,
-1.762328122764637017e-01,
-1.763917045001223149e-01,
-1.765502076715697310e-01,
-1.767083218178031045e-01,
-1.768660469662526047e-01,
-1.770233831447767525e-01,
-1.771803303816665287e-01,
-1.773368887056434862e-01,
-1.774930581458606382e-01,
-1.776488387318992113e-01,
-1.778042304937718643e-01,
-1.779592334619223282e-01,
-1.781138476672236848e-01,
-1.782680731409784503e-01,
-1.784219099149199628e-01,
-1.785753580212107727e-01,
-1.787284174924422819e-01,
-1.788810883616364922e-01,
-1.790333706622442012e-01,
-1.791852644281446416e-01,
-1.793367696936471745e-01,
-1.794878864934894569e-01,
-1.796386148628374979e-01,
-1.797889548372862134e-01,
-1.799389064528601478e-01,
-1.800884697460100325e-01,
-1.802376447536154502e-01,
-1.803864315129858065e-01,
-1.805348300618555279e-01,
-1.806828404383885034e-01,
-1.808304626811760851e-01,
-1.809776968292373667e-01,
-1.811245429220179337e-01,
-1.812710009993897808e-01,
-1.814170711016550308e-01,
-1.815627532695393287e-01,
-1.817080475441973098e-01,
-1.818529539672086581e-01,
-1.819974725805807991e-01,
-1.821416034267462902e-01,
-1.822853465485651803e-01,
-1.824287019893227058e-01,
-1.825716697927295129e-01,
-1.827142500029232397e-01,
-1.828564426644657681e-01,
-1.829982478223454723e-01,
-1.831396655219756919e-01,
-1.832806958091941496e-01,
-1.834213387302641440e-01,
-1.835615943318744947e-01,
-1.837014626611381263e-01,
-1.838409437655914302e-01,
-1.839800376931970127e-01,
-1.841187444923399197e-01,
-1.842570642118310509e-01,
-1.843949969009035239e-01,
-1.845325426092157273e-01,
-1.846697013868486559e-01,
-1.848064732843059388e-01,
-1.849428583525168923e-01,
-1.850788566428330784e-01,
-1.852144682070268056e-01,
-1.853496930972962642e-01,
-1.854845313662602801e-01,
-1.856189830669618401e-01,
-1.857530482528650106e-01,
-1.858867269778560205e-01,
-1.860200192962433718e-01,
-1.861529252627583120e-01,
-1.862854449325522521e-01,
-1.864175783611997372e-01,
-1.865493256046958093e-01,
-1.866806867194556740e-01,
-1.868116617623178100e-01,
-1.869422507905406095e-01,
-1.870724538618029897e-01,
-1.872022710342035323e-01,
-1.873317023662633418e-01,
-1.874607479169228264e-01,
-1.875894077455412812e-01,
-1.877176819118991369e-01,
-1.878455704761976264e-01,
-1.879730734990543717e-01,
-1.881001910415088796e-01,
-1.882269231650205432e-01,
-1.883532699314647840e-01,
-1.884792314031395188e-01,
-1.886048076427576936e-01,
-1.887299987134540558e-01,
-1.888548046787796031e-01,
-1.889792256027053030e-01,
-1.891032615496187896e-01,
-1.892269125843249744e-01,
-1.893501787720487106e-01,
-1.894730601784311297e-01,
-1.895955568695301963e-01,
-1.897176689118214021e-01,
-1.898393963721980715e-01,
-1.899607393179685577e-01,
-1.900816978168611004e-01,
-1.902022719370168313e-01,
-1.903224617469949365e-01,
-1.904422673157707413e-01,
-1.905616887127344894e-01,
-1.906807260076944788e-01,
-1.907993792708714276e-01,
-1.909176485729043582e-01,
-1.910355339848464618e-01,
-1.911530355781642099e-01,
-1.912701534247422119e-01,
-1.913868875968779693e-01,
-1.915032381672829576e-01,
-1.916192052090839038e-01,
-1.917347887958212038e-01,
-1.918499890014503939e-01,
-1.919648059003390139e-01,
-1.920792395672697717e-01,
-1.921932900774375452e-01,
-1.923069575064510484e-01,
-1.924202419303318035e-01,
-1.925331434255149743e-01,
-1.926456620688472565e-01,
-1.927577979375890704e-01,
-1.928695511094117854e-01,
-1.929809216623988577e-01,
-1.930919096750482733e-01,
-1.932025152262666357e-01,
-1.933127383953724132e-01,
-1.934225792620984929e-01,
-1.935320379065846863e-01,
-1.936411144093852787e-01,
-1.937498088514631456e-01,
-1.938581213141932214e-01,
-1.939660518793587252e-01,
-1.940736006291561844e-01,
-1.941807676461894672e-01,
-1.942875530134741402e-01,
-1.943939568144330554e-01,
-1.944999791329013183e-01,
-1.946056200531222080e-01,
-1.947108796597464553e-01,
-1.948157580378360731e-01,
-1.949202552728600546e-01,
-1.950243714506965931e-01,
-1.951281066576325274e-01,
-1.952314609803610101e-01,
-1.953344345059856713e-01,
-1.954370273220161491e-01,
-1.955392395163689234e-01,
-1.956410711773697020e-01,
-1.957425223937498127e-01,
-1.958435932546477298e-01,
-1.959442838496086858e-01,
-1.960445942685852538e-01,
-1.961445246019340727e-01,
-1.962440749404205098e-01,
-1.963432453752139428e-01,
-1.964420359978902852e-01,
-1.965404469004307930e-01,
-1.966384781752214816e-01,
-1.967361299150535425e-01,
-1.968334022131235095e-01,
-1.969302951630320098e-01,
-1.970268088587853461e-01,
-1.971229433947912224e-01,
-1.972186988658648499e-01,
-1.973140753672230352e-01,
-1.974090729944866507e-01,
-1.975036918436801348e-01,
-1.975979320112310200e-01,
-1.976917935939706550e-01,
-1.977852766891315672e-01,
-1.978783813943497116e-01,
-1.979711078076634156e-01,
-1.980634560275129075e-01,
-1.981554261527404825e-01,
-1.982470182825912253e-01,
-1.983382325167095672e-01,
-1.984290689551417020e-01,
-1.985195276983372503e-01,
-1.986096088471439036e-01,
-1.986993125028113927e-01,
-1.987886387669899890e-01,
-1.988775877417285343e-01,
-1.989661595294779373e-01,
-1.990543542330885651e-01,
-1.991421719558086612e-01,
-1.992296128012882583e-01,
-1.993166768735747385e-01,
-1.994033642771148862e-01,
-1.994896751167542504e-01,
-1.995756094977370887e-01,
-1.996611675257054241e-01,
-1.997463493067005713e-01,
-1.998311549471592230e-01,
-1.999155845539179188e-01,
-1.999996382342104084e-01,
-2.000833160956657364e-01,
-2.001666182463126276e-01,
-2.002495447945743801e-01,
-2.003320958492706416e-01,
-2.004142715196198521e-01,
-2.004960719152339976e-01,
-2.005774971461216361e-01,
-2.006585473226870642e-01,
-2.007392225557299292e-01,
-2.008195229564442852e-01,
-2.008994486364219789e-01,
-2.009789997076454060e-01,
-2.010581762824937280e-01,
-2.011369784737403466e-01,
-2.012154063945523486e-01,
-2.012934601584906724e-01,
-2.013711398795095808e-01,
-2.014484456719577987e-01,
-2.015253776505746552e-01,
-2.016019359304946912e-01,
-2.016781206272443006e-01,
-2.017539318567422302e-01,
-2.018293697352995797e-01,
-2.019044343796192464e-01,
-2.019791259067957034e-01,
-2.020534444343158320e-01,
-2.021273900800557299e-01,
-2.022009629622844029e-01,
-2.022741631996609613e-01,
-2.023469909112353138e-01,
-2.024194462164470576e-01,
-2.024915292351266438e-01,
-2.025632400874940175e-01,
-2.026345788941577575e-01,
-2.027055457761183510e-01,
-2.027761408547630317e-01,
-2.028463642518686660e-01,
-2.029162160896001987e-01,
-2.029856964905131234e-01,
-2.030548055775486804e-01,
-2.031235434740363555e-01,
-2.031919103036946284e-01,
-2.032599061906295856e-01,
-2.033275312593321171e-01,
-2.033947856346823568e-01,
-2.034616694419466298e-01,
-2.035281828067773968e-01,
-2.035943258552137813e-01,
-2.036600987136805430e-01,
-2.037255015089877164e-01,
-2.037905343683329984e-01,
-2.038551974192970018e-01,
-2.039194907898456699e-01,
-2.039834146083308875e-01,
-2.040469690034884265e-01,
-2.041101541044386958e-01,
-2.041729700406856585e-01,
-2.042354169421172483e-01,
-2.042974949390050921e-01,
-2.043592041620033162e-01,
-2.044205447421506283e-01,
-2.044815168108681525e-01,
-2.045421204999580134e-01,
-2.046023559416063065e-01,
-2.046622232683808496e-01,
-2.047217226132302392e-01,
-2.047808541094869039e-01,
-2.048396178908618859e-01,
-2.048980140914491432e-01,
-2.049560428457229133e-01,
-2.050137042885379068e-01,
-2.050709985551291969e-01,
-2.051279257811112200e-01,
-2.051844861024794409e-01,
-2.052406796556084656e-01,
-2.052965065772518471e-01,
-2.053519670045422518e-01,
-2.054070610749914871e-01,
-2.054617889264886699e-01,
-2.055161506973029462e-01,
-2.055701465260805216e-01,
-2.056237765518454663e-01,
-2.056770409139993538e-01,
-2.057299397523202622e-01,
-2.057824732069647444e-01,
-2.058346414184651918e-01,
-2.058864445277298061e-01,
-2.059378826760452919e-01,
-2.059889560050711943e-01,
-2.060396646568449508e-01,
-2.060900087737788933e-01,
-2.061399884986596653e-01,
-2.061896039746506926e-01,
-2.062388553452868534e-01,
-2.062877427544816122e-01,
-2.063362663465193592e-01,
-2.063844262660587403e-01,
-2.064322226581331576e-01,
-2.064796556681488815e-01,
-2.065267254418840515e-01,
-2.065734321254913686e-01,
-2.066197758654955141e-01,
-2.066657568087929830e-01,
-2.067113751026517510e-01,
-2.067566308947129672e-01,
-2.068015243329885955e-01,
-2.068460555658607480e-01,
-2.068902247420844054e-01,
-2.069340320107840026e-01,
-2.069774775214545670e-01,
-2.070205614239605529e-01,
-2.070632838685375343e-01,
-2.071056450057901788e-01,
-2.071476449866916925e-01,
-2.071892839625854577e-01,
-2.072305620851824515e-01,
-2.072714795065643267e-01,
-2.073120363791780274e-01,
-2.073522328558396743e-01,
-2.073920690897347596e-01,
-2.074315452344132893e-01,
-2.074706614437935304e-01,
-2.075094178721625382e-01,
-2.075478146741705499e-01,
-2.075858520048367017e-01,
-2.076235300195436728e-01,
-2.076608488740437353e-01,
-2.076978087244515936e-01,
-2.077344097272471046e-01,
-2.077706520392767209e-01,
-2.078065358177499655e-01,
-2.078420612202420414e-01,
-2.078772284046916663e-01,
-2.079120375294006839e-01,
-2.079464887530358408e-01,
-2.079805822346257604e-01,
-2.080143181335633307e-01,
-2.080476966096034830e-01,
-2.080807178228636645e-01,
-2.081133819338218394e-01,
-2.081456891033209022e-01,
-2.081776394925644036e-01,
-2.082092332631143017e-01,
-2.082404705768981235e-01,
-2.082713515961994721e-01,
-2.083018764836662429e-01,
-2.083320454023048773e-01,
-2.083618585154817515e-01,
-2.083913159869221210e-01,
-2.084204179807111756e-01,
-2.084491646612947058e-01,
-2.084775561934734678e-01,
-2.085055927424111777e-01,
-2.085332744736250465e-01,
-2.085606015529949397e-01,
-2.085875741467535516e-01,
-2.086141924214954535e-01,
-2.086404565441685177e-01,
-2.086663666820795238e-01,
-2.086919230028902450e-01,
-2.087171256746191417e-01,
-2.087419748656416940e-01,
-2.087664707446869605e-01,
-2.087906134808410474e-01,
-2.088144032435443331e-01,
-2.088378402025907743e-01,
-2.088609245281305982e-01,
-2.088836563906665555e-01,
-2.089060359610557527e-01,
-2.089280634105099843e-01,
-2.089497389105929304e-01,
-2.089710626332210164e-01,
-2.089920347506637743e-01,
-2.090126554355437039e-01,
-2.090329248608347457e-01,
-2.090528431998621428e-01,
-2.090724106263028015e-01,
-2.090916273141851245e-01,
-2.091104934378898161e-01,
-2.091290091721450251e-01,
-2.091471746920308961e-01,
-2.091649901729782657e-01,
-2.091824557907651094e-01,
-2.091995717215228423e-01,
-2.092163381417279366e-01,
-2.092327552282081948e-01,
-2.092488231581375591e-01,
-2.092645421090410240e-01,
-2.092799122587900018e-01,
-2.092949337856027936e-01,
-2.093096068680457833e-01,
-2.093239316850328269e-01,
-2.093379084158241421e-01,
-2.093515372400243935e-01,
-2.093648183375875493e-01,
-2.093777518888117195e-01,
-2.093903380743398490e-01,
-2.094025770751607174e-01,
-2.094144690726088276e-01,
-2.094260142483616582e-01,
-2.094372127844415232e-01,
-2.094480648632157382e-01,
-2.094585706673935399e-01,
-2.094687303800290279e-01,
-2.094785441845180285e-01,
-2.094880122645994547e-01,
-2.094971348043558335e-01,
-2.095059119882099474e-01,
-2.095143440009272495e-01,
-2.095224310276153912e-01,
-2.095301732537212802e-01,
-2.095375708650358826e-01,
-2.095446240476873667e-01,
-2.095513329881455999e-01,
-2.095576978732202611e-01,
-2.095637188900616177e-01,
-2.095693962261575560e-01,
-2.095747300693360238e-01,
-2.095797206077640029e-01,
-2.095843680299457334e-01,
-2.095886725247239901e-01,
-2.095926342812803045e-01,
-2.095962534891322171e-01,
-2.095995303381348596e-01,
-2.096024650184802607e-01,
-2.096050577206979570e-01,
-2.096073086356520510e-01,
-2.096092179545432088e-01,
-2.096107858689083836e-01,
-2.096120125706184278e-01,
-2.096128982518798145e-01,
-2.096134431052337488e-01,
-2.096136473235569730e-01,
-2.096135111000559659e-01,
-2.096130346282760737e-01,
-2.096122181020937114e-01,
-2.096110617157176115e-01,
-2.096095656636899340e-01,
-2.096077301408852955e-01,
-2.096055553425103246e-01,
-2.096030414641042450e-01,
-2.096001887015360721e-01,
-2.095969972510070556e-01,
-2.095934673090494860e-01,
-2.095895990725242519e-01,
-2.095853927386253923e-01,
-2.095808485048742675e-01,
-2.095759665691228624e-01,
-2.095707471295527313e-01,
-2.095651903846732222e-01,
-2.095592965333226421e-01,
-2.095530657746669245e-01,
-2.095464983082028221e-01,
-2.095395943337503286e-01,
-2.095323540514602567e-01,
-2.095247776618081870e-01,
-2.095168653655970770e-01,
-2.095086173639561511e-01,
-2.095000338583406785e-01,
-2.094911150505320840e-01,
-2.094818611426349786e-01,
-2.094722723370819606e-01,
-2.094623488366282316e-01,
-2.094520908443534557e-01,
-2.094414985636627036e-01,
-2.094305721982822055e-01,
-2.094193119522644309e-01,
-2.094077180299828145e-01,
-2.093957906361332000e-01,
-2.093835299757370594e-01,
-2.093709362541333052e-01,
-2.093580096769853960e-01,
-2.093447504502775613e-01,
-2.093311587803157736e-01,
-2.093172348737251665e-01,
-2.093029789374514227e-01,
-2.092883911787622175e-01,
-2.092734718052428611e-01,
-2.092582210247987407e-01,
-2.092426390456550434e-01,
-2.092267260763535086e-01,
-2.092104823257563140e-01,
-2.091939080030430498e-01,
-2.091770033177116073e-01,
-2.091597684795752921e-01,
-2.091422036987672095e-01,
-2.091243091857349912e-01,
-2.091060851512433205e-01,
-2.090875318063729893e-01,
-2.090686493625197873e-01,
-2.090494380313976663e-01,
-2.090298980250304695e-01,
-2.090100295557626997e-01,
-2.089898328362481128e-01,
-2.089693080794571556e-01,
-2.089484554986735243e-01,
-2.089272753074940536e-01,
-2.089057677198284946e-01,
-2.088839329499001807e-01,
-2.088617712122425307e-01,
-2.088392827217036007e-01,
-2.088164676934406161e-01,
-2.087933263429239128e-01,
-2.087698588859349946e-01,
-2.087460655385635910e-01,
-2.087219465172127641e-01,
-2.086975020385925805e-01,
-2.086727323197256068e-01,
-2.086476375779405812e-01,
-2.086222180308784091e-01,
-2.085964738964851406e-01,
-2.085704053930176882e-01,
-2.085440127390398857e-01,
-2.085172961534237923e-01,
-2.084902558553468066e-01,
-2.084628920642947192e-01,
-2.084352050000596035e-01,
-2.084071948827402321e-01,
-2.083788619327389957e-01,
-2.083502063707660390e-01,
-2.083212284178357077e-01,
-2.082919282952672146e-01,
-2.082623062246841406e-01,
-2.082323624280141561e-01,
-2.082020971274886889e-01,
-2.081715105456418968e-01,
-2.081406029053129159e-01,
-2.081093744296408921e-01,
-2.080778253420699497e-01,
-2.080459558663434461e-01,
-2.080137662265086340e-01,
-2.079812566469138591e-01,
-2.079484273522063109e-01,
-2.079152785673358261e-01,
-2.078818105175521680e-01,
-2.078480234284043882e-01,
-2.078139175257407156e-01,
-2.077794930357105829e-01,
-2.077447501847593525e-01,
-2.077096891996332018e-01,
-2.076743103073761532e-01,
-2.076386137353281036e-01,
-2.076025997111284327e-01,
-2.075662684627126164e-01,
-2.075296202183125049e-01,
-2.074926552064582097e-01,
-2.074553736559729966e-01,
-2.074177757959780877e-01,
-2.073798618558899409e-01,
-2.073416320654166700e-01,
-2.073030866545660100e-01,
-2.072642258536363247e-01,
-2.072250498932203810e-01,
-2.071855590042063211e-01,
-2.071457534177726933e-01,
-2.071056333653928938e-01,
-2.070651990788314190e-01,
-2.070244507901468911e-01,
-2.069833887316869514e-01,
-2.069420131360925064e-01,
-2.069003242362950634e-01,
-2.068583222655165366e-01,
-2.068160074572684692e-01,
-2.067733800453544490e-01,
-2.067304402638650285e-01,
-2.066871883471817217e-01,
-2.066436245299735908e-01,
-2.065997490472005482e-01,
-2.065555621341075565e-01,
-2.065110640262295960e-01,
-2.064662549593881402e-01,
-2.064211351696912944e-01,
-2.063757048935355443e-01,
-2.063299643676014816e-01,
-2.062839138288571905e-01,
-2.062375535145553329e-01,
-2.061908836622348695e-01,
-2.061439045097191447e-01,
-2.060966162951159975e-01,
-2.060490192568167067e-01,
-2.060011136334976289e-01,
-2.059528996641185883e-01,
-2.059043775879195737e-01,
-2.058555476444268173e-01,
-2.058064100734482982e-01,
-2.057569651150709944e-01,
-2.057072130096674889e-01,
-2.056571539978884200e-01,
-2.056067883206673941e-01,
-2.055561162192165170e-01,
-2.055051379350308072e-01,
-2.054538537098818951e-01,
-2.054022637858222700e-01,
-2.053503684051846967e-01,
-2.052981678105771646e-01,
-2.052456622448902701e-01,
-2.051928519512893623e-01,
-2.051397371732179009e-01,
-2.050863181543966518e-01,
-2.050325951388239920e-01,
-2.049785683707742723e-01,
-2.049242380947976783e-01,
-2.048696045557195089e-01,
-2.048146679986415919e-01,
-2.047594286689395082e-01,
-2.047038868122654509e-01,
-2.046480426745422021e-01,
-2.045918965019705993e-01,
-2.045354485410215972e-01,
-2.044786990384411807e-01,
-2.044216482412466174e-01,
-2.043642963967290671e-01,
-2.043066437524500567e-01,
-2.042486905562442279e-01,
-2.041904370562167559e-01,
-2.041318835007429056e-01,
-2.040730301384698353e-01,
-2.040138772183138494e-01,
-2.039544249894600370e-01,
-2.038946737013661026e-01,
-2.038346236037557602e-01,
-2.037742749466208703e-01,
-2.037136279802247707e-01,
-2.036526829550944773e-01,
-2.035914401220290937e-01,
-2.035298997320905412e-01,
-2.034680620366102755e-01,
-2.034059272871841795e-01,
-2.033434957356757833e-01,
-2.032807676342126280e-01,
-2.032177432351889579e-01,
-2.031544227912623624e-01,
-2.030908065553562458e-01,
-2.030268947806569690e-01,
-2.029626877206153757e-01,
-2.028981856289447105e-01,
-2.028333887596224516e-01,
-2.027682973668877286e-01,
-2.027029117052414897e-01,
-2.026372320294465568e-01,
-2.025712585945285138e-01,
-2.025049916557729868e-01,
-2.024384314687255326e-01,
-2.023715782891924442e-01,
-2.023044323732410554e-01,
-2.022369939771970770e-01,
-2.021692633576441522e-01,
-2.021012407714281034e-01,
-2.020329264756497711e-01,
-2.019643207276688168e-01,
-2.018954237851038613e-01,
-2.018262359058287658e-01,
-2.017567573479760734e-01,
-2.016869883699330679e-01,
-2.016169292303435223e-01,
-2.015465801881089480e-01,
-2.014759415023820444e-01,
-2.014050134325743313e-01,
-2.013337962383492941e-01,
-2.012622901796261021e-01,
-2.011904955165766118e-01,
-2.011184125096268649e-01,
-2.010460414194546463e-01,
-2.009733825069913438e-01,
-2.009004360334209205e-01,
-2.008272022601784168e-01,
-2.007536814489494781e-01,
-2.006798738616720201e-01,
-2.006057797605339532e-01,
-2.005313994079746254e-01,
-2.004567330666814917e-01,
-2.003817809995929733e-01,
-2.003065434698954317e-01,
-2.002310207410242793e-01,
-2.001552130766639515e-01,
-2.000791207407464078e-01,
-2.000027439974494947e-01,
-1.999260831112010806e-01,
-1.998491383466735327e-01,
-1.997719099687864930e-01,
-1.996943982427066833e-01,
-1.996166034338433537e-01,
-1.995385258078540003e-01,
-1.994601656306390081e-01,
-1.993815231683437605e-01,
-1.993025986873576683e-01,
-1.992233924543147239e-01,
-1.991439047360911707e-01,
-1.990641357998046423e-01,
-1.989840859128188255e-01,
-1.989037553427352167e-01,
-1.988231443573998947e-01,
-1.987422532249001339e-01,
-1.986610822135624066e-01,
-1.985796315919554078e-01,
-1.984979016288865028e-01,
-1.984158925934031703e-01,
-1.983336047547923919e-01,
-1.982510383825805966e-01,
-1.981681937465309962e-01,
-1.980850711166471656e-01,
-1.980016707631692130e-01,
-1.979179929565738905e-01,
-1.978340379675757044e-01,
-1.977498060671256108e-01,
-1.976652975264104328e-01,
-1.975805126168537207e-01,
-1.974954516101127266e-01,
-1.974101147780805421e-01,
-1.973245023928854591e-01,
-1.972386147268878065e-01,
-1.971524520526843072e-01,
-1.970660146431031379e-01,
-1.969793027712066213e-01,
-1.968923167102877014e-01,
-1.968050567338742174e-01,
-1.967175231157235471e-01,
-1.966297161298254659e-01,
-1.965416360504008975e-01,
-1.964532831518996381e-01,
-1.963646577090042145e-01,
-1.962757599966250543e-01,
-1.961865902899020686e-01,
-1.960971488642057614e-01,
-1.960074359951327894e-01,
-1.959174519585086538e-01,
-1.958271970303883946e-01,
-1.957366714870525382e-01,
-1.956458756050095671e-01,
-1.955548096609929232e-01,
-1.954634739319644487e-01,
-1.953718686951102235e-01,
-1.952799942278411749e-01,
-1.951878508077954377e-01,
-1.950954387128345235e-01,
-1.950027582210422661e-01,
-1.949098096107292066e-01,
-1.948165931604267098e-01,
-1.947231091488913768e-01,
-1.946293578550997716e-01,
-1.945353395582533895e-01,
-1.944410545377733279e-01,
-1.943465030733033949e-01,
-1.942516854447061403e-01,
-1.941566019320668801e-01,
-1.940612528156909766e-01,
-1.939656383761017011e-01,
-1.938697588940422323e-01,
-1.937736146504763779e-01,
-1.936772059265844947e-01,
-1.935805330037654592e-01,
-1.934835961636359458e-01,
-1.933863956880299828e-01,
-1.932889318589982863e-01,
-1.931912049588082325e-01,
-1.930932152699430526e-01,
-1.929949630751023326e-01,
-1.928964486571989601e-01,
-1.927976722993630654e-01,
-1.926986342849368039e-01,
-1.925993348974789632e-01,
-1.924997744207590789e-01,
-1.923999531387626249e-01,
-1.922998713356860734e-01,
-1.921995292959385593e-01,
-1.920989273041407985e-01,
-1.919980656451269196e-01,
-1.918969446039396898e-01,
-1.917955644658350112e-01,
-1.916939255162773692e-01,
-1.915920280409414977e-01,
-1.914898723257115742e-01,
-1.913874586566822744e-01,
-1.912847873201552751e-01,
-1.911818586026410582e-01,
-1.910786727908573568e-01,
-1.909752301717313472e-01,
-1.908715310323946812e-01,
-1.907675756601882322e-01,
-1.906633643426570157e-01,
-1.905588973675520215e-01,
-1.904541750228314900e-01,
-1.903491975966567773e-01,
-1.902439653773929928e-01,
-1.901384786536136628e-01,
-1.900327377140918206e-01,
-1.899267428478045860e-01,
-1.898204943439334158e-01,
-1.897139924918615217e-01,
-1.896072375811742039e-01,
-1.895002299016586844e-01,
-1.893929697433029413e-01,
-1.892854573962964304e-01,
-1.891776931510278925e-01,
-1.890696772980886287e-01,
-1.889614101282662550e-01,
-1.888528919325507538e-01,
-1.887441230021280614e-01,
-1.886351036283848981e-01,
-1.885258341029040219e-01,
-1.884163147174668929e-01,
-1.883065457640513418e-01,
-1.881965275348336242e-01,
-1.880862603221842566e-01,
-1.879757444186700710e-01,
-1.878649801170547973e-01,
-1.877539677102949833e-01,
-1.876427074915436588e-01,
-1.875311997541474485e-01,
-1.874194447916466000e-01,
-1.873074428977742900e-01,
-1.871951943664587337e-01,
-1.870826994918179387e-01,
-1.869699585681645349e-01,
-1.868569718900004173e-01,
-1.867437397520200770e-01,
-1.866302624491102680e-01,
-1.865165402763462876e-01,
-1.864025735289931429e-01,
-1.862883625025071599e-01,
-1.861739074925330972e-01,
-1.860592087949038131e-01,
-1.859442667056425691e-01,
-1.858290815209579505e-01,
-1.857136535372480302e-01,
-1.855979830510974538e-01,
-1.854820703592767461e-01,
-1.853659157587446982e-01,
-1.852495195466436206e-01,
-1.851328820203028691e-01,
-1.850160034772365125e-01,
-1.848988842151422229e-01,
-1.847815245319034405e-01,
-1.846639247255865701e-01,
-1.845460850944413977e-01,
-1.844280059369007574e-01,
-1.843096875515791433e-01,
-1.841911302372745141e-01,
-1.840723342929652673e-01,
-1.839533000178130151e-01,
-1.838340277111574494e-01,
-1.837145176725205886e-01,
-1.835947702016038907e-01,
-1.834747855982877540e-01,
-1.833545641626329881e-01,
-1.832341061948783989e-01,
-1.831134119954405115e-01,
-1.829924818649149021e-01,
-1.828713161040748381e-01,
-1.827499150138676143e-01,
-1.826282788954208813e-01,
-1.825064080500368169e-01,
-1.823843027791933746e-01,
-1.822619633845433962e-01,
-1.821393901679155825e-01,
-1.820165834313123843e-01,
-1.818935434769110848e-01,
-1.817702706070622176e-01,
-1.816467651242893999e-01,
-1.815230273312885556e-01,
-1.813990575309289144e-01,
-1.812748560262517628e-01,
-1.811504231204684456e-01,
-1.810257591169625313e-01,
-1.809008643192893118e-01,
-1.807757390311719170e-01,
-1.806503835565044791e-01,
-1.805247981993518824e-01,
-1.803989832639452673e-01,
-1.802729390546859711e-01,
-1.801466658761438078e-01,
-1.800201640330552910e-01,
-1.798934338303244951e-01,
-1.797664755730228880e-01,
-1.796392895663878331e-01,
-1.795118761158225051e-01,
-1.793842355268953914e-01,
-1.792563681053422897e-01,
-1.791282741570601189e-01,
-1.789999539881140800e-01,
-1.788714079047296901e-01,
-1.787426362132982227e-01,
-1.786136392203726553e-01,
-1.784844172326685852e-01,
-1.783549705570662280e-01,
-1.782252995006031182e-01,
-1.780954043704826295e-01,
-1.779652854740649548e-01,
-1.778349431188739060e-01,
-1.777043776125921959e-01,
-1.775735892630619650e-01,
-1.774425783782840327e-01,
-1.773113452664190626e-01,
-1.771798902357842320e-01,
-1.770482135948577840e-01,
-1.769163156522721714e-01,
-1.767841967168181927e-01,
-1.766518570974439095e-01,
-1.765192971032525926e-01,
-1.763865170435031937e-01,
-1.762535172276103179e-01,
-1.761202979651437239e-01,
-1.759868595658277135e-01,
-1.758532023395388277e-01,
-1.757193265963104822e-01,
-1.755852326463253898e-01,
-1.754509207999231379e-01,
-1.753163913675919172e-01,
-1.751816446599736010e-01,
-1.750466809878611085e-01,
-1.749115006621998758e-01,
-1.747761039940825545e-01,
-1.746404912947551735e-01,
-1.745046628756119211e-01,
-1.743686190481970599e-01,
-1.742323601242028175e-01,
-1.740958864154705521e-01,
-1.739591982339893372e-01,
-1.738222958918961836e-01,
-1.736851797014743737e-01,
-1.735478499751545167e-01,
-1.734103070255139378e-01,
-1.732725511652748462e-01,
-1.731345827073053623e-01,
-1.729964019646192674e-01,
-1.728580092503733956e-01,
-1.727194048778702695e-01,
-1.725805891605546316e-01,
-1.724415624120157753e-01,
-1.723023249459843254e-01,
-1.721628770763358462e-01,
-1.720232191170843472e-01,
-1.718833513823886661e-01,
-1.717432741865465851e-01,
-1.716029878439979950e-01,
-1.714624926693217311e-01,
-1.713217889772370439e-01,
-1.711808770826030446e-01,
-1.710397573004163452e-01,
-1.708984299458144451e-01,
-1.707568953340704021e-01,
-1.706151537805955243e-01,
-1.704732056009405639e-01,
-1.703310511107892777e-01,
-1.701886906259650889e-01,
-1.700461244624251467e-01,
-1.699033529362632966e-01,
-1.697603763637084984e-01,
-1.696171950611230772e-01,
-1.694738093450045002e-01,
-1.693302195319841830e-01,
-1.691864259388261849e-01,
-1.690424288824274035e-01,
-1.688982286798174637e-01,
-1.687538256481587173e-01,
-1.686092201047436900e-01,
-1.684644123669973570e-01,
-1.683194027524735625e-01,
-1.681741915788582120e-01,
-1.680287791639674677e-01,
-1.678831658257438353e-01,
-1.677373518822626308e-01,
-1.675913376517245423e-01,
-1.674451234524606813e-01,
-1.672987096029290022e-01,
-1.671520964217130811e-01,
-1.670052842275252525e-01,
-1.668582733392049433e-01,
-1.667110640757144824e-01,
-1.665636567561440406e-01,
-1.664160516997080785e-01,
-1.662682492257462619e-01,
-1.661202496537210194e-01,
-1.659720533032206236e-01,
-1.658236604939548053e-01,
-1.656750715457572798e-01,
-1.655262867785829706e-01,
-1.653773065125105357e-01,
-1.652281310677387038e-01,
-1.650787607645879396e-01,
-1.649291959234993055e-01,
-1.647794368650342955e-01,
-1.646294839098746410e-01,
-1.644793373788195623e-01,
-1.643289975927897106e-01,
-1.641784648728227824e-01,
-1.640277395400748239e-01,
-1.638768219158196482e-01,
-1.637257123214484467e-01,
-1.635744110784681793e-01,
-1.634229185085030456e-01,
-1.632712349332939572e-01,
-1.631193606746954572e-01,
-1.629672960546781346e-01,
-1.628150413953268483e-01,
-1.626625970188407266e-01,
-1.625099632475327793e-01,
-1.623571404038288979e-01,
-1.622041288102682444e-01,
-1.620509287895026129e-01,
-1.618975406642947645e-01,
-1.617439647575190376e-01,
-1.615902013921623470e-01,
-1.614362508913202987e-01,
-1.612821135782007698e-01,
-1.611277897761197453e-01,
-1.609732798085030114e-01,
-1.608185839988854615e-01,
-1.606637026709103466e-01,
-1.605086361483291368e-01,
-1.603533847550003832e-01,
-1.601979488148902175e-01,
-1.600423286520714361e-01,
-1.598865245907229449e-01,
-1.597305369551298981e-01,
-1.595743660696821997e-01,
-1.594180122588749748e-01,
-1.592614758473089032e-01,
-1.591047571596863608e-01,
-1.589478565208155281e-01,
-1.587907742556075308e-01,
-1.586335106890742752e-01,
-1.584760661463331388e-01,
-1.583184409526016689e-01,
-1.581606354331979991e-01,
-1.580026499135427642e-01,
-1.578444847191567690e-01,
-1.576861401756609327e-01,
-1.575276166087757057e-01,
-1.573689143443207372e-01,
-1.572100337082149579e-01,
-1.570509750264748317e-01,
-1.568917386252170476e-01,
-1.567323248306517203e-01,
-1.565727339690896058e-01,
-1.564129663669374115e-01,
-1.562530223506972404e-01,
-1.560929022469664251e-01,
-1.559326063824396369e-01,
-1.557721350839042229e-01,
-1.556114886782433426e-01,
-1.554506674924340248e-01,
-1.552896718535464460e-01,
-1.551285020887442079e-01,
-1.549671585252834216e-01,
-1.548056414905121247e-01,
-1.546439513118711973e-01,
-1.544820883168915582e-01,
-1.543200528331966637e-01,
-1.541578451884986767e-01,
-1.539954657106007430e-01,
-1.538329147273957975e-01,
-1.536701925668655377e-01,
-1.535072995570803955e-01,
-1.533442360261999260e-01,
-1.531810023024700040e-01,
-1.530175987142251282e-01,
-1.528540255898865052e-01,
-1.526902832579618285e-01,
-1.525263720470449169e-01,
-1.523622922858144657e-01,
-1.521980443030357955e-01,
-1.520336284275588812e-01,
-1.518690449883162985e-01,
-1.517042943143261935e-01,
-1.515393767346894516e-01,
-1.513742925785909466e-01,
-1.512090421752966818e-01,
-1.510436258541556775e-01,
-1.508780439445982779e-01,
-1.507122967761373444e-01,
-1.505463846783644255e-01,
-1.503803079809537535e-01,
-1.502140670136565548e-01,
-1.500476621063069060e-01,
-1.498810935888157392e-01,
-1.497143617911740332e-01,
-1.495474670434490672e-01,
-1.493804096757871680e-01,
-1.492131900184126836e-01,
-1.490458084016249574e-01,
-1.488782651558015202e-01,
-1.487105606113948431e-01,
-1.485426950989327533e-01,
-1.483746689490192672e-01,
-1.482064824923324531e-01,
-1.480381360596242091e-01,
-1.478696299817209847e-01,
-1.477009645895225320e-01,
-1.475321402140009619e-01,
-1.473631571862009659e-01,
-1.471940158372395668e-01,
-1.470247164983054800e-01,
-1.468552595006584471e-01,
-1.466856451756282653e-01,
-1.465158738546155637e-01,
-1.463459458690918591e-01,
-1.461758615505958647e-01,
-1.460056212307372370e-01,
-1.458352252411933836e-01,
-1.456646739137089364e-01,
-1.454939675800970833e-01,
-1.453231065722392912e-01,
-1.451520912220814752e-01,
-1.449809218616375239e-01,
-1.448095988229862185e-01,
-1.446381224382728425e-01,
-1.444664930397069336e-01,
-1.442947109595623945e-01,
-1.441227765301779928e-01,
-1.439506900839555292e-01,
-1.437784519533605310e-01,
-1.436060624709215583e-01,
-1.434335219692280949e-01,
-1.432608307809333237e-01,
-1.430879892387511010e-01,
-1.429149976754560125e-01,
-1.427418564238842336e-01,
-1.425685658169306147e-01,
-1.423951261875513741e-01,
-1.422215378687605725e-01,
-1.420478011936327778e-01,
-1.418739164952989573e-01,
-1.416998841069500581e-01,
-1.415257043618333155e-01,
-1.413513775932534466e-01,
-1.411769041345707909e-01,
-1.410022843192037800e-01,
-1.408275184806256908e-01,
-1.406526069523646449e-01,
-1.404775500680047196e-01,
-1.403023481611838097e-01,
-1.401270015655933787e-01,
-1.399515106149791521e-01,
-1.397758756431401461e-01,
-1.396000969839279460e-01,
-1.394241749712454292e-01,
-1.392481099390485422e-01,
-1.390719022213443290e-01,
-1.388955521521904324e-01,
-1.387190600656953987e-01,
-1.385424262960177344e-01,
-1.383656511773649067e-01,
-1.381887350439944817e-01,
-1.380116782302126255e-01,
-1.378344810703737988e-01,
-1.376571438988791474e-01,
-1.374796670501791940e-01,
-1.373020508587705912e-01,
-1.371242956591960938e-01,
-1.369464017860454463e-01,
-1.367683695739532468e-01,
-1.365901993575995288e-01,
-1.364118914717097897e-01,
-1.362334462510535749e-01,
-1.360548640304431456e-01,
-1.358761451447368096e-01,
-1.356972899288331758e-01,
-1.355182987176752341e-01,
-1.353391718462478022e-01,
-1.351599096495768870e-01,
-1.349805124627303510e-01,
-1.348009806208163852e-01,
-1.346213144589845090e-01,
-1.344415143124237932e-01,
-1.342615805163616116e-01,
-1.340815134060667768e-01,
-1.339013133168453773e-01,
-1.337209805840413879e-01,
-1.335405155430373081e-01,
-1.333599185292530520e-01,
-1.331791898781449213e-01,
-1.329983299252057993e-01,
-1.328173390059649017e-01,
-1.326362174559877760e-01,
-1.324549656108729712e-01,
-1.322735838062555069e-01,
-1.320920723778052364e-01,
-1.319104316612234595e-01,
-1.317286619922470037e-01,
-1.315467637066456419e-01,
-1.313647371402194008e-01,
-1.311825826288037233e-01,
-1.310003005082633898e-01,
-1.308178911144951551e-01,
-1.306353547834266660e-01,
-1.304526918510150457e-01,
-1.302699026532493920e-01,
-1.300869875261456143e-01,
-1.299039468057504032e-01,
-1.297207808281391206e-01,
-1.295374899294144677e-01,
-1.293540744457072067e-01,
-1.291705347131759107e-01,
-1.289868710680050767e-01,
-1.288030838464062633e-01,
-1.286191733846170915e-01,
-1.284351400188998293e-01,
-1.282509840855431682e-01,
-1.280667059208595304e-01,
-1.278823058611864849e-01,
-1.276977842428837495e-01,
-1.275131414023366605e-01,
-1.273283776759514263e-01,
-1.271434934001578754e-01,
-1.269584889114078463e-01,
-1.267733645461749936e-01,
-1.265881206409531778e-01,
-1.264027575322578256e-01,
-1.262172755566244031e-01,
-1.260316750506087213e-01,
-1.258459563507851875e-01,
-1.256601197937481929e-01,
-1.254741657161099477e-01,
-1.252880944545010644e-01,
-1.251019063455699742e-01,
-1.249156017259826362e-01,
-1.247291809324206635e-01,
-1.245426443015836965e-01,
-1.243559921701863635e-01,
-1.241692248749588778e-01,
-1.239823427526465099e-01,
-1.237953461400096988e-01,
-1.236082353738227196e-01,
-1.234210107908741832e-01,
-1.232336727279649685e-01,
-1.230462215219091521e-01,
-1.228586575095344940e-01,
-1.226709810276796486e-01,
-1.224831924131958294e-01,
-1.222952920029434926e-01,
-1.221072801337958896e-01,
-1.219191571426358617e-01,
-1.217309233663565471e-01,
-1.215425791418593415e-01,
-1.213541248060562572e-01,
-1.211655606958662451e-01,
-1.209768871482181235e-01,
-1.207881045000471637e-01,
-1.205992130882963392e-01,
-1.204102132499153682e-01,
-1.202211053218601305e-01,
-1.200318896410942221e-01,
-1.198425665445836813e-01,
-1.196531363693022071e-01,
-1.194635994522273287e-01,
-1.192739561303409190e-01,
-1.190842067406283483e-01,
-1.188943516200791362e-01,
-1.187043911056840373e-01,
-1.185143255344392466e-01,
-1.183241552433403621e-01,
-1.181338805693855770e-01,
-1.179435018495746113e-01,
-1.177530194209076841e-01,
-1.175624336203857784e-01,
-1.173717447850087109e-01,
-1.171809532517768121e-01,
-1.169900593576893577e-01,
-1.167990634397443744e-01,
-1.166079658349371273e-01,
-1.164167668802616046e-01,
-1.162254669127090190e-01,
-1.160340662692667807e-01,
-1.158425652869203432e-01,
-1.156509643026495532e-01,
-1.154592636534304273e-01,
-1.152674636762342358e-01,
-1.150755647080276278e-01,
-1.148835670857706881e-01,
-1.146914711464170483e-01,
-1.144992772269152609e-01,
-1.143069856642052740e-01,
-1.141145967952212209e-01,
-1.139221109568884782e-01,
-1.137295284861237349e-01,
-1.135368497198360055e-01,
-1.133440749949242987e-01,
-1.131512046482792827e-01,
-1.129582390167804817e-01,
-1.127651784372971228e-01,
-1.125720232466881077e-01,
-1.123787737818010835e-01,
-1.121854303794717206e-01,
-1.119919933765232967e-01,
-1.117984631097665577e-01,
-1.116048399160004534e-01,
-1.114111241320093620e-01,
-1.112173160945633815e-01,
-1.110234161404193703e-01,
-1.108294246063195460e-01,
-1.106353418289904855e-01,
-1.104411681451431398e-01,
-1.102469038914724447e-01,
-1.100525494046574598e-01,
-1.098581050213600085e-01,
-1.096635710782250944e-01,
-1.094689479118792635e-01,
-1.092742358589311458e-01,
-1.090794352559718294e-01,
-1.088845464395717250e-01,
-1.086895697462831739e-01,
-1.084945055126378816e-01,
-1.082993540751483463e-01,
-1.081041157703054451e-01,
-1.079087909345783636e-01,
-1.077133799044165952e-01,
-1.075178830162460825e-01,
-1.073223006064716184e-01,
-1.071266330114738347e-01,
-1.069308805676109642e-01,
-1.067350436112170092e-01,
-1.065391224786028934e-01,
-1.063431175060542411e-01,
-1.061470290298320435e-01,
-1.059508573861710629e-01,
-1.057546029112814978e-01,
-1.055582659413466518e-01,
-1.053618468125236823e-01,
-1.051653458609414643e-01,
-1.049687634227028793e-01,
-1.047720998338820819e-01,
-1.045753554305246802e-01,
-1.043785305486482629e-01,
-1.041816255242407063e-01,
-1.039846406932600359e-01,
-1.037875763916349531e-01,
-1.035904329552634340e-01,
-1.033932107200115358e-01,
-1.031959100217162140e-01,
-1.029985311961799793e-01,
-1.028010745791758523e-01,
-1.026035405064419509e-01,
-1.024059293136845850e-01,
-1.022082413365765913e-01,
-1.020104769107571391e-01,
-1.018126363718308003e-01,
-1.016147200553667307e-01,
-1.014167282969002937e-01,
-1.012186614319301042e-01,
-1.010205197959200135e-01,
-1.008223037242967079e-01,
-1.006240135524497509e-01,
-1.004256496157324846e-01,
-1.002272122494595741e-01,
-1.000287017889083807e-01,
-9.983011856931760242e-02,
-9.963146292588641317e-02,
-9.943273519377508751e-02,
-9.923393570810500053e-02,
-9.903506480395561640e-02,
-9.883612281636654229e-02,
-9.863711008033723693e-02,
-9.843802693082477628e-02,
-9.823887370274436703e-02,
-9.803965073096880534e-02,
-9.784035835032943440e-02,
-9.764099689561263340e-02,
-9.744156670156266242e-02,
-9.724206810287881753e-02,
-9.704250143421730423e-02,
-9.684286703018810116e-02,
-9.664316522535652820e-02,
-9.644339635424269142e-02,
-9.624356075131997035e-02,
-9.604365875101586458e-02,
-9.584369068771034228e-02,
-9.564365689573665896e-02,
-9.544355770937985872e-02,
-9.524339346287727381e-02,
-9.504316449041717851e-02,
-9.484287112613941362e-02,
-9.464251370413397091e-02,
-9.444209255844110418e-02,
-9.424160802305085738e-02,
-9.404106043190271769e-02,
-9.384045011888533794e-02,
-9.363977741783539865e-02,
-9.343904266253766355e-02,
-9.323824618672463260e-02,
-9.303738832407684733e-02,
-9.283646940822060101e-02,
-9.263548977272899332e-02,
-9.243444975112181938e-02,
-9.223334967686300234e-02,
-9.203218988336313300e-02,
-9.183097070397659711e-02,
-9.162969247200287992e-02,
-9.142835552068456773e-02,
-9.122696018320834710e-02,
-9.102550679270413059e-02,
-9.082399568224396036e-02,
-9.062242718484274373e-02,
-9.042080163345675436e-02,
-9.021911936098396534e-02,
-9.001738070026343852e-02,
-8.981558598407449190e-02,
-8.961373554513719919e-02,
-8.941182971611132124e-02,
-8.920986882959570929e-02,
-8.900785321812833273e-02,
-8.880578321418558518e-02,
-8.860365915018164618e-02,
-8.840148135847024358e-02,
-8.819925017133982414e-02,
-8.799696592101770298e-02,
-8.779462893966705206e-02,
-8.759223955938667816e-02,
-8.738979811221124494e-02,
-8.718730493011174476e-02,
-8.698476034499237619e-02,
-8.678216468869301425e-02,
-8.657951829298693447e-02,
-8.637682148958136796e-02,
-8.617407461011614145e-02,
-8.597127798616512051e-02,
-8.576843194923297609e-02,
-8.556553683075746042e-02,
-8.536259296210754743e-02,
-8.515960067458347438e-02,
-8.495656029941607568e-02,
-8.475347216776692172e-02,
-8.455033661072633433e-02,
-8.434715395931584314e-02,
-8.414392454448510472e-02,
-8.394064869711212462e-02,
-8.373732674800424269e-02,
-8.353395902789589877e-02,
-8.333054586744918779e-02,
-8.312708759725340180e-02,
-8.292358454782439159e-02,
-8.272003704960464998e-02,
-8.251644543296181300e-02,
-8.231281002818933989e-02,
-8.210913116550583313e-02,
-8.190540917505424734e-02,
-8.170164438690202813e-02,
-8.149783713103996019e-02,
-8.129398773738299999e-02,
-8.109009653576865206e-02,
-8.088616385595669145e-02,
-8.068219002762949676e-02,
-8.047817538039171714e-02,
-8.027412024376859301e-02,
-8.007002494720624752e-02,
-7.986588982007183923e-02,
-7.966171519165260451e-02,
-7.945750139115538568e-02,
-7.925324874770708905e-02,
-7.904895759035210356e-02,
-7.884462824805488212e-02,
-7.864026104969687458e-02,
-7.843585632407826247e-02,
-7.823141439991584956e-02,
-7.802693560584361698e-02,
-7.782242027041205712e-02,
-7.761786872208781274e-02,
-7.741328128925334395e-02,
-7.720865830020594289e-02,
-7.700400008315884393e-02,
-7.679930696623857300e-02,
-7.659457927748705708e-02,
-7.638981734485844610e-02,
-7.618502149622154163e-02,
-7.598019205935736820e-02,
-7.577532936195949254e-02,
-7.557043373163430111e-02,
-7.536550549589880743e-02,
-7.516054498218195656e-02,
-7.495555251782355655e-02,
-7.475052843007364001e-02,
-7.454547304609325520e-02,
-7.434038669295162105e-02,
-7.413526969762881946e-02,
-7.393012238701295036e-02,
-7.372494508790090884e-02,
-7.351973812699759414e-02,
-7.331450183091571537e-02,
-7.310923652617508373e-02,
-7.290394253920316758e-02,
-7.269862019633287209e-02,
-7.249326982380410733e-02,
-7.228789174776210913e-02,
-7.208248629425723086e-02,
-7.187705378924572064e-02,
-7.167159455858694572e-02,
-7.146610892804568238e-02,
-7.126059722328967339e-02,
-7.105505976989084926e-02,
-7.084949689332276090e-02,
-7.064390891896261959e-02,
-7.043829617208946514e-02,
-7.023265897788422141e-02,
-7.002699766142923832e-02,
-6.982131254770723716e-02,
-6.961560396160194897e-02,
-6.940987222789785083e-02,
-6.920411767127843117e-02,
-6.899834061632650895e-02,
-6.879254138752483039e-02,
-6.858672030925364038e-02,
-6.838087770579218128e-02,
-6.817501390131743000e-02,
-6.796912921990312662e-02,
-6.776322398552091231e-02,
-6.755729852203894159e-02,
-6.735135315322141047e-02,
-6.714538820272786257e-02,
-6.693940399411416053e-02,
-6.673340085083087625e-02,
-6.652737909622358226e-02,
-6.632133905353193581e-02,
-6.611528104588895727e-02,
-6.590920539632207087e-02,
-6.570311242775152272e-02,
-6.549700246299011708e-02,
-6.529087582474331353e-02,
-6.508473283560797795e-02,
-6.487857381807343726e-02,
-6.467239909451938384e-02,
-6.446620898721637516e-02,
-6.426000381832608355e-02,
-6.405378390989927007e-02,
-6.384754958387711676e-02,
-6.364130116208967236e-02,
-6.343503896625569960e-02,
-6.322876331798230054e-02,
-6.302247453876548555e-02,
-6.281617294998861900e-02,
-6.260985887292125351e-02,
-6.240353262872146839e-02,
-6.219719453843282342e-02,
-6.199084492298532340e-02,
-6.178448410319527934e-02,
-6.157811239976322681e-02,
-6.137173013327561211e-02,
-6.116533762420329340e-02,
-6.095893519290113832e-02,
-6.075252315960782273e-02,
-6.054610184444576132e-02,
-6.033967156742009452e-02,
-6.013323264841916038e-02,
-5.992678540721290553e-02,
-5.972033016345368317e-02,
-5.951386723667503875e-02,
-5.930739694629199449e-02,
-5.910091961160039015e-02,
-5.889443555177572426e-02,
-5.868794508587413944e-02,
-5.848144853283163136e-02,
-5.827494621146264014e-02,
-5.806843844046121611e-02,
-5.786192553839906300e-02,
-5.765540782372695350e-02,
-5.744888561477233535e-02,
-5.724235922974090646e-02,
-5.703582898671470669e-02,
-5.682929520365261750e-02,
-5.662275819838950841e-02,
-5.641621828863631338e-02,
-5.620967579197929526e-02,
-5.600313102587946984e-02,
-5.579658430767282795e-02,
-5.559003595456996766e-02,
-5.538348628365461629e-02,
-5.517693561188455331e-02,
-5.497038425609064582e-02,
-5.476383253297661957e-02,
-5.455728075911822628e-02,
-5.435072925096384039e-02,
-5.414417832483267579e-02,
-5.393762829691588212e-02,
-5.373107948327538602e-02,
-5.352453219984372457e-02,
-5.331798676242292812e-02,
-5.311144348668557502e-02,
-5.290490268817334835e-02,
-5.269836468229659177e-02,
-5.249182978433501734e-02,
-5.228529830943599160e-02,
-5.207877057261506293e-02,
-5.187224688875509415e-02,
-5.166572757260620014e-02,
-5.145921293878544939e-02,
-5.125270330177610079e-02,
-5.104619897592736766e-02,
-5.083970027545434839e-02,
-5.063320751443706191e-02,
-5.042672100682082936e-02,
-5.022024106641514996e-02,
-5.001376800689431162e-02,
-4.980730214179553833e-02,
-4.960084378452016968e-02,
-4.939439324833187067e-02,
-4.918795084635782522e-02,
-4.898151689158692507e-02,
-4.877509169687049145e-02,
-4.856867557492067222e-02,
-4.836226883831157286e-02,
-4.815587179947780627e-02,
-4.794948477071413889e-02,
-4.774310806417604580e-02,
-4.753674199187838539e-02,
-4.733038686569513570e-02,
-4.712404299735994256e-02,
-4.691771069846421838e-02,
-4.671139028045850905e-02,
-4.650508205465030132e-02,
-4.629878633220542439e-02,
-4.609250342414630830e-02,
-4.588623364135243493e-02,
-4.567997729455980371e-02,
-4.547373469436006427e-02,
-4.526750615120083560e-02,
-4.506129197538531750e-02,
-4.485509247707102770e-02,
-4.464890796627012104e-02,
-4.444273875284984743e-02,
-4.423658514653054652e-02,
-4.403044745688611261e-02,
-4.382432599334365464e-02,
-4.361822106518316311e-02,
-4.341213298153689254e-02,
-4.320606205138934758e-02,
-4.300000858357647116e-02,
-4.279397288678560285e-02,
-4.258795526955522215e-02,
-4.238195604027408109e-02,
-4.217597550718131527e-02,
-4.197001397836597203e-02,
-4.176407176176671204e-02,
-4.155814916517119872e-02,
-4.135224649621578596e-02,
-4.114636406238504629e-02,
-4.094050217101256883e-02,
-4.073466112927869726e-02,
-4.052884124421163303e-02,
-4.032304282268610318e-02,
-4.011726617142404722e-02,
-3.991151159699312528e-02,
-3.970577940580759246e-02,
-3.950006990412643915e-02,
-3.929438339805452207e-02,
-3.908872019354119737e-02,
-3.888308059638036912e-02,
-3.867746491221012856e-02,
-3.847187344651242791e-02,
-3.826630650461228245e-02,
-3.806076439167827008e-02,
-3.785524741272128929e-02,
-3.764975587259473261e-02,
-3.744429007599394538e-02,
-3.723885032745597595e-02,
-3.703343693135924958e-02,
-3.682805019192286755e-02,
-3.662269041320650315e-02,
-3.641735789911049181e-02,
-3.621205295337472790e-02,
-3.600677587957853282e-02,
-3.580152698114048848e-02,
-3.559630656131788223e-02,
-3.539111492320674152e-02,
-3.518595236974102897e-02,
-3.498081920369278813e-02,
-3.477571572767074876e-02,
-3.457064224412128434e-02,
-3.436559905532729498e-02,
-3.416058646340806165e-02,
-3.395560477031898949e-02,
-3.375065427785077510e-02,
-3.354573528762989226e-02,
-3.334084810111734298e-02,
-3.313599301960913623e-02,
-3.293117034423524714e-02,
-3.272638037595965166e-02,
-3.252162341557979230e-02,
-3.231689976372680018e-02,
-3.211220972086393372e-02,
-3.190755358728730728e-02,
-3.170293166312558586e-02,
-3.149834424833877766e-02,
-3.129379164271863661e-02,
-3.108927414588770824e-02,
-3.088479205729968355e-02,
-3.068034567623843106e-02,
-3.047593530181852417e-02,
-3.027156123298341620e-02,
-3.006722376850653328e-02,
-2.986292320699022659e-02,
-2.965865984686561277e-02,
-2.945443398639211938e-02,
-2.925024592365727330e-02,
-2.904609595657626012e-02,
-2.884198438289165695e-02,
-2.863791150017314449e-02,
-2.843387760581645232e-02,
-2.822988299704474666e-02,
-2.802592797090633706e-02,
-2.782201282427543623e-02,
-2.761813785385158065e-02,
-2.741430335615912747e-02,
-2.721050962754694227e-02,
-2.700675696418890909e-02,
-2.680304566208214709e-02,
-2.659937601704737142e-02,
-2.639574832472892443e-02,
-2.619216288059390482e-02,
-2.598861997993190051e-02,
-2.578511991785526966e-02,
-2.558166298929738514e-02,
-2.537824948901401534e-02,
-2.517487971158165541e-02,
-2.497155395139810316e-02,
-2.476827250268133149e-02,
-2.456503565946983186e-02,
-2.436184371562179901e-02,
-2.415869696481541193e-02,
-2.395559570054721019e-02,
-2.375254021613361008e-02,
-2.354953080470891316e-02,
-2.334656775922594810e-02,
-2.314365137245548085e-02,
-2.294078193698543058e-02,
-2.273795974522112295e-02,
-2.253518508938522416e-02,
-2.233245826151668278e-02,
-2.212977955347014344e-02,
-2.192714925691671354e-02,
-2.172456766334310979e-02,
-2.152203506405076308e-02,
-2.131955175015695300e-02,
-2.111711801259225085e-02,
-2.091473414210250070e-02,
-2.071240042924700833e-02,
-2.051011716439866267e-02,
-2.030788463774374844e-02,
-2.010570313928138411e-02,
-1.990357295882324434e-02,
-1.970149438599341774e-02,
-1.949946771022778927e-02,
-1.929749322077366214e-02,
-1.909557120669019836e-02,
-1.889370195684695122e-02,
-1.869188575992450016e-02,
-1.849012290441321565e-02,
-1.828841367861400516e-02,
-1.808675837063692532e-02,
-1.788515726840194525e-02,
-1.768361065963763856e-02,
-1.748211883188112784e-02,
-1.728068207247806382e-02,
-1.707930066858220908e-02,
-1.687797490715501822e-02,
-1.667670507496512092e-02,
-1.647549145858832539e-02,
-1.627433434440724025e-02,
-1.607323401861080608e-02,
-1.587219076719404570e-02,
-1.567120487595772410e-02,
-1.547027663050813337e-02,
-1.526940631625657747e-02,
-1.506859421841943818e-02,
-1.486784062201701277e-02,
-1.466714581187421318e-02,
-1.446651007261988073e-02,
-1.426593368868603155e-02,
-1.406541694430830589e-02,
-1.386496012352456120e-02,
-1.366456351017576731e-02,
-1.346422738790490833e-02,
-1.326395204015735733e-02,
-1.306373775017934807e-02,
-1.286358480101892736e-02,
-1.266349347552498360e-02,
-1.246346405634697271e-02,
-1.226349682593488172e-02,
-1.206359206653861461e-02,
-1.186375006020782240e-02,
-1.166397108879149193e-02,
-1.146425543393774123e-02,
-1.126460337709354192e-02,
-1.106501519950415721e-02,
-1.086549118221307245e-02,
-1.066603160606163780e-02,
-1.046663675168879246e-02,
-1.026730689953015037e-02,
-1.006804232981912441e-02,
-9.868843322584999050e-03,
-9.669710157653691948e-03,
-9.470643114646645419e-03,
-9.271642472981424937e-03,
-9.072708511870537784e-03,
-8.873841510321988160e-03,
-8.675041747138234616e-03,
-8.476309500915792799e-03,
-8.277645050045842612e-03,
-8.079048672713000021e-03,
-7.880520646895481859e-03,
-7.682061250364689495e-03,
-7.483670760684849738e-03,
-7.285349455212680909e-03,
-7.087097611097296565e-03,
-6.888915505279579257e-03,
-6.690803414492200486e-03,
-6.492761615259009210e-03,
-6.294790383894993679e-03,
-6.096889996505932760e-03,
-5.899060728987633520e-03,
-5.701302857026248685e-03,
-5.503616656098048524e-03,
-5.306002401468477153e-03,
-5.108460368191942644e-03,
-4.910990831112106714e-03,
-4.713594064861114513e-03,
-4.516270343859244210e-03,
-4.319019942315325059e-03,
-4.121843134225020890e-03,
-3.924740193371900436e-03,
-3.727711393326523133e-03,
-3.530757007446180210e-03,
-3.333877308874668745e-03,
-3.137072570541929971e-03,
-2.940343065163799480e-03,
-2.743689065241689765e-03,
-2.547110843062271469e-03,
-2.350608670697204496e-03,
-2.154182820002832708e-03,
-1.957833562619857356e-03,
-1.761561169973234519e-03,
-1.565365913271255481e-03,
-1.369248063506142178e-03,
-1.173207891453014384e-03,
-9.772456676703084304e-04,
-7.813616624987748628e-04,
-5.855561460612079307e-04,
-3.898293882628106393e-04,
-1.941816587903659583e-04,
 1.386772887924763056e-06,
 1.968756375227371852e-04,
 3.922846660839125407e-04,
 5.876135897607608028e-04,
 7.828621399623425514e-04,
 9.780300483177644614e-04,
 1.173117046676624801e-03,
 1.368122867108453227e-03,
 1.563047241904942609e-03,
 1.757889903578052334e-03,
 1.952650584861651516e-03,
 2.147329018710986658e-03,
 2.341924938303815724e-03,
 2.536438077040134922e-03,
 2.730868168542614771e-03,
 2.925214946656865076e-03,
 3.119478145451616644e-03,
 3.313657499219543109e-03,
 3.507752742476712322e-03,
 3.701763609963467597e-03,
 3.895689836644509671e-03,
 4.089531157709274875e-03,
 4.283287308572259963e-03,
 4.476958024872843868e-03,
 4.670543042476306417e-03,
 4.864042097473410264e-03,
 5.057454926181777395e-03,
 5.250781265144820534e-03,
 5.444020851132446576e-03,
 5.637173421141951704e-03,
 5.830238712397724753e-03,
 6.023216462351763285e-03,
 6.216106408683768139e-03,
 6.408908289301614401e-03,
 6.601621842341427737e-03,
 6.794246806168325117e-03,
 6.986782919376060066e-03,
 7.179229920787654103e-03,
 7.371587549455750621e-03,
 7.563855544662736324e-03,
 7.756033645920843572e-03,
 7.948121592972947486e-03,
 8.140119125792440180e-03,
 8.332025984583477096e-03,
 8.523841909781809667e-03,
 8.715566642054233676e-03,
 8.907199922299420189e-03,
 9.098741491648056068e-03,
 9.290191091463121525e-03,
 9.481548463340167682e-03,
 9.672813349107576772e-03,
 9.863985490827033992e-03,
 1.005506463079284749e-02,
 1.024605051153428328e-02,
 1.043694287581361374e-02,
 1.062774146662770480e-02,
 1.081844602720753550e-02,
 1.100905630101923528e-02,
 1.119957203176385509e-02,
 1.138999296337775066e-02,
 1.158031884003287056e-02,
 1.177054940613688275e-02,
 1.196068440633398129e-02,
 1.215072358550437458e-02,
 1.234066668876501738e-02,
 1.253051346146994739e-02,
 1.272026364921023840e-02,
 1.290991699781461784e-02,
 1.309947325334953443e-02,
 1.328893216211917208e-02,
 1.347829347066611429e-02,
 1.366755692577219065e-02,
 1.385672227445727822e-02,
 1.404578926398032147e-02,
 1.423475764183997766e-02,
 1.442362715577448495e-02,
 1.461239755376182725e-02,
 1.480106858402032918e-02,
 1.498963999500853468e-02,
 1.517811153542570485e-02,
 1.536648295421239215e-02,
 1.555475400054999631e-02,
 1.574292442386150334e-02,
 1.593099397381161214e-02,
 1.611896240030725666e-02,
 1.630682945349727977e-02,
 1.649459488377325381e-02,
 1.668225844176956033e-02,
 1.686981987836346300e-02,
 1.705727894467631497e-02,
 1.724463539207189006e-02,
 1.743188897215850255e-02,
 1.761903943678841400e-02,
 1.780608653805837438e-02,
 1.799303002830953194e-02,
 1.817986966012814440e-02,
 1.836660518634552347e-02,
 1.855323636003783361e-02,
 1.873976293452818409e-02,
 1.892618466338446756e-02,
 1.911250130042114678e-02,
 1.929871259969916791e-02,
 1.948481831552595356e-02,
 1.967081820245602727e-02,
 1.985671201529096153e-02,
 2.004249950908007505e-02,
 2.022818043911994365e-02,
 2.041375456095569432e-02,
 2.059922163038021073e-02,
 2.078458140343490690e-02,
 2.096983363641011580e-02,
 2.115497808584489159e-02,
 2.134001450852763410e-02,
 2.152494266149648436e-02,
 2.170976230203841909e-02,
 2.189447318769165846e-02,
 2.207907507624392446e-02,
 2.226356772573351295e-02,
 2.244795089444920344e-02,
 2.263222434093131383e-02,
 2.281638782397086770e-02,
 2.300044110261084684e-02,
 2.318438393614555976e-02,
 2.336821608412138068e-02,
 2.355193730633727695e-02,
 2.373554736284417405e-02,
 2.391904601394601385e-02,
 2.410243302019954986e-02,
 2.428570814241491280e-02,
 2.446887114165574237e-02,
 2.465192177923888200e-02,
 2.483485981673571458e-02,
 2.501768501597124647e-02,
 2.520039713902584924e-02,
 2.538299594823387878e-02,
 2.556548120618436920e-02,
 2.574785267572203204e-02,
 2.593011011994688503e-02,
 2.611225330221457475e-02,
 2.629428198613660214e-02,
 2.647619593558045090e-02,
 2.665799491467027438e-02,
 2.683967868778678462e-02,
 2.702124701956736680e-02,
 2.720269967490671417e-02,
 2.738403641895673785e-02,
 2.756525701712699353e-02,
 2.774636123508462601e-02,
 2.792734883875504920e-02,
 2.810821959432192527e-02,
 2.828897326822749081e-02,
 2.846960962717269908e-02,
 2.865012843811753918e-02,
 2.883052946828118870e-02,
 2.901081248514224623e-02,
 2.919097725643905045e-02,
 2.937102355017002717e-02,
 2.955095113459367887e-02,
 2.973075977822877899e-02,
 2.991044924985471892e-02,
 3.009001931851223652e-02,
 3.026946975350291655e-02,
 3.044880032438932946e-02,
 3.062801080099634629e-02,
 3.080710095340968499e-02,
 3.098607055197800594e-02,
 3.116491936731172543e-02,
 3.134364717028403913e-02,
 3.152225373203053349e-02,
 3.170073882395030990e-02,
 3.187910221770507563e-02,
 3.205734368522022981e-02,
 3.223546299868474546e-02,
 3.241345993055178704e-02,
 3.259133425353797492e-02,
 3.276908574062499524e-02,
 3.294671416505837169e-02,
 3.312421930034873535e-02,
 3.330160092027217161e-02,
 3.347885879886942223e-02,
 3.365599271044663471e-02,
 3.383300242957620191e-02,
 3.400988773109575591e-02,
 3.418664839010947254e-02,
 3.436328418198796031e-02,
 3.453979488236810086e-02,
 3.471618026715370814e-02,
 3.489244011251577821e-02,
 3.506857419489230882e-02,
 3.524458229098886147e-02,
 3.542046417777880429e-02,
 3.559621963250333282e-02,
 3.577184843267160880e-02,
 3.594735035606114876e-02,
 3.612272518071842076e-02,
 3.629797268495810886e-02,
 3.647309264736479928e-02,
 3.664808484679137751e-02,
 3.682294906236053406e-02,
 3.699768507346462565e-02,
 3.717229265976584873e-02,
 3.734677160119666967e-02,
 3.752112167795954717e-02,
 3.769534267052784826e-02,
 3.786943435964489763e-02,
 3.804339652632632296e-02,
 3.821722895185775820e-02,
 3.839093141779652274e-02,
 3.856450370597194061e-02,
 3.873794559848463964e-02,
 3.891125687770731478e-02,
 3.908443732628530398e-02,
 3.925748672713599841e-02,
 3.943040486344935591e-02,
 3.960319151868905291e-02,
 3.977584647659075656e-02,
 3.994836952116414402e-02,
 4.012076043669188935e-02,
 4.029301900773091250e-02,
 4.046514501911156747e-02,
 4.063713825593901624e-02,
 4.080899850359172298e-02,
 4.098072554772325821e-02,
 4.115231917426259017e-02,
 4.132377916941259999e-02,
 4.149510531965185794e-02,
 4.166629741173405455e-02,
 4.183735523268883316e-02,
 4.200827856982132513e-02,
 4.217906721071269099e-02,
 4.234972094322032865e-02,
 4.252023955547812317e-02,
 4.269062283589633577e-02,
 4.286087057316221444e-02,
 4.303098255623998003e-02,
 4.320095857437121489e-02,
 4.337079841707443262e-02,
 4.354050187414648665e-02,
 4.371006873566111312e-02,
 4.387949879197099862e-02,
 4.404879183370610102e-02,
 4.421794765177623765e-02,
 4.438696603736825425e-02,
 4.455584678194864784e-02,
 4.472458967726260920e-02,
 4.489319451533499428e-02,
 4.506166108846963031e-02,
 4.522998918924989870e-02,
 4.539817861053955378e-02,
 4.556622914548164038e-02,
 4.573414058749985384e-02,
 4.590191273029830404e-02,
 4.606954536786126569e-02,
 4.623703829445447583e-02,
 4.640439130462371831e-02,
 4.657160419319687078e-02,
 4.673867675528264182e-02,
 4.690560878627125091e-02,
 4.707240008183491420e-02,
 4.723905043792790692e-02,
 4.740555965078631362e-02,
 4.757192751692875671e-02,
 4.773815383315620914e-02,
 4.790423839655248706e-02,
 4.807018100448421510e-02,
 4.823598145460130521e-02,
 4.840163954483631820e-02,
 4.856715507340596261e-02,
 4.873252783881053957e-02,
 4.889775763983392198e-02,
 4.906284427554422761e-02,
 4.922778754529347905e-02,
 4.939258724871837397e-02,
 4.955724318574012549e-02,
 4.972175515656455935e-02,
 4.988612296168277310e-02,
 5.005034640187087935e-02,
 5.021442527819020007e-02,
 5.037835939198773844e-02,
 5.054214854489590819e-02,
 5.070579253883356063e-02,
 5.086929117600492295e-02,
 5.103264425890106232e-02,
 5.119585159029919896e-02,
 5.135891297326270616e-02,
 5.152182821114240086e-02,
 5.168459710757659920e-02,
 5.184721946648922913e-02,
 5.200969509209271702e-02,
 5.217202378888662756e-02,
 5.233420536165803855e-02,
 5.249623961548251921e-02,
 5.265812635572265921e-02,
 5.281986538803042780e-02,
 5.298145651834539060e-02,
 5.314289955289596551e-02,
 5.330419429819916594e-02,
 5.346534056106149596e-02,
 5.362633814857800663e-02,
 5.378718686813278860e-02,
 5.394788652739988810e-02,
 5.410843693434318896e-02,
 5.426883789721546197e-02,
 5.442908922456077964e-02,
 5.458919072521220550e-02,
 5.474914220829339706e-02,
 5.490894348321888330e-02,
 5.506859435969364142e-02,
 5.522809464771324950e-02,
 5.538744415756469835e-02,
 5.554664269982597519e-02,
 5.570569008536613298e-02,
 5.586458612534640072e-02,
 5.602333063121923279e-02,
 5.618192341472881546e-02,
 5.634036428791183715e-02,
 5.649865306309652391e-02,
 5.665678955290434637e-02,
 5.681477357024836833e-02,
 5.697260492833479406e-02,
 5.713028344066271164e-02,
 5.728780892102423861e-02,
 5.744518118350470243e-02,
 5.760240004248273066e-02,
 5.775946531263038974e-02,
 5.791637680891332379e-02,
 5.807313434659115009e-02,
 5.822973774121786850e-02,
 5.838618680864104266e-02,
 5.854248136500254940e-02,
 5.869862122673962651e-02,
 5.885460621058324904e-02,
 5.901043613355975992e-02,
 5.916611081299007896e-02,
 5.932163006649032733e-02,
 5.947699371197207735e-02,
 5.963220156764242191e-02,
 5.978725345200384955e-02,
 5.994214918385477181e-02,
 6.009688858228974528e-02,
 6.025147146669879161e-02,
 6.040589765676874362e-02,
 6.056016697248226693e-02,
 6.071427923411951838e-02,
 6.086823426225646677e-02,
 6.102203187776608639e-02,
 6.117567190181888437e-02,
 6.132915415588197777e-02,
 6.148247846172037040e-02,
 6.163564464139580784e-02,
 6.178865251726848445e-02,
 6.194150191199565558e-02,
 6.209419264853310860e-02,
 6.224672455013427474e-02,
 6.239909744035097156e-02,
 6.255131114303374984e-02,
 6.270336548233094998e-02,
 6.285526028269064480e-02,
 6.300699536885896734e-02,
 6.315857056588082552e-02,
 6.330998569910126217e-02,
 6.346124059416353991e-02,
 6.361233507701123668e-02,
 6.376326897388688575e-02,
 6.391404211133315527e-02,
 6.406465431619216833e-02,
 6.421510541560652985e-02,
 6.436539523701867438e-02,
 6.451552360817165710e-02,
 6.466549035710893178e-02,
 6.481529531217392059e-02,
 6.496493830201173492e-02,
 6.511441915556791249e-02,
 6.526373770208895864e-02,
 6.541289377112241565e-02,
 6.556188719251768160e-02,
 6.571071779642542743e-02,
 6.585938541329736107e-02,
 6.600788987388768458e-02,
 6.615623100925217825e-02,
 6.630440865074849199e-02,
 6.645242263003646455e-02,
 6.660027277907838716e-02,
 6.674795893013897585e-02,
 6.689548091578552402e-02,
 6.704283856888762494e-02,
 6.719003172261869827e-02,
 6.733706021045410273e-02,
 6.748392386617274585e-02,
 6.763062252385662609e-02,
 6.777715601789174871e-02,
 6.792352418296665473e-02,
 6.806972685407426671e-02,
 6.821576386651134749e-02,
 6.836163505587805611e-02,
 6.850734025807912742e-02,
 6.865287930932281735e-02,
 6.879825204612259604e-02,
 6.894345830529570451e-02,
 6.908849792396426492e-02,
 6.923337073955497523e-02,
 6.937807658979965042e-02,
 6.952261531273465356e-02,
 6.966698674670221414e-02,
 6.981119073034872113e-02,
 6.995522710262637445e-02,
 7.009909570279382329e-02,
 7.024279637041362656e-02,
 7.038632894535552798e-02,
 7.052969326779436054e-02,
 7.067288917821105965e-02,
 7.081591651739281568e-02,
 7.095877512643343488e-02,
 7.110146484673274259e-02,
 7.124398551999659712e-02,
 7.138633698823816653e-02,
 7.152851909377741513e-02,
 7.167053167924065937e-02,
 7.181237458756134506e-02,
 7.195404766198029711e-02,
 7.209555074604562241e-02,
 7.223688368361251555e-02,
 7.237804631884380002e-02,
 7.251903849620970621e-02,
 7.265986006048841261e-02,
 7.280051085676590705e-02,
 7.294099073043605608e-02,
 7.308129952720092415e-02,
 7.322143709307087078e-02,
 7.336140327436405095e-02,
 7.350119791770738653e-02,
 7.364082087003713528e-02,
 7.378027197859669817e-02,
 7.391955109093928389e-02,
 7.405865805492714560e-02,
 7.419759271873048456e-02,
 7.433635493082965673e-02,
 7.447494454001370168e-02,
 7.461336139538188306e-02,
 7.475160534634171794e-02,
 7.488967624261096134e-02,
 7.502757393421702337e-02,
 7.516529827149716347e-02,
 7.530284910509850438e-02,
 7.544022628597814306e-02,
 7.557742966540334506e-02,
 7.571445909495166937e-02,
 7.585131442651087130e-02,
 7.598799551227977678e-02,
 7.612450220476681129e-02,
 7.626083435679219258e-02,
 7.639699182148593226e-02,
 7.653297445228947338e-02,
 7.666878210295555163e-02,
 7.680441462754712678e-02,
 7.693987188043908965e-02,
 7.707515371631741552e-02,
 7.721025999018013564e-02,
 7.734519055733589388e-02,
 7.747994527340516802e-02,
 7.761452399432065830e-02,
 7.774892657632666293e-02,
 7.788315287597942504e-02,
 7.801720275014738248e-02,
 7.815107605601055718e-02,
 7.828477265106199845e-02,
 7.841829239310683930e-02,
 7.855163514026272664e-02,
 7.868480075095964088e-02,
 7.881778908394054817e-02,
 7.895059999826092856e-02,
 7.908323335328895642e-02,
 7.921568900870641639e-02,
 7.934796682450760696e-02,
 7.948006666100006223e-02,
 7.961198837880519019e-02,
 7.974373183885663519e-02,
 7.987529690240234570e-02,
 8.000668343100338087e-02,
 8.013789128653484028e-02,
 8.026892033118573910e-02,
 8.039977042745777291e-02,
 8.053044143816721900e-02,
 8.066093322644551922e-02,
 8.079124565573640726e-02,
 8.092137858979873977e-02,
 8.105133189270569138e-02,
 8.118110542884428293e-02,
 8.131069906291683858e-02,
 8.144011265993940374e-02,
 8.156934608524364638e-02,
 8.169839920447501125e-02,
 8.182727188359451009e-02,
 8.195596398887719514e-02,
 8.208447538691486522e-02,
 8.221280594461215230e-02,
 8.234095552919105943e-02,
 8.246892400818707503e-02,
 8.259671124945214271e-02,
 8.272431712115305147e-02,
 8.285174149177297609e-02,
 8.297898423010981184e-02,
 8.310604520527770100e-02,
 8.323292428670654719e-02,
 8.335962134414161284e-02,
 8.348613624764524010e-02,
 8.361246886759418628e-02,
 8.373861907468321819e-02,
 8.386458673992157331e-02,
 8.399037173463590189e-02,
 8.411597393046908733e-02,
 8.424139319937998249e-02,
 8.436662941364460322e-02,
 8.449168244585540666e-02,
 8.461655216892120801e-02,
 8.474123845606734706e-02,
 8.486574118083743679e-02,
 8.499006021709037961e-02,
 8.511419543900297646e-02,
 8.523814672106921897e-02,
 8.536191393809997030e-02,
 8.548549696522303454e-02,
 8.560889567788394772e-02,
 8.573210995184585292e-02,
 8.585513966318902845e-02,
 8.597798468831124863e-02,
 8.610064490392763115e-02,
 8.622312018707209424e-02,
 8.634541041509548320e-02,
 8.646751546566633362e-02,
 8.658943521677130162e-02,
 8.671116954671546917e-02,
 8.683271833412127549e-02,
 8.695408145792994647e-02,
 8.707525879740064811e-02,
 8.719625023210995918e-02,
 8.731705564195452185e-02,
 8.743767490714832169e-02,
 8.755810790822370071e-02,
 8.767835452603174595e-02,
 8.779841464174258092e-02,
 8.791828813684444965e-02,
 8.803797489314472979e-02,
 8.815747479276919707e-02,
 8.827678771816291348e-02,
 8.839591355208946399e-02,
 8.851485217763252478e-02,
 8.863360347819301821e-02,
 8.875216733749273501e-02,
 8.887054363957191949e-02,
 8.898873226878956100e-02,
 8.910673310982526740e-02,
 8.922454604767721120e-02,
 8.934217096766261523e-02,
 8.945960775541939025e-02,
 8.957685629690437246e-02,
 8.969391647839386472e-02,
 8.981078818648391415e-02,
 8.992747130809071454e-02,
 9.004396573044982921e-02,
 9.016027134111766206e-02,
 9.027638802796890405e-02,
 9.039231567919969734e-02,
 9.050805418332523444e-02,
 9.062360342918213130e-02,
 9.073896330592551296e-02,
 9.085413370303210834e-02,
 9.096911451029773832e-02,
 9.108390561784014683e-02,
 9.119850691609568405e-02,
 9.131291829582245667e-02,
 9.142713964809817684e-02,
 9.154117086432184136e-02,
 9.165501183621259373e-02,
 9.176866245581075110e-02,
 9.188212261547665238e-02,
 9.199539220789161587e-02,
 9.210847112605788367e-02,
 9.222135926329907973e-02,
 9.233405651325872487e-02,
 9.244656276990141641e-02,
 9.255887792751438248e-02,
 9.267100188070356848e-02,
 9.278293452439748124e-02,
 9.289467575384581510e-02,
 9.300622546461878581e-02,
 9.311758355260815745e-02,
 9.322874991402720080e-02,
 9.333972444541013824e-02,
 9.345050704361280991e-02,
 9.356109760581278467e-02,
 9.367149602950909648e-02,
 9.378170221252157823e-02,
 9.389171605299216627e-02,
 9.400153744938441469e-02,
 9.411116630048339815e-02,
 9.422060250539608661e-02,
 9.432984596355134532e-02,
 9.443889657469885235e-02,
 9.454775423891136066e-02,
 9.465641885658322707e-02,
 9.476489032842970450e-02,
 9.487316855548948158e-02,
 9.498125343912229568e-02,
 9.508914488100987661e-02,
 9.519684278315646009e-02,
 9.530434704788813549e-02,
 9.541165757785298462e-02,
 9.551877427602202542e-02,
 9.562569704568753270e-02,
 9.573242579046456480e-02,
 9.583896041429036672e-02,
 9.594530082142448124e-02,
 9.605144691644894317e-02,
 9.615739860426796015e-02,
 9.626315579010878698e-02,
 9.636871837951932473e-02,
 9.647408627837295025e-02,
 9.657925939286278461e-02,
 9.668423762950606459e-02,
 9.678902089514211660e-02,
 9.689360909693293944e-02,
 9.699800214236320439e-02,
 9.710219993924039394e-02,
 9.720620239569420507e-02,
 9.731000942017808963e-02,
 9.741362092146746421e-02,
 9.751703680866072310e-02,
 9.762025699117875266e-02,
 9.772328137876634679e-02,
 9.782610988148982001e-02,
 9.792874240973951927e-02,
 9.803117887422864440e-02,
 9.813341918599220726e-02,
 9.823546325638929377e-02,
 9.833731099710184276e-02,
 9.843896232013514547e-02,
 9.854041713781686029e-02,
 9.864167536279769277e-02,
 9.874273690805246417e-02,
 9.884360168687789105e-02,
 9.894426961289473632e-02,
 9.904474060004658797e-02,
 9.914501456260037260e-02,
 9.924509141514586963e-02,
 9.934497107259707138e-02,
 9.944465345018996261e-02,
 9.954413846348469930e-02,
 9.964342602836442908e-02,
 9.974251606103545775e-02,
 9.984140847802820684e-02,
 9.994010319619524296e-02,
 1.000386001327134011e-01,
 1.001368992050830214e-01,
 1.002350003311272691e-01,
 1.003329034289926064e-01,
 1.004306084171498331e-01,
 1.005281152143925882e-01,
 1.006254237398377938e-01,
 1.007225339129267927e-01,
 1.008194456534231426e-01,
 1.009161588814149468e-01,
 1.010126735173134949e-01,
 1.011089894818532620e-01,
 1.012051066960928530e-01,
 1.013010250814144059e-01,
 1.013967445595228417e-01,
 1.014922650524477110e-01,
 1.015875864825416808e-01,
 1.016827087724810758e-01,
 1.017776318452654621e-01,
 1.018723556242188272e-01,
 1.019668800329883440e-01,
 1.020612049955444411e-01,
 1.021553304361820375e-01,
 1.022492562795192100e-01,
 1.023429824504973745e-01,
 1.024365088743826036e-01,
 1.025298354767634756e-01,
 1.026229621835535177e-01,
 1.027158889209888043e-01,
 1.028086156156294423e-01,
 1.029011421943598764e-01,
 1.029934685843875569e-01,
 1.030855947132434669e-01,
 1.031775205087831215e-01,
 1.032692458991852635e-01,
 1.033607708129519465e-01,
 1.034520951789094922e-01,
 1.035432189262080749e-01,
 1.036341419843213735e-01,
 1.037248642830466416e-01,
 1.038153857525047213e-01,
 1.039057063231402511e-01,
 1.039958259257221934e-01,
 1.040857444913426411e-01,
 1.041754619514170255e-01,
 1.042649782376852546e-01,
 1.043542932822113106e-01,
 1.044434070173813345e-01,
 1.045323193759061520e-01,
 1.046210302908201495e-01,
 1.047095396954821622e-01,
 1.047978475235728235e-01,
 1.048859537090985200e-01,
 1.049738581863880749e-01,
 1.050615608900942466e-01,
 1.051490617551936319e-01,
 1.052363607169861104e-01,
 1.053234577110957054e-01,
 1.054103526734696122e-01,
 1.054970455403789059e-01,
 1.055835362484181389e-01,
 1.056698247345053965e-01,
 1.057559109358827687e-01,
 1.058417947901156425e-01,
 1.059274762350931876e-01,
 1.060129552090275096e-01,
 1.060982316504552325e-01,
 1.061833054982355834e-01,
 1.062681766915517800e-01,
 1.063528451699108368e-01,
 1.064373108731426487e-01,
 1.065215737414008101e-01,
 1.066056337151628924e-01,
 1.066894907352294586e-01,
 1.067731447427240216e-01,
 1.068565956790946542e-01,
 1.069398434861121988e-01,
 1.070228881058706283e-01,
 1.071057294807876148e-01,
 1.071883675536041552e-01,
 1.072708022673849459e-01,
 1.073530335655173834e-01,
 1.074350613917124386e-01,
 1.075168856900046849e-01,
 1.075985064047513817e-01,
 1.076799234806332523e-01,
 1.077611368626546495e-01,
 1.078421464961421133e-01,
 1.079229523267470764e-01,
 1.080035543004417981e-01,
 1.080839523635240690e-01,
 1.081641464626130339e-01,
 1.082441365446518006e-01,
 1.083239225569064546e-01,
 1.084035044469657538e-01,
 1.084828821627416423e-01,
 1.085620556524691666e-01,
 1.086410248647063093e-01,
 1.087197897483346276e-01,
 1.087983502525570051e-01,
 1.088767063269003438e-01,
 1.089548579212143709e-01,
 1.090328049856714165e-01,
 1.091105474707669831e-01,
 1.091880853273189539e-01,
 1.092654185064681482e-01,
 1.093425469596774335e-01,
 1.094194706387330990e-01,
 1.094961894957447446e-01,
 1.095727034831430885e-01,
 1.096490125536823262e-01,
 1.097251166604392980e-01,
 1.098010157568124340e-01,
 1.098767097965236972e-01,
 1.099521987336175566e-01,
 1.100274825224601821e-01,
 1.101025611177404856e-01,
 1.101774344744697598e-01,
 1.102521025479816646e-01,
 1.103265652939319913e-01,
 1.104008226682994948e-01,
 1.104748746273835069e-01,
 1.105487211278076420e-01,
 1.106223621265157997e-01,
 1.106957975807755373e-01,
 1.107690274481753639e-01,
 1.108420516866259892e-01,
 1.109148702543614196e-01,
 1.109874831099351422e-01,
 1.110598902122254400e-01,
 1.111320915204299653e-01,
 1.112040869940695703e-01,
 1.112758765929867805e-01,
 1.113474602773454752e-01,
 1.114188380076315266e-01,
 1.114900097446526461e-01,
 1.115609754495382466e-01,
 1.116317350837383315e-01,
 1.117022886090255351e-01,
 1.117726359874939984e-01,
 1.118427771815581756e-01,
 1.119127121539551517e-01,
 1.119824408677429495e-01,
 1.120519632863008486e-01,
 1.121212793733295243e-01,
 1.121903890928512143e-01,
 1.122592924092082056e-01,
 1.123279892870645696e-01,
 1.123964796914067588e-01,
 1.124647635875396096e-01,
 1.125328409410914776e-01,
 1.126007117180102129e-01,
 1.126683758845643812e-01,
 1.127358334073451651e-01,
 1.128030842532621869e-01,
 1.128701283895473667e-01,
 1.129369657837534097e-01,
 1.130035964037523488e-01,
 1.130700202177379460e-01,
 1.131362371942241374e-01,
 1.132022473020449921e-01,
 1.132680505103561414e-01,
 1.133336467886323917e-01,
 1.133990361066691266e-01,
 1.134642184345822924e-01,
 1.135291937428080933e-01,
 1.135939620021027413e-01,
 1.136585231835423454e-01,
 1.137228772585233694e-01,
 1.137870241987617853e-01,
 1.138509639762941006e-01,
 1.139146965634765946e-01,
 1.139782219329851243e-01,
 1.140415400578150273e-01,
 1.141046509112820517e-01,
 1.141675544670212317e-01,
 1.142302506989875677e-01,
 1.142927395814541114e-01,
 1.143550210890150604e-01,
 1.144170951965837041e-01,
 1.144789618793919522e-01,
 1.145406211129914587e-01,
 1.146020728732527472e-01,
 1.146633171363661413e-01,
 1.147243538788405848e-01,
 1.147851830775042381e-01,
 1.148458047095036183e-01,
 1.149062187523050976e-01,
 1.149664251836933077e-01,
 1.150264239817717915e-01,
 1.150862151249623655e-01,
 1.151457985920062294e-01,
 1.152051743619623009e-01,
 1.152643424142092282e-01,
 1.153233027284426976e-01,
 1.153820552846771402e-01,
 1.154406000632460655e-01,
 1.154989370448004649e-01,
 1.155570662103099361e-01,
 1.156149875410614480e-01,
 1.156727010186606730e-01,
 1.157302066250307376e-01,
 1.157875043424135691e-01,
 1.158445941533672169e-01,
 1.159014760407691830e-01,
 1.159581499878142991e-01,
 1.160146159780133662e-01,
 1.160708739951968188e-01,
 1.161269240235116851e-01,
 1.161827660474218371e-01,
 1.162384000517093785e-01,
 1.162938260214732566e-01,
 1.163490439421289296e-01,
 1.164040537994096014e-01,
 1.164588555793656804e-01,
 1.165134492683641831e-01,
 1.165678348530890529e-01,
 1.166220123205399251e-01,
 1.166759816580354298e-01,
 1.167297428532081127e-01,
 1.167832958940097365e-01,
 1.168366407687062292e-01,
 1.168897774658809036e-01,
 1.169427059744336667e-01,
 1.169954262835802700e-01,
 1.170479383828518100e-01,
 1.171002422620972955e-01,
 1.171523379114800117e-01,
 1.172042253214794633e-01,
 1.172559044828918318e-01,
 1.173073753868279501e-01,
 1.173586380247151062e-01,
 1.174096923882953780e-01,
 1.174605384696272709e-01,
 1.175111762610835803e-01,
 1.175616057553534599e-01,
 1.176118269454398679e-01,
 1.176618398246630642e-01,
 1.177116443866558920e-01,
 1.177612406253682326e-01,
 1.178106285350638271e-01,
 1.178598081103208600e-01,
 1.179087793460333738e-01,
 1.179575422374082444e-01,
 1.180060967799690941e-01,
 1.180544429695525310e-01,
 1.181025808023095369e-01,
 1.181505102747056474e-01,
 1.181982313835209242e-01,
 1.182457441258487202e-01,
 1.182930484990968173e-01,
 1.183401445009867325e-01,
 1.183870321295548422e-01,
 1.184337113831490096e-01,
 1.184801822604324012e-01,
 1.185264447603816690e-01,
 1.185724988822861731e-01,
 1.186183446257492446e-01,
 1.186639819906868815e-01,
 1.187094109773283168e-01,
 1.187546315862162000e-01,
 1.187996438182063880e-01,
 1.188444476744666689e-01,
 1.188890431564780803e-01,
 1.189334302660347426e-01,
 1.189776090052422214e-01,
 1.190215793765200258e-01,
 1.190653413825993323e-01,
 1.191088950265225266e-01,
 1.191522403116463402e-01,
 1.191953772416377705e-01,
 1.192383058204766477e-01,
 1.192810260524544003e-01,
 1.193235379421747205e-01,
 1.193658414945521634e-01,
 1.194079367148133120e-01,
 1.194498236084961529e-01,
 1.194915021814501460e-01,
 1.195329724398363491e-01,
 1.195742343901262522e-01,
 1.196152880391022216e-01,
 1.196561333938594290e-01,
 1.196967704618009387e-01,
 1.197371992506438693e-01,
 1.197774197684134678e-01,
 1.198174320234460799e-01,
 1.198572360243894408e-01,
 1.198968317802008021e-01,
 1.199362193001476673e-01,
 1.199753985938079026e-01,
 1.200143696710691682e-01,
 1.200531325421291540e-01,
 1.200916872174958988e-01,
 1.201300337079855562e-01,
 1.201681720247257806e-01,
 1.202061021791523826e-01,
 1.202438241830108001e-01,
 1.202813380483555711e-01,
 1.203186437875514020e-01,
 1.203557414132709197e-01,
 1.203926309384959203e-01,
 1.204293123765171059e-01,
 1.204657857409338478e-01,
 1.205020510456541599e-01,
 1.205381083048948226e-01,
 1.205739575331794405e-01,
 1.206095987453427165e-01,
 1.206450319565244567e-01,
 1.206802571821742193e-01,
 1.207152744380490805e-01,
 1.207500837402138844e-01,
 1.207846851050411452e-01,
 1.208190785492107983e-01,
 1.208532640897103660e-01,
 1.208872417438347502e-01,
 1.209210115291856763e-01,
 1.209545734636728737e-01,
 1.209879275655109665e-01,
 1.210210738532241648e-01,
 1.210540123456415595e-01,
 1.210867430618989271e-01,
 1.211192660214397560e-01,
 1.211515812440128043e-01,
 1.211836887496727660e-01,
 1.212155885587815896e-01,
 1.212472806920070478e-01,
 1.212787651703216146e-01,
 1.213100420150047820e-01,
 1.213411112476407844e-01,
 1.213719728901206524e-01,
 1.214026269646395761e-01,
 1.214330734936984041e-01,
 1.214633125001026437e-01,
 1.214933440069638215e-01,
 1.215231680376978041e-01,
 1.215527846160252973e-01,
 1.215821937659714996e-01,
 1.216113955118664491e-01,
 1.216403898783436632e-01,
 1.216691768903423315e-01,
 1.216977565731048594e-01,
 1.217261289521779088e-01,
 1.217542940534117185e-01,
 1.217822519029611861e-01,
 1.218100025272834119e-01,
 1.218375459531401694e-01,
 1.218648822075962812e-01,
 1.218920113180191889e-01,
 1.219189333120807711e-01,
 1.219456482177543183e-01,
 1.219721560633166973e-01,
 1.219984568773483380e-01,
 1.220245506887304987e-01,
 1.220504375266483338e-01,
 1.220761174205887284e-01,
 1.221015904003402708e-01,
 1.221268564959950703e-01,
 1.221519157379448300e-01,
 1.221767681568858011e-01,
 1.222014137838135089e-01,
 1.222258526500263481e-01,
 1.222500847871238611e-01,
 1.222741102270060026e-01,
 1.222979290018750553e-01,
 1.223215411442332562e-01,
 1.223449466868848506e-01,
 1.223681456629332615e-01,
 1.223911381057836006e-01,
 1.224139240491406572e-01,
 1.224365035270102847e-01,
 1.224588765736975976e-01,
 1.224810432238085944e-01,
 1.225030035122486594e-01,
 1.225247574742225898e-01,
 1.225463051452353874e-01,
 1.225676465610913840e-01,
 1.225887817578934225e-01,
 1.226097107720443002e-01,
 1.226304336402463391e-01,
 1.226509503994992201e-01,
 1.226712610871021625e-01,
 1.226913657406533548e-01,
 1.227112643980490664e-01,
 1.227309570974834119e-01,
 1.227504438774490031e-01,
 1.227697247767373934e-01,
 1.227887998344360243e-01,
 1.228076690899322365e-01,
 1.228263325829091202e-01,
 1.228447903533479157e-01,
 1.228630424415275840e-01,
 1.228810888880233626e-01,
 1.228989297337084174e-01,
 1.229165650197517196e-01,
 1.229339947876199046e-01,
 1.229512190790753440e-01,
 1.229682379361774630e-01,
 1.229850514012813534e-01,
 1.230016595170387445e-01,
 1.230180623263966710e-01,
 1.230342598725983200e-01,
 1.230502521991828635e-01,
 1.230660393499847793e-01,
 1.230816213691331013e-01,
 1.230969983010528623e-01,
 1.231121701904642207e-01,
 1.231271370823816130e-01,
 1.231418990221144899e-01,
 1.231564560552672744e-01,
 1.231708082277386401e-01,
 1.231849555857203460e-01,
 1.231988981757001500e-01,
 1.232126360444588398e-01,
 1.232261692390706348e-01,
 1.232394978069038805e-01,
 1.232526217956203540e-01,
 1.232655412531755423e-01,
 1.232782562278176980e-01,
 1.232907667680873259e-01,
 1.233030729228195843e-01,
 1.233151747411406762e-01,
 1.233270722724707225e-01,
 1.233387655665208194e-01,
 1.233502546732953564e-01,
 1.233615396430906008e-01,
 1.233726205264939618e-01,
 1.233834973743859614e-01,
 1.233941702379380279e-01,
 1.234046391686119820e-01,
 1.234149042181629935e-01,
 1.234249654386361528e-01,
 1.234348228823667071e-01,
 1.234444766019825029e-01,
 1.234539266504002114e-01,
 1.234631730808290612e-01,
 1.234722159467661479e-01,
 1.234810553020007778e-01,
 1.234896912006108044e-01,
 1.234981236969645985e-01,
 1.235063528457199106e-01,
 1.235143787018240097e-01,
 1.235222013205140995e-01,
 1.235298207573153478e-01,
 1.235372370680426352e-01,
 1.235444503087994306e-01,
 1.235514605359784440e-01,
 1.235582678062598500e-01,
 1.235648721766121477e-01,
 1.235712737042933967e-01,
 1.235774724468483160e-01,
 1.235834684621096718e-01,
 1.235892618081984168e-01,
 1.235948525435218021e-01,
 1.236002407267758757e-01,
 1.236054264169421796e-01,
 1.236104096732908719e-01,
 1.236151905553777713e-01,
 1.236197691230456197e-01,
 1.236241454364234993e-01,
 1.236283195559274156e-01,
 1.236322915422579799e-01,
 1.236360614564035454e-01,
 1.236396293596364465e-01,
 1.236429953135159132e-01,
 1.236461593798866138e-01,
 1.236491216208770172e-01,
 1.236518820989025019e-01,
 1.236544408766619974e-01,
 1.236567980171395381e-01,
 1.236589535836036396e-01,
 1.236609076396069928e-01,
 1.236626602489873522e-01,
 1.236642114758654820e-01,
 1.236655613846462248e-01,
 1.236667100400182656e-01,
 1.236676575069530354e-01,
 1.236684038507069316e-01,
 1.236689491368177657e-01,
 1.236692934311069136e-01,
 1.236694367996785393e-01,
 1.236693793089188587e-01,
 1.236691210254977635e-01,
 1.236686620163662126e-01,
 1.236680023487569391e-01,
 1.236671420901856305e-01,
 1.236660813084495547e-01,
 1.236648200716260471e-01,
 1.236633584480752029e-01,
 1.236616965064382540e-01,
 1.236598343156356111e-01,
 1.236577719448712365e-01,
 1.236555094636267171e-01,
 1.236530469416664696e-01,
 1.236503844490337983e-01,
 1.236475220560519089e-01,
 1.236444598333250877e-01,
 1.236411978517355514e-01,
 1.236377361824463755e-01,
 1.236340748968993986e-01,
 1.236302140668152499e-01,
 1.236261537641944186e-01,
 1.236218940613151990e-01,
 1.236174350307342601e-01,
 1.236127767452875476e-01,
 1.236079192780884795e-01,
 1.236028627025285015e-01,
 1.235976070922776143e-01,
 1.235921525212820560e-01,
 1.235864990637665223e-01,
 1.235806467942326681e-01,
 1.235745957874590101e-01,
 1.235683461185007048e-01,
 1.235618978626900483e-01,
 1.235552510956357680e-01,
 1.235484058932225099e-01,
 1.235413623316107962e-01,
 1.235341204872377335e-01,
 1.235266804368157362e-01,
 1.235190422573327479e-01,
 1.235112060260514927e-01,
 1.235031718205107931e-01,
 1.234949397185237802e-01,
 1.234865097981785453e-01,
 1.234778821378364755e-01,
 1.234690568161358193e-01,
 1.234600339119869966e-01,
 1.234508135045744998e-01,
 1.234413956733574069e-01,
 1.234317804980676891e-01,
 1.234219680587106266e-01,
 1.234119584355646698e-01,
 1.234017517091824806e-01,
 1.233913479603874624e-01,
 1.233807472702770219e-01,
 1.233699497202203899e-01,
 1.233589553918586490e-01,
 1.233477643671052615e-01,
 1.233363767281457357e-01,
 1.233247925574369325e-01,
 1.233130119377068845e-01,
 1.233010349519545745e-01,
 1.232888616834501155e-01,
 1.232764922157350562e-01,
 1.232639266326209654e-01,
 1.232511650181898483e-01,
 1.232382074567932861e-01,
 1.232250540330534355e-01,
 1.232117048318625008e-01,
 1.231981599383815407e-01,
 1.231844194380420088e-01,
 1.231704834165425616e-01,
 1.231563519598529721e-01,
 1.231420251542107436e-01,
 1.231275030861215675e-01,
 1.231127858423602395e-01,
 1.230978735099690635e-01,
 1.230827661762584346e-01,
 1.230674639288068944e-01,
 1.230519668554603263e-01,
 1.230362750443311642e-01,
 1.230203885838000583e-01,
 1.230043075625135152e-01,
 1.229880320693853002e-01,
 1.229715621935959513e-01,
 1.229548980245918771e-01,
 1.229380396520847046e-01,
 1.229209871660536801e-01,
 1.229037406567427687e-01,
 1.228863002146608763e-01,
 1.228686659305830292e-01,
 1.228508378955482511e-01,
 1.228328162008619912e-01,
 1.228146009380921694e-01,
 1.227961921990729927e-01,
 1.227775900759019850e-01,
 1.227587946609399461e-01,
 1.227398060468130325e-01,
 1.227206243264099272e-01,
 1.227012495928824776e-01,
 1.226816819396458202e-01,
 1.226619214603782010e-01,
 1.226419682490212937e-01,
 1.226218223997769807e-01,
 1.226014840071115025e-01,
 1.225809531657525847e-01,
 1.225602299706899240e-01,
 1.225393145171734671e-01,
 1.225182069007161867e-01,
 1.224969072170920964e-01,
 1.224754155623356128e-01,
 1.224537320327414719e-01,
 1.224318567248665474e-01,
 1.224097897355254511e-01,
 1.223875311617961259e-01,
 1.223650811010137118e-01,
 1.223424396507737100e-01,
 1.223196069089326349e-01,
 1.222965829736036431e-01,
 1.222733679431610154e-01,
 1.222499619162365908e-01,
 1.222263649917212924e-01,
 1.222025772687641149e-01,
 1.221785988467729289e-01,
 1.221544298254120253e-01,
 1.221300703046050845e-01,
 1.221055203845321929e-01,
 1.220807801656308977e-01,
 1.220558497485961097e-01,
 1.220307292343785627e-01,
 1.220054187241870897e-01,
 1.219799183194855835e-01,
 1.219542281219945096e-01,
 1.219283482336902952e-01,
 1.219022787568051214e-01,
 1.218760197938268536e-01,
 1.218495714474979869e-01,
 1.218229338208157292e-01,
 1.217961070170336946e-01,
 1.217690911396585446e-01,
 1.217418862924517925e-01,
 1.217144925794290261e-01,
 1.216869101048598661e-01,
 1.216591389732677997e-01,
 1.216311792894282096e-01,
 1.216030311583726209e-01,
 1.215746946853825811e-01,
 1.215461699759944614e-01,
 1.215174571359954325e-01,
 1.214885562714268091e-01,
 1.214594674885806913e-01,
 1.214301908940011998e-01,
 1.214007265944839348e-01,
 1.213710746970771553e-01,
 1.213412353090786294e-01,
 1.213112085380375488e-01,
 1.212809944917545846e-01,
 1.212505932782801110e-01,
 1.212200050059143996e-01,
 1.211892297832090071e-01,
 1.211582677189640828e-01,
 1.211271189222293126e-01,
 1.210957835023049461e-01,
 1.210642615687386181e-01,
 1.210325532313280966e-01,
 1.210006586001197149e-01,
 1.209685777854069416e-01,
 1.209363108977330181e-01,
 1.209038580478875441e-01,
 1.208712193469089757e-01,
 1.208383949060828633e-01,
 1.208053848369417677e-01,
 1.207721892512654688e-01,
 1.207388082610799662e-01,
 1.207052419786590614e-01,
 1.206714905165209156e-01,
 1.206375539874317837e-01,
 1.206034325044017530e-01,
 1.205691261806878800e-01,
 1.205346351297915258e-01,
 1.204999594654606598e-01,
 1.204650993016866956e-01,
 1.204300547527059340e-01,
 1.203948259329989667e-01,
 1.203594129572910093e-01,
 1.203238159405510127e-01,
 1.202880349979910252e-01,
 1.202520702450678158e-01,
 1.202159217974796551e-01,
 1.201795897711690070e-01,
 1.201430742823206416e-01,
 1.201063754473617323e-01,
 1.200694933829614119e-01,
 1.200324282060312997e-01,
 1.199951800337245716e-01,
 1.199577489834360300e-01,
 1.199201351728009790e-01,
 1.198823387196968349e-01,
 1.198443597422411688e-01,
 1.198061983587922902e-01,
 1.197678546879481498e-01,
 1.197293288485478946e-01,
 1.196906209596695636e-01,
 1.196517311406312123e-01,
 1.196126595109895524e-01,
 1.195734061905408541e-01,
 1.195339712993206127e-01,
 1.194943549576028552e-01,
 1.194545572858988353e-01,
 1.194145784049589765e-01,
 1.193744184357703186e-01,
 1.193340774995597237e-01,
 1.192935557177891154e-01,
 1.192528532121592683e-01,
 1.192119701046062408e-01,
 1.191709065173034987e-01,
 1.191296625726611103e-01,
 1.190882383933246774e-01,
 1.190466341021767377e-01,
 1.190048498223338774e-01,
 1.189628856771488830e-01,
 1.189207417902100050e-01,
 1.188784182853395710e-01,
 1.188359152865954005e-01,
 1.187932329182692370e-01,
 1.187503713048870257e-01,
 1.187073305712076088e-01,
 1.186641108422255564e-01,
 1.186207122431665456e-01,
 1.185771348994915236e-01,
 1.185333789368925306e-01,
 1.184894444812948366e-01,
 1.184453316588566230e-01,
 1.184010405959678575e-01,
 1.183565714192496982e-01,
 1.183119242555555339e-01,
 1.182670992319704573e-01,
 1.182220964758100012e-01,
 1.181769161146210279e-01,
 1.181315582761808675e-01,
 1.180860230884968193e-01,
 1.180403106798064289e-01,
 1.179944211785777658e-01,
 1.179483547135078275e-01,
 1.179021114135223730e-01,
 1.178556914077777684e-01,
 1.178090948256578785e-01,
 1.177623217967764119e-01,
 1.177153724509734239e-01,
 1.176682469183190222e-01,
 1.176209453291098550e-01,
 1.175734678138708883e-01,
 1.175258145033537260e-01,
 1.174779855285371516e-01,
 1.174299810206274053e-01,
 1.173818011110562137e-01,
 1.173334459314819278e-01,
 1.172849156137895782e-01,
 1.172362102900887937e-01,
 1.171873300927154110e-01,
 1.171382751542306005e-01,
 1.170890456074201863e-01,
 1.170396415852939659e-01,
 1.169900632210876396e-01,
 1.169403106482601318e-01,
 1.168903840004944239e-01,
 1.168402834116975958e-01,
 1.167900090159995213e-01,
 1.167395609477533541e-01,
 1.166889393415357773e-01,
 1.166381443321451300e-01,
 1.165871760546025176e-01,
 1.165360346441511874e-01,
 1.164847202362565559e-01,
 1.164332329666049465e-01,
 1.163815729711040886e-01,
 1.163297403858830903e-01,
 1.162777353472922021e-01,
 1.162255579919010545e-01,
 1.161732084565003098e-01,
 1.161206868781004403e-01,
 1.160679933939316871e-01,
 1.160151281414441571e-01,
 1.159620912583062685e-01,
 1.159088828824058753e-01,
 1.158555031518493095e-01,
 1.158019522049617278e-01,
 1.157482301802862518e-01,
 1.156943372165835510e-01,
 1.156402734528316073e-01,
 1.155860390282271305e-01,
 1.155316340821825050e-01,
 1.154770587543277605e-01,
 1.154223131845084627e-01,
 1.153673975127878087e-01,
 1.153123118794434215e-01,
 1.152570564249705276e-01,
 1.152016312900780992e-01,
 1.151460366156913245e-01,
 1.150902725429496787e-01,
 1.150343392132075343e-01,
 1.149782367680347583e-01,
 1.149219653492130760e-01,
 1.148655250987398457e-01,
 1.148089161588256857e-01,
 1.147521386718936415e-01,
 1.146951927805808652e-01,
 1.146380786277371444e-01,
 1.145807963564242221e-01,
 1.145233461099159356e-01,
 1.144657280316986742e-01,
 1.144079422654709632e-01,
 1.143499889551411741e-01,
 1.142918682448306050e-01,
 1.142335802788696786e-01,
 1.141751252018012169e-01,
 1.141165031583765144e-01,
 1.140577142935587651e-01,
 1.139987587525192053e-01,
 1.139396366806400829e-01,
 1.138803482235115488e-01,
 1.138208935269335864e-01,
 1.137612727369151644e-01,
 1.137014859996719612e-01,
 1.136415334616300288e-01,
 1.135814152694219620e-01,
 1.135211315698884671e-01,
 1.134606825100760441e-01,
 1.134000682372408308e-01,
 1.133392888988433711e-01,
 1.132783446425527085e-01,
 1.132172356162420429e-01,
 1.131559619679921164e-01,
 1.130945238460886321e-01,
 1.130329213990227816e-01,
 1.129711547754914808e-01,
 1.129092241243942751e-01,
 1.128471295948383218e-01,
 1.127848713361325333e-01,
 1.127224494977913660e-01,
 1.126598642295325581e-01,
 1.125971156812769769e-01,
 1.125342040031486607e-01,
 1.124711293454753319e-01,
 1.124078918587860798e-01,
 1.123444916938132199e-01,
 1.122809290014908090e-01,
 1.122172039329543541e-01,
 1.121533166395414644e-01,
 1.120892672727912404e-01,
 1.120250559844416655e-01,
 1.119606829264341852e-01,
 1.118961482509084754e-01,
 1.118314521102054399e-01,
 1.117665946568652535e-01,
 1.117015760436278621e-01,
 1.116363964234318579e-01,
 1.115710559494157705e-01,
 1.115055547749161380e-01,
 1.114398930534678395e-01,
 1.113740709388042621e-01,
 1.113080885848565932e-01,
 1.112419461457532788e-01,
 1.111756437758196492e-01,
 1.111091816295791124e-01,
 1.110425598617505033e-01,
 1.109757786272503322e-01,
 1.109088380811900226e-01,
 1.108417383788782989e-01,
 1.107744796758178552e-01,
 1.107070621277075478e-01,
 1.106394858904409390e-01,
 1.105717511201065317e-01,
 1.105038579729868270e-01,
 1.104358066055591420e-01,
 1.103675971744941114e-01,
 1.102992298366558127e-01,
 1.102307047491020570e-01,
 1.101620220690832513e-01,
 1.100931819540428708e-01,
 1.100241845616167086e-01,
 1.099550300496322242e-01,
 1.098857185761093064e-01,
 1.098162502992588718e-01,
 1.097466253774839057e-01,
 1.096768439693773661e-01,
 1.096069062337238220e-01,
 1.095368123294973295e-01,
 1.094665624158630973e-01,
 1.093961566521751694e-01,
 1.093255951979779511e-01,
 1.092548782130043500e-01,
 1.091840058571770106e-01,
 1.091129782906064549e-01,
 1.090417956735922761e-01,
 1.089704581666215422e-01,
 1.088989659303698926e-01,
 1.088273191256994843e-01,
 1.087555179136605876e-01,
 1.086835624554898933e-01,
 1.086114529126108591e-01,
 1.085391894466340157e-01,
 1.084667722193540518e-01,
 1.083942013927532699e-01,
 1.083214771289988804e-01,
 1.082485995904434034e-01,
 1.081755689396235037e-01,
 1.081023853392612116e-01,
 1.080290489522630210e-01,
 1.079555599417184875e-01,
 1.078819184709017276e-01,
 1.078081247032701834e-01,
 1.077341788024640534e-01,
 1.076600809323071117e-01,
 1.075858312568042374e-01,
 1.075114299401445095e-01,
 1.074368771466978068e-01,
 1.073621730410154046e-01,
 1.072873177878308076e-01,
 1.072123115520577236e-01,
 1.071371544987919089e-01,
 1.070618467933081713e-01,
 1.069863886010620768e-01,
 1.069107800876900882e-01,
 1.068350214190067482e-01,
 1.067591127610068164e-01,
 1.066830542798632986e-01,
 1.066068461419292512e-01,
 1.065304885137346308e-01,
 1.064539815619885144e-01,
 1.063773254535774482e-01,
 1.063005203555659056e-01,
 1.062235664351947606e-01,
 1.061464638598832028e-01,
 1.060692127972254623e-01,
 1.059918134149930302e-01,
 1.059142658811336180e-01,
 1.058365703637699218e-01,
 1.057587270312010524e-01,
 1.056807360519009253e-01,
 1.056025975945174417e-01,
 1.055243118278741538e-01,
 1.054458789209690162e-01,
 1.053672990429730255e-01,
 1.052885723632309561e-01,
 1.052096990512617902e-01,
 1.051306792767569692e-01,
 1.050515132095811988e-01,
 1.049722010197703670e-01,
 1.048927428775339316e-01,
 1.048131389532530044e-01,
 1.047333894174798524e-01,
 1.046534944409378970e-01,
 1.045734541945217977e-01,
 1.044932688492971051e-01,
 1.044129385764991924e-01,
 1.043324635475341988e-01,
 1.042518439339772812e-01,
 1.041710799075736688e-01,
 1.040901716402378857e-01,
 1.040091193040521417e-01,
 1.039279230712686353e-01,
 1.038465831143067092e-01,
 1.037650996057549874e-01,
 1.036834727183680860e-01,
 1.036017026250695416e-01,
 1.035197894989485501e-01,
 1.034377335132619646e-01,
 1.033555348414334635e-01,
 1.032731936570512321e-01,
 1.031907101338709887e-01,
 1.031080844458131945e-01,
 1.030253167669639147e-01,
 1.029424072715734162e-01,
 1.028593561340572365e-01,
 1.027761635289951153e-01,
 1.026928296311310079e-01,
 1.026093546153720726e-01,
 1.025257386567893086e-01,
 1.024419819306166962e-01,
 1.023580846122503912e-01,
 1.022740468772503075e-01,
 1.021898689013379519e-01,
 1.021055508603961881e-01,
 1.020210929304704306e-01,
 1.019364952877659936e-01,
 1.018517581086511165e-01,
 1.017668815696524537e-01,
 1.016818658474593629e-01,
 1.015967111189189503e-01,
 1.015114175610400127e-01,
 1.014259853509894699e-01,
 1.013404146660938365e-01,
 1.012547056838388193e-01,
 1.011688585818675823e-01,
 1.010828735379832033e-01,
 1.009967507301447048e-01,
 1.009104903364702460e-01,
 1.008240925352345135e-01,
 1.007375575048689298e-01,
 1.006508854239629575e-01,
 1.005640764712604079e-01,
 1.004771308256628831e-01,
 1.003900486662266250e-01,
 1.003028301721639870e-01,
 1.002154755228428507e-01,
 1.001279848977841419e-01,
 1.000403584766646481e-01,
 9.995259643931600491e-02,
 9.986469896572192084e-02,
 9.977666623602088336e-02,
 9.968849843050490989e-02,
 9.960019572961810452e-02,
 9.951175831395762950e-02,
 9.942318636427292800e-02,
 9.933448006146579357e-02,
 9.924563958658925988e-02,
 9.915666512084808648e-02,
 9.906755684559800934e-02,
 9.897831494234581029e-02,
 9.888893959274833168e-02,
 9.879943097861319801e-02,
 9.870978928189680368e-02,
 9.862001468470667220e-02,
 9.853010736929748714e-02,
 9.844006751807542199e-02,
 9.834989531359294990e-02,
 9.825959093855247961e-02,
 9.816915457580296933e-02,
 9.807858640834260511e-02,
 9.798788661931552568e-02,
 9.789705539201394580e-02,
 9.780609290987682392e-02,
 9.771499935648829405e-02,
 9.762377491557984455e-02,
 9.753241977102884708e-02,
 9.744093410685686352e-02,
 9.734931810723226886e-02,
 9.725757195646732300e-02,
 9.716569583901932261e-02,
 9.707368993948892189e-02,
 9.698155444262161751e-02,
 9.688928953330600002e-02,
 9.679689539657485020e-02,
 9.670437221760269653e-02,
 9.661172018170716136e-02,
 9.651893947434861398e-02,
 9.642603028112961550e-02,
 9.633299278779315633e-02,
 9.623982718022539018e-02,
 9.614653364445252537e-02,
 9.605311236664149099e-02,
 9.595956353309974263e-02,
 9.586588733027553988e-02,
 9.577208394475643372e-02,
 9.567815356326922482e-02,
 9.558409637268089343e-02,
 9.548991255999643435e-02,
 9.539560231235937049e-02,
 9.530116581705226630e-02,
 9.520660326149503472e-02,
 9.511191483324533957e-02,
 9.501710071999781848e-02,
 9.492216110958506814e-02,
 9.482709618997517409e-02,
 9.473190614927322339e-02,
 9.463659117572056911e-02,
 9.454115145769388662e-02,
 9.444558718370585360e-02,
 9.434989854240258267e-02,
 9.425408572256706308e-02,
 9.415814891311567736e-02,
 9.406208830309908953e-02,
 9.396590408170145403e-02,
 9.386959643824113741e-02,
 9.377316556216962196e-02,
 9.367661164307011790e-02,
 9.357993487066006144e-02,
 9.348313543478795062e-02,
 9.338621352543438614e-02,
 9.328916933271230727e-02,
 9.319200304686481307e-02,
 9.309471485826663339e-02,
 9.299730495742321301e-02,
 9.289977353496980950e-02,
 9.280212078167231204e-02,
 9.270434688842620063e-02,
 9.260645204625565785e-02,
 9.250843644631487339e-02,
 9.241030027988553219e-02,
 9.231204373837895161e-02,
 9.221366701333413851e-02,
 9.211517029641765053e-02,
 9.201655377942345726e-02,
 9.191781765427298190e-02,
 9.181896211301451838e-02,
 9.171998734782245422e-02,
 9.162089355099709009e-02,
 9.152168091496593050e-02,
 9.142234963228039468e-02,
 9.132289989561817589e-02,
 9.122333189778122908e-02,
 9.112364583169653420e-02,
 9.102384189041493046e-02,
 9.092392026711162978e-02,
 9.082388115508510662e-02,
 9.072372474775707019e-02,
 9.062345123867286689e-02,
 9.052306082149942645e-02,
 9.042255369002651089e-02,
 9.032193003816592347e-02,
 9.022119005995155039e-02,
 9.012033394953773702e-02,
 9.001936190120085612e-02,
 8.991827410933699027e-02,
 8.981707076846308369e-02,
 8.971575207321641487e-02,
 8.961431821835352807e-02,
 8.951276939875092709e-02,
 8.941110580940381247e-02,
 8.930932764542605373e-02,
 8.920743510204980076e-02,
 8.910542837462678833e-02,
 8.900330765862447813e-02,
 8.890107314962976404e-02,
 8.879872504334471173e-02,
 8.869626353558995868e-02,
 8.859368882230200803e-02,
 8.849100109953332571e-02,
 8.838820056345265963e-02,
 8.828528741034395722e-02,
 8.818226183660678175e-02,
 8.807912403875493845e-02,
 8.797587421341766800e-02,
 8.787251255733782851e-02,
 8.776903926737232575e-02,
 8.766545454049214092e-02,
 8.756175857378087346e-02,
 8.745795156443547658e-02,
 8.735403370976568826e-02,
 8.725000520719275454e-02,
 8.714586625425090050e-02,
 8.704161704858559556e-02,
 8.693725778795330372e-02,
 8.683278867022194147e-02,
 8.672820989337026720e-02,
 8.662352165548690974e-02,
 8.651872415477071532e-02,
 8.641381758953071979e-02,
 8.630880215818437229e-02,
 8.620367805925918669e-02,
 8.609844549139078485e-02,
 8.599310465332328512e-02,
 8.588765574390939961e-02,
 8.578209896210858831e-02,
 8.567643450698882168e-02,
 8.557066257772484585e-02,
 8.546478337359757205e-02,
 8.535879709399585291e-02,
 8.525270393841262451e-02,
 8.514650410644819534e-02,
 8.504019779780785937e-02,
 8.493378521230204869e-02,
 8.482726654984627801e-02,
 8.472064201045992338e-02,
 8.461391179426755449e-02,
 8.450707610149670035e-02,
 8.440013513247873744e-02,
 8.429308908764845953e-02,
 8.418593816754310621e-02,
 8.407868257280276536e-02,
 8.397132250416963761e-02,
 8.386385816248774494e-02,
 8.375628974870316656e-02,
 8.364861746386266506e-02,
 8.354084150911393614e-02,
 8.343296208570576133e-02,
 8.332497939498660633e-02,
 8.321689363840517606e-02,
 8.310870501750960981e-02,
 8.300041373394763389e-02,
 8.289201998946534033e-02,
 8.278352398590869965e-02,
 8.267492592521996642e-02,
 8.256622600944162060e-02,
 8.245742444071237076e-02,
 8.234852142126795893e-02,
 8.223951715344250679e-02,
 8.213041183966539316e-02,
 8.202120568246340504e-02,
 8.191189888445904455e-02,
 8.180249164836968234e-02,
 8.169298417700904258e-02,
 8.158337667328570408e-02,
 8.147366934020223994e-02,
 8.136386238085671629e-02,
 8.125395599843998617e-02,
 8.114395039623799322e-02,
 8.103384577762853813e-02,
 8.092364234608373508e-02,
 8.081334030516779121e-02,
 8.070293985853765895e-02,
 8.059244120994196736e-02,
 8.048184456322146629e-02,
 8.037115012230773570e-02,
 8.026035809122414322e-02,
 8.014946867408433151e-02,
 8.003848207509299539e-02,
 7.992739849854386958e-02,
 7.981621814882140786e-02,
 7.970494123039907619e-02,
 7.959356794783993549e-02,
 7.948209850579460167e-02,
 7.937053310900338277e-02,
 7.925887196229440546e-02,
 7.914711527058303220e-02,
 7.903526323887326288e-02,
 7.892331607225480661e-02,
 7.881127397590532990e-02,
 7.869913715508843055e-02,
 7.858690581515383189e-02,
 7.847458016153693872e-02,
 7.836216039975925363e-02,
 7.824964673542704474e-02,
 7.813703937423149837e-02,
 7.802433852194819164e-02,
 7.791154438443669006e-02,
 7.779865716764088057e-02,
 7.768567707758798624e-02,
 7.757260432038814990e-02,
 7.745943910223469786e-02,
 7.734618162940309904e-02,
 7.723283210825153400e-02,
 7.711939074521963200e-02,
 7.700585774682908169e-02,
 7.689223331968160491e-02,
 7.677851767046139919e-02,
 7.666471100593179322e-02,
 7.655081353293700930e-02,
 7.643682545840160825e-02,
 7.632274698932831059e-02,
 7.620857833280046678e-02,
 7.609431969597967027e-02,
 7.597997128610591011e-02,
 7.586553331049795956e-02,
 7.575100597655208545e-02,
 7.563638949174236736e-02,
 7.552168406361979558e-02,
 7.540688989981250701e-02,
 7.529200720802532720e-02,
 7.517703619603874343e-02,
 7.506197707171027855e-02,
 7.494683004297160445e-02,
 7.483159531783091512e-02,
 7.471627310437081726e-02,
 7.460086361074855232e-02,
 7.448536704519538587e-02,
 7.436978361601642717e-02,
 7.425411353159150352e-02,
 7.413835700037232912e-02,
 7.402251423088439253e-02,
 7.390658543172499984e-02,
 7.379057081156521758e-02,
 7.367447057914629227e-02,
 7.355828494328230105e-02,
 7.344201411285851411e-02,
 7.332565829683018732e-02,
 7.320921770422399166e-02,
 7.309269254413744421e-02,
 7.297608302573657668e-02,
 7.285938935825866936e-02,
 7.274261175100868448e-02,
 7.262575041336212511e-02,
 7.250880555476157951e-02,
 7.239177738471935797e-02,
 7.227466611281514741e-02,
 7.215747194869544245e-02,
 7.204019510207586297e-02,
 7.192283578273746258e-02,
 7.180539420052874100e-02,
 7.168787056536443658e-02,
 7.157026508722452718e-02,
 7.145257797615588158e-02,
 7.133480944226988640e-02,
 7.121695969574322327e-02,
 7.109902894681666141e-02,
 7.098101740579629282e-02,
 7.086292528305147831e-02,
 7.074475278901563857e-02,
 7.062650013418521333e-02,
 7.050816752911974461e-02,
 7.038975518444141877e-02,
 7.027126331083567712e-02,
 7.015269211904812119e-02,
 7.003404181988766297e-02,
 6.991531262422381876e-02,
 6.979650474298738916e-02,
 6.967761838716966805e-02,
 6.955865376782244258e-02,
 6.943961109605778503e-02,
 6.932049058304656786e-02,
 6.920129244002048985e-02,
 6.908201687826878712e-02,
 6.896266410913988454e-02,
 6.884323434404160391e-02,
 6.872372779443805535e-02,
 6.860414467185256548e-02,
 6.848448518786488803e-02,
 6.836474955411209198e-02,
 6.824493798228813135e-02,
 6.812505068414359544e-02,
 6.800508787148455692e-02,
 6.788504975617229431e-02,
 6.776493655012509609e-02,
 6.764474846531513819e-02,
 6.752448571376944153e-02,
 6.740414850756967780e-02,
 6.728373705885141998e-02,
 6.716325157980407301e-02,
 6.704269228267065173e-02,
 6.692205937974621266e-02,
 6.680135308338028266e-02,
 6.668057360597301475e-02,
 6.655972115997782490e-02,
 6.643879595789932424e-02,
 6.631779821229390193e-02,
 6.619672813576903125e-02,
 6.607558594098189575e-02,
 6.595437184064194269e-02,
 6.583308604750687243e-02,
 6.571172877438540005e-02,
 6.559030023413518762e-02,
 6.546880063966260821e-02,
 6.534723020392378678e-02,
 6.522558913992218543e-02,
 6.510387766071037974e-02,
 6.498209597938786608e-02,
 6.486024430910179717e-02,
 6.473832286304685713e-02,
 6.461633185446398475e-02,
 6.449427149664092862e-02,
 6.437214200291108135e-02,
 6.424994358665431227e-02,
 6.412767646129516330e-02,
 6.400534084030372328e-02,
 6.388293693719500344e-02,
 6.376046496552824350e-02,
 6.363792513890670355e-02,
 6.351531767097745584e-02,
 6.339264277543119053e-02,
 6.326990066600207685e-02,
 6.314709155646583416e-02,
 6.302421566064252134e-02,
 6.290127319239229020e-02,
 6.277826436561871615e-02,
 6.265518939426630018e-02,
 6.253204849232023299e-02,
 6.240884187380699166e-02,
 6.228556975279354868e-02,
 6.216223234338666415e-02,
 6.203882985973369069e-02,
 6.191536251602060281e-02,
 6.179183052647276020e-02,
 6.166823410535456768e-02,
 6.154457346696896175e-02,
 6.142084882565666121e-02,
 6.129706039579653487e-02,
 6.117320839180501874e-02,
 6.104929302813518616e-02,
 6.092531451927746949e-02,
 6.080127307975887602e-02,
 6.067716892414249524e-02,
 6.055300226702678423e-02,
 6.042877332304623372e-02,
 6.030448230687033423e-02,
 6.018012943320360381e-02,
 6.005571491678464435e-02,
 5.993123897238688408e-02,
 5.980670181481695380e-02,
 5.968210365891589431e-02,
 5.955744471955665836e-02,
 5.943272521164659483e-02,
 5.930794535012441637e-02,
 5.918310534996130273e-02,
 5.905820542616079666e-02,
 5.893324579375752714e-02,
 5.880822666781746616e-02,
 5.868314826343760948e-02,
 5.855801079574508849e-02,
 5.843281447989770450e-02,
 5.830755953108344297e-02,
 5.818224616451869030e-02,
 5.805687459545036400e-02,
 5.793144503915334531e-02,
 5.780595771093211682e-02,
 5.768041282611801462e-02,
 5.755481060007185817e-02,
 5.742915124818046696e-02,
 5.730343498585933892e-02,
 5.717766202855046470e-02,
 5.705183259172152965e-02,
 5.692594689086755838e-02,
 5.680000514150926327e-02,
 5.667400755919276695e-02,
 5.654795435948991450e-02,
 5.642184575799652491e-02,
 5.629568197033452820e-02,
 5.616946321214868337e-02,
 5.604318969910879189e-02,
 5.591686164690740785e-02,
 5.579047927126113554e-02,
 5.566404278790936661e-02,
 5.553755241261368325e-02,
 5.541100836115846195e-02,
 5.528441084934981181e-02,
 5.515776009301600474e-02,
 5.503105630800604608e-02,
 5.490429971019036848e-02,
 5.477749051545931919e-02,
 5.465062893972471442e-02,
 5.452371519891744539e-02,
 5.439674950898862327e-02,
 5.426973208590860076e-02,
 5.414266314566684030e-02,
 5.401554290427087318e-02,
 5.388837157774782616e-02,
 5.376114938214159727e-02,
 5.363387653351438245e-02,
 5.350655324794587747e-02,
 5.337917974153275763e-02,
 5.325175623038851114e-02,
 5.312428293064230117e-02,
 5.299676005844035365e-02,
 5.286918782994443067e-02,
 5.274156646133112969e-02,
 5.261389616879269537e-02,
 5.248617716853616610e-02,
 5.235840967678221519e-02,
 5.223059390976659416e-02,
 5.210273008373848824e-02,
 5.197481841496048166e-02,
 5.184685911970805111e-02,
 5.171885241427014168e-02,
 5.159079851494733499e-02,
 5.146269763805298714e-02,
 5.133454999991197976e-02,
 5.120635581686053261e-02,
 5.107811530524643956e-02,
 5.094982868142789584e-02,
 5.082149616177403240e-02,
 5.069311796266388198e-02,
 5.056469430048638608e-02,
 5.043622539163985369e-02,
 5.030771145253223192e-02,
 5.017915269957953089e-02,
 5.005054934920732945e-02,
 4.992190161784838126e-02,
 4.979320972194434952e-02,
 4.966447387794360041e-02,
 4.953569430230227166e-02,
 4.940687121148304439e-02,
 4.927800482195535819e-02,
 4.914909535019557074e-02,
 4.902014301268413365e-02,
 4.889114802590894399e-02,
 4.876211060636266581e-02,
 4.863303097054242491e-02,
 4.850390933495044715e-02,
 4.837474591609278174e-02,
 4.824554093048027265e-02,
 4.811629459462654634e-02,
 4.798700712504914284e-02,
 4.785767873826820423e-02,
 4.772830965080678001e-02,
 4.759890007919009153e-02,
 4.746945023994546264e-02,
 4.733996034960209071e-02,
 4.721043062469039431e-02,
 4.708086128174165941e-02,
 4.695125253728817116e-02,
 4.682160460786235351e-02,
 4.669191770999694263e-02,
 4.656219206022417512e-02,
 4.643242787507584346e-02,
 4.630262537108296994e-02,
 4.617278476477499477e-02,
 4.604290627268040059e-02,
 4.591299011132470714e-02,
 4.578303649723236557e-02,
 4.565304564692526657e-02,
 4.552301777692096402e-02,
 4.539295310373590853e-02,
 4.526285184388120081e-02,
 4.513271421386549215e-02,
 4.500254043019286804e-02,
 4.487233070936218898e-02,
 4.474208526786875584e-02,
 4.461180432220186037e-02,
 4.448148808884577060e-02,
 4.435113678427868300e-02,
 4.422075062497268783e-02,
 4.409032982739415074e-02,
 4.395987460800166585e-02,
 4.382938518324764471e-02,
 4.369886176957654689e-02,
 4.356830458342535184e-02,
 4.343771384122318419e-02,
 4.330708975939056432e-02,
 4.317643255433911698e-02,
 4.304574244247184878e-02,
 4.291501964018251680e-02,
 4.278426436385496245e-02,
 4.265347682986306288e-02,
 4.252265725457072404e-02,
 4.239180585433070109e-02,
 4.226092284548542410e-02,
 4.213000844436578379e-02,
 4.199906286729073596e-02,
 4.186808633056808560e-02,
 4.173707905049264116e-02,
 4.160604124334756765e-02,
 4.147497312540214531e-02,
 4.134387491291315053e-02,
 4.121274682212387741e-02,
 4.108158906926306225e-02,
 4.095040187054669462e-02,
 4.081918544217466582e-02,
 4.068794000033293390e-02,
 4.055666576119273253e-02,
 4.042536294090882248e-02,
 4.029403175562108058e-02,
 4.016267242145298011e-02,
 4.003128515451145897e-02,
 3.989987017088710702e-02,
 3.976842768665321548e-02,
 3.963695791786571443e-02,
 3.950546108056282590e-02,
 3.937393739076531368e-02,
 3.924238706447455427e-02,
 3.911081031767430632e-02,
 3.897920736632929511e-02,
 3.884757842638417169e-02,
 3.871592371376472025e-02,
 3.858424344437670628e-02,
 3.845253783410521736e-02,
 3.832080709881537789e-02,
 3.818905145435110005e-02,
 3.805727111653543077e-02,
 3.792546630116917089e-02,
 3.779363722403243642e-02,
 3.766178410088195927e-02,
 3.752990714745306489e-02,
 3.739800657945793749e-02,
 3.726608261258499560e-02,
 3.713413546250050878e-02,
 3.700216534484568331e-02,
 3.687017247523863284e-02,
 3.673815706927296282e-02,
 3.660611934251705585e-02,
 3.647405951051500839e-02,
 3.634197778878487523e-02,
 3.620987439281974501e-02,
 3.607774953808617902e-02,
 3.594560344002471763e-02,
 3.581343631404947103e-02,
 3.568124837554722401e-02,
 3.554903983987809518e-02,
 3.541681092237405210e-02,
 3.528456183833964671e-02,
 3.515229280305118276e-02,
 3.502000403175643817e-02,
 3.488769573967393650e-02,
 3.475536814199385593e-02,
 3.462302145387653046e-02,
 3.449065589045249153e-02,
 3.435827166682210027e-02,
 3.422586899805592914e-02,
 3.409344809919301333e-02,
 3.396100918524215528e-02,
 3.382855247118018299e-02,
 3.369607817195242189e-02,
 3.356358650247277808e-02,
 3.343107767762205917e-02,
 3.329855191224895261e-02,
 3.316600942116944284e-02,
 3.303345041916565944e-02,
 3.290087512098689715e-02,
 3.276828374134796440e-02,
 3.263567649492971762e-02,
 3.250305359637883917e-02,
 3.237041526030674798e-02,
 3.223776170129034890e-02,
 3.210509313387041597e-02,
 3.197240977255257077e-02,
 3.183971183180590858e-02,
 3.170699952606379629e-02,
 3.157427306972222791e-02,
 3.144153267714033112e-02,
 3.130877856264076275e-02,
 3.117601094050728716e-02,
 3.104323002498658723e-02,
 3.091043603028733114e-02,
 3.077762917057849310e-02,
 3.064480965999161546e-02,
 3.051197771261774869e-02,
 3.037913354250956766e-02,
 3.024627736367913391e-02,
 3.011340939009863119e-02,
 2.998052983570006699e-02,
 2.984763891437447123e-02,
 2.971473683997208695e-02,
 2.958182382630135041e-02,
 2.944890008712947038e-02,
 2.931596583618149843e-02,
 2.918302128714032884e-02,
 2.905006665364592844e-02,
 2.891710214929537476e-02,
 2.878412798764298786e-02,
 2.865114438219937623e-02,
 2.851815154643094069e-02,
 2.838514969376047456e-02,
 2.825213903756565795e-02,
 2.811911979118035879e-02,
 2.798609216789231177e-02,
 2.785305638094435349e-02,
 2.772001264353386035e-02,
 2.758696116881169738e-02,
 2.745390216988301615e-02,
 2.732083585980545765e-02,
 2.718776245159063368e-02,
 2.705468215820261077e-02,
 2.692159519255757708e-02,
 2.678850176752468545e-02,
 2.665540209592342710e-02,
 2.652229639052629262e-02,
 2.638918486405657932e-02,
 2.625606772918802345e-02,
 2.612294519854553229e-02,
 2.598981748470386918e-02,
 2.585668480018838561e-02,
 2.572354735747322402e-02,
 2.559040536898277846e-02,
 2.545725904709003271e-02,
 2.532410860411645620e-02,
 2.519095425233297200e-02,
 2.505779620395739288e-02,
 2.492463467115624970e-02,
 2.479146986604362224e-02,
 2.465830200068009834e-02,
 2.452513128707402290e-02,
 2.439195793717985339e-02,
 2.425878216289821879e-02,
 2.412560417607638105e-02,
 2.399242418850654895e-02,
 2.385924241192719994e-02,
 2.372605905802084927e-02,
 2.359287433841599987e-02,
 2.345968846468437716e-02,
 2.332650164834279213e-02,
 2.319331410085199649e-02,
 2.306012603361528787e-02,
 2.292693765798032787e-02,
 2.279374918523716098e-02,
 2.266056082661850601e-02,
 2.252737279330007530e-02,
 2.239418529639852426e-02,
 2.226099854697329364e-02,
 2.212781275602454870e-02,
 2.199462813449416451e-02,
 2.186144489326440413e-02,
 2.172826324315801569e-02,
 2.159508339493851348e-02,
 2.146190555930881441e-02,
 2.132872994691196664e-02,
 2.119555676832975827e-02,
 2.106238623408334884e-02,
 2.092921855463282521e-02,
 2.079605394037628563e-02,
 2.066289260164996811e-02,
 2.052973474872833021e-02,
 2.039658059182285904e-02,
 2.026343034108272004e-02,
 2.013028420659354958e-02,
 1.999714239837804830e-02,
 1.986400512639472857e-02,
 1.973087260053882006e-02,
 1.959774503064056275e-02,
 1.946462262646581759e-02,
 1.933150559771592072e-02,
 1.919839415402643107e-02,
 1.906528850496813643e-02,
 1.893218886004534307e-02,
 1.879909542869666675e-02,
 1.866600842029450882e-02,
 1.853292804414400155e-02,
 1.839985450948403503e-02,
 1.826678802548559882e-02,
 1.813372880125229888e-02,
 1.800067704582019798e-02,
 1.786763296815667076e-02,
 1.773459677716114971e-02,
 1.760156868166379979e-02,
 1.746854889042620193e-02,
 1.733553761214001038e-02,
 1.720253505542803166e-02,
 1.706954142884242395e-02,
 1.693655694086509261e-02,
 1.680358179990786710e-02,
 1.667061621431171342e-02,
 1.653766039234588064e-02,
 1.640471454220893480e-02,
 1.627177887202691658e-02,
 1.613885358985477775e-02,
 1.600593890367427163e-02,
 1.587303502139496281e-02,
 1.574014215085360255e-02,
 1.560726049981335170e-02,
 1.547439027596448149e-02,
 1.534153168692272903e-02,
 1.520868494023027741e-02,
 1.507585024335505140e-02,
 1.494302780368951533e-02,
 1.481021782855237480e-02,
 1.467742052518559298e-02,
 1.454463610075668045e-02,
 1.441186476235717384e-02,
 1.427910671700199571e-02,
 1.414636217163019009e-02,
 1.401363133310348091e-02,
 1.388091440820720703e-02,
 1.374821160364880779e-02,
 1.361552312605862625e-02,
 1.348284918198881105e-02,
 1.335018997791313951e-02,
 1.321754572022749985e-02,
 1.308491661524840456e-02,
 1.295230286921365305e-02,
 1.281970468828179388e-02,
 1.268712227853122446e-02,
 1.255455584596109307e-02,
 1.242200559648972726e-02,
 1.228947173595504490e-02,
 1.215695447011459589e-02,
 1.202445400464420208e-02,
 1.189197054513899295e-02,
 1.175950429711163960e-02,
 1.162705546599367840e-02,
 1.149462425713353338e-02,
 1.136221087579782942e-02,
 1.122981552717034967e-02,
 1.109743841635077964e-02,
 1.096507974835660669e-02,
 1.083273972812076949e-02,
 1.070041856049271101e-02,
 1.056811645023763777e-02,
 1.043583360203567158e-02,
 1.030357022048279496e-02,
 1.017132651008908518e-02,
 1.003910267527997717e-02,
 9.906898920394662314e-03,
 9.774715449686326163e-03,
 9.642552467322334023e-03,
 9.510410177382898692e-03,
 9.378288783862038028e-03,
 9.246188490665883594e-03,
 9.114109501613693737e-03,
 8.982052020437260309e-03,
 8.850016250779193031e-03,
 8.718002396195186771e-03,
 8.586010660151350074e-03,
 8.454041246025644982e-03,
 8.322094357106717827e-03,
 8.190170196593397900e-03,
 8.058268967595455523e-03,
 7.926390873131988757e-03,
 7.794536116132512807e-03,
 7.662704899435463825e-03,
 7.530897425788461719e-03,
 7.399113897848479289e-03,
 7.267354518180458786e-03,
 7.135619489258314581e-03,
 7.003909013463298187e-03,
 6.872223293084909861e-03,
 6.740562530320158736e-03,
 6.608926927272878483e-03,
 6.477316685953916388e-03,
 6.345732008280667580e-03,
 6.214173096077148760e-03,
 6.082640151073486455e-03,
 5.951133374904993278e-03,
 5.819652969113208764e-03,
 5.688199135144218418e-03,
 5.556772074349722312e-03,
 5.425371987985557962e-03,
 5.293999077211883342e-03,
 5.162653543093584547e-03,
 5.031335586598574029e-03,
 4.900045408599046533e-03,
 4.768783209869731365e-03,
 4.637549191088887260e-03,
 4.506343552837484452e-03,
 4.375166495598339922e-03,
 4.244018219757142614e-03,
 4.112898925600956372e-03,
 3.981808813318376931e-03,
 3.850748082999884501e-03,
 3.719716934636255190e-03,
 3.588715568119755801e-03,
 3.457744183242414306e-03,
 3.326802979697159133e-03,
 3.195892157076147318e-03,
 3.065011914871916369e-03,
 2.934162452475799158e-03,
 2.803343969178269997e-03,
 2.672556664168948548e-03,
 2.541800736536040800e-03,
 2.411076385265443090e-03,
 2.280383809241809823e-03,
 2.149723207246768009e-03,
 2.019094777960114221e-03,
 1.888498719958301483e-03,
 1.757935231714651122e-03,
 1.627404511599681502e-03,
 1.496906757879515326e-03,
 1.366442168717083103e-03,
 1.236010942170407724e-03,
 1.105613276193567881e-03,
 9.752493686359166867e-04,
 8.449194172412430402e-04,
 7.146236196489577468e-04,
 5.843621733916406179e-04,
 4.541352758971314092e-04,
 3.239431244869852124e-04,
 1.937859163758393348e-04,
 6.366384867241073873e-05,
-6.642288162222435724e-05,
-1.964740776134523434e-04,
-3.264895425148430647e-04,
-4.564690796469690701e-04,
-5.864124924389461967e-04,
-7.163195844281591710e-04,
-8.461901592599859780e-04,
-9.760240206893348262e-04,
-1.105820972579655030e-03,
-1.235580818903738018e-03,
-1.365303363744533845e-03,
-1.494988411294153295e-03,
-1.624635765855397037e-03,
-1.754245231841496935e-03,
-1.883816613775824182e-03,
-2.013349716293424095e-03,
-2.142844344139863827e-03,
-2.272300302172896181e-03,
-2.401717395361329440e-03,
-2.531095428786706795e-03,
-2.660434207642344874e-03,
-2.789733537233906203e-03,
-2.918993222980979536e-03,
-3.048213070414972168e-03,
-3.177392885181561967e-03,
-3.306532473039499546e-03,
-3.435631639861427052e-03,
-3.564690191634654025e-03,
-3.693707934460224544e-03,
-3.822684674554552211e-03,
-3.951620218248314692e-03,
-4.080514371987885303e-03,
-4.209366942335140450e-03,
-4.338177735967168637e-03,
-4.466946559677761018e-03,
-4.595673220376238731e-03,
-4.724357525089200628e-03,
-4.852999280959461627e-03,
-4.981598295246940887e-03,
-5.110154375329144065e-03,
-5.238667328701059230e-03,
-5.367136962975657330e-03,
-5.495563085883650202e-03,
-5.623945505274093384e-03,
-5.752284029115210980e-03,
-5.880578465493407729e-03,
-6.008828622614977716e-03,
-6.137034308804819802e-03,
-6.265195332508103829e-03,
-6.393311502289872501e-03,
-6.521382626834841892e-03,
-6.649408514948902844e-03,
-6.777388975557917944e-03,
-6.905323817709392055e-03,
-7.033212850571540775e-03,
-7.161055883434091010e-03,
-7.288852725708998281e-03,
-7.416603186929288799e-03,
-7.544307076751595627e-03,
-7.671964204953848898e-03,
-7.799574381437083398e-03,
-7.927137416225728261e-03,
-8.054653119466908748e-03,
-8.182121301431925092e-03,
-8.309541772515208202e-03,
-8.436914343235893052e-03,
-8.564238824236776113e-03,
-8.691515026285673642e-03,
-8.818742760275227396e-03,
-8.945921837222731154e-03,
-9.073052068271365844e-03,
-9.200133264689424120e-03,
-9.327165237871054559e-03,
-9.454147799336972899e-03,
-9.581080760733549570e-03,
-9.707963933834289419e-03,
-9.834797130539585375e-03,
-9.961580162876322933e-03,
-1.008831284299952120e-02,
-1.021499498319099891e-02,
-1.034162639586128432e-02,
-1.046820689354823093e-02,
-1.059473628891869842e-02,
-1.072121439476777204e-02,
-1.084764102401913032e-02,
-1.097401598972664802e-02,
-1.110033910507251739e-02,
-1.122661018336877300e-02,
-1.135282903805775664e-02,
-1.147899548271127598e-02,
-1.160510933103220746e-02,
-1.173117039685334095e-02,
-1.185717849413908329e-02,
-1.198313343698418319e-02,
-1.210903503961529952e-02,
-1.223488311639072887e-02,
-1.236067748180009508e-02,
-1.248641795046584284e-02,
-1.261210433714211356e-02,
-1.273773645671626500e-02,
-1.286331412420803691e-02,
-1.298883715477022055e-02,
-1.311430536368944980e-02,
-1.323971856638579692e-02,
-1.336507657841272227e-02,
-1.349037921545850373e-02,
-1.361562629334491827e-02,
-1.374081762802915538e-02,
-1.386595303560254205e-02,
-1.399103233229201902e-02,
-1.411605533445934105e-02,
-1.424102185860214205e-02,
-1.436593172135407909e-02,
-1.449078473948410203e-02,
-1.461558072989836872e-02,
-1.474031950963889531e-02,
-1.486500089588452603e-02,
-1.498962470595158018e-02,
-1.511419075729313229e-02,
-1.523869886750009450e-02,
-1.536314885430115247e-02,
-1.548754053556259183e-02,
-1.561187372928943447e-02,
-1.573614825362464401e-02,
-1.586036392685055696e-02,
-1.598452056738767016e-02,
-1.610861799379645701e-02,
-1.623265602477631450e-02,
-1.635663447916610794e-02,
-1.648055317594568359e-02,
-1.660441193423380438e-02,
-1.672821057329050218e-02,
-1.685194891251588084e-02,
-1.697562677145105642e-02,
-1.709924396977859432e-02,
-1.722280032732185356e-02,
-1.734629566404640930e-02,
-1.746972980005900150e-02,
-1.759310255560891934e-02,
-1.771641375108770969e-02,
-1.783966320702907657e-02,
-1.796285074411007807e-02,
-1.808597618315013408e-02,
-1.820903934511258412e-02,
-1.833204005110373666e-02,
-1.845497812237355262e-02,
-1.857785338031636355e-02,
-1.870066564647061141e-02,
-1.882341474251917821e-02,
-1.894610049028925408e-02,
-1.906872271175303127e-02,
-1.919128122902828693e-02,
-1.931377586437748109e-02,
-1.943620644020926588e-02,
-1.955857277907753142e-02,
-1.968087470368282479e-02,
-1.980311203687177071e-02,
-1.992528460163717208e-02,
-2.004739222111922431e-02,
-2.016943471860433226e-02,
-2.029141191752697679e-02,
-2.041332364146847961e-02,
-2.053516971415778047e-02,
-2.065694995947238433e-02,
-2.077866420143695964e-02,
-2.090031226422595437e-02,
-2.102189397216099043e-02,
-2.114340914971319166e-02,
-2.126485762150286465e-02,
-2.138623921229906855e-02,
-2.150755374702121095e-02,
-2.162880105073746936e-02,
-2.174998094866676182e-02,
-2.187109326617790728e-02,
-2.199213782879006276e-02,
-2.211311446217348320e-02,
-2.223402299214867137e-02,
-2.235486324468783509e-02,
-2.247563504591409966e-02,
-2.259633822210223297e-02,
-2.271697259967922489e-02,
-2.283753800522331581e-02,
-2.295803426546568632e-02,
-2.307846120728980488e-02,
-2.319881865773140012e-02,
-2.331910644397989715e-02,
-2.343932439337710616e-02,
-2.355947233341872810e-02,
-2.367955009175375797e-02,
-2.379955749618528280e-02,
-2.391949437467010345e-02,
-2.403936055531920302e-02,
-2.415915586639885357e-02,
-2.427888013632896816e-02,
-2.439853319368531781e-02,
-2.451811486719813679e-02,
-2.463762498575321203e-02,
-2.475706337839225779e-02,
-2.487642987431230163e-02,
-2.499572430286691252e-02,
-2.511494649356520517e-02,
-2.523409627607368921e-02,
-2.535317348021510001e-02,
-2.547217793596874211e-02,
-2.559110947347184931e-02,
-2.570996792301805112e-02,
-2.582875311505966609e-02,
-2.594746488020578667e-02,
-2.606610304922396190e-02,
-2.618466745303999615e-02,
-2.630315792273826836e-02,
-2.642157428956140933e-02,
-2.653991638491129401e-02,
-2.665818404034862865e-02,
-2.677637708759388405e-02,
-2.689449535852625126e-02,
-2.701253868518564347e-02,
-2.713050689977107230e-02,
-2.724839983464222987e-02,
-2.736621732231934653e-02,
-2.748395919548249008e-02,
-2.760162528697354331e-02,
-2.771921542979469133e-02,
-2.783672945710943120e-02,
-2.795416720224331089e-02,
-2.807152849868261787e-02,
-2.818881318007658912e-02,
-2.830602108023561742e-02,
-2.842315203313296873e-02,
-2.854020587290442487e-02,
-2.865718243384807531e-02,
-2.877408155042559049e-02,
-2.889090305726117400e-02,
-2.900764678914290184e-02,
-2.912431258102202852e-02,
-2.924090026801406603e-02,
-2.935740968539791995e-02,
-2.947384066861710381e-02,
-2.959019305327990207e-02,
-2.970646667515853753e-02,
-2.982266137019020866e-02,
-2.993877697447764469e-02,
-3.005481332428820707e-02,
-3.017077025605536048e-02,
-3.028664760637755221e-02,
-3.040244521201975955e-02,
-3.051816290991275077e-02,
-3.063380053715331758e-02,
-3.074935793100540271e-02,
-3.086483492889897234e-02,
-3.098023136843163633e-02,
-3.109554708736725348e-02,
-3.121078192363762466e-02,
-3.132593571534216664e-02,
-3.144100830074730152e-02,
-3.155599951828851057e-02,
-3.167090920656841224e-02,
-3.178573720435838579e-02,
-3.190048335059856438e-02,
-3.201514748439717589e-02,
-3.212972944503237477e-02,
-3.224422907195029220e-02,
-3.235864620476786718e-02,
-3.247298068327001547e-02,
-3.258723234741284225e-02,
-3.270140103732153969e-02,
-3.281548659329169837e-02,
-3.292948885578945994e-02,
-3.304340766545141306e-02,
-3.315724286308446150e-02,
-3.327099428966753120e-02,
-3.338466178634970360e-02,
-3.349824519445190191e-02,
-3.361174435546680078e-02,
-3.372515911105831293e-02,
-3.383848930306294911e-02,
-3.395173477348872176e-02,
-3.406489536451651201e-02,
-3.417797091849944513e-02,
-3.429096127796384119e-02,
-3.440386628560853505e-02,
-3.451668578430514001e-02,
-3.462941961710026828e-02,
-3.474206762721198521e-02,
-3.485462965803377139e-02,
-3.496710555313183727e-02,
-3.507949515624739223e-02,
-3.519179831129541636e-02,
-3.530401486236557640e-02,
-3.541614465372262821e-02,
-3.552818752980545225e-02,
-3.564014333522894790e-02,
-3.575201191478262486e-02,
-3.586379311343177584e-02,
-3.597548677631739328e-02,
-3.608709274875600975e-02,
-3.619861087624087065e-02,
-3.631004100444104599e-02,
-3.642138297920188145e-02,
-3.653263664654571308e-02,
-3.664380185267155504e-02,
-3.675487844395595310e-02,
-3.686586626695168012e-02,
-3.697676516838966504e-02,
-3.708757499517830597e-02,
-3.719829559440337996e-02,
-3.730892681332940997e-02,
-3.741946849939818687e-02,
-3.752992050023063603e-02,
-3.764028266362601238e-02,
-3.775055483756172003e-02,
-3.786073687019489431e-02,
-3.797082860986122216e-02,
-3.808082990507621196e-02,
-3.819074060453406944e-02,
-3.830056055710936991e-02,
-3.841028961185613544e-02,
-3.851992761800877157e-02,
-3.862947442498149142e-02,
-3.873892988236930096e-02,
-3.884829383994734681e-02,
-3.895756614767234560e-02,
-3.906674665568079380e-02,
-3.917583521429152116e-02,
-3.928483167400374787e-02,
-3.939373588549886090e-02,
-3.950254769963971319e-02,
-3.961126696747074155e-02,
-3.971989354021911167e-02,
-3.982842726929337190e-02,
-3.993686800628527128e-02,
-4.004521560296883664e-02,
-4.015346991130056692e-02,
-4.026163078342065438e-02,
-4.036969807165147889e-02,
-4.047767162849971734e-02,
-4.058555130665511546e-02,
-4.069333695899093883e-02,
-4.080102843856466682e-02,
-4.090862559861735415e-02,
-4.101612829257498399e-02,
-4.112353637404691370e-02,
-4.123084969682831724e-02,
-4.133806811489803418e-02,
-4.144519148242058887e-02,
-4.155221965374515658e-02,
-4.165915248340653493e-02,
-4.176598982612448469e-02,
-4.187273153680518695e-02,
-4.197937747053975821e-02,
-4.208592748260589489e-02,
-4.219238142846720718e-02,
-4.229873916377380888e-02,
-4.240500054436235899e-02,
-4.251116542625579808e-02,
-4.261723366566466664e-02,
-4.272320511898565487e-02,
-4.282907964280328189e-02,
-4.293485709388938920e-02,
-4.304053732920293251e-02,
-4.314612020589139035e-02,
-4.325160558128891830e-02,
-4.335699331291923558e-02,
-4.346228325849321728e-02,
-4.356747527591053187e-02,
-4.367256922325948171e-02,
-4.377756495881678783e-02,
-4.388246234104842269e-02,
-4.398726122860936727e-02,
-4.409196148034403434e-02,
-4.419656295528562318e-02,
-4.430106551265782650e-02,
-4.440546901187369250e-02,
-4.450977331253587466e-02,
-4.461397827443777664e-02,
-4.471808375756255310e-02,
-4.482208962208365788e-02,
-4.492599572836613459e-02,
-4.502980193696466682e-02,
-4.513350810862547940e-02,
-4.523711410428574858e-02,
-4.534061978507398366e-02,
-4.544402501231020047e-02,
-4.554732964750548424e-02,
-4.565053355236362714e-02,
-4.575363658877926176e-02,
-4.585663861884026193e-02,
-4.595953950482566108e-02,
-4.606233910920732449e-02,
-4.616503729465035871e-02,
-4.626763392401155028e-02,
-4.637012886034123926e-02,
-4.647252196688286124e-02,
-4.657481310707256572e-02,
-4.667700214454036101e-02,
-4.677908894310950361e-02,
-4.688107336679727538e-02,
-4.698295527981486558e-02,
-4.708473454656678797e-02,
-4.718641103165278211e-02,
-4.728798459986606473e-02,
-4.738945511619507833e-02,
-4.749082244582223528e-02,
-4.759208645412543043e-02,
-4.769324700667691708e-02,
-4.779430396924441021e-02,
-4.789525720779106571e-02,
-4.799610658847520972e-02,
-4.809685197765119213e-02,
-4.819749324186872741e-02,
-4.829803024787345661e-02,
-4.839846286260737762e-02,
-4.849879095320840799e-02,
-4.859901438701139803e-02,
-4.869913303154687484e-02,
-4.879914675454306155e-02,
-4.889905542392435078e-02,
-4.899885890781204706e-02,
-4.909855707452540075e-02,
-4.919814979258019250e-02,
-4.929763693069009328e-02,
-4.939701835776629663e-02,
-4.949629394291755330e-02,
-4.959546355545090685e-02,
-4.969452706487104826e-02,
-4.979348434088165520e-02,
-4.989233525338365727e-02,
-4.999107967247761602e-02,
-5.008971746846224704e-02,
-5.018824851183460029e-02,
-5.028667267329181567e-02,
-5.038498982372954099e-02,
-5.048319983424243845e-02,
-5.058130257612501041e-02,
-5.067929792087133567e-02,
-5.077718574017505565e-02,
-5.087496590592945067e-02,
-5.097263829022855020e-02,
-5.107020276536596015e-02,
-5.116765920383517519e-02,
-5.126500747833152849e-02,
-5.136224746174948563e-02,
-5.145937902718521889e-02,
-5.155640204793515702e-02,
-5.165331639749740078e-02,
-5.175012194957057804e-02,
-5.184681857805526622e-02,
-5.194340615705311109e-02,
-5.203988456086718062e-02,
-5.213625366400281846e-02,
-5.223251334116710970e-02,
-5.232866346726865875e-02,
-5.242470391741933106e-02,
-5.252063456693229632e-02,
-5.261645529132338156e-02,
-5.271216596631171647e-02,
-5.280776646781817907e-02,
-5.290325667196726922e-02,
-5.299863645508624821e-02,
-5.309390569370558283e-02,
-5.318906426455900782e-02,
-5.328411204458359529e-02,
-5.337904891092037918e-02,
-5.347387474091353649e-02,
-5.356858941211187913e-02,
-5.366319280226748700e-02,
-5.375768478933673489e-02,
-5.385206525148072965e-02,
-5.394633406706447754e-02,
-5.404049111465777933e-02,
-5.413453627303509846e-02,
-5.422846942117549168e-02,
-5.432229043826358739e-02,
-5.441599920368823257e-02,
-5.450959559704420671e-02,
-5.460307949813109768e-02,
-5.469645078695475199e-02,
-5.478970934372554003e-02,
-5.488285504886068755e-02,
-5.497588778298279771e-02,
-5.506880742692030206e-02,
-5.516161386170849446e-02,
-5.525430696858792123e-02,
-5.534688662900630329e-02,
-5.543935272461809893e-02,
-5.553170513728366425e-02,
-5.562394374907108502e-02,
-5.571606844225404642e-02,
-5.580807909931485844e-02,
-5.589997560294255458e-02,
-5.599175783603255879e-02,
-5.608342568168921821e-02,
-5.617497902322305531e-02,
-5.626641774415368225e-02,
-5.635774172820737227e-02,
-5.644895085931914136e-02,
-5.654004502163182538e-02,
-5.663102409949632293e-02,
-5.672188797747255984e-02,
-5.681263654032804589e-02,
-5.690326967303950545e-02,
-5.699378726079235014e-02,
-5.708418918898046368e-02,
-5.717447534320704849e-02,
-5.726464560928443831e-02,
-5.735469987323390390e-02,
-5.744463802128677715e-02,
-5.753445993988295232e-02,
-5.762416551567237089e-02,
-5.771375463551463997e-02,
-5.780322718647974006e-02,
-5.789258305584660952e-02,
-5.798182213110490008e-02,
-5.807094429995449114e-02,
-5.815994945030559388e-02,
-5.824883747027882058e-02,
-5.833760824820525409e-02,
-5.842626167262641307e-02,
-5.851479763229564673e-02,
-5.860321601617595605e-02,
-5.869151671344238763e-02,
-5.877969961348041006e-02,
-5.886776460588766940e-02,
-5.895571158047242105e-02,
-5.904354042725497298e-02,
-5.913125103646685310e-02,
-5.921884329855153090e-02,
-5.930631710416464641e-02,
-5.939367234417348290e-02,
-5.948090890965716110e-02,
-5.956802669190786742e-02,
-5.965502558242932740e-02,
-5.974190547293838083e-02,
-5.982866625536401028e-02,
-5.991530782184796566e-02,
-6.000183006474507641e-02,
-6.008823287662259233e-02,
-6.017451615026111339e-02,
-6.026067977865406933e-02,
-6.034672365500909352e-02,
-6.043264767274580257e-02,
-6.051845172549832202e-02,
-6.060413570711420395e-02,
-6.068969951165398974e-02,
-6.077514303339314611e-02,
-6.086046616682007360e-02,
-6.094566880663776498e-02,
-6.103075084776347220e-02,
-6.111571218532815125e-02,
-6.120055271467740587e-02,
-6.128527233137136265e-02,
-6.136987093118471959e-02,
-6.145434841010709998e-02,
-6.153870466434212955e-02,
-6.162293959030937934e-02,
-6.170705308464264488e-02,
-6.179104504419113963e-02,
-6.187491536601914810e-02,
-6.195866394740640742e-02,
-6.204229068584854456e-02,
-6.212579547905582034e-02,
-6.220917822495469762e-02,
-6.229243882168730706e-02,
-6.237557716761139154e-02,
-6.245859316130149969e-02,
-6.254148670154677236e-02,
-6.262425768735398190e-02,
-6.270690601794536023e-02,
-6.278943159275959807e-02,
-6.287183431145197676e-02,
-6.295411407389446545e-02,
-6.303627078017570717e-02,
-6.311830433060036660e-02,
-6.320021462569146153e-02,
-6.328200156618740690e-02,
-6.336366505304473484e-02,
-6.344520498743674852e-02,
-6.352662127075450749e-02,
-6.360791380460557864e-02,
-6.368908249081593753e-02,
-6.377012723142828909e-02,
-6.385104792870366364e-02,
-6.393184448512057028e-02,
-6.401251680337523287e-02,
-6.409306478638227000e-02,
-6.417348833727419544e-02,
-6.425378735940157071e-02,
-6.433396175633299130e-02,
-6.441401143185593314e-02,
-6.449393628997614203e-02,
-6.457373623491745318e-02,
-6.465341117112301250e-02,
-6.473296100325429125e-02,
-6.481238563619144688e-02,
-6.489168497503408628e-02,
-6.497085892510050253e-02,
-6.504990739192786919e-02,
-6.512883028127297580e-02,
-6.520762749911168665e-02,
-6.528629895163913510e-02,
-6.536484454527041743e-02,
-6.544326418663928835e-02,
-6.552155778260011776e-02,
-6.559972524022608664e-02,
-6.567776646681132424e-02,
-6.575568136986932599e-02,
-6.583346985713299515e-02,
-6.591113183655601671e-02,
-6.598866721631251042e-02,
-6.606607590479611491e-02,
-6.614335781062145869e-02,
-6.622051284262311932e-02,
-6.629754090985659487e-02,
-6.637444192159797085e-02,
-6.645121578734382306e-02,
-6.652786241681178658e-02,
-6.660438171994031986e-02,
-6.668077360688857980e-02,
-6.675703798803730993e-02,
-6.683317477398749429e-02,
-6.690918387556267499e-02,
-6.698506520380607954e-02,
-6.706081866998415963e-02,
-6.713644418558341320e-02,
-6.721194166231204969e-02,
-6.728731101210062848e-02,
-6.736255214710115680e-02,
-6.743766497968724238e-02,
-6.751264942245407963e-02,
-6.758750538821983733e-02,
-6.766223279002350766e-02,
-6.773683154112736249e-02,
-6.781130155501499668e-02,
-6.788564274539270194e-02,
-6.795985502618949459e-02,
-6.803393831155590821e-02,
-6.810789251586561732e-02,
-6.818171755371504883e-02,
-6.825541333992285464e-02,
-6.832897978953049456e-02,
-6.840241681780311056e-02,
-6.847572434022741739e-02,
-6.854890227251420054e-02,
-6.862195053059697014e-02,
-6.869486903063178052e-02,
-6.876765768899908982e-02,
-6.884031642230184489e-02,
-6.891284514736631395e-02,
-6.898524378124241963e-02,
-6.905751224120426635e-02,
-6.912965044474790599e-02,
-6.920165830959500164e-02,
-6.927353575368942751e-02,
-6.934528269519957266e-02,
-6.941689905251784143e-02,
-6.948838474426016765e-02,
-6.955973968926663920e-02,
-6.963096380660156737e-02,
-6.970205701555352851e-02,
-6.977301923563523911e-02,
-6.984385038658327827e-02,
-6.991455038835941993e-02,
-6.998511916114932840e-02,
-7.005555662536332162e-02,
-7.012586270163646829e-02,
-7.019603731082829645e-02,
-7.026608037402297391e-02,
-7.033599181252990495e-02,
-7.040577154788313363e-02,
-7.047541950184123272e-02,
-7.054493559638835842e-02,
-7.061431975373333447e-02,
-7.068357189631067905e-02,
-7.075269194677909212e-02,
-7.082167982802375916e-02,
-7.089053546315417231e-02,
-7.095925877550575411e-02,
-7.102784968863920523e-02,
-7.109630812634107344e-02,
-7.116463401262279609e-02,
-7.123282727172230988e-02,
-7.130088782810249659e-02,
-7.136881560645245981e-02,
-7.143661053168699759e-02,
-7.150427252894685226e-02,
-7.157180152359862713e-02,
-7.163919744123531386e-02,
-7.170646020767550144e-02,
-7.177358974896380639e-02,
-7.184058599137194134e-02,
-7.190744886139699421e-02,
-7.197417828576246901e-02,
-7.204077419141853567e-02,
-7.210723650554230757e-02,
-7.217356515553587093e-02,
-7.223976006902951830e-02,
-7.230582117387907015e-02,
-7.237174839816754024e-02,
-7.243754167020451107e-02,
-7.250320091852635596e-02,
-7.256872607189621127e-02,
-7.263411705930404583e-02,
-7.269937380996724374e-02,
-7.276449625332966076e-02,
-7.282948431906233200e-02,
-7.289433793706386056e-02,
-7.295905703745929338e-02,
-7.302364155060131479e-02,
-7.308809140707014929e-02,
-7.315240653767257628e-02,
-7.321658687344337335e-02,
-7.328063234564484441e-02,
-7.334454288576636172e-02,
-7.340831842552493491e-02,
-7.347195889686512771e-02,
-7.353546423195971016e-02,
-7.359883436320824313e-02,
-7.366206922323864648e-02,
-7.372516874490654681e-02,
-7.378813286129495830e-02,
-7.385096150571567042e-02,
-7.391365461170756879e-02,
-7.397621211303818944e-02,
-7.403863394370206741e-02,
-7.410092003792327631e-02,
-7.416307033015290262e-02,
-7.422508475507026693e-02,
-7.428696324758410352e-02,
-7.434870574282959055e-02,
-7.441031217617170845e-02,
-7.447178248320336647e-02,
-7.453311659974544423e-02,
-7.459431446184752734e-02,
-7.465537600578814326e-02,
-7.471630116807387312e-02,
-7.477708988544011504e-02,
-7.483774209485044571e-02,
-7.489825773349759186e-02,
-7.495863673880291678e-02,
-7.501887904841683663e-02,
-7.507898460021752984e-02,
-7.513895333231337959e-02,
-7.519878518304043413e-02,
-7.525848009096461344e-02,
-7.531803799488009932e-02,
-7.537745883381062606e-02,
-7.543674254700866166e-02,
-7.549588907395560211e-02,
-7.555489835436259016e-02,
-7.561377032816940513e-02,
-7.567250493554471269e-02,
-7.573110211688757754e-02,
-7.578956181282495153e-02,
-7.584788396421447698e-02,
-7.590606851214179440e-02,
-7.596411539792276291e-02,
-7.602202456310276635e-02,
-7.607979594945639412e-02,
-7.613742949898737178e-02,
-7.619492515392953247e-02,
-7.625228285674594264e-02,
-7.630950255012923511e-02,
-7.636658417700224744e-02,
-7.642352768051668965e-02,
-7.648033300405442103e-02,
-7.653700009122707537e-02,
-7.659352888587635244e-02,
-7.664991933207231101e-02,
-7.670617137411687991e-02,
-7.676228495654051354e-02,
-7.681826002410370446e-02,
-7.687409652179734432e-02,
-7.692979439484191884e-02,
-7.698535358868789646e-02,
-7.704077404901611692e-02,
-7.709605572173730548e-02,
-7.715119855299241991e-02,
-7.720620248915147088e-02,
-7.726106747681638076e-02,
-7.731579346281756970e-02,
-7.737038039421692548e-02,
-7.742482821830556916e-02,
-7.747913688260564535e-02,
-7.753330633486940626e-02,
-7.758733652307903128e-02,
-7.764122739544719598e-02,
-7.769497890041712762e-02,
-7.774859098666246637e-02,
-7.780206360308694613e-02,
-7.785539669882435287e-02,
-7.790859022324041205e-02,
-7.796164412592965220e-02,
-7.801455835671819439e-02,
-7.806733286566215624e-02,
-7.811996760304872056e-02,
-7.817246251939463653e-02,
-7.822481756544863440e-02,
-7.827703269218860838e-02,
-7.832910785082451699e-02,
-7.838104299279587128e-02,
-7.843283806977344175e-02,
-7.848449303365798158e-02,
-7.853600783658244711e-02,
-7.858738243090900022e-02,
-7.863861676923128430e-02,
-7.868971080437391075e-02,
-7.874066448939119611e-02,
-7.879147777757007642e-02,
-7.884215062242631855e-02,
-7.889268297770815619e-02,
-7.894307479739412492e-02,
-7.899332603569331201e-02,
-7.904343664704628625e-02,
-7.909340658612386277e-02,
-7.914323580782836598e-02,
-7.919292426729299117e-02,
-7.924247191988167960e-02,
-7.929187872118968750e-02,
-7.934114462704262849e-02,
-7.939026959349809731e-02,
-7.943925357684381017e-02,
-7.948809653359879823e-02,
-7.953679842051369908e-02,
-7.958535919456925789e-02,
-7.963377881297827032e-02,
-7.968205723318338984e-02,
-7.973019441285991715e-02,
-7.977819030991328830e-02,
-7.982604488248006003e-02,
-7.987375808892792362e-02,
-7.992132988785656533e-02,
-7.996876023809580680e-02,
-8.001604909870693727e-02,
-8.006319642898236666e-02,
-8.011020218844602803e-02,
-8.015706633685294735e-02,
-8.020378883418896598e-02,
-8.025036964067180922e-02,
-8.029680871674929610e-02,
-8.034310602310197613e-02,
-8.038926152064025665e-02,
-8.043527517050665099e-02,
-8.048114693407469600e-02,
-8.052687677294873003e-02,
-8.057246464896521132e-02,
-8.061791052419098325e-02,
-8.066321436092505071e-02,
-8.070837612169624864e-02,
-8.075339576926673923e-02,
-8.079827326662832043e-02,
-8.084300857700452148e-02,
-8.088760166385032535e-02,
-8.093205249085179409e-02,
-8.097636102192652674e-02,
-8.102052722122321526e-02,
-8.106455105312214415e-02,
-8.110843248223419122e-02,
-8.115217147340246517e-02,
-8.119576799170047376e-02,
-8.123922200243378910e-02,
-8.128253347113889582e-02,
-8.132570236358349636e-02,
-8.136872864576635833e-02,
-8.141161228391854965e-02,
-8.145435324450148173e-02,
-8.149695149420815854e-02,
-8.153940699996280184e-02,
-8.158171972892096224e-02,
-8.162388964846961636e-02,
-8.166591672622676434e-02,
-8.170780093004183231e-02,
-8.174954222799524217e-02,
-8.179114058839939694e-02,
-8.183259597979740396e-02,
-8.187390837096328311e-02,
-8.191507773090346556e-02,
-8.195610402885417090e-02,
-8.199698723428433533e-02,
-8.203772731689266962e-02,
-8.207832424661050397e-02,
-8.211877799359912355e-02,
-8.215908852825189179e-02,
-8.219925582119322338e-02,
-8.223927984327855656e-02,
-8.227916056559422819e-02,
-8.231889795945876442e-02,
-8.235849199642064633e-02,
-8.239794264826033610e-02,
-8.243724988698918066e-02,
-8.247641368484964763e-02,
-8.251543401431518654e-02,
-8.255431084809072839e-02,
-8.259304415911257469e-02,
-8.263163392054689860e-02,
-8.267008010579193766e-02,
-8.270838268847731378e-02,
-8.274654164246258992e-02,
-8.278455694183937952e-02,
-8.282242856092951466e-02,
-8.286015647428694730e-02,
-8.289774065669545944e-02,
-8.293518108317046722e-02,
-8.297247772895835483e-02,
-8.300963056953605812e-02,
-8.304663958061200835e-02,
-8.308350473812524395e-02,
-8.312022601824560486e-02,
-8.315680339737424598e-02,
-8.319323685214273512e-02,
-8.322952635941427424e-02,
-8.326567189628157617e-02,
-8.330167344006979280e-02,
-8.333753096833355911e-02,
-8.337324445885907487e-02,
-8.340881388966284171e-02,
-8.344423923899253748e-02,
-8.347952048532647495e-02,
-8.351465760737337984e-02,
-8.354965058407297362e-02,
-8.358449939459547395e-02,
-8.361920401834206651e-02,
-8.365376443494411396e-02,
-8.368818062426432169e-02,
-8.372245256639472555e-02,
-8.375658024165925919e-02,
-8.379056363061146429e-02,
-8.382440271403621135e-02,
-8.385809747294842298e-02,
-8.389164788859318489e-02,
-8.392505394244641204e-02,
-8.395831561621464045e-02,
-8.399143289183436112e-02,
-8.402440575147318569e-02,
-8.405723417752769544e-02,
-8.408991815262592540e-02,
-8.412245765962625410e-02,
-8.415485268161709831e-02,
-8.418710320191657992e-02,
-8.421920920407373334e-02,
-8.425117067186768671e-02,
-8.428298758930732881e-02,
-8.431465994063234992e-02,
-8.434618771031174300e-02,
-8.437757088304484454e-02,
-8.440880944376209782e-02,
-8.443990337762233289e-02,
-8.447085267001527842e-02,
-8.450165730656063190e-02,
-8.453231727310765720e-02,
-8.456283255573564250e-02,
-8.459320314075416403e-02,
-8.462342901470201739e-02,
-8.465351016434791154e-02,
-8.468344657669070463e-02,
-8.471323823895900162e-02,
-8.474288513861034933e-02,
-8.477238726333309604e-02,
-8.480174460104460132e-02,
-8.483095713989176334e-02,
-8.486002486825067193e-02,
-8.488894777472826003e-02,
-8.491772584816000002e-02,
-8.494635907761052818e-02,
-8.497484745237506021e-02,
-8.500319096197717084e-02,
-8.503138959617012604e-02,
-8.505944334493659165e-02,
-8.508735219848864717e-02,
-8.511511614726756381e-02,
-8.514273518194326318e-02,
-8.517020929341583002e-02,
-8.519753847281374970e-02,
-8.522472271149483802e-02,
-8.525176200104594981e-02,
-8.527865633328292339e-02,
-8.530540570025099689e-02,
-8.533201009422332339e-02,
-8.535846950770303865e-02,
-8.538478393342184558e-02,
-8.541095336433970897e-02,
-8.543697779364628486e-02,
-8.546285721475889441e-02,
-8.548859162132484146e-02,
-8.551418100721894233e-02,
-8.553962536654494131e-02,
-8.556492469363567721e-02,
-8.559007898305193152e-02,
-8.561508822958285858e-02,
-8.563995242824676279e-02,
-8.566467157428987733e-02,
-8.568924566318630864e-02,
-8.571367469063961853e-02,
-8.573795865258075632e-02,
-8.576209754516873895e-02,
-8.578609136479134478e-02,
-8.580994010806435035e-02,
-8.583364377183151650e-02,
-8.585720235316474103e-02,
-8.588061584936305948e-02,
-8.590388425795492111e-02,
-8.592700757669559375e-02,
-8.594998580356853768e-02,
-8.597281893678455911e-02,
-8.599550697478311467e-02,
-8.601804991623031305e-02,
-8.604044776002062189e-02,
-8.606270050527585480e-02,
-8.608480815134506026e-02,
-8.610677069780540982e-02,
-8.612858814446149036e-02,
-8.615026049134429098e-02,
-8.617178773871318753e-02,
-8.619316988705406912e-02,
-8.621440693708108671e-02,
-8.623549888973433553e-02,
-8.625644574618145100e-02,
-8.627724750781809449e-02,
-8.629790417626544141e-02,
-8.631841575337270700e-02,
-8.633878224121582790e-02,
-8.635900364209654623e-02,
-8.637907995854492149e-02,
-8.639901119331699908e-02,
-8.641879734939536539e-02,
-8.643843842998995275e-02,
-8.645793443853627691e-02,
-8.647728537869697751e-02,
-8.649649125436112418e-02,
-8.651555206964432754e-02,
-8.653446782888819799e-02,
-8.655323853666031797e-02,
-8.657186419775568520e-02,
-8.659034481719450616e-02,
-8.660868040022302872e-02,
-8.662687095231388912e-02,
-8.664491647916587602e-02,
-8.666281698670365297e-02,
-8.668057248107717550e-02,
-8.669818296866274587e-02,
-8.671564845606283267e-02,
-8.673296895010457197e-02,
-8.675014445784115513e-02,
-8.676717498655174554e-02,
-8.678406054374042389e-02,
-8.680080113713724288e-02,
-8.681739677469736682e-02,
-8.683384746460066916e-02,
-8.685015321525343945e-02,
-8.686631403528666251e-02,
-8.688232993355600453e-02,
-8.689820091914290945e-02,
-8.691392700135311400e-02,
-8.692950818971796612e-02,
-8.694494449399312042e-02,
-8.696023592415912107e-02,
-8.697538249042172098e-02,
-8.699038420321072995e-02,
-8.700524107318106937e-02,
-8.701995311121164811e-02,
-8.703452032840620911e-02,
-8.704894273609298239e-02,
-8.706322034582410219e-02,
-8.707735316937627312e-02,
-8.709134121875057588e-02,
-8.710518450617159292e-02,
-8.711888304408876849e-02,
-8.713243684517470167e-02,
-8.714584592232603455e-02,
-8.715911028866438204e-02,
-8.717222995753329262e-02,
-8.718520494250169006e-02,
-8.719803525736137539e-02,
-8.721072091612709631e-02,
-8.722326193303839292e-02,
-8.723565832255718300e-02,
-8.724791009936889996e-02,
-8.726001727838318678e-02,
-8.727197987473139795e-02,
-8.728379790376919467e-02,
-8.729547138107458804e-02,
-8.730700032244918807e-02,
-8.731838474391635796e-02,
-8.732962466172378146e-02,
-8.734072009234071510e-02,
-8.735167105245932040e-02,
-8.736247755899509415e-02,
-8.737313962908521692e-02,
-8.738365728008996858e-02,
-8.739403052959093809e-02,
-8.740425939539328559e-02,
-8.741434389552331374e-02,
-8.742428404823043842e-02,
-8.743407987198531517e-02,
-8.744373138548093560e-02,
-8.745323860763212775e-02,
-8.746260155757551447e-02,
-8.747182025466952726e-02,
-8.748089471849423981e-02,
-8.748982496885122917e-02,
-8.749861102576404759e-02,
-8.750725290947648782e-02,
-8.751575064045516439e-02,
-8.752410423938626616e-02,
-8.753231372717935888e-02,
-8.754037912496291651e-02,
-8.754830045408770745e-02,
-8.755607773612501810e-02,
-8.756371099286740234e-02,
-8.757120024632723820e-02,
-8.757854551873835158e-02,
-8.758574683255511417e-02,
-8.759280421045215204e-02,
-8.759971767532467868e-02,
-8.760648725028793993e-02,
-8.761311295867824089e-02,
-8.761959482405091981e-02,
-8.762593287018261012e-02,
-8.763212712106875635e-02,
-8.763817760092584841e-02,
-8.764408433418904854e-02,
-8.764984734551381496e-02,
-8.765546665977594354e-02,
-8.766094230206948612e-02,
-8.766627429770929014e-02,
-8.767146267222829248e-02,
-8.767650745137957335e-02,
-8.768140866113538490e-02,
-8.768616632768649888e-02,
-8.769078047744377491e-02,
-8.769525113703575958e-02,
-8.769957833331080976e-02,
-8.770376209333544115e-02,
-8.770780244439556339e-02,
-8.771169941399480086e-02,
-8.771545302985547798e-02,
-8.771906331991921602e-02,
-8.772253031234493459e-02,
-8.772585403550943461e-02,
-8.772903451800917463e-02,
-8.773207178865707889e-02,
-8.773496587648529910e-02,
-8.773771681074230000e-02,
-8.774032462089569051e-02,
-8.774278933663029467e-02,
-8.774511098784837371e-02,
-8.774728960466933458e-02,
-8.774932521743072922e-02,
-8.775121785668682506e-02,
-8.775296755320892428e-02,
-8.775457433798601603e-02,
-8.775603824222341642e-02,
-8.775735929734390650e-02,
-8.775853753498652488e-02,
-8.775957298700756692e-02,
-8.776046568547966886e-02,
-8.776121566269153018e-02,
-8.776182295114902387e-02,
-8.776228758357361437e-02,
-8.776260959290356489e-02,
-8.776278901229271623e-02,
-8.776282587511140265e-02,
-8.776272021494532782e-02,
-8.776247206559664726e-02,
-8.776208146108256669e-02,
-8.776154843563609143e-02,
-8.776087302370652599e-02,
-8.776005525995693446e-02,
-8.775909517926722136e-02,
-8.775799281673157815e-02,
-8.775674820765994033e-02,
-8.775536138757680793e-02,
-8.775383239222112053e-02,
-8.775216125754770058e-02,
-8.775034801972549092e-02,
-8.774839271513779071e-02,
-8.774629538038246357e-02,
-8.774405605227227067e-02,
-8.774167476783346908e-02,
-8.773915156430690809e-02,
-8.773648647914773779e-02,
-8.773367955002432661e-02,
-8.773073081481948254e-02,
-8.772764031162948173e-02,
-8.772440807876467905e-02,
-8.772103415474827304e-02,
-8.771751857831749932e-02,
-8.771386138842235392e-02,
-8.771006262422631483e-02,
-8.770612232510591189e-02,
-8.770204053065067118e-02,
-8.769781728066337878e-02,
-8.769345261515885948e-02,
-8.768894657436500373e-02,
-8.768429919872254563e-02,
-8.767951052888391106e-02,
-8.767458060571407807e-02,
-8.766950947029135410e-02,
-8.766429716390430893e-02,
-8.765894372805473067e-02,
-8.765344920445636290e-02,
-8.764781363503371114e-02,
-8.764203706192426335e-02,
-8.763611952747607514e-02,
-8.763006107424901880e-02,
-8.762386174501449188e-02,
-8.761752158275430691e-02,
-8.761104063066221803e-02,
-8.760441893214294951e-02,
-8.759765653081155734e-02,
-8.759075347049387339e-02,
-8.758370979522715760e-02,
-8.757652554925846045e-02,
-8.756920077704538619e-02,
-8.756173552325594023e-02,
-8.755412983276829320e-02,
-8.754638375067040623e-02,
-8.753849732226125224e-02,
-8.753047059304805422e-02,
-8.752230360874889425e-02,
-8.751399641529096496e-02,
-8.750554905881120782e-02,
-8.749696158565574422e-02,
-8.748823404238005585e-02,
-8.747936647574859614e-02,
-8.747035893273516494e-02,
-8.746121146052168727e-02,
-8.745192410650023951e-02,
-8.744249691826989912e-02,
-8.743292994363977000e-02,
-8.742322323062651224e-02,
-8.741337682745480009e-02,
-8.740339078255834893e-02,
-8.739326514457845807e-02,
-8.738299996236448264e-02,
-8.737259528497345884e-02,
-8.736205116167022888e-02,
-8.735136764192678871e-02,
-8.734054477542330108e-02,
-8.732958261204716577e-02,
-8.731848120189175666e-02,
-8.730724059525936387e-02,
-8.729586084265808510e-02,
-8.728434199480275546e-02,
-8.727268410261551645e-02,
-8.726088721722485841e-02,
-8.724895138996560662e-02,
-8.723687667237879639e-02,
-8.722466311621236701e-02,
-8.721231077341901061e-02,
-8.719981969615896167e-02,
-8.718718993679730467e-02,
-8.717442154790437658e-02,
-8.716151458225768200e-02,
-8.714846909283893717e-02,
-8.713528513283504140e-02,
-8.712196275563893755e-02,
-8.710850201484786337e-02,
-8.709490296426455891e-02,
-8.708116565789641994e-02,
-8.706729014995541471e-02,
-8.705327649485747332e-02,
-8.703912474722447223e-02,
-8.702483496188102852e-02,
-8.701040719385695621e-02,
-8.699584149838554548e-02,
-8.698113793090399282e-02,
-8.696629654705353984e-02,
-8.695131740267872389e-02,
-8.693620055382812739e-02,
-8.692094605675303176e-02,
-8.690555396790866638e-02,
-8.689002434395261265e-02,
-8.687435724174619178e-02,
-8.685855271835322966e-02,
-8.684261083103994583e-02,
-8.682653163727571677e-02,
-8.681031519473145219e-02,
-8.679396156128167672e-02,
-8.677747079500276739e-02,
-8.676084295417178793e-02,
-8.674407809726938923e-02,
-8.672717628297714476e-02,
-8.671013757017860535e-02,
-8.669296201795845258e-02,
-8.667564968560327598e-02,
-8.665820063260028239e-02,
-8.664061491863808695e-02,
-8.662289260360658827e-02,
-8.660503374759581652e-02,
-8.658703841089718245e-02,
-8.656890665400174267e-02,
-8.655063853760240622e-02,
-8.653223412259095082e-02,
-8.651369347005941068e-02,
-8.649501664130090917e-02,
-8.647620369780771588e-02,
-8.645725470127156587e-02,
-8.643816971358411760e-02,
-8.641894879683661990e-02,
-8.639959201331910699e-02,
-8.638009942552117570e-02,
-8.636047109613130546e-02,
-8.634070708803719130e-02,
-8.632080746432457818e-02,
-8.630077228827835734e-02,
-8.628060162338159478e-02,
-8.626029553331615585e-02,
-8.623985408196140068e-02,
-8.621927733339468380e-02,
-8.619856535189256153e-02,
-8.617771820192746124e-02,
-8.615673594817084557e-02,
-8.613561865549088092e-02,
-8.611436638895288154e-02,
-8.609297921382073893e-02,
-8.607145719555335528e-02,
-8.604980039980782147e-02,
-8.602800889243768234e-02,
-8.600608273949326976e-02,
-8.598402200722099487e-02,
-8.596182676206322315e-02,
-8.593949707066000920e-02,
-8.591703299984530806e-02,
-8.589443461665047241e-02,
-8.587170198830199053e-02,
-8.584883518222199972e-02,
-8.582583426602821697e-02,
-8.580269930753359198e-02,
-8.577943037474566879e-02,
-8.575602753586800131e-02,
-8.573249085929765534e-02,
-8.570882041362752612e-02,
-8.568501626764486734e-02,
-8.566107849033050003e-02,
-8.563700715086028370e-02,
-8.561280231860424195e-02,
-8.558846406312549393e-02,
-8.556399245418173927e-02,
-8.553938756172402291e-02,
-8.551464945589683231e-02,
-8.548977820703815289e-02,
-8.546477388567931543e-02,
-8.543963656254348338e-02,
-8.541436630854858103e-02,
-8.538896319480394903e-02,
-8.536342729261170437e-02,
-8.533775867346699018e-02,
-8.531195740905618552e-02,
-8.528602357125882050e-02,
-8.525995723214577215e-02,
-8.523375846398005551e-02,
-8.520742733921578271e-02,
-8.518096393049963411e-02,
-8.515436831066837409e-02,
-8.512764055275116870e-02,
-8.510078072996678233e-02,
-8.507378891572646429e-02,
-8.504666518363090955e-02,
-8.501940960747252085e-02,
-8.499202226123263315e-02,
-8.496450321908458059e-02,
-8.493685255539062950e-02,
-8.490907034470304704e-02,
-8.488115666176443419e-02,
-8.485311158150643518e-02,
-8.482493517905115299e-02,
-8.479662752970862361e-02,
-8.476818870897878666e-02,
-8.473961879255124952e-02,
-8.471091785630302518e-02,
-8.468208597630108581e-02,
-8.465312322879992024e-02,
-8.462402969024325483e-02,
-8.459480543726266566e-02,
-8.456545054667741201e-02,
-8.453596509549504701e-02,
-8.450634916091127880e-02,
-8.447660282030851342e-02,
-8.444672615125704829e-02,
-8.441671923151422563e-02,
-8.438658213902475169e-02,
-8.435631495191982243e-02,
-8.432591774851812272e-02,
-8.429539060732424427e-02,
-8.426473360702932403e-02,
-8.423394682651090537e-02,
-8.420303034483289650e-02,
-8.417198424124500145e-02,
-8.414080859518226208e-02,
-8.410950348626608508e-02,
-8.407806899430259051e-02,
-8.404650519928370811e-02,
-8.401481218138651119e-02,
-8.398299002097291133e-02,
-8.395103879858913098e-02,
-8.391895859496734111e-02,
-8.388674949102258027e-02,
-8.385441156785568284e-02,
-8.382194490675015652e-02,
-8.378934958917515219e-02,
-8.375662569678180014e-02,
-8.372377331140638812e-02,
-8.369079251506793271e-02,
-8.365768338996877607e-02,
-8.362444601849498838e-02,
-8.359108048321482742e-02,
-8.355758686688008474e-02,
-8.352396525242446190e-02,
-8.349021572296468074e-02,
-8.345633836179969234e-02,
-8.342233325241003861e-02,
-8.338820047845922623e-02,
-8.335394012379201967e-02,
-8.331955227243423301e-02,
-8.328503700859465897e-02,
-8.325039441666123863e-02,
-8.321562458120541905e-02,
-8.318072758697780955e-02,
-8.314570351891044375e-02,
-8.311055246211601633e-02,
-8.307527450188739726e-02,
-8.303986972369832575e-02,
-8.300433821320189753e-02,
-8.296868005623156406e-02,
-8.293289533880016107e-02,
-8.289698414710058860e-02,
-8.286094656750518650e-02,
-8.282478268656462417e-02,
-8.278849259100996838e-02,
-8.275207636775003261e-02,
-8.271553410387288974e-02,
-8.267886588664516423e-02,
-8.264207180351161586e-02,
-8.260515194209575029e-02,
-8.256810639019801501e-02,
-8.253093523579801971e-02,
-8.249363856705178855e-02,
-8.245621647229396667e-02,
-8.241866904003579408e-02,
-8.238099635896577178e-02,
-8.234319851794935641e-02,
-8.230527560602930726e-02,
-8.226722771242445109e-02,
-8.222905492653008463e-02,
-8.219075733791793292e-02,
-8.215233503633559420e-02,
-8.211378811170716441e-02,
-8.207511665413182167e-02,
-8.203632075388461731e-02,
-8.199740050141575420e-02,
-8.195835598735071170e-02,
-8.191918730249039826e-02,
-8.187989453781013838e-02,
-8.184047778445967258e-02,
-8.180093713376378195e-02,
-8.176127267722169134e-02,
-8.172148450650577878e-02,
-8.168157271346343506e-02,
-8.164153739011519029e-02,
-8.160137862865517178e-02,
-8.156109652145167310e-02,
-8.152069116104528057e-02,
-8.148016264014988630e-02,
-8.143951105165235516e-02,
-8.139873648861238598e-02,
-8.135783904426197033e-02,
-8.131681881200547579e-02,
-8.127567588541920185e-02,
-8.123441035825179624e-02,
-8.119302232442358880e-02,
-8.115151187802625843e-02,
-8.110987911332294409e-02,
-8.106812412474828644e-02,
-8.102624700690774784e-02,
-8.098424785457780661e-02,
-8.094212676270536033e-02,
-8.089988382640776743e-02,
-8.085751914097323578e-02,
-8.081503280185926841e-02,
-8.077242490469420388e-02,
-8.072969554527589797e-02,
-8.068684481957076604e-02,
-8.064387282371601740e-02,
-8.060077965401733768e-02,
-8.055756540694977708e-02,
-8.051423017915648739e-02,
-8.047077406744992945e-02,
-8.042719716881130410e-02,
-8.038349958038909504e-02,
-8.033968139950058152e-02,
-8.029574272363075582e-02,
-8.025168365043257312e-02,
-8.020750427772600777e-02,
-8.016320470349824756e-02,
-8.011878502590481788e-02,
-8.007424534326675059e-02,
-8.002958575407252695e-02,
-7.998480635697764740e-02,
-7.993990725080277193e-02,
-7.989488853453605155e-02,
-7.984975030733097723e-02,
-7.980449266850687950e-02,
-7.975911571754866480e-02,
-7.971361955410727340e-02,
-7.966800427799808348e-02,
-7.962226998920228505e-02,
-7.957641678786556150e-02,
-7.953044477429808967e-02,
-7.948435404897462309e-02,
-7.943814471253482501e-02,
-7.939181686578121455e-02,
-7.934537060968203936e-02,
-7.929880604536752864e-02,
-7.925212327413230784e-02,
-7.920532239743406644e-02,
-7.915840351689418242e-02,
-7.911136673429652877e-02,
-7.906421215158718208e-02,
-7.901693987087607396e-02,
-7.896954999443477063e-02,
-7.892204262469659781e-02,
-7.887441786425801460e-02,
-7.882667581587625427e-02,
-7.877881658247090635e-02,
-7.873084026712220962e-02,
-7.868274697307194032e-02,
-7.863453680372371746e-02,
-7.858620986264035213e-02,
-7.853776625354683127e-02,
-7.848920608032756985e-02,
-7.844052944702799290e-02,
-7.839173645785248168e-02,
-7.834282721716655240e-02,
-7.829380182949458034e-02,
-7.824466039952052143e-02,
-7.819540303208764864e-02,
-7.814602983219849641e-02,
-7.809654090501387536e-02,
-7.804693635585426004e-02,
-7.799721629019756852e-02,
-7.794738081368063343e-02,
-7.789743003209800842e-02,
-7.784736405140244009e-02,
-7.779718297770440993e-02,
-7.774688691727105194e-02,
-7.769647597652809545e-02,
-7.764595026205729777e-02,
-7.759530988059754053e-02,
-7.754455493904496843e-02,
-7.749368554445153212e-02,
-7.744270180402589021e-02,
-7.739160382513236847e-02,
-7.734039171529175083e-02,
-7.728906558217987777e-02,
-7.723762553362860384e-02,
-7.718607167762488175e-02,
-7.713440412231062360e-02,
-7.708262297598297841e-02,
-7.703072834709334682e-02,
-7.697872034424774190e-02,
-7.692659907620692794e-02,
-7.687436465188524082e-02,
-7.682201718035101823e-02,
-7.676955677082622498e-02,
-7.671698353268645298e-02,
-7.666429757546010249e-02,
-7.661149900882942287e-02,
-7.655858794262919431e-02,
-7.650556448684694977e-02,
-7.645242875162215623e-02,
-7.639918084724710290e-02,
-7.634582088416567991e-02,
-7.629234897297458573e-02,
-7.623876522442080139e-02,
-7.618506974940422727e-02,
-7.613126265897442180e-02,
-7.607734406433333540e-02,
-7.602331407683302067e-02,
-7.596917280797615968e-02,
-7.591492036941642485e-02,
-7.586055687295707728e-02,
-7.580608243055178552e-02,
-7.575149715430383457e-02,
-7.569680115646587604e-02,
-7.564199454944066370e-02,
-7.558707744577944365e-02,
-7.553204995818267597e-02,
-7.547691219949997921e-02,
-7.542166428272857603e-02,
-7.536630632101536109e-02,
-7.531083842765401437e-02,
-7.525526071608738821e-02,
-7.519957329990534234e-02,
-7.514377629284524351e-02,
-7.508786980879218753e-02,
-7.503185396177822208e-02,
-7.497572886598212472e-02,
-7.491949463572941670e-02,
-7.486315138549272385e-02,
-7.480669922988987530e-02,
-7.475013828368538837e-02,
-7.469346866179026045e-02,
-7.463669047925949873e-02,
-7.457980385129542311e-02,
-7.452280889324416902e-02,
-7.446570572059743598e-02,
-7.440849444899205745e-02,
-7.435117519420872401e-02,
-7.429374807217375976e-02,
-7.423621319895579163e-02,
-7.417857069076923271e-02,
-7.412082066397139568e-02,
-7.406296323506310342e-02,
-7.400499852068874451e-02,
-7.394692663763588469e-02,
-7.388874770283511417e-02,
-7.383046183335888191e-02,
-7.377206914642324420e-02,
-7.371356975938625489e-02,
-7.365496378974742409e-02,
-7.359625135514898109e-02,
-7.353743257337370942e-02,
-7.347850756234737546e-02,
-7.341947644013545327e-02,
-7.336033932494498422e-02,
-7.330109633512452150e-02,
-7.324174758916172923e-02,
-7.318229320568624130e-02,
-7.312273330346645561e-02,
-7.306306800141161573e-02,
-7.300329741857031207e-02,
-7.294342167413062072e-02,
-7.288344088742032545e-02,
-7.282335517790566870e-02,
-7.276316466519230919e-02,
-7.270286946902389247e-02,
-7.264246970928335545e-02,
-7.258196550599127495e-02,
-7.252135697930620073e-02,
-7.246064424952487759e-02,
-7.239982743708153756e-02,
-7.233890666254738644e-02,
-7.227788204663106175e-02,
-7.221675371017821643e-02,
-7.215552177417070001e-02,
-7.209418635972776601e-02,
-7.203274758810393474e-02,
-7.197120558069058927e-02,
-7.190956045901435167e-02,
-7.184781234473819334e-02,
-7.178596135965939484e-02,
-7.172400762571155830e-02,
-7.166195126496263668e-02,
-7.159979239961532238e-02,
-7.153753115200693624e-02,
-7.147516764460964955e-02,
-7.141270200002870772e-02,
-7.135013434100398455e-02,
-7.128746479040873330e-02,
-7.122469347124987804e-02,
-7.116182050666741699e-02,
-7.109884601993395059e-02,
-7.103577013445556976e-02,
-7.097259297377077336e-02,
-7.090931466154984375e-02,
-7.084593532159590146e-02,
-7.078245507784340640e-02,
-7.071887405435901830e-02,
-7.065519237534029218e-02,
-7.059141016511645550e-02,
-7.052752754814782532e-02,
-7.046354464902503112e-02,
-7.039946159246959767e-02,
-7.033527850333354259e-02,
-7.027099550659887672e-02,
-7.020661272737711844e-02,
-7.014213029091058427e-02,
-7.007754832257001576e-02,
-7.001286694785564813e-02,
-6.994808629239684938e-02,
-6.988320648195177343e-02,
-6.981822764240737389e-02,
-6.975314989977864089e-02,
-6.968797338020897569e-02,
-6.962269820996914993e-02,
-6.955732451545862394e-02,
-6.949185242320343736e-02,
-6.942628205985702794e-02,
-6.936061355220027314e-02,
-6.929484702714046318e-02,
-6.922898261171142598e-02,
-6.916302043307376302e-02,
-6.909696061851393345e-02,
-6.903080329544428184e-02,
-6.896454859140262184e-02,
-6.889819663405279127e-02,
-6.883174755118344479e-02,
-6.876520147070805389e-02,
-6.869855852066554525e-02,
-6.863181882921881583e-02,
-6.856498252465551002e-02,
-6.849804973538663189e-02,
-6.843102058994804393e-02,
-6.836389521699859362e-02,
-6.829667374532091828e-02,
-6.822935630382073735e-02,
-6.816194302152635276e-02,
-6.809443402758952324e-02,
-6.802682945128431247e-02,
-6.795912942200654783e-02,
-6.789133406927468084e-02,
-6.782344352272921817e-02,
-6.775545791213158364e-02,
-6.768737736736489541e-02,
-6.761920201843368838e-02,
-6.755093199546303995e-02,
-6.748256742869930547e-02,
-6.741410844850839745e-02,
-6.734555518537731211e-02,
-6.727690776991290811e-02,
-6.720816633284151798e-02,
-6.713933100500911466e-02,
-6.707040191738154744e-02,
-6.700137920104330680e-02,
-6.693226298719739953e-02,
-6.686305340716622303e-02,
-6.679375059239033019e-02,
-6.672435467442831836e-02,
-6.665486578495703751e-02,
-6.658528405577078535e-02,
-6.651560961878130729e-02,
-6.644584260601830994e-02,
-6.637598314962769863e-02,
-6.630603138187264600e-02,
-6.623598743513287035e-02,
-6.616585144190421930e-02,
-6.609562353479918329e-02,
-6.602530384654566042e-02,
-6.595489250998722019e-02,
-6.588438965808350589e-02,
-6.581379542390852766e-02,
-6.574310994065162006e-02,
-6.567233334161702574e-02,
-6.560146576022343745e-02,
-6.553050733000377603e-02,
-6.545945818460480181e-02,
-6.538831845778768359e-02,
-6.531708828342620843e-02,
-6.524576779550886330e-02,
-6.517435712813603177e-02,
-6.510285641552136793e-02,
-6.503126579199165758e-02,
-6.495958539198565251e-02,
-6.488781535005420931e-02,
-6.481595580086052522e-02,
-6.474400687917922226e-02,
-6.467196871989690232e-02,
-6.459984145801071775e-02,
-6.452762522862917627e-02,
-6.445532016697197442e-02,
-6.438292640836895675e-02,
-6.431044408826017134e-02,
-6.423787334219588363e-02,
-6.416521430583654872e-02,
-6.409246711495228399e-02,
-6.401963190542177273e-02,
-6.394670881323399891e-02,
-6.387369797448612385e-02,
-6.380059952538374990e-02,
-6.372741360224215557e-02,
-6.365414034148363098e-02,
-6.358077987963890731e-02,
-6.350733235334672655e-02,
-6.343379789935313373e-02,
-6.336017665451121328e-02,
-6.328646875578131104e-02,
-6.321267434023110365e-02,
-6.313879354503389163e-02,
-6.306482650747012586e-02,
-6.299077336492556189e-02,
-6.291663425489292527e-02,
-6.284240931496956617e-02,
-6.276809868285877780e-02,
-6.269370249636929682e-02,
-6.261922089341376285e-02,
-6.254465401201057817e-02,
-6.247000199028210354e-02,
-6.239526496645467213e-02,
-6.232044307885964418e-02,
-6.224553646593092987e-02,
-6.217054526620649502e-02,
-6.209546961832759782e-02,
-6.202030966103851822e-02,
-6.194506553318648856e-02,
-6.186973737372102045e-02,
-6.179432532169384928e-02,
-6.171882951625916325e-02,
-6.164325009667293020e-02,
-6.156758720229281445e-02,
-6.149184097257733017e-02,
-6.141601154708691002e-02,
-6.134009906548254509e-02,
-6.126410366752543801e-02,
-6.118802549307814781e-02,
-6.111186468210242501e-02,
-6.103562137466085613e-02,
-6.095929571091499716e-02,
-6.088288783112656699e-02,
-6.080639787565627480e-02,
-6.072982598496317469e-02,
-6.065317229960620615e-02,
-6.057643696024202218e-02,
-6.049962010762591907e-02,
-6.042272188261095522e-02,
-6.034574242614833967e-02,
-6.026868187928673820e-02,
-6.019154038317150318e-02,
-6.011431807904643598e-02,
-6.003701510825074777e-02,
-5.995963161222114118e-02,
-5.988216773249058905e-02,
-5.980462361068782789e-02,
-5.972699938853764240e-02,
-5.964929520786047684e-02,
-5.957151121057233101e-02,
-5.949364753868417038e-02,
-5.941570433430187759e-02,
-5.933768173962641890e-02,
-5.925957989695260913e-02,
-5.918139894866993739e-02,
-5.910313903726116536e-02,
-5.902480030530346533e-02,
-5.894638289546783733e-02,
-5.886788695051731884e-02,
-5.878931261330879593e-02,
-5.871066002679151824e-02,
-5.863192933400779988e-02,
-5.855312067809149285e-02,
-5.847423420226940255e-02,
-5.839527004985869268e-02,
-5.831622836426964690e-02,
-5.823710928900296263e-02,
-5.815791296765037560e-02,
-5.807863954389475697e-02,
-5.799928916150997454e-02,
-5.791986196435883888e-02,
-5.784035809639564291e-02,
-5.776077770166402475e-02,
-5.768112092429696774e-02,
-5.760138790851726531e-02,
-5.752157879863664669e-02,
-5.744169373905572140e-02,
-5.736173287426370865e-02,
-5.728169634883810424e-02,
-5.720158430744485406e-02,
-5.712139689483760469e-02,
-5.704113425585788377e-02,
-5.696079653543428128e-02,
-5.688038387858258133e-02,
-5.679989643040617153e-02,
-5.671933433609428754e-02,
-5.663869774092310933e-02,
-5.655798679025471343e-02,
-5.647720162953770440e-02,
-5.639634240430559109e-02,
-5.631540926017783444e-02,
-5.623440234285946582e-02,
-5.615332179813940089e-02,
-5.607216777189246576e-02,
-5.599094041007719735e-02,
-5.590963985873699527e-02,
-5.582826626399885889e-02,
-5.574681977207344291e-02,
-5.566530052925554306e-02,
-5.558370868192256953e-02,
-5.550204437653487310e-02,
-5.542030775963653622e-02,
-5.533849897785315941e-02,
-5.525661817789319363e-02,
-5.517466550654660795e-02,
-5.509264111068616632e-02,
-5.501054513726514467e-02,
-5.492837773331875340e-02,
-5.484613904596282591e-02,
-5.476382922239445700e-02,
-5.468144840989123262e-02,
-5.459899675581051520e-02,
-5.451647440759065100e-02,
-5.443388151274915904e-02,
-5.435121821888327931e-02,
-5.426848467367013928e-02,
-5.418568102486484572e-02,
-5.410280742030249002e-02,
-5.401986400789616366e-02,
-5.393685093563736765e-02,
-5.385376835159581821e-02,
-5.377061640391923164e-02,
-5.368739524083272069e-02,
-5.360410501063875982e-02,
-5.352074586171721993e-02,
-5.343731794252477157e-02,
-5.335382140159453807e-02,
-5.327025638753597053e-02,
-5.318662304903487570e-02,
-5.310292153485301342e-02,
-5.301915199382779831e-02,
-5.293531457487156422e-02,
-5.285140942697272998e-02,
-5.276743669919331525e-02,
-5.268339654067149408e-02,
-5.259928910061863194e-02,
-5.251511452832100663e-02,
-5.243087297313824002e-02,
-5.234656458450418631e-02,
-5.226218951192573153e-02,
-5.217774790498309195e-02,
-5.209323991332924508e-02,
-5.200866568669033907e-02,
-5.192402537486435349e-02,
-5.183931912772186956e-02,
-5.175454709520514035e-02,
-5.166970942732788952e-02,
-5.158480627417626890e-02,
-5.149983778590618705e-02,
-5.141480411274599455e-02,
-5.132970540499341705e-02,
-5.124454181301748429e-02,
-5.115931348725724637e-02,
-5.107402057822132274e-02,
-5.098866323648854060e-02,
-5.090324161270686626e-02,
-5.081775585759358560e-02,
-5.073220612193492934e-02,
-5.064659255658570530e-02,
-5.056091531246965226e-02,
-5.047517454057789260e-02,
-5.038937039197041723e-02,
-5.030350301777422595e-02,
-5.021757256918409074e-02,
-5.013157919746204227e-02,
-5.004552305393672462e-02,
-4.995940429000413074e-02,
-4.987322305712624942e-02,
-4.978697950683116241e-02,
-4.970067379071326646e-02,
-4.961430606043273212e-02,
-4.952787646771501795e-02,
-4.944138516435041264e-02,
-4.935483230219503414e-02,
-4.926821803316886600e-02,
-4.918154250925688142e-02,
-4.909480588250837718e-02,
-4.900800830503605765e-02,
-4.892114992901687442e-02,
-4.883423090669098549e-02,
-4.874725139036190785e-02,
-4.866021153239579594e-02,
-4.857311148522217015e-02,
-4.848595140133237641e-02,
-4.839873143328034949e-02,
-4.831145173368212725e-02,
-4.822411245521465023e-02,
-4.813671375061741309e-02,
-4.804925577269056336e-02,
-4.796173867429518595e-02,
-4.787416260835319903e-02,
-4.778652772784681285e-02,
-4.769883418581897377e-02,
-4.761108213537205286e-02,
-4.752327172966853280e-02,
-4.743540312192980751e-02,
-4.734747646543722294e-02,
-4.725949191353050888e-02,
-4.717144961960850758e-02,
-4.708334973712787613e-02,
-4.699519241960457838e-02,
-4.690697782061144933e-02,
-4.681870609377979109e-02,
-4.673037739279783942e-02,
-4.664199187141139513e-02,
-4.655354968342316491e-02,
-4.646505098269233802e-02,
-4.637649592313498881e-02,
-4.628788465872295949e-02,
-4.619921734348413078e-02,
-4.611049413150244275e-02,
-4.602171517691693026e-02,
-4.593288063392185483e-02,
-4.584399065676648954e-02,
-4.575504539975500801e-02,
-4.566604501724559617e-02,
-4.557698966365116705e-02,
-4.548787949343818804e-02,
-4.539871466112681969e-02,
-4.530949532129087409e-02,
-4.522022162855741934e-02,
-4.513089373760603706e-02,
-4.504151180316939840e-02,
-4.495207598003236188e-02,
-4.486258642303250777e-02,
-4.477304328705851433e-02,
-4.468344672705103215e-02,
-4.459379689800296170e-02,
-4.450409395495685816e-02,
-4.441433805300774168e-02,
-4.432452934730004429e-02,
-4.423466799302948338e-02,
-4.414475414544174331e-02,
-4.405478795983209378e-02,
-4.396476959154595882e-02,
-4.387469919597770940e-02,
-4.378457692857103817e-02,
-4.369440294481877901e-02,
-4.360417740026225480e-02,
-4.351390045049120109e-02,
-4.342357225114339830e-02,
-4.333319295790485914e-02,
-4.324276272650869057e-02,
-4.315228171273611385e-02,
-4.306175007241495184e-02,
-4.297116796141990658e-02,
-4.288053553567298254e-02,
-4.278985295114164089e-02,
-4.269912036383981951e-02,
-4.260833792982829382e-02,
-4.251750580521171385e-02,
-4.242662414614190719e-02,
-4.233569310881418052e-02,
-4.224471284946973437e-02,
-4.215368352439445576e-02,
-4.206260528991806469e-02,
-4.197147830241473865e-02,
-4.188030271830235629e-02,
-4.178907869404258763e-02,
-4.169780638614025564e-02,
-4.160648595114349590e-02,
-4.151511754564327084e-02,
-4.142370132627280072e-02,
-4.133223744970833391e-02,
-4.124072607266761337e-02,
-4.114916735191024438e-02,
-4.105756144423820808e-02,
-4.096590850649376586e-02,
-4.087420869556093045e-02,
-4.078246216836443200e-02,
-4.069066908186924625e-02,
-4.059882959308139944e-02,
-4.050694385904612949e-02,
-4.041501203684920440e-02,
-4.032303428361557612e-02,
-4.023101075650978992e-02,
-4.013894161273516559e-02,
-4.004682700953384605e-02,
-3.995466710418733164e-02,
-3.986246205401398901e-02,
-3.977021201637130632e-02,
-3.967791714865443603e-02,
-3.958557760829566757e-02,
-3.949319355276540572e-02,
-3.940076513956993626e-02,
-3.930829252625334808e-02,
-3.921577587039577067e-02,
-3.912321532961384601e-02,
-3.903061106156006238e-02,
-3.893796322392277520e-02,
-3.884527197442598501e-02,
-3.875253747082864353e-02,
-3.865975987092516025e-02,
-3.856693933254441709e-02,
-3.847407601354974754e-02,
-3.838117007183929758e-02,
-3.828822166534468635e-02,
-3.819523095203120749e-02,
-3.810219808989788459e-02,
-3.800912323697728384e-02,
-3.791600655133456343e-02,
-3.782284819106773721e-02,
-3.772964831430752897e-02,
-3.763640707921651202e-02,
-3.754312464398953941e-02,
-3.744980116685307781e-02,
-3.735643680606499928e-02,
-3.726303171991495605e-02,
-3.716958606672259025e-02,
-3.707610000483938656e-02,
-3.698257369264634775e-02,
-3.688900728855513261e-02,
-3.679540095100770902e-02,
-3.670175483847498699e-02,
-3.660806910945803988e-02,
-3.651434392248668198e-02,
-3.642057943611964194e-02,
-3.632677580894508318e-02,
-3.623293319957866798e-02,
-3.613905176666499380e-02,
-3.604513166887591408e-02,
-3.595117306491188436e-02,
-3.585717611349974882e-02,
-3.576314097339460679e-02,
-3.566906780337755073e-02,
-3.557495676225693598e-02,
-3.548080800886720121e-02,
-3.538662170206938878e-02,
-3.529239800074998601e-02,
-3.519813706382162594e-02,
-3.510383905022172041e-02,
-3.500950411891371600e-02,
-3.491513242888517193e-02,
-3.482072413914857195e-02,
-3.472627940874127572e-02,
-3.463179839672375637e-02,
-3.453728126218162664e-02,
-3.444272816422305761e-02,
-3.434813926198061751e-02,
-3.425351471460896802e-02,
-3.415885468128634916e-02,
-3.406415932121398954e-02,
-3.396942879361425360e-02,
-3.387466325773273723e-02,
-3.377986287283673422e-02,
-3.368502779821462567e-02,
-3.359015819317703877e-02,
-3.349525421705461248e-02,
-3.340031602920000287e-02,
-3.330534378898578757e-02,
-3.321033765580513886e-02,
-3.311529778907115751e-02,
-3.302022434821703933e-02,
-3.292511749269540905e-02,
-3.282997738197829252e-02,
-3.273480417555701266e-02,
-3.263959803294167600e-02,
-3.254435911366058976e-02,
-3.244908757726108761e-02,
-3.235378358330805171e-02,
-3.225844729138421102e-02,
-3.216307886109031483e-02,
-3.206767845204403639e-02,
-3.197224622388061821e-02,
-3.187678233625138025e-02,
-3.178128694882509375e-02,
-3.168576022128604536e-02,
-3.159020231333524442e-02,
-3.149461338468930588e-02,
-3.139899359508019350e-02,
-3.130334310425569172e-02,
-3.120766207197785830e-02,
-3.111195065802440859e-02,
-3.101620902218740067e-02,
-3.092043732427265934e-02,
-3.082463572410103561e-02,
-3.072880438150619661e-02,
-3.063294345633608279e-02,
-3.053705310845156867e-02,
-3.044113349772669189e-02,
-3.034518478404853517e-02,
-3.024920712731606759e-02,
-3.015320068744144211e-02,
-3.005716562434817413e-02,
-2.996110209797171742e-02,
-2.986501026825963759e-02,
-2.976889029516987042e-02,
-2.967274233867206804e-02,
-2.957656655874613821e-02,
-2.948036311538325752e-02,
-2.938413216858433083e-02,
-2.928787387836039383e-02,
-2.919158840473247765e-02,
-2.909527590773082831e-02,
-2.899893654739523971e-02,
-2.890257048377447777e-02,
-2.880617787692583281e-02,
-2.870975888691560882e-02,
-2.861331367381786048e-02,
-2.851684239771530224e-02,
-2.842034521869768807e-02,
-2.832382229686280020e-02,
-2.822727379231569286e-02,
-2.813069986516805038e-02,
-2.803410067553907883e-02,
-2.793747638355339319e-02,
-2.784082714934266178e-02,
-2.774415313304475980e-02,
-2.764745449480259312e-02,
-2.755073139476527794e-02,
-2.745398399308661766e-02,
-2.735721244992598070e-02,
-2.726041692544704451e-02,
-2.716359757981829867e-02,
-2.706675457321234754e-02,
-2.696988806580568124e-02,
-2.687299821777912323e-02,
-2.677608518931618234e-02,
-2.667914914060434337e-02,
-2.658219023183377647e-02,
-2.648520862319738572e-02,
-2.638820447489077445e-02,
-2.629117794711171088e-02,
-2.619412920005965290e-02,
-2.609705839393651472e-02,
-2.599996568894504673e-02,
-2.590285124528991095e-02,
-2.580571522317600536e-02,
-2.570855778280963996e-02,
-2.561137908439733643e-02,
-2.551417928814601194e-02,
-2.541695855426277795e-02,
-2.531971704295364958e-02,
-2.522245491442534973e-02,
-2.512517232888285268e-02,
-2.502786944653078577e-02,
-2.493054642757247530e-02,
-2.483320343220937754e-02,
-2.473584062064163730e-02,
-2.463845815306716508e-02,
-2.454105618968169950e-02,
-2.444363489067850545e-02,
-2.434619441624812086e-02,
-2.424873492657829074e-02,
-2.415125658185297494e-02,
-2.405375954225340979e-02,
-2.395624396795642194e-02,
-2.385871001913523679e-02,
-2.376115785595909677e-02,
-2.366358763859194997e-02,
-2.356599952719368521e-02,
-2.346839368191936878e-02,
-2.337077026291809259e-02,
-2.327312943033419887e-02,
-2.317547134430584035e-02,
-2.307779616496567418e-02,
-2.298010405243958859e-02,
-2.288239516684749744e-02,
-2.278466966830231324e-02,
-2.268692771690987431e-02,
-2.258916947276935414e-02,
-2.249139509597177997e-02,
-2.239360474660108749e-02,
-2.229579858473291695e-02,
-2.219797677043473111e-02,
-2.210013946376563829e-02,
-2.200228682477610095e-02,
-2.190441901350719325e-02,
-2.180653618999164878e-02,
-2.170863851425183441e-02,
-2.161072614630121097e-02,
-2.151279924614254296e-02,
-2.141485797376923433e-02,
-2.131690248916365618e-02,
-2.121893295229761514e-02,
-2.112094952313251645e-02,
-2.102295236161750083e-02,
-2.092494162769137703e-02,
-2.082691748128066497e-02,
-2.072888008230028625e-02,
-2.063082959065294306e-02,
-2.053276616622861164e-02,
-2.043468996890522582e-02,
-2.033660115854710182e-02,
-2.023849989500606933e-02,
-2.014038633812019127e-02,
-2.004226064771378463e-02,
-1.994412298359772573e-02,
-1.984597350556828801e-02,
-1.974781237340780468e-02,
-1.964963974688354806e-02,
-1.955145578574819451e-02,
-1.945326064973931096e-02,
-1.935505449857908775e-02,
-1.925683749197384248e-02,
-1.915860978961423516e-02,
-1.906037155117492124e-02,
-1.896212293631423587e-02,
-1.886386410467360761e-02,
-1.876559521587794696e-02,
-1.866731642953482415e-02,
-1.856902790523483338e-02,
-1.847072980255067345e-02,
-1.837242228103706104e-02,
-1.827410550023132740e-02,
-1.817577961965165939e-02,
-1.807744479879850458e-02,
-1.797910119715277755e-02,
-1.788074897417687298e-02,
-1.778238828931370460e-02,
-1.768401930198643460e-02,
-1.758564217159913623e-02,
-1.748725705753469140e-02,
-1.738886411915679595e-02,
-1.729046351580831170e-02,
-1.719205540681094380e-02,
-1.709363995146613927e-02,
-1.699521730905323436e-02,
-1.689678763883079374e-02,
-1.679835110003518803e-02,
-1.669990785188122523e-02,
-1.660145805356108908e-02,
-1.650300186424452989e-02,
-1.640453944307898940e-02,
-1.630607094918840733e-02,
-1.620759654167392913e-02,
-1.610911637961325374e-02,
-1.601063062205995008e-02,
-1.591213942804434872e-02,
-1.581364295657205696e-02,
-1.571514136662427799e-02,
-1.561663481715797226e-02,
-1.551812346710471947e-02,
-1.541960747537144370e-02,
-1.532108700083916093e-02,
-1.522256220236379264e-02,
-1.512403323877482483e-02,
-1.502550026887606964e-02,
-1.492696345144503729e-02,
-1.482842294523198552e-02,
-1.472987890896108529e-02,
-1.463133150132888381e-02,
-1.453278088100490133e-02,
-1.443422720663127372e-02,
-1.433567063682167006e-02,
-1.423711133016247916e-02,
-1.413854944521100547e-02,
-1.403998514049682560e-02,
-1.394141857452013862e-02,
-1.384284990575220496e-02,
-1.374427929263544526e-02,
-1.364570689358212373e-02,
-1.354713286697546183e-02,
-1.344855737116806317e-02,
-1.334998056448271318e-02,
-1.325140260521171821e-02,
-1.315282365161645622e-02,
-1.305424386192728138e-02,
-1.295566339434386580e-02,
-1.285708240703384471e-02,
-1.275850105813370293e-02,
-1.265991950574757614e-02,
-1.256133790794779909e-02,
-1.246275642277395145e-02,
-1.236417520823349797e-02,
-1.226559442230052040e-02,
-1.216701422291611122e-02,
-1.206843476798831472e-02,
-1.196985621539113295e-02,
-1.187127872296508957e-02,
-1.177270244851662435e-02,
-1.167412754981747222e-02,
-1.157555418460541954e-02,
-1.147698251058285393e-02,
-1.137841268541767495e-02,
-1.127984486674212666e-02,
-1.118127921215297804e-02,
-1.108271587921163918e-02,
-1.098415502544290885e-02,
-1.088559680833605173e-02,
-1.078704138534325972e-02,
-1.068848891388054015e-02,
-1.058993955132643723e-02,
-1.049139345502290641e-02,
-1.039285078227401328e-02,
-1.029431169034624588e-02,
-1.019577633646838802e-02,
-1.009724487783113939e-02,
-9.998717471586456365e-03,
-9.900194274848174783e-03,
-9.801675444690809494e-03,
-9.703161138150234385e-03,
-9.604651512222738691e-03,
-9.506146723864954129e-03,
-9.407646929994207055e-03,
-9.309152287487135885e-03,
-9.210662953180811727e-03,
-9.112179083871135496e-03,
-9.013700836313774667e-03,
-8.915228367223335809e-03,
-8.816761833272837232e-03,
-8.718301391094550323e-03,
-8.619847197278094827e-03,
-8.521399408372017439e-03,
-8.422958180882487295e-03,
-8.324523671273001066e-03,
-8.226096035964863482e-03,
-8.127675431336038939e-03,
-8.029262013721871413e-03,
-7.930855939413882297e-03,
-7.832457364660587451e-03,
-7.734066445666221319e-03,
-7.635683338591013614e-03,
-7.537308199551327227e-03,
-7.438941184618463875e-03,
-7.340582449819403957e-03,
-7.242232151136130877e-03,
-7.143890444505019560e-03,
-7.045557485817531204e-03,
-6.947233430919066630e-03,
-6.848918435609033933e-03,
-6.750612655641196301e-03,
-6.652316246722292901e-03,
-6.554029364513060639e-03,
-6.455752164626803874e-03,
-6.357484802630326837e-03,
-6.259227434042489470e-03,
-6.160980214335213569e-03,
-6.062743298932195615e-03,
-5.964516843209129691e-03,
-5.866301002493850593e-03,
-5.768095932065164626e-03,
-5.669901787153579925e-03,
-5.571718722940633382e-03,
-5.473546894558285227e-03,
-5.375386457089601638e-03,
-5.277237565567625445e-03,
-5.179100374975520102e-03,
-5.080975040246675511e-03,
-4.982861716263711424e-03,
-4.884760557859074183e-03,
-4.786671719813985482e-03,
-4.688595356859079875e-03,
-4.590531623673228638e-03,
-4.492480674884187682e-03,
-4.394442665068121374e-03,
-4.296417748748389102e-03,
-4.198406080397143816e-03,
-4.100407814433410826e-03,
-4.002423105223967305e-03,
-3.904452107082685697e-03,
-3.806494974269943911e-03,
-3.708551860993306200e-03,
-3.610622921406166606e-03,
-3.512708309608717373e-03,
-3.414808179646676087e-03,
-3.316922685511484309e-03,
-3.219051981140494054e-03,
-3.121196220415794250e-03,
-3.023355557165043842e-03,
-2.925530145160187227e-03,
-2.827720138118152045e-03,
-2.729925689700207769e-03,
-2.632146953511496461e-03,
-2.534384083101046646e-03,
-2.436637231961954163e-03,
-2.338906553530221630e-03,
-2.241192201185595884e-03,
-2.143494328250273879e-03,
-2.045813087989732312e-03,
-1.948148633611450874e-03,
-1.850501118265732549e-03,
-1.752870695044552634e-03,
-1.655257516981720493e-03,
-1.557661737053077540e-03,
-1.460083508175298974e-03,
-1.362522983206771766e-03,
-1.264980314946268468e-03,
-1.167455656133665380e-03,
-1.069949159449340827e-03,
-9.724609775134917785e-04,
-8.749912628869035286e-04,
-7.775401680697426520e-04,
-6.801078455017551963e-04,
-5.826944475624341912e-04,
-4.853001265698564620e-04,
-3.879250347815312895e-04,
-2.905693243930974152e-04,
-1.932331475391789921e-04,
-9.591665629207390324e-05,
 1.379997337382631567e-06,
 9.865666140099728300e-05,
 1.959131840130337663e-04,
 2.931494133501669555e-04,
 3.903651976519814182e-04,
 4.875603852215975144e-04,
 5.847348244249524077e-04,
 6.818883636921053634e-04,
 7.790208515163799278e-04,
 8.761321364556734275e-04,
 9.732220671315909089e-04,
 1.070290492230756589e-03,
 1.167337260504095788e-03,
 1.264362220767449672e-03,
 1.361365221901942148e-03,
 1.458346112854487812e-03,
 1.555304742636775617e-03,
 1.652240960326975842e-03,
 1.749154615068775585e-03,
 1.846045556072666146e-03,
 1.942913632615203817e-03,
 2.039758694039654763e-03,
 2.136580589756640995e-03,
 2.233379169243373836e-03,
 2.330154282044987271e-03,
 2.426905777773677528e-03,
 2.523633506109975062e-03,
 2.620337316802068880e-03,
 2.717017059666399382e-03,
 2.813672584588304548e-03,
 2.910303741521263164e-03,
 3.006910380487950833e-03,
 3.103492351580609040e-03,
 3.200049504960038142e-03,
 3.296581690857263141e-03,
 3.393088759572621647e-03,
 3.489570561476972119e-03,
 3.586026947011044640e-03,
 3.682457766686039833e-03,
 3.778862871084209991e-03,
 3.875242110858212897e-03,
 3.971595336732353446e-03,
 4.067922399501745778e-03,
 4.164223150033602612e-03,
 4.260497439266513163e-03,
 4.356745118211062875e-03,
 4.452966037950474402e-03,
 4.549160049639880757e-03,
 4.645327004507565638e-03,
 4.741466753854053570e-03,
 4.837579149053757022e-03,
 4.933664041553996286e-03,
 5.029721282875329949e-03,
 5.125750724612640821e-03,
 5.221752218434350112e-03,
 5.317725616083060144e-03,
 5.413670769376172781e-03,
 5.509587530205155639e-03,
 5.605475750536872623e-03,
 5.701335282412688804e-03,
 5.797165977949765396e-03,
 5.892967689340321627e-03,
 5.988740268852319956e-03,
 6.084483568830010777e-03,
 6.180197441693222049e-03,
 6.275881739938703706e-03,
 6.371536316139210857e-03,
 6.467161022944512526e-03,
 6.562755713081824469e-03,
 6.658320239354870683e-03,
 6.753854454644912103e-03,
 6.849358211911286097e-03,
 6.944831364190600688e-03,
 7.040273764598120598e-03,
 7.135685266326821825e-03,
 7.231065722648681408e-03,
 7.326414986913907211e-03,
 7.421732912552131411e-03,
 7.517019353071670643e-03,
 7.612274162060297944e-03,
 7.707497193185708535e-03,
 7.802688300194749599e-03,
 7.897847336914915611e-03,
 7.992974157253279754e-03,
 8.088068615197957154e-03,
 8.183130564816877561e-03,
 8.278159860259877434e-03,
 8.373156355756829899e-03,
 8.468119905619592852e-03,
 8.563050364240910872e-03,
 8.657947586095794332e-03,
 8.752811425740577439e-03,
 8.847641737814245302e-03,
 8.942438377037618610e-03,
 9.037201198214496814e-03,
 9.131930056231106485e-03,
 9.226624806056562753e-03,
 9.321285302743551049e-03,
 9.415911401427647098e-03,
 9.510502957328480916e-03,
 9.605059825748968327e-03,
 9.699581862076587721e-03,
 9.794068921782571671e-03,
 9.888520860422488068e-03,
 9.982937533637211563e-03,
 1.007731879715196253e-02,
 1.017166450677689342e-02,
 1.026597451840786761e-02,
 1.036024868802561637e-02,
 1.045448687169721683e-02,
 1.054868892557512920e-02,
 1.064285470589794100e-02,
 1.073698406899092905e-02,
 1.083107687126539688e-02,
 1.092513296921980744e-02,
 1.101915221943905974e-02,
 1.111313447859571708e-02,
 1.120707960344914135e-02,
 1.130098745084680452e-02,
 1.139485787772342475e-02,
 1.148869074110179037e-02,
 1.158248589809303050e-02,
 1.167624320589678161e-02,
 1.176996252180077286e-02,
 1.186364370318199711e-02,
 1.195728660750594412e-02,
 1.205089109232783569e-02,
 1.214445701529191964e-02,
 1.223798423413196071e-02,
 1.233147260667199693e-02,
 1.242492199082559194e-02,
 1.251833224459692785e-02,
 1.261170322608018944e-02,
 1.270503479346067610e-02,
 1.279832680501400734e-02,
 1.289157911910738565e-02,
 1.298479159419874823e-02,
 1.307796408883758928e-02,
 1.317109646166539014e-02,
 1.326418857141486128e-02,
 1.335724027691150874e-02,
 1.345025143707273031e-02,
 1.354322191090808619e-02,
 1.363615155752032071e-02,
 1.372904023610473263e-02,
 1.382188780594954466e-02,
 1.391469412643674478e-02,
 1.400745905704123967e-02,
 1.410018245733211766e-02,
 1.419286418697181078e-02,
 1.428550410571730912e-02,
 1.437810207341962652e-02,
 1.447065795002404169e-02,
 1.456317159557105924e-02,
 1.465564287019549029e-02,
 1.474807163412767373e-02,
 1.484045774769287944e-02,
 1.493280107131183393e-02,
 1.502510146550164669e-02,
 1.511735879087431657e-02,
 1.520957290813856368e-02,
 1.530174367809905220e-02,
 1.539387096165699409e-02,
 1.548595461981048388e-02,
 1.557799451365411703e-02,
 1.566999050438000821e-02,
 1.576194245327696905e-02,
 1.585385022173191327e-02,
 1.594571367122891298e-02,
 1.603753266335005909e-02,
 1.612930705977561399e-02,
 1.622103672228392135e-02,
 1.631272151275193344e-02,
 1.640436129315510014e-02,
 1.649595592556792056e-02,
 1.658750527216349205e-02,
 1.667900919521477995e-02,
 1.677046755709386827e-02,
 1.686188022027246616e-02,
 1.695324704732185939e-02,
 1.704456790091387827e-02,
 1.713584264382008587e-02,
 1.722707113891286043e-02,
 1.731825324916482986e-02,
 1.740938883764977033e-02,
 1.750047776754220727e-02,
 1.759151990211774153e-02,
 1.768251510475379179e-02,
 1.777346323892899788e-02,
 1.786436416822392154e-02,
 1.795521775632093545e-02,
 1.804602386700487546e-02,
 1.813678236416262426e-02,
 1.822749311178361101e-02,
 1.831815597396030046e-02,
 1.840877081488804384e-02,
 1.849933749886488454e-02,
 1.858985589029278629e-02,
 1.868032585367654722e-02,
 1.877074725362541316e-02,
 1.886111995485191539e-02,
 1.895144382217301207e-02,
 1.904171872050983844e-02,
 1.913194451488785600e-02,
 1.922212107043745274e-02,
 1.931224825239358581e-02,
 1.940232592609658982e-02,
 1.949235395699158019e-02,
 1.958233221062966392e-02,
 1.967226055266696819e-02,
 1.976213884886578870e-02,
 1.985196696509400685e-02,
 1.994174476732666831e-02,
 2.003147212164389096e-02,
 2.012114889423335939e-02,
 2.021077495138878799e-02,
 2.030035015951139887e-02,
 2.038987438510913089e-02,
 2.047934749479726757e-02,
 2.056876935529896103e-02,
 2.065813983344452764e-02,
 2.074745879617275260e-02,
 2.083672611052983167e-02,
 2.092594164367068271e-02,
 2.101510526285842173e-02,
 2.110421683546495272e-02,
 2.119327622897100236e-02,
 2.128228331096577303e-02,
 2.137123794914835492e-02,
 2.146014001132700091e-02,
 2.154898936541927226e-02,
 2.163778587945279844e-02,
 2.172652942156472894e-02,
 2.181521986000270127e-02,
 2.190385706312452524e-02,
 2.199244089939827659e-02,
 2.208097123740309156e-02,
 2.216944794582851458e-02,
 2.225787089347551831e-02,
 2.234623994925591037e-02,
 2.243455498219346089e-02,
 2.252281586142274722e-02,
 2.261102245619083656e-02,
 2.269917463585632844e-02,
 2.278727226988992716e-02,
 2.287531522787492749e-02,
 2.296330337950679146e-02,
 2.305123659459403646e-02,
 2.313911474305791957e-02,
 2.322693769493251389e-02,
 2.331470532036525323e-02,
 2.340241748961711596e-02,
 2.349007407306226425e-02,
 2.357767494118920629e-02,
 2.366521996459987343e-02,
 2.375270901401075122e-02,
 2.384014196025215776e-02,
 2.392751867426945456e-02,
 2.401483902712227975e-02,
 2.410210288998502343e-02,
 2.418931013414762562e-02,
 2.427646063101468812e-02,
 2.436355425210665407e-02,
 2.445059086905898918e-02,
 2.453757035362322605e-02,
 2.462449257766731459e-02,
 2.471135741317429316e-02,
 2.479816473224431134e-02,
 2.488491440709343638e-02,
 2.497160631005455184e-02,
 2.505824031357762466e-02,
 2.514481629022904952e-02,
 2.523133411269302268e-02,
 2.531779365377044913e-02,
 2.540419478638031303e-02,
 2.549053738355909829e-02,
 2.557682131846079898e-02,
 2.566304646435805040e-02,
 2.574921269464124085e-02,
 2.583531988281951783e-02,
 2.592136790252025716e-02,
 2.600735662749000671e-02,
 2.609328593159345594e-02,
 2.617915568881551761e-02,
 2.626496577325963810e-02,
 2.635071605914872730e-02,
 2.643640642082528344e-02,
 2.652203673275211476e-02,
 2.660760686951138890e-02,
 2.669311670580571533e-02,
 2.677856611645802049e-02,
 2.686395497641159633e-02,
 2.694928316073052707e-02,
 2.703455054459954349e-02,
 2.711975700332455719e-02,
 2.720490241233253920e-02,
 2.728998664717198833e-02,
 2.737500958351267097e-02,
 2.745997109714630804e-02,
 2.754487106398621418e-02,
 2.762970936006772793e-02,
 2.771448586154871482e-02,
 2.779920044470947371e-02,
 2.788385298595211920e-02,
 2.796844336180233023e-02,
 2.805297144890792765e-02,
 2.813743712404055686e-02,
 2.822184026409434859e-02,
 2.830618074608749063e-02,
 2.839045844716111058e-02,
 2.847467324458041738e-02,
 2.855882501573458326e-02,
 2.864291363813647323e-02,
 2.872693898942369969e-02,
 2.881090094735785229e-02,
 2.889479938982526114e-02,
 2.897863419483699340e-02,
 2.906240524052904062e-02,
 2.914611240516215562e-02,
 2.922975556712292117e-02,
 2.931333460492287213e-02,
 2.939684939719934553e-02,
 2.948029982271508850e-02,
 2.956368576035929216e-02,
 2.964700708914647098e-02,
 2.973026368821809345e-02,
 2.981345543684163490e-02,
 2.989658221441105976e-02,
 2.997964390044747379e-02,
 3.006264037459849617e-02,
 3.014557151663892556e-02,
 3.022843720647066731e-02,
 3.031123732412330934e-02,
 3.039397174975372318e-02,
 3.047664036364639353e-02,
 3.055924304621411222e-02,
 3.064177967799707261e-02,
 3.072425013966439619e-02,
 3.080665431201303969e-02,
 3.088899207596866939e-02,
 3.097126331258559517e-02,
 3.105346790304710364e-02,
 3.113560572866492723e-02,
 3.121767667088090961e-02,
 3.129968061126545825e-02,
 3.138161743151890448e-02,
 3.146348701347075061e-02,
 3.154528923908093280e-02,
 3.162702399043883922e-02,
 3.170869114976439251e-02,
 3.179029059940739060e-02,
 3.187182222184841568e-02,
 3.195328589969843175e-02,
 3.203468151569933281e-02,
 3.211600895272371387e-02,
 3.219726809377596033e-02,
 3.227845882199061045e-02,
 3.235958102063436759e-02,
 3.244063457310530918e-02,
 3.252161936293303246e-02,
 3.260253527377945243e-02,
 3.268338218943788592e-02,
 3.276415999383451572e-02,
 3.284486857102731500e-02,
 3.292550780520699799e-02,
 3.300607758069724895e-02,
 3.308657778195365357e-02,
 3.316700829356582225e-02,
 3.324736900025565545e-02,
 3.332765978687903669e-02,
 3.340788053842471544e-02,
 3.348803114001533410e-02,
 3.356811147690699076e-02,
 3.364812143449009280e-02,
 3.372806089828897513e-02,
 3.380792975396191419e-02,
 3.388772788730166907e-02,
 3.396745518423567589e-02,
 3.404711153082581876e-02,
 3.412669681326899185e-02,
 3.420621091789686347e-02,
 3.428565373117641729e-02,
 3.436502513970969563e-02,
 3.444432503023430597e-02,
 3.452355328962362913e-02,
 3.460270980488622250e-02,
 3.468179446316706910e-02,
 3.476080715174675873e-02,
 3.483974775804272311e-02,
 3.491861616960770937e-02,
 3.499741227413163264e-02,
 3.507613595944136797e-02,
 3.515478711349991764e-02,
 3.523336562440704256e-02,
 3.531187138040044193e-02,
 3.539030426985434463e-02,
 3.546866418128054310e-02,
 3.554695100332844887e-02,
 3.562516462478515500e-02,
 3.570330493457542220e-02,
 3.578137182176208131e-02,
 3.585936517554615816e-02,
 3.593728488526663073e-02,
 3.601513084040137980e-02,
 3.609290293056631460e-02,
 3.617060104551667737e-02,
 3.624822507514598169e-02,
 3.632577490948683124e-02,
 3.640325043871110722e-02,
 3.648065155313044705e-02,
 3.655797814319484973e-02,
 3.663523009949495174e-02,
 3.671240731276024377e-02,
 3.678950967386106219e-02,
 3.686653707380659756e-02,
 3.694348940374700407e-02,
 3.702036655497272649e-02,
 3.709716841891431277e-02,
 3.717389488714303164e-02,
 3.725054585137079627e-02,
 3.732712120345083040e-02,
 3.740362083537662058e-02,
 3.748004463928367863e-02,
 3.755639250744800817e-02,
 3.763266433228745766e-02,
 3.770886000636157476e-02,
 3.778497942237155766e-02,
 3.786102247316030373e-02,
 3.793698905171283275e-02,
 3.801287905115619675e-02,
 3.808869236476006281e-02,
 3.816442888593626209e-02,
 3.824008850823916450e-02,
 3.831567112536599790e-02,
 3.839117663115650114e-02,
 3.846660491959419392e-02,
 3.854195588480487794e-02,
 3.861722942105801082e-02,
 3.869242542276635916e-02,
 3.876754378448644262e-02,
 3.884258440091822862e-02,
 3.891754716690547927e-02,
 3.899243197743620243e-02,
 3.906723872764186756e-02,
 3.914196731279920294e-02,
 3.921661762832830828e-02,
 3.929118956979441718e-02,
 3.936568303290725879e-02,
 3.944009791352103000e-02,
 3.951443410763511022e-02,
 3.958869151139395026e-02,
 3.966287002108724591e-02,
 3.973696953314979907e-02,
 3.981098994416190640e-02,
 3.988493115084960211e-02,
 3.995879305008459559e-02,
 4.003257553888437542e-02,
 4.010627851441234820e-02,
 4.017990187397817159e-02,
 4.025344551503795554e-02,
 4.032690933519365167e-02,
 4.040029323219424678e-02,
 4.047359710393544363e-02,
 4.054682084845910583e-02,
 4.061996436395471505e-02,
 4.069302754875832318e-02,
 4.076601030135330872e-02,
 4.083891252037064740e-02,
 4.091173410458816967e-02,
 4.098447495293180975e-02,
 4.105713496447492561e-02,
 4.112971403843895118e-02,
 4.120221207419316745e-02,
 4.127462897125473706e-02,
 4.134696462928939831e-02,
 4.141921894811103483e-02,
 4.149139182768196016e-02,
 4.156348316811341731e-02,
 4.163549286966513469e-02,
 4.170742083274545792e-02,
 4.177926695791244621e-02,
 4.185103114587263029e-02,
 4.192271329748232384e-02,
 4.199431331374659654e-02,
 4.206583109582051616e-02,
 4.213726654500862118e-02,
 4.220861956276522609e-02,
 4.227989005069435202e-02,
 4.235107791055039983e-02,
 4.242218304423777536e-02,
 4.249320535381084785e-02,
 4.256414474147492133e-02,
 4.263500110958522160e-02,
 4.270577436064805499e-02,
 4.277646439732015610e-02,
 4.284707112240968702e-02,
 4.291759443887492587e-02,
 4.298803424982615418e-02,
 4.305839045852485891e-02,
 4.312866296838312880e-02,
 4.319885168296528494e-02,
 4.326895650598703430e-02,
 4.333897734131568480e-02,
 4.340891409297079062e-02,
 4.347876666512343058e-02,
 4.354853496209741548e-02,
 4.361821888836802524e-02,
 4.368781834856354934e-02,
 4.375733324746446107e-02,
 4.382676349000372978e-02,
 4.389610898126753563e-02,
 4.396536962649402747e-02,
 4.403454533107518248e-02,
 4.410363600055561967e-02,
 4.417264154063314102e-02,
 4.424156185715910627e-02,
 4.431039685613829410e-02,
 4.437914644372849271e-02,
 4.444781052624205420e-02,
 4.451638901014417365e-02,
 4.458488180205488066e-02,
 4.465328880874730455e-02,
 4.472160993714968669e-02,
 4.478984509434358330e-02,
 4.485799418756564183e-02,
 4.492605712420653236e-02,
 4.499403381181173167e-02,
 4.506192415808161350e-02,
 4.512972807087102523e-02,
 4.519744545819012749e-02,
 4.526507622820390153e-02,
 4.533262028923250309e-02,
 4.540007754975161625e-02,
 4.546744791839178734e-02,
 4.553473130393993068e-02,
 4.560192761533816280e-02,
 4.566903676168430903e-02,
 4.573605865223188266e-02,
 4.580299319639080657e-02,
 4.586984030372686511e-02,
 4.593659988396223137e-02,
 4.600327184697471095e-02,
 4.606985610279973331e-02,
 4.613635256162808285e-02,
 4.620276113380824418e-02,
 4.626908172984445233e-02,
 4.633531426039864953e-02,
 4.640145863628913903e-02,
 4.646751476849174389e-02,
 4.653348256813930051e-02,
 4.659936194652222058e-02,
 4.666515281508778340e-02,
 4.673085508544160688e-02,
 4.679646866934607241e-02,
 4.686199347872205268e-02,
 4.692742942564773201e-02,
 4.699277642235975827e-02,
 4.705803438125245181e-02,
 4.712320321487829117e-02,
 4.718828283594855844e-02,
 4.725327315733245104e-02,
 4.731817409205778951e-02,
 4.738298555331108691e-02,
 4.744770745443751409e-02,
 4.751233970894098990e-02,
 4.757688223048472942e-02,
 4.764133493289052917e-02,
 4.770569773013938475e-02,
 4.776997053637194179e-02,
 4.783415326588758704e-02,
 4.789824583314568340e-02,
 4.796224815276535491e-02,
 4.802616013952442503e-02,
 4.808998170836128322e-02,
 4.815371277437416331e-02,
 4.821735325282079654e-02,
 4.828090305911943159e-02,
 4.834436210884815455e-02,
 4.840773031774607549e-02,
 4.847100760171145495e-02,
 4.853419387680425745e-02,
 4.859728905924426412e-02,
 4.866029306541209964e-02,
 4.872320581184962085e-02,
 4.878602721525888974e-02,
 4.884875719250363763e-02,
 4.891139566060805077e-02,
 4.897394253675760312e-02,
 4.903639773830005544e-02,
 4.909876118274311002e-02,
 4.916103278775683927e-02,
 4.922321247117274895e-02,
 4.928530015098379902e-02,
 4.934729574534520158e-02,
 4.940919917257332455e-02,
 4.947101035114745415e-02,
 4.953272919970820587e-02,
 4.959435563705869021e-02,
 4.965588958216413801e-02,
 4.971733095415235837e-02,
 4.977867967231356522e-02,
 4.983993565610013443e-02,
 4.990109882512795692e-02,
 4.996216909917486348e-02,
 5.002314639818201264e-02,
 5.008403064225328688e-02,
 5.014482175165566741e-02,
 5.020551964681938678e-02,
 5.026612424833758197e-02,
 5.032663547696717560e-02,
 5.038705325362821674e-02,
 5.044737749940399196e-02,
 5.050760813554225348e-02,
 5.056774508345363711e-02,
 5.062778826471261984e-02,
 5.068773760105826226e-02,
 5.074759301439283471e-02,
 5.080735442678292052e-02,
 5.086702176045954787e-02,
 5.092659493781771796e-02,
 5.098607388141648128e-02,
 5.104545851398001322e-02,
 5.110474875839636499e-02,
 5.116394453771901107e-02,
 5.122304577516503810e-02,
 5.128205239411721267e-02,
 5.134096431812253114e-02,
 5.139978147089378085e-02,
 5.145850377630804134e-02,
 5.151713115840775986e-02,
 5.157566354140083464e-02,
 5.163410084966017083e-02,
 5.169244300772451312e-02,
 5.175068994029763392e-02,
 5.180884157224908970e-02,
 5.186689782861417242e-02,
 5.192485863459406908e-02,
 5.198272391555551486e-02,
 5.204049359703108446e-02,
 5.209816760472008035e-02,
 5.215574586448687433e-02,
 5.221322830236274637e-02,
 5.227061484454550294e-02,
 5.232790541739835294e-02,
 5.238509994745168402e-02,
 5.244219836140234098e-02,
 5.249920058611356327e-02,
 5.255610654861525566e-02,
 5.261291617610449473e-02,
 5.266962939594482113e-02,
 5.272624613566664203e-02,
 5.278276632296800830e-02,
 5.283918988571352504e-02,
 5.289551675193508024e-02,
 5.295174684983208063e-02,
 5.300788010777105624e-02,
 5.306391645428597259e-02,
 5.311985581807824458e-02,
 5.317569812801723611e-02,
 5.323144331313999639e-02,
 5.328709130265070482e-02,
 5.334264202592216980e-02,
 5.339809541249441321e-02,
 5.345345139207607899e-02,
 5.350870989454341309e-02,
 5.356387084994088804e-02,
 5.361893418848173720e-02,
 5.367389984054671964e-02,
 5.372876773668572303e-02,
 5.378353780761641750e-02,
 5.383820998422571974e-02,
 5.389278419756853705e-02,
 5.394726037886869718e-02,
 5.400163845951916342e-02,
 5.405591837108115333e-02,
 5.411010004528542250e-02,
 5.416418341403101550e-02,
 5.421816840938671611e-02,
 5.427205496359019388e-02,
 5.432584300904848978e-02,
 5.437953247833755138e-02,
 5.443312330420335687e-02,
 5.448661541956043713e-02,
 5.454000875749392963e-02,
 5.459330325125762162e-02,
 5.464649883427561555e-02,
 5.469959544014151021e-02,
 5.475259300261873380e-02,
 5.480549145564053704e-02,
 5.485829073331015271e-02,
 5.491099076990126060e-02,
 5.496359149985673848e-02,
 5.501609285779077846e-02,
 5.506849477848690944e-02,
 5.512079719689932933e-02,
 5.517300004815305081e-02,
 5.522510326754258292e-02,
 5.527710679053360332e-02,
 5.532901055276252117e-02,
 5.538081449003617873e-02,
 5.543251853833216364e-02,
 5.548412263379872561e-02,
 5.553562671275531770e-02,
 5.558703071169208976e-02,
 5.563833456727025617e-02,
 5.568953821632222773e-02,
 5.574064159585120914e-02,
 5.579164464303242726e-02,
 5.584254729521166694e-02,
 5.589334948990588858e-02,
 5.594405116480426210e-02,
 5.599465225776712601e-02,
 5.604515270682555034e-02,
 5.609555245018368885e-02,
 5.614585142621629499e-02,
 5.619604957347033164e-02,
 5.624614683066404136e-02,
 5.629614313668844516e-02,
 5.634603843060554534e-02,
 5.639583265165002551e-02,
 5.644552573922831384e-02,
 5.649511763291903410e-02,
 5.654460827247313054e-02,
 5.659399759781354178e-02,
 5.664328554903555468e-02,
 5.669247206640703335e-02,
 5.674155709036855788e-02,
 5.679054056153227253e-02,
 5.683942242068356493e-02,
 5.688820260878069135e-02,
 5.693688106695372203e-02,
 5.698545773650633833e-02,
 5.703393255891472946e-02,
 5.708230547582748837e-02,
 5.713057642906693712e-02,
 5.717874536062783619e-02,
 5.722681221267806456e-02,
 5.727477692755898048e-02,
 5.732263944778416553e-02,
 5.737039971604179778e-02,
 5.741805767519200104e-02,
 5.746561326826916949e-02,
 5.751306643848066308e-02,
 5.756041712920724474e-02,
 5.760766528400321912e-02,
 5.765481084659693223e-02,
 5.770185376088962648e-02,
 5.774879397095648154e-02,
 5.779563142104661433e-02,
 5.784236605558303046e-02,
 5.788899781916190257e-02,
 5.793552665655406914e-02,
 5.798195251270366751e-02,
 5.802827533272946620e-02,
 5.807449506192371297e-02,
 5.812061164575316879e-02,
 5.816662502985853883e-02,
 5.821253516005472917e-02,
 5.825834198233137418e-02,
 5.830404544285188589e-02,
 5.834964548795427280e-02,
 5.839514206415075126e-02,
 5.844053511812848101e-02,
 5.848582459674872558e-02,
 5.853101044704765721e-02,
 5.857609261623575314e-02,
 5.862107105169820503e-02,
 5.866594570099548100e-02,
 5.871071651186222234e-02,
 5.875538343220818027e-02,
 5.879994641011788981e-02,
 5.884440539385053792e-02,
 5.888876033184119868e-02,
 5.893301117269909850e-02,
 5.897715786520873332e-02,
 5.902120035832996575e-02,
 5.906513860119776832e-02,
 5.910897254312202226e-02,
 5.915270213358863466e-02,
 5.919632732225748456e-02,
 5.923984805896560096e-02,
 5.928326429372395012e-02,
 5.932657597671964905e-02,
 5.936978305831498715e-02,
 5.941288548904798822e-02,
 5.945588321963245909e-02,
 5.949877620095773284e-02,
 5.954156438408847452e-02,
 5.958424772026549993e-02,
 5.962682616090504012e-02,
 5.966929965759953242e-02,
 5.971166816211699591e-02,
 5.975393162640171146e-02,
 5.979609000257315315e-02,
 5.983814324292757725e-02,
 5.988009129993713403e-02,
 5.992193412624966659e-02,
 5.996367167468918957e-02,
 6.000530389825620148e-02,
 6.004683075012749033e-02,
 6.008825218365557858e-02,
 6.012956815236951413e-02,
 6.017077860997464139e-02,
 6.021188351035305919e-02,
 6.025288280756233017e-02,
 6.029377645583769429e-02,
 6.033456440958968880e-02,
 6.037524662340636172e-02,
 6.041582305205141223e-02,
 6.045629365046591847e-02,
 6.049665837376710237e-02,
 6.053691717724921095e-02,
 6.057707001638295424e-02,
 6.061711684681578283e-02,
 6.065705762437215848e-02,
 6.069689230505288802e-02,
 6.073662084503631681e-02,
 6.077624320067723240e-02,
 6.081575932850757926e-02,
 6.085516918523595220e-02,
 6.089447272774822090e-02,
 6.093366991310749520e-02,
 6.097276069855338265e-02,
 6.101174504150295996e-02,
 6.105062289955041910e-02,
 6.108939423046712974e-02,
 6.112805899220199318e-02,
 6.116661714288013779e-02,
 6.120506864080526438e-02,
 6.124341344445741880e-02,
 6.128165151249445608e-02,
 6.131978280375144363e-02,
 6.135780727724095968e-02,
 6.139572489215308626e-02,
 6.143353560785497908e-02,
 6.147123938389214420e-02,
 6.150883617998630787e-02,
 6.154632595603786588e-02,
 6.158370867212459299e-02,
 6.162098428850183718e-02,
 6.165815276560212416e-02,
 6.169521406403614960e-02,
 6.173216814459264734e-02,
 6.176901496823707094e-02,
 6.180575449611366845e-02,
 6.184238668954403217e-02,
 6.187891151002749418e-02,
 6.191532891924152182e-02,
 6.195163887904114874e-02,
 6.198784135145966184e-02,
 6.202393629870802533e-02,
 6.205992368317531788e-02,
 6.209580346742846896e-02,
 6.213157561421245312e-02,
 6.216724008645053284e-02,
 6.220279684724362712e-02,
 6.223824585987130370e-02,
 6.227358708779064805e-02,
 6.230882049463722094e-02,
 6.234394604422476699e-02,
 6.237896370054529099e-02,
 6.241387342776841957e-02,
 6.244867519024285135e-02,
 6.248336895249526068e-02,
 6.251795467923002003e-02,
 6.255243233533086533e-02,
 6.258680188585898085e-02,
 6.262106329605429678e-02,
 6.265521653133532265e-02,
 6.268926155729838412e-02,
 6.272319833971871927e-02,
 6.275702684454968761e-02,
 6.279074703792360268e-02,
 6.282435888615059416e-02,
 6.285786235571974578e-02,
 6.289125741329855412e-02,
 6.292454402573292860e-02,
 6.295772216004782984e-02,
 6.299079178344590968e-02,
 6.302375286330956505e-02,
 6.305660536719862042e-02,
 6.308934926285225675e-02,
 6.312198451818823441e-02,
 6.315451110130285151e-02,
 6.318692898047148510e-02,
 6.321923812414736998e-02,
 6.325143850096338893e-02,
 6.328353007973064326e-02,
 6.331551282943882752e-02,
 6.334738671925721487e-02,
 6.337915171853307494e-02,
 6.341080779679271473e-02,
 6.344235492374147856e-02,
 6.347379306926304032e-02,
 6.350512220342070802e-02,
 6.353634229645603593e-02,
 6.356745331878953242e-02,
 6.359845524102084036e-02,
 6.362934803392794603e-02,
 6.366013166846878901e-02,
 6.369080611577909723e-02,
 6.372137134717430207e-02,
 6.375182733414884451e-02,
 6.378217404837525917e-02,
 6.381241146170602008e-02,
 6.384253954617211124e-02,
 6.387255827398378993e-02,
 6.390246761752980953e-02,
 6.393226754937884893e-02,
 6.396195804227750026e-02,
 6.399153906915246159e-02,
 6.402101060310881608e-02,
 6.405037261743101729e-02,
 6.407962508558223691e-02,
 6.410876798120546116e-02,
 6.413780127812156173e-02,
 6.416672495033198809e-02,
 6.419553897201626946e-02,
 6.422424331753322224e-02,
 6.425283796142099157e-02,
 6.428132287839662118e-02,
 6.430969804335694151e-02,
 6.433796343137687668e-02,
 6.436611901771115141e-02,
 6.439416477779395798e-02,
 6.442210068723791538e-02,
 6.444992672183504079e-02,
 6.447764285755680502e-02,
 6.450524907055386892e-02,
 6.453274533715565309e-02,
 6.456013163387139264e-02,
 6.458740793738859676e-02,
 6.461457422457483890e-02,
 6.464163047247674376e-02,
 6.466857665831965418e-02,
 6.469541275950865811e-02,
 6.472213875362778368e-02,
 6.474875461844036006e-02,
 6.477526033188911458e-02,
 6.480165587209546496e-02,
 6.482794121736043524e-02,
 6.485411634616440602e-02,
 6.488018123716668417e-02,
 6.490613586920578049e-02,
 6.493198022130006186e-02,
 6.495771427264596110e-02,
 6.498333800262034998e-02,
 6.500885139077866581e-02,
 6.503425441685553587e-02,
 6.505954706076490235e-02,
 6.508472930260013334e-02,
 6.510980112263375919e-02,
 6.513476250131751411e-02,
 6.515961341928186434e-02,
 6.518435385733731269e-02,
 6.520898379647305232e-02,
 6.523350321785775785e-02,
 6.525791210283908572e-02,
 6.528221043294385462e-02,
 6.530639818987830914e-02,
 6.533047535552805041e-02,
 6.535444191195734220e-02,
 6.537829784140994360e-02,
 6.540204312630878980e-02,
 6.542567774925628354e-02,
 6.544920169303343471e-02,
 6.547261494060066522e-02,
 6.549591747509776740e-02,
 6.551910927984357091e-02,
 6.554219033833558195e-02,
 6.556516063425142649e-02,
 6.558802015144699071e-02,
 6.561076887395775326e-02,
 6.563340678599807743e-02,
 6.565593387196162756e-02,
 6.567835011642128573e-02,
 6.570065550412847177e-02,
 6.572285002001426735e-02,
 6.574493364918883309e-02,
 6.576690637694106167e-02,
 6.578876818873878596e-02,
 6.581051907022968106e-02,
 6.583215900723954350e-02,
 6.585368798577398430e-02,
 6.587510599201716610e-02,
 6.589641301233217785e-02,
 6.591760903326158993e-02,
 6.593869404152659375e-02,
 6.595966802402745965e-02,
 6.598053096784313454e-02,
 6.600128286023232427e-02,
 6.602192368863173122e-02,
 6.604245344065777512e-02,
 6.606287210410509425e-02,
 6.608317966694776668e-02,
 6.610337611733853314e-02,
 6.612346144360890798e-02,
 6.614343563427002581e-02,
 6.616329867801035158e-02,
 6.618305056369863659e-02,
 6.620269128038186457e-02,
 6.622222081728609822e-02,
 6.624163916381548001e-02,
 6.626094630955337017e-02,
 6.628014224426226342e-02,
 6.629922695788320608e-02,
 6.631820044053536589e-02,
 6.633706268251707283e-02,
 6.635581367430583299e-02,
 6.637445340655687143e-02,
 6.639298187010470031e-02,
 6.641139905596217530e-02,
 6.642970495532107833e-02,
 6.644789955955167360e-02,
 6.646598286020261037e-02,
 6.648395484900121444e-02,
 6.650181551785340484e-02,
 6.651956485884379100e-02,
 6.653720286423496499e-02,
 6.655472952646863949e-02,
 6.657214483816434325e-02,
 6.658944879212078116e-02,
 6.660664138131458523e-02,
 6.662372259890071702e-02,
 6.664069243821270361e-02,
 6.665755089276266532e-02,
 6.667429795624084388e-02,
 6.669093362251569956e-02,
 6.670745788563367529e-02,
 6.672387073982048722e-02,
 6.674017217947891822e-02,
 6.675636219919105219e-02,
 6.677244079371609520e-02,
 6.678840795799265151e-02,
 6.680426368713603125e-02,
 6.682000797644097045e-02,
 6.683564082137981310e-02,
 6.685116221760270538e-02,
 6.686657216093806755e-02,
 6.688187064739266330e-02,
 6.689705767315061447e-02,
 6.691213323457469164e-02,
 6.692709732820502355e-02,
 6.694194995075991583e-02,
 6.695669109913553185e-02,
 6.697132077040622578e-02,
 6.698583896182386255e-02,
 6.700024567081774851e-02,
 6.701454089499578326e-02,
 6.702872463214304410e-02,
 6.704279688022246608e-02,
 6.705675763737496686e-02,
 6.707060690191844754e-02,
 6.708434467234959675e-02,
 6.709797094734129552e-02,
 6.711148572574517079e-02,
 6.712488900658948598e-02,
 6.713818078908097287e-02,
 6.715136107260304132e-02,
 6.716442985671716714e-02,
 6.717738714116151810e-02,
 6.719023292585253604e-02,
 6.720296721088332703e-02,
 6.721558999652436917e-02,
 6.722810128322413703e-02,
 6.724050107160785272e-02,
 6.725278936247754136e-02,
 6.726496615681316904e-02,
 6.727703145577153265e-02,
 6.728898526068685659e-02,
 6.730082757306976582e-02,
 6.731255839460888180e-02,
 6.732417772716889348e-02,
 6.733568557279240308e-02,
 6.734708193369813578e-02,
 6.735836681228260514e-02,
 6.736954021111815627e-02,
 6.738060213295520018e-02,
 6.739155258071975740e-02,
 6.740239155751573397e-02,
 6.741311906662275644e-02,
 6.742373511149797605e-02,
 6.743423969577479193e-02,
 6.744463282326358666e-02,
 6.745491449795065764e-02,
 6.746508472399943834e-02,
 6.747514350574959630e-02,
 6.748509084771776856e-02,
 6.749492675459652091e-02,
 6.750465123125466704e-02,
 6.751426428273797631e-02,
 6.752376591426817454e-02,
 6.753315613124342975e-02,
 6.754243493923771380e-02,
 6.755160234400212071e-02,
 6.756065835146277121e-02,
 6.756960296772276942e-02,
 6.757843619906092614e-02,
 6.758715805193174497e-02,
 6.759576853296704602e-02,
 6.760426764897296825e-02,
 6.761265540693230103e-02,
 6.762093181400390118e-02,
 6.762909687752223509e-02,
 6.763715060499757292e-02,
 6.764509300411562787e-02,
 6.765292408273830549e-02,
 6.766064384890295436e-02,
 6.766825231082226888e-02,
 6.767574947688474729e-02,
 6.768313535565484429e-02,
 6.769040995587161103e-02,
 6.769757328644993022e-02,
 6.770462535648059943e-02,
 6.771156617522849919e-02,
 6.771839575213528528e-02,
 6.772511409681640504e-02,
 6.773172121906369247e-02,
 6.773821712884364743e-02,
 6.774460183629787968e-02,
 6.775087535174281750e-02,
 6.775703768567016561e-02,
 6.776308884874672478e-02,
 6.776902885181392000e-02,
 6.777485770588805025e-02,
 6.778057542216060771e-02,
 6.778618201199762550e-02,
 6.779167748693958051e-02,
 6.779706185870200408e-02,
 6.780233513917451049e-02,
 6.780749734042226806e-02,
 6.781254847468372315e-02,
 6.781748855437283452e-02,
 6.782231759207738020e-02,
 6.782703560055988734e-02,
 6.783164259275675789e-02,
 6.783613858177889311e-02,
 6.784052358091162416e-02,
 6.784479760361372680e-02,
 6.784896066351914223e-02,
 6.785301277443521462e-02,
 6.785695395034284372e-02,
 6.786078420539819189e-02,
 6.786450355392958933e-02,
 6.786811201044103126e-02,
 6.787160958960895829e-02,
 6.787499630628374137e-02,
 6.787827217549018133e-02,
 6.788143721242591300e-02,
 6.788449143246266804e-02,
 6.788743485114526188e-02,
 6.789026748419188517e-02,
 6.789298934749483927e-02,
 6.789560045711905134e-02,
 6.789810082930312907e-02,
 6.790049048045870839e-02,
 6.790276942717067554e-02,
 6.790493768619711157e-02,
 6.790699527446925066e-02,
 6.790894220909075851e-02,
 6.791077850733910626e-02,
 6.791250418666365529e-02,
 6.791411926468775284e-02,
 6.791562375920660866e-02,
 6.791701768818818319e-02,
 6.791830106977357617e-02,
 6.791947392227652702e-02,
 6.792053626418277645e-02,
 6.792148811415053833e-02,
 6.792232949101095763e-02,
 6.792306041376748593e-02,
 6.792368090159517369e-02,
 6.792419097384203019e-02,
 6.792459065002823260e-02,
 6.792487994984505728e-02,
 6.792505889315728074e-02,
 6.792512750000080646e-02,
 6.792508579058351148e-02,
 6.792493378528512149e-02,
 6.792467150465743286e-02,
 6.792429896942386858e-02,
 6.792381620047942270e-02,
 6.792322321889077141e-02,
 6.792252004589612036e-02,
 6.792170670290484380e-02,
 6.792078321149835896e-02,
 6.791974959342905738e-02,
 6.791860587062065191e-02,
 6.791735206516784362e-02,
 6.791598819933700182e-02,
 6.791451429556505381e-02,
 6.791293037646069231e-02,
 6.791123646480261289e-02,
 6.790943258354106837e-02,
 6.790751875579699448e-02,
 6.790549500486178780e-02,
 6.790336135419772212e-02,
 6.790111782743830926e-02,
 6.789876444838652270e-02,
 6.789630124101661557e-02,
 6.789372822947276065e-02,
 6.789104543806998016e-02,
 6.788825289129306328e-02,
 6.788535061379750990e-02,
 6.788233863040873950e-02,
 6.787921696612199407e-02,
 6.787598564610297647e-02,
 6.787264469568686509e-02,
 6.786919414037921594e-02,
 6.786563400585463035e-02,
 6.786196431795862849e-02,
 6.785818510270515136e-02,
 6.785429638627851756e-02,
 6.785029819503200776e-02,
 6.784619055548890554e-02,
 6.784197349434101243e-02,
 6.783764703845072963e-02,
 6.783321121484826854e-02,
 6.782866605073427368e-02,
 6.782401157347718590e-02,
 6.781924781061553220e-02,
 6.781437478985641309e-02,
 6.780939253907521114e-02,
 6.780430108631704811e-02,
 6.779910045979534172e-02,
 6.779379068789159746e-02,
 6.778837179915687960e-02,
 6.778284382230999328e-02,
 6.777720678623866402e-02,
 6.777146071999845534e-02,
 6.776560565281335158e-02,
 6.775964161407570241e-02,
 6.775356863334598689e-02,
 6.774738674035213348e-02,
 6.774109596499121311e-02,
 6.773469633732667750e-02,
 6.772818788759077391e-02,
 6.772157064618346267e-02,
 6.771484464367186207e-02,
 6.770800991079062303e-02,
 6.770106647844295611e-02,
 6.769401437769793917e-02,
 6.768685363979293212e-02,
 6.767958429613236959e-02,
 6.767220637828805230e-02,
 6.766471991799843932e-02,
 6.765712494716913383e-02,
 6.764942149787260550e-02,
 6.764160960234900932e-02,
 6.763368929300385413e-02,
 6.762566060241007038e-02,
 6.761752356330767710e-02,
 6.760927820860275494e-02,
 6.760092457136736288e-02,
 6.759246268484035702e-02,
 6.758389258242764042e-02,
 6.757521429769960952e-02,
 6.756642786439474857e-02,
 6.755753331641566051e-02,
 6.754853068783248093e-02,
 6.753942001288032460e-02,
 6.753020132596018743e-02,
 6.752087466163932128e-02,
 6.751144005464992937e-02,
 6.750189753988990182e-02,
 6.749224715242288508e-02,
 6.748248892747764349e-02,
 6.747262290044865607e-02,
 6.746264910689440952e-02,
 6.745256758254009055e-02,
 6.744237836327461599e-02,
 6.743208148515295042e-02,
 6.742167698439355261e-02,
 6.741116489738120665e-02,
 6.740054526066431573e-02,
 6.738981811095597074e-02,
 6.737898348513422786e-02,
 6.736804142024130360e-02,
 6.735699195348350543e-02,
 6.734583512223211998e-02,
 6.733457096402160891e-02,
 6.732319951655106605e-02,
 6.731172081768371784e-02,
 6.730013490544672905e-02,
 6.728844181803009250e-02,
 6.727664159378872466e-02,
 6.726473427124059212e-02,
 6.725271988906718346e-02,
 6.724059848611391166e-02,
 6.722837010138846270e-02,
 6.721603477406304372e-02,
 6.720359254347262057e-02,
 6.719104344911451532e-02,
 6.717838753065000224e-02,
 6.716562482790300326e-02,
 6.715275538085981044e-02,
 6.713977922966982148e-02,
 6.712669641464520665e-02,
 6.711350697626049244e-02,
 6.710021095515233958e-02,
 6.708680839212033398e-02,
 6.707329932812575168e-02,
 6.705968380429234987e-02,
 6.704596186190610319e-02,
 6.703213354241450983e-02,
 6.701819888742745202e-02,
 6.700415793871612735e-02,
 6.699001073821393704e-02,
 6.697575732801525072e-02,
 6.696139775037637798e-02,
 6.694693204771515194e-02,
 6.693236026261026317e-02,
 6.691768243780188419e-02,
 6.690289861619148903e-02,
 6.688800884084124265e-02,
 6.687301315497426457e-02,
 6.685791160197492033e-02,
 6.684270422538753087e-02,
 6.682739106891821823e-02,
 6.681197217643226882e-02,
 6.679644759195633996e-02,
 6.678081735967769661e-02,
 6.676508152394257378e-02,
 6.674924012925848027e-02,
 6.673329322029282473e-02,
 6.671724084187226345e-02,
 6.670108303898442115e-02,
 6.668481985677571222e-02,
 6.666845134055271460e-02,
 6.665197753578151751e-02,
 6.663539848808716637e-02,
 6.661871424325496727e-02,
 6.660192484722869677e-02,
 6.658503034611167049e-02,
 6.656803078616607694e-02,
 6.655092621381315798e-02,
 6.653371667563305614e-02,
 6.651640221836453704e-02,
 6.649898288890510045e-02,
 6.648145873431086927e-02,
 6.646382980179639521e-02,
 6.644609613873420084e-02,
 6.642825779265544572e-02,
 6.641031481124941294e-02,
 6.639226724236330091e-02,
 6.637411513400232055e-02,
 6.635585853432969528e-02,
 6.633749749166562015e-02,
 6.631903205448852479e-02,
 6.630046227143467086e-02,
 6.628178819129712518e-02,
 6.626300986302646745e-02,
 6.624412733573052658e-02,
 6.622514065867385336e-02,
 6.620604988127859469e-02,
 6.618685505312377204e-02,
 6.616755622394444869e-02,
 6.614815344363285388e-02,
 6.612864676223818849e-02,
 6.610903622996525120e-02,
 6.608932189717613148e-02,
 6.606950381438818354e-02,
 6.604958203227567770e-02,
 6.602955660166837104e-02,
 6.600942757355265922e-02,
 6.598919499906999442e-02,
 6.596885892951787067e-02,
 6.594841941634935201e-02,
 6.592787651117305858e-02,
 6.590723026575312504e-02,
 6.588648073200849276e-02,
 6.586562796201402004e-02,
 6.584467200799851150e-02,
 6.582361292234710504e-02,
 6.580245075759857953e-02,
 6.578118556644708959e-02,
 6.575981740174102752e-02,
 6.573834631648378668e-02,
 6.571677236383285936e-02,
 6.569509559709978130e-02,
 6.567331606975074232e-02,
 6.565143383540560096e-02,
 6.562944894783860617e-02,
 6.560736146097720378e-02,
 6.558517142890357698e-02,
 6.556287890585209277e-02,
 6.554048394621198037e-02,
 6.551798660452497203e-02,
 6.549538693548669077e-02,
 6.547268499394544305e-02,
 6.544988083490298203e-02,
 6.542697451351363325e-02,
 6.540396608508490528e-02,
 6.538085560507657379e-02,
 6.535764312910150031e-02,
 6.533432871292441102e-02,
 6.531091241246315959e-02,
 6.528739428378749210e-02,
 6.526377438311911638e-02,
 6.524005276683181309e-02,
 6.521622949145168546e-02,
 6.519230461365606299e-02,
 6.516827819027418145e-02,
 6.514415027828711346e-02,
 6.511992093482660282e-02,
 6.509559021717699345e-02,
 6.507115818277238450e-02,
 6.504662488919907282e-02,
 6.502199039419370719e-02,
 6.499725475564394062e-02,
 6.497241803158836093e-02,
 6.494748028021614383e-02,
 6.492244155986665044e-02,
 6.489730192902980199e-02,
 6.487206144634594107e-02,
 6.484672017060535976e-02,
 6.482127816074868820e-02,
 6.479573547586597870e-02,
 6.477009217519713591e-02,
 6.474434831813237479e-02,
 6.471850396421074958e-02,
 6.469255917312104198e-02,
 6.466651400470127542e-02,
 6.464036851893874280e-02,
 6.461412277596990938e-02,
 6.458777683607962172e-02,
 6.456133075970235669e-02,
 6.453478460742052836e-02,
 6.450813843996597297e-02,
 6.448139231821792272e-02,
 6.445454630320508749e-02,
 6.442760045610347597e-02,
 6.440055483823763083e-02,
 6.437340951108042053e-02,
 6.434616453625155441e-02,
 6.431881997551958108e-02,
 6.429137589079962634e-02,
 6.426383234415482260e-02,
 6.423618939779637826e-02,
 6.420844711408121852e-02,
 6.418060555551424740e-02,
 6.415266478474757061e-02,
 6.412462486457977395e-02,
 6.409648585795589548e-02,
 6.406824782796825823e-02,
 6.403991083785519345e-02,
 6.401147495100172058e-02,
 6.398294023093852034e-02,
 6.395430674134335025e-02,
 6.392557454603876865e-02,
 6.389674370899417477e-02,
 6.386781429432421275e-02,
 6.383878636628907699e-02,
 6.380965998929473415e-02,
 6.378043522789239583e-02,
 6.375111214677828264e-02,
 6.372169081079424868e-02,
 6.369217128492637991e-02,
 6.366255363430614600e-02,
 6.363283792420933171e-02,
 6.360302422005675860e-02,
 6.357311258741323023e-02,
 6.354310309198858697e-02,
 6.351299579963566588e-02,
 6.348279077635292367e-02,
 6.345248808828135578e-02,
 6.342208780170628668e-02,
 6.339158998305732817e-02,
 6.336099469890663083e-02,
 6.333030201596999420e-02,
 6.329951200110758847e-02,
 6.326862472132099846e-02,
 6.323764024375627679e-02,
 6.320655863570151523e-02,
 6.317537996458816307e-02,
 6.314410429798975044e-02,
 6.311273170362281804e-02,
 6.308126224934582083e-02,
 6.304969600315990519e-02,
 6.301803303320796523e-02,
 6.298627340777505912e-02,
 6.295441719528774294e-02,
 6.292246446431525031e-02,
 6.289041528356709154e-02,
 6.285826972189503814e-02,
 6.282602784829183218e-02,
 6.279368973189192182e-02,
 6.276125544197026784e-02,
 6.272872504794256565e-02,
 6.269609861936606410e-02,
 6.266337622593792789e-02,
 6.263055793749613964e-02,
 6.259764382401923621e-02,
 6.256463395562558705e-02,
 6.253152840257379663e-02,
 6.249832723526260042e-02,
 6.246503052423064972e-02,
 6.243163834015583169e-02,
 6.239815075385600485e-02,
 6.236456783628836764e-02,
 6.233088965854913927e-02,
 6.229711629187419802e-02,
 6.226324780763790867e-02,
 6.222928427735385098e-02,
 6.219522577267425772e-02,
 6.216107236538991748e-02,
 6.212682412743041754e-02,
 6.209248113086290183e-02,
 6.205804344789371541e-02,
 6.202351115086639916e-02,
 6.198888431226289020e-02,
 6.195416300470246718e-02,
 6.191934730094276335e-02,
 6.188443727387862858e-02,
 6.184943299654133142e-02,
 6.181433454210117501e-02,
 6.177914198386358358e-02,
 6.174385539527264127e-02,
 6.170847484990827497e-02,
 6.167300042148709388e-02,
 6.163743218386254913e-02,
 6.160177021102443418e-02,
 6.156601457709855174e-02,
 6.153016535634711626e-02,
 6.149422262316778937e-02,
 6.145818645209495668e-02,
 6.142205691779784038e-02,
 6.138583409508138744e-02,
 6.134951805888614468e-02,
 6.131310888428789102e-02,
 6.127660664649749872e-02,
 6.124001142086045457e-02,
 6.120332328285796319e-02,
 6.116654230810474741e-02,
 6.112966857235119927e-02,
 6.109270215148111804e-02,
 6.105564312151313261e-02,
 6.101849155860007701e-02,
 6.098124753902829653e-02,
 6.094391113921839714e-02,
 6.090648243572428094e-02,
 6.086896150523399968e-02,
 6.083134842456833224e-02,
 6.079364327068136065e-02,
 6.075584612066101814e-02,
 6.071795705172762514e-02,
 6.067997614123368799e-02,
 6.064190346666589737e-02,
 6.060373910564206129e-02,
 6.056548313591318677e-02,
 6.052713563536245289e-02,
 6.048869668200469729e-02,
 6.045016635398713090e-02,
 6.041154472958823463e-02,
 6.037283188721898064e-02,
 6.033402790542110455e-02,
 6.029513286286801443e-02,
 6.025614683836429814e-02,
 6.021706991084553595e-02,
 6.017790215937846715e-02,
 6.013864366315989363e-02,
 6.009929450151842850e-02,
 6.005985475391211609e-02,
 6.002032449992958374e-02,
 5.998070381929009737e-02,
 5.994099279184224305e-02,
 5.990119149756505113e-02,
 5.986130001656708027e-02,
 5.982131842908657016e-02,
 5.978124681549074754e-02,
 5.974108525627679078e-02,
 5.970083383207090005e-02,
 5.966049262362759648e-02,
 5.962006171183082542e-02,
 5.957954117769333202e-02,
 5.953893110235589092e-02,
 5.949823156708800714e-02,
 5.945744265328729156e-02,
 5.941656444247973151e-02,
 5.937559701631908715e-02,
 5.933454045658610732e-02,
 5.929339484519084019e-02,
 5.925216026416929571e-02,
 5.921083679568556191e-02,
 5.916942452203061836e-02,
 5.912792352562278725e-02,
 5.908633388900697697e-02,
 5.904465569485480708e-02,
 5.900288902596441398e-02,
 5.896103396526113094e-02,
 5.891909059579514274e-02,
 5.887705900074409471e-02,
 5.883493926341051838e-02,
 5.879273146722376747e-02,
 5.875043569573800556e-02,
 5.870805203263328165e-02,
 5.866558056171501667e-02,
 5.862302136691355248e-02,
 5.858037453228460978e-02,
 5.853764014200848326e-02,
 5.849481828039048564e-02,
 5.845190903186041342e-02,
 5.840891248097210275e-02,
 5.836582871240426212e-02,
 5.832265781095920254e-02,
 5.827939986156360080e-02,
 5.823605494926780562e-02,
 5.819262315924547679e-02,
 5.814910457679407785e-02,
 5.810549928733436259e-02,
 5.806180737641022938e-02,
 5.801802892968853376e-02,
 5.797416403295928972e-02,
 5.793021277213471903e-02,
 5.788617523325014641e-02,
 5.784205150246274352e-02,
 5.779784166605241025e-02,
 5.775354581042063673e-02,
 5.770916402209093354e-02,
 5.766469638770919254e-02,
 5.762014299404230599e-02,
 5.757550392797818745e-02,
 5.753077927652755497e-02,
 5.748596912682033683e-02,
 5.744107356610912707e-02,
 5.739609268176614626e-02,
 5.735102656128479581e-02,
 5.730587529227899185e-02,
 5.726063896248271418e-02,
 5.721531765975041567e-02,
 5.716991147205652268e-02,
 5.712442048749506729e-02,
 5.707884479427996482e-02,
 5.703318448074451430e-02,
 5.698743963534200208e-02,
 5.694161034664391857e-02,
 5.689569670334165830e-02,
 5.684969879424487532e-02,
 5.680361670828290577e-02,
 5.675745053450245020e-02,
 5.671120036206943327e-02,
 5.666486628026794897e-02,
 5.661844837849949741e-02,
 5.657194674628488601e-02,
 5.652536147326144705e-02,
 5.647869264918425197e-02,
 5.643194036392642360e-02,
 5.638510470747817166e-02,
 5.633818576994634869e-02,
 5.629118364155526882e-02,
 5.624409841264614573e-02,
 5.619693017367604487e-02,
 5.614967901521949328e-02,
 5.610234502796652284e-02,
 5.605492830272397475e-02,
 5.600742893041402853e-02,
 5.595984700207511792e-02,
 5.591218260886120922e-02,
 5.586443584204182217e-02,
 5.581660679300166905e-02,
 5.576869555324061312e-02,
 5.572070221437371712e-02,
 5.567262686813057720e-02,
 5.562446960635576698e-02,
 5.557623052100821304e-02,
 5.552790970416122268e-02,
 5.547950724800197048e-02,
 5.543102324483224763e-02,
 5.538245778706716443e-02,
 5.533381096723598291e-02,
 5.528508287798087478e-02,
 5.523627361205758757e-02,
 5.518738326233544461e-02,
 5.513841192179637363e-02,
 5.508935968353532303e-02,
 5.504022664075960275e-02,
 5.499101288678934218e-02,
 5.494171851505726123e-02,
 5.489234361910780291e-02,
 5.484288829259760523e-02,
 5.479335262929493217e-02,
 5.474373672308031208e-02,
 5.469404066794493480e-02,
 5.464426455799206717e-02,
 5.459440848743577629e-02,
 5.454447255060156791e-02,
 5.449445684192509576e-02,
 5.444436145595336202e-02,
 5.439418648734330869e-02,
 5.434393203086274049e-02,
 5.429359818138908972e-02,
 5.424318503391040852e-02,
 5.419269268352389785e-02,
 5.414212122543697603e-02,
 5.409147075496628654e-02,
 5.404074136753813512e-02,
 5.398993315868720611e-02,
 5.393904622405804039e-02,
 5.388808065940341868e-02,
 5.383703656058484721e-02,
 5.378591402357282836e-02,
 5.373471314444529939e-02,
 5.368343401938924231e-02,
 5.363207674469887970e-02,
 5.358064141677650744e-02,
 5.352912813213222404e-02,
 5.347753698738307027e-02,
 5.342586807925400749e-02,
 5.337412150457663401e-02,
 5.332229736028994138e-02,
 5.327039574343888501e-02,
 5.321841675117598702e-02,
 5.316636048075944199e-02,
 5.311422702955387321e-02,
 5.306201649503061724e-02,
 5.300972897476620427e-02,
 5.295736456644251078e-02,
 5.290492336784832078e-02,
 5.285240547687656415e-02,
 5.279981099152607910e-02,
 5.274714000990050194e-02,
 5.269439263020838510e-02,
 5.264156895076309989e-02,
 5.258866906998211493e-02,
 5.253569308638787044e-02,
 5.248264109860659166e-02,
 5.242951320536841375e-02,
 5.237630950550757614e-02,
 5.232303009796211019e-02,
 5.226967508177290250e-02,
 5.221624455608476351e-02,
 5.216273862014558782e-02,
 5.210915737330573672e-02,
 5.205550091501891241e-02,
 5.200176934484127683e-02,
 5.194796276243101446e-02,
 5.189408126754919970e-02,
 5.184012496005863113e-02,
 5.178609393992416460e-02,
 5.173198830721230379e-02,
 5.167780816209111699e-02,
 5.162355360483014688e-02,
 5.156922473579986926e-02,
 5.151482165547226211e-02,
 5.146034446441987570e-02,
 5.140579326331576326e-02,
 5.135116815293402914e-02,
 5.129646923414850346e-02,
 5.124169660793369274e-02,
 5.118685037536339910e-02,
 5.113193063761219126e-02,
 5.107693749595326738e-02,
 5.102187105176012039e-02,
 5.096673140650480327e-02,
 5.091151866175894908e-02,
 5.085623291919275091e-02,
 5.080087428057553089e-02,
 5.074544284777495612e-02,
 5.068993872275697615e-02,
 5.063436200758578143e-02,
 5.057871280442387957e-02,
 5.052299121553131822e-02,
 5.046719734326599732e-02,
 5.041133129008294744e-02,
 5.035539315853504450e-02,
 5.029938305127179543e-02,
 5.024330107104010845e-02,
 5.018714732068339096e-02,
 5.013092190314184793e-02,
 5.007462492145176025e-02,
 5.001825647874581088e-02,
 4.996181667825300848e-02,
 4.990530562329784786e-02,
 4.984872341730085116e-02,
 4.979207016377780459e-02,
 4.973534596633998051e-02,
 4.967855092869404715e-02,
 4.962168515464071561e-02,
 4.956474874807702963e-02,
 4.950774181299291005e-02,
 4.945066445347434669e-02,
 4.939351677370024812e-02,
 4.933629887794480778e-02,
 4.927901087057492274e-02,
 4.922165285605227536e-02,
 4.916422493893132101e-02,
 4.910672722386032890e-02,
 4.904915981558033433e-02,
 4.899152281892584643e-02,
 4.893381633882377263e-02,
 4.887604048029381421e-02,
 4.881819534844816788e-02,
 4.876028104849126910e-02,
 4.870229768571975038e-02,
 4.864424536552172662e-02,
 4.858612419337757227e-02,
 4.852793427485885963e-02,
 4.846967571562876137e-02,
 4.841134862144134271e-02,
 4.835295309814165166e-02,
 4.829448925166580919e-02,
 4.823595718804060684e-02,
 4.817735701338290988e-02,
 4.811868883390012230e-02,
 4.805995275588965943e-02,
 4.800114888573878136e-02,
 4.794227732992429464e-02,
 4.788333819501323224e-02,
 4.782433158766098008e-02,
 4.776525761461283826e-02,
 4.770611638270255001e-02,
 4.764690799885328704e-02,
 4.758763257007622705e-02,
 4.752829020347125455e-02,
 4.746888100622639189e-02,
 4.740940508561763966e-02,
 4.734986254900939995e-02,
 4.729025350385309551e-02,
 4.723057805768773876e-02,
 4.717083631814002198e-02,
 4.711102839292354016e-02,
 4.705115438983901999e-02,
 4.699121441677368838e-02,
 4.693120858170117538e-02,
 4.687113699268218026e-02,
 4.681099975786287559e-02,
 4.675079698547592727e-02,
 4.669052878383987693e-02,
 4.663019526135862847e-02,
 4.656979652652144808e-02,
 4.650933268790324870e-02,
 4.644880385416384760e-02,
 4.638821013404804267e-02,
 4.632755163638501567e-02,
 4.626682847008935229e-02,
 4.620604074415867596e-02,
 4.614518856767588911e-02,
 4.608427204980741071e-02,
 4.602329129980362726e-02,
 4.596224642699796997e-02,
 4.590113754080822617e-02,
 4.583996475073425642e-02,
 4.577872816636011782e-02,
 4.571742789735203788e-02,
 4.565606405345892793e-02,
 4.559463674451223747e-02,
 4.553314608042612066e-02,
 4.547159217119613878e-02,
 4.540997512690028021e-02,
 4.534829505769791269e-02,
 4.528655207383002618e-02,
 4.522474628561960752e-02,
 4.516287780346958658e-02,
 4.510094673786484154e-02,
 4.503895319937069319e-02,
 4.497689729863293268e-02,
 4.491477914637789087e-02,
 4.485259885341236902e-02,
 4.479035653062277827e-02,
 4.472805228897564628e-02,
 4.466568623951669426e-02,
 4.460325849337180154e-02,
 4.454076916174579126e-02,
 4.447821835592240258e-02,
 4.441560618726441562e-02,
 4.435293276721347794e-02,
 4.429019820728947315e-02,
 4.422740261909081927e-02,
 4.416454611429407318e-02,
 4.410162880465331309e-02,
 4.403865080200126264e-02,
 4.397561221824712596e-02,
 4.391251316537842647e-02,
 4.384935375545925135e-02,
 4.378613410063104255e-02,
 4.372285431311198622e-02,
 4.365951450519653387e-02,
 4.359611478925617956e-02,
 4.353265527773812760e-02,
 4.346913608316568117e-02,
 4.340555731813862395e-02,
 4.334191909533140902e-02,
 4.327822152749470630e-02,
 4.321446472745422984e-02,
 4.315064880811071008e-02,
 4.308677388244008116e-02,
 4.302284006349252343e-02,
 4.295884746439302543e-02,
 4.289479619834084961e-02,
 4.283068637860940053e-02,
 4.276651811854599583e-02,
 4.270229153157180380e-02,
 4.263800673118157275e-02,
 4.257366383094281920e-02,
 4.250926294449747234e-02,
 4.244480418555914708e-02,
 4.238028766791494123e-02,
 4.231571350542447790e-02,
 4.225108181201967655e-02,
 4.218639270170465583e-02,
 4.212164628855573356e-02,
 4.205684268672092024e-02,
 4.199198201042007861e-02,
 4.192706437394397995e-02,
 4.186208989165535882e-02,
 4.179705867798730323e-02,
 4.173197084744417751e-02,
 4.166682651460123371e-02,
 4.160162579410358469e-02,
 4.153636880066716164e-02,
 4.147105564907785369e-02,
 4.140568645419123034e-02,
 4.134026133093293698e-02,
 4.127478039429757078e-02,
 4.120924375934965217e-02,
 4.114365154122257007e-02,
 4.107800385511856112e-02,
 4.101230081630884150e-02,
 4.094654254013296857e-02,
 4.088072914199894492e-02,
 4.081486073738274656e-02,
 4.074893744182861433e-02,
 4.068295937094841552e-02,
 4.061692664042148432e-02,
 4.055083936599476746e-02,
 4.048469766348206100e-02,
 4.041850164876472501e-02,
 4.035225143779005985e-02,
 4.028594714657295073e-02,
 4.021958889119382763e-02,
 4.015317678780003924e-02,
 4.008671095260434719e-02,
 4.002019150188559915e-02,
 3.995361855198851370e-02,
 3.988699221932283379e-02,
 3.982031262036384023e-02,
 3.975357987165178270e-02,
 3.968679408979136625e-02,
 3.961995539145282685e-02,
 3.955306389336993994e-02,
 3.948611971234129020e-02,
 3.941912296522928627e-02,
 3.935207376896057707e-02,
 3.928497224052495546e-02,
 3.921781849697576761e-02,
 3.915061265543030161e-02,
 3.908335483306811520e-02,
 3.901604514713215982e-02,
 3.894868371492783005e-02,
 3.888127065382314396e-02,
 3.881380608124846560e-02,
 3.874629011469610945e-02,
 3.867872287172049311e-02,
 3.861110446993745726e-02,
 3.854343502702484159e-02,
 3.847571466072126356e-02,
 3.840794348882688863e-02,
 3.834012162920250044e-02,
 3.827224919977000039e-02,
 3.820432631851138072e-02,
 3.813635310346943225e-02,
 3.806832967274662027e-02,
 3.800025614450566053e-02,
 3.793213263696884607e-02,
 3.786395926841826937e-02,
 3.779573615719524632e-02,
 3.772746342170011508e-02,
 3.765914118039226377e-02,
 3.759076955179008195e-02,
 3.752234865446999607e-02,
 3.745387860706746175e-02,
 3.738535952827556907e-02,
 3.731679153684563932e-02,
 3.724817475158666291e-02,
 3.717950929136523003e-02,
 3.711079527510558612e-02,
 3.704203282178872986e-02,
 3.697322205045285720e-02,
 3.690436308019295203e-02,
 3.683545603016058489e-02,
 3.676650101956362854e-02,
 3.669749816766625095e-02,
 3.662844759378879045e-02,
 3.655934941730717980e-02,
 3.649020375765257146e-02,
 3.642101073431219110e-02,
 3.635177046682813023e-02,
 3.628248307479772089e-02,
 3.621314867787261277e-02,
 3.614376739575951569e-02,
 3.607433934821958899e-02,
 3.600486465506764350e-02,
 3.593534343617337673e-02,
 3.586577581145945770e-02,
 3.579616190090267186e-02,
 3.572650182453302597e-02,
 3.565679570243376201e-02,
 3.558704365474121140e-02,
 3.551724580164458689e-02,
 3.544740226338576050e-02,
 3.537751316025834758e-02,
 3.530757861260945540e-02,
 3.523759874083701865e-02,
 3.516757366539129820e-02,
 3.509750350677431907e-02,
 3.502738838553919043e-02,
 3.495722842229066069e-02,
 3.488702373768427095e-02,
 3.481677445242634811e-02,
 3.474648068727383826e-02,
 3.467614256303408471e-02,
 3.460576020056515406e-02,
 3.453533372077439295e-02,
 3.446486324461955214e-02,
 3.439434889310758608e-02,
 3.432379078729535377e-02,
 3.425318904828855704e-02,
 3.418254379724208758e-02,
 3.411185515535961749e-02,
 3.404112324389373112e-02,
 3.397034818414480795e-02,
 3.389953009746213275e-02,
 3.382866910524239684e-02,
 3.375776532893085685e-02,
 3.368681889002000940e-02,
 3.361582991004958415e-02,
 3.354479851060693935e-02,
 3.347372481332599320e-02,
 3.340260893988820229e-02,
 3.333145101202093091e-02,
 3.326025115149827682e-02,
 3.318900948014090468e-02,
 3.311772611981474157e-02,
 3.304640119243243412e-02,
 3.297503481995137098e-02,
 3.290362712437513992e-02,
 3.283217822775203604e-02,
 3.276068825217583885e-02,
 3.268915731978463274e-02,
 3.261758555276127181e-02,
 3.254597307333346318e-02,
 3.247432000377284411e-02,
 3.240262646639460731e-02,
 3.233089258355882623e-02,
 3.225911847766821383e-02,
 3.218730427116943404e-02,
 3.211545008655208866e-02,
 3.204355604634909205e-02,
 3.197162227313599114e-02,
 3.189964888953100708e-02,
 3.182763601819471599e-02,
 3.175558378182979230e-02,
 3.168349230318137644e-02,
 3.161136170503602710e-02,
 3.153919211022189473e-02,
 3.146698364160890188e-02,
 3.139473642210763998e-02,
 3.132245057467017424e-02,
 3.125012622228925951e-02,
 3.117776348799799688e-02,
 3.110536249487054483e-02,
 3.103292336602034643e-02,
 3.096044622460157950e-02,
 3.088793119380787641e-02,
 3.081537839687258432e-02,
 3.074278795706857775e-02,
 3.067015999770758214e-02,
 3.059749464214062825e-02,
 3.052479201375721610e-02,
 3.045205223598593594e-02,
 3.037927543229318114e-02,
 3.030646172618399470e-02,
 3.023361124120127127e-02,
 3.016072410092573639e-02,
 3.008780042897519005e-02,
 3.001484034900565867e-02,
 2.994184398470949721e-02,
 2.986881145981700597e-02,
 2.979574289809417201e-02,
 2.972263842334461892e-02,
 2.964949815940718172e-02,
 2.957632223015804057e-02,
 2.950311075950869111e-02,
 2.942986387140629836e-02,
 2.935658168983410962e-02,
 2.928326433880999030e-02,
 2.920991194238781175e-02,
 2.913652462465578588e-02,
 2.906310250973696135e-02,
 2.898964572178935883e-02,
 2.891615438500470467e-02,
 2.884262862360955845e-02,
 2.876906856186384198e-02,
 2.869547432406126253e-02,
 2.862184603452966325e-02,
 2.854818381762948623e-02,
 2.847448779775477168e-02,
 2.840075809933246404e-02,
 2.832699484682191585e-02,
 2.825319816471543941e-02,
 2.817936817753737347e-02,
 2.810550500984434694e-02,
 2.803160878622456068e-02,
 2.795767963129860284e-02,
 2.788371766971776272e-02,
 2.780972302616538036e-02,
 2.773569582535558367e-02,
 2.766163619203312884e-02,
 2.758754425097415669e-02,
 2.751342012698482567e-02,
 2.743926394490137435e-02,
 2.736507582959079102e-02,
 2.729085590594929403e-02,
 2.721660429890342819e-02,
 2.714232113340886432e-02,
 2.706800653445059351e-02,
 2.699366062704273289e-02,
 2.691928353622815434e-02,
 2.684487538707878637e-02,
 2.677043630469453164e-02,
 2.669596641420401983e-02,
 2.662146584076346273e-02,
 2.654693470955750076e-02,
 2.647237314579810666e-02,
 2.639778127472465138e-02,
 2.632315922160410535e-02,
 2.624850711173027165e-02,
 2.617382507042344958e-02,
 2.609911322303134357e-02,
 2.602437169492753666e-02,
 2.594960061151213235e-02,
 2.587480009821125151e-02,
 2.579997028047665425e-02,
 2.572511128378610762e-02,
 2.565022323364230319e-02,
 2.557530625557376258e-02,
 2.550036047513350862e-02,
 2.542538601789964131e-02,
 2.535038300947506026e-02,
 2.527535157548667713e-02,
 2.520029184158595684e-02,
 2.512520393344814737e-02,
 2.505008797677250876e-02,
 2.497494409728173714e-02,
 2.489977242072232214e-02,
 2.482457307286325618e-02,
 2.474934617949693313e-02,
 2.467409186643873889e-02,
 2.459881025952658298e-02,
 2.452350148462032961e-02,
 2.444816566760267540e-02,
 2.437280293437767142e-02,
 2.429741341087167036e-02,
 2.422199722303235506e-02,
 2.414655449682870728e-02,
 2.407108535825125406e-02,
 2.399558993331096096e-02,
 2.392006834804014451e-02,
 2.384452072849111565e-02,
 2.376894720073700895e-02,
 2.369334789087084933e-02,
 2.361772292500581225e-02,
 2.354207242927480737e-02,
 2.346639652982982285e-02,
 2.339069535284280660e-02,
 2.331496902450472253e-02,
 2.323921767102526958e-02,
 2.316344141863314193e-02,
 2.308764039357522058e-02,
 2.301181472211722215e-02,
 2.293596453054234929e-02,
 2.286008994515244253e-02,
 2.278419109226657857e-02,
 2.270826809822136874e-02,
 2.263232108937118098e-02,
 2.255635019208688391e-02,
 2.248035553275679402e-02,
 2.240433723778551683e-02,
 2.232829543359446042e-02,
 2.225223024662135313e-02,
 2.217614180332000071e-02,
 2.210003023015956122e-02,
 2.202389565362581486e-02,
 2.194773820021931471e-02,
 2.187155799645636514e-02,
 2.179535516886796018e-02,
 2.171912984400038715e-02,
 2.164288214841421018e-02,
 2.156661220868479403e-02,
 2.149032015140175250e-02,
 2.141400610316850084e-02,
 2.133767019060271719e-02,
 2.126131254033531565e-02,
 2.118493327901116094e-02,
 2.110853253328788190e-02,
 2.103211042983654452e-02,
 2.095566709534099278e-02,
 2.087920265649757801e-02,
 2.080271724001547459e-02,
 2.072621097261545531e-02,
 2.064968398103088007e-02,
 2.057313639200685287e-02,
 2.049656833229994077e-02,
 2.041997992867842712e-02,
 2.034337130792159692e-02,
 2.026674259681992760e-02,
 2.019009392217467960e-02,
 2.011342541079759114e-02,
 2.003673718951118690e-02,
 1.996002938514775810e-02,
 1.988330212455003201e-02,
 1.980655553457021448e-02,
 1.972978974207040617e-02,
 1.965300487392212733e-02,
 1.957620105700571406e-02,
 1.949937841821106424e-02,
 1.942253708443663490e-02,
 1.934567718258909177e-02,
 1.926879883958423911e-02,
 1.919190218234553130e-02,
 1.911498733780466266e-02,
 1.903805443290123786e-02,
 1.896110359458202943e-02,
 1.888413494980176188e-02,
 1.880714862552180372e-02,
 1.873014474871095153e-02,
 1.865312344634443426e-02,
 1.857608484540446483e-02,
 1.849902907287905018e-02,
 1.842195625576302856e-02,
 1.834486652105688995e-02,
 1.826775999576674483e-02,
 1.819063680690471974e-02,
 1.811349708148777410e-02,
 1.803634094653869605e-02,
 1.795916852908448214e-02,
 1.788197995615734004e-02,
 1.780477535479400505e-02,
 1.772755485203566725e-02,
 1.765031857492738165e-02,
 1.757306665051855052e-02,
 1.749579920586179227e-02,
 1.741851636801389214e-02,
 1.734121826403452887e-02,
 1.726390502098682639e-02,
 1.718657676593651068e-02,
 1.710923362595239902e-02,
 1.703187572810583444e-02,
 1.695450319947021736e-02,
 1.687711616712144966e-02,
 1.679971475813703957e-02,
 1.672229909959653191e-02,
 1.664486931858086965e-02,
 1.656742554217204011e-02,
 1.648996789745362651e-02,
 1.641249651151016273e-02,
 1.633501151142645325e-02,
 1.625751302428826706e-02,
 1.618000117718148070e-02,
 1.610247609719222053e-02,
 1.602493791140632839e-02,
 1.594738674690967042e-02,
 1.586982273078747785e-02,
 1.579224599012422903e-02,
 1.571465665200376394e-02,
 1.563705484350847580e-02,
 1.555944069171991823e-02,
 1.548181432371771409e-02,
 1.540417586658024418e-02,
 1.532652544738356999e-02,
 1.524886319320222991e-02,
 1.517118923110769187e-02,
 1.509350368816970295e-02,
 1.501580669145480100e-02,
 1.493809836802709005e-02,
 1.486037884494697918e-02,
 1.478264824927232046e-02,
 1.470490670805681480e-02,
 1.462715434835087404e-02,
 1.454939129720101559e-02,
 1.447161768164928648e-02,
 1.439383362873401968e-02,
 1.431603926548843594e-02,
 1.423823471894164472e-02,
 1.416042011611735874e-02,
 1.408259558403454278e-02,
 1.400476124970686728e-02,
 1.392691724014217397e-02,
 1.384906368234311257e-02,
 1.377120070330587441e-02,
 1.369332843002084125e-02,
 1.361544698947226260e-02,
 1.353755650863760346e-02,
 1.345965711448785136e-02,
 1.338174893398695088e-02,
 1.330383209409175503e-02,
 1.322590672175204610e-02,
 1.314797294390974806e-02,
 1.307003088749943316e-02,
 1.299208067944750654e-02,
 1.291412244667253587e-02,
 1.283615631608443254e-02,
 1.275818241458499640e-02,
 1.268020086906728253e-02,
 1.260221180641510341e-02,
 1.252421535350367425e-02,
 1.244621163719867966e-02,
 1.236820078435592503e-02,
 1.229018292182223505e-02,
 1.221215817643404519e-02,
 1.213412667501808165e-02,
 1.205608854439032228e-02,
 1.197804391135664712e-02,
 1.189999290271218091e-02,
 1.182193564524092362e-02,
 1.174387226571612340e-02,
 1.166580289089936932e-02,
 1.158772764754124364e-02,
 1.150964666238015431e-02,
 1.143156006214289533e-02,
 1.135346797354437089e-02,
 1.127537052328664476e-02,
 1.119726783805992387e-02,
 1.111916004454143597e-02,
 1.104104726939526479e-02,
 1.096292963927299365e-02,
 1.088480728081244429e-02,
 1.080668032063831878e-02,
 1.072854888536159054e-02,
 1.065041310157906727e-02,
 1.057227309587394949e-02,
 1.049412899481472726e-02,
 1.041598092495585499e-02,
 1.033782901283672104e-02,
 1.025967338498220104e-02,
 1.018151416790183221e-02,
 1.010335148809009785e-02,
 1.002518547202608905e-02,
 9.947016246172901005e-03,
 9.868843936978231521e-03,
 9.790668670873334950e-03,
 9.712490574273693542e-03,
 9.634309773577699049e-03,
 9.556126395167533968e-03,
 9.477940565408553980e-03,
 9.399752410649133555e-03,
 9.321562057220096967e-03,
 9.243369631435193606e-03,
 9.165175259590249701e-03,
 9.086979067963569037e-03,
 9.008781182815096822e-03,
 8.930581730387011224e-03,
 8.852380836902535091e-03,
 8.774178628566737387e-03,
 8.695975231565766447e-03,
 8.617770772066518647e-03,
 8.539565376217148410e-03,
 8.461359170145852163e-03,
 8.383152279961801623e-03,
 8.304944831754108164e-03,
 8.226736951591560876e-03,
 8.148528765523341266e-03,
 8.070320399578114270e-03,
 7.992111979763639670e-03,
 7.913903632067403535e-03,
 7.835695482455390035e-03,
 7.757487656872967020e-03,
 7.679280281243582376e-03,
 7.601073481469540309e-03,
 7.522867383431415880e-03,
 7.444662112987415759e-03,
 7.366457795974118948e-03,
 7.288254558205302380e-03,
 7.210052525472642609e-03,
 7.131851823544627274e-03,
 7.053652578167328782e-03,
 6.975454915063137099e-03,
 6.897258959931817923e-03,
 6.819064838448712050e-03,
 6.740872676266367741e-03,
 6.662682599012785187e-03,
 6.584494732292325500e-03,
 6.506309201684579678e-03,
 6.428126132745171778e-03,
 6.349945651004570632e-03,
 6.271767881968682255e-03,
 6.193592951118326827e-03,
 6.115420983908769446e-03,
 6.037252105770213664e-03,
 5.959086442106805749e-03,
 5.880924118297226229e-03,
 5.802765259693740997e-03,
 5.724609991622748618e-03,
 5.646458439383824496e-03,
 5.568310728250222205e-03,
 5.490166983468448489e-03,
 5.412027330257518191e-03,
 5.333891893809524984e-03,
 5.255760799289375083e-03,
 5.177634171833914688e-03,
 5.099512136552688049e-03,
 5.021394818526795159e-03,
 4.943282342809447727e-03,
 4.865174834425557183e-03,
 4.787072418371055536e-03,
 4.708975219613626556e-03,
 4.630883363091514889e-03,
 4.552796973714272853e-03,
 4.474716176361692721e-03,
 4.396641095884322795e-03,
 4.318571857103025054e-03,
 4.240508584808365400e-03,
 4.162451403761308413e-03,
 4.084400438692192131e-03,
 4.006355814300652587e-03,
 3.928317655256179791e-03,
 3.850286086196911227e-03,
 3.772261231730303192e-03,
 3.694243216432124659e-03,
 3.616232164847018454e-03,
 3.538228201487954826e-03,
 3.460231450835730537e-03,
 3.382242037339577758e-03,
 3.304260085416032156e-03,
 3.226285719449650206e-03,
 3.148319063791948404e-03,
 3.070360242761956213e-03,
 2.992409380645714295e-03,
 2.914466601695759728e-03,
 2.836532030131651196e-03,
 2.758605790138973692e-03,
 2.680688005870097024e-03,
 2.602778801442753344e-03,
 2.524878300940885858e-03,
 2.446986628414211679e-03,
 2.369103907877894398e-03,
 2.291230263312090450e-03,
 2.213365818662446118e-03,
 2.135510697839109601e-03,
 2.057665024717341643e-03,
 1.979828923136511994e-03,
 1.902002516900740603e-03,
 1.824185929777866980e-03,
 1.746379285499993382e-03,
 1.668582707762979568e-03,
 1.590796320225925427e-03,
 1.513020246511760560e-03,
 1.435254610206139914e-03,
 1.357499534858182776e-03,
 1.279755143979579169e-03,
 1.202021561044317507e-03,
 1.124298909489353324e-03,
 1.046587312713780733e-03,
 9.688868940784140264e-04,
 8.911977769063677288e-04,
 8.135200844819832347e-04,
 7.358539400515273603e-04,
 6.581994668221228867e-04,
 5.805567879624279207e-04,
 5.029260266015866043e-04,
 4.253073058297913273e-04,
 3.477007486977757005e-04,
 2.701064782162925664e-04,
 1.925246173566905780e-04,
 1.149552890498587685e-04,
 3.739861618690078964e-05,
-4.014527838191673045e-05,
-1.176762718463792454e-04,
-1.951942414378095389e-04,
-2.726990644277444971e-04,
-3.501906181294143594e-04,
-4.276687798969660984e-04,
-5.051334271265076146e-04,
-5.825844372554404372e-04,
-6.600216877634958960e-04,
-7.374450561721857022e-04,
-8.148544200453007895e-04,
-8.922496569894189378e-04,
-9.696306446533568173e-04,
-1.046997260729194126e-03,
-1.124349382951607889e-03,
-1.201686889098945278e-03,
-1.279009656992492316e-03,
-1.356317564497590712e-03,
-1.433610489523009027e-03,
-1.510888310021392834e-03,
-1.588150903990068327e-03,
-1.665398149470364480e-03,
-1.742629924547937654e-03,
-1.819846107353568273e-03,
-1.897046576062512251e-03,
-1.974231208895524045e-03,
-2.051399884118308269e-03,
-2.128552480042021026e-03,
-2.205688875023785554e-03,
-2.282808947466102856e-03,
-2.359912575817913784e-03,
-2.436999638573955022e-03,
-2.514070014275717520e-03,
-2.591123581510874473e-03,
-2.668160218914249725e-03,
-2.745179805167287379e-03,
-2.822182218998429103e-03,
-2.899167339184002736e-03,
-2.976135044547434730e-03,
-3.053085213959653467e-03,
-3.130017726339871190e-03,
-3.206932460654882307e-03,
-3.283829295920174043e-03,
-3.360708111199278095e-03,
-3.437568785604366069e-03,
-3.514411198296658878e-03,
-3.591235228485957064e-03,
-3.668040755431594899e-03,
-3.744827658441808940e-03,
-3.821595816874810096e-03,
-3.898345110138130062e-03,
-3.975075417689218939e-03,
-4.051786619035905798e-03,
-4.128478593735794566e-03,
-4.205151221397186896e-03,
-4.281804381679252605e-03,
-4.358437954291360071e-03,
-4.435051818994362530e-03,
-4.511645855599836531e-03,
-4.588219943971162673e-03,
-4.664773964022865538e-03,
-4.741307795721230386e-03,
-4.817821319084673523e-03,
-4.894314414183340706e-03,
-4.970786961139992723e-03,
-5.047238840129393035e-03,
-5.123669931379389378e-03,
-5.200080115170225073e-03,
-5.276469271835211236e-03,
-5.352837281761056373e-03,
-5.429184025387425762e-03,
-5.505509383207913762e-03,
-5.581813235769257989e-03,
-5.658095463672780864e-03,
-5.734355947573452003e-03,
-5.810594568180321023e-03,
-5.886811206257283428e-03,
-5.963005742622541974e-03,
-6.039178058149038616e-03,
-6.115328033764964519e-03,
-6.191455550453312494e-03,
-6.267560489252795540e-03,
-6.343642731257126063e-03,
-6.419702157616224113e-03,
-6.495738649535507878e-03,
-6.571752088276411503e-03,
-6.647742355156932396e-03,
-6.723709331551080449e-03,
-6.799652898889758414e-03,
-6.875572938660311738e-03,
-6.951469332407186896e-03,
-7.027341961732234965e-03,
-7.103190708294098397e-03,
-7.179015453809017670e-03,
-7.254816080051144402e-03,
-7.330592468852093792e-03,
-7.406344502101844945e-03,
-7.482072061748176219e-03,
-7.557775029797664419e-03,
-7.633453288314961428e-03,
-7.709106719423859319e-03,
-7.784735205306783819e-03,
-7.860338628205157732e-03,
-7.935916870419999422e-03,
-8.011469814311365095e-03,
-8.086997342299244787e-03,
-8.162499336863126079e-03,
-8.237975680542698395e-03,
-8.313426255937382894e-03,
-8.388850945707638715e-03,
-8.464249632573618565e-03,
-8.539622199316693543e-03,
-8.614968528778639556e-03,
-8.690288503862712843e-03,
-8.765582007532871089e-03,
-8.840848922814854155e-03,
-8.916089132795618558e-03,
-8.991302520624166669e-03,
-9.066488969511104362e-03,
-9.141648362729098976e-03,
-9.216780583613434427e-03,
-9.291885515561253139e-03,
-9.366963042032844938e-03,
-9.442013046550817856e-03,
-9.517035412701071312e-03,
-9.592030024132411001e-03,
-9.666996764556713695e-03,
-9.741935517749926443e-03,
-9.816846167551348395e-03,
-9.891728597863790398e-03,
-9.966582692654485723e-03,
-1.004140833595446904e-02,
-1.011620541185948713e-02,
-1.019097380452949411e-02,
-1.026571339818911806e-02,
-1.034042407712815366e-02,
-1.041510572570097590e-02,
-1.048975822832767975e-02,
-1.056438146949321803e-02,
-1.063897533374848561e-02,
-1.071353970570980765e-02,
-1.078807447005966647e-02,
-1.086257951154636497e-02,
-1.093705471498447775e-02,
-1.101149996525510252e-02,
-1.108591514730609962e-02,
-1.116030014615159056e-02,
-1.123465484687303367e-02,
-1.130897913461867757e-02,
-1.138327289460439387e-02,
-1.145753601211317585e-02,
-1.153176837249560681e-02,
-1.160596986117041519e-02,
-1.168014036362384662e-02,
-1.175427976541067523e-02,
-1.182838795215346295e-02,
-1.190246480954385705e-02,
-1.197651022334163262e-02,
-1.205052407937548010e-02,
-1.212450626354328632e-02,
-1.219845666181176499e-02,
-1.227237516021730673e-02,
-1.234626164486517588e-02,
-1.242011600193114115e-02,
-1.249393811766024223e-02,
-1.256772787836746459e-02,
-1.264148517043824083e-02,
-1.271520988032809850e-02,
-1.278890189456309209e-02,
-1.286256109974020720e-02,
-1.293618738252682622e-02,
-1.300978062966175880e-02,
-1.308334072795463987e-02,
-1.315686756428677447e-02,
-1.323036102561073873e-02,
-1.330382099895065229e-02,
-1.337724737140302475e-02,
-1.345064003013572360e-02,
-1.352399886238925958e-02,
-1.359732375547626458e-02,
-1.367061459678180560e-02,
-1.374387127376418272e-02,
-1.381709367395380673e-02,
-1.389028168495455226e-02,
-1.396343519444333964e-02,
-1.403655409017029107e-02,
-1.410963825995940543e-02,
-1.418268759170799968e-02,
-1.425570197338749817e-02,
-1.432868129304312385e-02,
-1.440162543879457135e-02,
-1.447453429883551086e-02,
-1.454740776143422128e-02,
-1.462024571493401350e-02,
-1.469304804775248795e-02,
-1.476581464838266911e-02,
-1.483854540539250588e-02,
-1.491124020742557246e-02,
-1.498389894320033972e-02,
-1.505652150151180410e-02,
-1.512910777123003397e-02,
-1.520165764130162675e-02,
-1.527417100074878777e-02,
-1.534664773867061224e-02,
-1.541908774424226303e-02,
-1.549149090671580499e-02,
-1.556385711541984421e-02,
-1.563618625976039705e-02,
-1.570847822922013387e-02,
-1.578073291335924458e-02,
-1.585295020181545778e-02,
-1.592512998430391583e-02,
-1.599727215061787569e-02,
-1.606937659062812260e-02,
-1.614144319428400393e-02,
-1.621347185161275267e-02,
-1.628546245272012583e-02,
-1.635741488779073050e-02,
-1.642932904708782615e-02,
-1.650120482095336974e-02,
-1.657304209980860199e-02,
-1.664484077415393989e-02,
-1.671660073456930976e-02,
-1.678832187171405352e-02,
-1.686000407632739367e-02,
-1.693164723922832571e-02,
-1.700325125131577075e-02,
-1.707481600356927642e-02,
-1.714634138704829169e-02,
-1.721782729289313488e-02,
-1.728927361232479587e-02,
-1.736068023664467247e-02,
-1.743204705723564937e-02,
-1.750337396556168185e-02,
-1.757466085316800042e-02,
-1.764590761168125313e-02,
-1.771711413281015085e-02,
-1.778828030834426685e-02,
-1.785940603015610459e-02,
-1.793049119019981055e-02,
-1.800153568051210407e-02,
-1.807253939321163197e-02,
-1.814350222050008232e-02,
-1.821442405466204215e-02,
-1.828530478806429313e-02,
-1.835614431315739023e-02,
-1.842694252247480124e-02,
-1.849769930863369438e-02,
-1.856841456433412987e-02,
-1.863908818236035408e-02,
-1.870972005558073359e-02,
-1.878031007694650617e-02,
-1.885085813949460495e-02,
-1.892136413634551775e-02,
-1.899182796070371382e-02,
-1.906224950585923630e-02,
-1.913262866518629715e-02,
-1.920296533214453302e-02,
-1.927325940027815529e-02,
-1.934351076321689719e-02,
-1.941371931467623241e-02,
-1.948388494845643484e-02,
-1.955400755844413641e-02,
-1.962408703861166087e-02,
-1.969412328301762757e-02,
-1.976411618580611873e-02,
-1.983406564120829274e-02,
-1.990397154354161049e-02,
-1.997383378720982497e-02,
-2.004365226670372716e-02,
-2.011342687660168729e-02,
-2.018315751156804852e-02,
-2.025284406635518425e-02,
-2.032248643580293959e-02,
-2.039208451483795481e-02,
-2.046163819847546597e-02,
-2.053114738181808716e-02,
-2.060061196005696232e-02,
-2.067003182847060999e-02,
-2.073940688242652611e-02,
-2.080873701738052833e-02,
-2.087802212887722789e-02,
-2.094726211254940504e-02,
-2.101645686411963976e-02,
-2.108560627939915985e-02,
-2.115471025428816015e-02,
-2.122376868477672540e-02,
-2.129278146694432716e-02,
-2.136174849696001118e-02,
-2.143066967108291088e-02,
-2.149954488566212935e-02,
-2.156837403713643755e-02,
-2.163715702203534638e-02,
-2.170589373697885682e-02,
-2.177458407867768550e-02,
-2.184322794393244588e-02,
-2.191182522963568483e-02,
-2.198037583277048096e-02,
-2.204887965041131895e-02,
-2.211733657972365930e-02,
-2.218574651796476060e-02,
-2.225410936248370733e-02,
-2.232242501072075058e-02,
-2.239069336020856060e-02,
-2.245891430857188328e-02,
-2.252708775352756793e-02,
-2.259521359288491071e-02,
-2.266329172454580737e-02,
-2.273132204650442356e-02,
-2.279930445684823573e-02,
-2.286723885375735801e-02,
-2.293512513550566984e-02,
-2.300296320045912279e-02,
-2.307075294707813459e-02,
-2.313849427391647534e-02,
-2.320618707962102123e-02,
-2.327383126293321516e-02,
-2.334142672268821328e-02,
-2.340897335781540189e-02,
-2.347647106733810954e-02,
-2.354391975037434595e-02,
-2.361131930613697208e-02,
-2.367866963393333232e-02,
-2.374597063316512269e-02,
-2.381322220333019143e-02,
-2.388042424402045047e-02,
-2.394757665492363088e-02,
-2.401467933582283540e-02,
-2.408173218659702061e-02,
-2.414873510722014352e-02,
-2.421568799776277134e-02,
-2.428259075839132863e-02,
-2.434944328936799324e-02,
-2.441624549105166075e-02,
-2.448299726389753864e-02,
-2.454969850845764925e-02,
-2.461634912538027131e-02,
-2.468294901541101885e-02,
-2.474949807939216817e-02,
-2.481599621826360846e-02,
-2.488244333306196057e-02,
-2.494883932492179476e-02,
-2.501518409507494378e-02,
-2.508147754485099551e-02,
-2.514771957567769542e-02,
-2.521391008908066209e-02,
-2.528004898668332126e-02,
-2.534613617020769691e-02,
-2.541217154147456733e-02,
-2.547815500240245556e-02,
-2.554408645500927388e-02,
-2.560996580141157095e-02,
-2.567579294382508343e-02,
-2.574156778456423988e-02,
-2.580729022604298303e-02,
-2.587296017077506463e-02,
-2.593857752137282424e-02,
-2.600414218054923274e-02,
-2.606965405111665024e-02,
-2.613511303598744714e-02,
-2.620051903817406658e-02,
-2.626587196078941297e-02,
-2.633117170704669940e-02,
-2.639641818025910761e-02,
-2.646161128384130409e-02,
-2.652675092130845139e-02,
-2.659183699627613168e-02,
-2.665686941246180747e-02,
-2.672184807368355175e-02,
-2.678677288386138722e-02,
-2.685164374701586032e-02,
-2.691646056726997374e-02,
-2.698122324884836762e-02,
-2.704593169607706626e-02,
-2.711058581338451554e-02,
-2.717518550530145446e-02,
-2.723973067646070015e-02,
-2.730422123159706102e-02,
-2.736865707554890503e-02,
-2.743303811325676494e-02,
-2.749736424976351873e-02,
-2.756163539021579817e-02,
-2.762585143986306252e-02,
-2.769001230405786218e-02,
-2.775411788825617523e-02,
-2.781816809801774051e-02,
-2.788216283900562045e-02,
-2.794610201698661742e-02,
-2.800998553783171433e-02,
-2.807381330751602955e-02,
-2.813758523211814730e-02,
-2.820130121782168237e-02,
-2.826496117091436069e-02,
-2.832856499778882431e-02,
-2.839211260494176048e-02,
-2.845560389897498765e-02,
-2.851903878659590302e-02,
-2.858241717461611556e-02,
-2.864573896995281643e-02,
-2.870900407962870618e-02,
-2.877221241077154365e-02,
-2.883536387061510012e-02,
-2.889845836649886784e-02,
-2.896149580586820232e-02,
-2.902447609627414535e-02,
-2.908739914537423338e-02,
-2.915026486093235183e-02,
-2.921307315081834652e-02,
-2.927582392300894648e-02,
-2.933851708558758015e-02,
-2.940115254674438225e-02,
-2.946373021477612791e-02,
-2.952624999808687797e-02,
-2.958871180518815244e-02,
-2.965111554469821928e-02,
-2.971346112534322889e-02,
-2.977574845595667638e-02,
-2.983797744547979358e-02,
-2.990014800296145886e-02,
-2.996226003755887365e-02,
-3.002431345853718084e-02,
-3.008630817526926696e-02,
-3.014824409723700430e-02,
-3.021012113403050495e-02,
-3.027193919534801672e-02,
-3.033369819099694664e-02,
-3.039539803089375339e-02,
-3.045703862506340606e-02,
-3.051861988363997052e-02,
-3.058014171686675511e-02,
-3.064160403509676514e-02,
-3.070300674879206104e-02,
-3.076434976852443839e-02,
-3.082563300497551811e-02,
-3.088685636893630931e-02,
-3.094801977130823278e-02,
-3.100912312310266650e-02,
-3.107016633544135153e-02,
-3.113114931955582657e-02,
-3.119207198678861787e-02,
-3.125293424859282299e-02,
-3.131373601653184707e-02,
-3.137447720228008635e-02,
-3.143515771762303568e-02,
-3.149577747445735099e-02,
-3.155633638479035663e-02,
-3.161683436074105152e-02,
-3.167727131454024792e-02,
-3.173764715852933627e-02,
-3.179796180516231835e-02,
-3.185821516700475947e-02,
-3.191840715673370521e-02,
-3.197853768713873612e-02,
-3.203860667112141264e-02,
-3.209861402169569833e-02,
-3.215855965198770317e-02,
-3.221844347523621088e-02,
-3.227826540479292183e-02,
-3.233802535412162726e-02,
-3.239772323679968036e-02,
-3.245735896651730928e-02,
-3.251693245707757557e-02,
-3.257644362239693614e-02,
-3.263589237650521557e-02,
-3.269527863354596692e-02,
-3.275460230777569454e-02,
-3.281386331356513086e-02,
-3.287306156539927804e-02,
-3.293219697787594380e-02,
-3.299126946570792723e-02,
-3.305027894372191549e-02,
-3.310922532685895564e-02,
-3.316810853017428118e-02,
-3.322692846883793655e-02,
-3.328568505813479794e-02,
-3.334437821346383779e-02,
-3.340300785033966519e-02,
-3.346157388439146424e-02,
-3.352007623136393083e-02,
-3.357851480711644687e-02,
-3.363688952762397544e-02,
-3.369520030897739382e-02,
-3.375344706738248046e-02,
-3.381162971916106680e-02,
-3.386974818075079441e-02,
-3.392780236870526767e-02,
-3.398579219969401211e-02,
-3.404371759050284912e-02,
-3.410157845803388904e-02,
-3.415937471930517721e-02,
-3.421710629145192917e-02,
-3.427477309172569098e-02,
-3.433237503749444336e-02,
-3.438991204624349679e-02,
-3.444738403557481843e-02,
-3.450479092320767743e-02,
-3.456213262697817312e-02,
-3.461940906483977620e-02,
-3.467662015486393939e-02,
-3.473376581523868190e-02,
-3.479084596427029635e-02,
-3.484786052038276599e-02,
-3.490480940211772298e-02,
-3.496169252813470518e-02,
-3.501850981721182227e-02,
-3.507526118824461775e-02,
-3.513194656024758167e-02,
-3.518856585235308199e-02,
-3.524511898381255809e-02,
-3.530160587399555627e-02,
-3.535802644239046527e-02,
-3.541438060860489789e-02,
-3.547066829236515673e-02,
-3.552688941351611618e-02,
-3.558304389202270046e-02,
-3.563913164796875255e-02,
-3.569515260155697173e-02,
-3.575110667311044016e-02,
-3.580699378307130448e-02,
-3.586281385200165012e-02,
-3.591856680058275186e-02,
-3.597425254961711394e-02,
-3.602987102002578462e-02,
-3.608542213285103467e-02,
-3.614090580925478913e-02,
-3.619632197051973754e-02,
-3.625167053804850131e-02,
-3.630695143336477859e-02,
-3.636216457811256714e-02,
-3.641730989405721208e-02,
-3.647238730308396959e-02,
-3.652739672719994279e-02,
-3.658233808853313812e-02,
-3.663721130933236120e-02,
-3.669201631196800789e-02,
-3.674675301893201573e-02,
-3.680142135283783617e-02,
-3.685602123641992800e-02,
-3.691055259253532561e-02,
-3.696501534416225809e-02,
-3.701940941440117622e-02,
-3.707373472647440549e-02,
-3.712799120372669431e-02,
-3.718217876962450624e-02,
-3.723629734775699834e-02,
-3.729034686183596570e-02,
-3.734432723569503648e-02,
-3.739823839329121241e-02,
-3.745208025870394586e-02,
-3.750585275613556313e-02,
-3.755955580991112569e-02,
-3.761318934447895057e-02,
-3.766675328441061732e-02,
-3.772024755440098187e-02,
-3.777367207926747572e-02,
-3.782702678395204188e-02,
-3.788031159351967769e-02,
-3.793352643315910794e-02,
-3.798667122818249337e-02,
-3.803974590402650624e-02,
-3.809275038625111603e-02,
-3.814568460054058863e-02,
-3.819854847270352793e-02,
-3.825134192867239713e-02,
-3.830406489450425417e-02,
-3.835671729638064076e-02,
-3.840929906060760318e-02,
-3.846181011361544944e-02,
-3.851425038195969985e-02,
-3.856661979232080262e-02,
-3.861891827150345374e-02,
-3.867114574643797098e-02,
-3.872330214417971789e-02,
-3.877538739190903444e-02,
-3.882740141693161173e-02,
-3.887934414667906097e-02,
-3.893121550870780323e-02,
-3.898301543070002706e-02,
-3.903474384046402845e-02,
-3.908640066593373208e-02,
-3.913798583516828189e-02,
-3.918949927635364400e-02,
-3.924094091780156585e-02,
-3.929231068795024234e-02,
-3.934360851536343462e-02,
-3.939483432873183699e-02,
-3.944598805687260512e-02,
-3.949706962872886334e-02,
-3.954807897337120348e-02,
-3.959901601999640114e-02,
-3.964988069792834552e-02,
-3.970067293661744962e-02,
-3.975139266564148288e-02,
-3.980203981470523122e-02,
-3.985261431364083701e-02,
-3.990311609240713292e-02,
-3.995354508109139752e-02,
-4.000390120990699599e-02,
-4.005418440919607248e-02,
-4.010439460942782919e-02,
-4.015453174119935909e-02,
-4.020459573523536140e-02,
-4.025458652238897428e-02,
-4.030450403364089357e-02,
-4.035434820009985157e-02,
-4.040411895300320688e-02,
-4.045381622371627822e-02,
-4.050343994373289958e-02,
-4.055299004467526752e-02,
-4.060246645829395512e-02,
-4.065186911646891110e-02,
-4.070119795120772516e-02,
-4.075045289464762632e-02,
-4.079963387905467115e-02,
-4.084874083682338980e-02,
-4.089777370047774363e-02,
-4.094673240267094477e-02,
-4.099561687618551165e-02,
-4.104442705393286650e-02,
-4.109316286895407094e-02,
-4.114182425441990920e-02,
-4.119041114363064526e-02,
-4.123892347001600900e-02,
-4.128736116713578597e-02,
-4.133572416867953986e-02,
-4.138401240846645290e-02,
-4.143222582044631813e-02,
-4.148036433869869977e-02,
-4.152842789743340507e-02,
-4.157641643099022066e-02,
-4.162432987384018929e-02,
-4.167216816058346568e-02,
-4.171993122595202275e-02,
-4.176761900480763234e-02,
-4.181523143214311428e-02,
-4.186276844308189221e-02,
-4.191022997287817409e-02,
-4.195761595691784723e-02,
-4.200492633071667425e-02,
-4.205216102992228450e-02,
-4.209931999031346628e-02,
-4.214640314780011832e-02,
-4.219341043842326361e-02,
-4.224034179835592373e-02,
-4.228719716390227923e-02,
-4.233397647149780840e-02,
-4.238067965771043916e-02,
-4.242730665923971634e-02,
-4.247385741291588579e-02,
-4.252033185570275320e-02,
-4.256672992469491545e-02,
-4.261305155711993253e-02,
-4.265929669033666216e-02,
-4.270546526183673780e-02,
-4.275155720924431885e-02,
-4.279757247031507061e-02,
-4.284351098293814192e-02,
-4.288937268513463852e-02,
-4.293515751505858763e-02,
-4.298086541099637586e-02,
-4.302649631136748476e-02,
-4.307205015472430343e-02,
-4.311752687975195508e-02,
-4.316292642526847745e-02,
-4.320824873022548890e-02,
-4.325349373370731415e-02,
-4.329866137493156020e-02,
-4.334375159324957427e-02,
-4.338876432814580547e-02,
-4.343369951923777006e-02,
-4.347855710627739761e-02,
-4.352333702914962243e-02,
-4.356803922787312600e-02,
-4.361266364260085043e-02,
-4.365721021361902709e-02,
-4.370167888134796064e-02,
-4.374606958634202208e-02,
-4.379038226928971128e-02,
-4.383461687101372628e-02,
-4.387877333247046374e-02,
-4.392285159475150386e-02,
-4.396685159908210461e-02,
-4.401077328682202056e-02,
-4.405461659946584979e-02,
-4.409838147864254126e-02,
-4.414206786611574868e-02,
-4.418567570378387904e-02,
-4.422920493367980127e-02,
-4.427265549797225475e-02,
-4.431602733896343460e-02,
-4.435932039909168401e-02,
-4.440253462093015496e-02,
-4.444566994718717606e-02,
-4.448872632070582228e-02,
-4.453170368446525418e-02,
-4.457460198157925380e-02,
-4.461742115529745284e-02,
-4.466016114900501349e-02,
-4.470282190622257290e-02,
-4.474540337060622236e-02,
-4.478790548594808324e-02,
-4.483032819617577269e-02,
-4.487267144535318081e-02,
-4.491493517767936039e-02,
-4.495711933749014372e-02,
-4.499922386925699069e-02,
-4.504124871758752313e-02,
-4.508319382722555252e-02,
-4.512505914305126736e-02,
-4.516684461008123319e-02,
-4.520855017346771254e-02,
-4.525017577850037886e-02,
-4.529172137060508141e-02,
-4.533318689534380358e-02,
-4.537457229841566214e-02,
-4.541587752565647701e-02,
-4.545710252303872961e-02,
-4.549824723667152127e-02,
-4.553931161280114215e-02,
-4.558029559781111989e-02,
-4.562119913822143547e-02,
-4.566202218068942525e-02,
-4.570276467200968390e-02,
-4.574342655911371736e-02,
-4.578400778907081026e-02,
-4.582450830908717937e-02,
-4.586492806650661197e-02,
-4.590526700881057687e-02,
-4.594552508361755827e-02,
-4.598570223868440887e-02,
-4.602579842190478859e-02,
-4.606581358131065645e-02,
-4.610574766507159056e-02,
-4.614560062149517666e-02,
-4.618537239902652941e-02,
-4.622506294624925682e-02,
-4.626467221188458601e-02,
-4.630420014479191132e-02,
-4.634364669396873193e-02,
-4.638301180855131794e-02,
-4.642229543781336426e-02,
-4.646149753116739223e-02,
-4.650061803816422923e-02,
-4.653965690849326542e-02,
-4.657861409198205127e-02,
-4.661748953859702616e-02,
-4.665628319844329630e-02,
-4.669499502176427397e-02,
-4.673362495894248930e-02,
-4.677217296049895195e-02,
-4.681063897709418498e-02,
-4.684902295952672602e-02,
-4.688732485873445960e-02,
-4.692554462579473507e-02,
-4.696368221192322862e-02,
-4.700173756847527556e-02,
-4.703971064694540544e-02,
-4.707760139896684931e-02,
-4.711540977631302474e-02,
-4.715313573089595367e-02,
-4.719077921476754617e-02,
-4.722834018011873997e-02,
-4.726581857928025682e-02,
-4.730321436472269270e-02,
-4.734052748905592106e-02,
-4.737775790502919693e-02,
-4.741490556553242669e-02,
-4.745197042359450973e-02,
-4.748895243238444169e-02,
-4.752585154521111327e-02,
-4.756266771552383754e-02,
-4.759940089691069159e-02,
-4.763605104310143085e-02,
-4.767261810796485227e-02,
-4.770910204551006423e-02,
-4.774550280988653500e-02,
-4.778182035538423161e-02,
-4.781805463643278020e-02,
-4.785420560760292319e-02,
-4.789027322360546457e-02,
-4.792625743929167237e-02,
-4.796215820965314680e-02,
-4.799797548982256273e-02,
-4.803370923507283008e-02,
-4.806935940081784320e-02,
-4.810492594261182864e-02,
-4.814040881614994882e-02,
-4.817580797726830899e-02,
-4.821112338194355473e-02,
-4.824635498629366998e-02,
-4.828150274657772023e-02,
-4.831656661919482565e-02,
-4.835154656068643003e-02,
-4.838644252773407345e-02,
-4.842125447716098818e-02,
-4.845598236593141872e-02,
-4.849062615115089236e-02,
-4.852518579006655230e-02,
-4.855966124006619311e-02,
-4.859405245867967627e-02,
-4.862835940357776443e-02,
-4.866258203257311371e-02,
-4.869672030361964221e-02,
-4.873077417481298107e-02,
-4.876474360439041894e-02,
-4.879862855073077016e-02,
-4.883242897235448576e-02,
-4.886614482792416003e-02,
-4.889977607624360761e-02,
-4.893332267625889742e-02,
-4.896678458705793630e-02,
-4.900016176787035105e-02,
-4.903345417806807827e-02,
-4.906666177716458715e-02,
-4.909978452481603139e-02,
-4.913282238082000014e-02,
-4.916577530511660049e-02,
-4.919864325778795788e-02,
-4.923142619905868100e-02,
-4.926412408929538300e-02,
-4.929673688900706313e-02,
-4.932926455884500960e-02,
-4.936170705960307020e-02,
-4.939406435221723596e-02,
-4.942633639776641136e-02,
-4.945852315747144984e-02,
-4.949062459269617381e-02,
-4.952264066494711792e-02,
-4.955457133587272411e-02,
-4.958641656726479191e-02,
-4.961817632105755549e-02,
-4.964985055932804453e-02,
-4.968143924429618136e-02,
-4.971294233832436460e-02,
-4.974435980391848922e-02,
-4.977569160372623952e-02,
-4.980693770053960107e-02,
-4.983809805729247366e-02,
-4.986917263706258652e-02,
-4.990016140306981901e-02,
-4.993106431867763706e-02,
-4.996188134739292658e-02,
-4.999261245286509836e-02,
-5.002325759888728157e-02,
-5.005381674939549802e-02,
-5.008428986846908543e-02,
-5.011467692033088478e-02,
-5.014497786934671297e-02,
-5.017519268002623711e-02,
-5.020532131702191286e-02,
-5.023536374513021957e-02,
-5.026531992929098025e-02,
-5.029518983458706322e-02,
-5.032497342624548536e-02,
-5.035467066963638522e-02,
-5.038428153027395967e-02,
-5.041380597381545786e-02,
-5.044324396606238853e-02,
-5.047259547295959714e-02,
-5.050186046059578632e-02,
-5.053103889520325215e-02,
-5.056013074315849481e-02,
-5.058913597098151776e-02,
-5.061805454533638282e-02,
-5.064688643303076609e-02,
-5.067563160101652003e-02,
-5.070429001638937505e-02,
-5.073286164638880769e-02,
-5.076134645839915777e-02,
-5.078974441994753286e-02,
-5.081805549870622302e-02,
-5.084627966249102154e-02,
-5.087441687926227973e-02,
-5.090246711712378275e-02,
-5.093043034432441496e-02,
-5.095830652925694565e-02,
-5.098609564045779308e-02,
-5.101379764660845390e-02,
-5.104141251653477457e-02,
-5.106894021920615340e-02,
-5.109638072373690054e-02,
-5.112373399938566904e-02,
-5.115100001555572540e-02,
-5.117817874179425575e-02,
-5.120527014779325398e-02,
-5.123227420338918869e-02,
-5.125919087856293382e-02,
-5.128602014344005311e-02,
-5.131276196829060582e-02,
-5.133941632352932716e-02,
-5.136598317971558664e-02,
-5.139246250755306195e-02,
-5.141885427789076590e-02,
-5.144515846172154072e-02,
-5.147137503018384130e-02,
-5.149750395456013929e-02,
-5.152354520627812351e-02,
-5.154949875691038075e-02,
-5.157536457817366721e-02,
-5.160114264193025463e-02,
-5.162683292018689640e-02,
-5.165243538509541044e-02,
-5.167795000895247098e-02,
-5.170337676419962253e-02,
-5.172871562342344631e-02,
-5.175396655935523421e-02,
-5.177912954487179364e-02,
-5.180420455299449695e-02,
-5.182919155688995444e-02,
-5.185409052986987566e-02,
-5.187890144539064607e-02,
-5.190362427705445814e-02,
-5.192825899860790267e-02,
-5.195280558394303749e-02,
-5.197726400709729022e-02,
-5.200163424225284076e-02,
-5.202591626373745393e-02,
-5.205011004602379254e-02,
-5.207421556372979210e-02,
-5.209823279161891751e-02,
-5.212216170459945536e-02,
-5.214600227772564489e-02,
-5.216975448619608213e-02,
-5.219341830535585008e-02,
-5.221699371069404849e-02,
-5.224048067784645144e-02,
-5.226387918259332160e-02,
-5.228718920086058292e-02,
-5.231041070871946669e-02,
-5.233354368238693488e-02,
-5.235658809822502091e-02,
-5.237954393274142639e-02,
-5.240241116258907705e-02,
-5.242518976456694846e-02,
-5.244787971561878231e-02,
-5.247048099283423139e-02,
-5.249299357344867217e-02,
-5.251541743484264280e-02,
-5.253775255454232879e-02,
-5.255999891021945203e-02,
-5.258215647969152057e-02,
-5.260422524092157881e-02,
-5.262620517201824916e-02,
-5.264809625123566261e-02,
-5.266989845697339634e-02,
-5.269161176777750755e-02,
-5.271323616233866000e-02,
-5.273477161949405995e-02,
-5.275621811822599205e-02,
-5.277757563766289489e-02,
-5.279884415707830625e-02,
-5.282002365589222315e-02,
-5.284111411366988753e-02,
-5.286211551012239690e-02,
-5.288302782510671124e-02,
-5.290385103862511873e-02,
-5.292458513082640148e-02,
-5.294523008200456571e-02,
-5.296578587259943155e-02,
-5.298625248319684816e-02,
-5.300662989452850637e-02,
-5.302691808747142521e-02,
-5.304711704304896497e-02,
-5.306722674243033455e-02,
-5.308724716693006412e-02,
-5.310717829800912920e-02,
-5.312702011727376411e-02,
-5.314677260647683588e-02,
-5.316643574751628298e-02,
-5.318600952243637825e-02,
-5.320549391342702800e-02,
-5.322488890282442431e-02,
-5.324419447311003195e-02,
-5.326341060691183737e-02,
-5.328253728700365482e-02,
-5.330157449630455041e-02,
-5.332052221788026458e-02,
-5.333938043494217823e-02,
-5.335814913084754169e-02,
-5.337682828909957877e-02,
-5.339541789334731337e-02,
-5.341391792738629102e-02,
-5.343232837515689282e-02,
-5.345064922074686808e-02,
-5.346888044838855186e-02,
-5.348702204246116171e-02,
-5.350507398748939603e-02,
-5.352303626814422510e-02,
-5.354090886924227355e-02,
-5.355869177574625745e-02,
-5.357638497276503986e-02,
-5.359398844555313818e-02,
-5.361150217951132779e-02,
-5.362892616018596903e-02,
-5.364626037326986757e-02,
-5.366350480460130301e-02,
-5.368065944016502111e-02,
-5.369772426609149829e-02,
-5.371469926865703182e-02,
-5.373158443428418390e-02,
-5.374837974954135844e-02,
-5.376508520114281486e-02,
-5.378170077594879306e-02,
-5.379822646096575622e-02,
-5.381466224334615495e-02,
-5.383100811038789985e-02,
-5.384726404953523587e-02,
-5.386343004837852028e-02,
-5.387950609465366747e-02,
-5.389549217624295396e-02,
-5.391138828117423426e-02,
-5.392719439762175271e-02,
-5.394291051390533859e-02,
-5.395853661849056571e-02,
-5.397407269998957119e-02,
-5.398951874716005628e-02,
-5.400487474890577899e-02,
-5.402014069427622800e-02,
-5.403531657246700426e-02,
-5.405040237281949489e-02,
-5.406539808482133808e-02,
-5.408030369810574306e-02,
-5.409511920245165667e-02,
-5.410984458778427680e-02,
-5.412447984417487201e-02,
-5.413902496184024027e-02,
-5.415347993114280611e-02,
-5.416784474259141169e-02,
-5.418211938684076856e-02,
-5.419630385469097200e-02,
-5.421039813708843080e-02,
-5.422440222512480562e-02,
-5.423831611003853553e-02,
-5.425213978321286740e-02,
-5.426587323617777792e-02,
-5.427951646060846097e-02,
-5.429306944832578558e-02,
-5.430653219129717713e-02,
-5.431990468163518104e-02,
-5.433318691159811503e-02,
-5.434637887359090175e-02,
-5.435948056016284835e-02,
-5.437249196401022083e-02,
-5.438541307797444685e-02,
-5.439824389504282348e-02,
-5.441098440834830213e-02,
-5.442363461116951628e-02,
-5.443619449693076762e-02,
-5.444866405920245622e-02,
-5.446104329169992875e-02,
-5.447333218828495638e-02,
-5.448553074296422910e-02,
-5.449763894989067409e-02,
-5.450965680336247038e-02,
-5.452158429782361093e-02,
-5.453342142786365976e-02,
-5.454516818821739110e-02,
-5.455682457376569150e-02,
-5.456839057953492833e-02,
-5.457986620069670697e-02,
-5.459125143256816914e-02,
-5.460254627061235377e-02,
-5.461375071043775287e-02,
-5.462486474779753437e-02,
-5.463588837859158220e-02,
-5.464682159886424806e-02,
-5.465766440480556571e-02,
-5.466841679275165344e-02,
-5.467907875918303490e-02,
-5.468965030072631128e-02,
-5.470013141415298180e-02,
-5.471052209638041508e-02,
-5.472082234447084997e-02,
-5.473103215563222823e-02,
-5.474115152721766714e-02,
-5.475118045672529993e-02,
-5.476111894179902517e-02,
-5.477096698022750065e-02,
-5.478072456994509398e-02,
-5.479039170903092504e-02,
-5.479996839570953904e-02,
-5.480945462835089960e-02,
-5.481885040546986138e-02,
-5.482815572572622559e-02,
-5.483737058792535757e-02,
-5.484649499101736103e-02,
-5.485552893409754993e-02,
-5.486447241640626804e-02,
-5.487332543732917345e-02,
-5.488208799639671814e-02,
-5.489076009328419659e-02,
-5.489934172781195387e-02,
-5.490783289994545513e-02,
-5.491623360979519530e-02,
-5.492454385761618568e-02,
-5.493276364380858534e-02,
-5.494089296891740276e-02,
-5.494893183363260686e-02,
-5.495688023878873146e-02,
-5.496473818536520839e-02,
-5.497250567448648539e-02,
-5.498018270742133229e-02,
-5.498776928558331972e-02,
-5.499526541053127021e-02,
-5.500267108396807852e-02,
-5.500998630774147496e-02,
-5.501721108384418496e-02,
-5.502434541441269394e-02,
-5.503138930172903065e-02,
-5.503834274821899769e-02,
-5.504520575645367036e-02,
-5.505197832914796724e-02,
-5.505866046916163548e-02,
-5.506525217949863327e-02,
-5.507175346330804577e-02,
-5.507816432388205896e-02,
-5.508448476465862415e-02,
-5.509071478921921672e-02,
-5.509685440128984230e-02,
-5.510290360474059956e-02,
-5.510886240358646437e-02,
-5.511473080198602686e-02,
-5.512050880424210209e-02,
-5.512619641480229205e-02,
-5.513179363825754936e-02,
-5.513730047934371770e-02,
-5.514271694293981091e-02,
-5.514804303407002534e-02,
-5.515327875790162343e-02,
-5.515842411974668236e-02,
-5.516347912506072704e-02,
-5.516844377944302158e-02,
-5.517331808863722153e-02,
-5.517810205853106165e-02,
-5.518279569515537053e-02,
-5.518739900468546539e-02,
-5.519191199344022913e-02,
-5.519633466788225612e-02,
-5.520066703461774110e-02,
-5.520490910039671517e-02,
-5.520906087211331636e-02,
-5.521312235680449904e-02,
-5.521709356165142857e-02,
-5.522097449397841279e-02,
-5.522476516125372076e-02,
-5.522846557108889581e-02,
-5.523207573123881109e-02,
-5.523559564960205115e-02,
-5.523902533422039157e-02,
-5.524236479327909038e-02,
-5.524561403510665908e-02,
-5.524877306817506384e-02,
-5.525184190109933002e-02,
-5.525482054263783360e-02,
-5.525770900169224564e-02,
-5.526050728730677597e-02,
-5.526321540866970666e-02,
-5.526583337511185856e-02,
-5.526836119610700065e-02,
-5.527079888127230112e-02,
-5.527314644036730729e-02,
-5.527540388329546528e-02,
-5.527757122010194119e-02,
-5.527964846097576518e-02,
-5.528163561624824252e-02,
-5.528353269639377926e-02,
-5.528533971202916758e-02,
-5.528705667391416168e-02,
-5.528868359295112389e-02,
-5.529022048018530922e-02,
-5.529166734680414363e-02,
-5.529302420413775149e-02,
-5.529429106365908037e-02,
-5.529546793698288110e-02,
-5.529655483586719961e-02,
-5.529755177221183648e-02,
-5.529845875805919353e-02,
-5.529927580559394762e-02,
-5.530000292714327276e-02,
-5.530064013517622945e-02,
-5.530118744230398675e-02,
-5.530164486128054391e-02,
-5.530201240500133564e-02,
-5.530229008650416889e-02,
-5.530247791896880649e-02,
-5.530257591571702963e-02,
-5.530258409021258231e-02,
-5.530250245606108117e-02,
-5.530233102701000852e-02,
-5.530206981694869156e-02,
-5.530171883990837173e-02,
-5.530127811006128880e-02,
-5.530074764172253354e-02,
-5.530012744934813956e-02,
-5.529941754753572858e-02,
-5.529861795102467698e-02,
-5.529772867469579661e-02,
-5.529674973357116136e-02,
-5.529568114281466912e-02,
-5.529452291773161166e-02,
-5.529327507376784190e-02,
-5.529193762651176541e-02,
-5.529051059169162730e-02,
-5.528899398517810038e-02,
-5.528738782298205784e-02,
-5.528569212125614141e-02,
-5.528390689629376215e-02,
-5.528203216452933638e-02,
-5.528006794253812611e-02,
-5.527801424703665534e-02,
-5.527587109488186351e-02,
-5.527363850307218801e-02,
-5.527131648874601677e-02,
-5.526890506918299972e-02,
-5.526640426180318144e-02,
-5.526381408416751462e-02,
-5.526113455397737434e-02,
-5.525836568907454421e-02,
-5.525550750744149392e-02,
-5.525256002720090737e-02,
-5.524952326661616148e-02,
-5.524639724409074332e-02,
-5.524318197816828480e-02,
-5.523987748753284022e-02,
-5.523648379100877526e-02,
-5.523300090756042002e-02,
-5.522942885629199966e-02,
-5.522576765644797436e-02,
-5.522201732741311569e-02,
-5.521817788871117433e-02,
-5.521424936000678824e-02,
-5.521023176110372715e-02,
-5.520612511194582933e-02,
-5.520192943261694601e-02,
-5.519764474333970633e-02,
-5.519327106447724507e-02,
-5.518880841653167613e-02,
-5.518425682014486272e-02,
-5.517961629609826474e-02,
-5.517488686531241832e-02,
-5.517006854884726197e-02,
-5.516516136790232394e-02,
-5.516016534381595893e-02,
-5.515508049806586849e-02,
-5.514990685226892758e-02,
-5.514464442818112905e-02,
-5.513929324769732687e-02,
-5.513385333285130557e-02,
-5.512832470581589123e-02,
-5.512270738890268779e-02,
-5.511700140456229913e-02,
-5.511120677538349638e-02,
-5.510532352409449469e-02,
-5.509935167356150298e-02,
-5.509329124678961215e-02,
-5.508714226692224686e-02,
-5.508090475724145701e-02,
-5.507457874116754304e-02,
-5.506816424225917384e-02,
-5.506166128421333822e-02,
-5.505506989086544206e-02,
-5.504839008618843399e-02,
-5.504162189429391561e-02,
-5.503476533943137822e-02,
-5.502782044598833466e-02,
-5.502078723849030545e-02,
-5.501366574159998607e-02,
-5.500645598011906501e-02,
-5.499915797898610736e-02,
-5.499177176327760957e-02,
-5.498429735820748593e-02,
-5.497673478912783879e-02,
-5.496908408152742509e-02,
-5.496134526103308576e-02,
-5.495351835340879509e-02,
-5.494560338455589665e-02,
-5.493760038051297145e-02,
-5.492950936745544244e-02,
-5.492133037169696919e-02,
-5.491306341968697075e-02,
-5.490470853801241585e-02,
-5.489626575339767028e-02,
-5.488773509270317152e-02,
-5.487911658292656675e-02,
-5.487041025120267812e-02,
-5.486161612480203870e-02,
-5.485273423113290470e-02,
-5.484376459773941670e-02,
-5.483470725230225884e-02,
-5.482556222263863799e-02,
-5.481632953670234620e-02,
-5.480700922258333052e-02,
-5.479760130850780397e-02,
-5.478810582283771824e-02,
-5.477852279407217223e-02,
-5.476885225084524023e-02,
-5.475909422192750536e-02,
-5.474924873622560167e-02,
-5.473931582278158958e-02,
-5.472929551077369836e-02,
-5.471918782951577104e-02,
-5.470899280845687579e-02,
-5.469871047718260354e-02,
-5.468834086541290995e-02,
-5.467788400300443302e-02,
-5.466733991994793262e-02,
-5.465670864637049708e-02,
-5.464599021253393335e-02,
-5.463518464883557191e-02,
-5.462429198580739942e-02,
-5.461331225411674567e-02,
-5.460224548456587418e-02,
-5.459109170809218342e-02,
-5.457985095576758927e-02,
-5.456852325879858745e-02,
-5.455710864852681558e-02,
-5.454560715642873397e-02,
-5.453401881411422403e-02,
-5.452234365332925270e-02,
-5.451058170595279861e-02,
-5.449873300399914189e-02,
-5.448679757961612247e-02,
-5.447477546508670138e-02,
-5.446266669282680967e-02,
-5.445047129538724273e-02,
-5.443818930545262641e-02,
-5.442582075584168066e-02,
-5.441336567950644937e-02,
-5.440082410953298031e-02,
-5.438819607914144316e-02,
-5.437548162168512333e-02,
-5.436268077065103954e-02,
-5.434979355965954828e-02,
-5.433682002246489201e-02,
-5.432376019295415831e-02,
-5.431061410514771010e-02,
-5.429738179319960195e-02,
-5.428406329139648379e-02,
-5.427065863415806574e-02,
-5.425716785603756226e-02,
-5.424359099172031129e-02,
-5.422992807602523141e-02,
-5.421617914390330917e-02,
-5.420234423043867461e-02,
-5.418842337084787270e-02,
-5.417441660048001595e-02,
-5.416032395481659018e-02,
-5.414614546947127405e-02,
-5.413188118019053585e-02,
-5.411753112285270367e-02,
-5.410309533346812499e-02,
-5.408857384817974956e-02,
-5.407396670326179711e-02,
-5.405927393512099249e-02,
-5.404449558029553180e-02,
-5.402963167545540152e-02,
-5.401468225740247570e-02,
-5.399964736307011348e-02,
-5.398452702952306892e-02,
-5.396932129395738686e-02,
-5.395403019370119402e-02,
-5.393865376621307522e-02,
-5.392319204908341268e-02,
-5.390764508003321326e-02,
-5.389201289691491342e-02,
-5.387629553771188656e-02,
-5.386049304053805442e-02,
-5.384460544363854628e-02,
-5.382863278538885937e-02,
-5.381257510429560825e-02,
-5.379643243899537991e-02,
-5.378020482825559417e-02,
-5.376389231097425392e-02,
-5.374749492617945240e-02,
-5.373101271302931775e-02,
-5.371444571081231828e-02,
-5.369779395894733881e-02,
-5.368105749698270229e-02,
-5.366423636459685675e-02,
-5.364733060159842387e-02,
-5.363034024792538018e-02,
-5.361326534364509178e-02,
-5.359610592895530656e-02,
-5.357886204418283588e-02,
-5.356153372978350591e-02,
-5.354412102634324017e-02,
-5.352662397457678273e-02,
-5.350904261532807987e-02,
-5.349137698957029396e-02,
-5.347362713840525528e-02,
-5.345579310306445425e-02,
-5.343787492490714719e-02,
-5.341987264542204933e-02,
-5.340178630622659933e-02,
-5.338361594906622376e-02,
-5.336536161581552362e-02,
-5.334702334847707395e-02,
-5.332860118918188869e-02,
-5.331009518018906684e-02,
-5.329150536388631287e-02,
-5.327283178278863912e-02,
-5.325407447953966339e-02,
-5.323523349691080403e-02,
-5.321630887780110647e-02,
-5.319730066523713219e-02,
-5.317820890237343057e-02,
-5.315903363249228908e-02,
-5.313977489900274798e-02,
-5.312043274544170357e-02,
-5.310100721547341557e-02,
-5.308149835288884094e-02,
-5.306190620160649435e-02,
-5.304223080567164322e-02,
-5.302247220925668941e-02,
-5.300263045666066958e-02,
-5.298270559230951193e-02,
-5.296269766075564767e-02,
-5.294260670667800400e-02,
-5.292243277488230258e-02,
-5.290217591030057370e-02,
-5.288183615799062209e-02,
-5.286141356313742851e-02,
-5.284090817105101950e-02,
-5.282032002716831320e-02,
-5.279964917705173844e-02,
-5.277889566638965108e-02,
-5.275805954099586220e-02,
-5.273714084681046382e-02,
-5.271613962989869784e-02,
-5.269505593645110869e-02,
-5.267388981278416094e-02,
-5.265264130533928860e-02,
-5.263131046068295071e-02,
-5.260989732550713088e-02,
-5.258840194662839362e-02,
-5.256682437098859906e-02,
-5.254516464565441025e-02,
-5.252342281781682831e-02,
-5.250159893479179607e-02,
-5.247969304402005930e-02,
-5.245770519306612589e-02,
-5.243563542961952872e-02,
-5.241348380149386810e-02,
-5.239125035662676316e-02,
-5.236893514307980335e-02,
-5.234653820903917287e-02,
-5.232405960281399926e-02,
-5.230149937283817135e-02,
-5.227885756766863928e-02,
-5.225613423598633039e-02,
-5.223332942659504596e-02,
-5.221044318842323062e-02,
-5.218747557052123148e-02,
-5.216442662206346309e-02,
-5.214129639234738739e-02,
-5.211808493079309046e-02,
-5.209479228694371966e-02,
-5.207141851046582365e-02,
-5.204796365114817969e-02,
-5.202442775890215448e-02,
-5.200081088376164173e-02,
-5.197711307588345764e-02,
-5.195333438554600863e-02,
-5.192947486315046407e-02,
-5.190553455922032600e-02,
-5.188151352440065894e-02,
-5.185741180945865891e-02,
-5.183322946528332031e-02,
-5.180896654288580372e-02,
-5.178462309339833258e-02,
-5.176019916807477611e-02,
-5.173569481829101702e-02,
-5.171111009554370253e-02,
-5.168644505145065376e-02,
-5.166169973775174701e-02,
-5.163687420630696384e-02,
-5.161196850909759853e-02,
-5.158698269822589028e-02,
-5.156191682591469011e-02,
-5.153677094450739848e-02,
-5.151154510646838158e-02,
-5.148623936438218723e-02,
-5.146085377095366981e-02,
-5.143538837900780980e-02,
-5.140984324149024121e-02,
-5.138421841146611352e-02,
-5.135851394212082033e-02,
-5.133272988675955523e-02,
-5.130686629880719385e-02,
-5.128092323180832163e-02,
-5.125490073942671337e-02,
-5.122879887544637412e-02,
-5.120261769376974886e-02,
-5.117635724841899242e-02,
-5.115001759353528243e-02,
-5.112359878337889574e-02,
-5.109710087232912507e-02,
-5.107052391488352966e-02,
-5.104386796565885814e-02,
-5.101713307939049341e-02,
-5.099031931093213343e-02,
-5.096342671525588841e-02,
-5.093645534745214892e-02,
-5.090940526272945410e-02,
-5.088227651641475530e-02,
-5.085506916395264587e-02,
-5.082778326090536813e-02,
-5.080041886295361131e-02,
-5.077297602589495029e-02,
-5.074545480564538608e-02,
-5.071785525823718777e-02,
-5.069017743982138363e-02,
-5.066242140666507576e-02,
-5.063458721515289029e-02,
-5.060667492178658883e-02,
-5.057868458318476312e-02,
-5.055061625608287673e-02,
-5.052246999733270988e-02,
-5.049424586390335867e-02,
-5.046594391287965997e-02,
-5.043756420146313507e-02,
-5.040910678697153868e-02,
-5.038057172683929608e-02,
-5.035195907861589326e-02,
-5.032326889996739661e-02,
-5.029450124867561323e-02,
-5.026565618263816732e-02,
-5.023673375986768830e-02,
-5.020773403849337208e-02,
-5.017865707675904507e-02,
-5.014950293302376100e-02,
-5.012027166576218246e-02,
-5.009096333356388708e-02,
-5.006157799513324264e-02,
-5.003211570928955271e-02,
-5.000257653496718857e-02,
-4.997296053121461773e-02,
-4.994326775719488964e-02,
-4.991349827218583696e-02,
-4.988365213557943711e-02,
-4.985372940688181237e-02,
-4.982373014571278569e-02,
-4.979365441180666485e-02,
-4.976350226501160406e-02,
-4.973327376528883376e-02,
-4.970296897271405528e-02,
-4.967258794747619194e-02,
-4.964213074987725710e-02,
-4.961159744033254160e-02,
-4.958098807937124514e-02,
-4.955030272763486648e-02,
-4.951954144587784185e-02,
-4.948870429496821099e-02,
-4.945779133588579929e-02,
-4.942680262972364014e-02,
-4.939573823768714234e-02,
-4.936459822109375006e-02,
-4.933338264137401147e-02,
-4.930209156006937904e-02,
-4.927072503883459659e-02,
-4.923928313943540247e-02,
-4.920776592374977859e-02,
-4.917617345376771448e-02,
-4.914450579158972932e-02,
-4.911276299942907153e-02,
-4.908094513960924860e-02,
-4.904905227456601152e-02,
-4.901708446684525933e-02,
-4.898504177910432966e-02,
-4.895292427411185310e-02,
-4.892073201474651106e-02,
-4.888846506399786157e-02,
-4.885612348496620044e-02,
-4.882370734086233927e-02,
-4.879121669500707803e-02,
-4.875865161083126759e-02,
-4.872601215187646190e-02,
-4.869329838179344005e-02,
-4.866051036434319854e-02,
-4.862764816339666674e-02,
-4.859471184293365220e-02,
-4.856170146704442969e-02,
-4.852861709992765948e-02,
-4.849545880589207353e-02,
-4.846222664935489338e-02,
-4.842892069484248940e-02,
-4.839554100699063055e-02,
-4.836208765054333947e-02,
-4.832856069035330188e-02,
-4.829496019138175555e-02,
-4.826128621869879565e-02,
-4.822753883748219506e-02,
-4.819371811301829261e-02,
-4.815982411070116737e-02,
-4.812585689603342265e-02,
-4.809181653462476363e-02,
-4.805770309219305897e-02,
-4.802351663456351505e-02,
-4.798925722766905072e-02,
-4.795492493754930502e-02,
-4.792051983035213597e-02,
-4.788604197233166382e-02,
-4.785149142984934656e-02,
-4.781686826937339707e-02,
-4.778217255747870679e-02,
-4.774740436084679018e-02,
-4.771256374626559743e-02,
-4.767765078062972950e-02,
-4.764266553093991774e-02,
-4.760760806430250347e-02,
-4.757247844793089514e-02,
-4.753727674914304258e-02,
-4.750200303536376845e-02,
-4.746665737412310987e-02,
-4.743123983305612412e-02,
-4.739575047990435275e-02,
-4.736018938251339294e-02,
-4.732455660883490289e-02,
-4.728885222692526952e-02,
-4.725307630494529620e-02,
-4.721722891116131998e-02,
-4.718131011394385843e-02,
-4.714531998176819949e-02,
-4.710925858321348553e-02,
-4.707312598696387212e-02,
-4.703692226180720970e-02,
-4.700064747663534187e-02,
-4.696430170044438301e-02,
-4.692788500233369131e-02,
-4.689139745150668059e-02,
-4.685483911727037626e-02,
-4.681821006903460342e-02,
-4.678151037631286119e-02,
-4.674474010872212842e-02,
-4.670789933598161470e-02,
-4.667098812791406481e-02,
-4.663400655444462778e-02,
-4.659695468560150905e-02,
-4.655983259151481174e-02,
-4.652264034241772317e-02,
-4.648537800864493280e-02,
-4.644804566063386042e-02,
-4.641064336892375408e-02,
-4.637317120415566929e-02,
-4.633562923707264247e-02,
-4.629801753851890689e-02,
-4.626033617944062815e-02,
-4.622258523088487031e-02,
-4.618476476400065062e-02,
-4.614687485003732270e-02,
-4.610891556034582561e-02,
-4.607088696637742786e-02,
-4.603278913968466418e-02,
-4.599462215192025305e-02,
-4.595638607483766569e-02,
-4.591808098029043911e-02,
-4.587970694023280060e-02,
-4.584126402671832856e-02,
-4.580275231190104879e-02,
-4.576417186803504594e-02,
-4.572552276747340189e-02,
-4.568680508266937529e-02,
-4.564801888617529141e-02,
-4.560916425064313884e-02,
-4.557024124882355642e-02,
-4.553124995356693655e-02,
-4.549219043782194716e-02,
-4.545306277463626726e-02,
-4.541386703715658002e-02,
-4.537460329862714331e-02,
-4.533527163239162161e-02,
-4.529587211189170515e-02,
-4.525640481066684623e-02,
-4.521686980235454373e-02,
-4.517726716069052351e-02,
-4.513759695950831513e-02,
-4.509785927273834982e-02,
-4.505805417440916089e-02,
-4.501818173864657185e-02,
-4.497824203967329404e-02,
-4.493823515180932204e-02,
-4.489816114947153131e-02,
-4.485802010717382382e-02,
-4.481781209952666323e-02,
-4.477753720123667930e-02,
-4.473719548710741734e-02,
-4.469678703203868592e-02,
-4.465631191102600872e-02,
-4.461577019916127679e-02,
-4.457516197163238075e-02,
-4.453448730372257247e-02,
-4.449374627081064543e-02,
-4.445293894837153148e-02,
-4.441206541197514901e-02,
-4.437112573728611842e-02,
-4.433012000006515685e-02,
-4.428904827616693407e-02,
-4.424791064154156434e-02,
-4.420670717223341983e-02,
-4.416543794438193560e-02,
-4.412410303422045071e-02,
-4.408270251807654139e-02,
-4.404123647237260381e-02,
-4.399970497362418881e-02,
-4.395810809844111211e-02,
-4.391644592352708654e-02,
-4.387471852567893793e-02,
-4.383292598178728516e-02,
-4.379106836883616544e-02,
-4.374914576390260407e-02,
-4.370715824415646877e-02,
-4.366510588686082356e-02,
-4.362298876937170666e-02,
-4.358080696913724239e-02,
-4.353856056369848765e-02,
-4.349624963068848132e-02,
-4.345387424783325736e-02,
-4.341143449294981166e-02,
-4.336893044394809354e-02,
-4.332636217882931268e-02,
-4.328372977568654967e-02,
-4.324103331270432587e-02,
-4.319827286815852013e-02,
-4.315544852041654222e-02,
-4.311256034793665287e-02,
-4.306960842926829680e-02,
-4.302659284305154763e-02,
-4.298351366801760748e-02,
-4.294037098298741223e-02,
-4.289716486687341485e-02,
-4.285389539867751757e-02,
-4.281056265749228623e-02,
-4.276716672249983309e-02,
-4.272370767297278132e-02,
-4.268018558827271075e-02,
-4.263660054785159415e-02,
-4.259295263125026376e-02,
-4.254924191809923012e-02,
-4.250546848811795342e-02,
-4.246163242111517661e-02,
-4.241773379698809271e-02,
-4.237377269572313587e-02,
-4.232974919739527359e-02,
-4.228566338216790954e-02,
-4.224151533029243955e-02,
-4.219730512210891765e-02,
-4.215303283804540391e-02,
-4.210869855861764516e-02,
-4.206430236442932485e-02,
-4.201984433617166753e-02,
-4.197532455462361228e-02,
-4.193074310065116744e-02,
-4.188610005520737589e-02,
-4.184139549933321017e-02,
-4.179662951415569205e-02,
-4.175180218088898193e-02,
-4.170691358083398331e-02,
-4.166196379537766975e-02,
-4.161695290599370239e-02,
-4.157188099424215244e-02,
-4.152674814176883500e-02,
-4.148155443030563522e-02,
-4.143629994167001562e-02,
-4.139098475776553654e-02,
-4.134560896058088464e-02,
-4.130017263219008111e-02,
-4.125467585475277310e-02,
-4.120911871051326225e-02,
-4.116350128180082391e-02,
-4.111782365102958914e-02,
-4.107208590069885007e-02,
-4.102628811339145004e-02,
-4.098043037177499098e-02,
-4.093451275860199301e-02,
-4.088853535670790296e-02,
-4.084249824901249604e-02,
-4.079640151851982727e-02,
-4.075024524831706574e-02,
-4.070402952157488319e-02,
-4.065775442154742625e-02,
-4.061142003157232339e-02,
-4.056502643506971345e-02,
-4.051857371554296733e-02,
-4.047206195657848671e-02,
-4.042549124184454529e-02,
-4.037886165509257941e-02,
-4.033217328015601538e-02,
-4.028542620095066501e-02,
-4.023862050147429537e-02,
-4.019175626580645533e-02,
-4.014483357810872538e-02,
-4.009785252262405147e-02,
-4.005081318367683524e-02,
-4.000371564567282295e-02,
-3.995655999309929290e-02,
-3.990934631052375087e-02,
-3.986207468259526238e-02,
-3.981474519404366169e-02,
-3.976735792967879546e-02,
-3.971991297439115415e-02,
-3.967241041315205247e-02,
-3.962485033101220688e-02,
-3.957723281310280422e-02,
-3.952955794463442613e-02,
-3.948182581089793031e-02,
-3.943403649726341664e-02,
-3.938619008918012310e-02,
-3.933828667217710573e-02,
-3.929032633186230888e-02,
-3.924230915392238478e-02,
-3.919423522412301963e-02,
-3.914610462830854509e-02,
-3.909791745240194516e-02,
-3.904967378240416231e-02,
-3.900137370439490242e-02,
-3.895301730453155920e-02,
-3.890460466904955422e-02,
-3.885613588426225368e-02,
-3.880761103656032301e-02,
-3.875903021241211555e-02,
-3.871039349836311733e-02,
-3.866170098103641900e-02,
-3.861295274713173742e-02,
-3.856414888342569319e-02,
-3.851528947677218540e-02,
-3.846637461410095521e-02,
-3.841740438241834921e-02,
-3.836837886880743731e-02,
-3.831929816042684012e-02,
-3.827016234451173504e-02,
-3.822097150837251711e-02,
-3.817172573939579122e-02,
-3.812242512504361580e-02,
-3.807306975285287137e-02,
-3.802365971043657894e-02,
-3.797419508548235262e-02,
-3.792467596575249678e-02,
-3.787510243908433910e-02,
-3.782547459339020285e-02,
-3.777579251665625498e-02,
-3.772605629694341517e-02,
-3.767626602238664801e-02,
-3.762642178119512265e-02,
-3.757652366165144947e-02,
-3.752657175211220747e-02,
-3.747656614100787487e-02,
-3.742650691684188541e-02,
-3.737639416819086430e-02,
-3.732622798370508616e-02,
-3.727600845210759378e-02,
-3.722573566219378877e-02,
-3.717540970283250701e-02,
-3.712503066296456850e-02,
-3.707459863160313118e-02,
-3.702411369783369793e-02,
-3.697357595081401938e-02,
-3.692298547977351103e-02,
-3.687234237401327414e-02,
-3.682164672290627605e-02,
-3.677089861589676045e-02,
-3.672009814250015020e-02,
-3.666924539230310975e-02,
-3.661834045496351053e-02,
-3.656738342020994514e-02,
-3.651637437784119311e-02,
-3.646531341772715762e-02,
-3.641420062980811612e-02,
-3.636303610409402642e-02,
-3.631181993066551900e-02,
-3.626055219967286997e-02,
-3.620923300133598033e-02,
-3.615786242594439676e-02,
-3.610644056385759609e-02,
-3.605496750550370166e-02,
-3.600344334138025348e-02,
-3.595186816205390296e-02,
-3.590024205815988551e-02,
-3.584856512040238835e-02,
-3.579683743955356517e-02,
-3.574505910645488227e-02,
-3.569323021201537688e-02,
-3.564135084721198332e-02,
-3.558942110309010892e-02,
-3.553744107076247521e-02,
-3.548541084140941632e-02,
-3.543333050627927444e-02,
-3.538120015668696355e-02,
-3.532901988401469795e-02,
-3.527678977971193675e-02,
-3.522450993529491897e-02,
-3.517218044234631663e-02,
-3.511980139251545674e-02,
-3.506737287751797438e-02,
-3.501489498913577803e-02,
-3.496236781921686909e-02,
-3.490979145967466196e-02,
-3.485716600248919134e-02,
-3.480449153970532894e-02,
-3.475176816343330394e-02,
-3.469899596584949397e-02,
-3.464617503919444758e-02,
-3.459330547577387643e-02,
-3.454038736795862069e-02,
-3.448742080818389261e-02,
-3.443440588894962351e-02,
-3.438134270281945765e-02,
-3.432823134242207752e-02,
-3.427507190044962876e-02,
-3.422186446965800460e-02,
-3.416860914286725531e-02,
-3.411530601296080406e-02,
-3.406195517288525959e-02,
-3.400855671565031213e-02,
-3.395511073432931626e-02,
-3.390161732205826395e-02,
-3.384807657203560416e-02,
-3.379448857752277713e-02,
-3.374085343184367314e-02,
-3.368717122838369576e-02,
-3.363344206059157293e-02,
-3.357966602197722666e-02,
-3.352584320611257107e-02,
-3.347197370663089477e-02,
-3.341805761722763807e-02,
-3.336409503165903984e-02,
-3.331008604374239429e-02,
-3.325603074735668241e-02,
-3.320192923644105926e-02,
-3.314778160499579074e-02,
-3.309358794708121276e-02,
-3.303934835681884147e-02,
-3.298506292838979115e-02,
-3.293073175603512814e-02,
-3.287635493405639819e-02,
-3.282193255681456479e-02,
-3.276746471873018263e-02,
-3.271295151428317560e-02,
-3.265839303801292004e-02,
-3.260378938451742592e-02,
-3.254914064845468996e-02,
-3.249444692454035027e-02,
-3.243970830754940027e-02,
-3.238492489231491189e-02,
-3.233009677372865320e-02,
-3.227522404674018630e-02,
-3.222030680635718652e-02,
-3.216534514764517183e-02,
-3.211033916572745422e-02,
-3.205528895578491771e-02,
-3.200019461305517871e-02,
-3.194505623283402235e-02,
-3.188987391047352210e-02,
-3.183464774138287240e-02,
-3.177937782102797926e-02,
-3.172406424493137006e-02,
-3.166870710867169397e-02,
-3.161330650788432561e-02,
-3.155786253826025484e-02,
-3.150237529554669735e-02,
-3.144684487554608165e-02,
-3.139127137411726332e-02,
-3.133565488717402620e-02,
-3.127999551068513795e-02,
-3.122429334067532147e-02,
-3.116854847322352018e-02,
-3.111276100446369944e-02,
-3.105693103058425678e-02,
-3.100105864782849024e-02,
-3.094514395249378658e-02,
-3.088918704093155179e-02,
-3.083318800954714181e-02,
-3.077714695480009838e-02,
-3.072106397320309087e-02,
-3.066493916132280451e-02,
-3.060877261577903824e-02,
-3.055256443324459031e-02,
-3.049631471044535538e-02,
-3.044002354416048758e-02,
-3.038369103122134235e-02,
-3.032731726851167764e-02,
-3.027090235296842763e-02,
-3.021444638157981880e-02,
-3.015794945138672994e-02,
-3.010141165948118300e-02,
-3.004483310300805690e-02,
-2.998821387916277004e-02,
-2.993155408519271657e-02,
-2.987485381839583357e-02,
-2.981811317612238083e-02,
-2.976133225577189817e-02,
-2.970451115479609203e-02,
-2.964764997069638600e-02,
-2.959074880102501373e-02,
-2.953380774338417586e-02,
-2.947682689542663673e-02,
-2.941980635485442336e-02,
-2.936274621941985588e-02,
-2.930564658692479119e-02,
-2.924850755522033496e-02,
-2.919132922220688334e-02,
-2.913411168583394592e-02,
-2.907685504410026378e-02,
-2.901955939505310167e-02,
-2.896222483678813006e-02,
-2.890485146745005660e-02,
-2.884743938523162340e-02,
-2.878998868837335384e-02,
-2.873249947516423250e-02,
-2.867497184394086907e-02,
-2.861740589308731098e-02,
-2.855980172103539036e-02,
-2.850215942626417587e-02,
-2.844447910729988940e-02,
-2.838676086271543775e-02,
-2.832900479113123829e-02,
-2.827121099121358838e-02,
-2.821337956167583455e-02,
-2.815551060127729349e-02,
-2.809760420882383147e-02,
-2.803966048316691370e-02,
-2.798167952320389229e-02,
-2.792366142787823871e-02,
-2.786560629617858276e-02,
-2.780751422713871948e-02,
-2.774938531983806370e-02,
-2.769121967340070975e-02,
-2.763301738699584786e-02,
-2.757477855983684820e-02,
-2.751650329118246127e-02,
-2.745819168033520816e-02,
-2.739984382664168577e-02,
-2.734145982949298323e-02,
-2.728303978832385263e-02,
-2.722458380261262578e-02,
-2.716609197188109628e-02,
-2.710756439569492540e-02,
-2.704900117366239309e-02,
-2.699040240543510924e-02,
-2.693176819070773609e-02,
-2.687309862921729089e-02,
-2.681439382074338879e-02,
-2.675565386510812479e-02,
-2.669687886217619183e-02,
-2.663806891185335757e-02,
-2.657922411408798063e-02,
-2.652034456887040342e-02,
-2.646143037623177943e-02,
-2.640248163624494757e-02,
-2.634349844902424478e-02,
-2.628448091472486425e-02,
-2.622542913354269922e-02,
-2.616634320571444364e-02,
-2.610722323151778990e-02,
-2.604806931127021455e-02,
-2.598888154532970687e-02,
-2.592966003409446357e-02,
-2.587040487800232325e-02,
-2.581111617753086701e-02,
-2.575179403319724503e-02,
-2.569243854555839160e-02,
-2.563304981521020640e-02,
-2.557362794278690912e-02,
-2.551417302896310038e-02,
-2.545468517445109019e-02,
-2.539516448000166474e-02,
-2.533561104640494333e-02,
-2.527602497448836957e-02,
-2.521640636511779041e-02,
-2.515675531919692870e-02,
-2.509707193766737288e-02,
-2.503735632150815363e-02,
-2.497760857173558433e-02,
-2.491782878940358714e-02,
-2.485801707560287427e-02,
-2.479817353146093403e-02,
-2.473829825814229458e-02,
-2.467839135684805549e-02,
-2.461845292881547839e-02,
-2.455848307531826452e-02,
-2.449848189766604817e-02,
-2.443844949720442791e-02,
-2.437838597531458151e-02,
-2.431829143341385571e-02,
-2.425816597295439581e-02,
-2.419800969542362790e-02,
-2.413782270234415134e-02,
-2.407760509527377343e-02,
-2.401735697580469411e-02,
-2.395707844556342614e-02,
-2.389676960621172491e-02,
-2.383643055944491274e-02,
-2.377606140699237494e-02,
-2.371566225061751132e-02,
-2.365523319211790959e-02,
-2.359477433332410681e-02,
-2.353428577610001959e-02,
-2.347376762234371431e-02,
-2.341321997398514848e-02,
-2.335264293298753083e-02,
-2.329203660134737675e-02,
-2.323140108109328708e-02,
-2.317073647428612507e-02,
-2.311004288301913082e-02,
-2.304932040941803234e-02,
-2.298856915563980002e-02,
-2.292778922387336132e-02,
-2.286698071633946547e-02,
-2.280614373528992364e-02,
-2.274527838300800797e-02,
-2.268438476180755642e-02,
-2.262346297403411768e-02,
-2.256251312206335180e-02,
-2.250153530830145687e-02,
-2.244052963518553684e-02,
-2.237949620518258145e-02,
-2.231843512078911587e-02,
-2.225734648453248435e-02,
-2.219623039896925429e-02,
-2.213508696668558401e-02,
-2.207391629029688274e-02,
-2.201271847244818183e-02,
-2.195149361581328826e-02,
-2.189024182309450006e-02,
-2.182896319702378948e-02,
-2.176765784036085657e-02,
-2.170632585589394106e-02,
-2.164496734643948581e-02,
-2.158358241484237966e-02,
-2.152217116397480909e-02,
-2.146073369673680981e-02,
-2.139927011605629106e-02,
-2.133778052488839380e-02,
-2.127626502621478288e-02,
-2.121472372304518059e-02,
-2.115315671841558332e-02,
-2.109156411538871609e-02,
-2.102994601705375152e-02,
-2.096830252652683371e-02,
-2.090663374694952045e-02,
-2.084493978148954652e-02,
-2.078322073334104222e-02,
-2.072147670572319425e-02,
-2.065970780188100195e-02,
-2.059791412508449326e-02,
-2.053609577862954005e-02,
-2.047425286583638010e-02,
-2.041238549005013753e-02,
-2.035049375464119750e-02,
-2.028857776300379417e-02,
-2.022663761855675660e-02,
-2.016467342474313057e-02,
-2.010268528502983515e-02,
-2.004067330290755858e-02,
-1.997863758189099767e-02,
-1.991657822551807025e-02,
-1.985449533734999147e-02,
-1.979238902097112812e-02,
-1.973025937998910267e-02,
-1.966810651803411678e-02,
-1.960593053875909694e-02,
-1.954373154583903538e-02,
-1.948150964297223897e-02,
-1.941926493387824415e-02,
-1.935699752229863568e-02,
-1.929470751199749770e-02,
-1.923239500675985592e-02,
-1.917006011039245478e-02,
-1.910770292672329951e-02,
-1.904532355960157283e-02,
-1.898292211289729498e-02,
-1.892049869050159774e-02,
-1.885805339632592309e-02,
-1.879558633430226250e-02,
-1.873309760838282739e-02,
-1.867058732254023301e-02,
-1.860805558076674554e-02,
-1.854550248707449722e-02,
-1.848292814549510471e-02,
-1.842033266008016520e-02,
-1.835771613489980622e-02,
-1.829507867404362928e-02,
-1.823242038162045664e-02,
-1.816974136175735291e-02,
-1.810704171860033282e-02,
-1.804432155631345222e-02,
-1.798158097907985933e-02,
-1.791882009109950838e-02,
-1.785603899659166799e-02,
-1.779323779979246484e-02,
-1.773041660495580304e-02,
-1.766757551635288886e-02,
-1.760471463827283090e-02,
-1.754183407502103720e-02,
-1.747893393092003061e-02,
-1.741601431030951816e-02,
-1.735307531754527038e-02,
-1.729011705699954465e-02,
-1.722713963306089432e-02,
-1.716414315013422426e-02,
-1.710112771263999284e-02,
-1.703809342501439589e-02,
-1.697504039170918619e-02,
-1.691196871719195804e-02,
-1.684887850594492253e-02,
-1.678576986246566385e-02,
-1.672264289126654604e-02,
-1.665949769687468524e-02,
-1.659633438383168250e-02,
-1.653315305669377649e-02,
-1.646995382003116695e-02,
-1.640673677842798689e-02,
-1.634350203648270161e-02,
-1.628024969880701237e-02,
-1.621697987002639410e-02,
-1.615369265477939464e-02,
-1.609038815771841185e-02,
-1.602706648350815319e-02,
-1.596372773682659674e-02,
-1.590037202236413427e-02,
-1.583699944482412983e-02,
-1.577361010892184764e-02,
-1.571020411938495870e-02,
-1.564678158095297172e-02,
-1.558334259837749342e-02,
-1.551988727642148770e-02,
-1.545641571985987249e-02,
-1.539292803347857598e-02,
-1.532942432207448982e-02,
-1.526590469045625668e-02,
-1.520236924344264481e-02,
-1.513881808586339459e-02,
-1.507525132255839277e-02,
-1.501166905837857980e-02,
-1.494807139818439892e-02,
-1.488445844684625936e-02,
-1.482083030924507584e-02,
-1.475718709027074894e-02,
-1.469352889482287462e-02,
-1.462985582781017868e-02,
-1.456616799415125750e-02,
-1.450246549877261780e-02,
-1.443874844661010258e-02,
-1.437501694260854765e-02,
-1.431127109172072691e-02,
-1.424751099890771838e-02,
-1.418373676913921647e-02,
-1.411994850739249109e-02,
-1.405614631865258202e-02,
-1.399233030791221730e-02,
-1.392850058017185318e-02,
-1.386465724043894551e-02,
-1.380080039372780752e-02,
-1.373693014506054653e-02,
-1.367304659946530845e-02,
-1.360914986197704277e-02,
-1.354524003763706366e-02,
-1.348131723149343514e-02,
-1.341738154860000823e-02,
-1.335343309401598386e-02,
-1.328947197280742724e-02,
-1.322549829004533023e-02,
-1.316151215080605882e-02,
-1.309751366017191006e-02,
-1.303350292322954899e-02,
-1.296948004507087783e-02,
-1.290544513079237669e-02,
-1.284139828549563968e-02,
-1.277733961428614146e-02,
-1.271326922227353218e-02,
-1.264918721457230361e-02,
-1.258509369630010644e-02,
-1.252098877257860204e-02,
-1.245687254853295074e-02,
-1.239274512929206679e-02,
-1.232860661998778744e-02,
-1.226445712575503430e-02,
-1.220029675173165892e-02,
-1.213612560305843933e-02,
-1.207194378487831329e-02,
-1.200775140233727167e-02,
-1.194354856058302793e-02,
-1.187933536476549513e-02,
-1.181511192003625865e-02,
-1.175087833154930643e-02,
-1.168663470445957357e-02,
-1.162238114392332745e-02,
-1.155811775509874538e-02,
-1.149384464314446436e-02,
-1.142956191322008937e-02,
-1.136526967048594704e-02,
-1.130096802010333544e-02,
-1.123665706723343469e-02,
-1.117233691703769377e-02,
-1.110800767467824343e-02,
-1.104366944531606949e-02,
-1.097932233411241451e-02,
-1.091496644622841523e-02,
-1.085060188682410165e-02,
-1.078622876105876996e-02,
-1.072184717409078655e-02,
-1.065745723107765219e-02,
-1.059305903717531507e-02,
-1.052865269753811527e-02,
-1.046423831731932604e-02,
-1.039981600166994466e-02,
-1.033538585573907584e-02,
-1.027094798467360556e-02,
-1.020650249361865214e-02,
-1.014204948771635188e-02,
-1.007758907210609851e-02,
-1.001312135192514163e-02,
-9.948646432307372417e-03,
-9.884164418383004427e-03,
-9.819675415280018638e-03,
-9.755179528122222277e-03,
-9.690676862029965269e-03,
-9.626167522119572981e-03,
-9.561651613504040109e-03,
-9.497129241291559637e-03,
-9.432600510586112638e-03,
-9.368065526487751038e-03,
-9.303524394091213304e-03,
-9.238977218486800480e-03,
-9.174424104759512297e-03,
-9.109865157989838202e-03,
-9.045300483252371321e-03,
-8.980730185616229988e-03,
-8.916154370145463678e-03,
-8.851573141897941047e-03,
-8.786986605925008187e-03,
-8.722394867272940597e-03,
-8.657798030980965592e-03,
-8.593196202082035995e-03,
-8.528589485602325326e-03,
-8.463977986561680572e-03,
-8.399361809972463386e-03,
-8.334741060839808563e-03,
-8.270115844162231195e-03,
-8.205486264930100110e-03,
-8.140852428126387277e-03,
-8.076214438726031161e-03,
-8.011572401696554283e-03,
-7.946926421996854117e-03,
-7.882276604577373100e-03,
-7.817623054380778633e-03,
-7.752965876340470359e-03,
-7.688305175381190786e-03,
-7.623641056418816245e-03,
-7.558973624359974393e-03,
-7.494302984102019921e-03,
-7.429629240532659856e-03,
-7.364952498530531223e-03,
-7.300272862963867043e-03,
-7.235590438690981188e-03,
-7.170905330560518182e-03,
-7.106217643410368996e-03,
-7.041527482068092592e-03,
-6.976834951350374681e-03,
-6.912140156063751109e-03,
-6.847443201003160229e-03,
-6.782744190952462449e-03,
-6.718043230684689164e-03,
-6.653340424960960293e-03,
-6.588635878530867650e-03,
-6.523929696132237284e-03,
-6.459221982490927390e-03,
-6.394512842320677383e-03,
-6.329802380322737537e-03,
-6.265090701186483944e-03,
-6.200377909588035072e-03,
-6.135664110190835498e-03,
-6.070949407645822443e-03,
-6.006233906590314683e-03,
-5.941517711648513882e-03,
-5.876800927430974632e-03,
-5.812083658535240234e-03,
-5.747366009544461855e-03,
-5.682648085027852160e-03,
-5.617929989541111183e-03,
-5.553211827625044623e-03,
-5.488493703806264674e-03,
-5.423775722596536029e-03,
-5.359057988493633705e-03,
-5.294340605979071419e-03,
-5.229623679520573575e-03,
-5.164907313569860881e-03,
-5.100191612563402359e-03,
-5.035476680921878445e-03,
-4.970762623050782071e-03,
-4.906049543339124561e-03,
-4.841337546160012426e-03,
-4.776626735870106999e-03,
-4.711917216810194292e-03,
-4.647209093303956810e-03,
-4.582502469658318763e-03,
-4.517797450163835507e-03,
-4.453094139093430673e-03,
-4.388392640702985098e-03,
-4.323693059230827689e-03,
-4.258995498898197722e-03,
-4.194300063908109472e-03,
-4.129606858445835325e-03,
-4.064915986678615221e-03,
-4.000227552755449348e-03,
-3.935541660806759871e-03,
-3.870858414944976841e-03,
-3.806177919263283548e-03,
-3.741500277836154725e-03,
-3.676825594718827889e-03,
-3.612153973947908325e-03,
-3.547485519540059806e-03,
-3.482820335492442607e-03,
-3.418158525783027060e-03,
-3.353500194369441259e-03,
-3.288845445189410820e-03,
-3.224194382160329962e-03,
-3.159547109179780631e-03,
-3.094903730124285227e-03,
-3.030264348849872127e-03,
-2.965629069191749994e-03,
-2.900997994964102638e-03,
-2.836371229959779375e-03,
-2.771748877950856640e-03,
-2.707131042687352558e-03,
-2.642517827897668432e-03,
-2.577909337288904895e-03,
-2.513305674545664083e-03,
-2.448706943330570922e-03,
-2.384113247283773957e-03,
-2.319524690023501770e-03,
-2.254941375144818745e-03,
-2.190363406220162401e-03,
-2.125790886798864174e-03,
-2.061223920407661593e-03,
-1.996662610549474002e-03,
-1.932107060703808481e-03,
-1.867557374327264656e-03,
-1.803013654851618906e-03,
-1.738476005685240990e-03,
-1.673944530212795453e-03,
-1.609419331794152003e-03,
-1.544900513764770186e-03,
-1.480388179436079726e-03,
-1.415882432094240414e-03,
-1.351383375000685290e-03,
-1.286891111391623866e-03,
-1.222405744478584442e-03,
-1.157927377447177031e-03,
-1.093456113457471311e-03,
-1.028992055644374582e-03,
-9.645353071163892660e-04,
-9.000859709561837398e-04,
-8.356441502200490437e-04,
-7.712099479384793618e-04,
-7.067834671150989871e-04,
-6.423648107263261109e-04,
-5.779540817228281469e-04,
-5.135513830275609520e-04,
-4.491568175363427483e-04,
-3.847704881182048629e-04,
-3.203924976141806196e-04,
-2.560229488378440790e-04,
-1.916619445748020357e-04,
-1.273095875832455247e-04,
-6.296598059271490153e-05,
 1.368773695521595375e-06,
 6.569457260809090534e-05,
 1.300113135007512370e-04,
 1.943188937578347144e-04,
 2.586172107927647477e-04,
 3.229061620475014768e-04,
 3.871856449937751462e-04,
 4.514555571325273072e-04,
 5.157157959942533986e-04,
 5.799662591391615283e-04,
 6.442068441575081418e-04,
 7.084374486690463808e-04,
 7.726579703242520986e-04,
 8.368683068037781813e-04,
 9.010683558189585933e-04,
 9.652580151112673604e-04,
 1.029437182453525395e-03,
 1.093605755649563419e-03,
 1.157763632533802484e-03,
 1.221910710972511430e-03,
 1.286046888863245268e-03,
 1.350172064135354323e-03,
 1.414286134749435193e-03,
 1.478388998698559800e-03,
 1.542480554007905026e-03,
 1.606560698734183076e-03,
 1.670629330967581330e-03,
 1.734686348830340738e-03,
 1.798731650477076961e-03,
 1.862765134095820336e-03,
 1.926786697907475077e-03,
 1.990796240166327769e-03,
 2.054793659159503093e-03,
 2.118778853208168160e-03,
 2.182751720667175811e-03,
 2.246712159924674299e-03,
 2.310660069403361501e-03,
 2.374595347559899008e-03,
 2.438517892885416500e-03,
 2.502427603905002605e-03,
 2.566324379178898385e-03,
 2.630208117302123942e-03,
 2.694078716903934578e-03,
 2.757936076649729427e-03,
 2.821780095239658902e-03,
 2.885610671408890982e-03,
 2.949427703928724463e-03,
 3.013231091605993953e-03,
 3.077020733283603732e-03,
 3.140796527839926234e-03,
 3.204558374190111334e-03,
 3.268306171285630547e-03,
 3.332039818113934418e-03,
 3.395759213699660328e-03,
 3.459464257104122049e-03,
 3.523154847425741254e-03,
 3.586830883799560065e-03,
 3.650492265398468366e-03,
 3.714138891432767955e-03,
 3.777770661149817358e-03,
 3.841387473835119505e-03,
 3.904989228812598846e-03,
 3.968575825443213141e-03,
 4.032147163126806148e-03,
 4.095703141301461001e-03,
 4.159243659443955139e-03,
 4.222768617069220382e-03,
 4.286277913731576308e-03,
 4.349771449024329543e-03,
 4.413249122579430278e-03,
 4.476710834068640607e-03,
 4.540156483203047072e-03,
 4.603585969733505617e-03,
 4.666999193450111633e-03,
 4.730396054183446351e-03,
 4.793776451804156180e-03,
 4.857140286222572795e-03,
 4.920487457389996835e-03,
 4.983817865298086416e-03,
 5.047131409979173713e-03,
 5.110427991506480069e-03,
 5.173707509994202730e-03,
 5.236969865597899086e-03,
 5.300214958513922020e-03,
 5.363442688980601253e-03,
 5.426652957277920686e-03,
 5.489845663727074311e-03,
 5.553020708691745570e-03,
 5.616177992577526222e-03,
 5.679317415832409004e-03,
 5.742438878946252469e-03,
 5.805542282452011774e-03,
 5.868627526925284180e-03,
 5.931694512984070529e-03,
 5.994743141289830823e-03,
 6.057773312547066157e-03,
 6.120784927503513870e-03,
 6.183777886950452864e-03,
 6.246752091722726150e-03,
 6.309707442699136366e-03,
 6.372643840801868985e-03,
 6.435561186997746513e-03,
 6.498459382297738438e-03,
 6.561338327756758258e-03,
 6.624197924474703458e-03,
 6.687038073595977586e-03,
 6.749858676310065315e-03,
 6.812659633850832487e-03,
 6.875440847497810669e-03,
 6.938202218575891846e-03,
 7.000943648454801063e-03,
 7.063665038550390532e-03,
 7.126366290324140026e-03,
 7.189047305283537657e-03,
 7.251707984981398993e-03,
 7.314348231017867193e-03,
 7.376967945038812730e-03,
 7.439567028736311302e-03,
 7.502145383849630894e-03,
 7.564702912164714826e-03,
 7.627239515514104562e-03,
 7.689755095777849568e-03,
 7.752249554883071901e-03,
 7.814722794804518716e-03,
 7.877174717563956846e-03,
 7.939605225231356755e-03,
 8.002014219924510896e-03,
 8.064401603808783042e-03,
 8.126767279098060653e-03,
 8.189111148054534564e-03,
 8.251433112988855109e-03,
 8.313733076259863242e-03,
 8.376010940275445751e-03,
 8.438266607492894353e-03,
 8.500499980417547397e-03,
 8.562710961604604390e-03,
 8.624899453658598641e-03,
 8.687065359233045111e-03,
 8.749208581031654719e-03,
 8.811329021807742801e-03,
 8.873426584364688813e-03,
 8.935501171555493977e-03,
 8.997552686283884563e-03,
 9.059581031503999640e-03,
 9.121586110219957397e-03,
 9.183567825487114547e-03,
 9.245526080411436629e-03,
 9.307460778150101685e-03,
 9.369371821910820256e-03,
 9.431259114953131212e-03,
 9.493122560587858791e-03,
 9.554962062177313822e-03,
 9.616777523135574754e-03,
 9.678568846928770411e-03,
 9.740335937074462436e-03,
 9.802078697142956737e-03,
 9.863797030756590520e-03,
 9.925490841590445257e-03,
 9.987160033371588613e-03,
 1.004880450988042059e-02,
 1.011042417495016353e-02,
 1.017201893246654984e-02,
 1.023358868636916295e-02,
 1.029513334065049190e-02,
 1.035665279935695307e-02,
 1.041814696658786323e-02,
 1.047961574649685680e-02,
 1.054105904329158579e-02,
 1.060247676123296165e-02,
 1.066386880463718496e-02,
 1.072523507787426569e-02,
 1.078657548536839268e-02,
 1.084788993159889817e-02,
 1.090917832109993511e-02,
 1.097044055845996895e-02,
 1.103167654832316012e-02,
 1.109288619538873269e-02,
 1.115406940441131776e-02,
 1.121522608020067251e-02,
 1.127635612762267758e-02,
 1.133745945159883931e-02,
 1.139853595710678923e-02,
 1.145958554917973250e-02,
 1.152060813290761536e-02,
 1.158160361343671743e-02,
 1.164257189596945921e-02,
 1.170351288576509767e-02,
 1.176442648814032821e-02,
 1.182531260846774596e-02,
 1.188617115217767244e-02,
 1.194700202475779474e-02,
 1.200780513175249940e-02,
 1.206858037876435558e-02,
 1.212932767145331533e-02,
 1.219004691553746654e-02,
 1.225073801679215160e-02,
 1.231140088105141597e-02,
 1.237203541420745651e-02,
 1.243264152221085043e-02,
 1.249321911107026915e-02,
 1.255376808685365955e-02,
 1.261428835568756401e-02,
 1.267477982375720541e-02,
 1.273524239730721222e-02,
 1.279567598264138434e-02,
 1.285608048612283533e-02,
 1.291645581417423354e-02,
 1.297680187327810743e-02,
 1.303711856997626442e-02,
 1.309740581087086818e-02,
 1.315766350262413328e-02,
 1.321789155195855769e-02,
 1.327808986565658968e-02,
 1.333825835056158884e-02,
 1.339839691357762319e-02,
 1.345850546166904062e-02,
 1.351858390186164681e-02,
 1.357863214124213277e-02,
 1.363865008695849985e-02,
 1.369863764621963992e-02,
 1.375859472629644385e-02,
 1.381852123452130716e-02,
 1.387841707828829305e-02,
 1.393828216505343248e-02,
 1.399811640233501568e-02,
 1.405791969771289646e-02,
 1.411769195882979500e-02,
 1.417743309339090062e-02,
 1.423714300916388044e-02,
 1.429682161397890366e-02,
 1.435646881572930252e-02,
 1.441608452237164856e-02,
 1.447566864192501718e-02,
 1.453522108247232332e-02,
 1.459474175215975424e-02,
 1.465423055919728990e-02,
 1.471368741185797961e-02,
 1.477311221847935757e-02,
 1.483250488746279232e-02,
 1.489186532727362899e-02,
 1.495119344644165772e-02,
 1.501048915356105115e-02,
 1.506975235729022568e-02,
 1.512898296635256483e-02,
 1.518818088953624405e-02,
 1.524734603569456205e-02,
 1.530647831374526077e-02,
 1.536557763267192532e-02,
 1.542464390152348784e-02,
 1.548367702941385975e-02,
 1.554267692552309919e-02,
 1.560164349909679352e-02,
 1.566057665944674618e-02,
 1.571947631595015105e-02,
 1.577834237805098364e-02,
 1.583717475525943039e-02,
 1.589597335715183662e-02,
 1.595473809337118881e-02,
 1.601346887362788129e-02,
 1.607216560769811689e-02,
 1.613082820542568324e-02,
 1.618945657672152955e-02,
 1.624805063156369370e-02,
 1.630661027999748269e-02,
 1.636513543213596183e-02,
 1.642362599816000329e-02,
 1.648208188831769630e-02,
 1.654050301292562739e-02,
 1.659888928236821423e-02,
 1.665724060709834753e-02,
 1.671555689763668320e-02,
 1.677383806457279775e-02,
 1.683208401856492453e-02,
 1.689029467033959647e-02,
 1.694846993069271113e-02,
 1.700660971048877437e-02,
 1.706471392066165327e-02,
 1.712278247221449973e-02,
 1.718081527621979562e-02,
 1.723881224381957483e-02,
 1.729677328622537813e-02,
 1.735469831471887076e-02,
 1.741258724065141220e-02,
 1.747043997544433722e-02,
 1.752825643058949362e-02,
 1.758603651764882592e-02,
 1.764378014825504146e-02,
 1.770148723411074654e-02,
 1.775915768699002154e-02,
 1.781679141873760905e-02,
 1.787438834126882370e-02,
 1.793194836657062419e-02,
 1.798947140670089859e-02,
 1.804695737378920334e-02,
 1.810440618003624283e-02,
 1.816181773771462921e-02,
 1.821919195916886502e-02,
 1.827652875681473610e-02,
 1.833382804314074438e-02,
 1.839108973070740713e-02,
 1.844831373214711120e-02,
 1.850549996016511226e-02,
 1.856264832753910798e-02,
 1.861975874711960244e-02,
 1.867683113182946192e-02,
 1.873386539466499745e-02,
 1.879086144869537844e-02,
 1.884781920706292066e-02,
 1.890473858298330825e-02,
 1.896161948974575337e-02,
 1.901846184071319737e-02,
 1.907526554932162735e-02,
 1.913203052908175883e-02,
 1.918875669357802613e-02,
 1.924544395646841585e-02,
 1.930209223148566730e-02,
 1.935870143243695676e-02,
 1.941527147320348465e-02,
 1.947180226774128040e-02,
 1.952829373008137942e-02,
 1.958474577432950045e-02,
 1.964115831466596226e-02,
 1.969753126534676615e-02,
 1.975386454070311368e-02,
 1.981015805514102501e-02,
 1.986641172314269899e-02,
 1.992262545926549305e-02,
 1.997879917814304740e-02,
 2.003493279448409839e-02,
 2.009102622307387329e-02,
 2.014707937877409719e-02,
 2.020309217652196607e-02,
 2.025906453133157273e-02,
 2.031499635829348005e-02,
 2.037088757257453711e-02,
 2.042673808941869451e-02,
 2.048254782414686212e-02,
 2.053831669215672867e-02,
 2.059404460892302544e-02,
 2.064973148999798766e-02,
 2.070537725101138926e-02,
 2.076098180766997731e-02,
 2.081654507575843999e-02,
 2.087206697113944479e-02,
 2.092754740975324643e-02,
 2.098298630761810321e-02,
 2.103838358083039844e-02,
 2.109373914556500126e-02,
 2.114905291807493704e-02,
 2.120432481469178634e-02,
 2.125955475182600418e-02,
 2.131474264596618096e-02,
 2.136988841368029843e-02,
 2.142499197161525787e-02,
 2.148005323649706741e-02,
 2.153507212513070326e-02,
 2.159004855440067872e-02,
 2.164498244127135290e-02,
 2.169987370278587610e-02,
 2.175472225606790017e-02,
 2.180952801832057239e-02,
 2.186429090682726409e-02,
 2.191901083895080385e-02,
 2.197368773213496593e-02,
 2.202832150390363411e-02,
 2.208291207186054150e-02,
 2.213745935369113710e-02,
 2.219196326716087533e-02,
 2.224642373011581978e-02,
 2.230084066048340641e-02,
 2.235521397627197523e-02,
 2.240954359557122827e-02,
 2.246382943655168135e-02,
 2.251807141746572580e-02,
 2.257226945664729534e-02,
 2.262642347251155039e-02,
 2.268053338355583912e-02,
 2.273459910835921166e-02,
 2.278862056558310020e-02,
 2.284259767397031279e-02,
 2.289653035234661543e-02,
 2.295041851962010410e-02,
 2.300426209478064615e-02,
 2.305806099690147978e-02,
 2.311181514513866928e-02,
 2.316552445873028623e-02,
 2.321918885699807145e-02,
 2.327280825934665079e-02,
 2.332638258526398278e-02,
 2.337991175432082430e-02,
 2.343339568617197263e-02,
 2.348683430055568608e-02,
 2.354022751729339599e-02,
 2.359357525629088292e-02,
 2.364687743753763130e-02,
 2.370013398110721800e-02,
 2.375334480715705562e-02,
 2.380650983592918005e-02,
 2.385962898774990001e-02,
 2.391270218302966530e-02,
 2.396572934226406243e-02,
 2.401871038603314856e-02,
 2.407164523500179149e-02,
 2.412453380991977023e-02,
 2.417737603162213242e-02,
 2.423017182102873632e-02,
 2.428292109914501756e-02,
 2.433562378706176019e-02,
 2.438827980595561010e-02,
 2.444088907708792668e-02,
 2.449345152180675347e-02,
 2.454596706154555524e-02,
 2.459843561782401947e-02,
 2.465085711224765386e-02,
 2.470323146650820617e-02,
 2.475555860238407707e-02,
 2.480783844173963665e-02,
 2.486007090652623402e-02,
 2.491225591878147919e-02,
 2.496439340063012075e-02,
 2.501648327428358104e-02,
 2.506852546204049043e-02,
 2.512051988628619462e-02,
 2.517246646949351796e-02,
 2.522436513422279120e-02,
 2.527621580312165717e-02,
 2.532801839892502571e-02,
 2.537977284445587164e-02,
 2.543147906262482882e-02,
 2.548313697643064812e-02,
 2.553474650895951395e-02,
 2.558630758338611977e-02,
 2.563782012297365770e-02,
 2.568928405107293728e-02,
 2.574069929112395017e-02,
 2.579206576665484321e-02,
 2.584338340128253600e-02,
 2.589465211871266187e-02,
 2.594587184274011610e-02,
 2.599704249724808097e-02,
 2.604816400620954542e-02,
 2.609923629368640988e-02,
 2.615025928382997897e-02,
 2.620123290088078108e-02,
 2.625215706916932470e-02,
 2.630303171311541149e-02,
 2.635385675722871218e-02,
 2.640463212610890190e-02,
 2.645535774444541383e-02,
 2.650603353701826495e-02,
 2.655665942869674459e-02,
 2.660723534444155505e-02,
 2.665776120930292079e-02,
 2.670823694842231616e-02,
 2.675866248703104300e-02,
 2.680903775045221163e-02,
 2.685936266409863493e-02,
 2.690963715347486143e-02,
 2.695986114417627325e-02,
 2.701003456188947119e-02,
 2.706015733239209783e-02,
 2.711022938155348283e-02,
 2.716025063533441392e-02,
 2.721022101978688018e-02,
 2.726014046105520658e-02,
 2.731000888537501656e-02,
 2.735982621907419657e-02,
 2.740959238857220218e-02,
 2.745930732038124114e-02,
 2.750897094110518748e-02,
 2.755858317744065353e-02,
 2.760814395617632380e-02,
 2.765765320419369400e-02,
 2.770711084846686281e-02,
 2.775651681606263604e-02,
 2.780587103414065148e-02,
 2.785517342995381951e-02,
 2.790442393084746620e-02,
 2.795362246426062736e-02,
 2.800276895772571203e-02,
 2.805186333886787106e-02,
 2.810090553540634667e-02,
 2.814989547515357043e-02,
 2.819883308601616942e-02,
 2.824771829599385595e-02,
 2.829655103318080497e-02,
 2.834533122576504346e-02,
 2.839405880202827345e-02,
 2.844273369034719390e-02,
 2.849135581919207127e-02,
 2.853992511712797470e-02,
 2.858844151281448795e-02,
 2.863690493500548745e-02,
 2.868531531255010328e-02,
 2.873367257439157080e-02,
 2.878197664956852128e-02,
 2.883022746721462456e-02,
 2.887842495655824210e-02,
 2.892656904692334635e-02,
 2.897465966772911489e-02,
 2.902269674849022874e-02,
 2.907068021881652198e-02,
 2.911861000841382482e-02,
 2.916648604708366524e-02,
 2.921430826472300873e-02,
 2.926207659132511879e-02,
 2.930979095697915440e-02,
 2.935745129187036437e-02,
 2.940505752628004218e-02,
 2.945260959058615055e-02,
 2.950010741526296748e-02,
 2.954755093088088161e-02,
 2.959494006810742608e-02,
 2.964227475770641468e-02,
 2.968955493053865649e-02,
 2.973678051756176513e-02,
 2.978395144983049872e-02,
 2.983106765849674949e-02,
 2.987812907480911356e-02,
 2.992513563011404629e-02,
 2.997208725585529671e-02,
 3.001898388357359879e-02,
 3.006582544490793776e-02,
 3.011261187159435318e-02,
 3.015934309546741687e-02,
 3.020601904845861274e-02,
 3.025263966259785289e-02,
 3.029920487001376908e-02,
 3.034571460293175940e-02,
 3.039216879367665283e-02,
 3.043856737467112716e-02,
 3.048491027843603859e-02,
 3.053119743759135155e-02,
 3.057742878485526089e-02,
 3.062360425304504891e-02,
 3.066972377507631506e-02,
 3.071578728396373928e-02,
 3.076179471282143238e-02,
 3.080774599486198542e-02,
 3.085364106339748974e-02,
 3.089947985183929061e-02,
 3.094526229369831682e-02,
 3.099098832258440767e-02,
 3.103665787220753411e-02,
 3.108227087637690372e-02,
 3.112782726900189395e-02,
 3.117332698409138250e-02,
 3.121876995575450717e-02,
 3.126415611819992335e-02,
 3.130948540573679634e-02,
 3.135475775277440924e-02,
 3.139997309382257934e-02,
 3.144513136349094684e-02,
 3.149023249648997408e-02,
 3.153527642763105654e-02,
 3.158026309182550978e-02,
 3.162519242408606129e-02,
 3.167006435952588600e-02,
 3.171487883335926544e-02,
 3.175963578090131717e-02,
 3.180433513756870251e-02,
 3.184897683887896042e-02,
 3.189356082045059076e-02,
 3.193808701800440741e-02,
 3.198255536736212268e-02,
 3.202696580444675672e-02,
 3.207131826528335228e-02,
 3.211561268599881502e-02,
 3.215984900282177483e-02,
 3.220402715208228739e-02,
 3.224814707021324278e-02,
 3.229220869374910957e-02,
 3.233621195932650377e-02,
 3.238015680368463295e-02,
 3.242404316366487987e-02,
 3.246787097621123275e-02,
 3.251164017836971620e-02,
 3.255535070728968888e-02,
 3.259900250022278873e-02,
 3.264259549452338399e-02,
 3.268612962764892022e-02,
 3.272960483715996877e-02,
 3.277302106071983828e-02,
 3.281637823609502569e-02,
 3.285967630115527172e-02,
 3.290291519387399805e-02,
 3.294609485232741219e-02,
 3.298921521469563856e-02,
 3.303227621926228125e-02,
 3.307527780441442411e-02,
 3.311821990864301235e-02,
 3.316110247054295662e-02,
 3.320392542881293874e-02,
 3.324668872225566840e-02,
 3.328939228977766812e-02,
 3.333203607039020300e-02,
 3.337462000320820521e-02,
 3.341714402745118995e-02,
 3.345960808244304030e-02,
 3.350201210761241666e-02,
 3.354435604249194486e-02,
 3.358663982671948600e-02,
 3.362886340003746338e-02,
 3.367102670229293881e-02,
 3.371312967343804284e-02,
 3.375517225353014822e-02,
 3.379715438273103723e-02,
 3.383907600130822702e-02,
 3.388093704963424796e-02,
 3.392273746818726121e-02,
 3.396447719755021910e-02,
 3.400615617841196842e-02,
 3.404777435156712551e-02,
 3.408933165791527137e-02,
 3.413082803846225616e-02,
 3.417226343431958163e-02,
 3.421363778670474115e-02,
 3.425495103694086579e-02,
 3.429620312645744601e-02,
 3.433739399679038018e-02,
 3.437852358958077420e-02,
 3.441959184657687049e-02,
 3.446059870963313204e-02,
 3.450154412071029103e-02,
 3.454242802187548755e-02,
 3.458325035530281089e-02,
 3.462401106327305661e-02,
 3.466471008817310906e-02,
 3.470534737249748869e-02,
 3.474592285884720716e-02,
 3.478643648993028081e-02,
 3.482688820856180006e-02,
 3.486727795766409593e-02,
 3.490760568026685107e-02,
 3.494787131950659320e-02,
 3.498807481862772212e-02,
 3.502821612098168391e-02,
 3.506829517002767876e-02,
 3.510831190933250134e-02,
 3.514826628257057550e-02,
 3.518815823352396122e-02,
 3.522798770608292357e-02,
 3.526775464424503764e-02,
 3.530745899211663874e-02,
 3.534710069391127502e-02,
 3.538667969395122709e-02,
 3.542619593666693212e-02,
 3.546564936659675482e-02,
 3.550503992838759809e-02,
 3.554436756679496545e-02,
 3.558363222668284309e-02,
 3.562283385302319333e-02,
 3.566197239089771709e-02,
 3.570104778549576530e-02,
 3.574005998211619156e-02,
 3.577900892616650563e-02,
 3.581789456316312320e-02,
 3.585671683873138671e-02,
 3.589547569860598170e-02,
 3.593417108863036086e-02,
 3.597280295475781958e-02,
 3.601137124305038573e-02,
 3.604987589967970085e-02,
 3.608831687092702717e-02,
 3.612669410318265772e-02,
 3.616500754294701969e-02,
 3.620325713682984170e-02,
 3.624144283155083385e-02,
 3.627956457393927137e-02,
 3.631762231093448035e-02,
 3.635561598958575447e-02,
 3.639354555705210520e-02,
 3.643141096060308753e-02,
 3.646921214761834895e-02,
 3.650694906558710207e-02,
 3.654462166210971363e-02,
 3.658222988489655270e-02,
 3.661977368176833753e-02,
 3.665725300065623971e-02,
 3.669466778960253639e-02,
 3.673201799675936130e-02,
 3.676930357039021047e-02,
 3.680652445886887364e-02,
 3.684368061068030165e-02,
 3.688077197442054395e-02,
 3.691779849879598535e-02,
 3.695476013262454645e-02,
 3.699165682483517709e-02,
 3.702848852446798122e-02,
 3.706525518067427943e-02,
 3.710195674271675459e-02,
 3.713859315996962535e-02,
 3.717516438191800082e-02,
 3.721167035815951818e-02,
 3.724811103840217075e-02,
 3.728448637246636888e-02,
 3.732079631028429462e-02,
 3.735704080189966581e-02,
 3.739321979746790259e-02,
 3.742933324725643274e-02,
 3.746538110164512186e-02,
 3.750136331112498972e-02,
 3.753727982629992410e-02,
 3.757313059788566778e-02,
 3.760891557671035973e-02,
 3.764463471371400777e-02,
 3.768028795994943225e-02,
 3.771587526658191220e-02,
 3.775139658488872729e-02,
 3.778685186626005305e-02,
 3.782224106219898158e-02,
 3.785756412432041834e-02,
 3.789282100435279604e-02,
 3.792801165413693665e-02,
 3.796313602562685630e-02,
 3.799819407088898815e-02,
 3.803318574210339670e-02,
 3.806811099156269529e-02,
 3.810296977167260818e-02,
 3.813776203495237993e-02,
 3.817248773403419254e-02,
 3.820714682166398424e-02,
 3.824173925070004781e-02,
 3.827626497411521639e-02,
 3.831072394499514255e-02,
 3.834511611653915186e-02,
 3.837944144206033997e-02,
 3.841369987498523958e-02,
 3.844789136885402164e-02,
 3.848201587732093254e-02,
 3.851607335415382222e-02,
 3.855006375323475482e-02,
 3.858398702855914131e-02,
 3.861784313423687748e-02,
 3.865163202449200391e-02,
 3.868535365366219253e-02,
 3.871900797619973189e-02,
 3.875259494667109006e-02,
 3.878611451975695623e-02,
 3.881956665025220604e-02,
 3.885295129306654688e-02,
 3.888626840322361583e-02,
 3.891951793586221481e-02,
 3.895269984623520726e-02,
 3.898581408971042717e-02,
 3.901886062177004760e-02,
 3.905183939801148280e-02,
 3.908475037414656933e-02,
 3.911759350600205881e-02,
 3.915036874951986073e-02,
 3.918307606075657756e-02,
 3.921571539588410149e-02,
 3.924828671118912177e-02,
 3.928078996307370063e-02,
 3.931322510805503739e-02,
 3.934559210276566965e-02,
 3.937789090395314717e-02,
 3.941012146848074660e-02,
 3.944228375332699960e-02,
 3.947437771558567204e-02,
 3.950640331246654813e-02,
 3.953836050129470175e-02,
 3.957024923951069778e-02,
 3.960206948467088345e-02,
 3.963382119444764512e-02,
 3.966550432662874215e-02,
 3.969711883911788974e-02,
 3.972866468993483530e-02,
 3.976014183721524042e-02,
 3.979155023921041728e-02,
 3.982288985428834860e-02,
 3.985416064093236233e-02,
 3.988536255774281086e-02,
 3.991649556343535021e-02,
 3.994755961684268164e-02,
 3.997855467691326797e-02,
 4.000948070271190260e-02,
 4.004033765342011886e-02,
 4.007112548833603044e-02,
 4.010184416687374853e-02,
 4.013249364856391610e-02,
 4.016307389305453363e-02,
 4.019358486010961989e-02,
 4.022402650960966303e-02,
 4.025439880155255723e-02,
 4.028470169605281176e-02,
 4.031493515334153704e-02,
 4.034509913376676388e-02,
 4.037519359779363770e-02,
 4.040521850600443943e-02,
 4.043517381909795400e-02,
 4.046505949789062917e-02,
 4.049487550331572899e-02,
 4.052462179642362522e-02,
 4.055429833838242182e-02,
 4.058390509047671291e-02,
 4.061344201410897747e-02,
 4.064290907079907977e-02,
 4.067230622218399178e-02,
 4.070163343001853562e-02,
 4.073089065617448851e-02,
 4.076007786264156801e-02,
 4.078919501152725863e-02,
 4.081824206505596520e-02,
 4.084721898557066438e-02,
 4.087612573553148221e-02,
 4.090496227751674874e-02,
 4.093372857422188787e-02,
 4.096242458846110351e-02,
 4.099105028316581134e-02,
 4.101960562138576988e-02,
 4.104809056628857394e-02,
 4.107650508116002935e-02,
 4.110484912940359087e-02,
 4.113312267454132670e-02,
 4.116132568021341198e-02,
 4.118945811017789976e-02,
 4.121751992831149125e-02,
 4.124551109860874476e-02,
 4.127343158518309574e-02,
 4.130128135226606573e-02,
 4.132906036420743584e-02,
 4.135676858547574636e-02,
 4.138440598065821346e-02,
 4.141197251445986188e-02,
 4.143946815170489184e-02,
 4.146689285733648478e-02,
 4.149424659641535312e-02,
 4.152152933412206481e-02,
 4.154874103575521144e-02,
 4.157588166673271968e-02,
 4.160295119259079660e-02,
 4.162994957898474846e-02,
 4.165687679168924434e-02,
 4.168373279659701863e-02,
 4.171051755972068897e-02,
 4.173723104719111177e-02,
 4.176387322525881157e-02,
 4.179044406029305131e-02,
 4.181694351878247062e-02,
 4.184337156733487773e-02,
 4.186972817267697183e-02,
 4.189601330165514115e-02,
 4.192222692123483141e-02,
 4.194836899850087203e-02,
 4.197443950065736507e-02,
 4.200043839502826809e-02,
 4.202636564905619376e-02,
 4.205222123030398496e-02,
 4.207800510645344494e-02,
 4.210371724530655863e-02,
 4.212935761478400071e-02,
 4.215492618292692589e-02,
 4.218042291789587256e-02,
 4.220584778797071418e-02,
 4.223120076155160996e-02,
 4.225648180715804725e-02,
 4.228169089342957015e-02,
 4.230682798912532849e-02,
 4.233189306312473005e-02,
 4.235688608442691322e-02,
 4.238180702215042783e-02,
 4.240665584553467843e-02,
 4.243143252393841158e-02,
 4.245613702684096491e-02,
 4.248076932384108745e-02,
 4.250532938465809152e-02,
 4.252981717913126986e-02,
 4.255423267722031194e-02,
 4.257857584900459624e-02,
 4.260284666468450165e-02,
 4.262704509457988095e-02,
 4.265117110913134446e-02,
 4.267522467889990623e-02,
 4.269920577456648436e-02,
 4.272311436693288639e-02,
 4.274695042692087943e-02,
 4.277071392557330737e-02,
 4.279440483405283491e-02,
 4.281802312364284963e-02,
 4.284156876574772566e-02,
 4.286504173189194938e-02,
 4.288844199372041088e-02,
 4.291176952299937536e-02,
 4.293502429161517170e-02,
 4.295820627157499738e-02,
 4.298131543500662705e-02,
 4.300435175415914801e-02,
 4.302731520140155169e-02,
 4.305020574922435728e-02,
 4.307302337023868888e-02,
 4.309576803717644206e-02,
 4.311843972289054056e-02,
 4.314103840035463100e-02,
 4.316356404266382535e-02,
 4.318601662303341721e-02,
 4.320839611480033898e-02,
 4.323070249142237087e-02,
 4.325293572647821716e-02,
 4.327509579366783932e-02,
 4.329718266681227556e-02,
 4.331919631985362701e-02,
 4.334113672685532132e-02,
 4.336300386200154372e-02,
 4.338479769959851379e-02,
 4.340651821407276456e-02,
 4.342816537997257198e-02,
 4.344973917196782304e-02,
 4.347123956484875984e-02,
 4.349266653352808903e-02,
 4.351402005303903892e-02,
 4.353530009853669169e-02,
 4.355650664529703286e-02,
 4.357763966871831124e-02,
 4.359869914431948462e-02,
 4.361968504774129535e-02,
 4.364059735474615925e-02,
 4.366143604121744404e-02,
 4.368220108316066275e-02,
 4.370289245670275907e-02,
 4.372351013809213510e-02,
 4.374405410369883174e-02,
 4.376452433001483400e-02,
 4.378492079365330775e-02,
 4.380524347134923807e-02,
 4.382549233995963051e-02,
 4.384566737646303225e-02,
 4.386576855795947666e-02,
 4.388579586167146857e-02,
 4.390574926494226343e-02,
 4.392562874523776167e-02,
 4.394543428014544700e-02,
 4.396516584737489297e-02,
 4.398482342475687479e-02,
 4.400440699024446567e-02,
 4.402391652191318255e-02,
 4.404335199795945954e-02,
 4.406271339670245896e-02,
 4.408200069658291254e-02,
 4.410121387616348920e-02,
 4.412035291412935711e-02,
 4.413941778928728854e-02,
 4.415840848056604845e-02,
 4.417732496701667899e-02,
 4.419616722781209706e-02,
 4.421493524224776733e-02,
 4.423362898974068924e-02,
 4.425224844983031286e-02,
 4.427079360217807402e-02,
 4.428926442656784535e-02,
 4.430766090290524234e-02,
 4.432598301121865036e-02,
 4.434423073165827400e-02,
 4.436240404449614400e-02,
 4.438050293012759523e-02,
 4.439852736906944874e-02,
 4.441647734196097624e-02,
 4.443435282956366417e-02,
 4.445215381276155370e-02,
 4.446988027256074116e-02,
 4.448753219008983600e-02,
 4.450510954659954443e-02,
 4.452261232346333558e-02,
 4.454004050217674759e-02,
 4.455739406435781091e-02,
 4.457467299174671521e-02,
 4.459187726620679471e-02,
 4.460900686972280038e-02,
 4.462606178440271104e-02,
 4.464304199247658145e-02,
 4.465994747629730560e-02,
 4.467677821833955509e-02,
 4.469353420120147913e-02,
 4.471021540760275470e-02,
 4.472682182038610621e-02,
 4.474335342251692382e-02,
 4.475981019708262509e-02,
 4.477619212729356396e-02,
 4.479249919648286421e-02,
 4.480873138810563538e-02,
 4.482488868573979851e-02,
 4.484097107308594732e-02,
 4.485697853396750090e-02,
 4.487291105233014860e-02,
 4.488876861224208592e-02,
 4.490455119789465988e-02,
 4.492025879360145996e-02,
 4.493589138379894266e-02,
 4.495144895304598737e-02,
 4.496693148602431966e-02,
 4.498233896753831701e-02,
 4.499767138251514059e-02,
 4.501292871600445084e-02,
 4.502811095317873352e-02,
 4.504321807933310551e-02,
 4.505825007988568942e-02,
 4.507320694037696140e-02,
 4.508808864647020215e-02,
 4.510289518395162178e-02,
 4.511762653872988804e-02,
 4.513228269683703525e-02,
 4.514686364442704880e-02,
 4.516136936777732230e-02,
 4.517579985328755432e-02,
 4.519015508748051163e-02,
 4.520443505700189046e-02,
 4.521863974861969199e-02,
 4.523276914922508968e-02,
 4.524682324583217258e-02,
 4.526080202557729998e-02,
 4.527470547572014226e-02,
 4.528853358364321596e-02,
 4.530228633685130790e-02,
 4.531596372297260616e-02,
 4.532956572975782583e-02,
 4.534309234508052816e-02,
 4.535654355693750223e-02,
 4.536991935344780041e-02,
 4.538321972285354333e-02,
 4.539644465351985042e-02,
 4.540959413393459015e-02,
 4.542266815270844943e-02,
 4.543566669857484336e-02,
 4.544858976039039405e-02,
 4.546143732713430613e-02,
 4.547420938790857486e-02,
 4.548690593193838866e-02,
 4.549952694857161556e-02,
 4.551207242727884489e-02,
 4.552454235765394236e-02,
 4.553693672941295373e-02,
 4.554925553239561747e-02,
 4.556149875656386600e-02,
 4.557366639200279013e-02,
 4.558575842892043095e-02,
 4.559777485764759247e-02,
 4.560971566863782772e-02,
 4.562158085246768857e-02,
 4.563337039983682980e-02,
 4.564508430156710012e-02,
 4.565672254860396462e-02,
 4.566828513201523498e-02,
 4.567977204299190214e-02,
 4.569118327284776154e-02,
 4.570251881301905933e-02,
 4.571377865506562332e-02,
 4.572496279066934344e-02,
 4.573607121163571210e-02,
 4.574710390989249198e-02,
 4.575806087749052786e-02,
 4.576894210660370499e-02,
 4.577974758952831763e-02,
 4.579047731868374910e-02,
 4.580113128661231908e-02,
 4.581170948597879100e-02,
 4.582221190957123935e-02,
 4.583263855030035583e-02,
 4.584298940119932442e-02,
 4.585326445542452917e-02,
 4.586346370625526275e-02,
 4.587358714709323382e-02,
 4.588363477146313596e-02,
 4.589360657301242569e-02,
 4.590350254551137793e-02,
 4.591332268285312074e-02,
 4.592306697905332302e-02,
 4.593273542825065947e-02,
 4.594232802470661625e-02,
 4.595184476280494285e-02,
 4.596128563705264430e-02,
 4.597065064207932206e-02,
 4.597993977263746535e-02,
 4.598915302360175039e-02,
 4.599829038997012287e-02,
 4.600735186686306932e-02,
 4.601633744952372124e-02,
 4.602524713331795220e-02,
 4.603408091373415584e-02,
 4.604283878638391891e-02,
 4.605152074700077924e-02,
 4.606012679144144001e-02,
 4.606865691568515220e-02,
 4.607711111583371461e-02,
 4.608548938811148771e-02,
 4.609379172886573367e-02,
 4.610201813456612369e-02,
 4.611016860180501553e-02,
 4.611824312729714825e-02,
 4.612624170788016259e-02,
 4.613416434051410830e-02,
 4.614201102228144419e-02,
 4.614978175038756542e-02,
 4.615747652216006802e-02,
 4.616509533504908197e-02,
 4.617263818662751401e-02,
 4.618010507459061054e-02,
 4.618749599675576328e-02,
 4.619481095106353630e-02,
 4.620204993557679163e-02,
 4.620921294848011340e-02,
 4.621629998808146622e-02,
 4.622331105281067554e-02,
 4.623024614122027420e-02,
 4.623710525198515553e-02,
 4.624388838390233042e-02,
 4.625059553589121880e-02,
 4.625722670699422556e-02,
 4.626378189637531113e-02,
 4.627026110332115028e-02,
 4.627666432724074352e-02,
 4.628299156766520900e-02,
 4.628924282424827508e-02,
 4.629541809676534364e-02,
 4.630151738511478765e-02,
 4.630754068931677847e-02,
 4.631348800951382710e-02,
 4.631935934597078419e-02,
 4.632515469907422939e-02,
 4.633087406933380364e-02,
 4.633651745738025240e-02,
 4.634208486396713261e-02,
 4.634757628997011186e-02,
 4.635299173638655901e-02,
 4.635833120433643928e-02,
 4.636359469506144693e-02,
 4.636878220992547706e-02,
 4.637389375041436196e-02,
 4.637892931813607927e-02,
 4.638388891482050219e-02,
 4.638877254231976027e-02,
 4.639358020260720555e-02,
 4.639831189777918891e-02,
 4.640296763005341552e-02,
 4.640754740176927795e-02,
 4.641205121538845291e-02,
 4.641647907349420732e-02,
 4.642083097879235593e-02,
 4.642510693410929756e-02,
 4.642930694239447847e-02,
 4.643343100671827595e-02,
 4.643747913027346241e-02,
 4.644145131637383850e-02,
 4.644534756845597467e-02,
 4.644916789007689367e-02,
 4.645291228491644359e-02,
 4.645658075677534110e-02,
 4.646017330957634417e-02,
 4.646368994736380098e-02,
 4.646713067430340710e-02,
 4.647049549468277446e-02,
 4.647378441291091788e-02,
 4.647699743351822732e-02,
 4.648013456115709929e-02,
 4.648319580060072953e-02,
 4.648618115674413992e-02,
 4.648909063460393565e-02,
 4.649192423931795132e-02,
 4.649468197614518156e-02,
 4.649736385046666920e-02,
 4.649996986778406199e-02,
 4.650250003372084773e-02,
 4.650495435402141747e-02,
 4.650733283455179418e-02,
 4.650963548129893183e-02,
 4.651186230037127750e-02,
 4.651401329799820933e-02,
 4.651608848053043893e-02,
 4.651808785443990041e-02,
 4.652001142631959074e-02,
 4.652185920288321591e-02,
 4.652363119096619704e-02,
 4.652532739752471974e-02,
 4.652694782963557457e-02,
 4.652849249449725333e-02,
 4.652996139942870701e-02,
 4.653135455187016462e-02,
 4.653267195938237677e-02,
 4.653391362964715006e-02,
 4.653507957046719434e-02,
 4.653616978976618523e-02,
 4.653718429558821590e-02,
 4.653812309609819259e-02,
 4.653898619958238281e-02,
 4.653977361444665978e-02,
 4.654048534921883390e-02,
 4.654112141254641150e-02,
 4.654168181319769809e-02,
 4.654216656006192332e-02,
 4.654257566214881070e-02,
 4.654290912858834173e-02,
 4.654316696863118608e-02,
 4.654334919164828527e-02,
 4.654345580713151187e-02,
 4.654348682469267029e-02,
 4.654344225406395474e-02,
 4.654332210509835865e-02,
 4.654312638776876565e-02,
 4.654285511216832427e-02,
 4.654250828851087818e-02,
 4.654208592712991838e-02,
 4.654158803847958936e-02,
 4.654101463313397441e-02,
 4.654036572178739395e-02,
 4.653964131525414882e-02,
 4.653884142446853417e-02,
 4.653796606048517942e-02,
 4.653701523447848626e-02,
 4.653598895774290617e-02,
 4.653488724169271840e-02,
 4.653371009786190504e-02,
 4.653245753790516415e-02,
 4.653112957359580026e-02,
 4.652972621682805593e-02,
 4.652824747961500917e-02,
 4.652669337408994743e-02,
 4.652506391250589568e-02,
 4.652335910723540829e-02,
 4.652157897077072862e-02,
 4.651972351572335879e-02,
 4.651779275482467724e-02,
 4.651578670092567508e-02,
 4.651370536699666464e-02,
 4.651154876612724476e-02,
 4.650931691152672409e-02,
 4.650700981652330229e-02,
 4.650462749456536760e-02,
 4.650216995921974128e-02,
 4.649963722417283646e-02,
 4.649702930323047767e-02,
 4.649434621031750536e-02,
 4.649158795947758160e-02,
 4.648875456487429336e-02,
 4.648584604078928595e-02,
 4.648286240162397692e-02,
 4.647980366189869567e-02,
 4.647666983625263482e-02,
 4.647346093944350331e-02,
 4.647017698634862970e-02,
 4.646681799196365065e-02,
 4.646338397140314935e-02,
 4.645987493990068329e-02,
 4.645629091280814582e-02,
 4.645263190559639072e-02,
 4.644889793385477417e-02,
 4.644508901329134909e-02,
 4.644120515973289981e-02,
 4.643724638912419961e-02,
 4.643321271752898216e-02,
 4.642910416112952521e-02,
 4.642492073622606075e-02,
 4.642066245923742729e-02,
 4.641632934670053556e-02,
 4.641192141527119425e-02,
 4.640743868172281933e-02,
 4.640288116294723902e-02,
 4.639824887595450642e-02,
 4.639354183787269825e-02,
 4.638876006594776918e-02,
 4.638390357754425958e-02,
 4.637897239014421996e-02,
 4.637396652134755104e-02,
 4.636888598887239921e-02,
 4.636373081055481654e-02,
 4.635850100434819182e-02,
 4.635319658832403461e-02,
 4.634781758067140628e-02,
 4.634236399969740572e-02,
 4.633683586382620484e-02,
 4.633123319160001308e-02,
 4.632555600167841126e-02,
 4.631980431283838628e-02,
 4.631397814397456708e-02,
 4.630807751409896783e-02,
 4.630210244234075206e-02,
 4.629605294794685022e-02,
 4.628992905028084942e-02,
 4.628373076882393022e-02,
 4.627745812317453356e-02,
 4.627111113304812479e-02,
 4.626468981827708965e-02,
 4.625819419881116445e-02,
 4.625162429471675607e-02,
 4.624498012617768439e-02,
 4.623826171349398190e-02,
 4.623146907708312880e-02,
 4.622460223747910935e-02,
 4.621766121533291138e-02,
 4.621064603141192273e-02,
 4.620355670660050013e-02,
 4.619639326189930312e-02,
 4.618915571842589773e-02,
 4.618184409741402791e-02,
 4.617445842021400404e-02,
 4.616699870829284180e-02,
 4.615946498323353353e-02,
 4.615185726673549926e-02,
 4.614417558061475327e-02,
 4.613641994680282854e-02,
 4.612859038734837963e-02,
 4.612068692441522594e-02,
 4.611270958028396844e-02,
 4.610465837735083089e-02,
 4.609653333812810394e-02,
 4.608833448524404797e-02,
 4.608006184144296247e-02,
 4.607171542958450605e-02,
 4.606329527264432094e-02,
 4.605480139371410236e-02,
 4.604623381600073118e-02,
 4.603759256282686368e-02,
 4.602887765763096634e-02,
 4.602008912396623325e-02,
 4.601122698550250134e-02,
 4.600229126602396745e-02,
 4.599328198943082591e-02,
 4.598419917973797788e-02,
 4.597504286107612775e-02,
 4.596581305769095044e-02,
 4.595650979394320240e-02,
 4.594713309430879800e-02,
 4.593768298337882333e-02,
 4.592815948585871749e-02,
 4.591856262656971582e-02,
 4.590889243044728174e-02,
 4.589914892254214757e-02,
 4.588933212801925982e-02,
 4.587944207215874370e-02,
 4.586947878035522314e-02,
 4.585944227811782764e-02,
 4.584933259107035891e-02,
 4.583914974495084671e-02,
 4.582889376561192357e-02,
 4.581856467902094276e-02,
 4.580816251125886807e-02,
 4.579768728852145337e-02,
 4.578713903711848637e-02,
 4.577651778347384404e-02,
 4.576582355412529141e-02,
 4.575505637572532813e-02,
 4.574421627503959253e-02,
 4.573330327894827019e-02,
 4.572231741444494207e-02,
 4.571125870863741725e-02,
 4.570012718874671975e-02,
 4.568892288210821967e-02,
 4.567764581617043962e-02,
 4.566629601849528375e-02,
 4.565487351675906469e-02,
 4.564337833875038025e-02,
 4.563181051237234775e-02,
 4.562017006564036276e-02,
 4.560845702668387541e-02,
 4.559667142374534271e-02,
 4.558481328518015907e-02,
 4.557288263945696166e-02,
 4.556087951515746387e-02,
 4.554880394097637897e-02,
 4.553665594572125358e-02,
 4.552443555831261340e-02,
 4.551214280778339422e-02,
 4.549977772327980230e-02,
 4.548734033406041932e-02,
 4.547483066949657010e-02,
 4.546224875907175361e-02,
 4.544959463238260750e-02,
 4.543686831913765212e-02,
 4.542406984915796364e-02,
 4.541119925237691729e-02,
 4.539825655884022204e-02,
 4.538524179870569164e-02,
 4.537215500224318909e-02,
 4.535899619983452952e-02,
 4.534576542197397975e-02,
 4.533246269926723832e-02,
 4.531908806243198362e-02,
 4.530564154229806129e-02,
 4.529212316980656128e-02,
 4.527853297601038690e-02,
 4.526487099207441439e-02,
 4.525113724927461167e-02,
 4.523733177899840613e-02,
 4.522345461274521194e-02,
 4.520950578212510479e-02,
 4.519548531885986958e-02,
 4.518139325478238294e-02,
 4.516722962183686296e-02,
 4.515299445207825862e-02,
 4.513868777767291590e-02,
 4.512430963089761327e-02,
 4.510986004414102579e-02,
 4.509533904990153247e-02,
 4.508074668078884684e-02,
 4.506608296952360065e-02,
 4.505134794893641409e-02,
 4.503654165196890186e-02,
 4.502166411167338872e-02,
 4.500671536121202132e-02,
 4.499169543385780901e-02,
 4.497660436299376341e-02,
 4.496144218211343274e-02,
 4.494620892482014546e-02,
 4.493090462482780129e-02,
 4.491552931595972631e-02,
 4.490008303214996360e-02,
 4.488456580744150382e-02,
 4.486897767598822112e-02,
 4.485331867205284012e-02,
 4.483758883000814321e-02,
 4.482178818433675549e-02,
 4.480591676963038839e-02,
 4.478997462059050583e-02,
 4.477396177202807442e-02,
 4.475787825886329979e-02,
 4.474172411612532818e-02,
 4.472549937895316241e-02,
 4.470920408259423245e-02,
 4.469283826240565832e-02,
 4.467640195385306351e-02,
 4.465989519251128970e-02,
 4.464331801406399430e-02,
 4.462667045430347007e-02,
 4.460995254913074914e-02,
 4.459316433455570716e-02,
 4.457630584669645957e-02,
 4.455937712177960447e-02,
 4.454237819614086796e-02,
 4.452530910622331389e-02,
 4.450816988857898837e-02,
 4.449096057986774017e-02,
 4.447368121685781744e-02,
 4.445633183642559022e-02,
 4.443891247555503687e-02,
 4.442142317133842416e-02,
 4.440386396097567578e-02,
 4.438623488177439319e-02,
 4.436853597115017478e-02,
 4.435076726662600527e-02,
 4.433292880583244305e-02,
 4.431502062650753693e-02,
 4.429704276649690936e-02,
 4.427899526375322914e-02,
 4.426087815633648892e-02,
 4.424269148241390809e-02,
 4.422443528026007153e-02,
 4.420610958825594433e-02,
 4.418771444489012074e-02,
 4.416924988875772784e-02,
 4.415071595856091824e-02,
 4.413211269310787083e-02,
 4.411344013131454633e-02,
 4.409469831220250852e-02,
 4.407588727490035357e-02,
 4.405700705864297462e-02,
 4.403805770277145065e-02,
 4.401903924673355312e-02,
 4.399995173008244831e-02,
 4.398079519247850150e-02,
 4.396156967368722995e-02,
 4.394227521358051031e-02,
 4.392291185213610671e-02,
 4.390347962943734472e-02,
 4.388397858567356230e-02,
 4.386440876113963799e-02,
 4.384477019623607419e-02,
 4.382506293146872650e-02,
 4.380528700744905357e-02,
 4.378544246489373543e-02,
 4.376552934462490246e-02,
 4.374554768756944850e-02,
 4.372549753475998141e-02,
 4.370537892733359492e-02,
 4.368519190653266659e-02,
 4.366493651370415702e-02,
 4.364461279030020652e-02,
 4.362422077787724700e-02,
 4.360376051809641135e-02,
 4.358323205272390810e-02,
 4.356263542362975860e-02,
 4.354197067278854638e-02,
 4.352123784227937553e-02,
 4.350043697428571110e-02,
 4.347956811109425501e-02,
 4.345863129509686118e-02,
 4.343762656878905754e-02,
 4.341655397476994194e-02,
 4.339541355574244585e-02,
 4.337420535451402132e-02,
 4.335292941399471189e-02,
 4.333158577719879029e-02,
 4.331017448724382851e-02,
 4.328869558735107953e-02,
 4.326714912084475562e-02,
 4.324553513115228509e-02,
 4.322385366180489519e-02,
 4.320210475643616876e-02,
 4.318028845878295330e-02,
 4.315840481268502782e-02,
 4.313645386208541516e-02,
 4.311443565102908437e-02,
 4.309235022366401935e-02,
 4.307019762424128123e-02,
 4.304797789711366923e-02,
 4.302569108673701126e-02,
 4.300333723766913002e-02,
 4.298091639457003038e-02,
 4.295842860220214221e-02,
 4.293587390542982773e-02,
 4.291325234921958276e-02,
 4.289056397863969666e-02,
 4.286780883886008586e-02,
 4.284498697515290444e-02,
 4.282209843289183637e-02,
 4.279914325755150573e-02,
 4.277612149470868402e-02,
 4.275303319004147146e-02,
 4.272987838932918586e-02,
 4.270665713845230027e-02,
 4.268336948339247067e-02,
 4.266001547023252211e-02,
 4.263659514515592830e-02,
 4.261310855444756102e-02,
 4.258955574449276027e-02,
 4.256593676177745228e-02,
 4.254225165288845478e-02,
 4.251850046451299131e-02,
 4.249468324343898262e-02,
 4.247080003655396424e-02,
 4.244685089084671709e-02,
 4.242283585340552582e-02,
 4.239875497141917110e-02,
 4.237460829217608305e-02,
 4.235039586306497961e-02,
 4.232611773157404084e-02,
 4.230177394529151952e-02,
 4.227736455190508891e-02,
 4.225288959920207171e-02,
 4.222834913506933602e-02,
 4.220374320749305935e-02,
 4.217907186455864543e-02,
 4.215433515445096008e-02,
 4.212953312545364426e-02,
 4.210466582594959289e-02,
 4.207973330442056625e-02,
 4.205473560944727324e-02,
 4.202967278970912157e-02,
 4.200454489398389862e-02,
 4.197935197114874284e-02,
 4.195409407017827719e-02,
 4.192877124014636470e-02,
 4.190338353022452639e-02,
 4.187793098968299599e-02,
 4.185241366788995665e-02,
 4.182683161431152707e-02,
 4.180118487851181008e-02,
 4.177547351015287180e-02,
 4.174969755899438084e-02,
 4.172385707489378176e-02,
 4.169795210780596895e-02,
 4.167198270778352254e-02,
 4.164594892497624351e-02,
 4.161985080963119532e-02,
 4.159368841209286349e-02,
 4.156746178280249643e-02,
 4.154117097229881317e-02,
 4.151481603121712216e-02,
 4.148839701028947391e-02,
 4.146191396034505650e-02,
 4.143536693230933515e-02,
 4.140875597720453105e-02,
 4.138208114614910782e-02,
 4.135534249035828502e-02,
 4.132854006114314999e-02,
 4.130167390991120596e-02,
 4.127474408816593499e-02,
 4.124775064750674236e-02,
 4.122069363962903299e-02,
 4.119357311632385749e-02,
 4.116638912947835627e-02,
 4.113914173107484362e-02,
 4.111183097319136975e-02,
 4.108445690800120731e-02,
 4.105701958777312199e-02,
 4.102951906487132400e-02,
 4.100195539175438553e-02,
 4.097432862097685757e-02,
 4.094663880518752130e-02,
 4.091888599713040808e-02,
 4.089107024964391129e-02,
 4.086319161566161207e-02,
 4.083525014821114130e-02,
 4.080724590041487354e-02,
 4.077917892548924006e-02,
 4.075104927674532557e-02,
 4.072285700758818822e-02,
 4.069460217151692205e-02,
 4.066628482212448353e-02,
 4.063790501309801767e-02,
 4.060946279821811555e-02,
 4.058095823135925845e-02,
 4.055239136648947779e-02,
 4.052376225767009843e-02,
 4.049507095905599541e-02,
 4.046631752489544126e-02,
 4.043750200952957868e-02,
 4.040862446739275360e-02,
 4.037968495301260535e-02,
 4.035068352100906752e-02,
 4.032162022609538099e-02,
 4.029249512307733067e-02,
 4.026330826685311365e-02,
 4.023405971241360291e-02,
 4.020474951484189624e-02,
 4.017537772931365631e-02,
 4.014594441109666650e-02,
 4.011644961555039385e-02,
 4.008689339812667590e-02,
 4.005727581436945711e-02,
 4.002759691991385899e-02,
 3.999785677048713073e-02,
 3.996805542190814964e-02,
 3.993819293008685906e-02,
 3.990826935102488593e-02,
 3.987828474081532570e-02,
 3.984823915564224966e-02,
 3.981813265178033717e-02,
 3.978796528559631202e-02,
 3.975773711354691625e-02,
 3.972744819217997186e-02,
 3.969709857813372850e-02,
 3.966668832813749490e-02,
 3.963621749901072300e-02,
 3.960568614766311890e-02,
 3.957509433109505231e-02,
 3.954444210639672386e-02,
 3.951372953074851202e-02,
 3.948295666142054988e-02,
 3.945212355577339125e-02,
 3.942123027125676860e-02,
 3.939027686541018980e-02,
 3.935926339586286182e-02,
 3.932818992033326744e-02,
 3.929705649662948441e-02,
 3.926586318264856795e-02,
 3.923461003637670336e-02,
 3.920329711588933785e-02,
 3.917192447935059774e-02,
 3.914049218501355204e-02,
 3.910900029121989335e-02,
 3.907744885640004190e-02,
 3.904583793907302758e-02,
 3.901416759784588628e-02,
 3.898243789141420806e-02,
 3.895064887856178326e-02,
 3.891880061816051922e-02,
 3.888689316917035704e-02,
 3.885492659063859849e-02,
 3.882290094170093991e-02,
 3.879081628158059791e-02,
 3.875867266958802487e-02,
 3.872647016512156121e-02,
 3.869420882766665820e-02,
 3.866188871679583638e-02,
 3.862950989216911574e-02,
 3.859707241353341894e-02,
 3.856457634072257834e-02,
 3.853202173365687794e-02,
 3.849940865234419834e-02,
 3.846673715687782408e-02,
 3.843400730743858768e-02,
 3.840121916429319743e-02,
 3.836837278779462596e-02,
 3.833546823838216572e-02,
 3.830250557658126942e-02,
 3.826948486300307123e-02,
 3.823640615834456025e-02,
 3.820326952338871235e-02,
 3.817007501900410854e-02,
 3.813682270614449088e-02,
 3.810351264584956738e-02,
 3.807014489924372136e-02,
 3.803671952753730212e-02,
 3.800323659202496651e-02,
 3.796969615408690019e-02,
 3.793609827518787392e-02,
 3.790244301687756279e-02,
 3.786873044079025474e-02,
 3.783496060864465632e-02,
 3.780113358224423958e-02,
 3.776724942347648578e-02,
 3.773330819431298944e-02,
 3.769930995681004815e-02,
 3.766525477310728870e-02,
 3.763114270542836787e-02,
 3.759697381608118061e-02,
 3.756274816745686085e-02,
 3.752846582203019088e-02,
 3.749412684235916421e-02,
 3.745973129108567251e-02,
 3.742527923093440928e-02,
 3.739077072471305718e-02,
 3.735620583531281541e-02,
 3.732158462570739355e-02,
 3.728690715895326829e-02,
 3.725217349818964879e-02,
 3.721738370663842110e-02,
 3.718253784760388453e-02,
 3.714763598447220344e-02,
 3.711267818071279506e-02,
 3.707766449987628249e-02,
 3.704259500559542451e-02,
 3.700746976158517110e-02,
 3.697228883164208751e-02,
 3.693705227964416693e-02,
 3.690176016955145494e-02,
 3.686641256540498096e-02,
 3.683100953132751459e-02,
 3.679555113152237211e-02,
 3.676003743027467241e-02,
 3.672446849195027535e-02,
 3.668884438099586504e-02,
 3.665316516193853347e-02,
 3.661743089938684220e-02,
 3.658164165802918477e-02,
 3.654579750263459853e-02,
 3.650989849805240384e-02,
 3.647394470921214854e-02,
 3.643793620112354553e-02,
 3.640187303887607029e-02,
 3.636575528763912740e-02,
 3.632958301266184936e-02,
 3.629335627927301328e-02,
 3.625707515288100619e-02,
 3.622073969897324219e-02,
 3.618434998311668288e-02,
 3.614790607095770547e-02,
 3.611140802822128404e-02,
 3.607485592071132258e-02,
 3.603824981431085622e-02,
 3.600158977498152391e-02,
 3.596487586876329079e-02,
 3.592810816177477440e-02,
 3.589128672021331401e-02,
 3.585441161035372859e-02,
 3.581748289854952416e-02,
 3.578050065123202644e-02,
 3.574346493491048493e-02,
 3.570637581617183698e-02,
 3.566923336168071473e-02,
 3.563203763817932024e-02,
 3.559478871248733522e-02,
 3.555748665150158805e-02,
 3.552013152219624104e-02,
 3.548272339162263089e-02,
 3.544526232690865808e-02,
 3.540774839525930723e-02,
 3.537018166395637653e-02,
 3.533256220035815853e-02,
 3.529489007189937771e-02,
 3.525716534609137087e-02,
 3.521938809052130998e-02,
 3.518155837285274340e-02,
 3.514367626082548490e-02,
 3.510574182225473239e-02,
 3.506775512503170628e-02,
 3.502971623712331645e-02,
 3.499162522657208590e-02,
 3.495348216149592180e-02,
 3.491528711008773378e-02,
 3.487704014061618341e-02,
 3.483874132142464330e-02,
 3.480039072093119024e-02,
 3.476198840762931980e-02,
 3.472353445008675293e-02,
 3.468502891694617840e-02,
 3.464647187692431601e-02,
 3.460786339881283952e-02,
 3.456920355147710677e-02,
 3.453049240385677038e-02,
 3.449173002496541685e-02,
 3.445291648389103845e-02,
 3.441405184979450665e-02,
 3.437513619191090442e-02,
 3.433616957954863103e-02,
 3.429715208208971439e-02,
 3.425808376898900609e-02,
 3.421896470977506266e-02,
 3.417979497404918798e-02,
 3.414057463148539168e-02,
 3.410130375183084012e-02,
 3.406198240490518336e-02,
 3.402261066060082578e-02,
 3.398318858888223909e-02,
 3.394371625978658685e-02,
 3.390419374342296815e-02,
 3.386462110997265351e-02,
 3.382499842968870324e-02,
 3.378532577289634214e-02,
 3.374560320999221014e-02,
 3.370583081144460508e-02,
 3.366600864779327462e-02,
 3.362613678964931907e-02,
 3.358621530769496238e-02,
 3.354624427268366321e-02,
 3.350622375543998305e-02,
 3.346615382685888540e-02,
 3.342603455790633254e-02,
 3.338586601961912592e-02,
 3.334564828310413592e-02,
 3.330538141953871822e-02,
 3.326506550017056807e-02,
 3.322470059631743577e-02,
 3.318428677936707816e-02,
 3.314382412077697404e-02,
 3.310331269207459487e-02,
 3.306275256485689124e-02,
 3.302214381079034144e-02,
 3.298148650161065315e-02,
 3.294078070912304784e-02,
 3.290002650520162941e-02,
 3.285922396178972416e-02,
 3.281837315089929791e-02,
 3.277747414461147646e-02,
 3.273652701507536594e-02,
 3.269553183450930878e-02,
 3.265448867519932241e-02,
 3.261339760950032057e-02,
 3.257225870983499610e-02,
 3.253107204869405689e-02,
 3.248983769863629523e-02,
 3.244855573228788703e-02,
 3.240722622234320366e-02,
 3.236584924156366005e-02,
 3.232442486277811722e-02,
 3.228295315888309036e-02,
 3.224143420284156930e-02,
 3.219986806768403154e-02,
 3.215825482650771366e-02,
 3.211659455247675016e-02,
 3.207488731882167377e-02,
 3.203313319883963756e-02,
 3.199133226589435247e-02,
 3.194948459341536567e-02,
 3.190759025489851158e-02,
 3.186564932390611310e-02,
 3.182366187406571872e-02,
 3.178162797907090054e-02,
 3.173954771268074071e-02,
 3.169742114872015765e-02,
 3.165524836107918433e-02,
 3.161302942371283647e-02,
 3.157076441064196604e-02,
 3.152845339595179708e-02,
 3.148609645379250171e-02,
 3.144369365837932501e-02,
 3.140124508399172454e-02,
 3.135875080497391859e-02,
 3.131621089573453920e-02,
 3.127362543074609785e-02,
 3.123099448454563082e-02,
 3.118831813173363748e-02,
 3.114559644697510385e-02,
 3.110282950499842700e-02,
 3.106001738059534223e-02,
 3.101716014862134982e-02,
 3.097425788399542704e-02,
 3.093131066169947652e-02,
 3.088831855677837135e-02,
 3.084528164434058306e-02,
 3.080219999955665852e-02,
 3.075907369766029548e-02,
 3.071590281394750294e-02,
 3.067268742377708690e-02,
 3.062942760256964075e-02,
 3.058612342580845772e-02,
 3.054277496903869821e-02,
 3.049938230786751470e-02,
 3.045594551796335092e-02,
 3.041246467505730189e-02,
 3.036893985494105302e-02,
 3.032537113346825408e-02,
 3.028175858655373850e-02,
 3.023810229017342630e-02,
 3.019440232036416441e-02,
 3.015065875322370942e-02,
 3.010687166491110914e-02,
 3.006304113164522812e-02,
 3.001916722970611809e-02,
 2.997525003543361974e-02,
 2.993128962522833766e-02,
 2.988728607555066197e-02,
 2.984323946292113602e-02,
 2.979914986392030035e-02,
 2.975501735518791199e-02,
 2.971084201342376330e-02,
 2.966662391538724131e-02,
 2.962236313789649508e-02,
 2.957805975782932389e-02,
 2.953371385212260822e-02,
 2.948932549777207035e-02,
 2.944489477183201767e-02,
 2.940042175141585265e-02,
 2.935590651369528875e-02,
 2.931134913590047533e-02,
 2.926674969531989356e-02,
 2.922210826930021418e-02,
 2.917742493524632177e-02,
 2.913269977062029822e-02,
 2.908793285294285214e-02,
 2.904312425979183043e-02,
 2.899827406880270061e-02,
 2.895338235766830096e-02,
 2.890844920413875030e-02,
 2.886347468602133010e-02,
 2.881845888117986684e-02,
 2.877340186753574516e-02,
 2.872830372306668309e-02,
 2.868316452580677023e-02,
 2.863798435384675226e-02,
 2.859276328533406561e-02,
 2.854750139847164747e-02,
 2.850219877151879272e-02,
 2.845685548279099433e-02,
 2.841147161065904134e-02,
 2.836604723354983412e-02,
 2.832058242994536790e-02,
 2.827507727838333984e-02,
 2.822953185745670501e-02,
 2.818394624581302410e-02,
 2.813832052215582691e-02,
 2.809265476524261743e-02,
 2.804694905388591467e-02,
 2.800120346695312776e-02,
 2.795541808336565390e-02,
 2.790959298209954448e-02,
 2.786372824218475916e-02,
 2.781782394270577649e-02,
 2.777188016280052185e-02,
 2.772589698166070399e-02,
 2.767987447853231808e-02,
 2.763381273271431349e-02,
 2.758771182355910026e-02,
 2.754157183047250060e-02,
 2.749539283291331862e-02,
 2.744917491039349303e-02,
 2.740291814247767035e-02,
 2.735662260878330906e-02,
 2.731028838898053729e-02,
 2.726391556279172609e-02,
 2.721750420999184336e-02,
 2.717105441040785357e-02,
 2.712456624391871782e-02,
 2.707803979045528622e-02,
 2.703147513000065533e-02,
 2.698487234258890172e-02,
 2.693823150830611246e-02,
 2.689155270728953856e-02,
 2.684483601972779271e-02,
 2.679808152586042602e-02,
 2.675128930597806681e-02,
 2.670445944042226794e-02,
 2.665759200958512168e-02,
 2.661068709390919731e-02,
 2.656374477388795743e-02,
 2.651676513006473446e-02,
 2.646974824303303941e-02,
 2.642269419343689155e-02,
 2.637560306196952073e-02,
 2.632847492937444994e-02,
 2.628130987644437117e-02,
 2.623410798402198152e-02,
 2.618686933299892161e-02,
 2.613959400431604616e-02,
 2.609228207896370846e-02,
 2.604493363798076472e-02,
 2.599754876245505969e-02,
 2.595012753352293061e-02,
 2.590267003236973106e-02,
 2.585517634022866523e-02,
 2.580764653838132916e-02,
 2.576008070815782522e-02,
 2.571247893093571435e-02,
 2.566484128814064403e-02,
 2.561716786124625805e-02,
 2.556945873177335696e-02,
 2.552171398129038371e-02,
 2.547393369141283392e-02,
 2.542611794380393239e-02,
 2.537826682017349511e-02,
 2.533038040227817908e-02,
 2.528245877192187088e-02,
 2.523450201095454523e-02,
 2.518651020127289641e-02,
 2.513848342482002604e-02,
 2.509042176358528345e-02,
 2.504232529960409223e-02,
 2.499419411495733614e-02,
 2.494602829177233402e-02,
 2.489782791222192732e-02,
 2.484959305852412620e-02,
 2.480132381294292837e-02,
 2.475302025778703882e-02,
 2.470468247541055679e-02,
 2.465631054821230614e-02,
 2.460790455863648071e-02,
 2.455946458917142305e-02,
 2.451099072235008239e-02,
 2.446248304075041360e-02,
 2.441394162699407622e-02,
 2.436536656374699988e-02,
 2.431675793371904093e-02,
 2.426811581966435011e-02,
 2.421944030438049483e-02,
 2.417073147070859448e-02,
 2.412198940153341756e-02,
 2.407321417978287859e-02,
 2.402440588842802774e-02,
 2.397556461048335266e-02,
 2.392669042900596316e-02,
 2.387778342709566404e-02,
 2.382884368789487187e-02,
 2.377987129458887516e-02,
 2.373086633040495316e-02,
 2.368182887861262909e-02,
 2.363275902252370136e-02,
 2.358365684549181343e-02,
 2.353452243091229065e-02,
 2.348535586222209176e-02,
 2.343615722290007947e-02,
 2.338692659646611147e-02,
 2.333766406648125902e-02,
 2.328836971654835511e-02,
 2.323904363031012790e-02,
 2.318968589145079320e-02,
 2.314029658369532935e-02,
 2.309087579080922048e-02,
 2.304142359659790487e-02,
 2.299194008490753477e-02,
 2.294242533962445943e-02,
 2.289287944467472899e-02,
 2.284330248402410835e-02,
 2.279369454167877104e-02,
 2.274405570168372762e-02,
 2.269438604812378663e-02,
 2.264468566512281220e-02,
 2.259495463684419239e-02,
 2.254519304749006553e-02,
 2.249540098130135141e-02,
 2.244557852255813640e-02,
 2.239572575557880266e-02,
 2.234584276471971928e-02,
 2.229592963437654687e-02,
 2.224598644898238484e-02,
 2.219601329300870118e-02,
 2.214601025096463519e-02,
 2.209597740739747268e-02,
 2.204591484689163647e-02,
 2.199582265406909570e-02,
 2.194570091358967814e-02,
 2.189554971014976911e-02,
 2.184536912848323437e-02,
 2.179515925336030641e-02,
 2.174492016958887858e-02,
 2.169465196201257953e-02,
 2.164435471551193549e-02,
 2.159402851500398166e-02,
 2.154367344544175569e-02,
 2.149328959181433935e-02,
 2.144287703914667456e-02,
 2.139243587249976819e-02,
 2.134196617696994605e-02,
 2.129146803768937335e-02,
 2.124094153982539895e-02,
 2.119038676858064907e-02,
 2.113980380919247906e-02,
 2.108919274693398654e-02,
 2.103855366711241542e-02,
 2.098788665506972143e-02,
 2.093719179618244025e-02,
 2.088646917586190616e-02,
 2.083571887955312785e-02,
 2.078494099273530196e-02,
 2.073413560092196919e-02,
 2.068330278966006366e-02,
 2.063244264453045415e-02,
 2.058155525114733694e-02,
 2.053064069515826012e-02,
 2.047969906224430398e-02,
 2.042873043811964731e-02,
 2.037773490853114766e-02,
 2.032671255925865006e-02,
 2.027566347611444580e-02,
 2.022458774494401840e-02,
 2.017348545162453433e-02,
 2.012235668206570696e-02,
 2.007120152220951553e-02,
 2.002002005802975063e-02,
 1.996881237553192398e-02,
 1.991757856075334135e-02,
 1.986631869976297413e-02,
 1.981503287866116444e-02,
 1.976372118357938232e-02,
 1.971238370068011461e-02,
 1.966102051615756935e-02,
 1.960963171623545179e-02,
 1.955821738716961508e-02,
 1.950677761524551371e-02,
 1.945531248677943165e-02,
 1.940382208811748666e-02,
 1.935230650563670926e-02,
 1.930076582574337396e-02,
 1.924920013487380413e-02,
 1.919760951949431652e-02,
 1.914599406610049265e-02,
 1.909435386121739048e-02,
 1.904268899139918009e-02,
 1.899099954322969533e-02,
 1.893928560332126115e-02,
 1.888754725831506137e-02,
 1.883578459488119763e-02,
 1.878399769971835290e-02,
 1.873218665955359366e-02,
 1.868035156114201262e-02,
 1.862849249126723519e-02,
 1.857660953674051055e-02,
 1.852470278440108628e-02,
 1.847277232111622577e-02,
 1.842081823378022287e-02,
 1.836884060931501944e-02,
 1.831683953467017761e-02,
 1.826481509682185977e-02,
 1.821276738277344959e-02,
 1.816069647955505587e-02,
 1.810860247422396013e-02,
 1.805648545386341966e-02,
 1.800434550558333707e-02,
 1.795218271652023259e-02,
 1.789999717383618238e-02,
 1.784778896471964083e-02,
 1.779555817638476742e-02,
 1.774330489607148231e-02,
 1.769102921104522691e-02,
 1.763873120859677651e-02,
 1.758641097604258727e-02,
 1.753406860072389412e-02,
 1.748170417000672119e-02,
 1.742931777128265899e-02,
 1.737690949196733781e-02,
 1.732447941950114242e-02,
 1.727202764134883051e-02,
 1.721955424499987258e-02,
 1.716705931796726897e-02,
 1.711454294778817081e-02,
 1.706200522202403966e-02,
 1.700944622825940195e-02,
 1.695686605410268166e-02,
 1.690426478718566952e-02,
 1.685164251516339459e-02,
 1.679899932571405144e-02,
 1.674633530653861849e-02,
 1.669365054536145129e-02,
 1.664094512992912028e-02,
 1.658821914801074382e-02,
 1.653547268739826229e-02,
 1.648270583590558114e-02,
 1.642991868136867498e-02,
 1.637711131164546613e-02,
 1.632428381461626180e-02,
 1.627143627818240790e-02,
 1.621856879026690665e-02,
 1.616568143881471145e-02,
 1.611277431179136341e-02,
 1.605984749718393848e-02,
 1.600690108300014194e-02,
 1.595393515726920702e-02,
 1.590094980804004215e-02,
 1.584794512338279227e-02,
 1.579492119138803732e-02,
 1.574187810016636907e-02,
 1.568881593784838754e-02,
 1.563573479258502028e-02,
 1.558263475254681625e-02,
 1.552951590592396847e-02,
 1.547637834092617515e-02,
 1.542322214578286527e-02,
 1.537004740874239883e-02,
 1.531685421807212240e-02,
 1.526364266205884786e-02,
 1.521041282900780986e-02,
 1.515716480724297287e-02,
 1.510389868510674839e-02,
 1.505061455096035582e-02,
 1.499731249318302442e-02,
 1.494399260017155451e-02,
 1.489065496034160802e-02,
 1.483729966212610392e-02,
 1.478392679397565884e-02,
 1.473053644435877267e-02,
 1.467712870176086405e-02,
 1.462370365468490356e-02,
 1.457026139165065216e-02,
 1.451680200119530306e-02,
 1.446332557187247903e-02,
 1.440983219225229831e-02,
 1.435632195092199220e-02,
 1.430279493648469076e-02,
 1.424925123755992236e-02,
 1.419569094278301177e-02,
 1.414211414080582263e-02,
 1.408852092029552229e-02,
 1.403491136993512134e-02,
 1.398128557842299308e-02,
 1.392764363447302443e-02,
 1.387398562681413199e-02,
 1.382031164419068175e-02,
 1.376662177536168256e-02,
 1.371291610910089706e-02,
 1.365919473419677059e-02,
 1.360545773945244508e-02,
 1.355170521368526462e-02,
 1.349793724572658817e-02,
 1.344415392442229254e-02,
 1.339035533863182532e-02,
 1.333654157722849974e-02,
 1.328271272909909567e-02,
 1.322886888314439048e-02,
 1.317501012827804706e-02,
 1.312113655342689485e-02,
 1.306724824753135485e-02,
 1.301334529954407439e-02,
 1.295942779843069388e-02,
 1.290549583316992314e-02,
 1.285154949275239475e-02,
 1.279758886618138046e-02,
 1.274361404247196204e-02,
 1.268962511065192637e-02,
 1.263562215976041410e-02,
 1.258160527884837759e-02,
 1.252757455697877699e-02,
 1.247353008322565730e-02,
 1.241947194667445374e-02,
 1.236540023642173323e-02,
 1.231131504157545464e-02,
 1.225721645125407190e-02,
 1.220310455458682025e-02,
 1.214897944071389492e-02,
 1.209484119878573467e-02,
 1.204068991796263498e-02,
 1.198652568741592067e-02,
 1.193234859632636216e-02,
 1.187815873388476350e-02,
 1.182395618929158246e-02,
 1.176974105175717517e-02,
 1.171551341050106401e-02,
 1.166127335475196543e-02,
 1.160702097374828427e-02,
 1.155275635673687525e-02,
 1.149847959297376626e-02,
 1.144419077172342467e-02,
 1.138988998225949623e-02,
 1.133557731386350409e-02,
 1.128125285582530848e-02,
 1.122691669744336346e-02,
 1.117256892802365523e-02,
 1.111820963688034056e-02,
 1.106383891333504767e-02,
 1.100945684671711042e-02,
 1.095506352636336361e-02,
 1.090065904161768157e-02,
 1.084624348183154015e-02,
 1.079181693636294646e-02,
 1.073737949457687253e-02,
 1.068293124584530213e-02,
 1.062847227954644667e-02,
 1.057400268506504364e-02,
 1.051952255179196792e-02,
 1.046503196912464476e-02,
 1.041053102646614242e-02,
 1.035601981322522951e-02,
 1.030149841881693347e-02,
 1.024696693266132809e-02,
 1.019242544418410591e-02,
 1.013787404281621396e-02,
 1.008331281799370108e-02,
 1.002874185915742129e-02,
 9.974161255753628830e-03,
 9.919571097232633694e-03,
 9.864971473049639547e-03,
 9.810362472663999509e-03,
 9.755744185539786881e-03,
 9.701116701144771662e-03,
 9.646480108950805654e-03,
 9.591834498433466846e-03,
 9.537179959072454929e-03,
 9.482516580350475871e-03,
 9.427844451753807434e-03,
 9.373163662772236726e-03,
 9.318474302898395803e-03,
 9.263776461627836259e-03,
 9.209070228458952900e-03,
 9.154355692893318547e-03,
 9.099632944434042983e-03,
 9.044902072587632583e-03,
 8.990163166862241706e-03,
 8.935416316768338835e-03,
 8.880661611818109827e-03,
 8.825899141526059866e-03,
 8.771128995407934462e-03,
 8.716351262981061193e-03,
 8.661566033764113784e-03,
 8.606773397277389659e-03,
 8.551973443041878398e-03,
 8.497166260579416125e-03,
 8.442351939413245826e-03,
 8.387530569066676406e-03,
 8.332702239063825150e-03,
 8.277867038928937715e-03,
 8.223025058186981401e-03,
 8.168176386362552277e-03,
 8.113321112980376518e-03,
 8.058459327564894067e-03,
 8.003591119640295071e-03,
 7.948716578730089660e-03,
 7.893835794357640517e-03,
 7.838948856045056118e-03,
 7.784055853313540281e-03,
 7.729156875683699211e-03,
 7.674252012674472045e-03,
 7.619341353803609634e-03,
 7.564424988587179280e-03,
 7.509503006540183163e-03,
 7.454575497175254702e-03,
 7.399642550003343762e-03,
 7.344704254533178898e-03,
 7.289760700271714043e-03,
 7.234811976723088539e-03,
 7.179858173389137149e-03,
 7.124899379769042244e-03,
 7.069935685359205434e-03,
 7.014967179652933579e-03,
 6.959993952140989572e-03,
 6.905016092310345063e-03,
 6.850033689644756396e-03,
 6.795046833624896442e-03,
 6.740055613727264326e-03,
 6.685060119424841157e-03,
 6.630060440186484605e-03,
 6.575056665477418960e-03,
 6.520048884758240272e-03,
 6.465037187485303191e-03,
 6.410021663110363616e-03,
 6.355002401080936912e-03,
 6.299979490839355094e-03,
 6.244953021823121571e-03,
 6.189923083464721199e-03,
 6.134889765191386089e-03,
 6.079853156424878773e-03,
 6.024813346581860823e-03,
 5.969770425073002949e-03,
 5.914724481303070859e-03,
 5.859675604671452619e-03,
 5.804623884570961692e-03,
 5.749569410388391186e-03,
 5.694512271503963073e-03,
 5.639452557291966574e-03,
 5.584390357119472723e-03,
 5.529325760346846981e-03,
 5.474258856327996435e-03,
 5.419189734409257837e-03,
 5.364118483929935371e-03,
 5.309045194221821869e-03,
 5.253969954609854533e-03,
 5.198892854410362002e-03,
 5.143813982932399220e-03,
 5.088733429477414368e-03,
 5.033651283338293030e-03,
 4.978567633799733765e-03,
 4.923482570138550812e-03,
 4.868396181622586423e-03,
 4.813308557511252958e-03,
 4.758219787054991656e-03,
 4.703129959495784378e-03,
 4.648039164066142259e-03,
 4.592947489989325158e-03,
 4.537855026479714615e-03,
 4.482761862741792974e-03,
 4.427668087970505068e-03,
 4.372573791350920815e-03,
 4.317479062058648086e-03,
 4.262383989258928911e-03,
 4.207288662106356721e-03,
 4.152193169746089783e-03,
 4.097097601312226639e-03,
 4.042002045928231105e-03,
 3.986906592707264475e-03,
 3.931811330751111729e-03,
 3.876716349150696739e-03,
 3.821621736985585278e-03,
 3.766527583324478547e-03,
 3.711433977224130702e-03,
 3.656341007729705782e-03,
 3.601248763875080847e-03,
 3.546157334681770013e-03,
 3.491066809159402810e-03,
 3.435977276305265341e-03,
 3.380888825104817232e-03,
 3.325801544530557988e-03,
 3.270715523542596856e-03,
 3.215630851088245156e-03,
 3.160547616101967282e-03,
 3.105465907505025516e-03,
 3.050385814205986996e-03,
 2.995307425099667277e-03,
 2.940230829067561839e-03,
 2.885156114977447967e-03,
 2.830083371683814533e-03,
 2.775012688026834602e-03,
 2.719944152832650362e-03,
 2.664877854913741753e-03,
 2.609813883067820146e-03,
 2.554752326078296720e-03,
 2.499693272713896918e-03,
 2.444636811729055531e-03,
 2.389583031862910125e-03,
 2.334532021839604184e-03,
 2.279483870368739437e-03,
 2.224438666143736115e-03,
 2.169396497843045085e-03,
 2.114357454129893281e-03,
 2.059321623651308789e-03,
 2.004289095038667718e-03,
 1.949259956907187447e-03,
 1.894234297856449856e-03,
 1.839212206469294794e-03,
 1.784193771312184802e-03,
 1.729179080935478331e-03,
 1.674168223872418834e-03,
 1.619161288639564111e-03,
 1.564158363736362382e-03,
 1.509159537645620667e-03,
 1.454164898832458093e-03,
 1.399174535744594512e-03,
 1.344188536812703730e-03,
 1.289206990449495412e-03,
 1.234229985049404340e-03,
 1.179257608989858286e-03,
 1.124289950629587956e-03,
 1.069327098309267102e-03,
 1.014369140351046748e-03,
 9.594161650590479632e-04,
 9.044682607182930522e-04,
 8.495255155950245289e-04,
 7.945880179370380745e-04,
 7.396558559726022384e-04,
 6.847291179109513170e-04,
 6.298078919418371438e-04,
 5.748922662359871654e-04,
 5.199823289440662095e-04,
 4.650781681969833135e-04,
 4.101798721062182868e-04,
 3.552875287627656436e-04,
 3.004012262375990207e-04,
 2.455210525813877670e-04,
 1.906470958243565124e-04,
 1.357794439761437610e-04,
 8.091818502551122920e-05,
 2.606340694081813765e-05,
-2.878480233103600840e-05,
-8.362635486429172160e-05,
-1.384611627540077955e-04,
-1.932891381171193300e-04,
-2.481101930919637046e-04,
-3.029242398387231973e-04,
-3.577311905389541562e-04,
-4.125309573966420363e-04,
-4.673234526378796630e-04,
-5.221085885105476634e-04,
-5.768862772853705330e-04,
-6.316564312554450627e-04,
-6.864189627365239110e-04,
-7.411737840671620264e-04,
-7.959208076088524972e-04,
-8.506599457463110466e-04,
-9.053911108870106930e-04,
-9.601142154622326671e-04,
-1.014829171926742669e-03,
-1.069535892758487943e-03,
-1.124234290459616209e-03,
-1.178924277556036996e-03,
-1.233605766597853154e-03,
-1.288278670158876432e-03,
-1.342942900837688046e-03,
-1.397598371257334883e-03,
-1.452244994064976055e-03,
-1.506882681932970132e-03,
-1.561511347558374677e-03,
-1.616130903663396410e-03,
-1.670741262994778842e-03,
-1.725342338325455043e-03,
-1.779934042453296030e-03,
-1.834516288201428879e-03,
-1.889088988419119911e-03,
-1.943652055981454421e-03,
-1.998205403789012936e-03,
-2.052748944768947176e-03,
-2.107282591874460285e-03,
-2.161806258085296247e-03,
-2.216319856407232471e-03,
-2.270823299873165734e-03,
-2.325316501542739212e-03,
-2.379799374502077937e-03,
-2.434271831864794500e-03,
-2.488733786771559278e-03,
-2.543185152390478598e-03,
-2.597625841916710067e-03,
-2.652055768573417533e-03,
-2.706474845611367332e-03,
-2.760882986309178954e-03,
-2.815280103973476396e-03,
-2.869666111939197812e-03,
-2.924040923569058616e-03,
-2.978404452254656935e-03,
-3.032756611415994390e-03,
-3.087097314501886791e-03,
-3.141426474989527425e-03,
-3.195744006385495793e-03,
-3.250049822225478755e-03,
-3.304343836073910575e-03,
-3.358625961525047148e-03,
-3.412896112202493289e-03,
-3.467154201759613859e-03,
-3.521400143879099658e-03,
-3.575633852273977023e-03,
-3.629855240687145969e-03,
-3.684064222891725825e-03,
-3.738260712691063043e-03,
-3.792444623919149702e-03,
-3.846615870440067524e-03,
-3.900774366149060372e-03,
-3.954920024972081484e-03,
-4.009052760866179017e-03,
-4.063172487819058896e-03,
-4.117279119850159909e-03,
-4.171372571010266428e-03,
-4.225452755381227388e-03,
-4.279519587076995382e-03,
-4.333572980243164362e-03,
-4.387612849057350405e-03,
-4.441639107728810945e-03,
-4.495651670499433566e-03,
-4.549650451643232063e-03,
-4.603635365466707263e-03,
-4.657606326308932898e-03,
-4.711563248541850504e-03,
-4.765506046569816662e-03,
-4.819434634830553621e-03,
-4.873348927795000986e-03,
-4.927248839966836061e-03,
-4.981134285883585811e-03,
-5.035005180116121186e-03,
-5.088861437269153257e-03,
-5.142702971980710192e-03,
-5.196529698923172021e-03,
-5.250341532802846496e-03,
-5.304138388360340323e-03,
-5.357920180370130681e-03,
-5.411686823641601723e-03,
-5.465438233018746206e-03,
-5.519174323379613840e-03,
-5.572895009638036481e-03,
-5.626600206742369582e-03,
-5.680289829675749802e-03,
-5.733963793457026552e-03,
-5.787622013140444541e-03,
-5.841264403815284688e-03,
-5.894890880606919702e-03,
-5.948501358676298000e-03,
-6.002095753220517901e-03,
-6.055673979472174506e-03,
-6.109235952700503743e-03,
-6.162781588211086597e-03,
-6.216310801345383344e-03,
-6.269823507481967796e-03,
-6.323319622035859441e-03,
-6.376799060459178298e-03,
-6.430261738240431076e-03,
-6.483707570905549410e-03,
-6.537136474018169149e-03,
-6.590548363178310234e-03,
-6.643943154024116622e-03,
-6.697320762231341075e-03,
-6.750681103513006022e-03,
-6.804024093620466077e-03,
-6.857349648342926651e-03,
-6.910657683507905394e-03,
-6.963948114980666668e-03,
-7.017220858665406368e-03,
-7.070475830504775738e-03,
-7.123712946479661065e-03,
-7.176932122610177670e-03,
-7.230133274955234494e-03,
-7.283316319612857630e-03,
-7.336481172719909287e-03,
-7.389627750452920467e-03,
-7.442755969027738810e-03,
-7.495865744699761919e-03,
-7.548956993764131644e-03,
-7.602029632555913630e-03,
-7.655083577449668837e-03,
-7.708118744860575910e-03,
-7.761135051243761573e-03,
-7.814132413094953752e-03,
-7.867110746949804168e-03,
-7.920069969385120853e-03,
-7.973009997018316516e-03,
-8.025930746507327004e-03,
-8.078832134551466523e-03,
-8.131714077891009571e-03,
-8.184576493307666248e-03,
-8.237419297624063580e-03,
-8.290242407704770736e-03,
-8.343045740455972900e-03,
-8.395829212825018512e-03,
-8.448592741802101944e-03,
-8.501336244418851440e-03,
-8.554059637748898104e-03,
-8.606762838908540297e-03,
-8.659445765056228428e-03,
-8.712108333393267512e-03,
-8.764750461163008793e-03,
-8.817372065652121296e-03,
-8.869973064190182430e-03,
-8.922553374149332778e-03,
-8.975112912945398466e-03,
-9.027651598037214620e-03,
-9.080169346927320986e-03,
-9.132666077161325294e-03,
-9.185141706328898981e-03,
-9.237596152063588112e-03,
-9.290029332042351942e-03,
-9.342441163986602015e-03,
-9.394831565662328798e-03,
-9.447200454878902989e-03,
-9.499547749490815443e-03,
-9.551873367396842771e-03,
-9.604177226540746432e-03,
-9.656459244910580580e-03,
-9.708719340539823106e-03,
-9.760957431506969706e-03,
-9.813173435935306638e-03,
-9.865367271993878695e-03,
-9.917538857897064200e-03,
-9.969688111904901132e-03,
-1.002181495232268640e-02,
-1.007391929750208262e-02,
-1.012600106584059245e-02,
-1.017806017578140425e-02,
-1.023009654581438256e-02,
-1.028211009447545926e-02,
-1.033410074034716263e-02,
-1.038606840205846468e-02,
-1.043801299828518020e-02,
-1.048993444774997535e-02,
-1.054183266922206416e-02,
-1.059370758151824757e-02,
-1.064555910350242426e-02,
-1.069738715408549007e-02,
-1.074919165222610988e-02,
-1.080097251693048002e-02,
-1.085272966725260579e-02,
-1.090446302229388861e-02,
-1.095617250120411480e-02,
-1.100785802318112599e-02,
-1.105951950747054678e-02,
-1.111115687336672146e-02,
-1.116277004021235843e-02,
-1.121435892739866720e-02,
-1.126592345436565508e-02,
-1.131746354060204386e-02,
-1.136897910564563241e-02,
-1.142047006908288379e-02,
-1.147193635054993659e-02,
-1.152337786973217995e-02,
-1.157479454636401589e-02,
-1.162618630022982900e-02,
-1.167755305116350770e-02,
-1.172889471904891082e-02,
-1.178021122381944091e-02,
-1.183150248545889599e-02,
-1.188276842400136715e-02,
-1.193400895953060023e-02,
-1.198522401218138703e-02,
-1.203641350213884714e-02,
-1.208757734963882523e-02,
-1.213871547496750067e-02,
-1.218982779846269904e-02,
-1.224091424051290157e-02,
-1.229197472155744465e-02,
-1.234300916208743229e-02,
-1.239401748264516191e-02,
-1.244499960382423019e-02,
-1.249595544627015581e-02,
-1.254688493068010363e-02,
-1.259778797780332533e-02,
-1.264866450844050021e-02,
-1.269951444344504313e-02,
-1.275033770372238119e-02,
-1.280113421023007687e-02,
-1.285190388397843345e-02,
-1.290264664603035967e-02,
-1.295336241750159011e-02,
-1.300405111955998602e-02,
-1.305471267342739328e-02,
-1.310534700037829618e-02,
-1.315595402173997709e-02,
-1.320653365889363356e-02,
-1.325708583327373132e-02,
-1.330761046636804411e-02,
-1.335810747971833204e-02,
-1.340857679492003622e-02,
-1.345901833362264481e-02,
-1.350943201752937382e-02,
-1.355981776839784367e-02,
-1.361017550804014854e-02,
-1.366050515832220244e-02,
-1.371080664116488060e-02,
-1.376107987854361878e-02,
-1.381132479248872030e-02,
-1.386154130508493974e-02,
-1.391172933847228607e-02,
-1.396188881484628289e-02,
-1.401201965645689461e-02,
-1.406212178560998886e-02,
-1.411219512466686983e-02,
-1.416223959604401110e-02,
-1.421225512221396467e-02,
-1.426224162570501226e-02,
-1.431219902910160074e-02,
-1.436212725504361007e-02,
-1.441202622622767687e-02,
-1.446189586540667232e-02,
-1.451173609538940895e-02,
-1.456154683904167108e-02,
-1.461132801928588520e-02,
-1.466107955910112524e-02,
-1.471080138152306045e-02,
-1.476049340964482280e-02,
-1.481015556661638248e-02,
-1.485978777564501627e-02,
-1.490938995999541161e-02,
-1.495896204298969613e-02,
-1.500850394800721903e-02,
-1.505801559848545489e-02,
-1.510749691791959427e-02,
-1.515694782986278487e-02,
-1.520636825792591636e-02,
-1.525575812577831779e-02,
-1.530511735714765870e-02,
-1.535444587581963859e-02,
-1.540374360563875715e-02,
-1.545301047050804712e-02,
-1.550224639438947498e-02,
-1.555145130130326618e-02,
-1.560062511532925300e-02,
-1.564976776060617025e-02,
-1.569887916133145059e-02,
-1.574795924176267820e-02,
-1.579700792621646990e-02,
-1.584602513906862090e-02,
-1.589501080475498943e-02,
-1.594396484777133721e-02,
-1.599288719267275005e-02,
-1.604177776407479661e-02,
-1.609063648665295942e-02,
-1.613946328514306860e-02,
-1.618825808434107630e-02,
-1.623702080910343834e-02,
-1.628575138434744038e-02,
-1.633444973505075032e-02,
-1.638311578625183118e-02,
-1.643174946305014233e-02,
-1.648035069060639971e-02,
-1.652891939414179515e-02,
-1.657745549893930442e-02,
-1.662595893034339925e-02,
-1.667442961375937768e-02,
-1.672286747465456108e-02,
-1.677127243855812411e-02,
-1.681964443106041471e-02,
-1.686798337781426904e-02,
-1.691628920453436963e-02,
-1.696456183699759923e-02,
-1.701280120104287780e-02,
-1.706100722257160307e-02,
-1.710917982754784836e-02,
-1.715731894199807456e-02,
-1.720542449201144242e-02,
-1.725349640373984028e-02,
-1.730153460339847044e-02,
-1.734953901726494357e-02,
-1.739750957168055209e-02,
-1.744544619304960742e-02,
-1.749334880783993268e-02,
-1.754121734258254697e-02,
-1.758905172387248764e-02,
-1.763685187836796717e-02,
-1.768461773279134119e-02,
-1.773234921392879276e-02,
-1.778004624863070704e-02,
-1.782770876381128966e-02,
-1.787533668644908369e-02,
-1.792292994358734778e-02,
-1.797048846233316455e-02,
-1.801801216985873463e-02,
-1.806550099340064816e-02,
-1.811295486026067575e-02,
-1.816037369780479360e-02,
-1.820775743346457823e-02,
-1.825510599473660275e-02,
-1.830241930918257570e-02,
-1.834969730442956304e-02,
-1.839693990817034899e-02,
-1.844414704816258258e-02,
-1.849131865223029719e-02,
-1.853845464826296349e-02,
-1.858555496421605835e-02,
-1.863261952811090180e-02,
-1.867964826803492073e-02,
-1.872664111214202010e-02,
-1.877359798865186127e-02,
-1.882051882585121863e-02,
-1.886740355209282419e-02,
-1.891425209579646396e-02,
-1.896106438544821818e-02,
-1.900784034960136329e-02,
-1.905457991687605976e-02,
-1.910128301595959144e-02,
-1.914794957560585903e-02,
-1.919457952463717032e-02,
-1.924117279194198504e-02,
-1.928772930647701042e-02,
-1.933424899726639626e-02,
-1.938073179340187024e-02,
-1.942717762404295653e-02,
-1.947358641841714574e-02,
-1.951995810582016211e-02,
-1.956629261561540489e-02,
-1.961258987723486086e-02,
-1.965884982017866711e-02,
-1.970507237401564887e-02,
-1.975125746838268803e-02,
-1.979740503298577439e-02,
-1.984351499759967261e-02,
-1.988958729206746420e-02,
-1.993562184630175496e-02,
-1.998161859028402265e-02,
-2.002757745406484255e-02,
-2.007349836776411989e-02,
-2.011938126157130149e-02,
-2.016522606574509130e-02,
-2.021103271061372095e-02,
-2.025680112657538695e-02,
-2.030253124409800783e-02,
-2.034822299371904716e-02,
-2.039387630604650239e-02,
-2.043949111175812766e-02,
-2.048506734160211729e-02,
-2.053060492639665821e-02,
-2.057610379703062042e-02,
-2.062156388446347716e-02,
-2.066698511972483651e-02,
-2.071236743391541985e-02,
-2.075771075820687442e-02,
-2.080301502384140216e-02,
-2.084828016213256113e-02,
-2.089350610446483875e-02,
-2.093869278229415487e-02,
-2.098384012714735181e-02,
-2.102894807062320043e-02,
-2.107401654439175487e-02,
-2.111904548019465783e-02,
-2.116403480984541813e-02,
-2.120898446522935521e-02,
-2.125389437830384892e-02,
-2.129876448109791279e-02,
-2.134359470571313075e-02,
-2.138838498432330676e-02,
-2.143313524917421151e-02,
-2.147784543258436304e-02,
-2.152251546694492618e-02,
-2.156714528471960837e-02,
-2.161173481844442731e-02,
-2.165628400072895296e-02,
-2.170079276425550610e-02,
-2.174526104177899877e-02,
-2.178968876612788139e-02,
-2.183407587020395890e-02,
-2.187842228698193975e-02,
-2.192272794951028239e-02,
-2.196699279091111207e-02,
-2.201121674437992934e-02,
-2.205539974318584950e-02,
-2.209954172067228606e-02,
-2.214364261025638866e-02,
-2.218770234542896333e-02,
-2.223172085975535367e-02,
-2.227569808687515640e-02,
-2.231963396050228726e-02,
-2.236352841442462019e-02,
-2.240738138250520164e-02,
-2.245119279868140749e-02,
-2.249496259696523795e-02,
-2.253869071144356390e-02,
-2.258237707627834545e-02,
-2.262602162570614278e-02,
-2.266962429403918122e-02,
-2.271318501566436249e-02,
-2.275670372504446856e-02,
-2.280018035671686066e-02,
-2.284361484529512723e-02,
-2.288700712546823737e-02,
-2.293035713200057210e-02,
-2.297366479973259393e-02,
-2.301693006358061094e-02,
-2.306015285853688784e-02,
-2.310333311966945163e-02,
-2.314647078212276818e-02,
-2.318956578111797118e-02,
-2.323261805195166174e-02,
-2.327562752999741413e-02,
-2.331859415070561964e-02,
-2.336151784960247349e-02,
-2.340439856229166796e-02,
-2.344723622445338967e-02,
-2.349003077184488517e-02,
-2.353278214030011042e-02,
-2.357549026573046991e-02,
-2.361815508412455980e-02,
-2.366077653154801536e-02,
-2.370335454414395845e-02,
-2.374588905813312945e-02,
-2.378838000981397388e-02,
-2.383082733556197291e-02,
-2.387323097183111087e-02,
-2.391559085515270952e-02,
-2.395790692213636136e-02,
-2.400017910946963817e-02,
-2.404240735391814654e-02,
-2.408459159232563540e-02,
-2.412673176161439503e-02,
-2.416882779878503848e-02,
-2.421087964091671318e-02,
-2.425288722516697262e-02,
-2.429485048877242509e-02,
-2.433676936904809532e-02,
-2.437864380338807674e-02,
-2.442047372926535800e-02,
-2.446225908423186463e-02,
-2.450399980591926041e-02,
-2.454569583203737235e-02,
-2.458734710037630347e-02,
-2.462895354880531573e-02,
-2.467051511527276753e-02,
-2.471203173780718229e-02,
-2.475350335451656850e-02,
-2.479492990358859658e-02,
-2.483631132329074467e-02,
-2.487764755197084676e-02,
-2.491893852805647167e-02,
-2.496018419005524569e-02,
-2.500138447655508508e-02,
-2.504253932622468176e-02,
-2.508364867781235491e-02,
-2.512471247014737286e-02,
-2.516573064213965122e-02,
-2.520670313277957250e-02,
-2.524762988113839202e-02,
-2.528851082636811298e-02,
-2.532934590770186470e-02,
-2.537013506445342376e-02,
-2.541087823601802242e-02,
-2.545157536187236946e-02,
-2.549222638157355031e-02,
-2.553283123476079303e-02,
-2.557338986115464258e-02,
-2.561390220055716552e-02,
-2.565436819285187020e-02,
-2.569478777800409883e-02,
-2.573516089606131887e-02,
-2.577548748715231819e-02,
-2.581576749148821806e-02,
-2.585600084936234139e-02,
-2.589618750115003920e-02,
-2.593632738730864556e-02,
-2.597642044837824432e-02,
-2.601646662498109316e-02,
-2.605646585782185262e-02,
-2.609641808768814117e-02,
-2.613632325544976154e-02,
-2.617618130205988380e-02,
-2.621599216855394904e-02,
-2.625575579605073789e-02,
-2.629547212575166978e-02,
-2.633514109894149330e-02,
-2.637476265698837641e-02,
-2.641433674134321952e-02,
-2.645386329354054711e-02,
-2.649334225519850428e-02,
-2.653277356801841264e-02,
-2.657215717378553360e-02,
-2.661149301436835715e-02,
-2.665078103171972940e-02,
-2.669002116787599216e-02,
-2.672921336495724665e-02,
-2.676835756516816531e-02,
-2.680745371079706549e-02,
-2.684650174421669006e-02,
-2.688550160788387780e-02,
-2.692445324434010814e-02,
-2.696335659621093214e-02,
-2.700221160620656577e-02,
-2.704101821712198359e-02,
-2.707977637183671751e-02,
-2.711848601331494010e-02,
-2.715714708460590862e-02,
-2.719575952884350709e-02,
-2.723432328924720036e-02,
-2.727283830912066373e-02,
-2.731130453185362517e-02,
-2.734972190092063368e-02,
-2.738809035988129872e-02,
-2.742640985238134835e-02,
-2.746468032215145308e-02,
-2.750290171300812450e-02,
-2.754107396885324341e-02,
-2.757919703367484390e-02,
-2.761727085154643338e-02,
-2.765529536662754764e-02,
-2.769327052316378907e-02,
-2.773119626548674332e-02,
-2.776907253801387879e-02,
-2.780689928524930632e-02,
-2.784467645178316519e-02,
-2.788240398229201861e-02,
-2.792008182153878082e-02,
-2.795770991437324451e-02,
-2.799528820573154650e-02,
-2.803281664063638282e-02,
-2.807029516419753956e-02,
-2.810772372161122329e-02,
-2.814510225816130654e-02,
-2.818243071921767290e-02,
-2.821970905023798298e-02,
-2.825693719676699439e-02,
-2.829411510443632580e-02,
-2.833124271896527227e-02,
-2.836831998616046180e-02,
-2.840534685191571998e-02,
-2.844232326221270493e-02,
-2.847924916312066790e-02,
-2.851612450079618957e-02,
-2.855294922148421399e-02,
-2.858972327151708751e-02,
-2.862644659731516938e-02,
-2.866311914538691163e-02,
-2.869974086232880348e-02,
-2.873631169482548930e-02,
-2.877283158964977217e-02,
-2.880930049366263804e-02,
-2.884571835381390809e-02,
-2.888208511714133661e-02,
-2.891840073077153739e-02,
-2.895466514191949794e-02,
-2.899087829788928733e-02,
-2.902704014607294589e-02,
-2.906315063395219569e-02,
-2.909920970909709442e-02,
-2.913521731916695126e-02,
-2.917117341190990018e-02,
-2.920707793516333708e-02,
-2.924293083685400307e-02,
-2.927873206499756117e-02,
-2.931448156769914451e-02,
-2.935017929315347079e-02,
-2.938582518964447804e-02,
-2.942141920554578252e-02,
-2.945696128932064409e-02,
-2.949245138952212228e-02,
-2.952788945479292021e-02,
-2.956327543386544354e-02,
-2.959860927556245275e-02,
-2.963389092879612982e-02,
-2.966912034256922320e-02,
-2.970429746597430878e-02,
-2.973942224819427910e-02,
-2.977449463850227046e-02,
-2.980951458626177053e-02,
-2.984448204092694790e-02,
-2.987939695204185411e-02,
-2.991425926924159984e-02,
-2.994906894225176155e-02,
-2.998382592088874241e-02,
-3.001853015505941483e-02,
-3.005318159476174159e-02,
-3.008778019008478272e-02,
-3.012232589120782816e-02,
-3.015681864840211515e-02,
-3.019125841202960001e-02,
-3.022564513254322530e-02,
-3.025997876048763108e-02,
-3.029425924649842283e-02,
-3.032848654130272312e-02,
-3.036266059571903625e-02,
-3.039678136065756403e-02,
-3.043084878712004615e-02,
-3.046486282619984692e-02,
-3.049882342908201427e-02,
-3.053273054704375850e-02,
-3.056658413145347739e-02,
-3.060038413377212316e-02,
-3.063413050555241490e-02,
-3.066782319843917859e-02,
-3.070146216416926727e-02,
-3.073504735457185943e-02,
-3.076857872156867069e-02,
-3.080205621717306899e-02,
-3.083547979349146248e-02,
-3.086884940272252575e-02,
-3.090216499715742193e-02,
-3.093542652917975408e-02,
-3.096863395126631460e-02,
-3.100178721598619014e-02,
-3.103488627600121952e-02,
-3.106793108406646908e-02,
-3.110092159302985798e-02,
-3.113385775583189796e-02,
-3.116673952550656074e-02,
-3.119956685518093450e-02,
-3.123233969807521007e-02,
-3.126505800750277453e-02,
-3.129772173687036391e-02,
-3.133033083967814991e-02,
-3.136288526951992728e-02,
-3.139538498008251355e-02,
-3.142782992514678991e-02,
-3.146022005858701426e-02,
-3.149255533437132076e-02,
-3.152483570656119255e-02,
-3.155706112931273150e-02,
-3.158923155687513862e-02,
-3.162134694359201859e-02,
-3.165340724390078991e-02,
-3.168541241233292782e-02,
-3.171736240351435976e-02,
-3.174925717216487558e-02,
-3.178109667309877984e-02,
-3.181288086122437131e-02,
-3.184460969154465776e-02,
-3.187628311915707835e-02,
-3.190790109925321916e-02,
-3.193946358711980543e-02,
-3.197097053813797995e-02,
-3.200242190778313650e-02,
-3.203381765162596762e-02,
-3.206515772533195113e-02,
-3.209644208466112814e-02,
-3.212767068546848459e-02,
-3.215884348370456891e-02,
-3.218996043541435398e-02,
-3.222102149673795185e-02,
-3.225202662391119662e-02,
-3.228297577326455503e-02,
-3.231386890122435462e-02,
-3.234470596431157641e-02,
-3.237548691914318016e-02,
-3.240621172243142445e-02,
-3.243688033098398454e-02,
-3.246749270170437573e-02,
-3.249804879159149534e-02,
-3.252854855774016396e-02,
-3.255899195734069523e-02,
-3.258937894767939547e-02,
-3.261970948613875793e-02,
-3.264998353019646360e-02,
-3.268020103742670657e-02,
-3.271036196549982622e-02,
-3.274046627218192562e-02,
-3.277051391533546132e-02,
-3.280050485291888251e-02,
-3.283043904298736659e-02,
-3.286031644369203503e-02,
-3.289013701328053624e-02,
-3.291990071009685132e-02,
-3.294960749258158544e-02,
-3.297925731927193321e-02,
-3.300885014880155371e-02,
-3.303838593990081340e-02,
-3.306786465139698039e-02,
-3.309728624221382892e-02,
-3.312665067137217367e-02,
-3.315595789798946730e-02,
-3.318520788128048044e-02,
-3.321440058055670497e-02,
-3.324353595522671484e-02,
-3.327261396479619382e-02,
-3.330163456886786610e-02,
-3.333059772714223878e-02,
-3.335950339941615855e-02,
-3.338835154558448398e-02,
-3.341714212563941244e-02,
-3.344587509967001521e-02,
-3.347455042786354196e-02,
-3.350316807050421342e-02,
-3.353172798797430382e-02,
-3.356023014075340538e-02,
-3.358867448941882383e-02,
-3.361706099464580044e-02,
-3.364538961720704019e-02,
-3.367366031797337095e-02,
-3.370187305791351451e-02,
-3.373002779809387147e-02,
-3.375812449967901391e-02,
-3.378616312393177556e-02,
-3.381414363221274533e-02,
-3.384206598598074600e-02,
-3.386993014679306330e-02,
-3.389773607630484908e-02,
-3.392548373626961405e-02,
-3.395317308853965099e-02,
-3.398080409506509109e-02,
-3.400837671789496558e-02,
-3.403589091917652576e-02,
-3.406334666115561766e-02,
-3.409074390617671674e-02,
-3.411808261668308057e-02,
-3.414536275521650593e-02,
-3.417258428441755785e-02,
-3.419974716702560424e-02,
-3.422685136587881594e-02,
-3.425389684391445810e-02,
-3.428088356416863353e-02,
-3.430781148977617157e-02,
-3.433468058397120409e-02,
-3.436149081008725570e-02,
-3.438824213155621673e-02,
-3.441493451190967556e-02,
-3.444156791477835655e-02,
-3.446814230389241840e-02,
-3.449465764308092680e-02,
-3.452111389627275650e-02,
-3.454751102749602232e-02,
-3.457384900087799584e-02,
-3.460012778064613936e-02,
-3.462634733112680135e-02,
-3.465250761674610464e-02,
-3.467860860203019618e-02,
-3.470465025160462263e-02,
-3.473063253019434415e-02,
-3.475655540262459486e-02,
-3.478241883382053590e-02,
-3.480822278880660314e-02,
-3.483396723270749951e-02,
-3.485965213074794511e-02,
-3.488527744825267035e-02,
-3.491084315064624938e-02,
-3.493634920345354417e-02,
-3.496179557229946167e-02,
-3.498718222290907176e-02,
-3.501250912110778074e-02,
-3.503777623282112313e-02,
-3.506298352407510172e-02,
-3.508813096099587525e-02,
-3.511321850981016096e-02,
-3.513824613684513043e-02,
-3.516321380852825002e-02,
-3.518812149138771800e-02,
-3.521296915205217315e-02,
-3.523775675725104167e-02,
-3.526248427381393352e-02,
-3.528715166867186365e-02,
-3.531175890885593360e-02,
-3.533630596149849035e-02,
-3.536079279383223806e-02,
-3.538521937319132060e-02,
-3.540958566701032928e-02,
-3.543389164282482323e-02,
-3.545813726827144047e-02,
-3.548232251108818930e-02,
-3.550644733911341444e-02,
-3.553051172028710153e-02,
-3.555451562265033588e-02,
-3.557845901434499719e-02,
-3.560234186361466852e-02,
-3.562616413880385913e-02,
-3.564992580835868452e-02,
-3.567362684082632518e-02,
-3.569726720485534577e-02,
-3.572084686919592411e-02,
-3.574436580269953201e-02,
-3.576782397431921279e-02,
-3.579122135310958130e-02,
-3.581455790822685170e-02,
-3.583783360892843495e-02,
-3.586104842457392416e-02,
-3.588420232462435217e-02,
-3.590729527864254533e-02,
-3.593032725629308893e-02,
-3.595329822734227160e-02,
-3.597620816165812696e-02,
-3.599905702921078060e-02,
-3.602184480007229045e-02,
-3.604457144441650107e-02,
-3.606723693251916857e-02,
-3.608984123475820344e-02,
-3.611238432161364975e-02,
-3.613486616366763660e-02,
-3.615728673160385764e-02,
-3.617964599620902139e-02,
-3.620194392837164377e-02,
-3.622418049908211757e-02,
-3.624635567943353814e-02,
-3.626846944062151606e-02,
-3.629052175394319874e-02,
-3.631251259079891491e-02,
-3.633444192269087714e-02,
-3.635630972122397969e-02,
-3.637811595810536841e-02,
-3.639986060514507210e-02,
-3.642154363425523234e-02,
-3.644316501745088754e-02,
-3.646472472684932770e-02,
-3.648622273467087840e-02,
-3.650765901323825557e-02,
-3.652903353497700956e-02,
-3.655034627241540712e-02,
-3.657159719818449395e-02,
-3.659278628501786562e-02,
-3.661391350575230602e-02,
-3.663497883332734323e-02,
-3.665598224078540912e-02,
-3.667692370127167284e-02,
-3.669780318803460978e-02,
-3.671862067442536320e-02,
-3.673937613389832019e-02,
-3.676006954001068139e-02,
-3.678070086642292597e-02,
-3.680127008689876994e-02,
-3.682177717530465272e-02,
-3.684222210561065997e-02,
-3.686260485188944114e-02,
-3.688292538831777767e-02,
-3.690318368917505643e-02,
-3.692337972884395664e-02,
-3.694351348181078298e-02,
-3.696358492266509088e-02,
-3.698359402609974894e-02,
-3.700354076691103611e-02,
-3.702342511999856534e-02,
-3.704324706036595666e-02,
-3.706300656311945635e-02,
-3.708270360346956757e-02,
-3.710233815673009278e-02,
-3.712191019831830724e-02,
-3.714141970375510471e-02,
-3.716086664866511541e-02,
-3.718025100877666439e-02,
-3.719957275992172296e-02,
-3.721883187803591564e-02,
-3.723802833915861726e-02,
-3.725716211943318895e-02,
-3.727623319510627725e-02,
-3.729524154252897988e-02,
-3.731418713815582572e-02,
-3.733306995854530214e-02,
-3.735188998035977870e-02,
-3.737064718036577082e-02,
-3.738934153543344019e-02,
-3.740797302253709433e-02,
-3.742654161875514501e-02,
-3.744504730126969883e-02,
-3.746349004736723720e-02,
-3.748186983443802661e-02,
-3.750018663997674306e-02,
-3.751844044158197250e-02,
-3.753663121695654387e-02,
-3.755475894390747360e-02,
-3.757282360034594482e-02,
-3.759082516428715465e-02,
-3.760876361385103589e-02,
-3.762663892726132026e-02,
-3.764445108284621838e-02,
-3.766220005903826024e-02,
-3.767988583437434369e-02,
-3.769750838749556104e-02,
-3.771506769714757373e-02,
-3.773256374218041803e-02,
-3.774999650154854669e-02,
-3.776736595431061383e-02,
-3.778467207963009944e-02,
-3.780191485677494856e-02,
-3.781909426511718963e-02,
-3.783621028413381576e-02,
-3.785326289340635447e-02,
-3.787025207262084692e-02,
-3.788717780156785481e-02,
-3.790404006014245347e-02,
-3.792083882834457881e-02,
-3.793757408627877747e-02,
-3.795424581415415138e-02,
-3.797085399228474628e-02,
-3.798739860108900357e-02,
-3.800387962109040563e-02,
-3.802029703291696233e-02,
-3.803665081730171066e-02,
-3.805294095508195834e-02,
-3.806916742720063002e-02,
-3.808533021470470598e-02,
-3.810142929874652667e-02,
-3.811746466058306415e-02,
-3.813343628157619264e-02,
-3.814934414319286204e-02,
-3.816518822700480651e-02,
-3.818096851468868319e-02,
-3.819668498802616247e-02,
-3.821233762890381691e-02,
-3.822792641931345436e-02,
-3.824345134135154201e-02,
-3.825891237721981697e-02,
-3.827430950922470348e-02,
-3.828964271977838146e-02,
-3.830491199139756525e-02,
-3.832011730670410038e-02,
-3.833525864842508152e-02,
-3.835033599939269983e-02,
-3.836534934254422907e-02,
-3.838029866092213666e-02,
-3.839518393767409055e-02,
-3.841000515605295235e-02,
-3.842476229941664545e-02,
-3.843945535122834239e-02,
-3.845408429505681874e-02,
-3.846864911457545388e-02,
-3.848314979356352861e-02,
-3.849758631590501773e-02,
-3.851195866558951297e-02,
-3.852626682671204256e-02,
-3.854051078347251608e-02,
-3.855469052017675147e-02,
-3.856880602123512886e-02,
-3.858285727116420732e-02,
-3.859684425458534407e-02,
-3.861076695622551319e-02,
-3.862462536091707671e-02,
-3.863841945359765273e-02,
-3.865214921931053871e-02,
-3.866581464320408001e-02,
-3.867941571053253730e-02,
-3.869295240665535790e-02,
-3.870642471703727994e-02,
-3.871983262724880415e-02,
-3.873317612296590939e-02,
-3.874645518997005267e-02,
-3.875966981414796092e-02,
-3.877281998149219311e-02,
-3.878590567810050183e-02,
-3.879892689017673535e-02,
-3.881188360402974130e-02,
-3.882477580607411605e-02,
-3.883760348283001734e-02,
-3.885036662092338638e-02,
-3.886306520708541351e-02,
-3.887569922815312801e-02,
-3.888826867106918994e-02,
-3.890077352288163343e-02,
-3.891321377074435234e-02,
-3.892558940191685746e-02,
-3.893790040376400585e-02,
-3.895014676375683355e-02,
-3.896232846947162570e-02,
-3.897444550859039542e-02,
-3.898649786890098085e-02,
-3.899848553829692033e-02,
-3.901040850477709154e-02,
-3.902226675644660664e-02,
-3.903406028151572976e-02,
-3.904578906830097340e-02,
-3.905745310522406449e-02,
-3.906905238081297138e-02,
-3.908058688370096706e-02,
-3.909205660262711490e-02,
-3.910346152643657397e-02,
-3.911480164407984267e-02,
-3.912607694461336938e-02,
-3.913728741719954551e-02,
-3.914843305110603244e-02,
-3.915951383570678151e-02,
-3.917052976048118751e-02,
-3.918148081501449803e-02,
-3.919236698899805638e-02,
-3.920318827222842722e-02,
-3.921394465460848605e-02,
-3.922463612614673911e-02,
-3.923526267695726100e-02,
-3.924582429726031219e-02,
-3.925632097738186721e-02,
-3.926675270775342036e-02,
-3.927711947891272815e-02,
-3.928742128150314317e-02,
-3.929765810627371819e-02,
-3.930782994407964331e-02,
-3.931793678588177410e-02,
-3.932797862274655526e-02,
-3.933795544584694354e-02,
-3.934786724646098521e-02,
-3.935771401597309982e-02,
-3.936749574587320583e-02,
-3.937721242775719249e-02,
-3.938686405332694762e-02,
-3.939645061439012164e-02,
-3.940597210285984309e-02,
-3.941542851075588438e-02,
-3.942481983020298952e-02,
-3.943414605343240759e-02,
-3.944340717278100455e-02,
-3.945260318069124944e-02,
-3.946173406971201225e-02,
-3.947079983249753010e-02,
-3.947980046180808722e-02,
-3.948873595051000801e-02,
-3.949760629157507419e-02,
-3.950641147808102438e-02,
-3.951515150321180392e-02,
-3.952382636025696810e-02,
-3.953243604261177241e-02,
-3.954098054377729043e-02,
-3.954945985736084413e-02,
-3.955787397707531683e-02,
-3.956622289673928511e-02,
-3.957450661027764327e-02,
-3.958272511172069436e-02,
-3.959087839520470525e-02,
-3.959896645497180956e-02,
-3.960698928536999369e-02,
-3.961494688085299976e-02,
-3.962283923598038105e-02,
-3.963066634541754368e-02,
-3.963842820393588540e-02,
-3.964612480641224040e-02,
-3.965375614782975372e-02,
-3.966132222327684725e-02,
-3.966882302794807330e-02,
-3.967625855714377453e-02,
-3.968362880626984113e-02,
-3.969093377083841856e-02,
-3.969817344646691532e-02,
-3.970534782887891884e-02,
-3.971245691390351551e-02,
-3.971950069747563761e-02,
-3.972647917563614656e-02,
-3.973339234453143742e-02,
-3.974024020041395239e-02,
-3.974702273964148685e-02,
-3.975373995867778620e-02,
-3.976039185409240700e-02,
-3.976697842256059212e-02,
-3.977349966086316663e-02,
-3.977995556588674597e-02,
-3.978634613462392333e-02,
-3.979267136417240225e-02,
-3.979893125173632890e-02,
-3.980512579462470307e-02,
-3.981125499025291864e-02,
-3.981731883614167411e-02,
-3.982331732991764572e-02,
-3.982925046931255764e-02,
-3.983511825216429908e-02,
-3.984092067641641088e-02,
-3.984665774011774547e-02,
-3.985232944142313993e-02,
-3.985793577859268744e-02,
-3.986347674999223684e-02,
-3.986895235409326083e-02,
-3.987436258947281431e-02,
-3.987970745481365931e-02,
-3.988498694890383472e-02,
-3.989020107063719067e-02,
-3.989534981901277089e-02,
-3.990043319313552050e-02,
-3.990545119221593912e-02,
-3.991040381556958117e-02,
-3.991529106261810372e-02,
-3.992011293288824647e-02,
-3.992486942601217170e-02,
-3.992956054172797781e-02,
-3.993418627987882497e-02,
-3.993874664041337230e-02,
-3.994324162338567380e-02,
-3.994767122895553912e-02,
-3.995203545738786055e-02,
-3.995633430905287664e-02,
-3.996056778442658164e-02,
-3.996473588408986505e-02,
-3.996883860872940675e-02,
-3.997287595913704555e-02,
-3.997684793620992494e-02,
-3.998075454095061793e-02,
-3.998459577446673158e-02,
-3.998837163797158006e-02,
-3.999208213278353935e-02,
-3.999572726032613046e-02,
-3.999930702212853295e-02,
-4.000282141982464124e-02,
-4.000627045515379315e-02,
-4.000965412996075610e-02,
-4.001297244619540783e-02,
-4.001622540591234095e-02,
-4.001941301127190376e-02,
-4.002253526453943000e-02,
-4.002559216808510706e-02,
-4.002858372438466983e-02,
-4.003150993601859581e-02,
-4.003437080567267409e-02,
-4.003716633613764453e-02,
-4.003989653030928103e-02,
-4.004256139118864133e-02,
-4.004516092188154658e-02,
-4.004769512559884503e-02,
-4.005016400565653695e-02,
-4.005256756547518476e-02,
-4.005490580858089844e-02,
-4.005717873860441952e-02,
-4.005938635928110031e-02,
-4.006152867445184063e-02,
-4.006360568806203309e-02,
-4.006561740416174355e-02,
-4.006756382690640494e-02,
-4.006944496055584587e-02,
-4.007126080947484570e-02,
-4.007301137813316233e-02,
-4.007469667110468564e-02,
-4.007631669306911670e-02,
-4.007787144881000407e-02,
-4.007936094321586096e-02,
-4.008078518127995704e-02,
-4.008214416810020053e-02,
-4.008343790887915897e-02,
-4.008466640892407312e-02,
-4.008582967364670430e-02,
-4.008692770856347315e-02,
-4.008796051929535559e-02,
-4.008892811156794522e-02,
-4.008983049121119663e-02,
-4.009066766415963351e-02,
-4.009143963645254299e-02,
-4.009214641423333031e-02,
-4.009278800374997676e-02,
-4.009336441135472051e-02,
-4.009387564350448685e-02,
-4.009432170676049956e-02,
-4.009470260778810746e-02,
-4.009501835335745057e-02,
-4.009526895034246086e-02,
-4.009545440572172964e-02,
-4.009557472657786920e-02,
-4.009562992009808868e-02,
-4.009561999357322271e-02,
-4.009554495439904970e-02,
-4.009540481007502211e-02,
-4.009519956820454395e-02,
-4.009492923649593532e-02,
-4.009459382276080175e-02,
-4.009419333491519993e-02,
-4.009372778097947121e-02,
-4.009319716907729092e-02,
-4.009260150743720885e-02,
-4.009194080439086594e-02,
-4.009121506837458326e-02,
-4.009042430792834899e-02,
-4.008956853169585999e-02,
-4.008864774842488959e-02,
-4.008766196696719047e-02,
-4.008661119627797420e-02,
-4.008549544541653575e-02,
-4.008431472354598984e-02,
-4.008306903993297948e-02,
-4.008175840394789802e-02,
-4.008038282506510425e-02,
-4.007894231286225628e-02,
-4.007743687702083890e-02,
-4.007586652732607335e-02,
-4.007423127366634835e-02,
-4.007253112603415685e-02,
-4.007076609452512456e-02,
-4.006893618933851653e-02,
-4.006704142077706365e-02,
-4.006508179924706675e-02,
-4.006305733525784840e-02,
-4.006096803942257173e-02,
-4.005881392245768530e-02,
-4.005659499518265249e-02,
-4.005431126852068702e-02,
-4.005196275349778151e-02,
-4.004954946124368587e-02,
-4.004707140299092194e-02,
-4.004452859007562315e-02,
-4.004192103393657692e-02,
-4.003924874611612672e-02,
-4.003651173825956838e-02,
-4.003371002211523338e-02,
-4.003084360953453741e-02,
-4.002791251247182769e-02,
-4.002491674298438301e-02,
-4.002185631323262882e-02,
-4.001873123547979721e-02,
-4.001554152209198939e-02,
-4.001228718553800912e-02,
-4.000896823838993172e-02,
-4.000558469332189671e-02,
-4.000213656311159272e-02,
-3.999862386063884195e-02,
-3.999504659888648839e-02,
-3.999140479093975242e-02,
-3.998769844998680684e-02,
-3.998392758931823554e-02,
-3.998009222232710991e-02,
-3.997619236250922470e-02,
-3.997222802346260540e-02,
-3.996819921888810495e-02,
-3.996410596258859887e-02,
-3.995994826846955422e-02,
-3.995572615053908511e-02,
-3.995143962290695350e-02,
-3.994708869978583904e-02,
-3.994267339549032597e-02,
-3.993819372443747906e-02,
-3.993364970114612195e-02,
-3.992904134023795432e-02,
-3.992436865643604615e-02,
-3.991963166456589940e-02,
-3.991483037955500385e-02,
-3.990996481643305921e-02,
-3.990503499033126733e-02,
-3.990004091648336609e-02,
-3.989498261022454695e-02,
-3.988986008699208635e-02,
-3.988467336232513066e-02,
-3.987942245186425205e-02,
-3.987410737135238525e-02,
-3.986872813663371734e-02,
-3.986328476365427059e-02,
-3.985777726846169433e-02,
-3.985220566720532737e-02,
-3.984656997613595514e-02,
-3.984087021160607339e-02,
-3.983510639006956205e-02,
-3.982927852808188646e-02,
-3.982338664229959080e-02,
-3.981743074948086020e-02,
-3.981141086648550681e-02,
-3.980532701027415798e-02,
-3.979917919790901953e-02,
-3.979296744655325818e-02,
-3.978669177347154973e-02,
-3.978035219602967659e-02,
-3.977394873169426415e-02,
-3.976748139803327337e-02,
-3.976095021271550123e-02,
-3.975435519351097624e-02,
-3.974769635829061842e-02,
-3.974097372502617687e-02,
-3.973418731179025054e-02,
-3.972733713675641321e-02,
-3.972042321819899136e-02,
-3.971344557449306423e-02,
-3.970640422411411685e-02,
-3.969929918563899762e-02,
-3.969213047774451664e-02,
-3.968489811920837551e-02,
-3.967760212890905636e-02,
-3.967024252582488503e-02,
-3.966281932903546054e-02,
-3.965533255772014237e-02,
-3.964778223115882072e-02,
-3.964016836873222177e-02,
-3.963249098992072811e-02,
-3.962475011430541261e-02,
-3.961694576156722658e-02,
-3.960907795148748550e-02,
-3.960114670394757758e-02,
-3.959315203892917884e-02,
-3.958509397651374662e-02,
-3.957697253688266525e-02,
-3.956878774031765550e-02,
-3.956053960719994184e-02,
-3.955222815801087699e-02,
-3.954385341333151171e-02,
-3.953541539384290010e-02,
-3.952691412032541263e-02,
-3.951834961365946475e-02,
-3.950972189482494790e-02,
-3.950103098490138215e-02,
-3.949227690506808969e-02,
-3.948345967660332051e-02,
-3.947457932088547367e-02,
-3.946563585939172336e-02,
-3.945662931369925408e-02,
-3.944755970548397689e-02,
-3.943842705652159802e-02,
-3.942923138868678623e-02,
-3.941997272395322133e-02,
-3.941065108439411463e-02,
-3.940126649218177179e-02,
-3.939181896958710710e-02,
-3.938230853898044143e-02,
-3.937273522283091243e-02,
-3.936309904370649537e-02,
-3.935340002427436396e-02,
-3.934363818729994661e-02,
-3.933381355564807141e-02,
-3.932392615228169630e-02,
-3.931397600026285272e-02,
-3.930396312275188236e-02,
-3.929388754300809639e-02,
-3.928374928438906066e-02,
-3.927354837035068602e-02,
-3.926328482444776946e-02,
-3.925295867033312680e-02,
-3.924256993175803676e-02,
-3.923211863257175525e-02,
-3.922160479672245903e-02,
-3.921102844825582329e-02,
-3.920038961131596528e-02,
-3.918968831014505577e-02,
-3.917892456908336068e-02,
-3.916809841256892188e-02,
-3.915720986513785556e-02,
-3.914625895142435918e-02,
-3.913524569616017024e-02,
-3.912417012417468420e-02,
-3.911303226039567621e-02,
-3.910183212984778139e-02,
-3.909056975765384800e-02,
-3.907924516903409085e-02,
-3.906785838930633414e-02,
-3.905640944388556746e-02,
-3.904489835828491712e-02,
-3.903332515811397396e-02,
-3.902168986908026438e-02,
-3.900999251698850090e-02,
-3.899823312774046424e-02,
-3.898641172733516291e-02,
-3.897452834186875686e-02,
-3.896258299753427995e-02,
-3.895057572062214646e-02,
-3.893850653751921437e-02,
-3.892637547470978454e-02,
-3.891418255877463622e-02,
-3.890192781639134623e-02,
-3.888961127433445547e-02,
-3.887723295947507346e-02,
-3.886479289878089910e-02,
-3.885229111931618601e-02,
-3.883972764824184659e-02,
-3.882710251281502184e-02,
-3.881441574038966419e-02,
-3.880166735841557302e-02,
-3.878885739443932446e-02,
-3.877598587610362607e-02,
-3.876305283114693523e-02,
-3.875005828740459013e-02,
-3.873700227280752612e-02,
-3.872388481538264343e-02,
-3.871070594325325132e-02,
-3.869746568463797859e-02,
-3.868416406785198797e-02,
-3.867080112130566460e-02,
-3.865737687350552509e-02,
-3.864389135305361378e-02,
-3.863034458864744725e-02,
-3.861673660908055555e-02,
-3.860306744324153161e-02,
-3.858933712011479444e-02,
-3.857554566877997165e-02,
-3.856169311841202429e-02,
-3.854777949828136485e-02,
-3.853380483775337845e-02,
-3.851976916628900571e-02,
-3.850567251344387543e-02,
-3.849151490886908167e-02,
-3.847729638231030952e-02,
-3.846301696360853589e-02,
-3.844867668269957850e-02,
-3.843427556961383218e-02,
-3.841981365447685870e-02,
-3.840529096750845695e-02,
-3.839070753902335681e-02,
-3.837606339943087919e-02,
-3.836135857923495679e-02,
-3.834659310903372476e-02,
-3.833176701952002718e-02,
-3.831688034148066080e-02,
-3.830193310579727006e-02,
-3.828692534344518839e-02,
-3.827185708549430548e-02,
-3.825672836310841513e-02,
-3.824153920754559677e-02,
-3.822628965015741759e-02,
-3.821097972238994556e-02,
-3.819560945578295841e-02,
-3.818017888196983262e-02,
-3.816468803267774462e-02,
-3.814913693972792064e-02,
-3.813352563503468601e-02,
-3.811785415060615217e-02,
-3.810212251854415422e-02,
-3.808633077104365411e-02,
-3.807047894039293501e-02,
-3.805456705897407310e-02,
-3.803859515926177187e-02,
-3.802256327382438211e-02,
-3.800647143532324274e-02,
-3.799031967651263914e-02,
-3.797410803024017095e-02,
-3.795783652944600267e-02,
-3.794150520716333547e-02,
-3.792511409651820597e-02,
-3.790866323072925037e-02,
-3.789215264310825254e-02,
-3.787558236705895753e-02,
-3.785895243607800831e-02,
-3.784226288375476532e-02,
-3.782551374377039061e-02,
-3.780870504989913838e-02,
-3.779183683600696037e-02,
-3.777490913605247025e-02,
-3.775792198408613881e-02,
-3.774087541425071024e-02,
-3.772376946078093152e-02,
-3.770660415800361487e-02,
-3.768937954033736021e-02,
-3.767209564229234003e-02,
-3.765475249847133332e-02,
-3.763735014356782427e-02,
-3.761988861236761211e-02,
-3.760236793974805480e-02,
-3.758478816067760409e-02,
-3.756714931021646470e-02,
-3.754945142351612253e-02,
-3.753169453581945564e-02,
-3.751387868246073426e-02,
-3.749600389886495466e-02,
-3.747807022054874815e-02,
-3.746007768311920838e-02,
-3.744202632227500160e-02,
-3.742391617380556867e-02,
-3.740574727359073648e-02,
-3.738751965760155754e-02,
-3.736923336189979655e-02,
-3.735088842263770137e-02,
-3.733248487605807936e-02,
-3.731402275849410310e-02,
-3.729550210636997654e-02,
-3.727692295619976920e-02,
-3.725828534458757585e-02,
-3.723958930822855729e-02,
-3.722083488390734440e-02,
-3.720202210849878066e-02,
-3.718315101896801922e-02,
-3.716422165236978742e-02,
-3.714523404584914312e-02,
-3.712618823664050327e-02,
-3.710708426206839328e-02,
-3.708792215954659355e-02,
-3.706870196657884725e-02,
-3.704942372075846480e-02,
-3.703008745976798383e-02,
-3.701069322137930800e-02,
-3.699124104345401232e-02,
-3.697173096394253816e-02,
-3.695216302088460275e-02,
-3.693253725240935870e-02,
-3.691285369673443645e-02,
-3.689311239216695043e-02,
-3.687331337710252760e-02,
-3.685345669002589031e-02,
-3.683354236951041222e-02,
-3.681357045421802809e-02,
-3.679354098289943503e-02,
-3.677345399439386348e-02,
-3.675330952762899395e-02,
-3.673310762162083909e-02,
-3.671284831547374367e-02,
-3.669253164838029435e-02,
-3.667215765962138219e-02,
-3.665172638856572379e-02,
-3.663123787467034015e-02,
-3.661069215748032069e-02,
-3.659008927662804611e-02,
-3.656942927183413905e-02,
-3.654871218290711016e-02,
-3.652793804974290709e-02,
-3.650710691232483124e-02,
-3.648621881072412060e-02,
-3.646527378509939465e-02,
-3.644427187569612009e-02,
-3.642321312284770018e-02,
-3.640209756697462828e-02,
-3.638092524858417554e-02,
-3.635969620827107784e-02,
-3.633841048671695995e-02,
-3.631706812469006479e-02,
-3.629566916304590579e-02,
-3.627421364272645499e-02,
-3.625270160476071896e-02,
-3.623113309026389228e-02,
-3.620950814043789184e-02,
-3.618782679657137763e-02,
-3.616608910003883681e-02,
-3.614429509230161763e-02,
-3.612244481490710368e-02,
-3.610053830948860287e-02,
-3.607857561776561112e-02,
-3.605655678154395111e-02,
-3.603448184271521720e-02,
-3.601235084325647012e-02,
-3.599016382523114593e-02,
-3.596792083078786950e-02,
-3.594562190216141206e-02,
-3.592326708167146304e-02,
-3.590085641172372638e-02,
-3.587838993480908789e-02,
-3.585586769350351116e-02,
-3.583328973046880084e-02,
-3.581065608845110382e-02,
-3.578796681028242888e-02,
-3.576522193887918255e-02,
-3.574242151724315447e-02,
-3.571956558846076102e-02,
-3.569665419570276083e-02,
-3.567368738222560093e-02,
-3.565066519136943918e-02,
-3.562758766655935161e-02,
-3.560445485130479815e-02,
-3.558126678919951158e-02,
-3.555802352392178206e-02,
-3.553472509923379791e-02,
-3.551137155898211745e-02,
-3.548796294709709309e-02,
-3.546449930759330849e-02,
-3.544098068456911360e-02,
-3.541740712220679127e-02,
-3.539377866477209922e-02,
-3.537009535661451293e-02,
-3.534635724216731584e-02,
-3.532256436594726628e-02,
-3.529871677255402851e-02,
-3.527481450667122043e-02,
-3.525085761306532423e-02,
-3.522684613658617209e-02,
-3.520278012216665475e-02,
-3.517865961482252724e-02,
-3.515448465965259617e-02,
-3.513025530183838674e-02,
-3.510597158664438555e-02,
-3.508163355941774225e-02,
-3.505724126558776993e-02,
-3.503279475066699289e-02,
-3.500829406024981438e-02,
-3.498373924001302315e-02,
-3.495913033571602935e-02,
-3.493446739320008043e-02,
-3.490975045838883017e-02,
-3.488497957728750598e-02,
-3.486015479598369299e-02,
-3.483527616064676508e-02,
-3.481034371752747547e-02,
-3.478535751295867146e-02,
-3.476031759335486415e-02,
-3.473522400521174974e-02,
-3.471007679510646621e-02,
-3.468487600969783619e-02,
-3.465962169572575635e-02,
-3.463431390001114885e-02,
-3.460895266945626658e-02,
-3.458353805104429080e-02,
-3.455807009183938655e-02,
-3.453254883898637662e-02,
-3.450697433971103290e-02,
-3.448134664131968091e-02,
-3.445566579119930389e-02,
-3.442993183681760522e-02,
-3.440414482572229371e-02,
-3.437830480554143753e-02,
-3.435241182398371396e-02,
-3.432646592883776410e-02,
-3.430046716797233164e-02,
-3.427441558933591592e-02,
-3.424831124095729235e-02,
-3.422215417094493645e-02,
-3.419594442748684349e-02,
-3.416968205885105581e-02,
-3.414336711338477465e-02,
-3.411699963951483894e-02,
-3.409057968574755876e-02,
-3.406410730066847248e-02,
-3.403758253294225655e-02,
-3.401100543131284348e-02,
-3.398437604460318590e-02,
-3.395769442171514552e-02,
-3.393096061162923643e-02,
-3.390417466340531899e-02,
-3.387733662618129526e-02,
-3.385044654917417073e-02,
-3.382350448167912443e-02,
-3.379651047307001555e-02,
-3.376946457279890457e-02,
-3.374236683039599782e-02,
-3.371521729547011931e-02,
-3.368801601770748944e-02,
-3.366076304687295323e-02,
-3.363345843280863418e-02,
-3.360610222543519710e-02,
-3.357869447475030078e-02,
-3.355123523082962494e-02,
-3.352372454382661349e-02,
-3.349616246397156549e-02,
-3.346854904157254423e-02,
-3.344088432701484981e-02,
-3.341316837076090118e-02,
-3.338540122335011823e-02,
-3.335758293539917846e-02,
-3.332971355760146887e-02,
-3.330179314072732877e-02,
-3.327382173562355716e-02,
-3.324579939321421068e-02,
-3.321772616449920196e-02,
-3.318960210055529880e-02,
-3.316142725253552054e-02,
-3.313320167166921432e-02,
-3.310492540926195798e-02,
-3.307659851669530332e-02,
-3.304822104542695649e-02,
-3.301979304699037554e-02,
-3.299131457299520759e-02,
-3.296278567512633817e-02,
-3.293420640514442554e-02,
-3.290557681488615743e-02,
-3.287689695626311998e-02,
-3.284816688126255407e-02,
-3.281938664194678640e-02,
-3.279055629045338899e-02,
-3.276167587899535966e-02,
-3.273274545986032402e-02,
-3.270376508541086857e-02,
-3.267473480808430475e-02,
-3.264565468039303670e-02,
-3.261652475492386044e-02,
-3.258734508433798471e-02,
-3.255811572137136400e-02,
-3.252883671883418509e-02,
-3.249950812961076296e-02,
-3.247013000665958243e-02,
-3.244070240301372143e-02,
-3.241122537177922036e-02,
-3.238169896613712906e-02,
-3.235212323934144596e-02,
-3.232249824472043648e-02,
-3.229282403567552973e-02,
-3.226310066568217200e-02,
-3.223332818828852225e-02,
-3.220350665711679133e-02,
-3.217363612586192356e-02,
-3.214371664829246411e-02,
-3.211374827824941408e-02,
-3.208373106964702848e-02,
-3.205366507647259416e-02,
-3.202355035278590945e-02,
-3.199338695271948529e-02,
-3.196317493047831637e-02,
-3.193291434034018633e-02,
-3.190260523665479353e-02,
-3.187224767384451429e-02,
-3.184184170640372291e-02,
-3.181138738889894430e-02,
-3.178088477596861805e-02,
-3.175033392232316787e-02,
-3.171973488274494601e-02,
-3.168908771208767128e-02,
-3.165839246527676898e-02,
-3.162764919730964158e-02,
-3.159685796325448909e-02,
-3.156601881825099598e-02,
-3.153513181751044919e-02,
-3.150419701631492625e-02,
-3.147321447001746181e-02,
-3.144218423404233215e-02,
-3.141110636388430577e-02,
-3.137998091510922627e-02,
-3.134880794335335313e-02,
-3.131758750432365318e-02,
-3.128631965379745361e-02,
-3.125500444762219221e-02,
-3.122364194171629859e-02,
-3.119223219206748027e-02,
-3.116077525473414170e-02,
-3.112927118584426361e-02,
-3.109772004159598244e-02,
-3.106612187825695884e-02,
-3.103447675216457202e-02,
-3.100278471972608627e-02,
-3.097104583741779743e-02,
-3.093926016178556726e-02,
-3.090742774944442786e-02,
-3.087554865707898763e-02,
-3.084362294144243205e-02,
-3.081165065935708228e-02,
-3.077963186771439860e-02,
-3.074756662347416861e-02,
-3.071545498366523921e-02,
-3.068329700538485402e-02,
-3.065109274579892046e-02,
-3.061884226214129506e-02,
-3.058654561171485209e-02,
-3.055420285188991530e-02,
-3.052181404010541332e-02,
-3.048937923386788387e-02,
-3.045689849075208441e-02,
-3.042437186840021499e-02,
-3.039179942452245597e-02,
-3.035918121689648586e-02,
-3.032651730336741527e-02,
-3.029380774184775582e-02,
-3.026105259031726738e-02,
-3.022825190682321486e-02,
-3.019540574947931350e-02,
-3.016251417646679395e-02,
-3.012957724603361476e-02,
-3.009659501649451785e-02,
-3.006356754623080302e-02,
-3.003049489369043548e-02,
-2.999737711738820548e-02,
-2.996421427590455211e-02,
-2.993100642788668053e-02,
-2.989775363204807274e-02,
-2.986445594716800531e-02,
-2.983111343209160493e-02,
-2.979772614573035841e-02,
-2.976429414706103713e-02,
-2.973081749512627298e-02,
-2.969729624903433979e-02,
-2.966373046795880639e-02,
-2.963012021113897027e-02,
-2.959646553787859471e-02,
-2.956276650754738333e-02,
-2.952902317957973449e-02,
-2.949523561347502237e-02,
-2.946140386879762818e-02,
-2.942752800517653769e-02,
-2.939360808230528574e-02,
-2.935964415994194929e-02,
-2.932563629790944926e-02,
-2.929158455609449235e-02,
-2.925748899444815393e-02,
-2.922334967298602024e-02,
-2.918916665178707473e-02,
-2.915493999099475972e-02,
-2.912066975081588002e-02,
-2.908635599152139747e-02,
-2.905199877344552886e-02,
-2.901759815698623513e-02,
-2.898315420260454134e-02,
-2.894866697082518203e-02,
-2.891413652223569219e-02,
-2.887956291748693810e-02,
-2.884494621729280853e-02,
-2.881028648242978107e-02,
-2.877558377373746340e-02,
-2.874083815211773973e-02,
-2.870604967853548906e-02,
-2.867121841401748528e-02,
-2.863634441965357685e-02,
-2.860142775659520187e-02,
-2.856646848605627967e-02,
-2.853146666931267311e-02,
-2.849642236770213652e-02,
-2.846133564262445445e-02,
-2.842620655554081721e-02,
-2.839103516797436208e-02,
-2.835582154150936146e-02,
-2.832056573779171901e-02,
-2.828526781852868169e-02,
-2.824992784548870789e-02,
-2.821454588050105114e-02,
-2.817912198545605498e-02,
-2.814365622230528136e-02,
-2.810814865306069874e-02,
-2.807259933979485908e-02,
-2.803700834464141825e-02,
-2.800137572979368925e-02,
-2.796570155750594672e-02,
-2.792998589009238614e-02,
-2.789422878992753319e-02,
-2.785843031944580661e-02,
-2.782259054114128924e-02,
-2.778670951756863003e-02,
-2.775078731134146895e-02,
-2.771482398513298515e-02,
-2.767881960167650410e-02,
-2.764277422376412718e-02,
-2.760668791424744292e-02,
-2.757056073603720431e-02,
-2.753439275210326984e-02,
-2.749818402547432941e-02,
-2.746193461923792864e-02,
-2.742564459654049658e-02,
-2.738931402058687389e-02,
-2.735294295464051062e-02,
-2.731653146202324065e-02,
-2.728007960611526089e-02,
-2.724358745035497173e-02,
-2.720705505823863002e-02,
-2.717048249332084178e-02,
-2.713386981921373300e-02,
-2.709721709958738331e-02,
-2.706052439816943739e-02,
-2.702379177874518826e-02,
-2.698701930515710196e-02,
-2.695020704130510897e-02,
-2.691335505114672566e-02,
-2.687646339869580875e-02,
-2.683953214802391185e-02,
-2.680256136325910934e-02,
-2.676555110858633985e-02,
-2.672850144824718763e-02,
-2.669141244653959466e-02,
-2.665428416781858573e-02,
-2.661711667649479043e-02,
-2.657991003703545629e-02,
-2.654266431396386586e-02,
-2.650537957185926038e-02,
-2.646805587535688148e-02,
-2.643069328914782190e-02,
-2.639329187797844270e-02,
-2.635585170665125793e-02,
-2.631837284002362665e-02,
-2.628085534300890827e-02,
-2.624329928057518233e-02,
-2.620570471774580357e-02,
-2.616807171959938116e-02,
-2.613040035126903970e-02,
-2.609269067794298819e-02,
-2.605494276486380184e-02,
-2.601715667732915072e-02,
-2.597933248069075191e-02,
-2.594147024035458465e-02,
-2.590357002178127199e-02,
-2.586563189048526543e-02,
-2.582765591203520228e-02,
-2.578964215205343732e-02,
-2.575159067621645911e-02,
-2.571350155025389425e-02,
-2.567537483994926720e-02,
-2.563721061113983027e-02,
-2.559900892971574485e-02,
-2.556076986162051159e-02,
-2.552249347285088371e-02,
-2.548417982945661367e-02,
-2.544582899754021035e-02,
-2.540744104325693906e-02,
-2.536901603281509557e-02,
-2.533055403247528106e-02,
-2.529205510855037781e-02,
-2.525351932740601754e-02,
-2.521494675545973493e-02,
-2.517633745918128677e-02,
-2.513769150509232581e-02,
-2.509900895976673388e-02,
-2.506028988982991756e-02,
-2.502153436195867289e-02,
-2.498274244288193474e-02,
-2.494391419937978804e-02,
-2.490504969828327350e-02,
-2.486614900647545617e-02,
-2.482721219088989892e-02,
-2.478823931851127996e-02,
-2.474923045637499042e-02,
-2.471018567156775883e-02,
-2.467110503122627377e-02,
-2.463198860253804079e-02,
-2.459283645274120897e-02,
-2.455364864912390477e-02,
-2.451442525902447489e-02,
-2.447516634983140996e-02,
-2.443587198898339308e-02,
-2.439654224396856780e-02,
-2.435717718232514525e-02,
-2.431777687164056803e-02,
-2.427834137955224916e-02,
-2.423887077374645496e-02,
-2.419936512195949505e-02,
-2.415982449197611251e-02,
-2.412024895163049701e-02,
-2.408063856880544862e-02,
-2.404099341143312377e-02,
-2.400131354749386950e-02,
-2.396159904501680288e-02,
-2.392184997207968261e-02,
-2.388206639680845109e-02,
-2.384224838737726906e-02,
-2.380239601200838037e-02,
-2.376250933897248313e-02,
-2.372258843658767158e-02,
-2.368263337321997383e-02,
-2.364264421728341781e-02,
-2.360262103723897650e-02,
-2.356256390159537986e-02,
-2.352247287890895516e-02,
-2.348234803778295743e-02,
-2.344218944686769085e-02,
-2.340199717486050185e-02,
-2.336177129050569234e-02,
-2.332151186259429076e-02,
-2.328121895996373633e-02,
-2.324089265149831968e-02,
-2.320053300612862426e-02,
-2.316014009283148475e-02,
-2.311971398062954292e-02,
-2.307925473859233703e-02,
-2.303876243583476841e-02,
-2.299823714151734422e-02,
-2.295767892484704489e-02,
-2.291708785507563101e-02,
-2.287646400150071535e-02,
-2.283580743346544026e-02,
-2.279511822035792251e-02,
-2.275439643161133660e-02,
-2.271364213670418533e-02,
-2.267285540515969963e-02,
-2.263203630654573445e-02,
-2.259118491047489366e-02,
-2.255030128660460292e-02,
-2.250938550463629090e-02,
-2.246843763431603108e-02,
-2.242745774543367099e-02,
-2.238644590782369603e-02,
-2.234540219136406380e-02,
-2.230432666597675570e-02,
-2.226321940162771795e-02,
-2.222208046832610528e-02,
-2.218090993612447520e-02,
-2.213970787511936045e-02,
-2.209847435544999572e-02,
-2.205720944729890748e-02,
-2.201591322089179598e-02,
-2.197458574649712934e-02,
-2.193322709442606724e-02,
-2.189183733503252682e-02,
-2.185041653871310288e-02,
-2.180896477590666890e-02,
-2.176748211709423828e-02,
-2.172596863279953674e-02,
-2.168442439358776730e-02,
-2.164284947006658855e-02,
-2.160124393288495245e-02,
-2.155960785273422151e-02,
-2.151794130034681563e-02,
-2.147624434649682626e-02,
-2.143451706199976312e-02,
-2.139275951771227313e-02,
-2.135097178453204333e-02,
-2.130915393339824493e-02,
-2.126730603529033287e-02,
-2.122542816122888892e-02,
-2.118352038227502496e-02,
-2.114158276953062576e-02,
-2.109961539413765866e-02,
-2.105761832727852390e-02,
-2.101559164017587078e-02,
-2.097353540409233399e-02,
-2.093144969033050931e-02,
-2.088933457023270726e-02,
-2.084719011518135559e-02,
-2.080501639659782312e-02,
-2.076281348594359241e-02,
-2.072058145471896567e-02,
-2.067832037446374824e-02,
-2.063603031675663793e-02,
-2.059371135321583918e-02,
-2.055136355549783134e-02,
-2.050898699529820832e-02,
-2.046658174435080774e-02,
-2.042414787442855401e-02,
-2.038168545734233769e-02,
-2.033919456494121328e-02,
-2.029667526911293346e-02,
-2.025412764178283892e-02,
-2.021155175491420528e-02,
-2.016894768050826042e-02,
-2.012631549060388964e-02,
-2.008365525727737882e-02,
-2.004096705264249434e-02,
-1.999825094885060786e-02,
-1.995550701808998170e-02,
-1.991273533258571329e-02,
-1.986993596460045683e-02,
-1.982710898643331998e-02,
-1.978425447042020391e-02,
-1.974137248893335222e-02,
-1.969846311438214551e-02,
-1.965552641921163371e-02,
-1.961256247590318150e-02,
-1.956957135697486028e-02,
-1.952655313498005696e-02,
-1.948350788250828233e-02,
-1.944043567218472698e-02,
-1.939733657667038966e-02,
-1.935421066866171297e-02,
-1.931105802089017748e-02,
-1.926787870612315864e-02,
-1.922467279716261190e-02,
-1.918144036684586023e-02,
-1.913818148804502170e-02,
-1.909489623366683944e-02,
-1.905158467665299393e-02,
-1.900824688997939174e-02,
-1.896488294665671023e-02,
-1.892149291972975919e-02,
-1.887807688227740102e-02,
-1.883463490741276933e-02,
-1.879116706828278666e-02,
-1.874767343806822001e-02,
-1.870415408998343104e-02,
-1.866060909727668832e-02,
-1.861703853322941096e-02,
-1.857344247115617214e-02,
-1.852982098440529579e-02,
-1.848617414635768050e-02,
-1.844250203042753847e-02,
-1.839880471006169471e-02,
-1.835508225873969460e-02,
-1.831133474997388363e-02,
-1.826756225730871014e-02,
-1.822376485432151971e-02,
-1.817994261462140340e-02,
-1.813609561184969035e-02,
-1.809222391968002067e-02,
-1.804832761181737050e-02,
-1.800440676199887777e-02,
-1.796046144399291583e-02,
-1.791649173159979083e-02,
-1.787249769865101312e-02,
-1.782847941900906133e-02,
-1.778443696656803810e-02,
-1.774037041525281314e-02,
-1.769627983901898155e-02,
-1.765216531185311369e-02,
-1.760802690777258164e-02,
-1.756386470082483067e-02,
-1.751967876508794125e-02,
-1.747546917467048336e-02,
-1.743123600371090584e-02,
-1.738697932637757806e-02,
-1.734269921686922705e-02,
-1.729839574941395217e-02,
-1.725406899826974552e-02,
-1.720971903772393688e-02,
-1.716534594209357875e-02,
-1.712094978572466231e-02,
-1.707653064299252677e-02,
-1.703208858830179695e-02,
-1.698762369608561654e-02,
-1.694313604080611643e-02,
-1.689862569695397068e-02,
-1.685409273904879199e-02,
-1.680953724163843088e-02,
-1.676495927929852470e-02,
-1.672035892663384718e-02,
-1.667573625827654255e-02,
-1.663109134888690957e-02,
-1.658642427315325588e-02,
-1.654173510579131506e-02,
-1.649702392154446876e-02,
-1.645229079518345863e-02,
-1.640753580150670909e-02,
-1.636275901533949112e-02,
-1.631796051153408533e-02,
-1.627314036497028507e-02,
-1.622829865055416820e-02,
-1.618343544321864877e-02,
-1.613855081792321330e-02,
-1.609364484965414982e-02,
-1.604871761342368391e-02,
-1.600376918427040898e-02,
-1.595879963725893233e-02,
-1.591380904748001396e-02,
-1.586879749004992124e-02,
-1.582376504011110893e-02,
-1.577871177283138304e-02,
-1.573363776340391124e-02,
-1.568854308704724365e-02,
-1.564342781900556964e-02,
-1.559829203454759887e-02,
-1.555313580896731940e-02,
-1.550795921758368542e-02,
-1.546276233574017667e-02,
-1.541754523880487469e-02,
-1.537230800217037098e-02,
-1.532705070125385712e-02,
-1.528177341149649683e-02,
-1.523647620836359427e-02,
-1.519115916734453849e-02,
-1.514582236395248249e-02,
-1.510046587372425135e-02,
-1.505508977222072033e-02,
-1.500969413502576365e-02,
-1.496427903774686166e-02,
-1.491884455601451623e-02,
-1.487339076548271043e-02,
-1.482791774182827017e-02,
-1.478242556075063351e-02,
-1.473691429797244906e-02,
-1.469138402923864800e-02,
-1.464583483031674238e-02,
-1.460026677699658229e-02,
-1.455467994509047035e-02,
-1.450907441043267597e-02,
-1.446345024887930354e-02,
-1.441780753630890997e-02,
-1.437214634862102845e-02,
-1.432646676173726305e-02,
-1.428076885160081862e-02,
-1.423505269417605322e-02,
-1.418931836544866203e-02,
-1.414356594142533383e-02,
-1.409779549813414828e-02,
-1.405200711162375021e-02,
-1.400620085796336171e-02,
-1.396037681324334596e-02,
-1.391453505357428781e-02,
-1.386867565508710827e-02,
-1.382279869393295522e-02,
-1.377690424628340467e-02,
-1.373099238832977895e-02,
-1.368506319628321789e-02,
-1.363911674637501535e-02,
-1.359315311485581081e-02,
-1.354717237799547835e-02,
-1.350117461208384315e-02,
-1.345515989342974117e-02,
-1.340912829836092557e-02,
-1.336307990322466860e-02,
-1.331701478438665660e-02,
-1.327093301823161105e-02,
-1.322483468116252697e-02,
-1.317871984960156811e-02,
-1.313258859998866872e-02,
-1.308644100878226038e-02,
-1.304027715245880889e-02,
-1.299409710751309871e-02,
-1.294790095045750093e-02,
-1.290168875782205654e-02,
-1.285546060615491704e-02,
-1.280921657202129492e-02,
-1.276295673200392340e-02,
-1.271668116270285691e-02,
-1.267038994073526638e-02,
-1.262408314273507845e-02,
-1.257776084535369536e-02,
-1.253142312525873728e-02,
-1.248507005913467721e-02,
-1.243870172368236222e-02,
-1.239231819561934476e-02,
-1.234591955167912113e-02,
-1.229950586861140206e-02,
-1.225307722318185605e-02,
-1.220663369217233653e-02,
-1.216017535238005445e-02,
-1.211370228061799462e-02,
-1.206721455371491045e-02,
-1.202071224851458502e-02,
-1.197419544187619707e-02,
-1.192766421067404867e-02,
-1.188111863179747672e-02,
-1.183455878215052513e-02,
-1.178798473865243397e-02,
-1.174139657823665590e-02,
-1.169479437785128292e-02,
-1.164817821445865605e-02,
-1.160154816503578511e-02,
-1.155490430657334956e-02,
-1.150824671607617901e-02,
-1.146157547056319247e-02,
-1.141489064706680857e-02,
-1.136819232263315375e-02,
-1.132148057432174129e-02,
-1.127475547920579746e-02,
-1.122801711437150518e-02,
-1.118126555691825209e-02,
-1.113450088395826279e-02,
-1.108772317261728230e-02,
-1.104093250003269737e-02,
-1.099412894335565112e-02,
-1.094731257974912962e-02,
-1.090048348638858119e-02,
-1.085364174046171866e-02,
-1.080678741916869454e-02,
-1.075992059972124409e-02,
-1.071304135934302362e-02,
-1.066614977526981513e-02,
-1.061924592474858264e-02,
-1.057232988503795275e-02,
-1.052540173340782946e-02,
-1.047846154713968567e-02,
-1.043150940352574954e-02,
-1.038454537986942781e-02,
-1.033756955348478883e-02,
-1.029058200169700489e-02,
-1.024358280184160461e-02,
-1.019657203126465850e-02,
-1.014954976732253440e-02,
-1.010251608738198942e-02,
-1.005547106881965469e-02,
-1.000841478902257838e-02,
-9.961347325387309715e-03,
-9.914268755320041274e-03,
-9.867179156237099874e-03,
-9.820078605563808613e-03,
-9.772967180735014220e-03,
-9.725844959194670722e-03,
-9.678712018396233227e-03,
-9.631568435801754133e-03,
-9.584414288882134661e-03,
-9.537249655117440578e-03,
-9.490074611995850951e-03,
-9.442889237014296527e-03,
-9.395693607677897685e-03,
-9.348487801500221170e-03,
-9.301271896002733658e-03,
-9.254045968714867676e-03,
-9.206810097174233237e-03,
-9.159564358925890992e-03,
-9.112308831522379984e-03,
-9.065043592524140922e-03,
-9.017768719498615859e-03,
-8.970484290020576054e-03,
-8.923190381671768090e-03,
-8.875887072041271225e-03,
-8.828574438724685544e-03,
-8.781252559324300225e-03,
-8.733921511449393646e-03,
-8.686581372715308780e-03,
-8.639232220743904220e-03,
-8.591874133163089275e-03,
-8.544507187607445001e-03,
-8.497131461716697642e-03,
-8.449747033136799368e-03,
-8.402353979519728774e-03,
-8.354952378522614853e-03,
-8.307542307808106485e-03,
-8.260123845044540711e-03,
-8.212697067905120468e-03,
-8.165262054068225112e-03,
-8.117818881217101629e-03,
-8.070367627040244546e-03,
-8.022908369230426218e-03,
-7.975441185485050710e-03,
-7.927966153506346356e-03,
-7.880483351000520942e-03,
-7.832992855678056615e-03,
-7.785494745253486101e-03,
-7.737989097445637302e-03,
-7.690475989976922055e-03,
-7.642955500573097617e-03,
-7.595427706964255447e-03,
-7.547892686883431700e-03,
-7.500350518067010544e-03,
-7.452801278254993049e-03,
-7.405245045190002318e-03,
-7.357681896617825588e-03,
-7.310111910286946728e-03,
-7.262535163948909654e-03,
-7.214951735357437966e-03,
-7.167361702268789693e-03,
-7.119765142441877859e-03,
-7.072162133637423936e-03,
-7.024552753618430560e-03,
-6.976937080149662844e-03,
-6.929315190998100275e-03,
-6.881687163932088437e-03,
-6.834053076721669472e-03,
-6.786413007138292382e-03,
-6.738767032954780072e-03,
-6.691115231945014494e-03,
-6.643457681884339106e-03,
-6.595794460548705385e-03,
-6.548125645714939977e-03,
-6.500451315160520049e-03,
-6.452771546663853448e-03,
-6.405086418003393990e-03,
-6.357396006957964987e-03,
-6.309700391306959609e-03,
-6.261999648829440560e-03,
-6.214293857304587637e-03,
-6.166583094511235430e-03,
-6.118867438228360774e-03,
-6.071146966234088754e-03,
-6.023421756306123788e-03,
-5.975691886221519769e-03,
-5.927957433756508333e-03,
-5.880218476686276813e-03,
-5.832475092785355947e-03,
-5.784727359826700478e-03,
-5.736975355582139315e-03,
-5.689219157821858580e-03,
-5.641458844314975810e-03,
-5.593694492828486103e-03,
-5.545926181127622083e-03,
-5.498153986976033435e-03,
-5.450377988134995008e-03,
-5.402598262363708659e-03,
-5.354814887418903394e-03,
-5.307027941055348849e-03,
-5.259237501024825734e-03,
-5.211443645076471905e-03,
-5.163646450957105026e-03,
-5.115845996409885965e-03,
-5.068042359175284166e-03,
-5.020235616990874686e-03,
-4.972425847590535020e-03,
-4.924613128704853626e-03,
-4.876797538060741351e-03,
-4.828979153381833880e-03,
-4.781158052387572341e-03,
-4.733334312793490394e-03,
-4.685508012311433677e-03,
-4.637679228648718469e-03,
-4.589848039508486431e-03,
-4.542014522589343795e-03,
-4.494178755585699625e-03,
-4.446340816186934893e-03,
-4.398500782077659210e-03,
-4.350658730937909460e-03,
-4.302814740442469782e-03,
-4.254968888260504678e-03,
-4.207121252056720412e-03,
-4.159271909489872278e-03,
-4.111420938213285019e-03,
-4.063568415874521493e-03,
-4.015714420115739161e-03,
-3.967859028572764610e-03,
-3.920002318875437028e-03,
-3.872144368647754357e-03,
-3.824285255507123456e-03,
-3.776425057064598627e-03,
-3.728563850924606661e-03,
-3.680701714685294650e-03,
-3.632838725937647447e-03,
-3.584974962265721418e-03,
-3.537110501246954961e-03,
-3.489245420451253868e-03,
-3.441379797441330469e-03,
-3.393513709772518448e-03,
-3.345647234992627991e-03,
-3.297780450641820890e-03,
-3.249913434252349031e-03,
-3.202046263348936033e-03,
-3.154179015447931573e-03,
-3.106311768057503503e-03,
-3.058444598677971353e-03,
-3.010577584800838355e-03,
-2.962710803909233796e-03,
-2.914844333477522274e-03,
-2.866978250971672759e-03,
-2.819112633848400336e-03,
-2.771247559555385220e-03,
-2.723383105531575026e-03,
-2.675519349206267102e-03,
-2.627656367999480196e-03,
-2.579794239321762332e-03,
-2.531933040573995652e-03,
-2.484072849147206906e-03,
-2.436213742422920891e-03,
-2.388355797772266208e-03,
-2.340499092556374248e-03,
-2.292643704126017500e-03,
-2.244789709821973407e-03,
-2.196937186974123185e-03,
-2.149086212901884629e-03,
-2.101236864913771495e-03,
-2.053389220307863181e-03,
-2.005543356370818094e-03,
-1.957699350378207161e-03,
-1.909857279594751912e-03,
-1.862017221273433703e-03,
-1.814179252655864077e-03,
-1.766343450971938258e-03,
-1.718509893440334961e-03,
-1.670678657266961437e-03,
-1.622849819646695344e-03,
-1.575023457761757801e-03,
-1.527199648782316633e-03,
-1.479378469866036213e-03,
-1.431559998158533475e-03,
-1.383744310792430973e-03,
-1.335931484887769964e-03,
-1.288121597551634837e-03,
-1.240314725878543644e-03,
-1.192510946949541925e-03,
-1.144710337832475925e-03,
-1.096912975582264946e-03,
-1.049118937239977610e-03,
-1.001328299833254042e-03,
-9.535411403759018988e-04,
-9.057575358683189921e-04,
-8.579775632965682460e-04,
-8.102012996327822127e-04,
-7.624288218349148990e-04,
-7.146602068466170830e-04,
-6.668955315969778402e-04,
-6.191348730009406604e-04,
-5.713783079583724432e-04,
-5.236259133543560160e-04,
-4.758777660594523478e-04,
-4.281339429287880850e-04,
-3.803945208024654885e-04,
-3.326595765051670243e-04,
-2.849291868465779866e-04,
-2.372034286204537307e-04,
-1.894823786050394223e-04,
-1.417661135626760384e-04,
-9.405471024021179460e-05,
-4.634824536808491736e-05,
 1.353204339268211485e-06,
 4.904956218380133315e-05,
 9.674075148331383496e-05,
 1.444266955730355464e-04,
 1.921073178038871653e-04,
 2.397825415441961941e-04,
 2.874522901786251048e-04,
 3.351164871093523061e-04,
 3.827750557549978614e-04,
 4.304279195522124689e-04,
 4.780750019545931232e-04,
 5.257162264328141960e-04,
 5.733515164760687741e-04,
 6.209807955903417966e-04,
 6.686039873001080238e-04,
 7.162210151471425047e-04,
 7.638318026922223409e-04,
 8.114362735133987935e-04,
 8.590343512077058775e-04,
 9.066259593899533191e-04,
 9.542110216944390535e-04,
 1.001789461773222633e-03,
 1.049361203297821893e-03,
 1.096926169958158679e-03,
 1.144484285463721104e-03,
 1.192035473542508084e-03,
 1.239579657942728062e-03,
 1.287116762431075130e-03,
 1.334646710794166894e-03,
 1.382169426838656149e-03,
 1.429684834390194817e-03,
 1.477192857294958766e-03,
 1.524693419418495736e-03,
 1.572186444647395882e-03,
 1.619671856887583937e-03,
 1.667149580066010564e-03,
 1.714619538129457136e-03,
 1.762081655046251810e-03,
 1.809535854804510298e-03,
 1.856982061413887074e-03,
 1.904420198904460812e-03,
 1.951850191327938284e-03,
 1.999271962756583171e-03,
 2.046685437284897005e-03,
 2.094090539027946684e-03,
 2.141487192122713216e-03,
 2.188875320728317451e-03,
 2.236254849024880368e-03,
 2.283625701215089964e-03,
 2.330987801523069346e-03,
 2.378341074196019516e-03,
 2.425685443502483343e-03,
 2.473020833734104577e-03,
 2.520347169204386218e-03,
 2.567664374250536261e-03,
 2.614972373231076383e-03,
 2.662271090528861659e-03,
 2.709560450548724811e-03,
 2.756840377719257332e-03,
 2.804110796491633781e-03,
 2.851371631341339131e-03,
 2.898622806766406722e-03,
 2.945864247288867196e-03,
 2.993095877454859510e-03,
 3.040317621833594879e-03,
 3.087529405018886799e-03,
 3.134731151627961031e-03,
 3.181922786303195087e-03,
 3.229104233710307185e-03,
 3.276275418540155158e-03,
 3.323436265507492653e-03,
 3.370586699352742452e-03,
 3.417726644839733530e-03,
 3.464856026758623194e-03,
 3.511974769923544796e-03,
 3.559082799174412715e-03,
 3.606180039375794354e-03,
 3.653266415418532538e-03,
 3.700341852218043317e-03,
 3.747406274716035945e-03,
 3.794459607879266047e-03,
 3.841501776701195751e-03,
 3.888532706200799761e-03,
 3.935552321422773961e-03,
 3.982560547438944443e-03,
 4.029557309346557502e-03,
 4.076542532269929360e-03,
 4.123516141359294743e-03,
 4.170478061792624001e-03,
 4.217428218773252614e-03,
 4.264366537532839757e-03,
 4.311292943329046376e-03,
 4.358207361447339299e-03,
 4.405109717199791677e-03,
 4.451999935926801225e-03,
 4.498877942995307792e-03,
 4.545743663800536766e-03,
 4.592597023764834197e-03,
 4.639437948339123104e-03,
 4.686266363001968457e-03,
 4.733082193259581516e-03,
 4.779885364647304749e-03,
 4.826675802727877114e-03,
 4.873453433093171382e-03,
 4.920218181362919982e-03,
 4.966969973186554678e-03,
 5.013708734240912394e-03,
 5.060434390233143481e-03,
 5.107146866898389787e-03,
 5.153846090001515910e-03,
 5.200531985336096993e-03,
 5.247204478725896702e-03,
 5.293863496023309446e-03,
 5.340508963110964999e-03,
 5.387140805900560159e-03,
 5.433758950334519749e-03,
 5.480363322384346030e-03,
 5.526953848051978715e-03,
 5.573530453369913810e-03,
 5.620093064400200067e-03,
 5.666641607235915236e-03,
 5.713176008000061049e-03,
 5.759696192847294470e-03,
 5.806202087961588425e-03,
 5.852693619559270165e-03,
 5.899170713886570105e-03,
 5.945633297221505735e-03,
 5.992081295872677717e-03,
 6.038514636180921345e-03,
 6.084933244517596977e-03,
 6.131337047286305672e-03,
 6.177725970921699172e-03,
 6.224099941891073247e-03,
 6.270458886692842002e-03,
 6.316802731857732237e-03,
 6.363131403949034114e-03,
 6.409444829561537771e-03,
 6.455742935323045134e-03,
 6.502025647893347297e-03,
 6.548292893965295715e-03,
 6.594544600263924430e-03,
 6.640780693547868214e-03,
 6.687001100607894120e-03,
 6.733205748268475746e-03,
 6.779394563386573723e-03,
 6.825567472853336613e-03,
 6.871724403592491953e-03,
 6.917865282561851126e-03,
 6.963990036752236434e-03,
 7.010098593189129958e-03,
 7.056190878930935356e-03,
 7.102266821070746423e-03,
 7.148326346735036502e-03,
 7.194369383085248357e-03,
 7.240395857316824467e-03,
 7.286405696659283351e-03,
 7.332398828377299435e-03,
 7.378375179769455783e-03,
 7.424334678170079437e-03,
 7.470277250947465059e-03,
 7.516202825505502970e-03,
 7.562111329282643520e-03,
 7.608002689753333436e-03,
 7.653876834426536109e-03,
 7.699733690847324064e-03,
 7.745573186595614348e-03,
 7.791395249287950096e-03,
 7.837199806575725902e-03,
 7.882986786146942496e-03,
 7.928756115724858861e-03,
 7.974507723069733031e-03,
 8.020241535977645081e-03,
 8.065957482280746924e-03,
 8.111655489848133144e-03,
 8.157335486584947615e-03,
 8.202997400433786890e-03,
 8.248641159373211809e-03,
 8.294266691419345180e-03,
 8.339873924624647064e-03,
 8.385462787079661640e-03,
 8.431033206911228706e-03,
 8.476585112284201057e-03,
 8.522118431400275279e-03,
 8.567633092499679637e-03,
 8.613129023859284958e-03,
 8.658606153794531912e-03,
 8.704064410658138642e-03,
 8.749503722841797324e-03,
 8.794924018773983207e-03,
 8.840325226922712831e-03,
 8.885707275793798890e-03,
 8.931070093931139930e-03,
 8.976413609918201808e-03,
 9.021737752376163266e-03,
 9.067042449965662804e-03,
 9.112327631385629470e-03,
 9.157593225374932588e-03,
 9.202839160710601929e-03,
 9.248065366209626617e-03,
 9.293271770727714806e-03,
 9.338458303160894827e-03,
 9.383624892443945265e-03,
 9.428771467551848653e-03,
 9.473897957498880751e-03,
 9.519004291340159643e-03,
 9.564090398169473872e-03,
 9.609156207121948706e-03,
 9.654201647372542133e-03,
 9.699226648136060475e-03,
 9.744231138668735248e-03,
 9.789215048266453750e-03,
 9.834178306266419187e-03,
 9.879120842045915549e-03,
 9.924042585024174176e-03,
 9.968943464660411785e-03,
 1.001382341045559295e-02,
 1.005868235195135456e-02,
 1.010352021873148730e-02,
 1.014833694042032060e-02,
 1.019313244668444175e-02,
 1.023790666723155100e-02,
 1.028265953181158043e-02,
 1.032739097021576243e-02,
 1.037210091227819958e-02,
 1.041678928787417857e-02,
 1.046145602692159435e-02,
 1.050610105938098657e-02,
 1.055072431525462019e-02,
 1.059532572458784377e-02,
 1.063990521746810240e-02,
 1.068446272402636711e-02,
 1.072899817443562741e-02,
 1.077351149891249936e-02,
 1.081800262771592629e-02,
 1.086247149114909390e-02,
 1.090691801955735903e-02,
 1.095134214333028967e-02,
 1.099574379290030324e-02,
 1.104012289874407513e-02,
 1.108447939138124290e-02,
 1.112881320137621734e-02,
 1.117312425933636097e-02,
 1.121741249591358749e-02,
 1.126167784180420739e-02,
 1.130592022774807963e-02,
 1.135013958452999253e-02,
 1.139433584297870616e-02,
 1.143850893396827079e-02,
 1.148265878841662514e-02,
 1.152678533728707447e-02,
 1.157088851158720802e-02,
 1.161496824237046727e-02,
 1.165902446073450484e-02,
 1.170305709782289323e-02,
 1.174706608482389315e-02,
 1.179105135297177191e-02,
 1.183501283354572615e-02,
 1.187895045787126271e-02,
 1.192286415731902763e-02,
 1.196675386330570308e-02,
 1.201061950729429353e-02,
 1.205446102079319078e-02,
 1.209827833535753391e-02,
 1.214207138258806794e-02,
 1.218584009413283681e-02,
 1.222958440168542618e-02,
 1.227330423698673803e-02,
 1.231699953182359072e-02,
 1.236067021803051100e-02,
 1.240431622748812412e-02,
 1.244793749212461630e-02,
 1.249153394391473888e-02,
 1.253510551488104009e-02,
 1.257865213709269230e-02,
 1.262217374266714175e-02,
 1.266567026376858897e-02,
 1.270914163260941469e-02,
 1.275258778144906791e-02,
 1.279600864259560628e-02,
 1.283940414840471778e-02,
 1.288277423127961487e-02,
 1.292611882367271023e-02,
 1.296943785808370685e-02,
 1.301273126706122517e-02,
 1.305599898320178656e-02,
 1.309924093915144395e-02,
 1.314245706760361690e-02,
 1.318564730130173356e-02,
 1.322881157303718372e-02,
 1.327194981565092170e-02,
 1.331506196203238387e-02,
 1.335814794512105164e-02,
 1.340120769790473579e-02,
 1.344424115342136503e-02,
 1.348724824475774735e-02,
 1.353022890505089885e-02,
 1.357318306748719026e-02,
 1.361611066530254988e-02,
 1.365901163178346624e-02,
 1.370188590026575649e-02,
 1.374473340413578069e-02,
 1.378755407682966290e-02,
 1.383034785183461304e-02,
 1.387311466268707771e-02,
 1.391585444297527112e-02,
 1.395856712633702576e-02,
 1.400125264646159134e-02,
 1.404391093708834415e-02,
 1.408654193200837602e-02,
 1.412914556506306152e-02,
 1.417172177014544392e-02,
 1.421427048119913543e-02,
 1.425679163221999814e-02,
 1.429928515725443529e-02,
 1.434175099040068194e-02,
 1.438418906580904259e-02,
 1.442659931768078101e-02,
 1.446898168026954090e-02,
 1.451133608788037280e-02,
 1.455366247487122761e-02,
 1.459596077565095129e-02,
 1.463823092468187134e-02,
 1.468047285647760408e-02,
 1.472268650560498368e-02,
 1.476487180668263795e-02,
 1.480702869438265713e-02,
 1.484915710342906911e-02,
 1.489125696859926011e-02,
 1.493332822472297379e-02,
 1.497537080668384993e-02,
 1.501738464941773654e-02,
 1.505936968791408807e-02,
 1.510132585721606080e-02,
 1.514325309241953792e-02,
 1.518515132867449650e-02,
 1.522702050118375158e-02,
 1.526886054520514013e-02,
 1.531067139604873686e-02,
 1.535245298907983620e-02,
 1.539420525971699205e-02,
 1.543592814343326507e-02,
 1.547762157575547672e-02,
 1.551928549226533685e-02,
 1.556091982859851043e-02,
 1.560252452044538600e-02,
 1.564409950355063333e-02,
 1.568564471371422173e-02,
 1.572716008679024557e-02,
 1.576864555868823237e-02,
 1.581010106537212787e-02,
 1.585152654286163185e-02,
 1.589292192723132033e-02,
 1.593428715461065598e-02,
 1.597562216118543488e-02,
 1.601692688319560423e-02,
 1.605820125693811079e-02,
 1.609944521876440632e-02,
 1.614065870508250150e-02,
 1.618184165235552613e-02,
 1.622299399710351586e-02,
 1.626411567590169485e-02,
 1.630520662538207516e-02,
 1.634626678223210713e-02,
 1.638729608319661191e-02,
 1.642829446507611604e-02,
 1.646926186472806933e-02,
 1.651019821906593577e-02,
 1.655110346506086585e-02,
 1.659197753974021514e-02,
 1.663282038018813747e-02,
 1.667363192354631707e-02,
 1.671441210701291036e-02,
 1.675516086784402392e-02,
 1.679587814335231979e-02,
 1.683656387090849346e-02,
 1.687721798794001096e-02,
 1.691784043193282627e-02,
 1.695843114042977842e-02,
 1.699899005103197927e-02,
 1.703951710139792186e-02,
 1.708001222924475024e-02,
 1.712047537234692371e-02,
 1.716090646853763932e-02,
 1.720130545570779448e-02,
 1.724167227180744763e-02,
 1.728200685484387183e-02,
 1.732230914288402160e-02,
 1.736257907405298895e-02,
 1.740281658653425670e-02,
 1.744302161857099256e-02,
 1.748319410846429015e-02,
 1.752333399457485508e-02,
 1.756344121532206828e-02,
 1.760351570918508926e-02,
 1.764355741470163830e-02,
 1.768356627046936344e-02,
 1.772354221514473027e-02,
 1.776348518744474622e-02,
 1.780339512614504890e-02,
 1.784327197008163737e-02,
 1.788311565814989026e-02,
 1.792292612930579052e-02,
 1.796270332256429472e-02,
 1.800244717700149460e-02,
 1.804215763175324311e-02,
 1.808183462601533828e-02,
 1.812147809904468207e-02,
 1.816108799015797234e-02,
 1.820066423873298311e-02,
 1.824020678420750288e-02,
 1.827971556608099304e-02,
 1.831919052391287397e-02,
 1.835863159732407240e-02,
 1.839803872599591120e-02,
 1.843741184967170529e-02,
 1.847675090815507903e-02,
 1.851605584131155516e-02,
 1.855532658906761806e-02,
 1.859456309141183442e-02,
 1.863376528839327459e-02,
 1.867293312012388573e-02,
 1.871206652677638235e-02,
 1.875116544858576248e-02,
 1.879022982584914112e-02,
 1.882925959892504247e-02,
 1.886825470823469061e-02,
 1.890721509426091657e-02,
 1.894614069754943508e-02,
 1.898503145870782810e-02,
 1.902388731840651617e-02,
 1.906270821737798479e-02,
 1.910149409641798135e-02,
 1.914024489638444654e-02,
 1.917896055819848927e-02,
 1.921764102284378301e-02,
 1.925628623136727002e-02,
 1.929489612487867572e-02,
 1.933347064455144537e-02,
 1.937200973162150550e-02,
 1.941051332738868984e-02,
 1.944898137321632650e-02,
 1.948741381053073832e-02,
 1.952581058082240167e-02,
 1.956417162564479811e-02,
 1.960249688661611089e-02,
 1.964078630541757700e-02,
 1.967903982379492350e-02,
 1.971725738355733365e-02,
 1.975543892657903589e-02,
 1.979358439479754136e-02,
 1.983169373021521215e-02,
 1.986976687489855689e-02,
 1.990780377097872353e-02,
 1.994580436065107598e-02,
 1.998376858617624541e-02,
 2.002169638987907549e-02,
 2.005958771414926081e-02,
 2.009744250144189504e-02,
 2.013526069427642659e-02,
 2.017304223523779319e-02,
 2.021078706697572447e-02,
 2.024849513220578628e-02,
 2.028616637370836071e-02,
 2.032380073432943704e-02,
 2.036139815698038286e-02,
 2.039895858463855460e-02,
 2.043648196034639555e-02,
 2.047396822721268134e-02,
 2.051141732841150339e-02,
 2.054882920718342776e-02,
 2.058620380683435364e-02,
 2.062354107073718912e-02,
 2.066084094233021362e-02,
 2.069810336511832341e-02,
 2.073532828267256323e-02,
 2.077251563863080630e-02,
 2.080966537669729638e-02,
 2.084677744064241181e-02,
 2.088385177430400128e-02,
 2.092088832158599601e-02,
 2.095788702645972820e-02,
 2.099484783296284851e-02,
 2.103177068520078671e-02,
 2.106865552734537780e-02,
 2.110550230363622201e-02,
 2.114231095837954683e-02,
 2.117908143594966763e-02,
 2.121581368078749932e-02,
 2.125250763740249224e-02,
 2.128916325037075868e-02,
 2.132578046433668967e-02,
 2.136235922401190368e-02,
 2.139889947417650956e-02,
 2.143540115967820098e-02,
 2.147186422543233622e-02,
 2.150828861642327047e-02,
 2.154467427770264190e-02,
 2.158102115439085658e-02,
 2.161732919167614134e-02,
 2.165359833481594193e-02,
 2.168982852913546588e-02,
 2.172601972002896620e-02,
 2.176217185295898499e-02,
 2.179828487345711330e-02,
 2.183435872712348458e-02,
 2.187039335962746855e-02,
 2.190638871670715429e-02,
 2.194234474416981856e-02,
 2.197826138789171421e-02,
 2.201413859381858365e-02,
 2.204997630796519045e-02,
 2.208577447641579469e-02,
 2.212153304532446865e-02,
 2.215725196091401436e-02,
 2.219293116947777811e-02,
 2.222857061737789144e-02,
 2.226417025104724529e-02,
 2.229973001698755397e-02,
 2.233524986177147509e-02,
 2.237072973204085047e-02,
 2.240616957450811825e-02,
 2.244156933595555306e-02,
 2.247692896323614728e-02,
 2.251224840327265345e-02,
 2.254752760305879164e-02,
 2.258276650965810803e-02,
 2.261796507020548408e-02,
 2.265312323190583552e-02,
 2.268824094203493805e-02,
 2.272331814793972227e-02,
 2.275835479703743752e-02,
 2.279335083681680724e-02,
 2.282830621483689440e-02,
 2.286322087872893344e-02,
 2.289809477619406813e-02,
 2.293292785500581493e-02,
 2.296772006300827965e-02,
 2.300247134811754524e-02,
 2.303718165832034648e-02,
 2.307185094167623837e-02,
 2.310647914631520222e-02,
 2.314106622043970302e-02,
 2.317561211232355839e-02,
 2.321011677031285456e-02,
 2.324458014282520385e-02,
 2.327900217835065025e-02,
 2.331338282545083671e-02,
 2.334772203276007721e-02,
 2.338201974898490923e-02,
 2.341627592290353513e-02,
 2.345049050336761934e-02,
 2.348466343930013731e-02,
 2.351879467969764104e-02,
 2.355288417362852091e-02,
 2.358693187023442120e-02,
 2.362093771872926518e-02,
 2.365490166840038613e-02,
 2.368882366860752819e-02,
 2.372270366878382816e-02,
 2.375654161843500714e-02,
 2.379033746714041483e-02,
 2.382409116455242587e-02,
 2.385780266039667918e-02,
 2.389147190447191496e-02,
 2.392509884665102587e-02,
 2.395868343687974564e-02,
 2.399222562517745738e-02,
 2.402572536163785286e-02,
 2.405918259642711443e-02,
 2.409259727978659005e-02,
 2.412596936203059358e-02,
 2.415929879354775794e-02,
 2.419258552480034463e-02,
 2.422582950632545112e-02,
 2.425903068873351207e-02,
 2.429218902270974603e-02,
 2.432530445901329164e-02,
 2.435837694847813734e-02,
 2.439140644201216387e-02,
 2.442439289059824756e-02,
 2.445733624529334779e-02,
 2.449023645722995038e-02,
 2.452309347761399277e-02,
 2.455590725772737598e-02,
 2.458867774892661492e-02,
 2.462140490264243600e-02,
 2.465408867038152568e-02,
 2.468672900372512191e-02,
 2.471932585432987800e-02,
 2.475187917392726242e-02,
 2.478438891432471758e-02,
 2.481685502740434493e-02,
 2.484927746512420946e-02,
 2.488165617951729192e-02,
 2.491399112269305355e-02,
 2.494628224683572218e-02,
 2.497852950420566959e-02,
 2.501073284713878700e-02,
 2.504289222804732470e-02,
 2.507500759941878876e-02,
 2.510707891381723164e-02,
 2.513910612388248547e-02,
 2.517108918233035286e-02,
 2.520302804195330426e-02,
 2.523492265561961059e-02,
 2.526677297627424532e-02,
 2.529857895693810380e-02,
 2.533034055070914822e-02,
 2.536205771076134249e-02,
 2.539373039034558549e-02,
 2.542535854278911781e-02,
 2.545694212149641339e-02,
 2.548848107994826709e-02,
 2.551997537170263772e-02,
 2.555142495039412071e-02,
 2.558282976973487791e-02,
 2.561418978351332615e-02,
 2.564550494559588931e-02,
 2.567677520992534684e-02,
 2.570800053052233608e-02,
 2.573918086148483872e-02,
 2.577031615698785819e-02,
 2.580140637128417597e-02,
 2.583245145870364731e-02,
 2.586345137365466187e-02,
 2.589440607062216612e-02,
 2.592531550416969990e-02,
 2.595617962893797398e-02,
 2.598699839964590391e-02,
 2.601777177109038108e-02,
 2.604849969814609922e-02,
 2.607918213576556829e-02,
 2.610981903898026632e-02,
 2.614041036289874165e-02,
 2.617095606270872926e-02,
 2.620145609367555833e-02,
 2.623191041114343591e-02,
 2.626231897053509651e-02,
 2.629268172735095208e-02,
 2.632299863717100716e-02,
 2.635326965565298885e-02,
 2.638349473853426191e-02,
 2.641367384163009063e-02,
 2.644380692083498144e-02,
 2.647389393212210007e-02,
 2.650393483154400362e-02,
 2.653392957523173154e-02,
 2.656387811939573546e-02,
 2.659378042032518180e-02,
 2.662363643438928409e-02,
 2.665344611803520045e-02,
 2.668320942779082647e-02,
 2.671292632026234931e-02,
 2.674259675213588872e-02,
 2.677222068017725068e-02,
 2.680179806123123357e-02,
 2.683132885222269670e-02,
 2.686081301015602954e-02,
 2.689025049211553331e-02,
 2.691964125526495263e-02,
 2.694898525684840188e-02,
 2.697828245418929308e-02,
 2.700753280469184864e-02,
 2.703673626583954701e-02,
 2.706589279519655902e-02,
 2.709500235040684588e-02,
 2.712406488919471073e-02,
 2.715308036936470507e-02,
 2.718204874880207969e-02,
 2.721096998547203882e-02,
 2.723984403742052765e-02,
 2.726867086277367375e-02,
 2.729745041973870995e-02,
 2.732618266660333597e-02,
 2.735486756173555536e-02,
 2.738350506358479611e-02,
 2.741209513068079695e-02,
 2.744063772163434292e-02,
 2.746913279513706063e-02,
 2.749758030996203584e-02,
 2.752598022496278649e-02,
 2.755433249907435558e-02,
 2.758263709131256874e-02,
 2.761089396077509583e-02,
 2.763910306664031299e-02,
 2.766726436816815959e-02,
 2.769537782470005843e-02,
 2.772344339565886023e-02,
 2.775146104054867016e-02,
 2.777943071895560764e-02,
 2.780735239054711594e-02,
 2.783522601507234379e-02,
 2.786305155236247499e-02,
 2.789082896232993047e-02,
 2.791855820496946805e-02,
 2.794623924035757531e-02,
 2.797387202865287206e-02,
 2.800145653009582236e-02,
 2.802899270500895657e-02,
 2.805648051379686439e-02,
 2.808391991694682288e-02,
 2.811131087502751272e-02,
 2.813865334869076335e-02,
 2.816594729867022417e-02,
 2.819319268578227011e-02,
 2.822038947092535624e-02,
 2.824753761508091293e-02,
 2.827463707931254788e-02,
 2.830168782476662204e-02,
 2.832868981267241959e-02,
 2.835564300434164492e-02,
 2.838254736116894994e-02,
 2.840940284463166696e-02,
 2.843620941629035337e-02,
 2.846296703778818799e-02,
 2.848967567085149144e-02,
 2.851633527728962558e-02,
 2.854294581899498306e-02,
 2.856950725794314694e-02,
 2.859601955619319597e-02,
 2.862248267588711481e-02,
 2.864889657925037691e-02,
 2.867526122859157672e-02,
 2.870157658630320685e-02,
 2.872784261486078031e-02,
 2.875405927682361459e-02,
 2.878022653483466517e-02,
 2.880634435162003973e-02,
 2.883241268999021945e-02,
 2.885843151283874058e-02,
 2.888440078314359963e-02,
 2.891032046396587243e-02,
 2.893619051845128243e-02,
 2.896201090982891690e-02,
 2.898778160141222970e-02,
 2.901350255659831609e-02,
 2.903917373886889808e-02,
 2.906479511178934605e-02,
 2.909036663900955305e-02,
 2.911588828426318887e-02,
 2.914136001136902188e-02,
 2.916678178422926759e-02,
 2.919215356683117768e-02,
 2.921747532324600605e-02,
 2.924274701762977907e-02,
 2.926796861422318805e-02,
 2.929314007735087100e-02,
 2.931826137142289068e-02,
 2.934333246093336761e-02,
 2.936835331046158334e-02,
 2.939332388467131088e-02,
 2.941824414831132120e-02,
 2.944311406621505367e-02,
 2.946793360330121972e-02,
 2.949270272457322345e-02,
 2.951742139511967511e-02,
 2.954208958011385333e-02,
 2.956670724481480841e-02,
 2.959127435456609598e-02,
 2.961579087479690106e-02,
 2.964025677102142403e-02,
 2.966467200883939406e-02,
 2.968903655393588525e-02,
 2.971335037208091764e-02,
 2.973761342913066805e-02,
 2.976182569102607881e-02,
 2.978598712379423863e-02,
 2.981009769354744238e-02,
 2.983415736648364208e-02,
 2.985816610888655451e-02,
 2.988212388712574788e-02,
 2.990603066765621862e-02,
 2.992988641701908176e-02,
 2.995369110184107134e-02,
 2.997744468883511287e-02,
 3.000114714479965722e-02,
 3.002479843661953751e-02,
 3.004839853126524754e-02,
 3.007194739579380910e-02,
 3.009544499734794626e-02,
 3.011889130315672028e-02,
 3.014228628053566145e-02,
 3.016562989688591559e-02,
 3.018892211969561104e-02,
 3.021216291653870331e-02,
 3.023535225507580776e-02,
 3.025849010305388387e-02,
 3.028157642830652321e-02,
 3.030461119875338394e-02,
 3.032759438240119343e-02,
 3.035052594734289830e-02,
 3.037340586175847623e-02,
 3.039623409391419007e-02,
 3.041901061216318800e-02,
 3.044173538494532663e-02,
 3.046440838078750407e-02,
 3.048702956830328867e-02,
 3.050959891619297107e-02,
 3.053211639324419566e-02,
 3.055458196833120421e-02,
 3.057699561041538061e-02,
 3.059935728854532716e-02,
 3.062166697185650377e-02,
 3.064392462957146387e-02,
 3.066613023100039220e-02,
 3.068828374554012986e-02,
 3.071038514267537475e-02,
 3.073243439197727994e-02,
 3.075443146310531672e-02,
 3.077637632580557461e-02,
 3.079826894991212829e-02,
 3.082010930534591700e-02,
 3.084189736211605248e-02,
 3.086363309031846247e-02,
 3.088531646013755946e-02,
 3.090694744184436030e-02,
 3.092852600579812719e-02,
 3.095005212244603468e-02,
 3.097152576232238205e-02,
 3.099294689604966194e-02,
 3.101431549433776233e-02,
 3.103563152798528846e-02,
 3.105689496787778295e-02,
 3.107810578498908932e-02,
 3.109926395038105709e-02,
 3.112036943520362503e-02,
 3.114142221069447422e-02,
 3.116242224817955195e-02,
 3.118336951907291210e-02,
 3.120426399487696151e-02,
 3.122510564718172441e-02,
 3.124589444766606369e-02,
 3.126663036809659846e-02,
 3.128731338032868931e-02,
 3.130794345630580344e-02,
 3.132852056805969510e-02,
 3.134904468771081837e-02,
 3.136951578746765418e-02,
 3.138993383962763312e-02,
 3.141029881657630279e-02,
 3.143061069078791070e-02,
 3.145086943482523073e-02,
 3.147107502133993789e-02,
 3.149122742307184503e-02,
 3.151132661284998526e-02,
 3.153137256359170998e-02,
 3.155136524830345901e-02,
 3.157130464008010146e-02,
 3.159119071210565038e-02,
 3.161102343765295752e-02,
 3.163080279008331774e-02,
 3.165052874284772499e-02,
 3.167020126948552616e-02,
 3.168982034362527456e-02,
 3.170938593898448010e-02,
 3.172889802936978282e-02,
 3.174835658867704996e-02,
 3.176776159089107071e-02,
 3.178711301008563250e-02,
 3.180641082042431900e-02,
 3.182565499615917087e-02,
 3.184484551163221933e-02,
 3.186398234127427870e-02,
 3.188306545960582078e-02,
 3.190209484123619765e-02,
 3.192107046086472416e-02,
 3.193999229327970646e-02,
 3.195886031335929550e-02,
 3.197767449607061968e-02,
 3.199643481647075627e-02,
 3.201514124970616243e-02,
 3.203379377101259196e-02,
 3.205239235571627487e-02,
 3.207093697923195375e-02,
 3.208942761706479185e-02,
 3.210786424480929074e-02,
 3.212624683815012983e-02,
 3.214457537286104227e-02,
 3.216284982480630689e-02,
 3.218107016993911051e-02,
 3.219923638430376850e-02,
 3.221734844403296993e-02,
 3.223540632535066425e-02,
 3.225341000456987545e-02,
 3.227135945809395112e-02,
 3.228925466241588244e-02,
 3.230709559411921311e-02,
 3.232488222987724147e-02,
 3.234261454645308981e-02,
 3.236029252070069667e-02,
 3.237791612956334580e-02,
 3.239548535007491514e-02,
 3.241300015935933559e-02,
 3.243046053463112532e-02,
 3.244786645319439750e-02,
 3.246521789244394274e-02,
 3.248251482986480587e-02,
 3.249975724303232755e-02,
 3.251694510961206097e-02,
 3.253407840736048662e-02,
 3.255115711412374935e-02,
 3.256818120783887965e-02,
 3.258515066653320386e-02,
 3.260206546832469798e-02,
 3.261892559142166859e-02,
 3.263573101412298172e-02,
 3.265248171481825029e-02,
 3.266917767198748712e-02,
 3.268581886420139637e-02,
 3.270240527012115844e-02,
 3.271893686849906141e-02,
 3.273541363817755734e-02,
 3.275183555809010882e-02,
 3.276820260726079348e-02,
 3.278451476480471333e-02,
 3.280077200992731479e-02,
 3.281697432192515890e-02,
 3.283312168018572702e-02,
 3.284921406418726125e-02,
 3.286525145349851462e-02,
 3.288123382777979192e-02,
 3.289716116678190194e-02,
 3.291303345034667788e-02,
 3.292885065840729653e-02,
 3.294461277098723745e-02,
 3.296031976820162218e-02,
 3.297597163025623584e-02,
 3.299156833744838757e-02,
 3.300710987016582804e-02,
 3.302259620888799152e-02,
 3.303802733418502446e-02,
 3.305340322671875691e-02,
 3.306872386724165475e-02,
 3.308398923659768009e-02,
 3.309919931572194440e-02,
 3.311435408564078475e-02,
 3.312945352747195121e-02,
 3.314449762242432929e-02,
 3.315948635179810644e-02,
 3.317441969698499415e-02,
 3.318929763946750627e-02,
 3.320412016082043005e-02,
 3.321888724270934817e-02,
 3.323359886689109671e-02,
 3.324825501521436882e-02,
 3.326285566961928453e-02,
 3.327740081213700907e-02,
 3.329189042489065498e-02,
 3.330632449009475471e-02,
 3.332070299005501085e-02,
 3.333502590716933695e-02,
 3.334929322392641421e-02,
 3.336350492290739850e-02,
 3.337766098678424803e-02,
 3.339176139832090301e-02,
 3.340580614037318846e-02,
 3.341979519588818281e-02,
 3.343372854790467585e-02,
 3.344760617955342547e-02,
 3.346142807405670661e-02,
 3.347519421472861662e-02,
 3.348890458497504746e-02,
 3.350255916829335961e-02,
 3.351615794827320083e-02,
 3.352970090859543062e-02,
 3.354318803303320967e-02,
 3.355661930545138921e-02,
 3.356999470980666367e-02,
 3.358331423014739719e-02,
 3.359657785061431062e-02,
 3.360978555543951696e-02,
 3.362293732894744425e-02,
 3.363603315555403067e-02,
 3.364907301976779314e-02,
 3.366205690618858520e-02,
 3.367498479950851997e-02,
 3.368785668451181048e-02,
 3.370067254607439500e-02,
 3.371343236916458930e-02,
 3.372613613884239275e-02,
 3.373878384026021693e-02,
 3.375137545866225414e-02,
 3.376391097938485908e-02,
 3.377639038785651415e-02,
 3.378881366959800292e-02,
 3.380118081022179949e-02,
 3.381349179543299138e-02,
 3.382574661102848851e-02,
 3.383794524289764072e-02,
 3.385008767702161331e-02,
 3.386217389947417111e-02,
 3.387420389642080421e-02,
 3.388617765412006017e-02,
 3.389809515892167752e-02,
 3.390995639726836902e-02,
 3.392176135569489187e-02,
 3.393351002082821422e-02,
 3.394520237938766782e-02,
 3.395683841818478849e-02,
 3.396841812412367684e-02,
 3.397994148420047100e-02,
 3.399140848550374211e-02,
 3.400281911521421674e-02,
 3.401417336060554714e-02,
 3.402547120904308303e-02,
 3.403671264798491247e-02,
 3.404789766498136916e-02,
 3.405902624767531001e-02,
 3.407009838380197636e-02,
 3.408111406118899400e-02,
 3.409207326775630376e-02,
 3.410297599151645292e-02,
 3.411382222057456753e-02,
 3.412461194312767926e-02,
 3.413534514746604381e-02,
 3.414602182197165603e-02,
 3.415664195511970008e-02,
 3.416720553547715478e-02,
 3.417771255170425071e-02,
 3.418816299255297841e-02,
 3.419855684686854552e-02,
 3.420889410358816246e-02,
 3.421917475174179185e-02,
 3.422939878045196116e-02,
 3.423956617893381821e-02,
 3.424967693649486056e-02,
 3.425973104253544899e-02,
 3.426972848654823850e-02,
 3.427966925811857385e-02,
 3.428955334692447565e-02,
 3.429938074273654325e-02,
 3.430915143541800327e-02,
 3.431886541492448761e-02,
 3.432852267130456769e-02,
 3.433812319469924795e-02,
 3.434766697534230584e-02,
 3.435715400355977139e-02,
 3.436658426977103054e-02,
 3.437595776448741647e-02,
 3.438527447831345868e-02,
 3.439453440194593231e-02,
 3.440373752617465614e-02,
 3.441288384188176397e-02,
 3.442197334004250264e-02,
 3.443100601172431607e-02,
 3.443998184808769875e-02,
 3.444890084038580713e-02,
 3.445776297996443194e-02,
 3.446656825826203280e-02,
 3.447531666680973828e-02,
 3.448400819723156097e-02,
 3.449264284124417546e-02,
 3.450122059065695301e-02,
 3.450974143737194771e-02,
 3.451820537338416706e-02,
 3.452661239078086419e-02,
 3.453496248174268979e-02,
 3.454325563854253323e-02,
 3.455149185354636221e-02,
 3.455967111921240398e-02,
 3.456779342809226940e-02,
 3.457585877282993991e-02,
 3.458386714616212138e-02,
 3.459181854091859104e-02,
 3.459971295002160080e-02,
 3.460755036648607147e-02,
 3.461533078342016873e-02,
 3.462305419402443574e-02,
 3.463072059159204991e-02,
 3.463832996950955145e-02,
 3.464588232125555972e-02,
 3.465337764040198748e-02,
 3.466081592061324296e-02,
 3.466819715564668780e-02,
 3.467552133935227626e-02,
 3.468278846567288826e-02,
 3.468999852864396161e-02,
 3.469715152239404715e-02,
 3.470424744114406629e-02,
 3.471128627920828241e-02,
 3.471826803099310743e-02,
 3.472519269099813566e-02,
 3.473206025381561646e-02,
 3.473887071413035710e-02,
 3.474562406672051379e-02,
 3.475232030645648840e-02,
 3.475895942830144886e-02,
 3.476554142731183572e-02,
 3.477206629863619641e-02,
 3.477853403751647587e-02,
 3.478494463928681613e-02,
 3.479129809937471507e-02,
 3.479759441329986075e-02,
 3.480383357667495708e-02,
 3.481001558520551570e-02,
 3.481614043468978653e-02,
 3.482220812101881335e-02,
 3.482821864017603131e-02,
 3.483417198823813427e-02,
 3.484006816137424217e-02,
 3.484590715584642839e-02,
 3.485168896800909522e-02,
 3.485741359430991754e-02,
 3.486308103128895469e-02,
 3.486869127557908066e-02,
 3.487424432390585916e-02,
 3.487974017308771713e-02,
 3.488517882003563941e-02,
 3.489056026175319652e-02,
 3.489588449533707198e-02,
 3.490115151797630599e-02,
 3.490636132695262850e-02,
 3.491151391964078532e-02,
 3.491660929350792753e-02,
 3.492164744611391675e-02,
 3.492662837511133905e-02,
 3.493155207824531067e-02,
 3.493641855335401919e-02,
 3.494122779836774523e-02,
 3.494597981130997955e-02,
 3.495067459029635448e-02,
 3.495531213353546274e-02,
 3.495989243932837165e-02,
 3.496441550606901177e-02,
 3.496888133224361483e-02,
 3.497328991643124108e-02,
 3.497764125730354334e-02,
 3.498193535362455198e-02,
 3.498617220425121604e-02,
 3.499035180813277884e-02,
 3.499447416431143015e-02,
 3.499853927192147357e-02,
 3.500254713018997876e-02,
 3.500649773843671209e-02,
 3.501039109607385902e-02,
 3.501422720260599641e-02,
 3.501800605763037699e-02,
 3.502172766083686689e-02,
 3.502539201200779995e-02,
 3.502899911101776259e-02,
 3.503254895783405182e-02,
 3.503604155251651558e-02,
 3.503947689521729608e-02,
 3.504285498618103095e-02,
 3.504617582574503371e-02,
 3.504943941433870391e-02,
 3.505264575248409620e-02,
 3.505579484079577451e-02,
 3.505888667998045827e-02,
 3.506192127083730681e-02,
 3.506489861425829413e-02,
 3.506781871122713334e-02,
 3.507068156282044241e-02,
 3.507348717020688372e-02,
 3.507623553464742083e-02,
 3.507892665749578337e-02,
 3.508156054019762049e-02,
 3.508413718429097966e-02,
 3.508665659140629972e-02,
 3.508911876326625129e-02,
 3.509152370168580615e-02,
 3.509387140857216786e-02,
 3.509616188592486197e-02,
 3.509839513583556253e-02,
 3.510057116048827253e-02,
 3.510268996215899773e-02,
 3.510475154321625324e-02,
 3.510675590612072350e-02,
 3.510870305342492920e-02,
 3.511059298777387261e-02,
 3.511242571190459349e-02,
 3.511420122864618992e-02,
 3.511591954092008888e-02,
 3.511758065173970628e-02,
 3.511918456421044693e-02,
 3.512073128153014173e-02,
 3.512222080698821497e-02,
 3.512365314396637822e-02,
 3.512502829593851239e-02,
 3.512634626647025832e-02,
 3.512760705921961352e-02,
 3.512881067793605094e-02,
 3.512995712646148350e-02,
 3.513104640872969503e-02,
 3.513207852876625709e-02,
 3.513305349068859829e-02,
 3.513397129870639291e-02,
 3.513483195712092250e-02,
 3.513563547032558243e-02,
 3.513638184280543086e-02,
 3.513707107913754263e-02,
 3.513770318399063453e-02,
 3.513827816212532207e-02,
 3.513879601839421662e-02,
 3.513925675774120377e-02,
 3.513966038520258822e-02,
 3.514000690590593501e-02,
 3.514029632507085360e-02,
 3.514052864800822767e-02,
 3.514070388012119350e-02,
 3.514082202690416157e-02,
 3.514088309394326065e-02,
 3.514088708691646273e-02,
 3.514083401159320136e-02,
 3.514072387383463530e-02,
 3.514055667959314899e-02,
 3.514033243491310188e-02,
 3.514005114593024559e-02,
 3.513971281887186271e-02,
 3.513931746005676676e-02,
 3.513886507589521202e-02,
 3.513835567288899758e-02,
 3.513778925763115513e-02,
 3.513716583680660116e-02,
 3.513648541719113783e-02,
 3.513574800565228556e-02,
 3.513495360914890842e-02,
 3.513410223473110300e-02,
 3.513319388954028177e-02,
 3.513222858080945060e-02,
 3.513120631586234832e-02,
 3.513012710211464718e-02,
 3.512899094707273157e-02,
 3.512779785833451685e-02,
 3.512654784358903298e-02,
 3.512524091061623721e-02,
 3.512387706728786751e-02,
 3.512245632156614505e-02,
 3.512097868150482194e-02,
 3.511944415524850815e-02,
 3.511785275103308096e-02,
 3.511620447718523386e-02,
 3.511449934212296925e-02,
 3.511273735435488375e-02,
 3.511091852248118123e-02,
 3.510904285519242385e-02,
 3.510711036127035778e-02,
 3.510512104958759400e-02,
 3.510307492910780952e-02,
 3.510097200888528252e-02,
 3.509881229806532943e-02,
 3.509659580588381927e-02,
 3.509432254166794385e-02,
 3.509199251483480220e-02,
 3.508960573489318391e-02,
 3.508716221144210501e-02,
 3.508466195417125899e-02,
 3.508210497286107232e-02,
 3.507949127738256567e-02,
 3.507682087769765922e-02,
 3.507409378385854121e-02,
 3.507131000600808429e-02,
 3.506846955437976227e-02,
 3.506557243929749046e-02,
 3.506261867117570902e-02,
 3.505960826051934820e-02,
 3.505654121792375205e-02,
 3.505341755407456045e-02,
 3.505023727974819481e-02,
 3.504700040581104625e-02,
 3.504370694321984336e-02,
 3.504035690302188116e-02,
 3.503695029635465336e-02,
 3.503348713444578988e-02,
 3.502996742861329976e-02,
 3.502639119026506459e-02,
 3.502275843089987239e-02,
 3.501906916210571069e-02,
 3.501532339556139017e-02,
 3.501152114303573981e-02,
 3.500766241638711418e-02,
 3.500374722756460777e-02,
 3.499977558860684068e-02,
 3.499574751164252068e-02,
 3.499166300889048481e-02,
 3.498752209265924840e-02,
 3.498332477534744911e-02,
 3.497907106944336819e-02,
 3.497476098752544393e-02,
 3.497039454226137656e-02,
 3.496597174640906497e-02,
 3.496149261281629450e-02,
 3.495695715442000834e-02,
 3.495236538424732753e-02,
 3.494771731541482240e-02,
 3.494301296112869298e-02,
 3.493825233468501879e-02,
 3.493343544946869023e-02,
 3.492856231895519192e-02,
 3.492363295670852102e-02,
 3.491864737638290805e-02,
 3.491360559172153322e-02,
 3.490850761655721335e-02,
 3.490335346481206191e-02,
 3.489814315049762083e-02,
 3.489287668771477724e-02,
 3.488755409065356222e-02,
 3.488217537359319942e-02,
 3.487674055090251440e-02,
 3.487124963703903263e-02,
 3.486570264654982598e-02,
 3.486009959407105480e-02,
 3.485444049432761399e-02,
 3.484872536213401428e-02,
 3.484295421239318180e-02,
 3.483712706009764459e-02,
 3.483124392032833222e-02,
 3.482530480825543617e-02,
 3.481930973913813232e-02,
 3.481325872832423396e-02,
 3.480715179125030978e-02,
 3.480098894344193367e-02,
 3.479477020051351815e-02,
 3.478849557816802995e-02,
 3.478216509219696911e-02,
 3.477577875848085476e-02,
 3.476933659298853119e-02,
 3.476283861177763279e-02,
 3.475628483099432731e-02,
 3.474967526687309377e-02,
 3.474300993573723600e-02,
 3.473628885399813321e-02,
 3.472951203815593385e-02,
 3.472267950479895199e-02,
 3.471579127060375053e-02,
 3.470884735233544655e-02,
 3.470184776684751005e-02,
 3.469479253108116029e-02,
 3.468768166206638581e-02,
 3.468051517692084806e-02,
 3.467329309285065164e-02,
 3.466601542714980999e-02,
 3.465868219720067561e-02,
 3.465129342047326699e-02,
 3.464384911452578208e-02,
 3.463634929700439014e-02,
 3.462879398564297495e-02,
 3.462118319826348878e-02,
 3.461351695277552903e-02,
 3.460579526717668525e-02,
 3.459801815955226151e-02,
 3.459018564807506135e-02,
 3.458229775100591513e-02,
 3.457435448669306244e-02,
 3.456635587357221456e-02,
 3.455830193016714430e-02,
 3.455019267508865205e-02,
 3.454202812703516257e-02,
 3.453380830479276659e-02,
 3.452553322723474899e-02,
 3.451720291332163737e-02,
 3.450881738210168082e-02,
 3.450037665271023929e-02,
 3.449188074436965873e-02,
 3.448332967638993024e-02,
 3.447472346816792682e-02,
 3.446606213918770867e-02,
 3.445734570902063421e-02,
 3.444857419732479803e-02,
 3.443974762384537092e-02,
 3.443086600841492595e-02,
 3.442192937095230748e-02,
 3.441293773146371360e-02,
 3.440389111004189815e-02,
 3.439478952686675362e-02,
 3.438563300220467966e-02,
 3.437642155640884684e-02,
 3.436715520991918266e-02,
 3.435783398326218430e-02,
 3.434845789705099489e-02,
 3.433902697198528559e-02,
 3.432954122885140125e-02,
 3.432000068852178454e-02,
 3.431040537195577389e-02,
 3.430075530019859736e-02,
 3.429105049438239267e-02,
 3.428129097572525652e-02,
 3.427147676553161243e-02,
 3.426160788519208578e-02,
 3.425168435618335810e-02,
 3.424170620006856958e-02,
 3.423167343849684713e-02,
 3.422158609320292977e-02,
 3.421144418600811227e-02,
 3.420124773881954433e-02,
 3.419099677363013345e-02,
 3.418069131251860043e-02,
 3.417033137764972917e-02,
 3.415991699127399195e-02,
 3.414944817572756336e-02,
 3.413892495343220923e-02,
 3.412834734689562666e-02,
 3.411771537871080562e-02,
 3.410702907155650082e-02,
 3.409628844819698884e-02,
 3.408549353148201261e-02,
 3.407464434434647610e-02,
 3.406374090981095781e-02,
 3.405278325098137771e-02,
 3.404177139104868494e-02,
 3.403070535328926033e-02,
 3.401958516106477759e-02,
 3.400841083782182861e-02,
 3.399718240709218714e-02,
 3.398589989249280185e-02,
 3.397456331772543553e-02,
 3.396317270657700504e-02,
 3.395172808291926914e-02,
 3.394022947070861329e-02,
 3.392867689398684078e-02,
 3.391707037687990978e-02,
 3.390540994359879379e-02,
 3.389369561843915551e-02,
 3.388192742578133992e-02,
 3.387010539009001342e-02,
 3.385822953591465651e-02,
 3.384629988788911970e-02,
 3.383431647073182474e-02,
 3.382227930924531362e-02,
 3.381018842831669952e-02,
 3.379804385291736157e-02,
 3.378584560810286852e-02,
 3.377359371901305501e-02,
 3.376128821087182735e-02,
 3.374892910898725368e-02,
 3.373651643875131417e-02,
 3.372405022564034516e-02,
 3.371153049521422029e-02,
 3.369895727311712774e-02,
 3.368633058507650851e-02,
 3.367365045690432629e-02,
 3.366091691449577677e-02,
 3.364812998383003712e-02,
 3.363528969096968302e-02,
 3.362239606206122999e-02,
 3.360944912333457130e-02,
 3.359644890110297100e-02,
 3.358339542176327908e-02,
 3.357028871179595919e-02,
 3.355712879776429763e-02,
 3.354391570631543723e-02,
 3.353064946417957243e-02,
 3.351733009816976888e-02,
 3.350395763518283082e-02,
 3.349053210219793408e-02,
 3.347705352627816655e-02,
 3.346352193456888363e-02,
 3.344993735429864501e-02,
 3.343629981277905505e-02,
 3.342260933740425627e-02,
 3.340886595565129014e-02,
 3.339506969508006240e-02,
 3.338122058333285042e-02,
 3.336731864813493459e-02,
 3.335336391729376571e-02,
 3.333935641869983230e-02,
 3.332529618032548796e-02,
 3.331118323022594363e-02,
 3.329701759653846266e-02,
 3.328279930748298532e-02,
 3.326852839136123369e-02,
 3.325420487655748186e-02,
 3.323982879153807718e-02,
 3.322540016485122510e-02,
 3.321091902512773170e-02,
 3.319638540107957420e-02,
 3.318179932150153860e-02,
 3.316716081526936699e-02,
 3.315246991134140897e-02,
 3.313772663875728247e-02,
 3.312293102663870642e-02,
 3.310808310418846684e-02,
 3.309318290069161728e-02,
 3.307823044551443104e-02,
 3.306322576810446362e-02,
 3.304816889799112173e-02,
 3.303305986478497630e-02,
 3.301789869817781109e-02,
 3.300268542794278226e-02,
 3.298742008393443226e-02,
 3.297210269608816940e-02,
 3.295673329442067728e-02,
 3.294131190902939432e-02,
 3.292583857009329790e-02,
 3.291031330787170389e-02,
 3.289473615270505080e-02,
 3.287910713501471932e-02,
 3.286342628530274090e-02,
 3.284769363415148552e-02,
 3.283190921222477188e-02,
 3.281607305026607718e-02,
 3.280018517910008452e-02,
 3.278424562963164896e-02,
 3.276825443284632489e-02,
 3.275221161980927664e-02,
 3.273611722166695076e-02,
 3.271997126964531349e-02,
 3.270377379505073900e-02,
 3.268752482926977343e-02,
 3.267122440376910020e-02,
 3.265487255009518613e-02,
 3.263846929987448964e-02,
 3.262201468481341210e-02,
 3.260550873669820077e-02,
 3.258895148739497649e-02,
 3.257234296884910923e-02,
 3.255568321308618951e-02,
 3.253897225221116796e-02,
 3.252221011840827208e-02,
 3.250539684394169321e-02,
 3.248853246115456644e-02,
 3.247161700246959520e-02,
 3.245465050038889160e-02,
 3.243763298749357399e-02,
 3.242056449644383637e-02,
 3.240344505997933694e-02,
 3.238627471091857363e-02,
 3.236905348215909917e-02,
 3.235178140667727825e-02,
 3.233445851752832223e-02,
 3.231708484784658053e-02,
 3.229966043084469413e-02,
 3.228218529981406043e-02,
 3.226465948812524270e-02,
 3.224708302922645736e-02,
 3.222945595664529483e-02,
 3.221177830398715830e-02,
 3.219405010493622127e-02,
 3.217627139325469204e-02,
 3.215844220278308435e-02,
 3.214056256744015488e-02,
 3.212263252122289636e-02,
 3.210465209820614896e-02,
 3.208662133254282234e-02,
 3.206854025846400669e-02,
 3.205040891027800126e-02,
 3.203222732237174381e-02,
 3.201399552920939501e-02,
 3.199571356533292138e-02,
 3.197738146536193565e-02,
 3.195899926399366209e-02,
 3.194056699600261728e-02,
 3.192208469624103345e-02,
 3.190355239963813677e-02,
 3.188497014120093842e-02,
 3.186633795601325619e-02,
 3.184765587923633207e-02,
 3.182892394610829095e-02,
 3.181014219194466808e-02,
 3.179131065213761792e-02,
 3.177242936215622648e-02,
 3.175349835754683742e-02,
 3.173451767393194872e-02,
 3.171548734701142014e-02,
 3.169640741256125188e-02,
 3.167727790643439650e-02,
 3.165809886456005112e-02,
 3.163887032294434437e-02,
 3.161959231766905271e-02,
 3.160026488489285634e-02,
 3.158088806085056904e-02,
 3.156146188185322138e-02,
 3.154198638428777623e-02,
 3.152246160461737862e-02,
 3.150288757938129319e-02,
 3.148326434519479328e-02,
 3.146359193874839755e-02,
 3.144387039680926477e-02,
 3.142409975621968110e-02,
 3.140428005389794830e-02,
 3.138441132683768287e-02,
 3.136449361210823933e-02,
 3.134452694685432167e-02,
 3.132451136829615679e-02,
 3.130444691372917532e-02,
 3.128433362052410877e-02,
 3.126417152612696176e-02,
 3.124396066805865471e-02,
 3.122370108391538807e-02,
 3.120339281136826071e-02,
 3.118303588816324218e-02,
 3.116263035212132534e-02,
 3.114217624113812394e-02,
 3.112167359318402174e-02,
 3.110112244630388115e-02,
 3.108052283861766074e-02,
 3.105987480831929118e-02,
 3.103917839367719908e-02,
 3.101843363303441459e-02,
 3.099764056480828686e-02,
 3.097679922749020306e-02,
 3.095590965964582775e-02,
 3.093497189991489468e-02,
 3.091398598701104380e-02,
 3.089295195972217509e-02,
 3.087186985690985527e-02,
 3.085073971750925889e-02,
 3.082956158052996276e-02,
 3.080833548505436392e-02,
 3.078706147023940742e-02,
 3.076573957531454975e-02,
 3.074436983958368091e-02,
 3.072295230242336542e-02,
 3.070148700328390393e-02,
 3.067997398168858386e-02,
 3.065841327723409226e-02,
 3.063680492959017579e-02,
 3.061514897849955050e-02,
 3.059344546377792615e-02,
 3.057169442531399231e-02,
 3.054989590306905062e-02,
 3.052804993707740333e-02,
 3.050615656744604109e-02,
 3.048421583435415722e-02,
 3.046222777805408441e-02,
 3.044019243887002846e-02,
 3.041810985719924781e-02,
 3.039598007351062767e-02,
 3.037380312834590118e-02,
 3.035157906231829295e-02,
 3.032930791611413227e-02,
 3.030698973049073333e-02,
 3.028462454627792871e-02,
 3.026221240437756976e-02,
 3.023975334576277027e-02,
 3.021724741147902016e-02,
 3.019469464264289138e-02,
 3.017209508044301283e-02,
 3.014944876613925157e-02,
 3.012675574106308748e-02,
 3.010401604661726987e-02,
 3.008122972427582781e-02,
 3.005839681558419504e-02,
 3.003551736215880064e-02,
 3.001259140568702383e-02,
 2.998961898792753059e-02,
 2.996660015070972197e-02,
 2.994353493593416432e-02,
 2.992042338557167683e-02,
 2.989726554166407049e-02,
 2.987406144632397814e-02,
 2.985081114173418135e-02,
 2.982751467014854024e-02,
 2.980417207389037676e-02,
 2.978078339535433772e-02,
 2.975734867700469827e-02,
 2.973386796137626048e-02,
 2.971034129107362129e-02,
 2.968676870877164434e-02,
 2.966315025721504017e-02,
 2.963948597921852932e-02,
 2.961577591766626633e-02,
 2.959202011551268635e-02,
 2.956821861578136715e-02,
 2.954437146156580971e-02,
 2.952047869602882069e-02,
 2.949654036240281774e-02,
 2.947255650398924315e-02,
 2.944852716415903918e-02,
 2.942445238635235313e-02,
 2.940033221407829453e-02,
 2.937616669091522303e-02,
 2.935195586051016908e-02,
 2.932769976657957287e-02,
 2.930339845290781675e-02,
 2.927905196334883164e-02,
 2.925466034182486186e-02,
 2.923022363232685022e-02,
 2.920574187891376156e-02,
 2.918121512571375531e-02,
 2.915664341692269373e-02,
 2.913202679680498841e-02,
 2.910736530969322208e-02,
 2.908265899998807233e-02,
 2.905790791215809646e-02,
 2.903311209073994661e-02,
 2.900827158033830733e-02,
 2.898338642562519815e-02,
 2.895845667134072307e-02,
 2.893348236229260212e-02,
 2.890846354335601526e-02,
 2.888340025947349482e-02,
 2.885829255565520307e-02,
 2.883314047697857138e-02,
 2.880794406858815798e-02,
 2.878270337569576939e-02,
 2.875741844358039104e-02,
 2.873208931758754539e-02,
 2.870671604313047853e-02,
 2.868129866568846706e-02,
 2.865583723080814341e-02,
 2.863033178410237869e-02,
 2.860478237125108764e-02,
 2.857918903800026056e-02,
 2.855355183016254281e-02,
 2.852787079361712372e-02,
 2.850214597430915375e-02,
 2.847637741825017471e-02,
 2.845056517151764788e-02,
 2.842470928025536692e-02,
 2.839880979067286107e-02,
 2.837286674904574910e-02,
 2.834688020171499331e-02,
 2.832085019508792656e-02,
 2.829477677563679849e-02,
 2.826865998990013562e-02,
 2.824249988448133616e-02,
 2.821629650604965192e-02,
 2.819004990133922722e-02,
 2.816376011714964711e-02,
 2.813742720034581937e-02,
 2.811105119785708290e-02,
 2.808463215667862667e-02,
 2.805817012386984527e-02,
 2.803166514655540398e-02,
 2.800511727192421876e-02,
 2.797852654723025426e-02,
 2.795189301979198945e-02,
 2.792521673699231710e-02,
 2.789849774627838758e-02,
 2.787173609516206338e-02,
 2.784493183121901361e-02,
 2.781808500208933152e-02,
 2.779119565547690310e-02,
 2.776426383915022236e-02,
 2.773728960094088564e-02,
 2.771027298874480238e-02,
 2.768321405052146661e-02,
 2.765611283429418588e-02,
 2.762896938814960943e-02,
 2.760178376023805086e-02,
 2.757455599877312383e-02,
 2.754728615203165878e-02,
 2.751997426835413665e-02,
 2.749262039614359943e-02,
 2.746522458386692345e-02,
 2.743778688005283836e-02,
 2.741030733329429675e-02,
 2.738278599224592061e-02,
 2.735522290562588180e-02,
 2.732761812221443792e-02,
 2.729997169085493156e-02,
 2.727228366045249611e-02,
 2.724455407997537423e-02,
 2.721678299845351964e-02,
 2.718897046497959630e-02,
 2.716111652870803472e-02,
 2.713322123885527834e-02,
 2.710528464470041143e-02,
 2.707730679558328912e-02,
 2.704928774090659474e-02,
 2.702122753013393164e-02,
 2.699312621279131158e-02,
 2.696498383846536451e-02,
 2.693680045680509408e-02,
 2.690857611752015335e-02,
 2.688031087038179195e-02,
 2.685200476522241197e-02,
 2.682365785193556451e-02,
 2.679527018047564088e-02,
 2.676684180085812936e-02,
 2.673837276315935152e-02,
 2.670986311751649689e-02,
 2.668131291412687012e-02,
 2.665272220324911567e-02,
 2.662409103520211456e-02,
 2.659541946036458188e-02,
 2.656670752917661762e-02,
 2.653795529213751059e-02,
 2.650916279980767773e-02,
 2.648033010280649927e-02,
 2.645145725181452870e-02,
 2.642254429757117870e-02,
 2.639359129087634828e-02,
 2.636459828258912175e-02,
 2.633556532362883382e-02,
 2.630649246497362287e-02,
 2.627737975766162096e-02,
 2.624822725279007951e-02,
 2.621903500151573016e-02,
 2.618980305505410819e-02,
 2.616053146468031929e-02,
 2.613122028172812708e-02,
 2.610186955759008498e-02,
 2.607247934371813985e-02,
 2.604304969162247671e-02,
 2.601358065287219523e-02,
 2.598407227909468528e-02,
 2.595452462197631038e-02,
 2.592493773326110668e-02,
 2.589531166475202151e-02,
 2.586564646830991077e-02,
 2.583594219585407317e-02,
 2.580619889936097699e-02,
 2.577641663086620641e-02,
 2.574659544246232432e-02,
 2.571673538630016992e-02,
 2.568683651458771727e-02,
 2.565689887959113347e-02,
 2.562692253363361983e-02,
 2.559690752909584907e-02,
 2.556685391841596877e-02,
 2.553676175408934462e-02,
 2.550663108866829676e-02,
 2.547646197476209282e-02,
 2.544625446503758978e-02,
 2.541600861221757907e-02,
 2.538572446908237551e-02,
 2.535540208846848165e-02,
 2.532504152326945160e-02,
 2.529464282643463166e-02,
 2.526420605097063482e-02,
 2.523373124993963032e-02,
 2.520321847646075572e-02,
 2.517266778370833014e-02,
 2.514207922491354733e-02,
 2.511145285336319893e-02,
 2.508078872240019144e-02,
 2.505008688542261983e-02,
 2.501934739588464532e-02,
 2.498857030729630807e-02,
 2.495775567322250019e-02,
 2.492690354728415922e-02,
 2.489601398315676589e-02,
 2.486508703457190189e-02,
 2.483412275531539717e-02,
 2.480312119922895714e-02,
 2.477208242020846260e-02,
 2.474100647220517021e-02,
 2.470989340922481736e-02,
 2.467874328532807318e-02,
 2.464755615462975100e-02,
 2.461633207129954037e-02,
 2.458507108956121262e-02,
 2.455377326369330079e-02,
 2.452243864802790621e-02,
 2.449106729695158663e-02,
 2.445965926490493297e-02,
 2.442821460638236464e-02,
 2.439673337593243826e-02,
 2.436521562815663344e-02,
 2.433366141771104579e-02,
 2.430207079930462102e-02,
 2.427044382770027209e-02,
 2.423878055771366141e-02,
 2.420708104421443602e-02,
 2.417534534212477382e-02,
 2.414357350642040365e-02,
 2.411176559212965809e-02,
 2.407992165433403900e-02,
 2.404804174816774567e-02,
 2.401612592881789687e-02,
 2.398417425152355245e-02,
 2.395218677157730583e-02,
 2.392016354432316416e-02,
 2.388810462515807490e-02,
 2.385601006953116596e-02,
 2.382387993294339881e-02,
 2.379171427094809929e-02,
 2.375951313915029839e-02,
 2.372727659320728044e-02,
 2.369500468882735494e-02,
 2.366269748177132065e-02,
 2.363035502785106393e-02,
 2.359797738293007568e-02,
 2.356556460292310098e-02,
 2.353311674379639229e-02,
 2.350063386156716130e-02,
 2.346811601230392591e-02,
 2.343556325212609037e-02,
 2.340297563720400778e-02,
 2.337035322375867127e-02,
 2.333769606806196037e-02,
 2.330500422643648484e-02,
 2.327227775525496020e-02,
 2.323951671094097102e-02,
 2.320672114996813820e-02,
 2.317389112886063252e-02,
 2.314102670419216842e-02,
 2.310812793258726350e-02,
 2.307519487071980555e-02,
 2.304222757531382976e-02,
 2.300922610314284217e-02,
 2.297619051103035395e-02,
 2.294312085584917019e-02,
 2.291001719452168822e-02,
 2.287687958401959584e-02,
 2.284370808136409331e-02,
 2.281050274362507457e-02,
 2.277726362792189055e-02,
 2.274399079142293278e-02,
 2.271068429134487018e-02,
 2.267734418495410270e-02,
 2.264397052956473172e-02,
 2.261056338254041967e-02,
 2.257712280129239857e-02,
 2.254364884328110066e-02,
 2.251014156601451044e-02,
 2.247660102704950730e-02,
 2.244302728399052982e-02,
 2.240942039449044312e-02,
 2.237578041624965416e-02,
 2.234210740701666337e-02,
 2.230840142458756156e-02,
 2.227466252680618611e-02,
 2.224089077156347904e-02,
 2.220708621679840303e-02,
 2.217324892049693172e-02,
 2.213937894069190407e-02,
 2.210547633546404434e-02,
 2.207154116294049798e-02,
 2.203757348129583779e-02,
 2.200357334875075940e-02,
 2.196954082357346211e-02,
 2.193547596407816394e-02,
 2.190137882862625701e-02,
 2.186724947562473584e-02,
 2.183308796352785922e-02,
 2.179889435083523508e-02,
 2.176466869609337829e-02,
 2.173041105789433325e-02,
 2.169612149487646843e-02,
 2.166180006572341124e-02,
 2.162744682916527619e-02,
 2.159306184397720429e-02,
 2.155864516898048019e-02,
 2.152419686304114788e-02,
 2.148971698507102027e-02,
 2.145520559402722821e-02,
 2.142066274891167230e-02,
 2.138608850877176185e-02,
 2.135148293269942613e-02,
 2.131684607983201987e-02,
 2.128217800935073428e-02,
 2.124747878048253297e-02,
 2.121274845249786906e-02,
 2.117798708471241298e-02,
 2.114319473648575143e-02,
 2.110837146722220614e-02,
 2.107351733636939409e-02,
 2.103863240341996219e-02,
 2.100371672790970340e-02,
 2.096877036941904512e-02,
 2.093379338757132488e-02,
 2.089878584203407400e-02,
 2.086374779251836883e-02,
 2.082867929877831037e-02,
 2.079358042061200604e-02,
 2.075845121786009176e-02,
 2.072329175040701216e-02,
 2.068810207817960503e-02,
 2.065288226114851688e-02,
 2.061763235932616289e-02,
 2.058235243276862469e-02,
 2.054704254157400933e-02,
 2.051170274588358378e-02,
 2.047633310588034550e-02,
 2.044093368179010495e-02,
 2.040550453388076738e-02,
 2.037004572246249937e-02,
 2.033455730788729515e-02,
 2.029903935054904948e-02,
 2.026349191088399476e-02,
 2.022791504936926471e-02,
 2.019230882652445214e-02,
 2.015667330291002340e-02,
 2.012100853912855702e-02,
 2.008531459582289444e-02,
 2.004959153367864844e-02,
 2.001383941342083431e-02,
 1.997805829581688480e-02,
 1.994224824167418336e-02,
 1.990640931184177106e-02,
 1.987054156720849743e-02,
 1.983464506870466146e-02,
 1.979871987730041222e-02,
 1.976276605400690417e-02,
 1.972678365987488858e-02,
 1.969077275599601454e-02,
 1.965473340350179163e-02,
 1.961866566356324990e-02,
 1.958256959739222008e-02,
 1.954644526623936646e-02,
 1.951029273139609499e-02,
 1.947411205419209007e-02,
 1.943790329599795128e-02,
 1.940166651822243515e-02,
 1.936540178231439119e-02,
 1.932910914976137054e-02,
 1.929278868209048994e-02,
 1.925644044086708556e-02,
 1.922006448769619097e-02,
 1.918366088422081978e-02,
 1.914722969212353382e-02,
 1.911077097312441353e-02,
 1.907428478898298349e-02,
 1.903777120149653668e-02,
 1.900123027250054386e-02,
 1.896466206386908729e-02,
 1.892806663751378862e-02,
 1.889144405538479773e-02,
 1.885479437946928349e-02,
 1.881811767179310951e-02,
 1.878141399441884962e-02,
 1.874468340944732136e-02,
 1.870792597901619128e-02,
 1.867114176530106084e-02,
 1.863433083051400929e-02,
 1.859749323690476630e-02,
 1.856062904675989667e-02,
 1.852373832240305704e-02,
 1.848682112619409040e-02,
 1.844987752053034447e-02,
 1.841290756784508958e-02,
 1.837591133060870879e-02,
 1.833888887132726145e-02,
 1.830184025254341998e-02,
 1.826476553683629989e-02,
 1.822766478682056462e-02,
 1.819053806514739358e-02,
 1.815338543450318101e-02,
 1.811620695761059774e-02,
 1.807900269722774803e-02,
 1.804177271614839512e-02,
 1.800451707720147204e-02,
 1.796723584325156386e-02,
 1.792992907719827278e-02,
 1.789259684197664832e-02,
 1.785523920055609795e-02,
 1.781785621594161526e-02,
 1.778044795117272522e-02,
 1.774301446932373405e-02,
 1.770555583350338219e-02,
 1.766807210685495191e-02,
 1.763056335255637833e-02,
 1.759302963381947221e-02,
 1.755547101389068332e-02,
 1.751788755605000400e-02,
 1.748027932361190251e-02,
 1.744264637992423012e-02,
 1.740498878836920990e-02,
 1.736730661236193449e-02,
 1.732959991535178504e-02,
 1.729186876082099145e-02,
 1.725411321228575295e-02,
 1.721633333329470467e-02,
 1.717852918743030879e-02,
 1.714070083830766811e-02,
 1.710284834957510880e-02,
 1.706497178491300781e-02,
 1.702707120803571145e-02,
 1.698914668268899572e-02,
 1.695119827265152007e-02,
 1.691322604173476143e-02,
 1.687523005378158830e-02,
 1.683721037266792953e-02,
 1.679916706230112286e-02,
 1.676110018662104600e-02,
 1.672300980959875658e-02,
 1.668489599523772723e-02,
 1.664675880757244750e-02,
 1.660859831066973866e-02,
 1.657041456862675885e-02,
 1.653220764557304309e-02,
 1.649397760566861590e-02,
 1.645572451310520906e-02,
 1.641744843210468652e-02,
 1.637914942692113296e-02,
 1.634082756183796725e-02,
 1.630248290117015594e-02,
 1.626411550926336325e-02,
 1.622572545049285123e-02,
 1.618731278926526657e-02,
 1.614887759001670114e-02,
 1.611041991721417696e-02,
 1.607193983535384549e-02,
 1.603343740896252811e-02,
 1.599491270259650877e-02,
 1.595636578084212026e-02,
 1.591779670831476243e-02,
 1.587920554965988051e-02,
 1.584059236955199026e-02,
 1.580195723269523997e-02,
 1.576330020382224473e-02,
 1.572462134769589751e-02,
 1.568592072910666296e-02,
 1.564719841287503035e-02,
 1.560845446384973370e-02,
 1.556968894690781945e-02,
 1.553090192695558841e-02,
 1.549209346892731556e-02,
 1.545326363778597514e-02,
 1.541441249852211655e-02,
 1.537554011615506824e-02,
 1.533664655573180324e-02,
 1.529773188232748556e-02,
 1.525879616104444669e-02,
 1.521983945701343641e-02,
 1.518086183539234940e-02,
 1.514186336136676657e-02,
 1.510284410014931834e-02,
 1.506380411698044278e-02,
 1.502474347712694919e-02,
 1.498566224588335737e-02,
 1.494656048857085154e-02,
 1.490743827053710863e-02,
 1.486829565715724194e-02,
 1.482913271383229543e-02,
 1.478994950599039557e-02,
 1.475074609908536873e-02,
 1.471152255859797982e-02,
 1.467227895003464858e-02,
 1.463301533892842794e-02,
 1.459373179083759374e-02,
 1.455442837134694051e-02,
 1.451510514606650822e-02,
 1.447576218063239238e-02,
 1.443639954070578303e-02,
 1.439701729197382686e-02,
 1.435761550014821343e-02,
 1.431819423096664101e-02,
 1.427875355019119288e-02,
 1.423929352360968174e-02,
 1.419981421703395662e-02,
 1.416031569630107900e-02,
 1.412079802727310429e-02,
 1.408126127583566277e-02,
 1.404170550789989903e-02,
 1.400213078940052043e-02,
 1.396253718629707555e-02,
 1.392292476457238429e-02,
 1.388329359023415983e-02,
 1.384364372931342832e-02,
 1.380397524786526955e-02,
 1.376428821196828620e-02,
 1.372458268772495243e-02,
 1.368485874126057836e-02,
 1.364511643872449304e-02,
 1.360535584628882501e-02,
 1.356557703014931587e-02,
 1.352578005652402791e-02,
 1.348596499165437800e-02,
 1.344613190180487562e-02,
 1.340628085326185832e-02,
 1.336641191233512230e-02,
 1.332652514535642187e-02,
 1.328662061868032297e-02,
 1.324669839868298886e-02,
 1.320675855176344643e-02,
 1.316680114434212560e-02,
 1.312682624286202679e-02,
 1.308683391378735739e-02,
 1.304682422360472528e-02,
 1.300679723882145096e-02,
 1.296675302596715998e-02,
 1.292669165159239519e-02,
 1.288661318226935748e-02,
 1.284651768459093082e-02,
 1.280640522517127733e-02,
 1.276627587064591354e-02,
 1.272612968767028278e-02,
 1.268596674292146731e-02,
 1.264578710309662533e-02,
 1.260559083491388441e-02,
 1.256537800511087731e-02,
 1.252514868044688617e-02,
 1.248490292770002355e-02,
 1.244464081366940429e-02,
 1.240436240517350970e-02,
 1.236406776905134633e-02,
 1.232375697216076676e-02,
 1.228343008138003609e-02,
 1.224308716360650827e-02,
 1.220272828575733742e-02,
 1.216235351476832767e-02,
 1.212196291759518735e-02,
 1.208155656121247951e-02,
 1.204113451261328710e-02,
 1.200069683881023822e-02,
 1.196024360683418247e-02,
 1.191977488373527003e-02,
 1.187929073658112143e-02,
 1.183879123245913309e-02,
 1.179827643847373639e-02,
 1.175774642174844120e-02,
 1.171720124942432321e-02,
 1.167664098866104221e-02,
 1.163606570663530161e-02,
 1.159547547054234039e-02,
 1.155487034759454003e-02,
 1.151425040502232315e-02,
 1.147361571007284031e-02,
 1.143296633001127278e-02,
 1.139230233211976223e-02,
 1.135162378369708631e-02,
 1.131093075205990249e-02,
 1.127022330454095257e-02,
 1.122950150849050081e-02,
 1.118876543127446561e-02,
 1.114801514027663129e-02,
 1.110725070289591068e-02,
 1.106647218654844937e-02,
 1.102567965866617025e-02,
 1.098487318669759405e-02,
 1.094405283810641685e-02,
 1.090321868037301932e-02,
 1.086237078099305808e-02,
 1.082150920747844934e-02,
 1.078063402735578852e-02,
 1.073974530816796356e-02,
 1.069884311747260931e-02,
 1.065792752284319689e-02,
 1.061699859186759215e-02,
 1.057605639214905142e-02,
 1.053510099130599946e-02,
 1.049413245697087584e-02,
 1.045315085679192173e-02,
 1.041215625843069752e-02,
 1.037114872956420610e-02,
 1.033012833788323100e-02,
 1.028909515109322978e-02,
 1.024804923691310064e-02,
 1.020699066307654244e-02,
 1.016591949733062876e-02,
 1.012483580743665963e-02,
 1.008373966116890737e-02,
 1.004263112631604768e-02,
 1.000151027067960018e-02,
 9.960377162075012558e-03,
 9.919231868330269375e-03,
 9.878074457286846119e-03,
 9.836904996799601675e-03,
 9.795723554735376662e-03,
 9.754530198975066430e-03,
 9.713324997410909684e-03,
 9.672108017948780057e-03,
 9.630879328506388934e-03,
 9.589638997014326288e-03,
 9.548387091414691982e-03,
 9.507123679662433241e-03,
 9.465848829724066160e-03,
 9.424562609578532660e-03,
 9.383265087215706887e-03,
 9.341956330638121267e-03,
 9.300636407859115551e-03,
 9.259305386904200311e-03,
 9.217963335809330888e-03,
 9.176610322622900592e-03,
 9.135246415403343312e-03,
 9.093871682220575070e-03,
 9.052486191155706061e-03,
 9.011090010299966854e-03,
 8.969683207755946991e-03,
 8.928265851636378939e-03,
 8.886838010064951679e-03,
 8.845399751174896907e-03,
 8.803951143110607530e-03,
 8.762492254025911614e-03,
 8.721023152085357819e-03,
 8.679543905462522302e-03,
 8.638054582341589058e-03,
 8.596555250915932644e-03,
 8.555045979389037589e-03,
 8.513526835972959686e-03,
 8.471997888890379913e-03,
 8.430459206372069997e-03,
 8.388910856658382542e-03,
 8.347352907999108784e-03,
 8.305785428652076932e-03,
 8.264208486884838320e-03,
 8.222622150972939623e-03,
 8.181026489201173590e-03,
 8.139421569861972697e-03,
 8.097807461256894060e-03,
 8.056184231695334014e-03,
 8.014551949495157812e-03,
 7.972910682981700428e-03,
 7.931260500488899329e-03,
 7.889601470357878940e-03,
 7.847933660938168424e-03,
 7.806257140585895829e-03,
 7.764571977665909661e-03,
 7.722878240549214089e-03,
 7.681175997614902301e-03,
 7.639465317249013315e-03,
 7.597746267844120854e-03,
 7.556018917800458312e-03,
 7.514283335524589956e-03,
 7.472539589430196756e-03,
 7.430787747936883764e-03,
 7.389027879471430846e-03,
 7.347260052466528940e-03,
 7.305484335361567619e-03,
 7.263700796601360067e-03,
 7.221909504637569026e-03,
 7.180110527927155949e-03,
 7.138303934933468674e-03,
 7.096489794124727010e-03,
 7.054668173975855473e-03,
 7.012839142966138806e-03,
 6.971002769581078999e-03,
 6.929159122311099456e-03,
 6.887308269651422690e-03,
 6.845450280103012285e-03,
 6.803585222171166895e-03,
 6.761713164366568891e-03,
 6.719834175203846273e-03,
 6.677948323202950905e-03,
 6.636055676887801964e-03,
 6.594156304787248714e-03,
 6.552250275433576035e-03,
 6.510337657364027517e-03,
 6.468418519119331807e-03,
 6.426492929244619415e-03,
 6.384560956288271721e-03,
 6.342622668803087581e-03,
 6.300678135344580690e-03,
 6.258727424472573797e-03,
 6.216770604749653935e-03,
 6.174807744742286109e-03,
 6.132838913019408172e-03,
 6.090864178153260027e-03,
 6.048883608719476425e-03,
 6.006897273295595981e-03,
 5.964905240462722164e-03,
 5.922907578803962916e-03,
 5.880904356905524398e-03,
 5.838895643355155804e-03,
 5.796881506743653371e-03,
 5.754862015663412753e-03,
 5.712837238709334541e-03,
 5.670807244477804251e-03,
 5.628772101567576167e-03,
 5.586731878578332644e-03,
 5.544686644112119603e-03,
 5.502636466771957009e-03,
 5.460581415162776495e-03,
 5.418521557890090823e-03,
 5.376456963560919365e-03,
 5.334387700783695292e-03,
 5.292313838166922031e-03,
 5.250235444320790895e-03,
 5.208152587855625903e-03,
 5.166065337382896860e-03,
 5.123973761513756116e-03,
 5.081877928860602418e-03,
 5.039777908035471959e-03,
 4.997673767651021962e-03,
 4.955565576319555764e-03,
 4.913453402653819926e-03,
 4.871337315265641607e-03,
 4.829217382767316338e-03,
 4.787093673770200300e-03,
 4.744966256885758960e-03,
 4.702835200724092557e-03,
 4.660700573894924897e-03,
 4.618562445007541768e-03,
 4.576420882669422242e-03,
 4.534275955487822481e-03,
 4.492127732068255247e-03,
 4.449976281015531610e-03,
 4.407821670932243058e-03,
 4.365663970420332295e-03,
 4.323503248079530251e-03,
 4.281339572508300641e-03,
 4.239173012302841631e-03,
 4.197003636057952333e-03,
 4.154831512365631148e-03,
 4.112656709816468747e-03,
 4.070479296998233409e-03,
 4.028299342496875421e-03,
 3.986116914895046492e-03,
 3.943932082773621110e-03,
 3.901744914710396795e-03,
 3.859555479280011268e-03,
 3.817363845054834101e-03,
 3.775170080603662635e-03,
 3.732974254492680850e-03,
 3.690776435284019979e-03,
 3.648576691537225650e-03,
 3.606375091807783369e-03,
 3.564171704648066118e-03,
 3.521966598606254481e-03,
 3.479759842227314170e-03,
 3.437551504051468594e-03,
 3.395341652615704604e-03,
 3.353130356452278457e-03,
 3.310917684089808698e-03,
 3.268703704051692353e-03,
 3.226488484857676590e-03,
 3.184272095022599308e-03,
 3.142054603056214368e-03,
 3.099836077464178212e-03,
 3.057616586746669893e-03,
 3.015396199399417599e-03,
 2.973174983912051528e-03,
 2.930953008770274034e-03,
 2.888730342453133069e-03,
 2.846507053435143753e-03,
 2.804283210184654700e-03,
 2.762058881164936117e-03,
 2.719834134832624633e-03,
 2.677609039639265026e-03,
 2.635383664029833112e-03,
 2.593158076443726704e-03,
 2.550932345313301937e-03,
 2.508706539065408067e-03,
 2.466480726119836629e-03,
 2.424254974890399997e-03,
 2.382029353783543177e-03,
 2.339803931199269712e-03,
 2.297578775531054079e-03,
 2.255353955164420519e-03,
 2.213129538479060698e-03,
 2.170905593846182181e-03,
 2.128682189630582734e-03,
 2.086459394189027917e-03,
 2.044237275871324446e-03,
 2.002015903018807517e-03,
 1.959795343965846544e-03,
 1.917575667038356330e-03,
 1.875356940554854818e-03,
 1.833139232824920707e-03,
 1.790922612150772043e-03,
 1.748707146825708011e-03,
 1.706492905135198338e-03,
 1.664279955355461469e-03,
 1.622068365754424741e-03,
 1.579858204591631354e-03,
 1.537649540116804020e-03,
 1.495442440571993206e-03,
 1.453236974188872911e-03,
 1.411033209190870261e-03,
 1.368831213791516432e-03,
 1.326631056195544519e-03,
 1.284432804597315922e-03,
 1.242236527182403929e-03,
 1.200042292126066298e-03,
 1.157850167594289990e-03,
 1.115660221742287381e-03,
 1.073472522716039951e-03,
 1.031287138650758281e-03,
 9.891041376719645218e-04,
 9.469235878939767865e-04,
 9.047455574214267101e-04,
 8.625701143479863782e-04,
 8.203973267561483424e-04,
 7.782272627187514181e-04,
 7.360599902964135108e-04,
 6.938955775396393050e-04,
 6.517340924872107658e-04,
 6.095756031672237450e-04,
 5.674201775955916736e-04,
 5.252678837775703836e-04,
 4.831187897062455918e-04,
 4.409729633635935207e-04,
 3.988304727189675688e-04,
 3.566913857306356554e-04,
 3.145557703442529050e-04,
 2.724236944939368503e-04,
 2.302952261006326181e-04,
 1.881704330742277743e-04,
 1.460493833111038155e-04,
 1.039321446950798318e-04,
 6.181878509836196941e-05,
 1.970937237908853315e-05,
-2.239602561654950767e-05,
-6.449734105594168328e-05,
-1.065945061189930591e-04,
-1.486874529996394219e-04,
-1.907761139043147769e-04,
-2.328604210534657647e-04,
-2.749403066804847117e-04,
-3.170157030332300201e-04,
-3.590865423724877935e-04,
-4.011527569734907772e-04,
-4.432142791248474102e-04,
-4.852710411301829822e-04,
-5.273229753060094472e-04,
-5.693700139844222680e-04,
-6.114120895109774944e-04,
-6.534491342460807886e-04,
-6.954810805651089100e-04,
-7.375078608574535573e-04,
-7.795294075279206401e-04,
-8.215456529956621226e-04,
-8.635565296957024720e-04,
-9.055619700773862978e-04,
-9.475619066059081611e-04,
-9.895562717612414912e-04,
-1.031544998039649096e-03,
-1.073528017952160183e-03,
-1.115505264026072198e-03,
-1.157476668803900230e-03,
-1.199442164844986836e-03,
-1.241401684723400642e-03,
-1.283355161030625162e-03,
-1.325302526373408609e-03,
-1.367243713375210440e-03,
-1.409178654676248839e-03,
-1.451107282932611025e-03,
-1.493029530817609586e-03,
-1.534945331020728639e-03,
-1.576854616249146910e-03,
-1.618757319226185598e-03,
-1.660653372692832974e-03,
-1.702542709406698346e-03,
-1.744425262143478334e-03,
-1.786300963695466523e-03,
-1.828169746873030800e-03,
-1.870031544503595504e-03,
-1.911886289433208097e-03,
-1.953733914524498263e-03,
-1.995574352659267633e-03,
-2.037407536736457123e-03,
-2.079233399673735289e-03,
-2.121051874406422368e-03,
-2.162862893888904941e-03,
-2.204666391093708724e-03,
-2.246462299011532399e-03,
-2.288250550652622811e-03,
-2.330031079045164714e-03,
-2.371803817236822071e-03,
-2.413568698293676838e-03,
-2.455325655301726032e-03,
-2.497074621365362110e-03,
-2.538815529608867434e-03,
-2.580548313175389484e-03,
-2.622272905228498208e-03,
-2.663989238950143380e-03,
-2.705697247543286613e-03,
-2.747396864229799309e-03,
-2.789088022252083320e-03,
-2.830770654872027080e-03,
-2.872444695372375172e-03,
-2.914110077055784634e-03,
-2.955766733244935985e-03,
-2.997414597283815183e-03,
-3.039053602536164085e-03,
-3.080683682387012207e-03,
-3.122304770241595556e-03,
-3.163916799526853268e-03,
-3.205519703689942677e-03,
-3.247113416199684348e-03,
-3.288697870545681697e-03,
-3.330273000239295043e-03,
-3.371838738812760802e-03,
-3.413395019820635642e-03,
-3.454941776838308960e-03,
-3.496478943463510788e-03,
-3.538006453315213715e-03,
-3.579524240035047121e-03,
-3.621032237286364759e-03,
-3.662530378754315884e-03,
-3.704018598147131112e-03,
-3.745496829194611046e-03,
-3.786965005649619870e-03,
-3.828423061286998115e-03,
-3.869870929905101786e-03,
-3.911308545324262802e-03,
-3.952735841388286923e-03,
-3.994152751963521777e-03,
-4.035559210939887280e-03,
-4.076955152229901590e-03,
-4.118340509770257972e-03,
-4.159715217520200230e-03,
-4.201079209463131660e-03,
-4.242432419605441513e-03,
-4.283774781978103539e-03,
-4.325106230635123415e-03,
-4.366426699654741769e-03,
-4.407736123139611127e-03,
-4.449034435215901660e-03,
-4.490321570034486870e-03,
-4.531597461770115257e-03,
-4.572862044622775547e-03,
-4.614115252816218711e-03,
-4.655357020599378698e-03,
-4.696587282245596150e-03,
-4.737805972053461476e-03,
-4.779013024345996931e-03,
-4.820208373472145875e-03,
-4.861391953805164687e-03,
-4.902563699744202225e-03,
-4.943723545713243385e-03,
-4.984871426162554992e-03,
-5.026007275567172250e-03,
-5.067131028428218872e-03,
-5.108242619272927894e-03,
-5.149341982653764770e-03,
-5.190429053149803879e-03,
-5.231503765365630443e-03,
-5.272566053932842799e-03,
-5.313615853508564871e-03,
-5.354653098776916351e-03,
-5.395677724448101099e-03,
-5.436689665259378593e-03,
-5.477688855974193090e-03,
-5.518675231383570953e-03,
-5.559648726304746748e-03,
-5.600609275582515457e-03,
-5.641556814088244561e-03,
-5.682491276721378035e-03,
-5.723412598407841279e-03,
-5.764320714101634456e-03,
-5.805215558783742222e-03,
-5.846097067463441703e-03,
-5.886965175177443811e-03,
-5.927819816989973907e-03,
-5.968660927994130089e-03,
-6.009488443309789381e-03,
-6.050302298086317372e-03,
-6.091102427500361648e-03,
-6.131888766757524929e-03,
-6.172661251091299088e-03,
-6.213419815764571752e-03,
-6.254164396068095412e-03,
-6.294894927321955866e-03,
-6.335611344874548731e-03,
-6.376313584104044418e-03,
-6.417001580416865913e-03,
-6.457675269249235281e-03,
-6.498334586066059106e-03,
-6.538979466362291118e-03,
-6.579609845662062230e-03,
-6.620225659518734311e-03,
-6.660826843516240263e-03,
-6.701413333267087352e-03,
-6.741985064414879499e-03,
-6.782541972632345761e-03,
-6.823083993622821794e-03,
-6.863611063119326103e-03,
-6.904123116885920938e-03,
-6.944620090716252525e-03,
-6.985101920435048128e-03,
-7.025568541897089098e-03,
-7.066019890988586502e-03,
-7.106455903625785546e-03,
-7.146876515756408858e-03,
-7.187281663358556678e-03,
-7.227671282442288056e-03,
-7.268045309047960721e-03,
-7.308403679247685650e-03,
-7.348746329145338339e-03,
-7.389073194875194449e-03,
-7.429384212604378361e-03,
-7.469679318530745085e-03,
-7.509958448884601970e-03,
-7.550221539927522152e-03,
-7.590468527953871114e-03,
-7.630699349289340842e-03,
-7.670913940292361892e-03,
-7.711112237353110258e-03,
-7.751294176894935918e-03,
-7.791459695372898731e-03,
-7.831608729275209985e-03,
-7.871741215122187232e-03,
-7.911857089467800794e-03,
-7.951956288898054392e-03,
-7.992038750032267116e-03,
-8.032104409523349239e-03,
-8.072153204056289541e-03,
-8.112185070350483307e-03,
-8.152199945157966379e-03,
-8.192197765264697118e-03,
-8.232178467489763632e-03,
-8.272141988686601555e-03,
-8.312088265741706880e-03,
-8.352017235576039353e-03,
-8.391928835143950410e-03,
-8.431823001434621268e-03,
-8.471699671470682078e-03,
-8.511558782309561547e-03,
-8.551400271042480794e-03,
-8.591224074795936541e-03,
-8.631030130730233535e-03,
-8.670818376040858450e-03,
-8.710588747957659361e-03,
-8.750341183745515353e-03,
-8.790075620704657436e-03,
-8.829791996169641596e-03,
-8.869490247510811165e-03,
-8.909170312133092920e-03,
-8.948832127477709258e-03,
-8.988475631020363676e-03,
-9.028100760272989370e-03,
-9.067707452782630337e-03,
-9.107295646132660891e-03,
-9.146865277941776048e-03,
-9.186416285864921344e-03,
-9.225948607592666592e-03,
-9.265462180852591934e-03,
-9.304956943407206166e-03,
-9.344432833056609544e-03,
-9.383889787636389562e-03,
-9.423327745019128426e-03,
-9.462746643114139378e-03,
-9.502146419866897703e-03,
-9.541527013260281062e-03,
-9.580888361313447121e-03,
-9.620230402083337559e-03,
-9.659553073663191408e-03,
-9.698856314184090693e-03,
-9.738140061813727044e-03,
-9.777404254758034069e-03,
-9.816648831259634778e-03,
-9.855873729599281402e-03,
-9.895078888094798950e-03,
-9.934264245102747068e-03,
-9.973429739016293274e-03,
-1.001257530826778382e-02,
-1.005170089132670537e-02,
-1.009080642670130527e-02,
-1.012989185293747436e-02,
-1.016895710862016945e-02,
-1.020800213237241238e-02,
-1.024702686285540454e-02,
-1.028603123876981745e-02,
-1.032501519885419862e-02,
-1.036397868188653447e-02,
-1.040292162668311066e-02,
-1.044184397210007852e-02,
-1.048074565703181402e-02,
-1.051962662041250850e-02,
-1.055848680121512957e-02,
-1.059732613845282105e-02,
-1.063614457117706760e-02,
-1.067494203848015286e-02,
-1.071371847949309855e-02,
-1.075247383338725528e-02,
-1.079120803937335185e-02,
-1.082992103670259686e-02,
-1.086861276466607323e-02,
-1.090728316259459083e-02,
-1.094593216985995446e-02,
-1.098455972587360913e-02,
-1.102316577008785256e-02,
-1.106175024199507716e-02,
-1.110031308112897387e-02,
-1.113885422706326414e-02,
-1.117737361941287602e-02,
-1.121587119783325204e-02,
-1.125434690202151491e-02,
-1.129280067171486296e-02,
-1.133123244669268642e-02,
-1.136964216677489002e-02,
-1.140802977182320092e-02,
-1.144639520174040373e-02,
-1.148473839647132580e-02,
-1.152305929600212948e-02,
-1.156135784036045958e-02,
-1.159963396961650149e-02,
-1.163788762388161778e-02,
-1.167611874330965090e-02,
-1.171432726809612350e-02,
-1.175251313847939204e-02,
-1.179067629473949663e-02,
-1.182881667719922272e-02,
-1.186693422622337596e-02,
-1.190502888222021854e-02,
-1.194310058563946043e-02,
-1.198114927697468274e-02,
-1.201917489676151800e-02,
-1.205717738557907787e-02,
-1.209515668404890880e-02,
-1.213311273283647872e-02,
-1.217104547264969555e-02,
-1.220895484423999491e-02,
-1.224684078840268878e-02,
-1.228470324597585005e-02,
-1.232254215784157718e-02,
-1.236035746492527079e-02,
-1.239814910819669359e-02,
-1.243591702866881157e-02,
-1.247366116739892679e-02,
-1.251138146548811357e-02,
-1.254907786408186558e-02,
-1.258675030436939499e-02,
-1.262439872758501676e-02,
-1.266202307500649549e-02,
-1.269962328795694144e-02,
-1.273719930780321981e-02,
-1.277475107595767503e-02,
-1.281227853387676384e-02,
-1.284978162306195382e-02,
-1.288726028506007905e-02,
-1.292471446146237386e-02,
-1.296214409390557785e-02,
-1.299954912407124026e-02,
-1.303692949368689610e-02,
-1.307428514452472698e-02,
-1.311161601840292977e-02,
-1.314892205718477293e-02,
-1.318620320277969112e-02,
-1.322345939714236057e-02,
-1.326069058227386487e-02,
-1.329789670022056558e-02,
-1.333507769307545193e-02,
-1.337223350297686575e-02,
-1.340936407211033334e-02,
-1.344646934270670412e-02,
-1.348354925704384373e-02,
-1.352060375744548043e-02,
-1.355763278628256165e-02,
-1.359463628597224610e-02,
-1.363161419897838261e-02,
-1.366856646781196456e-02,
-1.370549303503038746e-02,
-1.374239384323861640e-02,
-1.377926883508801860e-02,
-1.381611795327783443e-02,
-1.385294114055373935e-02,
-1.388973833970971565e-02,
-1.392650949358625184e-02,
-1.396325454507210337e-02,
-1.399997343710282331e-02,
-1.403666611266262548e-02,
-1.407333251478260459e-02,
-1.410997258654234608e-02,
-1.414658627106874303e-02,
-1.418317351153745680e-02,
-1.421973425117197855e-02,
-1.425626843324359974e-02,
-1.429277600107268717e-02,
-1.432925689802726048e-02,
-1.436571106752434351e-02,
-1.440213845302908309e-02,
-1.443853899805569094e-02,
-1.447491264616660930e-02,
-1.451125934097380332e-02,
-1.454757902613742528e-02,
-1.458387164536708094e-02,
-1.462013714242110102e-02,
-1.465637546110748306e-02,
-1.469258654528296515e-02,
-1.472877033885390888e-02,
-1.476492678577577718e-02,
-1.480105583005411098e-02,
-1.483715741574352133e-02,
-1.487323148694835555e-02,
-1.490927798782332343e-02,
-1.494529686257188919e-02,
-1.498128805544853177e-02,
-1.501725151075697547e-02,
-1.505318717285161409e-02,
-1.508909498613653262e-02,
-1.512497489506657404e-02,
-1.516082684414650668e-02,
-1.519665077793193146e-02,
-1.523244664102843884e-02,
-1.526821437809296016e-02,
-1.530395393383249952e-02,
-1.533966525300529612e-02,
-1.537534828041981633e-02,
-1.541100296093641901e-02,
-1.544662923946567984e-02,
-1.548222706096948412e-02,
-1.551779637046158712e-02,
-1.555333711300572672e-02,
-1.558884923371835728e-02,
-1.562433267776643618e-02,
-1.565978739036895384e-02,
-1.569521331679623807e-02,
-1.573061040237071564e-02,
-1.576597859246613165e-02,
-1.580131783250847063e-02,
-1.583662806797517600e-02,
-1.587190924439656550e-02,
-1.590716130735423534e-02,
-1.594238420248252422e-02,
-1.597757787546758707e-02,
-1.601274227204854336e-02,
-1.604787733801646757e-02,
-1.608298301921529463e-02,
-1.611805926154121979e-02,
-1.615310601094329876e-02,
-1.618812321342380511e-02,
-1.622311081503710270e-02,
-1.625806876189110281e-02,
-1.629299700014625110e-02,
-1.632789547601675578e-02,
-1.636276413576929004e-02,
-1.639760292572437980e-02,
-1.643241179225538723e-02,
-1.646719068178972151e-02,
-1.650193954080779110e-02,
-1.653665831584382948e-02,
-1.657134695348556550e-02,
-1.660600540037486181e-02,
-1.664063360320707299e-02,
-1.667523150873167354e-02,
-1.670979906375190047e-02,
-1.674433621512522521e-02,
-1.677884290976355136e-02,
-1.681331909463260055e-02,
-1.684776471675262025e-02,
-1.688217972319805416e-02,
-1.691656406109833671e-02,
-1.695091767763685225e-02,
-1.698524052005218749e-02,
-1.701953253563709412e-02,
-1.705379367173969624e-02,
-1.708802387576249804e-02,
-1.712222309516345242e-02,
-1.715639127745504505e-02,
-1.719052837020541152e-02,
-1.722463432103737632e-02,
-1.725870907762965326e-02,
-1.729275258771551665e-02,
-1.732676479908432446e-02,
-1.736074565958099086e-02,
-1.739469511710551100e-02,
-1.742861311961405382e-02,
-1.746249961511804616e-02,
-1.749635455168544254e-02,
-1.753017787743943109e-02,
-1.756396954055966173e-02,
-1.759772948928140304e-02,
-1.763145767189672197e-02,
-1.766515403675323823e-02,
-1.769881853225532126e-02,
-1.773245110686333392e-02,
-1.776605170909488843e-02,
-1.779962028752284792e-02,
-1.783315679077807428e-02,
-1.786666116754710709e-02,
-1.790013336657386017e-02,
-1.793357333665860157e-02,
-1.796698102665902907e-02,
-1.800035638548971514e-02,
-1.803369936212175992e-02,
-1.806700990558434555e-02,
-1.810028796496316802e-02,
-1.813353348940164797e-02,
-1.816674642810002863e-02,
-1.819992673031691627e-02,
-1.823307434536766344e-02,
-1.826618922262572900e-02,
-1.829927131152168582e-02,
-1.833232056154482717e-02,
-1.836533692224118219e-02,
-1.839832034321563919e-02,
-1.843127077413042603e-02,
-1.846418816470634869e-02,
-1.849707246472173661e-02,
-1.852992362401390675e-02,
-1.856274159247811584e-02,
-1.859552632006757772e-02,
-1.862827775679484418e-02,
-1.866099585273018821e-02,
-1.869368055800298134e-02,
-1.872633182280080202e-02,
-1.875894959737065687e-02,
-1.879153383201777328e-02,
-1.882408447710655700e-02,
-1.885660148306012376e-02,
-1.888908480036135401e-02,
-1.892153437955106793e-02,
-1.895395017123054776e-02,
-1.898633212605935205e-02,
-1.901868019475703650e-02,
-1.905099432810207147e-02,
-1.908327447693308754e-02,
-1.911552059214748772e-02,
-1.914773262470268952e-02,
-1.917991052561626719e-02,
-1.921205424596472700e-02,
-1.924416373688513440e-02,
-1.927623894957387202e-02,
-1.930827983528816613e-02,
-1.934028634534444915e-02,
-1.937225843111991738e-02,
-1.940419604405153875e-02,
-1.943609913563708672e-02,
-1.946796765743411678e-02,
-1.949980156106131957e-02,
-1.953160079819711570e-02,
-1.956336532058132113e-02,
-1.959509508001354428e-02,
-1.962679002835507336e-02,
-1.965845011752728744e-02,
-1.969007529951260008e-02,
-1.972166552635479242e-02,
-1.975322075015799664e-02,
-1.978474092308802126e-02,
-1.981622599737117157e-02,
-1.984767592529590799e-02,
-1.987909065921115992e-02,
-1.991047015152778987e-02,
-1.994181435471760466e-02,
-1.997312322131457318e-02,
-2.000439670391334843e-02,
-2.003563475517143241e-02,
-2.006683732780700086e-02,
-2.009800437460054420e-02,
-2.012913584839420844e-02,
-2.016023170209247165e-02,
-2.019129188866130784e-02,
-2.022231636112909250e-02,
-2.025330507258625221e-02,
-2.028425797618542761e-02,
-2.031517502514179271e-02,
-2.034605617273235745e-02,
-2.037690137229722712e-02,
-2.040771057723831869e-02,
-2.043848374102080409e-02,
-2.046922081717181610e-02,
-2.049992175928178756e-02,
-2.053058652100341747e-02,
-2.056121505605284019e-02,
-2.059180731820853955e-02,
-2.062236326131229591e-02,
-2.065288283926869362e-02,
-2.068336600604586337e-02,
-2.071381271567477450e-02,
-2.074422292224976580e-02,
-2.077459657992823325e-02,
-2.080493364293153208e-02,
-2.083523406554419616e-02,
-2.086549780211396921e-02,
-2.089572480705277277e-02,
-2.092591503483564805e-02,
-2.095606844000177243e-02,
-2.098618497715395645e-02,
-2.101626460095885884e-02,
-2.104630726614705252e-02,
-2.107631292751329516e-02,
-2.110628153991617184e-02,
-2.113621305827860508e-02,
-2.116610743758739685e-02,
-2.119596463289423471e-02,
-2.122578459931444630e-02,
-2.125556729202821363e-02,
-2.128531266627990692e-02,
-2.131502067737878203e-02,
-2.134469128069817201e-02,
-2.137432443167653143e-02,
-2.140392008581713801e-02,
-2.143347819868743342e-02,
-2.146299872592041802e-02,
-2.149248162321340874e-02,
-2.152192684632926387e-02,
-2.155133435109547746e-02,
-2.158070409340503981e-02,
-2.161003602921585109e-02,
-2.163933011455116198e-02,
-2.166858630549936895e-02,
-2.169780455821473594e-02,
-2.172698482891642288e-02,
-2.175612707388949532e-02,
-2.178523124948420972e-02,
-2.181429731211693979e-02,
-2.184332521826942708e-02,
-2.187231492448911407e-02,
-2.190126638738970274e-02,
-2.193017956365041210e-02,
-2.195905441001657840e-02,
-2.198789088329942271e-02,
-2.201668894037643598e-02,
-2.204544853819102868e-02,
-2.207416963375330443e-02,
-2.210285218413899147e-02,
-2.213149614649074365e-02,
-2.216010147801702329e-02,
-2.218866813599352367e-02,
-2.221719607776178815e-02,
-2.224568526073022329e-02,
-2.227413564237388371e-02,
-2.230254718023460397e-02,
-2.233091983192086322e-02,
-2.235925355510811133e-02,
-2.238754830753857464e-02,
-2.241580404702143633e-02,
-2.244402073143321463e-02,
-2.247219831871713133e-02,
-2.250033676688379877e-02,
-2.252843603401063349e-02,
-2.255649607824320238e-02,
-2.258451685779339427e-02,
-2.261249833094124140e-02,
-2.264044045603358368e-02,
-2.266834319148560914e-02,
-2.269620649577920590e-02,
-2.272403032746474205e-02,
-2.275181464515927537e-02,
-2.277955940754877034e-02,
-2.280726457338614482e-02,
-2.283493010149264743e-02,
-2.286255595075716712e-02,
-2.289014208013677096e-02,
-2.291768844865669022e-02,
-2.294519501541009837e-02,
-2.297266173955842331e-02,
-2.300008858033111836e-02,
-2.302747549702647764e-02,
-2.305482244901055008e-02,
-2.308212939571817682e-02,
-2.310939629665244646e-02,
-2.313662311138528146e-02,
-2.316380979955677197e-02,
-2.319095632087614031e-02,
-2.321806263512086674e-02,
-2.324512870213771981e-02,
-2.327215448184169130e-02,
-2.329913993421714805e-02,
-2.332608501931720396e-02,
-2.335298969726385884e-02,
-2.337985392824843550e-02,
-2.340667767253128487e-02,
-2.343346089044196986e-02,
-2.346020354237884561e-02,
-2.348690558881037435e-02,
-2.351356699027363009e-02,
-2.354018770737563437e-02,
-2.356676770079231542e-02,
-2.359330693126981612e-02,
-2.361980535962309238e-02,
-2.364626294673742926e-02,
-2.367267965356718157e-02,
-2.369905544113707144e-02,
-2.372539027054116831e-02,
-2.375168410294361057e-02,
-2.377793689957816148e-02,
-2.380414862174917712e-02,
-2.383031923083021170e-02,
-2.385644868826561349e-02,
-2.388253695556959502e-02,
-2.390858399432636491e-02,
-2.393458976619095013e-02,
-2.396055423288794006e-02,
-2.398647735621289509e-02,
-2.401235909803131272e-02,
-2.403819942027974124e-02,
-2.406399828496467996e-02,
-2.408975565416359918e-02,
-2.411547149002415957e-02,
-2.414114575476553406e-02,
-2.416677841067652391e-02,
-2.419236942011776179e-02,
-2.421791874552003607e-02,
-2.424342634938543226e-02,
-2.426889219428665645e-02,
-2.429431624286788535e-02,
-2.431969845784409667e-02,
-2.434503880200112810e-02,
-2.437033723819660713e-02,
-2.439559372935877143e-02,
-2.442080823848763460e-02,
-2.444598072865403898e-02,
-2.447111116300089081e-02,
-2.449619950474190080e-02,
-2.452124571716260415e-02,
-2.454624976361977767e-02,
-2.457121160754247718e-02,
-2.459613121243039990e-02,
-2.462100854185587592e-02,
-2.464584355946249083e-02,
-2.467063622896581085e-02,
-2.469538651415304972e-02,
-2.472009437888370714e-02,
-2.474475978708881932e-02,
-2.476938270277162166e-02,
-2.479396309000774304e-02,
-2.481850091294431765e-02,
-2.484299613580109520e-02,
-2.486744872286960478e-02,
-2.489185863851437613e-02,
-2.491622584717161082e-02,
-2.494055031335006348e-02,
-2.496483200163081284e-02,
-2.498907087666796603e-02,
-2.501326690318712853e-02,
-2.503742004598748586e-02,
-2.506153026994032904e-02,
-2.508559753998968259e-02,
-2.510962182115218655e-02,
-2.513360307851769324e-02,
-2.515754127724835823e-02,
-2.518143638257942796e-02,
-2.520528835981918417e-02,
-2.522909717434865945e-02,
-2.525286279162220621e-02,
-2.527658517716660502e-02,
-2.530026429658269183e-02,
-2.532390011554361622e-02,
-2.534749259979627786e-02,
-2.537104171516039661e-02,
-2.539454742752975808e-02,
-2.541800970287041994e-02,
-2.544142850722276930e-02,
-2.546480380670018348e-02,
-2.548813556748972739e-02,
-2.551142375585184821e-02,
-2.553466833812086459e-02,
-2.555786928070444969e-02,
-2.558102655008424528e-02,
-2.560414011281509500e-02,
-2.562720993552646681e-02,
-2.565023598492096810e-02,
-2.567321822777527893e-02,
-2.569615663094025268e-02,
-2.571905116134030542e-02,
-2.574190178597431100e-02,
-2.576470847191469210e-02,
-2.578747118630863103e-02,
-2.581018989637670971e-02,
-2.583286456941451953e-02,
-2.585549517279123535e-02,
-2.587808167395072578e-02,
-2.590062404041089048e-02,
-2.592312223976444077e-02,
-2.594557623967808785e-02,
-2.596798600789335457e-02,
-2.599035151222596138e-02,
-2.601267272056655144e-02,
-2.603494960088030899e-02,
-2.605718212120652910e-02,
-2.607937024966018244e-02,
-2.610151395443019093e-02,
-2.612361320378064899e-02,
-2.614566796605027194e-02,
-2.616767820965279490e-02,
-2.618964390307684104e-02,
-2.621156501488607418e-02,
-2.623344151371892474e-02,
-2.625527336828933911e-02,
-2.627706054738574576e-02,
-2.629880301987236671e-02,
-2.632050075468812811e-02,
-2.634215372084735066e-02,
-2.636376188743955878e-02,
-2.638532522362982066e-02,
-2.640684369865827635e-02,
-2.642831728184062354e-02,
-2.644974594256804812e-02,
-2.647112965030694667e-02,
-2.649246837459976259e-02,
-2.651376208506378562e-02,
-2.653501075139261603e-02,
-2.655621434335493289e-02,
-2.657737283079572577e-02,
-2.659848618363511510e-02,
-2.661955437186946244e-02,
-2.664057736557038161e-02,
-2.666155513488617512e-02,
-2.668248765004027981e-02,
-2.670337488133263382e-02,
-2.672421679913861148e-02,
-2.674501337391006067e-02,
-2.676576457617486221e-02,
-2.678647037653660370e-02,
-2.680713074567555795e-02,
-2.682774565434776701e-02,
-2.684831507338585749e-02,
-2.686883897369833282e-02,
-2.688931732627021509e-02,
-2.690975010216284033e-02,
-2.693013727251412220e-02,
-2.695047880853792058e-02,
-2.697077468152518642e-02,
-2.699102486284268160e-02,
-2.701122932393439785e-02,
-2.703138803632040843e-02,
-2.705150097159771463e-02,
-2.707156810143968723e-02,
-2.709158939759676032e-02,
-2.711156483189567853e-02,
-2.713149437624036778e-02,
-2.715137800261122752e-02,
-2.717121568306573795e-02,
-2.719100738973837320e-02,
-2.721075309484008442e-02,
-2.723045277065916717e-02,
-2.725010638956073053e-02,
-2.726971392398722799e-02,
-2.728927534645773229e-02,
-2.730879062956886177e-02,
-2.732825974599402755e-02,
-2.734768266848402324e-02,
-2.736705936986686891e-02,
-2.738638982304792552e-02,
-2.740567400100949250e-02,
-2.742491187681167161e-02,
-2.744410342359164534e-02,
-2.746324861456410360e-02,
-2.748234742302108069e-02,
-2.750139982233223285e-02,
-2.752040578594468559e-02,
-2.753936528738296433e-02,
-2.755827830024951824e-02,
-2.757714479822394663e-02,
-2.759596475506400498e-02,
-2.761473814460473422e-02,
-2.763346494075917537e-02,
-2.765214511751789422e-02,
-2.767077864894969264e-02,
-2.768936550920063702e-02,
-2.770790567249493963e-02,
-2.772639911313474342e-02,
-2.774484580550008392e-02,
-2.776324572404902449e-02,
-2.778159884331745516e-02,
-2.779990513791954013e-02,
-2.781816458254718002e-02,
-2.783637715197094520e-02,
-2.785454282103873996e-02,
-2.787266156467750611e-02,
-2.789073335789169286e-02,
-2.790875817576451631e-02,
-2.792673599345692897e-02,
-2.794466678620870573e-02,
-2.796255052933754176e-02,
-2.798038719823980544e-02,
-2.799817676839008729e-02,
-2.801591921534149487e-02,
-2.803361451472558344e-02,
-2.805126264225242874e-02,
-2.806886357371046747e-02,
-2.808641728496700379e-02,
-2.810392375196758483e-02,
-2.812138295073685068e-02,
-2.813879485737738953e-02,
-2.815615944807122600e-02,
-2.817347669907867974e-02,
-2.819074658673888928e-02,
-2.820796908746986756e-02,
-2.822514417776823478e-02,
-2.824227183420989842e-02,
-2.825935203344887015e-02,
-2.827638475221882705e-02,
-2.829336996733192860e-02,
-2.831030765567974991e-02,
-2.832719779423210210e-02,
-2.834404036003855890e-02,
-2.836083533022741229e-02,
-2.837758268200601605e-02,
-2.839428239266096957e-02,
-2.841093443955794440e-02,
-2.842753880014167386e-02,
-2.844409545193629998e-02,
-2.846060437254512715e-02,
-2.847706553965055273e-02,
-2.849347893101455281e-02,
-2.850984452447813400e-02,
-2.852616229796184691e-02,
-2.854243222946531433e-02,
-2.855865429706815409e-02,
-2.857482847892879943e-02,
-2.859095475328538027e-02,
-2.860703309845544565e-02,
-2.862306349283643553e-02,
-2.863904591490453594e-02,
-2.865498034321638590e-02,
-2.867086675640748497e-02,
-2.868670513319348386e-02,
-2.870249545236923730e-02,
-2.871823769280986219e-02,
-2.873393183346939841e-02,
-2.874957785338231805e-02,
-2.876517573166250188e-02,
-2.878072544750362796e-02,
-2.879622698017923060e-02,
-2.881168030904252692e-02,
-2.882708541352708986e-02,
-2.884244227314562009e-02,
-2.885775086749140309e-02,
-2.887301117623725447e-02,
-2.888822317913617571e-02,
-2.890338685602083721e-02,
-2.891850218680433460e-02,
-2.893356915147958508e-02,
-2.894858773011958070e-02,
-2.896355790287737098e-02,
-2.897847964998623987e-02,
-2.899335295175927557e-02,
-2.900817778859017537e-02,
-2.902295414095274612e-02,
-2.903768198940054682e-02,
-2.905236131456796073e-02,
-2.906699209716907470e-02,
-2.908157431799886228e-02,
-2.909610795793208388e-02,
-2.911059299792397373e-02,
-2.912502941901035786e-02,
-2.913941720230703650e-02,
-2.915375632901047107e-02,
-2.916804678039756557e-02,
-2.918228853782540641e-02,
-2.919648158273193891e-02,
-2.921062589663507222e-02,
-2.922472146113389707e-02,
-2.923876825790734657e-02,
-2.925276626871540706e-02,
-2.926671547539830276e-02,
-2.928061585987710991e-02,
-2.929446740415345488e-02,
-2.930827009030949337e-02,
-2.932202390050816718e-02,
-2.933572881699305843e-02,
-2.934938482208853186e-02,
-2.936299189819949196e-02,
-2.937655002781177846e-02,
-2.939005919349173268e-02,
-2.940351937788691569e-02,
-2.941693056372537626e-02,
-2.943029273381603944e-02,
-2.944360587104870308e-02,
-2.945686995839409336e-02,
-2.947008497890367743e-02,
-2.948325091571009707e-02,
-2.949636775202656505e-02,
-2.950943547114762838e-02,
-2.952245405644854034e-02,
-2.953542349138549294e-02,
-2.954834375949595346e-02,
-2.956121484439825503e-02,
-2.957403672979179096e-02,
-2.958680939945688634e-02,
-2.959953283725539133e-02,
-2.961220702712951888e-02,
-2.962483195310340600e-02,
-2.963740759928166352e-02,
-2.964993394985060080e-02,
-2.966241098907727858e-02,
-2.967483870131024451e-02,
-2.968721707097902313e-02,
-2.969954608259455300e-02,
-2.971182572074887104e-02,
-2.972405597011545941e-02,
-2.973623681544888125e-02,
-2.974836824158497497e-02,
-2.976045023344132609e-02,
-2.977248277601621598e-02,
-2.978446585438986396e-02,
-2.979639945372326501e-02,
-2.980828355925941447e-02,
-2.982011815632204521e-02,
-2.983190323031697372e-02,
-2.984363876673110094e-02,
-2.985532475113257533e-02,
-2.986696116917145552e-02,
-2.987854800657895049e-02,
-2.989008524916779777e-02,
-2.990157288283245424e-02,
-2.991301089354868326e-02,
-2.992439926737397449e-02,
-2.993573799044695408e-02,
-2.994702704898845325e-02,
-2.995826642930041542e-02,
-2.996945611776642357e-02,
-2.998059610085182514e-02,
-2.999168636510370425e-02,
-3.000272689715035093e-02,
-3.001371768370207985e-02,
-3.002465871155080707e-02,
-3.003554996757010209e-02,
-3.004639143871507337e-02,
-3.005718311202279849e-02,
-3.006792497461210564e-02,
-3.007861701368310173e-02,
-3.008925921651822016e-02,
-3.009985157048124596e-02,
-3.011039406301795757e-02,
-3.012088668165580421e-02,
-3.013132941400413142e-02,
-3.014172224775395550e-02,
-3.015206517067842845e-02,
-3.016235817063210589e-02,
-3.017260123555166526e-02,
-3.018279435345564560e-02,
-3.019293751244431223e-02,
-3.020303070070014598e-02,
-3.021307390648699312e-02,
-3.022306711815106114e-02,
-3.023301032412012077e-02,
-3.024290351290441839e-02,
-3.025274667309559712e-02,
-3.026253979336736982e-02,
-3.027228286247555730e-02,
-3.028197586925789053e-02,
-3.029161880263418760e-02,
-3.030121165160602065e-02,
-3.031075440525703157e-02,
-3.032024705275320614e-02,
-3.032968958334223905e-02,
-3.033908198635360681e-02,
-3.034842425119944551e-02,
-3.035771636737354465e-02,
-3.036695832445185372e-02,
-3.037615011209244056e-02,
-3.038529172003530399e-02,
-3.039438313810272421e-02,
-3.040342435619895756e-02,
-3.041241536431047235e-02,
-3.042135615250570607e-02,
-3.043024671093520761e-02,
-3.043908702983190440e-02,
-3.044787709951071036e-02,
-3.045661691036866472e-02,
-3.046530645288501871e-02,
-3.047394571762113147e-02,
-3.048253469522058459e-02,
-3.049107337640906065e-02,
-3.049956175199457567e-02,
-3.050799981286714604e-02,
-3.051638754999936448e-02,
-3.052472495444555345e-02,
-3.053301201734245907e-02,
-3.054124872990916437e-02,
-3.054943508344693665e-02,
-3.055757106933911643e-02,
-3.056565667905133607e-02,
-3.057369190413172441e-02,
-3.058167673621044885e-02,
-3.058961116699979513e-02,
-3.059749518829475712e-02,
-3.060532879197209316e-02,
-3.061311196999124892e-02,
-3.062084471439368433e-02,
-3.062852701730335581e-02,
-3.063615887092628956e-02,
-3.064374026755109157e-02,
-3.065127119954829532e-02,
-3.065875165937120839e-02,
-3.066618163955514911e-02,
-3.067356113271763746e-02,
-3.068089013155877662e-02,
-3.068816862886097202e-02,
-3.069539661748892437e-02,
-3.070257409038950128e-02,
-3.070970104059220565e-02,
-3.071677746120859628e-02,
-3.072380334543283256e-02,
-3.073077868654117140e-02,
-3.073770347789250498e-02,
-3.074457771292775018e-02,
-3.075140138517043140e-02,
-3.075817448822648625e-02,
-3.076489701578402625e-02,
-3.077156896161344773e-02,
-3.077819031956783441e-02,
-3.078476108358242300e-02,
-3.079128124767483918e-02,
-3.079775080594518433e-02,
-3.080416975257590367e-02,
-3.081053808183174814e-02,
-3.081685578805986453e-02,
-3.082312286568986495e-02,
-3.082933930923369148e-02,
-3.083550511328566474e-02,
-3.084162027252249430e-02,
-3.084768478170344178e-02,
-3.085369863566974485e-02,
-3.085966182934560612e-02,
-3.086557435773697525e-02,
-3.087143621593270784e-02,
-3.087724739910388191e-02,
-3.088300790250394015e-02,
-3.088871772146872113e-02,
-3.089437685141647322e-02,
-3.089998528784775392e-02,
-3.090554302634575951e-02,
-3.091105006257564153e-02,
-3.091650639228546438e-02,
-3.092191201130541425e-02,
-3.092726691554789284e-02,
-3.093257110100801344e-02,
-3.093782456376302503e-02,
-3.094302729997281884e-02,
-3.094817930587949115e-02,
-3.095328057780757230e-02,
-3.095833111216374917e-02,
-3.096333090543751734e-02,
-3.096827995420054630e-02,
-3.097317825510684935e-02,
-3.097802580489264490e-02,
-3.098282260037690111e-02,
-3.098756863846077736e-02,
-3.099226391612767625e-02,
-3.099690843044361835e-02,
-3.100150217855667314e-02,
-3.100604515769747951e-02,
-3.101053736517898202e-02,
-3.101497879839651070e-02,
-3.101936945482777763e-02,
-3.102370933203274159e-02,
-3.102799842765364621e-02,
-3.103223673941537392e-02,
-3.103642426512465483e-02,
-3.104056100267109375e-02,
-3.104464695002608424e-02,
-3.104868210524391187e-02,
-3.105266646646070300e-02,
-3.105660003189510132e-02,
-3.106048279984805621e-02,
-3.106431476870277070e-02,
-3.106809593692468410e-02,
-3.107182630306179472e-02,
-3.107550586574417059e-02,
-3.107913462368402588e-02,
-3.108271257567631063e-02,
-3.108623972059768037e-02,
-3.108971605740751959e-02,
-3.109314158514724091e-02,
-3.109651630294052449e-02,
-3.109984020999347412e-02,
-3.110311330559415235e-02,
-3.110633558911295865e-02,
-3.110950706000280633e-02,
-3.111262771779838010e-02,
-3.111569756211690629e-02,
-3.111871659265759080e-02,
-3.112168480920194866e-02,
-3.112460221161396021e-02,
-3.112746879983913431e-02,
-3.113028457390595513e-02,
-3.113304953392438332e-02,
-3.113576368008692807e-02,
-3.113842701266821694e-02,
-3.114103953202489172e-02,
-3.114360123859580276e-02,
-3.114611213290209221e-02,
-3.114857221554675690e-02,
-3.115098148721514443e-02,
-3.115333994867449524e-02,
-3.115564760077425485e-02,
-3.115790444444596283e-02,
-3.116011048070334993e-02,
-3.116226571064187670e-02,
-3.116437013543947240e-02,
-3.116642375635592099e-02,
-3.116842657473298250e-02,
-3.117037859199459776e-02,
-3.117227980964661777e-02,
-3.117413022927709859e-02,
-3.117592985255571159e-02,
-3.117767868123452746e-02,
-3.117937671714749587e-02,
-3.118102396221030664e-02,
-3.118262041842086510e-02,
-3.118416608785900060e-02,
-3.118566097268639370e-02,
-3.118710507514671493e-02,
-3.118849839756543743e-02,
-3.118984094235022556e-02,
-3.119113271199025830e-02,
-3.119237370905690240e-02,
-3.119356393620330639e-02,
-3.119470339616429999e-02,
-3.119579209175688678e-02,
-3.119683002587970988e-02,
-3.119781720151330526e-02,
-3.119875362171974434e-02,
-3.119963928964350833e-02,
-3.120047420851022532e-02,
-3.120125838162773890e-02,
-3.120199181238535180e-02,
-3.120267450425437405e-02,
-3.120330646078762690e-02,
-3.120388768561985562e-02,
-3.120441818246732710e-02,
-3.120489795512810735e-02,
-3.120532700748201646e-02,
-3.120570534349036834e-02,
-3.120603296719634545e-02,
-3.120630988272442979e-02,
-3.120653609428127723e-02,
-3.120671160615450315e-02,
-3.120683642271387948e-02,
-3.120691054841030418e-02,
-3.120693398777669297e-02,
-3.120690674542721602e-02,
-3.120682882605774547e-02,
-3.120670023444539407e-02,
-3.120652097544918124e-02,
-3.120629105400923864e-02,
-3.120601047514757684e-02,
-3.120567924396723536e-02,
-3.120529736565315349e-02,
-3.120486484547123004e-02,
-3.120438168876926710e-02,
-3.120384790097599850e-02,
-3.120326348760198848e-02,
-3.120262845423871570e-02,
-3.120194280655937125e-02,
-3.120120655031831391e-02,
-3.120041969135119858e-02,
-3.119958223557521212e-02,
-3.119869418898846974e-02,
-3.119775555767061170e-02,
-3.119676634778248067e-02,
-3.119572656556600376e-02,
-3.119463621734453948e-02,
-3.119349530952256547e-02,
-3.119230384858560565e-02,
-3.119106184110047655e-02,
-3.118976929371531509e-02,
-3.118842621315897137e-02,
-3.118703260624163323e-02,
-3.118558847985469437e-02,
-3.118409384097032763e-02,
-3.118254869664210949e-02,
-3.118095305400425676e-02,
-3.117930692027238992e-02,
-3.117761030274278367e-02,
-3.117586320879287692e-02,
-3.117406564588113063e-02,
-3.117221762154671200e-02,
-3.117031914340987614e-02,
-3.116837021917182732e-02,
-3.116637085661433035e-02,
-3.116432106360048429e-02,
-3.116222084807384121e-02,
-3.116007021805893007e-02,
-3.115786918166113528e-02,
-3.115561774706637407e-02,
-3.115331592254154749e-02,
-3.115096371643435655e-02,
-3.114856113717299688e-02,
-3.114610819326631488e-02,
-3.114360489330420673e-02,
-3.114105124595675789e-02,
-3.113844725997515911e-02,
-3.113579294419079393e-02,
-3.113308830751573483e-02,
-3.113033335894277789e-02,
-3.112752810754517915e-02,
-3.112467256247671357e-02,
-3.112176673297152585e-02,
-3.111881062834458839e-02,
-3.111580425799088251e-02,
-3.111274763138615132e-02,
-3.110964075808647991e-02,
-3.110648364772812535e-02,
-3.110327631002793303e-02,
-3.110001875478324296e-02,
-3.109671099187130694e-02,
-3.109335303124997896e-02,
-3.108994488295718089e-02,
-3.108648655711130498e-02,
-3.108297806391071422e-02,
-3.107941941363424193e-02,
-3.107581061664062283e-02,
-3.107215168336905850e-02,
-3.106844262433853046e-02,
-3.106468345014834834e-02,
-3.106087417147794516e-02,
-3.105701479908673512e-02,
-3.105310534381391235e-02,
-3.104914581657918643e-02,
-3.104513622838165482e-02,
-3.104107659030110739e-02,
-3.103696691349651371e-02,
-3.103280720920726862e-02,
-3.102859748875238383e-02,
-3.102433776353078973e-02,
-3.102002804502129729e-02,
-3.101566834478244883e-02,
-3.101125867445263945e-02,
-3.100679904575004767e-02,
-3.100228947047236477e-02,
-3.099772996049713833e-02,
-3.099312052778167501e-02,
-3.098846118436285324e-02,
-3.098375194235698793e-02,
-3.097899281396023982e-02,
-3.097418381144825122e-02,
-3.096932494717614601e-02,
-3.096441623357867878e-02,
-3.095945768316987756e-02,
-3.095444930854347396e-02,
-3.094939112237252848e-02,
-3.094428313740947567e-02,
-3.093912536648622466e-02,
-3.093391782251373248e-02,
-3.092866051848268058e-02,
-3.092335346746271155e-02,
-3.091799668260302586e-02,
-3.091259017713182330e-02,
-3.090713396435657012e-02,
-3.090162805766394349e-02,
-3.089607247051974828e-02,
-3.089046721646892049e-02,
-3.088481230913543707e-02,
-3.087910776222244427e-02,
-3.087335358951194542e-02,
-3.086754980486514782e-02,
-3.086169642222194587e-02,
-3.085579345560168427e-02,
-3.084984091910188478e-02,
-3.084383882689970685e-02,
-3.083778719325060841e-02,
-3.083168603248925138e-02,
-3.082553535902863781e-02,
-3.081933518736112293e-02,
-3.081308553205729106e-02,
-3.080678640776671889e-02,
-3.080043782921738915e-02,
-3.079403981121617978e-02,
-3.078759236864853782e-02,
-3.078109551647839615e-02,
-3.077454926974809019e-02,
-3.076795364357891999e-02,
-3.076130865317011631e-02,
-3.075461431379992311e-02,
-3.074787064082454280e-02,
-3.074107764967863934e-02,
-3.073423535587549438e-02,
-3.072734377500657352e-02,
-3.072040292274142922e-02,
-3.071341281482817265e-02,
-3.070637346709302606e-02,
-3.069928489544021880e-02,
-3.069214711585252844e-02,
-3.068496014439054537e-02,
-3.067772399719311677e-02,
-3.067043869047697199e-02,
-3.066310424053710765e-02,
-3.065572066374635390e-02,
-3.064828797655547166e-02,
-3.064080619549331558e-02,
-3.063327533716644208e-02,
-3.062569541825944236e-02,
-3.061806645553457468e-02,
-3.061038846583207657e-02,
-3.060266146606976240e-02,
-3.059488547324313093e-02,
-3.058706050442561511e-02,
-3.057918657676823512e-02,
-3.057126370749936942e-02,
-3.056329191392527164e-02,
-3.055527121342965433e-02,
-3.054720162347368886e-02,
-3.053908316159606104e-02,
-3.053091584541302653e-02,
-3.052269969261787660e-02,
-3.051443472098181245e-02,
-3.050612094835291471e-02,
-3.049775839265683394e-02,
-3.048934707189639853e-02,
-3.048088700415151758e-02,
-3.047237820757955559e-02,
-3.046382070041482593e-02,
-3.045521450096905572e-02,
-3.044655962763066423e-02,
-3.043785609886531102e-02,
-3.042910393321573634e-02,
-3.042030314930149054e-02,
-3.041145376581915263e-02,
-3.040255580154226783e-02,
-3.039360927532111165e-02,
-3.038461420608292926e-02,
-3.037557061283148105e-02,
-3.036647851464768788e-02,
-3.035733793068875683e-02,
-3.034814888018892015e-02,
-3.033891138245880040e-02,
-3.032962545688569142e-02,
-3.032029112293351328e-02,
-3.031090840014273244e-02,
-3.030147730813006340e-02,
-3.029199786658889892e-02,
-3.028247009528896999e-02,
-3.027289401407633543e-02,
-3.026326964287346516e-02,
-3.025359700167912572e-02,
-3.024387611056808881e-02,
-3.023410698969165866e-02,
-3.022428965927713429e-02,
-3.021442413962798640e-02,
-3.020451045112376026e-02,
-3.019454861422011388e-02,
-3.018453864944855430e-02,
-3.017448057741687131e-02,
-3.016437441880836720e-02,
-3.015422019438261658e-02,
-3.014401792497474128e-02,
-3.013376763149598625e-02,
-3.012346933493317142e-02,
-3.011312305634874717e-02,
-3.010272881688106500e-02,
-3.009228663774398196e-02,
-3.008179654022710356e-02,
-3.007125854569549228e-02,
-3.006067267558958436e-02,
-3.005003895142576570e-02,
-3.003935739479538305e-02,
-3.002862802736538939e-02,
-3.001785087087793791e-02,
-3.000702594715096150e-02,
-2.999615327807708329e-02,
-2.998523288562437647e-02,
-2.997426479183620124e-02,
-2.996324901883108682e-02,
-2.995218558880249904e-02,
-2.994107452401893049e-02,
-2.992991584682425099e-02,
-2.991870957963684366e-02,
-2.990745574495039250e-02,
-2.989615436533312257e-02,
-2.988480546342847655e-02,
-2.987340906195448675e-02,
-2.986196518370395556e-02,
-2.985047385154441374e-02,
-2.983893508841818989e-02,
-2.982734891734195246e-02,
-2.981571536140725440e-02,
-2.980403444378000935e-02,
-2.979230618770071365e-02,
-2.978053061648438735e-02,
-2.976870775352023421e-02,
-2.975683762227180826e-02,
-2.974492024627745090e-02,
-2.973295564914932299e-02,
-2.972094385457376212e-02,
-2.970888488631172331e-02,
-2.969677876819785262e-02,
-2.968462552414125738e-02,
-2.967242517812468741e-02,
-2.966017775420540584e-02,
-2.964788327651414479e-02,
-2.963554176925585135e-02,
-2.962315325670917751e-02,
-2.961071776322690002e-02,
-2.959823531323496626e-02,
-2.958570593123375364e-02,
-2.957312964179682757e-02,
-2.956050646957143757e-02,
-2.954783643927879483e-02,
-2.953511957571338872e-02,
-2.952235590374298335e-02,
-2.950954544830913101e-02,
-2.949668823442689811e-02,
-2.948378428718401861e-02,
-2.947083363174244144e-02,
-2.945783629333676573e-02,
-2.944479229727499370e-02,
-2.943170166893822881e-02,
-2.941856443378085273e-02,
-2.940538061733015407e-02,
-2.939215024518650882e-02,
-2.937887334302312359e-02,
-2.936554993658656298e-02,
-2.935218005169573305e-02,
-2.933876371424281801e-02,
-2.932530095019229149e-02,
-2.931179178558199899e-02,
-2.929823624652183600e-02,
-2.928463435919483743e-02,
-2.927098614985633104e-02,
-2.925729164483424627e-02,
-2.924355087052903437e-02,
-2.922976385341360950e-02,
-2.921593062003327232e-02,
-2.920205119700547067e-02,
-2.918812561102023667e-02,
-2.917415388883978777e-02,
-2.916013605729843305e-02,
-2.914607214330254548e-02,
-2.913196217383101638e-02,
-2.911780617593400997e-02,
-2.910360417673454533e-02,
-2.908935620342692485e-02,
-2.907506228327784437e-02,
-2.906072244362548421e-02,
-2.904633671187988389e-02,
-2.903190511552305661e-02,
-2.901742768210822596e-02,
-2.900290443926089104e-02,
-2.898833541467751851e-02,
-2.897372063612660073e-02,
-2.895906013144789251e-02,
-2.894435392855248396e-02,
-2.892960205542302946e-02,
-2.891480454011356380e-02,
-2.889996141074912747e-02,
-2.888507269552628015e-02,
-2.887013842271246231e-02,
-2.885515862064657461e-02,
-2.884013331773837077e-02,
-2.882506254246866573e-02,
-2.880994632338931133e-02,
-2.879478468912292227e-02,
-2.877957766836311201e-02,
-2.876432528987426379e-02,
-2.874902758249149939e-02,
-2.873368457512054039e-02,
-2.871829629673813139e-02,
-2.870286277639108249e-02,
-2.868738404319725113e-02,
-2.867186012634466430e-02,
-2.865629105509182040e-02,
-2.864067685876779679e-02,
-2.862501756677169121e-02,
-2.860931320857317689e-02,
-2.859356381371210357e-02,
-2.857776941179820951e-02,
-2.856193003251162460e-02,
-2.854604570560254767e-02,
-2.853011646089096548e-02,
-2.851414232826704129e-02,
-2.849812333769078179e-02,
-2.848205951919187059e-02,
-2.846595090286990065e-02,
-2.844979751889445060e-02,
-2.843359939750412721e-02,
-2.841735656900791149e-02,
-2.840106906378381257e-02,
-2.838473691227957202e-02,
-2.836836014501237235e-02,
-2.835193879256882668e-02,
-2.833547288560464214e-02,
-2.831896245484534502e-02,
-2.830240753108503177e-02,
-2.828580814518769082e-02,
-2.826916432808567262e-02,
-2.825247611078099061e-02,
-2.823574352434437759e-02,
-2.821896659991575754e-02,
-2.820214536870346844e-02,
-2.818527986198527541e-02,
-2.816837011110745470e-02,
-2.815141614748477294e-02,
-2.813441800260125386e-02,
-2.811737570800879049e-02,
-2.810028929532868217e-02,
-2.808315879624996569e-02,
-2.806598424253039029e-02,
-2.804876566599621979e-02,
-2.803150309854204533e-02,
-2.801419657213044187e-02,
-2.799684611879261695e-02,
-2.797945177062742886e-02,
-2.796201355980231298e-02,
-2.794453151855235198e-02,
-2.792700567918091417e-02,
-2.790943607405909146e-02,
-2.789182273562591449e-02,
-2.787416569638822769e-02,
-2.785646498892055054e-02,
-2.783872064586517467e-02,
-2.782093269993190371e-02,
-2.780310118389831345e-02,
-2.778522613060922450e-02,
-2.776730757297723312e-02,
-2.774934554398183692e-02,
-2.773134007667047221e-02,
-2.771329120415735869e-02,
-2.769519895962425579e-02,
-2.767706337631976182e-02,
-2.765888448755987258e-02,
-2.764066232672740195e-02,
-2.762239692727236351e-02,
-2.760408832271134608e-02,
-2.758573654662815205e-02,
-2.756734163267321458e-02,
-2.754890361456343445e-02,
-2.753042252608301974e-02,
-2.751189840108214310e-02,
-2.749333127347802427e-02,
-2.747472117725393778e-02,
-2.745606814646010460e-02,
-2.743737221521246744e-02,
-2.741863341769387730e-02,
-2.739985178815308037e-02,
-2.738102736090520725e-02,
-2.736216017033126988e-02,
-2.734325025087857089e-02,
-2.732429763706041223e-02,
-2.730530236345585227e-02,
-2.728626446470989661e-02,
-2.726718397553357445e-02,
-2.724806093070330365e-02,
-2.722889536506162972e-02,
-2.720968731351625092e-02,
-2.719043681104066704e-02,
-2.717114389267415164e-02,
-2.715180859352078410e-02,
-2.713243094875083389e-02,
-2.711301099359897035e-02,
-2.709354876336597315e-02,
-2.707404429341733754e-02,
-2.705449761918373927e-02,
-2.703490877616096869e-02,
-2.701527779990988212e-02,
-2.699560472605612438e-02,
-2.697588959029054850e-02,
-2.695613242836819926e-02,
-2.693633327610950312e-02,
-2.691649216939930728e-02,
-2.689660914418706000e-02,
-2.687668423648685578e-02,
-2.685671748237703285e-02,
-2.683670891800091912e-02,
-2.681665857956536808e-02,
-2.679656650334254556e-02,
-2.677643272566787927e-02,
-2.675625728294167213e-02,
-2.673604021162796773e-02,
-2.671578154825503607e-02,
-2.669548132941503352e-02,
-2.667513959176401675e-02,
-2.665475637202193576e-02,
-2.663433170697267205e-02,
-2.661386563346346268e-02,
-2.659335818840548663e-02,
-2.657280940877340333e-02,
-2.655221933160554007e-02,
-2.653158799400339579e-02,
-2.651091543313215115e-02,
-2.649020168622037708e-02,
-2.646944679055921942e-02,
-2.644865078350412679e-02,
-2.642781370247258843e-02,
-2.640693558494592447e-02,
-2.638601646846809937e-02,
-2.636505639064617296e-02,
-2.634405538914974185e-02,
-2.632301350171170964e-02,
-2.630193076612712816e-02,
-2.628080722025449845e-02,
-2.625964290201393200e-02,
-2.623843784938894794e-02,
-2.621719210042496376e-02,
-2.619590569323027376e-02,
-2.617457866597473759e-02,
-2.615321105689144554e-02,
-2.613180290427504285e-02,
-2.611035424648237152e-02,
-2.608886512193262994e-02,
-2.606733556910657140e-02,
-2.604576562654727784e-02,
-2.602415533285941385e-02,
-2.600250472670974020e-02,
-2.598081384682628808e-02,
-2.595908273199919528e-02,
-2.593731142107985957e-02,
-2.591549995298142450e-02,
-2.589364836667831793e-02,
-2.587175670120643589e-02,
-2.584982499566299691e-02,
-2.582785328920644830e-02,
-2.580584162105611576e-02,
-2.578379003049321994e-02,
-2.576169855685905494e-02,
-2.573956723955659470e-02,
-2.571739611804947298e-02,
-2.569518523186186190e-02,
-2.567293462057923178e-02,
-2.565064432384727561e-02,
-2.562831438137289086e-02,
-2.560594483292264606e-02,
-2.558353571832442178e-02,
-2.556108707746610267e-02,
-2.553859895029599036e-02,
-2.551607137682270973e-02,
-2.549350439711504240e-02,
-2.547089805130189552e-02,
-2.544825237957225317e-02,
-2.542556742217496821e-02,
-2.540284321941932433e-02,
-2.538007981167355806e-02,
-2.535727723936661085e-02,
-2.533443554298669964e-02,
-2.531155476308137586e-02,
-2.528863494025844136e-02,
-2.526567611518465428e-02,
-2.524267832858656871e-02,
-2.521964162124969155e-02,
-2.519656603401923198e-02,
-2.517345160779939708e-02,
-2.515029838355356193e-02,
-2.512710640230404052e-02,
-2.510387570513256117e-02,
-2.508060633317920132e-02,
-2.505729832764348741e-02,
-2.503395172978318053e-02,
-2.501056658091528259e-02,
-2.498714292241489485e-02,
-2.496368079571616161e-02,
-2.494018024231140634e-02,
-2.491664130375170066e-02,
-2.489306402164597615e-02,
-2.486944843766181190e-02,
-2.484579459352512232e-02,
-2.482210253101949440e-02,
-2.479837229198693718e-02,
-2.477460391832729536e-02,
-2.475079745199849912e-02,
-2.472695293501610617e-02,
-2.470307040945358967e-02,
-2.467914991744190462e-02,
-2.465519150117004635e-02,
-2.463119520288417630e-02,
-2.460716106488818750e-02,
-2.458308912954298292e-02,
-2.455897943926737062e-02,
-2.453483203653688757e-02,
-2.451064696388479888e-02,
-2.448642426390085572e-02,
-2.446216397923217656e-02,
-2.443786615258310493e-02,
-2.441353082671422411e-02,
-2.438915804444359223e-02,
-2.436474784864541346e-02,
-2.434030028225121073e-02,
-2.431581538824841016e-02,
-2.429129320968148251e-02,
-2.426673378965108277e-02,
-2.424213717131426873e-02,
-2.421750339788438997e-02,
-2.419283251263128556e-02,
-2.416812455888036823e-02,
-2.414337958001355755e-02,
-2.411859761946867631e-02,
-2.409377872073956151e-02,
-2.406892292737551967e-02,
-2.404403028298198255e-02,
-2.401910083122014983e-02,
-2.399413461580627085e-02,
-2.396913168051281740e-02,
-2.394409206916727970e-02,
-2.391901582565291590e-02,
-2.389390299390777017e-02,
-2.386875361792558173e-02,
-2.384356774175502500e-02,
-2.381834540950004964e-02,
-2.379308666531939134e-02,
-2.376779155342692920e-02,
-2.374246011809110629e-02,
-2.371709240363553337e-02,
-2.369168845443803476e-02,
-2.366624831493180370e-02,
-2.364077202960369883e-02,
-2.361525964299578464e-02,
-2.358971119970412408e-02,
-2.356412674437912899e-02,
-2.353850632172552193e-02,
-2.351284997650233272e-02,
-2.348715775352262433e-02,
-2.346142969765307312e-02,
-2.343566585381494718e-02,
-2.340986626698280185e-02,
-2.338403098218536438e-02,
-2.335816004450476033e-02,
-2.333225349907721430e-02,
-2.330631139109180100e-02,
-2.328033376579165953e-02,
-2.325432066847305662e-02,
-2.322827214448566074e-02,
-2.320218823923214657e-02,
-2.317606899816884725e-02,
-2.314991446680476905e-02,
-2.312372469070182041e-02,
-2.309749971547517267e-02,
-2.307123958679270503e-02,
-2.304494435037520578e-02,
-2.301861405199573732e-02,
-2.299224873748045850e-02,
-2.296584845270761149e-02,
-2.293941324360843428e-02,
-2.291294315616593594e-02,
-2.288643823641600336e-02,
-2.285989853044615230e-02,
-2.283332408439655778e-02,
-2.280671494445902711e-02,
-2.278007115687780831e-02,
-2.275339276794851109e-02,
-2.272667982401906789e-02,
-2.269993237148868609e-02,
-2.267315045680879174e-02,
-2.264633412648175970e-02,
-2.261948342706184348e-02,
-2.259259840515491849e-02,
-2.256567910741745508e-02,
-2.253872558055811451e-02,
-2.251173787133609744e-02,
-2.248471602656188992e-02,
-2.245766009309702049e-02,
-2.243057011785415389e-02,
-2.240344614779626528e-02,
-2.237628822993759439e-02,
-2.234909641134303834e-02,
-2.232187073912809613e-02,
-2.229461126045840721e-02,
-2.226731802255065701e-02,
-2.223999107267155342e-02,
-2.221263045813837503e-02,
-2.218523622631815573e-02,
-2.215780842462840988e-02,
-2.213034710053682352e-02,
-2.210285230156061251e-02,
-2.207532407526743845e-02,
-2.204776246927423952e-02,
-2.202016753124803189e-02,
-2.199253930890536501e-02,
-2.196487785001244308e-02,
-2.193718320238472949e-02,
-2.190945541388740134e-02,
-2.188169453243454798e-02,
-2.185390060599008005e-02,
-2.182607368256642491e-02,
-2.179821381022568894e-02,
-2.177032103707830096e-02,
-2.174239541128446251e-02,
-2.171443698105232981e-02,
-2.168644579463935296e-02,
-2.165842190035151618e-02,
-2.163036534654319207e-02,
-2.160227618161775567e-02,
-2.157415445402635981e-02,
-2.154600021226904180e-02,
-2.151781350489366529e-02,
-2.148959438049672863e-02,
-2.146134288772217485e-02,
-2.143305907526265458e-02,
-2.140474299185816595e-02,
-2.137639468629711631e-02,
-2.134801420741496217e-02,
-2.131960160409553801e-02,
-2.129115692526962686e-02,
-2.126268021991631341e-02,
-2.123417153706116597e-02,
-2.120563092577781514e-02,
-2.117705843518687472e-02,
-2.114845411445594528e-02,
-2.111981801280022816e-02,
-2.109115017948145696e-02,
-2.106245066380846992e-02,
-2.103371951513694979e-02,
-2.100495678286945847e-02,
-2.097616251645470151e-02,
-2.094733676538874587e-02,
-2.091847957921354542e-02,
-2.088959100751793668e-02,
-2.086067109993654592e-02,
-2.083171990615085775e-02,
-2.080273747588793146e-02,
-2.077372385892150425e-02,
-2.074467910507053758e-02,
-2.071560326420099352e-02,
-2.068649638622357609e-02,
-2.065735852109538279e-02,
-2.062818971881911004e-02,
-2.059899002944253973e-02,
-2.056975950305960782e-02,
-2.054049818980919692e-02,
-2.051120613987592045e-02,
-2.048188340348894992e-02,
-2.045253003092337499e-02,
-2.042314607249882258e-02,
-2.039373157858025490e-02,
-2.036428659957708123e-02,
-2.033481118594398368e-02,
-2.030530538818007061e-02,
-2.027576925682942136e-02,
-2.024620284247996560e-02,
-2.021660619576505155e-02,
-2.018697936736159326e-02,
-2.015732240799128494e-02,
-2.012763536842002501e-02,
-2.009791829945720837e-02,
-2.006817125195707596e-02,
-2.003839427681737562e-02,
-2.000858742498007325e-02,
-1.997875074743020105e-02,
-1.994888429519733192e-02,
-1.991898811935401484e-02,
-1.988906227101682953e-02,
-1.985910680134524153e-02,
-1.982912176154254941e-02,
-1.979910720285486120e-02,
-1.976906317657209020e-02,
-1.973898973402635551e-02,
-1.970888692659378966e-02,
-1.967875480569249158e-02,
-1.964859342278412954e-02,
-1.961840282937251517e-02,
-1.958818307700468594e-02,
-1.955793421726971862e-02,
-1.952765630179940926e-02,
-1.949734938226817954e-02,
-1.946701351039211575e-02,
-1.943664873793031836e-02,
-1.940625511668330264e-02,
-1.937583269849434478e-02,
-1.934538153524780271e-02,
-1.931490167887068080e-02,
-1.928439318133123512e-02,
-1.925385609463994493e-02,
-1.922329047084817347e-02,
-1.919269636204970833e-02,
-1.916207382037872498e-02,
-1.913142289801174345e-02,
-1.910074364716575837e-02,
-1.907003612009956425e-02,
-1.903930036911250304e-02,
-1.900853644654502267e-02,
-1.897774440477884017e-02,
-1.894692429623591121e-02,
-1.891607617337946398e-02,
-1.888520008871291331e-02,
-1.885429609478081470e-02,
-1.882336424416727882e-02,
-1.879240458949760564e-02,
-1.876141718343705619e-02,
-1.873040207869115098e-02,
-1.869935932800512526e-02,
-1.866828898416514337e-02,
-1.863719109999623785e-02,
-1.860606572836402683e-02,
-1.857491292217353096e-02,
-1.854373273436964523e-02,
-1.851252521793649367e-02,
-1.848129042589805385e-02,
-1.845002841131766422e-02,
-1.841873922729752797e-02,
-1.838742292697959080e-02,
-1.835607956354468051e-02,
-1.832470919021289557e-02,
-1.829331186024267530e-02,
-1.826188762693213216e-02,
-1.823043654361742802e-02,
-1.819895866367397808e-02,
-1.816745404051534063e-02,
-1.813592272759403934e-02,
-1.810436477840036973e-02,
-1.807278024646353023e-02,
-1.804116918535065076e-02,
-1.800953164866717776e-02,
-1.797786769005635041e-02,
-1.794617736319964116e-02,
-1.791446072181638455e-02,
-1.788271781966322554e-02,
-1.785094871053526794e-02,
-1.781915344826446798e-02,
-1.778733208672101176e-02,
-1.775548467981177478e-02,
-1.772361128148151541e-02,
-1.769171194571193123e-02,
-1.765978672652208231e-02,
-1.762783567796779097e-02,
-1.759585885414236342e-02,
-1.756385630917528182e-02,
-1.753182809723333874e-02,
-1.749977427251980452e-02,
-1.746769488927481587e-02,
-1.743559000177453272e-02,
-1.740345966433197097e-02,
-1.737130393129644387e-02,
-1.733912285705307976e-02,
-1.730691649602372761e-02,
-1.727468490266594742e-02,
-1.724242813147347508e-02,
-1.721014623697559448e-02,
-1.717783927373777234e-02,
-1.714550729636077700e-02,
-1.711315035948145213e-02,
-1.708076851777167240e-02,
-1.704836182593915533e-02,
-1.701593033872648292e-02,
-1.698347411091196205e-02,
-1.695099319730856285e-02,
-1.691848765276489017e-02,
-1.688595753216387899e-02,
-1.685340289042379716e-02,
-1.682082378249733640e-02,
-1.678822026337246226e-02,
-1.675559238807096396e-02,
-1.672294021164956110e-02,
-1.669026378919960182e-02,
-1.665756317584607751e-02,
-1.662483842674894810e-02,
-1.659208959710177858e-02,
-1.655931674213251270e-02,
-1.652651991710277560e-02,
-1.649369917730840809e-02,
-1.646085457807847097e-02,
-1.642798617477625456e-02,
-1.639509402279823447e-02,
-1.636217817757478973e-02,
-1.632923869456910301e-02,
-1.629627562927824305e-02,
-1.626328903723212385e-02,
-1.623027897399409447e-02,
-1.619724549516007514e-02,
-1.616418865635918869e-02,
-1.613110851325371548e-02,
-1.609800512153794494e-02,
-1.606487853693956691e-02,
-1.603172881521818666e-02,
-1.599855601216653572e-02,
-1.596536018360904599e-02,
-1.593214138540318195e-02,
-1.589889967343775801e-02,
-1.586563510363439219e-02,
-1.583234773194623288e-02,
-1.579903761435882611e-02,
-1.576570480688892911e-02,
-1.573234936558549901e-02,
-1.569897134652883594e-02,
-1.566557080583120751e-02,
-1.563214779963556858e-02,
-1.559870238411709305e-02,
-1.556523461548172879e-02,
-1.553174454996626187e-02,
-1.549823224383958462e-02,
-1.546469775340037281e-02,
-1.543114113497901993e-02,
-1.539756244493634303e-02,
-1.536396173966413786e-02,
-1.533033907558426640e-02,
-1.529669450914967858e-02,
-1.526302809684342530e-02,
-1.522933989517906428e-02,
-1.519562996070005466e-02,
-1.516189834998039714e-02,
-1.512814511962372668e-02,
-1.509437032626417992e-02,
-1.506057402656496742e-02,
-1.502675627721982050e-02,
-1.499291713495174913e-02,
-1.495905665651305234e-02,
-1.492517489868635389e-02,
-1.489127191828270094e-02,
-1.485734777214310458e-02,
-1.482340251713732890e-02,
-1.478943621016471505e-02,
-1.475544890815298077e-02,
-1.472144066805933932e-02,
-1.468741154686936320e-02,
-1.465336160159783595e-02,
-1.461929088928750481e-02,
-1.458519946701035234e-02,
-1.455108739186621036e-02,
-1.451695472098373831e-02,
-1.448280151151933731e-02,
-1.444862782065804534e-02,
-1.441443370561250326e-02,
-1.438021922362382916e-02,
-1.434598443196068510e-02,
-1.431172938791925274e-02,
-1.427745414882390304e-02,
-1.424315877202629067e-02,
-1.420884331490580334e-02,
-1.417450783486871521e-02,
-1.414015238934921911e-02,
-1.410577703580821914e-02,
-1.407138183173416331e-02,
-1.403696683464197847e-02,
-1.400253210207397930e-02,
-1.396807769159899223e-02,
-1.393360366081291060e-02,
-1.389911006733771104e-02,
-1.386459696882252554e-02,
-1.383006442294237859e-02,
-1.379551248739913777e-02,
-1.376094121992061173e-02,
-1.372635067826057272e-02,
-1.369174092019934813e-02,
-1.365711200354277795e-02,
-1.362246398612308035e-02,
-1.358779692579755762e-02,
-1.355311088044976707e-02,
-1.351840590798850626e-02,
-1.348368206634835767e-02,
-1.344893941348881787e-02,
-1.341417800739521347e-02,
-1.337939790607765855e-02,
-1.334459916757177109e-02,
-1.330978184993744130e-02,
-1.327494601126052130e-02,
-1.324009170965063410e-02,
-1.320521900324286672e-02,
-1.317032795019649170e-02,
-1.313541860869565057e-02,
-1.310049103694857150e-02,
-1.306554529318777920e-02,
-1.303058143567061879e-02,
-1.299559952267775528e-02,
-1.296059961251453535e-02,
-1.292558176350992391e-02,
-1.289054603401703844e-02,
-1.285549248241223651e-02,
-1.282042116709603864e-02,
-1.278533214649219159e-02,
-1.275022547904832056e-02,
-1.271510122323465074e-02,
-1.267995943754575416e-02,
-1.264480018049825120e-02,
-1.260962351063271529e-02,
-1.257442948651218279e-02,
-1.253921816672298045e-02,
-1.250398960987376094e-02,
-1.246874387459610302e-02,
-1.243348101954442828e-02,
-1.239820110339506093e-02,
-1.236290418484729987e-02,
-1.232759032262247846e-02,
-1.229225957546431318e-02,
-1.225691200213814905e-02,
-1.222154766143208546e-02,
-1.218616661215546869e-02,
-1.215076891314000387e-02,
-1.211535462323848344e-02,
-1.207992380132618185e-02,
-1.204447650629905837e-02,
-1.200901279707504953e-02,
-1.197353273259312879e-02,
-1.193803637181385657e-02,
-1.190252377371838616e-02,
-1.186699499730954274e-02,
-1.183145010161070800e-02,
-1.179588914566594496e-02,
-1.176031218854066418e-02,
-1.172471928932034869e-02,
-1.168911050711158618e-02,
-1.165348590104072282e-02,
-1.161784553025512444e-02,
-1.158218945392205067e-02,
-1.154651773122931067e-02,
-1.151083042138401590e-02,
-1.147512758361436506e-02,
-1.143940927716727805e-02,
-1.140367556131039427e-02,
-1.136792649533036222e-02,
-1.133216213853403646e-02,
-1.129638255024701700e-02,
-1.126058778981496589e-02,
-1.122477791660263929e-02,
-1.118895298999354575e-02,
-1.115311306939100085e-02,
-1.111725821421674296e-02,
-1.108138848391202608e-02,
-1.104550393793605340e-02,
-1.100960463576752639e-02,
-1.097369063690324144e-02,
-1.093776200085907167e-02,
-1.090181878716838665e-02,
-1.086586105538404207e-02,
-1.082988886507592341e-02,
-1.079390227583304496e-02,
-1.075790134726170230e-02,
-1.072188613898673870e-02,
-1.068585671065010352e-02,
-1.064981312191220532e-02,
-1.061375543245076346e-02,
-1.057768370196064331e-02,
-1.054159799015490402e-02,
-1.050549835676331881e-02,
-1.046938486153345220e-02,
-1.043325756422932779e-02,
-1.039711652463261825e-02,
-1.036096180254158193e-02,
-1.032479345777160759e-02,
-1.028861155015449273e-02,
-1.025241613953915311e-02,
-1.021620728579038587e-02,
-1.017998504879011855e-02,
-1.014374948843615835e-02,
-1.010750066464305950e-02,
-1.007123863734082740e-02,
-1.003496346647625090e-02,
-9.998675212011564825e-03,
-9.962373933925376332e-03,
-9.926059692211421093e-03,
-9.889732546879489647e-03,
-9.853392557955184539e-03,
-9.817039785478895095e-03,
-9.780674289507081121e-03,
-9.744296130110942367e-03,
-9.707905367377337932e-03,
-9.671502061407752371e-03,
-9.635086272319131825e-03,
-9.598658060242692275e-03,
-9.562217485324981184e-03,
-9.525764607726885241e-03,
-9.489299487624329454e-03,
-9.452822185206965697e-03,
-9.416332760679640285e-03,
-9.379831274260884769e-03,
-9.343317786183994930e-03,
-9.306792356695762700e-03,
-9.270255046057263720e-03,
-9.233705914543727244e-03,
-9.197145022443524789e-03,
-9.160572430059419138e-03,
-9.123988197707306666e-03,
-9.087392385716935514e-03,
-9.050785054431076393e-03,
-9.014166264206358720e-03,
-8.977536075411813449e-03,
-8.940894548430337180e-03,
-8.904241743657382441e-03,
-8.867577721501788621e-03,
-8.830902542384408069e-03,
-8.794216266739634386e-03,
-8.757518955013926173e-03,
-8.720810667666778482e-03,
-8.684091465169399213e-03,
-8.647361408005963326e-03,
-8.610620556672634457e-03,
-8.573868971677393175e-03,
-8.537106713540788122e-03,
-8.500333842794841402e-03,
-8.463550419983763284e-03,
-8.426756505663166377e-03,
-8.389952160400700534e-03,
-8.353137444774890591e-03,
-8.316312419376397508e-03,
-8.279477144806693042e-03,
-8.242631681678977418e-03,
-8.205776090616914709e-03,
-8.168910432255881843e-03,
-8.132034767241672762e-03,
-8.095149156231476809e-03,
-8.058253659892442369e-03,
-8.021348338903147926e-03,
-7.984433253952359991e-03,
-7.947508465738850961e-03,
-7.910574034972797305e-03,
-7.873630022373507079e-03,
-7.836676488671215357e-03,
-7.799713494605729422e-03,
-7.762741100927258824e-03,
-7.725759368395195004e-03,
-7.688768357779394123e-03,
-7.651768129858810968e-03,
-7.614758745422489476e-03,
-7.577740265268202713e-03,
-7.540712750203820702e-03,
-7.503676261045911372e-03,
-7.466630858620725009e-03,
-7.429576603762881072e-03,
-7.392513557316598115e-03,
-7.355441780134514169e-03,
-7.318361333078434415e-03,
-7.281272277018569633e-03,
-7.244174672833383552e-03,
-7.207068581410486230e-03,
-7.169954063645256684e-03,
-7.132831180441924490e-03,
-7.095699992712083994e-03,
-7.058560561376178363e-03,
-7.021412947362081457e-03,
-6.984257211606052784e-03,
-6.947093415051385293e-03,
-6.909921618649761919e-03,
-6.872741883359964089e-03,
-6.835554270148681832e-03,
-6.798358839989323762e-03,
-6.761155653863246129e-03,
-6.723944772758524632e-03,
-6.686726257670616222e-03,
-6.649500169601860362e-03,
-6.612266569561106068e-03,
-6.575025518564613959e-03,
-6.537777077634773434e-03,
-6.500521307801120086e-03,
-6.463258270098891541e-03,
-6.425988025570488101e-03,
-6.388710635264020776e-03,
-6.351426160234322632e-03,
-6.314134661541608712e-03,
-6.276836200252758000e-03,
-6.239530837440060949e-03,
-6.202218634182049550e-03,
-6.164899651562313378e-03,
-6.127573950670644511e-03,
-6.090241592601890012e-03,
-6.052902638456660565e-03,
-6.015557149340423210e-03,
-5.978205186364446769e-03,
-5.940846810644342946e-03,
-5.903482083301129710e-03,
-5.866111065460947668e-03,
-5.828733818254088622e-03,
-5.791350402816183851e-03,
-5.753960880287020165e-03,
-5.716565311811347416e-03,
-5.679163758537579196e-03,
-5.641756281619212700e-03,
-5.604342942213351615e-03,
-5.566923801481800729e-03,
-5.529498920589549782e-03,
-5.492068360706287011e-03,
-5.454632183004959334e-03,
-5.417190448662632767e-03,
-5.379743218859552208e-03,
-5.342290554780007930e-03,
-5.304832517611072704e-03,
-5.267369168543427523e-03,
-5.229900568771263594e-03,
-5.192426779491176453e-03,
-5.154947861903480012e-03,
-5.117463877210903789e-03,
-5.079974886619496692e-03,
-5.042480951337273073e-03,
-5.004982132575625658e-03,
-4.967478491547903073e-03,
-4.929970089470430729e-03,
-4.892456987560974725e-03,
-4.854939247040691679e-03,
-4.817416929131723528e-03,
-4.779890095059027670e-03,
-4.742358806049001320e-03,
-4.704823123330345407e-03,
-4.667283108132768733e-03,
-4.629738821688342797e-03,
-4.592190325230356869e-03,
-4.554637679993186160e-03,
-4.517080947213168718e-03,
-4.479520188127354696e-03,
-4.441955463974441368e-03,
-4.404386835993435653e-03,
-4.366814365424969042e-03,
-4.329238113510034715e-03,
-4.291658141490841891e-03,
-4.254074510609391624e-03,
-4.216487282109418824e-03,
-4.178896517233878644e-03,
-4.141302277226963091e-03,
-4.103704623332518966e-03,
-4.066103616795099969e-03,
-4.028499318858566776e-03,
-3.990891790767407167e-03,
-3.953281093765670037e-03,
-3.915667289096858711e-03,
-3.878050438004695087e-03,
-3.840430601731959978e-03,
-3.802807841521400802e-03,
-3.765182218614353347e-03,
-3.727553794252169445e-03,
-3.689922629674817489e-03,
-3.652288786121832623e-03,
-3.614652324830839192e-03,
-3.577013307039539174e-03,
-3.539371793983168632e-03,
-3.501727846896484416e-03,
-3.464081527012286606e-03,
-3.426432895562344857e-03,
-3.388782013776047482e-03,
-3.351128942881789231e-03,
-3.313473744105820303e-03,
-3.275816478672120141e-03,
-3.238157207803270005e-03,
-3.200495992719212639e-03,
-3.162832894638149556e-03,
-3.125167974775236099e-03,
-3.087501294343929746e-03,
-3.049832914554643972e-03,
-3.012162896615672419e-03,
-2.974491301731749943e-03,
-2.936818191105945632e-03,
-2.899143625937247639e-03,
-2.861467667422466603e-03,
-2.823790376754762438e-03,
-2.786111815124619247e-03,
-2.748432043718433259e-03,
-2.710751123719961752e-03,
-2.673069116308885405e-03,
-2.635386082661823112e-03,
-2.597702083951046546e-03,
-2.560017181345329747e-03,
-2.522331436009858045e-03,
-2.484644909105072300e-03,
-2.446957661788035001e-03,
-2.409269755211098860e-03,
-2.371581250522726905e-03,
-2.333892208866561804e-03,
-2.296202691382264165e-03,
-2.258512759204187644e-03,
-2.220822473462686492e-03,
-2.183131895282844435e-03,
-2.145441085785331631e-03,
-2.107750106085138752e-03,
-2.070059017292867187e-03,
-2.032367880513427996e-03,
-1.994676756846960018e-03,
-1.956985707387594309e-03,
-1.919294793224303941e-03,
-1.881604075440791246e-03,
-1.843913615114340732e-03,
-1.806223473317201652e-03,
-1.768533711115226033e-03,
-1.730844389568718476e-03,
-1.693155569731490725e-03,
-1.655467312651698244e-03,
-1.617779679370512716e-03,
-1.580092730923479249e-03,
-1.542406528339149195e-03,
-1.504721132640026446e-03,
-1.467036604841242316e-03,
-1.429353005951904078e-03,
-1.391670396973726694e-03,
-1.353988838902017927e-03,
-1.316308392724287093e-03,
-1.278629119421635218e-03,
-1.240951079967604273e-03,
-1.203274335328071570e-03,
-1.165598946462121028e-03,
-1.127924974320753835e-03,
-1.090252479847762541e-03,
-1.052581523978791045e-03,
-1.014912167642160546e-03,
-9.772444717575535372e-04,
-9.395784972373331717e-04,
-9.019143049852258471e-04,
-8.642519558972621861e-04,
-8.265915108604150610e-04,
-7.889330307539737120e-04,
-7.512765764481853497e-04,
-7.136222088052141324e-04,
-6.759699886777762639e-04,
-6.383199769105127016e-04,
-6.006722343388485761e-04,
-5.630268217888872648e-04,
-5.253838000782669109e-04,
-4.877432300148922873e-04,
-4.501051723978078496e-04,
-4.124696880162355612e-04,
-3.748368376504326600e-04,
-3.372066820703393869e-04,
-2.995792820369430750e-04,
-2.619546983009233849e-04,
-2.243329916036090313e-04,
-1.867142226756162695e-04,
-1.490984522382211429e-04,
-1.114857410020069406e-04,
-7.387614966781187145e-05,
-3.626973892537595288e-05,
 1.333430545288951487e-06,
 3.893329807525446935e-05,
 7.652980300572373559e-05,
 1.141228846892826772e-04,
 1.517124824890523738e-04,
 1.892985357788908333e-04,
 2.268809839441213530e-04,
 2.644597663806824771e-04,
 3.020348224964847813e-04,
 3.396060917100389778e-04,
 3.771735134518145556e-04,
 4.147370271632826199e-04,
 4.522965722982719042e-04,
 4.898520883216031085e-04,
 5.274035147104381895e-04,
 5.649507909533304367e-04,
 6.024938565515763639e-04,
 6.400326510178550900e-04,
 6.775671138775651598e-04,
 7.150971846679935037e-04,
 7.526228029390368652e-04,
 7.901439082533981504e-04,
 8.276604401857458456e-04,
 8.651723383239553209e-04,
 9.026795422681698020e-04,
 9.401819916321396860e-04,
 9.776796260418656615e-04,
 1.015172385136941602e-03,
 1.052660208569610985e-03,
 1.090143036006109350e-03,
 1.127620807125317938e-03,
 1.165093461620083813e-03,
 1.202560939196292006e-03,
 1.240023179574211007e-03,
 1.277480122487129922e-03,
 1.314931707682694866e-03,
 1.352377874922083226e-03,
 1.389818563980911798e-03,
 1.427253714648426880e-03,
 1.464683266728712295e-03,
 1.502107160039869299e-03,
 1.539525334414104836e-03,
 1.576937729698879272e-03,
 1.614344285755515149e-03,
 1.651744942460581711e-03,
 1.689139639704930178e-03,
 1.726528317395023418e-03,
 1.763910915451611912e-03,
 1.801287373811035668e-03,
 1.838657632424321947e-03,
 1.876021631258485440e-03,
 1.913379310295206838e-03,
 1.950730609532156648e-03,
 1.988075468982147560e-03,
 2.025413828674096136e-03,
 2.062745628652128127e-03,
 2.100070808976872358e-03,
 2.137389309724584043e-03,
 2.174701070987249303e-03,
 2.212006032873745261e-03,
 2.249304135508418435e-03,
 2.286595319032511554e-03,
 2.323879523603132689e-03,
 2.361156689394681638e-03,
 2.398426756597411402e-03,
 2.435689665418829843e-03,
 2.472945356082718697e-03,
 2.510193768830494901e-03,
 2.547434843919855335e-03,
 2.584668521626105192e-03,
 2.621894742241304057e-03,
 2.659113446075226511e-03,
 2.696324573454501276e-03,
 2.733528064723862380e-03,
 2.770723860245293078e-03,
 2.807911900398093064e-03,
 2.845092125580117072e-03,
 2.882264476206285175e-03,
 2.919428892710002662e-03,
 2.956585315542195960e-03,
 2.993733685172654448e-03,
 3.030873942088679537e-03,
 3.068006026796383980e-03,
 3.105129879819828846e-03,
 3.142245441702377906e-03,
 3.179352653004867933e-03,
 3.216451454308009560e-03,
 3.253541786210434415e-03,
 3.290623589330230348e-03,
 3.327696804303909277e-03,
 3.364761371787814044e-03,
 3.401817232456732804e-03,
 3.438864327005026165e-03,
 3.475902596146729969e-03,
 3.512931980614714816e-03,
 3.549952421161904279e-03,
 3.586963858560374575e-03,
 3.623966233602649543e-03,
 3.660959487100354497e-03,
 3.697943559885571475e-03,
 3.734918392809879507e-03,
 3.771883926745786195e-03,
 3.808840102584893240e-03,
 3.845786861240207098e-03,
 3.882724143644337034e-03,
 3.919651890750879865e-03,
 3.956570043533484508e-03,
 3.993478542987211576e-03,
 4.030377330127175514e-03,
 4.067266345989644857e-03,
 4.104145531632173195e-03,
 4.141014828132714466e-03,
 4.177874176590902315e-03,
 4.214723518127102067e-03,
 4.251562793883677076e-03,
 4.288391945023774417e-03,
 4.325210912732477611e-03,
 4.362019638216027735e-03,
 4.398818062703179106e-03,
 4.435606127443332720e-03,
 4.472383773708911957e-03,
 4.509150942793504688e-03,
 4.545907576013283151e-03,
 4.582653614706066331e-03,
 4.619389000232663502e-03,
 4.656113673975502062e-03,
 4.692827577339994498e-03,
 4.729530651753502749e-03,
 4.766222838666755481e-03,
 4.802904079552760414e-03,
 4.839574315907150398e-03,
 4.876233489249111493e-03,
 4.912881541120117483e-03,
 4.949518413085294243e-03,
 4.986144046732371091e-03,
 5.022758383673210821e-03,
 5.059361365541928390e-03,
 5.095952933997238872e-03,
 5.132533030720525836e-03,
 5.169101597417369645e-03,
 5.205658575816605495e-03,
 5.242203907671556806e-03,
 5.278737534758827857e-03,
 5.315259398879439157e-03,
 5.351769441858117080e-03,
 5.388267605544342503e-03,
 5.424753831811584062e-03,
 5.461228062557357127e-03,
 5.497690239704425968e-03,
 5.534140305199379550e-03,
 5.570578201013925632e-03,
 5.607003869144106672e-03,
 5.643417251611508069e-03,
 5.679818290461616237e-03,
 5.716206927766009568e-03,
 5.752583105620574268e-03,
 5.788946766146919887e-03,
 5.825297851491438236e-03,
 5.861636303826634788e-03,
 5.897962065349756505e-03,
 5.934275078284131921e-03,
 5.970575284878256936e-03,
 6.006862627407095860e-03,
 6.043137048170694504e-03,
 6.079398489495394485e-03,
 6.115646893733843632e-03,
 6.151882203264201487e-03,
 6.188104360491334527e-03,
 6.224313307846006914e-03,
 6.260508987785748727e-03,
 6.296691342794129981e-03,
 6.332860315381934162e-03,
 6.369015848085891017e-03,
 6.405157883470032239e-03,
 6.441286364124680988e-03,
 6.477401232667863960e-03,
 6.513502431743834267e-03,
 6.549589904024522534e-03,
 6.585663592208522953e-03,
 6.621723439022458510e-03,
 6.657769387219638312e-03,
 6.693801379581056782e-03,
 6.729819358915673823e-03,
 6.765823268059438164e-03,
 6.801813049876587539e-03,
 6.837788647258742289e-03,
 6.873750003125893293e-03,
 6.909697060425496438e-03,
 6.945629762133833512e-03,
 6.981548051254689476e-03,
 7.017451870820618810e-03,
 7.053341163891994024e-03,
 7.089215873558441135e-03,
 7.125075942937366021e-03,
 7.160921315175357814e-03,
 7.196751933447159341e-03,
 7.232567740957129496e-03,
 7.268368680937765253e-03,
 7.304154696651072101e-03,
 7.339925731387678468e-03,
 7.375681728467893029e-03,
 7.411422631241085419e-03,
 7.447148383085730461e-03,
 7.482858927410176650e-03,
 7.518554207651730222e-03,
 7.554234167278107114e-03,
 7.589898749785941104e-03,
 7.625547898702222764e-03,
 7.661181557583310667e-03,
 7.696799670016239367e-03,
 7.732402179617387135e-03,
 7.767989030033775263e-03,
 7.803560164942240605e-03,
 7.839115528050517173e-03,
 7.874655063096138927e-03,
 7.910178713847672294e-03,
 7.945686424103676204e-03,
 7.981178137694068184e-03,
 8.016653798479208420e-03,
 8.052113350350090584e-03,
 8.087556737229080819e-03,
 8.122983903069052117e-03,
 8.158394791854711378e-03,
 8.193789347601315720e-03,
 8.229167514355831270e-03,
 8.264529236196110906e-03,
 8.299874457232288977e-03,
 8.335203121605240864e-03,
 8.370515173488052296e-03,
 8.405810557084985452e-03,
 8.441089216632816430e-03,
 8.476351096399627888e-03,
 8.511596140685929665e-03,
 8.546824293823794896e-03,
 8.582035500178263401e-03,
 8.617229704145577471e-03,
 8.652406850155317311e-03,
 8.687566882669006327e-03,
 8.722709746180518781e-03,
 8.757835385216919399e-03,
 8.792943744337323661e-03,
 8.828034768134060059e-03,
 8.863108401231969274e-03,
 8.898164588289302762e-03,
 8.933203273996888349e-03,
 8.968224403079035761e-03,
 9.003227920292802833e-03,
 9.038213770429241040e-03,
 9.073181898312049354e-03,
 9.108132248798960287e-03,
 9.143064766780860386e-03,
 9.177979397182548307e-03,
 9.212876084962252562e-03,
 9.247754775112460718e-03,
 9.282615412659272341e-03,
 9.317457942662518700e-03,
 9.352282310216838285e-03,
 9.387088460450210975e-03,
 9.421876338525451630e-03,
 9.456645889639139768e-03,
 9.491397059023028160e-03,
 9.526129791942606478e-03,
 9.560844033698506425e-03,
 9.595539729625476508e-03,
 9.630216825093762881e-03,
 9.664875265507709423e-03,
 9.699514996307135109e-03,
 9.734135962966405931e-03,
 9.768738110995411547e-03,
 9.803321385938777721e-03,
 9.837885733376882866e-03,
 9.872431098925263035e-03,
 9.906957428234464472e-03,
 9.941464666991363733e-03,
 9.975952760917778175e-03,
 1.001042165577152067e-02,
 1.004487129734584622e-02,
 1.007930163147053269e-02,
 1.011371260401053990e-02,
 1.014810416086739560e-02,
 1.018247624797830216e-02,
 1.021682881131723113e-02,
 1.025116179689381478e-02,
 1.028547515075447713e-02,
 1.031976881898177302e-02,
 1.035404274769518435e-02,
 1.038829688305021974e-02,
 1.042253117123985613e-02,
 1.045674555849317525e-02,
 1.049093999107629689e-02,
 1.052511441529276059e-02,
 1.055926877748239109e-02,
 1.059340302402273469e-02,
 1.062751710132799933e-02,
 1.066161095585035391e-02,
 1.069568453407863939e-02,
 1.072973778253967676e-02,
 1.076377064779727825e-02,
 1.079778307645360910e-02,
 1.083177501514784487e-02,
 1.086574641055735452e-02,
 1.089969720939708633e-02,
 1.093362735842023231e-02,
 1.096753680441757590e-02,
 1.100142549421871500e-02,
 1.103529337469075396e-02,
 1.106914039273929062e-02,
 1.110296649530864710e-02,
 1.113677162938097286e-02,
 1.117055574197749722e-02,
 1.120431878015746945e-02,
 1.123806069101958988e-02,
 1.127178142170055276e-02,
 1.130548091937652079e-02,
 1.133915913126201137e-02,
 1.137281600461133475e-02,
 1.140645148671690264e-02,
 1.144006552491129425e-02,
 1.147365806656567601e-02,
 1.150722905909089613e-02,
 1.154077844993690871e-02,
 1.157430618659368270e-02,
 1.160781221659023740e-02,
 1.164129648749573018e-02,
 1.167475894691847454e-02,
 1.170819954250731237e-02,
 1.174161822195066325e-02,
 1.177501493297666499e-02,
 1.180838962335417977e-02,
 1.184174224089154862e-02,
 1.187507273343792018e-02,
 1.190838104888210063e-02,
 1.194166713515428316e-02,
 1.197493094022393512e-02,
 1.200817241210209822e-02,
 1.204139149883994182e-02,
 1.207458814852947586e-02,
 1.210776230930330974e-02,
 1.214091392933546246e-02,
 1.217404295684034257e-02,
 1.220714934007381333e-02,
 1.224023302733237388e-02,
 1.227329396695434581e-02,
 1.230633210731893121e-02,
 1.233934739684663939e-02,
 1.237233978399980214e-02,
 1.240530921728183293e-02,
 1.243825564523808741e-02,
 1.247117901645522844e-02,
 1.250407927956232075e-02,
 1.253695638322930260e-02,
 1.256981027616908136e-02,
 1.260264090713569297e-02,
 1.263544822492589786e-02,
 1.266823217837800310e-02,
 1.270099271637324494e-02,
 1.273372978783453117e-02,
 1.276644334172761554e-02,
 1.279913332706031359e-02,
 1.283179969288350021e-02,
 1.286444238829020578e-02,
 1.289706136241625806e-02,
 1.292965656444070716e-02,
 1.296222794358489229e-02,
 1.299477544911336463e-02,
 1.302729903033354730e-02,
 1.305979863659646918e-02,
 1.309227421729540312e-02,
 1.312472572186781754e-02,
 1.315715309979388278e-02,
 1.318955630059760742e-02,
 1.322193527384598645e-02,
 1.325428996915021390e-02,
 1.328662033616457259e-02,
 1.331892632458745243e-02,
 1.335120788416057323e-02,
 1.338346496467018691e-02,
 1.341569751594597071e-02,
 1.344790548786171588e-02,
 1.348008883033567119e-02,
 1.351224749332980909e-02,
 1.354438142685067056e-02,
 1.357649058094882559e-02,
 1.360857490571985330e-02,
 1.364063435130295071e-02,
 1.367266886788276285e-02,
 1.370467840568791867e-02,
 1.373666291499226269e-02,
 1.376862234611383844e-02,
 1.380055664941644972e-02,
 1.383246577530791374e-02,
 1.386434967424172472e-02,
 1.389620829671604080e-02,
 1.392804159327471966e-02,
 1.395984951450630202e-02,
 1.399163201104510444e-02,
 1.402338903357039541e-02,
 1.405512053280752460e-02,
 1.408682645952697918e-02,
 1.411850676454486260e-02,
 1.415016139872326759e-02,
 1.418179031296964640e-02,
 1.421339345823793843e-02,
 1.424497078552738709e-02,
 1.427652224588368476e-02,
 1.430804779039814012e-02,
 1.433954737020895487e-02,
 1.437102093649979956e-02,
 1.440246844050119442e-02,
 1.443388983348959168e-02,
 1.446528506678849968e-02,
 1.449665409176730674e-02,
 1.452799685984249370e-02,
 1.455931332247690536e-02,
 1.459060343118043224e-02,
 1.462186713750967572e-02,
 1.465310439306804526e-02,
 1.468431514950608793e-02,
 1.471549935852107041e-02,
 1.474665697185804578e-02,
 1.477778794130857332e-02,
 1.480889221871193803e-02,
 1.483996975595449665e-02,
 1.487102050497033333e-02,
 1.490204441774071326e-02,
 1.493304144629473140e-02,
 1.496401154270875743e-02,
 1.499495465910752334e-02,
 1.502587074766285023e-02,
 1.505675976059493021e-02,
 1.508762165017147466e-02,
 1.511845636870876725e-02,
 1.514926386857035762e-02,
 1.518004410216883954e-02,
 1.521079702196457238e-02,
 1.524152258046600553e-02,
 1.527222073023058908e-02,
 1.530289142386359082e-02,
 1.533353461401924279e-02,
 1.536415025339991740e-02,
 1.539473829475728958e-02,
 1.542529869089113125e-02,
 1.545583139465043013e-02,
 1.548633635893280867e-02,
 1.551681353668507048e-02,
 1.554726288090279435e-02,
 1.557768434463093453e-02,
 1.560807788096322049e-02,
 1.563844344304326367e-02,
 1.566878098406302919e-02,
 1.569909045726480129e-02,
 1.572937181593988404e-02,
 1.575962501342898989e-02,
 1.578985000312282949e-02,
 1.582004673846126863e-02,
 1.585021517293441068e-02,
 1.588035526008167025e-02,
 1.591046695349289039e-02,
 1.594055020680730517e-02,
 1.597060497371460483e-02,
 1.600063120795439803e-02,
 1.603062886331645120e-02,
 1.606059789364053941e-02,
 1.609053825281734143e-02,
 1.612044989478715953e-02,
 1.615033277354137667e-02,
 1.618018684312164113e-02,
 1.621001205761984573e-02,
 1.623980837117921031e-02,
 1.626957573799296675e-02,
 1.629931411230582314e-02,
 1.632902344841266618e-02,
 1.635870370066005650e-02,
 1.638835482344491723e-02,
 1.641797677121542565e-02,
 1.644756949847088479e-02,
 1.647713295976212938e-02,
 1.650666710969067585e-02,
 1.653617190290998171e-02,
 1.656564729412444287e-02,
 1.659509323809050044e-02,
 1.662450968961523903e-02,
 1.665389660355830193e-02,
 1.668325393483035060e-02,
 1.671258163839440397e-02,
 1.674187966926465529e-02,
 1.677114798250776626e-02,
 1.680038653324201700e-02,
 1.682959527663763222e-02,
 1.685877416791744382e-02,
 1.688792316235570787e-02,
 1.691704221527971785e-02,
 1.694613128206825733e-02,
 1.697519031815334506e-02,
 1.700421927901862862e-02,
 1.703321812020069936e-02,
 1.706218679728841933e-02,
 1.709112526592393433e-02,
 1.712003348180113349e-02,
 1.714891140066763034e-02,
 1.717775897832323276e-02,
 1.720657617062095607e-02,
 1.723536293346636383e-02,
 1.726411922281859829e-02,
 1.729284499468983563e-02,
 1.732154020514504317e-02,
 1.735020481030295769e-02,
 1.737883876633506547e-02,
 1.740744202946657368e-02,
 1.743601455597576858e-02,
 1.746455630219514651e-02,
 1.749306722450999496e-02,
 1.752154727935976292e-02,
 1.754999642323716927e-02,
 1.757841461268938935e-02,
 1.760680180431634448e-02,
 1.763515795477296061e-02,
 1.766348302076739193e-02,
 1.769177695906221440e-02,
 1.772003972647387057e-02,
 1.774827127987318662e-02,
 1.777647157618491430e-02,
 1.780464057238821673e-02,
 1.783277822551683142e-02,
 1.786088449265854292e-02,
 1.788895933095591487e-02,
 1.791700269760583553e-02,
 1.794501454986013184e-02,
 1.797299484502489289e-02,
 1.800094354046112219e-02,
 1.802886059358456070e-02,
 1.805674596186618644e-02,
 1.808459960283128817e-02,
 1.811242147406090519e-02,
 1.814021153319036669e-02,
 1.816796973791059630e-02,
 1.819569604596744244e-02,
 1.822339041516230981e-02,
 1.825105280335164240e-02,
 1.827868316844740576e-02,
 1.830628146841710782e-02,
 1.833384766128345889e-02,
 1.836138170512498571e-02,
 1.838888355807554581e-02,
 1.841635317832517743e-02,
 1.844379052411917672e-02,
 1.847119555375905178e-02,
 1.849856822560197803e-02,
 1.852590849806107220e-02,
 1.855321632960533693e-02,
 1.858049167876036148e-02,
 1.860773450410707630e-02,
 1.863494476428347729e-02,
 1.866212241798291885e-02,
 1.868926742395597349e-02,
 1.871637974100884630e-02,
 1.874345932800461009e-02,
 1.877050614386241434e-02,
 1.879752014755849132e-02,
 1.882450129812560796e-02,
 1.885144955465276051e-02,
 1.887836487628632987e-02,
 1.890524722222900952e-02,
 1.893209655174047518e-02,
 1.895891282413729798e-02,
 1.898569599879337821e-02,
 1.901244603513923409e-02,
 1.903916289266285866e-02,
 1.906584653090913350e-02,
 1.909249690948023812e-02,
 1.911911398803565337e-02,
 1.914569772629235583e-02,
 1.917224808402444303e-02,
 1.919876502106398694e-02,
 1.922524849729989257e-02,
 1.925169847267939674e-02,
 1.927811490720682600e-02,
 1.930449776094428707e-02,
 1.933084699401214912e-02,
 1.935716256658789533e-02,
 1.938344443890756968e-02,
 1.940969257126478123e-02,
 1.943590692401115511e-02,
 1.946208745755639152e-02,
 1.948823413236855720e-02,
 1.951434690897355453e-02,
 1.954042574795594733e-02,
 1.956647060995806917e-02,
 1.959248145568122726e-02,
 1.961845824588466514e-02,
 1.964440094138630508e-02,
 1.967030950306249137e-02,
 1.969618389184841709e-02,
 1.972202406873759320e-02,
 1.974782999478245926e-02,
 1.977360163109436603e-02,
 1.979933893884323545e-02,
 1.982504187925782438e-02,
 1.985071041362586330e-02,
 1.987634450329447966e-02,
 1.990194410966919861e-02,
 1.992750919421541755e-02,
 1.995303971845705654e-02,
 1.997853564397756437e-02,
 2.000399693241942597e-02,
 2.002942354548507137e-02,
 2.005481544493553994e-02,
 2.008017259259197579e-02,
 2.010549495033463890e-02,
 2.013078248010359214e-02,
 2.015603514389848264e-02,
 2.018125290377822609e-02,
 2.020643572186236678e-02,
 2.023158356032925265e-02,
 2.025669638141785675e-02,
 2.028177414742667745e-02,
 2.030681682071417554e-02,
 2.033182436369875348e-02,
 2.035679673885939719e-02,
 2.038173390873457627e-02,
 2.040663583592336461e-02,
 2.043150248308480202e-02,
 2.045633381293858466e-02,
 2.048112978826438155e-02,
 2.050589037190243477e-02,
 2.053061552675336174e-02,
 2.055530521577848824e-02,
 2.057995940199946680e-02,
 2.060457804849891161e-02,
 2.062916111841973932e-02,
 2.065370857496563392e-02,
 2.067822038140145965e-02,
 2.070269650105237280e-02,
 2.072713689730499090e-02,
 2.075154153360633455e-02,
 2.077591037346494460e-02,
 2.080024338044995924e-02,
 2.082454051819197446e-02,
 2.084880175038232586e-02,
 2.087302704077418150e-02,
 2.089721635318139356e-02,
 2.092136965147957731e-02,
 2.094548689960541721e-02,
 2.096956806155726022e-02,
 2.099361310139478964e-02,
 2.101762198323915698e-02,
 2.104159467127315539e-02,
 2.106553112974141398e-02,
 2.108943132295014802e-02,
 2.111329521526724567e-02,
 2.113712277112233737e-02,
 2.116091395500686867e-02,
 2.118466873147472132e-02,
 2.120838706514092259e-02,
 2.123206892068309898e-02,
 2.125571426284068172e-02,
 2.127932305641541330e-02,
 2.130289526627091035e-02,
 2.132643085733315624e-02,
 2.134992979459033810e-02,
 2.137339204309320409e-02,
 2.139681756795440426e-02,
 2.142020633434963892e-02,
 2.144355830751640615e-02,
 2.146687345275507738e-02,
 2.149015173542873774e-02,
 2.151339312096263098e-02,
 2.153659757484521417e-02,
 2.155976506262715503e-02,
 2.158289554992238318e-02,
 2.160598900240726788e-02,
 2.162904538582120437e-02,
 2.165206466596636403e-02,
 2.167504680870826345e-02,
 2.169799177997495596e-02,
 2.172089954575805171e-02,
 2.174377007211171497e-02,
 2.176660332515401031e-02,
 2.178939927106551822e-02,
 2.181215787609049744e-02,
 2.183487910653617026e-02,
 2.185756292877379450e-02,
 2.188020930923721685e-02,
 2.190281821442438548e-02,
 2.192538961089656596e-02,
 2.194792346527826496e-02,
 2.197041974425821553e-02,
 2.199287841458813855e-02,
 2.201529944308406109e-02,
 2.203768279662532067e-02,
 2.206002844215549513e-02,
 2.208233634668157336e-02,
 2.210460647727460759e-02,
 2.212683880106959544e-02,
 2.214903328526571583e-02,
 2.217118989712586405e-02,
 2.219330860397735264e-02,
 2.221538937321134236e-02,
 2.223743217228340424e-02,
 2.225943696871302349e-02,
 2.228140373008430028e-02,
 2.230333242404560976e-02,
 2.232522301830959510e-02,
 2.234707548065337224e-02,
 2.236888977891854716e-02,
 2.239066588101110145e-02,
 2.241240375490148248e-02,
 2.243410336862531815e-02,
 2.245576469028218169e-02,
 2.247738768803690668e-02,
 2.249897233011848019e-02,
 2.252051858482154167e-02,
 2.254202642050442268e-02,
 2.256349580559144363e-02,
 2.258492670857097095e-02,
 2.260631909799703729e-02,
 2.262767294248816188e-02,
 2.264898821072838103e-02,
 2.267026487146638417e-02,
 2.269150289351619387e-02,
 2.271270224575731508e-02,
 2.273386289713401343e-02,
 2.275498481665618605e-02,
 2.277606797339881348e-02,
 2.279711233650252161e-02,
 2.281811787517317239e-02,
 2.283908455868213436e-02,
 2.286001235636606413e-02,
 2.288090123762762801e-02,
 2.290175117193468321e-02,
 2.292256212882102726e-02,
 2.294333407788596429e-02,
 2.296406698879453062e-02,
 2.298476083127730385e-02,
 2.300541557513129456e-02,
 2.302603119021871120e-02,
 2.304660764646808413e-02,
 2.306714491387374874e-02,
 2.308764296249605358e-02,
 2.310810176246124240e-02,
 2.312852128396165191e-02,
 2.314890149725606569e-02,
 2.316924237266887107e-02,
 2.318954388059117980e-02,
 2.320980599147978718e-02,
 2.323002867585859457e-02,
 2.325021190431676363e-02,
 2.327035564751073204e-02,
 2.329045987616268701e-02,
 2.331052456106200849e-02,
 2.333054967306358307e-02,
 2.335053518308975382e-02,
 2.337048106212902265e-02,
 2.339038728123634878e-02,
 2.341025381153352333e-02,
 2.343008062420913473e-02,
 2.344986769051851661e-02,
 2.346961498178337310e-02,
 2.348932246939283708e-02,
 2.350899012480246741e-02,
 2.352861791953477638e-02,
 2.354820582517924699e-02,
 2.356775381339259665e-02,
 2.358726185589804861e-02,
 2.360672992448646645e-02,
 2.362615799101533756e-02,
 2.364554602740958147e-02,
 2.366489400566097745e-02,
 2.368420189782904917e-02,
 2.370346967603995797e-02,
 2.372269731248768942e-02,
 2.374188477943330045e-02,
 2.376103204920523501e-02,
 2.378013909419934846e-02,
 2.379920588687898728e-02,
 2.381823239977508971e-02,
 2.383721860548590823e-02,
 2.385616447667743625e-02,
 2.387506998608325895e-02,
 2.389393510650449429e-02,
 2.391275981080989363e-02,
 2.393154407193627542e-02,
 2.395028786288787639e-02,
 2.396899115673687547e-02,
 2.398765392662314047e-02,
 2.400627614575474161e-02,
 2.402485778740735128e-02,
 2.404339882492476099e-02,
 2.406189923171841646e-02,
 2.408035898126834051e-02,
 2.409877804712209567e-02,
 2.411715640289568280e-02,
 2.413549402227320798e-02,
 2.415379087900669866e-02,
 2.417204694691660674e-02,
 2.419026219989146853e-02,
 2.420843661188841131e-02,
 2.422657015693237617e-02,
 2.424466280911725252e-02,
 2.426271454260489277e-02,
 2.428072533162560151e-02,
 2.429869515047822920e-02,
 2.431662397353024155e-02,
 2.433451177521741074e-02,
 2.435235853004431156e-02,
 2.437016421258384261e-02,
 2.438792879747791326e-02,
 2.440565225943663874e-02,
 2.442333457323918669e-02,
 2.444097571373335387e-02,
 2.445857565583569454e-02,
 2.447613437453169394e-02,
 2.449365184487561561e-02,
 2.451112804199046674e-02,
 2.452856294106822016e-02,
 2.454595651737005030e-02,
 2.456330874622581276e-02,
 2.458061960303452656e-02,
 2.459788906326422150e-02,
 2.461511710245209081e-02,
 2.463230369620434540e-02,
 2.464944882019633188e-02,
 2.466655245017257414e-02,
 2.468361456194711340e-02,
 2.470063513140259223e-02,
 2.471761413449185749e-02,
 2.473455154723613186e-02,
 2.475144734572670008e-02,
 2.476830150612376741e-02,
 2.478511400465721604e-02,
 2.480188481762633096e-02,
 2.481861392139983122e-02,
 2.483530129241600173e-02,
 2.485194690718259963e-02,
 2.486855074227693752e-02,
 2.488511277434598754e-02,
 2.490163298010657916e-02,
 2.491811133634479203e-02,
 2.493454781991676431e-02,
 2.495094240774812719e-02,
 2.496729507683450103e-02,
 2.498360580424116226e-02,
 2.499987456710317871e-02,
 2.501610134262554838e-02,
 2.503228610808325150e-02,
 2.504842884082101456e-02,
 2.506452951825370243e-02,
 2.508058811786605113e-02,
 2.509660461721265057e-02,
 2.511257899391851345e-02,
 2.512851122567839185e-02,
 2.514440129025741558e-02,
 2.516024916549051971e-02,
 2.517605482928314542e-02,
 2.519181825961080978e-02,
 2.520753943451901208e-02,
 2.522321833212384096e-02,
 2.523885493061163096e-02,
 2.525444920823872313e-02,
 2.527000114333223871e-02,
 2.528551071428933664e-02,
 2.530097789957760912e-02,
 2.531640267773541120e-02,
 2.533178502737096910e-02,
 2.534712492716355986e-02,
 2.536242235586258845e-02,
 2.537767729228831287e-02,
 2.539288971533123010e-02,
 2.540805960395279076e-02,
 2.542318693718470524e-02,
 2.543827169412963760e-02,
 2.545331385396069554e-02,
 2.546831339592200288e-02,
 2.548327029932801260e-02,
 2.549818454356439154e-02,
 2.551305610808731958e-02,
 2.552788497242373944e-02,
 2.554267111617158914e-02,
 2.555741451899978117e-02,
 2.557211516064767862e-02,
 2.558677302092631292e-02,
 2.560138807971697184e-02,
 2.561596031697214310e-02,
 2.563048971271558035e-02,
 2.564497624704173417e-02,
 2.565941990011630369e-02,
 2.567382065217584802e-02,
 2.568817848352837954e-02,
 2.570249337455286082e-02,
 2.571676530569936073e-02,
 2.573099425748916549e-02,
 2.574518021051483418e-02,
 2.575932314544015361e-02,
 2.577342304300021467e-02,
 2.578747988400127700e-02,
 2.580149364932098066e-02,
 2.581546431990823162e-02,
 2.582939187678353482e-02,
 2.584327630103852580e-02,
 2.585711757383636275e-02,
 2.587091567641162243e-02,
 2.588467059007044588e-02,
 2.589838229619017412e-02,
 2.591205077621985819e-02,
 2.592567601168022789e-02,
 2.593925798416326853e-02,
 2.595279667533283152e-02,
 2.596629206692408279e-02,
 2.597974414074403354e-02,
 2.599315287867137378e-02,
 2.600651826265618777e-02,
 2.601984027472048489e-02,
 2.603311889695797757e-02,
 2.604635411153405355e-02,
 2.605954590068606386e-02,
 2.607269424672281621e-02,
 2.608579913202515102e-02,
 2.609886053904571929e-02,
 2.611187845030897223e-02,
 2.612485284841132779e-02,
 2.613778371602108047e-02,
 2.615067103587831107e-02,
 2.616351479079523021e-02,
 2.617631496365585911e-02,
 2.618907153741621349e-02,
 2.620178449510461929e-02,
 2.621445381982094938e-02,
 2.622707949473762970e-02,
 2.623966150309873027e-02,
 2.625219982822051684e-02,
 2.626469445349153414e-02,
 2.627714536237251222e-02,
 2.628955253839590153e-02,
 2.630191596516680969e-02,
 2.631423562636240471e-02,
 2.632651150573189422e-02,
 2.633874358709685504e-02,
 2.635093185435097643e-02,
 2.636307629146066034e-02,
 2.637517688246408462e-02,
 2.638723361147208776e-02,
 2.639924646266759642e-02,
 2.641121542030612501e-02,
 2.642314046871535940e-02,
 2.643502159229549689e-02,
 2.644685877551906580e-02,
 2.645865200293124123e-02,
 2.647040125914932457e-02,
 2.648210652886331604e-02,
 2.649376779683576891e-02,
 2.650538504790140096e-02,
 2.651695826696761835e-02,
 2.652848743901456419e-02,
 2.653997254909488263e-02,
 2.655141358233346210e-02,
 2.656281052392829578e-02,
 2.657416335914963151e-02,
 2.658547207334028759e-02,
 2.659673665191611761e-02,
 2.660795708036523682e-02,
 2.661913334424882011e-02,
 2.663026542920045314e-02,
 2.664135332092651409e-02,
 2.665239700520613542e-02,
 2.666339646789122816e-02,
 2.667435169490639871e-02,
 2.668526267224925752e-02,
 2.669612938598989529e-02,
 2.670695182227143805e-02,
 2.671772996730982508e-02,
 2.672846380739375693e-02,
 2.673915332888479254e-02,
 2.674979851821754698e-02,
 2.676039936189931329e-02,
 2.677095584651064189e-02,
 2.678146795870444893e-02,
 2.679193568520731039e-02,
 2.680235901281794592e-02,
 2.681273792840884948e-02,
 2.682307241892485650e-02,
 2.683336247138428179e-02,
 2.684360807287819103e-02,
 2.685380921057083439e-02,
 2.686396587169942798e-02,
 2.687407804357416080e-02,
 2.688414571357843411e-02,
 2.689416886916895164e-02,
 2.690414749787487306e-02,
 2.691408158729914277e-02,
 2.692397112511765028e-02,
 2.693381609907931351e-02,
 2.694361649700619324e-02,
 2.695337230679362844e-02,
 2.696308351641025364e-02,
 2.697275011389745070e-02,
 2.698237208737057705e-02,
 2.699194942501751890e-02,
 2.700148211509966270e-02,
 2.701097014595170084e-02,
 2.702041350598156574e-02,
 2.702981218367045413e-02,
 2.703916616757282357e-02,
 2.704847544631639247e-02,
 2.705774000860235173e-02,
 2.706695984320519471e-02,
 2.707613493897251256e-02,
 2.708526528482568113e-02,
 2.709435086975885143e-02,
 2.710339168284011183e-02,
 2.711238771321075949e-02,
 2.712133895008532122e-02,
 2.713024538275184486e-02,
 2.713910700057186806e-02,
 2.714792379298022404e-02,
 2.715669574948538847e-02,
 2.716542285966902850e-02,
 2.717410511318653701e-02,
 2.718274249976659201e-02,
 2.719133500921134053e-02,
 2.719988263139665879e-02,
 2.720838535627165614e-02,
 2.721684317385908783e-02,
 2.722525607425537938e-02,
 2.723362404763016859e-02,
 2.724194708422677039e-02,
 2.725022517436218039e-02,
 2.725845830842690831e-02,
 2.726664647688480103e-02,
 2.727478967027358037e-02,
 2.728288787920455163e-02,
 2.729094109436239202e-02,
 2.729894930650569179e-02,
 2.730691250646617718e-02,
 2.731483068514979629e-02,
 2.732270383353564702e-02,
 2.733053194267686184e-02,
 2.733831500369996240e-02,
 2.734605300780508855e-02,
 2.735374594626638345e-02,
 2.736139381043118865e-02,
 2.736899659172090105e-02,
 2.737655428163046981e-02,
 2.738406687172859066e-02,
 2.739153435365769551e-02,
 2.739895671913376157e-02,
 2.740633395994647101e-02,
 2.741366606795972785e-02,
 2.742095303511042290e-02,
 2.742819485340975555e-02,
 2.743539151494250178e-02,
 2.744254301186703146e-02,
 2.744964933641571778e-02,
 2.745671048089465272e-02,
 2.746372643768353605e-02,
 2.747069719923594944e-02,
 2.747762275807925925e-02,
 2.748450310681484557e-02,
 2.749133823811735974e-02,
 2.749812814473576866e-02,
 2.750487281949261578e-02,
 2.751157225528414949e-02,
 2.751822644508072901e-02,
 2.752483538192635262e-02,
 2.753139905893890391e-02,
 2.753791746930998527e-02,
 2.754439060630520242e-02,
 2.755081846326390069e-02,
 2.755720103359938361e-02,
 2.756353831079855557e-02,
 2.756983028842239017e-02,
 2.757607696010574289e-02,
 2.758227831955723658e-02,
 2.758843436055954251e-02,
 2.759454507696877321e-02,
 2.760061046271536714e-02,
 2.760663051180344690e-02,
 2.761260521831107248e-02,
 2.761853457639004347e-02,
 2.762441858026643687e-02,
 2.763025722423962868e-02,
 2.763605050268348046e-02,
 2.764179841004532276e-02,
 2.764750094084672538e-02,
 2.765315808968275141e-02,
 2.765876985122284887e-02,
 2.766433622020992092e-02,
 2.766985719146120015e-02,
 2.767533275986749919e-02,
 2.768076292039372069e-02,
 2.768614766807862490e-02,
 2.769148699803494068e-02,
 2.769678090544926835e-02,
 2.770202938558204500e-02,
 2.770723243376789144e-02,
 2.771239004541514381e-02,
 2.771750221600614503e-02,
 2.772256894109699499e-02,
 2.772759021631800505e-02,
 2.773256603737324702e-02,
 2.773749640004076131e-02,
 2.774238130017237305e-02,
 2.774722073369424030e-02,
 2.775201469660582704e-02,
 2.775676318498123546e-02,
 2.776146619496790147e-02,
 2.776612372278761814e-02,
 2.777073576473578290e-02,
 2.777530231718199419e-02,
 2.777982337656953807e-02,
 2.778429893941599532e-02,
 2.778872900231220411e-02,
 2.779311356192381080e-02,
 2.779745261498972261e-02,
 2.780174615832306864e-02,
 2.780599418881079046e-02,
 2.781019670341375316e-02,
 2.781435369916691533e-02,
 2.781846517317891621e-02,
 2.782253112263246772e-02,
 2.782655154478423307e-02,
 2.783052643696454567e-02,
 2.783445579657798513e-02,
 2.783833962110287066e-02,
 2.784217790809141030e-02,
 2.784597065516978068e-02,
 2.784971786003806807e-02,
 2.785341952047020245e-02,
 2.785707563431417608e-02,
 2.786068619949161329e-02,
 2.786425121399819377e-02,
 2.786777067590356927e-02,
 2.787124458335116239e-02,
 2.787467293455830886e-02,
 2.787805572781624011e-02,
 2.788139296149003479e-02,
 2.788468463401862565e-02,
 2.788793074391501467e-02,
 2.789113128976575956e-02,
 2.789428627023141094e-02,
 2.789739568404668232e-02,
 2.790045953001962092e-02,
 2.790347780703250624e-02,
 2.790645051404121169e-02,
 2.790937765007574928e-02,
 2.791225921423965556e-02,
 2.791509520571067160e-02,
 2.791788562373986177e-02,
 2.792063046765269618e-02,
 2.792332973684782949e-02,
 2.792598343079832207e-02,
 2.792859154905068253e-02,
 2.793115409122541928e-02,
 2.793367105701666936e-02,
 2.793614244619253145e-02,
 2.793856825859459408e-02,
 2.794094849413865378e-02,
 2.794328315281403158e-02,
 2.794557223468368407e-02,
 2.794781573988468215e-02,
 2.795001366862754147e-02,
 2.795216602119666299e-02,
 2.795427279795015263e-02,
 2.795633399931998775e-02,
 2.795834962581157310e-02,
 2.796031967800429244e-02,
 2.796224415655127263e-02,
 2.796412306217908178e-02,
 2.796595639568821498e-02,
 2.796774415795288959e-02,
 2.796948634992076077e-02,
 2.797118297261335859e-02,
 2.797283402712586603e-02,
 2.797443951462707731e-02,
 2.797599943635941180e-02,
 2.797751379363912563e-02,
 2.797898258785569414e-02,
 2.798040582047277292e-02,
 2.798178349302728532e-02,
 2.798311560712970700e-02,
 2.798440216446438158e-02,
 2.798564316678900377e-02,
 2.798683861593503214e-02,
 2.798798851380743594e-02,
 2.798909286238466382e-02,
 2.799015166371878610e-02,
 2.799116491993552600e-02,
 2.799213263323405837e-02,
 2.799305480588697506e-02,
 2.799393144024058325e-02,
 2.799476253871441972e-02,
 2.799554810380187539e-02,
 2.799628813806968528e-02,
 2.799698264415779667e-02,
 2.799763162478007342e-02,
 2.799823508272353614e-02,
 2.799879302084879937e-02,
 2.799930544208978009e-02,
 2.799977234945386084e-02,
 2.800019374602189665e-02,
 2.800056963494797213e-02,
 2.800090001946003992e-02,
 2.800118490285873757e-02,
 2.800142428851857060e-02,
 2.800161817988724294e-02,
 2.800176658048590325e-02,
 2.800186949390873897e-02,
 2.800192692382358003e-02,
 2.800193887397143741e-02,
 2.800190534816662455e-02,
 2.800182635029676084e-02,
 2.800170188432259122e-02,
 2.800153195427835737e-02,
 2.800131656427152019e-02,
 2.800105571848243019e-02,
 2.800074942116517057e-02,
 2.800039767664661353e-02,
 2.800000048932706903e-02,
 2.799955786367995178e-02,
 2.799906980425174996e-02,
 2.799853631566230627e-02,
 2.799795740260437732e-02,
 2.799733306984406381e-02,
 2.799666332222040810e-02,
 2.799594816464571687e-02,
 2.799518760210515517e-02,
 2.799438163965713502e-02,
 2.799353028243316624e-02,
 2.799263353563771761e-02,
 2.799169140454807470e-02,
 2.799070389451508920e-02,
 2.798967101096192650e-02,
 2.798859275938528693e-02,
 2.798746914535454877e-02,
 2.798630017451210136e-02,
 2.798508585257330691e-02,
 2.798382618532643806e-02,
 2.798252117863278543e-02,
 2.798117083842629679e-02,
 2.797977517071394832e-02,
 2.797833418157544272e-02,
 2.797684787716360477e-02,
 2.797531626370385396e-02,
 2.797373934749446817e-02,
 2.797211713490642404e-02,
 2.797044963238381338e-02,
 2.796873684644303470e-02,
 2.796697878367370230e-02,
 2.796517545073768166e-02,
 2.796332685436993953e-02,
 2.796143300137793677e-02,
 2.795949389864182608e-02,
 2.795750955311461158e-02,
 2.795547997182160765e-02,
 2.795340516186104601e-02,
 2.795128513040355187e-02,
 2.794911988469256370e-02,
 2.794690943204385103e-02,
 2.794465377984600707e-02,
 2.794235293556000463e-02,
 2.794000690671925857e-02,
 2.793761570092986868e-02,
 2.793517932587024147e-02,
 2.793269778929132960e-02,
 2.793017109901675329e-02,
 2.792759926294205441e-02,
 2.792498228903563667e-02,
 2.792232018533806481e-02,
 2.791961295996234216e-02,
 2.791686062109388286e-02,
 2.791406317699028986e-02,
 2.791122063598156997e-02,
 2.790833300647002635e-02,
 2.790540029693027585e-02,
 2.790242251590909980e-02,
 2.789939967202538854e-02,
 2.789633177397062708e-02,
 2.789321883050818740e-02,
 2.789006085047368577e-02,
 2.788685784277490642e-02,
 2.788360981639176339e-02,
 2.788031678037630398e-02,
 2.787697874385262550e-02,
 2.787359571601692732e-02,
 2.787016770613736510e-02,
 2.786669472355439783e-02,
 2.786317677768010773e-02,
 2.785961387799886294e-02,
 2.785600603406686998e-02,
 2.785235325551234029e-02,
 2.784865555203519527e-02,
 2.784491293340762494e-02,
 2.784112540947348419e-02,
 2.783729299014834138e-02,
 2.783341568541992939e-02,
 2.782949350534758004e-02,
 2.782552646006236988e-02,
 2.782151455976736645e-02,
 2.781745781473716345e-02,
 2.781335623531819290e-02,
 2.780920983192843032e-02,
 2.780501861505790123e-02,
 2.780078259526790399e-02,
 2.779650178319143655e-02,
 2.779217618953332136e-02,
 2.778780582506970229e-02,
 2.778339070064844360e-02,
 2.777893082718893222e-02,
 2.777442621568190773e-02,
 2.776987687718989253e-02,
 2.776528282284660906e-02,
 2.776064406385748973e-02,
 2.775596061149905938e-02,
 2.775123247711937940e-02,
 2.774645967213802689e-02,
 2.774164220804566788e-02,
 2.773678009640457090e-02,
 2.773187334884810035e-02,
 2.772692197708091083e-02,
 2.772192599287890552e-02,
 2.771688540808937840e-02,
 2.771180023463054240e-02,
 2.770667048449206721e-02,
 2.770149616973446166e-02,
 2.769627730248961153e-02,
 2.769101389496045687e-02,
 2.768570595942079771e-02,
 2.768035350821578672e-02,
 2.767495655376151983e-02,
 2.766951510854469970e-02,
 2.766402918512360365e-02,
 2.765849879612699083e-02,
 2.765292395425471977e-02,
 2.764730467227753674e-02,
 2.764164096303707227e-02,
 2.763593283944561566e-02,
 2.763018031448651046e-02,
 2.762438340121364452e-02,
 2.761854211275185586e-02,
 2.761265646229656839e-02,
 2.760672646311397929e-02,
 2.760075212854085427e-02,
 2.759473347198496823e-02,
 2.758867050692407480e-02,
 2.758256324690709638e-02,
 2.757641170555320126e-02,
 2.757021589655221649e-02,
 2.756397583366440932e-02,
 2.755769153072060509e-02,
 2.755136300162200000e-02,
 2.754499026034010895e-02,
 2.753857332091713336e-02,
 2.753211219746542343e-02,
 2.752560690416774175e-02,
 2.751905745527703437e-02,
 2.751246386511680547e-02,
 2.750582614808025003e-02,
 2.749914431863148545e-02,
 2.749241839130436155e-02,
 2.748564838070307464e-02,
 2.747883430150170961e-02,
 2.747197616844488516e-02,
 2.746507399634680324e-02,
 2.745812780009207130e-02,
 2.745113759463501182e-02,
 2.744410339500035628e-02,
 2.743702521628233956e-02,
 2.742990307364532795e-02,
 2.742273698232358670e-02,
 2.741552695762113773e-02,
 2.740827301491207194e-02,
 2.740097516963984833e-02,
 2.739363343731822387e-02,
 2.738624783353022299e-02,
 2.737881837392895298e-02,
 2.737134507423684415e-02,
 2.736382795024625003e-02,
 2.735626701781904840e-02,
 2.734866229288672457e-02,
 2.734101379145009725e-02,
 2.733332152957990493e-02,
 2.732558552341609812e-02,
 2.731780578916809948e-02,
 2.730998234311467210e-02,
 2.730211520160423164e-02,
 2.729420438105436414e-02,
 2.728624989795211050e-02,
 2.727825176885368547e-02,
 2.727021001038442902e-02,
 2.726212463923933724e-02,
 2.725399567218219493e-02,
 2.724582312604601972e-02,
 2.723760701773326326e-02,
 2.722934736421518329e-02,
 2.722104418253209687e-02,
 2.721269748979339084e-02,
 2.720430730317762932e-02,
 2.719587363993207843e-02,
 2.718739651737303933e-02,
 2.717887595288588296e-02,
 2.717031196392441852e-02,
 2.716170456801166727e-02,
 2.715305378273951201e-02,
 2.714435962576808650e-02,
 2.713562211482679551e-02,
 2.712684126771326698e-02,
 2.711801710229430618e-02,
 2.710914963650484094e-02,
 2.710023888834886541e-02,
 2.709128487589831935e-02,
 2.708228761729429557e-02,
 2.707324713074597475e-02,
 2.706416343453105916e-02,
 2.705503654699580388e-02,
 2.704586648655468370e-02,
 2.703665327169047297e-02,
 2.702739692095455087e-02,
 2.701809745296620754e-02,
 2.700875488641308816e-02,
 2.699936924005122071e-02,
 2.698994053270455107e-02,
 2.698046878326530382e-02,
 2.697095401069363532e-02,
 2.696139623401805699e-02,
 2.695179547233462342e-02,
 2.694215174480788302e-02,
 2.693246507067001763e-02,
 2.692273546922122757e-02,
 2.691296295982946452e-02,
 2.690314756193069173e-02,
 2.689328929502848506e-02,
 2.688338817869429312e-02,
 2.687344423256741652e-02,
 2.686345747635442496e-02,
 2.685342792983004545e-02,
 2.684335561283624286e-02,
 2.683324054528285485e-02,
 2.682308274714671759e-02,
 2.681288223847292859e-02,
 2.680263903937338613e-02,
 2.679235317002782307e-02,
 2.678202465068310958e-02,
 2.677165350165367635e-02,
 2.676123974332091440e-02,
 2.675078339613392794e-02,
 2.674028448060861152e-02,
 2.672974301732842020e-02,
 2.671915902694381451e-02,
 2.670853253017228812e-02,
 2.669786354779837834e-02,
 2.668715210067397828e-02,
 2.667639820971753548e-02,
 2.666560189591484983e-02,
 2.665476318031837280e-02,
 2.664388208404737390e-02,
 2.663295862828834668e-02,
 2.662199283429412741e-02,
 2.661098472338462723e-02,
 2.659993431694632898e-02,
 2.658884163643241913e-02,
 2.657770670336259689e-02,
 2.656652953932356689e-02,
 2.655531016596817534e-02,
 2.654404860501585056e-02,
 2.653274487825254407e-02,
 2.652139900753086241e-02,
 2.651001101476928995e-02,
 2.649858092195325407e-02,
 2.648710875113399754e-02,
 2.647559452442951530e-02,
 2.646403826402343035e-02,
 2.645243999216612824e-02,
 2.644079973117376137e-02,
 2.642911750342879715e-02,
 2.641739333137975432e-02,
 2.640562723754088029e-02,
 2.639381924449285197e-02,
 2.638196937488196045e-02,
 2.637007765142058632e-02,
 2.635814409688666191e-02,
 2.634616873412430268e-02,
 2.633415158604313078e-02,
 2.632209267561872248e-02,
 2.630999202589211911e-02,
 2.629784965997007673e-02,
 2.628566560102495522e-02,
 2.627343987229470781e-02,
 2.626117249708263476e-02,
 2.624886349875783093e-02,
 2.623651290075448145e-02,
 2.622412072657229892e-02,
 2.621168699977638808e-02,
 2.619921174399693700e-02,
 2.618669498292978612e-02,
 2.617413674033537696e-02,
 2.616153704004008443e-02,
 2.614889590593460350e-02,
 2.613621336197538211e-02,
 2.612348943218338951e-02,
 2.611072414064494890e-02,
 2.609791751151101930e-02,
 2.608506956899769511e-02,
 2.607218033738593205e-02,
 2.605924984102129735e-02,
 2.604627810431419527e-02,
 2.603326515173993647e-02,
 2.602021100783828006e-02,
 2.600711569721360361e-02,
 2.599397924453503844e-02,
 2.598080167453618861e-02,
 2.596758301201523497e-02,
 2.595432328183453277e-02,
 2.594102250892108344e-02,
 2.592768071826615645e-02,
 2.591429793492540032e-02,
 2.590087418401862060e-02,
 2.588740949073007128e-02,
 2.587390388030786498e-02,
 2.586035737806455584e-02,
 2.584677000937639704e-02,
 2.583314179968395144e-02,
 2.581947277449192155e-02,
 2.580576295936855280e-02,
 2.579201237994620602e-02,
 2.577822106192124291e-02,
 2.576438903105348829e-02,
 2.575051631316661524e-02,
 2.573660293414822831e-02,
 2.572264891994936742e-02,
 2.570865429658493809e-02,
 2.569461909013299322e-02,
 2.568054332673551030e-02,
 2.566642703259761071e-02,
 2.565227023398816003e-02,
 2.563807295723921978e-02,
 2.562383522874615502e-02,
 2.560955707496768638e-02,
 2.559523852242590741e-02,
 2.558087959770562192e-02,
 2.556648032745529805e-02,
 2.555204073838612810e-02,
 2.553756085727267033e-02,
 2.552304071095211346e-02,
 2.550848032632495321e-02,
 2.549387973035430882e-02,
 2.547923895006613815e-02,
 2.546455801254948401e-02,
 2.544983694495574558e-02,
 2.543507577449934456e-02,
 2.542027452845708677e-02,
 2.540543323416871377e-02,
 2.539055191903616046e-02,
 2.537563061052416913e-02,
 2.536066933615956087e-02,
 2.534566812353191562e-02,
 2.533062700029304823e-02,
 2.531554599415706402e-02,
 2.530042513290023734e-02,
 2.528526444436120235e-02,
 2.527006395644056796e-02,
 2.525482369710124742e-02,
 2.523954369436800030e-02,
 2.522422397632769972e-02,
 2.520886457112932535e-02,
 2.519346550698331119e-02,
 2.517802681216241636e-02,
 2.516254851500089249e-02,
 2.514703064389492773e-02,
 2.513147322730217847e-02,
 2.511587629374222030e-02,
 2.510023987179596516e-02,
 2.508456399010621993e-02,
 2.506884867737681558e-02,
 2.505309396237350231e-02,
 2.503729987392286013e-02,
 2.502146644091338482e-02,
 2.500559369229440887e-02,
 2.498968165707686137e-02,
 2.497373036433261223e-02,
 2.495773984319478792e-02,
 2.494171012285737246e-02,
 2.492564123257559258e-02,
 2.490953320166553950e-02,
 2.489338605950439445e-02,
 2.487719983553002973e-02,
 2.486097455924100863e-02,
 2.484471026019716144e-02,
 2.482840696801844396e-02,
 2.481206471238571812e-02,
 2.479568352304054382e-02,
 2.477926342978495344e-02,
 2.476280446248133038e-02,
 2.474630665105286356e-02,
 2.472977002548268008e-02,
 2.471319461581456683e-02,
 2.469658045215241543e-02,
 2.467992756466040605e-02,
 2.466323598356301786e-02,
 2.464650573914464737e-02,
 2.462973686175004562e-02,
 2.461292938178349585e-02,
 2.459608332970974684e-02,
 2.457919873605303798e-02,
 2.456227563139793887e-02,
 2.454531404638827033e-02,
 2.452831401172815909e-02,
 2.451127555818081658e-02,
 2.449419871656961789e-02,
 2.447708351777715119e-02,
 2.445992999274555768e-02,
 2.444273817247688205e-02,
 2.442550808803218079e-02,
 2.440823977053178245e-02,
 2.439093325115566230e-02,
 2.437358856114278313e-02,
 2.435620573179129653e-02,
 2.433878479445865731e-02,
 2.432132578056134600e-02,
 2.430382872157493476e-02,
 2.428629364903360857e-02,
 2.426872059453110200e-02,
 2.425110958971926980e-02,
 2.423346066630942611e-02,
 2.421577385607118563e-02,
 2.419804919083318184e-02,
 2.418028670248225515e-02,
 2.416248642296443469e-02,
 2.414464838428354368e-02,
 2.412677261850256979e-02,
 2.410885915774227395e-02,
 2.409090803418227275e-02,
 2.407291928006020584e-02,
 2.405489292767219386e-02,
 2.403682900937229028e-02,
 2.401872755757257852e-02,
 2.400058860474355363e-02,
 2.398241218341335551e-02,
 2.396419832616866058e-02,
 2.394594706565327316e-02,
 2.392765843456938490e-02,
 2.390933246567669701e-02,
 2.389096919179275330e-02,
 2.387256864579269042e-02,
 2.385413086060938700e-02,
 2.383565586923302657e-02,
 2.381714370471167339e-02,
 2.379859440015030803e-02,
 2.378000798871174326e-02,
 2.376138450361571855e-02,
 2.374272397813962862e-02,
 2.372402644561776019e-02,
 2.370529193944154178e-02,
 2.368652049305989757e-02,
 2.366771213997804352e-02,
 2.364886691375896535e-02,
 2.362998484802178445e-02,
 2.361106597644303806e-02,
 2.359211033275583624e-02,
 2.357311795075016370e-02,
 2.355408886427228995e-02,
 2.353502310722558125e-02,
 2.351592071356940761e-02,
 2.349678171732024964e-02,
 2.347760615255045299e-02,
 2.345839405338902978e-02,
 2.343914545402139837e-02,
 2.341986038868894629e-02,
 2.340053889168941872e-02,
 2.338118099737670347e-02,
 2.336178674016058804e-02,
 2.334235615450688112e-02,
 2.332288927493786010e-02,
 2.330338613603086945e-02,
 2.328384677241979520e-02,
 2.326427121879362861e-02,
 2.324465950989784008e-02,
 2.322501168053271031e-02,
 2.320532776555477364e-02,
 2.318560779987575635e-02,
 2.316585181846313873e-02,
 2.314605985633927387e-02,
 2.312623194858241110e-02,
 2.310636813032561354e-02,
 2.308646843675768792e-02,
 2.306653290312191129e-02,
 2.304656156471738757e-02,
 2.302655445689787139e-02,
 2.300651161507191386e-02,
 2.298643307470343844e-02,
 2.296631887131073135e-02,
 2.294616904046724998e-02,
 2.292598361780099139e-02,
 2.290576263899477688e-02,
 2.288550613978561007e-02,
 2.286521415596570739e-02,
 2.284488672338098880e-02,
 2.282452387793258014e-02,
 2.280412565557513732e-02,
 2.278369209231826190e-02,
 2.276322322422542552e-02,
 2.274271908741459097e-02,
 2.272217971805736564e-02,
 2.270160515237986537e-02,
 2.268099542666163898e-02,
 2.266035057723666743e-02,
 2.263967064049266995e-02,
 2.261895565287072932e-02,
 2.259820565086620436e-02,
 2.257742067102780706e-02,
 2.255660074995789396e-02,
 2.253574592431230664e-02,
 2.251485623080044102e-02,
 2.249393170618513987e-02,
 2.247297238728256444e-02,
 2.245197831096193766e-02,
 2.243094951414602647e-02,
 2.240988603381032993e-02,
 2.238878790698389798e-02,
 2.236765517074832191e-02,
 2.234648786223869532e-02,
 2.232528601864252477e-02,
 2.230404967720047912e-02,
 2.228277887520578940e-02,
 2.226147365000415504e-02,
 2.224013403899437885e-02,
 2.221876007962770780e-02,
 2.219735180940777750e-02,
 2.217590926589053935e-02,
 2.215443248668479484e-02,
 2.213292150945090839e-02,
 2.211137637190232347e-02,
 2.208979711180380362e-02,
 2.206818376697296594e-02,
 2.204653637527912574e-02,
 2.202485497464375108e-02,
 2.200313960303976191e-02,
 2.198139029849259171e-02,
 2.195960709907888303e-02,
 2.193779004292729234e-02,
 2.191593916821816743e-02,
 2.189405451318345713e-02,
 2.187213611610631936e-02,
 2.185018401532161370e-02,
 2.182819824921556490e-02,
 2.180617885622559635e-02,
 2.178412587484061108e-02,
 2.176203934360050607e-02,
 2.173991930109647405e-02,
 2.171776578597044843e-02,
 2.169557883691591860e-02,
 2.167335849267656642e-02,
 2.165110479204734525e-02,
 2.162881777387417812e-02,
 2.160649747705335397e-02,
 2.158414394053191285e-02,
 2.156175720330760423e-02,
 2.153933730442841171e-02,
 2.151688428299319139e-02,
 2.149439817815080450e-02,
 2.147187902910052681e-02,
 2.144932687509224639e-02,
 2.142674175542539153e-02,
 2.140412370945009302e-02,
 2.138147277656601147e-02,
 2.135878899622331920e-02,
 2.133607240792151361e-02,
 2.131332305121052054e-02,
 2.129054096568962912e-02,
 2.126772619100825157e-02,
 2.124487876686477483e-02,
 2.122199873300796222e-02,
 2.119908612923517705e-02,
 2.117614099539407574e-02,
 2.115316337138122352e-02,
 2.113015329714263563e-02,
 2.110711081267332284e-02,
 2.108403595801778413e-02,
 2.106092877326940296e-02,
 2.103778929857053059e-02,
 2.101461757411260400e-02,
 2.099141364013598979e-02,
 2.096817753692993558e-02,
 2.094490930483188310e-02,
 2.092160898422884205e-02,
 2.089827661555545418e-02,
 2.087491223929578352e-02,
 2.085151589598172386e-02,
 2.082808762619410559e-02,
 2.080462747056146741e-02,
 2.078113546976120482e-02,
 2.075761166451845982e-02,
 2.073405609560692586e-02,
 2.071046880384768904e-02,
 2.068684983011045628e-02,
 2.066319921531278858e-02,
 2.063951700041959103e-02,
 2.061580322644411545e-02,
 2.059205793444681895e-02,
 2.056828116553627295e-02,
 2.054447296086811883e-02,
 2.052063336164584167e-02,
 2.049676240912025327e-02,
 2.047286014458964132e-02,
 2.044892660939915188e-02,
 2.042496184494166714e-02,
 2.040096589265663965e-02,
 2.037693879403114708e-02,
 2.035288059059890686e-02,
 2.032879132394090418e-02,
 2.030467103568428522e-02,
 2.028051976750389757e-02,
 2.025633756112055900e-02,
 2.023212445830193523e-02,
 2.020788050086246707e-02,
 2.018360573066287078e-02,
 2.015930018961054407e-02,
 2.013496391965882704e-02,
 2.011059696280774467e-02,
 2.008619936110310478e-02,
 2.006177115663728902e-02,
 2.003731239154857291e-02,
 2.001282310802127845e-02,
 1.998830334828531272e-02,
 1.996375315461704214e-02,
 1.993917256933795332e-02,
 1.991456163481580832e-02,
 1.988992039346356225e-02,
 1.986524888773998077e-02,
 1.984054716014927583e-02,
 1.981581525324117854e-02,
 1.979105320961059566e-02,
 1.976626107189754719e-02,
 1.974143888278772491e-02,
 1.971658668501126421e-02,
 1.969170452134435395e-02,
 1.966679243460712351e-02,
 1.964185046766538101e-02,
 1.961687866342922901e-02,
 1.959187706485382430e-02,
 1.956684571493895117e-02,
 1.954178465672893814e-02,
 1.951669393331277938e-02,
 1.949157358782396127e-02,
 1.946642366344013275e-02,
 1.944124420338354947e-02,
 1.941603525092039373e-02,
 1.939079684936146838e-02,
 1.936552904206113868e-02,
 1.934023187241816835e-02,
 1.931490538387535885e-02,
 1.928954961991897338e-02,
 1.926416462407951058e-02,
 1.923875043993081291e-02,
 1.921330711109071193e-02,
 1.918783468122043853e-02,
 1.916233319402491433e-02,
 1.913680269325216884e-02,
 1.911124322269407497e-02,
 1.908565482618516593e-02,
 1.906003754760379407e-02,
 1.903439143087098245e-02,
 1.900871651995111877e-02,
 1.898301285885145573e-02,
 1.895728049162241635e-02,
 1.893151946235662256e-02,
 1.890572981519028292e-02,
 1.887991159430173205e-02,
 1.885406484391166995e-02,
 1.882818960828445271e-02,
 1.880228593172569157e-02,
 1.877635385858409528e-02,
 1.875039343325033206e-02,
 1.872440470015774086e-02,
 1.869838770378112053e-02,
 1.867234248863798574e-02,
 1.864626909928765799e-02,
 1.862016758033147729e-02,
 1.859403797641241696e-02,
 1.856788033221557291e-02,
 1.854169469246729970e-02,
 1.851548110193609181e-02,
 1.848923960543149420e-02,
 1.846297024780498702e-02,
 1.843667307394940974e-02,
 1.841034812879843371e-02,
 1.838399545732772103e-02,
 1.835761510455344303e-02,
 1.833120711553333504e-02,
 1.830477153536591919e-02,
 1.827830840919091038e-02,
 1.825181778218852233e-02,
 1.822529969958025867e-02,
 1.819875420662777840e-02,
 1.817218134863385001e-02,
 1.814558117094147369e-02,
 1.811895371893439133e-02,
 1.809229903803678818e-02,
 1.806561717371305345e-02,
 1.803890817146770395e-02,
 1.801217207684581087e-02,
 1.798540893543205607e-02,
 1.795861879285158905e-02,
 1.793180169476958630e-02,
 1.790495768689048806e-02,
 1.787808681495926463e-02,
 1.785118912475995231e-02,
 1.782426466211691971e-02,
 1.779731347289331689e-02,
 1.777033560299247708e-02,
 1.774333109835680641e-02,
 1.771630000496822108e-02,
 1.768924236884752976e-02,
 1.766215823605536001e-02,
 1.763504765269064897e-02,
 1.760791066489219084e-02,
 1.758074731883675634e-02,
 1.755355766074117099e-02,
 1.752634173686000441e-02,
 1.749909959348724953e-02,
 1.747183127695504240e-02,
 1.744453683363417218e-02,
 1.741721630993421296e-02,
 1.738986975230289930e-02,
 1.736249720722645232e-02,
 1.733509872122896561e-02,
 1.730767434087321713e-02,
 1.728022411275954850e-02,
 1.725274808352690592e-02,
 1.722524629985142455e-02,
 1.719771880844777473e-02,
 1.717016565606803088e-02,
 1.714258688950223708e-02,
 1.711498255557763679e-02,
 1.708735270115948474e-02,
 1.705969737315004078e-02,
 1.703201661848925338e-02,
 1.700431048415429816e-02,
 1.697657901715977219e-02,
 1.694882226455700705e-02,
 1.692104027343444353e-02,
 1.689323309091797856e-02,
 1.686540076416979256e-02,
 1.683754334038941106e-02,
 1.680966086681280613e-02,
 1.678175339071295152e-02,
 1.675382095939882687e-02,
 1.672586362021656961e-02,
 1.669788142054808369e-02,
 1.666987440781238575e-02,
 1.664184262946386342e-02,
 1.661378613299412804e-02,
 1.658570496593003707e-02,
 1.655759917583506102e-02,
 1.652946881030799633e-02,
 1.650131391698425945e-02,
 1.647313454353435680e-02,
 1.644493073766495339e-02,
 1.641670254711842872e-02,
 1.638845001967226267e-02,
 1.636017320313979534e-02,
 1.633187214536942905e-02,
 1.630354689424536735e-02,
 1.627519749768645274e-02,
 1.624682400364705487e-02,
 1.621842646011653274e-02,
 1.619000491511950537e-02,
 1.616155941671474847e-02,
 1.613309001299676609e-02,
 1.610459675209408720e-02,
 1.607607968217030642e-02,
 1.604753885142351164e-02,
 1.601897430808650602e-02,
 1.599038610042610026e-02,
 1.596177427674350460e-02,
 1.593313888537465500e-02,
 1.590447997468910288e-02,
 1.587579759309085473e-02,
 1.584709178901785864e-02,
 1.581836261094219168e-02,
 1.578961010736915777e-02,
 1.576083432683863736e-02,
 1.573203531792356086e-02,
 1.570321312923086271e-02,
 1.567436780940084998e-02,
 1.564549940710753539e-02,
 1.561660797105781338e-02,
 1.558769354999236904e-02,
 1.555875619268467548e-02,
 1.552979594794177791e-02,
 1.550081286460316260e-02,
 1.547180699154184803e-02,
 1.544277837766360600e-02,
 1.541372707190672917e-02,
 1.538465312324263992e-02,
 1.535555658067491204e-02,
 1.532643749324025945e-02,
 1.529729591000715885e-02,
 1.526813188007709356e-02,
 1.523894545258363056e-02,
 1.520973667669267386e-02,
 1.518050560160182604e-02,
 1.515125227654152452e-02,
 1.512197675077324791e-02,
 1.509267907359120725e-02,
 1.506335929432093407e-02,
 1.503401746232016153e-02,
 1.500465362697747836e-02,
 1.497526783771396981e-02,
 1.494586014398154028e-02,
 1.491643059526354467e-02,
 1.488697924107506426e-02,
 1.485750613096212605e-02,
 1.482801131450220411e-02,
 1.479849484130315446e-02,
 1.476895676100468610e-02,
 1.473939712327672173e-02,
 1.470981597782042120e-02,
 1.468021337436751020e-02,
 1.465058936268072952e-02,
 1.462094399255264160e-02,
 1.459127731380703910e-02,
 1.456158937629763520e-02,
 1.453188022990894654e-02,
 1.450214992455512060e-02,
 1.447239851018097996e-02,
 1.444262603676122261e-02,
 1.441283255430069431e-02,
 1.438301811283391324e-02,
 1.435318276242520882e-02,
 1.432332655316895589e-02,
 1.429344953518883743e-02,
 1.426355175863834417e-02,
 1.423363327370046581e-02,
 1.420369413058764942e-02,
 1.417373437954132231e-02,
 1.414375407083258603e-02,
 1.411375325476131593e-02,
 1.408373198165666952e-02,
 1.405369030187693380e-02,
 1.402362826580921991e-02,
 1.399354592386904857e-02,
 1.396344332650142211e-02,
 1.393332052417921296e-02,
 1.390317756740459647e-02,
 1.387301450670760591e-02,
 1.384283139264707793e-02,
 1.381262827581029515e-02,
 1.378240520681209801e-02,
 1.375216223629641132e-02,
 1.372189941493425977e-02,
 1.369161679342534819e-02,
 1.366131442249710407e-02,
 1.363099235290482318e-02,
 1.360065063543118742e-02,
 1.357028932088706272e-02,
 1.353990846011027087e-02,
 1.350950810396676742e-02,
 1.347908830334923133e-02,
 1.344864910917810061e-02,
 1.341819057240102933e-02,
 1.338771274399283388e-02,
 1.335721567495485804e-02,
 1.332669941631626012e-02,
 1.329616401913238238e-02,
 1.326560953448533038e-02,
 1.323503601348489586e-02,
 1.320444350726628600e-02,
 1.317383206699217386e-02,
 1.314320174385099314e-02,
 1.311255258905820106e-02,
 1.308188465385485937e-02,
 1.305119798950881045e-02,
 1.302049264731381176e-02,
 1.298976867858974565e-02,
 1.295902613468215281e-02,
 1.292826506696288791e-02,
 1.289748552682907015e-02,
 1.286668756570402174e-02,
 1.283587123503625478e-02,
 1.280503658630007674e-02,
 1.277418367099528163e-02,
 1.274331254064670245e-02,
 1.271242324680487042e-02,
 1.268151584104493072e-02,
 1.265059037496764696e-02,
 1.261964690019859968e-02,
 1.258868546838854199e-02,
 1.255770613121243336e-02,
 1.252670894037075967e-02,
 1.249569394758791481e-02,
 1.246466120461376184e-02,
 1.243361076322171271e-02,
 1.240254267521027215e-02,
 1.237145699240206446e-02,
 1.234035376664414235e-02,
 1.230923304980721320e-02,
 1.227809489378665388e-02,
 1.224693935050123229e-02,
 1.221576647189406319e-02,
 1.218457630993221609e-02,
 1.215336891660581502e-02,
 1.212214434392933776e-02,
 1.209090264394019863e-02,
 1.205964386869991418e-02,
 1.202836807029278657e-02,
 1.199707530082677956e-02,
 1.196576561243303284e-02,
 1.193443905726588976e-02,
 1.190309568750229537e-02,
 1.187173555534276614e-02,
 1.184035871301006466e-02,
 1.180896521275040870e-02,
 1.177755510683176250e-02,
 1.174612844754600177e-02,
 1.171468528720630460e-02,
 1.168322567814914642e-02,
 1.165174967273273007e-02,
 1.162025732333768838e-02,
 1.158874868236705810e-02,
 1.155722380224587578e-02,
 1.152568273542126272e-02,
 1.149412553436178312e-02,
 1.146255225155852660e-02,
 1.143096293952362494e-02,
 1.139935765079160869e-02,
 1.136773643791779906e-02,
 1.133609935347955865e-02,
 1.130444645007544664e-02,
 1.127277778032564730e-02,
 1.124109339687081287e-02,
 1.120939335237356241e-02,
 1.117767769951694828e-02,
 1.114594649100527843e-02,
 1.111419977956380582e-02,
 1.108243761793859493e-02,
 1.105066005889607413e-02,
 1.101886715522334623e-02,
 1.098705895972858053e-02,
 1.095523552523952615e-02,
 1.092339690460504380e-02,
 1.089154315069389492e-02,
 1.085967431639530550e-02,
 1.082779045461799462e-02,
 1.079589161829149456e-02,
 1.076397786036437446e-02,
 1.073204923380596983e-02,
 1.070010579160426273e-02,
 1.066814758676823231e-02,
 1.063617467232520417e-02,
 1.060418710132280187e-02,
 1.057218492682742567e-02,
 1.054016820192542163e-02,
 1.050813697972161065e-02,
 1.047609131334058773e-02,
 1.044403125592590839e-02,
 1.041195686063961859e-02,
 1.037986818066326082e-02,
 1.034776526919650198e-02,
 1.031564817945840318e-02,
 1.028351696468595734e-02,
 1.025137167813514570e-02,
 1.021921237308019530e-02,
 1.018703910281397625e-02,
 1.015485192064695917e-02,
 1.012265087990853359e-02,
 1.009043603394546226e-02,
 1.005820743612303829e-02,
 1.002596513982426975e-02,
 9.993709198450183295e-03,
 9.961439665419159761e-03,
 9.929156594167225583e-03,
 9.896860038148460464e-03,
 9.864550050833821235e-03,
 9.832226685712023087e-03,
 9.799889996288984467e-03,
 9.767540036087969321e-03,
 9.735176858648889736e-03,
 9.702800517529301672e-03,
 9.670411066303041467e-03,
 9.638008558561495659e-03,
 9.605593047911935647e-03,
 9.573164587979566403e-03,
 9.540723232404872342e-03,
 9.508269034845794401e-03,
 9.475802048975967562e-03,
 9.443322328486002809e-03,
 9.410829927082101087e-03,
 9.378324898487066380e-03,
 9.345807296439915396e-03,
 9.313277174694899185e-03,
 9.280734587023024493e-03,
 9.248179587210260053e-03,
 9.215612229059113453e-03,
 9.183032566386868656e-03,
 9.150440653026982452e-03,
 9.117836542828149440e-03,
 9.085220289654529283e-03,
 9.052591947385052809e-03,
 9.019951569914606837e-03,
 8.987299211152351489e-03,
 8.954634925023007355e-03,
 8.921958765466080077e-03,
 8.889270786436021671e-03,
 8.856571041901493274e-03,
 8.823859585846525674e-03,
 8.791136472269185306e-03,
 8.758401755181962831e-03,
 8.725655488612128752e-03,
 8.692897726601056876e-03,
 8.660128523204486256e-03,
 8.627347932491756174e-03,
 8.594556008546925044e-03,
 8.561752805467299360e-03,
 8.528938377364549128e-03,
 8.496112778363946322e-03,
 8.463276062604600802e-03,
 8.430428284238655409e-03,
 8.397569497432486388e-03,
 8.364699756365150812e-03,
 8.331819115229744874e-03,
 8.298927628231885997e-03,
 8.266025349590838678e-03,
 8.233112333538728650e-03,
 8.200188634320908915e-03,
 8.167254306195158298e-03,
 8.134309403432080435e-03,
 8.101353980315495820e-03,
 8.068388091141130355e-03,
 8.035411790217751593e-03,
 8.002425131866415867e-03,
 7.969428170420634824e-03,
 7.936420960225672866e-03,
 7.903403555639725020e-03,
 7.870376011032201302e-03,
 7.837338380785196026e-03,
 7.804290719292419215e-03,
 7.771233080959616402e-03,
 7.738165520203678718e-03,
 7.705088091453876284e-03,
 7.672000849150272667e-03,
 7.638903847745135214e-03,
 7.605797141701346915e-03,
 7.572680785493620705e-03,
 7.539554833607844606e-03,
 7.506419340540467638e-03,
 7.473274360799663819e-03,
 7.440119948903821216e-03,
 7.406956159382683397e-03,
 7.373783046776537578e-03,
 7.340600665636547693e-03,
 7.307409070523850601e-03,
 7.274208316010812025e-03,
 7.240998456679418466e-03,
 7.207779547122736968e-03,
 7.174551641943238516e-03,
 7.141314795754141569e-03,
 7.108069063178450164e-03,
 7.074814498849290451e-03,
 7.041551157409136133e-03,
 7.008279093510902218e-03,
 6.974998361816656112e-03,
 6.941709016998017477e-03,
 6.908411113736501706e-03,
 6.875104706722813021e-03,
 6.841789850657184480e-03,
 6.808466600248493268e-03,
 6.775135010215517506e-03,
 6.741795135285311678e-03,
 6.708447030194483393e-03,
 6.675090749688283517e-03,
 6.641726348520956592e-03,
 6.608353881454861328e-03,
 6.574973403261691850e-03,
 6.541584968720941598e-03,
 6.508188632621271161e-03,
 6.474784449758896714e-03,
 6.441372474938857236e-03,
 6.407952762974334499e-03,
 6.374525368686039840e-03,
 6.341090346903379034e-03,
 6.307647752462928331e-03,
 6.274197640209588055e-03,
 6.240740064995817585e-03,
 6.207275081681829648e-03,
 6.173802745134858265e-03,
 6.140323110230301064e-03,
 6.106836231850167572e-03,
 6.073342164884465259e-03,
 6.039840964229631348e-03,
 6.006332684789751457e-03,
 5.972817381475726065e-03,
 5.939295109205510771e-03,
 5.905765922903381641e-03,
 5.872229877500998591e-03,
 5.838687027935989850e-03,
 5.805137429153047444e-03,
 5.771581136103347796e-03,
 5.738018203743837017e-03,
 5.704448687038542361e-03,
 5.670872640956880865e-03,
 5.637290120475156423e-03,
 5.603701180574910054e-03,
 5.570105876244159371e-03,
 5.536504262476604939e-03,
 5.502896394271854924e-03,
 5.469282326634597631e-03,
 5.435662114575849635e-03,
 5.402035813111352031e-03,
 5.368403477262966884e-03,
 5.334765162057128994e-03,
 5.301120922526018561e-03,
 5.267470813706745872e-03,
 5.233814890641659209e-03,
 5.200153208377650098e-03,
 5.166485821966452542e-03,
 5.132812786464959615e-03,
 5.099134156934528699e-03,
 5.065449988441287667e-03,
 5.031760336055305684e-03,
 4.998065254851792767e-03,
 4.964364799909509046e-03,
 4.930659026312219327e-03,
 4.896947989147053780e-03,
 4.863231743505744796e-03,
 4.829510344483809933e-03,
 4.795783847180789573e-03,
 4.762052306699475837e-03,
 4.728315778147064441e-03,
 4.694574316633629875e-03,
 4.660827977273291137e-03,
 4.627076815183403351e-03,
 4.593320885484869151e-03,
 4.559560243301386678e-03,
 4.525794943759885863e-03,
 4.492025041990873636e-03,
 4.458250593127080844e-03,
 4.424471652304702574e-03,
 4.390688274662525592e-03,
 4.356900515342228448e-03,
 4.323108429487538401e-03,
 4.289312072245482152e-03,
 4.255511498764723982e-03,
 4.221706764197078431e-03,
 4.187897923695652405e-03,
 4.154085032417025730e-03,
 4.120268145518572733e-03,
 4.086447318160561261e-03,
 4.052622605504419689e-03,
 4.018794062714157664e-03,
 3.984961744954730253e-03,
 3.951125707393288687e-03,
 3.917286005198548048e-03,
 3.883442693540094248e-03,
 3.849595827589635203e-03,
 3.815745462519390570e-03,
 3.781891653503540677e-03,
 3.748034455716584175e-03,
 3.714173924334604818e-03,
 3.680310114534419714e-03,
 3.646443081493851678e-03,
 3.612572880390903934e-03,
 3.578699566404974861e-03,
 3.544823194715279822e-03,
 3.510943820502066340e-03,
 3.477061498945770591e-03,
 3.443176285227322279e-03,
 3.409288234527463324e-03,
 3.375397402027058812e-03,
 3.341503842907557129e-03,
 3.307607612349600015e-03,
 3.273708765534230365e-03,
 3.239807357642069535e-03,
 3.205903443853580156e-03,
 3.171997079348256882e-03,
 3.138088319305825952e-03,
 3.104177218904667027e-03,
 3.070263833323220483e-03,
 3.036348217738204115e-03,
 3.002430427326801491e-03,
 2.968510517263908081e-03,
 2.934588542724313534e-03,
 2.900664558880941806e-03,
 2.866738620906228094e-03,
 2.832810783970539370e-03,
 2.798881103243413843e-03,
 2.764949633892912172e-03,
 2.731016431084917935e-03,
 2.697081549984433474e-03,
 2.663145045753928866e-03,
 2.629206973554791722e-03,
 2.595267388545715627e-03,
 2.561326345883926155e-03,
 2.527383900724370757e-03,
 2.493440108219960750e-03,
 2.459495023520756000e-03,
 2.425548701775196575e-03,
 2.391601198128485550e-03,
 2.357652567723849280e-03,
 2.323702865701667442e-03,
 2.289752147199780076e-03,
 2.255800467352621092e-03,
 2.221847881292479850e-03,
 2.187894444148072177e-03,
 2.153940211045017854e-03,
 2.119985237106136386e-03,
 2.086029577450798644e-03,
 2.052073287195183612e-03,
 2.018116421451474334e-03,
 1.984159035329066158e-03,
 1.950201183932977287e-03,
 1.916242922365264103e-03,
 1.882284305723241338e-03,
 1.848325389101648309e-03,
 1.814366227589926921e-03,
 1.780406876274392459e-03,
 1.746447390236445952e-03,
 1.712487824554000549e-03,
 1.678528234299879506e-03,
 1.644568674543038294e-03,
 1.610609200347755138e-03,
 1.576649866773874092e-03,
 1.542690728876172949e-03,
 1.508731841704670290e-03,
 1.474773260305060896e-03,
 1.440815039717344885e-03,
 1.406857234977039852e-03,
 1.372899901114342340e-03,
 1.338943093154414728e-03,
 1.304986866116544103e-03,
 1.271031275015381068e-03,
 1.237076374859321032e-03,
 1.203122220651762098e-03,
 1.169168867390250497e-03,
 1.135216370066757493e-03,
 1.101264783666862325e-03,
 1.067314163170961097e-03,
 1.033364563552674736e-03,
 9.994160397802877207e-04,
 9.654686468151204865e-04,
 9.315224396127846007e-04,
 8.975774731225181482e-04,
 8.636338022865401977e-04,
 8.296914820412679267e-04,
 7.957505673157324938e-04,
 7.618111130328121018e-04,
 7.278731741083771046e-04,
 6.939368054515884874e-04,
 6.600020619640511055e-04,
 6.260689985410534692e-04,
 5.921376700699566191e-04,
 5.582081314316297187e-04,
 5.242804374988427243e-04,
 4.903546431375021587e-04,
 4.564308032058099875e-04,
 4.225089725545501189e-04,
 3.885892060262469551e-04,
 3.546715584564001894e-04,
 3.207560846720701399e-04,
 2.868428394923616827e-04,
 2.529318777287114573e-04,
 2.190232541842331980e-04,
 1.851170236540089237e-04,
 1.512132409242433685e-04,
 1.173119607735009345e-04,
 8.341323797110359315e-05,
 4.951712727836799416e-05,
 1.562368344776079716e-05,
-1.826703877681107706e-05,
-5.215498466084425745e-05,
-8.604009947800363015e-05,
-1.199223285117223227e-04,
-1.538016170537768220e-04,
-1.876779104058872057e-04,
-2.215511538784824459e-04,
-2.554212927913534787e-04,
-2.892882724743084280e-04,
-3.231520382659381057e-04,
-3.570125355152157522e-04,
-3.908697095802600701e-04,
-4.247235058291787334e-04,
-4.585738696397806402e-04,
-4.924207464004152482e-04,
-5.262640815087411914e-04,
-5.601038203733246660e-04,
-5.939399084122110473e-04,
-6.277722910545288594e-04,
-6.616009137392555185e-04,
-6.954257219160514102e-04,
-7.292466610449841770e-04,
-7.630636765973550966e-04,
-7.968767140544778371e-04,
-8.306857189092670297e-04,
-8.644906366650126871e-04,
-8.982914128360217250e-04,
-9.320879929482886505e-04,
-9.658803225382407058e-04,
-9.996683471543521375e-04,
-1.033452012355715217e-03,
-1.067231263713635213e-03,
-1.101006046810396564e-03,
-1.134776307240109540e-03,
-1.168541990608412077e-03,
-1.202303042533323704e-03,
-1.236059408643997619e-03,
-1.269811034582322496e-03,
-1.303557866001509328e-03,
-1.337299848567673069e-03,
-1.371036927958602927e-03,
-1.404769049864611728e-03,
-1.438496159988238415e-03,
-1.472218204044901816e-03,
-1.505935127762611167e-03,
-1.539646876881666437e-03,
-1.573353397155332484e-03,
-1.607054634349533309e-03,
-1.640750534243681693e-03,
-1.674441042629475941e-03,
-1.708126105312471115e-03,
-1.741805668110659160e-03,
-1.775479676856077643e-03,
-1.809148077393561401e-03,
-1.842810815581596463e-03,
-1.876467837292014737e-03,
-1.910119088410840767e-03,
-1.943764514837074617e-03,
-1.977404062484255497e-03,
-2.011037677279253321e-03,
-2.044665305163098114e-03,
-2.078286892090691618e-03,
-2.111902384031459981e-03,
-2.145511726969055819e-03,
-2.179114866900897212e-03,
-2.212711749839549411e-03,
-2.246302321811514003e-03,
-2.279886528858045963e-03,
-2.313464317034884341e-03,
-2.347035632413080157e-03,
-2.380600421077769518e-03,
-2.414158629129752650e-03,
-2.447710202684092243e-03,
-2.481255087871705491e-03,
-2.514793230838098612e-03,
-2.548324577744252428e-03,
-2.581849074766314010e-03,
-2.615366668096402898e-03,
-2.648877303941437125e-03,
-2.682380928524687961e-03,
-2.715877488084547826e-03,
-2.749366928875191657e-03,
-2.782849197167225688e-03,
-2.816324239246457539e-03,
-2.849792001415466566e-03,
-2.883252429992230401e-03,
-2.916705471311656708e-03,
-2.950151071724403575e-03,
-2.983589177597675748e-03,
-3.017019735314968761e-03,
-3.050442691276885991e-03,
-3.083857991899908307e-03,
-3.117265583617989579e-03,
-3.150665412881332398e-03,
-3.184057426157201227e-03,
-3.217441569929660461e-03,
-3.250817790700213233e-03,
-3.284186034987481365e-03,
-3.317546249326795531e-03,
-3.350898380271526231e-03,
-3.384242374391867748e-03,
-3.417578178275721117e-03,
-3.450905738528349358e-03,
-3.484225001773234853e-03,
-3.517535914650853340e-03,
-3.550838423820256405e-03,
-3.584132475957658992e-03,
-3.617418017758190600e-03,
-3.650694995933768949e-03,
-3.683963357215769285e-03,
-3.717223048352902379e-03,
-3.750474016112932338e-03,
-3.783716207281305737e-03,
-3.816949568662726319e-03,
-3.850174047079919868e-03,
-3.883389589374276925e-03,
-3.916596142406494202e-03,
-3.949793653055404946e-03,
-3.982982068219463427e-03,
-4.016161334815409635e-03,
-4.049331399779821858e-03,
-4.082492210067902375e-03,
-4.115643712654283234e-03,
-4.148785854532763447e-03,
-4.181918582717146851e-03,
-4.215041844239990516e-03,
-4.248155586154182470e-03,
-4.281259755531763821e-03,
-4.314354299464708518e-03,
-4.347439165064652736e-03,
-4.380514299463746618e-03,
-4.413579649813385332e-03,
-4.446635163285636745e-03,
-4.479680787072753100e-03,
-4.512716468386884783e-03,
-4.545742154460731717e-03,
-4.578757792547220699e-03,
-4.611763329920365827e-03,
-4.644758713874067198e-03,
-4.677743891723602776e-03,
-4.710718810804339490e-03,
-4.743683418473376885e-03,
-4.776637662107473259e-03,
-4.809581489105716270e-03,
-4.842514846887343259e-03,
-4.875437682893564439e-03,
-4.908349944586060630e-03,
-4.941251579448672007e-03,
-4.974142534986068440e-03,
-5.007022758724651544e-03,
-5.039892198212244170e-03,
-5.072750801018705361e-03,
-5.105598514735703967e-03,
-5.138435286976147064e-03,
-5.171261065375663997e-03,
-5.204075797591342645e-03,
-5.236879431302536060e-03,
-5.269671914210630886e-03,
-5.302453194039782013e-03,
-5.335223218535812759e-03,
-5.367981935467679849e-03,
-5.400729292626322425e-03,
-5.433465237825439199e-03,
-5.466189718901266412e-03,
-5.498902683713297740e-03,
-5.531604080143168872e-03,
-5.564293856096206616e-03,
-5.596971959499952645e-03,
-5.629638338305817565e-03,
-5.662292940487824097e-03,
-5.694935714043246333e-03,
-5.727566606993262852e-03,
-5.760185567381725935e-03,
-5.792792543276730627e-03,
-5.825387482769218278e-03,
-5.857970333974725149e-03,
-5.890541045031246967e-03,
-5.923099564101897384e-03,
-5.955645839372782947e-03,
-5.988179819054736085e-03,
-6.020701451381950745e-03,
-6.053210684613489004e-03,
-6.085707467032117068e-03,
-6.118191746945099777e-03,
-6.150663472683932584e-03,
-6.183122592605144741e-03,
-6.215569055089085852e-03,
-6.248002808541310189e-03,
-6.280423801392122189e-03,
-6.312831982096231247e-03,
-6.345227299133474226e-03,
-6.377609701008417342e-03,
-6.409979136251275564e-03,
-6.442335553416654072e-03,
-6.474678901085128592e-03,
-6.507009127861973843e-03,
-6.539326182378084676e-03,
-6.571630013289592696e-03,
-6.603920569278746641e-03,
-6.636197799052659038e-03,
-6.668461651344908224e-03,
-6.700712074914093319e-03,
-6.732949018545436246e-03,
-6.765172431049557011e-03,
-6.797382261263083467e-03,
-6.829578458049298355e-03,
-6.861760970296975314e-03,
-6.893929746921825634e-03,
-6.926084736865412324e-03,
-6.958225889095912518e-03,
-6.990353152607785281e-03,
-7.022466476422658047e-03,
-7.054565809588126193e-03,
-7.086651101179207608e-03,
-7.118722300297054655e-03,
-7.150779356070457310e-03,
-7.182822217654640136e-03,
-7.214850834232082802e-03,
-7.246865155012239927e-03,
-7.278865129232339054e-03,
-7.310850706156199301e-03,
-7.342821835075734500e-03,
-7.374778465309640013e-03,
-7.406720546204846427e-03,
-7.438648027135384179e-03,
-7.470560857503028875e-03,
-7.502458986737808692e-03,
-7.534342364296989572e-03,
-7.566210939666435237e-03,
-7.598064662359528196e-03,
-7.629903481917954707e-03,
-7.661727347911341350e-03,
-7.693536209938211731e-03,
-7.725330017624644670e-03,
-7.757108720625879687e-03,
-7.788872268624966524e-03,
-7.820620611334202360e-03,
-7.852353698494053680e-03,
-7.884071479873907412e-03,
-7.915773905271747402e-03,
-7.947460924514850034e-03,
-7.979132487459463310e-03,
-8.010788543990524091e-03,
-8.042429044022270448e-03,
-8.074053937498016156e-03,
-8.105663174390848047e-03,
-8.137256704702573035e-03,
-8.168834478465071200e-03,
-8.200396445739130055e-03,
-8.231942556615801099e-03,
-8.263472761215272244e-03,
-8.294987009687736917e-03,
-8.326485252212974253e-03,
-8.357967439001252885e-03,
-8.389433520292130519e-03,
-8.420883446355935387e-03,
-8.452317167492666428e-03,
-8.483734634032593508e-03,
-8.515135796336293847e-03,
-8.546520604794945186e-03,
-8.577889009830278952e-03,
-8.609240961893993918e-03,
-8.640576411469104087e-03,
-8.671895309068816324e-03,
-8.703197605237286694e-03,
-8.734483250549349848e-03,
-8.765752195611268421e-03,
-8.797004391059629752e-03,
-8.828239787562808250e-03,
-8.859458335819667824e-03,
-8.890659986560918437e-03,
-8.921844690548155071e-03,
-8.953012398574520386e-03,
-8.984163061464402883e-03,
-9.015296630074293854e-03,
-9.046413055291665020e-03,
-9.077512288036279978e-03,
-9.108594279259215817e-03,
-9.139658979943428643e-03,
-9.170706341104260112e-03,
-9.201736313788407007e-03,
-9.232748849075347181e-03,
-9.263743898076040248e-03,
-9.294721411934278935e-03,
-9.325681341825788756e-03,
-9.356623638958764047e-03,
-9.387548254573710102e-03,
-9.418455139944230739e-03,
-9.449344246375784503e-03,
-9.480215525207275409e-03,
-9.511068927809871593e-03,
-9.541904405587709609e-03,
-9.572721909977700144e-03,
-9.603521392450077923e-03,
-9.634302804508200480e-03,
-9.665066097687979169e-03,
-9.695811223559338068e-03,
-9.726538133724925081e-03,
-9.757246779820930721e-03,
-9.787937113516857399e-03,
-9.818609086516230655e-03,
-9.849262650555476797e-03,
-9.879897757405445985e-03,
-9.910514358869988022e-03,
-9.941112406787503200e-03,
-9.971691853029800851e-03,
-1.000225264950280017e-02,
-1.003279474814632206e-02,
-1.006331810093484547e-02,
-1.009382265987629652e-02,
-1.012430837701368096e-02,
-1.015477520442376741e-02,
-1.018522309421775532e-02,
-1.021565199854190982e-02,
-1.024606186957632489e-02,
-1.027645265953645859e-02,
-1.030682432067185975e-02,
-1.033717680526746382e-02,
-1.036751006564267524e-02,
-1.039782405415194157e-02,
-1.042811872318458004e-02,
-1.045839402516557728e-02,
-1.048864991255430562e-02,
-1.051888633784613808e-02,
-1.054910325357127227e-02,
-1.057930061229542945e-02,
-1.060947836661962386e-02,
-1.063963646918093808e-02,
-1.066977487265142154e-02,
-1.069989352973925098e-02,
-1.072999239318845471e-02,
-1.076007141577848061e-02,
-1.079013055032489871e-02,
-1.082016974967909412e-02,
-1.085018896672898525e-02,
-1.088018815439799163e-02,
-1.091016726564635400e-02,
-1.094012625346996864e-02,
-1.097006507090190694e-02,
-1.099998367101048292e-02,
-1.102988200690167321e-02,
-1.105976003171716543e-02,
-1.108961769863601836e-02,
-1.111945496087330884e-02,
-1.114927177168155599e-02,
-1.117906808434964740e-02,
-1.120884385220356598e-02,
-1.123859902860611590e-02,
-1.126833356695756093e-02,
-1.129804742069527752e-02,
-1.132774054329337664e-02,
-1.135741288826391110e-02,
-1.138706440915582957e-02,
-1.141669505955565829e-02,
-1.144630479308730679e-02,
-1.147589356341270454e-02,
-1.150546132423084338e-02,
-1.153500802927904384e-02,
-1.156453363233193865e-02,
-1.159403808720224117e-02,
-1.162352134774041930e-02,
-1.165298336783540840e-02,
-1.168242410141360349e-02,
-1.171184350244022961e-02,
-1.174124152491805642e-02,
-1.177061812288881723e-02,
-1.179997325043212995e-02,
-1.182930686166601929e-02,
-1.185861891074758284e-02,
-1.188790935187175601e-02,
-1.191717813927289579e-02,
-1.194642522722332359e-02,
-1.197565057003498711e-02,
-1.200485412205767356e-02,
-1.203403583768108444e-02,
-1.206319567133324472e-02,
-1.209233357748184731e-02,
-1.212144951063310987e-02,
-1.215054342533306540e-02,
-1.217961527616663077e-02,
-1.220866501775819991e-02,
-1.223769260477142358e-02,
-1.226669799190999340e-02,
-1.229568113391645706e-02,
-1.232464198557352807e-02,
-1.235358050170361037e-02,
-1.238249663716860412e-02,
-1.241139034687038269e-02,
-1.244026158575056717e-02,
-1.246911030879133998e-02,
-1.249793647101418714e-02,
-1.252674002748142661e-02,
-1.255552093329509629e-02,
-1.258427914359763235e-02,
-1.261301461357166274e-02,
-1.264172729844071155e-02,
-1.267041715346813729e-02,
-1.269908413395848430e-02,
-1.272772819525623371e-02,
-1.275634929274723980e-02,
-1.278494738185760246e-02,
-1.281352241805424133e-02,
-1.284207435684548912e-02,
-1.287060315377991718e-02,
-1.289910876444783257e-02,
-1.292759114448011407e-02,
-1.295605024954899105e-02,
-1.298448603536775034e-02,
-1.301289845769144742e-02,
-1.304128747231595234e-02,
-1.306965303507907211e-02,
-1.309799510185952545e-02,
-1.312631362857837568e-02,
-1.315460857119759783e-02,
-1.318287988572129643e-02,
-1.321112752819504979e-02,
-1.323935145470672529e-02,
-1.326755162138555134e-02,
-1.329572798440338023e-02,
-1.332388049997339403e-02,
-1.335200912435158260e-02,
-1.338011381383563680e-02,
-1.340819452476546547e-02,
-1.343625121352379041e-02,
-1.346428383653513854e-02,
-1.349229235026699024e-02,
-1.352027671122900919e-02,
-1.354823687597348988e-02,
-1.357617280109531255e-02,
-1.360408444323245834e-02,
-1.363197175906517497e-02,
-1.365983470531703312e-02,
-1.368767323875406602e-02,
-1.371548731618579993e-02,
-1.374327689446440751e-02,
-1.377104193048528727e-02,
-1.379878238118689877e-02,
-1.382649820355120844e-02,
-1.385418935460363057e-02,
-1.388185579141247399e-02,
-1.390949747108977640e-02,
-1.393711435079088116e-02,
-1.396470638771524046e-02,
-1.399227353910523913e-02,
-1.401981576224761022e-02,
-1.404733301447231436e-02,
-1.407482525315372976e-02,
-1.410229243570967732e-02,
-1.412973451960204858e-02,
-1.415715146233675024e-02,
-1.418454322146414995e-02,
-1.421190975457818813e-02,
-1.423925101931766343e-02,
-1.426656697336509474e-02,
-1.429385757444802743e-02,
-1.432112278033751546e-02,
-1.434836254884989774e-02,
-1.437557683784597765e-02,
-1.440276560523064478e-02,
-1.442992880895423158e-02,
-1.445706640701123133e-02,
-1.448417835744112390e-02,
-1.451126461832821964e-02,
-1.453832514780211554e-02,
-1.456535990403683492e-02,
-1.459236884525212490e-02,
-1.461935192971215193e-02,
-1.464630911572712725e-02,
-1.467324036165176121e-02,
-1.470014562588645851e-02,
-1.472702486687677177e-02,
-1.475387804311422725e-02,
-1.478070511313522850e-02,
-1.480750603552234007e-02,
-1.483428076890330911e-02,
-1.486102927195170550e-02,
-1.488775150338718725e-02,
-1.491444742197472334e-02,
-1.494111698652574906e-02,
-1.496776015589704537e-02,
-1.499437688899209371e-02,
-1.502096714475991725e-02,
-1.504753088219588572e-02,
-1.507406806034143273e-02,
-1.510057863828469758e-02,
-1.512706257515960238e-02,
-1.515351983014697444e-02,
-1.517995036247374481e-02,
-1.520635413141348258e-02,
-1.523273109628619712e-02,
-1.525908121645884290e-02,
-1.528540445134505925e-02,
-1.531170076040484600e-02,
-1.533797010314564592e-02,
-1.536421243912127962e-02,
-1.539042772793272965e-02,
-1.541661592922786289e-02,
-1.544277700270201698e-02,
-1.546891090809714327e-02,
-1.549501760520288936e-02,
-1.552109705385566925e-02,
-1.554714921393984296e-02,
-1.557317404538656816e-02,
-1.559917150817474209e-02,
-1.562514156233049678e-02,
-1.565108416792806295e-02,
-1.567699928508874130e-02,
-1.570288687398199365e-02,
-1.572874689482473692e-02,
-1.575457930788152355e-02,
-1.578038407346541577e-02,
-1.580616115193663948e-02,
-1.583191050370415937e-02,
-1.585763208922429807e-02,
-1.588332586900212048e-02,
-1.590899180359036519e-02,
-1.593462985359026321e-02,
-1.596023997965113558e-02,
-1.598582214247103866e-02,
-1.601137630279592799e-02,
-1.603690242142079975e-02,
-1.606240045918876785e-02,
-1.608787037699161565e-02,
-1.611331213576968832e-02,
-1.613872569651245495e-02,
-1.616411102025759952e-02,
-1.618946806809201319e-02,
-1.621479680115152713e-02,
-1.624009718062062804e-02,
-1.626536916773290570e-02,
-1.629061272377089684e-02,
-1.631582781006676169e-02,
-1.634101438800110787e-02,
-1.636617241900449604e-02,
-1.639130186455616325e-02,
-1.641640268618531698e-02,
-1.644147484547000063e-02,
-1.646651830403812050e-02,
-1.649153302356673803e-02,
-1.651651896578305856e-02,
-1.654147609246338010e-02,
-1.656640436543415501e-02,
-1.659130374657125789e-02,
-1.661617419780057545e-02,
-1.664101568109761439e-02,
-1.666582815848816068e-02,
-1.669061159204801234e-02,
-1.671536594390260130e-02,
-1.674009117622793016e-02,
-1.676478725124985747e-02,
-1.678945413124453487e-02,
-1.681409177853829262e-02,
-1.683870015550820165e-02,
-1.686327922458118883e-02,
-1.688782894823512987e-02,
-1.691234928899807213e-02,
-1.693684020944869612e-02,
-1.696130167221620438e-02,
-1.698573363998082120e-02,
-1.701013607547305698e-02,
-1.703450894147471445e-02,
-1.705885220081781659e-02,
-1.708316581638597703e-02,
-1.710744975111323091e-02,
-1.713170396798470788e-02,
-1.715592843003695134e-02,
-1.718012310035715168e-02,
-1.720428794208413853e-02,
-1.722842291840750995e-02,
-1.725252799256874608e-02,
-1.727660312785989777e-02,
-1.730064828762519283e-02,
-1.732466343525968996e-02,
-1.734864853421045836e-02,
-1.737260354797570336e-02,
-1.739652844010571020e-02,
-1.742042317420203212e-02,
-1.744428771391812877e-02,
-1.746812202295909902e-02,
-1.749192606508228470e-02,
-1.751569980409636504e-02,
-1.753944320386237668e-02,
-1.756315622829334594e-02,
-1.758683884135416042e-02,
-1.761049100706186393e-02,
-1.763411268948561830e-02,
-1.765770385274711279e-02,
-1.768126446101982163e-02,
-1.770479447853010382e-02,
-1.772829386955630457e-02,
-1.775176259842923751e-02,
-1.777520062953221597e-02,
-1.779860792730136518e-02,
-1.782198445622494576e-02,
-1.784533018084441189e-02,
-1.786864506575333231e-02,
-1.789192907559858381e-02,
-1.791518217507947347e-02,
-1.793840432894816192e-02,
-1.796159550201009356e-02,
-1.798475565912314653e-02,
-1.800788476519881581e-02,
-1.803098278520103709e-02,
-1.805404968414760919e-02,
-1.807708542710859123e-02,
-1.810008997920806509e-02,
-1.812306330562290027e-02,
-1.814600537158376353e-02,
-1.816891614237413702e-02,
-1.819179558333147359e-02,
-1.821464365984639885e-02,
-1.823746033736312055e-02,
-1.826024558137934531e-02,
-1.828299935744681290e-02,
-1.830572163117043585e-02,
-1.832841236820941661e-02,
-1.835107153427618237e-02,
-1.837369909513753008e-02,
-1.839629501661384572e-02,
-1.841885926457936806e-02,
-1.844139180496276800e-02,
-1.846389260374630206e-02,
-1.848636162696679422e-02,
-1.850879884071473039e-02,
-1.853120421113514313e-02,
-1.855357770442710511e-02,
-1.857591928684425991e-02,
-1.859822892469426350e-02,
-1.862050658433958908e-02,
-1.864275223219670832e-02,
-1.866496583473706283e-02,
-1.868714735848629738e-02,
-1.870929677002472133e-02,
-1.873141403598733642e-02,
-1.875349912306394778e-02,
-1.877555199799913616e-02,
-1.879757262759203934e-02,
-1.881956097869687955e-02,
-1.884151701822250891e-02,
-1.886344071313314497e-02,
-1.888533203044762132e-02,
-1.890719093724017169e-02,
-1.892901740063963195e-02,
-1.895081138783061975e-02,
-1.897257286605242427e-02,
-1.899430180259983544e-02,
-1.901599816482268251e-02,
-1.903766192012660771e-02,
-1.905929303597211216e-02,
-1.908089147987560366e-02,
-1.910245721940851543e-02,
-1.912399022219832614e-02,
-1.914549045592765439e-02,
-1.916695788833483807e-02,
-1.918839248721416341e-02,
-1.920979422041527857e-02,
-1.923116305584391186e-02,
-1.925249896146144155e-02,
-1.927380190528511089e-02,
-1.929507185538800393e-02,
-1.931630877989954156e-02,
-1.933751264700458647e-02,
-1.935868342494463309e-02,
-1.937982108201678766e-02,
-1.940092558657469449e-02,
-1.942199690702803641e-02,
-1.944303501184258334e-02,
-1.946403986954049412e-02,
-1.948501144870053853e-02,
-1.950594971795738264e-02,
-1.952685464600264001e-02,
-1.954772620158400781e-02,
-1.956856435350569356e-02,
-1.958936907062889046e-02,
-1.961014032187086836e-02,
-1.963087807620603198e-02,
-1.965158230266510556e-02,
-1.967225297033584411e-02,
-1.969289004836269341e-02,
-1.971349350594683858e-02,
-1.973406331234640182e-02,
-1.975459943687664713e-02,
-1.977510184890943212e-02,
-1.979557051787411356e-02,
-1.981600541325657244e-02,
-1.983640650460044910e-02,
-1.985677376150569648e-02,
-1.987710715363020034e-02,
-1.989740665068896047e-02,
-1.991767222245386867e-02,
-1.993790383875468017e-02,
-1.995810146947813585e-02,
-1.997826508456850350e-02,
-1.999839465402753272e-02,
-2.001849014791462142e-02,
-2.003855153634640993e-02,
-2.005857878949754772e-02,
-2.007857187759989892e-02,
-2.009853077094343396e-02,
-2.011845543987555648e-02,
-2.013834585480138786e-02,
-2.015820198618406209e-02,
-2.017802380454462516e-02,
-2.019781128046175059e-02,
-2.021756438457237084e-02,
-2.023728308757118816e-02,
-2.025696736021084104e-02,
-2.027661717330245250e-02,
-2.029623249771480079e-02,
-2.031581330437521801e-02,
-2.033535956426882341e-02,
-2.035487124843943924e-02,
-2.037434832798885875e-02,
-2.039379077407720356e-02,
-2.041319855792297910e-02,
-2.043257165080342164e-02,
-2.045191002405367248e-02,
-2.047121364906792293e-02,
-2.049048249729851917e-02,
-2.050971654025651389e-02,
-2.052891574951143383e-02,
-2.054808009669176899e-02,
-2.056720955348445568e-02,
-2.058630409163533098e-02,
-2.060536368294904955e-02,
-2.062438829928882680e-02,
-2.064337791257693511e-02,
-2.066233249479442272e-02,
-2.068125201798167931e-02,
-2.070013645423747495e-02,
-2.071898577572017092e-02,
-2.073779995464675521e-02,
-2.075657896329373073e-02,
-2.077532277399643176e-02,
-2.079403135914948894e-02,
-2.081270469120667307e-02,
-2.083134274268126640e-02,
-2.084994548614558033e-02,
-2.086851289423159381e-02,
-2.088704493963037048e-02,
-2.090554159509245072e-02,
-2.092400283342796610e-02,
-2.094242862750647985e-02,
-2.096081895025720537e-02,
-2.097917377466871486e-02,
-2.099749307378950477e-02,
-2.101577682072744771e-02,
-2.103402498865033707e-02,
-2.105223755078540829e-02,
-2.107041448042011947e-02,
-2.108855575090131176e-02,
-2.110666133563606287e-02,
-2.112473120809106250e-02,
-2.114276534179302183e-02,
-2.116076371032847223e-02,
-2.117872628734443485e-02,
-2.119665304654731741e-02,
-2.121454396170416312e-02,
-2.123239900664180071e-02,
-2.125021815524742730e-02,
-2.126800138146834468e-02,
-2.128574865931187263e-02,
-2.130345996284607052e-02,
-2.132113526619887345e-02,
-2.133877454355890407e-02,
-2.135637776917480996e-02,
-2.137394491735600949e-02,
-2.139147596247218883e-02,
-2.140897087895352741e-02,
-2.142642964129060773e-02,
-2.144385222403499824e-02,
-2.146123860179837209e-02,
-2.147858874925349590e-02,
-2.149590264113339713e-02,
-2.151318025223212735e-02,
-2.153042155740418975e-02,
-2.154762653156525737e-02,
-2.156479514969135078e-02,
-2.158192738681981304e-02,
-2.159902321804862621e-02,
-2.161608261853672705e-02,
-2.163310556350393765e-02,
-2.165009202823113890e-02,
-2.166704198806040926e-02,
-2.168395541839457027e-02,
-2.170083229469785616e-02,
-2.171767259249547666e-02,
-2.173447628737375584e-02,
-2.175124335498024655e-02,
-2.176797377102399761e-02,
-2.178466751127487722e-02,
-2.180132455156456872e-02,
-2.181794486778558875e-02,
-2.183452843589235581e-02,
-2.185107523190020842e-02,
-2.186758523188617534e-02,
-2.188405841198885066e-02,
-2.190049474840807114e-02,
-2.191689421740551993e-02,
-2.193325679530416794e-02,
-2.194958245848900591e-02,
-2.196587118340605563e-02,
-2.198212294656363627e-02,
-2.199833772453133399e-02,
-2.201451549394086230e-02,
-2.203065623148532312e-02,
-2.204675991391996659e-02,
-2.206282651806168102e-02,
-2.207885602078927742e-02,
-2.209484839904341663e-02,
-2.211080362982692504e-02,
-2.212672169020431234e-02,
-2.214260255730239602e-02,
-2.215844620830968725e-02,
-2.217425262047713688e-02,
-2.219002177111744842e-02,
-2.220575363760567827e-02,
-2.222144819737905189e-02,
-2.223710542793676942e-02,
-2.225272530684062680e-02,
-2.226830781171434265e-02,
-2.228385292024413072e-02,
-2.229936061017830790e-02,
-2.231483085932794291e-02,
-2.233026364556594048e-02,
-2.234565894682822434e-02,
-2.236101674111263399e-02,
-2.237633700647982671e-02,
-2.239161972105280229e-02,
-2.240686486301720487e-02,
-2.242207241062105921e-02,
-2.243724234217515587e-02,
-2.245237463605302686e-02,
-2.246746927069052588e-02,
-2.248252622458667832e-02,
-2.249754547630250165e-02,
-2.251252700446250074e-02,
-2.252747078775347786e-02,
-2.254237680492542431e-02,
-2.255724503479071899e-02,
-2.257207545622496800e-02,
-2.258686804816662300e-02,
-2.260162278961684590e-02,
-2.261633965963993562e-02,
-2.263101863736318234e-02,
-2.264565970197672529e-02,
-2.266026283273402456e-02,
-2.267482800895124703e-02,
-2.268935521000807129e-02,
-2.270384441534689310e-02,
-2.271829560447346033e-02,
-2.273270875695680704e-02,
-2.274708385242889958e-02,
-2.276142087058527497e-02,
-2.277571979118447540e-02,
-2.278998059404838475e-02,
-2.280420325906225287e-02,
-2.281838776617474765e-02,
-2.283253409539771558e-02,
-2.284664222680666407e-02,
-2.286071214054030687e-02,
-2.287474381680094579e-02,
-2.288873723585437697e-02,
-2.290269237802972091e-02,
-2.291660922371978326e-02,
-2.293048775338108261e-02,
-2.294432794753333352e-02,
-2.295812978676034857e-02,
-2.297189325170922308e-02,
-2.298561832309075834e-02,
-2.299930498167966283e-02,
-2.301295320831416372e-02,
-2.302656298389643696e-02,
-2.304013428939214597e-02,
-2.305366710583104176e-02,
-2.306716141430656050e-02,
-2.308061719597596234e-02,
-2.309403443206043544e-02,
-2.310741310384517230e-02,
-2.312075319267893614e-02,
-2.313405467997502532e-02,
-2.314731754721017012e-02,
-2.316054177592551805e-02,
-2.317372734772570053e-02,
-2.318687424427999869e-02,
-2.319998244732154880e-02,
-2.321305193864741864e-02,
-2.322608270011913140e-02,
-2.323907471366201682e-02,
-2.325202796126579069e-02,
-2.326494242498427720e-02,
-2.327781808693559287e-02,
-2.329065492930199738e-02,
-2.330345293433027862e-02,
-2.331621208433110742e-02,
-2.332893236167985634e-02,
-2.334161374881601678e-02,
-2.335425622824350081e-02,
-2.336685978253055795e-02,
-2.337942439431003189e-02,
-2.339195004627890595e-02,
-2.340443672119902480e-02,
-2.341688440189625478e-02,
-2.342929307126120908e-02,
-2.344166271224913320e-02,
-2.345399330787953027e-02,
-2.346628484123675779e-02,
-2.347853729546952456e-02,
-2.349075065379138683e-02,
-2.350292489948032498e-02,
-2.351506001587910094e-02,
-2.352715598639505343e-02,
-2.353921279450036860e-02,
-2.355123042373188577e-02,
-2.356320885769117718e-02,
-2.357514808004453413e-02,
-2.358704807452324456e-02,
-2.359890882492299280e-02,
-2.361073031510478593e-02,
-2.362251252899404477e-02,
-2.363425545058144353e-02,
-2.364595906392229219e-02,
-2.365762335313697715e-02,
-2.366924830241062816e-02,
-2.368083389599335079e-02,
-2.369238011820052475e-02,
-2.370388695341216906e-02,
-2.371535438607356647e-02,
-2.372678240069472574e-02,
-2.373817098185116228e-02,
-2.374952011418308973e-02,
-2.376082978239590221e-02,
-2.377209997126016397e-02,
-2.378333066561165443e-02,
-2.379452185035111147e-02,
-2.380567351044463736e-02,
-2.381678563092340037e-02,
-2.382785819688371109e-02,
-2.383889119348735208e-02,
-2.384988460596106433e-02,
-2.386083841959715443e-02,
-2.387175261975300541e-02,
-2.388262719185139590e-02,
-2.389346212138036829e-02,
-2.390425739389336751e-02,
-2.391501299500905370e-02,
-2.392572891041174973e-02,
-2.393640512585088614e-02,
-2.394704162714148682e-02,
-2.395763840016391921e-02,
-2.396819543086404353e-02,
-2.397871270525309129e-02,
-2.398919020940800534e-02,
-2.399962792947088128e-02,
-2.401002585164975847e-02,
-2.402038396221786373e-02,
-2.403070224751417336e-02,
-2.404098069394304885e-02,
-2.405121928797461853e-02,
-2.406141801614453471e-02,
-2.407157686505413327e-02,
-2.408169582137024284e-02,
-2.409177487182554908e-02,
-2.410181400321823042e-02,
-2.411181320241229456e-02,
-2.412177245633730094e-02,
-2.413169175198860358e-02,
-2.414157107642733724e-02,
-2.415141041678024389e-02,
-2.416120976024003358e-02,
-2.417096909406508606e-02,
-2.418068840557954444e-02,
-2.419036768217331865e-02,
-2.420000691130241507e-02,
-2.420960608048829121e-02,
-2.421916517731855997e-02,
-2.422868418944666355e-02,
-2.423816310459183873e-02,
-2.424760191053921057e-02,
-2.425700059513985832e-02,
-2.426635914631092988e-02,
-2.427567755203531921e-02,
-2.428495580036194382e-02,
-2.429419387940569622e-02,
-2.430339177734749598e-02,
-2.431254948243421338e-02,
-2.432166698297874227e-02,
-2.433074426736000703e-02,
-2.433978132402307010e-02,
-2.434877814147887176e-02,
-2.435773470830458406e-02,
-2.436665101314332629e-02,
-2.437552704470438703e-02,
-2.438436279176317209e-02,
-2.439315824316113865e-02,
-2.440191338780611785e-02,
-2.441062821467161054e-02,
-2.441930271279784542e-02,
-2.442793687129075214e-02,
-2.443653067932282513e-02,
-2.444508412613235690e-02,
-2.445359720102418394e-02,
-2.446206989336918367e-02,
-2.447050219260469769e-02,
-2.447889408823401489e-02,
-2.448724556982678074e-02,
-2.449555662701900435e-02,
-2.450382724951285368e-02,
-2.451205742707692273e-02,
-2.452024714954599907e-02,
-2.452839640682113326e-02,
-2.453650518887000309e-02,
-2.454457348572625444e-02,
-2.455260128748996962e-02,
-2.456058858432775757e-02,
-2.456853536647248676e-02,
-2.457644162422347595e-02,
-2.458430734794627912e-02,
-2.459213252807293873e-02,
-2.459991715510190941e-02,
-2.460766121959813424e-02,
-2.461536471219287134e-02,
-2.462302762358387423e-02,
-2.463064994453535717e-02,
-2.463823166587802982e-02,
-2.464577277850896198e-02,
-2.465327327339179864e-02,
-2.466073314155662818e-02,
-2.466815237409998932e-02,
-2.467553096218509656e-02,
-2.468286889704155926e-02,
-2.469016616996555849e-02,
-2.469742277231963892e-02,
-2.470463869553319800e-02,
-2.471181393110190999e-02,
-2.471894847058817360e-02,
-2.472604230562086905e-02,
-2.473309542789553159e-02,
-2.474010782917424045e-02,
-2.474707950128563275e-02,
-2.475401043612489305e-02,
-2.476090062565411073e-02,
-2.476775006190160000e-02,
-2.477455873696258332e-02,
-2.478132664299876817e-02,
-2.478805377223860726e-02,
-2.479474011697718402e-02,
-2.480138566957595936e-02,
-2.480799042246361469e-02,
-2.481455436813496951e-02,
-2.482107749915184874e-02,
-2.482755980814256233e-02,
-2.483400128780224175e-02,
-2.484040193089255208e-02,
-2.484676173024216034e-02,
-2.485308067874615612e-02,
-2.485935876936637076e-02,
-2.486559599513149185e-02,
-2.487179234913695566e-02,
-2.487794782454476328e-02,
-2.488406241458364365e-02,
-2.489013611254935893e-02,
-2.489616891180410074e-02,
-2.490216080577694474e-02,
-2.490811178796376382e-02,
-2.491402185192728366e-02,
-2.491989099129656923e-02,
-2.492571919976804828e-02,
-2.493150647110459542e-02,
-2.493725279913586168e-02,
-2.494295817775837171e-02,
-2.494862260093550291e-02,
-2.495424606269735016e-02,
-2.495982855714079518e-02,
-2.496537007842948575e-02,
-2.497087062079416178e-02,
-2.497633017853198925e-02,
-2.498174874600723322e-02,
-2.498712631765086581e-02,
-2.499246288796082294e-02,
-2.499775845150165043e-02,
-2.500301300290481629e-02,
-2.500822653686879046e-02,
-2.501339904815877424e-02,
-2.501853053160665169e-02,
-2.502362098211140598e-02,
-2.502867039463878632e-02,
-2.503367876422134264e-02,
-2.503864608595857827e-02,
-2.504357235501671053e-02,
-2.504845756662904196e-02,
-2.505330171609551973e-02,
-2.505810479878305130e-02,
-2.506286681012551143e-02,
-2.506758774562350620e-02,
-2.507226760084453956e-02,
-2.507690637142306195e-02,
-2.508150405306037306e-02,
-2.508606064152456641e-02,
-2.509057613265076175e-02,
-2.509505052234090039e-02,
-2.509948380656374170e-02,
-2.510387598135510601e-02,
-2.510822704281744089e-02,
-2.511253698712029997e-02,
-2.511680581050016597e-02,
-2.512103350926013848e-02,
-2.512522007977046473e-02,
-2.512936551846814762e-02,
-2.513346982185715034e-02,
-2.513753298650824725e-02,
-2.514155500905932220e-02,
-2.514553588621478569e-02,
-2.514947561474641796e-02,
-2.515337419149244608e-02,
-2.515723161335813723e-02,
-2.516104787731573977e-02,
-2.516482298040443114e-02,
-2.516855691973011316e-02,
-2.517224969246563415e-02,
-2.517590129585091374e-02,
-2.517951172719231148e-02,
-2.518308098386368502e-02,
-2.518660906330526250e-02,
-2.519009596302448223e-02,
-2.519354168059549301e-02,
-2.519694621365945256e-02,
-2.520030955992421176e-02,
-2.520363171716480041e-02,
-2.520691268322285475e-02,
-2.521015245600699561e-02,
-2.521335103349276949e-02,
-2.521650841372255133e-02,
-2.521962459480548216e-02,
-2.522269957491778819e-02,
-2.522573335230244782e-02,
-2.522872592526924362e-02,
-2.523167729219492547e-02,
-2.523458745152315150e-02,
-2.523745640176422098e-02,
-2.524028414149552535e-02,
-2.524307066936116312e-02,
-2.524581598407214800e-02,
-2.524852008440633608e-02,
-2.525118296920832520e-02,
-2.525380463738975331e-02,
-2.525638508792896197e-02,
-2.525892431987109346e-02,
-2.526142233232817058e-02,
-2.526387912447905504e-02,
-2.526629469556946478e-02,
-2.526866904491187685e-02,
-2.527100217188552392e-02,
-2.527329407593656083e-02,
-2.527554475657791538e-02,
-2.527775421338930573e-02,
-2.527992244601727848e-02,
-2.528204945417501792e-02,
-2.528413523764275195e-02,
-2.528617979626726284e-02,
-2.528818312996224810e-02,
-2.529014523870814699e-02,
-2.529206612255213010e-02,
-2.529394578160810286e-02,
-2.529578421605684774e-02,
-2.529758142614571548e-02,
-2.529933741218904145e-02,
-2.530105217456770847e-02,
-2.530272571372935153e-02,
-2.530435803018837512e-02,
-2.530594912452600528e-02,
-2.530749899738997735e-02,
-2.530900764949484474e-02,
-2.531047508162190957e-02,
-2.531190129461913588e-02,
-2.531328628940106296e-02,
-2.531463006694912796e-02,
-2.531593262831118366e-02,
-2.531719397460205009e-02,
-2.531841410700298028e-02,
-2.531959302676196552e-02,
-2.532073073519357925e-02,
-2.532182723367918872e-02,
-2.532288252366662190e-02,
-2.532389660667043116e-02,
-2.532486948427181001e-02,
-2.532580115811850982e-02,
-2.532669162992480863e-02,
-2.532754090147172968e-02,
-2.532834897460681245e-02,
-2.532911585124416470e-02,
-2.532984153336442779e-02,
-2.533052602301490153e-02,
-2.533116932230946444e-02,
-2.533177143342833088e-02,
-2.533233235861843957e-02,
-2.533285210019324551e-02,
-2.533333066053262625e-02,
-2.533376804208304148e-02,
-2.533416424735742203e-02,
-2.533451927893515601e-02,
-2.533483313946223794e-02,
-2.533510583165097044e-02,
-2.533533735828019662e-02,
-2.533552772219530361e-02,
-2.533567692630794149e-02,
-2.533578497359634599e-02,
-2.533585186710504353e-02,
-2.533587760994507332e-02,
-2.533586220529390753e-02,
-2.533580565639521540e-02,
-2.533570796655925522e-02,
-2.533556913916261075e-02,
-2.533538917764816337e-02,
-2.533516808552514071e-02,
-2.533490586636926931e-02,
-2.533460252382232006e-02,
-2.533425806159265992e-02,
-2.533387248345478002e-02,
-2.533344579324965651e-02,
-2.533297799488424748e-02,
-2.533246909233200644e-02,
-2.533191908963263600e-02,
-2.533132799089212253e-02,
-2.533069580028246559e-02,
-2.533002252204218097e-02,
-2.532930816047567965e-02,
-2.532855271995392357e-02,
-2.532775620491382537e-02,
-2.532691861985852944e-02,
-2.532603996935734944e-02,
-2.532512025804579611e-02,
-2.532415949062540028e-02,
-2.532315767186401126e-02,
-2.532211480659534927e-02,
-2.532103089971942181e-02,
-2.531990595620225992e-02,
-2.531873998107598764e-02,
-2.531753297943871786e-02,
-2.531628495645470156e-02,
-2.531499591735414043e-02,
-2.531366586743332564e-02,
-2.531229481205460319e-02,
-2.531088275664614487e-02,
-2.530942970670223280e-02,
-2.530793566778309633e-02,
-2.530640064551480453e-02,
-2.530482464558955757e-02,
-2.530320767376526350e-02,
-2.530154973586598230e-02,
-2.529985083778140548e-02,
-2.529811098546725853e-02,
-2.529633018494518992e-02,
-2.529450844230252127e-02,
-2.529264576369247980e-02,
-2.529074215533411510e-02,
-2.528879762351237889e-02,
-2.528681217457784403e-02,
-2.528478581494698202e-02,
-2.528271855110186817e-02,
-2.528061038959058399e-02,
-2.527846133702662743e-02,
-2.527627140008942980e-02,
-2.527404058552404353e-02,
-2.527176890014116648e-02,
-2.526945635081724942e-02,
-2.526710294449422550e-02,
-2.526470868817987797e-02,
-2.526227358894737526e-02,
-2.525979765393564225e-02,
-2.525728089034915205e-02,
-2.525472330545793648e-02,
-2.525212490659751313e-02,
-2.524948570116893401e-02,
-2.524680569663890692e-02,
-2.524408490053946935e-02,
-2.524132332046824523e-02,
-2.523852096408820203e-02,
-2.523567783912790755e-02,
-2.523279395338116210e-02,
-2.522986931470736979e-02,
-2.522690393103117767e-02,
-2.522389781034268738e-02,
-2.522085096069730595e-02,
-2.521776339021589153e-02,
-2.521463510708434053e-02,
-2.521146611955426761e-02,
-2.520825643594209325e-02,
-2.520500606462994231e-02,
-2.520171501406485298e-02,
-2.519838329275922439e-02,
-2.519501090929080270e-02,
-2.519159787230217454e-02,
-2.518814419050142625e-02,
-2.518464987266159569e-02,
-2.518111492762097406e-02,
-2.517753936428281103e-02,
-2.517392319161565820e-02,
-2.517026641865291806e-02,
-2.516656905449317361e-02,
-2.516283110830003916e-02,
-2.515905258930211177e-02,
-2.515523350679301287e-02,
-2.515137387013118356e-02,
-2.514747368874026279e-02,
-2.514353297210865368e-02,
-2.513955172978971087e-02,
-2.513552997140172662e-02,
-2.513146770662777127e-02,
-2.512736494521577990e-02,
-2.512322169697858015e-02,
-2.511903797179389913e-02,
-2.511481377960387770e-02,
-2.511054913041592396e-02,
-2.510624403430175913e-02,
-2.510189850139808720e-02,
-2.509751254190620284e-02,
-2.509308616609212325e-02,
-2.508861938428652225e-02,
-2.508411220688468168e-02,
-2.507956464434650534e-02,
-2.507497670719651545e-02,
-2.507034840602385267e-02,
-2.506567975148195002e-02,
-2.506097075428915383e-02,
-2.505622142522803686e-02,
-2.505143177514583194e-02,
-2.504660181495392199e-02,
-2.504173155562857897e-02,
-2.503682100821014514e-02,
-2.503187018380335568e-02,
-2.502687909357759546e-02,
-2.502184774876634737e-02,
-2.501677616066747684e-02,
-2.501166434064311384e-02,
-2.500651230011977436e-02,
-2.500132005058809323e-02,
-2.499608760360302537e-02,
-2.499081497078370004e-02,
-2.498550216381341740e-02,
-2.498014919443962076e-02,
-2.497475607447398327e-02,
-2.496932281579207144e-02,
-2.496384943033389328e-02,
-2.495833593010306564e-02,
-2.495278232716763647e-02,
-2.494718863365942910e-02,
-2.494155486177440997e-02,
-2.493588102377222032e-02,
-2.493016713197694287e-02,
-2.492441319877604713e-02,
-2.491861923662117700e-02,
-2.491278525802782112e-02,
-2.490691127557518453e-02,
-2.490099730190644192e-02,
-2.489504334972842195e-02,
-2.488904943181179802e-02,
-2.488301556099087666e-02,
-2.487694175016375020e-02,
-2.487082801229223775e-02,
-2.486467436040186094e-02,
-2.485848080758146575e-02,
-2.485224736698388170e-02,
-2.484597405182523144e-02,
-2.483966087538540257e-02,
-2.483330785100767643e-02,
-2.482691499209891198e-02,
-2.482048231212933068e-02,
-2.481400982463275243e-02,
-2.480749754320634923e-02,
-2.480094548151051334e-02,
-2.479435365326938465e-02,
-2.478772207227010124e-02,
-2.478105075236326435e-02,
-2.477433970746274056e-02,
-2.476758895154565834e-02,
-2.476079849865226584e-02,
-2.475396836288625002e-02,
-2.474709855841420586e-02,
-2.474018909946610473e-02,
-2.473324000033482947e-02,
-2.472625127537659076e-02,
-2.471922293901043788e-02,
-2.471215500571853976e-02,
-2.470504749004603234e-02,
-2.469790040660116773e-02,
-2.469071377005496726e-02,
-2.468348759514153029e-02,
-2.467622189665774624e-02,
-2.466891668946337088e-02,
-2.466157198848105761e-02,
-2.465418780869622559e-02,
-2.464676416515693136e-02,
-2.463930107297431643e-02,
-2.463179854732193766e-02,
-2.462425660343612113e-02,
-2.461667525661589279e-02,
-2.460905452222296105e-02,
-2.460139441568142543e-02,
-2.459369495247815118e-02,
-2.458595614816249872e-02,
-2.457817801834629931e-02,
-2.457036057870392101e-02,
-2.456250384497203273e-02,
-2.455460783294997548e-02,
-2.454667255849917254e-02,
-2.453869803754370194e-02,
-2.453068428606976215e-02,
-2.452263132012599475e-02,
-2.451453915582316873e-02,
-2.450640780933431920e-02,
-2.449823729689480298e-02,
-2.449002763480204875e-02,
-2.448177883941559524e-02,
-2.447349092715716060e-02,
-2.446516391451056260e-02,
-2.445679781802156949e-02,
-2.444839265429804911e-02,
-2.443994844000980243e-02,
-2.443146519188862942e-02,
-2.442294292672822498e-02,
-2.441438166138421365e-02,
-2.440578141277396224e-02,
-2.439714219787678454e-02,
-2.438846403373379212e-02,
-2.437974693744768967e-02,
-2.437099092618303167e-02,
-2.436219601716616695e-02,
-2.435336222768498191e-02,
-2.434448957508890746e-02,
-2.433557807678927293e-02,
-2.432662775025848725e-02,
-2.431763861303100002e-02,
-2.430861068270247574e-02,
-2.429954397693014079e-02,
-2.429043851343253360e-02,
-2.428129430998979960e-02,
-2.427211138444309094e-02,
-2.426288975469541656e-02,
-2.425362943871050420e-02,
-2.424433045451380997e-02,
-2.423499282019189044e-02,
-2.422561655389221871e-02,
-2.421620167382381936e-02,
-2.420674819825663696e-02,
-2.419725614552170959e-02,
-2.418772553401122780e-02,
-2.417815638217838195e-02,
-2.416854870853725121e-02,
-2.415890253166296658e-02,
-2.414921787019156524e-02,
-2.413949474281996618e-02,
-2.412973316830585579e-02,
-2.411993316546789251e-02,
-2.411009475318535294e-02,
-2.410021795039848577e-02,
-2.409030277610791151e-02,
-2.408034924937526092e-02,
-2.407035738932266494e-02,
-2.406032721513257436e-02,
-2.405025874604865832e-02,
-2.404015200137445130e-02,
-2.403000700047448757e-02,
-2.401982376277337489e-02,
-2.400960230775645368e-02,
-2.399934265496916908e-02,
-2.398904482401751151e-02,
-2.397870883456772878e-02,
-2.396833470634641972e-02,
-2.395792245914032254e-02,
-2.394747211279638424e-02,
-2.393698368722171899e-02,
-2.392645720238371215e-02,
-2.391589267830957280e-02,
-2.390529013508686448e-02,
-2.389464959286305076e-02,
-2.388397107184540152e-02,
-2.387325459230141972e-02,
-2.386250017455835218e-02,
-2.385170783900331104e-02,
-2.384087760608332926e-02,
-2.383000949630523918e-02,
-2.381910353023540539e-02,
-2.380815972850032491e-02,
-2.379717811178573908e-02,
-2.378615870083735512e-02,
-2.377510151646023903e-02,
-2.376400657951919723e-02,
-2.375287391093852327e-02,
-2.374170353170206374e-02,
-2.373049546285291647e-02,
-2.371924972549383295e-02,
-2.370796634078667711e-02,
-2.369664532995295961e-02,
-2.368528671427322721e-02,
-2.367389051508734382e-02,
-2.366245675379455987e-02,
-2.365098545185308210e-02,
-2.363947663078044825e-02,
-2.362793031215300668e-02,
-2.361634651760648185e-02,
-2.360472526883544350e-02,
-2.359306658759368486e-02,
-2.358137049569349053e-02,
-2.356963701500647615e-02,
-2.355786616746285284e-02,
-2.354605797505190945e-02,
-2.353421245982133952e-02,
-2.352232964387796638e-02,
-2.351040954938704228e-02,
-2.349845219857275500e-02,
-2.348645761371761717e-02,
-2.347442581716282367e-02,
-2.346235683130815444e-02,
-2.345025067861192941e-02,
-2.343810738159093562e-02,
-2.342592696282007683e-02,
-2.341370944493311249e-02,
-2.340145485062170363e-02,
-2.338916320263616580e-02,
-2.337683452378468488e-02,
-2.336446883693401103e-02,
-2.335206616500888968e-02,
-2.333962653099229054e-02,
-2.332714995792502244e-02,
-2.331463646890629890e-02,
-2.330208608709304074e-02,
-2.328949883570029245e-02,
-2.327687473800095497e-02,
-2.326421381732594190e-02,
-2.325151609706371802e-02,
-2.323878160066071910e-02,
-2.322601035162124433e-02,
-2.321320237350701227e-02,
-2.320035768993760142e-02,
-2.318747632459018659e-02,
-2.317455830119966032e-02,
-2.316160364355808812e-02,
-2.314861237551541287e-02,
-2.313558452097868451e-02,
-2.312252010391267765e-02,
-2.310941914833922889e-02,
-2.309628167833787868e-02,
-2.308310771804507680e-02,
-2.306989729165474443e-02,
-2.305665042341771900e-02,
-2.304336713764239611e-02,
-2.303004745869390718e-02,
-2.301669141099451157e-02,
-2.300329901902381166e-02,
-2.298987030731784731e-02,
-2.297640530047006038e-02,
-2.296290402313046555e-02,
-2.294936650000610479e-02,
-2.293579275586059632e-02,
-2.292218281551462733e-02,
-2.290853670384529125e-02,
-2.289485444578660128e-02,
-2.288113606632884503e-02,
-2.286738159051930619e-02,
-2.285359104346143880e-02,
-2.283976445031534255e-02,
-2.282590183629755465e-02,
-2.281200322668102201e-02,
-2.279806864679487927e-02,
-2.278409812202483384e-02,
-2.277009167781258656e-02,
-2.275604933965604676e-02,
-2.274197113310956475e-02,
-2.272785708378337668e-02,
-2.271370721734394804e-02,
-2.269952155951347750e-02,
-2.268530013607057347e-02,
-2.267104297284940756e-02,
-2.265675009574022111e-02,
-2.264242153068897132e-02,
-2.262805730369775448e-02,
-2.261365744082389703e-02,
-2.259922196818095821e-02,
-2.258475091193760595e-02,
-2.257024429831870280e-02,
-2.255570215360408470e-02,
-2.254112450412960877e-02,
-2.252651137628640735e-02,
-2.251186279652082553e-02,
-2.249717879133505960e-02,
-2.248245938728617513e-02,
-2.246770461098673496e-02,
-2.245291448910447310e-02,
-2.243808904836238488e-02,
-2.242322831553856047e-02,
-2.240833231746627852e-02,
-2.239340108103362106e-02,
-2.237843463318392803e-02,
-2.236343300091528027e-02,
-2.234839621128078407e-02,
-2.233332429138841502e-02,
-2.231821726840094514e-02,
-2.230307516953571045e-02,
-2.228789802206514528e-02,
-2.227268585331597731e-02,
-2.225743869066959188e-02,
-2.224215656156214652e-02,
-2.222683949348412680e-02,
-2.221148751398071761e-02,
-2.219610065065111271e-02,
-2.218067893114939598e-02,
-2.216522238318341734e-02,
-2.214973103451566006e-02,
-2.213420491296283141e-02,
-2.211864404639575857e-02,
-2.210304846273919432e-02,
-2.208741818997220566e-02,
-2.207175325612774353e-02,
-2.205605368929302798e-02,
-2.204031951760861835e-02,
-2.202455076926950264e-02,
-2.200874747252425448e-02,
-2.199290965567540085e-02,
-2.197703734707896761e-02,
-2.196113057514458705e-02,
-2.194518936833593850e-02,
-2.192921375516980811e-02,
-2.191320376421676541e-02,
-2.189715942410087532e-02,
-2.188108076349961489e-02,
-2.186496781114362006e-02,
-2.184882059581714359e-02,
-2.183263914635739239e-02,
-2.181642349165520064e-02,
-2.180017366065420750e-02,
-2.178388968235147466e-02,
-2.176757158579681328e-02,
-2.175121940009331831e-02,
-2.173483315439689659e-02,
-2.171841287791649935e-02,
-2.170195859991378914e-02,
-2.168547034970331674e-02,
-2.166894815665252119e-02,
-2.165239205018131344e-02,
-2.163580205976247881e-02,
-2.161917821492116351e-02,
-2.160252054523536733e-02,
-2.158582908033531908e-02,
-2.156910384990407686e-02,
-2.155234488367655313e-02,
-2.153555221144048959e-02,
-2.151872586303558293e-02,
-2.150186586835411279e-02,
-2.148497225734017843e-02,
-2.146804505999022963e-02,
-2.145108430635283073e-02,
-2.143409002652858775e-02,
-2.141706225066986741e-02,
-2.140000100898126201e-02,
-2.138290633171901003e-02,
-2.136577824919112453e-02,
-2.134861679175766372e-02,
-2.133142198983027996e-02,
-2.131419387387226139e-02,
-2.129693247439833070e-02,
-2.127963782197521414e-02,
-2.126230994722061104e-02,
-2.124494888080401267e-02,
-2.122755465344620951e-02,
-2.121012729591947171e-02,
-2.119266683904703907e-02,
-2.117517331370372125e-02,
-2.115764675081521773e-02,
-2.114008718135863482e-02,
-2.112249463636185071e-02,
-2.110486914690406016e-02,
-2.108721074411528881e-02,
-2.106951945917635849e-02,
-2.105179532331918207e-02,
-2.103403836782621189e-02,
-2.101624862403081440e-02,
-2.099842612331706548e-02,
-2.098057089711974701e-02,
-2.096268297692381599e-02,
-2.094476239426533437e-02,
-2.092680918073028945e-02,
-2.090882336795558266e-02,
-2.089080498762795751e-02,
-2.087275407148496409e-02,
-2.085467065131410905e-02,
-2.083655475895327541e-02,
-2.081840642629019522e-02,
-2.080022568526316076e-02,
-2.078201256785985190e-02,
-2.076376710611848100e-02,
-2.074548933212707127e-02,
-2.072717927802318616e-02,
-2.070883697599473772e-02,
-2.069046245827871333e-02,
-2.067205575716247676e-02,
-2.065361690498250177e-02,
-2.063514593412517709e-02,
-2.061664287702626511e-02,
-2.059810776617118644e-02,
-2.057954063409443701e-02,
-2.056094151338017095e-02,
-2.054231043666167322e-02,
-2.052364743662158861e-02,
-2.050495254599165804e-02,
-2.048622579755281226e-02,
-2.046746722413504693e-02,
-2.044867685861752674e-02,
-2.042985473392800247e-02,
-2.041100088304340435e-02,
-2.039211533898940831e-02,
-2.037319813484064768e-02,
-2.035424930372041474e-02,
-2.033526887880039713e-02,
-2.031625689330144799e-02,
-2.029721338049234741e-02,
-2.027813837369096470e-02,
-2.025903190626313771e-02,
-2.023989401162335985e-02,
-2.022072472323445391e-02,
-2.020152407460757901e-02,
-2.018229209930172408e-02,
-2.016302883092455089e-02,
-2.014373430313133942e-02,
-2.012440854962573716e-02,
-2.010505160415927695e-02,
-2.008566350053153302e-02,
-2.006624427258970819e-02,
-2.004679395422884203e-02,
-2.002731257939197734e-02,
-2.000780018206950797e-02,
-1.998825679629975816e-02,
-1.996868245616842050e-02,
-1.994907719580893066e-02,
-1.992944104940179775e-02,
-1.990977405117539192e-02,
-1.989007623540491043e-02,
-1.987034763641339769e-02,
-1.985058828857060378e-02,
-1.983079822629364719e-02,
-1.981097748404684472e-02,
-1.979112609634155889e-02,
-1.977124409773580241e-02,
-1.975133152283496327e-02,
-1.973138840629087148e-02,
-1.971141478280248258e-02,
-1.969141068711544040e-02,
-1.967137615402176493e-02,
-1.965131121836070915e-02,
-1.963121591501730545e-02,
-1.961109027892380535e-02,
-1.959093434505842363e-02,
-1.957074814844596278e-02,
-1.955053172415757712e-02,
-1.953028510731072420e-02,
-1.951000833306873461e-02,
-1.948970143664160645e-02,
-1.946936445328476678e-02,
-1.944899741830024079e-02,
-1.942860036703572546e-02,
-1.940817333488507185e-02,
-1.938771635728752524e-02,
-1.936722946972853701e-02,
-1.934671270773911586e-02,
-1.932616610689567513e-02,
-1.930558970282064343e-02,
-1.928498353118178812e-02,
-1.926434762769252754e-02,
-1.924368202811127873e-02,
-1.922298676824219649e-02,
-1.920226188393446901e-02,
-1.918150741108278629e-02,
-1.916072338562657337e-02,
-1.913990984355099650e-02,
-1.911906682088561696e-02,
-1.909819435370549087e-02,
-1.907729247813014575e-02,
-1.905636123032431253e-02,
-1.903540064649727331e-02,
-1.901441076290323259e-02,
-1.899339161584106053e-02,
-1.897234324165399805e-02,
-1.895126567673022580e-02,
-1.893015895750186847e-02,
-1.890902312044608763e-02,
-1.888785820208380151e-02,
-1.886666423898075359e-02,
-1.884544126774658282e-02,
-1.882418932503544112e-02,
-1.880290844754501159e-02,
-1.878159867201764643e-02,
-1.876026003523920821e-02,
-1.873889257403973246e-02,
-1.871749632529308080e-02,
-1.869607132591705884e-02,
-1.867461761287272579e-02,
-1.865313522316534856e-02,
-1.863162419384354479e-02,
-1.861008456199921696e-02,
-1.858851636476827399e-02,
-1.856691963932976391e-02,
-1.854529442290616531e-02,
-1.852364075276308891e-02,
-1.850195866620953089e-02,
-1.848024820059751896e-02,
-1.845850939332238302e-02,
-1.843674228182205777e-02,
-1.841494690357813047e-02,
-1.839312329611450178e-02,
-1.837127149699823922e-02,
-1.834939154383882429e-02,
-1.832748347428898167e-02,
-1.830554732604355167e-02,
-1.828358313684032288e-02,
-1.826159094445949788e-02,
-1.823957078672382506e-02,
-1.821752270149825520e-02,
-1.819544672669000038e-02,
-1.817334290024900934e-02,
-1.815121126016673928e-02,
-1.812905184447740486e-02,
-1.810686469125698250e-02,
-1.808464983862363359e-02,
-1.806240732473708352e-02,
-1.804013718779946471e-02,
-1.801783946605416825e-02,
-1.799551419778669045e-02,
-1.797316142132414710e-02,
-1.795078117503536366e-02,
-1.792837349733032021e-02,
-1.790593842666101526e-02,
-1.788347600152033826e-02,
-1.786098626044302015e-02,
-1.783846924200458914e-02,
-1.781592498482221371e-02,
-1.779335352755416835e-02,
-1.777075490889946235e-02,
-1.774812916759862386e-02,
-1.772547634243259312e-02,
-1.770279647222364541e-02,
-1.768008959583481504e-02,
-1.765735575216981559e-02,
-1.763459498017288726e-02,
-1.761180731882933462e-02,
-1.758899280716445107e-02,
-1.756615148424461176e-02,
-1.754328338917609739e-02,
-1.752038856110586101e-02,
-1.749746703922119145e-02,
-1.747451886274959537e-02,
-1.745154407095840174e-02,
-1.742854270315550430e-02,
-1.740551479868853585e-02,
-1.738246039694503475e-02,
-1.735937953735269823e-02,
-1.733627225937891050e-02,
-1.731313860253097178e-02,
-1.728997860635549805e-02,
-1.726679231043926066e-02,
-1.724357975440799634e-02,
-1.722034097792746188e-02,
-1.719707602070253208e-02,
-1.717378492247779997e-02,
-1.715046772303656028e-02,
-1.712712446220198206e-02,
-1.710375517983575219e-02,
-1.708035991583928617e-02,
-1.705693871015240629e-02,
-1.703349160275445875e-02,
-1.701001863366342556e-02,
-1.698651984293591058e-02,
-1.696299527066770507e-02,
-1.693944495699277464e-02,
-1.691586894208412656e-02,
-1.689226726615317489e-02,
-1.686863996944993477e-02,
-1.684498709226241869e-02,
-1.682130867491752474e-02,
-1.679760475777994019e-02,
-1.677387538125309566e-02,
-1.675012058577792992e-02,
-1.672634041183395162e-02,
-1.670253489993852800e-02,
-1.667870409064699938e-02,
-1.665484802455236002e-02,
-1.663096674228574726e-02,
-1.660706028451561581e-02,
-1.658312869194852532e-02,
-1.655917200532818628e-02,
-1.653519026543616433e-02,
-1.651118351309154020e-02,
-1.648715178915028182e-02,
-1.646309513450634407e-02,
-1.643901359009024635e-02,
-1.641490719687020705e-02,
-1.639077599585142195e-02,
-1.636662002807609193e-02,
-1.634243933462324258e-02,
-1.631823395660910586e-02,
-1.629400393518635332e-02,
-1.626974931154493570e-02,
-1.624547012691089296e-02,
-1.622116642254737076e-02,
-1.619683823975389542e-02,
-1.617248561986663752e-02,
-1.614810860425787420e-02,
-1.612370723433622158e-02,
-1.609928155154691926e-02,
-1.607483159737125092e-02,
-1.605035741332669005e-02,
-1.602585904096645933e-02,
-1.600133652188029387e-02,
-1.597678989769331370e-02,
-1.595221921006701599e-02,
-1.592762450069822033e-02,
-1.590300581131973839e-02,
-1.587836318370000263e-02,
-1.585369665964310448e-02,
-1.582900628098826007e-02,
-1.580429208961066714e-02,
-1.577955412742025609e-02,
-1.575479243636277935e-02,
-1.573000705841907584e-02,
-1.570519803560515085e-02,
-1.568036540997193307e-02,
-1.565550922360529201e-02,
-1.563062951862652719e-02,
-1.560572633719117808e-02,
-1.558079972149002332e-02,
-1.555584971374847705e-02,
-1.553087635622663228e-02,
-1.550587969121892257e-02,
-1.548085976105469976e-02,
-1.545581660809729370e-02,
-1.543075027474492648e-02,
-1.540566080342956057e-02,
-1.538054823661783553e-02,
-1.535541261681034123e-02,
-1.533025398654202370e-02,
-1.530507238838126581e-02,
-1.527986786493111884e-02,
-1.525464045882781589e-02,
-1.522939021274184561e-02,
-1.520411716937747001e-02,
-1.517882137147218667e-02,
-1.515350286179759608e-02,
-1.512816168315823592e-02,
-1.510279787839272254e-02,
-1.507741149037242039e-02,
-1.505200256200248804e-02,
-1.502657113622106293e-02,
-1.500111725599966375e-02,
-1.497564096434243416e-02,
-1.495014230428712461e-02,
-1.492462131890381904e-02,
-1.489907805129586996e-02,
-1.487351254459942131e-02,
-1.484792484198328016e-02,
-1.482231498664866864e-02,
-1.479668302182980330e-02,
-1.477102899079310409e-02,
-1.474535293683730021e-02,
-1.471965490329387068e-02,
-1.469393493352641467e-02,
-1.466819307093080067e-02,
-1.464242935893474672e-02,
-1.461664384099856454e-02,
-1.459083656061390191e-02,
-1.456500756130506800e-02,
-1.453915688662744433e-02,
-1.451328458016883788e-02,
-1.448739068554850441e-02,
-1.446147524641743821e-02,
-1.443553830645785511e-02,
-1.440957990938395925e-02,
-1.438360009894083281e-02,
-1.435759891890533296e-02,
-1.433157641308554879e-02,
-1.430553262532034513e-02,
-1.427946759948033398e-02,
-1.425338137946653184e-02,
-1.422727400921147863e-02,
-1.420114553267817770e-02,
-1.417499599386073429e-02,
-1.414882543678397039e-02,
-1.412263390550346463e-02,
-1.409642144410504574e-02,
-1.407018809670550034e-02,
-1.404393390745169862e-02,
-1.401765892052119628e-02,
-1.399136318012173322e-02,
-1.396504673049142956e-02,
-1.393870961589823050e-02,
-1.391235188064059332e-02,
-1.388597356904666680e-02,
-1.385957472547449595e-02,
-1.383315539431228570e-02,
-1.380671561997795158e-02,
-1.378025544691917001e-02,
-1.375377491961288570e-02,
-1.372727408256622234e-02,
-1.370075298031515898e-02,
-1.367421165742572185e-02,
-1.364765015849249245e-02,
-1.362106852814045158e-02,
-1.359446681102267039e-02,
-1.356784505182214058e-02,
-1.354120329525023043e-02,
-1.351454158604798415e-02,
-1.348785996898465948e-02,
-1.346115848885884141e-02,
-1.343443719049768753e-02,
-1.340769611875721433e-02,
-1.338093531852171079e-02,
-1.335415483470396049e-02,
-1.332735471224577063e-02,
-1.330053499611663116e-02,
-1.327369573131475210e-02,
-1.324683696286655180e-02,
-1.321995873582662052e-02,
-1.319306109527726249e-02,
-1.316614408632930597e-02,
-1.313920775412099132e-02,
-1.311225214381884357e-02,
-1.308527730061692824e-02,
-1.305828326973724855e-02,
-1.303127009642903247e-02,
-1.300423782596952724e-02,
-1.297718650366294635e-02,
-1.295011617484150869e-02,
-1.292302688486405768e-02,
-1.289591867911728945e-02,
-1.286879160301494449e-02,
-1.284164570199751269e-02,
-1.281448102153296374e-02,
-1.278729760711582071e-02,
-1.276009550426791296e-02,
-1.273287475853718265e-02,
-1.270563541549935352e-02,
-1.267837752075564629e-02,
-1.265110111993477532e-02,
-1.262380625869120344e-02,
-1.259649298270644306e-02,
-1.256916133768777935e-02,
-1.254181136936922090e-02,
-1.251444312351075207e-02,
-1.248705664589870069e-02,
-1.245965198234489507e-02,
-1.243222917868783660e-02,
-1.240478828079137445e-02,
-1.237732933454516356e-02,
-1.234985238586491438e-02,
-1.232235748069191936e-02,
-1.229484466499306330e-02,
-1.226731398476038799e-02,
-1.223976548601189186e-02,
-1.221219921479039898e-02,
-1.218461521716442814e-02,
-1.215701353922750243e-02,
-1.212939422709845283e-02,
-1.210175732692076248e-02,
-1.207410288486339064e-02,
-1.204643094711961918e-02,
-1.201874155990818177e-02,
-1.199103476947188662e-02,
-1.196331062207874399e-02,
-1.193556916402125842e-02,
-1.190781044161602284e-02,
-1.188003450120470560e-02,
-1.185224138915266616e-02,
-1.182443115185005840e-02,
-1.179660383571101354e-02,
-1.176875948717402698e-02,
-1.174089815270105454e-02,
-1.171301987877883255e-02,
-1.168512471191715703e-02,
-1.165721269865042410e-02,
-1.162928388553604100e-02,
-1.160133831915563171e-02,
-1.157337604611417999e-02,
-1.154539711304039713e-02,
-1.151740156658585465e-02,
-1.148938945342624016e-02,
-1.146136082025978227e-02,
-1.143331571380857246e-02,
-1.140525418081723974e-02,
-1.137717626805384054e-02,
-1.134908202230943720e-02,
-1.132097149039755501e-02,
-1.129284471915511720e-02,
-1.126470175544115604e-02,
-1.123654264613781206e-02,
-1.120836743814967312e-02,
-1.118017617840400858e-02,
-1.115196891384998695e-02,
-1.112374569145980867e-02,
-1.109550655822725586e-02,
-1.106725156116900553e-02,
-1.103898074732309435e-02,
-1.101069416375021273e-02,
-1.098239185753276809e-02,
-1.095407387577522138e-02,
-1.092574026560352157e-02,
-1.089739107416533986e-02,
-1.086902634863028648e-02,
-1.084064613618944059e-02,
-1.081225048405546826e-02,
-1.078383943946201705e-02,
-1.075541304966469609e-02,
-1.072697136193966408e-02,
-1.069851442358504476e-02,
-1.067004228191927029e-02,
-1.064155498428237014e-02,
-1.061305257803510892e-02,
-1.058453511055926916e-02,
-1.055600262925701985e-02,
-1.052745518155175954e-02,
-1.049889281488701823e-02,
-1.047031557672735251e-02,
-1.044172351455714860e-02,
-1.041311667588219574e-02,
-1.038449510822771031e-02,
-1.035585885913928132e-02,
-1.032720797618313577e-02,
-1.029854250694496945e-02,
-1.026986249903088025e-02,
-1.024116800006684251e-02,
-1.021245905769874521e-02,
-1.018373571959181254e-02,
-1.015499803343162047e-02,
-1.012624604692263786e-02,
-1.009747980778955348e-02,
-1.006869936377590563e-02,
-1.003990476264500151e-02,
-1.001109605217936037e-02,
-9.982273280180814154e-03,
-9.953436494469898588e-03,
-9.924585742886836773e-03,
-9.895721073290194778e-03,
-9.866842533557929409e-03,
-9.837950171586765449e-03,
-9.809044035291772379e-03,
-9.780124172607247354e-03,
-9.751190631485506105e-03,
-9.722243459897949788e-03,
-9.693282705833793436e-03,
-9.664308417301080770e-03,
-9.635320642325959084e-03,
-9.606319428952960274e-03,
-9.577304825244182043e-03,
-9.548276879280458845e-03,
-9.519235639159868284e-03,
-9.490181152998938482e-03,
-9.461113468931739087e-03,
-9.432032635110278521e-03,
-9.402938699703655701e-03,
-9.373831710899236183e-03,
-9.344711716901387549e-03,
-9.315578765931760430e-03,
-9.286432906229795045e-03,
-9.257274186051937109e-03,
-9.228102653671915387e-03,
-9.198918357380148417e-03,
-9.169721345484613609e-03,
-9.140511666309629468e-03,
-9.111289368196981431e-03,
-9.082054499504546227e-03,
-9.052807108607429862e-03,
-9.023547243897086373e-03,
-8.994274953781761922e-03,
-8.964990286685580595e-03,
-8.935693291049718809e-03,
-8.906384015330982840e-03,
-8.877062508002891289e-03,
-8.847728817555050584e-03,
-8.818382992492646705e-03,
-8.789025081337486014e-03,
-8.759655132626602281e-03,
-8.730273194913503940e-03,
-8.700879316766744684e-03,
-8.671473546771064911e-03,
-8.642055933526541708e-03,
-8.612626525648984371e-03,
-8.583185371769058367e-03,
-8.553732520533447597e-03,
-8.524268020603398971e-03,
-8.494791920655841294e-03,
-8.465304269382634139e-03,
-8.435805115490807235e-03,
-8.406294507701804128e-03,
-8.376772494752599343e-03,
-8.347239125394412956e-03,
-8.317694448393225803e-03,
-8.288138512529887036e-03,
-8.258571366599614522e-03,
-8.228993059412279334e-03,
-8.199403639791602583e-03,
-8.169803156576270833e-03,
-8.140191658618477211e-03,
-8.110569194785274480e-03,
-8.080935813957012062e-03,
-8.051291565028612790e-03,
-8.021636496908624014e-03,
-7.991970658519630469e-03,
-7.962294098797416397e-03,
-7.932606866692103534e-03,
-7.902909011166671382e-03,
-7.873200581198143769e-03,
-7.843481625776726682e-03,
-7.813752193906184709e-03,
-7.784012334603137608e-03,
-7.754262096897414185e-03,
-7.724501529832393174e-03,
-7.694730682463815814e-03,
-7.664949603860849239e-03,
-7.635158343105317991e-03,
-7.605356949292009332e-03,
-7.575545471527863998e-03,
-7.545723958933121117e-03,
-7.515892460639859302e-03,
-7.486051025793086060e-03,
-7.456199703550043037e-03,
-7.426338543080390764e-03,
-7.396467593565514767e-03,
-7.366586904199548189e-03,
-7.336696524188034314e-03,
-7.306796502749146952e-03,
-7.276886889112241935e-03,
-7.246967732519007249e-03,
-7.217039082222820312e-03,
-7.187100987488222355e-03,
-7.157153497591934102e-03,
-7.127196661821575546e-03,
-7.097230529476718057e-03,
-7.067255149867486194e-03,
-7.037270572316405189e-03,
-7.007276846155942839e-03,
-6.977274020730524391e-03,
-6.947262145394868076e-03,
-6.917241269515282676e-03,
-6.887211442468256332e-03,
-6.857172713641501716e-03,
-6.827125132433223102e-03,
-6.797068748252462454e-03,
-6.767003610518151392e-03,
-6.736929768660408768e-03,
-6.706847272119152020e-03,
-6.676756170344608915e-03,
-6.646656512797468469e-03,
-6.616548348948417778e-03,
-6.586431728278270385e-03,
-6.556306700277325303e-03,
-6.526173314446431263e-03,
-6.496031620295500061e-03,
-6.465881667344653208e-03,
-6.435723505123507222e-03,
-6.405557183171344503e-03,
-6.375382751036422907e-03,
-6.345200258277026995e-03,
-6.315009754460100197e-03,
-6.284811289162420961e-03,
-6.254604911969291296e-03,
-6.224390672475540315e-03,
-6.194168620284968250e-03,
-6.163938805009756654e-03,
-6.133701276271576880e-03,
-6.103456083700184095e-03,
-6.073203276934618575e-03,
-6.042942905621644448e-03,
-6.012675019417728153e-03,
-5.982399667986550845e-03,
-5.952116901000921792e-03,
-5.921826768141265698e-03,
-5.891529319096830072e-03,
-5.861224603564269692e-03,
-5.830912671248755959e-03,
-5.800593571863182397e-03,
-5.770267355128495118e-03,
-5.739934070772837599e-03,
-5.709593768532748512e-03,
-5.679246498151680270e-03,
-5.648892309381250629e-03,
-5.618531251979863583e-03,
-5.588163375713777956e-03,
-5.557788730356495038e-03,
-5.527407365688241647e-03,
-5.497019331497004883e-03,
-5.466624677577144355e-03,
-5.436223453730440816e-03,
-5.405815709765388402e-03,
-5.375401495497465244e-03,
-5.344980860748288660e-03,
-5.314553855346832063e-03,
-5.284120529127882791e-03,
-5.253680931933405601e-03,
-5.223235113611039530e-03,
-5.192783124015273172e-03,
-5.162325013006575578e-03,
-5.131860830451771827e-03,
-5.101390626223393371e-03,
-5.070914450199955591e-03,
-5.040432352266150350e-03,
-5.009944382312395833e-03,
-4.979450590234942367e-03,
-4.948951025935212356e-03,
-4.918445739320872340e-03,
-4.887934780304378432e-03,
-4.857418198804301646e-03,
-4.826896044743823021e-03,
-4.796368368051905431e-03,
-4.765835218662503418e-03,
-4.735296646514795642e-03,
-4.704752701552474513e-03,
-4.674203433724830395e-03,
-4.643648892985291834e-03,
-4.613089129292746553e-03,
-4.582524192609889122e-03,
-4.551954132905215028e-03,
-4.521379000150708288e-03,
-4.490798844322927384e-03,
-4.460213715403327922e-03,
-4.429623663376955518e-03,
-4.399028738233503981e-03,
-4.368428989966668258e-03,
-4.337824468574303163e-03,
-4.307215224057680050e-03,
-4.276601306422662084e-03,
-4.245982765678183758e-03,
-4.215359651837571019e-03,
-4.184732014917064147e-03,
-4.154099904936984361e-03,
-4.123463371920928905e-03,
-4.092822465896041664e-03,
-4.062177236892240348e-03,
-4.031527734943337118e-03,
-4.000874010085628263e-03,
-3.970216112358929822e-03,
-3.939554091806051102e-03,
-3.908887998472171041e-03,
-3.878217882405968816e-03,
-3.847543793658141954e-03,
-3.816865782282754648e-03,
-3.786183898335713366e-03,
-3.755498191875946464e-03,
-3.724808712964602746e-03,
-3.694115511665332051e-03,
-3.663418638043477310e-03,
-3.632718142167282345e-03,
-3.602014074106326715e-03,
-3.571306483932900483e-03,
-3.540595421720351462e-03,
-3.509880937545052388e-03,
-3.479163081483921567e-03,
-3.448441903616419110e-03,
-3.417717454023086725e-03,
-3.386989782785956252e-03,
-3.356258939988847161e-03,
-3.325524975716734680e-03,
-3.294787940056042100e-03,
-3.264047883093881396e-03,
-3.233304854919120518e-03,
-3.202558905620975227e-03,
-3.171810085290307536e-03,
-3.141058444018122574e-03,
-3.110304031896735620e-03,
-3.079546899018997981e-03,
-3.048787095478522509e-03,
-3.018024671368972362e-03,
-2.987259676785120922e-03,
-2.956492161821458377e-03,
-2.925722176573261613e-03,
-2.894949771136023919e-03,
-2.864174995604858685e-03,
-2.833397900075608749e-03,
-2.802618534643407447e-03,
-2.771836949403952335e-03,
-2.741053194452055825e-03,
-2.710267319882780131e-03,
-2.679479375790665748e-03,
-2.648689412269973013e-03,
-2.617897479413935739e-03,
-2.587103627315878382e-03,
-2.556307906067749325e-03,
-2.525510365761259729e-03,
-2.494711056487103340e-03,
-2.463910028335219299e-03,
-2.433107331394033200e-03,
-2.402303015751574688e-03,
-2.371497131494182918e-03,
-2.340689728706955852e-03,
-2.309880857474005695e-03,
-2.279070567877865619e-03,
-2.248258909999745637e-03,
-2.217445933918781465e-03,
-2.186631689713127834e-03,
-2.155816227458535583e-03,
-2.124999597229621472e-03,
-2.094181849098416658e-03,
-2.063363033135508142e-03,
-2.032543199409231685e-03,
-2.001722397985979292e-03,
-1.970900678929395598e-03,
-1.940078092301533198e-03,
-1.909254688161347770e-03,
-1.878430516565877907e-03,
-1.847605627569437383e-03,
-1.816780071223889894e-03,
-1.785953897578052962e-03,
-1.755127156677968765e-03,
-1.724299898567322213e-03,
-1.693472173286165051e-03,
-1.662644030872048638e-03,
-1.631815521359235299e-03,
-1.600986694778979346e-03,
-1.570157601158750360e-03,
-1.539328290523350349e-03,
-1.508498812893476751e-03,
-1.477669218286823327e-03,
-1.446839556717329249e-03,
-1.416009878195426726e-03,
-1.385180232727287923e-03,
-1.354350670315927372e-03,
-1.323521240959776900e-03,
-1.292691994653956964e-03,
-1.261862981388812109e-03,
-1.231034251151064780e-03,
-1.200205853923196021e-03,
-1.169377839682855672e-03,
-1.138550258403985384e-03,
-1.107723160055358851e-03,
-1.076896594601885453e-03,
-1.046070612002974413e-03,
-1.015245262214519535e-03,
-9.844205951864129153e-04,
-9.535966608645267536e-04,
-9.227735091890890010e-04,
-8.919511900959694413e-04,
-8.611297535152339071e-04,
-8.303092493722624180e-04,
-7.994897275869803721e-04,
-7.686712380741221162e-04,
-7.378538307424692931e-04,
-7.070375554959621497e-04,
-6.762224622324291765e-04,
-6.454086008440111395e-04,
-6.145960212174324559e-04,
-5.837847732333983778e-04,
-5.529749067668647414e-04,
-5.221664716862677502e-04,
-4.913595178546452565e-04,
-4.605540951281848522e-04,
-4.297502533573423320e-04,
-3.989480423860809082e-04,
-3.681475120521261074e-04,
-3.373487121862043885e-04,
-3.065516926131647509e-04,
-2.757565031505239514e-04,
-2.449631936097573012e-04,
-2.141718137948507409e-04,
-1.833824135034172170e-04,
-1.525950425261055196e-04,
-1.218097506460023052e-04,
-9.102658763975618353e-05,
-6.024560327612199994e-05,
-2.946684731725605054e-05,
 1.309630482909408198e-06,
 3.208378037668672365e-05,
 6.285555262511502840e-05,
 9.362489749598110840e-05,
 1.243917652654441758e-04,
 1.551561062167414737e-04,
 1.859178706416422658e-04,
 2.166770088393267307e-04,
 2.474334711171502564e-04,
 2.781872077903825547e-04,
 3.089381691829722943e-04,
 3.396863056264243013e-04,
 3.704315674612564287e-04,
 4.011739050357031214e-04,
 4.319132687071667296e-04,
 4.626496088410995337e-04,
 4.933828758115958810e-04,
 5.241130200019900693e-04,
 5.548399918037257407e-04,
 5.855637416178196631e-04,
 6.162842198537345391e-04,
 6.470013769301451037e-04,
 6.777151632746717357e-04,
 7.084255293246542523e-04,
 7.391324255260206533e-04,
 7.698358023347474325e-04,
 8.005356102155637395e-04,
 8.312317996433975969e-04,
 8.619243211022631834e-04,
 8.926131250860233537e-04,
 9.232981620981246590e-04,
 9.539793826521913815e-04,
 9.846567372717601220e-04,
 1.015330176489852082e-03,
 1.045999650850411690e-03,
 1.076665110906342791e-03,
 1.107326507221978017e-03,
 1.137983790371102514e-03,
 1.168636910938575680e-03,
 1.199285819519048781e-03,
 1.229930466718394356e-03,
 1.260570803152609226e-03,
 1.291206779448564107e-03,
 1.321838346243740803e-03,
 1.352465454187004590e-03,
 1.383088053937481850e-03,
 1.413706096165996207e-03,
 1.444319531553795669e-03,
 1.474928310794162024e-03,
 1.505532384590447343e-03,
 1.536131703658352981e-03,
 1.566726218724840379e-03,
 1.597315880527851346e-03,
 1.627900639817577225e-03,
 1.658480447355361676e-03,
 1.689055253914453986e-03,
 1.719625010279726956e-03,
 1.750189667248476825e-03,
 1.780749175629269898e-03,
 1.811303486243415325e-03,
 1.841852549923657769e-03,
 1.872396317515626334e-03,
 1.902934739876735839e-03,
 1.933467767876917995e-03,
 1.963995352398386577e-03,
 1.994517444336377926e-03,
 2.025033994598053090e-03,
 2.055544954103918995e-03,
 2.086050273786736221e-03,
 2.116549904592096229e-03,
 2.147043797479010734e-03,
 2.177531903418800617e-03,
 2.208014173396537910e-03,
 2.238490558409758201e-03,
 2.268961009469900019e-03,
 2.299425477601207621e-03,
 2.329883913841459143e-03,
 2.360336269241738050e-03,
 2.390782494867167360e-03,
 2.421222541795793343e-03,
 2.451656361120069585e-03,
 2.482083903945511705e-03,
 2.512505121392345341e-03,
 2.542919964593540715e-03,
 2.573328384697083811e-03,
 2.603730332864882206e-03,
 2.634125760272493146e-03,
 2.664514618110393803e-03,
 2.694896857582871480e-03,
 2.725272429908783423e-03,
 2.755641286321281868e-03,
 2.786003378068578618e-03,
 2.816358656412846963e-03,
 2.846707072631642858e-03,
 2.877048578016622084e-03,
 2.907383123874990923e-03,
 2.937710661528367736e-03,
 2.968031142313591782e-03,
 2.998344517582400125e-03,
 3.028650738702217370e-03,
 3.058949757055047600e-03,
 3.089241524038906835e-03,
 3.119525991066685044e-03,
 3.149803109566774555e-03,
 3.180072830983635569e-03,
 3.210335106776676401e-03,
 3.240589888421715851e-03,
 3.270837127409671318e-03,
 3.301076775248015099e-03,
 3.331308783459662869e-03,
 3.361533103583719175e-03,
 3.391749687175216361e-03,
 3.421958485805884354e-03,
 3.452159451063025256e-03,
 3.482352534550946233e-03,
 3.512537687889697932e-03,
 3.542714862716661757e-03,
 3.572884010684596132e-03,
 3.603045083464089839e-03,
 3.633198032741589197e-03,
 3.663342810220860009e-03,
 3.693479367622542163e-03,
 3.723607656683872516e-03,
 3.753727629159289442e-03,
 3.783839236820163519e-03,
 3.813942431455536949e-03,
 3.844037164871068855e-03,
 3.874123388890399634e-03,
 3.904201055353901089e-03,
 3.934270116120118857e-03,
 3.964330523064660446e-03,
 3.994382228080897365e-03,
 4.024425183079809870e-03,
 4.054459339990630976e-03,
 4.084484650759818633e-03,
 4.114501067352430499e-03,
 4.144508541751031928e-03,
 4.174507025956481800e-03,
 4.204496471987615933e-03,
 4.234476831881872454e-03,
 4.264448057695028119e-03,
 4.294410101500728202e-03,
 4.324362915391782337e-03,
 4.354306451479070771e-03,
 4.384240661892230446e-03,
 4.414165498779491076e-03,
 4.444080914308312646e-03,
 4.473986860664387090e-03,
 4.503883290052979223e-03,
 4.533770154697885045e-03,
 4.563647406842148181e-03,
 4.593514998747810080e-03,
 4.623372882696648138e-03,
 4.653221010989081960e-03,
 4.683059335945602766e-03,
 4.712887809905475824e-03,
 4.742706385228195008e-03,
 4.772515014292381258e-03,
 4.802313649496297784e-03,
 4.832102243258534421e-03,
 4.861880748016841024e-03,
 4.891649116229518715e-03,
 4.921407300374241144e-03,
 4.951155252949403229e-03,
 4.980892926473030023e-03,
 5.010620273483559935e-03,
 5.040337246539525543e-03,
 5.070043798220378456e-03,
 5.099739881125300162e-03,
 5.129425447874689549e-03,
 5.159100451109034473e-03,
 5.188764843489674164e-03,
 5.218418577698493051e-03,
 5.248061606438744753e-03,
 5.277693882433856856e-03,
 5.307315358428788335e-03,
 5.336925987189501328e-03,
 5.366525721502760776e-03,
 5.396114514176693876e-03,
 5.425692318040529864e-03,
 5.455259085945337282e-03,
 5.484814770762970124e-03,
 5.514359325387395774e-03,
 5.543892702733687131e-03,
 5.573414855738716492e-03,
 5.602925737360908362e-03,
 5.632425300580962829e-03,
 5.661913498400824273e-03,
 5.691390283845011028e-03,
 5.720855609959380264e-03,
 5.750309429812579080e-03,
 5.779751696494906527e-03,
 5.809182363118914685e-03,
 5.838601382819922150e-03,
 5.868008708755028703e-03,
 5.897404294104415488e-03,
 5.926788092070157596e-03,
 5.956160055877767964e-03,
 5.985520138774277042e-03,
 6.014868294030630176e-03,
 6.044204474939787221e-03,
 6.073528634818264708e-03,
 6.102840727004918073e-03,
 6.132140704862283458e-03,
 6.161428521775541220e-03,
 6.190704131153260993e-03,
 6.219967486427092906e-03,
 6.249218541052529129e-03,
 6.278457248507829207e-03,
 6.307683562295437335e-03,
 6.336897435940662231e-03,
 6.366098822993131699e-03,
 6.395287677025697157e-03,
 6.424463951634997415e-03,
 6.453627600442019864e-03,
 6.482778577091031884e-03,
 6.511916835250979897e-03,
 6.541042328614366137e-03,
 6.570155010898059630e-03,
 6.599254835842941445e-03,
 6.628341757214735626e-03,
 6.657415728802836517e-03,
 6.686476704421781547e-03,
 6.715524637909950183e-03,
 6.744559483130958648e-03,
 6.773581193972604345e-03,
 6.802589724347616988e-03,
 6.831585028193360234e-03,
 6.860567059472352965e-03,
 6.889535772172140048e-03,
 6.918491120304796210e-03,
 6.947433057908257437e-03,
 6.976361539044563694e-03,
 7.005276517802094122e-03,
 7.034177948293744709e-03,
 7.063065784658460917e-03,
 7.091939981059990419e-03,
 7.120800491688281282e-03,
 7.149647270758363073e-03,
 7.178480272511163912e-03,
 7.207299451213159194e-03,
 7.236104761157165222e-03,
 7.264896156661199492e-03,
 7.293673592069957815e-03,
 7.322437021753460361e-03,
 7.351186400108559137e-03,
 7.379921681557733218e-03,
 7.408642820549786109e-03,
 7.437349771560259476e-03,
 7.466042489090502464e-03,
 7.494720927668960600e-03,
 7.523385041850157509e-03,
 7.552034786215360181e-03,
 7.580670115372376006e-03,
 7.609290983956251003e-03,
 7.637897346628189088e-03,
 7.666489158077011840e-03,
 7.695066373017785469e-03,
 7.723628946193288394e-03,
 7.752176832372957398e-03,
 7.780709986353544216e-03,
 7.809228362958900438e-03,
 7.837731917040697410e-03,
 7.866220603477320356e-03,
 7.894694377175191097e-03,
 7.923153193068329173e-03,
 7.951597006117468863e-03,
 7.980025771312137389e-03,
 8.008439443668779675e-03,
 8.036837978232356031e-03,
 8.065221330075027228e-03,
 8.093589454297608204e-03,
 8.121942306028409261e-03,
 8.150279840424042715e-03,
 8.178602012669166157e-03,
 8.206908777977072258e-03,
 8.235200091588840490e-03,
 8.263475908774502859e-03,
 8.291736184831900724e-03,
 8.319980875088254721e-03,
 8.348209934898221871e-03,
 8.376423319646119497e-03,
 8.404620984744773371e-03,
 8.432802885635450052e-03,
 8.460968977788831807e-03,
 8.489119216704092002e-03,
 8.517253557909630624e-03,
 8.545371956962718660e-03,
 8.573474369450268320e-03,
 8.601560750987786996e-03,
 8.629631057220766774e-03,
 8.657685243823320942e-03,
 8.685723266499719222e-03,
 8.713745080983248056e-03,
 8.741750643036881943e-03,
 8.769739908453153335e-03,
 8.797712833054683462e-03,
 8.825669372693337525e-03,
 8.853609483251386955e-03,
 8.881533120640636852e-03,
 8.909440240802769459e-03,
 8.937330799710116111e-03,
 8.965204753364390891e-03,
 8.993062057798238002e-03,
 9.020902669073868271e-03,
 9.048726543284486834e-03,
 9.076533636553177700e-03,
 9.104323905033750303e-03,
 9.132097304910305816e-03,
 9.159853792398081965e-03,
 9.187593323742328927e-03,
 9.215315855219681496e-03,
 9.243021343137000287e-03,
 9.270709743832710945e-03,
 9.298381013675229012e-03,
 9.326035109064965273e-03,
 9.353671986432724600e-03,
 9.381291602240871691e-03,
 9.408893912983004940e-03,
 9.436478875183739595e-03,
 9.464046445399205629e-03,
 9.491596580216728543e-03,
 9.519129236255717552e-03,
 9.546644370166383620e-03,
 9.574141938631323262e-03,
 9.601621898364137708e-03,
 9.629084206110796393e-03,
 9.656528818648722756e-03,
 9.683955692787305988e-03,
 9.711364785367786537e-03,
 9.738756053263946527e-03,
 9.766129453380968314e-03,
 9.793484942656907263e-03,
 9.820822478061519076e-03,
 9.848142016597080314e-03,
 9.875443515298065744e-03,
 9.902726931231691301e-03,
 9.929992221497690313e-03,
 9.957239343227912778e-03,
 9.984468253587406097e-03,
 1.001167890977357200e-02,
 1.003887126901667828e-02,
 1.006604528857966280e-02,
 1.009320092575882559e-02,
 1.012033813788293379e-02,
 1.014745688231428501e-02,
 1.017455711644785904e-02,
 1.020163879771202910e-02,
 1.022870188356817499e-02,
 1.025574633151145852e-02,
 1.028277209906983472e-02,
 1.030977914380528868e-02,
 1.033676742331273227e-02,
 1.036373689522116642e-02,
 1.039068751719290223e-02,
 1.041761924692385759e-02,
 1.044453204214422851e-02,
 1.047142586061740495e-02,
 1.049830066014132042e-02,
 1.052515639854725675e-02,
 1.055199303370108616e-02,
 1.057881052350240735e-02,
 1.060560882588510757e-02,
 1.063238789881710070e-02,
 1.065914770030110953e-02,
 1.068588818837360940e-02,
 1.071260932110607023e-02,
 1.073931105660403014e-02,
 1.076599335300774084e-02,
 1.079265616849188654e-02,
 1.081929946126632819e-02,
 1.084592318957505568e-02,
 1.087252731169735358e-02,
 1.089911178594732931e-02,
 1.092567657067380731e-02,
 1.095222162426075403e-02,
 1.097874690512700042e-02,
 1.100525237172708670e-02,
 1.103173798255004980e-02,
 1.105820369612082674e-02,
 1.108464947099927975e-02,
 1.111107526578077910e-02,
 1.113748103909601751e-02,
 1.116386674961167454e-02,
 1.119023235602939481e-02,
 1.121657781708713594e-02,
 1.124290309155790563e-02,
 1.126920813825114075e-02,
 1.129549291601166829e-02,
 1.132175738372020665e-02,
 1.134800150029396243e-02,
 1.137422522468546984e-02,
 1.140042851588409130e-02,
 1.142661133291465736e-02,
 1.145277363483892044e-02,
 1.147891538075435265e-02,
 1.150503652979509121e-02,
 1.153113704113140590e-02,
 1.155721687397059591e-02,
 1.158327598755583103e-02,
 1.160931434116756547e-02,
 1.163533189412240161e-02,
 1.166132860577393481e-02,
 1.168730443551228675e-02,
 1.171325934276499364e-02,
 1.173919328699583008e-02,
 1.176510622770624535e-02,
 1.179099812443410757e-02,
 1.181686893675495953e-02,
 1.184271862428115142e-02,
 1.186854714666218599e-02,
 1.189435446358535348e-02,
 1.192014053477477922e-02,
 1.194590531999246107e-02,
 1.197164877903759278e-02,
 1.199737087174700817e-02,
 1.202307155799497637e-02,
 1.204875079769389228e-02,
 1.207440855079337967e-02,
 1.210004477728135290e-02,
 1.212565943718301939e-02,
 1.215125249056216335e-02,
 1.217682389752004421e-02,
 1.220237361819612870e-02,
 1.222790161276790522e-02,
 1.225340784145121514e-02,
 1.227889226450022166e-02,
 1.230435484220693612e-02,
 1.232979553490240465e-02,
 1.235521430295510176e-02,
 1.238061110677304844e-02,
 1.240598590680195949e-02,
 1.243133866352682734e-02,
 1.245666933747070597e-02,
 1.248197788919592349e-02,
 1.250726427930316971e-02,
 1.253252846843214141e-02,
 1.255777041726126482e-02,
 1.258299008650840163e-02,
 1.260818743692983246e-02,
 1.263336242932151972e-02,
 1.265851502451798179e-02,
 1.268364518339354895e-02,
 1.270875286686132949e-02,
 1.273383803587382901e-02,
 1.275890065142332164e-02,
 1.278394067454100003e-02,
 1.280895806629805608e-02,
 1.283395278780494891e-02,
 1.285892480021182289e-02,
 1.288387406470838104e-02,
 1.290880054252449213e-02,
 1.293370419492930433e-02,
 1.295858498323238482e-02,
 1.298344286878262005e-02,
 1.300827781296952541e-02,
 1.303308977722218188e-02,
 1.305787872300992816e-02,
 1.308264461184218894e-02,
 1.310738740526889816e-02,
 1.313210706487985373e-02,
 1.315680355230555362e-02,
 1.318147682921705366e-02,
 1.320612685732498043e-02,
 1.323075359838158174e-02,
 1.325535701417883579e-02,
 1.327993706655002971e-02,
 1.330449371736853147e-02,
 1.332902692854906306e-02,
 1.335353666204670310e-02,
 1.337802287985754950e-02,
 1.340248554401852511e-02,
 1.342692461660795200e-02,
 1.345134005974457474e-02,
 1.347573183558889789e-02,
 1.350009990634197868e-02,
 1.352444423424666899e-02,
 1.354876478158667692e-02,
 1.357306151068710109e-02,
 1.359733438391470643e-02,
 1.362158336367735000e-02,
 1.364580841242479282e-02,
 1.367000949264805289e-02,
 1.369418656687987519e-02,
 1.371833959769456872e-02,
 1.374246854770854939e-02,
 1.376657337957955772e-02,
 1.379065405600765799e-02,
 1.381471053973434837e-02,
 1.383874279354365376e-02,
 1.386275078026112141e-02,
 1.388673446275462582e-02,
 1.391069380393398537e-02,
 1.393462876675162498e-02,
 1.395853931420175907e-02,
 1.398242540932139594e-02,
 1.400628701518943919e-02,
 1.403012409492737297e-02,
 1.405393661169943714e-02,
 1.407772452871198197e-02,
 1.410148780921439970e-02,
 1.412522641649818084e-02,
 1.414894031389815100e-02,
 1.417262946479151339e-02,
 1.419629383259827723e-02,
 1.421993338078134626e-02,
 1.424354807284685526e-02,
 1.426713787234343452e-02,
 1.429070274286335131e-02,
 1.431424264804133199e-02,
 1.433775755155594633e-02,
 1.436124741712811737e-02,
 1.438471220852291337e-02,
 1.440815188954805773e-02,
 1.443156642405502878e-02,
 1.445495577593878915e-02,
 1.447831990913747528e-02,
 1.450165878763296813e-02,
 1.452497237545052715e-02,
 1.454826063665949631e-02,
 1.457152353537244371e-02,
 1.459476103574611737e-02,
 1.461797310198072360e-02,
 1.464115969832071283e-02,
 1.466432078905413952e-02,
 1.468745633851312703e-02,
 1.471056631107372191e-02,
 1.473365067115654098e-02,
 1.475670938322566801e-02,
 1.477974241179001377e-02,
 1.480274972140232029e-02,
 1.482573127665974370e-02,
 1.484868704220373113e-02,
 1.487161698272034330e-02,
 1.489452106294013832e-02,
 1.491739924763777446e-02,
 1.494025150163304748e-02,
 1.496307778979000074e-02,
 1.498587807701745774e-02,
 1.500865232826878275e-02,
 1.503140050854270132e-02,
 1.505412258288214844e-02,
 1.507681851637540302e-02,
 1.509948827415529514e-02,
 1.512213182140023822e-02,
 1.514474912333287418e-02,
 1.516734014522177522e-02,
 1.518990485238003868e-02,
 1.521244321016657422e-02,
 1.523495518398491379e-02,
 1.525744073928447450e-02,
 1.527989984155975201e-02,
 1.530233245635058241e-02,
 1.532473854924262975e-02,
 1.534711808586660363e-02,
 1.536947103189938157e-02,
 1.539179735306288148e-02,
 1.541409701512518049e-02,
 1.543636998389988010e-02,
 1.545861622524626403e-02,
 1.548083570506953929e-02,
 1.550302838932107741e-02,
 1.552519424399769789e-02,
 1.554733323514277156e-02,
 1.556944532884523870e-02,
 1.559153049124041568e-02,
 1.561358868850950057e-02,
 1.563561988688036072e-02,
 1.565762405262655435e-02,
 1.567960115206841476e-02,
 1.570155115157246054e-02,
 1.572347401755153778e-02,
 1.574536971646494851e-02,
 1.576723821481855123e-02,
 1.578907947916494831e-02,
 1.581089347610295515e-02,
 1.583268017227850918e-02,
 1.585443953438387191e-02,
 1.587617152915827418e-02,
 1.589787612338756234e-02,
 1.591955328390476723e-02,
 1.594120297758947272e-02,
 1.596282517136862061e-02,
 1.598441983221571272e-02,
 1.600598692715175450e-02,
 1.602752642324457855e-02,
 1.604903828760909784e-02,
 1.607052248740784006e-02,
 1.609197898985011838e-02,
 1.611340776219304799e-02,
 1.613480877174059899e-02,
 1.615618198584457821e-02,
 1.617752737190399082e-02,
 1.619884489736545322e-02,
 1.622013452972293629e-02,
 1.624139623651846970e-02,
 1.626262998534125023e-02,
 1.628383574382859939e-02,
 1.630501347966525905e-02,
 1.632616316058392927e-02,
 1.634728475436499073e-02,
 1.636837822883713961e-02,
 1.638944355187642310e-02,
 1.641048069140756127e-02,
 1.643148961540263561e-02,
 1.645247029188243865e-02,
 1.647342268891547473e-02,
 1.649434677461842844e-02,
 1.651524251715670230e-02,
 1.653610988474329621e-02,
 1.655694884564022640e-02,
 1.657775936815738399e-02,
 1.659854142065329830e-02,
 1.661929497153484189e-02,
 1.664001998925773371e-02,
 1.666071644232578614e-02,
 1.668138429929192507e-02,
 1.670202352875729823e-02,
 1.672263409937214951e-02,
 1.674321597983527421e-02,
 1.676376913889424808e-02,
 1.678429354534544116e-02,
 1.680478916803441330e-02,
 1.682525597585551175e-02,
 1.684569393775195781e-02,
 1.686610302271623896e-02,
 1.688648319978979309e-02,
 1.690683443806317507e-02,
 1.692715670667602895e-02,
 1.694744997481760843e-02,
 1.696771421172593025e-02,
 1.698794938668884286e-02,
 1.700815546904317979e-02,
 1.702833242817531831e-02,
 1.704848023352099548e-02,
 1.706859885456572107e-02,
 1.708868826084415996e-02,
 1.710874842194097870e-02,
 1.712877930749012387e-02,
 1.714878088717560964e-02,
 1.716875313073077530e-02,
 1.718869600793892366e-02,
 1.720860948863329673e-02,
 1.722849354269673922e-02,
 1.724834814006235076e-02,
 1.726817325071285450e-02,
 1.728796884468110709e-02,
 1.730773489204994256e-02,
 1.732747136295256091e-02,
 1.734717822757188971e-02,
 1.736685545614138904e-02,
 1.738650301894441308e-02,
 1.740612088631500465e-02,
 1.742570902863719434e-02,
 1.744526741634536138e-02,
 1.746479601992436889e-02,
 1.748429480990964374e-02,
 1.750376375688689201e-02,
 1.752320283149249106e-02,
 1.754261200441360052e-02,
 1.756199124638729153e-02,
 1.758134052820213566e-02,
 1.760065982069684495e-02,
 1.761994909476121557e-02,
 1.763920832133555189e-02,
 1.765843747141131875e-02,
 1.767763651603062452e-02,
 1.769680542628654374e-02,
 1.771594417332303037e-02,
 1.773505272833540009e-02,
 1.775413106256953921e-02,
 1.777317914732285883e-02,
 1.779219695394353498e-02,
 1.781118445383135171e-02,
 1.783014161843691700e-02,
 1.784906841926221788e-02,
 1.786796482786070367e-02,
 1.788683081583694601e-02,
 1.790566635484718699e-02,
 1.792447141659886042e-02,
 1.794324597285093872e-02,
 1.796198999541381153e-02,
 1.798070345614980609e-02,
 1.799938632697234073e-02,
 1.801803857984698651e-02,
 1.803666018679050270e-02,
 1.805525111987179090e-02,
 1.807381135121130175e-02,
 1.809234085298131248e-02,
 1.811083959740584365e-02,
 1.812930755676122122e-02,
 1.814774470337513282e-02,
 1.816615100962782128e-02,
 1.818452644795107848e-02,
 1.820287099082882817e-02,
 1.822118461079742097e-02,
 1.823946728044486751e-02,
 1.825771897241184813e-02,
 1.827593965939076914e-02,
 1.829412931412677246e-02,
 1.831228790941691331e-02,
 1.833041541811071540e-02,
 1.834851181311009799e-02,
 1.836657706736945922e-02,
 1.838461115389553382e-02,
 1.840261404574766030e-02,
 1.842058571603763517e-02,
 1.843852613792990730e-02,
 1.845643528464147032e-02,
 1.847431312944203957e-02,
 1.849215964565380926e-02,
 1.850997480665204920e-02,
 1.852775858586468496e-02,
 1.854551095677238123e-02,
 1.856323189290859377e-02,
 1.858092136785970475e-02,
 1.859857935526533848e-02,
 1.861620582881754610e-02,
 1.863380076226186371e-02,
 1.865136412939658039e-02,
 1.866889590407327243e-02,
 1.868639606019649804e-02,
 1.870386457172396044e-02,
 1.872130141266653905e-02,
 1.873870655708859134e-02,
 1.875607997910747407e-02,
 1.877342165289404632e-02,
 1.879073155267245443e-02,
 1.880800965272014930e-02,
 1.882525592736797662e-02,
 1.884247035100046139e-02,
 1.885965289805567602e-02,
 1.887680354302477201e-02,
 1.889392226045304851e-02,
 1.891100902493902253e-02,
 1.892806381113494238e-02,
 1.894508659374673915e-02,
 1.896207734753429727e-02,
 1.897903604731091334e-02,
 1.899596266794405935e-02,
 1.901285718435459862e-02,
 1.902971957151776417e-02,
 1.904654980446215604e-02,
 1.906334785827080644e-02,
 1.908011370808028462e-02,
 1.909684732908172727e-02,
 1.911354869651976998e-02,
 1.913021778569348394e-02,
 1.914685457195597004e-02,
 1.916345903071441092e-02,
 1.918003113743035198e-02,
 1.919657086761929199e-02,
 1.921307819685143248e-02,
 1.922955310075081040e-02,
 1.924599555499621056e-02,
 1.926240553532047872e-02,
 1.927878301751100032e-02,
 1.929512797740961030e-02,
 1.931144039091262088e-02,
 1.932772023397084926e-02,
 1.934396748258971482e-02,
 1.936018211282914889e-02,
 1.937636410080372656e-02,
 1.939251342268251410e-02,
 1.940863005468966562e-02,
 1.942471397310367373e-02,
 1.944076515425797319e-02,
 1.945678357454090970e-02,
 1.947276921039533745e-02,
 1.948872203831911870e-02,
 1.950464203486501971e-02,
 1.952052917664084952e-02,
 1.953638344030917545e-02,
 1.955220480258773250e-02,
 1.956799324024909720e-02,
 1.958374873012124276e-02,
 1.959947124908665433e-02,
 1.961516077408360925e-02,
 1.963081728210507373e-02,
 1.964644075019952169e-02,
 1.966203115547030672e-02,
 1.967758847507650524e-02,
 1.969311268623214276e-02,
 1.970860376620647489e-02,
 1.972406169232462925e-02,
 1.973948644196652641e-02,
 1.975487799256796240e-02,
 1.977023632161992520e-02,
 1.978556140666912211e-02,
 1.980085322531753567e-02,
 1.981611175522284690e-02,
 1.983133697409816820e-02,
 1.984652885971256372e-02,
 1.986168738989035551e-02,
 1.987681254251187635e-02,
 1.989190429551300487e-02,
 1.990696262688533558e-02,
 1.992198751467624124e-02,
 1.993697893698908805e-02,
 1.995193687198278457e-02,
 1.996686129787249298e-02,
 1.998175219292877558e-02,
 1.999660953547875361e-02,
 2.001143330390494496e-02,
 2.002622347664602398e-02,
 2.004098003219696028e-02,
 2.005570294910841503e-02,
 2.007039220598745913e-02,
 2.008504778149695219e-02,
 2.009966965435617745e-02,
 2.011425780334035948e-02,
 2.012881220728116038e-02,
 2.014333284506630850e-02,
 2.015781969564002171e-02,
 2.017227273800243151e-02,
 2.018669195121044688e-02,
 2.020107731437707430e-02,
 2.021542880667165712e-02,
 2.022974640732003865e-02,
 2.024403009560460029e-02,
 2.025827985086418176e-02,
 2.027249565249389721e-02,
 2.028667747994574583e-02,
 2.030082531272804636e-02,
 2.031493913040572849e-02,
 2.032901891260032248e-02,
 2.034306463899023670e-02,
 2.035707628931026497e-02,
 2.037105384335220065e-02,
 2.038499728096428501e-02,
 2.039890658205167212e-02,
 2.041278172657625886e-02,
 2.042662269455686880e-02,
 2.044042946606899197e-02,
 2.045420202124527409e-02,
 2.046794034027487469e-02,
 2.048164440340434836e-02,
 2.049531419093682943e-02,
 2.050894968323253159e-02,
 2.052255086070886234e-02,
 2.053611770384006913e-02,
 2.054965019315758631e-02,
 2.056314830924987208e-02,
 2.057661203276258191e-02,
 2.059004134439838818e-02,
 2.060343622491737220e-02,
 2.061679665513659748e-02,
 2.063012261593057117e-02,
 2.064341408823075485e-02,
 2.065667105302627926e-02,
 2.066989349136335793e-02,
 2.068308138434547111e-02,
 2.069623471313362592e-02,
 2.070935345894620375e-02,
 2.072243760305894286e-02,
 2.073548712680509457e-02,
 2.074850201157538848e-02,
 2.076148223881792154e-02,
 2.077442779003845635e-02,
 2.078733864680007773e-02,
 2.080021479072389698e-02,
 2.081305620348802149e-02,
 2.082586286682878637e-02,
 2.083863476253982466e-02,
 2.085137187247240037e-02,
 2.086407417853556115e-02,
 2.087674166269623197e-02,
 2.088937430697891326e-02,
 2.090197209346601401e-02,
 2.091453500429745274e-02,
 2.092706302167142776e-02,
 2.093955612784360876e-02,
 2.095201430512766763e-02,
 2.096443753589517789e-02,
 2.097682580257560075e-02,
 2.098917908765651416e-02,
 2.100149737368321723e-02,
 2.101378064325908415e-02,
 2.102602887904558501e-02,
 2.103824206376221639e-02,
 2.105042018018640076e-02,
 2.106256321115385424e-02,
 2.107467113955830210e-02,
 2.108674394835159671e-02,
 2.109878162054376269e-02,
 2.111078413920303848e-02,
 2.112275148745570985e-02,
 2.113468364848661296e-02,
 2.114658060553848903e-02,
 2.115844234191261580e-02,
 2.117026884096846404e-02,
 2.118206008612368366e-02,
 2.119381606085454436e-02,
 2.120553674869544644e-02,
 2.121722213323942036e-02,
 2.122887219813760634e-02,
 2.124048692709985114e-02,
 2.125206630389428475e-02,
 2.126361031234752855e-02,
 2.127511893634474391e-02,
 2.128659215982961483e-02,
 2.129802996680429591e-02,
 2.130943234132973152e-02,
 2.132079926752511456e-02,
 2.133213072956850059e-02,
 2.134342671169649902e-02,
 2.135468719820431474e-02,
 2.136591217344573426e-02,
 2.137710162183354898e-02,
 2.138825552783901740e-02,
 2.139937387599217047e-02,
 2.141045665088182892e-02,
 2.142150383715549222e-02,
 2.143251541951957453e-02,
 2.144349138273916183e-02,
 2.145443171163845947e-02,
 2.146533639110017461e-02,
 2.147620540606610604e-02,
 2.148703874153692212e-02,
 2.149783638257215038e-02,
 2.150859831429017058e-02,
 2.151932452186860675e-02,
 2.153001499054376169e-02,
 2.154066970561107491e-02,
 2.155128865242500469e-02,
 2.156187181639896561e-02,
 2.157241918300540837e-02,
 2.158293073777592733e-02,
 2.159340646630133684e-02,
 2.160384635423125144e-02,
 2.161425038727467218e-02,
 2.162461855119966053e-02,
 2.163495083183333140e-02,
 2.164524721506209948e-02,
 2.165550768683172783e-02,
 2.166573223314680052e-02,
 2.167592084007160733e-02,
 2.168607349372928331e-02,
 2.169619018030260679e-02,
 2.170627088603335753e-02,
 2.171631559722276422e-02,
 2.172632430023125824e-02,
 2.173629698147884134e-02,
 2.174623362744474223e-02,
 2.175613422466755181e-02,
 2.176599875974538287e-02,
 2.177582721933551263e-02,
 2.178561959015493793e-02,
 2.179537585897991375e-02,
 2.180509601264632100e-02,
 2.181478003804937157e-02,
 2.182442792214386168e-02,
 2.183403965194414403e-02,
 2.184361521452396135e-02,
 2.185315459701667531e-02,
 2.186265778661543313e-02,
 2.187212477057255688e-02,
 2.188155553620036234e-02,
 2.189095007087046504e-02,
 2.190030836201438749e-02,
 2.190963039712305258e-02,
 2.191891616374724849e-02,
 2.192816564949724711e-02,
 2.193737884204325153e-02,
 2.194655572911509075e-02,
 2.195569629850219542e-02,
 2.196480053805383026e-02,
 2.197386843567900039e-02,
 2.198289997934658319e-02,
 2.199189515708505419e-02,
 2.200085395698299015e-02,
 2.200977636718838212e-02,
 2.201866237590945075e-02,
 2.202751197141395237e-02,
 2.203632514202967171e-02,
 2.204510187614424840e-02,
 2.205384216220523941e-02,
 2.206254598871991782e-02,
 2.207121334425583142e-02,
 2.207984421744016781e-02,
 2.208843859696010131e-02,
 2.209699647156285890e-02,
 2.210551783005561613e-02,
 2.211400266130552836e-02,
 2.212245095423968910e-02,
 2.213086269784536944e-02,
 2.213923788116971617e-02,
 2.214757649331996342e-02,
 2.215587852346340494e-02,
 2.216414396082742877e-02,
 2.217237279469942354e-02,
 2.218056501442709078e-02,
 2.218872060941794871e-02,
 2.219683956913982500e-02,
 2.220492188312059301e-02,
 2.221296754094833834e-02,
 2.222097653227128253e-02,
 2.222894884679782815e-02,
 2.223688447429644777e-02,
 2.224478340459600662e-02,
 2.225264562758550238e-02,
 2.226047113321401663e-02,
 2.226825991149101319e-02,
 2.227601195248615773e-02,
 2.228372724632941143e-02,
 2.229140578321092692e-02,
 2.229904755338120090e-02,
 2.230665254715088336e-02,
 2.231422075489113838e-02,
 2.232175216703324513e-02,
 2.232924677406898997e-02,
 2.233670456655025005e-02,
 2.234412553508953458e-02,
 2.235150967035948177e-02,
 2.235885696309321616e-02,
 2.236616740408414739e-02,
 2.237344098418608818e-02,
 2.238067769431345902e-02,
 2.238787752544070878e-02,
 2.239504046860306755e-02,
 2.240216651489594993e-02,
 2.240925565547530196e-02,
 2.241630788155742071e-02,
 2.242332318441930469e-02,
 2.243030155539818896e-02,
 2.243724298589178795e-02,
 2.244414746735846553e-02,
 2.245101499131701636e-02,
 2.245784554934657229e-02,
 2.246463913308700475e-02,
 2.247139573423854661e-02,
 2.247811534456215302e-02,
 2.248479795587909197e-02,
 2.249144356007138496e-02,
 2.249805214908147388e-02,
 2.250462371491236332e-02,
 2.251115824962775930e-02,
 2.251765574535185416e-02,
 2.252411619426942027e-02,
 2.253053958862590370e-02,
 2.253692592072729234e-02,
 2.254327518294019922e-02,
 2.254958736769194921e-02,
 2.255586246747031884e-02,
 2.256210047482393871e-02,
 2.256830138236189456e-02,
 2.257446518275416439e-02,
 2.258059186873107027e-02,
 2.258668143308381962e-02,
 2.259273386866432129e-02,
 2.259874916838503639e-02,
 2.260472732521914482e-02,
 2.261066833220063896e-02,
 2.261657218242408771e-02,
 2.262243886904488285e-02,
 2.262826838527898926e-02,
 2.263406072440317038e-02,
 2.263981587975505763e-02,
 2.264553384473274450e-02,
 2.265121461279523754e-02,
 2.265685817746240435e-02,
 2.266246453231461622e-02,
 2.266803367099309852e-02,
 2.267356558719993420e-02,
 2.267906027469793195e-02,
 2.268451772731060537e-02,
 2.268993793892231173e-02,
 2.269532090347825201e-02,
 2.270066661498437374e-02,
 2.270597506750731895e-02,
 2.271124625517478152e-02,
 2.271648017217502147e-02,
 2.272167681275724660e-02,
 2.272683617123144595e-02,
 2.273195824196844878e-02,
 2.273704301939985864e-02,
 2.274209049801828933e-02,
 2.274710067237689995e-02,
 2.275207353708998473e-02,
 2.275700908683253240e-02,
 2.276190731634040315e-02,
 2.276676822041031820e-02,
 2.277159179389989449e-02,
 2.277637803172744002e-02,
 2.278112692887248464e-02,
 2.278583848037509310e-02,
 2.279051268133637162e-02,
 2.279514952691817989e-02,
 2.279974901234339130e-02,
 2.280431113289583048e-02,
 2.280883588391989167e-02,
 2.281332326082122913e-02,
 2.281777325906610837e-02,
 2.282218587418185715e-02,
 2.282656110175666775e-02,
 2.283089893743963164e-02,
 2.283519937694062849e-02,
 2.283946241603067653e-02,
 2.284368805054151283e-02,
 2.284787627636588464e-02,
 2.285202708945739333e-02,
 2.285614048583061580e-02,
 2.286021646156104897e-02,
 2.286425501278496059e-02,
 2.286825613569976393e-02,
 2.287221982656365352e-02,
 2.287614608169580288e-02,
 2.288003489747629168e-02,
 2.288388627034612308e-02,
 2.288770019680726880e-02,
 2.289147667342250961e-02,
 2.289521569681580646e-02,
 2.289891726367178706e-02,
 2.290258137073609632e-02,
 2.290620801481545871e-02,
 2.290979719277731405e-02,
 2.291334890155018178e-02,
 2.291686313812348746e-02,
 2.292033989954760792e-02,
 2.292377918293377406e-02,
 2.292718098545423397e-02,
 2.293054530434215227e-02,
 2.293387213689161014e-02,
 2.293716148045772674e-02,
 2.294041333245638858e-02,
 2.294362769036459998e-02,
 2.294680455172008748e-02,
 2.294994391412174747e-02,
 2.295304577522926798e-02,
 2.295611013276330561e-02,
 2.295913698450549600e-02,
 2.296212632829828029e-02,
 2.296507816204521393e-02,
 2.296799248371061974e-02,
 2.297086929131982383e-02,
 2.297370858295908619e-02,
 2.297651035677561113e-02,
 2.297927461097742236e-02,
 2.298200134383368912e-02,
 2.298469055367421965e-02,
 2.298734223888994690e-02,
 2.298995639793270651e-02,
 2.299253302931505635e-02,
 2.299507213161082822e-02,
 2.299757370345440616e-02,
 2.300003774354135444e-02,
 2.300246425062794225e-02,
 2.300485322353138309e-02,
 2.300720466112997353e-02,
 2.300951856236274282e-02,
 2.301179492622967143e-02,
 2.301403375179151070e-02,
 2.301623503817011238e-02,
 2.301839878454810598e-02,
 2.302052499016903758e-02,
 2.302261365433724838e-02,
 2.302466477641816264e-02,
 2.302667835583782976e-02,
 2.302865439208336140e-02,
 2.303059288470261576e-02,
 2.303249383330437799e-02,
 2.303435723755836717e-02,
 2.303618309719496562e-02,
 2.303797141200560061e-02,
 2.303972218184241819e-02,
 2.304143540661857809e-02,
 2.304311108630780272e-02,
 2.304474922094490799e-02,
 2.304634981062547369e-02,
 2.304791285550581922e-02,
 2.304943835580319789e-02,
 2.305092631179560952e-02,
 2.305237672382188727e-02,
 2.305378959228169752e-02,
 2.305516491763547407e-02,
 2.305650270040450478e-02,
 2.305780294117078938e-02,
 2.305906564057714353e-02,
 2.306029079932721271e-02,
 2.306147841818538893e-02,
 2.306262849797677608e-02,
 2.306374103958728355e-02,
 2.306481604396372342e-02,
 2.306585351211341492e-02,
 2.306685344510452443e-02,
 2.306781584406606203e-02,
 2.306874071018758660e-02,
 2.306962804471957007e-02,
 2.307047784897300891e-02,
 2.307129012431986814e-02,
 2.307206487219258181e-02,
 2.307280209408438254e-02,
 2.307350179154921826e-02,
 2.307416396620166552e-02,
 2.307478861971704043e-02,
 2.307537575383133630e-02,
 2.307592537034123398e-02,
 2.307643747110385210e-02,
 2.307691205803734727e-02,
 2.307734913312019243e-02,
 2.307774869839157236e-02,
 2.307811075595141842e-02,
 2.307843530796019685e-02,
 2.307872235663896432e-02,
 2.307897190426950323e-02,
 2.307918395319401642e-02,
 2.307935850581535261e-02,
 2.307949556459705856e-02,
 2.307959513206312221e-02,
 2.307965721079814625e-02,
 2.307968180344731335e-02,
 2.307966891271629947e-02,
 2.307961854137130508e-02,
 2.307953069223914189e-02,
 2.307940536820701424e-02,
 2.307924257222280368e-02,
 2.307904230729483641e-02,
 2.307880457649171338e-02,
 2.307852938294293124e-02,
 2.307821672983804973e-02,
 2.307786662042737164e-02,
 2.307747905802151958e-02,
 2.307705404599163027e-02,
 2.307659158776918448e-02,
 2.307609168684622916e-02,
 2.307555434677504430e-02,
 2.307497957116846563e-02,
 2.307436736369964173e-02,
 2.307371772810215202e-02,
 2.307303066816995124e-02,
 2.307230618775722372e-02,
 2.307154429077874422e-02,
 2.307074498120940606e-02,
 2.306990826308457504e-02,
 2.306903414049990206e-02,
 2.306812261761122251e-02,
 2.306717369863491712e-02,
 2.306618738784741579e-02,
 2.306516368958556190e-02,
 2.306410260824637293e-02,
 2.306300414828724860e-02,
 2.306186831422563435e-02,
 2.306069511063942382e-02,
 2.305948454216656326e-02,
 2.305823661350525980e-02,
 2.305695132941382869e-02,
 2.305562869471103338e-02,
 2.305426871427543670e-02,
 2.305287139304608435e-02,
 2.305143673602198795e-02,
 2.304996474826224648e-02,
 2.304845543488619891e-02,
 2.304690880107327852e-02,
 2.304532485206295389e-02,
 2.304370359315478095e-02,
 2.304204502970847585e-02,
 2.304034916714362002e-02,
 2.303861601094005229e-02,
 2.303684556663752186e-02,
 2.303503783983578898e-02,
 2.303319283619459715e-02,
 2.303131056143383620e-02,
 2.302939102133315374e-02,
 2.302743422173222226e-02,
 2.302544016853079120e-02,
 2.302340886768840245e-02,
 2.302134032522451523e-02,
 2.301923454721862411e-02,
 2.301709153980993280e-02,
 2.301491130919766301e-02,
 2.301269386164084274e-02,
 2.301043920345834798e-02,
 2.300814734102893042e-02,
 2.300581828079108562e-02,
 2.300345202924315713e-02,
 2.300104859294321152e-02,
 2.299860797850924662e-02,
 2.299613019261880983e-02,
 2.299361524200937285e-02,
 2.299106313347804714e-02,
 2.298847387388167421e-02,
 2.298584747013675614e-02,
 2.298318392921949727e-02,
 2.298048325816582152e-02,
 2.297774546407124752e-02,
 2.297497055409093367e-02,
 2.297215853543965042e-02,
 2.296930941539176638e-02,
 2.296642320128137321e-02,
 2.296349990050181381e-02,
 2.296053952050634839e-02,
 2.295754206880745718e-02,
 2.295450755297747530e-02,
 2.295143598064793358e-02,
 2.294832735950996447e-02,
 2.294518169731428817e-02,
 2.294199900187085181e-02,
 2.293877928104921457e-02,
 2.293552254277829786e-02,
 2.293222879504641307e-02,
 2.292889804590126160e-02,
 2.292553030345003198e-02,
 2.292212557585896968e-02,
 2.291868387135399462e-02,
 2.291520519822010798e-02,
 2.291168956480170785e-02,
 2.290813697950237413e-02,
 2.290454745078514959e-02,
 2.290092098717214433e-02,
 2.289725759724470233e-02,
 2.289355728964347428e-02,
 2.288982007306818167e-02,
 2.288604595627781804e-02,
 2.288223494809052058e-02,
 2.287838705738347647e-02,
 2.287450229309302349e-02,
 2.287058066421470554e-02,
 2.286662217980290485e-02,
 2.286262684897137978e-02,
 2.285859468089259869e-02,
 2.285452568479830540e-02,
 2.285041986997916538e-02,
 2.284627724578469979e-02,
 2.284209782162359773e-02,
 2.283788160696333114e-02,
 2.283362861133043584e-02,
 2.282933884431010904e-02,
 2.282501231554683388e-02,
 2.282064903474353632e-02,
 2.281624901166223046e-02,
 2.281181225612363694e-02,
 2.280733877800743964e-02,
 2.280282858725193873e-02,
 2.279828169385419989e-02,
 2.279369810787023123e-02,
 2.278907783941447676e-02,
 2.278442089866032985e-02,
 2.277972729583972386e-02,
 2.277499704124327437e-02,
 2.277023014522027225e-02,
 2.276542661817862814e-02,
 2.276058647058474063e-02,
 2.275570971296375644e-02,
 2.275079635589920962e-02,
 2.274584641003338931e-02,
 2.274085988606674297e-02,
 2.273583679475855296e-02,
 2.273077714692643345e-02,
 2.272568095344641020e-02,
 2.272054822525295878e-02,
 2.271537897333902531e-02,
 2.271017320875579060e-02,
 2.270493094261293379e-02,
 2.269965218607844157e-02,
 2.269433695037850404e-02,
 2.268898524679781661e-02,
 2.268359708667911853e-02,
 2.267817248142353290e-02,
 2.267271144249025094e-02,
 2.266721398139692409e-02,
 2.266168010971915739e-02,
 2.265610983909084261e-02,
 2.265050318120394313e-02,
 2.264486014780854942e-02,
 2.263918075071270214e-02,
 2.263346500178277376e-02,
 2.262771291294295162e-02,
 2.262192449617552586e-02,
 2.261609976352079582e-02,
 2.261023872707701443e-02,
 2.260434139900030504e-02,
 2.259840779150485215e-02,
 2.259243791686254416e-02,
 2.258643178740336183e-02,
 2.258038941551494469e-02,
 2.257431081364291020e-02,
 2.256819599429057271e-02,
 2.256204497001901982e-02,
 2.255585775344708457e-02,
 2.254963435725148430e-02,
 2.254337479416640422e-02,
 2.253707907698384097e-02,
 2.253074721855350196e-02,
 2.252437923178252782e-02,
 2.251797512963580813e-02,
 2.251153492513580448e-02,
 2.250505863136238044e-02,
 2.249854626145312772e-02,
 2.249199782860307473e-02,
 2.248541334606459288e-02,
 2.247879282714775745e-02,
 2.247213628521978548e-02,
 2.246544373370548339e-02,
 2.245871518608693468e-02,
 2.245195065590356240e-02,
 2.244515015675227834e-02,
 2.243831370228707017e-02,
 2.243144130621934143e-02,
 2.242453298231759581e-02,
 2.241758874440766963e-02,
 2.241060860637248200e-02,
 2.240359258215231589e-02,
 2.239654068574426643e-02,
 2.238945293120294874e-02,
 2.238232933263959237e-02,
 2.237516990422296417e-02,
 2.236797466017838992e-02,
 2.236074361478850719e-02,
 2.235347678239283167e-02,
 2.234617417738790288e-02,
 2.233883581422695455e-02,
 2.233146170742033448e-02,
 2.232405187153523735e-02,
 2.231660632119552429e-02,
 2.230912507108199702e-02,
 2.230160813593218272e-02,
 2.229405553054051789e-02,
 2.228646726975788347e-02,
 2.227884336849202118e-02,
 2.227118384170735654e-02,
 2.226348870442487055e-02,
 2.225575797172228004e-02,
 2.224799165873378101e-02,
 2.224018978065004509e-02,
 2.223235235271853183e-02,
 2.222447939024282254e-02,
 2.221657090858331074e-02,
 2.220862692315658110e-02,
 2.220064744943582580e-02,
 2.219263250295057735e-02,
 2.218458209928644842e-02,
 2.217649625408583264e-02,
 2.216837498304697479e-02,
 2.216021830192465084e-02,
 2.215202622652974115e-02,
 2.214379877272947689e-02,
 2.213553595644708952e-02,
 2.212723779366208496e-02,
 2.211890430040994518e-02,
 2.211053549278241270e-02,
 2.210213138692700488e-02,
 2.209369199904762451e-02,
 2.208521734540387291e-02,
 2.207670744231158416e-02,
 2.206816230614213475e-02,
 2.205958195332314783e-02,
 2.205096640033804914e-02,
 2.204231566372586576e-02,
 2.203362976008177432e-02,
 2.202490870605654932e-02,
 2.201615251835676093e-02,
 2.200736121374452167e-02,
 2.199853480903803463e-02,
 2.198967332111062892e-02,
 2.198077676689165136e-02,
 2.197184516336588359e-02,
 2.196287852757378145e-02,
 2.195387687661113849e-02,
 2.194484022762934264e-02,
 2.193576859783530342e-02,
 2.192666200449133393e-02,
 2.191752046491499475e-02,
 2.190834399647937497e-02,
 2.189913261661299848e-02,
 2.188988634279940074e-02,
 2.188060519257762834e-02,
 2.187128918354176374e-02,
 2.186193833334143174e-02,
 2.185255265968097382e-02,
 2.184313218032031892e-02,
 2.183367691307412303e-02,
 2.182418687581244576e-02,
 2.181466208646009458e-02,
 2.180510256299717994e-02,
 2.179550832345844569e-02,
 2.178587938593386231e-02,
 2.177621576856824878e-02,
 2.176651748956133850e-02,
 2.175678456716744619e-02,
 2.174701701969600220e-02,
 2.173721486551107029e-02,
 2.172737812303151758e-02,
 2.171750681073086192e-02,
 2.170760094713724761e-02,
 2.169766055083370559e-02,
 2.168768564045749775e-02,
 2.167767623470086280e-02,
 2.166763235231021142e-02,
 2.165755401208665706e-02,
 2.164744123288576266e-02,
 2.163729403361762393e-02,
 2.162711243324642180e-02,
 2.161689645079110239e-02,
 2.160664610532454788e-02,
 2.159636141597435013e-02,
 2.158604240192196766e-02,
 2.157568908240335703e-02,
 2.156530147670848371e-02,
 2.155487960418178348e-02,
 2.154442348422136444e-02,
 2.153393313627965239e-02,
 2.152340857986324157e-02,
 2.151284983453254779e-02,
 2.150225691990208937e-02,
 2.149162985564019926e-02,
 2.148096866146925049e-02,
 2.147027335716541682e-02,
 2.145954396255873170e-02,
 2.144878049753293908e-02,
 2.143798298202569466e-02,
 2.142715143602831260e-02,
 2.141628587958586960e-02,
 2.140538633279691003e-02,
 2.139445281581377201e-02,
 2.138348534884232724e-02,
 2.137248395214196711e-02,
 2.136144864602549862e-02,
 2.135037945085958844e-02,
 2.133927638706384355e-02,
 2.132813947511158839e-02,
 2.131696873552934440e-02,
 2.130576418889699314e-02,
 2.129452585584782134e-02,
 2.128325375706824341e-02,
 2.127194791329802687e-02,
 2.126060834532982752e-02,
 2.124923507400970635e-02,
 2.123782812023676178e-02,
 2.122638750496311580e-02,
 2.121491324919385496e-02,
 2.120340537398721428e-02,
 2.119186390045424070e-02,
 2.118028884975909840e-02,
 2.116868024311843385e-02,
 2.115703810180216693e-02,
 2.114536244713263735e-02,
 2.113365330048520493e-02,
 2.112191068328795121e-02,
 2.111013461702134289e-02,
 2.109832512321887718e-02,
 2.108648222346641218e-02,
 2.107460593940241669e-02,
 2.106269629271786611e-02,
 2.105075330515630144e-02,
 2.103877699851368355e-02,
 2.102676739463843480e-02,
 2.101472451543113726e-02,
 2.100264838284494201e-02,
 2.099053901888518064e-02,
 2.097839644560939298e-02,
 2.096622068512747974e-02,
 2.095401175960149090e-02,
 2.094176969124534465e-02,
 2.092949450232546582e-02,
 2.091718621516000520e-02,
 2.090484485211919694e-02,
 2.089247043562544523e-02,
 2.088006298815279355e-02,
 2.086762253222752481e-02,
 2.085514909042736689e-02,
 2.084264268538221429e-02,
 2.083010333977351400e-02,
 2.081753107633460900e-02,
 2.080492591785035664e-02,
 2.079228788715738185e-02,
 2.077961700714393845e-02,
 2.076691330074982578e-02,
 2.075417679096628470e-02,
 2.074140750083620227e-02,
 2.072860545345371619e-02,
 2.071577067196457567e-02,
 2.070290317956580486e-02,
 2.069000299950565780e-02,
 2.067707015508387855e-02,
 2.066410466965120513e-02,
 2.065110656660985866e-02,
 2.063807586941287728e-02,
 2.062501260156470589e-02,
 2.061191678662075213e-02,
 2.059878844818753552e-02,
 2.058562760992232316e-02,
 2.057243429553369876e-02,
 2.055920852878076466e-02,
 2.054595033347372118e-02,
 2.053265973347364812e-02,
 2.051933675269233814e-02,
 2.050598141509207481e-02,
 2.049259374468629172e-02,
 2.047917376553860802e-02,
 2.046572150176367497e-02,
 2.045223697752635711e-02,
 2.043872021704223885e-02,
 2.042517124457751687e-02,
 2.041159008444841383e-02,
 2.039797676102200752e-02,
 2.038433129871526986e-02,
 2.037065372199596894e-02,
 2.035694405538172533e-02,
 2.034320232344062965e-02,
 2.032942855079084357e-02,
 2.031562276210077678e-02,
 2.030178498208870530e-02,
 2.028791523552331971e-02,
 2.027401354722284735e-02,
 2.026007994205585375e-02,
 2.024611444494068407e-02,
 2.023211708084565741e-02,
 2.021808787478868163e-02,
 2.020402685183763508e-02,
 2.018993403711021040e-02,
 2.017580945577352250e-02,
 2.016165313304457349e-02,
 2.014746509418989875e-02,
 2.013324536452577168e-02,
 2.011899396941755833e-02,
 2.010471093428055009e-02,
 2.009039628457912063e-02,
 2.007605004582731223e-02,
 2.006167224358825288e-02,
 2.004726290347474613e-02,
 2.003282205114831002e-02,
 2.001834971232015897e-02,
 2.000384591275026006e-02,
 1.998931067824814140e-02,
 1.997474403467190338e-02,
 1.996014600792902355e-02,
 1.994551662397592989e-02,
 1.993085590881782387e-02,
 1.991616388850897534e-02,
 1.990144058915218478e-02,
 1.988668603689952921e-02,
 1.987190025795125894e-02,
 1.985708327855700145e-02,
 1.984223512501442563e-02,
 1.982735582367021673e-02,
 1.981244540091934084e-02,
 1.979750388320557566e-02,
 1.978253129702080282e-02,
 1.976752766890568780e-02,
 1.975249302544912142e-02,
 1.973742739328840021e-02,
 1.972233079910891071e-02,
 1.970720326964457356e-02,
 1.969204483167721551e-02,
 1.967685551203693373e-02,
 1.966163533760196397e-02,
 1.964638433529857300e-02,
 1.963110253210115577e-02,
 1.961578995503169415e-02,
 1.960044663116052716e-02,
 1.958507258760548708e-02,
 1.956966785153247887e-02,
 1.955423245015509848e-02,
 1.953876641073473350e-02,
 1.952326976058017804e-02,
 1.950774252704822603e-02,
 1.949218473754288014e-02,
 1.947659641951603529e-02,
 1.946097760046679517e-02,
 1.944532830794179143e-02,
 1.942964856953519406e-02,
 1.941393841288817368e-02,
 1.939819786568957108e-02,
 1.938242695567507848e-02,
 1.936662571062804095e-02,
 1.935079415837843292e-02,
 1.933493232680385740e-02,
 1.931904024382859533e-02,
 1.930311793742403928e-02,
 1.928716543560846444e-02,
 1.927118276644726458e-02,
 1.925516995805241077e-02,
 1.923912703858281573e-02,
 1.922305403624426090e-02,
 1.920695097928909120e-02,
 1.919081789601622887e-02,
 1.917465481477148917e-02,
 1.915846176394690736e-02,
 1.914223877198132154e-02,
 1.912598586735976200e-02,
 1.910970307861390230e-02,
 1.909339043432179903e-02,
 1.907704796310752751e-02,
 1.906067569364176123e-02,
 1.904427365464113689e-02,
 1.902784187486860484e-02,
 1.901138038313314807e-02,
 1.899488920828997993e-02,
 1.897836837923997863e-02,
 1.896181792493043319e-02,
 1.894523787435413789e-02,
 1.892862825655007228e-02,
 1.891198910060268648e-02,
 1.889532043564254651e-02,
 1.887862229084574447e-02,
 1.886189469543416916e-02,
 1.884513767867510362e-02,
 1.882835126988141594e-02,
 1.881153549841179523e-02,
 1.879469039366988767e-02,
 1.877781598510537206e-02,
 1.876091230221263104e-02,
 1.874397937453189597e-02,
 1.872701723164825471e-02,
 1.871002590319229691e-02,
 1.869300541883946870e-02,
 1.867595580831059657e-02,
 1.865887710137137043e-02,
 1.864176932783276341e-02,
 1.862463251755018187e-02,
 1.860746670042446801e-02,
 1.859027190640086605e-02,
 1.857304816546980972e-02,
 1.855579550766598904e-02,
 1.853851396306944316e-02,
 1.852120356180436689e-02,
 1.850386433403938824e-02,
 1.848649630998825885e-02,
 1.846909951990860152e-02,
 1.845167399410293022e-02,
 1.843421976291789027e-02,
 1.841673685674461575e-02,
 1.839922530601820205e-02,
 1.838168514121845537e-02,
 1.836411639286871650e-02,
 1.834651909153705088e-02,
 1.832889326783516959e-02,
 1.831123895241900182e-02,
 1.829355617598837219e-02,
 1.827584496928708405e-02,
 1.825810536310254473e-02,
 1.824033738826633805e-02,
 1.822254107565334652e-02,
 1.820471645618254239e-02,
 1.818686356081639435e-02,
 1.816898242056074267e-02,
 1.815107306646542712e-02,
 1.813313552962319414e-02,
 1.811516984117076540e-02,
 1.809717603228774147e-02,
 1.807915413419736855e-02,
 1.806110417816612565e-02,
 1.804302619550361350e-02,
 1.802492021756252685e-02,
 1.800678627573888343e-02,
 1.798862440147144803e-02,
 1.797043462624230148e-02,
 1.795221698157601492e-02,
 1.793397149904077392e-02,
 1.791569821024679987e-02,
 1.789739714684768571e-02,
 1.787906834053945224e-02,
 1.786071182306063487e-02,
 1.784232762619277629e-02,
 1.782391578175976377e-02,
 1.780547632162817959e-02,
 1.778700927770664186e-02,
 1.776851468194661637e-02,
 1.774999256634154920e-02,
 1.773144296292752942e-02,
 1.771286590378249107e-02,
 1.769426142102684119e-02,
 1.767562954682301568e-02,
 1.765697031337555567e-02,
 1.763828375293083686e-02,
 1.761956989777748936e-02,
 1.760082878024565520e-02,
 1.758206043270766489e-02,
 1.756326488757761067e-02,
 1.754444217731100999e-02,
 1.752559233440547162e-02,
 1.750671539139985605e-02,
 1.748781138087491735e-02,
 1.746888033545260580e-02,
 1.744992228779654667e-02,
 1.743093727061174533e-02,
 1.741192531664459073e-02,
 1.739288645868245289e-02,
 1.737382072955442197e-02,
 1.735472816213026737e-02,
 1.733560878932123919e-02,
 1.731646264407947153e-02,
 1.729728975939832936e-02,
 1.727809016831172162e-02,
 1.725886390389488184e-02,
 1.723961099926347995e-02,
 1.722033148757443066e-02,
 1.720102540202488386e-02,
 1.718169277585299831e-02,
 1.716233364233753916e-02,
 1.714294803479752757e-02,
 1.712353598659285478e-02,
 1.710409753112351536e-02,
 1.708463270183022131e-02,
 1.706514153219368737e-02,
 1.704562405573510631e-02,
 1.702608030601582625e-02,
 1.700651031663750340e-02,
 1.698691412124149827e-02,
 1.696729175350962515e-02,
 1.694764324716341308e-02,
 1.692796863596445281e-02,
 1.690826795371413657e-02,
 1.688854123425387321e-02,
 1.686878851146451572e-02,
 1.684900981926659713e-02,
 1.682920519162070180e-02,
 1.680937466252650780e-02,
 1.678951826602357103e-02,
 1.676963603619068682e-02,
 1.674972800714633059e-02,
 1.672979421304789105e-02,
 1.670983468809253761e-02,
 1.668984946651619686e-02,
 1.666983858259430545e-02,
 1.664980207064135215e-02,
 1.662973996501090554e-02,
 1.660965230009527061e-02,
 1.658953911032610279e-02,
 1.656940043017353023e-02,
 1.654923629414686501e-02,
 1.652904673679387454e-02,
 1.650883179270125345e-02,
 1.648859149649434253e-02,
 1.646832588283682342e-02,
 1.644803498643128761e-02,
 1.642771884201829277e-02,
 1.640737748437741395e-02,
 1.638701094832601540e-02,
 1.636661926872009371e-02,
 1.634620248045382321e-02,
 1.632576061845955606e-02,
 1.630529371770758629e-02,
 1.628480181320658693e-02,
 1.626428494000278085e-02,
 1.624374313318076302e-02,
 1.622317642786278921e-02,
 1.620258485920907099e-02,
 1.618196846241726564e-02,
 1.616132727272316313e-02,
 1.614066132539987777e-02,
 1.611997065575807714e-02,
 1.609925529914615211e-02,
 1.607851529094991502e-02,
 1.605775066659260661e-02,
 1.603696146153449700e-02,
 1.601614771127362821e-02,
 1.599530945134472817e-02,
 1.597444671732011628e-02,
 1.595355954480903379e-02,
 1.593264796945784850e-02,
 1.591171202694967313e-02,
 1.589075175300490653e-02,
 1.586976718338029696e-02,
 1.584875835387002455e-02,
 1.582772530030438288e-02,
 1.580666805855074006e-02,
 1.578558666451307033e-02,
 1.576448115413161752e-02,
 1.574335156338343630e-02,
 1.572219792828173646e-02,
 1.570102028487643103e-02,
 1.567981866925318227e-02,
 1.565859311753475119e-02,
 1.563734366587923863e-02,
 1.561607035048148857e-02,
 1.559477320757194675e-02,
 1.557345227341743431e-02,
 1.555210758432038799e-02,
 1.553073917661937711e-02,
 1.550934708668875832e-02,
 1.548793135093864091e-02,
 1.546649200581462491e-02,
 1.544502908779827634e-02,
 1.542354263340638305e-02,
 1.540203267919165384e-02,
 1.538049926174182500e-02,
 1.535894241768024325e-02,
 1.533736218366577378e-02,
 1.531575859639203868e-02,
 1.529413169258847342e-02,
 1.527248150901904487e-02,
 1.525080808248320714e-02,
 1.522911144981533085e-02,
 1.520739164788487661e-02,
 1.518564871359582603e-02,
 1.516388268388741203e-02,
 1.514209359573321159e-02,
 1.512028148614199749e-02,
 1.509844639215664544e-02,
 1.507658835085508818e-02,
 1.505470739934953311e-02,
 1.503280357478683008e-02,
 1.501087691434795091e-02,
 1.498892745524823926e-02,
 1.496695523473761703e-02,
 1.494496029009963721e-02,
 1.492294265865284908e-02,
 1.490090237774903230e-02,
 1.487883948477457252e-02,
 1.485675401714931128e-02,
 1.483464601232753650e-02,
 1.481251550779679078e-02,
 1.479036254107879249e-02,
 1.476818714972883209e-02,
 1.474598937133600289e-02,
 1.472376924352249497e-02,
 1.470152680394459614e-02,
 1.467926209029154529e-02,
 1.465697514028640319e-02,
 1.463466599168517304e-02,
 1.461233468227730002e-02,
 1.458998124988560366e-02,
 1.456760573236555271e-02,
 1.454520816760626438e-02,
 1.452278859352927262e-02,
 1.450034704808950137e-02,
 1.447788356927454806e-02,
 1.445539819510502366e-02,
 1.443289096363386918e-02,
 1.441036191294724732e-02,
 1.438781108116337672e-02,
 1.436523850643361098e-02,
 1.434264422694122090e-02,
 1.432002828090231730e-02,
 1.429739070656523697e-02,
 1.427473154221078552e-02,
 1.425205082615159033e-02,
 1.422934859673293494e-02,
 1.420662489233171476e-02,
 1.418387975135729055e-02,
 1.416111321225095761e-02,
 1.413832531348556409e-02,
 1.411551609356625873e-02,
 1.409268559102958007e-02,
 1.406983384444418159e-02,
 1.404696089240994004e-02,
 1.402406677355861296e-02,
 1.400115152655350900e-02,
 1.397821519008930410e-02,
 1.395525780289194433e-02,
 1.393227940371896331e-02,
 1.390928003135888553e-02,
 1.388625972463172938e-02,
 1.386321852238820394e-02,
 1.384015646351081756e-02,
 1.381707358691231652e-02,
 1.379396993153693927e-02,
 1.377084553635944328e-02,
 1.374770044038541895e-02,
 1.372453468265145624e-02,
 1.370134830222464149e-02,
 1.367814133820284724e-02,
 1.365491382971411281e-02,
 1.363166581591743545e-02,
 1.360839733600176238e-02,
 1.358510842918687553e-02,
 1.356179913472233857e-02,
 1.353846949188828620e-02,
 1.351511953999496793e-02,
 1.349174931838272549e-02,
 1.346835886642164422e-02,
 1.344494822351223647e-02,
 1.342151742908436439e-02,
 1.339806652259816107e-02,
 1.337459554354347366e-02,
 1.335110453143945573e-02,
 1.332759352583540689e-02,
 1.330406256630967468e-02,
 1.328051169247065379e-02,
 1.325694094395558735e-02,
 1.323335036043149504e-02,
 1.320973998159456937e-02,
 1.318610984717032315e-02,
 1.316245999691313152e-02,
 1.313879047060689635e-02,
 1.311510130806403142e-02,
 1.309139254912647723e-02,
 1.306766423366443469e-02,
 1.304391640157778406e-02,
 1.302014909279427743e-02,
 1.299636234727105481e-02,
 1.297255620499332580e-02,
 1.294873070597538089e-02,
 1.292488589025949340e-02,
 1.290102179791675734e-02,
 1.287713846904663811e-02,
 1.285323594377649550e-02,
 1.282931426226247180e-02,
 1.280537346468826367e-02,
 1.278141359126627220e-02,
 1.275743468223633319e-02,
 1.273343677786671450e-02,
 1.270941991845338757e-02,
 1.268538414432030491e-02,
 1.266132949581874091e-02,
 1.263725601332824078e-02,
 1.261316373725545996e-02,
 1.258905270803489275e-02,
 1.256492296612850626e-02,
 1.254077455202580113e-02,
 1.251660750624332581e-02,
 1.249242186932494024e-02,
 1.246821768184209686e-02,
 1.244399498439294031e-02,
 1.241975381760299091e-02,
 1.239549422212475605e-02,
 1.237121623863774063e-02,
 1.234691990784795440e-02,
 1.232260527048881053e-02,
 1.229827236731984713e-02,
 1.227392123912770389e-02,
 1.224955192672557217e-02,
 1.222516447095316552e-02,
 1.220075891267640225e-02,
 1.217633529278811313e-02,
 1.215189365220690695e-02,
 1.212743403187814539e-02,
 1.210295647277296986e-02,
 1.207846101588897110e-02,
 1.205394770224984917e-02,
 1.202941657290483753e-02,
 1.200486766892970396e-02,
 1.198030103142549811e-02,
 1.195571670151959927e-02,
 1.193111472036459050e-02,
 1.190649512913910003e-02,
 1.188185796904718886e-02,
 1.185720328131859361e-02,
 1.183253110720809166e-02,
 1.180784148799637542e-02,
 1.178313446498889007e-02,
 1.175841007951674427e-02,
 1.173366837293610999e-02,
 1.170890938662835605e-02,
 1.168413316199949821e-02,
 1.165933974048107523e-02,
 1.163452916352907505e-02,
 1.160970147262438065e-02,
 1.158485670927284460e-02,
 1.155999491500489008e-02,
 1.153511613137573819e-02,
 1.151022039996470528e-02,
 1.148530776237618317e-02,
 1.146037826023835540e-02,
 1.143543193520426063e-02,
 1.141046882895097210e-02,
 1.138548898318003655e-02,
 1.136049243961661896e-02,
 1.133547924001053649e-02,
 1.131044942613505105e-02,
 1.128540303978795012e-02,
 1.126034012279025429e-02,
 1.123526071698724600e-02,
 1.121016486424792659e-02,
 1.118505260646449409e-02,
 1.115992398555333553e-02,
 1.113477904345375885e-02,
 1.110961782212908054e-02,
 1.108444036356546689e-02,
 1.105924670977277702e-02,
 1.103403690278393669e-02,
 1.100881098465522276e-02,
 1.098356899746559708e-02,
 1.095831098331757902e-02,
 1.093303698433606072e-02,
 1.090774704266929407e-02,
 1.088244120048820207e-02,
 1.085711949998654190e-02,
 1.083178198338035844e-02,
 1.080642869290888812e-02,
 1.078105967083332374e-02,
 1.075567495943786402e-02,
 1.073027460102858599e-02,
 1.070485863793426556e-02,
 1.067942711250599586e-02,
 1.065398006711654362e-02,
 1.062851754416146120e-02,
 1.060303958605769183e-02,
 1.057754623524465205e-02,
 1.055203753418347892e-02,
 1.052651352535729015e-02,
 1.050097425127053882e-02,
 1.047541975444995534e-02,
 1.044985007744332964e-02,
 1.042426526282054164e-02,
 1.039866535317245620e-02,
 1.037305039111166213e-02,
 1.034742041927205758e-02,
 1.032177548030890207e-02,
 1.029611561689840367e-02,
 1.027044087173782129e-02,
 1.024475128754600423e-02,
 1.021904690706203732e-02,
 1.019332777304688027e-02,
 1.016759392828137619e-02,
 1.014184541556791518e-02,
 1.011608227772891819e-02,
 1.009030455760807216e-02,
 1.006451229806904803e-02,
 1.003870554199646527e-02,
 1.001288433229516849e-02,
 9.987048711890503250e-03,
 9.961198723727736695e-03,
 9.935334410772860697e-03,
 9.909455816011408791e-03,
 9.883562982449620171e-03,
 9.857655953113095282e-03,
 9.831734771047848792e-03,
 9.805799479319730200e-03,
 9.779850121013938108e-03,
 9.753886739235925751e-03,
 9.727909377110242201e-03,
 9.701918077781470848e-03,
 9.675912884413480006e-03,
 9.649893840189771588e-03,
 9.623860988312726503e-03,
 9.597814372004626407e-03,
 9.571754034506366540e-03,
 9.545680019078553805e-03,
 9.519592369000290724e-03,
 9.493491127570136481e-03,
 9.467376338105425171e-03,
 9.441248043942470497e-03,
 9.415106288435951681e-03,
 9.388951114959846744e-03,
 9.362782566906313608e-03,
 9.336600687685998878e-03,
 9.310405520728827142e-03,
 9.284197109482203794e-03,
 9.257975497412597107e-03,
 9.231740728004159124e-03,
 9.205492844759887924e-03,
 9.179231891200250251e-03,
 9.152957910864310820e-03,
 9.126670947308936077e-03,
 9.100371044109049207e-03,
 9.074058244857042058e-03,
 9.047732593163621689e-03,
 9.021394132656651577e-03,
 8.995042906982220199e-03,
 8.968678959803324385e-03,
 8.942302334801010763e-03,
 8.915913075673527477e-03,
 8.889511226136629501e-03,
 8.863096829923061692e-03,
 8.836669930782746138e-03,
 8.810230572483087469e-03,
 8.783778798808402136e-03,
 8.757314653560057185e-03,
 8.730838180555991479e-03,
 8.704349423631539684e-03,
 8.677848426638228377e-03,
 8.651335233444841163e-03,
 8.624809887936246006e-03,
 8.598272434014293808e-03,
 8.571722915597185244e-03,
 8.545161376619632085e-03,
 8.518587861032315967e-03,
 8.492002412802700240e-03,
 8.465405075913909339e-03,
 8.438795894365597877e-03,
 8.412174912173513500e-03,
 8.385542173368884522e-03,
 8.358897721999446889e-03,
 8.332241602128236807e-03,
 8.305573857834558718e-03,
 8.278894533212894161e-03,
 8.252203672373708415e-03,
 8.225501319442902332e-03,
 8.198787518561996210e-03,
 8.172062313887467136e-03,
 8.145325749591668385e-03,
 8.118577869861672361e-03,
 8.091818718900297552e-03,
 8.065048340924719020e-03,
 8.038266780168187506e-03,
 8.011474080877906134e-03,
 7.984670287316655846e-03,
 7.957855443761631398e-03,
 7.931029594504772698e-03,
 7.904192783852946949e-03,
 7.877345056127521908e-03,
 7.850486455664511601e-03,
 7.823617026813939682e-03,
 7.796736813940804804e-03,
 7.769845861423816009e-03,
 7.742944213656544582e-03,
 7.716031915046059689e-03,
 7.689109010014022125e-03,
 7.662175542995947053e-03,
 7.635231558441406101e-03,
 7.608277100813464443e-03,
 7.581312214589521273e-03,
 7.554336944260118050e-03,
 7.527351334329895199e-03,
 7.500355429316935517e-03,
 7.473349273752968869e-03,
 7.446332912182817079e-03,
 7.419306389164714854e-03,
 7.392269749270621165e-03,
 7.365223037085110759e-03,
 7.338166297206320451e-03,
 7.311099574245324625e-03,
 7.284022912826305235e-03,
 7.256936357585982815e-03,
 7.229839953174478639e-03,
 7.202733744254063118e-03,
 7.175617775500391787e-03,
 7.148492091600895486e-03,
 7.121356737256665133e-03,
 7.094211757180232149e-03,
 7.067057196097262413e-03,
 7.039893098745151137e-03,
 7.012719509874159977e-03,
 6.985536474246133339e-03,
 6.958344036635507983e-03,
 6.931142241828719755e-03,
 6.903931134623758625e-03,
 6.876710759831095900e-03,
 6.849481162272393585e-03,
 6.822242386781702216e-03,
 6.794994478204132923e-03,
 6.767737481396831484e-03,
 6.740471441228346877e-03,
 6.713196402578818639e-03,
 6.685912410339285572e-03,
 6.658619509412745663e-03,
 6.631317744712820345e-03,
 6.604007161164706860e-03,
 6.576687803704547690e-03,
 6.549359717279661271e-03,
 6.522022946847881933e-03,
 6.494677537378458487e-03,
 6.467323533850987370e-03,
 6.439960981255821171e-03,
 6.412589924594187460e-03,
 6.385210408877842712e-03,
 6.357822479129083583e-03,
 6.330426180380243836e-03,
 6.303021557674566046e-03,
 6.275608656065005501e-03,
 6.248187520615175634e-03,
 6.220758196398600351e-03,
 6.193320728499091335e-03,
 6.165875162009944004e-03,
 6.138421542034981811e-03,
 6.110959913687256939e-03,
 6.083490322090155319e-03,
 6.056012812376212681e-03,
 6.028527429687960230e-03,
 6.001034219177510051e-03,
 5.973533226005960095e-03,
 5.946024495344428944e-03,
 5.918508072372734817e-03,
 5.890984002280556971e-03,
 5.863452330266117306e-03,
 5.835913101537211663e-03,
 5.808366361310498584e-03,
 5.780812154811706613e-03,
 5.753250527275046225e-03,
 5.725681523944078921e-03,
 5.698105190070513332e-03,
 5.670521570915161048e-03,
 5.642930711747267888e-03,
 5.615332657844731602e-03,
 5.587727454493420128e-03,
 5.560115146988165585e-03,
 5.532495780631474513e-03,
 5.504869400734708346e-03,
 5.477236052616706041e-03,
 5.449595781604839664e-03,
 5.421948633034485293e-03,
 5.394294652248455765e-03,
 5.366633884598022430e-03,
 5.338966375441623648e-03,
 5.311292170145819752e-03,
 5.283611314084658145e-03,
 5.255923852639888399e-03,
 5.228229831200238015e-03,
 5.200529295162505290e-03,
 5.172822289930097822e-03,
 5.145108860914404669e-03,
 5.117389053533273266e-03,
 5.089662913212160411e-03,
 5.061930485383402817e-03,
 5.034191815486405326e-03,
 5.006446948967181211e-03,
 4.978695931278522176e-03,
 4.950938807880425098e-03,
 4.923175624238908948e-03,
 4.895406425827064298e-03,
 4.867631258124309988e-03,
 4.839850166616661148e-03,
 4.812063196796024893e-03,
 4.784270394161227284e-03,
 4.756471804216669784e-03,
 4.728667472473342334e-03,
 4.700857444448185846e-03,
 4.673041765664244854e-03,
 4.645220481650034344e-03,
 4.617393637940515536e-03,
 4.589561280075803509e-03,
 4.561723453602333812e-03,
 4.533880204071524117e-03,
 4.506031577040805515e-03,
 4.478177618073085620e-03,
 4.450318372736198659e-03,
 4.422453886603916820e-03,
 4.394584205254650072e-03,
 4.366709374272431492e-03,
 4.338829439246233780e-03,
 4.310944445770239011e-03,
 4.283054439443074492e-03,
 4.255159465868909967e-03,
 4.227259570656063774e-03,
 4.199354799418205872e-03,
 4.171445197773048126e-03,
 4.143530811343339171e-03,
 4.115611685756184399e-03,
 4.087687866643293158e-03,
 4.059759399640216343e-03,
 4.031826330387462687e-03,
 4.003888704529250629e-03,
 3.975946567713790208e-03,
 3.947999965594284864e-03,
 3.920048943826820280e-03,
 3.892093548072204055e-03,
 3.864133823994420937e-03,
 3.836169817261862736e-03,
 3.808201573545998662e-03,
 3.780229138522344171e-03,
 3.752252557869839925e-03,
 3.724271877271016599e-03,
 3.696287142411362140e-03,
 3.668298398980277160e-03,
 3.640305692669795149e-03,
 3.612309069175736933e-03,
 3.584308574196409629e-03,
 3.556304253433596740e-03,
 3.528296152591875977e-03,
 3.500284317378851706e-03,
 3.472268793504620660e-03,
 3.444249626682004389e-03,
 3.416226862626782577e-03,
 3.388200547057153983e-03,
 3.360170725693977130e-03,
 3.332137444260076849e-03,
 3.304100748481249555e-03,
 3.276060684084939646e-03,
 3.248017296801439073e-03,
 3.219970632362523840e-03,
 3.191920736502521297e-03,
 3.163867654957567242e-03,
 3.135811433465859627e-03,
 3.107752117766979846e-03,
 3.079689753602876754e-03,
 3.051624386716575172e-03,
 3.023556062853163372e-03,
 2.995484827759277869e-03,
 2.967410727182551340e-03,
 2.939333806872628744e-03,
 2.911254112579840254e-03,
 2.883171690056385208e-03,
 2.855086585055011551e-03,
 2.826998843330018069e-03,
 2.798908510636565275e-03,
 2.770815632730930841e-03,
 2.742720255369769742e-03,
 2.714622424311188050e-03,
 2.686522185313351685e-03,
 2.658419584135738450e-03,
 2.630314666537578953e-03,
 2.602207478279729667e-03,
 2.574098065122360987e-03,
 2.545986472826789956e-03,
 2.517872747154123719e-03,
 2.489756933865686691e-03,
 2.461639078723236972e-03,
 2.433519227488439417e-03,
 2.405397425923089423e-03,
 2.377273719788418598e-03,
 2.349148154846123892e-03,
 2.321020776857033591e-03,
 2.292891631582276955e-03,
 2.264760764781981444e-03,
 2.236628222216265408e-03,
 2.208494049644567185e-03,
 2.180358292825868450e-03,
 2.152220997517981238e-03,
 2.124082209478608731e-03,
 2.095941974463960949e-03,
 2.067800338229838514e-03,
 2.039657346530899303e-03,
 2.011513045120884389e-03,
 1.983367479752111504e-03,
 1.955220696175678004e-03,
 1.927072740141890861e-03,
 1.898923657399063849e-03,
 1.870773493694564017e-03,
 1.842622294774099801e-03,
 1.814470106381956081e-03,
 1.786316974260309613e-03,
 1.758162944150240374e-03,
 1.730008061790400163e-03,
 1.701852372918205222e-03,
 1.673695923268341771e-03,
 1.645538758574575109e-03,
 1.617380924567481679e-03,
 1.589222466976260772e-03,
 1.561063431527238976e-03,
 1.532903863945067786e-03,
 1.504743809951373775e-03,
 1.476583315265800941e-03,
 1.448422425605457118e-03,
 1.420261186684366236e-03,
 1.392099644214505466e-03,
 1.363937843904462549e-03,
 1.335775831460631015e-03,
 1.307613652585864258e-03,
 1.279451352980514418e-03,
 1.251288978341724397e-03,
 1.223126574363668766e-03,
 1.194964186736857063e-03,
 1.166801861149147513e-03,
 1.138639643284431032e-03,
 1.110477578823644952e-03,
 1.082315713444076963e-03,
 1.054154092819608625e-03,
 1.025992762620006301e-03,
 9.978317685119476779e-04,
 9.696711561578592875e-04,
 9.415109712162972756e-04,
 9.133512593422000222e-04,
 8.851920661863395354e-04,
 8.570334373955632284e-04,
 8.288754186120909223e-04,
 8.007180554745384421e-04,
 7.725613936165927212e-04,
 7.444054786681895703e-04,
 7.162503562540302720e-04,
 6.880960719953920900e-04,
 6.599426715078520952e-04,
 6.317902004031042884e-04,
 6.036387042874689305e-04,
 5.754882287630776845e-04,
 5.473388194265393957e-04,
 5.191905218699693252e-04,
 4.910433816804459645e-04,
 4.628974444394631338e-04,
 4.347527557239581311e-04,
 4.066093611049811994e-04,
 3.784673061488762224e-04,
 3.503266364159559384e-04,
 3.221873974615240715e-04,
 2.940496348351742326e-04,
 2.659133940810314792e-04,
 2.377787207370510270e-04,
 2.096456603360436334e-04,
 1.815142584043453631e-04,
 1.533845604628449510e-04,
 1.252566120262819981e-04,
 9.713045860348614629e-05,
 6.900614569667848656e-05,
 4.088371880249530316e-05,
 1.276322341066001066e-05,
-1.535529499483530283e-05,
-4.347179093705743041e-05,
-7.158621894510751598e-05,
-9.969853355466531356e-05,
-1.278086893085317560e-04,
-1.559166407556046379e-04,
-1.840223424522064246e-04,
-2.121257489610611313e-04,
-2.402268148519906652e-04,
-2.683254947016798248e-04,
-2.964217430943705419e-04,
-3.245155146208423516e-04,
-3.526067638797361495e-04,
-3.806954454763768290e-04,
-4.087815140240948697e-04,
-4.368649241432071874e-04,
-4.649456304617152519e-04,
-4.930235876150639062e-04,
-5.210987502466833590e-04,
-5.491710730077517446e-04,
-5.772405105567983592e-04,
-6.053070175608653292e-04,
-6.333705486944971345e-04,
-6.614310586404266923e-04,
-6.894885020893423613e-04,
-7.175428337405869274e-04,
-7.455940083011309725e-04,
-7.736419804869038410e-04,
-8.016867050217624550e-04,
-8.297281366381961546e-04,
-8.577662300770862213e-04,
-8.858009400883994425e-04,
-9.138322214301705876e-04,
-9.418600288698286043e-04,
-9.698843171830067063e-04,
-9.979050411548838571e-04,
-1.025922155579141659e-03,
-1.053935615258523801e-03,
-1.081945375005371763e-03,
-1.109951389640594175e-03,
-1.137953613995005371e-03,
-1.165952002908294096e-03,
-1.193946511229721733e-03,
-1.221937093817882262e-03,
-1.249923705541403736e-03,
-1.277906301277925228e-03,
-1.305884835915412188e-03,
-1.333859264350988972e-03,
-1.361829541492256147e-03,
-1.389795622256275679e-03,
-1.417757461570245524e-03,
-1.445715014371301002e-03,
-1.473668235607159677e-03,
-1.501617080235147965e-03,
-1.529561503223341931e-03,
-1.557501459550166998e-03,
-1.585436904204175690e-03,
-1.613367792184574115e-03,
-1.641294078500988435e-03,
-1.669215718174154846e-03,
-1.697132666234907154e-03,
-1.725044877725494946e-03,
-1.752952307698560971e-03,
-1.780854911217834378e-03,
-1.808752643357898916e-03,
-1.836645459204885519e-03,
-1.864533313855443186e-03,
-1.892416162418078833e-03,
-1.920293960011957950e-03,
-1.948166661768245978e-03,
-1.976034222829070076e-03,
-2.003896598348230574e-03,
-2.031753743490942281e-03,
-2.059605613434395670e-03,
-2.087452163367496671e-03,
-2.115293348490646357e-03,
-2.143129124016263966e-03,
-2.170959445168543604e-03,
-2.198784267184182833e-03,
-2.226603545311311039e-03,
-2.254417234810856402e-03,
-2.282225290955336786e-03,
-2.310027669030201986e-03,
-2.337824324332796796e-03,
-2.365615212173062271e-03,
-2.393400287873301974e-03,
-2.421179506768860682e-03,
-2.448952824207130397e-03,
-2.476720195548835768e-03,
-2.504481576167040969e-03,
-2.532236921447684422e-03,
-2.559986186790103990e-03,
-2.587729327606033431e-03,
-2.615466299320895645e-03,
-2.643197057372668590e-03,
-2.670921557213168113e-03,
-2.698639754307035742e-03,
-2.726351604132445580e-03,
-2.754057062180852774e-03,
-2.781756083957678729e-03,
-2.809448624981318414e-03,
-2.837134640784435766e-03,
-2.864814086912795786e-03,
-2.892486918926575560e-03,
-2.920153092399359416e-03,
-2.947812562918819806e-03,
-2.975465286086485285e-03,
-3.003111217518266568e-03,
-3.030750312844217569e-03,
-3.058382527708322033e-03,
-3.086007817768997036e-03,
-3.113626138698856634e-03,
-3.141237446185426996e-03,
-3.168841695930120755e-03,
-3.196438843649524603e-03,
-3.224028845074270854e-03,
-3.251611655950311600e-03,
-3.279187232037914738e-03,
-3.306755529112387782e-03,
-3.334316502963781664e-03,
-3.361870109397620179e-03,
-3.389416304233875202e-03,
-3.416955043308274667e-03,
-3.444486282471292092e-03,
-3.472009977588836997e-03,
-3.499526084542001637e-03,
-3.527034559227620880e-03,
-3.554535357558022846e-03,
-3.582028435460622110e-03,
-3.609513748879073728e-03,
-3.636991253772281843e-03,
-3.664460906115090105e-03,
-3.691922661897998476e-03,
-3.719376477127906561e-03,
-3.746822307827065834e-03,
-3.774260110034391522e-03,
-3.801689839804315955e-03,
-3.829111453208236624e-03,
-3.856524906332719875e-03,
-3.883930155281736536e-03,
-3.911327156174912445e-03,
-3.938715865148948760e-03,
-3.966096238356467060e-03,
-3.993468231967328176e-03,
-4.020831802167590049e-03,
-4.048186905160083664e-03,
-4.075533497164912644e-03,
-4.102871534418455791e-03,
-4.130200973174660319e-03,
-4.157521769703903004e-03,
-4.184833880294255674e-03,
-4.212137261250512889e-03,
-4.239431868894860678e-03,
-4.266717659566624139e-03,
-4.293994589622972605e-03,
-4.321262615437916101e-03,
-4.348521693403589045e-03,
-4.375771779929244973e-03,
-4.403012831441947827e-03,
-4.430244804386342106e-03,
-4.457467655225318126e-03,
-4.484681340439007624e-03,
-4.511885816525934741e-03,
-4.539081040002622240e-03,
-4.566266967403396354e-03,
-4.593443555280816125e-03,
-4.620610760205536363e-03,
-4.647768538766913066e-03,
-4.674916847572083145e-03,
-4.702055643247165725e-03,
-4.729184882436164930e-03,
-4.756304521802419243e-03,
-4.783414518026810405e-03,
-4.810514827809959579e-03,
-4.837605407870502160e-03,
-4.864686214946519795e-03,
-4.891757205794371177e-03,
-4.918818337189973140e-03,
-4.945869565927860437e-03,
-4.972910848821616818e-03,
-4.999942142704504738e-03,
-5.026963404428386357e-03,
-5.053974590865044532e-03,
-5.080975658905050908e-03,
-5.107966565458995842e-03,
-5.134947267456556851e-03,
-5.161917721847134391e-03,
-5.188877885599617670e-03,
-5.215827715703095883e-03,
-5.242767169165802633e-03,
-5.269696203016460342e-03,
-5.296614774303259367e-03,
-5.323522840094499844e-03,
-5.350420357478443377e-03,
-5.377307283563883752e-03,
-5.404183575479233614e-03,
-5.431049190373762187e-03,
-5.457904085416472907e-03,
-5.484748217797350694e-03,
-5.511581544726441677e-03,
-5.538404023434279934e-03,
-5.565215611172461690e-03,
-5.592016265212690351e-03,
-5.618805942847944837e-03,
-5.645584601391467373e-03,
-5.672352198178100095e-03,
-5.699108690562564201e-03,
-5.725854035921664788e-03,
-5.752588191652517960e-03,
-5.779311115173988919e-03,
-5.806022763925553117e-03,
-5.832723095368544386e-03,
-5.859412066985230337e-03,
-5.886089636279418641e-03,
-5.912755760776243659e-03,
-5.939410398022715483e-03,
-5.966053505587415491e-03,
-5.992685041060191904e-03,
-6.019304962053227508e-03,
-6.045913226200079482e-03,
-6.072509791156335997e-03,
-6.099094614599382021e-03,
-6.125667654229066325e-03,
-6.152228867766747385e-03,
-6.178778212956495541e-03,
-6.205315647564179672e-03,
-6.231841129378083016e-03,
-6.258354616208707151e-03,
-6.284856065889421646e-03,
-6.311345436275472669e-03,
-6.337822685245250200e-03,
-6.364287770699196892e-03,
-6.390740650560991151e-03,
-6.417181282776669368e-03,
-6.443609625315009290e-03,
-6.470025636168231717e-03,
-6.496429273350779257e-03,
-6.522820494900836812e-03,
-6.549199258879134615e-03,
-6.575565523369725392e-03,
-6.601919246479757107e-03,
-6.628260386340064508e-03,
-6.654588901104283548e-03,
-6.680904748950030995e-03,
-6.707207888077783807e-03,
-6.733498276712220065e-03,
-6.759775873101119166e-03,
-6.786040635516144177e-03,
-6.812292522252529590e-03,
-6.838531491629759596e-03,
-6.864757501990602709e-03,
-6.890970511702239343e-03,
-6.917170479155819451e-03,
-6.943357362766295997e-03,
-6.969531120972905468e-03,
-6.995691712238924151e-03,
-7.021839095052358551e-03,
-7.047973227924965271e-03,
-7.074094069393491342e-03,
-7.100201578018668080e-03,
-7.126295712385934469e-03,
-7.152376431105212512e-03,
-7.178443692811494435e-03,
-7.204497456163891193e-03,
-7.230537679846924838e-03,
-7.256564322569393141e-03,
-7.282577343065585636e-03,
-7.308576700094347733e-03,
-7.334562352439709561e-03,
-7.360534258910705549e-03,
-7.386492378341808114e-03,
-7.412436669592784542e-03,
-7.438367091548343975e-03,
-7.464283603118832162e-03,
-7.490186163239770031e-03,
-7.516074730872727983e-03,
-7.541949265004180107e-03,
-7.567809724646885894e-03,
-7.593656068838672453e-03,
-7.619488256643742498e-03,
-7.645306247151708104e-03,
-7.671109999478171841e-03,
-7.696899472764580190e-03,
-7.722674626178863654e-03,
-7.748435418914388119e-03,
-7.774181810191311409e-03,
-7.799913759255555461e-03,
-7.825631225379339750e-03,
-7.851334167861604568e-03,
-7.877022546027160135e-03,
-7.902696319227900043e-03,
-7.928355446841601692e-03,
-7.953999888273288049e-03,
-7.979629602954165998e-03,
-8.005244550342337576e-03,
-8.030844689922510271e-03,
-8.056429981206784594e-03,
-8.082000383733457111e-03,
-8.107555857068505373e-03,
-8.133096360804300748e-03,
-8.158621854560945894e-03,
-8.184132297985253005e-03,
-8.209627650751446376e-03,
-8.235107872560858827e-03,
-8.260572923142531915e-03,
-8.286022762252872459e-03,
-8.311457349675538051e-03,
-8.336876645221865528e-03,
-8.362280608730655873e-03,
-8.387669200068826464e-03,
-8.413042379130450041e-03,
-8.438400105838003706e-03,
-8.463742340141244824e-03,
-8.489069042018435735e-03,
-8.514380171475401798e-03,
-8.539675688546152429e-03,
-8.564955553292690274e-03,
-8.590219725805646120e-03,
-8.615468166203293574e-03,
-8.640700834632766836e-03,
-8.665917691269205483e-03,
-8.691118696316250600e-03,
-8.716303810005982325e-03,
-8.741472992599219963e-03,
-8.766626204385457796e-03,
-8.791763405682469570e-03,
-8.816884556837302489e-03,
-8.841989618225361280e-03,
-8.867078550251119434e-03,
-8.892151313347801747e-03,
-8.917207867978052191e-03,
-8.942248174633019714e-03,
-8.967272193833530913e-03,
-8.992279886129005834e-03,
-9.017271212098658395e-03,
-9.042246132350642909e-03,
-9.067204607522560619e-03,
-9.092146598281301839e-03,
-9.117072065323693006e-03,
-9.141980969375525234e-03,
-9.166873271192742603e-03,
-9.191748931560612956e-03,
-9.216607911294022806e-03,
-9.241450171238205918e-03,
-9.266275672267555025e-03,
-9.291084375287059910e-03,
-9.315876241231006369e-03,
-9.340651231064417762e-03,
-9.365409305781852850e-03,
-9.390150426408321732e-03,
-9.414874553998761955e-03,
-9.439581649638924959e-03,
-9.464271674444290142e-03,
-9.488944589561360693e-03,
-9.513600356166582867e-03,
-9.538238935467178645e-03,
-9.562860288700725936e-03,
-9.587464377135977364e-03,
-9.612051162071696270e-03,
-9.636620604837949078e-03,
-9.661172666795544983e-03,
-9.685707309335975235e-03,
-9.710224493881798244e-03,
-9.734724181886408867e-03,
-9.759206334834732294e-03,
-9.783670914242224848e-03,
-9.808117881656142067e-03,
-9.832547198654367770e-03,
-9.856958826846866015e-03,
-9.881352727873932498e-03,
-9.905728863408316126e-03,
-9.930087195153539797e-03,
-9.954427684845177163e-03,
-9.978750294249976588e-03,
-1.000305498516680137e-02,
-1.002734171942588730e-02,
-1.005161045888923292e-02,
-1.007586116545109746e-02,
-1.010009380103712474e-02,
-1.012430832760544130e-02,
-1.014850470714569013e-02,
-1.017268290168008189e-02,
-1.019684287326261610e-02,
-1.022098458397963268e-02,
-1.024510799594959519e-02,
-1.026921307132366672e-02,
-1.029329977228484426e-02,
-1.031736806104917650e-02,
-1.034141789986474554e-02,
-1.036544925101230523e-02,
-1.038946207680517368e-02,
-1.041345633958966170e-02,
-1.043743200174435982e-02,
-1.046138902568109069e-02,
-1.048532737384408157e-02,
-1.050924700871096011e-02,
-1.053314789279191296e-02,
-1.055702998863017501e-02,
-1.058089325880246824e-02,
-1.060473766591809447e-02,
-1.062856317262015834e-02,
-1.065236974158438425e-02,
-1.067615733552056308e-02,
-1.069992591717092156e-02,
-1.072367544931202704e-02,
-1.074740589475326608e-02,
-1.077111721633812295e-02,
-1.079480937694315620e-02,
-1.081848233947916085e-02,
-1.084213606689016229e-02,
-1.086577052215418303e-02,
-1.088938566828289399e-02,
-1.091298146832216792e-02,
-1.093655788535185212e-02,
-1.096011488248528273e-02,
-1.098365242287054240e-02,
-1.100717046968939343e-02,
-1.103066898615785718e-02,
-1.105414793552611345e-02,
-1.107760728107900529e-02,
-1.110104698613525488e-02,
-1.112446701404847318e-02,
-1.114786732820631857e-02,
-1.117124789203120458e-02,
-1.119460866897990445e-02,
-1.121794962254424842e-02,
-1.124127071625025641e-02,
-1.126457191365914587e-02,
-1.128785317836654423e-02,
-1.131111447400337533e-02,
-1.133435576423512219e-02,
-1.135757701276220860e-02,
-1.138077818332054736e-02,
-1.140395923968058091e-02,
-1.142712014564841588e-02,
-1.145026086506481348e-02,
-1.147338136180650961e-02,
-1.149648159978461370e-02,
-1.151956154294647532e-02,
-1.154262115527431368e-02,
-1.156566040078622383e-02,
-1.158867924353542030e-02,
-1.161167764761120505e-02,
-1.163465557713810189e-02,
-1.165761299627648094e-02,
-1.168054986922239906e-02,
-1.170346616020806474e-02,
-1.172636183350102279e-02,
-1.174923685340518824e-02,
-1.177209118426041957e-02,
-1.179492479044235223e-02,
-1.181773763636284440e-02,
-1.184052968646980182e-02,
-1.186330090524768087e-02,
-1.188605125721669403e-02,
-1.190878070693390280e-02,
-1.193148921899230171e-02,
-1.195417675802142032e-02,
-1.197684328868726944e-02,
-1.199948877569262905e-02,
-1.202211318377637526e-02,
-1.204471647771461311e-02,
-1.206729862231955760e-02,
-1.208985958244073941e-02,
-1.211239932296404205e-02,
-1.213491780881234203e-02,
-1.215741500494540300e-02,
-1.217989087636008744e-02,
-1.220234538809033924e-02,
-1.222477850520684028e-02,
-1.224719019281769218e-02,
-1.226958041606787328e-02,
-1.229194914014010605e-02,
-1.231429633025380062e-02,
-1.233662195166630900e-02,
-1.235892596967179749e-02,
-1.238120834960235866e-02,
-1.240346905682738511e-02,
-1.242570805675372037e-02,
-1.244792531482587922e-02,
-1.247012079652631486e-02,
-1.249229446737473194e-02,
-1.251444629292907361e-02,
-1.253657623878466632e-02,
-1.255868427057515828e-02,
-1.258077035397181173e-02,
-1.260283445468372843e-02,
-1.262487653845862680e-02,
-1.264689657108166929e-02,
-1.266889451837667664e-02,
-1.269087034620533690e-02,
-1.271282402046765465e-02,
-1.273475550710186262e-02,
-1.275666477208489170e-02,
-1.277855178143154705e-02,
-1.280041650119565638e-02,
-1.282225889746900493e-02,
-1.284407893638241094e-02,
-1.286587658410503349e-02,
-1.288765180684467611e-02,
-1.290940457084788565e-02,
-1.293113484240012052e-02,
-1.295284258782570391e-02,
-1.297452777348759995e-02,
-1.299619036578772945e-02,
-1.301783033116695604e-02,
-1.303944763610551290e-02,
-1.306104224712226029e-02,
-1.308261413077558763e-02,
-1.310416325366260681e-02,
-1.312568958242023125e-02,
-1.314719308372420091e-02,
-1.316867372428973983e-02,
-1.319013147087136177e-02,
-1.321156629026332824e-02,
-1.323297814929897016e-02,
-1.325436701485159519e-02,
-1.327573285383373304e-02,
-1.329707563319770976e-02,
-1.331839531993544469e-02,
-1.333969188107874196e-02,
-1.336096528369930432e-02,
-1.338221549490825960e-02,
-1.340344248185710262e-02,
-1.342464621173694583e-02,
-1.344582665177902758e-02,
-1.346698376925447790e-02,
-1.348811753147487365e-02,
-1.350922790579148214e-02,
-1.353031485959624303e-02,
-1.355137836032082981e-02,
-1.357241837543778779e-02,
-1.359343487245950888e-02,
-1.361442781893901569e-02,
-1.363539718246958507e-02,
-1.365634293068538653e-02,
-1.367726503126062178e-02,
-1.369816345191056904e-02,
-1.371903816039084061e-02,
-1.373988912449773322e-02,
-1.376071631206853690e-02,
-1.378151969098098499e-02,
-1.380229922915403133e-02,
-1.382305489454713730e-02,
-1.384378665516112009e-02,
-1.386449447903741715e-02,
-1.388517833425862054e-02,
-1.390583818894835198e-02,
-1.392647401127160289e-02,
-1.394708576943421742e-02,
-1.396767343168365920e-02,
-1.398823696630831746e-02,
-1.400877634163802399e-02,
-1.402929152604391258e-02,
-1.404978248793881286e-02,
-1.407024919577668128e-02,
-1.409069161805320824e-02,
-1.411110972330578348e-02,
-1.413150348011310738e-02,
-1.415187285709558311e-02,
-1.417221782291541374e-02,
-1.419253834627670803e-02,
-1.421283439592505200e-02,
-1.423310594064831555e-02,
-1.425335294927577642e-02,
-1.427357539067914544e-02,
-1.429377323377181187e-02,
-1.431394644750924247e-02,
-1.433409500088903173e-02,
-1.435421886295108231e-02,
-1.437431800277720780e-02,
-1.439439238949175720e-02,
-1.441444199226109626e-02,
-1.443446678029390584e-02,
-1.445446672284158955e-02,
-1.447444178919753306e-02,
-1.449439194869798012e-02,
-1.451431717072130916e-02,
-1.453421742468889721e-02,
-1.455409268006437225e-02,
-1.457394290635415784e-02,
-1.459376807310724423e-02,
-1.461356814991566361e-02,
-1.463334310641392459e-02,
-1.465309291227966972e-02,
-1.467281753723321570e-02,
-1.469251695103788134e-02,
-1.471219112349979145e-02,
-1.473184002446854476e-02,
-1.475146362383628236e-02,
-1.477106189153875454e-02,
-1.479063479755433549e-02,
-1.481018231190518904e-02,
-1.482970440465631971e-02,
-1.484920104591601515e-02,
-1.486867220583627629e-02,
-1.488811785461208702e-02,
-1.490753796248217231e-02,
-1.492693249972845693e-02,
-1.494630143667683049e-02,
-1.496564474369602160e-02,
-1.498496239119917126e-02,
-1.500425434964253527e-02,
-1.502352058952637071e-02,
-1.504276108139440161e-02,
-1.506197579583457881e-02,
-1.508116470347825588e-02,
-1.510032777500090219e-02,
-1.511946498112169690e-02,
-1.513857629260405985e-02,
-1.515766168025546937e-02,
-1.517672111492707719e-02,
-1.519575456751453245e-02,
-1.521476200895741267e-02,
-1.523374341023956378e-02,
-1.525269874238890759e-02,
-1.527162797647803327e-02,
-1.529053108362334046e-02,
-1.530940803498615117e-02,
-1.532825880177174707e-02,
-1.534708335523002690e-02,
-1.536588166665534168e-02,
-1.538465370738680699e-02,
-1.540339944880770792e-02,
-1.542211886234648270e-02,
-1.544081191947565754e-02,
-1.545947859171301932e-02,
-1.547811885062076731e-02,
-1.549673266780587054e-02,
-1.551532001492048410e-02,
-1.553388086366122578e-02,
-1.555241518577004517e-02,
-1.557092295303347772e-02,
-1.558940413728351383e-02,
-1.560785871039658060e-02,
-1.562628664429487058e-02,
-1.564468791094519515e-02,
-1.566306248235994902e-02,
-1.568141033059639380e-02,
-1.569973142775743860e-02,
-1.571802574599102942e-02,
-1.573629325749043364e-02,
-1.575453393449439271e-02,
-1.577274774928726087e-02,
-1.579093467419849517e-02,
-1.580909468160343612e-02,
-1.582722774392284967e-02,
-1.584533383362301748e-02,
-1.586341292321593460e-02,
-1.588146498525922629e-02,
-1.589948999235640120e-02,
-1.591748791715643860e-02,
-1.593545873235455504e-02,
-1.595340241069142725e-02,
-1.597131892495377500e-02,
-1.598920824797412168e-02,
-1.600707035263130781e-02,
-1.602490521184975203e-02,
-1.604271279860029417e-02,
-1.606049308589950833e-02,
-1.607824604681054939e-02,
-1.609597165444228914e-02,
-1.611366988195002056e-02,
-1.613134070253539193e-02,
-1.614898408944607719e-02,
-1.616660001597647334e-02,
-1.618418845546697529e-02,
-1.620174938130454143e-02,
-1.621928276692252702e-02,
-1.623678858580103121e-02,
-1.625426681146625862e-02,
-1.627171741749141448e-02,
-1.628914037749598295e-02,
-1.630653566514641759e-02,
-1.632390325415557231e-02,
-1.634124311828317674e-02,
-1.635855523133555520e-02,
-1.637583956716622685e-02,
-1.639309609967508005e-02,
-1.641032480280939926e-02,
-1.642752565056289013e-02,
-1.644469861697664056e-02,
-1.646184367613847538e-02,
-1.647896080218327550e-02,
-1.649604996929326245e-02,
-1.651311115169738428e-02,
-1.653014432367219330e-02,
-1.654714945954099611e-02,
-1.656412653367468624e-02,
-1.658107552049107106e-02,
-1.659799639445570102e-02,
-1.661488913008110982e-02,
-1.663175370192748054e-02,
-1.664859008460220502e-02,
-1.666539825276033837e-02,
-1.668217818110433182e-02,
-1.669892984438407432e-02,
-1.671565321739710772e-02,
-1.673234827498870994e-02,
-1.674901499205179445e-02,
-1.676565334352678530e-02,
-1.678226330440194328e-02,
-1.679884484971320632e-02,
-1.681539795454452951e-02,
-1.683192259402734037e-02,
-1.684841874334145131e-02,
-1.686488637771401192e-02,
-1.688132547242065379e-02,
-1.689773600278460935e-02,
-1.691411794417726697e-02,
-1.693047127201798355e-02,
-1.694679596177441419e-02,
-1.696309198896214093e-02,
-1.697935932914512031e-02,
-1.699559795793520109e-02,
-1.701180785099290493e-02,
-1.702798898402650349e-02,
-1.704414133279293087e-02,
-1.706026487309754078e-02,
-1.707635958079367286e-02,
-1.709242543178357554e-02,
-1.710846240201762888e-02,
-1.712447046749470195e-02,
-1.714044960426220482e-02,
-1.715639978841636271e-02,
-1.717232099610164694e-02,
-1.718821320351143767e-02,
-1.720407638688750684e-02,
-1.721991052252062893e-02,
-1.723571558675010898e-02,
-1.725149155596403597e-02,
-1.726723840659932785e-02,
-1.728295611514189117e-02,
-1.729864465812618046e-02,
-1.731430401213595455e-02,
-1.732993415380364513e-02,
-1.734553505981059271e-02,
-1.736110670688751148e-02,
-1.737664907181379545e-02,
-1.739216213141821579e-02,
-1.740764586257833452e-02,
-1.742310024222120876e-02,
-1.743852524732284262e-02,
-1.745392085490851328e-02,
-1.746928704205268079e-02,
-1.748462378587935240e-02,
-1.749993106356148576e-02,
-1.751520885232177652e-02,
-1.753045712943199913e-02,
-1.754567587221348215e-02,
-1.756086505803686540e-02,
-1.757602466432256136e-02,
-1.759115466854013765e-02,
-1.760625504820904214e-02,
-1.762132578089819351e-02,
-1.763636684422607848e-02,
-1.765137821586083844e-02,
-1.766635987352020015e-02,
-1.768131179497190938e-02,
-1.769623395803305785e-02,
-1.771112634057105811e-02,
-1.772598892050242236e-02,
-1.774082167579422650e-02,
-1.775562458446294095e-02,
-1.777039762457510372e-02,
-1.778514077424713652e-02,
-1.779985401164558417e-02,
-1.781453731498680929e-02,
-1.782919066253741552e-02,
-1.784381403261389720e-02,
-1.785840740358276765e-02,
-1.787297075386109699e-02,
-1.788750406191557535e-02,
-1.790200730626357803e-02,
-1.791648046547226689e-02,
-1.793092351815947158e-02,
-1.794533644299300262e-02,
-1.795971921869112323e-02,
-1.797407182402228909e-02,
-1.798839423780569310e-02,
-1.800268643891052636e-02,
-1.801694840625677266e-02,
-1.803118011881469154e-02,
-1.804538155560498833e-02,
-1.805955269569905000e-02,
-1.807369351821880646e-02,
-1.808780400233667845e-02,
-1.810188412727594884e-02,
-1.811593387231019009e-02,
-1.812995321676408311e-02,
-1.814394214001265049e-02,
-1.815790062148176301e-02,
-1.817182864064828193e-02,
-1.818572617703958366e-02,
-1.819959321023415996e-02,
-1.821342971986103162e-02,
-1.822723568560041460e-02,
-1.824101108718326550e-02,
-1.825475590439157650e-02,
-1.826847011705826085e-02,
-1.828215370506735410e-02,
-1.829580664835374348e-02,
-1.830942892690362242e-02,
-1.832302052075410886e-02,
-1.833658140999346389e-02,
-1.835011157476112639e-02,
-1.836361099524769572e-02,
-1.837707965169518148e-02,
-1.839051752439645540e-02,
-1.840392459369606659e-02,
-1.841730083998951994e-02,
-1.843064624372380694e-02,
-1.844396078539723219e-02,
-1.845724444555957647e-02,
-1.847049720481180879e-02,
-1.848371904380668312e-02,
-1.849690994324816595e-02,
-1.851006988389161320e-02,
-1.852319884654415882e-02,
-1.853629681206439214e-02,
-1.854936376136234397e-02,
-1.856239967539998620e-02,
-1.857540453519045467e-02,
-1.858837832179898591e-02,
-1.860132101634219201e-02,
-1.861423259998850818e-02,
-1.862711305395816502e-02,
-1.863996235952297686e-02,
-1.865278049800680668e-02,
-1.866556745078507343e-02,
-1.867832319928534879e-02,
-1.869104772498656267e-02,
-1.870374100942018628e-02,
-1.871640303416906986e-02,
-1.872903378086842111e-02,
-1.874163323120512162e-02,
-1.875420136691822309e-02,
-1.876673816979876688e-02,
-1.877924362168982911e-02,
-1.879171770448642004e-02,
-1.880416040013606002e-02,
-1.881657169063793641e-02,
-1.882895155804372930e-02,
-1.884129998445718129e-02,
-1.885361695203420160e-02,
-1.886590244298296318e-02,
-1.887815643956379866e-02,
-1.889037892408960279e-02,
-1.890256987892522528e-02,
-1.891472928648817858e-02,
-1.892685712924814176e-02,
-1.893895338972715128e-02,
-1.895101805049965310e-02,
-1.896305109419270385e-02,
-1.897505250348561698e-02,
-1.898702226111029928e-02,
-1.899896034985104620e-02,
-1.901086675254487837e-02,
-1.902274145208120507e-02,
-1.903458443140196993e-02,
-1.904639567350196322e-02,
-1.905817516142828752e-02,
-1.906992287828095101e-02,
-1.908163880721242683e-02,
-1.909332293142815273e-02,
-1.910497523418593427e-02,
-1.911659569879663526e-02,
-1.912818430862365041e-02,
-1.913974104708340493e-02,
-1.915126589764485493e-02,
-1.916275884383007375e-02,
-1.917421986921379745e-02,
-1.918564895742371629e-02,
-1.919704609214033589e-02,
-1.920841125709731381e-02,
-1.921974443608093566e-02,
-1.923104561293077774e-02,
-1.924231477153921094e-02,
-1.925355189585170254e-02,
-1.926475696986677463e-02,
-1.927592997763586183e-02,
-1.928707090326368251e-02,
-1.929817973090795780e-02,
-1.930925644477956768e-02,
-1.932030102914253714e-02,
-1.933131346831403960e-02,
-1.934229374666435186e-02,
-1.935324184861721836e-02,
-1.936415775864937239e-02,
-1.937504146129102531e-02,
-1.938589294112542244e-02,
-1.939671218278930104e-02,
-1.940749917097272376e-02,
-1.941825389041886007e-02,
-1.942897632592446161e-02,
-1.943966646233970946e-02,
-1.945032428456800952e-02,
-1.946094977756637409e-02,
-1.947154292634505762e-02,
-1.948210371596787588e-02,
-1.949263213155230656e-02,
-1.950312815826902441e-02,
-1.951359178134247363e-02,
-1.952402298605048631e-02,
-1.953442175772461195e-02,
-1.954478808174994406e-02,
-1.955512194356509928e-02,
-1.956542332866229722e-02,
-1.957569222258767269e-02,
-1.958592861094067897e-02,
-1.959613247937478167e-02,
-1.960630381359687244e-02,
-1.961644259936785178e-02,
-1.962654882250196645e-02,
-1.963662246886766286e-02,
-1.964666352438691754e-02,
-1.965667197503557020e-02,
-1.966664780684337227e-02,
-1.967659100589373364e-02,
-1.968650155832412166e-02,
-1.969637945032564480e-02,
-1.970622466814355225e-02,
-1.971603719807685576e-02,
-1.972581702647865920e-02,
-1.973556413975574575e-02,
-1.974527852436923359e-02,
-1.975496016683390629e-02,
-1.976460905371870552e-02,
-1.977422517164655405e-02,
-1.978380850729453619e-02,
-1.979335904739355431e-02,
-1.980287677872889437e-02,
-1.981236168813969856e-02,
-1.982181376251929833e-02,
-1.983123298881523874e-02,
-1.984061935402903903e-02,
-1.984997284521659508e-02,
-1.985929344948784286e-02,
-1.986858115400694236e-02,
-1.987783594599232956e-02,
-1.988705781271657771e-02,
-1.989624674150657427e-02,
-1.990540271974347922e-02,
-1.991452573486268696e-02,
-1.992361577435404485e-02,
-1.993267282576145771e-02,
-1.994169687668348803e-02,
-1.995068791477268982e-02,
-1.995964592773630600e-02,
-1.996857090333569937e-02,
-1.997746282938685225e-02,
-1.998632169376010626e-02,
-1.999514748438008596e-02,
-2.000394018922609443e-02,
-2.001269979633161014e-02,
-2.002142629378491842e-02,
-2.003011966972849736e-02,
-2.003877991235965966e-02,
-2.004740700992985181e-02,
-2.005600095074538958e-02,
-2.006456172316700703e-02,
-2.007308931560999876e-02,
-2.008158371654424415e-02,
-2.009004491449428026e-02,
-2.009847289803913875e-02,
-2.010686765581272059e-02,
-2.011522917650332420e-02,
-2.012355744885392997e-02,
-2.013185246166235634e-02,
-2.014011420378096842e-02,
-2.014834266411694857e-02,
-2.015653783163198765e-02,
-2.016469969534276027e-02,
-2.017282824432054325e-02,
-2.018092346769134390e-02,
-2.018898535463594865e-02,
-2.019701389439011383e-02,
-2.020500907624411466e-02,
-2.021297088954332813e-02,
-2.022089932368769175e-02,
-2.022879436813210599e-02,
-2.023665601238629208e-02,
-2.024448424601494115e-02,
-2.025227905863746791e-02,
-2.026004043992831252e-02,
-2.026776837961663871e-02,
-2.027546286748681953e-02,
-2.028312389337789956e-02,
-2.029075144718394189e-02,
-2.029834551885398297e-02,
-2.030590609839202573e-02,
-2.031343317585709851e-02,
-2.032092674136308161e-02,
-2.032838678507905422e-02,
-2.033581329722898220e-02,
-2.034320626809183949e-02,
-2.035056568800167748e-02,
-2.035789154734771178e-02,
-2.036518383657398568e-02,
-2.037244254617998421e-02,
-2.037966766671978416e-02,
-2.038685918880307063e-02,
-2.039401710309418636e-02,
-2.040114140031294016e-02,
-2.040823207123412114e-02,
-2.041528910668765490e-02,
-2.042231249755871447e-02,
-2.042930223478756774e-02,
-2.043625830936957391e-02,
-2.044318071235549927e-02,
-2.045006943485111819e-02,
-2.045692446801744557e-02,
-2.046374580307085828e-02,
-2.047053343128283145e-02,
-2.047728734398002529e-02,
-2.048400753254448620e-02,
-2.049069398841345951e-02,
-2.049734670307945886e-02,
-2.050396566809035981e-02,
-2.051055087504908420e-02,
-2.051710231561427664e-02,
-2.052361998149946493e-02,
-2.053010386447366373e-02,
-2.053655395636133640e-02,
-2.054297024904209665e-02,
-2.054935273445103808e-02,
-2.055570140457851566e-02,
-2.056201625147029838e-02,
-2.056829726722755186e-02,
-2.057454444400682106e-02,
-2.058075777401991227e-02,
-2.058693724953425050e-02,
-2.059308286287254292e-02,
-2.059919460641292110e-02,
-2.060527247258898617e-02,
-2.061131645388974282e-02,
-2.061732654285957506e-02,
-2.062330273209851683e-02,
-2.062924501426181834e-02,
-2.063515338206044214e-02,
-2.064102782826058094e-02,
-2.064686834568421614e-02,
-2.065267492720845866e-02,
-2.065844756576614566e-02,
-2.066418625434564976e-02,
-2.066989098599069513e-02,
-2.067556175380069403e-02,
-2.068119855093056639e-02,
-2.068680137059058372e-02,
-2.069237020604673336e-02,
-2.069790505062055891e-02,
-2.070340589768915676e-02,
-2.070887274068506853e-02,
-2.071430557309654821e-02,
-2.071970438846738871e-02,
-2.072506918039695653e-02,
-2.073039994254013280e-02,
-2.073569666860755265e-02,
-2.074095935236532073e-02,
-2.074618798763524369e-02,
-2.075138256829468439e-02,
-2.075654308827677708e-02,
-2.076166954156995897e-02,
-2.076676192221869194e-02,
-2.077182022432272693e-02,
-2.077684444203777014e-02,
-2.078183456957494873e-02,
-2.078679060120120631e-02,
-2.079171253123902885e-02,
-2.079660035406668064e-02,
-2.080145406411795447e-02,
-2.080627365588251509e-02,
-2.081105912390543780e-02,
-2.081581046278787456e-02,
-2.082052766718634970e-02,
-2.082521073181313812e-02,
-2.082985965143636237e-02,
-2.083447442087969434e-02,
-2.083905503502263973e-02,
-2.084360148880028477e-02,
-2.084811377720358419e-02,
-2.085259189527917389e-02,
-2.085703583812930847e-02,
-2.086144560091219430e-02,
-2.086582117884151419e-02,
-2.087016256718692703e-02,
-2.087446976127367917e-02,
-2.087874275648281264e-02,
-2.088298154825122752e-02,
-2.088718613207141833e-02,
-2.089135650349174117e-02,
-2.089549265811617776e-02,
-2.089959459160473446e-02,
-2.090366229967298081e-02,
-2.090769577809222304e-02,
-2.091169502268983710e-02,
-2.091566002934855048e-02,
-2.091959079400719859e-02,
-2.092348731266033268e-02,
-2.092734958135818515e-02,
-2.093117759620688814e-02,
-2.093497135336835208e-02,
-2.093873084906021712e-02,
-2.094245607955600927e-02,
-2.094614704118490447e-02,
-2.094980373033211371e-02,
-2.095342614343838686e-02,
-2.095701427700050537e-02,
-2.096056812757088328e-02,
-2.096408769175797659e-02,
-2.096757296622568309e-02,
-2.097102394769401190e-02,
-2.097444063293873659e-02,
-2.097782301879134656e-02,
-2.098117110213928993e-02,
-2.098448487992566822e-02,
-2.098776434914954858e-02,
-2.099100950686565159e-02,
-2.099422035018472590e-02,
-2.099739687627310766e-02,
-2.100053908235321315e-02,
-2.100364696570303225e-02,
-2.100672052365655171e-02,
-2.100975975360352965e-02,
-2.101276465298947821e-02,
-2.101573521931585087e-02,
-2.101867145013981697e-02,
-2.102157334307443864e-02,
-2.102444089578859795e-02,
-2.102727410600700383e-02,
-2.103007297151011923e-02,
-2.103283749013431028e-02,
-2.103556765977172144e-02,
-2.103826347837037605e-02,
-2.104092494393403068e-02,
-2.104355205452240751e-02,
-2.104614480825080930e-02,
-2.104870320329067443e-02,
-2.105122723786892469e-02,
-2.105371691026857242e-02,
-2.105617221882828335e-02,
-2.105859316194265418e-02,
-2.106097973806199050e-02,
-2.106333194569254275e-02,
-2.106564978339617658e-02,
-2.106793324979080659e-02,
-2.107018234354987932e-02,
-2.107239706340289717e-02,
-2.107457740813511310e-02,
-2.107672337658746120e-02,
-2.107883496765677878e-02,
-2.108091218029569530e-02,
-2.108295501351264284e-02,
-2.108496346637175889e-02,
-2.108693753799312579e-02,
-2.108887722755248273e-02,
-2.109078253428144784e-02,
-2.109265345746734813e-02,
-2.109448999645338954e-02,
-2.109629215063843141e-02,
-2.109805991947724668e-02,
-2.109979330248018189e-02,
-2.110149229921361516e-02,
-2.110315690929955371e-02,
-2.110478713241569979e-02,
-2.110638296829566232e-02,
-2.110794441672872099e-02,
-2.110947147755989906e-02,
-2.111096415069000157e-02,
-2.111242243607565003e-02,
-2.111384633372908812e-02,
-2.111523584371836557e-02,
-2.111659096616721326e-02,
-2.111791170125516814e-02,
-2.111919804921740321e-02,
-2.112045001034492525e-02,
-2.112166758498441529e-02,
-2.112285077353821122e-02,
-2.112399957646439105e-02,
-2.112511399427678682e-02,
-2.112619402754489090e-02,
-2.112723967689390109e-02,
-2.112825094300467207e-02,
-2.112922782661385071e-02,
-2.113017032851357765e-02,
-2.113107844955183431e-02,
-2.113195219063225203e-02,
-2.113279155271404613e-02,
-2.113359653681213743e-02,
-2.113436714399706540e-02,
-2.113510337539518599e-02,
-2.113580523218824836e-02,
-2.113647271561378341e-02,
-2.113710582696497892e-02,
-2.113770456759049218e-02,
-2.113826893889482472e-02,
-2.113879894233791634e-02,
-2.113929457943534984e-02,
-2.113975585175837529e-02,
-2.114018276093370188e-02,
-2.114057530864383791e-02,
-2.114093349662672303e-02,
-2.114125732667579069e-02,
-2.114154680064029776e-02,
-2.114180192042483877e-02,
-2.114202268798962350e-02,
-2.114220910535048736e-02,
-2.114236117457868325e-02,
-2.114247889780112438e-02,
-2.114256227720013800e-02,
-2.114261131501362148e-02,
-2.114262601353501109e-02,
-2.114260637511320914e-02,
-2.114255240215254239e-02,
-2.114246409711297014e-02,
-2.114234146250989002e-02,
-2.114218450091404078e-02,
-2.114199321495189091e-02,
-2.114176760730505575e-02,
-2.114150768071084568e-02,
-2.114121343796185673e-02,
-2.114088488190616483e-02,
-2.114052201544738135e-02,
-2.114012484154434782e-02,
-2.113969336321134748e-02,
-2.113922758351825804e-02,
-2.113872750559002422e-02,
-2.113819313260724767e-02,
-2.113762446780573581e-02,
-2.113702151447678645e-02,
-2.113638427596691710e-02,
-2.113571275567806620e-02,
-2.113500695706754459e-02,
-2.113426688364787587e-02,
-2.113349253898697336e-02,
-2.113268392670802909e-02,
-2.113184105048957970e-02,
-2.113096391406539890e-02,
-2.113005252122449745e-02,
-2.112910687581131056e-02,
-2.112812698172529882e-02,
-2.112711284292138544e-02,
-2.112606446340956415e-02,
-2.112498184725522532e-02,
-2.112386499857880212e-02,
-2.112271392155600641e-02,
-2.112152862041780446e-02,
-2.112030909945024001e-02,
-2.111905536299455918e-02,
-2.111776741544722433e-02,
-2.111644526125981344e-02,
-2.111508890493899240e-02,
-2.111369835104669190e-02,
-2.111227360419980909e-02,
-2.111081466907043999e-02,
-2.110932155038573385e-02,
-2.110779425292795553e-02,
-2.110623278153445428e-02,
-2.110463714109756320e-02,
-2.110300733656474831e-02,
-2.110134337293842824e-02,
-2.109964525527612683e-02,
-2.109791298869041418e-02,
-2.109614657834870538e-02,
-2.109434602947357629e-02,
-2.109251134734236449e-02,
-2.109064253728765506e-02,
-2.108873960469684339e-02,
-2.108680255501206927e-02,
-2.108483139373080323e-02,
-2.108282612640512838e-02,
-2.108078675864211507e-02,
-2.107871329610375155e-02,
-2.107660574450682597e-02,
-2.107446410962307906e-02,
-2.107228839727905839e-02,
-2.107007861335611840e-02,
-2.106783476379054179e-02,
-2.106555685457321345e-02,
-2.106324489175011652e-02,
-2.106089888142171490e-02,
-2.105851882974339034e-02,
-2.105610474292531412e-02,
-2.105365662723237413e-02,
-2.105117448898406046e-02,
-2.104865833455476024e-02,
-2.104610817037340029e-02,
-2.104352400292376982e-02,
-2.104090583874417345e-02,
-2.103825368442761856e-02,
-2.103556754662171818e-02,
-2.103284743202884360e-02,
-2.103009334740586073e-02,
-2.102730529956426883e-02,
-2.102448329537017629e-02,
-2.102162734174417569e-02,
-2.101873744566145480e-02,
-2.101581361415182439e-02,
-2.101285585429954472e-02,
-2.100986417324330821e-02,
-2.100683857817651004e-02,
-2.100377907634680755e-02,
-2.100068567505639083e-02,
-2.099755838166195501e-02,
-2.099439720357462388e-02,
-2.099120214825983197e-02,
-2.098797322323743900e-02,
-2.098471043608179931e-02,
-2.098141379442152593e-02,
-2.097808330593968831e-02,
-2.097471897837352439e-02,
-2.097132081951475976e-02,
-2.096788883720929197e-02,
-2.096442303935741949e-02,
-2.096092343391362661e-02,
-2.095739002888669447e-02,
-2.095382283233960738e-02,
-2.095022185238961179e-02,
-2.094658709720811571e-02,
-2.094291857502069906e-02,
-2.093921629410716925e-02,
-2.093548026280143970e-02,
-2.093171048949165822e-02,
-2.092790698261991905e-02,
-2.092406975068246758e-02,
-2.092019880222976622e-02,
-2.091629414586615443e-02,
-2.091235579025017485e-02,
-2.090838374409428532e-02,
-2.090437801616503583e-02,
-2.090033861528294012e-02,
-2.089626555032237862e-02,
-2.089215883021195222e-02,
-2.088801846393388909e-02,
-2.088384446052457197e-02,
-2.087963682907424331e-02,
-2.087539557872685261e-02,
-2.087112071868047966e-02,
-2.086681225818686619e-02,
-2.086247020655164486e-02,
-2.085809457313426291e-02,
-2.085368536734796482e-02,
-2.084924259865973684e-02,
-2.084476627659034853e-02,
-2.084025641071423143e-02,
-2.083571301065961431e-02,
-2.083113608610841563e-02,
-2.082652564679617069e-02,
-2.082188170251216691e-02,
-2.081720426309923225e-02,
-2.081249333845380106e-02,
-2.080774893852603558e-02,
-2.080297107331955872e-02,
-2.079815975289156169e-02,
-2.079331498735281780e-02,
-2.078843678686758886e-02,
-2.078352516165372921e-02,
-2.077858012198230755e-02,
-2.077360167817818987e-02,
-2.076858984061944607e-02,
-2.076354461973761376e-02,
-2.075846602601774324e-02,
-2.075335406999797086e-02,
-2.074820876227022326e-02,
-2.074303011347932574e-02,
-2.073781813432369267e-02,
-2.073257283555486261e-02,
-2.072729422797780358e-02,
-2.072198232245064595e-02,
-2.071663712988474834e-02,
-2.071125866124464907e-02,
-2.070584692754815631e-02,
-2.070040193986612612e-02,
-2.069492370932274339e-02,
-2.068941224709500842e-02,
-2.068386756441342039e-02,
-2.067828967256121059e-02,
-2.067267858287480387e-02,
-2.066703430674366945e-02,
-2.066135685561030361e-02,
-2.065564624097008389e-02,
-2.064990247437148083e-02,
-2.064412556741582541e-02,
-2.063831553175743405e-02,
-2.063247237910351833e-02,
-2.062659612121398034e-02,
-2.062068676990190877e-02,
-2.061474433703295098e-02,
-2.060876883452568767e-02,
-2.060276027435151494e-02,
-2.059671866853443264e-02,
-2.059064402915132888e-02,
-2.058453636833178571e-02,
-2.057839569825802364e-02,
-2.057222203116492940e-02,
-2.056601537934016691e-02,
-2.055977575512386510e-02,
-2.055350317090880868e-02,
-2.054719763914035144e-02,
-2.054085917231647865e-02,
-2.053448778298748445e-02,
-2.052808348375641939e-02,
-2.052164628727876777e-02,
-2.051517620626232968e-02,
-2.050867325346744305e-02,
-2.050213744170683444e-02,
-2.049556878384561909e-02,
-2.048896729280125228e-02,
-2.048233298154343227e-02,
-2.047566586309443326e-02,
-2.046896595052853304e-02,
-2.046223325697248130e-02,
-2.045546779560503819e-02,
-2.044866957965749479e-02,
-2.044183862241288549e-02,
-2.043497493720683456e-02,
-2.042807853742692470e-02,
-2.042114943651269360e-02,
-2.041418764795609533e-02,
-2.040719318530082038e-02,
-2.040016606214286113e-02,
-2.039310629212997411e-02,
-2.038601388896203737e-02,
-2.037888886639092553e-02,
-2.037173123822035026e-02,
-2.036454101830596081e-02,
-2.035731822055528856e-02,
-2.035006285892768801e-02,
-2.034277494743438192e-02,
-2.033545450013837450e-02,
-2.032810153115449658e-02,
-2.032071605464917663e-02,
-2.031329808484078070e-02,
-2.030584763599918574e-02,
-2.029836472244595652e-02,
-2.029084935855442542e-02,
-2.028330155874939061e-02,
-2.027572133750739011e-02,
-2.026810870935637568e-02,
-2.026046368887595567e-02,
-2.025278629069710012e-02,
-2.024507652950238365e-02,
-2.023733442002581193e-02,
-2.022955997705280437e-02,
-2.022175321542006576e-02,
-2.021391415001595401e-02,
-2.020604279577978973e-02,
-2.019813916770257789e-02,
-2.019020328082627228e-02,
-2.018223515024433062e-02,
-2.017423479110141971e-02,
-2.016620221859324186e-02,
-2.015813744796682294e-02,
-2.015004049452025561e-02,
-2.014191137360289707e-02,
-2.013375010061498049e-02,
-2.012555669100784747e-02,
-2.011733116028402088e-02,
-2.010907352399698284e-02,
-2.010078379775104632e-02,
-2.009246199720161538e-02,
-2.008410813805492495e-02,
-2.007572223606813450e-02,
-2.006730430704926210e-02,
-2.005885436685719142e-02,
-2.005037243140155717e-02,
-2.004185851664279372e-02,
-2.003331263859201017e-02,
-2.002473481331118119e-02,
-2.001612505691275495e-02,
-2.000748338556002440e-02,
-1.999880981546684963e-02,
-1.999010436289757470e-02,
-1.998136704416733633e-02,
-1.997259787564152275e-02,
-1.996379687373619691e-02,
-1.995496405491797159e-02,
-1.994609943570381863e-02,
-1.993720303266094396e-02,
-1.992827486240733581e-02,
-1.991931494161092164e-02,
-1.991032328699025508e-02,
-1.990129991531396775e-02,
-1.989224484340113702e-02,
-1.988315808812095645e-02,
-1.987403966639290226e-02,
-1.986488959518657380e-02,
-1.985570789152156512e-02,
-1.984649457246789178e-02,
-1.983724965514531077e-02,
-1.982797315672399710e-02,
-1.981866509442377702e-02,
-1.980932548551471786e-02,
-1.979995434731665963e-02,
-1.979055169719954113e-02,
-1.978111755258294552e-02,
-1.977165193093654433e-02,
-1.976215484977978873e-02,
-1.975262632668188176e-02,
-1.974306637926172628e-02,
-1.973347502518812274e-02,
-1.972385228217928693e-02,
-1.971419816800355426e-02,
-1.970451270047833894e-02,
-1.969479589747109849e-02,
-1.968504777689876473e-02,
-1.967526835672759808e-02,
-1.966545765497365594e-02,
-1.965561568970212308e-02,
-1.964574247902801593e-02,
-1.963583804111544706e-02,
-1.962590239417812826e-02,
-1.961593555647892992e-02,
-1.960593754633011346e-02,
-1.959590838209319258e-02,
-1.958584808217895754e-02,
-1.957575666504734677e-02,
-1.956563414920758914e-02,
-1.955548055321790560e-02,
-1.954529589568581791e-02,
-1.953508019526764561e-02,
-1.952483347066904032e-02,
-1.951455574064452428e-02,
-1.950424702399739321e-02,
-1.949390733958040328e-02,
-1.948353670629467127e-02,
-1.947313514309055582e-02,
-1.946270266896702947e-02,
-1.945223930297205681e-02,
-1.944174506420212611e-02,
-1.943121997180271079e-02,
-1.942066404496781834e-02,
-1.941007730294034422e-02,
-1.939945976501152025e-02,
-1.938881145052134131e-02,
-1.937813237885835371e-02,
-1.936742256945966911e-02,
-1.935668204181075630e-02,
-1.934591081544564939e-02,
-1.933510890994682291e-02,
-1.932427634494512936e-02,
-1.931341314011979921e-02,
-1.930251931519809741e-02,
-1.929159488995602426e-02,
-1.928063988421754166e-02,
-1.926965431785501379e-02,
-1.925863821078867971e-02,
-1.924759158298726056e-02,
-1.923651445446729683e-02,
-1.922540684529368271e-02,
-1.921426877557901730e-02,
-1.920310026548420479e-02,
-1.919190133521790631e-02,
-1.918067200503693198e-02,
-1.916941229524566151e-02,
-1.915812222619668950e-02,
-1.914680181829004485e-02,
-1.913545109197386726e-02,
-1.912407006774395624e-02,
-1.911265876614360801e-02,
-1.910121720776417065e-02,
-1.908974541324423915e-02,
-1.907824340327033200e-02,
-1.906671119857625274e-02,
-1.905514881994354454e-02,
-1.904355628820120216e-02,
-1.903193362422557489e-02,
-1.902028084894044971e-02,
-1.900859798331714506e-02,
-1.899688504837406325e-02,
-1.898514206517713451e-02,
-1.897336905483935562e-02,
-1.896156603852122355e-02,
-1.894973303743016993e-02,
-1.893787007282094273e-02,
-1.892597716599520724e-02,
-1.891405433830200752e-02,
-1.890210161113710721e-02,
-1.889011900594347523e-02,
-1.887810654421106030e-02,
-1.886606424747656885e-02,
-1.885399213732387794e-02,
-1.884189023538323723e-02,
-1.882975856333231335e-02,
-1.881759714289502061e-02,
-1.880540599584230518e-02,
-1.879318514399175993e-02,
-1.878093460920759322e-02,
-1.876865441340061849e-02,
-1.875634457852837222e-02,
-1.874400512659462822e-02,
-1.873163607964998048e-02,
-1.871923745979134010e-02,
-1.870680928916214000e-02,
-1.869435158995205043e-02,
-1.868186438439714200e-02,
-1.866934769477989961e-02,
-1.865680154342888586e-02,
-1.864422595271906721e-02,
-1.863162094507154684e-02,
-1.861898654295364094e-02,
-1.860632276887853875e-02,
-1.859362964540579172e-02,
-1.858090719514081043e-02,
-1.856815544073507976e-02,
-1.855537440488585349e-02,
-1.854256411033671295e-02,
-1.852972457987662677e-02,
-1.851685583634079396e-02,
-1.850395790260982859e-02,
-1.849103080161050225e-02,
-1.847807455631492873e-02,
-1.846508918974109834e-02,
-1.845207472495270090e-02,
-1.843903118505875460e-02,
-1.842595859321411247e-02,
-1.841285697261888302e-02,
-1.839972634651890898e-02,
-1.838656673820514634e-02,
-1.837337817101428530e-02,
-1.836016066832803911e-02,
-1.834691425357375463e-02,
-1.833363895022368725e-02,
-1.832033478179563232e-02,
-1.830700177185230412e-02,
-1.829363994400178342e-02,
-1.828024932189708032e-02,
-1.826682992923642918e-02,
-1.825338178976286183e-02,
-1.823990492726466905e-02,
-1.822639936557482118e-02,
-1.821286512857117276e-02,
-1.819930224017666034e-02,
-1.818571072435885144e-02,
-1.817209060513025332e-02,
-1.815844190654774745e-02,
-1.814476465271334243e-02,
-1.813105886777331352e-02,
-1.811732457591883755e-02,
-1.810356180138523660e-02,
-1.808977056845291129e-02,
-1.807595090144625480e-02,
-1.806210282473438497e-02,
-1.804822636273057876e-02,
-1.803432153989263653e-02,
-1.802038838072254207e-02,
-1.800642690976659091e-02,
-1.799243715161536611e-02,
-1.797841913090343635e-02,
-1.796437287230969945e-02,
-1.795029840055701459e-02,
-1.793619574041233067e-02,
-1.792206491668657184e-02,
-1.790790595423459239e-02,
-1.789371887795534327e-02,
-1.787950371279152517e-02,
-1.786526048372939421e-02,
-1.785098921579961195e-02,
-1.783668993407589928e-02,
-1.782236266367609803e-02,
-1.780800742976165751e-02,
-1.779362425753763452e-02,
-1.777921317225242270e-02,
-1.776477419919827300e-02,
-1.775030736371065870e-02,
-1.773581269116859122e-02,
-1.772129020699447777e-02,
-1.770673993665400348e-02,
-1.769216190565636032e-02,
-1.767755613955365041e-02,
-1.766292266394157637e-02,
-1.764826150445868158e-02,
-1.763357268678680118e-02,
-1.761885623665082612e-02,
-1.760411217981878648e-02,
-1.758934054210139347e-02,
-1.757454134935271597e-02,
-1.755971462746931319e-02,
-1.754486040239099792e-02,
-1.752997870009997614e-02,
-1.751506954662156168e-02,
-1.750013296802368015e-02,
-1.748516899041701114e-02,
-1.747017763995462741e-02,
-1.745515894283231409e-02,
-1.744011292528856866e-02,
-1.742503961360409789e-02,
-1.740993903410220645e-02,
-1.739481121314866152e-02,
-1.737965617715158881e-02,
-1.736447395256114981e-02,
-1.734926456587014554e-02,
-1.733402804361332608e-02,
-1.731876441236773062e-02,
-1.730347369875259028e-02,
-1.728815592942917548e-02,
-1.727281113110064326e-02,
-1.725743933051242587e-02,
-1.724204055445154038e-02,
-1.722661482974730332e-02,
-1.721116218327051195e-02,
-1.719568264193403750e-02,
-1.718017623269247132e-02,
-1.716464298254189585e-02,
-1.714908291852045019e-02,
-1.713349606770744535e-02,
-1.711788245722402346e-02,
-1.710224211423297738e-02,
-1.708657506593835168e-02,
-1.707088133958563694e-02,
-1.705516096246183569e-02,
-1.703941396189517440e-02,
-1.702364036525529437e-02,
-1.700784019995283877e-02,
-1.699201349343996623e-02,
-1.697616027320977480e-02,
-1.696028056679663512e-02,
-1.694437440177568033e-02,
-1.692844180576339938e-02,
-1.691248280641705765e-02,
-1.689649743143457894e-02,
-1.688048570855543717e-02,
-1.686444766555925470e-02,
-1.684838333026685009e-02,
-1.683229273053940891e-02,
-1.681617589427916032e-02,
-1.680003284942857902e-02,
-1.678386362397106188e-02,
-1.676766824593031724e-02,
-1.675144674337079864e-02,
-1.673519914439692072e-02,
-1.671892547715399940e-02,
-1.670262576982728397e-02,
-1.668630005064261623e-02,
-1.666994834786579560e-02,
-1.665357068980308219e-02,
-1.663716710480073885e-02,
-1.662073762124518031e-02,
-1.660428226756282058e-02,
-1.658780107221994454e-02,
-1.657129406372301328e-02,
-1.655476127061833447e-02,
-1.653820272149210055e-02,
-1.652161844496999321e-02,
-1.650500846971795013e-02,
-1.648837282444111721e-02,
-1.647171153788471593e-02,
-1.645502463883323496e-02,
-1.643831215611091939e-02,
-1.642157411858143762e-02,
-1.640481055514806177e-02,
-1.638802149475319242e-02,
-1.637120696637894487e-02,
-1.635436699904629226e-02,
-1.633750162181586002e-02,
-1.632061086378738812e-02,
-1.630369475409958191e-02,
-1.628675332193060474e-02,
-1.626978659649725920e-02,
-1.625279460705573997e-02,
-1.623577738290088446e-02,
-1.621873495336667581e-02,
-1.620166734782583357e-02,
-1.618457459569008425e-02,
-1.616745672640947096e-02,
-1.615031376947328665e-02,
-1.613314575440895696e-02,
-1.611595271078304636e-02,
-1.609873466820016183e-02,
-1.608149165630373689e-02,
-1.606422370477561534e-02,
-1.604693084333610673e-02,
-1.602961310174356654e-02,
-1.601227050979509015e-02,
-1.599490309732560026e-02,
-1.597751089420852352e-02,
-1.596009393035538806e-02,
-1.594265223571561529e-02,
-1.592518584027701606e-02,
-1.590769477406499613e-02,
-1.589017906714333336e-02,
-1.587263874961332075e-02,
-1.585507385161429722e-02,
-1.583748440332340135e-02,
-1.581987043495554010e-02,
-1.580223197676307659e-02,
-1.578456905903631580e-02,
-1.576688171210285580e-02,
-1.574916996632806654e-02,
-1.573143385211469431e-02,
-1.571367339990301787e-02,
-1.569588864017055010e-02,
-1.567807960343206575e-02,
-1.566024632023993793e-02,
-1.564238882118336449e-02,
-1.562450713688900636e-02,
-1.560660129802058337e-02,
-1.558867133527892454e-02,
-1.557071727940152923e-02,
-1.555273916116341887e-02,
-1.553473701137601630e-02,
-1.551671086088796635e-02,
-1.549866074058430139e-02,
-1.548058668138745965e-02,
-1.546248871425589567e-02,
-1.544436687018520271e-02,
-1.542622118020715687e-02,
-1.540805167539050294e-02,
-1.538985838684008359e-02,
-1.537164134569742914e-02,
-1.535340058314045748e-02,
-1.533513613038315487e-02,
-1.531684801867620564e-02,
-1.529853627930604504e-02,
-1.528020094359569016e-02,
-1.526184204290390208e-02,
-1.524345960862583116e-02,
-1.522505367219249839e-02,
-1.520662426507095842e-02,
-1.518817141876396999e-02,
-1.516969516481040704e-02,
-1.515119553478469494e-02,
-1.513267256029711579e-02,
-1.511412627299369392e-02,
-1.509555670455615083e-02,
-1.507696388670148185e-02,
-1.505834785118254603e-02,
-1.503970862978751266e-02,
-1.502104625433985097e-02,
-1.500236075669869780e-02,
-1.498365216875827306e-02,
-1.496492052244831339e-02,
-1.494616584973329845e-02,
-1.492738818261339639e-02,
-1.490858755312341952e-02,
-1.488976399333358930e-02,
-1.487091753534864128e-02,
-1.485204821130893353e-02,
-1.483315605338905545e-02,
-1.481424109379884946e-02,
-1.479530336478259746e-02,
-1.477634289861963143e-02,
-1.475735972762359446e-02,
-1.473835388414293512e-02,
-1.471932540056084156e-02,
-1.470027430929451637e-02,
-1.468120064279611857e-02,
-1.466210443355171582e-02,
-1.464298571408214830e-02,
-1.462384451694215444e-02,
-1.460468087472092079e-02,
-1.458549482004179929e-02,
-1.456628638556228643e-02,
-1.454705560397365378e-02,
-1.452780250800152564e-02,
-1.450852713040517127e-02,
-1.448922950397797844e-02,
-1.446990966154707882e-02,
-1.445056763597348144e-02,
-1.443120346015165124e-02,
-1.441181716701011618e-02,
-1.439240878951059469e-02,
-1.437297836064870687e-02,
-1.435352591345334140e-02,
-1.433405148098691392e-02,
-1.431455509634543301e-02,
-1.429503679265781146e-02,
-1.427549660308672329e-02,
-1.425593456082755589e-02,
-1.423635069910923409e-02,
-1.421674505119374828e-02,
-1.419711765037613531e-02,
-1.417746852998418364e-02,
-1.415779772337904217e-02,
-1.413810526395427661e-02,
-1.411839118513672810e-02,
-1.409865552038563029e-02,
-1.407889830319319739e-02,
-1.405911956708422172e-02,
-1.403931934561617086e-02,
-1.401949767237890658e-02,
-1.399965458099470400e-02,
-1.397979010511868347e-02,
-1.395990427843782355e-02,
-1.393999713467180233e-02,
-1.392006870757245100e-02,
-1.390011903092388916e-02,
-1.388014813854203562e-02,
-1.386015606427546190e-02,
-1.384014284200414321e-02,
-1.382010850564052186e-02,
-1.380005308912878557e-02,
-1.377997662644516418e-02,
-1.375987915159722179e-02,
-1.373976069862486125e-02,
-1.371962130159911676e-02,
-1.369946099462319121e-02,
-1.367927981183137721e-02,
-1.365907778738982038e-02,
-1.363885495549620706e-02,
-1.361861135037911383e-02,
-1.359834700629910208e-02,
-1.357806195754748119e-02,
-1.355775623844714811e-02,
-1.353742988335206524e-02,
-1.351708292664735925e-02,
-1.349671540274901584e-02,
-1.347632734610439489e-02,
-1.345591879119127643e-02,
-1.343548977251887711e-02,
-1.341504032462678339e-02,
-1.339457048208566627e-02,
-1.337408027949678509e-02,
-1.335356975149218188e-02,
-1.333303893273412276e-02,
-1.331248785791590630e-02,
-1.329191656176095804e-02,
-1.327132507902312880e-02,
-1.325071344448684567e-02,
-1.323008169296668347e-02,
-1.320942985930767359e-02,
-1.318875797838459096e-02,
-1.316806608510290647e-02,
-1.314735421439755698e-02,
-1.312662240123400534e-02,
-1.310587068060738852e-02,
-1.308509908754296007e-02,
-1.306430765709539268e-02,
-1.304349642434969939e-02,
-1.302266542442000186e-02,
-1.300181469245065453e-02,
-1.298094426361514307e-02,
-1.296005417311677649e-02,
-1.293914445618828124e-02,
-1.291821514809190011e-02,
-1.289726628411899667e-02,
-1.287629789959026348e-02,
-1.285531002985589206e-02,
-1.283430271029504903e-02,
-1.281327597631624383e-02,
-1.279222986335665918e-02,
-1.277116440688294899e-02,
-1.275007964239028430e-02,
-1.272897560540313389e-02,
-1.270785233147437784e-02,
-1.268670985618600144e-02,
-1.266554821514853310e-02,
-1.264436744400136356e-02,
-1.262316757841205200e-02,
-1.260194865407719515e-02,
-1.258071070672136735e-02,
-1.255945377209788556e-02,
-1.253817788598849368e-02,
-1.251688308420279179e-02,
-1.249556940257915902e-02,
-1.247423687698358957e-02,
-1.245288554331074223e-02,
-1.243151543748281275e-02,
-1.241012659545035444e-02,
-1.238871905319167965e-02,
-1.236729284671320150e-02,
-1.234584801204871053e-02,
-1.232438458526023337e-02,
-1.230290260243701791e-02,
-1.228140209969642328e-02,
-1.225988311318291189e-02,
-1.223834567906874685e-02,
-1.221678983355365539e-02,
-1.219521561286472655e-02,
-1.217362305325612321e-02,
-1.215201219100966318e-02,
-1.213038306243401261e-02,
-1.210873570386520465e-02,
-1.208707015166650238e-02,
-1.206538644222769109e-02,
-1.204368461196610694e-02,
-1.202196469732544695e-02,
-1.200022673477680289e-02,
-1.197847076081744004e-02,
-1.195669681197186578e-02,
-1.193490492479098650e-02,
-1.191309513585251181e-02,
-1.189126748176027280e-02,
-1.186942199914514141e-02,
-1.184755872466382309e-02,
-1.182567769499982477e-02,
-1.180377894686274014e-02,
-1.178186251698861049e-02,
-1.175992844213932451e-02,
-1.173797675910291313e-02,
-1.171600750469382543e-02,
-1.169402071575201263e-02,
-1.167201642914369661e-02,
-1.164999468176085816e-02,
-1.162795551052139137e-02,
-1.160589895236856760e-02,
-1.158382504427181436e-02,
-1.156173382322573523e-02,
-1.153962532625093032e-02,
-1.151749959039299886e-02,
-1.149535665272337359e-02,
-1.147319655033871184e-02,
-1.145101932036110201e-02,
-1.142882499993754658e-02,
-1.140661362624069072e-02,
-1.138438523646779360e-02,
-1.136213986784159226e-02,
-1.133987755760978988e-02,
-1.131759834304469324e-02,
-1.129530226144389617e-02,
-1.127298935012939832e-02,
-1.125065964644841009e-02,
-1.122831318777231698e-02,
-1.120595001149754522e-02,
-1.118357015504494421e-02,
-1.116117365585998430e-02,
-1.113876055141217389e-02,
-1.111633087919594066e-02,
-1.109388467672952489e-02,
-1.107142198155574783e-02,
-1.104894283124158681e-02,
-1.102644726337816301e-02,
-1.100393531558035119e-02,
-1.098140702548754816e-02,
-1.095886243076263887e-02,
-1.093630156909245442e-02,
-1.091372447818788304e-02,
-1.089113119578337396e-02,
-1.086852175963727921e-02,
-1.084589620753115963e-02,
-1.082325457727062457e-02,
-1.080059690668433263e-02,
-1.077792323362483130e-02,
-1.075523359596743111e-02,
-1.073252803161166453e-02,
-1.070980657847936737e-02,
-1.068706927451626952e-02,
-1.066431615769066789e-02,
-1.064154726599442213e-02,
-1.061876263744193118e-02,
-1.059596231007086525e-02,
-1.057314632194173397e-02,
-1.055031471113757231e-02,
-1.052746751576460159e-02,
-1.050460477395118337e-02,
-1.048172652384889332e-02,
-1.045883280363125306e-02,
-1.043592365149479013e-02,
-1.041299910565816368e-02,
-1.039005920436267966e-02,
-1.036710398587147725e-02,
-1.034413348847044653e-02,
-1.032114775046717378e-02,
-1.029814681019172382e-02,
-1.027513070599604672e-02,
-1.025209947625427102e-02,
-1.022905315936200980e-02,
-1.020599179373726621e-02,
-1.018291541781930418e-02,
-1.015982407006963024e-02,
-1.013671778897094582e-02,
-1.011359661302787399e-02,
-1.009046058076660743e-02,
-1.006730973073444689e-02,
-1.004414410150059576e-02,
-1.002096373165505157e-02,
-9.997768659809645048e-03,
-9.974558924596820669e-03,
-9.951334564670991437e-03,
-9.928095618706826719e-03,
-9.904842125400657379e-03,
-9.881574123469188606e-03,
-9.858291651650651771e-03,
-9.834994748703482573e-03,
-9.811683453407367070e-03,
-9.788357804562497488e-03,
-9.765017840989889675e-03,
-9.741663601530836658e-03,
-9.718295125047141103e-03,
-9.694912450421490011e-03,
-9.671515616556370515e-03,
-9.648104662375048268e-03,
-9.624679626820833653e-03,
-9.601240548857446072e-03,
-9.577787467468242000e-03,
-9.554320421657221118e-03,
-9.530839450447858852e-03,
-9.507344592883928622e-03,
-9.483835888028986638e-03,
-9.460313374966422204e-03,
-9.436777092799100361e-03,
-9.413227080649967313e-03,
-9.389663377661131016e-03,
-9.366086022994749363e-03,
-9.342495055831939038e-03,
-9.318890515373554409e-03,
-9.295272440839887421e-03,
-9.271640871470110748e-03,
-9.247995846523087912e-03,
-9.224337405276358468e-03,
-9.200665587026937708e-03,
-9.176980431090740742e-03,
-9.153281976802721265e-03,
-9.129570263516429210e-03,
-9.105845330604666471e-03,
-9.082107217458562295e-03,
-9.058355963488409421e-03,
-9.034591608122626710e-03,
-9.010814190808631718e-03,
-8.987023751012157211e-03,
-8.963220328217570351e-03,
-8.939403961927154529e-03,
-8.915574691662068660e-03,
-8.891732556961301145e-03,
-8.867877597382054985e-03,
-8.844009852499857063e-03,
-8.820129361908174773e-03,
-8.796236165218584285e-03,
-8.772330302060198093e-03,
-8.748411812080511551e-03,
-8.724480734944252761e-03,
-8.700537110334265536e-03,
-8.676580977950957771e-03,
-8.652612377512428066e-03,
-8.628631348753901947e-03,
-8.604637931428580147e-03,
-8.580632165306568276e-03,
-8.556614090175815313e-03,
-8.532583745840942660e-03,
-8.508541172124267637e-03,
-8.484486408865026322e-03,
-8.460419495919691002e-03,
-8.436340473161465375e-03,
-8.412249380480461489e-03,
-8.388146257783946069e-03,
-8.364031144995865211e-03,
-8.339904082056981416e-03,
-8.315765108924415630e-03,
-8.291614265572344600e-03,
-8.267451591990975651e-03,
-8.243277128187552830e-03,
-8.219090914185179023e-03,
-8.194892990023659035e-03,
-8.170683395758984377e-03,
-8.146462171463466836e-03,
-8.122229357225179899e-03,
-8.097984993148775804e-03,
-8.073729119354434297e-03,
-8.049461775978769898e-03,
-8.025183003173756366e-03,
-8.000892841107583656e-03,
-7.976591329964170460e-03,
-7.952278509942753079e-03,
-7.927954421258653905e-03,
-7.903619104142297833e-03,
-7.879272598839918290e-03,
-7.854914945613043764e-03,
-7.830546184738723312e-03,
-7.806166356508849151e-03,
-7.781775501231089943e-03,
-7.757373659227685160e-03,
-7.732960870836544029e-03,
-7.708537176410070260e-03,
-7.684102616315948743e-03,
-7.659657230936662425e-03,
-7.635201060669668388e-03,
-7.610734145926734313e-03,
-7.586256527134850949e-03,
-7.561768244735133163e-03,
-7.537269339183595360e-03,
-7.512759850950768981e-03,
-7.488239820521205500e-03,
-7.463709288394329913e-03,
-7.439168295083348724e-03,
-7.414616881116181495e-03,
-7.390055087034403530e-03,
-7.365482953394037781e-03,
-7.340900520765038760e-03,
-7.316307829731413109e-03,
-7.291704920890667088e-03,
-7.267091834854690416e-03,
-7.242468612248538495e-03,
-7.217835293711349215e-03,
-7.193191919895837276e-03,
-7.168538531468313275e-03,
-7.143875169108342832e-03,
-7.119201873508896640e-03,
-7.094518685376707823e-03,
-7.069825645431291813e-03,
-7.045122794405698358e-03,
-7.020410173046087374e-03,
-6.995687822111814821e-03,
-6.970955782374790854e-03,
-6.946214094620513715e-03,
-6.921462799646764356e-03,
-6.896701938264668957e-03,
-6.871931551297605183e-03,
-6.847151679582046124e-03,
-6.822362363966878555e-03,
-6.797563645313770692e-03,
-6.772755564496382025e-03,
-6.747938162401359054e-03,
-6.723111479927180827e-03,
-6.698275557984991607e-03,
-6.673430437498151582e-03,
-6.648576159401753741e-03,
-6.623712764643510317e-03,
-6.598840294182653846e-03,
-6.573958788990827938e-03,
-6.549068290051071606e-03,
-6.524168838358614629e-03,
-6.499260474920305099e-03,
-6.474343240754801970e-03,
-6.449417176891969646e-03,
-6.424482324373750539e-03,
-6.399538724253027965e-03,
-6.374586417594496970e-03,
-6.349625445474062387e-03,
-6.324655848979014033e-03,
-6.299677669207472477e-03,
-6.274690947269245117e-03,
-6.249695724284773206e-03,
-6.224692041385499613e-03,
-6.199679939714105616e-03,
-6.174659460423994814e-03,
-6.149630644679510844e-03,
-6.124593533655301597e-03,
-6.099548168537268986e-03,
-6.074494590521326877e-03,
-6.049432840814487032e-03,
-6.024362960633682963e-03,
-5.999284991206646836e-03,
-5.974198973771312725e-03,
-5.949104949576012637e-03,
-5.924002959878863286e-03,
-5.898893045948642132e-03,
-5.873775249063665008e-03,
-5.848649610512617926e-03,
-5.823516171594145079e-03,
-5.798374973616316277e-03,
-5.773226057897537684e-03,
-5.748069465765416435e-03,
-5.722905238557717336e-03,
-5.697733417621312496e-03,
-5.672554044312919444e-03,
-5.647367159998612808e-03,
-5.622172806054024675e-03,
-5.596971023863609937e-03,
-5.571761854821712275e-03,
-5.546545340331231026e-03,
-5.521321521804638602e-03,
-5.496090440663272715e-03,
-5.470852138337662512e-03,
-5.445606656266732334e-03,
-5.420354035898884183e-03,
-5.395094318690695813e-03,
-5.369827546108040493e-03,
-5.344553759624838009e-03,
-5.319273000724036513e-03,
-5.293985310897040934e-03,
-5.268690731643319199e-03,
-5.243389304471243566e-03,
-5.218081070896927499e-03,
-5.192766072445296859e-03,
-5.167444350648702119e-03,
-5.142115947048612329e-03,
-5.116780903193521302e-03,
-5.091439260640580854e-03,
-5.066091060954318846e-03,
-5.040736345707595885e-03,
-5.015375156480476014e-03,
-4.990007534861186020e-03,
-4.964633522445362560e-03,
-4.939253160836393035e-03,
-4.913866491644843133e-03,
-4.888473556488704026e-03,
-4.863074396993741048e-03,
-4.837669054792426843e-03,
-4.812257571524886784e-03,
-4.786839988838247593e-03,
-4.761416348386851571e-03,
-4.735986691831629500e-03,
-4.710551060841025248e-03,
-4.685109497089782332e-03,
-4.659662042259898017e-03,
-4.634208738039926820e-03,
-4.608749626125271948e-03,
-4.583284748217505283e-03,
-4.557814146025305005e-03,
-4.532337861263213523e-03,
-4.506855935652803215e-03,
-4.481368410921350229e-03,
-4.455875328802854501e-03,
-4.430376731037508932e-03,
-4.404872659371172894e-03,
-4.379363155556387915e-03,
-4.353848261351068831e-03,
-4.328328018519646964e-03,
-4.302802468831702296e-03,
-4.277271654063574159e-03,
-4.251735615996353294e-03,
-4.226194396417468253e-03,
-4.200648037119376552e-03,
-4.175096579900594226e-03,
-4.149540066564560460e-03,
-4.123978538920475452e-03,
-4.098412038782727959e-03,
-4.072840607971093055e-03,
-4.047264288310084210e-03,
-4.021683121629898716e-03,
-3.996097149765322210e-03,
-3.970506414556151942e-03,
-3.944910957847333824e-03,
-3.919310821488518337e-03,
-3.893706047334279541e-03,
-3.868096677243420753e-03,
-3.842482753079992826e-03,
-3.816864316711999182e-03,
-3.791241410012391542e-03,
-3.765614074858381240e-03,
-3.739982353131695528e-03,
-3.714346286717917951e-03,
-3.688705917507422490e-03,
-3.663061287394154923e-03,
-3.637412438276735240e-03,
-3.611759412057217750e-03,
-3.586102250642029567e-03,
-3.560440995941346540e-03,
-3.534775689869280174e-03,
-3.509106374343410988e-03,
-3.483433091285012724e-03,
-3.457755882619223224e-03,
-3.432074790274578218e-03,
-3.406389856183248549e-03,
-3.380701122280364065e-03,
-3.355008630504971185e-03,
-3.329312422798794309e-03,
-3.303612541107339099e-03,
-3.277909027378674706e-03,
-3.252201923564347098e-03,
-3.226491271618761071e-03,
-3.200777113499389710e-03,
-3.175059491166138184e-03,
-3.149338446582273989e-03,
-3.123614021713193127e-03,
-3.097886258527548543e-03,
-3.072155198995983345e-03,
-3.046420885092086198e-03,
-3.020683358791910814e-03,
-2.994942662073449453e-03,
-2.969198836917590501e-03,
-2.943451925306868593e-03,
-2.917701969226457314e-03,
-2.891949010663462730e-03,
-2.866193091607207449e-03,
-2.840434254048525026e-03,
-2.814672539980742679e-03,
-2.788907991398439663e-03,
-2.763140650298549685e-03,
-2.737370558679114944e-03,
-2.711597758540255833e-03,
-2.685822291883499611e-03,
-2.660044200712014147e-03,
-2.634263527029959574e-03,
-2.608480312843439782e-03,
-2.582694600159265563e-03,
-2.556906430985899596e-03,
-2.531115847332966826e-03,
-2.505322891210740987e-03,
-2.479527604631083949e-03,
-2.453730029606237487e-03,
-2.427930208149905750e-03,
-2.402128182276017099e-03,
-2.376323993999683408e-03,
-2.350517685336555619e-03,
-2.324709298303031472e-03,
-2.298898874915611488e-03,
-2.273086457191858274e-03,
-2.247272087149162264e-03,
-2.221455806805804241e-03,
-2.195637658179643448e-03,
-2.169817683289729585e-03,
-2.143995924154386799e-03,
-2.118172422792139169e-03,
-2.092347221221956596e-03,
-2.066520361462145447e-03,
-2.040691885531306562e-03,
-2.014861835447693834e-03,
-1.989030253229421511e-03,
-1.963197180893841865e-03,
-1.937362660458457004e-03,
-1.911526733939720611e-03,
-1.885689443354106754e-03,
-1.859850830716906636e-03,
-1.834010938043154721e-03,
-1.808169807346986886e-03,
-1.782327480641868753e-03,
-1.756483999939937148e-03,
-1.730639407252962435e-03,
-1.704793744591103421e-03,
-1.678947053963858634e-03,
-1.653099377379566937e-03,
-1.627250756844916607e-03,
-1.601401234365867551e-03,
-1.575550851946440475e-03,
-1.549699651589802165e-03,
-1.523847675297038606e-03,
-1.497994965068111684e-03,
-1.472141562901184810e-03,
-1.446287510792883344e-03,
-1.420432850737611986e-03,
-1.394577624728519276e-03,
-1.368721874756270935e-03,
-1.342865642809983788e-03,
-1.317008970876598021e-03,
-1.291151900941077098e-03,
-1.265294474985777847e-03,
-1.239436734991387640e-03,
-1.213578722935841278e-03,
-1.187720480794698073e-03,
-1.161862050541350886e-03,
-1.136003474146528693e-03,
-1.110144793578531856e-03,
-1.084286050802554064e-03,
-1.058427287781660720e-03,
-1.032568546475541669e-03,
-1.006709868841616654e-03,
-9.808512968337893510e-04,
-9.549928724034191388e-04,
-9.291346374986444480e-04,
-9.032766340646390668e-04,
-8.774189040429274675e-04,
-8.515614893723664428e-04,
-8.257044319878900336e-04,
-7.998477738214764205e-04,
-7.739915568016305421e-04,
-7.481358228528943617e-04,
-7.222806138967815572e-04,
-6.964259718505634317e-04,
-6.705719386283447679e-04,
-6.447185561398548334e-04,
-6.188658662913786024e-04,
-5.930139109851198954e-04,
-5.671627321194176773e-04,
-5.413123715881009573e-04,
-5.154628712814350805e-04,
-4.896142730848982057e-04,
-4.637666188801196823e-04,
-4.379199505442447622e-04,
-4.120743099501423872e-04,
-3.862297389657759180e-04,
-3.603862794551307772e-04,
-3.345439732770038839e-04,
-3.087028622860838443e-04,
-2.828629883317329043e-04,
-2.570243932589265194e-04,
-2.311871189077554080e-04,
-2.053512071129238363e-04,
-1.795166997046927933e-04,
-1.536836385076592061e-04,
-1.278520653418401692e-04,
-1.020220220213102243e-04,
-7.619355035586178879e-05,
-5.036669214892215967e-05,
-2.454148919921291178e-05,
 1.282016700611655602e-06,
 2.710378376288123675e-05,
 5.292377020612812501e-05,
 7.874193425414699650e-05,
 1.045582341366375792e-04,
 1.303726280889846219e-04,
 1.561850743527568443e-04,
 1.819955311754851968e-04,
 2.078039568103009951e-04,
 2.336103095170070573e-04,
 2.594145475611404927e-04,
 2.852166292146139258e-04,
 3.110165127554948613e-04,
 3.368141564686497817e-04,
 3.626095186448027342e-04,
 3.884025575817533237e-04,
 4.141932315834368178e-04,
 4.399814989605700601e-04,
 4.657673180304253060e-04,
 4.915506471174760274e-04,
 5.173314445524557171e-04,
 5.431096686735777243e-04,
 5.688852778254491552e-04,
 5.946582303602897333e-04,
 6.204284846369925548e-04,
 6.461959990216208701e-04,
 6.719607318879064917e-04,
 6.977226416163134770e-04,
 7.234816865952517842e-04,
 7.492378252199918777e-04,
 7.749910158940363520e-04,
 8.007412170274452734e-04,
 8.264883870389318340e-04,
 8.522324843541898617e-04,
 8.779734674072689135e-04,
 9.037112946394792318e-04,
 9.294459245006082187e-04,
 9.551773154479947445e-04,
 9.809054259471569007e-04,
 1.006630214471573859e-03,
 1.032351639503334547e-03,
 1.058069659532191904e-03,
 1.083784233056631682e-03,
 1.109495318583519647e-03,
 1.135202874627873684e-03,
 1.160906859713362309e-03,
 1.186607232372080241e-03,
 1.212303951145199355e-03,
 1.237996974582019792e-03,
 1.263686261241187079e-03,
 1.289371769689766443e-03,
 1.315053458503857332e-03,
 1.340731286268404768e-03,
 1.366405211577810834e-03,
 1.392075193035017438e-03,
 1.417741189252710865e-03,
 1.443403158852238875e-03,
 1.469061060464830863e-03,
 1.494714852730656988e-03,
 1.520364494299474793e-03,
 1.546009943830390894e-03,
 1.571651159992379669e-03,
 1.597288101464045592e-03,
 1.622920726933267405e-03,
 1.648548995098414374e-03,
 1.674172864666682902e-03,
 1.699792294356178204e-03,
 1.725407242894256123e-03,
 1.751017669018879470e-03,
 1.776623531477536421e-03,
 1.802224789028456994e-03,
 1.827821400439680853e-03,
 1.853413324489675299e-03,
 1.879000519967135999e-03,
 1.904582945671629696e-03,
 1.930160560412627103e-03,
 1.955733323010747787e-03,
 1.981301192296674660e-03,
 2.006864127112338147e-03,
 2.032422086310019770e-03,
 2.057975028752810111e-03,
 2.083522913315138773e-03,
 2.109065698881809007e-03,
 2.134603344349229794e-03,
 2.160135808624467392e-03,
 2.185663050625880673e-03,
 2.211185029282922068e-03,
 2.236701703536753821e-03,
 2.262213032339308212e-03,
 2.287718974654532212e-03,
 2.313219489457265989e-03,
 2.338714535734480199e-03,
 2.364204072484333598e-03,
 2.389688058716808380e-03,
 2.415166453453491610e-03,
 2.440639215728203620e-03,
 2.466106304586093787e-03,
 2.491567679084803668e-03,
 2.517023298293577516e-03,
 2.542473121293709840e-03,
 2.567917107179087943e-03,
 2.593355215055220039e-03,
 2.618787404040459101e-03,
 2.644213633264929936e-03,
 2.669633861871726580e-03,
 2.695048049015986817e-03,
 2.720456153865518419e-03,
 2.745858135600582305e-03,
 2.771253953414539156e-03,
 2.796643566512908765e-03,
 2.822026934114562659e-03,
 2.847404015450678057e-03,
 2.872774769766055399e-03,
 2.898139156317501575e-03,
 2.923497134375719914e-03,
 2.948848663224399452e-03,
 2.974193702159976839e-03,
 2.999532210492728782e-03,
 3.024864147545786724e-03,
 3.050189472655841141e-03,
 3.075508145172858778e-03,
 3.100820124460764403e-03,
 3.126125369896468921e-03,
 3.151423840871097129e-03,
 3.176715496788921726e-03,
 3.202000297068533386e-03,
 3.227278201141949975e-03,
 3.252549168455222406e-03,
 3.277813158468223867e-03,
 3.303070130655272156e-03,
 3.328320044504232394e-03,
 3.353562859517683625e-03,
 3.378798535211990309e-03,
 3.404027031117830109e-03,
 3.429248306780619763e-03,
 3.454462321759673750e-03,
 3.479669035629318844e-03,
 3.504868407977868461e-03,
 3.530060398408824390e-03,
 3.555244966539921822e-03,
 3.580422072003774242e-03,
 3.605591674447688241e-03,
 3.630753733534224700e-03,
 3.655908208940331430e-03,
 3.681055060358509774e-03,
 3.706194247495768999e-03,
 3.731325730074923439e-03,
 3.756449467833024303e-03,
 3.781565420523330320e-03,
 3.806673547913731748e-03,
 3.831773809787921738e-03,
 3.856866165945026844e-03,
 3.881950576199423141e-03,
 3.907027000381173808e-03,
 3.932095398335873869e-03,
 3.957155729925210946e-03,
 3.982207955026083150e-03,
 4.007252033531787799e-03,
 4.032287925350956301e-03,
 4.057315590408742435e-03,
 4.082334988645870862e-03,
 4.107346080019322332e-03,
 4.132348824502090831e-03,
 4.157343182083777719e-03,
 4.182329112769702685e-03,
 4.207306576582118054e-03,
 4.232275533559224333e-03,
 4.257235943755716644e-03,
 4.282187767243209736e-03,
 4.307130964109374960e-03,
 4.332065494459115540e-03,
 4.356991318413458089e-03,
 4.381908396110808547e-03,
 4.406816687705975531e-03,
 4.431716153370849481e-03,
 4.456606753294129440e-03,
 4.481488447681978779e-03,
 4.506361196757124009e-03,
 4.531224960759981484e-03,
 4.556079699947802181e-03,
 4.580925374595271049e-03,
 4.605761944994265882e-03,
 4.630589371454532123e-03,
 4.655407614302701017e-03,
 4.680216633883550748e-03,
 4.705016390558864996e-03,
 4.729806844708690609e-03,
 4.754587956730360956e-03,
 4.779359687039037158e-03,
 4.804121996068124421e-03,
 4.828874844268424629e-03,
 4.853618192109258704e-03,
 4.878352000077449194e-03,
 4.903076228678479066e-03,
 4.927790838435613940e-03,
 4.952495789890440717e-03,
 4.977191043602778239e-03,
 5.001876560151147406e-03,
 5.026552300132000953e-03,
 5.051218224160798978e-03,
 5.075874292871145055e-03,
 5.100520466915402923e-03,
 5.125156706964444087e-03,
 5.149782973708194253e-03,
 5.174399227855328888e-03,
 5.199005430133037294e-03,
 5.223601541287902980e-03,
 5.248187522085161205e-03,
 5.272763333309181226e-03,
 5.297328935763314511e-03,
 5.321884290270536590e-03,
 5.346429357672450450e-03,
 5.370964098830538144e-03,
 5.395488474625239651e-03,
 5.420002445956529670e-03,
 5.444505973743745016e-03,
 5.468999018926170089e-03,
 5.493481542462161707e-03,
 5.517953505330271471e-03,
 5.542414868528269117e-03,
 5.566865593074247533e-03,
 5.591305640005705957e-03,
 5.615734970380139787e-03,
 5.640153545275358900e-03,
 5.664561325788740852e-03,
 5.688958273038221408e-03,
 5.713344348161428915e-03,
 5.737719512316884728e-03,
 5.762083726682404664e-03,
 5.786436952457155516e-03,
 5.810779150859996661e-03,
 5.835110283130834005e-03,
 5.859430310529534919e-03,
 5.883739194337117388e-03,
 5.908036895854856634e-03,
 5.932323376404866240e-03,
 5.956598597329902135e-03,
 5.980862519993966273e-03,
 6.005115105781441004e-03,
 6.029356316098045780e-03,
 6.053586112370571738e-03,
 6.077804456046532154e-03,
 6.102011308594812965e-03,
 6.126206631505335364e-03,
 6.150390386289698516e-03,
 6.174562534480236738e-03,
 6.198723037631336148e-03,
 6.222871857318299296e-03,
 6.247008955138148335e-03,
 6.271134292709301498e-03,
 6.295247831672251375e-03,
 6.319349533688638568e-03,
 6.343439360442333294e-03,
 6.367517273638594044e-03,
 6.391583235004969638e-03,
 6.415637206290652171e-03,
 6.439679149266870802e-03,
 6.463709025726831897e-03,
 6.487726797486111953e-03,
 6.511732426382467638e-03,
 6.535725874275477576e-03,
 6.559707103047728895e-03,
 6.583676074603158831e-03,
 6.607632750869115584e-03,
 6.631577093794744152e-03,
 6.655509065352246609e-03,
 6.679428627535898520e-03,
 6.703335742363190387e-03,
 6.727230371873890898e-03,
 6.751112478130706120e-03,
 6.774982023219038377e-03,
 6.798838969247603808e-03,
 6.822683278347512099e-03,
 6.846514912673453031e-03,
 6.870333834402652176e-03,
 6.894140005735999339e-03,
 6.917933388897193336e-03,
 6.941713946133167869e-03,
 6.965481639714594594e-03,
 6.989236431934986275e-03,
 7.012978285111810470e-03,
 7.036707161585655131e-03,
 7.060423023720762900e-03,
 7.084125833904889730e-03,
 7.107815554549819226e-03,
 7.131492148090592433e-03,
 7.155155576986520043e-03,
 7.178805803720270801e-03,
 7.202442790798940959e-03,
 7.226066500753194725e-03,
 7.249676896137873146e-03,
 7.273273939531745176e-03,
 7.296857593537987331e-03,
 7.320427820784052714e-03,
 7.343984583921162740e-03,
 7.367527845625593437e-03,
 7.391057568597023120e-03,
 7.414573715560560281e-03,
 7.438076249265118157e-03,
 7.461565132484654188e-03,
 7.485040328017299183e-03,
 7.508501798686352188e-03,
 7.531949507339392308e-03,
 7.555383416849013357e-03,
 7.578803490112485594e-03,
 7.602209690052396697e-03,
 7.625601979615754047e-03,
 7.648980321775114034e-03,
 7.672344679527636629e-03,
 7.695695015896241581e-03,
 7.719031293928151245e-03,
 7.742353476696623577e-03,
 7.765661527300091703e-03,
 7.788955408861999996e-03,
 7.812235084531722606e-03,
 7.835500517483771563e-03,
 7.858751670918278157e-03,
 7.881988508060896667e-03,
 7.905210992163366410e-03,
 7.928419086502535088e-03,
 7.951612754381632078e-03,
 7.974791959129166885e-03,
 7.997956664100080992e-03,
 8.021106832674875300e-03,
 8.044242428260222483e-03,
 8.067363414288666879e-03,
 8.090469754219314913e-03,
 8.113561411536934775e-03,
 8.136638349753073582e-03,
 8.159700532405139706e-03,
 8.182747923056923195e-03,
 8.205780485299019045e-03,
 8.228798182747985857e-03,
 8.251800979047384937e-03,
 8.274788837866904265e-03,
 8.297761722903359421e-03,
 8.320719597879848786e-03,
 8.343662426546430075e-03,
 8.366590172679766457e-03,
 8.389502800083815243e-03,
 8.412400272588951844e-03,
 8.435282554053034898e-03,
 8.458149608360479924e-03,
 8.481001399423390361e-03,
 8.503837891180131628e-03,
 8.526659047597223706e-03,
 8.549464832667798969e-03,
 8.572255210412656895e-03,
 8.595030144879986511e-03,
 8.617789600145224146e-03,
 8.640533540311341396e-03,
 8.663261929508772261e-03,
 8.685974731895926629e-03,
 8.708671911658394035e-03,
 8.731353433009930720e-03,
 8.754019260191642574e-03,
 8.776669357472875049e-03,
 8.799303689150555705e-03,
 8.821922219549681657e-03,
 8.844524913023009069e-03,
 8.867111733951910102e-03,
 8.889682646745198508e-03,
 8.912237615840446284e-03,
 8.934776605703069474e-03,
 8.957299580826662971e-03,
 8.979806505733661445e-03,
 9.002297344974307183e-03,
 9.024772063127829702e-03,
 9.047230624801392770e-03,
 9.069672994631284429e-03,
 9.092099137282001059e-03,
 9.114509017446793815e-03,
 9.136902599847564546e-03,
 9.159279849235361926e-03,
 9.181640730389526231e-03,
 9.203985208118804773e-03,
 9.226313247260486267e-03,
 9.248624812681049620e-03,
 9.270919869275823927e-03,
 9.293198381969638988e-03,
 9.315460315716016931e-03,
 9.337705635498164472e-03,
 9.359934306328086470e-03,
 9.382146293247543498e-03,
 9.404341561327403051e-03,
 9.426520075667898027e-03,
 9.448681801399126320e-03,
 9.470826703680249384e-03,
 9.492954747700566021e-03,
 9.515065898678416040e-03,
 9.537160121862469156e-03,
 9.559237382530682420e-03,
 9.581297645991042680e-03,
 9.603340877581193619e-03,
 9.625367042669134843e-03,
 9.647376106652338912e-03,
 9.669368034958773089e-03,
 9.691342793046170759e-03,
 9.713300346402475513e-03,
 9.735240660545744010e-03,
 9.757163701024508529e-03,
 9.779069433417589621e-03,
 9.800957823333820290e-03,
 9.822828836412915085e-03,
 9.844682438324703355e-03,
 9.866518594769635789e-03,
 9.888337271478586654e-03,
 9.910138434213473096e-03,
 9.931922048766365224e-03,
 9.953688080960561638e-03,
 9.975436496649782783e-03,
 9.997167261718674022e-03,
 1.001888034208272410e-02,
 1.004057570368863117e-02,
 1.006225331251369738e-02,
 1.008391313456666848e-02,
 1.010555513588697572e-02,
 1.012717928254566399e-02,
 1.014878554064463714e-02,
 1.017037387631705703e-02,
 1.019194425572769909e-02,
 1.021349664507234002e-02,
 1.023503101057856787e-02,
 1.025654731850498408e-02,
 1.027804553514220093e-02,
 1.029952562681205053e-02,
 1.032098755986807052e-02,
 1.034243130069543472e-02,
 1.036385681571137807e-02,
 1.038526407136438658e-02,
 1.040665303413534741e-02,
 1.042802367053665726e-02,
 1.044937594711271150e-02,
 1.047070983043989385e-02,
 1.049202528712687467e-02,
 1.051332228381404721e-02,
 1.053460078717421977e-02,
 1.055586076391248906e-02,
 1.057710218076589499e-02,
 1.059832500450397404e-02,
 1.061952920192843312e-02,
 1.064071473987378280e-02,
 1.066188158520652365e-02,
 1.068302970482610560e-02,
 1.070415906566423402e-02,
 1.072526963468530686e-02,
 1.074636137888631757e-02,
 1.076743426529725746e-02,
 1.078848826098052077e-02,
 1.080952333303167832e-02,
 1.083053944857877669e-02,
 1.085153657478325762e-02,
 1.087251467883909584e-02,
 1.089347372797354330e-02,
 1.091441368944671628e-02,
 1.093533453055213142e-02,
 1.095623621861641431e-02,
 1.097711872099913118e-02,
 1.099798200509374997e-02,
 1.101882603832612939e-02,
 1.103965078815644443e-02,
 1.106045622207763729e-02,
 1.108124230761663165e-02,
 1.110200901233341850e-02,
 1.112275630382200328e-02,
 1.114348414970975192e-02,
 1.116419251765768915e-02,
 1.118488137536060786e-02,
 1.120555069054729631e-02,
 1.122620043098006282e-02,
 1.124683056445539495e-02,
 1.126744105880336626e-02,
 1.128803188188843599e-02,
 1.130860300160878990e-02,
 1.132915438589667846e-02,
 1.134968600271878125e-02,
 1.137019782007556677e-02,
 1.139068980600218585e-02,
 1.141116192856767193e-02,
 1.143161415587556039e-02,
 1.145204645606361440e-02,
 1.147245879730435410e-02,
 1.149285114780438516e-02,
 1.151322347580521245e-02,
 1.153357574958254264e-02,
 1.155390793744707524e-02,
 1.157422000774397004e-02,
 1.159451192885303968e-02,
 1.161478366918891093e-02,
 1.163503519720120866e-02,
 1.165526648137439093e-02,
 1.167547749022753399e-02,
 1.169566819231527589e-02,
 1.171583855622636977e-02,
 1.173598855058553825e-02,
 1.175611814405198158e-02,
 1.177622730532056419e-02,
 1.179631600312082591e-02,
 1.181638420621809911e-02,
 1.183643188341268124e-02,
 1.185645900354025464e-02,
 1.187646553547185534e-02,
 1.189645144811433790e-02,
 1.191641671040947516e-02,
 1.193636129133518638e-02,
 1.195628515990446346e-02,
 1.197618828516639963e-02,
 1.199607063620541404e-02,
 1.201593218214169062e-02,
 1.203577289213154759e-02,
 1.205559273536665338e-02,
 1.207539168107501018e-02,
 1.209516969852023928e-02,
 1.211492675700201471e-02,
 1.213466282585598001e-02,
 1.215437787445405003e-02,
 1.217407187220398077e-02,
 1.219374478855001116e-02,
 1.221339659297220222e-02,
 1.223302725498732341e-02,
 1.225263674414811023e-02,
 1.227222503004369962e-02,
 1.229179208229956924e-02,
 1.231133787057799543e-02,
 1.233086236457725873e-02,
 1.235036553403256847e-02,
 1.236984734871575398e-02,
 1.238930777843466786e-02,
 1.240874679303459287e-02,
 1.242816436239700152e-02,
 1.244756045644052241e-02,
 1.246693504512024972e-02,
 1.248628809842850310e-02,
 1.250561958639424473e-02,
 1.252492947908346796e-02,
 1.254421774659905849e-02,
 1.256348435908126275e-02,
 1.258272928670703394e-02,
 1.260195249969086641e-02,
 1.262115396828401154e-02,
 1.264033366277549607e-02,
 1.265949155349082797e-02,
 1.267862761079365658e-02,
 1.269774180508443165e-02,
 1.271683410680134532e-02,
 1.273590448642001639e-02,
 1.275495291445343654e-02,
 1.277397936145211257e-02,
 1.279298379800420174e-02,
 1.281196619473568520e-02,
 1.283092652230992045e-02,
 1.284986475142831271e-02,
 1.286878085282968688e-02,
 1.288767479729107171e-02,
 1.290654655562708912e-02,
 1.292539609869032373e-02,
 1.294422339737124651e-02,
 1.296302842259865716e-02,
 1.298181114533890866e-02,
 1.300057153659688568e-02,
 1.301930956741539046e-02,
 1.303802520887527294e-02,
 1.305671843209594944e-02,
 1.307538920823472436e-02,
 1.309403750848760727e-02,
 1.311266330408850968e-02,
 1.313126656631023390e-02,
 1.314984726646367327e-02,
 1.316840537589822335e-02,
 1.318694086600189289e-02,
 1.320545370820137322e-02,
 1.322394387396172780e-02,
 1.324241133478696632e-02,
 1.326085606221949487e-02,
 1.327927802784088784e-02,
 1.329767720327083499e-02,
 1.331605356016861592e-02,
 1.333440707023179385e-02,
 1.335273770519735705e-02,
 1.337104543684073006e-02,
 1.338933023697689087e-02,
 1.340759207745945668e-02,
 1.342583093018116791e-02,
 1.344404676707424383e-02,
 1.346223956010964874e-02,
 1.348040928129792468e-02,
 1.349855590268855474e-02,
 1.351667939637071769e-02,
 1.353477973447259758e-02,
 1.355285688916189543e-02,
 1.357091083264568357e-02,
 1.358894153717073519e-02,
 1.360694897502301437e-02,
 1.362493311852839249e-02,
 1.364289394005213131e-02,
 1.366083141199912233e-02,
 1.367874550681392326e-02,
 1.369663619698101298e-02,
 1.371450345502464759e-02,
 1.373234725350853253e-02,
 1.375016756503670036e-02,
 1.376796436225279432e-02,
 1.378573761784042048e-02,
 1.380348730452313558e-02,
 1.382121339506481306e-02,
 1.383891586226894226e-02,
 1.385659467897953391e-02,
 1.387424981808052342e-02,
 1.389188125249601717e-02,
 1.390948895519031510e-02,
 1.392707289916829579e-02,
 1.394463305747471044e-02,
 1.396216940319511615e-02,
 1.397968190945501205e-02,
 1.399717054942072568e-02,
 1.401463529629883888e-02,
 1.403207612333635945e-02,
 1.404949300382121909e-02,
 1.406688591108151178e-02,
 1.408425481848633691e-02,
 1.410159969944517304e-02,
 1.411892052740850237e-02,
 1.413621727586732851e-02,
 1.415348991835353731e-02,
 1.417073842843979449e-02,
 1.418796277973990994e-02,
 1.420516294590816637e-02,
 1.422233890064033245e-02,
 1.423949061767270340e-02,
 1.425661807078290426e-02,
 1.427372123378937638e-02,
 1.429080008055207650e-02,
 1.430785458497166665e-02,
 1.432488472099037631e-02,
 1.434189046259157739e-02,
 1.435887178379977210e-02,
 1.437582865868092773e-02,
 1.439276106134216790e-02,
 1.440966896593235715e-02,
 1.442655234664139315e-02,
 1.444341117770107409e-02,
 1.446024543338435449e-02,
 1.447705508800587251e-02,
 1.449384011592177134e-02,
 1.451060049153006862e-02,
 1.452733618927011874e-02,
 1.454404718362329804e-02,
 1.456073344911241498e-02,
 1.457739496030242311e-02,
 1.459403169179978449e-02,
 1.461064361825292236e-02,
 1.462723071435207203e-02,
 1.464379295482958789e-02,
 1.466033031445987227e-02,
 1.467684276805890191e-02,
 1.469333029048519937e-02,
 1.470979285663910445e-02,
 1.472623044146306737e-02,
 1.474264301994174416e-02,
 1.475903056710214413e-02,
 1.477539305801326905e-02,
 1.479173046778663007e-02,
 1.480804277157589215e-02,
 1.482432994457713940e-02,
 1.484059196202872945e-02,
 1.485682879921168716e-02,
 1.487304043144923801e-02,
 1.488922683410736150e-02,
 1.490538798259431232e-02,
 1.492152385236121363e-02,
 1.493763441890154538e-02,
 1.495371965775140616e-02,
 1.496977954448993481e-02,
 1.498581405473860435e-02,
 1.500182316416192631e-02,
 1.501780684846703781e-02,
 1.503376508340393582e-02,
 1.504969784476544066e-02,
 1.506560510838752219e-02,
 1.508148685014872210e-02,
 1.509734304597091722e-02,
 1.511317367181871929e-02,
 1.512897870370002486e-02,
 1.514475811766564928e-02,
 1.516051188980952098e-02,
 1.517623999626880639e-02,
 1.519194241322376765e-02,
 1.520761911689822062e-02,
 1.522327008355872126e-02,
 1.523889528951571405e-02,
 1.525449471112227603e-02,
 1.527006832477552541e-02,
 1.528561610691555293e-02,
 1.530113803402622860e-02,
 1.531663408263450252e-02,
 1.533210422931126880e-02,
 1.534754845067067691e-02,
 1.536296672337045602e-02,
 1.537835902411203992e-02,
 1.539372532964067286e-02,
 1.540906561674490992e-02,
 1.542437986225743234e-02,
 1.543966804305426169e-02,
 1.545493013605573306e-02,
 1.547016611822552533e-02,
 1.548537596657125794e-02,
 1.550055965814482045e-02,
 1.551571717004151564e-02,
 1.553084847940102917e-02,
 1.554595356340679295e-02,
 1.556103239928634252e-02,
 1.557608496431119732e-02,
 1.559111123579725970e-02,
 1.560611119110418520e-02,
 1.562108480763609204e-02,
 1.563603206284106331e-02,
 1.565095293421167599e-02,
 1.566584739928457426e-02,
 1.568071543564076437e-02,
 1.569555702090546026e-02,
 1.571037213274860400e-02,
 1.572516074888413024e-02,
 1.573992284707058376e-02,
 1.575465840511120971e-02,
 1.576936740085312094e-02,
 1.578404981218869962e-02,
 1.579870561705432747e-02,
 1.581333479343139184e-02,
 1.582793731934557108e-02,
 1.584251317286756999e-02,
 1.585706233211238436e-02,
 1.587158477524006073e-02,
 1.588608048045515517e-02,
 1.590054942600738208e-02,
 1.591499159019079193e-02,
 1.592940695134475310e-02,
 1.594379548785318165e-02,
 1.595815717814521445e-02,
 1.597249200069470604e-02,
 1.598679993402059296e-02,
 1.600108095668671682e-02,
 1.601533504730213650e-02,
 1.602956218452106230e-02,
 1.604376234704255055e-02,
 1.605793551361096166e-02,
 1.607208166301568250e-02,
 1.608620077409164337e-02,
 1.610029282571857553e-02,
 1.611435779682195493e-02,
 1.612839566637208621e-02,
 1.614240641338500482e-02,
 1.615639001692184204e-02,
 1.617034645608923446e-02,
 1.618427571003913309e-02,
 1.619817775796923362e-02,
 1.621205257912226860e-02,
 1.622590015278697895e-02,
 1.623972045829735061e-02,
 1.625351347503286442e-02,
 1.626727918241896789e-02,
 1.628101755992638136e-02,
 1.629472858707180921e-02,
 1.630841224341729803e-02,
 1.632206850857102765e-02,
 1.633569736218663457e-02,
 1.634929878396364569e-02,
 1.636287275364730481e-02,
 1.637641925102904447e-02,
 1.638993825594567411e-02,
 1.640342974828041048e-02,
 1.641689370796196867e-02,
 1.643033011496547457e-02,
 1.644373894931156280e-02,
 1.645712019106727528e-02,
 1.647047382034555474e-02,
 1.648379981730547020e-02,
 1.649709816215211289e-02,
 1.651036883513693626e-02,
 1.652361181655729802e-02,
 1.653682708675687646e-02,
 1.655001462612566351e-02,
 1.656317441509969762e-02,
 1.657630643416160149e-02,
 1.658941066383998880e-02,
 1.660248708471009915e-02,
 1.661553567739338516e-02,
 1.662855642255775881e-02,
 1.664154930091736248e-02,
 1.665451429323317259e-02,
 1.666745138031231963e-02,
 1.668036054300870222e-02,
 1.669324176222254652e-02,
 1.670609501890074275e-02,
 1.671892029403672722e-02,
 1.673171756867062807e-02,
 1.674448682388935197e-02,
 1.675722804082604642e-02,
 1.676994120066115784e-02,
 1.678262628462138042e-02,
 1.679528327398038812e-02,
 1.680791215005853628e-02,
 1.682051289422325721e-02,
 1.683308548788844602e-02,
 1.684562991251517539e-02,
 1.685814614961124447e-02,
 1.687063418073157101e-02,
 1.688309398747762577e-02,
 1.689552555149833810e-02,
 1.690792885448928057e-02,
 1.692030387819333515e-02,
 1.693265060440021091e-02,
 1.694496901494681879e-02,
 1.695725909171720558e-02,
 1.696952081664233544e-02,
 1.698175417170069007e-02,
 1.699395913891764420e-02,
 1.700613570036599298e-02,
 1.701828383816553214e-02,
 1.703040353448365130e-02,
 1.704249477153470596e-02,
 1.705455753158058654e-02,
 1.706659179693031936e-02,
 1.707859754994063561e-02,
 1.709057477301526365e-02,
 1.710252344860572690e-02,
 1.711444355921068472e-02,
 1.712633508737647012e-02,
 1.713819801569672202e-02,
 1.715003232681283282e-02,
 1.716183800341353899e-02,
 1.717361502823527147e-02,
 1.718536338406206551e-02,
 1.719708305372550511e-02,
 1.720877402010478202e-02,
 1.722043626612682066e-02,
 1.723206977476632318e-02,
 1.724367452904550235e-02,
 1.725525051203453258e-02,
 1.726679770685118909e-02,
 1.727831609666117749e-02,
 1.728980566467783891e-02,
 1.730126639416254553e-02,
 1.731269826842437784e-02,
 1.732410127082050291e-02,
 1.733547538475570596e-02,
 1.734682059368301485e-02,
 1.735813688110320399e-02,
 1.736942423056510656e-02,
 1.738068262566550351e-02,
 1.739191205004926577e-02,
 1.740311248740937858e-02,
 1.741428392148678533e-02,
 1.742542633607057495e-02,
 1.743653971499796451e-02,
 1.744762404215428539e-02,
 1.745867930147299366e-02,
 1.746970547693590253e-02,
 1.748070255257282504e-02,
 1.749167051246209442e-02,
 1.750260934072998126e-02,
 1.751351902155124859e-02,
 1.752439953914878071e-02,
 1.753525087779408964e-02,
 1.754607302180664907e-02,
 1.755686595555469923e-02,
 1.756762966345448360e-02,
 1.757836412997102957e-02,
 1.758906933961759331e-02,
 1.759974527695580895e-02,
 1.761039192659601474e-02,
 1.762100927319684360e-02,
 1.763159730146568113e-02,
 1.764215599615825622e-02,
 1.765268534207894632e-02,
 1.766318532408057626e-02,
 1.767365592706494903e-02,
 1.768409713598204439e-02,
 1.769450893583085146e-02,
 1.770489131165878249e-02,
 1.771524424856214808e-02,
 1.772556773168584496e-02,
 1.773586174622352601e-02,
 1.774612627741754128e-02,
 1.775636131055917388e-02,
 1.776656683098847694e-02,
 1.777674282409406198e-02,
 1.778688927531383440e-02,
 1.779700617013417127e-02,
 1.780709349409043823e-02,
 1.781715123276695484e-02,
 1.782717937179695636e-02,
 1.783717789686256952e-02,
 1.784714679369494780e-02,
 1.785708604807413266e-02,
 1.786699564582927904e-02,
 1.787687557283838130e-02,
 1.788672581502870340e-02,
 1.789654635837637300e-02,
 1.790633718890677004e-02,
 1.791609829269419710e-02,
 1.792582965586218824e-02,
 1.793553126458341529e-02,
 1.794520310507953173e-02,
 1.795484516362169658e-02,
 1.796445742652992561e-02,
 1.797403988017364646e-02,
 1.798359251097152514e-02,
 1.799311530539131690e-02,
 1.800260824995011597e-02,
 1.801207133121441456e-02,
 1.802150453579989819e-02,
 1.803090785037162955e-02,
 1.804028126164393050e-02,
 1.804962475638063196e-02,
 1.805893832139479627e-02,
 1.806822194354893926e-02,
 1.807747560975499906e-02,
 1.808669930697436035e-02,
 1.809589302221777801e-02,
 1.810505674254556455e-02,
 1.811419045506764899e-02,
 1.812329414694305654e-02,
 1.813236780538072385e-02,
 1.814141141763893003e-02,
 1.815042497102567487e-02,
 1.815940845289826591e-02,
 1.816836185066391524e-02,
 1.817728515177918780e-02,
 1.818617834375044554e-02,
 1.819504141413348652e-02,
 1.820387435053405500e-02,
 1.821267714060730361e-02,
 1.822144977205832767e-02,
 1.823019223264162395e-02,
 1.823890451016176029e-02,
 1.824758659247276149e-02,
 1.825623846747855342e-02,
 1.826486012313278604e-02,
 1.827345154743888894e-02,
 1.828201272845026565e-02,
 1.829054365426992235e-02,
 1.829904431305078710e-02,
 1.830751469299563006e-02,
 1.831595478235711547e-02,
 1.832436456943782599e-02,
 1.833274404259017942e-02,
 1.834109319021653625e-02,
 1.834941200076924822e-02,
 1.835770046275055425e-02,
 1.836595856471256311e-02,
 1.837418629525757255e-02,
 1.838238364303773978e-02,
 1.839055059675521672e-02,
 1.839868714516233045e-02,
 1.840679327706131949e-02,
 1.841486898130436853e-02,
 1.842291424679404210e-02,
 1.843092906248265661e-02,
 1.843891341737290482e-02,
 1.844686730051741178e-02,
 1.845479070101898461e-02,
 1.846268360803061948e-02,
 1.847054601075538705e-02,
 1.847837789844653661e-02,
 1.848617926040759668e-02,
 1.849395008599217377e-02,
 1.850169036460417790e-02,
 1.850940008569765260e-02,
 1.851707923877709758e-02,
 1.852472781339696908e-02,
 1.853234579916216915e-02,
 1.853993318572779575e-02,
 1.854748996279937528e-02,
 1.855501612013260582e-02,
 1.856251164753356872e-02,
 1.856997653485869745e-02,
 1.857741077201461449e-02,
 1.858481434895862747e-02,
 1.859218725569802833e-02,
 1.859952948229083233e-02,
 1.860684101884525418e-02,
 1.861412185551998208e-02,
 1.862137198252411183e-02,
 1.862859139011723703e-02,
 1.863578006860927908e-02,
 1.864293800836074044e-02,
 1.865006519978253466e-02,
 1.865716163333610428e-02,
 1.866422729953333415e-02,
 1.867126218893669365e-02,
 1.867826629215902853e-02,
 1.868523959986393909e-02,
 1.869218210276540545e-02,
 1.869909379162805127e-02,
 1.870597465726699452e-02,
 1.871282469054798281e-02,
 1.871964388238742463e-02,
 1.872643222375207361e-02,
 1.873318970565967037e-02,
 1.873991631917824516e-02,
 1.874661205542676665e-02,
 1.875327690557451396e-02,
 1.875991086084180179e-02,
 1.876651391249927955e-02,
 1.877308605186854204e-02,
 1.877962727032168530e-02,
 1.878613755928158074e-02,
 1.879261691022182310e-02,
 1.879906531466675121e-02,
 1.880548276419139603e-02,
 1.881186925042148753e-02,
 1.881822476503366287e-02,
 1.882454929975515764e-02,
 1.883084284636408687e-02,
 1.883710539668936521e-02,
 1.884333694261058900e-02,
 1.884953747605823057e-02,
 1.885570698901363820e-02,
 1.886184547350878288e-02,
 1.886795292162678911e-02,
 1.887402932550126880e-02,
 1.888007467731700126e-02,
 1.888608896930942319e-02,
 1.889207219376492705e-02,
 1.889802434302068415e-02,
 1.890394540946492563e-02,
 1.890983538553663371e-02,
 1.891569426372575330e-02,
 1.892152203657324755e-02,
 1.892731869667084454e-02,
 1.893308423666120038e-02,
 1.893881864923800326e-02,
 1.894452192714599081e-02,
 1.895019406318051991e-02,
 1.895583505018830911e-02,
 1.896144488106680723e-02,
 1.896702354876457844e-02,
 1.897257104628097615e-02,
 1.897808736666661486e-02,
 1.898357250302289828e-02,
 1.898902644850250857e-02,
 1.899444919630873668e-02,
 1.899984073969635326e-02,
 1.900520107197088693e-02,
 1.901053018648904760e-02,
 1.901582807665844893e-02,
 1.902109473593786501e-02,
 1.902633015783726164e-02,
 1.903153433591742161e-02,
 1.903670726379036449e-02,
 1.904184893511918358e-02,
 1.904695934361813267e-02,
 1.905203848305232414e-02,
 1.905708634723831535e-02,
 1.906210293004348411e-02,
 1.906708822538660461e-02,
 1.907204222723733397e-02,
 1.907696492961656956e-02,
 1.908185632659635880e-02,
 1.908671641229991653e-02,
 1.909154518090155905e-02,
 1.909634262662682561e-02,
 1.910110874375231527e-02,
 1.910584352660596799e-02,
 1.911054696956672808e-02,
 1.911521906706477314e-02,
 1.911985981358163209e-02,
 1.912446920364974448e-02,
 1.912904723185299485e-02,
 1.913359389282636921e-02,
 1.913810918125602445e-02,
 1.914259309187942362e-02,
 1.914704561948524231e-02,
 1.915146675891324715e-02,
 1.915585650505469487e-02,
 1.916021485285179793e-02,
 1.916454179729825888e-02,
 1.916883733343881929e-02,
 1.917310145636963101e-02,
 1.917733416123794735e-02,
 1.918153544324245272e-02,
 1.918570529763297464e-02,
 1.918984371971068845e-02,
 1.919395070482791607e-02,
 1.919802624838842786e-02,
 1.920207034584716158e-02,
 1.920608299271034033e-02,
 1.921006418453552814e-02,
 1.921401391693161598e-02,
 1.921793218555865879e-02,
 1.922181898612811135e-02,
 1.922567431440273117e-02,
 1.922949816619651600e-02,
 1.923329053737488428e-02,
 1.923705142385448083e-02,
 1.924078082160330175e-02,
 1.924447872664066320e-02,
 1.924814513503718058e-02,
 1.925178004291481365e-02,
 1.925538344644686303e-02,
 1.925895534185800145e-02,
 1.926249572542412108e-02,
 1.926600459347254171e-02,
 1.926948194238195175e-02,
 1.927292776858223478e-02,
 1.927634206855480606e-02,
 1.927972483883227603e-02,
 1.928307607599874518e-02,
 1.928639577668955774e-02,
 1.928968393759144043e-02,
 1.929294055544248168e-02,
 1.929616562703216284e-02,
 1.929935914920129919e-02,
 1.930252111884200178e-02,
 1.930565153289788213e-02,
 1.930875038836374347e-02,
 1.931181768228593804e-02,
 1.931485341176211387e-02,
 1.931785757394121825e-02,
 1.932083016602366768e-02,
 1.932377118526118140e-02,
 1.932668062895691666e-02,
 1.932955849446532648e-02,
 1.933240477919238171e-02,
 1.933521948059517201e-02,
 1.933800259618244019e-02,
 1.934075412351417278e-02,
 1.934347406020171106e-02,
 1.934616240390784128e-02,
 1.934881915234669403e-02,
 1.935144430328373036e-02,
 1.935403785453598813e-02,
 1.935659980397159974e-02,
 1.935913014951031949e-02,
 1.936162888912308644e-02,
 1.936409602083233317e-02,
 1.936653154271194763e-02,
 1.936893545288700252e-02,
 1.937130774953410919e-02,
 1.937364843088114352e-02,
 1.937595749520749921e-02,
 1.937823494084369921e-02,
 1.938048076617202714e-02,
 1.938269496962570851e-02,
 1.938487754968969828e-02,
 1.938702850490012577e-02,
 1.938914783384455484e-02,
 1.939123553516191797e-02,
 1.939329160754253364e-02,
 1.939531604972802650e-02,
 1.939730886051148698e-02,
 1.939927003873732556e-02,
 1.940119958330127972e-02,
 1.940309749315052845e-02,
 1.940496376728347711e-02,
 1.940679840475014947e-02,
 1.940860140465163960e-02,
 1.941037276614055590e-02,
 1.941211248842083376e-02,
 1.941382057074777373e-02,
 1.941549701242792358e-02,
 1.941714181281939053e-02,
 1.941875497133138326e-02,
 1.942033648742463176e-02,
 1.942188636061115484e-02,
 1.942340459045432260e-02,
 1.942489117656876624e-02,
 1.942634611862051330e-02,
 1.942776941632698429e-02,
 1.942916106945680524e-02,
 1.943052107782991880e-02,
 1.943184944131771258e-02,
 1.943314615984286647e-02,
 1.943441123337922780e-02,
 1.943564466195217555e-02,
 1.943684644563824573e-02,
 1.943801658456529094e-02,
 1.943915507891250810e-02,
 1.944026192891037258e-02,
 1.944133713484067633e-02,
 1.944238069703648625e-02,
 1.944339261588208870e-02,
 1.944437289181322540e-02,
 1.944532152531669097e-02,
 1.944623851693074931e-02,
 1.944712386724482128e-02,
 1.944797757689960618e-02,
 1.944879964658712684e-02,
 1.944959007705054921e-02,
 1.945034886908447030e-02,
 1.945107602353452619e-02,
 1.945177154129773198e-02,
 1.945243542332229097e-02,
 1.945306767060769881e-02,
 1.945366828420454566e-02,
 1.945423726521475563e-02,
 1.945477461479152084e-02,
 1.945528033413907593e-02,
 1.945575442451296863e-02,
 1.945619688721997656e-02,
 1.945660772361802390e-02,
 1.945698693511620225e-02,
 1.945733452317481571e-02,
 1.945765048930541904e-02,
 1.945793483507064422e-02,
 1.945818756208432879e-02,
 1.945840867201138399e-02,
 1.945859816656803770e-02,
 1.945875604752158455e-02,
 1.945888231669040333e-02,
 1.945897697594416512e-02,
 1.945904002720349329e-02,
 1.945907147244027233e-02,
 1.945907131367740142e-02,
 1.945903955298896801e-02,
 1.945897619250013671e-02,
 1.945888123438718753e-02,
 1.945875468087745336e-02,
 1.945859653424939287e-02,
 1.945840679683244825e-02,
 1.945818547100726728e-02,
 1.945793255920553327e-02,
 1.945764806390984369e-02,
 1.945733198765399810e-02,
 1.945698433302276570e-02,
 1.945660510265202064e-02,
 1.945619429922855470e-02,
 1.945575192549028887e-02,
 1.945527798422599583e-02,
 1.945477247827565731e-02,
 1.945423541053009284e-02,
 1.945366678393110199e-02,
 1.945306660147165870e-02,
 1.945243486619538734e-02,
 1.945177158119721153e-02,
 1.945107674962270189e-02,
 1.945035037466871786e-02,
 1.944959245958260974e-02,
 1.944880300766314157e-02,
 1.944798202225955092e-02,
 1.944712950677231558e-02,
 1.944624546465266446e-02,
 1.944532989940268852e-02,
 1.944438281457552820e-02,
 1.944340421377496395e-02,
 1.944239410065586038e-02,
 1.944135247892377072e-02,
 1.944027935233521437e-02,
 1.943917472469746180e-02,
 1.943803859986870455e-02,
 1.943687098175782627e-02,
 1.943567187432462470e-02,
 1.943444128157965911e-02,
 1.943317920758426062e-02,
 1.943188565645056001e-02,
 1.943056063234148076e-02,
 1.942920413947065925e-02,
 1.942781618210250374e-02,
 1.942639676455213196e-02,
 1.942494589118547166e-02,
 1.942346356641899002e-02,
 1.942194979472014818e-02,
 1.942040458060676281e-02,
 1.941882792864765145e-02,
 1.941721984346211557e-02,
 1.941558032972011752e-02,
 1.941390939214246089e-02,
 1.941220703550031873e-02,
 1.941047326461572270e-02,
 1.940870808436116410e-02,
 1.940691149965995121e-02,
 1.940508351548565769e-02,
 1.940322413686284414e-02,
 1.940133336886627063e-02,
 1.939941121662159748e-02,
 1.939745768530473993e-02,
 1.939547278014237819e-02,
 1.939345650641158270e-02,
 1.939140886944000150e-02,
 1.938932987460577004e-02,
 1.938721952733751808e-02,
 1.938507783311440788e-02,
 1.938290479746595379e-02,
 1.938070042597223042e-02,
 1.937846472426368524e-02,
 1.937619769802130174e-02,
 1.937389935297635646e-02,
 1.937156969491062378e-02,
 1.936920872965619544e-02,
 1.936681646309560897e-02,
 1.936439290116170886e-02,
 1.936193804983782005e-02,
 1.935945191515744956e-02,
 1.935693450320453285e-02,
 1.935438582011331232e-02,
 1.935180587206823330e-02,
 1.934919466530423543e-02,
 1.934655220610629126e-02,
 1.934387850080985724e-02,
 1.934117355580052336e-02,
 1.933843737751405473e-02,
 1.933566997243658936e-02,
 1.933287134710436408e-02,
 1.933004150810382904e-02,
 1.932718046207170318e-02,
 1.932428821569471405e-02,
 1.932136477570991356e-02,
 1.931841014890429975e-02,
 1.931542434211514989e-02,
 1.931240736222979149e-02,
 1.930935921618565781e-02,
 1.930627991097027402e-02,
 1.930316945362123629e-02,
 1.930002785122606618e-02,
 1.929685511092250200e-02,
 1.929365123989821088e-02,
 1.929041624539092406e-02,
 1.928715013468828079e-02,
 1.928385291512795668e-02,
 1.928052459409752492e-02,
 1.927716517903461935e-02,
 1.927377467742670547e-02,
 1.927035309681117761e-02,
 1.926690044477537278e-02,
 1.926341672895646312e-02,
 1.925990195704154959e-02,
 1.925635613676750582e-02,
 1.925277927592113428e-02,
 1.924917138233894764e-02,
 1.924553246390739783e-02,
 1.924186252856262616e-02,
 1.923816158429056400e-02,
 1.923442963912696396e-02,
 1.923066670115718829e-02,
 1.922687277851641355e-02,
 1.922304787938954734e-02,
 1.921919201201120059e-02,
 1.921530518466552442e-02,
 1.921138740568648431e-02,
 1.920743868345758595e-02,
 1.920345902641201405e-02,
 1.919944844303248660e-02,
 1.919540694185147001e-02,
 1.919133453145078702e-02,
 1.918723122046204696e-02,
 1.918309701756619814e-02,
 1.917893193149383668e-02,
 1.917473597102494626e-02,
 1.917050914498922079e-02,
 1.916625146226559606e-02,
 1.916196293178246482e-02,
 1.915764356251788841e-02,
 1.915329336349905556e-02,
 1.914891234380276808e-02,
 1.914450051255506269e-02,
 1.914005787893141575e-02,
 1.913558445215667383e-02,
 1.913108024150496009e-02,
 1.912654525629974706e-02,
 1.912197950591371792e-02,
 1.911738299976882896e-02,
 1.911275574733644830e-02,
 1.910809775813700206e-02,
 1.910340904174017210e-02,
 1.909868960776490640e-02,
 1.909393946587933585e-02,
 1.908915862580066319e-02,
 1.908434709729521159e-02,
 1.907950489017855647e-02,
 1.907463201431527575e-02,
 1.906972847961910592e-02,
 1.906479429605274778e-02,
 1.905982947362800523e-02,
 1.905483402240574706e-02,
 1.904980795249578210e-02,
 1.904475127405684878e-02,
 1.903966399729684414e-02,
 1.903454613247242827e-02,
 1.902939768988935396e-02,
 1.902421867990207807e-02,
 1.901900911291411894e-02,
 1.901376899937772674e-02,
 1.900849834979413330e-02,
 1.900319717471325720e-02,
 1.899786548473399173e-02,
 1.899250329050390651e-02,
 1.898711060271925447e-02,
 1.898168743212526322e-02,
 1.897623378951564244e-02,
 1.897074968573294121e-02,
 1.896523513166838842e-02,
 1.895969013826188238e-02,
 1.895411471650188667e-02,
 1.894850887742558984e-02,
 1.894287263211860001e-02,
 1.893720599171538552e-02,
 1.893150896739866432e-02,
 1.892578157039996253e-02,
 1.892002381199909405e-02,
 1.891423570352456299e-02,
 1.890841725635318202e-02,
 1.890256848191030833e-02,
 1.889668939166966322e-02,
 1.889077999715348816e-02,
 1.888484030993228466e-02,
 1.887887034162498770e-02,
 1.887287010389880962e-02,
 1.886683960846928867e-02,
 1.886077886710045559e-02,
 1.885468789160429925e-02,
 1.884856669384123162e-02,
 1.884241528571995242e-02,
 1.883623367919727912e-02,
 1.883002188627816431e-02,
 1.882377991901583100e-02,
 1.881750778951156791e-02,
 1.881120550991485438e-02,
 1.880487309242317301e-02,
 1.879851054928221785e-02,
 1.879211789278551620e-02,
 1.878569513527483109e-02,
 1.877924228913982474e-02,
 1.877275936681809324e-02,
 1.876624638079520471e-02,
 1.875970334360484854e-02,
 1.875313026782840162e-02,
 1.874652716609520597e-02,
 1.873989405108247505e-02,
 1.873323093551515148e-02,
 1.872653783216623319e-02,
 1.871981475385617322e-02,
 1.871306171345359093e-02,
 1.870627872387444282e-02,
 1.869946579808272336e-02,
 1.869262294908992372e-02,
 1.868575018995538919e-02,
 1.867884753378578483e-02,
 1.867191499373576161e-02,
 1.866495258300743254e-02,
 1.865796031485038309e-02,
 1.865093820256185850e-02,
 1.864388625948659728e-02,
 1.863680449901684855e-02,
 1.862969293459235121e-02,
 1.862255157970016048e-02,
 1.861538044787490465e-02,
 1.860817955269870524e-02,
 1.860094890780076074e-02,
 1.859368852685786000e-02,
 1.858639842359394515e-02,
 1.857907861178042033e-02,
 1.857172910523582215e-02,
 1.856434991782611454e-02,
 1.855694106346427938e-02,
 1.854950255611060791e-02,
 1.854203440977249609e-02,
 1.853453663850457636e-02,
 1.852700925640854424e-02,
 1.851945227763317561e-02,
 1.851186571637431638e-02,
 1.850424958687492752e-02,
 1.849660390342489080e-02,
 1.848892868036107126e-02,
 1.848122393206741085e-02,
 1.847348967297461272e-02,
 1.846572591756052636e-02,
 1.845793268034960632e-02,
 1.845010997591347429e-02,
 1.844225781887019397e-02,
 1.843437622388508293e-02,
 1.842646520566981402e-02,
 1.841852477898305376e-02,
 1.841055495863015354e-02,
 1.840255575946322594e-02,
 1.839452719638083600e-02,
 1.838646928432828911e-02,
 1.837838203829772130e-02,
 1.837026547332750587e-02,
 1.836211960450277736e-02,
 1.835394444695518865e-02,
 1.834574001586289360e-02,
 1.833750632645043954e-02,
 1.832924339398894764e-02,
 1.832095123379586660e-02,
 1.831262986123500039e-02,
 1.830427929171669563e-02,
 1.829589954069749808e-02,
 1.828749062368024980e-02,
 1.827905255621420366e-02,
 1.827058535389460350e-02,
 1.826208903236330172e-02,
 1.825356360730795088e-02,
 1.824500909446263169e-02,
 1.823642550960756850e-02,
 1.822781286856888991e-02,
 1.821917118721903817e-02,
 1.821050048147627304e-02,
 1.820180076730516447e-02,
 1.819307206071593339e-02,
 1.818431437776518375e-02,
 1.817552773455504214e-02,
 1.816671214723390715e-02,
 1.815786763199568610e-02,
 1.814899420508049588e-02,
 1.814009188277398640e-02,
 1.813116068140777082e-02,
 1.812220061735922427e-02,
 1.811321170705141453e-02,
 1.810419396695302566e-02,
 1.809514741357853840e-02,
 1.808607206348807062e-02,
 1.807696793328716911e-02,
 1.806783503962729881e-02,
 1.805867339920515235e-02,
 1.804948302876325031e-02,
 1.804026394508926115e-02,
 1.803101616501662924e-02,
 1.802173970542402665e-02,
 1.801243458323560295e-02,
 1.800310081542092974e-02,
 1.799373841899492080e-02,
 1.798434741101763087e-02,
 1.797492780859464082e-02,
 1.796547962887655794e-02,
 1.795600288905938730e-02,
 1.794649760638417774e-02,
 1.793696379813725442e-02,
 1.792740148165004183e-02,
 1.791781067429905686e-02,
 1.790819139350584635e-02,
 1.789854365673690037e-02,
 1.788886748150394709e-02,
 1.787916288536353648e-02,
 1.786942988591724499e-02,
 1.785966850081136328e-02,
 1.784987874773734731e-02,
 1.784006064443120071e-02,
 1.783021420867399176e-02,
 1.782033945829133992e-02,
 1.781043641115385989e-02,
 1.780050508517670368e-02,
 1.779054549831985896e-02,
 1.778055766858775005e-02,
 1.777054161402968555e-02,
 1.776049735273930313e-02,
 1.775042490285503108e-02,
 1.774032428255961982e-02,
 1.773019551008050976e-02,
 1.772003860368950856e-02,
 1.770985358170274263e-02,
 1.769964046248096237e-02,
 1.768939926442907734e-02,
 1.767913000599640946e-02,
 1.766883270567664102e-02,
 1.765850738200774178e-02,
 1.764815405357161512e-02,
 1.763777273899475029e-02,
 1.762736345694757012e-02,
 1.761692622614469128e-02,
 1.760646106534487221e-02,
 1.759596799335079106e-02,
 1.758544702900937881e-02,
 1.757489819121144797e-02,
 1.756432149889172734e-02,
 1.755371697102899725e-02,
 1.754308462664581209e-02,
 1.753242448480866675e-02,
 1.752173656462790302e-02,
 1.751102088525759506e-02,
 1.750027746589569513e-02,
 1.748950632578368664e-02,
 1.747870748420706291e-02,
 1.746788096049457090e-02,
 1.745702677401886685e-02,
 1.744614494419623185e-02,
 1.743523549048638793e-02,
 1.742429843239251194e-02,
 1.741333378946146454e-02,
 1.740234158128342937e-02,
 1.739132182749199285e-02,
 1.738027454776423786e-02,
 1.736919976182057720e-02,
 1.735809748942468769e-02,
 1.734696775038348238e-02,
 1.733581056454725627e-02,
 1.732462595180937759e-02,
 1.731341393210650975e-02,
 1.730217452541840673e-02,
 1.729090775176799974e-02,
 1.727961363122111280e-02,
 1.726829218388684431e-02,
 1.725694342991705016e-02,
 1.724556738950679818e-02,
 1.723416408289378185e-02,
 1.722273353035889618e-02,
 1.721127575222576936e-02,
 1.719979076886091890e-02,
 1.718827860067341159e-02,
 1.717673926811541171e-02,
 1.716517279168147669e-02,
 1.715357919190909491e-02,
 1.714195848937831099e-02,
 1.713031070471165290e-02,
 1.711863585857450326e-02,
 1.710693397167442273e-02,
 1.709520506476174331e-02,
 1.708344915862920060e-02,
 1.707166627411188520e-02,
 1.705985643208734678e-02,
 1.704801965347547618e-02,
 1.703615595923841167e-02,
 1.702426537038072979e-02,
 1.701234790794904639e-02,
 1.700040359303228374e-02,
 1.698843244676160810e-02,
 1.697643449031031523e-02,
 1.696440974489350079e-02,
 1.695235823176877848e-02,
 1.694027997223539195e-02,
 1.692817498763473857e-02,
 1.691604329935017526e-02,
 1.690388492880699409e-02,
 1.689169989747228706e-02,
 1.687948822685493566e-02,
 1.686724993850577739e-02,
 1.685498505401720679e-02,
 1.684269359502358829e-02,
 1.683037558320063173e-02,
 1.681803104026604462e-02,
 1.680565998797895269e-02,
 1.679326244814007343e-02,
 1.678083844259168483e-02,
 1.676838799321757681e-02,
 1.675591112194279794e-02,
 1.674340785073416202e-02,
 1.673087820159964087e-02,
 1.671832219658847540e-02,
 1.670573985779151213e-02,
 1.669313120734043296e-02,
 1.668049626740856356e-02,
 1.666783506021011010e-02,
 1.665514760800059987e-02,
 1.664243393307661412e-02,
 1.662969405777586090e-02,
 1.661692800447691146e-02,
 1.660413579559957831e-02,
 1.659131745360433938e-02,
 1.657847300099284452e-02,
 1.656560246030751998e-02,
 1.655270585413168294e-02,
 1.653978320508921532e-02,
 1.652683453584508771e-02,
 1.651385986910474876e-02,
 1.650085922761450330e-02,
 1.648783263416106135e-02,
 1.647478011157196831e-02,
 1.646170168271526499e-02,
 1.644859737049943899e-02,
 1.643546719787356697e-02,
 1.642231118782693303e-02,
 1.640912936338961847e-02,
 1.639592174763157550e-02,
 1.638268836366367151e-02,
 1.636942923463647129e-02,
 1.635614438374120155e-02,
 1.634283383420898420e-02,
 1.632949760931136710e-02,
 1.631613573235979331e-02,
 1.630274822670590290e-02,
 1.628933511574141846e-02,
 1.627589642289803407e-02,
 1.626243217164734245e-02,
 1.624894238550074824e-02,
 1.623542708800987389e-02,
 1.622188630276579641e-02,
 1.620832005339964063e-02,
 1.619472836358221493e-02,
 1.618111125702412917e-02,
 1.616746875747538878e-02,
 1.615380088872602274e-02,
 1.614010767460525436e-02,
 1.612638913898208071e-02,
 1.611264530576510257e-02,
 1.609887619890220875e-02,
 1.608508184238066629e-02,
 1.607126226022738066e-02,
 1.605741747650825044e-02,
 1.604354751532887507e-02,
 1.602965240083377430e-02,
 1.601573215720678706e-02,
 1.600178680867111666e-02,
 1.598781637948879647e-02,
 1.597382089396124152e-02,
 1.595980037642860325e-02,
 1.594575485127035924e-02,
 1.593168434290462634e-02,
 1.591758887578888573e-02,
 1.590346847441907047e-02,
 1.588932316333024550e-02,
 1.587515296709599705e-02,
 1.586095791032899466e-02,
 1.584673801768030424e-02,
 1.583249331383986339e-02,
 1.581822382353621770e-02,
 1.580392957153652772e-02,
 1.578961058264626710e-02,
 1.577526688170974301e-02,
 1.576089849360948203e-02,
 1.574650544326644877e-02,
 1.573208775564005277e-02,
 1.571764545572804095e-02,
 1.570317856856645947e-02,
 1.568868711922946982e-02,
 1.567417113282961599e-02,
 1.565963063451736997e-02,
 1.564506564948146133e-02,
 1.563047620294878010e-02,
 1.561586232018415468e-02,
 1.560122402649021835e-02,
 1.558656134720787755e-02,
 1.557187430771556774e-02,
 1.555716293343000975e-02,
 1.554242724980531981e-02,
 1.552766728233358901e-02,
 1.551288305654460568e-02,
 1.549807459800595262e-02,
 1.548324193232262190e-02,
 1.546838508513723003e-02,
 1.545350408213014455e-02,
 1.543859894901882315e-02,
 1.542366971155886834e-02,
 1.540871639554258592e-02,
 1.539373902680012118e-02,
 1.537873763119861591e-02,
 1.536371223464282759e-02,
 1.534866286307434366e-02,
 1.533358954247233258e-02,
 1.531849229885290375e-02,
 1.530337115826949090e-02,
 1.528822614681210092e-02,
 1.527305729060831826e-02,
 1.525786461582229366e-02,
 1.524264814865541363e-02,
 1.522740791534557027e-02,
 1.521214394216786198e-02,
 1.519685625543399851e-02,
 1.518154488149241373e-02,
 1.516620984672837659e-02,
 1.515085117756354363e-02,
 1.513546890045645507e-02,
 1.512006304190212369e-02,
 1.510463362843215279e-02,
 1.508918068661434242e-02,
 1.507370424305331733e-02,
 1.505820432438969431e-02,
 1.504268095730080385e-02,
 1.502713416849991816e-02,
 1.501156398473674214e-02,
 1.499597043279719995e-02,
 1.498035353950344026e-02,
 1.496471333171341817e-02,
 1.494904983632145204e-02,
 1.493336308025764586e-02,
 1.491765309048831943e-02,
 1.490191989401558857e-02,
 1.488616351787732696e-02,
 1.487038398914751307e-02,
 1.485458133493561261e-02,
 1.483875558238714927e-02,
 1.482290675868303334e-02,
 1.480703489103998328e-02,
 1.479114000671032103e-02,
 1.477522213298200320e-02,
 1.475928129717821516e-02,
 1.474331752665796087e-02,
 1.472733084881526489e-02,
 1.471132129107997032e-02,
 1.469528888091667720e-02,
 1.467923364582598630e-02,
 1.466315561334311825e-02,
 1.464705481103862651e-02,
 1.463093126651842345e-02,
 1.461478500742314189e-02,
 1.459861606142877355e-02,
 1.458242445624619021e-02,
 1.456621021962124611e-02,
 1.454997337933451942e-02,
 1.453371396320171823e-02,
 1.451743199907303689e-02,
 1.450112751483383956e-02,
 1.448480053840364191e-02,
 1.446845109773713806e-02,
 1.445207922082340952e-02,
 1.443568493568619590e-02,
 1.441926827038350449e-02,
 1.440282925300821228e-02,
 1.438636791168722284e-02,
 1.436988427458203710e-02,
 1.435337836988859889e-02,
 1.433685022583673294e-02,
 1.432029987069098273e-02,
 1.430372733274962345e-02,
 1.428713264034545821e-02,
 1.427051582184500796e-02,
 1.425387690564911165e-02,
 1.423721592019252559e-02,
 1.422053289394401877e-02,
 1.420382785540597395e-02,
 1.418710083311498261e-02,
 1.417035185564112162e-02,
 1.415358095158842679e-02,
 1.413678814959457540e-02,
 1.411997347833097126e-02,
 1.410313696650237342e-02,
 1.408627864284746692e-02,
 1.406939853613810472e-02,
 1.405249667517966851e-02,
 1.403557308881109127e-02,
 1.401862780590459184e-02,
 1.400166085536579293e-02,
 1.398467226613330297e-02,
 1.396766206717926437e-02,
 1.395063028750869773e-02,
 1.393357695616008647e-02,
 1.391650210220454070e-02,
 1.389940575474652926e-02,
 1.388228794292337143e-02,
 1.386514869590541564e-02,
 1.384798804289558670e-02,
 1.383080601312997905e-02,
 1.381360263587714209e-02,
 1.379637794043855892e-02,
 1.377913195614842955e-02,
 1.376186471237325279e-02,
 1.374457623851249762e-02,
 1.372726656399784334e-02,
 1.370993571829365321e-02,
 1.369258373089649559e-02,
 1.367521063133550659e-02,
 1.365781644917206904e-02,
 1.364040121399994442e-02,
 1.362296495544482351e-02,
 1.360550770316491624e-02,
 1.358802948685025949e-02,
 1.357053033622312131e-02,
 1.355301028103782744e-02,
 1.353546935108070060e-02,
 1.351790757616964066e-02,
 1.350032498615496082e-02,
 1.348272161091824267e-02,
 1.346509748037325732e-02,
 1.344745262446522989e-02,
 1.342978707317124196e-02,
 1.341210085649995228e-02,
 1.339439400449137646e-02,
 1.337666654721739179e-02,
 1.335891851478100169e-02,
 1.334114993731696890e-02,
 1.332336084499098801e-02,
 1.330555126800045396e-02,
 1.328772123657390516e-02,
 1.326987078097110508e-02,
 1.325199993148279236e-02,
 1.323410871843111285e-02,
 1.321619717216893607e-02,
 1.319826532308042769e-02,
 1.318031320158060543e-02,
 1.316234083811543970e-02,
 1.314434826316163152e-02,
 1.312633550722665243e-02,
 1.310830260084900473e-02,
 1.309024957459751018e-02,
 1.307217645907189467e-02,
 1.305408328490247939e-02,
 1.303597008275008545e-02,
 1.301783688330588815e-02,
 1.299968371729174656e-02,
 1.298151061545961549e-02,
 1.296331760859203985e-02,
 1.294510472750176437e-02,
 1.292687200303182897e-02,
 1.290861946605523919e-02,
 1.289034714747545537e-02,
 1.287205507822560858e-02,
 1.285374328926934019e-02,
 1.283541181159972809e-02,
 1.281706067624019396e-02,
 1.279868991424397071e-02,
 1.278029955669383183e-02,
 1.276188963470270381e-02,
 1.274346017941276055e-02,
 1.272501122199639657e-02,
 1.270654279365493813e-02,
 1.268805492562006740e-02,
 1.266954764915221091e-02,
 1.265102099554179724e-02,
 1.263247499610822139e-02,
 1.261390968220065141e-02,
 1.259532508519707605e-02,
 1.257672123650512008e-02,
 1.255809816756136947e-02,
 1.253945590983180161e-02,
 1.252079449481106020e-02,
 1.250211395402320985e-02,
 1.248341431902104566e-02,
 1.246469562138624761e-02,
 1.244595789272963382e-02,
 1.242720116469058812e-02,
 1.240842546893753708e-02,
 1.238963083716717282e-02,
 1.237081730110531873e-02,
 1.235198489250595444e-02,
 1.233313364315196184e-02,
 1.231426358485456819e-02,
 1.229537474945359074e-02,
 1.227646716881687812e-02,
 1.225754087484105630e-02,
 1.223859589945063518e-02,
 1.221963227459870079e-02,
 1.220065003226621266e-02,
 1.218164920446240806e-02,
 1.216262982322461987e-02,
 1.214359192061825569e-02,
 1.212453552873646659e-02,
 1.210546067970031704e-02,
 1.208636740565900876e-02,
 1.206725573878907054e-02,
 1.204812571129545984e-02,
 1.202897735541012120e-02,
 1.200981070339315546e-02,
 1.199062578753179627e-02,
 1.197142264014128786e-02,
 1.195220129356385982e-02,
 1.193296178016952334e-02,
 1.191370413235552823e-02,
 1.189442838254653467e-02,
 1.187513456319418126e-02,
 1.185582270677768349e-02,
 1.183649284580300109e-02,
 1.181714501280362560e-02,
 1.179777924033964011e-02,
 1.177839556099846870e-02,
 1.175899400739441499e-02,
 1.173957461216836896e-02,
 1.172013740798848874e-02,
 1.170068242754921869e-02,
 1.168120970357202672e-02,
 1.166171926880505728e-02,
 1.164221115602300655e-02,
 1.162268539802688294e-02,
 1.160314202764459526e-02,
 1.158358107773008877e-02,
 1.156400258116403734e-02,
 1.154440657085309928e-02,
 1.152479307973053313e-02,
 1.150516214075564952e-02,
 1.148551378691401934e-02,
 1.146584805121707469e-02,
 1.144616496670270399e-02,
 1.142646456643427004e-02,
 1.140674688350156590e-02,
 1.138701195102010018e-02,
 1.136725980213103282e-02,
 1.134749047000162964e-02,
 1.132770398782450595e-02,
 1.130790038881831355e-02,
 1.128807970622700170e-02,
 1.126824197332023519e-02,
 1.124838722339317407e-02,
 1.122851548976653256e-02,
 1.120862680578603096e-02,
 1.118872120482317274e-02,
 1.116879872027434252e-02,
 1.114885938556154678e-02,
 1.112890323413141293e-02,
 1.110893029945642443e-02,
 1.108894061503349834e-02,
 1.106893421438462886e-02,
 1.104891113105713196e-02,
 1.102887139862266351e-02,
 1.100881505067815951e-02,
 1.098874212084512136e-02,
 1.096865264276994205e-02,
 1.094854665012329371e-02,
 1.092842417660095690e-02,
 1.090828525592276235e-02,
 1.088812992183350349e-02,
 1.086795820810193026e-02,
 1.084777014852157835e-02,
 1.082756577691010823e-02,
 1.080734512710963130e-02,
 1.078710823298606979e-02,
 1.076685512842999806e-02,
 1.074658584735563478e-02,
 1.072630042370156800e-02,
 1.070599889143033709e-02,
 1.068568128452810316e-02,
 1.066534763700536723e-02,
 1.064499798289596406e-02,
 1.062463235625794693e-02,
 1.060425079117261436e-02,
 1.058385332174526655e-02,
 1.056343998210463632e-02,
 1.054301080640312853e-02,
 1.052256582881632915e-02,
 1.050210508354360202e-02,
 1.048162860480728389e-02,
 1.046113642685342175e-02,
 1.044062858395076662e-02,
 1.042010511039211280e-02,
 1.039956604049246253e-02,
 1.037901140859056291e-02,
 1.035844124904781484e-02,
 1.033785559624854876e-02,
 1.031725448460026062e-02,
 1.029663794853316258e-02,
 1.027600602250036167e-02,
 1.025535874097737062e-02,
 1.023469613846284682e-02,
 1.021401824947761050e-02,
 1.019332510856542189e-02,
 1.017261675029217625e-02,
 1.015189320924649204e-02,
 1.013115452003934304e-02,
 1.011040071730405152e-02,
 1.008963183569594642e-02,
 1.006884790989297923e-02,
 1.004804897459479762e-02,
 1.002723506452354515e-02,
 1.000640621442334087e-02,
 9.985562459059996523e-03,
 9.964703833221719154e-03,
 9.943830371718033814e-03,
 9.922942109380829614e-03,
 9.902039081063249495e-03,
 9.881121321640470856e-03,
 9.860188866009216360e-03,
 9.839241749087904859e-03,
 9.818280005816065054e-03,
 9.797303671155273980e-03,
 9.776312780087904539e-03,
 9.755307367618155923e-03,
 9.734287468771326765e-03,
 9.713253118594047594e-03,
 9.692204352153854091e-03,
 9.671141204539775160e-03,
 9.650063710861469038e-03,
 9.628971906250061163e-03,
 9.607865825857153652e-03,
 9.586745504855557348e-03,
 9.565610978438925799e-03,
 9.544462281821312899e-03,
 9.523299450237967395e-03,
 9.502122518944290316e-03,
 9.480931523216749174e-03,
 9.459726498351889168e-03,
 9.438507479667089528e-03,
 9.417274502499939012e-03,
 9.396027602208638363e-03,
 9.374766814171224885e-03,
 9.353492173786477973e-03,
 9.332203716472904295e-03,
 9.310901477669471585e-03,
 9.289585492835032710e-03,
 9.268255797448658739e-03,
 9.246912427009104651e-03,
 9.225555417034951577e-03,
 9.204184803065033546e-03,
 9.182800620657420934e-03,
 9.161402905390286094e-03,
 9.139991692861325692e-03,
 9.118567018687960199e-03,
 9.097128918506742351e-03,
 9.075677427974222777e-03,
 9.054212582765839776e-03,
 9.032734418576795349e-03,
 9.011242971121430703e-03,
 8.989738276133474315e-03,
 8.968220369365455594e-03,
 8.946689286589476833e-03,
 8.925145063596267789e-03,
 8.903587736196023547e-03,
 8.882017340217387980e-03,
 8.860433911508255184e-03,
 8.838837485935306312e-03,
 8.817228099383695589e-03,
 8.795605787757699093e-03,
 8.773970586979810971e-03,
 8.752322532991522325e-03,
 8.730661661752450384e-03,
 8.708988009240964737e-03,
 8.687301611453757122e-03,
 8.665602504405966328e-03,
 8.643890724130699407e-03,
 8.622166306679760264e-03,
 8.600429288122568919e-03,
 8.578679704547139892e-03,
 8.556917592059305050e-03,
 8.535142986783065752e-03,
 8.513355924859945800e-03,
 8.491556442449890024e-03,
 8.469744575730237326e-03,
 8.447920360896083239e-03,
 8.426083834160475947e-03,
 8.404235031753954852e-03,
 8.382373989924762209e-03,
 8.360500744938291484e-03,
 8.338615333077845429e-03,
 8.316717790643669839e-03,
 8.294808153953669994e-03,
 8.272886459342956161e-03,
 8.250952743163895639e-03,
 8.229007041785701623e-03,
 8.207049391595154855e-03,
 8.185079828995545440e-03,
 8.163098390407656432e-03,
 8.141105112268691782e-03,
 8.119100031033077772e-03,
 8.097083183171878418e-03,
 8.075054605173050473e-03,
 8.053014333540917807e-03,
 8.030962404796507942e-03,
 8.008898855477664808e-03,
 7.986823722138181383e-03,
 7.964737041349085125e-03,
 7.942638849696974368e-03,
 7.920529183785329774e-03,
 7.898408080233391970e-03,
 7.876275575677080948e-03,
 7.854131706767948293e-03,
 7.831976510174013320e-03,
 7.809810022579161126e-03,
 7.787632280683304785e-03,
 7.765443321201940391e-03,
 7.743243180866829674e-03,
 7.721031896425067584e-03,
 7.698809504639875928e-03,
 7.676576042289672691e-03,
 7.654331546168807558e-03,
 7.632076053087158592e-03,
 7.609809599869695081e-03,
 7.587532223357286790e-03,
 7.565243960405657053e-03,
 7.542944847886146921e-03,
 7.520634922685243313e-03,
 7.498314221704654482e-03,
 7.475982781860866788e-03,
 7.453640640085856806e-03,
 7.431287833326124213e-03,
 7.408924398543553086e-03,
 7.386550372714392743e-03,
 7.364165792830060057e-03,
 7.341770695896562664e-03,
 7.319365118934726203e-03,
 7.296949098979598446e-03,
 7.274522673081288034e-03,
 7.252085878304008644e-03,
 7.229638751726281953e-03,
 7.207181330441728671e-03,
 7.184713651557443972e-03,
 7.162235752195360121e-03,
 7.139747669491057318e-03,
 7.117249440594827954e-03,
 7.094741102670431079e-03,
 7.072222692896077724e-03,
 7.049694248463759562e-03,
 7.027155806579454475e-03,
 7.004607404462597463e-03,
 6.982049079346900299e-03,
 6.959480868479243042e-03,
 6.936902809120629870e-03,
 6.914314938545180339e-03,
 6.891717294040848422e-03,
 6.869109912909072968e-03,
 6.846492832464297178e-03,
 6.823866090034774387e-03,
 6.801229722961535905e-03,
 6.778583768599204598e-03,
 6.755928264315403352e-03,
 6.733263247490966705e-03,
 6.710588755519378799e-03,
 6.687904825807565283e-03,
 6.665211495774855076e-03,
 6.642508802853928397e-03,
 6.619796784489744707e-03,
 6.597075478140289502e-03,
 6.574344921276170130e-03,
 6.551605151380637468e-03,
 6.528856205949110612e-03,
 6.506098122489986126e-03,
 6.483330938523551232e-03,
 6.460554691582810413e-03,
 6.437769419213090760e-03,
 6.414975158971497268e-03,
 6.392171948427858262e-03,
 6.369359825163533641e-03,
 6.346538826772488671e-03,
 6.323708990860094428e-03,
 6.300870355044060206e-03,
 6.278022956953780397e-03,
 6.255166834230612913e-03,
 6.232302024527221727e-03,
 6.209428565508411275e-03,
 6.186546494850184499e-03,
 6.163655850240503525e-03,
 6.140756669378194185e-03,
 6.117848989974407521e-03,
 6.094932849750744550e-03,
 6.072008286440757664e-03,
 6.049075337788810923e-03,
 6.026134041550486840e-03,
 6.003184435492666185e-03,
 5.980226557393232209e-03,
 5.957260445041084526e-03,
 5.934286136235749666e-03,
 5.911303668788082770e-03,
 5.888313080519217216e-03,
 5.865314409261549074e-03,
 5.842307692857632087e-03,
 5.819292969161041565e-03,
 5.796270276035720391e-03,
 5.773239651356291274e-03,
 5.750201133007370666e-03,
 5.727154758884465610e-03,
 5.704100566892886942e-03,
 5.681038594948554198e-03,
 5.657968880977577546e-03,
 5.634891462915764260e-03,
 5.611806378709551131e-03,
 5.588713666314794500e-03,
 5.565613363697816292e-03,
 5.542505508834301604e-03,
 5.519390139710101013e-03,
 5.496267294320699749e-03,
 5.473137010671398107e-03,
 5.449999326776711235e-03,
 5.426854280661233022e-03,
 5.403701910358522410e-03,
 5.380542253912112133e-03,
 5.357375349374242368e-03,
 5.334201234807365612e-03,
 5.311019948282271440e-03,
 5.287831527879606128e-03,
 5.264636011688573342e-03,
 5.241433437807978442e-03,
 5.218223844345116526e-03,
 5.195007269416587747e-03,
 5.171783751147856698e-03,
 5.148553327672828264e-03,
 5.125316037134656881e-03,
 5.102071917684660590e-03,
 5.078821007483312437e-03,
 5.055563344699121574e-03,
 5.032298967509469395e-03,
 5.009027914100065704e-03,
 4.985750222665108304e-03,
 4.962465931406693197e-03,
 4.939175078535733114e-03,
 4.915877702270765766e-03,
 4.892573840838854160e-03,
 4.869263532475000267e-03,
 4.845946815422312419e-03,
 4.822623727931587244e-03,
 4.799294308261490075e-03,
 4.775958594678898425e-03,
 4.752616625457909728e-03,
 4.729268438880681810e-03,
 4.705914073236873441e-03,
 4.682553566823852501e-03,
 4.659186957946064543e-03,
 4.635814284915921839e-03,
 4.612435586052708765e-03,
 4.589050899683371106e-03,
 4.565660264141997368e-03,
 4.542263717769998328e-03,
 4.518861298915485131e-03,
 4.495453045934173948e-03,
 4.472038997188251472e-03,
 4.448619191047352428e-03,
 4.425193665887469305e-03,
 4.401762460091798897e-03,
 4.378325612050273062e-03,
 4.354883160159107695e-03,
 4.331435142821683099e-03,
 4.307981598447411208e-03,
 4.284522565452707037e-03,
 4.261058082259917487e-03,
 4.237588187298136667e-03,
 4.214112919002640373e-03,
 4.190632315815069966e-03,
 4.167146416182873798e-03,
 4.143655258560135536e-03,
 4.120158881406466543e-03,
 4.096657323187876711e-03,
 4.073150622376169906e-03,
 4.049638817449135661e-03,
 4.026121946890008803e-03,
 4.002600049188252684e-03,
 3.979073162838661464e-03,
 3.955541326341596893e-03,
 3.932004578203285826e-03,
 3.908462956935288522e-03,
 3.884916501054733271e-03,
 3.861365249083722681e-03,
 3.837809239550183694e-03,
 3.814248510986749992e-03,
 3.790683101931661882e-03,
 3.767113050928103200e-03,
 3.743538396524460216e-03,
 3.719959177273733132e-03,
 3.696375431734337524e-03,
 3.672787198469058736e-03,
 3.649194516045993833e-03,
 3.625597423037443118e-03,
 3.601995958020821724e-03,
 3.578390159577977871e-03,
 3.554780066295450472e-03,
 3.531165716764032847e-03,
 3.507547149578915408e-03,
 3.483924403340045179e-03,
 3.460297516651145242e-03,
 3.436666528120586005e-03,
 3.413031476360775009e-03,
 3.389392399988333873e-03,
 3.365749337623570505e-03,
 3.342102327891282709e-03,
 3.318451409419680490e-03,
 3.294796620841217855e-03,
 3.271138000792016016e-03,
 3.247475587912057680e-03,
 3.223809420844613288e-03,
 3.200139538237072815e-03,
 3.176465978739842055e-03,
 3.152788781007365669e-03,
 3.129107983696946278e-03,
 3.105423625469658656e-03,
 3.081735744989854038e-03,
 3.058044380924734244e-03,
 3.034349571945197787e-03,
 3.010651356724704068e-03,
 2.986949773940166756e-03,
 2.963244862271336225e-03,
 2.939536660401018131e-03,
 2.915825207014474500e-03,
 2.892110540800277210e-03,
 2.868392700449211210e-03,
 2.844671724655244670e-03,
 2.820947652114422655e-03,
 2.797220521525731456e-03,
 2.773490371590490999e-03,
 2.749757241012577760e-03,
 2.726021168497801996e-03,
 2.702282192754824550e-03,
 2.678540352494095198e-03,
 2.654795686428128472e-03,
 2.631048233272314206e-03,
 2.607298031743136412e-03,
 2.583545120559752745e-03,
 2.559789538442667871e-03,
 2.536031324114789050e-03,
 2.512270516300250424e-03,
 2.488507153725329386e-03,
 2.464741275117819479e-03,
 2.440972919207244195e-03,
 2.417202124724269780e-03,
 2.393428930401550470e-03,
 2.369653374972624776e-03,
 2.345875497172901676e-03,
 2.322095335738551692e-03,
 2.298312929407353433e-03,
 2.274528316918239534e-03,
 2.250741537010850831e-03,
 2.226952628426372063e-03,
 2.203161629906442032e-03,
 2.179368580193986708e-03,
 2.155573518032651535e-03,
 2.131776482166990085e-03,
 2.107977511341875988e-03,
 2.084176644303367687e-03,
 2.060373919797571767e-03,
 2.036569376571675111e-03,
 2.012763053372782635e-03,
 1.988954988948800264e-03,
 1.965145222047852934e-03,
 1.941333791418450253e-03,
 1.917520735808950260e-03,
 1.893706093968360645e-03,
 1.869889904645409160e-03,
 1.846072206588690633e-03,
 1.822253038547565337e-03,
 1.798432439270377433e-03,
 1.774610447505954201e-03,
 1.750787102002382845e-03,
 1.726962441507978252e-03,
 1.703136504770177756e-03,
 1.679309330536406762e-03,
 1.655480957553476587e-03,
 1.631651424567794788e-03,
 1.607820770324766904e-03,
 1.583989033569658611e-03,
 1.560156253046490922e-03,
 1.536322467499009027e-03,
 1.512487715669450210e-03,
 1.488652036300064114e-03,
 1.464815468131191100e-03,
 1.440978049902797266e-03,
 1.417139820353337980e-03,
 1.393300818220108515e-03,
 1.369461082239435950e-03,
 1.345620651146227061e-03,
 1.321779563674164992e-03,
 1.297937858555109911e-03,
 1.274095574519986318e-03,
 1.250252750297631624e-03,
 1.226409424615812916e-03,
 1.202565636200104158e-03,
 1.178721423774733816e-03,
 1.154876826062017177e-03,
 1.131031881782538053e-03,
 1.107186629654566571e-03,
 1.083341108394917643e-03,
 1.059495356717838135e-03,
 1.035649413335861880e-03,
 1.011803316959352566e-03,
 9.879571062960455612e-04,
 9.641108200519159233e-04,
 9.402644969300459491e-04,
 9.164181756316281714e-04,
 8.925718948548465705e-04,
 8.687256932957376472e-04,
 8.448796096475955216e-04,
 8.210336826011763048e-04,
 7.971879508441137140e-04,
 7.733424530617667020e-04,
 7.494972279361131369e-04,
 7.256523141467387033e-04,
 7.018077503695833476e-04,
 6.779635752784754239e-04,
 6.541198275432002964e-04,
 6.302765458310418583e-04,
 6.064337688055191104e-04,
 5.825915351273876393e-04,
 5.587498834535151908e-04,
 5.349088524377479479e-04,
 5.110684807304507202e-04,
 4.872288069780445320e-04,
 4.633898698238756103e-04,
 4.395517079070901997e-04,
 4.157143598636325161e-04,
 3.918778643251241700e-04,
 3.680422599197274080e-04,
 3.442075852715527589e-04,
 3.203738790008635686e-04,
 2.965411797234812608e-04,
 2.727095260516528615e-04,
 2.488789565929259767e-04,
 2.250495099510165875e-04,
 2.012212247252154228e-04,
 1.773941395105917888e-04,
 1.535682928975320787e-04,
 1.297437234719425454e-04,
 1.059204698155879522e-04,
 8.209857050509683063e-05,
 5.827806411283070607e-05,
 3.445898920629041534e-05,
 1.064138434831879679e-05,
-1.317471190349207185e-05,
-3.698926099593356597e-05,
-6.080222438130510613e-05,
-8.461356351641397650e-05,
-1.084232398638325335e-04,
-1.322312148