/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.processors.CommandProcessor;
import amazon.fws.clicommando.util.HelpUtils;
import amazon.fws.clicommando.util.StringUtils;
import java.util.Collection;

public class ParameterMergeCommandProcessor
implements CommandProcessor {
    public Command process(Command process) throws CliCommandoException {
        Collection<ParamConfig> parameters = process.getCurrentCommandConfig().getAllParameters();
        for (ParamConfig param : parameters) {
            if (StringUtils.isEmpty(param.getSameAs())) continue;
            ParamConfig otherParam = process.getCurrentCommandConfig().getParameter(param.getSameAs());
            if (otherParam == null) {
                throw new ConfigurationErrorException("same-as tag of: " + param.getName() + " is pointing to a non existing parameter: " + param.getSameAs());
            }
            int paramInputType = this.getValueType(param);
            int otherParamInputType = this.getValueType(otherParam);
            if (paramInputType > 0 && otherParamInputType > 0) {
                String option = HelpUtils.printLongOrShortValueOption("", param);
                String otherOption = HelpUtils.printLongOrShortValueOption("", otherParam);
                if (paramInputType != otherParamInputType) {
                    throw new ConfigurationErrorException("Conflicting value types for: " + param.getName() + " and " + otherParam.getName());
                }
                throw new BadInputException(ErrorMessages.ErrorCode.CONFLICTING_OPTIONS, option, otherOption);
            }
            switch (paramInputType) {
                case 1: {
                    otherParam.setValue(param.getValue());
                    break;
                }
                case 2: {
                    otherParam.setValues(param.getValues());
                    break;
                }
                case 3: {
                    otherParam.setValuesMap(param.getValuesMap());
                    break;
                }
            }
            param.setIsDirective(true);
        }
        return process;
    }

    private int getValueType(ParamConfig param) {
        int type = 0;
        if (StringUtils.notEmpty(param.getValue())) {
            type = 1;
        } else if (param.getValues().size() > 0) {
            type = 2;
        } else if (param.getValuesMap().size() > 0) {
            type = 3;
        }
        return type;
    }
}

