/*  libtrain
 *  Copyright (c) 2000 ARINO Kazuma & FURUKAWA Yo.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/* $Id: libtrain.c,v 1.1.1.1 2000/05/07 06:44:33 furukawa Exp $ */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>

#include "lfunc.h"
#include "base.h"
#include "graph.h"
#include "train.h"

#include "libtrain.h"

#define LINE_BUFFER_SIZE 128
#define PATH_SIZE 512

extern void test_reload(void);

static char gTrainDir[PATH_SIZE];

int
Train_Initialize(void)
{
    struct passwd *pwd;

    pwd = getpwuid(getuid());
    sprintf(gTrainDir, "%s/.train/", pwd->pw_dir);
    sprintf(Fn_init, "%s/train.ini", gTrainDir);
    if (read_ini() == -1){
	fprintf(stderr, "ERROR: Init file not found (%s).\n", Fn_init);
	return -1;
    }

    if (*RosenDir && *TrainFile){
	sprintf(TrainPath, "%s/%s", RosenDir, TrainFile);
    }

    test_reload();
    return 0;
}

void
Train_Finalize(void)
{
    /* nothing to do */
}

char *
Train_GetTrainDir(void)
{
    return gTrainDir;
}

void
Train_SetDataFile(char *data_path)
{
    strcpy(TrainPath, data_path);
    clear_data();
    test_reload();
}

void
Train_SetDepartureTime(int time)
{
    DeptTime = time;
}

int
Train_GetDepartureTime(void)
{
    return DeptTime;
}

int
Train_SetStartPoint(char *start_point)
{
    return roma2sortidx(start_point);
}

int
Train_SetEndPoint(char *end_point)
{
    return roma2sortidx(end_point);
}

int
Train_Search(int start_id, int end_id)
{
    search_exec2(end_id, start_id);
    return 0;
}

char *
Train_GetWalkText(void)
{
    return WalkStr;
}

char *
Train_GetWaitText(void)
{
    return WaitStr;
}

char *
Train_GetJoushaText(void)
{
    return JyosyaStr;
}

char *
Train_GetTotalText(void)
{
    return TotalStr;
}

int
Train_GetTotalTime(void)
{
    return Total_time;
}

char *
Train_GetResultText(void)
{
    int i;
    char buf[LINE_BUFFER_SIZE], buf2[LINE_BUFFER_SIZE];
    static char result[2048];

    result[0] = '\0';
    
    for (i=0; ; i++){
	if (get_result_text(i, buf)){
	    break;
	}
	sjis2euc(buf, buf2);
	
	if (*buf2 == '1' || *buf2 == '4'){
	    strcat(result, buf2 + 2);
	    strcat(result, "\n");
	}else if (*buf2 == '3'){
	    if (F_detail){
		strcat(result, buf2 + 2);
		strcat(result, "\n");
	    }
	}else if(*buf2 == '2'){
	    strcat(result, get_msg(0, 9));
	    strcat(result, " ");
	    strcat(result, buf2 + 2);
	    strcat(result, "\n");
	}else if(*buf2 == '5'){
	    strcat(result, get_msg(0, 0));
	    strcat(result, "\t");
	    strcat(result, get_msg(0, 5));
	    strncat(result, buf2 + 2, 5);
	    strcat(result, "\t");
	    strcat(result, get_msg(0, 6));
	    strncat(result, buf2 + 8, 5);
	    strcat(result, "\n");
	}
    }
    return result;
}

char *
Train_GetResultItem(int no)
{
    char buf[LINE_BUFFER_SIZE], buf2[LINE_BUFFER_SIZE];
    static char result[LINE_BUFFER_SIZE];

    result[0] = '\0';
    
    if (get_result_text(no, buf)){
	return NULL;
    }
    sjis2euc(buf, buf2);
    
    if (*buf2 == '1' || *buf2 == '4'){
	strcat(result, buf2 + 2);
    }else if (*buf2 == '3'){
	if (F_detail){
	    strcat(result, buf2 + 2);
	}
    }else if(*buf2 == '2'){
	strcat(result, get_msg(0, 9));
	strcat(result, " ");
	strcat(result, buf2 + 2);
    }else if(*buf2 == '5'){
	strcat(result, get_msg(0, 0));
	strcat(result, "\t");
	strcat(result, get_msg(0, 5));
	strncat(result, buf2 + 2, 5);
	strcat(result, "\t");
	strcat(result, get_msg(0, 6));
	strncat(result, buf2 + 8, 5);
    }
    return result;
}

void
Train_SetWalkLimit(int limit)
{
    F_walk = limit;
}

int
Train_GetWalkLimit(void)
{
    return F_walk;
}

void
Train_SetWaitLimit(int limit)
{
    F_wait = limit;
}

int
Train_GetWaitLimit(void)
{
    return F_wait;
}

void
Train_SetChangeLimit(int limit)
{
    F_change = limit;
}

int
Train_GetChangeLimit(void)
{
    return F_change;
}

void
Train_SetUseChargedExpress(int use)
{
    if (use){
	F_nouse |= 0x01;
    }else{
	F_nouse &= ~0x01;
    }
}

int
Train_GetUseChargedExpress(void)
{
    return !(F_nouse & 0x01);
}

void
Train_SetUseShinkansen(int use)
{
    if (use){
	F_nouse |= 0x02;
    }else{
	F_nouse &= ~0x02;
    }
}

int
Train_GetUseShinkansen(void)
{
    return !(F_nouse & 0x02);
}

void
Train_SetUseMisc(int use)
{
    if (use){
	F_nouse |= 0x04;
    }else{
	F_nouse &= ~0x04;
    }
}

int
Train_GetUseMisc(void)
{
    return !(F_nouse & 0x04);
}

void
Train_SetStartingWait(int on)
{
    F_machi = on;
}

int
Train_GetStartingWait(void)
{
    return F_machi;
}

void
Train_SetDetailed(int on)
{
    F_detail = on;
}

int
Train_GetDetailed(void)
{
    return F_detail;
}

int
Train_GetStationCount(void)
{
    return Num_s - 1;
}

char *
Train_GetStationName(int id)
{
    STATION *s;
    static char result[LINE_BUFFER_SIZE];
    
    s = get_station(get_sort_s_id(id));
    sjis2euc(STATION_get_name(s), result);
    return result;
}

char *
Train_GetStationNameInRoman(int id)
{
    STATION *s;
    static char result[LINE_BUFFER_SIZE];
    
    s = get_station(get_sort_s_id(id));
    sjis2euc(STATION_get_roma(s), result);
    return result;
}

int
Train_GetStationComplementCandidate(char *ss, int ss_len, int *cookie)
{
    int max;

    max = Train_GetStationCount();
    while (*cookie < max){
	int cmp;
	int candidate_len;
	char *candidate;
	candidate = Train_GetStationNameInRoman(*cookie);
	candidate_len = strlen(candidate);
	*cookie = *cookie + 1;
	if (ss_len > candidate_len){
	    continue;
	}
	cmp = strncmp(ss, candidate, ss_len);
	if (cmp == 0){
	    return *cookie - 1;
	}
    }
    return -1;
}
