/* ok */
#include	"lfunc.h"
#include	"base.h"

HLOCAL	StationHandle = NULL ;
HLOCAL	RosenHandle = NULL ;
#ifndef	TOOLS
HLOCAL	RStatHandle = NULL ;
#endif	/* TOOLS */
HLOCAL	SortHandle = NULL ;		/* Ȥ줿޻̾ */
HLOCAL	KSortHandle = NULL ;	/* Ȥ줿̾ */
int		Max_s = MAX_S ;
int		Max_r = MAX_R ;
int		Num_s = 0 ;
int		Num_r = 0 ;
int		Num_rstat = 0 ;
int		F_inter = 0 ;			/* International Ǥξ** */

/* ѱԲΰ */
#define	MAX_KAISYA	(MAX_R/10)
WORD	Kaisya_idx[ MAX_KAISYA ] ;	/* Բ̾ʸIDX */
BYTE	Kaisya_len[ MAX_KAISYA ] ;	/* Բ̾Ĺ */
BYTE	Kaisya_use[ MAX_KAISYA ] ;	/* ϩѥե饰 */
int		Num_kaisya = 0 ;		/* ԲҤθĿ */

/*----------------------------------------------------------------------------
 * STATION
 *--------------------------------------------------------------------------*/
void	STATION_init( WORD n_idx, WORD r_idx ,STATION *st) {
   st->name_idx = n_idx ; st->roma_idx = r_idx ;
#ifdef	TOOLS
   st->first_rosen_id = 0 ;
#endif	/* TOOLS */
}

int
STATION_cmp(  BYTE *nm,STATION *st ) 
{
   if ( F_inter ) {
      BYTE	tmpbuf1[ MAX_ST_NAME * 2 ], tmpbuf2[ MAX_ST_NAME * 2 ] ;
      roma2kana( ( BYTE *)StringGet( st->roma_idx ), tmpbuf1 ) ;
      roma2kana( ( BYTE *)nm, tmpbuf2 ) ;
      return Strcmp( tmpbuf1, tmpbuf2 ) ;
   } else {
#ifdef	TOOLS
      return Strcmp( StringGet( st->name_idx ), nm ) ;
#else	/* TOOLS */
/*      WORD	c, c2 ;*/
      unsigned char c,c2;
       BYTE	*p = StringGet( st->name_idx ) ;
       BYTE	*nm_org = nm ;
       BYTE	*p_org = p ;
      
      while ( ( c = 0xFF & *p++ ) != 0 ) {
	 if ( iskanji( c ) ) {
	    c  = (c  << 8) | (0xFF & *p++) ;
	    c2 = 0xFF & *nm++ ;
	    c2 = (c2 << 8) | (0xFF & *nm++) ;
	    if ( c != c2 ) {
	       if ( c != 0x8396U || (c2 != 0x8350U && c2 != 0x82AAU) ) {
		  return Strcmp( p_org, nm_org ) ;
	       }
	    }
	 } else {
	    c2 = 0xFF & *nm++ ;
	    if ( c != c2 ) {
	       return c < c2 ? -1 : 1 ;
	    }
	 }
      }
      return *nm ? -1 : 0 ;
#endif	/* TOOLS */
   }
}

 BYTE*
STATION_get_name(STATION *st)
{
   if ( F_inter ) {
#if 0
      static	char	tmpbuf[ 100 ] ;
      
      if ( st->roma_idx < 0 ) {
	 return "" ;
      }
      kana2roma( StringGet( st->roma_idx ), tmpbuf ) ;
      return tmpbuf ;
#else
      return StringGet( st->roma_idx ) ;
#endif
   } else {
      return StringGet( st->name_idx ) ;
   }
}

 BYTE*
STATION_get_roma(STATION *st)
{
    return st->roma_idx >= 0 ? StringGet( st->roma_idx ) : EmptyStr ;
 }

/*----------------------------------------------------------------------------
 * ROSEN
 *--------------------------------------------------------------------------*/
void	ROSEN_init( WORD n_idx, WORD n, WORD w, int c, int lk ,ROSEN *ro) {
   ro->name_idx = n_idx ; ro->num = n ; ro->wait = w ;
   ro->circle = (BYTE) c ; ro->len_kaisya = (BYTE) lk ;
   ro->flag = FLAG_USE ;
#ifdef	TOOLS
   ro->stat = ro->time = 0 ;
   ro->size = n ;
#else	/* TOOLS */
   ro->rstat_idx = 0 ;
#endif	/* TOOLS */
   ro->kid = KID_NONE ;
}

WORD	ROSEN_get_wait(ROSEN *ro)  { return ro->wait ; }

#ifdef	TOOLS
int   ROSEN_get_s_id( int idx,ROSEN *ro )  { return ro->stat[ idx ] ; } ;
int   ROSEN_get_time( int idx,ROSEN *ro )  { return ro->time[ idx ] ; } ;
#else	/* TOOLS */
int   ROSEN_get_s_id( int idx,ROSEN *ro )  ;
int   ROSEN_get_time( int idx, ROSEN *ro )  ;
#endif	/* TOOLS */

int	ROSEN_get_kid(ROSEN *ro) { return ro->kid ; } ;
void	ROSEN_set_kid( int idx,ROSEN *ro ) { ro->kid = idx ; } ;
WORD	ROSEN_get_num(ROSEN *ro) { return ro->num ; }

int ROSEN_get_circle(ROSEN *ro) { return (int) ro->circle ; }
int ROSEN_get_len_kaisya(ROSEN *ro)  { return (int) ro->len_kaisya ; }
int ROSEN_get_use(ROSEN *ro)  { return ro->flag & FLAG_USE ; }
int ROSEN_get_ploop(ROSEN *ro) { return ro->flag & FLAG_PLOOP ; }
int ROSEN_get_lmark(ROSEN *ro) { return ro->flag & FLAG_LMARK ; }

WORD	ROSEN_get_name_idx(ROSEN *ro) { return ro->name_idx ; }
void	ROSEN_set_use( BOOL _flag,ROSEN *ro ) ;
int	ROSEN_find( int st_id ,ROSEN *ro)  ;
int	ROSEN_diff_time( int time_from, int time_to,ROSEN *ro );
int	ROSEN_calc_time( int from, int to ,ROSEN *ro);

int	ROSEN_nouse( int mask,ROSEN *ro ) {
   return ((mask & 0x01) && ((ro->flag & MASK_KIND) == FLAG_KIND_EXP))
      || ((mask & 0x02) && ((ro->flag & MASK_KIND) == FLAG_KIND_SEXP))
	 || ((mask & 0x04) && ((ro->flag & MASK_KIND) == FLAG_KIND_OTHER)) ;
	}
int ROSEN_available( int mask ,ROSEN *ro) {
   return ROSEN_get_use(ro) && !ROSEN_nouse( mask,ro ) ;
}

 BYTE*
ROSEN_get_name(ROSEN *ro) 
{
    return StringGet( ro->name_idx ) ;
 }

int
ROSEN_find( int st_id ,ROSEN *ro)
{
   int i;
   for ( i = 0 ; i < ro->num ; i ++ ) {
      if ( ROSEN_get_s_id( i,ro ) == st_id ) {
	 return i + 1 ;
      }
   }
   return 0 ;
}

int
ROSEN_diff_time( int time_from, int time_to ,ROSEN *ro) 
{
   int		tmp ;
   int result;
   if ( time_from < 0 || time_to < 0 ) {
      return -1 ;
    }
   if ( time_from > time_to ) {
      tmp = time_from, time_from = time_to, time_to = tmp ;
   }
   result = time_to - time_from ;
   if ( ro->circle ) {
      tmp = time_from + (0xFF & ro->circle) - time_to ;
      if ( tmp < result ) {
	 result = tmp ;
      }
   }
   return result ;
}

void
ROSEN_set_use( BOOL _flag ,ROSEN *ro)
{
   if ( _flag ) {
      ro->flag |= FLAG_USE ;
   } else {
      ro->flag &= ~FLAG_USE ;
   }
}

#ifndef	TOOLS
int
ROSEN_get_s_id( int idx ,ROSEN *ro)
{
    short	*stat_time ;
   
   stat_time = &((short *) RStatHandle)[ ro->rstat_idx ] ;
   return stat_time[ idx ] ;
}

int
ROSEN_get_time( int idx ,ROSEN *ro)
{
    short	*stat_time ;
   stat_time = &((short *) RStatHandle)[ ro->rstat_idx ] ;
   return stat_time[ ro->num + idx ] ;
}
#endif	/* TOOLS */

/* zzz*/
/*----------------------------------------------------------------------------
 * common function
 *--------------------------------------------------------------------------*/
void
init_station()
{
   Assert( StationHandle == NULL ) ;
   StationHandle = LocalAlloc( LPTR, sizeof (STATION) * Max_s ) ;
   SortHandle = LocalAlloc( LPTR, sizeof (WORD) * Max_s ) ;
   KSortHandle = LocalAlloc( LPTR, sizeof (WORD) * Max_s ) ;
   Num_s = 0 ;
}

#ifndef	TOOLS
void
free_station()
{
   if ( StationHandle ) {
      LocalFree( StationHandle ) ;
      StationHandle = NULL ;
   }
   if ( SortHandle ) {
      LocalFree( SortHandle ) ;
      SortHandle = NULL ;
   }
   if ( KSortHandle ) {
      LocalFree( KSortHandle ) ;
      KSortHandle = NULL ;
   }
   Max_s = MAX_S ;
   Num_s = 0 ;
}
#endif	TOOLS

void
init_rosen()
{
    Assert( RosenHandle == NULL ) ;
    RosenHandle = LocalAlloc( LPTR, sizeof (ROSEN) * Max_r ) ;
#ifndef	TOOLS
    Assert( RStatHandle == NULL ) ;
    RStatHandle = LocalAlloc( LPTR, sizeof (short) * Num_rstat * 2 ) ;
#endif	/* TOOLS */
    Num_r = 0 ;
 }

#ifndef	TOOLS
void
free_rosen( void )
{
   if ( RStatHandle ) {
      LocalFree( RStatHandle ) ;
      RStatHandle = NULL ;
	}
   if ( RosenHandle ) {
      LocalFree( RosenHandle ) ;
      RosenHandle = NULL ;
   }
   Max_r = MAX_R ;
   Num_r = 0 ;
   Num_rstat = 0 ;
}
#endif	/* TOOLS */

LPSTATION
get_station( int index )
{
   Assert( index < Num_s ) ;
   return &((LPSTATION) StationHandle)[ index ] ;
}

LPROSEN
get_rosen( int index )
{
   Assert( index < Num_r ) ;
   return &((LPROSEN) RosenHandle)[ index ] ;
}

/*
 * ȱ̾ط
 */

#if 0
/*
 * ̾ΰΥǥåأɣĤ
 */
int
get_ksort_s_id( int index )
{
   Assert( index >= 0 && index < Num_s ) ;
   return ((WORD *) KSortHandle)[ index ] ;
}
#endif

/*
 * ̾ǱأɣĤ򸡺
 */
BOOL
name2stid(  BYTE *name, LPDWORD pIndex )
{
   int		upper, lower, half, s_id, ret ;
   if ( Strlen( name ) <= 0 ) {
      return FALSE ;
   }
   upper = 0, lower = Num_s - 1 ;
   while ( 1 ) {
      half = (upper + lower) / 2 ;
      s_id = get_ksort_s_id( half ) ;
/*      ret = get_station( s_id )->cmp( name ) ;*/
      ret = STATION_cmp(name,get_station( s_id ));
      if ( ret == 0 ) {
	 while ( half > 0 ) {
	    s_id = get_ksort_s_id( half - 1 ) ;
/*	    if ( get_station( s_id )->cmp( name ) ) {*/
	    if ( STATION_cmp(name,get_station( s_id ))){
	       break ;
	    }
	    half -- ;
	 }
	 *pIndex = get_ksort_s_id( half ) ;
	 return TRUE ;
      }
      if ( half == lower ) {
	 return FALSE ;
      }
      if ( ret > 0 ) {
	 lower = half - 1 ;
      } else {
	 upper = half + 1 ;
      }
      if ( lower < upper ) {
	 return FALSE ;
      }
   }
}

/*
 * ޻̾ΰΥǥåأɣĤ
 */
int
get_sort_s_id( int index )
{
/*   Assert( index >= 0 && index < Num_s - 1 ) ;*/
   Assert( index >= 0 && index < Num_s ) ;
   return ((WORD *) SortHandle)[ index ] ;
}

/*
 * ޻̾ؤΥIndex
 */
int
roma2sortidx(  BYTE *roma )
{
   BYTE	kana[ 100 ] ;
   int len;
   int		upper, lower, half, s_id, ret ;
   roma2kana( roma, kana ) ;
   len = Strlen( kana ) ;
   if ( len <= 0 ) {
      return FALSE ;
   }
   
    upper = 0, lower = Num_s - 2 ;
    while ( 1 ) {
		half = (upper + lower) / 2 ;
		s_id = get_sort_s_id( half ) ;
/*		ret = Memcmp( get_station( s_id )->get_roma(), kana, len ) ;*/
		ret = Memcmp( STATION_get_roma(get_station( s_id )), kana, 
			     len ) ;
		if ( ret == 0 ) {
		   while ( half > 0 ) {
		      s_id = get_sort_s_id( half - 1 ) ;
		      if ( Memcmp( STATION_get_roma(get_station( s_id )), 
				  kana, len ) ) {
			 break ;
		      }
		      half -- ;
		   }
		   return get_sort_s_id(half);
		}
		if ( half == lower ) {
		   return -1;
		}
		if ( ret > 0 ) {
		   lower = half - 1 ;
		} else {
		   upper = half + 1 ;
		}
		if ( lower < upper ) {
		   return -1 ;
		}
	     }
}

#if 0
/*
 * ޻̾ؤΥIndex
 */
BOOL
roma2sortidx(  BYTE *roma, LPDWORD index )
{
   BYTE	kana[ 100 ] ;
   int len;
   int		upper, lower, half, s_id, ret ;
   roma2kana( roma, kana ) ;
   len = Strlen( kana ) ;
   if ( len <= 0 ) {
      return FALSE ;
   }
   
    upper = 0, lower = Num_s - 2 ;
    while ( 1 ) {
		half = (upper + lower) / 2 ;
		s_id = get_sort_s_id( half ) ;
/*		ret = Memcmp( get_station( s_id )->get_roma(), kana, len ) ;*/
		ret = Memcmp( STATION_get_roma(get_station( s_id )), kana, 
			     len ) ;
		if ( ret == 0 ) {
		   while ( half > 0 ) {
		      s_id = get_sort_s_id( half - 1 ) ;
		      if ( Memcmp( STATION_get_roma(get_station( s_id )), 
				  kana, len ) ) {
			 break ;
		      }
		      half -- ;
		   }
		   *index = half ;
		   return TRUE ;
		}
		if ( half == lower ) {
		   return FALSE ;
		}
		if ( ret > 0 ) {
		   lower = half - 1 ;
		} else {
		   upper = half + 1 ;
		}
		if ( lower < upper ) {
		   return FALSE ;
		}
	     }
}
#endif


/*
 * ԲҰΤΥǡ
 */
void
init_kaisya()
{
    int		last_len = 0, r_id, i, f_other = 0 ;
    BYTE	last_name[ 100 ] ;
    BYTE	name[ 100 ] ;

    last_name[0] = name[0] = 0 ;
    Num_kaisya = 0 ;
    for ( r_id = 1 ; r_id < Num_r ; r_id ++ ) {
		ROSEN	*r = get_rosen( r_id ) ;
/*		int		len = r->get_len_kaisya() ;*/
		int		len = ROSEN_get_len_kaisya(r) ;
		WORD	idx = ROSEN_get_name_idx(r) ;

		Strcpy( name, StringGet( idx ) ) ;
		if ( len == 0 ) {
			f_other = 1 ;
			/*			r->set_kid( KID_NONE ) ;*/
			ROSEN_set_kid( KID_NONE ,r) ;
			continue ;
		     }
		if ( last_len != len || Memcmp( last_name, name, len ) != 0 ) {
		   for ( i = 0 ; i < Num_kaisya ; i ++ ) {
		      WORD	o_idx = Kaisya_idx[ i ] ;
		      int		o_len = Kaisya_len[ i ] ;
		       BYTE	*o_name = StringGet( o_idx ) ;
		      if ( o_len == len && Memcmp( o_name, name, len ) == 0 ) {
/*			 r->set_kid( i ) ;*/
			 ROSEN_set_kid( KID_NONE ,r) ;
			 goto next ;
		      }
		   }
		   /* ԲҤϿɬפ */
		   Assert( Num_kaisya < MAX_KAISYA ) ;
		   Kaisya_idx[ Num_kaisya ] = idx ;
		   Kaisya_len[ Num_kaisya ] = len ;
		   Num_kaisya ++ ;
		   /* ΥǡȤ */
		   Strcpy( last_name, name ) ;
		   last_len = len ;
		}
/*		r->set_kid( Num_kaisya - 1 ) ;*/
		ROSEN_set_kid( Num_kaisya - 1 ,r) ;
		next:;
    }
    if ( f_other ) {
		/* ¾αԲҤϿ */
		Assert( Num_kaisya < MAX_KAISYA ) ;
		Kaisya_idx[ Num_kaisya ] = 0 ;
		Kaisya_len[ Num_kaisya ] = 0 ;
		Num_kaisya ++ ;
		for ( r_id = 1 ; r_id < Num_r ; r_id ++ ) {
			ROSEN	*r = get_rosen( r_id ) ;
/*			if ( r->get_kid() == KID_NONE ) {
			r->set_kid( Num_kaisya - 1 ) ;*/
			if ( ROSEN_get_kid(r) == KID_NONE ) {
			   ROSEN_set_kid( Num_kaisya - 1,r) ;
			}
		     }
	     }
 }

/* zzz ޤ */
extern BOOL	han2zen_kanastr(  BYTE *src, LPBYTE dst, DWORD dstlen, BOOL fHira );


 BYTE *
get_station_kana( int s_id )
{
    BYTE	*q ;
   static BYTE	kana[ MAX_ST_NAME * 2 + 1 ] ;
   
   q = STATION_get_roma(get_station( s_id ));
   han2zen_kanastr( q, kana, sizeof kana, TRUE ) ;
   return kana ;
}

/*
 * ȱ̾ط
 */

/*
 * ̾ΰΥǥåأɣĤ
 */
int
get_ksort_s_id( int index )
{
    Assert( index >= 0 && index < Num_s ) ;
    return ((WORD *)KSortHandle)[index] ;
}



/*
 * ̾ǱأɣĤ򸡺
 */
int
find_name_s_id( char name[] )
{
    if ( F_inter ) {
	char	kana[ 100 ] ;
	int		upper, lower, half, s_id, ret ;
	STATION *s;
	roma2kana( name, kana ) ;
	if ( Strlen( kana ) <= 0 ) {
	    return -1 ;
	}
	upper = 0, lower = Num_s - 2 ;
	while ( 1 ) {
	   half = (upper + lower) / 2 ;
	   s_id = get_sort_s_id( half ) ;
	   ret = Strcmp( STATION_get_roma(get_station( s_id )), kana ) ;
	   if ( ret == 0 ) {
	      while ( half > 0 ) {
		 s_id = get_sort_s_id( half - 1 ) ;
		 if ( Strcmp( STATION_get_roma(get_station( s_id )), kana ) ) {
		    break ;
		 }
		 half -- ;
	      }
	      return get_sort_s_id( half ) ;
	   }
	   if ( half == lower ) {
	      return -1 ;
	   }
	   if ( ret > 0 ) {
	      lower = half - 1 ;
	   } else {
	      upper = half + 1 ;
	   }
	   if ( lower < upper ) {
	      return -1 ;
	   }
	}
    } else {
       int		upper, lower, half, s_id, ret ;
       if ( Strlen( name ) <= 0 ) {
	  return -1 ;
       }
       upper = 0, lower = Num_s - 1 ;


       while ( 1 ) {
	  half = (upper + lower) / 2 ;
	  s_id = get_ksort_s_id( half ) ;
	  ret = STATION_cmp(name,get_station( s_id ));
	  if ( ret == 0 ) {
	     while ( half > 0 ) {
		s_id = get_ksort_s_id( half - 1 ) ;
		if ( STATION_cmp(name,get_station( s_id ))) {
		   break ;
		}
		half -- ;
	     }
	     return get_ksort_s_id( half ) ;
	  }
	  if ( half == lower ) {
	     return -1 ;
	  }
	  if ( ret > 0 ) {
	     lower = half - 1 ;
	  } else {
	     upper = half + 1 ;
	  }
	  if ( lower < upper ) {
	     return -1 ;
	  }
       }
    }
}

