/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.html.HtmlDocDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlMetadata;
import edu.harvard.hul.ois.jhove.module.html.HtmlTagDesc;
import edu.harvard.hul.ois.jhove.module.html.JHAttribute;
import edu.harvard.hul.ois.jhove.module.html.JHElement;
import java.util.ArrayList;
import java.util.List;

public class JHOpenTag
extends JHElement {
    public String _name;
    public List _attributes;
    private HtmlTagDesc _element;
    private String _errorMessage;
    private int _contentIdx;
    private int _elementCount;

    public JHOpenTag(List list, String string, List list2, int n, int n2) {
        super(list);
        this._name = string.toLowerCase();
        this._attributes = list2;
        this._line = n;
        this._column = n2;
        this._contentIdx = 0;
        this._elementCount = 0;
    }

    public JHOpenTag(List list, String string, List list2, int n, int n2, String string2) {
        this(list, string, list2, n, n2);
        this._errorMessage = string2;
    }

    public JHOpenTag(String string) {
        super(null);
        this._name = string;
        this._attributes = new ArrayList(1);
        this._contentIdx = 0;
    }

    public void setElement(HtmlTagDesc htmlTagDesc) {
        this._element = htmlTagDesc;
    }

    public HtmlTagDesc getElement() {
        return this._element;
    }

    public String getName() {
        return this._name;
    }

    public List getAttributes() {
        return this._attributes;
    }

    protected void processElement(HtmlMetadata htmlMetadata) {
        if ("html".equals(this._name)) {
            this.processHtml(htmlMetadata);
        } else if ("meta".equals(this._name)) {
            this.processMeta(htmlMetadata);
        } else if ("a".equals(this._name)) {
            this.processA(htmlMetadata);
        } else if ("img".equals(this._name)) {
            this.processImg(htmlMetadata);
        } else if ("frame".equals(this._name)) {
            this.processFrame(htmlMetadata);
        } else if ("script".equals(this._name)) {
            this.processScript(htmlMetadata);
        }
        for (JHAttribute jHAttribute : this._attributes) {
            if (!"lang".equals(jHAttribute.getName()) || jHAttribute.getValue() == null) continue;
            htmlMetadata.addLanguage(jHAttribute.getValue());
        }
    }

    protected boolean allowsTag(String string, HtmlDocDesc htmlDocDesc) {
        return this._element.allowsTag(string, this._contentIdx, htmlDocDesc);
    }

    protected boolean canGetMore() {
        return this._element.canGetMoreAt(this._contentIdx, this._elementCount);
    }

    protected void countComponent() {
        ++this._elementCount;
    }

    protected void advanceIndex() {
        ++this._contentIdx;
        this._elementCount = 0;
    }

    protected boolean canAdvance() {
        return this._element.canAdvanceFrom(this._contentIdx, this._elementCount);
    }

    protected String getErrorMessage() {
        return this._errorMessage;
    }

    private void processHtml(HtmlMetadata htmlMetadata) {
        String string = null;
        for (JHAttribute jHAttribute : this._attributes) {
            if (!"lang".equals(jHAttribute.getName())) continue;
            string = jHAttribute.getValue();
        }
        if (string != null) {
            htmlMetadata.setLanguage(string);
        }
    }

    private void processMeta(HtmlMetadata htmlMetadata) {
        String string = null;
        String string2 = null;
        String string3 = null;
        for (Object object : this._attributes) {
            String string4 = ((JHAttribute)object).getName();
            String string5 = ((JHAttribute)object).getValue();
            if ("name".equals(string4)) {
                string = string5;
            }
            if ("http-equiv".equals(string4)) {
                string2 = string5;
            }
            if (!"content".equals(string4)) continue;
            string3 = string5;
        }
        if (string != null || string2 != null || string3 != null) {
            Object object;
            object = new ArrayList(3);
            if (string != null) {
                object.add(new Property("Name", PropertyType.STRING, string));
            }
            if (string2 != null) {
                object.add(new Property("Httpequiv", PropertyType.STRING, string2));
            }
            if (string3 != null) {
                object.add(new Property("Content", PropertyType.STRING, string3));
            }
            htmlMetadata.addMeta(new Property("Meta", PropertyType.PROPERTY, PropertyArity.LIST, object));
        }
    }

    private void processA(HtmlMetadata htmlMetadata) {
        for (JHAttribute jHAttribute : this._attributes) {
            if (!"href".equals(jHAttribute.getName())) continue;
            String string = jHAttribute.getValue();
            if (string.length() <= 0 || string.charAt(0) == '#') break;
            htmlMetadata.addLink(string);
            break;
        }
    }

    private void processImg(HtmlMetadata htmlMetadata) {
        Object object2;
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = -1;
        int n2 = -1;
        for (Object object2 : this._attributes) {
            String string4 = ((JHAttribute)object2).getName();
            String string5 = ((JHAttribute)object2).getValue();
            if ("alt".equals(string4)) {
                string = string5;
                continue;
            }
            if ("src".equals(string4)) {
                string3 = string5;
                continue;
            }
            if ("longdesc".equals(string4)) {
                string2 = string5;
                continue;
            }
            if ("height".equals(string4)) {
                try {
                    n = Integer.parseInt(string5);
                }
                catch (Exception exception) {}
                continue;
            }
            if (!"width".equals(string4)) continue;
            try {
                n2 = Integer.parseInt(string5);
            }
            catch (Exception exception) {}
        }
        object2 = new ArrayList(5);
        if (string != null) {
            object2.add(new Property("Alt", PropertyType.STRING, string));
        }
        if (string2 != null) {
            object2.add(new Property("Longdesc", PropertyType.STRING, string2));
        }
        if (string3 != null) {
            object2.add(new Property("Src", PropertyType.STRING, string3));
        }
        if (n >= 0) {
            object2.add(new Property("Height", PropertyType.INTEGER, new Integer(n)));
        }
        if (n2 >= 0) {
            object2.add(new Property("Width", PropertyType.INTEGER, new Integer(n2)));
        }
        if (!object2.isEmpty()) {
            htmlMetadata.addImage(new Property("Image", PropertyType.PROPERTY, PropertyArity.LIST, object2));
        }
    }

    private void processFrame(HtmlMetadata htmlMetadata) {
        Object object2;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = -1;
        int n2 = -1;
        for (Object object2 : this._attributes) {
            String string5 = ((JHAttribute)object2).getName();
            String string6 = ((JHAttribute)object2).getValue();
            if ("name".equals(string5)) {
                string = string6;
                continue;
            }
            if ("title".equals(string5)) {
                string2 = string6;
                continue;
            }
            if ("src".equals(string5)) {
                string3 = string6;
                continue;
            }
            if (!"longdesc".equals(string5)) continue;
            string4 = string6;
        }
        object2 = new ArrayList(4);
        if (string != null) {
            object2.add(new Property("Name", PropertyType.STRING, string));
        }
        if (string2 != null) {
            object2.add(new Property("Title", PropertyType.STRING, string2));
        }
        if (string4 != null) {
            object2.add(new Property("Longdesc", PropertyType.STRING, string4));
        }
        if (string3 != null) {
            object2.add(new Property("src", PropertyType.STRING, string3));
        }
        if (!object2.isEmpty()) {
            htmlMetadata.addFrame(new Property("Frame", PropertyType.PROPERTY, PropertyArity.LIST, object2));
        }
    }

    private void processScript(HtmlMetadata htmlMetadata) {
        for (JHAttribute jHAttribute : this._attributes) {
            String string = jHAttribute.getName();
            String string2 = jHAttribute.getValue();
            if (!"type".equals(string) || string2.length() <= 0) continue;
            htmlMetadata.addScript(string2);
        }
    }
}

