/*
 * * Copyright (c) 2016, Intel Corporation
 *
 * All rights reserved.
 * Redistribution.  Redistribution and use in binary form, without modification, are
 * permitted provided that the following conditions are met:
 * Redistributions must reproduce the above copyright notice and the following
 * disclaimer in the documentation and/or other materials provided with the
 * distribution.
 * Neither the name of Intel Corporation nor the names of its suppliers may be used
 * to endorse or promote products derived from this software without specific prior
 * written permission.
 * No reverse engineering, decompilation, or disassembly of this software is permitted.
 * Limited patent license.  Intel Corporation grants a world-wide, royalty-free,
 * nonexclusive license under patents it now or hereafter owns or controls to make, have made,
 * use, import, offer to sell and sell (.Utilize.) this software, but solely to the extent that any
 * such patent is necessary to Utilize the software alone.  The patent license shall not apply
 * to any combinations which include this software.  No hardware per se is licensed here under.

 * DISCLAIMER.  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT
 * HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>

const unsigned int vp9_fullspiral_ime_search_path_delta[14] = {
    0x0101F00F, 0x0F0F1010, 0xF0F0F00F, 0x01010101, 0x10101010, 0x0F0F0F0F, 0xF0F0F00F, 0x0101F0F0, 0x01010101, 0x10101010, 0x0F0F1010, 0x0F0F0F0F, 0xF0F0F00F, 0xF0F0F0F0
};

const unsigned int vp9_diamond_ime_search_path_delta[14] = {
    0x120FF10F, 0x1E22E20D, 0x20E2FF10, 0x2EDD06FC, 0x11D33FF1, 0xEB1FF33D, 0x4EF1F1F1, 0xF1F21211, 0x0DFFFFE0, 0x11201F1F, 0x1105F1CF, 0x00000000, 0x00000000, 0x00000000
};

const unsigned int vp9_brc_const_data_i_g9[4448] = {
    0x0032000A, 0x00960064, 0x67614B28, 0xFCFAA07D, 0x040200FE, 0x03010106, 0x05280102, 0x04010305,
    0x78503C1E, 0x04FFC88C, 0x78503C1E, 0x28FFC88C, 0x02B47850, 0x120E0A06, 0x0A060402, 0x0200000E,
    0x00000804, 0xFE040200, 0x02000000, 0x00FEFCFA, 0xFCF8F600, 0xF4F200FE, 0xEEFEFCF8, 0xFEFCF6F2,
    0x100A0402, 0x08040214, 0x0200100C, 0x000C0804, 0x04020000, 0x000000FE, 0xFEFEFC02, 0xFCFA0000,
    0xF600FEFE, 0x00FEFCFA, 0xFCF8F4F2, 0x000000FE, 0x0C080000, 0x00001410, 0x06000000, 0xFE120E0A,
    0x00000000, 0x0E0C0806, 0x0000FEFC, 0x06040200, 0xFEFCFA0A, 0x02000000, 0xFCF80A06, 0x000000FE,
    0xF60A0602, 0x00FEFCFA, 0x0A060200, 0xFEFCF8F4, 0x06020000, 0xFCF8F40A, 0x020000FE, 0x00000A06,
    0x06000000, 0x00120E0A, 0x00000000, 0x100C0A06, 0x000000FE, 0x0E0A0600, 0x00FEFC10, 0x08040000,
    0xFCFA0C0A, 0x000000FE, 0xF80A0802, 0x0000FEFC, 0x0A080200, 0xFEFEFCF8, 0x08000000, 0xFCFAF80A,
    0x000000FE, 0xF8F60A02, 0x0000FEFC, 0x00080200, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x02061200, 0x00000036, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x28190702, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00010002,
    0x050D2501, 0x0000006D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x38290E03, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00020004,
    0x050D2502, 0x0000006D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x38290E03, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00020004,
    0x050D2503, 0x0000006D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x38290E03, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00020004,
    0x06102E04, 0x00000088, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x3A2B1904, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00020005,
    0x06102E05, 0x00000088, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x3A2B1904, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00020005,
    0x07133706, 0x000000A3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x3C2E1B05, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00030006,
    0x07133707, 0x000000A3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x3C2E1B05, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00030006,
    0x07133708, 0x000000A3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x3C2E1B05, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00030006,
    0x08164009, 0x000000BE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x3E381D05, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00030007,
    0x0816400A, 0x000000BE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x3E381D05, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00030007,
    0x0A1A4A0B, 0x000000DA, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x48391E06, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00040008,
    0x0A1A4A0C, 0x000000DA, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x48391E06, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00040008,
    0x0B1D530D, 0x000000F5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x493A2807, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00040009,
    0x0B1D530E, 0x000000F5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x493A2807, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00040009,
    0x0B1D530F, 0x000000F5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x493A2807, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00040009,
    0x0C205C10, 0x00000110, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x4A3B2908, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0005000A,
    0x0C205C11, 0x00000110, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x4A3B2908, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0005000A,
    0x0D236512, 0x0000012B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x4B3C2A09, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0005000B,
    0x0D236513, 0x0000012B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x4B3C2A09, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0005000B,
    0x0E266E14, 0x00000146, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x4C3E2B09, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0006000C,
    0x0E266E15, 0x00000146, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x4C3E2B09, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0006000C,
    0x102A7816, 0x00000162, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x4D3F2C0A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0006000D,
    0x102A7817, 0x00000162, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x4D3F2C0A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0006000D,
    0x102A7818, 0x00000162, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x4D3F2C0A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0006000D,
    0x112D8119, 0x0000017D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x4E482C0B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0007000E,
    0x112D811A, 0x0000017D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x4E482C0B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0007000E,
    0x12308A1B, 0x00000198, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x4F482D0C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0007000F,
    0x12308A1C, 0x00000198, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x4F482D0C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0007000F,
    0x1333931D, 0x000001B3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x58492E0D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00080010,
    0x1333931E, 0x000001B3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x58492E0D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00080010,
    0x1333931F, 0x000001B3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x58492E0D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00080010,
    0x14369C20, 0x000001CE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x594A2F0D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00080011,
    0x14369C21, 0x000001CE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x594A2F0D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00080011,
    0x163AA622, 0x000001EA, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x594A380E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00090012,
    0x163AA623, 0x000001EA, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x594A380E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00090012,
    0x173DAF24, 0x00000205, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5A4B380F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00090013,
    0x173DAF25, 0x00000205, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5A4B380F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00090013,
    0x173DAF26, 0x00000205, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5A4B380F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00090013,
    0x1840B827, 0x00000220, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5A4B3918, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000A0014,
    0x1840B828, 0x00000220, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5A4B3918, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000A0014,
    0x1943C129, 0x0000023B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5B4C3918, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000A0015,
    0x1943C12A, 0x0000023B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5B4C3918, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000A0015,
    0x1943C12B, 0x0000023B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5B4C3918, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000A0015,
    0x1A46CA2C, 0x00000256, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5B4C3A19, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000B0016,
    0x1A46CA2D, 0x00000256, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5B4C3A19, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000B0016,
    0x1B49D32E, 0x00000271, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5C4D3A19, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000B0017,
    0x1B49D32F, 0x00000271, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5C4D3A19, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000B0017,
    0x1D4DDD30, 0x0000028D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5C4E3B1A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000C0018,
    0x1D4DDD31, 0x0000028D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5C4E3B1A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000C0018,
    0x1D4DDD32, 0x0000028D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5C4E3B1A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000C0018,
    0x1E50E633, 0x000002A8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5D4E3B1A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000C0019,
    0x1E50E634, 0x000002A8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5D4E3B1A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000C0019,
    0x1F53EF35, 0x000002C3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5D4F3B1A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000D001A,
    0x1F53EF36, 0x000002C3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5D4F3B1A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000D001A,
    0x1F53EF37, 0x000002C3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5D4F3B1A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000D001A,
    0x2056F838, 0x000002DE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5E4F3C1B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000D001B,
    0x2056F839, 0x000002DE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5E4F3C1B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000D001B,
    0x2159FF3A, 0x000002F9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5E583C1B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000E001C,
    0x2159FF3B, 0x000002F9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5E583C1B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000E001C,
    0x2159FF3C, 0x000002F9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5E583C1B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000E001C,
    0x235DFF3D, 0x00000315, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5F583D1C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000E001D,
    0x235DFF3E, 0x00000315, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5F583D1C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000E001D,
    0x2460FF3F, 0x00000330, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5F583D1C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000F001E,
    0x2460FF40, 0x00000330, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x5F583D1C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000F001E,
    0x2563FF41, 0x0000034B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x68593E1C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000F001F,
    0x2563FF42, 0x0000034B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x68593E1C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000F001F,
    0x2563FF43, 0x0000034B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x68593E1C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000F001F,
    0x2666FF44, 0x00000366, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x68593E1D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00100020,
    0x2666FF45, 0x00000366, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x68593E1D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00100020,
    0x2769FF46, 0x00000381, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x68593F1D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00100021,
    0x2769FF47, 0x00000381, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x68593F1D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00100021,
    0x2769FF48, 0x00000381, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x68593F1D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00100021,
    0x296DFF49, 0x0000039D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x695A3F1E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00110022,
    0x296DFF4A, 0x0000039D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x695A3F1E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00110022,
    0x2A70FF4B, 0x000003B8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x695A3F1E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00110023,
    0x2A70FF4C, 0x000003B8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x695A3F1E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00110023,
    0x2A70FF4D, 0x000003B8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x695A3F1E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00110023,
    0x2B73FF4E, 0x000003D3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x695A481E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00120024,
    0x2B73FF4F, 0x000003D3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x695A481E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00120024,
    0x2C76FF50, 0x000003EE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x695A481F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00120025,
    0x2C76FF51, 0x000003EE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x695A481F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00120025,
    0x2C76FF52, 0x000003EE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x695A481F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00120025,
    0x2D79FF53, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6A5B481F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00130026,
    0x2D79FF54, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6A5B481F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00130026,
    0x2F7DFF55, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6A5B491F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00130027,
    0x2F7DFF56, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6A5B491F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00130027,
    0x2F7DFF57, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6A5B491F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00130027,
    0x3080FF58, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6A5B4928, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00140028,
    0x3080FF59, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6A5B4928, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00140028,
    0x3080FF5A, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6A5B4928, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00140028,
    0x3183FF5B, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6B5C4928, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00140029,
    0x3183FF5C, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6B5C4928, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00140029,
    0x3286FF5D, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6B5C4928, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0015002A,
    0x3286FF5E, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6B5C4928, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0015002A,
    0x3286FF5F, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6B5C4928, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0015002A,
    0x3389FF60, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6B5C4929, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0015002B,
    0x358DFF61, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6B5C4A29, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0016002C,
    0x3690FF62, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6C5D4A29, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0016002D,
    0x3793FF63, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6C5D4A29, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0017002E,
    0x3793FF64, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6C5D4A29, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0017002E,
    0x3896FF65, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6C5D4A29, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0017002F,
    0x3999FF66, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6C5D4B2A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00180030,
    0x3B9DFF67, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6D5E4B2A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00180031,
    0x3B9DFF68, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6D5E4B2A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00180031,
    0x3CA0FF69, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6D5E4B2A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00190032,
    0x3DA3FF6A, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6D5E4B2A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00190033,
    0x3EA6FF6B, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6D5F4B2A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001A0034,
    0x3EA6FF6C, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6D5F4B2A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001A0034,
    0x3FA9FF6D, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6E5F4C2A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001A0035,
    0x41ADFF6E, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6E5F4C2B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001B0036,
    0x42B0FF6F, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6E5F4C2B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001B0037,
    0x42B0FF70, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6E5F4C2B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001B0037,
    0x43B3FF71, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6E684C2B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C0038,
    0x44B6FF72, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6F684D2B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C0039,
    0x45B9FF73, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6F684D2B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001D003A,
    0x45B9FF74, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6F684D2B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001D003A,
    0x47BDFF75, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6F684D2C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001D003B,
    0x48C0FF76, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6F684D2C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001E003C,
    0x48C0FF77, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x6F684D2C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001E003C,
    0x49C3FF78, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x78694D2C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001E003D,
    0x4AC6FF79, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x78694E2C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001F003E,
    0x4BC9FF7A, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x78694E2C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001F003F,
    0x4DCDFF7B, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x78694E2D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00200040,
    0x4ED0FF7C, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x78694E2D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00200041,
    0x50D6FF7D, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x79694F2D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00210043,
    0x51D9FF7E, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x796A4F2D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00220044,
    0x52DCFF7F, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x796A4F2E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00220045,
    0x54E0FF80, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x796A4F2E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00230046,
    0x55E3FF81, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x796A582E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00230047,
    0x56E6FF82, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x796A582E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00240048,
    0x57E9FF83, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x796A582E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00240049,
    0x58ECFF84, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x796A582F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0025004A,
    0x5AF0FF85, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7A6B582F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0025004B,
    0x5BF3FF86, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7A6B582F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0026004C,
    0x5CF6FF87, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7A6B582F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0026004D,
    0x5DF9FF88, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7A6B592F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0027004E,
    0x5EFCFF89, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7A6B5938, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0027004F,
    0x60FFFF8A, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7A6B5938, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00280050,
    0x62FFFF8B, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7B6C5938, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00290052,
    0x63FFFF8C, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7B6C5938, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00290053,
    0x64FFFF8D, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7B6C5938, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002A0054,
    0x67FFFF8E, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7B6C5938, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002B0056,
    0x68FFFF8F, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7B6C5A39, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002B0057,
    0x69FFFF90, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7B6C5A39, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002C0058,
    0x6CFFFF91, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7C6D5A39, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002D005A,
    0x6DFFFF92, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7C6D5A39, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002D005B,
    0x6EFFFF93, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7C6D5A39, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002E005C,
    0x6FFFFF94, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7C6D5A39, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002E005D,
    0x72FFFF95, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7C6D5A39, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002F005F,
    0x73FFFF96, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7C6D5B39, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00300060,
    0x74FFFF97, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7C6E5B3A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00300061,
    0x76FFFF98, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7D6E5B3A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00310063,
    0x79FFFF99, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7D6E5B3A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00320065,
    0x7AFFFF9A, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7D6E5B3A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00330066,
    0x7CFFFF9B, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7D6F5B3A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00340068,
    0x7EFFFF9C, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7D6F5C3A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00340069,
    0x80FFFF9D, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7E6F5C3B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0035006B,
    0x81FFFF9E, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7E6F5C3B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0036006C,
    0x83FFFF9F, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7E6F5C3B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0037006E,
    0x85FFFFA0, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7E785C3B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0037006F,
    0x87FFFFA1, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7E785C3B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00380071,
    0x89FFFFA2, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7F785D3B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00390073,
    0x8BFFFFA3, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7F785D3B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x003A0074,
    0x8DFFFFA4, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7F785D3C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x003B0076,
    0x8FFFFFA5, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x7F785D3C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x003C0078,
    0x91FFFFA6, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x88785D3C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x003C0079,
    0x93FFFFA7, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x88795E3C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x003D007B,
    0x95FFFFA8, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x88795E3C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x003E007D,
    0x97FFFFA9, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x88795E3C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x003F007E,
    0x99FFFFAA, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x88795E3D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00400080,
    0x9BFFFFAB, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x88795E3D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00410082,
    0x9EFFFFAC, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x88795F3D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00420084,
    0xA0FFFFAD, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x89795F3D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00430086,
    0xA3FFFFAE, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x897A5F3D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00440088,
    0xA5FFFFAF, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x897A5F3E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0045008A,
    0xA7FFFFB0, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x897A5F3E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0046008C,
    0xAAFFFFB1, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x897A683E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0047008E,
    0xACFFFFB2, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x897A683E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00480090,
    0xAFFFFFB3, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x897A683E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00490092,
    0xB1FFFFB4, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x897A683F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x004A0094,
    0xB3FFFFB5, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8A7B683F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x004B0096,
    0xB6FFFFB6, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8A7B683F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x004C0098,
    0xB8FFFFB7, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8A7B683F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x004D009A,
    0xBAFFFFB8, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8A7B693F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x004E009C,
    0xBDFFFFB9, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8A7B693F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x004F009E,
    0xC0FFFFBA, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8A7B6948, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005000A1,
    0xC3FFFFBB, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8A7B6948, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005100A3,
    0xC5FFFFBC, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8B7C6948, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005200A5,
    0xC8FFFFBD, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8B7C6948, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005300A7,
    0xCBFFFFBE, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8B7C6948, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005500AA,
    0xCEFFFFBF, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8B7C6948, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005600AC,
    0xD0FFFFC0, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8B7C6A49, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005700AE,
    0xD4FFFFC1, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8B7C6A49, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005800B1,
    0xD6FFFFC2, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8B7D6A49, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005900B3,
    0xDAFFFFC3, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8C7D6A49, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005B00B6,
    0xDCFFFFC4, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8C7D6A49, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005C00B8,
    0xE0FFFFC5, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8C7D6A49, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005D00BB,
    0xE2FFFFC6, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8C7D6A49, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005E00BD,
    0xE6FFFFC7, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8C7D6B49, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006000C0,
    0xE8FFFFC8, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8C7E6B4A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006100C2,
    0xEBFFFFC9, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8D7E6B4A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006200C5,
    0xEFFFFFCA, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8D7E6B4A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006400C8,
    0xF3FFFFCB, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8D7E6B4A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006500CB,
    0xF5FFFFCC, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8D7E6B4A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006600CD,
    0xF9FFFFCD, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8D7F6B4A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006800D0,
    0xFCFFFFCE, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8E7F6C4A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006900D3,
    0xFFFFFFCF, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8E7F6C4A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006B00D6,
    0xFFFFFFD0, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8E7F6C4B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006C00D9,
    0xFFFFFFD1, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8E7F6C4B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006E00DC,
    0xFFFFFFD2, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8E886C4B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006F00DF,
    0xFFFFFFD3, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F886C4B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x007100E3,
    0xFFFFFFD4, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F886D4B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x007300E6,
    0xFFFFFFD5, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F886D4B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x007400E9,
    0xFFFFFFD6, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F886D4C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x007600ED,
    0xFFFFFFD7, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F886D4C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x007800F1,
    0xFFFFFFD8, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F896D4C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x007A00F4,
    0xFFFFFFD9, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F896E4C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x007C00F8,
    0xFFFFFFDA, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F896E4C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x007E00FC,
    0xFFFFFFDB, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F896E4D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00800100,
    0xFFFFFFDC, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F896E4D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00820105,
    0xFFFFFFDD, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F896F4D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00840109,
    0xFFFFFFDE, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F896F4D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0086010D,
    0xFFFFFFDF, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8A6F4D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00890112,
    0xFFFFFFE0, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8A6F4E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x008B0117,
    0xFFFFFFE1, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8A784E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x008E011C,
    0xFFFFFFE2, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8A784E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00900121,
    0xFFFFFFE3, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8A784E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00930127,
    0xFFFFFFE4, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8B784F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0096012D,
    0xFFFFFFE5, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8B784F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00990133,
    0xFFFFFFE6, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8B794F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x009C0139,
    0xFFFFFFE7, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8B7958, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00A00140,
    0xFFFFFFE8, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8B7958, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00A30147,
    0xFFFFFFE9, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8C7958, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00A7014E,
    0xFFFFFFEA, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8C7958, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00AB0156,
    0xFFFFFFEB, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8C7A59, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00AF015E,
    0xFFFFFFEC, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8D7A59, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00B30166,
    0xFFFFFFED, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8D7A59, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00B80170,
    0xFFFFFFEE, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8D7A59, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00BC0179,
    0xFFFFFFEF, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8E7B59, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00C10183,
    0xFFFFFFF0, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8E7B5A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00C7018E,
    0xFFFFFFF1, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8E7B5A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00CC0199,
    0xFFFFFFF2, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8F7C5A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00D201A5,
    0xFFFFFFF3, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8F7C5B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00D901B2,
    0xFFFFFFF4, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8F7C5B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00E001C0,
    0xFFFFFFF5, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8F7D5B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00E701CE,
    0xFFFFFFF6, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8F7D5C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00EE01DD,
    0xFFFFFFF7, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8F7E5C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00F701EE,
    0xFFFFFFF8, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8F7E5C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FF01FF,
    0xFFFFFFF9, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8F7F5D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01080211,
    0xFFFFFFFA, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8F7F5D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01120225,
    0xFFFFFFFB, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8F885E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x011C0239,
    0xFFFFFFFC, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8F885E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01280250,
    0xFFFFFFFD, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8F885F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01340268,
    0xFFFFFFFE, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8F8968, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01400281,
    0xFFFFFFFF, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x8F8F8968, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x014E029C,
    0x00080004, 0x00090008, 0x000B000A, 0x000C000C, 0x000E000D, 0x0010000F, 0x00120011, 0x00130013,
    0x00150014, 0x00170016, 0x00190018, 0x001A001A, 0x001C001B, 0x001E001D, 0x0020001F, 0x00210020,
    0x00230022, 0x00250024, 0x00260026, 0x00280027, 0x002A0029, 0x002B002B, 0x002D002C, 0x002F002E,
    0x00300030, 0x00320031, 0x00340033, 0x00350035, 0x00370036, 0x00390038, 0x003A0039, 0x003C003B,
    0x003E003D, 0x003F003E, 0x00410040, 0x00420042, 0x00440043, 0x00460045, 0x00470046, 0x00490048,
    0x004A004A, 0x004C004B, 0x004E004D, 0x004F004E, 0x00510050, 0x00520051, 0x00540053, 0x00550055,
    0x00580057, 0x005C005A, 0x005F005D, 0x00620060, 0x00650063, 0x00680066, 0x006B0069, 0x006E006C,
    0x0071006F, 0x00740072, 0x00760075, 0x00790078, 0x007D007B, 0x0081007F, 0x00860083, 0x008A0088,
    0x008E008C, 0x00920090, 0x00960094, 0x009A0098, 0x009E009C, 0x00A400A1, 0x00A900A6, 0x00AE00AC,
    0x00B400B1, 0x00B900B6, 0x00BE00BB, 0x00C300C0, 0x00CA00C7, 0x00D000CD, 0x00D600D3, 0x00DC00D9,
    0x00E200DF, 0x00E900E6, 0x00F000ED, 0x00F700F3, 0x00FD00FA, 0x01050101, 0x010D0109, 0x01140110,
    0x011C0118, 0x01240120, 0x012C0128, 0x01350130, 0x013D0139, 0x01460142, 0x014F014A, 0x01580154,
    0x0162015D, 0x016C0167, 0x01760171, 0x0180017B, 0x018B0185, 0x01960190, 0x01A1019B, 0x01AD01A7,
    0x01B901B3, 0x01C601BF, 0x01D301CD, 0x01E201DB, 0x01F101E9, 0x020101F9, 0x0212020A, 0x0225021B,
    0x0239022F, 0x024E0243, 0x0266025A, 0x02800272, 0x029C028E, 0x02BC02AC, 0x02E002CD, 0x030702F3,
    0x0333031C, 0x0365034B, 0x039D0380, 0x03DC03BB, 0x042203FE, 0x0473044A, 0x04D004A0, 0x05380502,
    0x00080004, 0x000A0009, 0x000C000B, 0x000E000D, 0x0010000F, 0x00120011, 0x00140013, 0x00160015,
    0x00180017, 0x001A0019, 0x001C001B, 0x001E001D, 0x0020001F, 0x00220021, 0x00240023, 0x00260025,
    0x00280027, 0x002A0029, 0x002C002B, 0x002E002D, 0x0030002F, 0x00320031, 0x00340033, 0x00360035,
    0x00380037, 0x003A0039, 0x003C003B, 0x003E003D, 0x0040003F, 0x00420041, 0x00440043, 0x00460045,
    0x00480047, 0x004A0049, 0x004C004B, 0x004E004D, 0x0050004F, 0x00520051, 0x00540053, 0x00560055,
    0x00580057, 0x005A0059, 0x005C005B, 0x005E005D, 0x0060005F, 0x00620061, 0x00640063, 0x00660065,
    0x006A0068, 0x006E006C, 0x00720070, 0x00760074, 0x007A0078, 0x007E007C, 0x00820080, 0x00860084,
    0x008A0088, 0x008E008C, 0x00920090, 0x00960094, 0x009B0098, 0x00A1009E, 0x00A700A4, 0x00AD00AA,
    0x00B300B0, 0x00B900B6, 0x00BF00BC, 0x00C500C2, 0x00CB00C8, 0x00D300CF, 0x00DB00D7, 0x00E300DF,
    0x00EB00E7, 0x00F300EF, 0x00FB00F7, 0x010400FF, 0x010E0109, 0x01180113, 0x0122011D, 0x012C0127,
    0x01370131, 0x0143013D, 0x014F0149, 0x015B0155, 0x01670161, 0x0175016E, 0x0183017C, 0x0191018A,
    0x01A00198, 0x01B001A8, 0x01C001B8, 0x01D101C8, 0x01E301DA, 0x01F501EC, 0x020801FE, 0x021C0212,
    0x02300226, 0x0246023B, 0x025C0251, 0x02730267, 0x028B027F, 0x02A40297, 0x02BE02B1, 0x02D902CB,
    0x02F502E7, 0x03120303, 0x03300321, 0x03500340, 0x03710360, 0x03930382, 0x03B703A5, 0x03DC03C9,
    0x040203EF, 0x042A0416, 0x0454043F, 0x047F0469, 0x04AC0495, 0x04DB04C3, 0x050C04F3, 0x053F0525,
    0x05740559, 0x05AB058F, 0x05E405C7, 0x061F0601, 0x065C063D, 0x069C067C, 0x06DF06BD, 0x07240701
};

const unsigned int vp9_brc_const_data_p_g9[4448] = {
    0x0032000A, 0x00960064, 0x67614B28, 0xFCFAA07D, 0x040200FE, 0x03010106, 0x05280102, 0x04010305,
    0x78503C1E, 0x04FFC88C, 0x78503C1E, 0x28FFC88C, 0x02B47850, 0x120E0A06, 0x0A060402, 0x0200000E,
    0x00000804, 0xFE040200, 0x02000000, 0x00FEFCFA, 0xFCF8F600, 0xF4F200FE, 0xEEFEFCF8, 0xFEFCF6F2,
    0x100A0402, 0x08040214, 0x0200100C, 0x000C0804, 0x04020000, 0x000000FE, 0xFEFEFC02, 0xFCFA0000,
    0xF600FEFE, 0x00FEFCFA, 0xFCF8F4F2, 0x000000FE, 0x0C080000, 0x00001410, 0x06000000, 0xFE120E0A,
    0x00000000, 0x0E0C0806, 0x0000FEFC, 0x06040200, 0xFEFCFA0A, 0x02000000, 0xFCF80A06, 0x000000FE,
    0xF60A0602, 0x00FEFCFA, 0x0A060200, 0xFEFCF8F4, 0x06020000, 0xFCF8F40A, 0x020000FE, 0x00000A06,
    0x06000000, 0x00120E0A, 0x00000000, 0x100C0A06, 0x000000FE, 0x0E0A0600, 0x00FEFC10, 0x08040000,
    0xFCFA0C0A, 0x000000FE, 0xF80A0802, 0x0000FEFC, 0x0A080200, 0xFEFEFCF8, 0x08000000, 0xFCFAF80A,
    0x000000FE, 0xF8F60A02, 0x0000FEFC, 0x00080200, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x040C2400, 0x00000000, 0x00010001, 0x00010000, 0x00010000, 0x00020002, 0x00030002, 0x00040003,
    0x02020100, 0x04030302, 0x39070402, 0x6F6F0103, 0x00010001, 0x00000000, 0x00000004, 0x00010004,
    0x08184801, 0x00000000, 0x00020002, 0x00020001, 0x00020000, 0x00040003, 0x00060005, 0x00080007,
    0x04030200, 0x08070605, 0x490D0903, 0x6F6F0305, 0x00020001, 0x00000000, 0x00000008, 0x00020008,
    0x08184802, 0x00000000, 0x00020002, 0x00020001, 0x00020000, 0x00040003, 0x00060005, 0x00080007,
    0x04030200, 0x08070605, 0x490D0903, 0x6F6F0305, 0x00020001, 0x00000000, 0x00000008, 0x00020008,
    0x091B5103, 0x00000000, 0x00020002, 0x00020001, 0x00020000, 0x00040003, 0x00060005, 0x00080007,
    0x04030200, 0x08070605, 0x4A0F0A04, 0x6F6F0305, 0x00020001, 0x00000000, 0x00000008, 0x00020009,
    0x0A1E5A04, 0x00000000, 0x00020002, 0x00020001, 0x00020000, 0x00040003, 0x00060005, 0x00080007,
    0x04030200, 0x08070605, 0x4B180B04, 0x6F6F0305, 0x00020001, 0x00000000, 0x00000008, 0x0002000A,
    0x0B216305, 0x00000000, 0x00020002, 0x00020001, 0x00020000, 0x00040003, 0x00060005, 0x00080007,
    0x04030200, 0x08070605, 0x4D190C04, 0x6F6F0305, 0x00020001, 0x00000000, 0x00000008, 0x0002000B,
    0x0C246C06, 0x00000000, 0x00020004, 0x00030001, 0x00040000, 0x00060005, 0x00080007, 0x000C000A,
    0x06050400, 0x0C0A0807, 0x4E1A0D05, 0x6F6F0408, 0x00030002, 0x00000000, 0x0000000C, 0x0003000C,
    0x0C246C07, 0x00000000, 0x00020004, 0x00030001, 0x00040000, 0x00060005, 0x00080007, 0x000C000A,
    0x06050400, 0x0C0A0807, 0x4E1A0D05, 0x6F6F0408, 0x00030002, 0x00000000, 0x0000000C, 0x0003000C,
    0x0D277508, 0x00000000, 0x00020004, 0x00030001, 0x00040000, 0x00060005, 0x00080007, 0x000C000A,
    0x06050400, 0x0C0A0807, 0x4F1B0E05, 0x6F6F0408, 0x00030002, 0x00000000, 0x0000000C, 0x0003000D,
    0x0E2A7E09, 0x00000000, 0x00020004, 0x00030001, 0x00040000, 0x00060005, 0x00080007, 0x000C000A,
    0x06050400, 0x0C0A0807, 0x581C0F05, 0x6F6F0408, 0x00030002, 0x00000000, 0x0000000C, 0x0003000E,
    0x0F2D870A, 0x00000000, 0x00020004, 0x00030001, 0x00040000, 0x00060005, 0x00080007, 0x000C000A,
    0x06050400, 0x0C0A0807, 0x591D1806, 0x6F6F0408, 0x00030002, 0x00000000, 0x0000000C, 0x0003000F,
    0x1030900B, 0x00000000, 0x00030005, 0x00040002, 0x00050000, 0x00080006, 0x000B000A, 0x0010000D,
    0x08060500, 0x180D0B0A, 0x591D1906, 0x6F6F050B, 0x00040002, 0x00000000, 0x00000010, 0x00040010,
    0x1133990C, 0x00000000, 0x00030005, 0x00040002, 0x00050000, 0x00080006, 0x000B000A, 0x0010000D,
    0x08060500, 0x180D0B0A, 0x5A1E1A07, 0x6F6F050B, 0x00040002, 0x00000000, 0x00000010, 0x00040011,
    0x1236A20D, 0x00000000, 0x00030005, 0x00040002, 0x00050000, 0x00080006, 0x000B000A, 0x0010000D,
    0x08060500, 0x180D0B0A, 0x5A1F1A07, 0x6F6F050B, 0x00040002, 0x00000000, 0x00000010, 0x00040012,
    0x1339AB0E, 0x00000000, 0x00030005, 0x00040002, 0x00050000, 0x00080006, 0x000B000A, 0x0010000D,
    0x08060500, 0x180D0B0A, 0x5B281B07, 0x6F6F050B, 0x00040002, 0x00000000, 0x00000010, 0x00040013,
    0x1339AB0F, 0x00000000, 0x00030005, 0x00040002, 0x00050000, 0x00080006, 0x000B000A, 0x0010000D,
    0x08060500, 0x180D0B0A, 0x5B281B07, 0x6F6F050B, 0x00040002, 0x00000000, 0x00000010, 0x00040013,
    0x143CB410, 0x00000000, 0x00040006, 0x00050002, 0x00060000, 0x000A0008, 0x000E000C, 0x00140011,
    0x0A080600, 0x1A190E0C, 0x5B281B08, 0x6F6F070E, 0x00050003, 0x00000000, 0x00000014, 0x00050014,
    0x153FBD11, 0x00000000, 0x00040006, 0x00050002, 0x00060000, 0x000A0008, 0x000E000C, 0x00140011,
    0x0A080600, 0x1A190E0C, 0x5C291C08, 0x6F6F070E, 0x00050003, 0x00000000, 0x00000014, 0x00050015,
    0x1642C612, 0x00000000, 0x00040006, 0x00050002, 0x00060000, 0x000A0008, 0x000E000C, 0x00140011,
    0x0A080600, 0x1A190E0C, 0x5D291C09, 0x6F6F070E, 0x00050003, 0x00000000, 0x00000014, 0x00050016,
    0x1745CF13, 0x00000000, 0x00040006, 0x00050002, 0x00060000, 0x000A0008, 0x000E000C, 0x00140011,
    0x0A080600, 0x1A190E0C, 0x5D2A1D09, 0x6F6F070E, 0x00050003, 0x00000000, 0x00000014, 0x00050017,
    0x1848D814, 0x00000000, 0x00050007, 0x00060002, 0x00070000, 0x000C0009, 0x0011000F, 0x00170014,
    0x0C090700, 0x1C1A190F, 0x5E2A1D09, 0x6F6F0818, 0x00060003, 0x00000000, 0x00000017, 0x00060018,
    0x194BE115, 0x00000000, 0x00050007, 0x00060002, 0x00070000, 0x000C0009, 0x0011000F, 0x00170014,
    0x0C090700, 0x1C1A190F, 0x5E2A1E0A, 0x6F6F0818, 0x00060003, 0x00000000, 0x00000017, 0x00060019,
    0x1A4EEA16, 0x00000000, 0x00050007, 0x00060002, 0x00070000, 0x000C0009, 0x0011000F, 0x00170014,
    0x0C090700, 0x1C1A190F, 0x5F2B1E0A, 0x6F6F0818, 0x00060003, 0x00000000, 0x00000017, 0x0006001A,
    0x1A4EEA17, 0x00000000, 0x00050007, 0x00060002, 0x00070000, 0x000C0009, 0x0011000F, 0x00170014,
    0x0C090700, 0x1C1A190F, 0x5F2B1E0A, 0x6F6F0818, 0x00060003, 0x00000000, 0x00000017, 0x0006001A,
    0x1B51F318, 0x00000000, 0x00050007, 0x00060002, 0x00070000, 0x000C0009, 0x0011000F, 0x00170014,
    0x0C090700, 0x1C1A190F, 0x5F2B1F0B, 0x6F6F0818, 0x00060003, 0x00000000, 0x00000017, 0x0006001B,
    0x1C54FC19, 0x00000000, 0x00050008, 0x00070003, 0x00080000, 0x000E000B, 0x00140011, 0x001B0017,
    0x0E0B0800, 0x1E1C1A19, 0x682C280B, 0x6F6F0A1A, 0x00070004, 0x00000000, 0x0000001B, 0x0007001C,
    0x1D57FF1A, 0x00000000, 0x00050008, 0x00070003, 0x00080000, 0x000E000B, 0x00140011, 0x001B0017,
    0x0E0B0800, 0x1E1C1A19, 0x682C280B, 0x6F6F0A1A, 0x00070004, 0x00000000, 0x0000001B, 0x0007001D,
    0x1E5AFF1B, 0x00000000, 0x00050008, 0x00070003, 0x00080000, 0x000E000B, 0x00140011, 0x001B0017,
    0x0E0B0800, 0x1E1C1A19, 0x692C280C, 0x6F6F0A1A, 0x00070004, 0x00000000, 0x0000001B, 0x0007001E,
    0x1F5DFF1C, 0x00000000, 0x00050008, 0x00070003, 0x00080000, 0x000E000B, 0x00140011, 0x001B0017,
    0x0E0B0800, 0x1E1C1A19, 0x692D290C, 0x6F6F0A1A, 0x00070004, 0x00000000, 0x0000001B, 0x0007001F,
    0x2060FF1D, 0x00000000, 0x00060009, 0x00080003, 0x00090000, 0x0010000D, 0x00170013, 0x001F001B,
    0x180D0900, 0x281E1C1A, 0x692D290D, 0x6F6F0B1B, 0x00080004, 0x00000000, 0x0000001F, 0x00080020,
    0x2060FF1E, 0x00000000, 0x00060009, 0x00080003, 0x00090000, 0x0010000D, 0x00170013, 0x001F001B,
    0x180D0900, 0x281E1C1A, 0x692D290D, 0x6F6F0B1B, 0x00080004, 0x00000000, 0x0000001F, 0x00080020,
    0x2163FF1F, 0x00000000, 0x00060009, 0x00080003, 0x00090000, 0x0010000D, 0x00170013, 0x001F001B,
    0x180D0900, 0x281E1C1A, 0x692E290D, 0x6F6F0B1B, 0x00080004, 0x00000000, 0x0000001F, 0x00080021,
    0x2266FF20, 0x00000000, 0x00060009, 0x00080003, 0x00090000, 0x0010000D, 0x00170013, 0x001F001B,
    0x180D0900, 0x281E1C1A, 0x6A2E290D, 0x6F6F0B1B, 0x00080004, 0x00000000, 0x0000001F, 0x00080022,
    0x2369FF21, 0x00000000, 0x00060009, 0x00080003, 0x00090000, 0x0010000D, 0x00170013, 0x001F001B,
    0x180D0900, 0x281E1C1A, 0x6A2E2A0E, 0x6F6F0B1B, 0x00080004, 0x00000000, 0x0000001F, 0x00080023,
    0x246CFF22, 0x00000000, 0x0007000B, 0x00090004, 0x000B0000, 0x0012000E, 0x00190016, 0x0023001E,
    0x190E0B00, 0x291F1D1B, 0x6A2F2A0E, 0x6F6F0C1D, 0x00090005, 0x00000000, 0x00000023, 0x00090024,
    0x256FFF23, 0x00000000, 0x0007000B, 0x00090004, 0x000B0000, 0x0012000E, 0x00190016, 0x0023001E,
    0x190E0B00, 0x291F1D1B, 0x6B2F2A0E, 0x6F6F0C1D, 0x00090005, 0x00000000, 0x00000023, 0x00090025,
    0x2672FF24, 0x00000000, 0x0007000B, 0x00090004, 0x000B0000, 0x0012000E, 0x00190016, 0x0023001E,
    0x190E0B00, 0x291F1D1B, 0x6B382B0F, 0x6F6F0C1D, 0x00090005, 0x00000000, 0x00000023, 0x00090026,
    0x2672FF25, 0x00000000, 0x0007000B, 0x00090004, 0x000B0000, 0x0012000E, 0x00190016, 0x0023001E,
    0x190E0B00, 0x291F1D1B, 0x6B382B0F, 0x6F6F0C1D, 0x00090005, 0x00000000, 0x00000023, 0x00090026,
    0x2775FF26, 0x00000000, 0x0007000B, 0x00090004, 0x000B0000, 0x0012000E, 0x00190016, 0x0023001E,
    0x190E0B00, 0x291F1D1B, 0x6B382B0F, 0x6F6F0C1D, 0x00090005, 0x00000000, 0x00000023, 0x00090027,
    0x2878FF27, 0x00000000, 0x0008000C, 0x000A0004, 0x000C0000, 0x00140010, 0x001C0018, 0x00270021,
    0x1A180C00, 0x2A281E1C, 0x6B382B18, 0x6F6F0E1E, 0x000A0005, 0x00000000, 0x00000027, 0x000A0028,
    0x297BFF28, 0x00000000, 0x0008000C, 0x000A0004, 0x000C0000, 0x00140010, 0x001C0018, 0x00270021,
    0x1A180C00, 0x2A281E1C, 0x6C382B18, 0x6F6F0E1E, 0x000A0005, 0x00000000, 0x00000027, 0x000A0029,
    0x2A7EFF29, 0x00000000, 0x0008000C, 0x000A0004, 0x000C0000, 0x00140010, 0x001C0018, 0x00270021,
    0x1A180C00, 0x2A281E1C, 0x6C392C18, 0x6F6F0E1E, 0x000A0005, 0x00000000, 0x00000027, 0x000A002A,
    0x2B81FF2A, 0x00000000, 0x0008000C, 0x000A0004, 0x000C0000, 0x00140010, 0x001C0018, 0x00270021,
    0x1A180C00, 0x2A281E1C, 0x6C392C19, 0x6F6F0E1E, 0x000A0005, 0x00000000, 0x00000027, 0x000A002B,
    0x2B81FF2B, 0x00000000, 0x0008000C, 0x000A0004, 0x000C0000, 0x00140010, 0x001C0018, 0x00270021,
    0x1A180C00, 0x2A281E1C, 0x6C392C19, 0x6F6F0E1E, 0x000A0005, 0x00000000, 0x00000027, 0x000A002B,
    0x2C84FF2C, 0x00000000, 0x0009000D, 0x000B0004, 0x000D0000, 0x00160011, 0x001F001B, 0x002B0025,
    0x1B190D00, 0x2B29281E, 0x6D392C19, 0x6F6F0F1F, 0x000B0006, 0x00000000, 0x0000002B, 0x000B002C,
    0x2D87FF2D, 0x00000000, 0x0009000D, 0x000B0004, 0x000D0000, 0x00160011, 0x001F001B, 0x002B0025,
    0x1B190D00, 0x2B29281E, 0x6D392C19, 0x6F6F0F1F, 0x000B0006, 0x00000000, 0x0000002B, 0x000B002D,
    0x2E8AFF2E, 0x00000000, 0x0009000D, 0x000B0004, 0x000D0000, 0x00160011, 0x001F001B, 0x002B0025,
    0x1B190D00, 0x2B29281E, 0x6D392D19, 0x6F6F0F1F, 0x000B0006, 0x00000000, 0x0000002B, 0x000B002E,
    0x2F8DFF2F, 0x00000000, 0x0009000D, 0x000B0004, 0x000D0000, 0x00160011, 0x001F001B, 0x002B0025,
    0x1B190D00, 0x2B29281E, 0x6D3A2D19, 0x6F6F0F1F, 0x000B0006, 0x00000000, 0x0000002B, 0x000B002F,
    0x3090FF30, 0x00000000, 0x0009000E, 0x000C0005, 0x000E0000, 0x00180013, 0x0022001D, 0x002F0028,
    0x1C1A0E00, 0x2C2A291F, 0x6E3A2D1A, 0x6F6F1828, 0x000C0007, 0x00000000, 0x0000002F, 0x000C0030,
    0x3090FF31, 0x00000000, 0x0009000E, 0x000C0005, 0x000E0000, 0x00180013, 0x0022001D, 0x002F0028,
    0x1C1A0E00, 0x2C2A291F, 0x6E3A2D1A, 0x6F6F1828, 0x000C0007, 0x00000000, 0x0000002F, 0x000C0030,
    0x3193FF32, 0x00000000, 0x0009000E, 0x000C0005, 0x000E0000, 0x00180013, 0x0022001D, 0x002F0028,
    0x1C1A0E00, 0x2C2A291F, 0x6E3A2E1A, 0x6F6F1828, 0x000C0007, 0x00000000, 0x0000002F, 0x000C0031,
    0x3296FF33, 0x00000000, 0x0009000E, 0x000C0005, 0x000E0000, 0x00180013, 0x0022001D, 0x002F0028,
    0x1C1A0E00, 0x2C2A291F, 0x6E3A2E1A, 0x6F6F1828, 0x000C0007, 0x00000000, 0x0000002F, 0x000C0032,
    0x3399FF34, 0x00000000, 0x0009000E, 0x000C0005, 0x000E0000, 0x00180013, 0x0022001D, 0x002F0028,
    0x1C1A0E00, 0x2C2A291F, 0x6F3B2E1A, 0x6F6F1828, 0x000C0007, 0x00000000, 0x0000002F, 0x000C0033,
    0x349CFF35, 0x00000000, 0x000A000F, 0x000D0005, 0x000F0000, 0x001A0014, 0x0025001F, 0x0033002B,
    0x1D1A0F00, 0x2D2B2928, 0x6F3B2E1A, 0x6F6F1929, 0x000D0007, 0x00000000, 0x00000033, 0x000D0034,
    0x359FFF36, 0x00000000, 0x000A000F, 0x000D0005, 0x000F0000, 0x001A0014, 0x0025001F, 0x0033002B,
    0x1D1A0F00, 0x2D2B2928, 0x6F3B2F1B, 0x6F6F1929, 0x000D0007, 0x00000000, 0x00000033, 0x000D0035,
    0x359FFF37, 0x00000000, 0x000A000F, 0x000D0005, 0x000F0000, 0x001A0014, 0x0025001F, 0x0033002B,
    0x1D1A0F00, 0x2D2B2928, 0x6F3B2F1B, 0x6F6F1929, 0x000D0007, 0x00000000, 0x00000033, 0x000D0035,
    0x36A2FF38, 0x00000000, 0x000A000F, 0x000D0005, 0x000F0000, 0x001A0014, 0x0025001F, 0x0033002B,
    0x1D1A0F00, 0x2D2B2928, 0x6F3B2F1B, 0x6F6F1929, 0x000D0007, 0x00000000, 0x00000033, 0x000D0036,
    0x37A5FF39, 0x00000000, 0x000A000F, 0x000D0005, 0x000F0000, 0x001A0014, 0x0025001F, 0x0033002B,
    0x1D1A0F00, 0x2D2B2928, 0x783B2F1B, 0x6F6F1929, 0x000D0007, 0x00000000, 0x00000033, 0x000D0037,
    0x38A8FF3A, 0x00000000, 0x000B0010, 0x000E0005, 0x00100000, 0x001C0016, 0x00270022, 0x0037002E,
    0x1E1B1800, 0x2E2C2A29, 0x783C2F1B, 0x6F6F1A2A, 0x000E0008, 0x00000000, 0x00000037, 0x000E0038,
    0x39ABFF3B, 0x00000000, 0x000B0010, 0x000E0005, 0x00100000, 0x001C0016, 0x00270022, 0x0037002E,
    0x1E1B1800, 0x2E2C2A29, 0x783C381B, 0x6F6F1A2A, 0x000E0008, 0x00000000, 0x00000037, 0x000E0039,
    0x39ABFF3C, 0x00000000, 0x000B0010, 0x000E0005, 0x00100000, 0x001C0016, 0x00270022, 0x0037002E,
    0x1E1B1800, 0x2E2C2A29, 0x783C381B, 0x6F6F1A2A, 0x000E0008, 0x00000000, 0x00000037, 0x000E0039,
    0x3AAEFF3D, 0x00000000, 0x000B0010, 0x000E0005, 0x00100000, 0x001C0016, 0x00270022, 0x0037002E,
    0x1E1B1800, 0x2E2C2A29, 0x783C381C, 0x6F6F1A2A, 0x000E0008, 0x00000000, 0x00000037, 0x000E003A,
    0x3BB1FF3E, 0x00000000, 0x000B0010, 0x000E0005, 0x00100000, 0x001C0016, 0x00270022, 0x0037002E,
    0x1E1B1800, 0x2E2C2A29, 0x783C381C, 0x6F6F1A2A, 0x000E0008, 0x00000000, 0x00000037, 0x000E003B,
    0x3CB4FF3F, 0x00000000, 0x000C0012, 0x000F0006, 0x00120000, 0x001E0017, 0x002A0024, 0x003B0032,
    0x1F1C1900, 0x2F2D2B29, 0x793C381C, 0x6F6F1B2A, 0x000F0008, 0x00000000, 0x0000003B, 0x000F003C,
    0x3DB7FF40, 0x00000000, 0x000C0012, 0x000F0006, 0x00120000, 0x001E0017, 0x002A0024, 0x003B0032,
    0x1F1C1900, 0x2F2D2B29, 0x793D381C, 0x6F6F1B2A, 0x000F0008, 0x00000000, 0x0000003B, 0x000F003D,
    0x3EBAFF41, 0x00000000, 0x000C0012, 0x000F0006, 0x00120000, 0x001E0017, 0x002A0024, 0x003B0032,
    0x1F1C1900, 0x2F2D2B29, 0x793D391C, 0x6F6F1B2A, 0x000F0008, 0x00000000, 0x0000003B, 0x000F003E,
    0x3EBAFF42, 0x00000000, 0x000C0012, 0x000F0006, 0x00120000, 0x001E0017, 0x002A0024, 0x003B0032,
    0x1F1C1900, 0x2F2D2B29, 0x793D391C, 0x6F6F1B2A, 0x000F0008, 0x00000000, 0x0000003B, 0x000F003E,
    0x3FBDFF43, 0x00000000, 0x000C0012, 0x000F0006, 0x00120000, 0x001E0017, 0x002A0024, 0x003B0032,
    0x1F1C1900, 0x2F2D2B29, 0x793D391D, 0x6F6F1B2A, 0x000F0008, 0x00000000, 0x0000003B, 0x000F003F,
    0x40C0FF44, 0x00000000, 0x000D0013, 0x00100006, 0x00130000, 0x00210019, 0x002D0027, 0x003F0035,
    0x281D1A00, 0x382D2B2A, 0x793D391D, 0x6F6F1B2B, 0x00180009, 0x00000000, 0x0000003F, 0x00100040,
    0x41C3FF45, 0x00000000, 0x000D0013, 0x00100006, 0x00130000, 0x00210019, 0x002D0027, 0x003F0035,
    0x281D1A00, 0x382D2B2A, 0x793D391D, 0x6F6F1B2B, 0x00180009, 0x00000000, 0x0000003F, 0x00100041,
    0x42C6FF46, 0x00000000, 0x000D0013, 0x00100006, 0x00130000, 0x00210019, 0x002D0027, 0x003F0035,
    0x281D1A00, 0x382D2B2A, 0x793E391D, 0x6F6F1B2B, 0x00180009, 0x00000000, 0x0000003F, 0x00100042,
    0x42C6FF47, 0x00000000, 0x000D0013, 0x00100006, 0x00130000, 0x00210019, 0x002D0027, 0x003F0035,
    0x281D1A00, 0x382D2B2A, 0x793E391D, 0x6F6F1B2B, 0x00180009, 0x00000000, 0x0000003F, 0x00100042,
    0x43C9FF48, 0x00000000, 0x000D0013, 0x00100006, 0x00130000, 0x00210019, 0x002D0027, 0x003F0035,
    0x281D1A00, 0x382D2B2A, 0x7A3E391D, 0x6F6F1B2B, 0x00180009, 0x00000000, 0x0000003F, 0x00100043,
    0x44CCFF49, 0x00000000, 0x000D0014, 0x00110007, 0x00140000, 0x0023001B, 0x00300029, 0x00420038,
    0x291E1A00, 0x382E2C2A, 0x7A3E391E, 0x6F6F1C2C, 0x00190009, 0x00000000, 0x00000042, 0x00110044,
    0x45CFFF4A, 0x00000000, 0x000D0014, 0x00110007, 0x00140000, 0x0023001B, 0x00300029, 0x00420038,
    0x291E1A00, 0x382E2C2A, 0x7A3E391E, 0x6F6F1C2C, 0x00190009, 0x00000000, 0x00000042, 0x00110045,
    0x46D2FF4B, 0x00000000, 0x000D0014, 0x00110007, 0x00140000, 0x0023001B, 0x00300029, 0x00420038,
    0x291E1A00, 0x382E2C2A, 0x7A3E3A1E, 0x6F6F1C2C, 0x00190009, 0x00000000, 0x00000042, 0x00110046,
    0x46D2FF4C, 0x00000000, 0x000D0014, 0x00110007, 0x00140000, 0x0023001B, 0x00300029, 0x00420038,
    0x291E1A00, 0x382E2C2A, 0x7A3E3A1E, 0x6F6F1C2C, 0x00190009, 0x00000000, 0x00000042, 0x00110046,
    0x47D5FF4D, 0x00000000, 0x000D0014, 0x00110007, 0x00140000, 0x0023001B, 0x00300029, 0x00420038,
    0x291E1A00, 0x382E2C2A, 0x7A3F3A1E, 0x6F6F1C2C, 0x00190009, 0x00000000, 0x00000042, 0x00110047,
    0x48D8FF4E, 0x00000000, 0x000E0015, 0x00120007, 0x00150000, 0x0025001C, 0x0033002C, 0x0046003C,
    0x291E1B00, 0x392F2D2B, 0x7A3F3A1E, 0x6F6F1D2C, 0x0019000A, 0x00000000, 0x00000046, 0x00120048,
    0x49DBFF4F, 0x00000000, 0x000E0015, 0x00120007, 0x00150000, 0x0025001C, 0x0033002C, 0x0046003C,
    0x291E1B00, 0x392F2D2B, 0x7A3F3A1F, 0x6F6F1D2C, 0x0019000A, 0x00000000, 0x00000046, 0x00120049,
    0x4ADEFF50, 0x00000000, 0x000E0015, 0x00120007, 0x00150000, 0x0025001C, 0x0033002C, 0x0046003C,
    0x291E1B00, 0x392F2D2B, 0x7B3F3A1F, 0x6F6F1D2C, 0x0019000A, 0x00000000, 0x00000046, 0x0012004A,
    0x4ADEFF51, 0x00000000, 0x000E0015, 0x00120007, 0x00150000, 0x0025001C, 0x0033002C, 0x0046003C,
    0x291E1B00, 0x392F2D2B, 0x7B3F3A1F, 0x6F6F1D2C, 0x0019000A, 0x00000000, 0x00000046, 0x0012004A,
    0x4BE1FF52, 0x00000000, 0x000E0015, 0x00120007, 0x00150000, 0x0025001C, 0x0033002C, 0x0046003C,
    0x291E1B00, 0x392F2D2B, 0x7B3F3A1F, 0x6F6F1D2C, 0x0019000A, 0x00000000, 0x00000046, 0x0012004B,
    0x4CE4FF53, 0x00000000, 0x000F0016, 0x00130007, 0x00160000, 0x0027001E, 0x0035002E, 0x004A003F,
    0x2A1F1B00, 0x39382D2C, 0x7B483A1F, 0x6F6F1D2D, 0x001A000A, 0x00000000, 0x0000004A, 0x0013004C,
    0x4DE7FF54, 0x00000000, 0x000F0016, 0x00130007, 0x00160000, 0x0027001E, 0x0035002E, 0x004A003F,
    0x2A1F1B00, 0x39382D2C, 0x7B483B1F, 0x6F6F1D2D, 0x001A000A, 0x00000000, 0x0000004A, 0x0013004D,
    0x4EEAFF55, 0x00000000, 0x000F0016, 0x00130007, 0x00160000, 0x0027001E, 0x0035002E, 0x004A003F,
    0x2A1F1B00, 0x39382D2C, 0x7B483B1F, 0x6F6F1D2D, 0x001A000A, 0x00000000, 0x0000004A, 0x0013004E,
    0x4EEAFF56, 0x00000000, 0x000F0016, 0x00130007, 0x00160000, 0x0027001E, 0x0035002E, 0x004A003F,
    0x2A1F1B00, 0x39382D2C, 0x7B483B1F, 0x6F6F1D2D, 0x001A000A, 0x00000000, 0x0000004A, 0x0013004E,
    0x4FEDFF57, 0x00000000, 0x000F0016, 0x00130007, 0x00160000, 0x0027001E, 0x0035002E, 0x004A003F,
    0x2A1F1B00, 0x39382D2C, 0x7B483B28, 0x6F6F1D2D, 0x001A000A, 0x00000000, 0x0000004A, 0x0013004F,
    0x50F0FF58, 0x00000000, 0x00100017, 0x00140008, 0x00170000, 0x0029001F, 0x00380030, 0x004E0042,
    0x2A281C00, 0x3A382E2C, 0x7B483B28, 0x6F6F1E2E, 0x001A000B, 0x00000000, 0x0000004E, 0x00140050,
    0x51F3FF59, 0x00000000, 0x00100017, 0x00140008, 0x00170000, 0x0029001F, 0x00380030, 0x004E0042,
    0x2A281C00, 0x3A382E2C, 0x7C483B28, 0x6F6F1E2E, 0x001A000B, 0x00000000, 0x0000004E, 0x00140051,
    0x51F3FF5A, 0x00000000, 0x00100017, 0x00140008, 0x00170000, 0x0029001F, 0x00380030, 0x004E0042,
    0x2A281C00, 0x3A382E2C, 0x7C483B28, 0x6F6F1E2E, 0x001A000B, 0x00000000, 0x0000004E, 0x00140051,
    0x52F6FF5B, 0x00000000, 0x00100017, 0x00140008, 0x00170000, 0x0029001F, 0x00380030, 0x004E0042,
    0x2A281C00, 0x3A382E2C, 0x7C483B28, 0x6F6F1E2E, 0x001A000B, 0x00000000, 0x0000004E, 0x00140052,
    0x53F9FF5C, 0x00000000, 0x00100017, 0x00140008, 0x00170000, 0x0029001F, 0x00380030, 0x004E0042,
    0x2A281C00, 0x3A382E2C, 0x7C493B28, 0x6F6F1E2E, 0x001A000B, 0x00000000, 0x0000004E, 0x00140053,
    0x54FCFF5D, 0x00000000, 0x00100019, 0x00150008, 0x00190000, 0x002B0021, 0x003B0033, 0x00520046,
    0x2B281D00, 0x3A392F2D, 0x7C493C28, 0x6F6F1F2E, 0x001B000B, 0x00000000, 0x00000052, 0x00150054,
    0x55FFFF5E, 0x00000000, 0x00100019, 0x00150008, 0x00190000, 0x002B0021, 0x003B0033, 0x00520046,
    0x2B281D00, 0x3A392F2D, 0x7C493C28, 0x6F6F1F2E, 0x001B000B, 0x00000000, 0x00000052, 0x00150055,
    0x55FFFF5F, 0x00000000, 0x00100019, 0x00150008, 0x00190000, 0x002B0021, 0x003B0033, 0x00520046,
    0x2B281D00, 0x3A392F2D, 0x7C493C28, 0x6F6F1F2E, 0x001B000B, 0x00000000, 0x00000052, 0x00150055,
    0x57FFFF60, 0x00000000, 0x00100019, 0x00150008, 0x00190000, 0x002B0021, 0x003B0033, 0x00520046,
    0x2B281D00, 0x3A392F2D, 0x7C493C29, 0x6F6F1F2E, 0x001B000B, 0x00000000, 0x00000052, 0x00150057,
    0x58FFFF61, 0x00000000, 0x0011001A, 0x00150009, 0x001A0000, 0x002D0022, 0x003E0035, 0x00560049,
    0x2B291D00, 0x3B39382D, 0x7D493C29, 0x6F6F1F2F, 0x001B000C, 0x00000000, 0x00000056, 0x00160058,
    0x5AFFFF62, 0x00000000, 0x0011001A, 0x00150009, 0x001A0000, 0x002D0022, 0x003E0035, 0x00560049,
    0x2B291D00, 0x3B39382D, 0x7D493C29, 0x6F6F1F2F, 0x001B000C, 0x00000000, 0x00000056, 0x0016005A,
    0x5CFFFF63, 0x00000000, 0x0012001B, 0x00160009, 0x001B0000, 0x002F0024, 0x00410038, 0x005A004C,
    0x2C291E00, 0x3B3A382E, 0x7D493D29, 0x6F6F2838, 0x001B000D, 0x00000000, 0x0000005A, 0x0017005C,
    0x5DFFFF64, 0x00000000, 0x0012001B, 0x00160009, 0x001B0000, 0x002F0024, 0x00410038, 0x005A004C,
    0x2C291E00, 0x3B3A382E, 0x7D4A3D29, 0x6F6F2838, 0x001B000D, 0x00000000, 0x0000005A, 0x0017005D,
    0x5FFFFF65, 0x00000000, 0x0012001B, 0x00160009, 0x001B0000, 0x002F0024, 0x00410038, 0x005A004C,
    0x2C291E00, 0x3B3A382E, 0x7E4A3D29, 0x6F6F2838, 0x001B000D, 0x00000000, 0x0000005A, 0x0017005F,
    0x60FFFF66, 0x00000000, 0x0013001C, 0x00170009, 0x001C0000, 0x00310026, 0x0044003A, 0x005E0050,
    0x2C2A1E00, 0x3C3A392F, 0x7E4A3D2A, 0x6F6F2838, 0x001C000D, 0x00000000, 0x0000005E, 0x00180060,
    0x62FFFF67, 0x00000000, 0x0013001C, 0x00170009, 0x001C0000, 0x00310026, 0x0044003A, 0x005E0050,
    0x2C2A1E00, 0x3C3A392F, 0x7E4A3D2A, 0x6F6F2838, 0x001C000D, 0x00000000, 0x0000005E, 0x00180062,
    0x63FFFF68, 0x00000000, 0x0013001C, 0x00170009, 0x001C0000, 0x00310026, 0x0044003A, 0x005E0050,
    0x2C2A1E00, 0x3C3A392F, 0x7E4A3E2A, 0x6F6F2838, 0x001C000D, 0x00000000, 0x0000005E, 0x00180063,
    0x65FFFF69, 0x00000000, 0x0014001D, 0x0018000A, 0x001D0000, 0x00330027, 0x0046003D, 0x00620053,
    0x2D2A1F00, 0x3C3A392F, 0x7E4A3E2A, 0x6F6F2939, 0x001C000E, 0x00000000, 0x00000062, 0x00190065,
    0x66FFFF6A, 0x00000000, 0x0014001D, 0x0018000A, 0x001D0000, 0x00330027, 0x0046003D, 0x00620053,
    0x2D2A1F00, 0x3C3A392F, 0x7E4A3E2A, 0x6F6F2939, 0x001C000E, 0x00000000, 0x00000062, 0x00190066,
    0x68FFFF6B, 0x00000000, 0x0014001E, 0x0019000A, 0x001E0000, 0x00350029, 0x0049003F, 0x00660056,
    0x2D2A1F00, 0x3D3B3938, 0x7F4B3E2A, 0x6F6F2939, 0x001D000E, 0x00000000, 0x00000066, 0x001A0068,
    0x69FFFF6C, 0x00000000, 0x0014001E, 0x0019000A, 0x001E0000, 0x00350029, 0x0049003F, 0x00660056,
    0x2D2A1F00, 0x3D3B3938, 0x7F4B3E2A, 0x6F6F2939, 0x001D000E, 0x00000000, 0x00000066, 0x001A0069,
    0x6BFFFF6D, 0x00000000, 0x0014001E, 0x0019000A, 0x001E0000, 0x00350029, 0x0049003F, 0x00660056,
    0x2D2A1F00, 0x3D3B3938, 0x7F4B3F2B, 0x6F6F2939, 0x001D000E, 0x00000000, 0x00000066, 0x001A006B,
    0x6CFFFF6E, 0x00000000, 0x00150020, 0x001A000B, 0x00200000, 0x0037002A, 0x004C0041, 0x0069005A,
    0x2E2B2800, 0x3D3B3A38, 0x7F4B3F2B, 0x6F6F2939, 0x001D000F, 0x00000000, 0x00000069, 0x001B006C,
    0x6EFFFF6F, 0x00000000, 0x00150020, 0x001A000B, 0x00200000, 0x0037002A, 0x004C0041, 0x0069005A,
    0x2E2B2800, 0x3D3B3A38, 0x884B3F2B, 0x6F6F2939, 0x001D000F, 0x00000000, 0x00000069, 0x001B006E,
    0x6FFFFF70, 0x00000000, 0x00150020, 0x001A000B, 0x00200000, 0x0037002A, 0x004C0041, 0x0069005A,
    0x2E2B2800, 0x3D3B3A38, 0x884B3F2B, 0x6F6F2939, 0x001D000F, 0x00000000, 0x00000069, 0x001B006F,
    0x71FFFF71, 0x00000000, 0x00160021, 0x001B000B, 0x00210000, 0x0039002C, 0x004F0044, 0x006D005D,
    0x2E2B2800, 0x3E3C3A39, 0x884C482B, 0x6F6F2A3A, 0x001E000F, 0x00000000, 0x0000006D, 0x001C0071,
    0x72FFFF72, 0x00000000, 0x00160021, 0x001B000B, 0x00210000, 0x0039002C, 0x004F0044, 0x006D005D,
    0x2E2B2800, 0x3E3C3A39, 0x884C482B, 0x6F6F2A3A, 0x001E000F, 0x00000000, 0x0000006D, 0x001C0072,
    0x74FFFF73, 0x00000000, 0x00170022, 0x001C000B, 0x00220000, 0x003B002D, 0x00520046, 0x00710060,
    0x2F2B2900, 0x3E3C3A39, 0x884C482B, 0x6F6F2A3A, 0x001E0018, 0x00000000, 0x00000071, 0x001D0074,
    0x75FFFF74, 0x00000000, 0x00170022, 0x001C000B, 0x00220000, 0x003B002D, 0x00520046, 0x00710060,
    0x2F2B2900, 0x3E3C3A39, 0x884C482C, 0x6F6F2A3A, 0x001E0018, 0x00000000, 0x00000071, 0x001D0075,
    0x76FFFF75, 0x00000000, 0x00170022, 0x001C000B, 0x00220000, 0x003B002D, 0x00520046, 0x00710060,
    0x2F2B2900, 0x3E3C3A39, 0x884C482C, 0x6F6F2A3A, 0x001E0018, 0x00000000, 0x00000071, 0x001D0076,
    0x78FFFF76, 0x00000000, 0x00170023, 0x001D000C, 0x00230000, 0x003D002F, 0x00540049, 0x00750064,
    0x2F2C2900, 0x3F3D3B39, 0x894C482C, 0x6F6F2A3A, 0x001F0018, 0x00000000, 0x00000075, 0x001E0078,
    0x79FFFF77, 0x00000000, 0x00170023, 0x001D000C, 0x00230000, 0x003D002F, 0x00540049, 0x00750064,
    0x2F2C2900, 0x3F3D3B39, 0x894C482C, 0x6F6F2A3A, 0x001F0018, 0x00000000, 0x00000075, 0x001E0079,
    0x7BFFFF78, 0x00000000, 0x00170023, 0x001D000C, 0x00230000, 0x003D002F, 0x00540049, 0x00750064,
    0x2F2C2900, 0x3F3D3B39, 0x894D482C, 0x6F6F2A3A, 0x001F0018, 0x00000000, 0x00000075, 0x001E007B,
    0x7DFFFF79, 0x00000000, 0x00180024, 0x001E000C, 0x00240000, 0x003F0030, 0x0057004B, 0x00790067,
    0x382C2900, 0x3F3D3B39, 0x894D492C, 0x6F6F2B3B, 0x001F0019, 0x00000000, 0x00000079, 0x001F007D,
    0x7FFFFF7A, 0x00000000, 0x00180024, 0x001E000C, 0x00240000, 0x003F0030, 0x0057004B, 0x00790067,
    0x382C2900, 0x3F3D3B39, 0x894D492D, 0x6F6F2B3B, 0x001F0019, 0x00000000, 0x00000079, 0x001F007F,
    0x81FFFF7B, 0x00000000, 0x00190026, 0x001F000D, 0x00260000, 0x00410032, 0x005A004E, 0x007D006A,
    0x382D2A00, 0x483D3B3A, 0x894D492D, 0x6F6F2B3B, 0x00280019, 0x00000000, 0x0000007D, 0x00200081,
    0x83FFFF7C, 0x00000000, 0x00190026, 0x001F000D, 0x00260000, 0x00410032, 0x005A004E, 0x007D006A,
    0x382D2A00, 0x483D3B3A, 0x894D492D, 0x6F6F2B3B, 0x00280019, 0x00000000, 0x0000007D, 0x00200083,
    0x86FFFF7D, 0x00000000, 0x001A0027, 0x0020000D, 0x00270000, 0x00430034, 0x005D0050, 0x0081006E,
    0x382D2A00, 0x483E3C3A, 0x8A4E492D, 0x6F6F2B3B, 0x00280019, 0x00000000, 0x00000081, 0x00210086,
    0x88FFFF7E, 0x00000000, 0x001B0028, 0x0021000D, 0x00280000, 0x00450035, 0x00600052, 0x00850071,
    0x392D2A00, 0x483E3C3A, 0x8A4E492D, 0x6F6F2C3C, 0x0028001A, 0x00000000, 0x00000085, 0x00220088,
    0x8AFFFF7F, 0x00000000, 0x001B0028, 0x0021000D, 0x00280000, 0x00450035, 0x00600052, 0x00850071,
    0x392D2A00, 0x483E3C3A, 0x8A4E492E, 0x6F6F2C3C, 0x0028001A, 0x00000000, 0x00000085, 0x0022008A,
    0x8CFFFF80, 0x00000000, 0x001B0029, 0x0022000E, 0x00290000, 0x00470037, 0x00620055, 0x00890074,
    0x392E2A00, 0x493F3C3B, 0x8A4E4A2E, 0x6F6F2C3C, 0x0029001A, 0x00000000, 0x00000089, 0x0023008C,
    0x8EFFFF81, 0x00000000, 0x001B0029, 0x0022000E, 0x00290000, 0x00470037, 0x00620055, 0x00890074,
    0x392E2A00, 0x493F3C3B, 0x8A4F4A2E, 0x6F6F2C3C, 0x0029001A, 0x00000000, 0x00000089, 0x0023008E,
    0x90FFFF82, 0x00000000, 0x001C002A, 0x0023000E, 0x002A0000, 0x00490038, 0x00650057, 0x008D0078,
    0x392E2B00, 0x493F3D3B, 0x8A4F4A2E, 0x6F6F2C3C, 0x0029001A, 0x00000000, 0x0000008D, 0x00240090,
    0x92FFFF83, 0x00000000, 0x001C002A, 0x0023000E, 0x002A0000, 0x00490038, 0x00650057, 0x008D0078,
    0x392E2B00, 0x493F3D3B, 0x8A4F4A2E, 0x6F6F2C3C, 0x0029001A, 0x00000000, 0x0000008D, 0x00240092,
    0x94FFFF84, 0x00000000, 0x001D002B, 0x0024000E, 0x002B0000, 0x004B003A, 0x0068005A, 0x0091007B,
    0x392F2B00, 0x493F3D3B, 0x8B4F4A2F, 0x6F6F2D3D, 0x0029001A, 0x00000000, 0x00000091, 0x00250094,
    0x96FFFF85, 0x00000000, 0x001D002B, 0x0024000E, 0x002B0000, 0x004B003A, 0x0068005A, 0x0091007B,
    0x392F2B00, 0x493F3D3B, 0x8B4F4A2F, 0x6F6F2D3D, 0x0029001A, 0x00000000, 0x00000091, 0x00250096,
    0x98FFFF86, 0x00000000, 0x001E002D, 0x0025000F, 0x002D0000, 0x004D003B, 0x006B005C, 0x0094007E,
    0x3A2F2B00, 0x49483D3C, 0x8B584A2F, 0x6F6F2D3D, 0x0029001B, 0x00000000, 0x00000094, 0x00260098,
    0x9AFFFF87, 0x00000000, 0x001E002D, 0x0025000F, 0x002D0000, 0x004D003B, 0x006B005C, 0x0094007E,
    0x3A2F2B00, 0x49483D3C, 0x8B584B2F, 0x6F6F2D3D, 0x0029001B, 0x00000000, 0x00000094, 0x0026009A,
    0x9CFFFF88, 0x00000000, 0x001E002E, 0x0026000F, 0x002E0000, 0x004F003D, 0x006E005E, 0x00980081,
    0x3A2F2C00, 0x4A483E3C, 0x8B584B2F, 0x6F6F2D3D, 0x002A001B, 0x00000000, 0x00000098, 0x0027009C,
    0x9EFFFF89, 0x00000000, 0x001E002E, 0x0026000F, 0x002E0000, 0x004F003D, 0x006E005E, 0x00980081,
    0x3A2F2C00, 0x4A483E3C, 0x8B584B38, 0x6F6F2D3D, 0x002A001B, 0x00000000, 0x00000098, 0x0027009E,
    0xA1FFFF8A, 0x00000000, 0x001F002F, 0x00270010, 0x002F0000, 0x0051003F, 0x00710061, 0x009C0085,
    0x3A382C00, 0x4A483E3C, 0x8B584B38, 0x6F6F2E3E, 0x002A001B, 0x00000000, 0x0000009C, 0x002800A1,
    0xA4FFFF8B, 0x00000000, 0x00200030, 0x00280010, 0x00300000, 0x00530040, 0x00730063, 0x00A00088,
    0x3A382C00, 0x4A493E3C, 0x8C584B38, 0x6F6F2E3E, 0x002A001B, 0x00000000, 0x000000A0, 0x002900A4,
    0xA6FFFF8C, 0x00000000, 0x00200030, 0x00280010, 0x00300000, 0x00530040, 0x00730063, 0x00A00088,
    0x3A382C00, 0x4A493E3C, 0x8C594B38, 0x6F6F2E3E, 0x002A001B, 0x00000000, 0x000000A0, 0x002900A6,
    0xA9FFFF8D, 0x00000000, 0x00210031, 0x00290010, 0x00310000, 0x00550042, 0x00760066, 0x00A4008B,
    0x3B382C00, 0x4A493F3D, 0x8C594C38, 0x6F6F2E3E, 0x002A001C, 0x00000000, 0x000000A4, 0x002A00A9,
    0xACFFFF8E, 0x00000000, 0x00220032, 0x002A0011, 0x00320000, 0x00570043, 0x00790068, 0x00A8008F,
    0x3B382D00, 0x4B493F3D, 0x8C594C38, 0x6F6F2F3F, 0x002B001C, 0x00000000, 0x000000A8, 0x002B00AC,
    0xAEFFFF8F, 0x00000000, 0x00220032, 0x002A0011, 0x00320000, 0x00570043, 0x00790068, 0x00A8008F,
    0x3B382D00, 0x4B493F3D, 0x8C594C39, 0x6F6F2F3F, 0x002B001C, 0x00000000, 0x000000A8, 0x002B00AE,
    0xB1FFFF90, 0x00000000, 0x00220034, 0x002B0011, 0x00340000, 0x00590045, 0x007C006B, 0x00AC0092,
    0x3B392D00, 0x4B49483D, 0x8D594C39, 0x6F6F2F3F, 0x002B001C, 0x00000000, 0x000000AC, 0x002C00B1,
    0xB4FFFF91, 0x00000000, 0x00230035, 0x002C0012, 0x00350000, 0x005B0046, 0x007F006D, 0x00B00095,
    0x3B392D00, 0x4B49483E, 0x8D594C39, 0x6F6F383F, 0x002B001D, 0x00000000, 0x000000B0, 0x002D00B4,
    0xB6FFFF92, 0x00000000, 0x00230035, 0x002C0012, 0x00350000, 0x005B0046, 0x007F006D, 0x00B00095,
    0x3B392D00, 0x4B49483E, 0x8D594C39, 0x6F6F383F, 0x002B001D, 0x00000000, 0x000000B0, 0x002D00B6,
    0xB9FFFF93, 0x00000000, 0x00240036, 0x002D0012, 0x00360000, 0x005D0048, 0x0081006F, 0x00B40099,
    0x3C392E00, 0x4B4A483E, 0x8D5A4D39, 0x6F6F3848, 0x002B001D, 0x00000000, 0x000000B4, 0x002E00B9,
    0xBBFFFF94, 0x00000000, 0x00240036, 0x002D0012, 0x00360000, 0x005D0048, 0x0081006F, 0x00B40099,
    0x3C392E00, 0x4B4A483E, 0x8D5A4D39, 0x6F6F3848, 0x002B001D, 0x00000000, 0x000000B4, 0x002E00BB,
    0xBEFFFF95, 0x00000000, 0x00250037, 0x002E0012, 0x00370000, 0x005F0049, 0x00840072, 0x00B8009C,
    0x3C392E00, 0x4C4A483E, 0x8E5A4D39, 0x6F6F3848, 0x002C001D, 0x00000000, 0x000000B8, 0x002F00BE,
    0xC0FFFF96, 0x00000000, 0x00260038, 0x002F0013, 0x00380000, 0x0062004B, 0x00870074, 0x00BC009F,
    0x3C392E00, 0x4C4A483F, 0x8E5A4D39, 0x6F6F3848, 0x002C001D, 0x00000000, 0x000000BC, 0x003000C0,
    0xC3FFFF97, 0x00000000, 0x00260038, 0x002F0013, 0x00380000, 0x0062004B, 0x00870074, 0x00BC009F,
    0x3C392E00, 0x4C4A483F, 0x8E5A4D3A, 0x6F6F3848, 0x002C001D, 0x00000000, 0x000000BC, 0x003000C3,
    0xC7FFFF98, 0x00000000, 0x00260039, 0x00300013, 0x00390000, 0x0064004D, 0x008A0077, 0x00BF00A3,
    0x3D3A2E00, 0x4C4A493F, 0x8E5A4E3A, 0x6F6F3848, 0x002C001E, 0x00000000, 0x000000BF, 0x003100C7,
    0xCAFFFF99, 0x00000000, 0x0027003B, 0x00310014, 0x003B0000, 0x0066004E, 0x008D0079, 0x00C300A6,
    0x3D3A2F00, 0x4C4A493F, 0x8E5A4E3A, 0x6F6F3949, 0x002C001E, 0x00000000, 0x000000C3, 0x003200CA,
    0xCDFFFF9A, 0x00000000, 0x0028003C, 0x00320014, 0x003C0000, 0x00680050, 0x008F007C, 0x00C700A9,
    0x3D3A2F00, 0x4C4B4948, 0x8F5B4E3A, 0x6F6F3949, 0x002D001E, 0x00000000, 0x000000C7, 0x003300CD,
    0xD0FFFF9B, 0x00000000, 0x0029003D, 0x00330014, 0x003D0000, 0x006A0051, 0x0092007E, 0x00CB00AD,
    0x3D3A2F00, 0x4D4B4948, 0x8F5B4E3A, 0x6F6F3949, 0x002D001E, 0x00000000, 0x000000CB, 0x003400D0,
    0xD3FFFF9C, 0x00000000, 0x0029003D, 0x00330014, 0x003D0000, 0x006A0051, 0x0092007E, 0x00CB00AD,
    0x3D3A2F00, 0x4D4B4948, 0x8F5B4E3A, 0x6F6F3949, 0x002D001E, 0x00000000, 0x000000CB, 0x003400D3,
    0xD6FFFF9D, 0x00000000, 0x0029003E, 0x00340015, 0x003E0000, 0x006C0053, 0x00950080, 0x00CF00B0,
    0x3E3A3800, 0x4D4B4948, 0x8F5B4F3B, 0x6F6F3949, 0x002D001F, 0x00000000, 0x000000CF, 0x003500D6,
    0xD9FFFF9E, 0x00000000, 0x002A003F, 0x00350015, 0x003F0000, 0x006E0054, 0x00980083, 0x00D300B3,
    0x3E3B3800, 0x4D4B4A48, 0x8F5B4F3B, 0x6F6F3949, 0x002D001F, 0x00000000, 0x000000D3, 0x003600D9,
    0xDCFFFF9F, 0x00000000, 0x002B0040, 0x00360015, 0x00400000, 0x00700056, 0x009B0085, 0x00D700B7,
    0x3E3B3800, 0x4D4B4A48, 0x8F5B4F3B, 0x6F6F3949, 0x002E001F, 0x00000000, 0x000000D7, 0x003700DC,
    0xDFFFFFA0, 0x00000000, 0x002B0040, 0x00360015, 0x00400000, 0x00700056, 0x009B0085, 0x00D700B7,
    0x3E3B3800, 0x4D4B4A48, 0x8F5B4F3B, 0x6F6F3949, 0x002E001F, 0x00000000, 0x000000D7, 0x003700DF,
    0xE2FFFFA1, 0x00000000, 0x002C0042, 0x00370016, 0x00420000, 0x00720058, 0x009E0088, 0x00DB00BA,
    0x3E3B3800, 0x4E4C4A49, 0x8F5C4F3B, 0x6F6F3A4A, 0x002E0028, 0x00000000, 0x000000DB, 0x003800E2,
    0xE6FFFFA2, 0x00000000, 0x002D0043, 0x00380016, 0x00430000, 0x00740059, 0x00A0008A, 0x00DF00BD,
    0x3F3B3800, 0x4E4C4A49, 0x8F5C583B, 0x6F6F3A4A, 0x002E0028, 0x00000000, 0x000000DF, 0x003900E6,
    0xE9FFFFA3, 0x00000000, 0x002D0044, 0x00390017, 0x00440000, 0x0076005B, 0x00A3008C, 0x00E300C1,
    0x3F3B3900, 0x4E4C4A49, 0x8F5C583B, 0x6F6F3A4A, 0x002E0028, 0x00000000, 0x000000E3, 0x003A00E9,
    0xEDFFFFA4, 0x00000000, 0x002E0045, 0x003A0017, 0x00450000, 0x0078005C, 0x00A6008F, 0x00E600C4,
    0x3F3C3900, 0x4E4C4A49, 0x8F5C583C, 0x6F6F3A4A, 0x002F0028, 0x00000000, 0x000000E6, 0x003B00ED,
    0xF0FFFFA5, 0x00000000, 0x002F0046, 0x003B0017, 0x00460000, 0x007A005E, 0x00A90091, 0x00EA00C7,
    0x3F3C3900, 0x4F4C4B49, 0x8F5C583C, 0x6F6F3A4A, 0x002F0028, 0x00000000, 0x000000EA, 0x003C00F0,
    0xF3FFFFA6, 0x00000000, 0x002F0046, 0x003B0017, 0x00460000, 0x007A005E, 0x00A90091, 0x00EA00C7,
    0x3F3C3900, 0x4F4C4B49, 0x8F5C583C, 0x6F6F3A4A, 0x002F0028, 0x00000000, 0x000000EA, 0x003C00F3,
    0xF7FFFFA7, 0x00000000, 0x00300047, 0x003C0018, 0x00470000, 0x007C005F, 0x00AC0094, 0x00EE00CB,
    0x483C3900, 0x4F4D4B49, 0x8F5D583C, 0x6F6F3A4A, 0x002F0028, 0x00000000, 0x000000EE, 0x003D00F7,
    0xFAFFFFA8, 0x00000000, 0x00300049, 0x003D0018, 0x00490000, 0x007E0061, 0x00AE0096, 0x00F200CE,
    0x483C3900, 0x4F4D4B49, 0x8F5D593C, 0x6F6F3B4B, 0x002F0029, 0x00000000, 0x000000F2, 0x003E00FA,
    0xFDFFFFA9, 0x00000000, 0x0031004A, 0x003E0019, 0x004A0000, 0x00800062, 0x00B10099, 0x00F600D1,
    0x483C3900, 0x4F4D4B4A, 0x8F5D593C, 0x6F6F3B4B, 0x00380029, 0x00000000, 0x000000F6, 0x003F00FD,
    0xFFFFFFAA, 0x00000000, 0x0032004B, 0x003F0019, 0x004B0000, 0x00820064, 0x00B4009B, 0x00FA00D5,
    0x483D3900, 0x584D4B4A, 0x8F5D593D, 0x6F6F3B4B, 0x00380029, 0x00000000, 0x000000FA, 0x00400101,
    0xFFFFFFAB, 0x00000000, 0x0033004C, 0x003F0019, 0x004C0000, 0x00840066, 0x00B7009D, 0x00FE00D8,
    0x483D3A00, 0x584E4B4A, 0x8F5D593D, 0x6F6F3B4B, 0x00380029, 0x00000000, 0x000000FE, 0x00410105,
    0xFFFFFFAC, 0x00000000, 0x0034004D, 0x0040001A, 0x004D0000, 0x00860067, 0x00BA00A0, 0x010200DB,
    0x483D3A00, 0x584E4C4A, 0x8F5E593D, 0x6F6F3B4B, 0x00380029, 0x00000000, 0x00000102, 0x00420109,
    0xFFFFFFAD, 0x00000000, 0x0034004F, 0x0041001A, 0x004F0000, 0x00880069, 0x00BC00A2, 0x010600DE,
    0x493D3A00, 0x584E4C4A, 0x8F5E593D, 0x6F6F3C4B, 0x00380029, 0x00000000, 0x00000106, 0x0043010D,
    0xFFFFFFAE, 0x00000000, 0x00350050, 0x0042001B, 0x00500000, 0x008A006A, 0x00BF00A5, 0x010A00E2,
    0x493D3A00, 0x584E4C4A, 0x8F5E593D, 0x6F6F3C4C, 0x00380029, 0x00000000, 0x0000010A, 0x00440110,
    0xFFFFFFAF, 0x00000000, 0x00360051, 0x0043001B, 0x00510000, 0x008C006C, 0x00C200A7, 0x010E00E5,
    0x493E3A00, 0x584E4C4A, 0x8F5E593E, 0x6F6F3C4C, 0x0038002A, 0x00000000, 0x0000010E, 0x00450114,
    0xFFFFFFB0, 0x00000000, 0x00370052, 0x0044001B, 0x00520000, 0x008E006D, 0x00C500AA, 0x011100E8,
    0x493E3A00, 0x594F4C4B, 0x8F5E5A3E, 0x6F6F3C4C, 0x0039002A, 0x00000000, 0x00000111, 0x00460118,
    0xFFFFFFB1, 0x00000000, 0x00370053, 0x0045001C, 0x00530000, 0x0090006F, 0x00C800AC, 0x011500EC,
    0x493E3A00, 0x594F4D4B, 0x8F5F5A3E, 0x6F6F3C4C, 0x0039002A, 0x00000000, 0x00000115, 0x0047011C,
    0xFFFFFFB2, 0x00000000, 0x00380054, 0x0046001C, 0x00540000, 0x00920071, 0x00CB00AE, 0x011900EF,
    0x493E3B00, 0x594F4D4B, 0x8F5F5A3E, 0x6F6F3C4C, 0x0039002A, 0x00000000, 0x00000119, 0x00480120,
    0xFFFFFFB3, 0x00000000, 0x00390056, 0x0047001D, 0x00560000, 0x00940072, 0x00CD00B1, 0x011D00F2,
    0x493E3B00, 0x594F4D4B, 0x8F5F5A3E, 0x6F6F3D4D, 0x0039002A, 0x00000000, 0x0000011D, 0x00490124,
    0xFFFFFFB4, 0x00000000, 0x003A0057, 0x0048001D, 0x00570000, 0x00960074, 0x00D000B3, 0x012100F6,
    0x493F3B00, 0x594F4D4B, 0x8F5F5A3F, 0x6F6F3D4D, 0x0039002A, 0x00000000, 0x00000121, 0x004A0128,
    0xFFFFFFB5, 0x00000000, 0x003B0058, 0x0049001D, 0x00580000, 0x00980075, 0x00D300B6, 0x012500F9,
    0x4A3F3B00, 0x59584D4B, 0x8F5F5A3F, 0x6F6F3D4D, 0x0039002A, 0x00000000, 0x00000125, 0x004B012C,
    0xFFFFFFB6, 0x00000000, 0x003B0059, 0x004A001E, 0x00590000, 0x009A0077, 0x00D600B8, 0x012900FC,
    0x4A3F3B00, 0x59584D4C, 0x8F685A3F, 0x6F6F3D4D, 0x0039002B, 0x00000000, 0x00000129, 0x004C0130,
    0xFFFFFFB7, 0x00000000, 0x003C005A, 0x004B001E, 0x005A0000, 0x009C0078, 0x00D900BA, 0x012D0100,
    0x4A3F3B00, 0x59584E4C, 0x8F685B3F, 0x6F6F3D4D, 0x0039002B, 0x00000000, 0x0000012D, 0x004D0135,
    0xFFFFFFB8, 0x00000000, 0x003D005B, 0x004C001E, 0x005B0000, 0x009E007A, 0x00DB00BD, 0x01310103,
    0x4A3F3B00, 0x5A584E4C, 0x8F685B3F, 0x6F6F3D4D, 0x003A002B, 0x00000000, 0x00000131, 0x004E0139,
    0xFFFFFFB9, 0x00000000, 0x003E005D, 0x004D001F, 0x005D0000, 0x00A0007B, 0x00DE00BF, 0x01350106,
    0x4A3F3C00, 0x5A584E4C, 0x8F685B48, 0x6F6F3E4E, 0x003A002B, 0x00000000, 0x00000135, 0x004F013D,
    0xFFFFFFBA, 0x00000000, 0x003F005E, 0x004E001F, 0x005E0000, 0x00A3007D, 0x00E100C2, 0x0139010A,
    0x4A483C00, 0x5A584E4C, 0x8F685B48, 0x6F6F3E4E, 0x003A002B, 0x00000000, 0x00000139, 0x00500142,
    0xFFFFFFBB, 0x00000000, 0x003F005F, 0x004F0020, 0x005F0000, 0x00A5007F, 0x00E400C4, 0x013C010D,
    0x4A483C00, 0x5A584E4C, 0x8F685B48, 0x6F6F3E4E, 0x003A002B, 0x00000000, 0x0000013C, 0x00510146,
    0xFFFFFFBC, 0x00000000, 0x00400060, 0x00500020, 0x00600000, 0x00A70080, 0x00E700C7, 0x01400110,
    0x4A483C00, 0x5A594E4C, 0x8F685B48, 0x6F6F3E4E, 0x003A002B, 0x00000000, 0x00000140, 0x0052014A,
    0xFFFFFFBD, 0x00000000, 0x00410061, 0x00510020, 0x00610000, 0x00A90082, 0x00E900C9, 0x01440114,
    0x4B483C00, 0x5A594F4D, 0x8F695B48, 0x6F6F3E4E, 0x003A002B, 0x00000000, 0x00000144, 0x0053014F,
    0xFFFFFFBE, 0x00000000, 0x00420064, 0x00530021, 0x00640000, 0x00AD0085, 0x00EF00CE, 0x014C011A,
    0x4B483D00, 0x5A594F4D, 0x8F695C48, 0x6F6F3F4F, 0x003A002C, 0x00000000, 0x0000014C, 0x00550154,
    0xFFFFFFBF, 0x00000000, 0x00430065, 0x00540022, 0x00650000, 0x00AF0086, 0x00F200D0, 0x0150011E,
    0x4B483D00, 0x5B594F4D, 0x8F695C48, 0x6F6F3F4F, 0x003B002C, 0x00000000, 0x00000150, 0x00560158,
    0xFFFFFFC0, 0x00000000, 0x00440066, 0x00550022, 0x00660000, 0x00B10088, 0x00F500D3, 0x01540121,
    0x4B493D00, 0x5B594F4D, 0x8F695C49, 0x6F6F3F4F, 0x003B002C, 0x00000000, 0x00000154, 0x0057015D,
    0xFFFFFFC1, 0x00000000, 0x00450067, 0x00560022, 0x00670000, 0x00B3008A, 0x00F800D5, 0x01580124,
    0x4B493D00, 0x5B59584D, 0x8F695C49, 0x6F6F3F4F, 0x003B002C, 0x00000000, 0x00000158, 0x00580162,
    0xFFFFFFC2, 0x00000000, 0x00460068, 0x00570023, 0x00680000, 0x00B5008B, 0x00FA00D8, 0x015C0128,
    0x4B493D00, 0x5B59584E, 0x8F695C49, 0x6F6F3F4F, 0x003B002C, 0x00000000, 0x0000015C, 0x00590167,
    0xFFFFFFC3, 0x00000000, 0x0047006B, 0x00590024, 0x006B0000, 0x00B9008E, 0x010000DC, 0x0163012E,
    0x4C493D00, 0x5B59584E, 0x8F695C49, 0x6F6F4858, 0x003B002D, 0x00000000, 0x00000163, 0x005B016C,
    0xFFFFFFC4, 0x00000000, 0x0048006C, 0x005A0024, 0x006C0000, 0x00BB0090, 0x010300DF, 0x01670131,
    0x4C493E00, 0x5B5A584E, 0x8F695D49, 0x6F6F4858, 0x003B002D, 0x00000000, 0x00000167, 0x005C0171,
    0xFFFFFFC5, 0x00000000, 0x0049006D, 0x005B0024, 0x006D0000, 0x00BD0091, 0x010600E1, 0x016B0135,
    0x4C493E00, 0x5B5A584E, 0x8F6A5D49, 0x6F6F4858, 0x003B002D, 0x00000000, 0x0000016B, 0x005D0176,
    0xFFFFFFC6, 0x00000000, 0x0049006E, 0x005C0025, 0x006E0000, 0x00BF0093, 0x010800E4, 0x016F0138,
    0x4C493E00, 0x5B5A584E, 0x8F6A5D49, 0x6F6F4858, 0x003C002D, 0x00000000, 0x0000016F, 0x005E017B,
    0xFFFFFFC7, 0x00000000, 0x004B0071, 0x005E0026, 0x00710000, 0x00C30096, 0x010E00E9, 0x0177013F,
    0x4C493E00, 0x5C5A584F, 0x8F6A5D49, 0x6F6F4858, 0x003C002D, 0x00000000, 0x00000177, 0x00600180,
    0xFFFFFFC8, 0x00000000, 0x004C0072, 0x005F0026, 0x00720000, 0x00C50098, 0x011100EB, 0x017B0142,
    0x4C4A3E00, 0x5C5A594F, 0x8F6A5D4A, 0x6F6F4858, 0x003C002D, 0x00000000, 0x0000017B, 0x00610185,
    0xFFFFFFC9, 0x00000000, 0x004D0073, 0x00600026, 0x00730000, 0x00C70099, 0x011400ED, 0x017F0145,
    0x4C4A3E00, 0x5C5A594F, 0x8F6A5E4A, 0x6F6F4858, 0x003C002E, 0x00000000, 0x0000017F, 0x0062018B,
    0xFFFFFFCA, 0x00000000, 0x004E0075, 0x00620027, 0x00750000, 0x00CB009C, 0x011900F2, 0x0187014C,
    0x4D4A3F00, 0x5C5A594F, 0x8F6A5E4A, 0x6F6F4959, 0x003C002E, 0x00000000, 0x00000187, 0x00640190,
    0xFFFFFFCB, 0x00000000, 0x004F0076, 0x00630027, 0x00760000, 0x00CD009E, 0x011C00F5, 0x018B014F,
    0x4D4A3F00, 0x5C5A594F, 0x8F6A5E4A, 0x6F6F4959, 0x003C002E, 0x00000000, 0x0000018B, 0x00650196,
    0xFFFFFFCC, 0x00000000, 0x00500078, 0x00640028, 0x00780000, 0x00CF009F, 0x011F00F7, 0x018E0153,
    0x4D4A3F00, 0x5C5B594F, 0x8F6B5E4A, 0x6F6F4959, 0x003D002E, 0x00000000, 0x0000018E, 0x0066019B,
    0xFFFFFFCD, 0x00000000, 0x0051007A, 0x00660029, 0x007A0000, 0x00D300A3, 0x012500FC, 0x01960159,
    0x4D4A3F00, 0x5D5B5958, 0x8F6B5E4A, 0x6F6F4959, 0x003D002E, 0x00000000, 0x00000196, 0x006801A1,
    0xFFFFFFCE, 0x00000000, 0x0052007B, 0x00670029, 0x007B0000, 0x00D500A4, 0x012700FE, 0x019A015D,
    0x4D4A3F00, 0x5D5B5958, 0x8F6B5E4A, 0x6F6F4959, 0x003D002E, 0x00000000, 0x0000019A, 0x006901A7,
    0xFFFFFFCF, 0x00000000, 0x0054007D, 0x0068002A, 0x007D0000, 0x00D900A7, 0x012D0103, 0x01A20163,
    0x4E4A4800, 0x5D5B5958, 0x8F6B5F4B, 0x6F6F4959, 0x003D002F, 0x00000000, 0x000001A2, 0x006B01AD,
    0xFFFFFFD0, 0x00000000, 0x0054007F, 0x0069002A, 0x007F0000, 0x00DB00A9, 0x01300106, 0x01A60167,
    0x4E4B4800, 0x5D5B5A58, 0x8F6B5F4B, 0x6F6F4959, 0x003D002F, 0x00000000, 0x000001A6, 0x006C01B3,
    0xFFFFFFD1, 0x00000000, 0x00560081, 0x006B002B, 0x00810000, 0x00DF00AC, 0x0135010A, 0x01AE016D,
    0x4E4B4800, 0x5D5B5A58, 0x8F6B5F4B, 0x6F6F4959, 0x003D002F, 0x00000000, 0x000001AE, 0x006E01B9,
    0xFFFFFFD2, 0x00000000, 0x00570082, 0x006C002B, 0x00820000, 0x00E100AD, 0x0138010D, 0x01B20171,
    0x4E4B4800, 0x5E5C5A58, 0x8F6B5F4B, 0x6F6F4A5A, 0x003E002F, 0x00000000, 0x000001B2, 0x006F01BF,
    0xFFFFFFD3, 0x00000000, 0x00580084, 0x006E002C, 0x00840000, 0x00E600B1, 0x013E0112, 0x01B90177,
    0x4E4B4800, 0x5E5C5A59, 0x8F6C684B, 0x6F6F4A5A, 0x003E0038, 0x00000000, 0x000001B9, 0x007101C6,
    0xFFFFFFD4, 0x00000000, 0x005A0087, 0x0070002D, 0x00870000, 0x00EA00B4, 0x01430117, 0x01C1017E,
    0x4F4B4800, 0x5E5C5A59, 0x8F6C684B, 0x6F6F4A5A, 0x003E0038, 0x00000000, 0x000001C1, 0x007301CD,
    0xFFFFFFD5, 0x00000000, 0x005B0088, 0x0071002D, 0x00880000, 0x00EC00B5, 0x01460119, 0x01C50181,
    0x4F4B4900, 0x5E5C5A59, 0x8F6C684B, 0x6F6F4A5A, 0x003E0038, 0x00000000, 0x000001C5, 0x007401D3,
    0xFFFFFFD6, 0x00000000, 0x005C008A, 0x0073002E, 0x008A0000, 0x00F000B8, 0x014C011E, 0x01CD0188,
    0x4F4C4900, 0x5E5C5A59, 0x8F6C684C, 0x6F6F4A5A, 0x003E0038, 0x00000000, 0x000001CD, 0x007601DB,
    0xFFFFFFD7, 0x00000000, 0x005E008D, 0x0075002F, 0x008D0000, 0x00F400BC, 0x01520123, 0x01D5018E,
    0x4F4C4900, 0x5F5C5B59, 0x8F6C684C, 0x6F6F4A5A, 0x003F0038, 0x00000000, 0x000001D5, 0x007801E2,
    0xFFFFFFD8, 0x00000000, 0x005F008F, 0x00770030, 0x008F0000, 0x00F800BF, 0x01570127, 0x01DD0195,
    0x584C4900, 0x5F5D5B59, 0x8F6D684C, 0x6F6F4A5A, 0x003F0038, 0x00000000, 0x000001DD, 0x007A01E9,
    0xFFFFFFD9, 0x00000000, 0x00610091, 0x00790030, 0x00910000, 0x00FC00C2, 0x015D012C, 0x01E4019C,
    0x584C4900, 0x5F5D5B59, 0x8F6D694C, 0x6F6F4B5B, 0x003F0039, 0x00000000, 0x000001E4, 0x007C01F1,
    0xFFFFFFDA, 0x00000000, 0x00620094, 0x007B0031, 0x00940000, 0x010000C5, 0x01620131, 0x01EC01A2,
    0x584C4900, 0x5F5D5B5A, 0x8F6D694C, 0x6F6F4B5B, 0x003F0039, 0x00000000, 0x000001EC, 0x007E01F9,
    0xFFFFFFDB, 0x00000000, 0x00640096, 0x007D0032, 0x00960000, 0x010400C8, 0x01680136, 0x01F401A9,
    0x584D4900, 0x685D5B5A, 0x8F6D694D, 0x6F6F4B5B, 0x00480039, 0x00000000, 0x000001F4, 0x00800201,
    0xFFFFFFDC, 0x00000000, 0x00660098, 0x007F0033, 0x00980000, 0x010800CB, 0x016E013B, 0x01FC01B0,
    0x584D4A00, 0x685E5B5A, 0x8F6D694D, 0x6F6F4B5B, 0x00480039, 0x00000000, 0x000001FC, 0x0082020A,
    0xFFFFFFDD, 0x00000000, 0x0067009B, 0x00810034, 0x009B0000, 0x010C00CE, 0x01730140, 0x020401B6,
    0x584D4A00, 0x685E5C5A, 0x8F6E694D, 0x6F6F4B5B, 0x00480039, 0x00000000, 0x00000204, 0x00840212,
    0xFFFFFFDE, 0x00000000, 0x0069009D, 0x00830034, 0x009D0000, 0x011000D1, 0x01790145, 0x020B01BD,
    0x594D4A00, 0x685E5C5A, 0x8F6E694D, 0x6F6F4B5B, 0x00480039, 0x00000000, 0x0000020B, 0x0086021B,
    0xFFFFFFDF, 0x00000000, 0x006B00A1, 0x00860036, 0x00A10000, 0x011600D6, 0x0181014C, 0x021701C7,
    0x594D4A00, 0x685E5C5A, 0x8F6E694D, 0x6F6F4C5C, 0x00480039, 0x00000000, 0x00000217, 0x00890225,
    0xFFFFFFE0, 0x00000000, 0x006D00A3, 0x00880036, 0x00A30000, 0x011A00D9, 0x01870151, 0x021F01CE,
    0x594E4A00, 0x685E5C5B, 0x8F6E6A4E, 0x6F6F4C5C, 0x0049003A, 0x00000000, 0x0000021F, 0x008B022F,
    0xFFFFFFE1, 0x00000000, 0x006F00A6, 0x008B0037, 0x00A60000, 0x012000DE, 0x018F0158, 0x022B01D7,
    0x594E4A00, 0x695F5C5B, 0x8F6F6A4E, 0x6F6F4C5C, 0x0049003A, 0x00000000, 0x0000022B, 0x008E0239,
    0xFFFFFFE2, 0x00000000, 0x007100A9, 0x008D0038, 0x00A90000, 0x012500E1, 0x0195015D, 0x023301DE,
    0x594E4B00, 0x695F5D5B, 0x8F6F6A4E, 0x6F6F4C5C, 0x0049003A, 0x00000000, 0x00000233, 0x00900243,
    0xFFFFFFE3, 0x00000000, 0x007300AC, 0x00900039, 0x00AC0000, 0x012B00E6, 0x019D0164, 0x023E01E8,
    0x594E4B00, 0x695F5D5B, 0x8F6F6A4E, 0x6F6F4D5D, 0x0049003A, 0x00000000, 0x0000023E, 0x0093024E,
    0xFFFFFFE4, 0x00000000, 0x007500B0, 0x0092003B, 0x00B00000, 0x013100EA, 0x01A6016B, 0x024A01F2,
    0x5A4F4B00, 0x69685D5B, 0x8F6F6A4F, 0x6F6F4D5D, 0x0049003A, 0x00000000, 0x0000024A, 0x0096025A,
    0xFFFFFFE5, 0x00000000, 0x007800B3, 0x0095003C, 0x00B30000, 0x013700EF, 0x01AE0173, 0x025601FC,
    0x5A4F4B00, 0x69685D5C, 0x8F786B4F, 0x6F6F4D5D, 0x0049003B, 0x00000000, 0x00000256, 0x00990266,
    0xFFFFFFE6, 0x00000000, 0x007A00B7, 0x0098003D, 0x00B70000, 0x013D00F4, 0x01B7017A, 0x02610206,
    0x5A4F4B00, 0x6A685E5C, 0x8F786B4F, 0x6F6F4D5D, 0x004A003B, 0x00000000, 0x00000261, 0x009C0272,
    0xFFFFFFE7, 0x00000000, 0x007D00BC, 0x009C003F, 0x00BC0000, 0x014500FA, 0x01C20184, 0x02710213,
    0x5A584C00, 0x6A685E5C, 0x8F786B58, 0x6F6F4E5E, 0x004A003B, 0x00000000, 0x00000271, 0x00A00280,
    0xFFFFFFE8, 0x00000000, 0x007F00BF, 0x009F0040, 0x00BF0000, 0x014B00FF, 0x01CA018B, 0x027D021D,
    0x5A584C00, 0x6A685E5C, 0x8F786B58, 0x6F6F4E5E, 0x004A003B, 0x00000000, 0x0000027D, 0x00A3028E,
    0xFFFFFFE9, 0x00000000, 0x008200C4, 0x00A30041, 0x00C40000, 0x01530105, 0x01D60194, 0x028C022A,
    0x5B584C00, 0x6A695F5D, 0x8F796B58, 0x6F6F4E5E, 0x004A003B, 0x00000000, 0x0000028C, 0x00A7029C,
    0xFFFFFFEA, 0x00000000, 0x008600C8, 0x00A70043, 0x00C80000, 0x015B010B, 0x01E1019E, 0x029C0238,
    0x5B584D00, 0x6A695F5D, 0x8F796C58, 0x6F6F4F5F, 0x004A003C, 0x00000000, 0x0000029C, 0x00AB02AC,
    0xFFFFFFEB, 0x00000000, 0x008900CD, 0x00AB0044, 0x00CD0000, 0x01630111, 0x01EC01A8, 0x02AC0245,
    0x5B594D00, 0x6B695F5D, 0x8F796C59, 0x6F6F4F5F, 0x004B003C, 0x00000000, 0x000002AC, 0x00AF02BC,
    0xFFFFFFEC, 0x00000000, 0x008C00D2, 0x00AF0046, 0x00D20000, 0x016C0118, 0x01F701B2, 0x02BB0252,
    0x5B594D00, 0x6B69685E, 0x8F796C59, 0x6F6F4F5F, 0x004B003C, 0x00000000, 0x000002BB, 0x00B302CD,
    0xFFFFFFED, 0x00000000, 0x009000D8, 0x00B40048, 0x00D80000, 0x01760120, 0x020601BE, 0x02CF0263,
    0x5C594E00, 0x6B6A685E, 0x8F796D59, 0x6F6F5868, 0x004B003D, 0x00000000, 0x000002CF, 0x00B802E0,
    0xFFFFFFEE, 0x00000000, 0x009300DC, 0x00B80049, 0x00DC0000, 0x017E0126, 0x021101C7, 0x02DE0270,
    0x5C594E00, 0x6B6A685E, 0x8F7A6D59, 0x6F6F5868, 0x004C003D, 0x00000000, 0x000002DE, 0x00BC02F3,
    0xFFFFFFEF, 0x00000000, 0x009700E2, 0x00BC004B, 0x00E20000, 0x0188012E, 0x021F01D3, 0x02F20281,
    0x5C594E00, 0x6C6A685F, 0x8F7A6D59, 0x6F6F5868, 0x004C003D, 0x00000000, 0x000002F2, 0x00C10307,
    0xFFFFFFF0, 0x00000000, 0x009B00E9, 0x00C2004E, 0x00E90000, 0x01940137, 0x023001E2, 0x03090295,
    0x5D5A4F00, 0x6C6A695F, 0x8F7A6E5A, 0x6F6F5969, 0x004C003E, 0x00000000, 0x00000309, 0x00C7031C,
    0xFFFFFFF1, 0x00000000, 0x009F00EF, 0x00C70050, 0x00EF0000, 0x019E013F, 0x023E01EE, 0x031D02A5,
    0x5D5A4F00, 0x6C6B695F, 0x8F7B6E5A, 0x6F6F5969, 0x004C003E, 0x00000000, 0x0000031D, 0x00CC0333,
    0xFFFFFFF2, 0x00000000, 0x00A400F6, 0x00CD0052, 0x00F60000, 0x01AB0148, 0x024F01FD, 0x033402B9,
    0x5D5A4F00, 0x6D6B6968, 0x8F7B6E5A, 0x6F6F5969, 0x004D003E, 0x00000000, 0x00000334, 0x00D2034B,
    0xFFFFFFF3, 0x00000000, 0x00AA00FE, 0x00D40055, 0x00FE0000, 0x01B90153, 0x0262020E, 0x035002D1,
    0x5E5B5800, 0x6D6B6A68, 0x8F7B6F5B, 0x6F6F5969, 0x004D003F, 0x00000000, 0x00000350, 0x00D90365,
    0xFFFFFFF4, 0x00000000, 0x00AF0107, 0x00DB0058, 0x01070000, 0x01C7015E, 0x0276021F, 0x036B02E8,
    0x5E5B5800, 0x6E6C6A68, 0x8F7B6F5B, 0x6F6F5A6A, 0x004E003F, 0x00000000, 0x0000036B, 0x00E00380,
    0xFFFFFFF5, 0x00000000, 0x00B4010F, 0x00E2005A, 0x010F0000, 0x01D50169, 0x028A022F, 0x038602FF,
    0x5F5B5800, 0x6E6C6A69, 0x8F7C785B, 0x6F6F5A6A, 0x004E0048, 0x00000000, 0x00000386, 0x00E7039D,
    0xFFFFFFF6, 0x00000000, 0x00BA0117, 0x00E8005D, 0x01170000, 0x01E30174, 0x029D0240, 0x03A20316,
    0x5F5C5900, 0x6F6C6A69, 0x8F7C785C, 0x6F6F5A6A, 0x004F0048, 0x00000000, 0x000003A2, 0x00EE03BB,
    0xFFFFFFF7, 0x00000000, 0x00C10121, 0x00F10060, 0x01210000, 0x01F60182, 0x02B70256, 0x03C50334,
    0x685C5900, 0x6F6D6B69, 0x8F7D785C, 0x6F6F5B6B, 0x004F0048, 0x00000000, 0x000003C5, 0x00F703DC,
    0xFFFFFFF8, 0x00000000, 0x00C7012B, 0x00F90064, 0x012B0000, 0x0206018E, 0x02CD026A, 0x03E4034F,
    0x685C5900, 0x6F6D6B6A, 0x8F7D795C, 0x6F6F5B6B, 0x00580049, 0x00000000, 0x000003E4, 0x00FF03FE,
    0xFFFFFFF9, 0x00000000, 0x00CE0135, 0x01020067, 0x01350000, 0x0218019D, 0x02E7027F, 0x0407036D,
    0x685D5A00, 0x6F6E6C6A, 0x8F7E795D, 0x6F6F5B6B, 0x00580049, 0x00000000, 0x00000407, 0x01080422,
    0xFFFFFFFA, 0x00000000, 0x00D60141, 0x010C006B, 0x01410000, 0x022D01AC, 0x03030298, 0x042E038E,
    0x695D5A00, 0x6F6E6C6A, 0x8F7E795D, 0x6F6F5C6C, 0x00580049, 0x00000000, 0x0000042E, 0x0112044A,
    0xFFFFFFFB, 0x00000000, 0x00DE014D, 0x0115006F, 0x014D0000, 0x024101BC, 0x031F02B0, 0x045503AF,
    0x695E5A00, 0x6F6F6C6B, 0x8F7F7A5E, 0x6F6F5C6C, 0x0059004A, 0x00000000, 0x00000455, 0x011C0473,
    0xFFFFFFFC, 0x00000000, 0x00E7015B, 0x01210074, 0x015B0000, 0x025901CF, 0x034102CD, 0x048403D7,
    0x695E5B00, 0x6F6F6D6B, 0x8F7F7A5E, 0x6F6F5D6D, 0x0059004A, 0x00000000, 0x00000484, 0x012804A0,
    0xFFFFFFFD, 0x00000000, 0x00F10169, 0x012D0078, 0x01690000, 0x027201E1, 0x036202EA, 0x04B303FF,
    0x6A5F5B00, 0x6F6F6E6C, 0x8F887B5F, 0x6F6F5D6D, 0x0059004B, 0x00000000, 0x000004B3, 0x013404D0,
    0xFFFFFFFE, 0x00000000, 0x00FA0177, 0x0139007D, 0x01770000, 0x028A01F4, 0x03840307, 0x04E20427,
    0x6A685C00, 0x6F6F6E6C, 0x8F887B68, 0x6F6F5E6E, 0x005A004B, 0x00000000, 0x000004E2, 0x01400502,
    0xFFFFFFFF, 0x00000000, 0x01050187, 0x01460082, 0x01870000, 0x02A6020A, 0x03AB0329, 0x05190455,
    0x6B685C00, 0x6F6F6F6D, 0x8F897B68, 0x6F6F5E6E, 0x005A004B, 0x00000000, 0x00000519, 0x014E0538,
    0x00080004, 0x00090008, 0x000B000A, 0x000C000C, 0x000E000D, 0x0010000F, 0x00120011, 0x00130013,
    0x00150014, 0x00170016, 0x00190018, 0x001A001A, 0x001C001B, 0x001E001D, 0x0020001F, 0x00210020,
    0x00230022, 0x00250024, 0x00260026, 0x00280027, 0x002A0029, 0x002B002B, 0x002D002C, 0x002F002E,
    0x00300030, 0x00320031, 0x00340033, 0x00350035, 0x00370036, 0x00390038, 0x003A0039, 0x003C003B,
    0x003E003D, 0x003F003E, 0x00410040, 0x00420042, 0x00440043, 0x00460045, 0x00470046, 0x00490048,
    0x004A004A, 0x004C004B, 0x004E004D, 0x004F004E, 0x00510050, 0x00520051, 0x00540053, 0x00550055,
    0x00580057, 0x005C005A, 0x005F005D, 0x00620060, 0x00650063, 0x00680066, 0x006B0069, 0x006E006C,
    0x0071006F, 0x00740072, 0x00760075, 0x00790078, 0x007D007B, 0x0081007F, 0x00860083, 0x008A0088,
    0x008E008C, 0x00920090, 0x00960094, 0x009A0098, 0x009E009C, 0x00A400A1, 0x00A900A6, 0x00AE00AC,
    0x00B400B1, 0x00B900B6, 0x00BE00BB, 0x00C300C0, 0x00CA00C7, 0x00D000CD, 0x00D600D3, 0x00DC00D9,
    0x00E200DF, 0x00E900E6, 0x00F000ED, 0x00F700F3, 0x00FD00FA, 0x01050101, 0x010D0109, 0x01140110,
    0x011C0118, 0x01240120, 0x012C0128, 0x01350130, 0x013D0139, 0x01460142, 0x014F014A, 0x01580154,
    0x0162015D, 0x016C0167, 0x01760171, 0x0180017B, 0x018B0185, 0x01960190, 0x01A1019B, 0x01AD01A7,
    0x01B901B3, 0x01C601BF, 0x01D301CD, 0x01E201DB, 0x01F101E9, 0x020101F9, 0x0212020A, 0x0225021B,
    0x0239022F, 0x024E0243, 0x0266025A, 0x02800272, 0x029C028E, 0x02BC02AC, 0x02E002CD, 0x030702F3,
    0x0333031C, 0x0365034B, 0x039D0380, 0x03DC03BB, 0x042203FE, 0x0473044A, 0x04D004A0, 0x05380502,
    0x00080004, 0x000A0009, 0x000C000B, 0x000E000D, 0x0010000F, 0x00120011, 0x00140013, 0x00160015,
    0x00180017, 0x001A0019, 0x001C001B, 0x001E001D, 0x0020001F, 0x00220021, 0x00240023, 0x00260025,
    0x00280027, 0x002A0029, 0x002C002B, 0x002E002D, 0x0030002F, 0x00320031, 0x00340033, 0x00360035,
    0x00380037, 0x003A0039, 0x003C003B, 0x003E003D, 0x0040003F, 0x00420041, 0x00440043, 0x00460045,
    0x00480047, 0x004A0049, 0x004C004B, 0x004E004D, 0x0050004F, 0x00520051, 0x00540053, 0x00560055,
    0x00580057, 0x005A0059, 0x005C005B, 0x005E005D, 0x0060005F, 0x00620061, 0x00640063, 0x00660065,
    0x006A0068, 0x006E006C, 0x00720070, 0x00760074, 0x007A0078, 0x007E007C, 0x00820080, 0x00860084,
    0x008A0088, 0x008E008C, 0x00920090, 0x00960094, 0x009B0098, 0x00A1009E, 0x00A700A4, 0x00AD00AA,
    0x00B300B0, 0x00B900B6, 0x00BF00BC, 0x00C500C2, 0x00CB00C8, 0x00D300CF, 0x00DB00D7, 0x00E300DF,
    0x00EB00E7, 0x00F300EF, 0x00FB00F7, 0x010400FF, 0x010E0109, 0x01180113, 0x0122011D, 0x012C0127,
    0x01370131, 0x0143013D, 0x014F0149, 0x015B0155, 0x01670161, 0x0175016E, 0x0183017C, 0x0191018A,
    0x01A00198, 0x01B001A8, 0x01C001B8, 0x01D101C8, 0x01E301DA, 0x01F501EC, 0x020801FE, 0x021C0212,
    0x02300226, 0x0246023B, 0x025C0251, 0x02730267, 0x028B027F, 0x02A40297, 0x02BE02B1, 0x02D902CB,
    0x02F502E7, 0x03120303, 0x03300321, 0x03500340, 0x03710360, 0x03930382, 0x03B703A5, 0x03DC03C9,
    0x040203EF, 0x042A0416, 0x0454043F, 0x047F0469, 0x04AC0495, 0x04DB04C3, 0x050C04F3, 0x053F0525,
    0x05740559, 0x05AB058F, 0x05E405C7, 0x061F0601, 0x065C063D, 0x069C067C, 0x06DF06BD, 0x07240701
};

const unsigned int gen9_vp9_avs_coeffs[256] = {
    0x00000000, 0x40400000, 0x00000000, 0x00000000, 0x40000000, 0x00000000, 0x40000000, 0x00000000,
    0x0101FFFF, 0x4040FEFE, 0xFFFF0202, 0x00000101, 0x40FF0000, 0x00000001, 0x40FF0000, 0x00000001,
    0x0202FFFF, 0x4141FCFC, 0xFEFE0404, 0xFFFF0101, 0x3FFE0000, 0x00000003, 0x3FFE0000, 0x00000003,
    0x0303FFFF, 0x3F3FFBFB, 0xFDFD0606, 0xFFFF0202, 0x3EFD0000, 0x00000005, 0x3EFD0000, 0x00000005,
    0x0303FEFE, 0x4040F9F9, 0xFCFC0909, 0xFFFF0202, 0x3EFC0000, 0x00000006, 0x3EFC0000, 0x00000006,
    0x0404FEFE, 0x3F3FF8F8, 0xFBFB0B0B, 0xFEFE0303, 0x3CFC0000, 0x00000008, 0x3CFC0000, 0x00000008,
    0x0505FDFD, 0x3E3EF7F7, 0xFAFA0E0E, 0xFEFE0303, 0x3CFB0000, 0x0000FF0A, 0x3CFB0000, 0x0000FF0A,
    0x0505FDFD, 0x3D3DF5F5, 0xF9F91111, 0xFEFE0404, 0x39FB0000, 0x0000FF0D, 0x39FB0000, 0x0000FF0D,
    0x0606FDFD, 0x3B3BF5F5, 0xF8F81414, 0xFDFD0404, 0x37FB0000, 0x0000FF0F, 0x37FB0000, 0x0000FF0F,
    0x0606FCFC, 0x3B3BF4F4, 0xF7F71616, 0xFDFD0505, 0x35FB0000, 0x0000FF11, 0x35FB0000, 0x0000FF11,
    0x0707FCFC, 0x3939F3F3, 0xF6F61919, 0xFDFD0505, 0x33FB0000, 0x0000FE14, 0x33FB0000, 0x0000FE14,
    0x0707FCFC, 0x3737F3F3, 0xF5F51C1C, 0xFCFC0606, 0x31FB0000, 0x0000FE16, 0x31FB0000, 0x0000FE16,
    0x0707FCFC, 0x3535F2F2, 0xF5F51F1F, 0xFCFC0606, 0x2EFB0000, 0x0000FE19, 0x2EFB0000, 0x0000FE19,
    0x0707FCFC, 0x3232F2F2, 0xF4F42222, 0xFCFC0707, 0x2CFB0000, 0x0000FD1C, 0x2CFB0000, 0x0000FD1C,
    0x0707FCFC, 0x3030F2F2, 0xF3F32525, 0xFCFC0707, 0x29FB0000, 0x0000FD1F, 0x29FB0000, 0x0000FD1F,
    0x0707FCFC, 0x2D2DF2F2, 0xF3F32828, 0xFCFC0707, 0x27FC0000, 0x0000FC21, 0x27FC0000, 0x0000FC21,
    0x0707FCFC, 0x2929F3F3, 0xF3F32B2B, 0xFCFC0707, 0x24FC0000, 0x0000FC24, 0x24FC0000, 0x0000FC24,
    0x0707FCFC, 0x2828F3F3, 0xF2F22D2D, 0xFCFC0707, 0x21FC0000, 0x0000FC27, 0x21FC0000, 0x0000FC27,
    0x0707FCFC, 0x2525F3F3, 0xF2F23030, 0xFCFC0707, 0x1FFD0000, 0x0000FB29, 0x1FFD0000, 0x0000FB29,
    0x0707FCFC, 0x2222F4F4, 0xF2F23232, 0xFCFC0707, 0x1CFD0000, 0x0000FB2C, 0x1CFD0000, 0x0000FB2C,
    0x0606FCFC, 0x1F1FF5F5, 0xF2F23535, 0xFCFC0707, 0x19FE0000, 0x0000FB2E, 0x19FE0000, 0x0000FB2E,
    0x0606FCFC, 0x1C1CF5F5, 0xF3F33737, 0xFCFC0707, 0x16FE0000, 0x0000FB31, 0x16FE0000, 0x0000FB31,
    0x0505FDFD, 0x1919F6F6, 0xF3F33939, 0xFCFC0707, 0x14FE0000, 0x0000FB33, 0x14FE0000, 0x0000FB33,
    0x0505FDFD, 0x1616F7F7, 0xF4F43B3B, 0xFCFC0606, 0x11FF0000, 0x0000FB35, 0x11FF0000, 0x0000FB35,
    0x0404FDFD, 0x1414F8F8, 0xF5F53B3B, 0xFDFD0606, 0x0FFF0000, 0x0000FB37, 0x0FFF0000, 0x0000FB37,
    0x0404FEFE, 0x1111F9F9, 0xF5F53D3D, 0xFDFD0505, 0x0DFF0000, 0x0000FB39, 0x0DFF0000, 0x0000FB39,
    0x0303FEFE, 0x0E0EFAFA, 0xF7F73E3E, 0xFDFD0505, 0x0AFF0000, 0x0000FB3C, 0x0AFF0000, 0x0000FB3C,
    0x0303FEFE, 0x0B0BFBFB, 0xF8F83F3F, 0xFEFE0404, 0x08000000, 0x0000FC3C, 0x08000000, 0x0000FC3C,
    0x0202FFFF, 0x0909FCFC, 0xF9F94040, 0xFEFE0303, 0x06000000, 0x0000FC3E, 0x06000000, 0x0000FC3E,
    0x0202FFFF, 0x0606FDFD, 0xFBFB3F3F, 0xFFFF0303, 0x05000000, 0x0000FD3E, 0x05000000, 0x0000FD3E,
    0x0101FFFF, 0x0404FEFE, 0xFCFC4141, 0xFFFF0202, 0x03000000, 0x0000FE3F, 0x03000000, 0x0000FE3F,
    0x01010000, 0x0202FFFF, 0xFEFE4040, 0xFFFF0101, 0x01000000, 0x0000FF40, 0x01000000, 0x0000FF40,
};

const unsigned int intel_vp9_costlut_key[4096] = {
    0x02061200, 0x00000036, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x28190702, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00010002,
    0x050D2501, 0x0000006D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x38290E03, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00020004,
    0x050D2502, 0x0000006D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x38290E03, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00020004,
    0x050D2503, 0x0000006D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x38290E03, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00020004,
    0x06102E04, 0x00000088, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3A2B1904, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00020005,
    0x06102E05, 0x00000088, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3A2B1904, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00020005,
    0x07133706, 0x000000A3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3C2E1B05, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00030006,
    0x07133707, 0x000000A3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3C2E1B05, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00030006,
    0x07133708, 0x000000A3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3C2E1B05, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00030006,
    0x08164009, 0x000000BE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3E381D05, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00030007,
    0x0816400A, 0x000000BE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3E381D05, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00030007,
    0x0A1A4A0B, 0x000000DA, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x48391E06, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00040008,
    0x0A1A4A0C, 0x000000DA, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x48391E06, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00040008,
    0x0B1D530D, 0x000000F5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x493A2807, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00040009,
    0x0B1D530E, 0x000000F5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x493A2807, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00040009,
    0x0B1D530F, 0x000000F5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x493A2807, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00040009,
    0x0C205C10, 0x00000110, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4A3B2908, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0005000A,
    0x0C205C11, 0x00000110, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4A3B2908, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0005000A,
    0x0D236512, 0x0000012B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4B3C2A09, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0005000B,
    0x0D236513, 0x0000012B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4B3C2A09, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0005000B,
    0x0E266E14, 0x00000146, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4C3E2B09, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0006000C,
    0x0E266E15, 0x00000146, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4C3E2B09, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0006000C,
    0x102A7816, 0x00000162, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4D3F2C0A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0006000D,
    0x102A7817, 0x00000162, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4D3F2C0A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0006000D,
    0x102A7818, 0x00000162, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4D3F2C0A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0006000D,
    0x112D8119, 0x0000017D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4E482C0B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0007000E,
    0x112D811A, 0x0000017D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4E482C0B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0007000E,
    0x12308A1B, 0x00000198, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4F482D0C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0007000F,
    0x12308A1C, 0x00000198, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4F482D0C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0007000F,
    0x1333931D, 0x000001B3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x58492E0D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00080010,
    0x1333931E, 0x000001B3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x58492E0D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00080010,
    0x1333931F, 0x000001B3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x58492E0D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00080010,
    0x14369C20, 0x000001CE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x594A2F0D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00080011,
    0x14369C21, 0x000001CE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x594A2F0D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00080011,
    0x163AA622, 0x000001EA, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x594A380E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00090012,
    0x163AA623, 0x000001EA, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x594A380E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00090012,
    0x173DAF24, 0x00000205, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5A4B380F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00090013,
    0x173DAF25, 0x00000205, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5A4B380F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00090013,
    0x173DAF26, 0x00000205, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5A4B380F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00090013,
    0x1840B827, 0x00000220, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5A4B3918, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000A0014,
    0x1840B828, 0x00000220, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5A4B3918, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000A0014,
    0x1943C129, 0x0000023B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5B4C3918, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000A0015,
    0x1943C12A, 0x0000023B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5B4C3918, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000A0015,
    0x1943C12B, 0x0000023B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5B4C3918, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000A0015,
    0x1A46CA2C, 0x00000256, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5B4C3A19, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000B0016,
    0x1A46CA2D, 0x00000256, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5B4C3A19, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000B0016,
    0x1B49D32E, 0x00000271, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5C4D3A19, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000B0017,
    0x1B49D32F, 0x00000271, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5C4D3A19, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000B0017,
    0x1D4DDD30, 0x0000028D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5C4E3B1A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000C0018,
    0x1D4DDD31, 0x0000028D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5C4E3B1A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000C0018,
    0x1D4DDD32, 0x0000028D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5C4E3B1A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000C0018,
    0x1E50E633, 0x000002A8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5D4E3B1A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000C0019,
    0x1E50E634, 0x000002A8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5D4E3B1A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000C0019,
    0x1F53EF35, 0x000002C3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5D4F3B1A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000D001A,
    0x1F53EF36, 0x000002C3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5D4F3B1A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000D001A,
    0x1F53EF37, 0x000002C3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5D4F3B1A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000D001A,
    0x2056F838, 0x000002DE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5E4F3C1B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000D001B,
    0x2056F839, 0x000002DE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5E4F3C1B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000D001B,
    0x2159FF3A, 0x000002F9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5E583C1B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000E001C,
    0x2159FF3B, 0x000002F9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5E583C1B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000E001C,
    0x2159FF3C, 0x000002F9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5E583C1B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000E001C,
    0x235DFF3D, 0x00000315, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5F583D1C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000E001D,
    0x235DFF3E, 0x00000315, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5F583D1C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000E001D,
    0x2460FF3F, 0x00000330, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5F583D1C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000F001E,
    0x2460FF40, 0x00000330, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5F583D1C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000F001E,
    0x2563FF41, 0x0000034B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x68593E1C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000F001F,
    0x2563FF42, 0x0000034B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x68593E1C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000F001F,
    0x2563FF43, 0x0000034B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x68593E1C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000F001F,
    0x2666FF44, 0x00000366, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x68593E1D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00100020,
    0x2666FF45, 0x00000366, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x68593E1D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00100020,
    0x2769FF46, 0x00000381, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x68593F1D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00100021,
    0x2769FF47, 0x00000381, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x68593F1D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00100021,
    0x2769FF48, 0x00000381, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x68593F1D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00100021,
    0x296DFF49, 0x0000039D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x695A3F1E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00110022,
    0x296DFF4A, 0x0000039D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x695A3F1E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00110022,
    0x2A70FF4B, 0x000003B8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x695A3F1E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00110023,
    0x2A70FF4C, 0x000003B8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x695A3F1E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00110023,
    0x2A70FF4D, 0x000003B8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x695A3F1E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00110023,
    0x2B73FF4E, 0x000003D3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x695A481E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00120024,
    0x2B73FF4F, 0x000003D3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x695A481E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00120024,
    0x2C76FF50, 0x000003EE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x695A481F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00120025,
    0x2C76FF51, 0x000003EE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x695A481F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00120025,
    0x2C76FF52, 0x000003EE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x695A481F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00120025,
    0x2D79FF53, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6A5B481F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00130026,
    0x2D79FF54, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6A5B481F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00130026,
    0x2F7DFF55, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6A5B491F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00130027,
    0x2F7DFF56, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6A5B491F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00130027,
    0x2F7DFF57, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6A5B491F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00130027,
    0x3080FF58, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6A5B4928, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00140028,
    0x3080FF59, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6A5B4928, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00140028,
    0x3080FF5A, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6A5B4928, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00140028,
    0x3183FF5B, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6B5C4928, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00140029,
    0x3183FF5C, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6B5C4928, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00140029,
    0x3286FF5D, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6B5C4928, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0015002A,
    0x3286FF5E, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6B5C4928, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0015002A,
    0x3286FF5F, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6B5C4928, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0015002A,
    0x3389FF60, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6B5C4929, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0015002B,
    0x358DFF61, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6B5C4A29, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0016002C,
    0x3690FF62, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6C5D4A29, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0016002D,
    0x3793FF63, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6C5D4A29, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0017002E,
    0x3793FF64, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6C5D4A29, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0017002E,
    0x3896FF65, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6C5D4A29, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0017002F,
    0x3999FF66, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6C5D4B2A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00180030,
    0x3B9DFF67, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6D5E4B2A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00180031,
    0x3B9DFF68, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6D5E4B2A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00180031,
    0x3CA0FF69, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6D5E4B2A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00190032,
    0x3DA3FF6A, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6D5E4B2A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00190033,
    0x3EA6FF6B, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6D5F4B2A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001A0034,
    0x3EA6FF6C, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6D5F4B2A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001A0034,
    0x3FA9FF6D, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6E5F4C2A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001A0035,
    0x41ADFF6E, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6E5F4C2B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001B0036,
    0x42B0FF6F, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6E5F4C2B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001B0037,
    0x42B0FF70, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6E5F4C2B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001B0037,
    0x43B3FF71, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6E684C2B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C0038,
    0x44B6FF72, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6F684D2B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C0039,
    0x45B9FF73, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6F684D2B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001D003A,
    0x45B9FF74, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6F684D2B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001D003A,
    0x47BDFF75, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6F684D2C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001D003B,
    0x48C0FF76, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6F684D2C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001E003C,
    0x48C0FF77, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6F684D2C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001E003C,
    0x49C3FF78, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x78694D2C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001E003D,
    0x4AC6FF79, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x78694E2C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001F003E,
    0x4BC9FF7A, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x78694E2C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001F003F,
    0x4DCDFF7B, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x78694E2D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00200040,
    0x4ED0FF7C, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x78694E2D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00200041,
    0x50D6FF7D, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x79694F2D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00210043,
    0x51D9FF7E, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x796A4F2D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00220044,
    0x52DCFF7F, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x796A4F2E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00220045,
    0x54E0FF80, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x796A4F2E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00230046,
    0x55E3FF81, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x796A582E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00230047,
    0x56E6FF82, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x796A582E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00240048,
    0x57E9FF83, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x796A582E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00240049,
    0x58ECFF84, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x796A582F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0025004A,
    0x5AF0FF85, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7A6B582F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0025004B,
    0x5BF3FF86, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7A6B582F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0026004C,
    0x5CF6FF87, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7A6B582F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0026004D,
    0x5DF9FF88, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7A6B592F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0027004E,
    0x5EFCFF89, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7A6B5938, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0027004F,
    0x60FFFF8A, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7A6B5938, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00280050,
    0x62FFFF8B, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7B6C5938, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00290052,
    0x63FFFF8C, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7B6C5938, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00290053,
    0x64FFFF8D, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7B6C5938, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002A0054,
    0x67FFFF8E, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7B6C5938, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002B0056,
    0x68FFFF8F, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7B6C5A39, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002B0057,
    0x69FFFF90, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7B6C5A39, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002C0058,
    0x6CFFFF91, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7C6D5A39, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002D005A,
    0x6DFFFF92, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7C6D5A39, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002D005B,
    0x6EFFFF93, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7C6D5A39, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002E005C,
    0x6FFFFF94, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7C6D5A39, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002E005D,
    0x72FFFF95, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7C6D5A39, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002F005F,
    0x73FFFF96, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7C6D5B39, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00300060,
    0x74FFFF97, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7C6E5B3A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00300061,
    0x76FFFF98, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7D6E5B3A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00310063,
    0x79FFFF99, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7D6E5B3A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00320065,
    0x7AFFFF9A, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7D6E5B3A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00330066,
    0x7CFFFF9B, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7D6F5B3A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00340068,
    0x7EFFFF9C, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7D6F5C3A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00340069,
    0x80FFFF9D, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7E6F5C3B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0035006B,
    0x81FFFF9E, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7E6F5C3B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0036006C,
    0x83FFFF9F, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7E6F5C3B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0037006E,
    0x85FFFFA0, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7E785C3B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0037006F,
    0x87FFFFA1, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7E785C3B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00380071,
    0x89FFFFA2, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7F785D3B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00390073,
    0x8BFFFFA3, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7F785D3B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x003A0074,
    0x8DFFFFA4, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7F785D3C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x003B0076,
    0x8FFFFFA5, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7F785D3C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x003C0078,
    0x91FFFFA6, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x88785D3C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x003C0079,
    0x93FFFFA7, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x88795E3C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x003D007B,
    0x95FFFFA8, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x88795E3C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x003E007D,
    0x97FFFFA9, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x88795E3C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x003F007E,
    0x99FFFFAA, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x88795E3D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00400080,
    0x9BFFFFAB, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x88795E3D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00410082,
    0x9EFFFFAC, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x88795F3D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00420084,
    0xA0FFFFAD, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x89795F3D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00430086,
    0xA3FFFFAE, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x897A5F3D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00440088,
    0xA5FFFFAF, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x897A5F3E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0045008A,
    0xA7FFFFB0, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x897A5F3E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0046008C,
    0xAAFFFFB1, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x897A683E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0047008E,
    0xACFFFFB2, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x897A683E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00480090,
    0xAFFFFFB3, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x897A683E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00490092,
    0xB1FFFFB4, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x897A683F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x004A0094,
    0xB3FFFFB5, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8A7B683F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x004B0096,
    0xB6FFFFB6, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8A7B683F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x004C0098,
    0xB8FFFFB7, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8A7B683F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x004D009A,
    0xBAFFFFB8, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8A7B693F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x004E009C,
    0xBDFFFFB9, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8A7B693F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x004F009E,
    0xC0FFFFBA, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8A7B6948, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005000A1,
    0xC3FFFFBB, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8A7B6948, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005100A3,
    0xC5FFFFBC, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8B7C6948, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005200A5,
    0xC8FFFFBD, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8B7C6948, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005300A7,
    0xCBFFFFBE, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8B7C6948, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005500AA,
    0xCEFFFFBF, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8B7C6948, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005600AC,
    0xD0FFFFC0, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8B7C6A49, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005700AE,
    0xD4FFFFC1, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8B7C6A49, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005800B1,
    0xD6FFFFC2, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8B7D6A49, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005900B3,
    0xDAFFFFC3, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8C7D6A49, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005B00B6,
    0xDCFFFFC4, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8C7D6A49, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005C00B8,
    0xE0FFFFC5, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8C7D6A49, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005D00BB,
    0xE2FFFFC6, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8C7D6A49, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x005E00BD,
    0xE6FFFFC7, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8C7D6B49, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006000C0,
    0xE8FFFFC8, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8C7E6B4A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006100C2,
    0xEBFFFFC9, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8D7E6B4A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006200C5,
    0xEFFFFFCA, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8D7E6B4A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006400C8,
    0xF3FFFFCB, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8D7E6B4A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006500CB,
    0xF5FFFFCC, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8D7E6B4A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006600CD,
    0xF9FFFFCD, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8D7F6B4A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006800D0,
    0xFCFFFFCE, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8E7F6C4A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006900D3,
    0xFFFFFFCF, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8E7F6C4A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006B00D6,
    0xFFFFFFD0, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8E7F6C4B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006C00D9,
    0xFFFFFFD1, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8E7F6C4B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006E00DC,
    0xFFFFFFD2, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8E886C4B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006F00DF,
    0xFFFFFFD3, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F886C4B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x007100E3,
    0xFFFFFFD4, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F886D4B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x007300E6,
    0xFFFFFFD5, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F886D4B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x007400E9,
    0xFFFFFFD6, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F886D4C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x007600ED,
    0xFFFFFFD7, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F886D4C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x007800F1,
    0xFFFFFFD8, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F896D4C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x007A00F4,
    0xFFFFFFD9, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F896E4C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x007C00F8,
    0xFFFFFFDA, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F896E4C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x007E00FC,
    0xFFFFFFDB, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F896E4D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00800100,
    0xFFFFFFDC, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F896E4D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00820105,
    0xFFFFFFDD, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F896F4D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00840109,
    0xFFFFFFDE, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F896F4D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0086010D,
    0xFFFFFFDF, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8A6F4D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00890112,
    0xFFFFFFE0, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8A6F4E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x008B0117,
    0xFFFFFFE1, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8A784E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x008E011C,
    0xFFFFFFE2, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8A784E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00900121,
    0xFFFFFFE3, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8A784E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00930127,
    0xFFFFFFE4, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8B784F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0096012D,
    0xFFFFFFE5, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8B784F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00990133,
    0xFFFFFFE6, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8B794F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x009C0139,
    0xFFFFFFE7, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8B7958, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00A00140,
    0xFFFFFFE8, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8B7958, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00A30147,
    0xFFFFFFE9, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8C7958, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00A7014E,
    0xFFFFFFEA, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8C7958, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00AB0156,
    0xFFFFFFEB, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8C7A59, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00AF015E,
    0xFFFFFFEC, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8D7A59, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00B30166,
    0xFFFFFFED, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8D7A59, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00B80170,
    0xFFFFFFEE, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8D7A59, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00BC0179,
    0xFFFFFFEF, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8E7B59, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00C10183,
    0xFFFFFFF0, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8E7B5A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00C7018E,
    0xFFFFFFF1, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8E7B5A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00CC0199,
    0xFFFFFFF2, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8F7C5A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00D201A5,
    0xFFFFFFF3, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8F7C5B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00D901B2,
    0xFFFFFFF4, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8F7C5B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00E001C0,
    0xFFFFFFF5, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8F7D5B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00E701CE,
    0xFFFFFFF6, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8F7D5C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00EE01DD,
    0xFFFFFFF7, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8F7E5C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00F701EE,
    0xFFFFFFF8, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8F7E5C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FF01FF,
    0xFFFFFFF9, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8F7F5D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01080211,
    0xFFFFFFFA, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8F7F5D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01120225,
    0xFFFFFFFB, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8F885E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x011C0239,
    0xFFFFFFFC, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8F885E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01280250,
    0xFFFFFFFD, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8F885F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01340268,
    0xFFFFFFFE, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8F8968, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01400281,
    0xFFFFFFFF, 0x000003FF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8F8F8968, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x014E029C,
};

const unsigned int intel_vp9_costlut_p[4096] = {
    0x040C2400, 0x00000010, 0x00010001, 0x00010000, 0x00010000, 0x00020002, 0x00030002, 0x00040003, 0x02020100, 0x04030302, 0x39070402, 0x6F6F0103, 0x00010001, 0x00000000, 0x00000004, 0x00010004,
    0x08184801, 0x00000001, 0x00020002, 0x00020001, 0x00020000, 0x00040003, 0x00060005, 0x00080007, 0x04030200, 0x08070605, 0x490D0903, 0x6F6F0305, 0x00020001, 0x00000000, 0x00000008, 0x00020008,
    0x08184802, 0x00000000, 0x00020002, 0x00020001, 0x00020000, 0x00040003, 0x00060005, 0x00080007, 0x04030200, 0x08070605, 0x490D0903, 0x6F6F0305, 0x00020001, 0x00000000, 0x00000008, 0x00020008,
    0x091B5103, 0x00000000, 0x00020002, 0x00020001, 0x00020000, 0x00040003, 0x00060005, 0x00080007, 0x04030200, 0x08070605, 0x4A0F0A04, 0x6F6F0305, 0x00020001, 0x00000000, 0x00000008, 0x00020009,
    0x0A1E5A04, 0x00000000, 0x00020002, 0x00020001, 0x00020000, 0x00040003, 0x00060005, 0x00080007, 0x04030200, 0x08070605, 0x4B180B04, 0x6F6F0305, 0x00020001, 0x00000000, 0x00000008, 0x0002000A,
    0x0B216305, 0x00000000, 0x00020002, 0x00020001, 0x00020000, 0x00040003, 0x00060005, 0x00080007, 0x04030200, 0x08070605, 0x4D190C04, 0x6F6F0305, 0x00020001, 0x00000000, 0x00000008, 0x0002000B,
    0x0C246C06, 0x00000000, 0x00020004, 0x00030001, 0x00040000, 0x00060005, 0x00080007, 0x000C000A, 0x06050400, 0x0C0A0807, 0x4E1A0D05, 0x6F6F0408, 0x00030002, 0x00000000, 0x0000000C, 0x0003000C,
    0x0C246C07, 0x00000000, 0x00020004, 0x00030001, 0x00040000, 0x00060005, 0x00080007, 0x000C000A, 0x06050400, 0x0C0A0807, 0x4E1A0D05, 0x6F6F0408, 0x00030002, 0x00000000, 0x0000000C, 0x0003000C,
    0x0D277508, 0x00000000, 0x00020004, 0x00030001, 0x00040000, 0x00060005, 0x00080007, 0x000C000A, 0x06050400, 0x0C0A0807, 0x4F1B0E05, 0x6F6F0408, 0x00030002, 0x00000000, 0x0000000C, 0x0003000D,
    0x0E2A7E09, 0x00000000, 0x00020004, 0x00030001, 0x00040000, 0x00060005, 0x00080007, 0x000C000A, 0x06050400, 0x0C0A0807, 0x581C0F05, 0x6F6F0408, 0x00030002, 0x00000000, 0x0000000C, 0x0003000E,
    0x0F2D870A, 0x00000000, 0x00020004, 0x00030001, 0x00040000, 0x00060005, 0x00080007, 0x000C000A, 0x06050400, 0x0C0A0807, 0x591D1806, 0x6F6F0408, 0x00030002, 0x00000000, 0x0000000C, 0x0003000F,
    0x1030900B, 0x00000000, 0x00030005, 0x00040002, 0x00050000, 0x00080006, 0x000B000A, 0x0010000D, 0x08060500, 0x180D0B0A, 0x591D1906, 0x6F6F050B, 0x00040002, 0x00000000, 0x00000010, 0x00040010,
    0x1133990C, 0x00000000, 0x00030005, 0x00040002, 0x00050000, 0x00080006, 0x000B000A, 0x0010000D, 0x08060500, 0x180D0B0A, 0x5A1E1A07, 0x6F6F050B, 0x00040002, 0x00000000, 0x00000010, 0x00040011,
    0x1236A20D, 0x00000000, 0x00030005, 0x00040002, 0x00050000, 0x00080006, 0x000B000A, 0x0010000D, 0x08060500, 0x180D0B0A, 0x5A1F1A07, 0x6F6F050B, 0x00040002, 0x00000000, 0x00000010, 0x00040012,
    0x1339AB0E, 0x00000000, 0x00030005, 0x00040002, 0x00050000, 0x00080006, 0x000B000A, 0x0010000D, 0x08060500, 0x180D0B0A, 0x5B281B07, 0x6F6F050B, 0x00040002, 0x00000000, 0x00000010, 0x00040013,
    0x1339AB0F, 0x00000000, 0x00030005, 0x00040002, 0x00050000, 0x00080006, 0x000B000A, 0x0010000D, 0x08060500, 0x180D0B0A, 0x5B281B07, 0x6F6F050B, 0x00040002, 0x00000000, 0x00000010, 0x00040013,
    0x143CB410, 0x00000000, 0x00040006, 0x00050002, 0x00060000, 0x000A0008, 0x000E000C, 0x00140011, 0x0A080600, 0x1A190E0C, 0x5B281B08, 0x6F6F070E, 0x00050003, 0x00000000, 0x00000014, 0x00050014,
    0x153FBD11, 0x00000000, 0x00040006, 0x00050002, 0x00060000, 0x000A0008, 0x000E000C, 0x00140011, 0x0A080600, 0x1A190E0C, 0x5C291C08, 0x6F6F070E, 0x00050003, 0x00000000, 0x00000014, 0x00050015,
    0x1642C612, 0x00000000, 0x00040006, 0x00050002, 0x00060000, 0x000A0008, 0x000E000C, 0x00140011, 0x0A080600, 0x1A190E0C, 0x5D291C09, 0x6F6F070E, 0x00050003, 0x00000000, 0x00000014, 0x00050016,
    0x1745CF13, 0x00000000, 0x00040006, 0x00050002, 0x00060000, 0x000A0008, 0x000E000C, 0x00140011, 0x0A080600, 0x1A190E0C, 0x5D2A1D09, 0x6F6F070E, 0x00050003, 0x00000000, 0x00000014, 0x00050017,
    0x1848D814, 0x00000000, 0x00050007, 0x00060002, 0x00070000, 0x000C0009, 0x0011000F, 0x00170014, 0x0C090700, 0x1C1A190F, 0x5E2A1D09, 0x6F6F0818, 0x00060003, 0x00000000, 0x00000017, 0x00060018,
    0x194BE115, 0x00000000, 0x00050007, 0x00060002, 0x00070000, 0x000C0009, 0x0011000F, 0x00170014, 0x0C090700, 0x1C1A190F, 0x5E2A1E0A, 0x6F6F0818, 0x00060003, 0x00000000, 0x00000017, 0x00060019,
    0x1A4EEA16, 0x00000000, 0x00050007, 0x00060002, 0x00070000, 0x000C0009, 0x0011000F, 0x00170014, 0x0C090700, 0x1C1A190F, 0x5F2B1E0A, 0x6F6F0818, 0x00060003, 0x00000000, 0x00000017, 0x0006001A,
    0x1A4EEA17, 0x00000000, 0x00050007, 0x00060002, 0x00070000, 0x000C0009, 0x0011000F, 0x00170014, 0x0C090700, 0x1C1A190F, 0x5F2B1E0A, 0x6F6F0818, 0x00060003, 0x00000000, 0x00000017, 0x0006001A,
    0x1B51F318, 0x00000000, 0x00050007, 0x00060002, 0x00070000, 0x000C0009, 0x0011000F, 0x00170014, 0x0C090700, 0x1C1A190F, 0x5F2B1F0B, 0x6F6F0818, 0x00060003, 0x00000000, 0x00000017, 0x0006001B,
    0x1C54FC19, 0x00000000, 0x00050008, 0x00070003, 0x00080000, 0x000E000B, 0x00140011, 0x001B0017, 0x0E0B0800, 0x1E1C1A19, 0x682C280B, 0x6F6F0A1A, 0x00070004, 0x00000000, 0x0000001B, 0x0007001C,
    0x1D57FF1A, 0x00000000, 0x00050008, 0x00070003, 0x00080000, 0x000E000B, 0x00140011, 0x001B0017, 0x0E0B0800, 0x1E1C1A19, 0x682C280B, 0x6F6F0A1A, 0x00070004, 0x00000000, 0x0000001B, 0x0007001D,
    0x1E5AFF1B, 0x00000000, 0x00050008, 0x00070003, 0x00080000, 0x000E000B, 0x00140011, 0x001B0017, 0x0E0B0800, 0x1E1C1A19, 0x692C280C, 0x6F6F0A1A, 0x00070004, 0x00000000, 0x0000001B, 0x0007001E,
    0x1F5DFF1C, 0x00000000, 0x00050008, 0x00070003, 0x00080000, 0x000E000B, 0x00140011, 0x001B0017, 0x0E0B0800, 0x1E1C1A19, 0x692D290C, 0x6F6F0A1A, 0x00070004, 0x00000000, 0x0000001B, 0x0007001F,
    0x2060FF1D, 0x00000000, 0x00060009, 0x00080003, 0x00090000, 0x0010000D, 0x00170013, 0x001F001B, 0x180D0900, 0x281E1C1A, 0x692D290D, 0x6F6F0B1B, 0x00080004, 0x00000000, 0x0000001F, 0x00080020,
    0x2060FF1E, 0x00000000, 0x00060009, 0x00080003, 0x00090000, 0x0010000D, 0x00170013, 0x001F001B, 0x180D0900, 0x281E1C1A, 0x692D290D, 0x6F6F0B1B, 0x00080004, 0x00000000, 0x0000001F, 0x00080020,
    0x2163FF1F, 0x00000000, 0x00060009, 0x00080003, 0x00090000, 0x0010000D, 0x00170013, 0x001F001B, 0x180D0900, 0x281E1C1A, 0x692E290D, 0x6F6F0B1B, 0x00080004, 0x00000000, 0x0000001F, 0x00080021,
    0x2266FF20, 0x00000000, 0x00060009, 0x00080003, 0x00090000, 0x0010000D, 0x00170013, 0x001F001B, 0x180D0900, 0x281E1C1A, 0x6A2E290D, 0x6F6F0B1B, 0x00080004, 0x00000000, 0x0000001F, 0x00080022,
    0x2369FF21, 0x00000000, 0x00060009, 0x00080003, 0x00090000, 0x0010000D, 0x00170013, 0x001F001B, 0x180D0900, 0x281E1C1A, 0x6A2E2A0E, 0x6F6F0B1B, 0x00080004, 0x00000000, 0x0000001F, 0x00080023,
    0x246CFF22, 0x00000000, 0x0007000B, 0x00090004, 0x000B0000, 0x0012000E, 0x00190016, 0x0023001E, 0x190E0B00, 0x291F1D1B, 0x6A2F2A0E, 0x6F6F0C1D, 0x00090005, 0x00000000, 0x00000023, 0x00090024,
    0x256FFF23, 0x00000000, 0x0007000B, 0x00090004, 0x000B0000, 0x0012000E, 0x00190016, 0x0023001E, 0x190E0B00, 0x291F1D1B, 0x6B2F2A0E, 0x6F6F0C1D, 0x00090005, 0x00000000, 0x00000023, 0x00090025,
    0x2672FF24, 0x00000000, 0x0007000B, 0x00090004, 0x000B0000, 0x0012000E, 0x00190016, 0x0023001E, 0x190E0B00, 0x291F1D1B, 0x6B382B0F, 0x6F6F0C1D, 0x00090005, 0x00000000, 0x00000023, 0x00090026,
    0x2672FF25, 0x00000000, 0x0007000B, 0x00090004, 0x000B0000, 0x0012000E, 0x00190016, 0x0023001E, 0x190E0B00, 0x291F1D1B, 0x6B382B0F, 0x6F6F0C1D, 0x00090005, 0x00000000, 0x00000023, 0x00090026,
    0x2775FF26, 0x00000000, 0x0007000B, 0x00090004, 0x000B0000, 0x0012000E, 0x00190016, 0x0023001E, 0x190E0B00, 0x291F1D1B, 0x6B382B0F, 0x6F6F0C1D, 0x00090005, 0x00000000, 0x00000023, 0x00090027,
    0x2878FF27, 0x00000000, 0x0008000C, 0x000A0004, 0x000C0000, 0x00140010, 0x001C0018, 0x00270021, 0x1A180C00, 0x2A281E1C, 0x6B382B18, 0x6F6F0E1E, 0x000A0005, 0x00000000, 0x00000027, 0x000A0028,
    0x297BFF28, 0x00000000, 0x0008000C, 0x000A0004, 0x000C0000, 0x00140010, 0x001C0018, 0x00270021, 0x1A180C00, 0x2A281E1C, 0x6C382B18, 0x6F6F0E1E, 0x000A0005, 0x00000000, 0x00000027, 0x000A0029,
    0x2A7EFF29, 0x00000000, 0x0008000C, 0x000A0004, 0x000C0000, 0x00140010, 0x001C0018, 0x00270021, 0x1A180C00, 0x2A281E1C, 0x6C392C18, 0x6F6F0E1E, 0x000A0005, 0x00000000, 0x00000027, 0x000A002A,
    0x2B81FF2A, 0x00000000, 0x0008000C, 0x000A0004, 0x000C0000, 0x00140010, 0x001C0018, 0x00270021, 0x1A180C00, 0x2A281E1C, 0x6C392C19, 0x6F6F0E1E, 0x000A0005, 0x00000000, 0x00000027, 0x000A002B,
    0x2B81FF2B, 0x00000000, 0x0008000C, 0x000A0004, 0x000C0000, 0x00140010, 0x001C0018, 0x00270021, 0x1A180C00, 0x2A281E1C, 0x6C392C19, 0x6F6F0E1E, 0x000A0005, 0x00000000, 0x00000027, 0x000A002B,
    0x2C84FF2C, 0x00000000, 0x0009000D, 0x000B0004, 0x000D0000, 0x00160011, 0x001F001B, 0x002B0025, 0x1B190D00, 0x2B29281E, 0x6D392C19, 0x6F6F0F1F, 0x000B0006, 0x00000000, 0x0000002B, 0x000B002C,
    0x2D87FF2D, 0x00000000, 0x0009000D, 0x000B0004, 0x000D0000, 0x00160011, 0x001F001B, 0x002B0025, 0x1B190D00, 0x2B29281E, 0x6D392C19, 0x6F6F0F1F, 0x000B0006, 0x00000000, 0x0000002B, 0x000B002D,
    0x2E8AFF2E, 0x00000000, 0x0009000D, 0x000B0004, 0x000D0000, 0x00160011, 0x001F001B, 0x002B0025, 0x1B190D00, 0x2B29281E, 0x6D392D19, 0x6F6F0F1F, 0x000B0006, 0x00000000, 0x0000002B, 0x000B002E,
    0x2F8DFF2F, 0x00000000, 0x0009000D, 0x000B0004, 0x000D0000, 0x00160011, 0x001F001B, 0x002B0025, 0x1B190D00, 0x2B29281E, 0x6D3A2D19, 0x6F6F0F1F, 0x000B0006, 0x00000000, 0x0000002B, 0x000B002F,
    0x3090FF30, 0x00000000, 0x0009000E, 0x000C0005, 0x000E0000, 0x00180013, 0x0022001D, 0x002F0028, 0x1C1A0E00, 0x2C2A291F, 0x6E3A2D1A, 0x6F6F1828, 0x000C0007, 0x00000000, 0x0000002F, 0x000C0030,
    0x3090FF31, 0x00000000, 0x0009000E, 0x000C0005, 0x000E0000, 0x00180013, 0x0022001D, 0x002F0028, 0x1C1A0E00, 0x2C2A291F, 0x6E3A2D1A, 0x6F6F1828, 0x000C0007, 0x00000000, 0x0000002F, 0x000C0030,
    0x3193FF32, 0x00000000, 0x0009000E, 0x000C0005, 0x000E0000, 0x00180013, 0x0022001D, 0x002F0028, 0x1C1A0E00, 0x2C2A291F, 0x6E3A2E1A, 0x6F6F1828, 0x000C0007, 0x00000000, 0x0000002F, 0x000C0031,
    0x3296FF33, 0x00000000, 0x0009000E, 0x000C0005, 0x000E0000, 0x00180013, 0x0022001D, 0x002F0028, 0x1C1A0E00, 0x2C2A291F, 0x6E3A2E1A, 0x6F6F1828, 0x000C0007, 0x00000000, 0x0000002F, 0x000C0032,
    0x3399FF34, 0x00000000, 0x0009000E, 0x000C0005, 0x000E0000, 0x00180013, 0x0022001D, 0x002F0028, 0x1C1A0E00, 0x2C2A291F, 0x6F3B2E1A, 0x6F6F1828, 0x000C0007, 0x00000000, 0x0000002F, 0x000C0033,
    0x349CFF35, 0x00000000, 0x000A000F, 0x000D0005, 0x000F0000, 0x001A0014, 0x0025001F, 0x0033002B, 0x1D1A0F00, 0x2D2B2928, 0x6F3B2E1A, 0x6F6F1929, 0x000D0007, 0x00000000, 0x00000033, 0x000D0034,
    0x359FFF36, 0x00000000, 0x000A000F, 0x000D0005, 0x000F0000, 0x001A0014, 0x0025001F, 0x0033002B, 0x1D1A0F00, 0x2D2B2928, 0x6F3B2F1B, 0x6F6F1929, 0x000D0007, 0x00000000, 0x00000033, 0x000D0035,
    0x359FFF37, 0x00000000, 0x000A000F, 0x000D0005, 0x000F0000, 0x001A0014, 0x0025001F, 0x0033002B, 0x1D1A0F00, 0x2D2B2928, 0x6F3B2F1B, 0x6F6F1929, 0x000D0007, 0x00000000, 0x00000033, 0x000D0035,
    0x36A2FF38, 0x00000000, 0x000A000F, 0x000D0005, 0x000F0000, 0x001A0014, 0x0025001F, 0x0033002B, 0x1D1A0F00, 0x2D2B2928, 0x6F3B2F1B, 0x6F6F1929, 0x000D0007, 0x00000000, 0x00000033, 0x000D0036,
    0x37A5FF39, 0x00000000, 0x000A000F, 0x000D0005, 0x000F0000, 0x001A0014, 0x0025001F, 0x0033002B, 0x1D1A0F00, 0x2D2B2928, 0x783B2F1B, 0x6F6F1929, 0x000D0007, 0x00000000, 0x00000033, 0x000D0037,
    0x38A8FF3A, 0x00000000, 0x000B0010, 0x000E0005, 0x00100000, 0x001C0016, 0x00270022, 0x0037002E, 0x1E1B1800, 0x2E2C2A29, 0x783C2F1B, 0x6F6F1A2A, 0x000E0008, 0x00000000, 0x00000037, 0x000E0038,
    0x39ABFF3B, 0x00000000, 0x000B0010, 0x000E0005, 0x00100000, 0x001C0016, 0x00270022, 0x0037002E, 0x1E1B1800, 0x2E2C2A29, 0x783C381B, 0x6F6F1A2A, 0x000E0008, 0x00000000, 0x00000037, 0x000E0039,
    0x39ABFF3C, 0x00000000, 0x000B0010, 0x000E0005, 0x00100000, 0x001C0016, 0x00270022, 0x0037002E, 0x1E1B1800, 0x2E2C2A29, 0x783C381B, 0x6F6F1A2A, 0x000E0008, 0x00000000, 0x00000037, 0x000E0039,
    0x3AAEFF3D, 0x00000000, 0x000B0010, 0x000E0005, 0x00100000, 0x001C0016, 0x00270022, 0x0037002E, 0x1E1B1800, 0x2E2C2A29, 0x783C381C, 0x6F6F1A2A, 0x000E0008, 0x00000000, 0x00000037, 0x000E003A,
    0x3BB1FF3E, 0x00000000, 0x000B0010, 0x000E0005, 0x00100000, 0x001C0016, 0x00270022, 0x0037002E, 0x1E1B1800, 0x2E2C2A29, 0x783C381C, 0x6F6F1A2A, 0x000E0008, 0x00000000, 0x00000037, 0x000E003B,
    0x3CB4FF3F, 0x00000000, 0x000C0012, 0x000F0006, 0x00120000, 0x001E0017, 0x002A0024, 0x003B0032, 0x1F1C1900, 0x2F2D2B29, 0x793C381C, 0x6F6F1B2A, 0x000F0008, 0x00000000, 0x0000003B, 0x000F003C,
    0x3DB7FF40, 0x00000000, 0x000C0012, 0x000F0006, 0x00120000, 0x001E0017, 0x002A0024, 0x003B0032, 0x1F1C1900, 0x2F2D2B29, 0x793D381C, 0x6F6F1B2A, 0x000F0008, 0x00000000, 0x0000003B, 0x000F003D,
    0x3EBAFF41, 0x00000000, 0x000C0012, 0x000F0006, 0x00120000, 0x001E0017, 0x002A0024, 0x003B0032, 0x1F1C1900, 0x2F2D2B29, 0x793D391C, 0x6F6F1B2A, 0x000F0008, 0x00000000, 0x0000003B, 0x000F003E,
    0x3EBAFF42, 0x00000000, 0x000C0012, 0x000F0006, 0x00120000, 0x001E0017, 0x002A0024, 0x003B0032, 0x1F1C1900, 0x2F2D2B29, 0x793D391C, 0x6F6F1B2A, 0x000F0008, 0x00000000, 0x0000003B, 0x000F003E,
    0x3FBDFF43, 0x00000000, 0x000C0012, 0x000F0006, 0x00120000, 0x001E0017, 0x002A0024, 0x003B0032, 0x1F1C1900, 0x2F2D2B29, 0x793D391D, 0x6F6F1B2A, 0x000F0008, 0x00000000, 0x0000003B, 0x000F003F,
    0x40C0FF44, 0x00000000, 0x000D0013, 0x00100006, 0x00130000, 0x00210019, 0x002D0027, 0x003F0035, 0x281D1A00, 0x382D2B2A, 0x793D391D, 0x6F6F1B2B, 0x00180009, 0x00000000, 0x0000003F, 0x00100040,
    0x41C3FF45, 0x00000000, 0x000D0013, 0x00100006, 0x00130000, 0x00210019, 0x002D0027, 0x003F0035, 0x281D1A00, 0x382D2B2A, 0x793D391D, 0x6F6F1B2B, 0x00180009, 0x00000000, 0x0000003F, 0x00100041,
    0x42C6FF46, 0x00000000, 0x000D0013, 0x00100006, 0x00130000, 0x00210019, 0x002D0027, 0x003F0035, 0x281D1A00, 0x382D2B2A, 0x793E391D, 0x6F6F1B2B, 0x00180009, 0x00000000, 0x0000003F, 0x00100042,
    0x42C6FF47, 0x00000000, 0x000D0013, 0x00100006, 0x00130000, 0x00210019, 0x002D0027, 0x003F0035, 0x281D1A00, 0x382D2B2A, 0x793E391D, 0x6F6F1B2B, 0x00180009, 0x00000000, 0x0000003F, 0x00100042,
    0x43C9FF48, 0x00000000, 0x000D0013, 0x00100006, 0x00130000, 0x00210019, 0x002D0027, 0x003F0035, 0x281D1A00, 0x382D2B2A, 0x7A3E391D, 0x6F6F1B2B, 0x00180009, 0x00000000, 0x0000003F, 0x00100043,
    0x44CCFF49, 0x00000000, 0x000D0014, 0x00110007, 0x00140000, 0x0023001B, 0x00300029, 0x00420038, 0x291E1A00, 0x382E2C2A, 0x7A3E391E, 0x6F6F1C2C, 0x00190009, 0x00000000, 0x00000042, 0x00110044,
    0x45CFFF4A, 0x00000000, 0x000D0014, 0x00110007, 0x00140000, 0x0023001B, 0x00300029, 0x00420038, 0x291E1A00, 0x382E2C2A, 0x7A3E391E, 0x6F6F1C2C, 0x00190009, 0x00000000, 0x00000042, 0x00110045,
    0x46D2FF4B, 0x00000000, 0x000D0014, 0x00110007, 0x00140000, 0x0023001B, 0x00300029, 0x00420038, 0x291E1A00, 0x382E2C2A, 0x7A3E3A1E, 0x6F6F1C2C, 0x00190009, 0x00000000, 0x00000042, 0x00110046,
    0x46D2FF4C, 0x00000000, 0x000D0014, 0x00110007, 0x00140000, 0x0023001B, 0x00300029, 0x00420038, 0x291E1A00, 0x382E2C2A, 0x7A3E3A1E, 0x6F6F1C2C, 0x00190009, 0x00000000, 0x00000042, 0x00110046,
    0x47D5FF4D, 0x00000000, 0x000D0014, 0x00110007, 0x00140000, 0x0023001B, 0x00300029, 0x00420038, 0x291E1A00, 0x382E2C2A, 0x7A3F3A1E, 0x6F6F1C2C, 0x00190009, 0x00000000, 0x00000042, 0x00110047,
    0x48D8FF4E, 0x00000000, 0x000E0015, 0x00120007, 0x00150000, 0x0025001C, 0x0033002C, 0x0046003C, 0x291E1B00, 0x392F2D2B, 0x7A3F3A1E, 0x6F6F1D2C, 0x0019000A, 0x00000000, 0x00000046, 0x00120048,
    0x49DBFF4F, 0x00000000, 0x000E0015, 0x00120007, 0x00150000, 0x0025001C, 0x0033002C, 0x0046003C, 0x291E1B00, 0x392F2D2B, 0x7A3F3A1F, 0x6F6F1D2C, 0x0019000A, 0x00000000, 0x00000046, 0x00120049,
    0x4ADEFF50, 0x00000000, 0x000E0015, 0x00120007, 0x00150000, 0x0025001C, 0x0033002C, 0x0046003C, 0x291E1B00, 0x392F2D2B, 0x7B3F3A1F, 0x6F6F1D2C, 0x0019000A, 0x00000000, 0x00000046, 0x0012004A,
    0x4ADEFF51, 0x00000000, 0x000E0015, 0x00120007, 0x00150000, 0x0025001C, 0x0033002C, 0x0046003C, 0x291E1B00, 0x392F2D2B, 0x7B3F3A1F, 0x6F6F1D2C, 0x0019000A, 0x00000000, 0x00000046, 0x0012004A,
    0x4BE1FF52, 0x00000000, 0x000E0015, 0x00120007, 0x00150000, 0x0025001C, 0x0033002C, 0x0046003C, 0x291E1B00, 0x392F2D2B, 0x7B3F3A1F, 0x6F6F1D2C, 0x0019000A, 0x00000000, 0x00000046, 0x0012004B,
    0x4CE4FF53, 0x00000000, 0x000F0016, 0x00130007, 0x00160000, 0x0027001E, 0x0035002E, 0x004A003F, 0x2A1F1B00, 0x39382D2C, 0x7B483A1F, 0x6F6F1D2D, 0x001A000A, 0x00000000, 0x0000004A, 0x0013004C,
    0x4DE7FF54, 0x00000000, 0x000F0016, 0x00130007, 0x00160000, 0x0027001E, 0x0035002E, 0x004A003F, 0x2A1F1B00, 0x39382D2C, 0x7B483B1F, 0x6F6F1D2D, 0x001A000A, 0x00000000, 0x0000004A, 0x0013004D,
    0x4EEAFF55, 0x00000000, 0x000F0016, 0x00130007, 0x00160000, 0x0027001E, 0x0035002E, 0x004A003F, 0x2A1F1B00, 0x39382D2C, 0x7B483B1F, 0x6F6F1D2D, 0x001A000A, 0x00000000, 0x0000004A, 0x0013004E,
    0x4EEAFF56, 0x00000000, 0x000F0016, 0x00130007, 0x00160000, 0x0027001E, 0x0035002E, 0x004A003F, 0x2A1F1B00, 0x39382D2C, 0x7B483B1F, 0x6F6F1D2D, 0x001A000A, 0x00000000, 0x0000004A, 0x0013004E,
    0x4FEDFF57, 0x00000000, 0x000F0016, 0x00130007, 0x00160000, 0x0027001E, 0x0035002E, 0x004A003F, 0x2A1F1B00, 0x39382D2C, 0x7B483B28, 0x6F6F1D2D, 0x001A000A, 0x00000000, 0x0000004A, 0x0013004F,
    0x50F0FF58, 0x00000000, 0x00100017, 0x00140008, 0x00170000, 0x0029001F, 0x00380030, 0x004E0042, 0x2A281C00, 0x3A382E2C, 0x7B483B28, 0x6F6F1E2E, 0x001A000B, 0x00000000, 0x0000004E, 0x00140050,
    0x51F3FF59, 0x00000000, 0x00100017, 0x00140008, 0x00170000, 0x0029001F, 0x00380030, 0x004E0042, 0x2A281C00, 0x3A382E2C, 0x7C483B28, 0x6F6F1E2E, 0x001A000B, 0x00000000, 0x0000004E, 0x00140051,
    0x51F3FF5A, 0x00000000, 0x00100017, 0x00140008, 0x00170000, 0x0029001F, 0x00380030, 0x004E0042, 0x2A281C00, 0x3A382E2C, 0x7C483B28, 0x6F6F1E2E, 0x001A000B, 0x00000000, 0x0000004E, 0x00140051,
    0x52F6FF5B, 0x00000000, 0x00100017, 0x00140008, 0x00170000, 0x0029001F, 0x00380030, 0x004E0042, 0x2A281C00, 0x3A382E2C, 0x7C483B28, 0x6F6F1E2E, 0x001A000B, 0x00000000, 0x0000004E, 0x00140052,
    0x53F9FF5C, 0x00000000, 0x00100017, 0x00140008, 0x00170000, 0x0029001F, 0x00380030, 0x004E0042, 0x2A281C00, 0x3A382E2C, 0x7C493B28, 0x6F6F1E2E, 0x001A000B, 0x00000000, 0x0000004E, 0x00140053,
    0x54FCFF5D, 0x00000000, 0x00100019, 0x00150008, 0x00190000, 0x002B0021, 0x003B0033, 0x00520046, 0x2B281D00, 0x3A392F2D, 0x7C493C28, 0x6F6F1F2E, 0x001B000B, 0x00000000, 0x00000052, 0x00150054,
    0x55FFFF5E, 0x00000000, 0x00100019, 0x00150008, 0x00190000, 0x002B0021, 0x003B0033, 0x00520046, 0x2B281D00, 0x3A392F2D, 0x7C493C28, 0x6F6F1F2E, 0x001B000B, 0x00000000, 0x00000052, 0x00150055,
    0x55FFFF5F, 0x00000000, 0x00100019, 0x00150008, 0x00190000, 0x002B0021, 0x003B0033, 0x00520046, 0x2B281D00, 0x3A392F2D, 0x7C493C28, 0x6F6F1F2E, 0x001B000B, 0x00000000, 0x00000052, 0x00150055,
    0x57FFFF60, 0x00000000, 0x00100019, 0x00150008, 0x00190000, 0x002B0021, 0x003B0033, 0x00520046, 0x2B281D00, 0x3A392F2D, 0x7C493C29, 0x6F6F1F2E, 0x001B000B, 0x00000000, 0x00000052, 0x00150057,
    0x58FFFF61, 0x00000000, 0x0011001A, 0x00150009, 0x001A0000, 0x002D0022, 0x003E0035, 0x00560049, 0x2B291D00, 0x3B39382D, 0x7D493C29, 0x6F6F1F2F, 0x001B000C, 0x00000000, 0x00000056, 0x00160058,
    0x5AFFFF62, 0x00000000, 0x0011001A, 0x00150009, 0x001A0000, 0x002D0022, 0x003E0035, 0x00560049, 0x2B291D00, 0x3B39382D, 0x7D493C29, 0x6F6F1F2F, 0x001B000C, 0x00000000, 0x00000056, 0x0016005A,
    0x5CFFFF63, 0x00000000, 0x0012001B, 0x00160009, 0x001B0000, 0x002F0024, 0x00410038, 0x005A004C, 0x2C291E00, 0x3B3A382E, 0x7D493D29, 0x6F6F2838, 0x001B000D, 0x00000000, 0x0000005A, 0x0017005C,
    0x5DFFFF64, 0x00000000, 0x0012001B, 0x00160009, 0x001B0000, 0x002F0024, 0x00410038, 0x005A004C, 0x2C291E00, 0x3B3A382E, 0x7D4A3D29, 0x6F6F2838, 0x001B000D, 0x00000000, 0x0000005A, 0x0017005D,
    0x5FFFFF65, 0x00000000, 0x0012001B, 0x00160009, 0x001B0000, 0x002F0024, 0x00410038, 0x005A004C, 0x2C291E00, 0x3B3A382E, 0x7E4A3D29, 0x6F6F2838, 0x001B000D, 0x00000000, 0x0000005A, 0x0017005F,
    0x60FFFF66, 0x00000000, 0x0013001C, 0x00170009, 0x001C0000, 0x00310026, 0x0044003A, 0x005E0050, 0x2C2A1E00, 0x3C3A392F, 0x7E4A3D2A, 0x6F6F2838, 0x001C000D, 0x00000000, 0x0000005E, 0x00180060,
    0x62FFFF67, 0x00000000, 0x0013001C, 0x00170009, 0x001C0000, 0x00310026, 0x0044003A, 0x005E0050, 0x2C2A1E00, 0x3C3A392F, 0x7E4A3D2A, 0x6F6F2838, 0x001C000D, 0x00000000, 0x0000005E, 0x00180062,
    0x63FFFF68, 0x00000000, 0x0013001C, 0x00170009, 0x001C0000, 0x00310026, 0x0044003A, 0x005E0050, 0x2C2A1E00, 0x3C3A392F, 0x7E4A3E2A, 0x6F6F2838, 0x001C000D, 0x00000000, 0x0000005E, 0x00180063,
    0x65FFFF69, 0x00000000, 0x0014001D, 0x0018000A, 0x001D0000, 0x00330027, 0x0046003D, 0x00620053, 0x2D2A1F00, 0x3C3A392F, 0x7E4A3E2A, 0x6F6F2939, 0x001C000E, 0x00000000, 0x00000062, 0x00190065,
    0x66FFFF6A, 0x00000000, 0x0014001D, 0x0018000A, 0x001D0000, 0x00330027, 0x0046003D, 0x00620053, 0x2D2A1F00, 0x3C3A392F, 0x7E4A3E2A, 0x6F6F2939, 0x001C000E, 0x00000000, 0x00000062, 0x00190066,
    0x68FFFF6B, 0x00000000, 0x0014001E, 0x0019000A, 0x001E0000, 0x00350029, 0x0049003F, 0x00660056, 0x2D2A1F00, 0x3D3B3938, 0x7F4B3E2A, 0x6F6F2939, 0x001D000E, 0x00000000, 0x00000066, 0x001A0068,
    0x69FFFF6C, 0x00000000, 0x0014001E, 0x0019000A, 0x001E0000, 0x00350029, 0x0049003F, 0x00660056, 0x2D2A1F00, 0x3D3B3938, 0x7F4B3E2A, 0x6F6F2939, 0x001D000E, 0x00000000, 0x00000066, 0x001A0069,
    0x6BFFFF6D, 0x00000000, 0x0014001E, 0x0019000A, 0x001E0000, 0x00350029, 0x0049003F, 0x00660056, 0x2D2A1F00, 0x3D3B3938, 0x7F4B3F2B, 0x6F6F2939, 0x001D000E, 0x00000000, 0x00000066, 0x001A006B,
    0x6CFFFF6E, 0x00000000, 0x00150020, 0x001A000B, 0x00200000, 0x0037002A, 0x004C0041, 0x0069005A, 0x2E2B2800, 0x3D3B3A38, 0x7F4B3F2B, 0x6F6F2939, 0x001D000F, 0x00000000, 0x00000069, 0x001B006C,
    0x6EFFFF6F, 0x00000000, 0x00150020, 0x001A000B, 0x00200000, 0x0037002A, 0x004C0041, 0x0069005A, 0x2E2B2800, 0x3D3B3A38, 0x884B3F2B, 0x6F6F2939, 0x001D000F, 0x00000000, 0x00000069, 0x001B006E,
    0x6FFFFF70, 0x00000000, 0x00150020, 0x001A000B, 0x00200000, 0x0037002A, 0x004C0041, 0x0069005A, 0x2E2B2800, 0x3D3B3A38, 0x884B3F2B, 0x6F6F2939, 0x001D000F, 0x00000000, 0x00000069, 0x001B006F,
    0x71FFFF71, 0x00000000, 0x00160021, 0x001B000B, 0x00210000, 0x0039002C, 0x004F0044, 0x006D005D, 0x2E2B2800, 0x3E3C3A39, 0x884C482B, 0x6F6F2A3A, 0x001E000F, 0x00000000, 0x0000006D, 0x001C0071,
    0x72FFFF72, 0x00000000, 0x00160021, 0x001B000B, 0x00210000, 0x0039002C, 0x004F0044, 0x006D005D, 0x2E2B2800, 0x3E3C3A39, 0x884C482B, 0x6F6F2A3A, 0x001E000F, 0x00000000, 0x0000006D, 0x001C0072,
    0x74FFFF73, 0x00000000, 0x00170022, 0x001C000B, 0x00220000, 0x003B002D, 0x00520046, 0x00710060, 0x2F2B2900, 0x3E3C3A39, 0x884C482B, 0x6F6F2A3A, 0x001E0018, 0x00000000, 0x00000071, 0x001D0074,
    0x75FFFF74, 0x00000000, 0x00170022, 0x001C000B, 0x00220000, 0x003B002D, 0x00520046, 0x00710060, 0x2F2B2900, 0x3E3C3A39, 0x884C482C, 0x6F6F2A3A, 0x001E0018, 0x00000000, 0x00000071, 0x001D0075,
    0x76FFFF75, 0x00000000, 0x00170022, 0x001C000B, 0x00220000, 0x003B002D, 0x00520046, 0x00710060, 0x2F2B2900, 0x3E3C3A39, 0x884C482C, 0x6F6F2A3A, 0x001E0018, 0x00000000, 0x00000071, 0x001D0076,
    0x78FFFF76, 0x00000000, 0x00170023, 0x001D000C, 0x00230000, 0x003D002F, 0x00540049, 0x00750064, 0x2F2C2900, 0x3F3D3B39, 0x894C482C, 0x6F6F2A3A, 0x001F0018, 0x00000000, 0x00000075, 0x001E0078,
    0x79FFFF77, 0x00000000, 0x00170023, 0x001D000C, 0x00230000, 0x003D002F, 0x00540049, 0x00750064, 0x2F2C2900, 0x3F3D3B39, 0x894C482C, 0x6F6F2A3A, 0x001F0018, 0x00000000, 0x00000075, 0x001E0079,
    0x7BFFFF78, 0x00000000, 0x00170023, 0x001D000C, 0x00230000, 0x003D002F, 0x00540049, 0x00750064, 0x2F2C2900, 0x3F3D3B39, 0x894D482C, 0x6F6F2A3A, 0x001F0018, 0x00000000, 0x00000075, 0x001E007B,
    0x7DFFFF79, 0x00000000, 0x00180024, 0x001E000C, 0x00240000, 0x003F0030, 0x0057004B, 0x00790067, 0x382C2900, 0x3F3D3B39, 0x894D492C, 0x6F6F2B3B, 0x001F0019, 0x00000000, 0x00000079, 0x001F007D,
    0x7FFFFF7A, 0x00000000, 0x00180024, 0x001E000C, 0x00240000, 0x003F0030, 0x0057004B, 0x00790067, 0x382C2900, 0x3F3D3B39, 0x894D492D, 0x6F6F2B3B, 0x001F0019, 0x00000000, 0x00000079, 0x001F007F,
    0x81FFFF7B, 0x00000000, 0x00190026, 0x001F000D, 0x00260000, 0x00410032, 0x005A004E, 0x007D006A, 0x382D2A00, 0x483D3B3A, 0x894D492D, 0x6F6F2B3B, 0x00280019, 0x00000000, 0x0000007D, 0x00200081,
    0x83FFFF7C, 0x00000000, 0x00190026, 0x001F000D, 0x00260000, 0x00410032, 0x005A004E, 0x007D006A, 0x382D2A00, 0x483D3B3A, 0x894D492D, 0x6F6F2B3B, 0x00280019, 0x00000000, 0x0000007D, 0x00200083,
    0x86FFFF7D, 0x00000000, 0x001A0027, 0x0020000D, 0x00270000, 0x00430034, 0x005D0050, 0x0081006E, 0x382D2A00, 0x483E3C3A, 0x8A4E492D, 0x6F6F2B3B, 0x00280019, 0x00000000, 0x00000081, 0x00210086,
    0x88FFFF7E, 0x00000000, 0x001B0028, 0x0021000D, 0x00280000, 0x00450035, 0x00600052, 0x00850071, 0x392D2A00, 0x483E3C3A, 0x8A4E492D, 0x6F6F2C3C, 0x0028001A, 0x00000000, 0x00000085, 0x00220088,
    0x8AFFFF7F, 0x00000000, 0x001B0028, 0x0021000D, 0x00280000, 0x00450035, 0x00600052, 0x00850071, 0x392D2A00, 0x483E3C3A, 0x8A4E492E, 0x6F6F2C3C, 0x0028001A, 0x00000000, 0x00000085, 0x0022008A,
    0x8CFFFF80, 0x00000000, 0x001B0029, 0x0022000E, 0x00290000, 0x00470037, 0x00620055, 0x00890074, 0x392E2A00, 0x493F3C3B, 0x8A4E4A2E, 0x6F6F2C3C, 0x0029001A, 0x00000000, 0x00000089, 0x0023008C,
    0x8EFFFF81, 0x00000000, 0x001B0029, 0x0022000E, 0x00290000, 0x00470037, 0x00620055, 0x00890074, 0x392E2A00, 0x493F3C3B, 0x8A4F4A2E, 0x6F6F2C3C, 0x0029001A, 0x00000000, 0x00000089, 0x0023008E,
    0x90FFFF82, 0x00000000, 0x001C002A, 0x0023000E, 0x002A0000, 0x00490038, 0x00650057, 0x008D0078, 0x392E2B00, 0x493F3D3B, 0x8A4F4A2E, 0x6F6F2C3C, 0x0029001A, 0x00000000, 0x0000008D, 0x00240090,
    0x92FFFF83, 0x00000000, 0x001C002A, 0x0023000E, 0x002A0000, 0x00490038, 0x00650057, 0x008D0078, 0x392E2B00, 0x493F3D3B, 0x8A4F4A2E, 0x6F6F2C3C, 0x0029001A, 0x00000000, 0x0000008D, 0x00240092,
    0x94FFFF84, 0x00000000, 0x001D002B, 0x0024000E, 0x002B0000, 0x004B003A, 0x0068005A, 0x0091007B, 0x392F2B00, 0x493F3D3B, 0x8B4F4A2F, 0x6F6F2D3D, 0x0029001A, 0x00000000, 0x00000091, 0x00250094,
    0x96FFFF85, 0x00000000, 0x001D002B, 0x0024000E, 0x002B0000, 0x004B003A, 0x0068005A, 0x0091007B, 0x392F2B00, 0x493F3D3B, 0x8B4F4A2F, 0x6F6F2D3D, 0x0029001A, 0x00000000, 0x00000091, 0x00250096,
    0x98FFFF86, 0x00000000, 0x001E002D, 0x0025000F, 0x002D0000, 0x004D003B, 0x006B005C, 0x0094007E, 0x3A2F2B00, 0x49483D3C, 0x8B584A2F, 0x6F6F2D3D, 0x0029001B, 0x00000000, 0x00000094, 0x00260098,
    0x9AFFFF87, 0x00000000, 0x001E002D, 0x0025000F, 0x002D0000, 0x004D003B, 0x006B005C, 0x0094007E, 0x3A2F2B00, 0x49483D3C, 0x8B584B2F, 0x6F6F2D3D, 0x0029001B, 0x00000000, 0x00000094, 0x0026009A,
    0x9CFFFF88, 0x00000000, 0x001E002E, 0x0026000F, 0x002E0000, 0x004F003D, 0x006E005E, 0x00980081, 0x3A2F2C00, 0x4A483E3C, 0x8B584B2F, 0x6F6F2D3D, 0x002A001B, 0x00000000, 0x00000098, 0x0027009C,
    0x9EFFFF89, 0x00000000, 0x001E002E, 0x0026000F, 0x002E0000, 0x004F003D, 0x006E005E, 0x00980081, 0x3A2F2C00, 0x4A483E3C, 0x8B584B38, 0x6F6F2D3D, 0x002A001B, 0x00000000, 0x00000098, 0x0027009E,
    0xA1FFFF8A, 0x00000000, 0x001F002F, 0x00270010, 0x002F0000, 0x0051003F, 0x00710061, 0x009C0085, 0x3A382C00, 0x4A483E3C, 0x8B584B38, 0x6F6F2E3E, 0x002A001B, 0x00000000, 0x0000009C, 0x002800A1,
    0xA4FFFF8B, 0x00000000, 0x00200030, 0x00280010, 0x00300000, 0x00530040, 0x00730063, 0x00A00088, 0x3A382C00, 0x4A493E3C, 0x8C584B38, 0x6F6F2E3E, 0x002A001B, 0x00000000, 0x000000A0, 0x002900A4,
    0xA6FFFF8C, 0x00000000, 0x00200030, 0x00280010, 0x00300000, 0x00530040, 0x00730063, 0x00A00088, 0x3A382C00, 0x4A493E3C, 0x8C594B38, 0x6F6F2E3E, 0x002A001B, 0x00000000, 0x000000A0, 0x002900A6,
    0xA9FFFF8D, 0x00000000, 0x00210031, 0x00290010, 0x00310000, 0x00550042, 0x00760066, 0x00A4008B, 0x3B382C00, 0x4A493F3D, 0x8C594C38, 0x6F6F2E3E, 0x002A001C, 0x00000000, 0x000000A4, 0x002A00A9,
    0xACFFFF8E, 0x00000000, 0x00220032, 0x002A0011, 0x00320000, 0x00570043, 0x00790068, 0x00A8008F, 0x3B382D00, 0x4B493F3D, 0x8C594C38, 0x6F6F2F3F, 0x002B001C, 0x00000000, 0x000000A8, 0x002B00AC,
    0xAEFFFF8F, 0x00000000, 0x00220032, 0x002A0011, 0x00320000, 0x00570043, 0x00790068, 0x00A8008F, 0x3B382D00, 0x4B493F3D, 0x8C594C39, 0x6F6F2F3F, 0x002B001C, 0x00000000, 0x000000A8, 0x002B00AE,
    0xB1FFFF90, 0x00000000, 0x00220034, 0x002B0011, 0x00340000, 0x00590045, 0x007C006B, 0x00AC0092, 0x3B392D00, 0x4B49483D, 0x8D594C39, 0x6F6F2F3F, 0x002B001C, 0x00000000, 0x000000AC, 0x002C00B1,
    0xB4FFFF91, 0x00000000, 0x00230035, 0x002C0012, 0x00350000, 0x005B0046, 0x007F006D, 0x00B00095, 0x3B392D00, 0x4B49483E, 0x8D594C39, 0x6F6F383F, 0x002B001D, 0x00000000, 0x000000B0, 0x002D00B4,
    0xB6FFFF92, 0x00000000, 0x00230035, 0x002C0012, 0x00350000, 0x005B0046, 0x007F006D, 0x00B00095, 0x3B392D00, 0x4B49483E, 0x8D594C39, 0x6F6F383F, 0x002B001D, 0x00000000, 0x000000B0, 0x002D00B6,
    0xB9FFFF93, 0x00000000, 0x00240036, 0x002D0012, 0x00360000, 0x005D0048, 0x0081006F, 0x00B40099, 0x3C392E00, 0x4B4A483E, 0x8D5A4D39, 0x6F6F3848, 0x002B001D, 0x00000000, 0x000000B4, 0x002E00B9,
    0xBBFFFF94, 0x00000000, 0x00240036, 0x002D0012, 0x00360000, 0x005D0048, 0x0081006F, 0x00B40099, 0x3C392E00, 0x4B4A483E, 0x8D5A4D39, 0x6F6F3848, 0x002B001D, 0x00000000, 0x000000B4, 0x002E00BB,
    0xBEFFFF95, 0x00000000, 0x00250037, 0x002E0012, 0x00370000, 0x005F0049, 0x00840072, 0x00B8009C, 0x3C392E00, 0x4C4A483E, 0x8E5A4D39, 0x6F6F3848, 0x002C001D, 0x00000000, 0x000000B8, 0x002F00BE,
    0xC0FFFF96, 0x00000000, 0x00260038, 0x002F0013, 0x00380000, 0x0062004B, 0x00870074, 0x00BC009F, 0x3C392E00, 0x4C4A483F, 0x8E5A4D39, 0x6F6F3848, 0x002C001D, 0x00000000, 0x000000BC, 0x003000C0,
    0xC3FFFF97, 0x00000000, 0x00260038, 0x002F0013, 0x00380000, 0x0062004B, 0x00870074, 0x00BC009F, 0x3C392E00, 0x4C4A483F, 0x8E5A4D3A, 0x6F6F3848, 0x002C001D, 0x00000000, 0x000000BC, 0x003000C3,
    0xC7FFFF98, 0x00000000, 0x00260039, 0x00300013, 0x00390000, 0x0064004D, 0x008A0077, 0x00BF00A3, 0x3D3A2E00, 0x4C4A493F, 0x8E5A4E3A, 0x6F6F3848, 0x002C001E, 0x00000000, 0x000000BF, 0x003100C7,
    0xCAFFFF99, 0x00000000, 0x0027003B, 0x00310014, 0x003B0000, 0x0066004E, 0x008D0079, 0x00C300A6, 0x3D3A2F00, 0x4C4A493F, 0x8E5A4E3A, 0x6F6F3949, 0x002C001E, 0x00000000, 0x000000C3, 0x003200CA,
    0xCDFFFF9A, 0x00000000, 0x0028003C, 0x00320014, 0x003C0000, 0x00680050, 0x008F007C, 0x00C700A9, 0x3D3A2F00, 0x4C4B4948, 0x8F5B4E3A, 0x6F6F3949, 0x002D001E, 0x00000000, 0x000000C7, 0x003300CD,
    0xD0FFFF9B, 0x00000000, 0x0029003D, 0x00330014, 0x003D0000, 0x006A0051, 0x0092007E, 0x00CB00AD, 0x3D3A2F00, 0x4D4B4948, 0x8F5B4E3A, 0x6F6F3949, 0x002D001E, 0x00000000, 0x000000CB, 0x003400D0,
    0xD3FFFF9C, 0x00000000, 0x0029003D, 0x00330014, 0x003D0000, 0x006A0051, 0x0092007E, 0x00CB00AD, 0x3D3A2F00, 0x4D4B4948, 0x8F5B4E3A, 0x6F6F3949, 0x002D001E, 0x00000000, 0x000000CB, 0x003400D3,
    0xD6FFFF9D, 0x00000000, 0x0029003E, 0x00340015, 0x003E0000, 0x006C0053, 0x00950080, 0x00CF00B0, 0x3E3A3800, 0x4D4B4948, 0x8F5B4F3B, 0x6F6F3949, 0x002D001F, 0x00000000, 0x000000CF, 0x003500D6,
    0xD9FFFF9E, 0x00000000, 0x002A003F, 0x00350015, 0x003F0000, 0x006E0054, 0x00980083, 0x00D300B3, 0x3E3B3800, 0x4D4B4A48, 0x8F5B4F3B, 0x6F6F3949, 0x002D001F, 0x00000000, 0x000000D3, 0x003600D9,
    0xDCFFFF9F, 0x00000000, 0x002B0040, 0x00360015, 0x00400000, 0x00700056, 0x009B0085, 0x00D700B7, 0x3E3B3800, 0x4D4B4A48, 0x8F5B4F3B, 0x6F6F3949, 0x002E001F, 0x00000000, 0x000000D7, 0x003700DC,
    0xDFFFFFA0, 0x00000000, 0x002B0040, 0x00360015, 0x00400000, 0x00700056, 0x009B0085, 0x00D700B7, 0x3E3B3800, 0x4D4B4A48, 0x8F5B4F3B, 0x6F6F3949, 0x002E001F, 0x00000000, 0x000000D7, 0x003700DF,
    0xE2FFFFA1, 0x00000000, 0x002C0042, 0x00370016, 0x00420000, 0x00720058, 0x009E0088, 0x00DB00BA, 0x3E3B3800, 0x4E4C4A49, 0x8F5C4F3B, 0x6F6F3A4A, 0x002E0028, 0x00000000, 0x000000DB, 0x003800E2,
    0xE6FFFFA2, 0x00000000, 0x002D0043, 0x00380016, 0x00430000, 0x00740059, 0x00A0008A, 0x00DF00BD, 0x3F3B3800, 0x4E4C4A49, 0x8F5C583B, 0x6F6F3A4A, 0x002E0028, 0x00000000, 0x000000DF, 0x003900E6,
    0xE9FFFFA3, 0x00000000, 0x002D0044, 0x00390017, 0x00440000, 0x0076005B, 0x00A3008C, 0x00E300C1, 0x3F3B3900, 0x4E4C4A49, 0x8F5C583B, 0x6F6F3A4A, 0x002E0028, 0x00000000, 0x000000E3, 0x003A00E9,
    0xEDFFFFA4, 0x00000000, 0x002E0045, 0x003A0017, 0x00450000, 0x0078005C, 0x00A6008F, 0x00E600C4, 0x3F3C3900, 0x4E4C4A49, 0x8F5C583C, 0x6F6F3A4A, 0x002F0028, 0x00000000, 0x000000E6, 0x003B00ED,
    0xF0FFFFA5, 0x00000000, 0x002F0046, 0x003B0017, 0x00460000, 0x007A005E, 0x00A90091, 0x00EA00C7, 0x3F3C3900, 0x4F4C4B49, 0x8F5C583C, 0x6F6F3A4A, 0x002F0028, 0x00000000, 0x000000EA, 0x003C00F0,
    0xF3FFFFA6, 0x00000000, 0x002F0046, 0x003B0017, 0x00460000, 0x007A005E, 0x00A90091, 0x00EA00C7, 0x3F3C3900, 0x4F4C4B49, 0x8F5C583C, 0x6F6F3A4A, 0x002F0028, 0x00000000, 0x000000EA, 0x003C00F3,
    0xF7FFFFA7, 0x00000000, 0x00300047, 0x003C0018, 0x00470000, 0x007C005F, 0x00AC0094, 0x00EE00CB, 0x483C3900, 0x4F4D4B49, 0x8F5D583C, 0x6F6F3A4A, 0x002F0028, 0x00000000, 0x000000EE, 0x003D00F7,
    0xFAFFFFA8, 0x00000000, 0x00300049, 0x003D0018, 0x00490000, 0x007E0061, 0x00AE0096, 0x00F200CE, 0x483C3900, 0x4F4D4B49, 0x8F5D593C, 0x6F6F3B4B, 0x002F0029, 0x00000000, 0x000000F2, 0x003E00FA,
    0xFDFFFFA9, 0x00000000, 0x0031004A, 0x003E0019, 0x004A0000, 0x00800062, 0x00B10099, 0x00F600D1, 0x483C3900, 0x4F4D4B4A, 0x8F5D593C, 0x6F6F3B4B, 0x00380029, 0x00000000, 0x000000F6, 0x003F00FD,
    0xFFFFFFAA, 0x00000000, 0x0032004B, 0x003F0019, 0x004B0000, 0x00820064, 0x00B4009B, 0x00FA00D5, 0x483D3900, 0x584D4B4A, 0x8F5D593D, 0x6F6F3B4B, 0x00380029, 0x00000000, 0x000000FA, 0x00400101,
    0xFFFFFFAB, 0x00000000, 0x0033004C, 0x003F0019, 0x004C0000, 0x00840066, 0x00B7009D, 0x00FE00D8, 0x483D3A00, 0x584E4B4A, 0x8F5D593D, 0x6F6F3B4B, 0x00380029, 0x00000000, 0x000000FE, 0x00410105,
    0xFFFFFFAC, 0x00000000, 0x0034004D, 0x0040001A, 0x004D0000, 0x00860067, 0x00BA00A0, 0x010200DB, 0x483D3A00, 0x584E4C4A, 0x8F5E593D, 0x6F6F3B4B, 0x00380029, 0x00000000, 0x00000102, 0x00420109,
    0xFFFFFFAD, 0x00000000, 0x0034004F, 0x0041001A, 0x004F0000, 0x00880069, 0x00BC00A2, 0x010600DE, 0x493D3A00, 0x584E4C4A, 0x8F5E593D, 0x6F6F3C4B, 0x00380029, 0x00000000, 0x00000106, 0x0043010D,
    0xFFFFFFAE, 0x00000000, 0x00350050, 0x0042001B, 0x00500000, 0x008A006A, 0x00BF00A5, 0x010A00E2, 0x493D3A00, 0x584E4C4A, 0x8F5E593D, 0x6F6F3C4C, 0x00380029, 0x00000000, 0x0000010A, 0x00440110,
    0xFFFFFFAF, 0x00000000, 0x00360051, 0x0043001B, 0x00510000, 0x008C006C, 0x00C200A7, 0x010E00E5, 0x493E3A00, 0x584E4C4A, 0x8F5E593E, 0x6F6F3C4C, 0x0038002A, 0x00000000, 0x0000010E, 0x00450114,
    0xFFFFFFB0, 0x00000000, 0x00370052, 0x0044001B, 0x00520000, 0x008E006D, 0x00C500AA, 0x011100E8, 0x493E3A00, 0x594F4C4B, 0x8F5E5A3E, 0x6F6F3C4C, 0x0039002A, 0x00000000, 0x00000111, 0x00460118,
    0xFFFFFFB1, 0x00000000, 0x00370053, 0x0045001C, 0x00530000, 0x0090006F, 0x00C800AC, 0x011500EC, 0x493E3A00, 0x594F4D4B, 0x8F5F5A3E, 0x6F6F3C4C, 0x0039002A, 0x00000000, 0x00000115, 0x0047011C,
    0xFFFFFFB2, 0x00000000, 0x00380054, 0x0046001C, 0x00540000, 0x00920071, 0x00CB00AE, 0x011900EF, 0x493E3B00, 0x594F4D4B, 0x8F5F5A3E, 0x6F6F3C4C, 0x0039002A, 0x00000000, 0x00000119, 0x00480120,
    0xFFFFFFB3, 0x00000000, 0x00390056, 0x0047001D, 0x00560000, 0x00940072, 0x00CD00B1, 0x011D00F2, 0x493E3B00, 0x594F4D4B, 0x8F5F5A3E, 0x6F6F3D4D, 0x0039002A, 0x00000000, 0x0000011D, 0x00490124,
    0xFFFFFFB4, 0x00000000, 0x003A0057, 0x0048001D, 0x00570000, 0x00960074, 0x00D000B3, 0x012100F6, 0x493F3B00, 0x594F4D4B, 0x8F5F5A3F, 0x6F6F3D4D, 0x0039002A, 0x00000000, 0x00000121, 0x004A0128,
    0xFFFFFFB5, 0x00000000, 0x003B0058, 0x0049001D, 0x00580000, 0x00980075, 0x00D300B6, 0x012500F9, 0x4A3F3B00, 0x59584D4B, 0x8F5F5A3F, 0x6F6F3D4D, 0x0039002A, 0x00000000, 0x00000125, 0x004B012C,
    0xFFFFFFB6, 0x00000000, 0x003B0059, 0x004A001E, 0x00590000, 0x009A0077, 0x00D600B8, 0x012900FC, 0x4A3F3B00, 0x59584D4C, 0x8F685A3F, 0x6F6F3D4D, 0x0039002B, 0x00000000, 0x00000129, 0x004C0130,
    0xFFFFFFB7, 0x00000000, 0x003C005A, 0x004B001E, 0x005A0000, 0x009C0078, 0x00D900BA, 0x012D0100, 0x4A3F3B00, 0x59584E4C, 0x8F685B3F, 0x6F6F3D4D, 0x0039002B, 0x00000000, 0x0000012D, 0x004D0135,
    0xFFFFFFB8, 0x00000000, 0x003D005B, 0x004C001E, 0x005B0000, 0x009E007A, 0x00DB00BD, 0x01310103, 0x4A3F3B00, 0x5A584E4C, 0x8F685B3F, 0x6F6F3D4D, 0x003A002B, 0x00000000, 0x00000131, 0x004E0139,
    0xFFFFFFB9, 0x00000000, 0x003E005D, 0x004D001F, 0x005D0000, 0x00A0007B, 0x00DE00BF, 0x01350106, 0x4A3F3C00, 0x5A584E4C, 0x8F685B48, 0x6F6F3E4E, 0x003A002B, 0x00000000, 0x00000135, 0x004F013D,
    0xFFFFFFBA, 0x00000000, 0x003F005E, 0x004E001F, 0x005E0000, 0x00A3007D, 0x00E100C2, 0x0139010A, 0x4A483C00, 0x5A584E4C, 0x8F685B48, 0x6F6F3E4E, 0x003A002B, 0x00000000, 0x00000139, 0x00500142,
    0xFFFFFFBB, 0x00000000, 0x003F005F, 0x004F0020, 0x005F0000, 0x00A5007F, 0x00E400C4, 0x013C010D, 0x4A483C00, 0x5A584E4C, 0x8F685B48, 0x6F6F3E4E, 0x003A002B, 0x00000000, 0x0000013C, 0x00510146,
    0xFFFFFFBC, 0x00000000, 0x00400060, 0x00500020, 0x00600000, 0x00A70080, 0x00E700C7, 0x01400110, 0x4A483C00, 0x5A594E4C, 0x8F685B48, 0x6F6F3E4E, 0x003A002B, 0x00000000, 0x00000140, 0x0052014A,
    0xFFFFFFBD, 0x00000000, 0x00410061, 0x00510020, 0x00610000, 0x00A90082, 0x00E900C9, 0x01440114, 0x4B483C00, 0x5A594F4D, 0x8F695B48, 0x6F6F3E4E, 0x003A002B, 0x00000000, 0x00000144, 0x0053014F,
    0xFFFFFFBE, 0x00000000, 0x00420064, 0x00530021, 0x00640000, 0x00AD0085, 0x00EF00CE, 0x014C011A, 0x4B483D00, 0x5A594F4D, 0x8F695C48, 0x6F6F3F4F, 0x003A002C, 0x00000000, 0x0000014C, 0x00550154,
    0xFFFFFFBF, 0x00000000, 0x00430065, 0x00540022, 0x00650000, 0x00AF0086, 0x00F200D0, 0x0150011E, 0x4B483D00, 0x5B594F4D, 0x8F695C48, 0x6F6F3F4F, 0x003B002C, 0x00000000, 0x00000150, 0x00560158,
    0xFFFFFFC0, 0x00000000, 0x00440066, 0x00550022, 0x00660000, 0x00B10088, 0x00F500D3, 0x01540121, 0x4B493D00, 0x5B594F4D, 0x8F695C49, 0x6F6F3F4F, 0x003B002C, 0x00000000, 0x00000154, 0x0057015D,
    0xFFFFFFC1, 0x00000000, 0x00450067, 0x00560022, 0x00670000, 0x00B3008A, 0x00F800D5, 0x01580124, 0x4B493D00, 0x5B59584D, 0x8F695C49, 0x6F6F3F4F, 0x003B002C, 0x00000000, 0x00000158, 0x00580162,
    0xFFFFFFC2, 0x00000000, 0x00460068, 0x00570023, 0x00680000, 0x00B5008B, 0x00FA00D8, 0x015C0128, 0x4B493D00, 0x5B59584E, 0x8F695C49, 0x6F6F3F4F, 0x003B002C, 0x00000000, 0x0000015C, 0x00590167,
    0xFFFFFFC3, 0x00000000, 0x0047006B, 0x00590024, 0x006B0000, 0x00B9008E, 0x010000DC, 0x0163012E, 0x4C493D00, 0x5B59584E, 0x8F695C49, 0x6F6F4858, 0x003B002D, 0x00000000, 0x00000163, 0x005B016C,
    0xFFFFFFC4, 0x00000000, 0x0048006C, 0x005A0024, 0x006C0000, 0x00BB0090, 0x010300DF, 0x01670131, 0x4C493E00, 0x5B5A584E, 0x8F695D49, 0x6F6F4858, 0x003B002D, 0x00000000, 0x00000167, 0x005C0171,
    0xFFFFFFC5, 0x00000000, 0x0049006D, 0x005B0024, 0x006D0000, 0x00BD0091, 0x010600E1, 0x016B0135, 0x4C493E00, 0x5B5A584E, 0x8F6A5D49, 0x6F6F4858, 0x003B002D, 0x00000000, 0x0000016B, 0x005D0176,
    0xFFFFFFC6, 0x00000000, 0x0049006E, 0x005C0025, 0x006E0000, 0x00BF0093, 0x010800E4, 0x016F0138, 0x4C493E00, 0x5B5A584E, 0x8F6A5D49, 0x6F6F4858, 0x003C002D, 0x00000000, 0x0000016F, 0x005E017B,
    0xFFFFFFC7, 0x00000000, 0x004B0071, 0x005E0026, 0x00710000, 0x00C30096, 0x010E00E9, 0x0177013F, 0x4C493E00, 0x5C5A584F, 0x8F6A5D49, 0x6F6F4858, 0x003C002D, 0x00000000, 0x00000177, 0x00600180,
    0xFFFFFFC8, 0x00000000, 0x004C0072, 0x005F0026, 0x00720000, 0x00C50098, 0x011100EB, 0x017B0142, 0x4C4A3E00, 0x5C5A594F, 0x8F6A5D4A, 0x6F6F4858, 0x003C002D, 0x00000000, 0x0000017B, 0x00610185,
    0xFFFFFFC9, 0x00000000, 0x004D0073, 0x00600026, 0x00730000, 0x00C70099, 0x011400ED, 0x017F0145, 0x4C4A3E00, 0x5C5A594F, 0x8F6A5E4A, 0x6F6F4858, 0x003C002E, 0x00000000, 0x0000017F, 0x0062018B,
    0xFFFFFFCA, 0x00000000, 0x004E0075, 0x00620027, 0x00750000, 0x00CB009C, 0x011900F2, 0x0187014C, 0x4D4A3F00, 0x5C5A594F, 0x8F6A5E4A, 0x6F6F4959, 0x003C002E, 0x00000000, 0x00000187, 0x00640190,
    0xFFFFFFCB, 0x00000000, 0x004F0076, 0x00630027, 0x00760000, 0x00CD009E, 0x011C00F5, 0x018B014F, 0x4D4A3F00, 0x5C5A594F, 0x8F6A5E4A, 0x6F6F4959, 0x003C002E, 0x00000000, 0x0000018B, 0x00650196,
    0xFFFFFFCC, 0x00000000, 0x00500078, 0x00640028, 0x00780000, 0x00CF009F, 0x011F00F7, 0x018E0153, 0x4D4A3F00, 0x5C5B594F, 0x8F6B5E4A, 0x6F6F4959, 0x003D002E, 0x00000000, 0x0000018E, 0x0066019B,
    0xFFFFFFCD, 0x00000000, 0x0051007A, 0x00660029, 0x007A0000, 0x00D300A3, 0x012500FC, 0x01960159, 0x4D4A3F00, 0x5D5B5958, 0x8F6B5E4A, 0x6F6F4959, 0x003D002E, 0x00000000, 0x00000196, 0x006801A1,
    0xFFFFFFCE, 0x00000000, 0x0052007B, 0x00670029, 0x007B0000, 0x00D500A4, 0x012700FE, 0x019A015D, 0x4D4A3F00, 0x5D5B5958, 0x8F6B5E4A, 0x6F6F4959, 0x003D002E, 0x00000000, 0x0000019A, 0x006901A7,
    0xFFFFFFCF, 0x00000000, 0x0054007D, 0x0068002A, 0x007D0000, 0x00D900A7, 0x012D0103, 0x01A20163, 0x4E4A4800, 0x5D5B5958, 0x8F6B5F4B, 0x6F6F4959, 0x003D002F, 0x00000000, 0x000001A2, 0x006B01AD,
    0xFFFFFFD0, 0x00000000, 0x0054007F, 0x0069002A, 0x007F0000, 0x00DB00A9, 0x01300106, 0x01A60167, 0x4E4B4800, 0x5D5B5A58, 0x8F6B5F4B, 0x6F6F4959, 0x003D002F, 0x00000000, 0x000001A6, 0x006C01B3,
    0xFFFFFFD1, 0x00000000, 0x00560081, 0x006B002B, 0x00810000, 0x00DF00AC, 0x0135010A, 0x01AE016D, 0x4E4B4800, 0x5D5B5A58, 0x8F6B5F4B, 0x6F6F4959, 0x003D002F, 0x00000000, 0x000001AE, 0x006E01B9,
    0xFFFFFFD2, 0x00000000, 0x00570082, 0x006C002B, 0x00820000, 0x00E100AD, 0x0138010D, 0x01B20171, 0x4E4B4800, 0x5E5C5A58, 0x8F6B5F4B, 0x6F6F4A5A, 0x003E002F, 0x00000000, 0x000001B2, 0x006F01BF,
    0xFFFFFFD3, 0x00000000, 0x00580084, 0x006E002C, 0x00840000, 0x00E600B1, 0x013E0112, 0x01B90177, 0x4E4B4800, 0x5E5C5A59, 0x8F6C684B, 0x6F6F4A5A, 0x003E0038, 0x00000000, 0x000001B9, 0x007101C6,
    0xFFFFFFD4, 0x00000000, 0x005A0087, 0x0070002D, 0x00870000, 0x00EA00B4, 0x01430117, 0x01C1017E, 0x4F4B4800, 0x5E5C5A59, 0x8F6C684B, 0x6F6F4A5A, 0x003E0038, 0x00000000, 0x000001C1, 0x007301CD,
    0xFFFFFFD5, 0x00000000, 0x005B0088, 0x0071002D, 0x00880000, 0x00EC00B5, 0x01460119, 0x01C50181, 0x4F4B4900, 0x5E5C5A59, 0x8F6C684B, 0x6F6F4A5A, 0x003E0038, 0x00000000, 0x000001C5, 0x007401D3,
    0xFFFFFFD6, 0x00000000, 0x005C008A, 0x0073002E, 0x008A0000, 0x00F000B8, 0x014C011E, 0x01CD0188, 0x4F4C4900, 0x5E5C5A59, 0x8F6C684C, 0x6F6F4A5A, 0x003E0038, 0x00000000, 0x000001CD, 0x007601DB,
    0xFFFFFFD7, 0x00000000, 0x005E008D, 0x0075002F, 0x008D0000, 0x00F400BC, 0x01520123, 0x01D5018E, 0x4F4C4900, 0x5F5C5B59, 0x8F6C684C, 0x6F6F4A5A, 0x003F0038, 0x00000000, 0x000001D5, 0x007801E2,
    0xFFFFFFD8, 0x00000000, 0x005F008F, 0x00770030, 0x008F0000, 0x00F800BF, 0x01570127, 0x01DD0195, 0x584C4900, 0x5F5D5B59, 0x8F6D684C, 0x6F6F4A5A, 0x003F0038, 0x00000000, 0x000001DD, 0x007A01E9,
    0xFFFFFFD9, 0x00000000, 0x00610091, 0x00790030, 0x00910000, 0x00FC00C2, 0x015D012C, 0x01E4019C, 0x584C4900, 0x5F5D5B59, 0x8F6D694C, 0x6F6F4B5B, 0x003F0039, 0x00000000, 0x000001E4, 0x007C01F1,
    0xFFFFFFDA, 0x00000000, 0x00620094, 0x007B0031, 0x00940000, 0x010000C5, 0x01620131, 0x01EC01A2, 0x584C4900, 0x5F5D5B5A, 0x8F6D694C, 0x6F6F4B5B, 0x003F0039, 0x00000000, 0x000001EC, 0x007E01F9,
    0xFFFFFFDB, 0x00000000, 0x00640096, 0x007D0032, 0x00960000, 0x010400C8, 0x01680136, 0x01F401A9, 0x584D4900, 0x685D5B5A, 0x8F6D694D, 0x6F6F4B5B, 0x00480039, 0x00000000, 0x000001F4, 0x00800201,
    0xFFFFFFDC, 0x00000000, 0x00660098, 0x007F0033, 0x00980000, 0x010800CB, 0x016E013B, 0x01FC01B0, 0x584D4A00, 0x685E5B5A, 0x8F6D694D, 0x6F6F4B5B, 0x00480039, 0x00000000, 0x000001FC, 0x0082020A,
    0xFFFFFFDD, 0x00000000, 0x0067009B, 0x00810034, 0x009B0000, 0x010C00CE, 0x01730140, 0x020401B6, 0x584D4A00, 0x685E5C5A, 0x8F6E694D, 0x6F6F4B5B, 0x00480039, 0x00000000, 0x00000204, 0x00840212,
    0xFFFFFFDE, 0x00000000, 0x0069009D, 0x00830034, 0x009D0000, 0x011000D1, 0x01790145, 0x020B01BD, 0x594D4A00, 0x685E5C5A, 0x8F6E694D, 0x6F6F4B5B, 0x00480039, 0x00000000, 0x0000020B, 0x0086021B,
    0xFFFFFFDF, 0x00000000, 0x006B00A1, 0x00860036, 0x00A10000, 0x011600D6, 0x0181014C, 0x021701C7, 0x594D4A00, 0x685E5C5A, 0x8F6E694D, 0x6F6F4C5C, 0x00480039, 0x00000000, 0x00000217, 0x00890225,
    0xFFFFFFE0, 0x00000000, 0x006D00A3, 0x00880036, 0x00A30000, 0x011A00D9, 0x01870151, 0x021F01CE, 0x594E4A00, 0x685E5C5B, 0x8F6E6A4E, 0x6F6F4C5C, 0x0049003A, 0x00000000, 0x0000021F, 0x008B022F,
    0xFFFFFFE1, 0x00000000, 0x006F00A6, 0x008B0037, 0x00A60000, 0x012000DE, 0x018F0158, 0x022B01D7, 0x594E4A00, 0x695F5C5B, 0x8F6F6A4E, 0x6F6F4C5C, 0x0049003A, 0x00000000, 0x0000022B, 0x008E0239,
    0xFFFFFFE2, 0x00000000, 0x007100A9, 0x008D0038, 0x00A90000, 0x012500E1, 0x0195015D, 0x023301DE, 0x594E4B00, 0x695F5D5B, 0x8F6F6A4E, 0x6F6F4C5C, 0x0049003A, 0x00000000, 0x00000233, 0x00900243,
    0xFFFFFFE3, 0x00000000, 0x007300AC, 0x00900039, 0x00AC0000, 0x012B00E6, 0x019D0164, 0x023E01E8, 0x594E4B00, 0x695F5D5B, 0x8F6F6A4E, 0x6F6F4D5D, 0x0049003A, 0x00000000, 0x0000023E, 0x0093024E,
    0xFFFFFFE4, 0x00000000, 0x007500B0, 0x0092003B, 0x00B00000, 0x013100EA, 0x01A6016B, 0x024A01F2, 0x5A4F4B00, 0x69685D5B, 0x8F6F6A4F, 0x6F6F4D5D, 0x0049003A, 0x00000000, 0x0000024A, 0x0096025A,
    0xFFFFFFE5, 0x00000000, 0x007800B3, 0x0095003C, 0x00B30000, 0x013700EF, 0x01AE0173, 0x025601FC, 0x5A4F4B00, 0x69685D5C, 0x8F786B4F, 0x6F6F4D5D, 0x0049003B, 0x00000000, 0x00000256, 0x00990266,
    0xFFFFFFE6, 0x00000000, 0x007A00B7, 0x0098003D, 0x00B70000, 0x013D00F4, 0x01B7017A, 0x02610206, 0x5A4F4B00, 0x6A685E5C, 0x8F786B4F, 0x6F6F4D5D, 0x004A003B, 0x00000000, 0x00000261, 0x009C0272,
    0xFFFFFFE7, 0x00000000, 0x007D00BC, 0x009C003F, 0x00BC0000, 0x014500FA, 0x01C20184, 0x02710213, 0x5A584C00, 0x6A685E5C, 0x8F786B58, 0x6F6F4E5E, 0x004A003B, 0x00000000, 0x00000271, 0x00A00280,
    0xFFFFFFE8, 0x00000000, 0x007F00BF, 0x009F0040, 0x00BF0000, 0x014B00FF, 0x01CA018B, 0x027D021D, 0x5A584C00, 0x6A685E5C, 0x8F786B58, 0x6F6F4E5E, 0x004A003B, 0x00000000, 0x0000027D, 0x00A3028E,
    0xFFFFFFE9, 0x00000000, 0x008200C4, 0x00A30041, 0x00C40000, 0x01530105, 0x01D60194, 0x028C022A, 0x5B584C00, 0x6A695F5D, 0x8F796B58, 0x6F6F4E5E, 0x004A003B, 0x00000000, 0x0000028C, 0x00A7029C,
    0xFFFFFFEA, 0x00000000, 0x008600C8, 0x00A70043, 0x00C80000, 0x015B010B, 0x01E1019E, 0x029C0238, 0x5B584D00, 0x6A695F5D, 0x8F796C58, 0x6F6F4F5F, 0x004A003C, 0x00000000, 0x0000029C, 0x00AB02AC,
    0xFFFFFFEB, 0x00000000, 0x008900CD, 0x00AB0044, 0x00CD0000, 0x01630111, 0x01EC01A8, 0x02AC0245, 0x5B594D00, 0x6B695F5D, 0x8F796C59, 0x6F6F4F5F, 0x004B003C, 0x00000000, 0x000002AC, 0x00AF02BC,
    0xFFFFFFEC, 0x00000000, 0x008C00D2, 0x00AF0046, 0x00D20000, 0x016C0118, 0x01F701B2, 0x02BB0252, 0x5B594D00, 0x6B69685E, 0x8F796C59, 0x6F6F4F5F, 0x004B003C, 0x00000000, 0x000002BB, 0x00B302CD,
    0xFFFFFFED, 0x00000000, 0x009000D8, 0x00B40048, 0x00D80000, 0x01760120, 0x020601BE, 0x02CF0263, 0x5C594E00, 0x6B6A685E, 0x8F796D59, 0x6F6F5868, 0x004B003D, 0x00000000, 0x000002CF, 0x00B802E0,
    0xFFFFFFEE, 0x00000000, 0x009300DC, 0x00B80049, 0x00DC0000, 0x017E0126, 0x021101C7, 0x02DE0270, 0x5C594E00, 0x6B6A685E, 0x8F7A6D59, 0x6F6F5868, 0x004C003D, 0x00000000, 0x000002DE, 0x00BC02F3,
    0xFFFFFFEF, 0x00000000, 0x009700E2, 0x00BC004B, 0x00E20000, 0x0188012E, 0x021F01D3, 0x02F20281, 0x5C594E00, 0x6C6A685F, 0x8F7A6D59, 0x6F6F5868, 0x004C003D, 0x00000000, 0x000002F2, 0x00C10307,
    0xFFFFFFF0, 0x00000000, 0x009B00E9, 0x00C2004E, 0x00E90000, 0x01940137, 0x023001E2, 0x03090295, 0x5D5A4F00, 0x6C6A695F, 0x8F7A6E5A, 0x6F6F5969, 0x004C003E, 0x00000000, 0x00000309, 0x00C7031C,
    0xFFFFFFF1, 0x00000000, 0x009F00EF, 0x00C70050, 0x00EF0000, 0x019E013F, 0x023E01EE, 0x031D02A5, 0x5D5A4F00, 0x6C6B695F, 0x8F7B6E5A, 0x6F6F5969, 0x004C003E, 0x00000000, 0x0000031D, 0x00CC0333,
    0xFFFFFFF2, 0x00000000, 0x00A400F6, 0x00CD0052, 0x00F60000, 0x01AB0148, 0x024F01FD, 0x033402B9, 0x5D5A4F00, 0x6D6B6968, 0x8F7B6E5A, 0x6F6F5969, 0x004D003E, 0x00000000, 0x00000334, 0x00D2034B,
    0xFFFFFFF3, 0x00000000, 0x00AA00FE, 0x00D40055, 0x00FE0000, 0x01B90153, 0x0262020E, 0x035002D1, 0x5E5B5800, 0x6D6B6A68, 0x8F7B6F5B, 0x6F6F5969, 0x004D003F, 0x00000000, 0x00000350, 0x00D90365,
    0xFFFFFFF4, 0x00000000, 0x00AF0107, 0x00DB0058, 0x01070000, 0x01C7015E, 0x0276021F, 0x036B02E8, 0x5E5B5800, 0x6E6C6A68, 0x8F7B6F5B, 0x6F6F5A6A, 0x004E003F, 0x00000000, 0x0000036B, 0x00E00380,
    0xFFFFFFF5, 0x00000000, 0x00B4010F, 0x00E2005A, 0x010F0000, 0x01D50169, 0x028A022F, 0x038602FF, 0x5F5B5800, 0x6E6C6A69, 0x8F7C785B, 0x6F6F5A6A, 0x004E0048, 0x00000000, 0x00000386, 0x00E7039D,
    0xFFFFFFF6, 0x00000000, 0x00BA0117, 0x00E8005D, 0x01170000, 0x01E30174, 0x029D0240, 0x03A20316, 0x5F5C5900, 0x6F6C6A69, 0x8F7C785C, 0x6F6F5A6A, 0x004F0048, 0x00000000, 0x000003A2, 0x00EE03BB,
    0xFFFFFFF7, 0x00000000, 0x00C10121, 0x00F10060, 0x01210000, 0x01F60182, 0x02B70256, 0x03C50334, 0x685C5900, 0x6F6D6B69, 0x8F7D785C, 0x6F6F5B6B, 0x004F0048, 0x00000000, 0x000003C5, 0x00F703DC,
    0xFFFFFFF8, 0x00000000, 0x00C7012B, 0x00F90064, 0x012B0000, 0x0206018E, 0x02CD026A, 0x03E4034F, 0x685C5900, 0x6F6D6B6A, 0x8F7D795C, 0x6F6F5B6B, 0x00580049, 0x00000000, 0x000003E4, 0x00FF03FE,
    0xFFFFFFF9, 0x00000000, 0x00CE0135, 0x01020067, 0x01350000, 0x0218019D, 0x02E7027F, 0x0407036D, 0x685D5A00, 0x6F6E6C6A, 0x8F7E795D, 0x6F6F5B6B, 0x00580049, 0x00000000, 0x00000407, 0x01080422,
    0xFFFFFFFA, 0x00000000, 0x00D60141, 0x010C006B, 0x01410000, 0x022D01AC, 0x03030298, 0x042E038E, 0x695D5A00, 0x6F6E6C6A, 0x8F7E795D, 0x6F6F5C6C, 0x00580049, 0x00000000, 0x0000042E, 0x0112044A,
    0xFFFFFFFB, 0x00000000, 0x00DE014D, 0x0115006F, 0x014D0000, 0x024101BC, 0x031F02B0, 0x045503AF, 0x695E5A00, 0x6F6F6C6B, 0x8F7F7A5E, 0x6F6F5C6C, 0x0059004A, 0x00000000, 0x00000455, 0x011C0473,
    0xFFFFFFFC, 0x00000000, 0x00E7015B, 0x01210074, 0x015B0000, 0x025901CF, 0x034102CD, 0x048403D7, 0x695E5B00, 0x6F6F6D6B, 0x8F7F7A5E, 0x6F6F5D6D, 0x0059004A, 0x00000000, 0x00000484, 0x012804A0,
    0xFFFFFFFD, 0x00000000, 0x00F10169, 0x012D0078, 0x01690000, 0x027201E1, 0x036202EA, 0x04B303FF, 0x6A5F5B00, 0x6F6F6E6C, 0x8F887B5F, 0x6F6F5D6D, 0x0059004B, 0x00000000, 0x000004B3, 0x013404D0,
    0xFFFFFFFE, 0x00000000, 0x00FA0177, 0x0139007D, 0x01770000, 0x028A01F4, 0x03840307, 0x04E20427, 0x6A685C00, 0x6F6F6E6C, 0x8F887B68, 0x6F6F5E6E, 0x005A004B, 0x00000000, 0x000004E2, 0x01400502,
    0xFFFFFFFF, 0x00000000, 0x01050187, 0x01460082, 0x01870000, 0x02A6020A, 0x03AB0329, 0x05190455, 0x6B685C00, 0x6F6F6F6D, 0x8F897B68, 0x6F6F5E6E, 0x005A004B, 0x00000000, 0x00000519, 0x014E0538,
};
