/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.model;

import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import java.util.List;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UserCreateRequest
extends CLIRequest {
    private static final String NAME = "iam-usercreate";
    private static final String DESCRIPTION = "Creates a new user in your account. You can also optionally add the user to one or more groups, and create an access key for the user.";
    @Option(name="-u", usage="the name of the user", required=true, metaVar="USERNAME")
    private String userName_;
    @Option(name="-k", usage="create a key for the user")
    private boolean createKey_;
    @Option(name="-g", usage="add user to group(s)", multiValued=true, metaVar="GROUPS")
    private List<String> groupNames_;
    @Option(name="-p", usage="the path of the user, defaults to /", metaVar="PATH")
    private String path_;
    @Option(name="-v", usage="print out the newly created user's arn and guid", metaVar="VERBOSE")
    private boolean isVerbose_;

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UserCreateRequest [createKey_=");
        builder.append(this.createKey_);
        builder.append(", groupNames_=");
        builder.append(this.groupNames_);
        builder.append(", isVerbose_=");
        builder.append(this.isVerbose_);
        builder.append(", path_=");
        builder.append(this.path_);
        builder.append(", userName_=");
        builder.append(this.userName_);
        builder.append(", toString()=");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }

    public boolean isVerbose() {
        return this.isVerbose_;
    }

    public boolean isCreateKey() {
        return this.createKey_;
    }

    public List<String> getGroupNames() {
        return this.groupNames_;
    }

    public String getPath() {
        return this.path_;
    }

    public String getUserName() {
        return this.userName_;
    }

    @Override
    public String getRequestName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }
}

