/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.UserDelRequest;
import com.amazonaws.services.identitymanagement.model.AccessKeyMetadata;
import com.amazonaws.services.identitymanagement.model.DeleteAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteSigningCertificateRequest;
import com.amazonaws.services.identitymanagement.model.DeleteUserPolicyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteUserRequest;
import com.amazonaws.services.identitymanagement.model.Group;
import com.amazonaws.services.identitymanagement.model.ListAccessKeysRequest;
import com.amazonaws.services.identitymanagement.model.ListAccessKeysResult;
import com.amazonaws.services.identitymanagement.model.ListGroupsForUserRequest;
import com.amazonaws.services.identitymanagement.model.ListGroupsForUserResult;
import com.amazonaws.services.identitymanagement.model.ListSigningCertificatesRequest;
import com.amazonaws.services.identitymanagement.model.ListSigningCertificatesResult;
import com.amazonaws.services.identitymanagement.model.ListUserPoliciesRequest;
import com.amazonaws.services.identitymanagement.model.ListUserPoliciesResult;
import com.amazonaws.services.identitymanagement.model.RemoveUserFromGroupRequest;
import com.amazonaws.services.identitymanagement.model.SigningCertificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMUserDelDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMUserDelDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof UserDelRequest) {
            LOG.debug((Object)("UserDelRequest " + request));
            UserDelRequest req = (UserDelRequest)request;
            boolean noop = req.isNoop();
            if (req.isRecursive()) {
                ListAccessKeysRequest listAccessKeysRequest = new ListAccessKeysRequest();
                listAccessKeysRequest.setUserName(req.getUserName());
                ListAccessKeysResult result = this.getClient().listAccessKeys(listAccessKeysRequest);
                if (!result.getAccessKeyMetadata().isEmpty()) {
                    if (noop) {
                        LOG.info((Object)"accesskeys");
                        for (AccessKeyMetadata key : result.getAccessKeyMetadata()) {
                            LOG.info((Object)("\t" + key.getAccessKeyId()));
                        }
                    } else {
                        LOG.debug((Object)"Deleting access keys");
                        DeleteAccessKeyRequest accessKeyRequest = new DeleteAccessKeyRequest();
                        accessKeyRequest.setUserName(req.getUserName());
                        for (AccessKeyMetadata key : result.getAccessKeyMetadata()) {
                            accessKeyRequest.setAccessKeyId(key.getAccessKeyId());
                            LOG.debug((Object)("Deleting access key " + key.getAccessKeyId()));
                            this.getClient().deleteAccessKey(accessKeyRequest);
                        }
                    }
                }
                ListUserPoliciesRequest listPoliciesRequest = new ListUserPoliciesRequest();
                listPoliciesRequest.setUserName(req.getUserName());
                ListUserPoliciesResult policiesResult = this.getClient().listUserPolicies(listPoliciesRequest);
                if (!policiesResult.getPolicyNames().isEmpty()) {
                    if (noop) {
                        LOG.info((Object)"policies");
                        for (String policy : policiesResult.getPolicyNames()) {
                            LOG.info((Object)("\t" + policy));
                        }
                    } else {
                        LOG.debug((Object)"Deleting policies");
                        DeleteUserPolicyRequest deletePolicyRequest = new DeleteUserPolicyRequest();
                        deletePolicyRequest.setUserName(req.getUserName());
                        for (String policy : policiesResult.getPolicyNames()) {
                            deletePolicyRequest.setPolicyName(policy);
                            LOG.debug((Object)("Deleting policy " + policy));
                            this.getClient().deleteUserPolicy(deletePolicyRequest);
                        }
                    }
                }
                ListSigningCertificatesRequest certificatesRequest = new ListSigningCertificatesRequest();
                certificatesRequest.setUserName(req.getUserName());
                ListSigningCertificatesResult certificatesResult = this.getClient().listSigningCertificates(certificatesRequest);
                if (!certificatesResult.getCertificates().isEmpty()) {
                    if (noop) {
                        LOG.info((Object)"certificates");
                        for (SigningCertificate cert : certificatesResult.getCertificates()) {
                            LOG.info((Object)("\t" + cert.getCertificateId()));
                        }
                    } else {
                        LOG.debug((Object)"Deleting certificates");
                        DeleteSigningCertificateRequest deleteCertificateRequest = new DeleteSigningCertificateRequest();
                        deleteCertificateRequest.setUserName(req.getUserName());
                        for (SigningCertificate cert : certificatesResult.getCertificates()) {
                            deleteCertificateRequest.setCertificateId(cert.getCertificateId());
                            LOG.debug((Object)("Deleting cert " + cert.getCertificateId()));
                            this.getClient().deleteSigningCertificate(deleteCertificateRequest);
                        }
                    }
                }
                ListGroupsForUserRequest groupsRequest = new ListGroupsForUserRequest();
                groupsRequest.setUserName(req.getUserName());
                LOG.debug((Object)"Listing group memebership.");
                ListGroupsForUserResult groupsResult = this.getClient().listGroupsForUser(groupsRequest);
                if (!groupsResult.getGroups().isEmpty()) {
                    if (noop) {
                        LOG.info((Object)"groups");
                        for (Group group : groupsResult.getGroups()) {
                            LOG.info((Object)("\t" + group.getArn()));
                        }
                    } else {
                        LOG.debug((Object)"Deleting groups");
                        RemoveUserFromGroupRequest removeUserFromGroupRequest = new RemoveUserFromGroupRequest();
                        removeUserFromGroupRequest.setUserName(req.getUserName());
                        for (Group group : groupsResult.getGroups()) {
                            removeUserFromGroupRequest.setGroupName(group.getGroupName());
                            LOG.debug((Object)("Deleting group " + group.getArn()));
                            this.getClient().removeUserFromGroup(removeUserFromGroupRequest);
                        }
                    }
                }
            }
            if (!noop) {
                DeleteUserRequest deleteUserRequest = new DeleteUserRequest();
                deleteUserRequest.setUserName(req.getUserName());
                LOG.debug((Object)"Deleting user");
                this.getClient().deleteUser(deleteUserRequest);
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

