/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_RV.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgi_replaceValue(const char * const name, const char * const data
		, int type, int trustlevel);

	If name == NULL:
		If data == NULL: the currently selected value is deleted;
		else: The data of the currently selected value is replaced by 'data';
	else
		all occurances of value(s) 'name' are removed and
		if data != NULL: a new value 'name' is appened to the section
			with the specified data

	Return: cfg error code

ob: cfgi_replaceValue
ty: L
su: inifile/2
sh: Replace / Remove a value
lo: \item If \para{name} == NULL && \para{data} == NULL, the current value is removed
	from the section.
	\item If \para{name} == NULL && \para{data} != NULL, the data of the current value is replaced by \para{data}.
	\item If \para{name} != NULL && \para{data} == NULL, all accurances of the specified value are removed from the section.
	\item If \para{name} != NULL && \para{data} != NULL, all accurances of the specified value are removed from the section and a new line is appended defining the value with the specified data.
re: 
fi: cfgi_rv.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <stdlib.h>
#endif
#include "inifile.loc"
#include "supplio.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_RV.C 1.5 2001/02/27 01:27:57 ska Exp ska $";
#endif

int cfgi_replaceValue(const char * const name, const char * const data
	, int type, int trustlevel)
{	int rv;
	char *p;

	DBG_ENTER("cfgi_replaceValue", Suppl_inifile2)
	DBG_ARGUMENTS( ("name=\"%s\", data=\"%s\", typ=%d, lvl=%d", name, data, type, trustlevel) )

	assert(hasKey(usrini));

	chkHeap
	if(name) {
		/* actively scan the current section for the specified value */
		if((rv = cfgEraseCurSection()) == CFG_ERR_NONE) {
			chkHeap
			FFsetpos(usrini.cfgi_fp, usrini.cfgi_pos);	/* reset section */

nxtValue:			/* loop until a line is found that is neither
						a comment nor ill-formed nor a valid value */
			switch(rv = cfgi_brkNxtVal(usrini.cfgi_fp)) {
			case CFG_ERR_COMMENT:		/* buf is comment */
			case CFG_ERR_LINE:			/* buf is ill-formed */
				chkHeap
				/* just duplicate */
				CFGI_NXTLINE			/* flush previous line */
				fputs(I(buf), cfgi_ini);
				cfgi_nlwritten = 1;		/* Ignore this line */
				goto nxtValue;

			case CFG_ERR_NONE:			/* normal value */
					/* The "data" string still contains the
						comment, if one is present. */
				chkHeap
				if(!cfgEqName(I(value), name))	/* not the value
										to be deleted */
					cfgCreateDataLineINI(I(value), I(data), I(type)
					 , I(trustlevel));
				chkHeap
				goto nxtValue;

			case CFG_ERR_END:		/* end of section --> all OK */
				if(data)
					cfgCreateDataLineINI(name, data, type, trustlevel);
				rv = CFG_ERR_NONE;
			default:
				break;
			}
		}

	} else {


			/* Delete current value */
		if(!hasValue())
			DBG_RETURN_I( CFG_ERR_ARG)
		if(I(valLocation) <= 0)			/* value not in user INI file */
			DBG_RETURN_I( CFG_ERR_NONE)

		chkHeap
		/* open the temporary output file */
		if((rv = cfgi_wrOpen()) == CFG_ERR_NONE
		 && (rv = cfgi_wrSetCurKey()) == CFG_ERR_NONE
			/* copy everything preceeding the current value */
		 && (rv = cfgi_copyallto(aS(I(curpos)))) == CFG_ERR_NONE) {
			chkHeap
			if(data)
				cfgCreateDataLineINI(I(value), data
				 , type == CFG_TDEFAULT? I(type): type
				 , trustlevel == CFG_DEFAULT_TRUSTLEVEL
				   ? I(trustlevel)
				   : trustlevel);
			/* skip the current value */
			if((p = Fgetline(usrini.cfgi_fp)) != 0) {
				chkHeap
				free(p);
				chkHeap
				rv = cfgi_copy();		/* Copy the rest of the file */
				chkHeap
			}
			else
				rv = CFG_ERR_MEM;
		}
	}

	chkHeap
	DBG_RETURN_BI( cfgi_wrClose(rv))
}
