/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_FS.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgi_findSec(FILE *fp, const char * const name);

	Find a key (section) in the specified file.

	If fp == NULL, the function always fails.

ob: cfgi_findSec
ty: L
su: inifile/2
sh: Search for a section within the specified file
lo: Searches for a section within the whole file.\par
	If \para{fp} == NULL, the function fails.
re: 
fi: cfgi_fs.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <string.h>
#endif
#include "inifile.loc"
#include "supplio.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_FS.C 1.5 2001/02/27 01:27:48 ska Exp ska $";
#endif

int cfgi_findSec(FILE * const fp, const char * const name)
{	int rv;

	DBG_ENTER("cfgi_findSec", Suppl_inifile2)
	DBG_ARGUMENTS( ("name=\"%s\"", name) )

	if(!fp)			DBG_RETURN_I( CFG_ERR_KEY)

	chkHeap
	I(data) =			/* pointer to section name for name == NULL */
	I(value) = 0;	/* indicate there is no cur value */

	chkHeap
	Frewind(fp);
	FFgetpos(fp, I(curpos));
	if(!name)		DBG_RETURN_I( CFG_ERR_NONE)		/* found */

	chkHeap
	while((rv = cfgi_nxtSec(fp)) == CFG_ERR_NONE	/* no error */
	 && !cfgEqName(I(data), name));					/* not requested key */
	chkHeap

	DBG_RETURN_I( rv)
}
