/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "trv" locale.
 */
public class LocalizedNamesImpl_trv extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AD",
        "AE",
        "AF",
        "AG",
        "AI",
        "AL",
        "US",
        "HM",
        "GB",
        "IO",
        "IN",
        "CN",
        "IT",
        "HR",
        "ME",
        "AQ",
        "GS",
        "JP",
        "BR",
        "FR",
        "TF",
        "BA",
        "BV",
        "RU",
        "SM",
        "RS",
        "CH",
        "DE",
        "AM",
        "AN",
        "AO",
        "AR",
        "AS",
        "AT",
        "AU",
        "AW",
        "AX",
        "AZ",
        "BB",
        "BD",
        "BE",
        "BF",
        "BG",
        "BH",
        "BI",
        "BJ",
        "BL",
        "BM",
        "BN",
        "BO",
        "BS",
        "BT",
        "BW",
        "BY",
        "BZ",
        "CA",
        "CC",
        "CD",
        "CF",
        "CG",
        "CI",
        "CK",
        "CL",
        "CM",
        "CO",
        "CP",
        "CR",
        "CU",
        "CV",
        "CX",
        "CY",
        "CZ",
        "DG",
        "DJ",
        "DK",
        "DM",
        "DO",
        "DZ",
        "EA",
        "EC",
        "EE",
        "EG",
        "EH",
        "ER",
        "ES",
        "ET",
        "EU",
        "FI",
        "FJ",
        "FK",
        "FM",
        "FO",
        "GA",
        "GD",
        "GE",
        "GF",
        "GG",
        "GH",
        "GI",
        "GL",
        "GM",
        "GN",
        "GP",
        "GQ",
        "GR",
        "GT",
        "GU",
        "GW",
        "GY",
        "HK",
        "HN",
        "HT",
        "HU",
        "IC",
        "ID",
        "IE",
        "IL",
        "IM",
        "IQ",
        "IR",
        "IS",
        "JE",
        "JM",
        "JO",
        "KE",
        "KG",
        "KH",
        "KI",
        "KM",
        "KN",
        "KP",
        "KR",
        "KW",
        "KY",
        "KZ",
        "LA",
        "LB",
        "LC",
        "LI",
        "LK",
        "LR",
        "LS",
        "LT",
        "LU",
        "LV",
        "LY",
        "MA",
        "MC",
        "MD",
        "MF",
        "MG",
        "MH",
        "MK",
        "ML",
        "MM",
        "MN",
        "MO",
        "MP",
        "MQ",
        "MR",
        "MS",
        "MT",
        "MU",
        "MV",
        "MW",
        "MX",
        "MY",
        "MZ",
        "NA",
        "NC",
        "NE",
        "NF",
        "NG",
        "NI",
        "NL",
        "NO",
        "NP",
        "NR",
        "NU",
        "NZ",
        "OM",
        "PA",
        "PE",
        "PF",
        "PG",
        "PH",
        "PK",
        "PL",
        "PM",
        "PN",
        "PR",
        "PS",
        "PT",
        "PW",
        "PY",
        "QA",
        "QO",
        "RE",
        "RO",
        "RW",
        "SA",
        "SB",
        "SC",
        "SD",
        "SE",
        "SG",
        "SH",
        "SI",
        "SJ",
        "SK",
        "SL",
        "SN",
        "SO",
        "SR",
        "ST",
        "SV",
        "SY",
        "SZ",
        "TA",
        "TC",
        "TD",
        "TG",
        "TH",
        "TJ",
        "TK",
        "TL",
        "TM",
        "TN",
        "TO",
        "TR",
        "TT",
        "TV",
        "TW",
        "TZ",
        "UA",
        "UG",
        "UM",
        "UY",
        "UZ",
        "VA",
        "VC",
        "VE",
        "VG",
        "VI",
        "VN",
        "VU",
        "WF",
        "WS",
        "YE",
        "YT",
        "ZA",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AQ", "alang Nanci");
    namesMap.put("BA", "alang Posniya");
    namesMap.put("BR", "alang Pajey");
    namesMap.put("BV", "alang Puwei");
    namesMap.put("CH", "alang Switjrrant");
    namesMap.put("CN", "alang Ipaw");
    namesMap.put("DE", "alang Towjih");
    namesMap.put("FR", "alang Posey");
    namesMap.put("GB", "alang Inglis");
    namesMap.put("GS", "alang Nanjiouya ni Nansanminji");
    namesMap.put("HM", "alang Htee ni Mayktan");
    namesMap.put("HR", "alang Krowtia");
    namesMap.put("IN", "alang Intu");
    namesMap.put("IO", "alang Inglis niq Intu");
    namesMap.put("IT", "alang Itariya");
    namesMap.put("JP", "alang Nihong");
    namesMap.put("ME", "alang Mondineygrw");
    namesMap.put("RS", "alang Srbia");
    namesMap.put("RU", "alang Ruski");
    namesMap.put("SM", "alang Snmarinow");
    namesMap.put("TF", "alang Posey niq Nan");
    namesMap.put("US", "alang Amarika");
    namesMap.put("ZZ", "ini klayi na alang ni");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AQ": "alang Nanci",
        "BA": "alang Posniya",
        "BR": "alang Pajey",
        "BV": "alang Puwei",
        "CH": "alang Switjrrant",
        "CN": "alang Ipaw",
        "DE": "alang Towjih",
        "FR": "alang Posey",
        "GB": "alang Inglis",
        "GS": "alang Nanjiouya ni Nansanminji",
        "HM": "alang Htee ni Mayktan",
        "HR": "alang Krowtia",
        "IN": "alang Intu",
        "IO": "alang Inglis niq Intu",
        "IT": "alang Itariya",
        "JP": "alang Nihong",
        "ME": "alang Mondineygrw",
        "RS": "alang Srbia",
        "RU": "alang Ruski",
        "SM": "alang Snmarinow",
        "TF": "alang Posey niq Nan",
        "US": "alang Amarika",
        "ZZ": "ini klayi na alang ni"
    };
  }-*/;
}
