/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "af" locale.
 */
public class LocalizedNamesImpl_af extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "ZA",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AX",
        "AL",
        "DZ",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AC",
        "AZ",
        "AU",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BF",
        "BO",
        "BA",
        "BW",
        "BR",
        "IO",
        "VG",
        "BN",
        "BG",
        "BI",
        "BV",
        "CC",
        "EA",
        "CL",
        "CY",
        "CP",
        "KM",
        "CK",
        "CR",
        "CX",
        "CD",
        "DK",
        "DG",
        "DJ",
        "DM",
        "DO",
        "DE",
        "EC",
        "EG",
        "GQ",
        "ER",
        "EE",
        "ET",
        "EU",
        "FK",
        "FO",
        "FJ",
        "PH",
        "FI",
        "FR",
        "GF",
        "PF",
        "GA",
        "GM",
        "GE",
        "GG",
        "GH",
        "GI",
        "GD",
        "GR",
        "GL",
        "GB",
        "GS",
        "GP",
        "GU",
        "GT",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "HN",
        "HU",
        "HK",
        "IE",
        "IM",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IL",
        "IT",
        "CI",
        "JM",
        "JP",
        "YE",
        "JE",
        "JO",
        "KY",
        "CV",
        "KH",
        "CM",
        "CA",
        "IC",
        "KZ",
        "QA",
        "KE",
        "KG",
        "KI",
        "KW",
        "CO",
        "CG",
        "HR",
        "CU",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MK",
        "MG",
        "MW",
        "MV",
        "MY",
        "ML",
        "MT",
        "MA",
        "MH",
        "MQ",
        "MU",
        "YT",
        "ME",
        "MX",
        "MF",
        "MM",
        "FM",
        "MD",
        "MC",
        "MN",
        "MS",
        "MZ",
        "MR",
        "NA",
        "NR",
        "NL",
        "AN",
        "NP",
        "NI",
        "NC",
        "NZ",
        "NE",
        "NG",
        "NU",
        "MP",
        "KP",
        "NO",
        "NF",
        "UA",
        "UZ",
        "OM",
        "AT",
        "TL",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "QO",
        "RE",
        "RO",
        "RS",
        "RU",
        "RW",
        "KN",
        "VC",
        "SV",
        "WS",
        "SM",
        "SA",
        "ST",
        "SN",
        "CF",
        "CS",
        "SC",
        "SL",
        "SG",
        "BL",
        "SH",
        "LC",
        "PM",
        "SY",
        "SJ",
        "CN",
        "SK",
        "SI",
        "SD",
        "SB",
        "SO",
        "ES",
        "LK",
        "ZA",
        "KR",
        "SR",
        "SZ",
        "SE",
        "CH",
        "TJ",
        "TW",
        "TZ",
        "TF",
        "TH",
        "CZ",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TD",
        "TN",
        "TM",
        "TC",
        "TR",
        "TV",
        "UG",
        "UM",
        "UY",
        "VI",
        "VU",
        "VA",
        "VE",
        "AE",
        "US",
        "VN",
        "WF",
        "EH",
        "BY",
        "IS",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Wêreld");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Noord-Amerika");
    namesMap.put("005", "Suid-Amerika");
    namesMap.put("009", "Oseanië");
    namesMap.put("011", "Wes-Afrika");
    namesMap.put("013", "Sentraal-Amerika");
    namesMap.put("014", "Oos-Afrika");
    namesMap.put("015", "Noord-Afrika");
    namesMap.put("017", "Midde-Afrika");
    namesMap.put("018", "Suider-Afrika");
    namesMap.put("019", "Amerikas");
    namesMap.put("021", "Noordelike Amerika");
    namesMap.put("029", "Karibies");
    namesMap.put("030", "Oos-Asië");
    namesMap.put("034", "Suid-Asië");
    namesMap.put("035", "Suidoos-Asië");
    namesMap.put("039", "Suid-Europa");
    namesMap.put("053", "Australië en Nieu-Seeland");
    namesMap.put("054", "Melanesië");
    namesMap.put("061", "Polinesië");
    namesMap.put("142", "Asië");
    namesMap.put("143", "Sentraal-Asië");
    namesMap.put("145", "Wes-Asië");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Oos-Europa");
    namesMap.put("154", "Noord-Europa");
    namesMap.put("155", "Wes-Europa");
    namesMap.put("172", "Gemenebes van Onafhanklike State");
    namesMap.put("AC", "Ascension");
    namesMap.put("AE", "Verenigde Arabiese Emirate");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigua en Barbuda");
    namesMap.put("AL", "Albanië");
    namesMap.put("AM", "Armenië");
    namesMap.put("AN", "Nederlands-Antille");
    namesMap.put("AQ", "Antarktika");
    namesMap.put("AR", "Argentinië");
    namesMap.put("AS", "Amerikaans Samoa");
    namesMap.put("AT", "Oostenryk");
    namesMap.put("AU", "Australië");
    namesMap.put("AX", "Åland");
    namesMap.put("AZ", "Aserbeidjan");
    namesMap.put("BA", "Bosnië en Herzegowina");
    namesMap.put("BD", "Bangladesj");
    namesMap.put("BE", "België");
    namesMap.put("BF", "Boerkina Fasso");
    namesMap.put("BG", "Bulgarye");
    namesMap.put("BH", "Bahrein");
    namesMap.put("BL", "Sint Barthélemy");
    namesMap.put("BN", "Broenei");
    namesMap.put("BO", "Bolivië");
    namesMap.put("BR", "Brasilië");
    namesMap.put("BT", "Bhoetan");
    namesMap.put("BY", "Wit-Rusland");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Demokratiese Republiek van die Kongo");
    namesMap.put("CF", "Sentraal-Afrikaanse Republiek");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Switserland");
    namesMap.put("CI", "Ivoorkus");
    namesMap.put("CK", "Cookeilande");
    namesMap.put("CL", "Chili");
    namesMap.put("CM", "Kameroen");
    namesMap.put("CN", "Sjina");
    namesMap.put("CO", "Kolombië");
    namesMap.put("CP", "Clipperton");
    namesMap.put("CS", "Serwië en Montenegro");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kaap Verde");
    namesMap.put("CY", "Ciprus");
    namesMap.put("CZ", "Tjeggiese Republiek");
    namesMap.put("DE", "Duitsland");
    namesMap.put("DJ", "Djiboeti");
    namesMap.put("DK", "Denemarke");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Dominikaanse Republiek");
    namesMap.put("DZ", "Algerië");
    namesMap.put("EA", "Ceuta en Melilla");
    namesMap.put("EE", "Estland");
    namesMap.put("EG", "Egipte");
    namesMap.put("EH", "Wes-Sahara");
    namesMap.put("ES", "Spanje");
    namesMap.put("ET", "Ethiopië");
    namesMap.put("EU", "Europese Unie");
    namesMap.put("FJ", "Fidji");
    namesMap.put("FK", "Falklandeilande");
    namesMap.put("FM", "Mikronesië");
    namesMap.put("FO", "Faroëreilande");
    namesMap.put("FR", "Frankryk");
    namesMap.put("GA", "Gaboen");
    namesMap.put("GB", "Groot-Brittanje");
    namesMap.put("GE", "Georgië");
    namesMap.put("GF", "Frans-Guyana");
    namesMap.put("GL", "Groenland");
    namesMap.put("GM", "Gambië");
    namesMap.put("GN", "Guinee");
    namesMap.put("GQ", "Ekwatoriaal-Guinee");
    namesMap.put("GR", "Griekeland");
    namesMap.put("GW", "Guinee-Bissau");
    namesMap.put("HK", "Hongkong");
    namesMap.put("HR", "Kroasië");
    namesMap.put("HT", "Haïti");
    namesMap.put("HU", "Hongarye");
    namesMap.put("IC", "Kanariese Eilande");
    namesMap.put("ID", "Indonesië");
    namesMap.put("IE", "Ierland");
    namesMap.put("IN", "Indië");
    namesMap.put("IO", "Britse Indiese Oseaan Gebied");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Ysland");
    namesMap.put("IT", "Italië");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Jordanië");
    namesMap.put("KE", "Kenia");
    namesMap.put("KG", "Kirgisië");
    namesMap.put("KH", "Kambodja");
    namesMap.put("KM", "Comore");
    namesMap.put("KN", "Saint Kitts en Nevis");
    namesMap.put("KP", "Noord-Korea");
    namesMap.put("KR", "Suid-Korea");
    namesMap.put("KW", "Koeweit");
    namesMap.put("KY", "Kaaimanseilande");
    namesMap.put("KZ", "Kasakstan");
    namesMap.put("LB", "Libanon");
    namesMap.put("LC", "Sint Lucia");
    namesMap.put("LR", "Liberië");
    namesMap.put("LT", "Litaue");
    namesMap.put("LU", "Luxemburg");
    namesMap.put("LV", "Letland");
    namesMap.put("LY", "Libië");
    namesMap.put("MA", "Marokko");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshall-eilande");
    namesMap.put("MK", "Macedonië");
    namesMap.put("MM", "Mianmar");
    namesMap.put("MN", "Mongolië");
    namesMap.put("MO", "Macao");
    namesMap.put("MP", "Noordelike Marianaeilande");
    namesMap.put("MR", "Mouritanië");
    namesMap.put("MV", "Maledive");
    namesMap.put("MX", "Meksiko");
    namesMap.put("MY", "Maleisië");
    namesMap.put("MZ", "Mosambiek");
    namesMap.put("NA", "Namibië");
    namesMap.put("NC", "Nieu-Kaledonië");
    namesMap.put("NF", "Norfolk-eiland");
    namesMap.put("NG", "Nigerië");
    namesMap.put("NL", "Nederland");
    namesMap.put("NO", "Noorweë");
    namesMap.put("NR", "Naoeroe");
    namesMap.put("NZ", "Nieu-Seeland");
    namesMap.put("PF", "Frans-Polinesië");
    namesMap.put("PG", "Papoea Nieu-Guinee");
    namesMap.put("PH", "Filippyne");
    namesMap.put("PL", "Pole");
    namesMap.put("PM", "Sint-Pierre en Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PS", "Palestina");
    namesMap.put("QA", "Katar");
    namesMap.put("RO", "Roemenië");
    namesMap.put("RU", "Rusland");
    namesMap.put("SA", "Saoedi-Arabië");
    namesMap.put("SB", "Solomon Eilande");
    namesMap.put("SC", "Seychelle");
    namesMap.put("SD", "Soedan");
    namesMap.put("SE", "Swede");
    namesMap.put("SG", "Singapoer");
    namesMap.put("SH", "Sint Helena");
    namesMap.put("SI", "Slowenië");
    namesMap.put("SK", "Slowakye");
    namesMap.put("SO", "Somalië");
    namesMap.put("ST", "Sao Tome en Principe");
    namesMap.put("SV", "Salvador");
    namesMap.put("SY", "Sirië");
    namesMap.put("TC", "Turks en Caicos Eilande");
    namesMap.put("TD", "Tsjaad");
    namesMap.put("TJ", "Tadjikistan");
    namesMap.put("TL", "Oos-Timor");
    namesMap.put("TM", "Turkmenië");
    namesMap.put("TN", "Tunisië");
    namesMap.put("TR", "Turkye");
    namesMap.put("TT", "Trinidad en Tobago");
    namesMap.put("TZ", "Tanzanië");
    namesMap.put("UA", "Oekraine");
    namesMap.put("US", "Verenigde State van Amerika");
    namesMap.put("UZ", "Oesbekistan");
    namesMap.put("VA", "Vatikaan");
    namesMap.put("VC", "Saint Vincent en die Grenadine");
    namesMap.put("VG", "Britse Maagde-eilande");
    namesMap.put("VI", "V.S. Maagde-eilande");
    namesMap.put("VN", "Viëtnam");
    namesMap.put("WF", "Wallis en Futuna");
    namesMap.put("YE", "Jemen");
    namesMap.put("ZA", "Suid-Afrika");
    namesMap.put("ZM", "Zambië");
    namesMap.put("ZZ", "onbekend gebied");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Wêreld",
        "002": "Afrika",
        "003": "Noord-Amerika",
        "005": "Suid-Amerika",
        "009": "Oseanië",
        "011": "Wes-Afrika",
        "013": "Sentraal-Amerika",
        "014": "Oos-Afrika",
        "015": "Noord-Afrika",
        "017": "Midde-Afrika",
        "018": "Suider-Afrika",
        "019": "Amerikas",
        "021": "Noordelike Amerika",
        "029": "Karibies",
        "030": "Oos-Asië",
        "034": "Suid-Asië",
        "035": "Suidoos-Asië",
        "039": "Suid-Europa",
        "053": "Australië en Nieu-Seeland",
        "054": "Melanesië",
        "061": "Polinesië",
        "142": "Asië",
        "143": "Sentraal-Asië",
        "145": "Wes-Asië",
        "150": "Europa",
        "151": "Oos-Europa",
        "154": "Noord-Europa",
        "155": "Wes-Europa",
        "172": "Gemenebes van Onafhanklike State",
        "AC": "Ascension",
        "AE": "Verenigde Arabiese Emirate",
        "AF": "Afganistan",
        "AG": "Antigua en Barbuda",
        "AL": "Albanië",
        "AM": "Armenië",
        "AN": "Nederlands-Antille",
        "AQ": "Antarktika",
        "AR": "Argentinië",
        "AS": "Amerikaans Samoa",
        "AT": "Oostenryk",
        "AU": "Australië",
        "AX": "Åland",
        "AZ": "Aserbeidjan",
        "BA": "Bosnië en Herzegowina",
        "BD": "Bangladesj",
        "BE": "België",
        "BF": "Boerkina Fasso",
        "BG": "Bulgarye",
        "BH": "Bahrein",
        "BL": "Sint Barthélemy",
        "BN": "Broenei",
        "BO": "Bolivië",
        "BR": "Brasilië",
        "BT": "Bhoetan",
        "BY": "Wit-Rusland",
        "CA": "Kanada",
        "CD": "Demokratiese Republiek van die Kongo",
        "CF": "Sentraal-Afrikaanse Republiek",
        "CG": "Kongo",
        "CH": "Switserland",
        "CI": "Ivoorkus",
        "CK": "Cookeilande",
        "CL": "Chili",
        "CM": "Kameroen",
        "CN": "Sjina",
        "CO": "Kolombië",
        "CP": "Clipperton",
        "CS": "Serwië en Montenegro",
        "CU": "Kuba",
        "CV": "Kaap Verde",
        "CY": "Ciprus",
        "CZ": "Tjeggiese Republiek",
        "DE": "Duitsland",
        "DJ": "Djiboeti",
        "DK": "Denemarke",
        "DM": "Dominika",
        "DO": "Dominikaanse Republiek",
        "DZ": "Algerië",
        "EA": "Ceuta en Melilla",
        "EE": "Estland",
        "EG": "Egipte",
        "EH": "Wes-Sahara",
        "ES": "Spanje",
        "ET": "Ethiopië",
        "EU": "Europese Unie",
        "FJ": "Fidji",
        "FK": "Falklandeilande",
        "FM": "Mikronesië",
        "FO": "Faroëreilande",
        "FR": "Frankryk",
        "GA": "Gaboen",
        "GB": "Groot-Brittanje",
        "GE": "Georgië",
        "GF": "Frans-Guyana",
        "GL": "Groenland",
        "GM": "Gambië",
        "GN": "Guinee",
        "GQ": "Ekwatoriaal-Guinee",
        "GR": "Griekeland",
        "GW": "Guinee-Bissau",
        "HK": "Hongkong",
        "HR": "Kroasië",
        "HT": "Haïti",
        "HU": "Hongarye",
        "IC": "Kanariese Eilande",
        "ID": "Indonesië",
        "IE": "Ierland",
        "IN": "Indië",
        "IO": "Britse Indiese Oseaan Gebied",
        "IQ": "Irak",
        "IS": "Ysland",
        "IT": "Italië",
        "JM": "Jamaika",
        "JO": "Jordanië",
        "KE": "Kenia",
        "KG": "Kirgisië",
        "KH": "Kambodja",
        "KM": "Comore",
        "KN": "Saint Kitts en Nevis",
        "KP": "Noord-Korea",
        "KR": "Suid-Korea",
        "KW": "Koeweit",
        "KY": "Kaaimanseilande",
        "KZ": "Kasakstan",
        "LB": "Libanon",
        "LC": "Sint Lucia",
        "LR": "Liberië",
        "LT": "Litaue",
        "LU": "Luxemburg",
        "LV": "Letland",
        "LY": "Libië",
        "MA": "Marokko",
        "MG": "Madagaskar",
        "MH": "Marshall-eilande",
        "MK": "Macedonië",
        "MM": "Mianmar",
        "MN": "Mongolië",
        "MO": "Macao",
        "MP": "Noordelike Marianaeilande",
        "MR": "Mouritanië",
        "MV": "Maledive",
        "MX": "Meksiko",
        "MY": "Maleisië",
        "MZ": "Mosambiek",
        "NA": "Namibië",
        "NC": "Nieu-Kaledonië",
        "NF": "Norfolk-eiland",
        "NG": "Nigerië",
        "NL": "Nederland",
        "NO": "Noorweë",
        "NR": "Naoeroe",
        "NZ": "Nieu-Seeland",
        "PF": "Frans-Polinesië",
        "PG": "Papoea Nieu-Guinee",
        "PH": "Filippyne",
        "PL": "Pole",
        "PM": "Sint-Pierre en Miquelon",
        "PN": "Pitcairn",
        "PS": "Palestina",
        "QA": "Katar",
        "RO": "Roemenië",
        "RU": "Rusland",
        "SA": "Saoedi-Arabië",
        "SB": "Solomon Eilande",
        "SC": "Seychelle",
        "SD": "Soedan",
        "SE": "Swede",
        "SG": "Singapoer",
        "SH": "Sint Helena",
        "SI": "Slowenië",
        "SK": "Slowakye",
        "SO": "Somalië",
        "ST": "Sao Tome en Principe",
        "SV": "Salvador",
        "SY": "Sirië",
        "TC": "Turks en Caicos Eilande",
        "TD": "Tsjaad",
        "TJ": "Tadjikistan",
        "TL": "Oos-Timor",
        "TM": "Turkmenië",
        "TN": "Tunisië",
        "TR": "Turkye",
        "TT": "Trinidad en Tobago",
        "TZ": "Tanzanië",
        "UA": "Oekraine",
        "US": "Verenigde State van Amerika",
        "UZ": "Oesbekistan",
        "VA": "Vatikaan",
        "VC": "Saint Vincent en die Grenadine",
        "VG": "Britse Maagde-eilande",
        "VI": "V.S. Maagde-eilande",
        "VN": "Viëtnam",
        "WF": "Wallis en Futuna",
        "YE": "Jemen",
        "ZA": "Suid-Afrika",
        "ZM": "Zambië",
        "ZZ": "onbekend gebied"
    };
  }-*/;
}
