/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ksb" locale.
 */
public class LocalizedNamesImpl_ksb extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "BE",
        "AC",
        "ZA",
        "AF",
        "IS",
        "AR",
        "AL",
        "DZ",
        "AM",
        "AW",
        "AD",
        "AO",
        "AI",
        "AG",
        "AN",
        "AQ",
        "AU",
        "AT",
        "AX",
        "IE",
        "AZ",
        "BB",
        "BH",
        "BS",
        "BD",
        "BY",
        "BZ",
        "BM",
        "BJ",
        "BL",
        "BR",
        "BN",
        "BO",
        "BA",
        "BW",
        "BF",
        "MG",
        "BG",
        "BI",
        "BT",
        "BV",
        "CC",
        "TD",
        "CL",
        "CN",
        "CP",
        "CX",
        "DK",
        "DG",
        "DM",
        "EA",
        "EH",
        "EC",
        "ER",
        "SV",
        "IO",
        "EE",
        "EU",
        "AE",
        "FJ",
        "PH",
        "FO",
        "GA",
        "GM",
        "GG",
        "GH",
        "GN",
        "GW",
        "GQ",
        "GD",
        "GL",
        "GS",
        "GY",
        "GP",
        "GU",
        "GT",
        "GF",
        "HT",
        "ES",
        "HK",
        "HM",
        "HN",
        "HU",
        "IC",
        "IQ",
        "IM",
        "IN",
        "ID",
        "IL",
        "IT",
        "JM",
        "CF",
        "CZ",
        "DO",
        "CD",
        "JP",
        "JE",
        "GI",
        "DJ",
        "GE",
        "KH",
        "CM",
        "CA",
        "QA",
        "KZ",
        "KE",
        "CV",
        "KI",
        "KG",
        "NF",
        "CI",
        "HR",
        "KP",
        "KR",
        "CO",
        "KM",
        "CG",
        "CR",
        "CU",
        "CY",
        "KW",
        "LA",
        "LU",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "RE",
        "RO",
        "RW",
        "MW",
        "US",
        "MY",
        "ML",
        "MT",
        "MQ",
        "MK",
        "MR",
        "YT",
        "ME",
        "MX",
        "MF",
        "FM",
        "EG",
        "MO",
        "MV",
        "MD",
        "MU",
        "MA",
        "MC",
        "MN",
        "MS",
        "MZ",
        "MM",
        "NE",
        "NG",
        "NA",
        "NR",
        "NP",
        "NI",
        "NU",
        "NO",
        "NC",
        "NZ",
        "OM",
        "PK",
        "PY",
        "PW",
        "PA",
        "PG",
        "PE",
        "PN",
        "PL",
        "PF",
        "PR",
        "QO",
        "RS",
        "SM",
        "WS",
        "AS",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "ST",
        "SA",
        "CS",
        "SN",
        "SC",
        "SL",
        "SY",
        "LK",
        "SG",
        "SJ",
        "SK",
        "SI",
        "SO",
        "SD",
        "SR",
        "TA",
        "TH",
        "TW",
        "TJ",
        "TZ",
        "TF",
        "TL",
        "TT",
        "TG",
        "TK",
        "TO",
        "TM",
        "TN",
        "TV",
        "IR",
        "FR",
        "FI",
        "UG",
        "GR",
        "ET",
        "NL",
        "GB",
        "DE",
        "PS",
        "UA",
        "PT",
        "UY",
        "RU",
        "UM",
        "SZ",
        "SE",
        "CH",
        "TR",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "CK",
        "FK",
        "KY",
        "MP",
        "MH",
        "SB",
        "TC",
        "VI",
        "VG",
        "WF",
        "YE",
        "JO",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Andola");
    namesMap.put("AE", "Falme za Kialabu");
    namesMap.put("AF", "Afuganistani");
    namesMap.put("AG", "Antigua na Balbuda");
    namesMap.put("AM", "Almenia");
    namesMap.put("AN", "Antili za Uholanzi");
    namesMap.put("AR", "Ajentina");
    namesMap.put("AS", "Samoa ya Malekani");
    namesMap.put("AT", "Austlia");
    namesMap.put("AU", "Austlalia");
    namesMap.put("AW", "Aluba");
    namesMap.put("AZ", "Azabajani");
    namesMap.put("BA", "Bosnia na Hezegovina");
    namesMap.put("BB", "Babadosi");
    namesMap.put("BD", "Bangladeshi");
    namesMap.put("BE", "");
    namesMap.put("BF", "Bukinafaso");
    namesMap.put("BG", "Bulgalia");
    namesMap.put("BH", "Bahaleni");
    namesMap.put("BI", "Bulundi");
    namesMap.put("BJ", "Benini");
    namesMap.put("BM", "Belmuda");
    namesMap.put("BN", "Blunei");
    namesMap.put("BR", "Blazili");
    namesMap.put("BS", "Bahama");
    namesMap.put("BT", "Butani");
    namesMap.put("BY", "Belalusi");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Jamhuli ya Kidemoklasia ya Kongo");
    namesMap.put("CF", "Jamhuli ya Afrika ya Gati");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Uswisi");
    namesMap.put("CI", "Kodivaa");
    namesMap.put("CK", "Visiwa vya Cook");
    namesMap.put("CM", "Kameluni");
    namesMap.put("CO", "Kolombia");
    namesMap.put("CR", "Kostalika");
    namesMap.put("CS", "Selbia na Monteneglo");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kepuvede");
    namesMap.put("CY", "Kuplosi");
    namesMap.put("CZ", "Jamhuli ya Cheki");
    namesMap.put("DE", "Ujeumani");
    namesMap.put("DJ", "Jibuti");
    namesMap.put("DK", "Denmaki");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Jamhuli ya Dominika");
    namesMap.put("DZ", "Aljelia");
    namesMap.put("EC", "Ekwado");
    namesMap.put("EG", "Misli");
    namesMap.put("ER", "Elitlea");
    namesMap.put("ES", "Hispania");
    namesMap.put("ET", "Uhabeshi");
    namesMap.put("FI", "Ufini");
    namesMap.put("FK", "Visiwa vya Falkland");
    namesMap.put("FM", "Miklonesia");
    namesMap.put("FR", "Ufalansa");
    namesMap.put("GA", "Gaboni");
    namesMap.put("GB", "Uingeeza");
    namesMap.put("GD", "Glenada");
    namesMap.put("GE", "Jojia");
    namesMap.put("GF", "Gwiyana ya Ufalansa");
    namesMap.put("GI", "Jiblalta");
    namesMap.put("GL", "Glinlandi");
    namesMap.put("GN", "Gine");
    namesMap.put("GP", "Gwadelupe");
    namesMap.put("GQ", "Ginekweta");
    namesMap.put("GR", "Ugiiki");
    namesMap.put("GT", "Gwatemala");
    namesMap.put("GU", "Gwam");
    namesMap.put("GW", "Ginebisau");
    namesMap.put("HN", "Honduasi");
    namesMap.put("HR", "Kolasia");
    namesMap.put("HU", "Hungalia");
    namesMap.put("IE", "Ayalandi");
    namesMap.put("IL", "Islaeli");
    namesMap.put("IO", "Eneo ja Uingeeza mwe Bahali Hindi");
    namesMap.put("IQ", "Ilaki");
    namesMap.put("IR", "Uajemi");
    namesMap.put("IS", "Aislandi");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Yoldani");
    namesMap.put("JP", "Japani");
    namesMap.put("KG", "Kiigizistani");
    namesMap.put("KH", "Kambodia");
    namesMap.put("KI", "Kiibati");
    namesMap.put("KM", "Komolo");
    namesMap.put("KN", "Santakitzi na Nevis");
    namesMap.put("KP", "Kolea Kaskazini");
    namesMap.put("KR", "Kolea Kusini");
    namesMap.put("KW", "Kuwaiti");
    namesMap.put("KY", "Visiwa vya Kayman");
    namesMap.put("KZ", "Kazakistani");
    namesMap.put("LA", "Laosi");
    namesMap.put("LB", "Lebanoni");
    namesMap.put("LC", "Santalusia");
    namesMap.put("LI", "Lishenteni");
    namesMap.put("LK", "Sililanka");
    namesMap.put("LR", "Libelia");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Litwania");
    namesMap.put("LU", "Lasembagi");
    namesMap.put("LV", "Lativia");
    namesMap.put("MA", "Moloko");
    namesMap.put("MC", "Monako");
    namesMap.put("MG", "Bukini");
    namesMap.put("MH", "Visiwa vya Mashal");
    namesMap.put("MK", "Masedonia");
    namesMap.put("MM", "Myama");
    namesMap.put("MP", "Visiwa vya Maliana vya Kaskazini");
    namesMap.put("MQ", "Maltiniki");
    namesMap.put("MR", "Maulitania");
    namesMap.put("MS", "Montselati");
    namesMap.put("MU", "Molisi");
    namesMap.put("MV", "Modivu");
    namesMap.put("MX", "Meksiko");
    namesMap.put("MY", "Malesia");
    namesMap.put("MZ", "Msumbiji");
    namesMap.put("NC", "Nyukaledonia");
    namesMap.put("NE", "Naija");
    namesMap.put("NF", "Kisiwa cha Nolfok");
    namesMap.put("NG", "Naijelia");
    namesMap.put("NI", "Nikalagwa");
    namesMap.put("NL", "Uholanzi");
    namesMap.put("NO", "Nolwei");
    namesMap.put("NP", "Nepali");
    namesMap.put("NR", "Naulu");
    namesMap.put("NZ", "Nyuzilandi");
    namesMap.put("OM", "Omani");
    namesMap.put("PE", "Pelu");
    namesMap.put("PF", "Polinesia ya Ufalansa");
    namesMap.put("PG", "Papua");
    namesMap.put("PH", "Filipino");
    namesMap.put("PK", "Pakistani");
    namesMap.put("PL", "Polandi");
    namesMap.put("PM", "Santapieli na Mikeloni");
    namesMap.put("PN", "Pitkailni");
    namesMap.put("PR", "Pwetoliko");
    namesMap.put("PS", "Ukingo wa Maghalibi na Ukanda wa Gaza wa Palestina");
    namesMap.put("PT", "Uleno");
    namesMap.put("PY", "Palagwai");
    namesMap.put("QA", "Katali");
    namesMap.put("RE", "Liyunioni");
    namesMap.put("RO", "Lomania");
    namesMap.put("RU", "Ulusi");
    namesMap.put("RW", "Lwanda");
    namesMap.put("SA", "Saudi");
    namesMap.put("SB", "Visiwa vya Solomon");
    namesMap.put("SC", "Shelisheli");
    namesMap.put("SD", "Sudani");
    namesMap.put("SE", "Uswidi");
    namesMap.put("SG", "Singapoo");
    namesMap.put("SH", "Santahelena");
    namesMap.put("SL", "Siela Leoni");
    namesMap.put("SM", "Samalino");
    namesMap.put("SN", "Senegali");
    namesMap.put("SR", "Sulinamu");
    namesMap.put("ST", "Sao Tome na Plincipe");
    namesMap.put("SV", "Elsavado");
    namesMap.put("SY", "Silia");
    namesMap.put("SZ", "Uswazi");
    namesMap.put("TC", "Visiwa vya Tulki na Kaiko");
    namesMap.put("TD", "Chadi");
    namesMap.put("TH", "Tailandi");
    namesMap.put("TJ", "Tajikistani");
    namesMap.put("TL", "Timoli ya Mashaliki");
    namesMap.put("TM", "Tulukimenistani");
    namesMap.put("TR", "Utuluki");
    namesMap.put("TT", "Tlinidad na Tobago");
    namesMap.put("TW", "Taiwani");
    namesMap.put("UA", "Uklaini");
    namesMap.put("US", "Malekani");
    namesMap.put("UY", "Ulugwai");
    namesMap.put("UZ", "Uzibekistani");
    namesMap.put("VA", "Vatikani");
    namesMap.put("VC", "Santavisenti na Glenadini");
    namesMap.put("VG", "Visiwa vya Vilgin vya Uingeeza");
    namesMap.put("VI", "Visiwa vya Vilgin vya Malekani");
    namesMap.put("VN", "Vietinamu");
    namesMap.put("WF", "Walis na Futuna");
    namesMap.put("YE", "Yemeni");
    namesMap.put("ZA", "Aflika Kusini");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Andola",
        "AE": "Falme za Kialabu",
        "AF": "Afuganistani",
        "AG": "Antigua na Balbuda",
        "AM": "Almenia",
        "AN": "Antili za Uholanzi",
        "AR": "Ajentina",
        "AS": "Samoa ya Malekani",
        "AT": "Austlia",
        "AU": "Austlalia",
        "AW": "Aluba",
        "AZ": "Azabajani",
        "BA": "Bosnia na Hezegovina",
        "BB": "Babadosi",
        "BD": "Bangladeshi",
        "BE": "",
        "BF": "Bukinafaso",
        "BG": "Bulgalia",
        "BH": "Bahaleni",
        "BI": "Bulundi",
        "BJ": "Benini",
        "BM": "Belmuda",
        "BN": "Blunei",
        "BR": "Blazili",
        "BS": "Bahama",
        "BT": "Butani",
        "BY": "Belalusi",
        "CA": "Kanada",
        "CD": "Jamhuli ya Kidemoklasia ya Kongo",
        "CF": "Jamhuli ya Afrika ya Gati",
        "CG": "Kongo",
        "CH": "Uswisi",
        "CI": "Kodivaa",
        "CK": "Visiwa vya Cook",
        "CM": "Kameluni",
        "CO": "Kolombia",
        "CR": "Kostalika",
        "CS": "Selbia na Monteneglo",
        "CU": "Kuba",
        "CV": "Kepuvede",
        "CY": "Kuplosi",
        "CZ": "Jamhuli ya Cheki",
        "DE": "Ujeumani",
        "DJ": "Jibuti",
        "DK": "Denmaki",
        "DM": "Dominika",
        "DO": "Jamhuli ya Dominika",
        "DZ": "Aljelia",
        "EC": "Ekwado",
        "EG": "Misli",
        "ER": "Elitlea",
        "ES": "Hispania",
        "ET": "Uhabeshi",
        "FI": "Ufini",
        "FK": "Visiwa vya Falkland",
        "FM": "Miklonesia",
        "FR": "Ufalansa",
        "GA": "Gaboni",
        "GB": "Uingeeza",
        "GD": "Glenada",
        "GE": "Jojia",
        "GF": "Gwiyana ya Ufalansa",
        "GI": "Jiblalta",
        "GL": "Glinlandi",
        "GN": "Gine",
        "GP": "Gwadelupe",
        "GQ": "Ginekweta",
        "GR": "Ugiiki",
        "GT": "Gwatemala",
        "GU": "Gwam",
        "GW": "Ginebisau",
        "HN": "Honduasi",
        "HR": "Kolasia",
        "HU": "Hungalia",
        "IE": "Ayalandi",
        "IL": "Islaeli",
        "IO": "Eneo ja Uingeeza mwe Bahali Hindi",
        "IQ": "Ilaki",
        "IR": "Uajemi",
        "IS": "Aislandi",
        "IT": "Italia",
        "JM": "Jamaika",
        "JO": "Yoldani",
        "JP": "Japani",
        "KG": "Kiigizistani",
        "KH": "Kambodia",
        "KI": "Kiibati",
        "KM": "Komolo",
        "KN": "Santakitzi na Nevis",
        "KP": "Kolea Kaskazini",
        "KR": "Kolea Kusini",
        "KW": "Kuwaiti",
        "KY": "Visiwa vya Kayman",
        "KZ": "Kazakistani",
        "LA": "Laosi",
        "LB": "Lebanoni",
        "LC": "Santalusia",
        "LI": "Lishenteni",
        "LK": "Sililanka",
        "LR": "Libelia",
        "LS": "Lesoto",
        "LT": "Litwania",
        "LU": "Lasembagi",
        "LV": "Lativia",
        "MA": "Moloko",
        "MC": "Monako",
        "MG": "Bukini",
        "MH": "Visiwa vya Mashal",
        "MK": "Masedonia",
        "MM": "Myama",
        "MP": "Visiwa vya Maliana vya Kaskazini",
        "MQ": "Maltiniki",
        "MR": "Maulitania",
        "MS": "Montselati",
        "MU": "Molisi",
        "MV": "Modivu",
        "MX": "Meksiko",
        "MY": "Malesia",
        "MZ": "Msumbiji",
        "NC": "Nyukaledonia",
        "NE": "Naija",
        "NF": "Kisiwa cha Nolfok",
        "NG": "Naijelia",
        "NI": "Nikalagwa",
        "NL": "Uholanzi",
        "NO": "Nolwei",
        "NP": "Nepali",
        "NR": "Naulu",
        "NZ": "Nyuzilandi",
        "OM": "Omani",
        "PE": "Pelu",
        "PF": "Polinesia ya Ufalansa",
        "PG": "Papua",
        "PH": "Filipino",
        "PK": "Pakistani",
        "PL": "Polandi",
        "PM": "Santapieli na Mikeloni",
        "PN": "Pitkailni",
        "PR": "Pwetoliko",
        "PS": "Ukingo wa Maghalibi na Ukanda wa Gaza wa Palestina",
        "PT": "Uleno",
        "PY": "Palagwai",
        "QA": "Katali",
        "RE": "Liyunioni",
        "RO": "Lomania",
        "RU": "Ulusi",
        "RW": "Lwanda",
        "SA": "Saudi",
        "SB": "Visiwa vya Solomon",
        "SC": "Shelisheli",
        "SD": "Sudani",
        "SE": "Uswidi",
        "SG": "Singapoo",
        "SH": "Santahelena",
        "SL": "Siela Leoni",
        "SM": "Samalino",
        "SN": "Senegali",
        "SR": "Sulinamu",
        "ST": "Sao Tome na Plincipe",
        "SV": "Elsavado",
        "SY": "Silia",
        "SZ": "Uswazi",
        "TC": "Visiwa vya Tulki na Kaiko",
        "TD": "Chadi",
        "TH": "Tailandi",
        "TJ": "Tajikistani",
        "TL": "Timoli ya Mashaliki",
        "TM": "Tulukimenistani",
        "TR": "Utuluki",
        "TT": "Tlinidad na Tobago",
        "TW": "Taiwani",
        "UA": "Uklaini",
        "US": "Malekani",
        "UY": "Ulugwai",
        "UZ": "Uzibekistani",
        "VA": "Vatikani",
        "VC": "Santavisenti na Glenadini",
        "VG": "Visiwa vya Vilgin vya Uingeeza",
        "VI": "Visiwa vya Vilgin vya Malekani",
        "VN": "Vietinamu",
        "WF": "Walis na Futuna",
        "YE": "Yemeni",
        "ZA": "Aflika Kusini"
    };
  }-*/;
}
