/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionCell<C>
extends AbstractCell<C> {
    private final SafeHtml html;
    private final Delegate<C> delegate;

    public ActionCell(SafeHtml message, Delegate<C> delegate) {
        super("click", "keydown");
        this.delegate = delegate;
        this.html = new SafeHtmlBuilder().appendHtmlConstant("<button type=\"button\" tabindex=\"-1\">").append(message).appendHtmlConstant("</button>").toSafeHtml();
    }

    public ActionCell(String text, Delegate<C> delegate) {
        this(SafeHtmlUtils.fromString(text), delegate);
    }

    @Override
    public void onBrowserEvent(Cell.Context context, Element parent, C value, NativeEvent event, ValueUpdater<C> valueUpdater) {
        super.onBrowserEvent(context, parent, value, event, valueUpdater);
        if ("click".equals(event.getType())) {
            EventTarget eventTarget = event.getEventTarget();
            if (!Element.is(eventTarget)) {
                return;
            }
            if (parent.getFirstChildElement().isOrHasChild(Element.as(eventTarget))) {
                this.onEnterKeyDown(context, parent, value, event, valueUpdater);
            }
        }
    }

    @Override
    public void render(Cell.Context context, C value, SafeHtmlBuilder sb) {
        sb.append(this.html);
    }

    @Override
    protected void onEnterKeyDown(Cell.Context context, Element parent, C value, NativeEvent event, ValueUpdater<C> valueUpdater) {
        this.delegate.execute(value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Delegate<T> {
        public void execute(T var1);
    }
}

