/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "tr" locale.
 */
public class LocalizedNamesImpl_tr extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "TR",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "VI",
        "AF",
        "AX",
        "DE",
        "US",
        "UM",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AL",
        "AW",
        "AC",
        "EU",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "EH",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BY",
        "AE",
        "GB",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "CV",
        "KY",
        "GI",
        "EA",
        "DZ",
        "CX",
        "DJ",
        "CP",
        "CC",
        "CK",
        "TD",
        "CZ",
        "CN",
        "DK",
        "DG",
        "DM",
        "DO",
        "EC",
        "GQ",
        "SV",
        "ID",
        "ER",
        "AM",
        "EE",
        "ET",
        "FK",
        "FO",
        "MA",
        "FJ",
        "CI",
        "PH",
        "PS",
        "FI",
        "FR",
        "FX",
        "GF",
        "TF",
        "PF",
        "GA",
        "GM",
        "GH",
        "GN",
        "GW",
        "GD",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GY",
        "ZA",
        "GS",
        "CY",
        "KR",
        "GE",
        "HT",
        "HM",
        "HR",
        "IN",
        "NL",
        "AN",
        "HN",
        "HK",
        "IQ",
        "IO",
        "VG",
        "IR",
        "IE",
        "ES",
        "IL",
        "SE",
        "CH",
        "IT",
        "IS",
        "JM",
        "JP",
        "JE",
        "KH",
        "CM",
        "CA",
        "IC",
        "ME",
        "QA",
        "KZ",
        "KE",
        "KG",
        "KI",
        "CO",
        "KM",
        "CG",
        "CD",
        "CR",
        "KW",
        "KP",
        "MP",
        "CU",
        "LA",
        "LS",
        "LV",
        "LR",
        "LY",
        "LI",
        "LT",
        "LB",
        "LU",
        "HU",
        "MG",
        "MO",
        "MK",
        "MW",
        "MV",
        "MY",
        "ML",
        "MT",
        "IM",
        "MH",
        "MQ",
        "MU",
        "YT",
        "MX",
        "EG",
        "FM",
        "MN",
        "MD",
        "MC",
        "MS",
        "MR",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NF",
        "NO",
        "CF",
        "UZ",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "RE",
        "RO",
        "RW",
        "RU",
        "BL",
        "SH",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "WS",
        "SM",
        "ST",
        "SN",
        "SC",
        "RS",
        "CS",
        "SL",
        "SG",
        "SK",
        "SI",
        "SB",
        "SO",
        "LK",
        "SD",
        "SR",
        "SY",
        "SA",
        "SJ",
        "SZ",
        "CL",
        "TJ",
        "TZ",
        "TH",
        "TW",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TC",
        "TV",
        "TR",
        "TM",
        "UG",
        "UA",
        "OM",
        "UY",
        "QO",
        "JO",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "YE",
        "NC",
        "NZ",
        "GR",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Dünya");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Kuzey Amerika");
    namesMap.put("005", "Güney Amerika");
    namesMap.put("009", "Okyanusya");
    namesMap.put("011", "Batı Afrika");
    namesMap.put("013", "Orta Amerika");
    namesMap.put("014", "Doğu Afrika");
    namesMap.put("015", "Kuzey Afrika");
    namesMap.put("017", "Orta Afrika");
    namesMap.put("018", "Afrika'nın Güneyi");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Amerika'nın Kuzeyi");
    namesMap.put("029", "Karayipler");
    namesMap.put("030", "Doğu Asya");
    namesMap.put("034", "Güney Asya");
    namesMap.put("035", "Güney Doğu Asya");
    namesMap.put("039", "Güney Avrupa");
    namesMap.put("053", "Avustralya ve Yeni Zelanda");
    namesMap.put("054", "Melanezya");
    namesMap.put("057", "Mikronezya");
    namesMap.put("061", "Polinezya");
    namesMap.put("062", "Güney Orta Asya");
    namesMap.put("142", "Asya");
    namesMap.put("143", "Orta Asya");
    namesMap.put("145", "Batı Asya");
    namesMap.put("150", "Avrupa");
    namesMap.put("151", "Doğu Avrupa");
    namesMap.put("154", "Kuzey Avrupa");
    namesMap.put("155", "Batı Avrupa");
    namesMap.put("172", "Bağımsız Devletler Topluluğu");
    namesMap.put("419", "Latin Amerika ve Karayipler");
    namesMap.put("830", "Kanal Adaları");
    namesMap.put("AC", "Ascension Adası");
    namesMap.put("AE", "Birleşik Arap Emirlikleri");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigua ve Barbuda");
    namesMap.put("AL", "Arnavutluk");
    namesMap.put("AM", "Ermenistan");
    namesMap.put("AN", "Hollanda Antilleri");
    namesMap.put("AQ", "Antarktika");
    namesMap.put("AR", "Arjantin");
    namesMap.put("AS", "Amerikan Samoası");
    namesMap.put("AT", "Avusturya");
    namesMap.put("AU", "Avustralya");
    namesMap.put("AX", "Aland Adaları");
    namesMap.put("AZ", "Azerbaycan");
    namesMap.put("BA", "Bosna Hersek");
    namesMap.put("BD", "Bangladeş");
    namesMap.put("BE", "Belçika");
    namesMap.put("BG", "Bulgaristan");
    namesMap.put("BH", "Bahreyn");
    namesMap.put("BL", "Saint Barthelemy");
    namesMap.put("BO", "Bolivya");
    namesMap.put("BR", "Brezilya");
    namesMap.put("BS", "Bahamalar");
    namesMap.put("BT", "Butan");
    namesMap.put("BV", "Bouvet Adası");
    namesMap.put("BW", "Botsvana");
    namesMap.put("BY", "Beyaz Rusya");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Cocos Adaları");
    namesMap.put("CD", "Kongo - Kinşasa");
    namesMap.put("CF", "Orta Afrika Cumhuriyeti");
    namesMap.put("CG", "Kongo - Brazavil");
    namesMap.put("CH", "İsviçre");
    namesMap.put("CI", "Fildişi Sahili");
    namesMap.put("CK", "Cook Adaları");
    namesMap.put("CL", "Şili");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Çin");
    namesMap.put("CO", "Kolombiya");
    namesMap.put("CP", "Clipperton Adası");
    namesMap.put("CR", "Kosta Rika");
    namesMap.put("CS", "Sırbistan-Karadağ");
    namesMap.put("CU", "Küba");
    namesMap.put("CX", "Christmas Adası");
    namesMap.put("CY", "Güney Kıbrıs Rum Kesimi");
    namesMap.put("CZ", "Çek Cumhuriyeti");
    namesMap.put("DE", "Almanya");
    namesMap.put("DJ", "Cibuti");
    namesMap.put("DK", "Danimarka");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Dominik Cumhuriyeti");
    namesMap.put("DZ", "Cezayir");
    namesMap.put("EA", "Ceuta ve Melilla");
    namesMap.put("EC", "Ekvador");
    namesMap.put("EE", "Estonya");
    namesMap.put("EG", "Mısır");
    namesMap.put("EH", "Batı Sahara");
    namesMap.put("ER", "Eritre");
    namesMap.put("ES", "İspanya");
    namesMap.put("ET", "Etiyopya");
    namesMap.put("EU", "Avrupa Birliği");
    namesMap.put("FI", "Finlandiya");
    namesMap.put("FK", "Falkland Adaları");
    namesMap.put("FM", "Mikronezya Federal Eyaletleri");
    namesMap.put("FO", "Faroe Adaları");
    namesMap.put("FR", "Fransa");
    namesMap.put("FX", "Fransa, Metropolitan");
    namesMap.put("GB", "Birleşik Krallık");
    namesMap.put("GE", "Gürcistan");
    namesMap.put("GF", "Fransız Guyanası");
    namesMap.put("GH", "Gana");
    namesMap.put("GI", "Cebelitarık");
    namesMap.put("GL", "Grönland");
    namesMap.put("GM", "Gambiya");
    namesMap.put("GN", "Gine");
    namesMap.put("GP", "Guadalupe");
    namesMap.put("GQ", "Ekvator Ginesi");
    namesMap.put("GR", "Yunanistan");
    namesMap.put("GS", "Güney Georgia ve Güney Sandwich Adaları");
    namesMap.put("GW", "Gine-Bissau");
    namesMap.put("HM", "Heard Adası ve McDonald Adaları");
    namesMap.put("HR", "Hırvatistan");
    namesMap.put("HU", "Macaristan");
    namesMap.put("IC", "Kanarya Adaları");
    namesMap.put("ID", "Endonezya");
    namesMap.put("IE", "İrlanda");
    namesMap.put("IL", "İsrail");
    namesMap.put("IM", "Man Adası");
    namesMap.put("IN", "Hindistan");
    namesMap.put("IO", "İngiliz Hint Okyanusu Bölgesi");
    namesMap.put("IQ", "Irak");
    namesMap.put("IR", "İran");
    namesMap.put("IS", "İzlanda");
    namesMap.put("IT", "İtalya");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Ürdün");
    namesMap.put("JP", "Japonya");
    namesMap.put("KG", "Kırgızistan");
    namesMap.put("KH", "Kamboçya");
    namesMap.put("KM", "Komorlar");
    namesMap.put("KN", "Saint Kitts ve Nevis");
    namesMap.put("KP", "Kuzey Kore");
    namesMap.put("KR", "Güney Kore");
    namesMap.put("KW", "Kuveyt");
    namesMap.put("KY", "Cayman Adaları");
    namesMap.put("KZ", "Kazakistan");
    namesMap.put("LB", "Lübnan");
    namesMap.put("LR", "Liberya");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Litvanya");
    namesMap.put("LU", "Lüksemburg");
    namesMap.put("LV", "Letonya");
    namesMap.put("MA", "Fas");
    namesMap.put("MC", "Monako");
    namesMap.put("ME", "Karadağ");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshall Adaları");
    namesMap.put("MK", "Makedonya");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MN", "Moğolistan");
    namesMap.put("MO", "Makao");
    namesMap.put("MP", "Kuzey Mariana Adaları");
    namesMap.put("MQ", "Martinik");
    namesMap.put("MR", "Moritanya");
    namesMap.put("MV", "Maldivler");
    namesMap.put("MW", "Malavi");
    namesMap.put("MX", "Meksika");
    namesMap.put("MY", "Malezya");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NA", "Namibya");
    namesMap.put("NC", "Yeni Kaledonya");
    namesMap.put("NE", "Nijer");
    namesMap.put("NF", "Norfolk Adası");
    namesMap.put("NG", "Nijerya");
    namesMap.put("NI", "Nikaragua");
    namesMap.put("NL", "Hollanda");
    namesMap.put("NO", "Norveç");
    namesMap.put("NZ", "Yeni Zelanda");
    namesMap.put("OM", "Umman");
    namesMap.put("PF", "Fransız Polinezyası");
    namesMap.put("PG", "Papua Yeni Gine");
    namesMap.put("PH", "Filipinler");
    namesMap.put("PL", "Polonya");
    namesMap.put("PM", "Saint Pierre ve Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PR", "Porto Riko");
    namesMap.put("PS", "Filistin Bölgesi");
    namesMap.put("PT", "Portekiz");
    namesMap.put("QA", "Katar");
    namesMap.put("QO", "Uzak Okyanusya");
    namesMap.put("RE", "Reunion");
    namesMap.put("RO", "Romanya");
    namesMap.put("RS", "Sırbistan");
    namesMap.put("RU", "Rusya Federasyonu");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Suudi Arabistan");
    namesMap.put("SB", "Solomon Adaları");
    namesMap.put("SC", "Seyşeller");
    namesMap.put("SE", "İsveç");
    namesMap.put("SG", "Singapur");
    namesMap.put("SI", "Slovenya");
    namesMap.put("SJ", "Svalbard ve Jan Mayen Adaları");
    namesMap.put("SK", "Slovakya");
    namesMap.put("SO", "Somali");
    namesMap.put("SR", "Surinam");
    namesMap.put("ST", "Sao Tome ve Principe");
    namesMap.put("SY", "Suriye");
    namesMap.put("SZ", "Svaziland");
    namesMap.put("TC", "Turks ve Caicos Adaları");
    namesMap.put("TD", "Çad");
    namesMap.put("TF", "Fransız Güney Bölgeleri");
    namesMap.put("TH", "Tayland");
    namesMap.put("TJ", "Tacikistan");
    namesMap.put("TM", "Türkmenistan");
    namesMap.put("TN", "Tunus");
    namesMap.put("TR", "Türkiye");
    namesMap.put("TT", "Trinidad ve Tobago");
    namesMap.put("TW", "Tayvan");
    namesMap.put("TZ", "Tanzanya");
    namesMap.put("UA", "Ukrayna");
    namesMap.put("UM", "Amerika Birleşik Devletleri Küçük Dış Adaları");
    namesMap.put("US", "Amerika Birleşik Devletleri");
    namesMap.put("UZ", "Özbekistan");
    namesMap.put("VA", "Vatikan");
    namesMap.put("VC", "Saint Vincent ve Grenadinler");
    namesMap.put("VG", "İngiliz Virgin Adaları");
    namesMap.put("VI", "ABD Virgin Adaları");
    namesMap.put("WF", "Wallis ve Futuna Adaları");
    namesMap.put("ZA", "Güney Afrika");
    namesMap.put("ZM", "Zambiya");
    namesMap.put("ZW", "Zimbabve");
    namesMap.put("ZZ", "Bilinmeyen veya Geçersiz Bölge");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Dünya",
        "002": "Afrika",
        "003": "Kuzey Amerika",
        "005": "Güney Amerika",
        "009": "Okyanusya",
        "011": "Batı Afrika",
        "013": "Orta Amerika",
        "014": "Doğu Afrika",
        "015": "Kuzey Afrika",
        "017": "Orta Afrika",
        "018": "Afrika'nın Güneyi",
        "019": "Amerika",
        "021": "Amerika'nın Kuzeyi",
        "029": "Karayipler",
        "030": "Doğu Asya",
        "034": "Güney Asya",
        "035": "Güney Doğu Asya",
        "039": "Güney Avrupa",
        "053": "Avustralya ve Yeni Zelanda",
        "054": "Melanezya",
        "057": "Mikronezya",
        "061": "Polinezya",
        "062": "Güney Orta Asya",
        "142": "Asya",
        "143": "Orta Asya",
        "145": "Batı Asya",
        "150": "Avrupa",
        "151": "Doğu Avrupa",
        "154": "Kuzey Avrupa",
        "155": "Batı Avrupa",
        "172": "Bağımsız Devletler Topluluğu",
        "419": "Latin Amerika ve Karayipler",
        "830": "Kanal Adaları",
        "AC": "Ascension Adası",
        "AE": "Birleşik Arap Emirlikleri",
        "AF": "Afganistan",
        "AG": "Antigua ve Barbuda",
        "AL": "Arnavutluk",
        "AM": "Ermenistan",
        "AN": "Hollanda Antilleri",
        "AQ": "Antarktika",
        "AR": "Arjantin",
        "AS": "Amerikan Samoası",
        "AT": "Avusturya",
        "AU": "Avustralya",
        "AX": "Aland Adaları",
        "AZ": "Azerbaycan",
        "BA": "Bosna Hersek",
        "BD": "Bangladeş",
        "BE": "Belçika",
        "BG": "Bulgaristan",
        "BH": "Bahreyn",
        "BL": "Saint Barthelemy",
        "BO": "Bolivya",
        "BR": "Brezilya",
        "BS": "Bahamalar",
        "BT": "Butan",
        "BV": "Bouvet Adası",
        "BW": "Botsvana",
        "BY": "Beyaz Rusya",
        "CA": "Kanada",
        "CC": "Cocos Adaları",
        "CD": "Kongo - Kinşasa",
        "CF": "Orta Afrika Cumhuriyeti",
        "CG": "Kongo - Brazavil",
        "CH": "İsviçre",
        "CI": "Fildişi Sahili",
        "CK": "Cook Adaları",
        "CL": "Şili",
        "CM": "Kamerun",
        "CN": "Çin",
        "CO": "Kolombiya",
        "CP": "Clipperton Adası",
        "CR": "Kosta Rika",
        "CS": "Sırbistan-Karadağ",
        "CU": "Küba",
        "CX": "Christmas Adası",
        "CY": "Güney Kıbrıs Rum Kesimi",
        "CZ": "Çek Cumhuriyeti",
        "DE": "Almanya",
        "DJ": "Cibuti",
        "DK": "Danimarka",
        "DM": "Dominika",
        "DO": "Dominik Cumhuriyeti",
        "DZ": "Cezayir",
        "EA": "Ceuta ve Melilla",
        "EC": "Ekvador",
        "EE": "Estonya",
        "EG": "Mısır",
        "EH": "Batı Sahara",
        "ER": "Eritre",
        "ES": "İspanya",
        "ET": "Etiyopya",
        "EU": "Avrupa Birliği",
        "FI": "Finlandiya",
        "FK": "Falkland Adaları",
        "FM": "Mikronezya Federal Eyaletleri",
        "FO": "Faroe Adaları",
        "FR": "Fransa",
        "FX": "Fransa, Metropolitan",
        "GB": "Birleşik Krallık",
        "GE": "Gürcistan",
        "GF": "Fransız Guyanası",
        "GH": "Gana",
        "GI": "Cebelitarık",
        "GL": "Grönland",
        "GM": "Gambiya",
        "GN": "Gine",
        "GP": "Guadalupe",
        "GQ": "Ekvator Ginesi",
        "GR": "Yunanistan",
        "GS": "Güney Georgia ve Güney Sandwich Adaları",
        "GW": "Gine-Bissau",
        "HM": "Heard Adası ve McDonald Adaları",
        "HR": "Hırvatistan",
        "HU": "Macaristan",
        "IC": "Kanarya Adaları",
        "ID": "Endonezya",
        "IE": "İrlanda",
        "IL": "İsrail",
        "IM": "Man Adası",
        "IN": "Hindistan",
        "IO": "İngiliz Hint Okyanusu Bölgesi",
        "IQ": "Irak",
        "IR": "İran",
        "IS": "İzlanda",
        "IT": "İtalya",
        "JM": "Jamaika",
        "JO": "Ürdün",
        "JP": "Japonya",
        "KG": "Kırgızistan",
        "KH": "Kamboçya",
        "KM": "Komorlar",
        "KN": "Saint Kitts ve Nevis",
        "KP": "Kuzey Kore",
        "KR": "Güney Kore",
        "KW": "Kuveyt",
        "KY": "Cayman Adaları",
        "KZ": "Kazakistan",
        "LB": "Lübnan",
        "LR": "Liberya",
        "LS": "Lesoto",
        "LT": "Litvanya",
        "LU": "Lüksemburg",
        "LV": "Letonya",
        "MA": "Fas",
        "MC": "Monako",
        "ME": "Karadağ",
        "MG": "Madagaskar",
        "MH": "Marshall Adaları",
        "MK": "Makedonya",
        "MM": "Myanmar",
        "MN": "Moğolistan",
        "MO": "Makao",
        "MP": "Kuzey Mariana Adaları",
        "MQ": "Martinik",
        "MR": "Moritanya",
        "MV": "Maldivler",
        "MW": "Malavi",
        "MX": "Meksika",
        "MY": "Malezya",
        "MZ": "Mozambik",
        "NA": "Namibya",
        "NC": "Yeni Kaledonya",
        "NE": "Nijer",
        "NF": "Norfolk Adası",
        "NG": "Nijerya",
        "NI": "Nikaragua",
        "NL": "Hollanda",
        "NO": "Norveç",
        "NZ": "Yeni Zelanda",
        "OM": "Umman",
        "PF": "Fransız Polinezyası",
        "PG": "Papua Yeni Gine",
        "PH": "Filipinler",
        "PL": "Polonya",
        "PM": "Saint Pierre ve Miquelon",
        "PN": "Pitcairn",
        "PR": "Porto Riko",
        "PS": "Filistin Bölgesi",
        "PT": "Portekiz",
        "QA": "Katar",
        "QO": "Uzak Okyanusya",
        "RE": "Reunion",
        "RO": "Romanya",
        "RS": "Sırbistan",
        "RU": "Rusya Federasyonu",
        "RW": "Ruanda",
        "SA": "Suudi Arabistan",
        "SB": "Solomon Adaları",
        "SC": "Seyşeller",
        "SE": "İsveç",
        "SG": "Singapur",
        "SI": "Slovenya",
        "SJ": "Svalbard ve Jan Mayen Adaları",
        "SK": "Slovakya",
        "SO": "Somali",
        "SR": "Surinam",
        "ST": "Sao Tome ve Principe",
        "SY": "Suriye",
        "SZ": "Svaziland",
        "TC": "Turks ve Caicos Adaları",
        "TD": "Çad",
        "TF": "Fransız Güney Bölgeleri",
        "TH": "Tayland",
        "TJ": "Tacikistan",
        "TM": "Türkmenistan",
        "TN": "Tunus",
        "TR": "Türkiye",
        "TT": "Trinidad ve Tobago",
        "TW": "Tayvan",
        "TZ": "Tanzanya",
        "UA": "Ukrayna",
        "UM": "Amerika Birleşik Devletleri Küçük Dış Adaları",
        "US": "Amerika Birleşik Devletleri",
        "UZ": "Özbekistan",
        "VA": "Vatikan",
        "VC": "Saint Vincent ve Grenadinler",
        "VG": "İngiliz Virgin Adaları",
        "VI": "ABD Virgin Adaları",
        "WF": "Wallis ve Futuna Adaları",
        "ZA": "Güney Afrika",
        "ZM": "Zambiya",
        "ZW": "Zimbabve",
        "ZZ": "Bilinmeyen veya Geçersiz Bölge"
    };
  }-*/;
}
